/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file OptionsFile.cxx
    \author Romain BONDUE
    \date 03/08/2006 */
#ifndef NDEBUG
#include <iostream>
#endif // NDEBUG
#include <sstream>
#include <fstream>
#include <cstdlib> // getenv()
#include <cstring> // strcmp()

#include "OptionsFile.h"
#include "StaticSettings.h"
#include "ErrorsCode.h"
#include "UserData.h"



namespace
{
    const char* const DisplayTrayIconLabel ("DisplayTrayIcon");
    const char* const StartMinimizedLabel ("StartMinimized");
    const char* const LeaveRootDelayLabel ("LeaveRootDelay");
    const char* const RootMarkupLabel ("Options");
    const char* const Indentation ("    ");

} // anonymous namespace



void nsUserData::COptionsFile::Record () throw (nsErrors::CException)
{
#ifndef NDEBUG
    std::cerr << "Recording options in : " << AppDirectory << '/'
              << nsCore::OptionsFileName << std::endl;
#endif // NDEBUG
    std::ofstream Os ((AppDirectory + '/' + nsCore::OptionsFileName).c_str(),
                      std::ios_base::trunc);
    try
    {
        Os.exceptions (std::ios_base::badbit | std::ios_base::failbit);
        Os << XMLHeader << '\n' << Markup1B << RootMarkupLabel << Markup2E;
        RecordFields (Os);
        Os << Markup2B << RootMarkupLabel << Markup2E;
    }
    catch (const std::ios_base::failure& Exc)
    {
        throw nsErrors::CException (Exc.what(),
                                    nsErrors::OptionsRecordFailure);
    }

} // Record()


void nsUserData::COptionsFile::Extract () throw (nsErrors::CException)
{
    CXMLParser::Extract (AppDirectory + '/' + nsCore::OptionsFileName);

} // Extract()


void nsUserData::COptionsFile::Text (const char* QName,
                                     const std::string& Text)
                                                throw (nsErrors::CException)
{
    std::istringstream Is (Text);
    Is.exceptions (std::ios_base::badbit);
    try
    {
        if (!strcmp (QName, DisplayTrayIconLabel))
            Is >> m_DisplayTrayIcon;
        else if (!strcmp (QName, StartMinimizedLabel))
            Is >> m_StartMinimized;
        else if (!strcmp (QName, LeaveRootDelayLabel))
            Is >> m_LeaveRootDelay;
    }
    catch (const std::ios_base::failure& Exc)
    {
        throw nsErrors::CException (Exc.what(),
                                    nsErrors::OptionsExtractionInvalidValue);
    }

} // Text()


void nsUserData::COptionsFile::RecordFields (std::ostream& Os)
                                                throw (std::ios_base::failure)
{
    Os << Indentation << Markup1B << DisplayTrayIconLabel << Markup1E
       << m_DisplayTrayIcon << Markup2B << DisplayTrayIconLabel << Markup2E
       << Indentation << Markup1B << StartMinimizedLabel << Markup1E
       << m_StartMinimized << Markup2B << StartMinimizedLabel << Markup2E
       << Indentation << Markup1B << LeaveRootDelayLabel << Markup1E
       << m_LeaveRootDelay << Markup2B << LeaveRootDelayLabel << Markup2E;

} // RecordFields()
