/*
*  Rubrica
*  file: 
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "libral.h"

#include "types.h"


#ifndef RUBRICA_APP_H
#define RUBRICA_APP_H

#define RUBRICA_APP_TYPE           (rubrica_app_get_type())

#define RUBRICA_APP(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),     \
                                    RUBRICA_APP_TYPE, RubricaApp))

#define RUBRICA_APP_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),      \
                                    RUBRICA_APP_TYPE, RubricaAppClass))

#define IS_RUBRICA_APP(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),     \
                                    RUBRICA_APP_TYPE))

#define IS_RUBRICA_APP_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),        \
                                    RUBRICA_APP_TYPE))

#define RUBRICA_APP_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),      \
			            RUBRICA_APP_TYPE, RubricaAppClass))


typedef struct _RubricaApp        RubricaApp; 
typedef struct _RubricaAppClass   RubricaAppClass;
typedef struct _RubricaAppPrivate RubricaAppPrivate;


struct _RubricaApp {
  GObject parent;
   
  GtkWidget *window;

  RubricaAppPrivate* priv;  
};


struct _RubricaAppClass {
  GObjectClass parent;
};



GType       rubrica_app_get_type (void);


RubricaApp* rubrica_app_new  (void);
void        rubrica_app_free (RubricaApp* app);

/*  get
*/
GtkWidget* rubrica_app_get_search             (RubricaApp* app);
GtkWidget* rubrica_app_get_trash              (RubricaApp* app);
GtkWidget* rubrica_app_get_dataview           (RubricaApp* app);
GtkWidget* rubrica_app_get_notebook           (RubricaApp* app);
GtkWidget* rubrica_app_get_current_view       (RubricaApp* app); 
RAbook*    rubrica_app_get_active_addressbook (RubricaApp* app); 
RGroupBox* rubrica_app_get_groups             (RubricaApp* app);  
GtkWidget* rubrica_app_get_groups_view        (RubricaApp* app); 
GtkWidget* rubrica_app_get_statusbar          (RubricaApp* app); 
gchar*     rubrica_app_get_view_report        (RubricaApp* app); 


void       rubrica_app_run                      (RubricaApp* app);

GtkWidget* rubrica_app_append_addressbook       (RubricaApp* app);
//void       rubrica_app_append_empty_addressbook (RubricaApp* app);
void       rubrica_app_remove_addressbbok       (RubricaApp* app, 
						 GtkWidget* child);

gboolean   rubrica_app_load_file              (RubricaApp* app, gchar* file,
					       gchar* filter);

void       rubrica_app_add_card               (RubricaApp* app, RCard* card);
void       rubrica_app_move_card_to_trash     (RubricaApp* app, RCard* card); 

void       rubrica_app_display_card_data      (RubricaApp* app, RCard* card);

void       rubrica_app_show_message           (RubricaApp* app, gchar* msg);
void       rubrica_app_notify                 (RubricaApp* app, gchar* msg);

void       rubrica_app_update_view            (RubricaApp* app);

gint       rubrica_app_get_stack_len          (RubricaApp* app);
void       rubrica_app_push_card              (RubricaApp* app, gpointer crd);
gpointer   rubrica_app_pop_card               (RubricaApp* app);


void       rubrica_app_display_search_results (RubricaApp* app, 
					       GList* results);


void       rubrica_app_display_cards_by_group (RubricaApp* app, gchar* group);
void       rubrica_app_display_cards_by_type  (RubricaApp* app, gchar* type);
void       rubrica_app_display_cards_by_genre (RubricaApp* app, gchar* genre);
void       rubrica_app_display_cards_by_rate  (RubricaApp* app, RRate  rate);

void       rubrica_app_set_toolbar_style      (RubricaApp* app, gint style);
void       rubrica_app_set_font               (RubricaApp* app, gchar* font);

void       rubrica_app_enable_previouses      (RubricaApp* app, gboolean bool);
void       rubrica_app_enable_nexts           (RubricaApp* app, gboolean bool);

/*
void       rubrica_app_disable_previouses     (RubricaApp* app);
void       rubrica_app_disable_nexts          (RubricaApp* app);
*/

#endif
