#!/usr/bin/perl

use strict;
use warnings;
use NGCP::Rtpengine::Test;
use NGCP::Rtpclient::SRTP;
use NGCP::Rtpengine::AutoTest;
use Test::More;
use IPC::Open3;


$ENV{RTPENGINE_EXTENDED_TESTS} or exit();
$ENV{RTPENGINE_3GPP_EVS_LIB} or exit();


autotest_start(qw(--config-file=none -t -1 -i 203.0.113.1 -i 2001:db8:4321::1
			-n 2223 -f -L 7 -E), "--evs-lib-path=$ENV{RTPENGINE_3GPP_EVS_LIB}")
		or die;

my $wav_file = "\x52\x49\x46\x46\x64\x06\x00\x00\x57\x41\x56\x45\x66\x6d\x74\x20\x10\x00\x00\x00\x01\x00\x01\x00\x40\x1f\x00\x00\x80\x3e\x00\x00\x02\x00\x10\x00\x64\x61\x74\x61\x40\x06\x00\x00\x00\x00\xb0\x22\x45\x41\x25\x58\x95\x64\x24\x65\xbd\x59\xb6\x43\xb4\x25\x35\x03\x5e\xe0\x3b\xc1\x8c\xa9\x0f\x9c\x6a\x9a\xc2\xa4\xe7\xb9\x55\xd7\x92\xf9\x92\x1c\x30\x3c\xb2\x54\x2e\x63\xf3\x65\xa7\x5c\x68\x48\x9b\x2b\xa1\x09\x8a\xe6\x71\xc6\x28\xad\xab\x9d\xcc\x99\x06\xa2\x5c\xb5\x81\xd1\x2d\xf3\x53\x16\xe1\x36\xe8\x50\x64\x61\x59\x66\x36\x5f\xcf\x4c\x56\x31\x04\x10\xd0\xec\xe0\xcb\x19\xb1\xa9\x9f\x98\x99\xa8\x9f\x1a\xb1\xdf\xcb\xd1\xec\x04\x10\x54\x31\xd2\x4c\x33\x5f\x5c\x66\x61\x61\xeb\x50\xde\x36\x56\x16\x2b\xf3\x83\xd1\x59\xb5\x08\xa2\xcb\x99\xac\x9d\x28\xad\x70\xc6\x8a\xe6\xa3\x09\x98\x2b\x6a\x48\xa6\x5c\xf4\x65\x2d\x63\xb3\x54\x2e\x3c\x93\x1c\x93\xf9\x53\xd7\xe9\xb9\xc1\xa4\x69\x9a\x11\x9c\x8b\xa9\x3b\xc1\x5e\xe0\x36\x03\xb2\x25\xba\x43\xb7\x59\x2a\x65\x90\x64\x29\x58\x42\x41\xb2\x22\xff\xff\x50\xdd\xbb\xbe\xdb\xa7\x6b\x9b\xdd\x9a\x42\xa6\x4b\xbc\x4b\xda\xca\xfc\xa5\x1f\xc2\x3e\x77\x56\xed\x63\x9a\x65\x3b\x5b\x1b\x46\xa9\x28\x70\x06\x6c\xe3\xd2\xc3\x4d\xab\xd1\x9c\x10\x9a\x56\xa3\x99\xb7\x67\xd4\x5b\xf6\x79\x19\x8e\x39\xd7\x52\x58\x62\x30\x66\xfd\x5d\xa2\x4a\x81\x2e\xd1\x0c\xae\xe9\x1f\xc9\x17\xaf\x9e\x9e\xa4\x99\xce\xa0\x2c\xb3\xaf\xce\xf8\xef\x33\x13\x1e\x34\xe8\x4e\x57\x60\x68\x66\x57\x60\xe9\x4e\x1c\x34\x35\x13\xf6\xef\xb0\xce\x2d\xb3\xcc\xa0\xa6\x99\x9c\x9e\x17\xaf\x22\xc9\xa9\xe9\xd6\x0c\x7c\x2e\xa7\x4a\xf8\x5d\x36\x66\x52\x62\xdb\x52\x8c\x39\x79\x19\x5c\xf6\x67\xd4\x97\xb7\x59\xa3\x0e\x9a\xd1\x9c\x4e\xab\xd0\xc3\x6e\xe3\x6e\x06\xac\x28\x18\x46\x3d\x5b\x98\x65\xef\x63\x76\x56\xc3\x3e\xa4\x1f\xc9\xfc\x4e\xda\x49\xbc\x43\xa6\xdd\x9a\x69\x9b\xdd\xa7\xbb\xbe\x4f\xdd\x01\x00\xaf\x22\x47\x41\x23\x58\x96\x64\x24\x65\xbb\x59\xba\x43\xb0\x25\x39\x03\x59\xe0\x40\xc1\x87\xa9\x15\x9c\x65\x9a\xc4\xa4\xe7\xb9\x56\xd7\x90\xf9\x94\x1c\x2e\x3c\xb3\x54\x2f\x63\xf1\x65\xa8\x5c\x68\x48\x9a\x2b\xa2\x09\x8a\xe6\x71\xc6\x27\xad\xac\x9d\xcb\x99\x08\xa2\x59\xb5\x84\xd1\x2a\xf3\x56\x16\xe0\x36\xe7\x50\x65\x61\x59\x66\x35\x5f\xd1\x4c\x54\x31\x04\x10\xd2\xec\xdd\xcb\x1c\xb1\xa5\x9f\x9b\x99\xa8\x9f\x18\xb1\xe2\xcb\xcd\xec\x07\x10\x54\x31\xd1\x4c\x33\x5f\x5d\x66\x60\x61\xec\x50\xdd\x36\x57\x16\x29\xf3\x86\xd1\x57\xb5\x09\xa2\xcb\x99\xab\x9d\x29\xad\x70\xc6\x8a\xe6\xa2\x09\x9a\x2b\x69\x48\xa7\x5c\xf2\x65\x2e\x63\xb2\x54\x31\x3c\x91\x1c\x93\xf9\x53\xd7\xe9\xb9\xc1\xa4\x6a\x9a\x10\x9c\x8a\xa9\x3f\xc1\x59\xe0\x3a\x03\xb0\x25\xb8\x43\xbd\x59\x24\x65\x95\x64\x24\x58\x46\x41\xaf\x22\x02\x00\x4e\xdd\xbb\xbe\xdd\xa7\x68\x9b\xdf\x9a\x42\xa6\x48\xbc\x50\xda\xc6\xfc\xa7\x1f\xc2\x3e\x75\x56\xef\x63\x99\x65\x3c\x5b\x1a\x46\xaa\x28\x6e\x06\x6e\xe3\xd1\xc3\x4e\xab\xd1\x9c\x0e\x9a\x57\xa3\x9a\xb7\x64\xd4\x60\xf6\x75\x19\x90\x39\xd7\x52\x55\x62\x34\x66\xf9\x5d\xa8\x4a\x7a\x2e\xd8\x0c\xa7\xe9\x23\xc9\x16\xaf\x9d\x9e\xa6\x99\xcb\xa0\x2f\xb3\xad\xce\xfa\xef\x30\x13\x21\x34\xe6\x4e\x59\x60\x66\x66\x5a\x60\xe4\x4e\x23\x34\x2e\x13\xfc\xef\xab\xce\x30\xb3\xcb\xa0\xa5\x99\x9f\x9e\x14\xaf\x24\xc9\xa7\xe9\xd8\x0c\x7b\x2e\xa8\x4a\xf7\x5d\x36\x66\x53\x62\xda\x52\x8d\x39\x78\x19\x5d\xf6\x67\xd4\x97\xb7\x59\xa3\x0d\x9a\xd2\x9c\x4e\xab\xd1\xc3\x6d\xe3\x6f\x06\xaa\x28\x19\x46\x3f\x5b\x95\x65\xf2\x63\x74\x56\xc2\x3e\xa8\x1f\xc4\xfc\x52\xda\x45\xbc\x46\xa6\xdc\x9a\x6a\x9b\xdc\xa7\xba\xbe\x51\xdd\xff\xff\xb1\x22\x45\x41\x24\x58\x97\x64\x22\x65\xbd\x59\xb7\x43\xb3\x25\x37\x03\x5b\xe0\x3e\xc1\x89\xa9\x11\x9c\x6a\x9a\xc0\xa4\xeb\xb9\x51\xd7\x94\xf9\x91\x1c\x31\x3c\xb1\x54\x2f\x63\xf3\x65\xa5\x5c\x6c\x48\x95\x2b\xa7\x09\x86\xe6\x73\xc6\x28\xad\xa9\x9d\xcf\x99\x04\xa2\x5b\xb5\x84\xd1\x29\xf3\x57\x16\xde\x36\xe9\x50\x65\x61\x57\x66\x38\x5f\xcd\x4c\x57\x31\x04\x10\xd0\xec\xe1\xcb\x17\xb1\xaa\x9f\x97\x99\xaa\x9f\x18\xb1\xe1\xcb\xce\xec\x07\x10\x53\x31\xd0\x4c\x38\x5f\x55\x66\x68\x61\xe6\x50\xe0\x36\x56\x16\x2b\xf3\x81\xd1\x5d\xb5\x04\xa2\xce\x99\xaa\x9d\x29\xad\x70\xc6\x8a\xe6\xa2\x09\x9b\x2b\x67\x48\xa9\x5c\xf1\x65\x2e\x63\xb4\x54\x2e\x3c\x93\x1c\x92\xf9\x54\xd7\xe8\xb9\xc2\xa4\x69\x9a\x10\x9c\x8c\xa9\x3c\xc1\x5c\xe0\x37\x03\xb2\x25\xb8\x43\xbc\x59\x24\x65\x95\x64\x26\x58\x43\x41\xb2\x22\xff\xff\x50\xdd\xba\xbe\xde\xa7\x68\x9b\xdd\x9a\x45\xa6\x45\xbc\x52\xda\xc5\xfc\xa8\x1f\xbf\x3e\x79\x56\xec\x63\x9b\x65\x3b\x5b\x1a\x46\xaa\x28\x6f\x06\x6e\xe3\xd0\xc3\x4f\xab\xd0\x9c\x0f\x9a\x58\xa3\x97\xb7\x68\xd4\x5c\xf6\x78\x19\x8f\x39\xd6\x52\x57\x62\x32\x66\xfb\x5d\xa6\x4a\x7b\x2e\xd8\x0c\xa6\xe9\x25\xc9\x15\xaf\x9c\x9e\xa9\x99\xc7\xa0\x33\xb3\xa9\xce\xfd\xef\x2f\x13\x21\x34\xe6\x4e\x58\x60\x67\x66\x59\x60\xe5\x4e\x23\x34\x2c\x13\x00\xf0\xa6\xce\x35\xb3\xc7\xa0\xa8\x99\x9d\x9e\x15\xaf\x24\xc9\xa8\xe9\xd5\x0c\x7e\x2e\xa5\x4a\xfa\x5d\x35\x66\x52\x62\xdb\x52\x8d\x39\x77\x19\x5e\xf6\x66\xd4\x98\xb7\x59\xa3\x0c\x9a\xd3\x9c\x4d\xab\xd1\xc3\x6e\xe3\x6e\x06\xaa\x28\x1b\x46\x3b\x5b\x9a\x65\xed\x63\x76\x56\xc4\x3e\xa3\x1f\xcb\xfc\x4b\xda\x4a\xbc\x43\xa6\xdd\x9a\x6a\x9b\xdc\xa7\xba\xbe\x51\xdd\xff\xff\xb1\x22\x44\x41\x25\x58\x96\x64\x23\x65\xbd\x59\xb6\x43\xb4\x25\x36\x03\x5c\xe0\x3d\xc1\x8a\xa9\x12\x9c\x67\x9a\xc4\xa4\xe6\xb9\x55\xd7\x93\xf9\x91\x1c\x31\x3c\xb0\x54\x31\x63\xef\x65\xab\x5c\x66\x48\x9a\x2b\xa4\x09\x87\xe6\x73\xc6\x26\xad\xad\x9d\xcb\x99\x07\xa2\x5b\xb5\x81\xd1\x2c\xf3\x56\x16\xde\x36\xeb\x50\x62\x61\x59\x66\x38\x5f\xcc\x4c\x59\x31\x01\x10\xd3\xec\xdd\xcb\x1b\xb1\xa8\x9f\x98\x99\xa9\x9f\x18\xb1\xe0\xcb\xd1\xec\x03\x10\x57\x31\xce\x4c\x37\x5f\x58\x66\x63\x61\xec\x50\xdb\x36\x5a\x16\x27\xf3\x85\xd1\x5a\xb5\x05\xa2\xce\x99\xaa\x9d\x29\xad\x70\xc6\x8a\xe6\xa2\x09\x9a\x2b\x69\x48\xa6\x5c\xf4\x65\x2e\x63\xb1\x54\x32\x3c\x8e\x1c\x96\xf9\x52\xd7\xea\xb9\xc1\xa4\x67\x9a\x13\x9c\x8a\xa9\x3c\xc1\x5e\xe0\x33\x03\xb7\x25\xb4\x43\xbf\x59\x21\x65\x99\x64\x21\x58\x48\x41\xad\x22\x03\x00\x4f\xdd\xbb\xbe\xdb\xa7\x6a\x9b\xdd\x9a\x43\xa6\x4b\xbc\x4a\xda\xcb\xfc\xa4\x1f\xc3\x3e\x76\x56\xef\x63\x96\x65\x40\x5b\x17\x46\xac\x28\x6e\x06\x6d\xe3\xd2\xc3\x4d\xab\xd2\x9c\x0d\x9a\x59\xa3\x97\xb7\x68\xd4\x5c\xf6\x77\x19\x8f\x39\xd8\x52\x55\x62\x33\x66\xfb\x5d\xa4\x4a\x7f\x2e\xd4\x0c\xab\xe9\x20\xc9\x17\xaf\x9d\x9e\xa7\x99\xc9\xa0\x32\xb3\xa9\xce\xfd\xef\x2f\x13\x20\x34\xe8\x4e\x56\x60\x6a\x66\x55\x60\xe9\x4e\x1f\x34\x31\x13\xfa\xef\xad\xce\x2e\xb3\xcc\xa0\xa7\x99\x9b\x9e\x18\xaf\x20\xc9\xac\xe9\xd2\x0c\x81\x2e\xa1\x4a\xff\x5d\x30\x66\x56\x62\xd7\x52\x90\x39\x77\x19\x5d\xf6\x67\xd4\x96\xb7\x5a\xa3\x0e\x9a\xd0\x9c\x50\xab\xcf\xc3\x6e\xe3\x6f\x06\xaa\x28\x1a\x46\x3d\x5b\x98\x65\xee\x63\x77\x56\xc1\x3e\xa7\x1f\xc8\xfc\x4c\xda\x4b\xbc\x41\xa6\xdf\x9a\x68\x9b\xdd\xa7\xba\xbe\x51\xdd";

my ($sock_a, $sock_b, $port_a, $port_b, $ssrc, $ssrc_b, $resp, $srtp_ctx_a, $srtp_ctx_b, @ret1, @ret2);
my ($seq, $ts);




new_call;

offer('EVS codec accept basic', { codec => { accept => ['EVS'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept basic', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP



new_call;

offer('EVS codec accept multi', { codec => { accept => ['EVS'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; evs-mode-switch=1
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; evs-mode-switch=1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept multi', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP



new_call;

offer('EVS codec accept multi select', { codec => { accept => ['EVS/16000/1///evs-mode-switch=1;hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; evs-mode-switch=1
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; evs-mode-switch=1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept multi select', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 97
c=IN IP4 203.0.113.1
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; evs-mode-switch=1
a=sendrecv
a=rtcp:PORT
SDP




new_call;

offer('EVS codec accept select compat control', { codec => { accept => ['EVS/16000/1///hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=24-96
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=24-96
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat control', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=sendrecv
a=rtcp:PORT
SDP




new_call;

offer('EVS codec accept select compat 1', { codec => { accept => ['EVS/16000/1///hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat 1', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
a=rtcp:PORT
SDP





new_call;

offer('EVS codec accept select compat 2', { codec => { accept => ['EVS/16000/1///hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat 2', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=sendrecv
a=rtcp:PORT
SDP




new_call;

offer('EVS codec accept select compat 3', { codec => { accept => ['EVS/16000/1///hf-only=1;br=8-32'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat 3', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 97
c=IN IP4 203.0.113.1
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=sendrecv
a=rtcp:PORT
SDP




new_call;

offer('EVS codec accept select compat 4', { codec => { accept => ['EVS/16000/1///hf-only=1;br=6-50'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat 4', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 97
c=IN IP4 203.0.113.1
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=sendrecv
a=rtcp:PORT
SDP



new_call;

offer('EVS codec accept select compat 5', { codec => { accept => ['EVS/16000/1///evs-mode-switch=1;mode-set=3,4,5,6'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96 97 98 99 8 0
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=rtpmap:98 EVS/16000
a=fmtp:98 evs-mode-switch=1; mode-set=5,6,7
a=rtpmap:99 EVS/16000
a=fmtp:99 evs-mode-switch=1; mode-set=4,5
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 97 98 99 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24-96
a=rtpmap:97 EVS/16000
a=fmtp:97 hf-only=1; br=8-32
a=rtpmap:98 EVS/16000
a=fmtp:98 evs-mode-switch=1; mode-set=5,6,7
a=rtpmap:99 EVS/16000
a=fmtp:99 evs-mode-switch=1; mode-set=4,5
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS codec accept select compat 5', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 99
c=IN IP4 203.0.113.1
a=rtpmap:99 EVS/16000
a=fmtp:99 evs-mode-switch=1; mode-set=4,5
a=sendrecv
a=rtcp:PORT
SDP




new_call;

offer('EVS negotiate basic', { codec => { transcode => ['PCMA'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS negotiate basic', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP



new_call;

offer('EVS negotiate br-send/recv', { codec => { transcode => ['PCMA'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4020 RTP/AVP 96
c=IN IP4 198.51.100.4
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 br-send=13.2-24.4; br-recv=32-64
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 br-send=13.2-24.4; br-recv=32-64
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

answer('EVS negotiate br-send/recv', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.4
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.4
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 br-send=32-64; br-recv=13.2-24.4
a=sendrecv
a=rtcp:PORT
SDP






($sock_a, $sock_b) = new_call([qw(198.51.100.1 4020)], [qw(198.51.100.3 4022)]);

($port_a) = offer('EVS forward', { codec => { transcode => ['EVS'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4020 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4022 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x0d\x67\x75\x43\x46\xc3\x10\x82\x03\x82\x02\x00\x00\x00\x5f\xf1\x9a\x2c\xd9\xea\x12\x46\x8b\xa0\x21\xd6\x1f\xd0\xc2\xb8\xa0\x61\xa0\x79\x25\x36\x57\x23\xbd\xd9\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x0d\xe4\x73\x07\x88\x40\x03\x19\x43\xa3\x1d\xf7\xfb\x85\x89\xf4\xba\xee\x7e\x28\x4b\xf1\x89\x71\x33\xa1\xa6\xfe\xe5\xe3\x9d\x75\x95\x06\xea\xee\xb5\xc3\x75\x16\xa0"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x0d\xe4\x58\xcb\x9a\x50\x4b\x41\xb5\xd5\x58\xa9\xfa\x80\x99\x11\x05\x39\xae\x43\x80\x41\x1a\x41\x71\x3f\x62\x78\x64\xc1\x71\x61\xd7\x08\xfc\xad\xbe\x96\x3b\x00\x4a"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x4d\xa6\xcb\xc6\xe0\x43\x2a\x80\x80\x80\x80\x80\x2f\xfc\x00\x00\x14\x03\x5a\xaf\x1c\xc8\x3e\xe1\x30\x92\x3a\x01\x80\x6a\xe7\x47\x61\x15\x00\x0e\x09\xdb\x02\xc5\x77"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd0\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x54\x57\x51\x53\x5d\x5f\x59\x59\x5b\x58\x45\x58\x47\x5e\x45\x74\x13\x02\x02\x02\x02\x03\x03\x02\x02\x00\x01\x06\x06\x07\x04\x05\x1b\x19\x19\x06\x00\x01\x03\x02\x0c\x0c\x0d\x02\x03\x00\x01\x06\x07\x04\x05\x1b\x19\x1f\x1d\x13\x17\x15\x69\x6f\x6c\x6f\x6f\x63\x64\x73\x48\xd0\xf4\xf3\xe6\xe3\xeb\x97\x93\x9d\x9c\x98\x98\x85"));



($sock_a, $sock_b) = new_call([qw(198.51.100.5 4020)], [qw(198.51.100.7 4022)]);

($port_a) = offer('EVS reverse', { codec => { transcode => ['PCMA', 'PCMU'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.5
s=tester
t=0 0
m=audio 4020 RTP/AVP 96
c=IN IP4 198.51.100.5
a=sendrecv
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.5
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS reverse', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.7
s=tester
t=0 0
m=audio 4022 RTP/AVP 8
c=IN IP4 198.51.100.7
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.7
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_b, $port_a, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_a, $port_b, rtpm(96, 2000, 4000, -1, "\x0d\x67\x75\x43\x46\xc3\x10\x82\x03\x82\x02\x00\x00\x00\x5f\xf1\x9a\x2c\xd9\xea\x12\x46\x8b\xa0\x21\xd6\x1f\xd0\xc2\xb8\xa0\x61\xa0\x79\x25\x36\x57\x23\xbd\xd9\x01"));
snd($sock_b, $port_a, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_a, $port_b, rtpm(96, 2001, 4320, $ssrc, "\x0d\xe4\x73\x07\x88\x40\x03\x19\x43\xa3\x1d\xf7\xfb\x85\x89\xf4\xba\xee\x7e\x28\x4b\xf1\x89\x71\x33\xa1\xa6\xfe\xe5\xe3\x9d\x75\x95\x06\xea\xee\xb5\xc3\x75\x16\xa0"));
snd($sock_b, $port_a, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_a, $port_b, rtpm(96, 2002, 4640, $ssrc, "\x0d\xe4\x58\xcb\x9a\x50\x4b\x41\xb5\xd5\x58\xa9\xfa\x80\x99\x11\x05\x39\xae\x43\x80\x41\x1a\x41\x71\x3f\x62\x78\x64\xc1\x71\x61\xd7\x08\xfc\xad\xbe\x96\x3b\x00\x4a"));

snd($sock_a, $port_b, rtp(96, 6000, 7000, 0x9876, "\x4d\xa6\xcb\xc6\xe0\x43\x2a\x80\x80\x80\x80\x80\x2f\xfc\x00\x00\x14\x03\x5a\xaf\x1c\xc8\x3e\xe1\x30\x92\x3a\x01\x80\x6a\xe7\x47\x61\x15\x00\x0e\x09\xdb\x02\xc5\x77"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_a, $port_b, rtp(96, 6001, 7320, 0x9876, "\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc) = rcv($sock_b, $port_a, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd0\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x54\x57\x51\x53\x5d\x5f\x59\x59\x5b\x58\x45\x58\x47\x5e\x45\x74\x13\x02\x02\x02\x02\x03\x03\x02\x02\x00\x01\x06\x06\x07\x04\x05\x1b\x19\x19\x06\x00\x01\x03\x02\x0c\x0c\x0d\x02\x03\x00\x01\x06\x07\x04\x05\x1b\x19\x1f\x1d\x13\x17\x15\x69\x6f\x6c\x6f\x6f\x63\x64\x73\x48\xd0\xf4\xf3\xe6\xe3\xeb\x97\x93\x9d\x9c\x98\x98\x85"));






($sock_a, $sock_b) = new_call([qw(198.51.100.1 4024)], [qw(198.51.100.3 4026)]);

($port_a) = offer('EVS forward hf-only', { codec => { transcode => ['EVS/16000/1///hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4024 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward hf-only', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4026 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x05\x0d\x67\x75\x43\x46\xc3\x10\x82\x03\x82\x02\x00\x00\x00\x5f\xf1\x9a\x2c\xd9\xea\x12\x46\x8b\xa0\x21\xd6\x1f\xd0\xc2\xb8\xa0\x61\xa0\x79\x25\x36\x57\x23\xbd\xd9\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x05\x0d\xe4\x73\x07\x88\x40\x03\x19\x43\xa3\x1d\xf7\xfb\x85\x89\xf4\xba\xee\x7e\x28\x4b\xf1\x89\x71\x33\xa1\xa6\xfe\xe5\xe3\x9d\x75\x95\x06\xea\xee\xb5\xc3\x75\x16\xa0"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x05\x0d\xe4\x58\xcb\x9a\x50\x4b\x41\xb5\xd5\x58\xa9\xfa\x80\x99\x11\x05\x39\xae\x43\x80\x41\x1a\x41\x71\x3f\x62\x78\x64\xc1\x71\x61\xd7\x08\xfc\xad\xbe\x96\x3b\x00\x4a"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x05\x4d\xa6\xcb\xc6\xe0\x43\x2a\x80\x80\x80\x80\x80\x2f\xfc\x00\x00\x14\x03\x5a\xaf\x1c\xc8\x3e\xe1\x30\x92\x3a\x01\x80\x6a\xe7\x47\x61\x15\x00\x0e\x09\xdb\x02\xc5\x77"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x05\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd0\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x54\x57\x51\x53\x5d\x5f\x59\x59\x5b\x58\x45\x58\x47\x5e\x45\x74\x13\x02\x02\x02\x02\x03\x03\x02\x02\x00\x01\x06\x06\x07\x04\x05\x1b\x19\x19\x06\x00\x01\x03\x02\x0c\x0c\x0d\x02\x03\x00\x01\x06\x07\x04\x05\x1b\x19\x1f\x1d\x13\x17\x15\x69\x6f\x6c\x6f\x6f\x63\x64\x73\x48\xd0\xf4\xf3\xe6\xe3\xeb\x97\x93\x9d\x9c\x98\x98\x85"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4028)], [qw(198.51.100.3 4030)]);

($port_a) = offer('EVS forward AMR IO', { codec => { transcode => ['EVS/16000/1///evs-mode-switch=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4028 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward AMR IO', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4030 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\xf1\x25\x1c\xa6\x31\xce\x69\xff\xd4\x16\x11\xbe\x62\xfa\x84\x08\x00\x00\x22\x14\xa8\x01\x3b\x70\x08\x12\x80\xa0\x07\x10\x80\x03\x23\x6f\x04\x42\x42\x0f\x11\x22\xca\xdf\x9c\x11\x2f\x43"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\xfa\x73\xa1\xf8\xfc\x5e\x83\x48\x5c\xe8\x7e\x20\x80\x99\xed\xa4\x7f\xd5\xb6\x36\x2e\x05\xf7\x20\x31\x29\x0b\xa6\xa0\x07\x3a\x07\x87\x3b\x75\xbb\x91\xf0\x5f\xc9\x81\xa9\x5c\x40\x6b\x3d"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\xf0\xa3\x92\x33\x35\x5c\x4f\xf8\x94\x1b\xef\x10\x85\xe7\xa5\x59\xe0\x76\x57\xb6\x3e\x7d\xf9\x72\x1b\xb8\x10\xde\xa6\x36\xf1\x6b\xab\x57\x5b\x42\x8a\xdb\xe1\x8b\xc6\xaf\xc1\x3f\x0c\x87"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\xf9\x41\x84\xa6\x30\xee\x84\xc8\x34\x40\x18\x15\xa1\xde\x14\x09\x10\x08\x6e\x22\xad\x51\x36\x30\x0c\x52\x00\xa8\x60\xd2\xc0\x32\x63\x6d\x64\x42\x73\x4f\x91\x22\x6b\x9b\x0c\x64\x1f\x63"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\xf8\x73\x1a\x7a\xfe\x3e\x97\xc9\x76\xd1\xb7\x75\x71\xa4\x9d\xe6\x5d\x05\x39\x51\x16\x4e\x40\xaa\xa6\xaa\x49\x92\xd0\x0c\x37\x33\xd8\x07\x30\x45\xea\x99\x86\x78\x0c\x36\xd9\x85\x06\x2f"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\x55\x55\x55\xd5\xd4\xd4\xd4\xd5\xd5\x55\x54\x54\x54\x57\x54\x55\xd5\xd7\xd7\xd7\xd7\xd7\xd4\xd5\xd5\x55\x55\xd5\xd4\xd7\xd7\xd4\x55\xd5\xd5\x55\x54\x54\x57\x57\x54\x54\x54\x54\x54\x54\x55\xd4\xd7\xd7\xd7\x54\x57\x57\x5d\x58\x5a\x5a\x58\x5f\x52\x56\x56\x51\x54\x54\x53\x5c\x5e\x5c\x52\x51\x50\x5e\x5f\x53\x58\x4d\x4e\x4c\x5a\x53\xd7\xd2\xd2\xd1\xd4\x51\x5e\x58\x58\x5b\x5b\x5c\x56\xd5\xd5\xd4\xd1\xdd\xdf\xdf\xd2\x57\x5c\x5e\x46\x4b\x74\x4a\x41\x5d"));



($sock_a, $sock_b) = new_call([qw(198.51.100.5 4028)], [qw(198.51.100.7 4030)]);

($port_a) = offer('EVS reverse AMR IO', { codec => { transcode => ['PCMA','PCMU'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.5
s=tester
t=0 0
m=audio 4028 RTP/AVP 96
c=IN IP4 198.51.100.5
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.5
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8 0
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS reverse AMR IO', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.7
s=tester
t=0 0
m=audio 4030 RTP/AVP 8
c=IN IP4 198.51.100.7
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.7
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_b, $port_a, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_a, $port_b, rtpm(96, 2000, 4000, -1, "\xf1\x25\x1c\xa6\x31\xce\x69\xff\xd4\x16\x11\xbe\x62\xfa\x84\x08\x00\x00\x22\x14\xa8\x01\x3b\x70\x08\x12\x80\xa0\x07\x10\x80\x03\x23\x6f\x04\x42\x42\x0f\x11\x22\xca\xdf\x9c\x11\x2f\x43"));
snd($sock_b, $port_a, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_a, $port_b, rtpm(96, 2001, 4320, $ssrc, "\xfa\x73\xa1\xf8\xfc\x5e\x83\x48\x5c\xe8\x7e\x20\x80\x99\xed\xa4\x7f\xd5\xb6\x36\x2e\x05\xf7\x20\x31\x29\x0b\xa6\xa0\x07\x3a\x07\x87\x3b\x75\xbb\x91\xf0\x5f\xc9\x81\xa9\x5c\x40\x6b\x3d"));
snd($sock_b, $port_a, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_a, $port_b, rtpm(96, 2002, 4640, $ssrc, "\xf0\xa3\x92\x33\x35\x5c\x4f\xf8\x94\x1b\xef\x10\x85\xe7\xa5\x59\xe0\x76\x57\xb6\x3e\x7d\xf9\x72\x1b\xb8\x10\xde\xa6\x36\xf1\x6b\xab\x57\x5b\x42\x8a\xdb\xe1\x8b\xc6\xaf\xc1\x3f\x0c\x87"));

snd($sock_a, $port_b, rtp(96, 6000, 7000, 0x9876, "\xf9\x41\x84\xa6\x30\xee\x84\xc8\x34\x40\x18\x15\xa1\xde\x14\x09\x10\x08\x6e\x22\xad\x51\x36\x30\x0c\x52\x00\xa8\x60\xd2\xc0\x32\x63\x6d\x64\x42\x73\x4f\x91\x22\x6b\x9b\x0c\x64\x1f\x63"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_a, $port_b, rtp(96, 6001, 7320, 0x9876, "\xf8\x73\x1a\x7a\xfe\x3e\x97\xc9\x76\xd1\xb7\x75\x71\xa4\x9d\xe6\x5d\x05\x39\x51\x16\x4e\x40\xaa\xa6\xaa\x49\x92\xd0\x0c\x37\x33\xd8\x07\x30\x45\xea\x99\x86\x78\x0c\x36\xd9\x85\x06\x2f"));
($ssrc) = rcv($sock_b, $port_a, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\x55\x55\x55\xd5\xd4\xd4\xd4\xd5\xd5\x55\x54\x54\x54\x57\x54\x55\xd5\xd7\xd7\xd7\xd7\xd7\xd4\xd5\xd5\x55\x55\xd5\xd4\xd7\xd7\xd4\x55\xd5\xd5\x55\x54\x54\x57\x57\x54\x54\x54\x54\x54\x54\x55\xd4\xd7\xd7\xd7\x54\x57\x57\x5d\x58\x5a\x5a\x58\x5f\x52\x56\x56\x51\x54\x54\x53\x5c\x5e\x5c\x52\x51\x50\x5e\x5f\x53\x58\x4d\x4e\x4c\x5a\x53\xd7\xd2\xd2\xd1\xd4\x51\x5e\x58\x58\x5b\x5b\x5c\x56\xd5\xd5\xd4\xd1\xdd\xdf\xdf\xd2\x57\x5c\x5e\x46\x4b\x74\x4a\x41\x5d"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4032)], [qw(198.51.100.3 4034)]);

($port_a) = offer('EVS forward AMR IO hf-only', { codec => { transcode => ['EVS/16000/1///evs-mode-switch=1;hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4032 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; evs-mode-switch=1
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward AMR IO hf-only', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4034 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1;hf-only=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x35\xc4\x94\x72\x98\xc7\x39\xa7\xff\x50\x58\x46\xf9\x8b\xea\x10\x20\x00\x00\x88\x52\xa0\x04\xed\xc0\x20\x4a\x02\x80\x1c\x42\x00\x0c\x8d\xbc\x11\x09\x08\x3c\x44\x8b\x2b\x7e\x70\x44\xbd\x08"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x35\xe9\xce\x87\xe3\xf1\x7a\x0d\x21\x73\xa1\xf8\x82\x02\x67\xb6\x91\xff\x56\xd8\xd8\xb8\x17\xdc\x80\xc4\xa4\x2e\x9a\x80\x1c\xe8\x1e\x1c\xed\xd6\xee\x47\xc1\x7f\x26\x06\xa5\x71\x01\xac\xf0"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x35\xc2\x8e\x48\xcc\xd5\x71\x3f\xe2\x50\x6f\xbc\x42\x17\x9e\x95\x67\x81\xd9\x5e\xd8\xf9\xf7\xe5\xc8\x6e\xe0\x43\x7a\x98\xdb\xc5\xae\xad\x5d\x6d\x0a\x2b\x6f\x86\x2f\x1a\xbf\x04\xfc\x32\x18"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x35\xe5\x06\x12\x98\xc3\xba\x13\x20\xd1\x00\x60\x56\x87\x78\x50\x24\x40\x21\xb8\x8a\xb5\x44\xd8\xc0\x31\x48\x02\xa1\x83\x4b\x00\xc9\x8d\xb5\x91\x09\xcd\x3e\x44\x89\xae\x6c\x31\x90\x7d\x88"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x35\xe1\xcc\x69\xeb\xf8\xfa\x5f\x25\xdb\x46\xdd\xd5\xc6\x92\x77\x99\x74\x14\xe5\x44\x59\x39\x02\xaa\x9a\xa9\x26\x4b\x40\x30\xdc\xcf\x60\x1c\xc1\x17\xaa\x66\x19\xe0\x30\xdb\x66\x14\x18\xb8"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\x55\x55\x55\xd5\xd4\xd4\xd4\xd5\xd5\x55\x54\x54\x54\x57\x54\x55\xd5\xd7\xd7\xd7\xd7\xd7\xd4\xd5\xd5\x55\x55\xd5\xd4\xd7\xd7\xd4\x55\xd5\xd5\x55\x54\x54\x57\x57\x54\x54\x54\x54\x54\x54\x55\xd4\xd7\xd7\xd7\x54\x57\x57\x5d\x58\x5a\x5a\x58\x5f\x52\x56\x56\x51\x54\x54\x53\x5c\x5e\x5c\x52\x51\x50\x5e\x5f\x53\x58\x4d\x4e\x4c\x5a\x53\xd7\xd2\xd2\xd1\xd4\x51\x5e\x58\x58\x5b\x5b\x5c\x56\xd5\xd5\xd4\xd1\xdd\xdf\xdf\xd2\x57\x5c\x5e\x46\x4b\x74\x4a\x41\x5d"));





($sock_a, $sock_b) = new_call([qw(198.51.100.1 4036)], [qw(198.51.100.3 4038)]);

($port_a) = offer('EVS forward mode 10', { codec => { transcode => ['EVS/16000/1/96000//hf-only=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4036 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward mode 10', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4038 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
# XXX clamped to mode 6 due to 8 kHz input
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x06\x0d\x67\x75\x43\x46\xc3\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x47\x40\x42\x99\x21\xe1\x1a\x74\xf7\x1b\xac\x40\xc0\x23\xe2\xa0\x1e\x87\x44\x57\x30\x7d\xb3\x2a\x38\x38\x06\x6d\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x06\x0d\xe4\x73\x07\x88\x40\x09\x1c\x40\x96\x23\x82\x19\xed\x9f\x97\x05\x2f\xb7\x13\xea\x0e\x50\x2c\xc9\xea\xc6\x6f\x5e\xf4\x22\xec\x82\xe2\x6c\xda\x74\x7d\x15\xe1\xe4\xbf\x99\xd9\x74\x78\xd4\x3d\x26\xf2\x7b\x2c\x3c\x6d\xa3\x8c\xd8\x3a\x14\xa9\xac"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x06\x0d\xe4\x58\xcb\x9a\x50\x3f\x67\x5a\x18\x97\x8f\x12\x87\x11\x8a\xd9\x0b\x8b\x95\xea\x11\xba\x7f\x3b\xd4\x60\x66\xb9\x9b\xd9\xdf\x57\x00\x22\x57\x52\xd3\x95\x41\x01\x35\xdc\xbf\xa7\x9a\x41\xdf\x98\xb3\x86\x20\x3c\xd2\x1b\x1f\x44\xdf\x87\x43\x62"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x0a\x1e\xe2\xdb\xc6\x8e\x3f\x0e\xd3\x01\xef\x0e\xc0\x39\xdc\x7b\xce\xff\xf9\xe0\x08\xb8\xbf\xa8\xcc\x4a\x61\xdb\xe6\x0d\xa3\x46\xd7\x2d\xb6\x13\x5d\x58\x60\x27\x68\x31\xa4\x99\x92\x74\xfb\xb0\x44\xdc\x8c\xc1\xf7\x5b\x37\x58\x64\x47\xb7\x56\x72\x57\x85\xc8\xf8\xbd\x72\x37\x94\x84\x87\x41\x63\x22\x2b\xbd\x11\x1b\xec\x45\x55\x40\xdd\xdf\xfe\xee\xd1\x11\x11\x2e\xee\xef\xbb\x48\x83\x52\x96\x9f\x0b\x0d\x01\x39\x30\x66\xb2\xb3\x95\xf7\x7d\x1b\x7c\x83\x6f\x9d\x06\x92\x49\x06\x74\x95\xeb\x2a\x81\x02\xc2\x48\xf8\x61\x9d\x57\xa3\xb8\x8f\x4f\x01\x4b\x66\x57\xbf\x68\x94\x15\x98\x0a\xf2\x53\xc9\xa8\xdb\xa8\xe3\xbf\x47\x44\x8a\xb0\x5a\xbd\x1a\x9e\xb5\x29\xf9\x4c\x46\xd3\xb9\x94\xe6\x9c\x05\xf6\x2c\x53\x32\xba\x07\xc8\x97\x9e\x09\x13\xaf\x82\xf6\xde\x07\x53\x50\x7e\x3a\xaa\xb5\x9c\xce\x63\x23\x33\x39\x99\x8c\x9a\xaa\xca\xaa\x35\x55\x9b\x4c\x03\x13\x1a\x44\x69\x8c\x26\xf0\xd6\x02\x56\x98\x6b\x77\x17\x4e\x28\x16\xb5\x8c\x22\xc0\xf2\x97\x2d\xa3\xb8\x43\xae\x45\x32\xf5"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x0a\x0a\x1b\xcb\x12\xa5\x0f\xbe\x00\x42\xb2\x7c\x01\x4c\xfa\x7c\x89\xa8\x1f\x1b\xd0\x5f\x34\x11\x55\xc9\x58\x27\x63\xad\x74\x4b\x9a\xe4\xa2\x1c\x9b\xa2\x25\xe3\xa3\x22\xb0\x0b\x55\x0f\x66\xf2\x73\x9a\x88\xf6\x43\xff\xff\xff\xff\xfd\x6a\x77\x2a\x7a\x46\xd5\x69\x4a\xb5\x54\xb5\x54\xb5\x54\xa9\x55\x94\xd5\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x4a\x45\x94\xa5\x60\xd6\x6e\xd6\x4b\x84"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\x55\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\xd5\x55\xd4\x54\xd1\x5e\xd9\x5e\xc4\x4b\xf2\x66\x96\x24\x2a\x2f\x2e\x2d\x2d\x23\x20\x21\x26\x27\x24\x3a\x3b\x39\x3f\x3d\x33\x31\x36\x34\x0a\x09\x0c\x02\x01\x04\x18\x1d\x16\x69\x67\x71\x51\xca\xfa\xe2\xea\x96\x93\x9c\x99\x9a\x84\x87\x81\x80\x83\x82\x8c\x8f\x8e\x89\x88\x8b\x8a\x8a\xb5\xb5\xb4\xb4\xb4\xb4\xb7"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4040)], [qw(198.51.100.3 4042)]);

($port_a) = offer('EVS forward br=96', { codec => { transcode => ['EVS/16000/1///hf-only=1;br=96'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4040 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=96
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward br=96', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4042 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1;br=96
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
# XXX clamped to mode 6 due to 8 kHz input
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x06\x0d\x67\x75\x43\x46\xc3\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x47\x40\x42\x99\x21\xe1\x1a\x74\xf7\x1b\xac\x40\xc0\x23\xe2\xa0\x1e\x87\x44\x57\x30\x7d\xb3\x2a\x38\x38\x06\x6d\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x06\x0d\xe4\x73\x07\x88\x40\x09\x1c\x40\x96\x23\x82\x19\xed\x9f\x97\x05\x2f\xb7\x13\xea\x0e\x50\x2c\xc9\xea\xc6\x6f\x5e\xf4\x22\xec\x82\xe2\x6c\xda\x74\x7d\x15\xe1\xe4\xbf\x99\xd9\x74\x78\xd4\x3d\x26\xf2\x7b\x2c\x3c\x6d\xa3\x8c\xd8\x3a\x14\xa9\xac"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x06\x0d\xe4\x58\xcb\x9a\x50\x3f\x67\x5a\x18\x97\x8f\x12\x87\x11\x8a\xd9\x0b\x8b\x95\xea\x11\xba\x7f\x3b\xd4\x60\x66\xb9\x9b\xd9\xdf\x57\x00\x22\x57\x52\xd3\x95\x41\x01\x35\xdc\xbf\xa7\x9a\x41\xdf\x98\xb3\x86\x20\x3c\xd2\x1b\x1f\x44\xdf\x87\x43\x62"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x0a\x1e\xe2\xdb\xc6\x8e\x3f\x0e\xd3\x01\xef\x0e\xc0\x39\xdc\x7b\xce\xff\xf9\xe0\x08\xb8\xbf\xa8\xcc\x4a\x61\xdb\xe6\x0d\xa3\x46\xd7\x2d\xb6\x13\x5d\x58\x60\x27\x68\x31\xa4\x99\x92\x74\xfb\xb0\x44\xdc\x8c\xc1\xf7\x5b\x37\x58\x64\x47\xb7\x56\x72\x57\x85\xc8\xf8\xbd\x72\x37\x94\x84\x87\x41\x63\x22\x2b\xbd\x11\x1b\xec\x45\x55\x40\xdd\xdf\xfe\xee\xd1\x11\x11\x2e\xee\xef\xbb\x48\x83\x52\x96\x9f\x0b\x0d\x01\x39\x30\x66\xb2\xb3\x95\xf7\x7d\x1b\x7c\x83\x6f\x9d\x06\x92\x49\x06\x74\x95\xeb\x2a\x81\x02\xc2\x48\xf8\x61\x9d\x57\xa3\xb8\x8f\x4f\x01\x4b\x66\x57\xbf\x68\x94\x15\x98\x0a\xf2\x53\xc9\xa8\xdb\xa8\xe3\xbf\x47\x44\x8a\xb0\x5a\xbd\x1a\x9e\xb5\x29\xf9\x4c\x46\xd3\xb9\x94\xe6\x9c\x05\xf6\x2c\x53\x32\xba\x07\xc8\x97\x9e\x09\x13\xaf\x82\xf6\xde\x07\x53\x50\x7e\x3a\xaa\xb5\x9c\xce\x63\x23\x33\x39\x99\x8c\x9a\xaa\xca\xaa\x35\x55\x9b\x4c\x03\x13\x1a\x44\x69\x8c\x26\xf0\xd6\x02\x56\x98\x6b\x77\x17\x4e\x28\x16\xb5\x8c\x22\xc0\xf2\x97\x2d\xa3\xb8\x43\xae\x45\x32\xf5"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x0a\x0a\x1b\xcb\x12\xa5\x0f\xbe\x00\x42\xb2\x7c\x01\x4c\xfa\x7c\x89\xa8\x1f\x1b\xd0\x5f\x34\x11\x55\xc9\x58\x27\x63\xad\x74\x4b\x9a\xe4\xa2\x1c\x9b\xa2\x25\xe3\xa3\x22\xb0\x0b\x55\x0f\x66\xf2\x73\x9a\x88\xf6\x43\xff\xff\xff\xff\xfd\x6a\x77\x2a\x7a\x46\xd5\x69\x4a\xb5\x54\xb5\x54\xb5\x54\xa9\x55\x94\xd5\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x4a\x45\x94\xa5\x60\xd6\x6e\xd6\x4b\x84"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\x55\xd5\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\xd5\x55\xd4\x54\xd1\x5e\xd9\x5e\xc4\x4b\xf2\x66\x96\x24\x2a\x2f\x2e\x2d\x2d\x23\x20\x21\x26\x27\x24\x3a\x3b\x39\x3f\x3d\x33\x31\x36\x34\x0a\x09\x0c\x02\x01\x04\x18\x1d\x16\x69\x67\x71\x51\xca\xfa\xe2\xea\x96\x93\x9c\x99\x9a\x84\x87\x81\x80\x83\x82\x8c\x8f\x8e\x89\x88\x8b\x8a\x8a\xb5\xb5\xb4\xb4\xb4\xb4\xb7"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4044)], [qw(198.51.100.3 4046)]);

($port_a) = offer('EVS forward br=24.4-96', { codec => { transcode => ['EVS/16000/1///hf-only=1;br=24.4-96'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4044 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=24.4-96
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward br=24.4-96', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4046 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1;br=24.4-96
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x06\x0d\x67\x75\x43\x46\xc3\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x47\x40\x42\x99\x21\xe1\x1a\x74\xf7\x1b\xac\x40\xc0\x23\xe2\xa0\x1e\x87\x44\x57\x30\x7d\xb3\x2a\x38\x38\x06\x6d\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x06\x0d\xe4\x73\x07\x88\x40\x09\x1c\x40\x96\x23\x82\x19\xed\x9f\x97\x05\x2f\xb7\x13\xea\x0e\x50\x2c\xc9\xea\xc6\x6f\x5e\xf4\x22\xec\x82\xe2\x6c\xda\x74\x7d\x15\xe1\xe4\xbf\x99\xd9\x74\x78\xd4\x3d\x26\xf2\x7b\x2c\x3c\x6d\xa3\x8c\xd8\x3a\x14\xa9\xac"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x06\x0d\xe4\x58\xcb\x9a\x50\x3f\x67\x5a\x18\x97\x8f\x12\x87\x11\x8a\xd9\x0b\x8b\x95\xea\x11\xba\x7f\x3b\xd4\x60\x66\xb9\x9b\xd9\xdf\x57\x00\x22\x57\x52\xd3\x95\x41\x01\x35\xdc\xbf\xa7\x9a\x41\xdf\x98\xb3\x86\x20\x3c\xd2\x1b\x1f\x44\xdf\x87\x43\x62"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x06\x4e\x0d\x36\x5e\x37\x02\x19\x54\x00\x04\x00\x04\x00\x04\x00\x04\x05\xff\x80\x01\x00\x00\x14\x01\x0c\x51\x80\x05\xe3\x67\x22\x86\xa8\x57\x3e\xea\x34\xd1\xa3\xa0\x3c\x70\x3b\xd8\xbb\x7e\x99\x42\x0e\x0e\x98\x9c\x8a\xc7\x36\xfa\x22\x5b\x2c\x28\xb1"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x06\x4e\x0b\x34\x7f\xa9\xe0\x08\x9d\xe3\x08\x04\x4b\x50\x7d\xd9\x94\x43\xff\x0b\x7b\x7e\x13\xd6\x3a\x72\x60\xe5\xe3\x42\x43\x94\x08\xa6\x96\x25\x4e\x9e\x11\x7a\xfe\x37\xd9\x05\x61\xf0\xdf\x8d\x5b\x44\x85\xc8\x8b\x64\x0c\x1f\xa7\x7c\x8e\xe1\x15\x2c"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd3\xd1\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x54\x57\x56\x56\x51\x51\x53\x53\x5d\x52\x5f\x50\x59\x58\x16\x05\x1f\x1e\x1c\x13\x14\x14\x15\x6a\x6b\x6d\x62\x60\x60\x67\x64\x78\x64\x1f\x05\x07\x01\x03\x02\x0d\x0d\x02\x02\x03\x02\x00\x01\x06\x07\x04\x05\x19\x1d\x12\x6b\x69\x6e\x64\x61\x65\x75\x41\xdc\xf6\xfa\xff\xf8\xe6\xe3\xe2\xed\xee\xe9\x95\x94\x96\x90\x93", "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd3\xd1\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x54\x57\x56\x56\x51\x50\x53\x53\x5d\x52\x5f\x50\x59\x58\x16\x05\x1f\x1e\x1c\x13\x14\x14\x15\x6a\x6b\x6d\x62\x60\x60\x67\x64\x78\x64\x1f\x05\x07\x01\x03\x02\x0d\x0d\x02\x02\x03\x02\x00\x01\x06\x07\x04\x05\x19\x1d\x12\x6b\x69\x6e\x64\x61\x65\x75\x41\xdc\xf6\xfa\xff\xf8\xe6\xe3\xe2\xed\xee\xe9\x95\x94\x96\x90\x93"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4048)], [qw(198.51.100.3 4050)]);

# mode 8, restrict to NB -> mode 6
($port_a) = offer('EVS forward bw=nb', { codec => { transcode => ['EVS/16000/1/48800//hf-only=1;bw=nb'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4048 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; bw=nb
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward bw=nb', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4050 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1;bw=nb
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x06\x0d\x67\x75\x43\x46\xc3\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf6\x6f\xb7\xd6\x92\xb8\xdf\x3d\xc2\x47\xb9\xeb\x47\x40\x42\x99\x21\xe1\x1a\x74\xf7\x1b\xac\x40\xc0\x23\xe2\xa0\x1e\x87\x44\x57\x30\x7d\xb3\x2a\x38\x38\x06\x6d\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x06\x0d\xe4\x73\x07\x88\x40\x09\x1c\x40\x96\x23\x82\x19\xed\x9f\x97\x05\x2f\xb7\x13\xea\x0e\x50\x2c\xc9\xea\xc6\x6f\x5e\xf4\x22\xec\x82\xe2\x6c\xda\x74\x7d\x15\xe1\xe4\xbf\x99\xd9\x74\x78\xd4\x3d\x26\xf2\x7b\x2c\x3c\x6d\xa3\x8c\xd8\x3a\x14\xa9\xac"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x06\x0d\xe4\x58\xcb\x9a\x50\x3f\x67\x5a\x18\x97\x8f\x12\x87\x11\x8a\xd9\x0b\x8b\x95\xea\x11\xba\x7f\x3b\xd4\x60\x66\xb9\x9b\xd9\xdf\x57\x00\x22\x57\x52\xd3\x95\x41\x01\x35\xdc\xbf\xa7\x9a\x41\xdf\x98\xb3\x86\x20\x3c\xd2\x1b\x1f\x44\xdf\x87\x43\x62"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x06\x0d\x67\x75\x25\x45\x64\x10\x80\x00\x80\x80\x00\x00\x00\x00\x80\x80\x00\x00\xbf\xf9\x7f\xfa\xa6\x0f\x99\x7b\x5e\x1e\x0f\x29\xe8\xf7\x40\x45\x0e\x18\x03\xa9\x2f\x74\x32\xc8\x18\x20\x6d\xd1\x40\x43\xfd\x38\x6a\x85\x6f\x40\x12\x76\x69\x83\x83\x06"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x06\x0d\xe4\x73\x6a\x88\x40\x13\x46\xe3\x8e\x0d\xb8\x26\x57\xe2\x59\x37\x07\xb0\xd3\xe4\x17\xbb\xcb\x12\x2b\xae\xc2\x3a\x17\x64\x58\xc2\xc2\x62\xaf\x5d\x5e\xea\x90\x94\x6b\x90\xdf\xd6\xa0\x05\x9d\x08\x36\xc2\x80\xe7\x9f\x4f\x9e\xcc\xf9\x38\xec\x1a"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\xd5\x56\x5f\x5a\x5a\x5a\x5b\x58\x59\x5f\x5d\x53\x51\x56\x54\x55\xd5\xd4\xd4\xd7\xd7\xd7\xd7\xd6\xd5\x50\x5c\x5f\x5f\x5f\x5c\x5d\x53\x50\x56\x57\x55\xd5\xd4\xd4\xd7\xd7\xd7\xd4\xd4\xd4\xd5\xd4\x54\x5d\x6b\x16\x14\x11\x17\x11\x17\x17\x14\x14\x6a\x69\x6f\x62\x60\x66\x65\x7b\x73\x6e\x1d\x16\x10\x14\x11\x18\x04\x65\x3c\x2d\x21\x20\x21\x27\x24\x24\x25\x25\x3b\x39\x3e\x3c\x33\x30\x36\x37\x36\x37\x36\x34\x0b\x0f\x02\x06\x1a\x1d\x12\x16\x14\x6c\x7d\x40\xda\xf4\xf0\xe0\xec\xf8\xe8\x96\x9f\x9e\x84\x87\x81\x83\x82\x8c\x8f\x89\x88\x8b\x8b\x8a\xb5\xb5\xb5\xb5\xb4\xb4\xb4\xb7"));






($sock_a, $sock_b) = new_call([qw(198.51.100.1 4052)], [qw(198.51.100.3 4054)]);

($port_a) = offer('EVS forward cmr=1', { codec => { transcode => ['EVS/16000/1///cmr=1'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4052 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 cmr=1
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward cmr=1', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4054 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 cmr=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\xff\x05\x0d\x67\x75\x43\x46\xc3\x10\x82\x03\x82\x02\x00\x00\x00\x5f\xf1\x9a\x2c\xd9\xea\x12\x46\x8b\xa0\x21\xd6\x1f\xd0\xc2\xb8\xa0\x61\xa0\x79\x25\x36\x57\x23\xbd\xd9\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\xff\x05\x0d\xe4\x73\x07\x88\x40\x03\x19\x43\xa3\x1d\xf7\xfb\x85\x89\xf4\xba\xee\x7e\x28\x4b\xf1\x89\x71\x33\xa1\xa6\xfe\xe5\xe3\x9d\x75\x95\x06\xea\xee\xb5\xc3\x75\x16\xa0"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\xff\x05\x0d\xe4\x58\xcb\x9a\x50\x4b\x41\xb5\xd5\x58\xa9\xfa\x80\x99\x11\x05\x39\xae\x43\x80\x41\x1a\x41\x71\x3f\x62\x78\x64\xc1\x71\x61\xd7\x08\xfc\xad\xbe\x96\x3b\x00\x4a"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\xff\x05\x4d\xa6\xcb\xc6\xe0\x43\x2a\x80\x80\x80\x80\x80\x2f\xfc\x00\x00\x14\x03\x5a\xaf\x1c\xc8\x3e\xe1\x30\x92\x3a\x01\x80\x6a\xe7\x47\x61\x15\x00\x0e\x09\xdb\x02\xc5\x77"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\xff\x05\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd0\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x54\x57\x51\x53\x5d\x5f\x59\x59\x5b\x58\x45\x58\x47\x5e\x45\x74\x13\x02\x02\x02\x02\x03\x03\x02\x02\x00\x01\x06\x06\x07\x04\x05\x1b\x19\x19\x06\x00\x01\x03\x02\x0c\x0c\x0d\x02\x03\x00\x01\x06\x07\x04\x05\x1b\x19\x1f\x1d\x13\x17\x15\x69\x6f\x6c\x6f\x6f\x63\x64\x73\x48\xd0\xf4\xf3\xe6\xe3\xeb\x97\x93\x9d\x9c\x98\x98\x85"));
# compact format
snd($sock_b, $port_a, rtp(96, 6002, 7640, 0x9876, "\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6001, 7160, $ssrc, "\x85\x84\x87\x86\x86\x86\x80\x81\x80\x80\x83\x83\x8d\x8d\x8d\x8c\x8d\x8c\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x82\x82\x82\x83\x83\x83\x83\x83\x80\x80\x80\x81\x81\x86\x86\x86\x87\x87\x84\x84\x84\x85\x9a\x9a\x9b\x98\x99\x9e\x9e\x9f\x9c\x9d\x92\x93\x90\x90\x91\x96\x97\x94\x95\xea\xeb\xe9\xee\xec\xe2\xe3\xe1\xe6\xe4\xe5\xfb\xfe\xfd\xf3\xf6\xf4\xc8\xcd\xc6\xdb\xdc\xd1\x55\x53\x5f\x5a\x41\x4d\x48\x74\x76\x70\x72\x7c\x7e\x7b\x65\x64\x66\x61\x60\x63\x62\x6c\x6f\x6e\x69\x68\x6b\x6a\x6a\x15\x15\x14\x14\x17\x17\x17\x16\x16\x11\x11\x11\x10\x10\x10\x10\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13"));



($sock_a, $sock_b) = new_call([qw(198.51.100.1 4056)], [qw(198.51.100.3 4058)]);

($port_a) = offer('EVS forward AMR mode-set',
	{ codec => { transcode => ['EVS/16000/1///evs-mode-switch=1;mode-set=2'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4056 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1; mode-set=2
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward AMR mode-set', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4058 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1; mode-set=2
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\xf1\x25\x1c\xa6\x31\xee\x69\xff\xd4\x16\x11\xbe\x62\xfa\x17\xe0\x88\x88\x8a\xaa\x88\x8e\x8c\x8a\x08\x02\x86\x8c\x8c\xa2\x02\x63"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\xf8\x73\x95\xfd\xee\x4f\x83\x48\x5c\x68\x9e\x24\x80\x91\xc9\xdb\x2a\x53\xc7\xb9\x0a\x36\x81\x8d\x00\x41\x81\x4f\x33\xf3\xcb\x9d"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\xf0\xa3\x9e\x13\x34\xd4\xd7\xf8\x95\x1b\x6d\x12\x85\xe0\xbf\xf4\xd5\xf4\x7a\xf1\xe4\xa5\xaa\x73\x34\x4d\xba\x05\x74\x93\x4d\x41"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\xf9\x41\x84\xa6\x30\xee\x84\xc8\x34\x40\x18\x15\xa1\xde\x1f\xe0\x88\x2a\xaa\xaa\xa8\x88\x8c\xae\xa8\x4e\x8e\x88\x88\xae\x48\x03"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\xfc\x73\x1a\x5e\x7c\x07\x87\xc9\x76\xd1\xb7\x71\x71\xa0\x75\x3e\xe2\x61\x41\xca\xfa\x68\x29\xe6\xf5\x34\xac\xae\x00\xf7\x7e\x41"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd4\xd7\xd4\xd6\xde\xc5\xda\xd9\xdc\xd3\x55\x50\x5d\x52\x52\x5f\x5c\x53\xd4\xdd\xdf\xdc\xd8\xc2\xcd\xc3\xc6\xdb\xdb\xc4\xc4\xd8\xdc\xdc\xdd\xd1\xd4\x54\x56\x51\x50\x50\x57\xdd\xc6\xcd\xc3\xc6\xc6\xc3\xc2\xc6\xd9\xd7\x55\x55\xd0\xcc\xf4\xf6\xf0\xf1\xcd\xd8\xdb\xdf\xd4\x5e\x5a\x5f\x56\x54\x54\x54\xdc\xc2\xc9\xcc\xc5\xdd\x54\x46\x77\x7c\x7b\x7b\x7f\x70\x49\x5e\xd7\xce\x65\x19\x06\x06\x1e\x69\x64\x71\xda\xfb\x95\x86\x8e\x8f\x87\x96\xe6\x60\x01\x08\x35\x0a\x0e\x01\x1c\x70\xe2\x9f\x84\x87\x9b\x96\xf6\x74\x6f\x11\x6e\x50\xe4\x94\x92\x98\x87\x80\x83\x80\x85\x96\xe4\xc8\xc5", "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd4\xd7\xd4\xd6\xde\xc5\xda\xd9\xdc\xd3\x55\x50\x5d\x52\x52\x5f\x5c\x53\xd4\xdd\xdf\xdc\xd8\xc2\xcd\xc3\xc6\xdb\xdb\xc4\xc4\xd8\xdc\xdc\xdd\xd1\xd4\x54\x56\x51\x50\x50\x57\xdd\xc6\xcd\xc3\xc6\xc6\xc3\xc2\xc6\xd9\xd7\x55\x55\xd0\xcc\xf4\xf6\xf1\xf1\xcd\xd8\xdb\xdf\xd4\x5e\x5a\x5f\x56\x54\x54\x54\xdc\xc2\xc9\xcc\xc5\xdd\x54\x46\x77\x7c\x7b\x7b\x7f\x70\x49\x5e\xd7\xce\x65\x19\x06\x06\x1e\x69\x64\x71\xda\xfb\x95\x86\x8e\x8f\x87\x96\xe6\x60\x01\x08\x35\x0a\x0e\x01\x1c\x70\xe2\x9f\x84\x87\x9b\x96\xf6\x74\x6f\x11\x6e\x50\xe4\x94\x92\x98\x87\x80\x83\x80\x85\x96\xe4\xc8\xc5"));






($sock_a, $sock_b) = new_call([qw(198.51.100.1 4060)], [qw(198.51.100.3 4062)]);

($port_a) = offer('EVS forward AMR mode-set higher',
	{ codec => { transcode => ['EVS/16000/1///evs-mode-switch=1;mode-set=7'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4060 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1; mode-set=7
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward AMR mode-set higher', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4062 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 evs-mode-switch=1; mode-set=7
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\xf1\x25\x1c\xa6\x31\xee\x69\xff\xd4\x16\x11\xbe\x62\xfa\x08\x8f\x04\x50\x52\x01\x43\x90\x0b\x09\xc7\xd1\x30\x04\x39\xd7\x74\xb1\x2d\x24\x90\x40\x4c\x5c\x12\x07\x41\x48\x08\x60\x00\x05\x61\xb3\x0d\x09\x5e\xc0\x5c\x58\x16\x9a\x88\x05"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\xfb\x73\x1c\xe4\x30\xe1\x83\x48\x5c\xf9\xde\x22\x80\x90\xff\xe7\x93\xbb\x82\xed\x13\x74\x33\xed\x18\xd2\xa3\x38\xec\x28\x65\x61\x40\x6a\x0e\xe4\x97\xc1\x51\x9a\xa4\x59\x62\x1d\xb9\xfd\xf7\x0c\xf5\xd4\x0c\x1f\xee\x08\xac\x90\x50\xf3"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\xf4\xa2\x90\x19\xbc\xf6\xc7\xf8\x95\x2a\x4d\x10\x81\xe5\x79\x7f\xed\x9f\x04\xd8\xd3\xdc\x9d\x67\xee\x36\xf3\xdb\xd9\xbb\x73\x59\x55\x97\xcf\x71\x40\xa4\x1f\x16\xb8\x7d\xd9\xf9\x82\x35\x13\x44\x87\x7d\xf2\x56\x0b\x8e\xad\xf8\xc0\x0d"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\xf9\x41\x84\xa6\x30\xee\x84\xc8\x34\x40\x18\x15\xa1\xde\x08\x49\x04\x71\x3c\x01\x45\x80\x59\x49\xcd\x59\x66\x34\x3f\xd3\xf4\xb1\x69\xbe\xf4\x54\x4e\xdc\x1b\x06\x43\xea\x88\x63\x70\x44\xa4\x70\xa8\x00\x3e\x40\x51\x98\x02\xd2\xb8\x89"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\xf8\x73\x26\x7e\x7a\x0e\x8b\xc9\x76\x40\xb7\x71\x71\xa5\xa4\x3a\x10\xcf\x01\x01\x50\x86\x49\x15\x1b\xf9\xda\x59\xaa\xbc\xa2\x13\x83\x84\x82\x91\x43\x00\x3d\x48\xc0\xa6\xc6\x20\x53\xfd\xfb\xf6\xbc\x34\xdd\x2c\x56\xda\x96\x34\xd4\xcb"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\x55\x55\x54\x57\xd5\x54\x53\x5e\x5b\x5b\x5c\x50\x52\x53\x55\xc4\xf4\xf1\xf7\xc2\xd8\xd3\x53\x58\x44\x4c\x4e\x4d\x47\x5a\x5e\x50\x56\x54\xd5\xd9\xc3\xc0\xc3\xcb\xf1\xf3\xf7\xc3\xd0\x53\x44\x4f\x75\x74\x77\x77\x4f\x58\x53\x54\xdf\xc8\xf1\xf0\xf3\xfd\xff\xfd\xf5\xd8\x51\x44\x49\x74\x77\x75\x48\x44\x57\xd0\xdc\xdb\xc9\xf7\xc8\xce\xcb\xf4\xf0\xff\xf1\xd9\x45\x40\xd4\xde\xdd\xd9\xf1\xf9\xf9\xfe\xf1\xc4\xde\xd6\x42\x73\x61\x6b\x6b\x6d\x61\x64\x7e\x59\xf3\xe0\xe9\x95\x94\x95\xec\xfe\x52\x7d\x64\x66\x69\x6c\x5d\xe4\xec\xe8\xef\xe7\xf8\xf4\xd1\x48\x79\x77\xc2\xe6\xe3\xe7\xf2\xf7\xfd"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4064)], [qw(198.51.100.3 4066)]);

($port_a) = offer('EVS forward CMR', { codec => { transcode => ['EVS'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4064 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0; dtx-recv=0
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward CMR', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4066 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 dtx=0;dtx-recv=0
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x0d\x67\x75\x43\x46\xc3\x10\x82\x03\x82\x02\x00\x00\x00\x5f\xf1\x9a\x2c\xd9\xea\x12\x46\x8b\xa0\x21\xd6\x1f\xd0\xc2\xb8\xa0\x61\xa0\x79\x25\x36\x57\x23\xbd\xd9\x01"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x0d\xe4\x73\x07\x88\x40\x03\x19\x43\xa3\x1d\xf7\xfb\x85\x89\xf4\xba\xee\x7e\x28\x4b\xf1\x89\x71\x33\xa1\xa6\xfe\xe5\xe3\x9d\x75\x95\x06\xea\xee\xb5\xc3\x75\x16\xa0"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x0d\xe4\x58\xcb\x9a\x50\x4b\x41\xb5\xd5\x58\xa9\xfa\x80\x99\x11\x05\x39\xae\x43\x80\x41\x1a\x41\x71\x3f\x62\x78\x64\xc1\x71\x61\xd7\x08\xfc\xad\xbe\x96\x3b\x00\x4a"));
snd($sock_a, $port_b, rtp(8, 2003, 4480, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2003, 4960, $ssrc, "\x0c\x5c\x44\x58\x04\x58\x01\x79\x5d\xae\x82\xcf\x82\x3b\x5e\xb0\x21\x80\x87\x1a\xc0\xc0\xaa\xf0\x16\xd8\x07\x94\x0e\xa7\x39\xa5\xe6\xe7\xec\x60\x4d\x41\x75\x86\xaf"));


snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x4d\xa6\xcb\xc6\xe0\x43\x2a\x80\x80\x80\x80\x80\x2f\xfc\x00\x00\x14\x03\x5a\xaf\x1c\xc8\x3e\xe1\x30\x92\x3a\x01\x80\x6a\xe7\x47\x61\x15\x00\x0e\x09\xdb\x02\xc5\x77"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x4d\x66\x8f\xf5\x3c\x01\x13\x87\x19\x19\xb4\x84\x9f\xe2\x6f\xe0\xfe\x93\x2f\x94\x12\x00\x04\x9e\x90\x81\xac\x9a\x67\x8c\x68\xb1\xa1\x9a\x09\x04\x64\xf0\xbc\x38\x20"));
($ssrc_b) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x57\x50\x53\x53\x53\x53\x53\x50\x51\x56\x57\x54\x55\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd6\xd0\xd0\xd3\xd3\xd0\xd1\xd1\xd6\xd6\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x54\x57\x51\x53\x5d\x5f\x59\x59\x5b\x58\x45\x58\x47\x5e\x45\x74\x13\x02\x02\x02\x02\x03\x03\x02\x02\x00\x01\x06\x06\x07\x04\x05\x1b\x19\x19\x06\x00\x01\x03\x02\x0c\x0c\x0d\x02\x03\x00\x01\x06\x07\x04\x05\x1b\x19\x1f\x1d\x13\x17\x15\x69\x6f\x6c\x6f\x6f\x63\x64\x73\x48\xd0\xf4\xf3\xe6\xe3\xeb\x97\x93\x9d\x9c\x98\x98\x85"));

# send CMR for mode 7, type 2
snd($sock_b, $port_a, rtp(96, 6002, 7640, 0x9876, "\xa7\x05\x4d\x6c\x25\x8d\x8e\x58\x0f\x04\x84\x8f\x89\xa5\xf8\xf0\x2f\x79\x67\x70\xea\xc1\x00\x17\xa5\xc8\xe2\x9d\x1a\x00\x04\x26\xeb\x73\x5f\x85\x00\x0c\x69\xb1\xff\xbe\x4a"));
rcv($sock_a, $port_b, rtpm(8, 6001, 7160, $ssrc_b, "\x85\x84\x87\x86\x86\x86\x80\x81\x80\x80\x83\x83\x8d\x8d\x8d\x8c\x8d\x8c\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x82\x82\x82\x83\x83\x83\x83\x83\x80\x80\x80\x81\x81\x86\x86\x86\x87\x87\x84\x84\x84\x85\x9a\x9a\x9b\x98\x99\x9e\x9e\x9f\x9c\x9d\x92\x93\x93\x90\x91\x96\x97\x94\x95\xea\xeb\xe9\xee\xec\xe2\xe3\xe1\xe6\xe4\xe5\xfb\xfe\xfd\xf3\xf6\xf4\xc8\xcd\xc6\xdb\xdc\xd1\x55\x53\x5f\x5a\x41\x4c\x48\x74\x76\x70\x72\x7c\x7e\x7b\x65\x64\x66\x61\x60\x63\x62\x6c\x6f\x6e\x69\x68\x6b\x6a\x6a\x15\x15\x14\x14\x17\x17\x17\x16\x16\x11\x11\x11\x10\x10\x10\x10\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13", "\x85\x84\x87\x86\x86\x86\x80\x81\x80\x80\x83\x83\x8d\x8d\x8d\x8c\x8d\x8c\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x82\x82\x82\x83\x83\x83\x83\x83\x80\x80\x80\x81\x81\x86\x86\x86\x87\x87\x84\x84\x84\x85\x9a\x9a\x9b\x98\x99\x9e\x9e\x9f\x9c\x9d\x92\x93\x90\x90\x91\x96\x97\x94\x95\xea\xeb\xe9\xee\xec\xe2\xe3\xe1\xe6\xe4\xe5\xfb\xfe\xfd\xf3\xf6\xf4\xc8\xcd\xc6\xdb\xdc\xd1\x55\x53\x5f\x5a\x41\x4d\x48\x74\x76\x70\x72\x7c\x7e\x7b\x65\x64\x66\x61\x60\x63\x62\x6c\x6f\x6e\x69\x68\x6b\x6a\x6a\x15\x15\x14\x14\x17\x17\x17\x16\x16\x11\x11\x11\x10\x10\x10\x10\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13"));

# now receive mode 6 (not 7, clamped by 8 kHz input)
snd($sock_a, $port_b, rtp(8, 2004, 4640, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2004, 5280, $ssrc, "\x0c\x4d\xe0\xe0\x3f\x98\x00\x71\x07\x3b\x15\xed\x95\x35\xaf\x37\x69\x0e\xce\xbf\xf7\x4f\x45\xe9\x79\x3b\x2b\xfc\xe1\xae\x63\xbc\x25\xe2\x70\x93\x53\x09\x9d\x14\x92\x11\xd4\x84\x41\x50\xa5\xe9\x34\x7b\x48\xa9\x80\x76\x58\x3e\x70\x90\x0c\xa6\x2f"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 4068)], [qw(198.51.100.3 4070)]);

($port_a) = offer('EVS forward br=5.9', { codec => { transcode => ['EVS/16000/1///hf-only=1;br=5.9'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4068 RTP/AVP 8 0
c=IN IP4 198.51.100.3
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1; br=5.9
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('EVS forward br=5.9', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 4070 RTP/AVP 96
c=IN IP4 198.51.100.3
a=rtpmap:96 EVS/16000
a=fmtp:96 hf-only=1;br=5.9
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(8, 2000, 4000, 0x3456, "\x2b" x 160));
($ssrc) = rcv($sock_b, $port_a, rtpm(96, 2000, 4000, -1, "\x01\x0b\x1d\x39\xa4\x08\x74\x00\x10\x07\xbe\x9c\x3f\x04\x0e\x80\x00\x78\x0b"));
snd($sock_a, $port_b, rtp(8, 2001, 4160, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2001, 4320, $ssrc, "\x01\x0f\x22\x75\x31\x88\x07\x84\x9f\xf8\x18\x2c\x66\x66\xcf\x84\x9d\xec\x1c"));
snd($sock_a, $port_b, rtp(8, 2002, 4320, 0x3456, "\x2b" x 160));
rcv($sock_b, $port_a, rtpm(96, 2002, 4640, $ssrc, "\x01\x0f\x21\x9e\x0b\xa8\xf4\xb9\xb7\x6e\x20\x4a\x7b\xd7\x07\x02\xba\x97\x04"));

snd($sock_b, $port_a, rtp(96, 6000, 7000, 0x9876, "\x01\x68\x2a\xb4\xd8\x2c\x74\x00\x10\x07\xdf\x1c\x57\x04\x93\x3f\x68\x60\x03"));
Time::HiRes::usleep(20000); # no output, resampling delay
snd($sock_b, $port_a, rtp(96, 6001, 7320, 0x9876, "\x01\x9b\x8c\xe1\xe2\x11\x1d\xdd\x9e\x01\x2c\x2f\x10\xcc\x0f\x46\x24\x45\xeb"));
($ssrc) = rcv($sock_a, $port_b, rtpm(8, 6000, 7000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x54\x55\x55\xd5\x54\xd5\x56\x5d\x5b\x64\x66\x65\x66\x7a\x60\x15\x6b\x68\x6b\x69\x6e\x69\x6e\x6f\x6c\x62\x60\x61\x67\x64\x7a\x79\x7c\x73\x77\x49\x46\x5e\x57\xd6\xdb\xc5\xc9\xd4\x47\xd4\xd4\xd2\xde\x43\x76\x77\x7e\x65\x66\x6c\x6e\x6f\x68\x68\x63\x62\x62\x67\x65\x64\x7f\x73\x72\x72"));





($sock_a, $sock_b) = new_call([qw(198.51.100.1 2020)], [qw(198.51.100.3 2022)]);

offer('media playback, HF only', { ICE => 'remove', replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.1
s=tester
t=0 0
m=audio 2020 RTP/AVP 126
c=IN IP4 198.51.100.1
a=sendrecv
a=rtpmap:126 EVS/16000/1
a=fmtp:126 hf-only=1; br=5.9-24.4; bw=nb-swb
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 126
c=IN IP4 203.0.113.1
a=rtpmap:126 EVS/16000
a=fmtp:126 hf-only=1; br=5.9-24.4; bw=nb-swb
a=sendrecv
a=rtcp:PORT
SDP

answer('media playback, HF only', { replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 2022 RTP/AVP 126
c=IN IP4 198.51.100.3
a=sendrecv
a=rtpmap:126 EVS/16000/1
a=fmtp:126 hf-only=1;br=5.9-24.4;bw=nb-swb
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 126
c=IN IP4 203.0.113.1
a=rtpmap:126 EVS/16000
a=fmtp:126 hf-only=1; br=5.9-24.4; bw=nb-swb
a=sendrecv
a=rtcp:PORT
SDP


$resp = rtpe_req('play media', 'media playback, HF only', { 'from-tag' => ft(), blob => $wav_file });
is $resp->{duration}, 100, 'media duration';

(undef, $seq, $ts, $ssrc) = rcv($sock_a, -1, rtpm(126 | 0x80, -1, -1, -1, "\x01\xe2\xaa\xbf\x4b\xc3\xdc\x7d\x28\xb7\xbf\xdb\xf9\xb9\x8a\x33\xb3\x72\x32"));
rcv($sock_a, -1, rtpm(126, $seq + 1, $ts + 320 * 1, $ssrc, "\x01\xe1\xd9\xfe\x9e\x40\x00\x44\x38\x49\x41\xa5\x65\x15\xa2\x89\xa0\x5d\xc3"));
rcv($sock_a, -1, rtpm(126, $seq + 2, $ts + 320 * 2, $ssrc, "\x01\xe1\x52\x19\x12\x54\x2a\xfb\x5a\x0f\x44\x8d\x72\xc8\xc6\x36\x13\x59\xc2"));
rcv($sock_a, -1, rtpm(126, $seq + 3, $ts + 320 * 3, $ssrc, "\x01\xe1\x56\x91\xa2\x55\x55\x5b\xcf\x07\x36\x37\x26\xdd\x12\xb4\x7f\xc3\xc2"));
rcv($sock_a, -1, rtpm(126, $seq + 4, $ts + 320 * 4, $ssrc, "\x01\xe1\x52\x90\xd1\x2a\xaa\xbe\xcb\x83\x4d\x34\xc6\x09\xe6\xa6\x77\x5f\x00"));




($sock_a, $sock_b) = new_call([qw(198.51.100.1 2024)], [qw(198.51.100.3 2026)]);

offer('media playback, compact with zero padding', { ICE => 'remove', replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.1
s=tester
t=0 0
m=audio 2024 RTP/AVP 126
c=IN IP4 198.51.100.1
a=sendrecv
a=rtpmap:126 EVS/16000/1
a=fmtp:126 cmr=1; br=5.9-24.4; bw=nb-swb
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 126
c=IN IP4 203.0.113.1
a=rtpmap:126 EVS/16000
a=fmtp:126 cmr=1; br=5.9-24.4; bw=nb-swb
a=sendrecv
a=rtcp:PORT
SDP

answer('media playback, compact with zero padding', { replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.3
s=tester
t=0 0
m=audio 2026 RTP/AVP 126
c=IN IP4 198.51.100.3
a=sendrecv
a=rtpmap:126 EVS/16000/1
a=fmtp:126 br=5.9-24.4;bw=nb-swb;cmr=1
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 126
c=IN IP4 203.0.113.1
a=rtpmap:126 EVS/16000
a=fmtp:126 cmr=1; br=5.9-24.4; bw=nb-swb
a=sendrecv
a=rtcp:PORT
SDP


$resp = rtpe_req('play media', 'media playback, compact with zero padding', { 'from-tag' => ft(), blob => $wav_file });
is $resp->{duration}, 100, 'media duration';

(undef, $seq, $ts, $ssrc) = rcv($sock_a, -1, rtpm(126 | 0x80, -1, -1, -1, "\xff\x01\xe2\xaa\xbf\x4b\xc3\xdc\x7d\x28\xb7\xbf\xdb\xf9\xb9\x8a\x33\xb3\x72\x32\x00"));
rcv($sock_a, -1, rtpm(126, $seq + 1, $ts + 320 * 1, $ssrc, "\xff\x01\xe1\xd9\xfe\x9e\x40\x00\x44\x38\x49\x41\xa5\x65\x15\xa2\x89\xa0\x5d\xc3\x00"));
rcv($sock_a, -1, rtpm(126, $seq + 2, $ts + 320 * 2, $ssrc, "\xff\x01\xe1\x52\x19\x12\x54\x2a\xfb\x5a\x0f\x44\x8d\x72\xc8\xc6\x36\x13\x59\xc2\x00"));
rcv($sock_a, -1, rtpm(126, $seq + 3, $ts + 320 * 3, $ssrc, "\xff\x01\xe1\x56\x91\xa2\x55\x55\x5b\xcf\x07\x36\x37\x26\xdd\x12\xb4\x7f\xc3\xc2\x00"));
rcv($sock_a, -1, rtpm(126, $seq + 4, $ts + 320 * 4, $ssrc, "\xff\x01\xe1\x52\x90\xd1\x2a\xaa\xbe\xcb\x83\x4d\x34\xc6\x09\xe6\xa6\x77\x5f\x00\x00"));


#done_testing;NGCP::Rtpengine::AutoTest::terminate('f00');exit;
done_testing();
