#include <assert.h>
#include "powerup.h"
#include "datafun.h"
#include "guru_meditation.h"
#include "random_gen.h"
#include "rockdodger_globals.h"

static sdl_surfaces_t *surf_laserpowerup; //!< surfaces for laser powerup
static sdl_surfaces_t *surf_shieldpowerup; //!< surfaces for shield powerup
static sdl_surfaces_t *surf_lifepowerup; //!< surfaces for life powerup

static powerup_t powerup;


powerup_types_t get_current_powerup(void) {
  return powerup.active;
}


powerup_t *init_powerup() {
  //laserpowerup: load images and set color key for transparency
  puts("Laserpowerups ");
  surf_laserpowerup = load_images_ck("laserpowerup.%02X.png", 0, 0, 255);
  if(surf_laserpowerup == NULL) {
#ifndef DEBUG
    guru_meditation(GM_FLAGS_DEADEND, GM_SS_Graphics | GM_GE_IOError | GURU_SEC_powerup, (void*)0x4c415345);
#endif
    return NULL;
  }
  //shieldpowerup: load image and set color key for transparency
  puts("Shieldpowerups ");
  surf_shieldpowerup = load_images_ck("shieldpowerup.%02X.png", 0, 0, 255);
  if(surf_shieldpowerup == NULL) {
#ifndef DEBUG
    guru_meditation(GM_FLAGS_DEADEND, GM_SS_Graphics | GM_GE_IOError | GURU_SEC_powerup, (void*)0x53484945);
#endif
    return NULL;
  }
  //Life Powerup
  puts("Lifepowerups");
  surf_lifepowerup = load_images_ck("lifepowerup.%02X.ilbm", 0, 255, 0);
  if(surf_lifepowerup == NULL) {
#ifndef DEBUG
    guru_meditation(GM_FLAGS_DEADEND, GM_SS_Graphics | GM_GE_IOError | GURU_SEC_powerup, (void*)0x4c494645);
#endif
    return NULL;
  }
  deactivate_powerup();
#ifdef DEBUG
  printf("surf_laserpowerup=%p surf_shieldpowerup=%p surf_lifepowerup=%p\n", surf_laserpowerup, surf_shieldpowerup, surf_lifepowerup);
#endif
  return &powerup;
}

void shutdown_powerups() {
  deactivate_powerup();
#ifdef DEBUG
  printf("surf_laserpowerup=%p surf_shieldpowerup=%p surf_lifepowerup=%p\n", surf_laserpowerup, surf_shieldpowerup, surf_lifepowerup);
#endif
  assert(surf_laserpowerup);
  assert(surf_shieldpowerup);
  assert(surf_lifepowerup);  
  destroy_sdl_surfaces(surf_laserpowerup);
  destroy_sdl_surfaces(surf_shieldpowerup);
  destroy_sdl_surfaces(surf_lifepowerup);  
}

SDL_Surface *get_powerup_surface() {
  SDL_Surface *source;
  sdl_surfaces_t *surfaces = NULL;

  switch(get_current_powerup()) {
  case POWERUP_LASER:
    surfaces = surf_laserpowerup;
    break;
  case POWERUP_SHIELD:
    surfaces = surf_shieldpowerup;
    break;
  case POWERUP_LIFE:
    surfaces = surf_lifepowerup;
    break;
  case POWERUP_NONE:
    assert(0);
    guru_meditation(GM_FLAGS_DEADEND | GM_FLAGS_ABORTIFY, GM_SS_Graphics | GM_GE_BadParm | GURU_SEC_powerup, &get_powerup_surface);
    return NULL;
    break;
  }
  assert(surfaces);
  source = surfaces->surfaces[(unsigned short)powerup.img_ctr % surfaces->num_surfaces];  
  return source;
}

void display_powerup(SDL_Surface * surf_screen) {
  SDL_Rect dest;
  SDL_Surface *source;

  dest.w = 0; //powersurf->w;
  dest.h = 0; //powersurf->h;
  dest.x = powerup.x;
  dest.y = powerup.y;
  source = get_powerup_surface();
  SDL_BlitSurface(source, NULL, surf_screen, &dest);
}

void deactivate_powerup() {
  powerup.active = POWERUP_NONE;
  powerup.countdown = POWERUPDELAY;
  powerup.img_ctr = 0;
}

void update_powerup() {
  if(powerup.active != POWERUP_NONE) {
    SDL_Surface *surf = get_powerup_surface();
    powerup.x += powerup.dx * movementrate;
    powerup.y += powerup.dy * movementrate;
    if(powerup.x < -surf->w
       || powerup.y < -surf->h
       || powerup.x > xsize
       || powerup.y > ysize) {
      deactivate_powerup();
    }
  } else {
    powerup.countdown -= movementrate;
    if(powerup.countdown < 0 && rnd() < .3) {
      powerup.x = xsize;
      powerup.dx = -(3 + rnd() * 5);
      powerup.dy = .5 + rnd() * 3;
      if((powerup.y = rnd() * ysize) >= ysize / 2)
	powerup.dy = -powerup.dy;
      if(current_edition == EDITION_yellifish && rnd() < 0.051807) {
	powerup.active = POWERUP_LIFE;
      } else if(rnd() < .7) {
	powerup.active = POWERUP_LASER;
      } else {
	powerup.active = POWERUP_SHIELD;
      }
      assert(powerup.active != POWERUP_NONE);
    }
  }
  powerup.img_ctr += movementrate;
}
