set terminal pslatex color auxfile
set output "p-laplacian-damped-newton-p=1,5.tex"

set size square 0.8
set log y

set xtics (0,5,10,15)
set ytics (\
        "[r]{$10^{-15}$}" 1e-15, \
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{0}$}" 1 )
set xlabel "[c]{$n$}"
set  label "[r]{\\Large $\\|r_h\\|_{L^2}$}" at graph -0.05,0.50

plot [0:15][1e-15:100] \
"p-laplacian-damped-newton-n=10-p=1.5.gdat" u 1:($2) title  "[r]{$10\\times 10$}" w lp, \
"p-laplacian-damped-newton-n=20-p=1.5.gdat" u 1:($2) title  "[r]{$20\\times 20$}" w lp, \
"p-laplacian-damped-newton-n=30-p=1.5.gdat" u 1:($2) title  "[r]{$30\\times 30$}" w lp, \
"p-laplacian-damped-newton-n=40-p=1.5.gdat" u 1:($2) title  "[r]{$40\\times 40$}" w lp, \
"p-laplacian-damped-newton-n=50-p=1.5.gdat" u 1:($2) title  "[r]{$50\\times 50$}" w lp

#pause -1 "<retour>"

