% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psiplot-package.R
\docType{package}
\name{psiplot}
\alias{psiplot}
\alias{psiplot-package}
\title{Produce PSI and GE plots based on output from vast-tools}
\description{
\code{psiplot} is an R package for generating plots of percent spliced-in (PSI)
values of alternatively spliced exons. It requires input from
\href{https://www.github.com/vastgroup/vast-tools}{VAST-TOOLS}, an RNA-Seq
pipeline for alternative splicing analysis.
}
\details{
This package uses input data generated by vast-tools. A sample dataset
(\code{psi}, \code{crpkm} and \code{crpkm_counts}) and sample configuration file
(\code{config}) is provided.

The main functions to generate plots is \code{\link{plot_event}} and
\code{\link{plot_expr}} for PSI and cRPKM values, respectively. Two other
functions, \code{\link{plot_multievent}} and \code{\link{plot_multi}}, allow
plotting of multiple events in scatterplots or heatmaps.

\code{\link{plot_multi}} can be used to plot multiple events in the form
of a heatmap.

See \code{vignette('psiplot-usage', package="psiplot")} for usage details.

Report bugs and issues to \url{https://github.com/kcha/psiplot/issues}.
}
\examples{
library(psiplot)
plot_event(psi[1,])
plot_event(psi[1,], config=config, subg=FALSE)
plot_expr(crpkm[1,])
plot_expr(crpkm[1,], config=config)
}
\seealso{
\url{https://www.github.com/kcha/psiplot}

\url{https://www.github.com/vastgroup/vast-tools}

\url{https://www.vastdb.crg.eu}
}
