% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R
\name{vec_default_cast}
\alias{vec_default_cast}
\title{Default cast method}
\usage{
vec_default_cast(x, to, x_arg = "x", to_arg = "to")
}
\arguments{
\item{x}{Vectors to cast.}

\item{to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}

\item{x_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{to_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\description{
This function should typically be called from the default
\code{\link[=vec_cast]{vec_cast()}} method for your class, e.g. \code{vec_cast.myclass.default()}.
It does two things:
\itemize{
\item If \code{x} is an \link{unspecified} vector, it automatically casts it to
\code{to} using \code{\link[=vec_init]{vec_init()}}.
\item Otherwise, an error is thrown with \code{\link[=stop_incompatible_cast]{stop_incompatible_cast()}}.
}
}
