% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{editCalls}
\alias{editCalls}
\alias{editCalls,unitizer,language,language-method}
\title{Edit Calls In Unitizer}
\usage{
editCalls(x, lang.old, lang.new, ...)

\S4method{editCalls}{unitizer,language,language}(
  x,
  lang.old,
  lang.new,
  interactive.mode = interactive(),
  interactive.only = TRUE,
  ...
)
}
\arguments{
\item{x}{a unitizer object}

\item{lang.old}{the name of the function replace}

\item{lang.new}{the new name of the function}

\item{...}{unused}

\item{interactive.mode}{logical(1L) whether to run in interactive mode (
request user input when needed) or not (error if user input is required,
e.g. if all tests do not pass).}

\item{interactive.only}{logical(1L) set to FALSE if you want to allow this to
run in non-interactive mode, but warnings will be suppressed and will
proceed without prompting, obviously...}
}
\value{
a untizer object with function names modifies
}
\description{
Used if you want to change language in test expression in a unitizer when
the actual results of running the expressions is unchanged.  This is useful
if you decided to rename functions, etc., without having to re-run the entire
\code{unitize} process since \code{unitize} matches tests based on
expressions.
}
\note{
this is a somewhat experimental function, so make sure you backup any
  unitizers before you try to use it.
}
\examples{
\dontrun{
untz <- get_unitizer("tests/unitizer/mytests.unitizer")
untz.edited <- editCalls(untz, quote(myFun), quote(my_fun))
set_unitizer("tests/unitizer/mytests.unitizer", untz.edited)
}
}
