% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{[[.Seurat}
\alias{[[.Seurat}
\alias{head.Seurat}
\alias{tail.Seurat}
\title{Subobjects and Cell-Level Meta Data}
\usage{
\method{[[}{Seurat}(x, i = missing_arg(), ..., drop = FALSE, na.rm = FALSE)

\method{head}{Seurat}(x, n = 10L, ...)

\method{tail}{Seurat}(x, n = 10L, ...)
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{i}{Name of cell-level meta data}

\item{...}{Ignored}

\item{drop}{See \code{\link[base]{drop}}}

\item{na.rm}{Remove cells where meta data is all \code{NA}}

\item{n}{Number of meta data rows to show}
}
\value{
Varies based on the value of \code{i}:
\itemize{
 \item If \code{i} is missing, a data frame with cell-level meta data
 \item If \code{i} is a vector with cell-level meta data names, a data frame
  (or vector of \code{drop = TRUE}) with cell-level meta data requested
 \item If \code{i} is a one-length character with the
  \link[=names.Seurat]{name of a subobject}, the
  subobject specified by \code{i}
}

\code{head}: The first \code{n} rows of cell-level metadata

\code{tail}: The last \code{n} rows of cell-level metadata
}
\description{
The \code{[[} operator pulls either subobjects
(eg. \link[=Assay]{v3} or \link[=Assay5]{v5} assays,
\link[=DimReduc]{dimensional reduction} information,
or \link[=Graph]{nearest-neighbor graphs}) or cell-level
meta data from a \code{\link{Seurat}} object
}
\examples{
# Get the cell-level metadata data frame
head(pbmc_small[[]])

# Pull specific metadata information
head(pbmc_small[[c("letter.idents", "groups")]])
head(pbmc_small[["groups", drop = TRUE]])

# Get a sub-object (eg. an `Assay` or `DimReduc`)
pbmc_small[["RNA"]]
pbmc_small[["pca"]]

# Get the first 10 rows of cell-level metadata
head(pbmc_small)

# Get the last 10 rows of cell-level metadata
tail(pbmc_small)

}
\seealso{
See \link[=$.Seurat]{here} for adding meta data with \code{[[<-},
\link[=[[<-,Seurat]{here} for adding subobjects with \code{[[<-}, and
\link[=[[<-,Seurat,NULL]{here} for removing subobjects and cell-level meta
data with \code{[[<-}

Seurat object, validity, and interaction methods
\code{\link{$.Seurat}()},
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[<-,Seurat}},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{dim.Seurat}()},
\code{\link{dimnames.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{names.Seurat}()},
\code{\link{subset.Seurat}()}
}
\concept{seurat}
