% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-step.R
\name{forward}
\alias{forward}
\title{Forward Request to The Next Handler}
\usage{
forward()
}
\description{
This function is used when a filter is done processing a request and wishes
to pass control off to the next handler in the chain. If this is not called
by a filter, the assumption is that the filter fully handled the request
itself and no other filters or endpoints should be evaluated for this
request. \code{forward()} cannot be used within handlers to trigger the next
matching handler in the router. It only has relevance for filters.
}
\examples{
\dontrun{
pr() \%>\%
  pr_filter("foo", function(req, res) {
    print("This is filter foo")
    forward()
  }) \%>\%
  pr_run()
}

}
