% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{glue_col}
\alias{glue_col}
\alias{glue_data_col}
\title{Construct strings with color}
\usage{
glue_col(..., .envir = parent.frame(), .na = "NA")

glue_data_col(.x, ..., .envir = parent.frame(), .na = "NA")
}
\arguments{
\item{...}{[\code{expressions}]\cr Expressions string(s) to format, multiple inputs are concatenated together before formatting.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored.}

\item{.na}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace NA values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}

\item{.x}{[\code{listish}]\cr An environment, list or data frame used to lookup values.}
}
\description{
The \link[crayon:crayon]{crayon} package defines a number of functions used to
color terminal output. \code{glue_col()} and \code{glue_data_col()} functions provide
additional syntax to make using these functions in glue strings easier.

Using the following syntax will apply the function \code{blue} function to the text 'foo bar'.\preformatted{{blue foo bar}
}

If you want an expression to be evaluated, simply place that in a normal brace
expression (these can be nested).\preformatted{{blue 1 + 1 = {1 + 1}}
}
}
\examples{
if (require(crayon)) {
  glue_col("{blue foo bar}")

  glue_col("{blue 1 + 1 = {1 + 1}}")

  white_on_grey <- bgBlack $ white
  glue_col("{white_on_grey
    Roses are {red {colors()[[552]]}}
    Violets are {blue {colors()[[26]]}}
    `glue_col()` can show {red c}{yellow o}{green l}{cyan o}{blue r}{magenta s}
    and {bold bold} and {underline underline} too!
    }")
}
}
