% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{formatVC}
\alias{formatVC}
\title{Format the 'VarCorr' Matrix of Random Effects}
\usage{
formatVC(
  varcor,
  digits = max(3, getOption("digits") - 2),
  comp = "Std.Dev.",
  formatter = format,
  useScale = attr(varcor, "useSc"),
  ...
)
}
\arguments{
\item{varcor}{a \code{\link{VarCorr}} (-like) matrix with attributes.}

\item{digits}{the number of significant digits.}

\item{comp}{character vector of length one or two indicating which
columns out of "Variance" and "Std.Dev." should be shown in the
formatted output.}

\item{formatter}{the \code{\link{function}} to be used for
formatting the standard deviations and or variances (but
\emph{not} the correlations which (currently) are always formatted
as "0.nnn"}

\item{useScale}{whether to report a scale parameter (e.g. residual standard deviation)}

\item{...}{optional arguments for \code{formatter(*)} in addition
to the first (numeric vector) and \code{digits}.}
}
\value{
a character matrix of formatted VarCorr entries from \code{varc}.
}
\description{
"format()" the 'VarCorr' matrix of the random effects -- for
print()ing and show()ing
}
