% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_centrality.R
\name{layout_tbl_graph_centrality}
\alias{layout_tbl_graph_centrality}
\title{Place nodes in circles according to centrality measure}
\usage{
layout_tbl_graph_centrality(
  graph,
  centrality,
  scale = TRUE,
  niter = 500,
  tolerance = 1e-04,
  tseq = seq(0, 1, 0.2),
  group = NULL,
  shrink = 10,
  circular = FALSE
)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{centrality}{An expression evaluating to a centrality measure for the
nodes. See the different \verb{centrality_*()} algorithms in tidygraph for a
selection.}

\item{scale}{Should the centrality measure be scaled between 0 and 100}

\item{niter}{number of iterations during stress optimization}

\item{tolerance}{stopping criterion for stress optimization}

\item{tseq}{Transitioning steps}

\item{group}{An expression evaluating to a grouping of the nodes. If given
the layout will keep grouped nodes within an angle range of the origin}

\item{shrink}{shrink the reserved angle range for a group to increase the
gaps between groups}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular}, \code{centrality} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout places nodes in circles with the radii relative to a given
centrality measure. Under the hood it use stress majorisation to place nodes
optimally given the radius constraint.
}
\references{
Brandes, U., & Pich, C. (2011). \emph{More flexible radial layout.} Journal of
Graph Algorithms and Applications, 15(1), 157-173.
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_cactustree}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_htree}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_metro}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
