% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fontset.R
\name{fontset_variants}
\alias{fontset_styles}
\alias{fontset_variants}
\title{Fontset variants and styles}
\usage{
fontset_variants(fontset)

fontset_styles(fontset, variant)
}
\arguments{
\item{fontset}{A string giving the name of a set of fonts
(e.g. \code{"Liberation"} or\code{"Bitstream Vera"}). Use
\code{\link{fontset_list}()} to obtain the list of fontsets
registered in your session.}

\item{variant}{Font variant, as per Fontconfig's nomenclature. Use
\code{\link{fontset_variants}()} to find out which variants are
available for a fontset.}
}
\description{
These functions return the variants and the styles available for a
given fontset.
}
\examples{
fontset_variants("Liberation")
fontset_styles("Bitstream Vera", "Sans Mono")
}

