% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_nest.R
\name{group_nest}
\alias{group_nest}
\title{Nest a tibble using a grouping specification}
\usage{
group_nest(.tbl, ..., .key = "data", keep = FALSE)
}
\arguments{
\item{.tbl}{A tbl}

\item{...}{Grouping specification, forwarded to \code{\link[=group_by]{group_by()}}}

\item{.key}{the name of the list column}

\item{keep}{Should the grouping columns be kept in the list column.}
}
\value{
A tbl with one row per unique combination of the grouping variables.
The first columns are the grouping variables, followed by a list column of tibbles
with matching rows of the remaining columns.
}
\description{
Nest a tibble using a grouping specification
}
\details{
\Sexpr[results=rd, stage=render]{dplyr:::lifecycle("experimental")}
}
\section{Grouped data frames}{


The primary use case for \code{\link[=group_nest]{group_nest()}} is with already grouped data frames,
typically a result of \code{\link[=group_by]{group_by()}}. In this case \code{\link[=group_nest]{group_nest()}} only uses
the first argument, the grouped tibble, and warns when \code{...} is used.
}

\section{Ungrouped data frames}{


When used on ungrouped data frames, \code{\link[=group_nest]{group_nest()}} forwards the \code{...} to
\code{\link[=group_by]{group_by()}} before nesting, therefore the \code{...} are subject to the data mask.
}

\examples{

#----- use case 1: a grouped data frame
iris \%>\%
  group_by(Species) \%>\%
  group_nest()

# this can be useful if the grouped data has been altered before nesting
iris \%>\%
  group_by(Species) \%>\%
  filter(Sepal.Length > mean(Sepal.Length)) \%>\%
  group_nest()

#----- use case 2: using group_nest() on a ungrouped data frame with
#                  a grouping specification that uses the data mask
starwars \%>\%
  group_nest(species, homeworld)


}
\seealso{
Other grouping functions: \code{\link{group_by_all}},
  \code{\link{group_by}}, \code{\link{group_indices}},
  \code{\link{group_keys}}, \code{\link{group_map}},
  \code{\link{group_rows}}, \code{\link{group_size}},
  \code{\link{group_trim}}, \code{\link{groups}}
}
\concept{grouping functions}
\keyword{internal}
