% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gev.R
\name{dist_gev}
\alias{dist_gev}
\title{The Generalized Extreme Value Distribution}
\usage{
dist_gev(location, scale, shape)
}
\arguments{
\item{location}{the location parameter \eqn{a} of the GEV distribution.}

\item{scale}{the scale parameter \eqn{b} of the GEV distribution.}

\item{shape}{the shape parameter \eqn{s} of the GEV distribution.}
}
\description{
The GEV distribution function with parameters \eqn{\code{location} = a},
\eqn{\code{scale} = b} and \eqn{\code{shape} = s} is
}
\details{
\deqn{F(x) = \exp\left[-\{1+s(x-a)/b\}^{-1/s}\right]}

for \eqn{1+s(x-a)/b > 0}, where \eqn{b > 0}. If \eqn{s = 0} the distribution
is defined by continuity, giving

\deqn{F(x) = \exp\left[-\exp\left(-\frac{x-a}{b}\right)\right]}

The support of the distribution is the real line if \eqn{s = 0},
\eqn{x \geq a - b/s} if \eqn{s \neq 0}, and
\eqn{x \leq a - b/s} if \eqn{s < 0}.

The parametric form of the GEV encompasses that of the Gumbel, Frechet and
reverse Weibull distributions, which are obtained for \eqn{s = 0},
\eqn{s > 0} and \eqn{s < 0} respectively. It was first introduced by
Jenkinson (1955).
}
\examples{
dist <- dist_gev(location = 0, scale = 1, shape = 0)
}
\references{
Jenkinson, A. F. (1955) The frequency distribution of the annual
maximum (or minimum) of meteorological elements. \emph{Quart. J. R. Met. Soc.},
\bold{81}, 158–171.
}
\seealso{
\code{\link[evd]{gev}}
}
