% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-oo-api.R
\name{desc_del_author}
\alias{desc_del_author}
\title{Remove one or more authors from DESCRIPTION.}
\usage{
desc_del_author(
  given = NULL,
  family = NULL,
  email = NULL,
  role = NULL,
  comment = NULL,
  orcid = NULL,
  file = ".",
  normalize = FALSE
)
}
\arguments{
\item{given}{Given name to filter on. Regular expression.}

\item{family}{Family name to filter on. Regular expression.}

\item{email}{Email address to filter on. Regular expression.}

\item{role}{Role to filter on. Regular expression.}

\item{comment}{Comment field to filter on. Regular expression.}

\item{orcid}{ORCID field to filter on.}

\item{file}{DESCRIPTION file to use. By default the DESCRIPTION
file of the current package (i.e. the package the working directory
is part of) is used.}

\item{normalize}{Whether to normalize the write when writing back
the result. See \code{\link{desc_normalize}}.}
}
\description{
It uses the Authors@R field. The author(s) to be removed
can be specified via any field(s). All authors matching all
specifications will be removed. E.g. if only \code{given = "Joe"}
is supplied, then all authors whole given name matches \code{Joe} will
be removed. The specifications can be (PCRE) regular expressions.
}
\seealso{
Other Authors@R: 
\code{\link{desc_add_author_gh}()},
\code{\link{desc_add_author}()},
\code{\link{desc_add_me}()},
\code{\link{desc_add_orcid}()},
\code{\link{desc_add_role}()},
\code{\link{desc_change_maintainer}()},
\code{\link{desc_coerce_authors_at_r}()},
\code{\link{desc_del_role}()},
\code{\link{desc_get_authors}()},
\code{\link{desc_get_author}()},
\code{\link{desc_get_maintainer}()},
\code{\link{desc_set_authors}()}
}
\concept{Authors@R}
