# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtNetworkAnchorsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_list_by_subscription(self, resource_group):
        response = self.client.network_anchors.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_begin_create_or_update(self, resource_group):
        response = self.client.network_anchors.begin_create_or_update(
            resource_group_name=resource_group.name,
            network_anchor_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "resourceAnchorId": "str",
                    "subnetId": "str",
                    "cidrBlock": "str",
                    "dnsForwardingEndpointIpAddress": "str",
                    "dnsForwardingEndpointNsgRulesUrl": "str",
                    "dnsForwardingRules": [{"domainNames": "str", "forwardingIpAddress": "str"}],
                    "dnsForwardingRulesUrl": "str",
                    "dnsListeningEndpointAllowedCidrs": "str",
                    "dnsListeningEndpointIpAddress": "str",
                    "dnsListeningEndpointNsgRulesUrl": "str",
                    "isOracleDnsForwardingEndpointEnabled": bool,
                    "isOracleDnsListeningEndpointEnabled": bool,
                    "isOracleToAzureDnsZoneSyncEnabled": bool,
                    "ociBackupCidrBlock": "str",
                    "ociSubnetId": "str",
                    "ociVcnDnsLabel": "str",
                    "ociVcnId": "str",
                    "provisioningState": "str",
                    "vnetId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_get(self, resource_group):
        response = self.client.network_anchors.get(
            resource_group_name=resource_group.name,
            network_anchor_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_begin_update(self, resource_group):
        response = self.client.network_anchors.begin_update(
            resource_group_name=resource_group.name,
            network_anchor_name="str",
            properties={
                "properties": {
                    "isOracleDnsForwardingEndpointEnabled": bool,
                    "isOracleDnsListeningEndpointEnabled": bool,
                    "isOracleToAzureDnsZoneSyncEnabled": bool,
                    "ociBackupCidrBlock": "str",
                },
                "tags": {"str": "str"},
                "zones": ["str"],
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_begin_delete(self, resource_group):
        response = self.client.network_anchors.begin_delete(
            resource_group_name=resource_group.name,
            network_anchor_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_anchors_list_by_resource_group(self, resource_group):
        response = self.client.network_anchors.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
