/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_RANDOM_HPP
#define yf_RANDOM_HPP
//---------------------------------------------------------------------------
#include <yf/defs.hpp>
#ifdef YF_ENABLE_CHECKS
	#include <yf/exception/exception.hpp>
#endif
//------------------------------------------------------------------------------
namespace yf
{
	namespace random
	{
		void rnd_init();

		bool rnd_bool();
		byte rnd_byte();

		uint16 rnd_uint16(uint16 border);
		sint16 rnd_sint16(uint16 border);
		uint32 rnd_uint32(uint32 border);
		sint32 rnd_sint32(uint32 border);

		uint16 rnd_uint16();
		sint16 rnd_sint16();
		uint32 rnd_uint32();
		sint32 rnd_sint32();

		uint64 rnd_uint64();
		sint64 rnd_sint64();

		sint32 rnd_in_range(sint32 start, sint32 stop);

		double rnd_0_1();
		double rnd_double(double border);

		void rnd_mem(void* ptr, size_t size);

		char rnd_decimal_digit();
		char rnd_small_latin_character();
		char rnd_big_lation_character();
		char rnd_latin_character();
	}
}
#endif
