/* $Id: TMgr_Message.hpp 371635 2012-08-09 17:42:05Z clausen $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_Message.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: TMgr_Message_.hpp


#ifndef INTERNAL_TRACKMGR_OBJECTS_TRACKMGR_TMGR_MESSAGE_HPP
#define INTERNAL_TRACKMGR_OBJECTS_TRACKMGR_TMGR_MESSAGE_HPP


#include <objects/trackmgr/TMgr_Message_.hpp>
#include <serial/enumvalues.hpp>


BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE


/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_Message : public CTMgr_Message_Base
{
    typedef CTMgr_Message_Base Tparent;
public:
    CTMgr_Message(void);
    CTMgr_Message(TLevel level);
    CTMgr_Message(TLevel level, const TMessage& message);
    ~CTMgr_Message(void);

    operator string() const
    {
        static const CEnumeratedTypeValues* lvls =
            GetTypeInfo_enum_ETMgr_MessageLevel();
        return lvls->FindName(GetLevel(), false) + ": " + GetMessage();
    }

private:
    // Prohibit copy constructor and assignment operator
    CTMgr_Message(const CTMgr_Message& value);
    CTMgr_Message& operator=(const CTMgr_Message& value);

};


inline
CTMgr_Message::CTMgr_Message(void)
{
}


END_objects_SCOPE
END_NCBI_SCOPE

#endif // INTERNAL_TRACKMGR_OBJECTS_TRACKMGR_TMGR_MESSAGE_HPP

