/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:57:04 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Canvas;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.util.Stack;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.emboss.jemboss.JembossParams;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.circular.MemoryComboBox;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MemoryComboBox_ESTest extends MemoryComboBox_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Vector<ScrollPane> vector0 = new Vector<ScrollPane>();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      // Undeclared exception!
      try { 
        memoryComboBox0.getURLAt(2);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 2
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Stack<Canvas> stack0 = new Stack<Canvas>();
      Canvas canvas0 = new Canvas();
      stack0.add(canvas0);
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(stack0);
      int int0 = memoryComboBox0.getIndexOf(canvas0);
      //  // Unstable assertion: assertEquals("[java.awt.Canvas[canvas90,0,0,0x0,invalid]]", stack0.toString());
      //  // Unstable assertion: assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      memoryComboBox0.addURL(jembossParams0);
      int int0 = memoryComboBox0.getIndexOf(jembossParams0);
      assertEquals(3, vector0.size());
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      // Undeclared exception!
      try { 
        memoryComboBox0.isItem((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.MemoryComboBox", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Stack<Canvas> stack0 = new Stack<Canvas>();
      Canvas canvas0 = new Canvas();
      stack0.add(canvas0);
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(stack0);
      // Undeclared exception!
      try { 
        memoryComboBox0.getURLAt(0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.awt.Canvas cannot be cast to java.net.URL
         //
         verifyException("uk.ac.sanger.artemis.circular.MemoryComboBox", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MemoryComboBox memoryComboBox0 = null;
      try {
        memoryComboBox0 = new MemoryComboBox((Vector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.DefaultComboBoxModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      memoryComboBox0.addURL("");
      boolean boolean0 = memoryComboBox0.isItem("");
      assertEquals(3, vector0.size());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      boolean boolean0 = memoryComboBox0.isItem("bbbb");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      boolean boolean0 = memoryComboBox0.isForwardPage();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Vector<TextField> vector0 = new Vector<TextField>(24, 0);
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(vector0, vector0);
      Vector vector1 = defaultTableModel0.getDataVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector1);
      boolean boolean0 = memoryComboBox0.isForwardPage();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      boolean boolean0 = memoryComboBox0.isBackPage();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Vector<TextField> vector0 = new Vector<TextField>(24, 0);
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(vector0, vector0);
      Vector vector1 = defaultTableModel0.getDataVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector1);
      boolean boolean0 = memoryComboBox0.isBackPage();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Vector<TextField> vector0 = new Vector<TextField>(24, 0);
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(vector0, vector0);
      Vector vector1 = defaultTableModel0.getDataVector();
      defaultTableModel0.addColumn((Object) vector0, (Vector) vector0);
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector1);
      memoryComboBox0.setLastIndex(vector1);
      assertEquals("[(this Collection)]", vector1.toString());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Stack<Canvas> stack0 = new Stack<Canvas>();
      Canvas canvas0 = new Canvas();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(stack0);
      memoryComboBox0.setLastIndex(canvas0);
      assertFalse(memoryComboBox0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DefaultTableModel defaultTableModel0 = new DefaultTableModel();
      defaultTableModel0.setNumRows(1761);
      Vector vector0 = defaultTableModel0.getDataVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      memoryComboBox0.addURL(defaultTableModel0);
      assertEquals(1761, vector0.size());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      memoryComboBox0.addURL(jembossParams0);
      boolean boolean0 = memoryComboBox0.isBackPage();
      assertEquals(3, vector0.size());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.modeVector();
      MemoryComboBox memoryComboBox0 = new MemoryComboBox(vector0);
      int int0 = memoryComboBox0.getIndexOf(jembossParams0);
      assertEquals((-1), int0);
  }
}
