#!/usr/bin/python3
# Copyright 2023 The ANGLE Project Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import os
import subprocess
import sys
import argparse

template_header_boilerplate = """// GENERATED FILE - DO NOT EDIT.
// Generated by {script_name}
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
"""


def embed_in_header(source_file, variable_name, dest_header_file):
    boilerplate_code = template_header_boilerplate.format(
        script_name=os.path.basename(sys.argv[0]))

    with open(source_file, 'rb') as f:
        source_data = f.read()

    with open(dest_header_file, 'wt') as out_file:
        out_file.write(boilerplate_code)
        out_file.write('\n')
        out_file.write('// C++ string version of default shaders mtllib.\n\n')
        out_file.write('\n\nstatic constexpr uint8_t ' + variable_name + '[] = {\n')
        for byte in source_data:
            out_file.write(f"{byte}, ")
        out_file.write('\n')
        out_file.write('};\n')
        out_file.close()


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--source')
    parser.add_argument('--variable-name')
    parser.add_argument('--header')
    args = parser.parse_args()

    embed_in_header(args.source, args.variable_name, args.header)


if __name__ == '__main__':
    sys.exit(main())
