/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef __XE_OA_REGS__
#define __XE_OA_REGS__

#define RPM_CONFIG1			XE_REG(0xd04)
#define   GT_NOA_ENABLE			REG_BIT(9)

#define EU_PERF_CNTL0			XE_REG(0xe458)
#define EU_PERF_CNTL4			XE_REG(0xe45c)
#define EU_PERF_CNTL1			XE_REG(0xe558)
#define EU_PERF_CNTL5			XE_REG(0xe55c)
#define EU_PERF_CNTL2			XE_REG(0xe658)
#define EU_PERF_CNTL6			XE_REG(0xe65c)
#define EU_PERF_CNTL3			XE_REG(0xe758)

#define OA_TLB_INV_CR			XE_REG(0xceec)

/* OAR unit */
#define OAR_OACONTROL			XE_REG(0x2960)
#define  OAR_OACONTROL_COUNTER_SEL_MASK	REG_GENMASK(3, 1)
#define  OAR_OACONTROL_COUNTER_ENABLE	REG_BIT(0)

#define OACTXCONTROL(base) XE_REG((base) + 0x360)
#define OAR_OASTATUS			XE_REG(0x2968)
#define  OA_COUNTER_RESUME		REG_BIT(0)

/* OAG unit */
#define OAG_OAGLBCTXCTRL		XE_REG(0x2b28)
#define  OAG_OAGLBCTXCTRL_TIMER_PERIOD_MASK	REG_GENMASK(7, 2)
#define  OAG_OAGLBCTXCTRL_TIMER_ENABLE		REG_BIT(1)
#define  OAG_OAGLBCTXCTRL_COUNTER_RESUME	REG_BIT(0)

#define OAG_OAHEADPTR				XE_REG(0xdb00)
#define  OAG_OAHEADPTR_MASK			REG_GENMASK(31, 6)
#define OAG_OATAILPTR				XE_REG(0xdb04)
#define  OAG_OATAILPTR_MASK			REG_GENMASK(31, 6)

#define OAG_OABUFFER		XE_REG(0xdb08)
#define  OABUFFER_SIZE_MASK	REG_GENMASK(5, 3)
#define  OAG_OABUFFER_MEMORY_SELECT		REG_BIT(0) /* 0: PPGTT, 1: GGTT */

#define OAG_OACONTROL				XE_REG(0xdaf4)
#define  OAG_OACONTROL_OA_PES_DISAG_EN		REG_GENMASK(27, 22)
#define  OAG_OACONTROL_OA_CCS_SELECT_MASK	REG_GENMASK(18, 16)
#define  OAG_OACONTROL_OA_COUNTER_SEL_MASK	REG_GENMASK(4, 2)
#define  OAG_OACONTROL_OA_COUNTER_ENABLE	REG_BIT(0)
/* Common to all OA units */
#define  OA_OACONTROL_REPORT_BC_MASK		REG_GENMASK(9, 9)
#define  OA_OACONTROL_COUNTER_SIZE_MASK		REG_GENMASK(8, 8)
#define  OAG_OACONTROL_USED_BITS \
	(OAG_OACONTROL_OA_PES_DISAG_EN | OAG_OACONTROL_OA_CCS_SELECT_MASK | \
	 OAG_OACONTROL_OA_COUNTER_SEL_MASK | OAG_OACONTROL_OA_COUNTER_ENABLE | \
	 OA_OACONTROL_REPORT_BC_MASK | OA_OACONTROL_COUNTER_SIZE_MASK)

#define OAG_OA_DEBUG XE_REG(0xdaf8, XE_REG_OPTION_MASKED)
#define  OAG_OA_DEBUG_DISABLE_MMIO_TRG			REG_BIT(14)
#define  OAG_OA_DEBUG_START_TRIGGER_SCOPE_CONTROL	REG_BIT(13)
#define  OAG_OA_DEBUG_BUF_SIZE_SELECT			REG_BIT(12)
#define  OAG_OA_DEBUG_DISABLE_START_TRG_2_COUNT_QUAL	REG_BIT(8)
#define  OAG_OA_DEBUG_DISABLE_START_TRG_1_COUNT_QUAL	REG_BIT(7)
#define  OAG_OA_DEBUG_INCLUDE_CLK_RATIO			REG_BIT(6)
#define  OAG_OA_DEBUG_DISABLE_CLK_RATIO_REPORTS		REG_BIT(5)
#define  OAG_OA_DEBUG_DISABLE_CTX_SWITCH_REPORTS	REG_BIT(1)

#define OAG_OASTATUS			XE_REG(0xdafc)
#define  OASTATUS_MMIO_TRG_Q_FULL	REG_BIT(6)
#define  OASTATUS_COUNTER_OVERFLOW	REG_BIT(2)
#define  OASTATUS_BUFFER_OVERFLOW	REG_BIT(1)
#define  OASTATUS_REPORT_LOST		REG_BIT(0)
#define OAG_MMIOTRIGGER			XE_REG(0xdb1c)
/* OAC unit */
#define OAC_OACONTROL			XE_REG(0x15114)

/* OAM unit */
#define OAM_HEAD_POINTER_OFFSET			(0x1a0)
#define OAM_TAIL_POINTER_OFFSET			(0x1a4)
#define OAM_BUFFER_OFFSET			(0x1a8)
#define OAM_CONTEXT_CONTROL_OFFSET		(0x1bc)
#define OAM_CONTROL_OFFSET			(0x194)
#define  OAM_CONTROL_COUNTER_SEL_MASK		REG_GENMASK(3, 1)
#define  OAM_OACONTROL_USED_BITS \
	(OAM_CONTROL_COUNTER_SEL_MASK | OAG_OACONTROL_OA_COUNTER_ENABLE)
#define OAM_DEBUG_OFFSET			(0x198)
#define OAM_STATUS_OFFSET			(0x19c)
#define OAM_MMIO_TRG_OFFSET			(0x1d0)

#define OAM_HEAD_POINTER(base)			XE_REG((base) + OAM_HEAD_POINTER_OFFSET)
#define OAM_TAIL_POINTER(base)			XE_REG((base) + OAM_TAIL_POINTER_OFFSET)
#define OAM_BUFFER(base)			XE_REG((base) + OAM_BUFFER_OFFSET)
#define OAM_CONTEXT_CONTROL(base)		XE_REG((base) + OAM_CONTEXT_CONTROL_OFFSET)
#define OAM_CONTROL(base)			XE_REG((base) + OAM_CONTROL_OFFSET)
#define OAM_DEBUG(base)				XE_REG((base) + OAM_DEBUG_OFFSET)
#define OAM_STATUS(base)			XE_REG((base) + OAM_STATUS_OFFSET)
#define OAM_MMIO_TRG(base)			XE_REG((base) + OAM_MMIO_TRG_OFFSET)

#define OAM_COMPRESSION_T3_CONTROL		XE_REG(0x1c2e00)
#define  OAM_LAT_MEASURE_ENABLE			REG_BIT(4)

#endif
