/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */

#ifndef DT_BINDINGS_ASPEED_WDT_H
#define DT_BINDINGS_ASPEED_WDT_H

#define AST2500_WDT_RESET_CPU		(1 << 0)
#define AST2500_WDT_RESET_COPROC	(1 << 1)
#define AST2500_WDT_RESET_SDRAM		(1 << 2)
#define AST2500_WDT_RESET_AHB		(1 << 3)
#define AST2500_WDT_RESET_I2C		(1 << 4)
#define AST2500_WDT_RESET_MAC0		(1 << 5)
#define AST2500_WDT_RESET_MAC1		(1 << 6)
#define AST2500_WDT_RESET_GRAPHICS	(1 << 7)
#define AST2500_WDT_RESET_USB2_HOST_HUB	(1 << 8)
#define AST2500_WDT_RESET_USB_HOST	(1 << 9)
#define AST2500_WDT_RESET_HID_EHCI	(1 << 10)
#define AST2500_WDT_RESET_VIDEO		(1 << 11)
#define AST2500_WDT_RESET_HAC		(1 << 12)
#define AST2500_WDT_RESET_LPC		(1 << 13)
#define AST2500_WDT_RESET_SDIO		(1 << 14)
#define AST2500_WDT_RESET_MIC		(1 << 15)
#define AST2500_WDT_RESET_CRT		(1 << 16)
#define AST2500_WDT_RESET_PWM		(1 << 17)
#define AST2500_WDT_RESET_PECI		(1 << 18)
#define AST2500_WDT_RESET_JTAG		(1 << 19)
#define AST2500_WDT_RESET_ADC		(1 << 20)
#define AST2500_WDT_RESET_GPIO		(1 << 21)
#define AST2500_WDT_RESET_MCTP		(1 << 22)
#define AST2500_WDT_RESET_XDMA		(1 << 23)
#define AST2500_WDT_RESET_SPI		(1 << 24)
#define AST2500_WDT_RESET_SOC_MISC	(1 << 25)

#define AST2500_WDT_RESET_DEFAULT 0x023ffff3

#define AST2600_WDT_RESET1_CPU		(1 << 0)
#define AST2600_WDT_RESET1_SDRAM	(1 << 1)
#define AST2600_WDT_RESET1_AHB		(1 << 2)
#define AST2600_WDT_RESET1_SLI		(1 << 3)
#define AST2600_WDT_RESET1_SOC_MISC0	(1 << 4)
#define AST2600_WDT_RESET1_COPROC	(1 << 5)
#define AST2600_WDT_RESET1_USB_A	(1 << 6)
#define AST2600_WDT_RESET1_USB_B	(1 << 7)
#define AST2600_WDT_RESET1_UHCI		(1 << 8)
#define AST2600_WDT_RESET1_GRAPHICS	(1 << 9)
#define AST2600_WDT_RESET1_CRT		(1 << 10)
#define AST2600_WDT_RESET1_VIDEO	(1 << 11)
#define AST2600_WDT_RESET1_HAC		(1 << 12)
#define AST2600_WDT_RESET1_DP		(1 << 13)
#define AST2600_WDT_RESET1_DP_MCU	(1 << 14)
#define AST2600_WDT_RESET1_GP_MCU	(1 << 15)
#define AST2600_WDT_RESET1_MAC0		(1 << 16)
#define AST2600_WDT_RESET1_MAC1		(1 << 17)
#define AST2600_WDT_RESET1_SDIO0	(1 << 18)
#define AST2600_WDT_RESET1_JTAG0	(1 << 19)
#define AST2600_WDT_RESET1_MCTP0	(1 << 20)
#define AST2600_WDT_RESET1_MCTP1	(1 << 21)
#define AST2600_WDT_RESET1_XDMA0	(1 << 22)
#define AST2600_WDT_RESET1_XDMA1	(1 << 23)
#define AST2600_WDT_RESET1_GPIO0	(1 << 24)
#define AST2600_WDT_RESET1_RVAS		(1 << 25)

#define AST2600_WDT_RESET1_DEFAULT 0x030f1ff1

#define AST2600_WDT_RESET2_CPU		(1 << 0)
#define AST2600_WDT_RESET2_SPI		(1 << 1)
#define AST2600_WDT_RESET2_AHB2		(1 << 2)
#define AST2600_WDT_RESET2_SLI2		(1 << 3)
#define AST2600_WDT_RESET2_SOC_MISC1	(1 << 4)
#define AST2600_WDT_RESET2_MAC2		(1 << 5)
#define AST2600_WDT_RESET2_MAC3		(1 << 6)
#define AST2600_WDT_RESET2_SDIO1	(1 << 7)
#define AST2600_WDT_RESET2_JTAG1	(1 << 8)
#define AST2600_WDT_RESET2_GPIO1	(1 << 9)
#define AST2600_WDT_RESET2_MDIO		(1 << 10)
#define AST2600_WDT_RESET2_LPC		(1 << 11)
#define AST2600_WDT_RESET2_PECI		(1 << 12)
#define AST2600_WDT_RESET2_PWM		(1 << 13)
#define AST2600_WDT_RESET2_ADC		(1 << 14)
#define AST2600_WDT_RESET2_FSI		(1 << 15)
#define AST2600_WDT_RESET2_I2C		(1 << 16)
#define AST2600_WDT_RESET2_I3C_GLOBAL	(1 << 17)
#define AST2600_WDT_RESET2_I3C0		(1 << 18)
#define AST2600_WDT_RESET2_I3C1		(1 << 19)
#define AST2600_WDT_RESET2_I3C2		(1 << 20)
#define AST2600_WDT_RESET2_I3C3		(1 << 21)
#define AST2600_WDT_RESET2_I3C4		(1 << 22)
#define AST2600_WDT_RESET2_I3C5		(1 << 23)
#define AST2600_WDT_RESET2_ESPI		(1 << 26)

#define AST2600_WDT_RESET2_DEFAULT 0x03fffff1

#endif
