---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              disposition d'équations, mise en forme des équations, 
              équations longues, équations sur plusieurs lignes, 
              comment couper une équation
---

# Comment mettre en page des formules longues ?

## Avec l'extension <ctanpkg:mathtools>

Les environnements `split` et `multline` de l'extension <ctanpkg:mathtools> 
(ou de <ctanpkg:amsmath>) permettent de couper une équation trop longue 
pour tenir sur une seule ligne. En voici des exemples :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{equation}
\begin{split}
  a & = b+c-d\\
    & \quad +e-f\\
    & = i
\end{split}
\end{equation}

\begin{multline}
  a+b+c+d+e+f+g+h+i+j+k+l+m\\
  +n+o+p+q+r+s+t+u+v+w+x+y+z
\end{multline}
\end{document}
```


:::{seealso}
Sur ce sujet, [Leslie Lamport](wpfr:Leslie_Lamport) définit certaines
conventions dans un article en anglais : 
[*How to write a long formula*](https://lamport.azurewebsites.net/pubs/lamport-howtowrite.pdf) 
(1994).
:::