/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of python-ubuntu-platform-api.
 *
 * python-upa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * python-upa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <Python.h>

#include <ubuntu/ui/ubuntu_ui_session_service.h>
#include <ubuntu/application/ui/display.h>

#include <stdio.h>
#include <stdlib.h>

static PyObject* py_get_resolution(PyObject* dummy, PyObject* args)
{
    // HACK: no guarantee Mir server running. For now just use a set of hardcoded values
    int32_t res_x = 0;
    int32_t res_y = 0;
    char device[20];

    FILE *fp = popen("/usr/bin/getprop ro.product.device", "r");
    if (fp == NULL) {
        printf("UPAModule: unable to get run shell command");
        pclose(fp);
        return Py_BuildValue("(i,i)", res_x, res_y);
    }

    if (fgets(device, sizeof(device), fp) == NULL) {
        printf("UPAModule: unable to get current device name");
        pclose(fp);
        return Py_BuildValue("(i,i)", res_x, res_y);
    }
    pclose(fp);

    if (strcmp(device, "mako\n") == 0) {
        res_x = 768;
        res_y = 1280;
    } else if (strcmp(device, "maguro\n") == 0) {
        res_x = 720;
        res_y = 1280;
    } else if (strcmp(device, "manta\n") == 0) {
        res_x = 2560;
        res_y = 1600;
    } else if (strcmp(device, "grouper\n") == 0) {
        res_x = 800;
        res_y = 1280;
    }

    return Py_BuildValue("(i,i)", res_x, res_y);
}


static PyMethodDef UPAMethods[] = {
    {"get_resolution", py_get_resolution, METH_VARARGS, "Get horizontal and vertical resolution."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


PyMODINIT_FUNC init_mir(void)
{
    PyEval_InitThreads();
    (void) Py_InitModule("_mir", UPAMethods);
}
