r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Autopilot
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from datetime import datetime
from typing import Any, Dict, List, Optional, Union, Iterator, AsyncIterator
from twilio.base import deserialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version
from twilio.base.page import Page


class QueryInstance(InstanceResource):

    """
    :ivar account_sid: The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Query resource.
    :ivar date_created: The date and time in GMT when the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
    :ivar date_updated: The date and time in GMT when the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
    :ivar results: The natural language analysis results that include the [Task](https://www.twilio.com/docs/autopilot/api/task) recognized and a list of identified [Fields](https://www.twilio.com/docs/autopilot/api/task-field).
    :ivar language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query. For example: `en-US`.
    :ivar model_build_sid: The SID of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) queried.
    :ivar query: The end-user's natural language input.
    :ivar sample_sid: The SID of an optional reference to the [Sample](https://www.twilio.com/docs/autopilot/api/task-sample) created from the query.
    :ivar assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resource.
    :ivar sid: The unique string that we created to identify the Query resource.
    :ivar status: The status of the Query. Can be: `pending-review`, `reviewed`, or `discarded`
    :ivar url: The absolute URL of the Query resource.
    :ivar source_channel: The communication channel from where the end-user input came.
    :ivar dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
    """

    def __init__(
        self,
        version: Version,
        payload: Dict[str, Any],
        assistant_sid: str,
        sid: Optional[str] = None,
    ):
        super().__init__(version)

        self.account_sid: Optional[str] = payload.get("account_sid")
        self.date_created: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_created")
        )
        self.date_updated: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_updated")
        )
        self.results: Optional[Dict[str, object]] = payload.get("results")
        self.language: Optional[str] = payload.get("language")
        self.model_build_sid: Optional[str] = payload.get("model_build_sid")
        self.query: Optional[str] = payload.get("query")
        self.sample_sid: Optional[str] = payload.get("sample_sid")
        self.assistant_sid: Optional[str] = payload.get("assistant_sid")
        self.sid: Optional[str] = payload.get("sid")
        self.status: Optional[str] = payload.get("status")
        self.url: Optional[str] = payload.get("url")
        self.source_channel: Optional[str] = payload.get("source_channel")
        self.dialogue_sid: Optional[str] = payload.get("dialogue_sid")

        self._solution = {
            "assistant_sid": assistant_sid,
            "sid": sid or self.sid,
        }
        self._context: Optional[QueryContext] = None

    @property
    def _proxy(self) -> "QueryContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: QueryContext for this QueryInstance
        """
        if self._context is None:
            self._context = QueryContext(
                self._version,
                assistant_sid=self._solution["assistant_sid"],
                sid=self._solution["sid"],
            )
        return self._context

    def delete(self) -> bool:
        """
        Deletes the QueryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._proxy.delete()

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the QueryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._proxy.delete_async()

    def fetch(self) -> "QueryInstance":
        """
        Fetch the QueryInstance


        :returns: The fetched QueryInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "QueryInstance":
        """
        Asynchronous coroutine to fetch the QueryInstance


        :returns: The fetched QueryInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self,
        sample_sid: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
    ) -> "QueryInstance":
        """
        Update the QueryInstance

        :param sample_sid: The SID of an optional reference to the [Sample](https://www.twilio.com/docs/autopilot/api/task-sample) created from the query.
        :param status: The new status of the resource. Can be: `pending-review`, `reviewed`, or `discarded`

        :returns: The updated QueryInstance
        """
        return self._proxy.update(
            sample_sid=sample_sid,
            status=status,
        )

    async def update_async(
        self,
        sample_sid: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
    ) -> "QueryInstance":
        """
        Asynchronous coroutine to update the QueryInstance

        :param sample_sid: The SID of an optional reference to the [Sample](https://www.twilio.com/docs/autopilot/api/task-sample) created from the query.
        :param status: The new status of the resource. Can be: `pending-review`, `reviewed`, or `discarded`

        :returns: The updated QueryInstance
        """
        return await self._proxy.update_async(
            sample_sid=sample_sid,
            status=status,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.QueryInstance {}>".format(context)


class QueryContext(InstanceContext):
    def __init__(self, version: Version, assistant_sid: str, sid: str):
        """
        Initialize the QueryContext

        :param version: Version that contains the resource
        :param assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resource to update.
        :param sid: The Twilio-provided string that uniquely identifies the Query resource to update.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "assistant_sid": assistant_sid,
            "sid": sid,
        }
        self._uri = "/Assistants/{assistant_sid}/Queries/{sid}".format(**self._solution)

    def delete(self) -> bool:
        """
        Deletes the QueryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._version.delete(
            method="DELETE",
            uri=self._uri,
        )

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the QueryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._version.delete_async(
            method="DELETE",
            uri=self._uri,
        )

    def fetch(self) -> QueryInstance:
        """
        Fetch the QueryInstance


        :returns: The fetched QueryInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return QueryInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
            sid=self._solution["sid"],
        )

    async def fetch_async(self) -> QueryInstance:
        """
        Asynchronous coroutine to fetch the QueryInstance


        :returns: The fetched QueryInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return QueryInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
            sid=self._solution["sid"],
        )

    def update(
        self,
        sample_sid: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
    ) -> QueryInstance:
        """
        Update the QueryInstance

        :param sample_sid: The SID of an optional reference to the [Sample](https://www.twilio.com/docs/autopilot/api/task-sample) created from the query.
        :param status: The new status of the resource. Can be: `pending-review`, `reviewed`, or `discarded`

        :returns: The updated QueryInstance
        """
        data = values.of(
            {
                "SampleSid": sample_sid,
                "Status": status,
            }
        )

        payload = self._version.update(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return QueryInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
            sid=self._solution["sid"],
        )

    async def update_async(
        self,
        sample_sid: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
    ) -> QueryInstance:
        """
        Asynchronous coroutine to update the QueryInstance

        :param sample_sid: The SID of an optional reference to the [Sample](https://www.twilio.com/docs/autopilot/api/task-sample) created from the query.
        :param status: The new status of the resource. Can be: `pending-review`, `reviewed`, or `discarded`

        :returns: The updated QueryInstance
        """
        data = values.of(
            {
                "SampleSid": sample_sid,
                "Status": status,
            }
        )

        payload = await self._version.update_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return QueryInstance(
            self._version,
            payload,
            assistant_sid=self._solution["assistant_sid"],
            sid=self._solution["sid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.QueryContext {}>".format(context)


class QueryPage(Page):
    def get_instance(self, payload: Dict[str, Any]) -> QueryInstance:
        """
        Build an instance of QueryInstance

        :param payload: Payload response from the API
        """
        return QueryInstance(
            self._version, payload, assistant_sid=self._solution["assistant_sid"]
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Autopilot.V1.QueryPage>"


class QueryList(ListResource):
    def __init__(self, version: Version, assistant_sid: str):
        """
        Initialize the QueryList

        :param version: Version that contains the resource
        :param assistant_sid: The SID of the [Assistant](https://www.twilio.com/docs/autopilot/api/assistant) that is the parent of the resources to read.

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "assistant_sid": assistant_sid,
        }
        self._uri = "/Assistants/{assistant_sid}/Queries".format(**self._solution)

    def create(
        self,
        language: str,
        query: str,
        tasks: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
    ) -> QueryInstance:
        """
        Create the QueryInstance

        :param language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used for the new query. For example: `en-US`.
        :param query: The end-user's natural language input. It can be up to 2048 characters long.
        :param tasks: The list of tasks to limit the new query to. Tasks are expressed as a comma-separated list of task `unique_name` values. For example, `task-unique_name-1, task-unique_name-2`. Listing specific tasks is useful to constrain the paths that a user can take.
        :param model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.

        :returns: The created QueryInstance
        """
        data = values.of(
            {
                "Language": language,
                "Query": query,
                "Tasks": tasks,
                "ModelBuild": model_build,
            }
        )

        payload = self._version.create(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return QueryInstance(
            self._version, payload, assistant_sid=self._solution["assistant_sid"]
        )

    async def create_async(
        self,
        language: str,
        query: str,
        tasks: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
    ) -> QueryInstance:
        """
        Asynchronously create the QueryInstance

        :param language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used for the new query. For example: `en-US`.
        :param query: The end-user's natural language input. It can be up to 2048 characters long.
        :param tasks: The list of tasks to limit the new query to. Tasks are expressed as a comma-separated list of task `unique_name` values. For example, `task-unique_name-1, task-unique_name-2`. Listing specific tasks is useful to constrain the paths that a user can take.
        :param model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.

        :returns: The created QueryInstance
        """
        data = values.of(
            {
                "Language": language,
                "Query": query,
                "Tasks": tasks,
                "ModelBuild": model_build,
            }
        )

        payload = await self._version.create_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return QueryInstance(
            self._version, payload, assistant_sid=self._solution["assistant_sid"]
        )

    def stream(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> Iterator[QueryInstance]:
        """
        Streams QueryInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param str language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param str model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param str status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param str dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = self.page(
            language=language,
            model_build=model_build,
            status=status,
            dialogue_sid=dialogue_sid,
            page_size=limits["page_size"],
        )

        return self._version.stream(page, limits["limit"])

    async def stream_async(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> AsyncIterator[QueryInstance]:
        """
        Asynchronously streams QueryInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param str language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param str model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param str status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param str dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = await self.page_async(
            language=language,
            model_build=model_build,
            status=status,
            dialogue_sid=dialogue_sid,
            page_size=limits["page_size"],
        )

        return self._version.stream_async(page, limits["limit"])

    def list(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[QueryInstance]:
        """
        Lists QueryInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param str language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param str model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param str status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param str dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return list(
            self.stream(
                language=language,
                model_build=model_build,
                status=status,
                dialogue_sid=dialogue_sid,
                limit=limit,
                page_size=page_size,
            )
        )

    async def list_async(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[QueryInstance]:
        """
        Asynchronously lists QueryInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param str language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param str model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param str status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param str dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return [
            record
            async for record in await self.stream_async(
                language=language,
                model_build=model_build,
                status=status,
                dialogue_sid=dialogue_sid,
                limit=limit,
                page_size=page_size,
            )
        ]

    def page(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> QueryPage:
        """
        Retrieve a single page of QueryInstance records from the API.
        Request is executed immediately

        :param language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of QueryInstance
        """
        data = values.of(
            {
                "Language": language,
                "ModelBuild": model_build,
                "Status": status,
                "DialogueSid": dialogue_sid,
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        response = self._version.page(method="GET", uri=self._uri, params=data)
        return QueryPage(self._version, response, self._solution)

    async def page_async(
        self,
        language: Union[str, object] = values.unset,
        model_build: Union[str, object] = values.unset,
        status: Union[str, object] = values.unset,
        dialogue_sid: Union[str, object] = values.unset,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> QueryPage:
        """
        Asynchronously retrieve a single page of QueryInstance records from the API.
        Request is executed immediately

        :param language: The [ISO language-country](https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html) string that specifies the language used by the Query resources to read. For example: `en-US`.
        :param model_build: The SID or unique name of the [Model Build](https://www.twilio.com/docs/autopilot/api/model-build) to be queried.
        :param status: The status of the resources to read. Can be: `pending-review`, `reviewed`, or `discarded`
        :param dialogue_sid: The SID of the [Dialogue](https://www.twilio.com/docs/autopilot/api/dialogue).
        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of QueryInstance
        """
        data = values.of(
            {
                "Language": language,
                "ModelBuild": model_build,
                "Status": status,
                "DialogueSid": dialogue_sid,
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        response = await self._version.page_async(
            method="GET", uri=self._uri, params=data
        )
        return QueryPage(self._version, response, self._solution)

    def get_page(self, target_url: str) -> QueryPage:
        """
        Retrieve a specific page of QueryInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of QueryInstance
        """
        response = self._version.domain.twilio.request("GET", target_url)
        return QueryPage(self._version, response, self._solution)

    async def get_page_async(self, target_url: str) -> QueryPage:
        """
        Asynchronously retrieve a specific page of QueryInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of QueryInstance
        """
        response = await self._version.domain.twilio.request_async("GET", target_url)
        return QueryPage(self._version, response, self._solution)

    def get(self, sid: str) -> QueryContext:
        """
        Constructs a QueryContext

        :param sid: The Twilio-provided string that uniquely identifies the Query resource to update.
        """
        return QueryContext(
            self._version, assistant_sid=self._solution["assistant_sid"], sid=sid
        )

    def __call__(self, sid: str) -> QueryContext:
        """
        Constructs a QueryContext

        :param sid: The Twilio-provided string that uniquely identifies the Query resource to update.
        """
        return QueryContext(
            self._version, assistant_sid=self._solution["assistant_sid"], sid=sid
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Autopilot.V1.QueryList>"
