# Contributing to python-nubia
We want to make contributing to this project as easy and transparent as
possible.

## Our Development Process
External pull requests are first applied to facebook's internal branch, then synced with python-nubia github repository.

## Development Requirements
The project uses [pre-commit](https://github.com/pre-commit/pre-commit) which is included in
development dependencies `requirements-dev.txt`.


## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. Run `pre-commit install` after forking/cloning the repo.
3. If you've added code that should be tested, add tests.
4. If you've changed APIs, update the documentation.
5. Ensure the test suite passes.
6. Make sure your code lints.
7. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.

## Coding Style  
We use python [black formatting](https://github.com/ambv/black). Make sure your code
is formatted with black before sending the pull request.

## License
By contributing to python-nubia, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
