# GeoPandas logo

GeoPandas project uses a logo derived from [`pandas` logo](https://pandas.pydata.org/about/citing.html), enclosing it in a globe illustrating the geographic nature of our data.

## Versions

We have four versions of our logo:

### Primary logo

The primary logo should be used in a majority of cases. Inverted logo or icon should be used only when necessary.

```{image} ../_static/logo/geopandas_logo.png
:alt: geopandas-logo
:align: center
```

### Inverted colors

If you want to place the GeoPandas logo on a dark background, use the inverted version.

```{image} ../_static/logo/geopandas_logo_green.png
:alt: geopandas-logo-green
:align: center
```

### Icon

Although it is possible to use icon independently, we would prefer using the complete variant above.

```{image} ../_static/logo/geopandas_icon.png
:alt: geopandas-icon
:width: 25%
:align: center
```

### Inverted icon

```{image} ../_static/logo/geopandas_icon_green.png
:alt: geopandas-icon-green
:width: 25%
:align: center
```

## Download

You can download all version in SVG and PNG from [GitHub repository](https://github.com/geopandas/geopandas/tree/master/doc/source/_static/logo).


## Colors

Pink and yellow accent colors are shared with `pandas`.

### Green
```{raw} html
<svg xmlns="http://www.w3.org/2000/svg" width="75" height="75" style="float: left">
    <circle cx="33" cy="33" r="33" fill="#139C5A"></circle>
</svg>
```
**HEX:** #139C5A

**RGB:** (19, 156, 90)

### Yellow
```{raw} html
<svg xmlns="http://www.w3.org/2000/svg" width="75" height="75" style="float: left">
    <circle cx="33" cy="33" r="33" fill="#FFCA00"></circle>
</svg>
```
**HEX:** #FFCA00

**RGB:** (255, 202, 0)

### Pink
```{raw} html
<svg xmlns="http://www.w3.org/2000/svg" width="75" height="75" style="float: left">
    <circle cx="33" cy="33" r="33" fill="#E70488"></circle>
</svg>
```
**HEX:** #E70488

**RGB:** ((31, 4, 136)


