# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=13.0.0 --output=unicodedb_13_0_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '13.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x07 ABOVE '
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x03 AN'
'\x05 AND '
'\n AND ARROW'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x06 ARROW'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\t ASTERISK'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x05 BACK'
'\r BAT AND BALL'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\x07 CER-WA'
'\n CHARACTER'
'\x07 CHIKI '
'\x05 CHWV'
'\x07 CIRCLE'
'\x05 COAT'
'\n CONJOINED'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING ESH2'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\t DRACHMAS'
'\x10 DRAWINGS LIGHT '
'\x02 E'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x08 FACING '
'\x05 FILL'
'\x06 FINAL'
'\x13 FLUTTERING IN WIND'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x11 GRAVEYARD SYMBOL'
'\x05 GUNU'
'\x08 HANDLES'
'\t HITTING '
'\x05 HOOK'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ICON'
'\x05 ILUT'
'\x03 IN'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x04 KEY'
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x13 LOVE YOU HAND SIGN'
'\x02 M'
'\x08 MACHINE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x08 MAKSURA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x06 MURDA'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\t OF BLOOD'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\t OF PAPER'
'\r OF THE HORNS'
'\x08 OF YARN'
'\x05 OPEN'
'\x07 OPEN-O'
'\r OPPOSING KUR'
'\x04 ORE'
'\x04 OUT'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
'\x12 OVER HI TIMES ASH'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x16 OVER STAMPED ENVELOPE'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DA'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GAL'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\x10 PLUS KAK PLUS A'
'\x0c PLUS KASKAL'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x12 PLUS PAP PLUS LU3'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\t PLUS SAG'
'\x11 PLUS SHA3 PLUS A'
'\t PLUS SHU'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x07 PLUS U'
'\t PLUS ZA7'
'\x06 POINT'
'\n POINTING '
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x0c PUNCTUATION'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\t RICKSHAW'
'\x0c RING LITTLE'
'\t ROTATED '
'\x17 ROTATED NINETY DEGREES'
'\x08 ROTUNDA'
'\x06 RULER'
'\x02 S'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x07 SECANT'
'\n SEPARATOR'
'\x04 SET'
'\x06 SEVEN'
'\x05 SHOE'
'\x05 SIDE'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\t STRAIGHT'
'\t STREAMER'
'\x07 SYMBOL'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x12 THROUGH DESCENDER'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES BAD'
'\x10 TIMES DISH TENU'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\t TIMES HA'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x0b TIMES TAK4'
'\x08 TIMES U'
'\t TIMES UD'
'\x07 TO BAR'
'\x10 TO LOWER CENTRE'
'\x0f TO MIDDLE LEFT'
'\x10 TO MIDDLE RIGHT'
'\x05 TONE'
'\x06 TONE-'
'\x0f TOUCHING INDEX'
'\x08 TTUDDAG'
'\x02 U'
'\x04 U U'
'\r VARIANT FORM'
'\x04 WEB'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x16 WITH CIRCUMFLEX ABOVE'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x0f WITH DOT ABOVE'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE MIDDLE TILDE'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x0b WITH FLASH'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\r WITH JEGOGAN'
'\x12 WITH KAVYKA ABOVE'
'\x0e WITH LONG LEG'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\x0e WITH ORNAMENT'
'\x18 WITH OVERLAID BACKSLASH'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\x0f WITH RIGHT LEG'
'\n WITH RING'
'\x11 WITH SOUND WAVES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x16 WITH THREE DOTS ABOVE'
'\x12 WITH VERTICAL BAR'
'\x13 WITH VERTICAL TAIL'
'\x0b WITHIN DOT'
'\x07 WOLOSO'
'\x0b WRIST FLEX'
'\x02 X'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x02-A'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\t-LOW TONE'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x07-MU-MO-'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x0b-OFF SYMBOL'
'\x0f-PIECE SWIMSUIT'
'\x06-PIEUP'
'\n-POINTING '
'\x11-POINTING CHEVRON'
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x08-X BELOW'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x080 BRONZE'
'\x050 DOO'
'\x050 DWO'
'\x030 E'
'\x0b0 FOOTSTOOL'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\x040 KO'
'\t0 LONG LE'
'\x040 MA'
'\x050 MAN'
'\x060 NGGI'
'\x060 NGGO'
'\x040 NI'
'\x060 NYON'
'\x060 NYUN'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x040 SA'
'\x070 SPEAR'
'\x030 U'
'\x030 W'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 YE'
'\x040 ZO'
'\x030-0'
'\x050-VAS'
'\x0200'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0304A'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x031 A'
'\x071 ARROW'
'\x041 BA'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DO'
'\x041 DU'
'\x051 DWE'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x061 GOLD'
'\x041 HA'
'\x081 HELMET'
'\x061 HORN'
'\x041 IN'
'\x041 KI'
'\x041 KU'
'\n1 LONG MBE'
'\x061 NDEE'
'\x031 O'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 PO'
'\x041 QI'
'\x041 RA'
'\x041 SA'
'\x041 SI'
'\x041 SU'
'\x051 TEE'
'\x051 TWO'
'\x041 VU'
'\x061 WINE'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-0'
'\x031-2'
'\x051-VAS'
'\x0211'
'\x03121'
'\x041358'
'\x0314D'
'\x03155'
'\x0216'
'\x0217'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x032 B'
'\x042 BU'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\x072 PLUS '
'\n2 PLUS ASH'
'\x052 POO'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x052 SEE'
'\x042 SO'
'\x042 TI'
'\x042 VI'
'\x042 WO'
'\x072 WOMAN'
'\x032 Y'
'\x042 YA'
'\x032-0'
'\x052-VAS'
'\x0220'
'\x0320B'
'\x0221'
'\x0222'
'\x0224'
'\t247 DIPTE'
'\x03253'
'\x0726 EYYY'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 PA'
'\t3 PLUS AN'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x043 TA'
'\x053 VEE'
'\x053 WEI'
'\x073 WHEEL'
'\x043 YU'
'\x033-0'
'\x053-VAS'
'\x0230'
'\x03305'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0233'
'\x0234'
'\x0236'
'\x0238'
'\x0239'
'\x014'
'\x034 A'
'\x054 ABB'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x044 KE'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x044 NE'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x044 TE'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WA'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x044 ZE'
'\x034-0'
'\x054-VAS'
'\x0240'
'\x0242'
'\x0248'
'\x0249'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AN'
'\x045 AU'
'\t5 BATHTUB'
'\x045 BB'
'\t5 CYPERUS'
'\x045 DE'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 JU'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x065 MERI'
'\x045 MO'
'\x055 NDU'
'\x075 NGGEE'
'\x045 NU'
'\x045 OO'
'\x045 TE'
'\x045 TO'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WE'
'\x045 WO'
'\x065 WOOL'
'\x035-0'
'\x055-VAS'
'\x0250'
'\x0253'
'\x0255'
'\x03550'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x046 JE'
'\x046 JO'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x046 NA'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 TA2'
'\x066 TREE'
'\x056 WEE'
'\x046 WU'
'\x036-0'
'\x056-VAS'
'\x0262'
'\x03620'
'\x0264'
'\x036D7'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 DI'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x047 JA'
'\x057 JEE'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 VO'
'\x047 ZA'
'\x057-VAS'
'\x0270'
'\x0271'
'\x0272'
'\x0372C'
'\x0279'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x038 A'
'\x048 BO'
'\x048 DU'
'\x038 E'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x038 I'
'\x048 JI'
'\x038 K'
'\x088 KANAKO'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x058 NWA'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 SI'
'\x049 SO'
'\x049 TA'
'\x049 TO'
'\x049 TU'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x0292'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A HAAM'
'\x06A MFON'
'\x0cA NAME REIWA'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\tA PLUS NA'
'\x08A SIGN A'
'\nA TANG LAI'
'\x07A WITH '
'\rA WITH STROKE'
'\x05A YUE'
'\x02A-'
'\x04A-HA'
'\x06A-KARA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x04AACU'
'\x03AAF'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\tAAZHAAKKU'
'\x02AB'
'\x03AB2'
'\nAB2 TIMES '
'\x03ABA'
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x05ABOVE'
'\x15ABOVE LEFTWARDS ARROW'
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\rACCOMMODATION'
'\x03ACE'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x03AD3'
'\x03ADA'
'\x04ADA '
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x05ADULT'
'\x02AE'
'\x03AEA'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\tAF PERSON'
'\x17AF WITH INVERTED STROKE'
'\x04AFEL'
'\x0eAFETY SCISSORS'
'\tAFFE FACE'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x04AGE '
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x02AH'
'\x08AH WITH '
'\x16AH WITH TWO DOTS ABOVE'
'\x04AHAD'
'\x08AHAPRANA'
'\x02AI'
'\x0fAI LAING DIGIT '
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\x06AISED '
'\x1fAISED HAND WITH FINGERS SPLAYED'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\x02AJ'
'\x06AJANI '
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x03AK4'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x05ALLOT'
'\x0cALLPOINT PEN'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x05ALPHA'
'\x0cALT PAN SIGN'
'\x08ALTERNAT'
'\nALTERNATE '
'\x13ALTERNATE LAKH MARK'
'\x11ALTERNATE NUMBER '
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x08AM WITH '
'\x04AMBA'
'\tAME WITH '
'\x05AMEDH'
'\x05AMEKH'
'\x03AMI'
'\x04AMLA'
'\x04AMMA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\rAN RUPEE SIGN'
'\x04AN X'
'\x03AN2'
'\x03ANA'
'\x10ANABAZAR SQUARE '
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x04AND '
'\x11AND BLACK SQUARES'
'\x0eAND COLD SWEAT'
'\x0fAND FEMALE SIGN'
'\x12AND LOW RIGHT RING'
'\x18AND MALE AND FEMALE SIGN'
'\x1fAND MIDDLE LEFT TO LOWER CENTRE'
' AND MIDDLE RIGHT TO LOWER CENTRE'
'\x1aAND RIGHT ONE EIGHTH BLOCK'
')AND RIGHT TRIANGULAR THREE QUARTERS BLOCK'
'\x08AND SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\nANDHI MARK'
'\nANDRABINDU'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANG CITI '
'\x05ANGEL'
'\tANGGEUAET'
'\x05ANGKA'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\rANGUL IEUNG U'
'\x04ANI '
'\x08ANI SIGN'
'\x06ANIMAL'
'\x05ANNON'
'\x08ANS SIGN'
'\x0fANS-SERIF ARROW'
'\x07ANSIOS-'
'\x13ANSPOSITION BRACKET'
'\x0cANTARGOMUKHA'
'\tANTAYALAN'
'\x13ANTICLOCKWISE ARROW'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x0eANUSVARA ABOVE'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x03AR '
'\x04ARA3'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x04ARAE'
'\x04ARAM'
'\x0bARAM GONDI '
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDNESS'
'\x03ARE'
'\x05ARGE '
'\x03ARK'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x03ARL'
'\x03ARM'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\x0bARMS RAISED'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x08ARRIVING'
'\x05ARROW'
'\x06ARROW '
'\x07ARROW O'
'\x12ARROW SHAFT WIDTH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x0eARSI YEH WITH '
'\x03ART'
'\x05ARTAR'
'\x17ARTY HORN AND PARTY HAT'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\x07AS SIGN'
'\x05ASAL '
'\x10ASALIZATION MARK'
'\x04ASAT'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x07ASHTRA '
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x03ASS'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATAKANA '
'\x08ATEBOARD'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x03ATO'
'\tATTACHED '
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\nATTY WITH '
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x07AUGHTS '
'\x03AUJ'
'\x04AULA'
'\x07AULDRON'
'\x03AUM'
'\x07AUNTLET'
'\x03AUS'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x02AW'
'\x05AWAY '
'\rAWELLEMET YAZ'
'\x0bAWNING FACE'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x03AYD'
'\nAYER BEADS'
'\x06AYEROK'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x05BACUS'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x03BAL'
'\x05BALAG'
'\x04BALD'
'\x04BALL'
'\rBALL AND HOOP'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rBASAN LETTER '
'\tBASE UNIT'
'\x04BASH'
'\x08BATAEAN '
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x08BBLE TEA'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x07BERRIES'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x08BEVERAGE'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\tBIAL SIGN'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x03BIN'
'\x05BINDU'
'\tBING CANE'
'\x07BINING '
'\x0cBINING MARK '
'\x08BINOVILE'
'\x0bBIRGA WITH '
'\x05BISAH'
'\x06BISCUS'
'\x06BISHOP'
'\x0fBISHOP ROTATED '
'\tBITE LIPS'
'\x0fBJOINED LETTER '
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\nBLACK FLAG'
'\rBLACK SQUARES'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
')BLOCK AND LOWER HALF INVERSE MEDIUM SHADE'
'\x0fBLOCK DIAGONAL '
'\x04BLOW'
'\x0cBLOWING FACE'
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x07BOTTOM '
'\x11BOTTOM HALF BLACK'
'\x15BOTTOM U-SHAPED ARROW'
'\x07BOURING'
'\x04BOVE'
'\x05BOVE '
'\rBOVE REVERSE '
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x08BRA FACE'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREAD'
'\x05BREVE'
'\x19BREVE WITH INVERTED BREVE'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x05BRUSH'
'\x12BSERVER EYE SYMBOL'
'\x04BSET'
'\x03BSP'
'\x05BSTER'
'\nBSTRUCTION'
'\x02BU'
'\x03BU '
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C CLEF'
'\x06C SIGN'
'\x08C SIYAQ '
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x03CAI'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x11CANDRABINDU ABOVE'
'\x04CANO'
'\x05CANUS'
'\x04CAP '
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\tCAPITAL I'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x04CASE'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\x05CCOLI'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\x05CECAK'
'\x05CECEK'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\nCENTRE TO '
'\x07CENTRED'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x08CER BALL'
'\x06CER-WA'
'\x05CEREK'
'\x0eCERTAINTY SIGN'
'\x06CEVITU'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x11CHA WITH TWO DOTS'
'\x06CHAMKO'
'\tCHANICAL '
'\x14CHARACTER INTRODUCER'
'\x0cCHARACTER-18'
'\x0cCHARACTER-1B'
'\x05CHART'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x11CHEH WITH SMALL V'
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x06CHESS '
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x05CHIME'
'\x08CHINESE '
'\x0bCHING CHICK'
'\x06CHIRET'
'\x03CHO'
'\x04CHO '
'\x05CHOOI'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x03CHU'
'\x06CHURCH'
'\x05CHUTE'
'\x04CHWA'
'\nCIA SYMBOL'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x04CIM '
'\x06CIRCLE'
'\rCIRCLE INSIDE'
'\x12CIRCLE NUKTA ABOVE'
'\x0fCIRCLE WITH DOT'
'\x08CIRCLED '
'\nCIRCLED CA'
'\x0cCIRCLED PLUS'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x11CIRCLES WITH DOTS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\rCITATION MARK'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0bCK SEXTANT-'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x1dCKED FACE WITH EXPLODING HEAD'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x05CKING'
'\x05CKTIE'
'\x02CL'
'\x07CLEAVER'
'\x08CLIMBING'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x17CLUSTER-INITIAL LETTER '
'\x02CO'
'\x07COASTER'
'\x06CODILE'
'\x08COENG QA'
'\nCOLATE BAR'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\nCOMPONENT '
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x16CONSONANT MODIFIER BAR'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x16CONSONANT SIGN MEDIAL '
'\x11CONSONANT SIGN PA'
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x04COON'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x07CORDION'
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0bCREDIT SIGN'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x15CROSSE STICK AND BALL'
'\x07CROSSED'
'\x0cCROSSED-TAIL'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GABA'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x04CURL'
'\nCURLED WAW'
'\x08CURLICUE'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY HAIR'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x04D HA'
'\x0bD MIDDLE UP'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x08D SYMBOL'
'\x1bD WITH SHORT STROKE OVERLAY'
'\x0eD-UP NEWSPAPER'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\x07DA FACE'
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DA2'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\tDATE MARK'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDDA'
'\x04DDHI'
'\x05DDING'
'%DDLE THIRD WHITE RIGHT POINTING INDEX'
'\x08DDY BEAR'
'\x02DE'
'\x06DE DOG'
'\x18DE INVERTED BRIDGE BELOW'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\nDED PERSON'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\x16DEOGRAPHIC TALLY MARK '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\x03DES'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x06DGEHOG'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x07DHALATH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\tDIAERESIS'
'\rDIAERESIZED U'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\rDIC MARK SIGN'
'\x0cDICTION SIGN'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x08DIM GUNU'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x04DIUM'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x03DNA'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'#DOLLAR SIGN WITH OVERLAID BACKSLASH'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x0fDOT PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x10DOTTED CRESCENTS'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\x1cDOUBLE ANUSVARA ANTARGOMUKHA'
'\nDOUBLE BAR'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\rDOUBLE MUCAAD'
'\x0fDOUBLE ORNAMENT'
'\x0bDOUBLE RING'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x16DOUBLE-LINED HEAD MARK'
'\x04DOWN'
'\x05DOWN '
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\x18DOWNSCALING FACTOR KIIZH'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'"DOWNWARDS ARROW WITH TIP LEFTWARDS'
'\x0fDOWNWARDS TREND'
'\x02DR'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\tDRAM SIGN'
'\x05DRESS'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x03DUG'
'\x0cDUG TIMES NI'
'\tDUN3 GUNU'
'\x0eDUN3 GUNU GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x05DWICH'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\tE AT LEFT'
'\x14E CONSONANT MODIFIER'
'\x07E DRINK'
'\x05E GEE'
'\x07E GLASS'
'\x06E HOOK'
'\x11E LIGHT MOON ARTA'
'\x05E OF '
'\x08E OF POO'
'\x0cE OF WORSHIP'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\x10E PLUS GAN2 TENU'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E-'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x04EANS'
'\nEARLY FORM'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EATH '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'\x08ED BRICK'
'\x06ED CAP'
'\x07ED FACE'
'\nED FINGERS'
'\x06ED ICE'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x0eED PARAGRAPHOS'
'\tED PLANET'
'\x07ED RICE'
'\tED SYMBOL'
'\x0eED SYMBOL FOR '
'\tEDESTRIAN'
'\nEDESTRIANS'
'\x06EDIAL '
'\x05EDIC '
'\rEDIC ANUSVARA'
'\x0bEDICAL MASK'
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\rEELING PERSON'
'\x03EEM'
'\x04EEM '
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x06EENTH-'
'\x06EENTHS'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x02EF'
'\tEFAIDRIN '
'\x10EFORE COMPLETION'
'\tEFORMED T'
'\x03EFT'
'\x04EFT '
'-EFT AND LOWER TRIANGULAR THREE QUARTERS BLOCK'
'\x15EFT HORIZONTAL SECANT'
'\x08EFT TACK'
'\x15EFT-POINTING TRIANGLE'
'\x14EFTWARDS ARROW WITH '
'\x0fEFTWARDS ARROWS'
'\x0cEGIN SEGMENT'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\x0eEH WITH SMALL '
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x05EIDON'
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\rEIGHTHS BLOCK'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x16EIGHTY ON BLACK SQUARE'
'\x03EIN'
'\x04EIPT'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x08ELEPHANT'
'\x03ELF'
'\x03ELI'
'\x03ELL'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x03ELT'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0bEN STRAIGHT'
'\x0bEN THOUSAND'
'\x0bEN TWELFTHS'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x08ENICIAN '
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\tENTRY SAW'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x08ENVELOPE'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x08EOUT BOX'
'\x03EOW'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x04EPHA'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\nEQUIHOPPER'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\rER BOARD FILL'
'\tER BUBBLE'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x05ERN W'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x0eERTICAL JOINER'
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\tES AKURU '
'\x03ES-'
'\x03ESC'
'\x08ESCENDER'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x06ESTAN '
'\x02ET'
'\x03ET '
'\x06ET KUT'
'\x08ET SHOES'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
' ETNAMESE ALTERNATE READING MARK '
'\x04ETOS'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\tETTER SHA'
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\nEUTRAL YER'
'\x03EUX'
'\nEVAL COMMA'
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x12EVEN EIGHTHS BLOCK'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\rEVEN TWELFTHS'
'\x08EVENTEEN'
'\x06EVENTY'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0eEXCLAMATION OH'
'\x06EXHALE'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EYK'
'\nEZING FACE'
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\rF WITH STROKE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x06FAMILY'
'\x04FAST'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FETH'
'\x05FETY '
'\x04FEUQ'
'\x06FF OF '
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x04FFLE'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIER '
'\x05FIFTY'
'\x06FIFTY '
'\x08FILE BOX'
'\x06FILLER'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\x14FINAL CONSONANT MARK'
'\x15FINAL CONSONANT SIGN '
'\rFINAL LETTER '
'\x0eFINAL LETTER G'
'\tFINAL NGA'
'\tFINAL NUN'
'\x08FINAL TH'
'\x07FINAL Y'
'\x08FINGER C'
'\x1bFINGER COVERING CLOSED LIPS'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x04FIVE'
'\x05FIVE '
'\x12FIVE EIGHTHS BLOCK'
'\x13FIVE FINGERS SPREAD'
'\x0cFIVE HUNDRED'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x05FLAME'
'\x15FLATTENED PARENTHESIS'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLICT'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\nFLUTTERING'
'\x03FLY'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x04FOR '
'\x08FOR STOP'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x06FORMEE'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x12FORTY-FIVE DEGREES'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\nFOUR BELOW'
'\tFOUR BENT'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\rFRACTION ONE '
'\x11FRACTION ONE HALF'
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x08FROM BAR'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT RERENGGAN'
'\x13FT-POINTING FLEURON'
'\x05FTEEN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x02FU'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x03GAF'
'\x03GAG'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x03GAR'
'\rGAR FRACTION '
'\x08GARITIC '
'\x05GAROO'
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x05GAZE-'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x06GDIAN '
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x07GEMINAT'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x07GENERAL'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\nGER BUBBLE'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x05GGAGE'
'\x05GGER '
'\nGGING FACE'
'\x05GGLES'
'\x06GGLING'
'\x0fGGLY LINE BELOW'
'\x12GGLY VERTICAL LINE'
'\nGGRAVATION'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x0eGHT WITH STARS'
'\x06GHTLY '
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\x04GIDA'
'\x04GIEA'
'\rGIFT ENVELOPE'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GIR2'
'\x04GISH'
'\x12GISH CROSSING GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x0eGMENTED DIGIT '
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x08GOLITIC '
'\x0bGONEK ABOVE'
'\x04GONG'
'\x03GOU'
'\x07GRADUAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x05GRAPH'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0bGREEK CROSS'
'\x06GREEN '
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x0bGUISED FACE'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x0eGUNU TIMES ASH'
'\x03GUR'
'\x05GVANG'
'#GVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x02GW'
'\x02GY'
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x03HAB'
'\x05HADDA'
'\x03HAF'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x1aHAIN WITH THREE DOTS ABOVE'
'\x12HAIS LUS NTOG NTOG'
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x04HALA'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x11HALF BLACK CIRCLE'
'\x14HALF CIRCLE WITH DOT'
'\x08HALF GUR'
'\x06HALF H'
'\x11HALF MEDIUM SHADE'
'\tHALF NOTE'
'\x0fHALF RING ABOVE'
'\tHALF SIGN'
'\x05HALF-'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\nHAMZA MARK'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x13HAND COVERING MOUTH'
'\x0cHAND FORMAT '
'\tHAND SIGN'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x05HANNA'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\x08HARBAHAY'
'\tHARD SIGN'
'\x06HARIOT'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x04HAYN'
'\x02HD'
'\x02HE'
'\x03HE '
'\x03HEA'
'\x04HEAD'
'\x05HEAD '
'\tHEAD MARK'
'\x1bHEAD MARK WITH MOON AND SUN'
'\x0cHEAD-BANDAGE'
'\x13HEAD-SHAPED POINTER'
'\x07HEADING'
'\tHEADSCARF'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x0bHEATED FACE'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x08HEAVY YA'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x06HELMET'
'\nHEMATICAL '
'\x12HEN WITH DIAERESIS'
'\x04HENG'
'\x03HER'
'\rHER CHRISTMAS'
'\x06HERMES'
'\nHERMOMETER'
'\x04HERO'
'\x04HERU'
'\x06HESHIG'
'\x0eHESIVE BANDAGE'
'\x08HESPIAN '
'\x05HESS '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x07HEXAGON'
'\x16HEXIFORM LONG ANUSVARA'
'\x04HEYN'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\rHI TIMES ASH2'
'\x0cHIBITED SIGN'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x04HIGH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x03HII'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\x03HIM'
'\tHIMA SIMA'
'\x05HIMEL'
'\x03HIN'
'\rHINESE TONE Y'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x07HIRTEEN'
'\x05HIRTY'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x08HITTING '
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x04HMI '
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOM'
'\x04HOM '
'\x03HOO'
'\x04HOOK'
'\x05HOOK '
'\rHOOK AND TAIL'
'\tHOOK MARK'
'\tHOOK TAIL'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x0fHORIZONTAL FILL'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x1fHORIZONTAL WITH VERTICAL STROKE'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x05HORSE'
'\x06HORT A'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x13HORT STROKE OVERLAY'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\x08HOULDER '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\x06HREE D'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
' HREE DOTS POINTING UPWARDS BELOW'
'\x0cHREE FINGERS'
'\tHREE FOR '
'\x1cHREE HUNDRED FIFTEEN DEGREES'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x14HREE-DOT NUKTA ABOVE'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x04HSHU'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x02HU'
'\x04HUB2'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x03HUR'
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\x02HW'
'\x03HWA'
'\tHWA WITH '
'\x04HWAH'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x10HYPHENATION MARK'
'\x01I'
'\x02I '
'\x06I GUNU'
'\x06I HOOK'
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES BAD'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x05I-RES'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x06IAMOND'
'\x07IAMOND '
'\x04IAN '
'\x0bIAN LETTER '
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x1aIANGULAR ONE QUARTER BLOCK'
'\x04IARA'
'\x05IARDS'
'\x05IAUDA'
'\x06IB YAM'
'\x02IC'
'\nIC LETTER '
'\x07IC WAND'
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\nICK FIGURE'
'\x05ICKET'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x06IDE ES'
'\x10IDED GREEK CROSS'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x03IDO'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IETH'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\rIFI ROHINGYA '
'\x06IFIED '
'\x07IFIED E'
'\x06IFTEEN'
'\x04IFTH'
'\x04IFTY'
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\nIGATING RA'
'\x13IGATURE AYIN-DALETH'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x12IGATURE ZAYIN-YODH'
'\x06IGGLES'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\nIGHT ANGLE'
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\tIGHT TACK'
'\rIGHT TWELFTHS'
'\x17IGHT-SHADED WHITE ARROW'
'\x07IGHTEEN'
'\tIGHTH ASH'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\x0cIGN AVAGRAHA'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\tIGN TOMPI'
'\x12IGSAW PUZZLE PIECE'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x03IL '
'\x07IL DRUM'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\x12IN POSSESSION SIGN'
'\tIN SQUARE'
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x10INDEPENDENT SHIN'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\nINDU BELOW'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x08ING FACE'
'\tING GLOVE'
'\x08ING HAND'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\tING LANES'
'\nING LITTLE'
'\x08ING MASK'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x0cING ROTATED '
'\x13ING SHIRT WITH SASH'
'\tING STONE'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x06INHALE'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x11INITIAL LETTER RA'
'\nINITIAL RA'
'\x06INKING'
'\x05INNA '
'\x07INNABAR'
'\tINNYIIYHE'
'\nINOCULAR O'
'\x0eINOLOGICAL DOT'
'\x0eINSERTION SIGN'
'\x06INSHIP'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
')INVERSE MEDIUM SHADE AND LOWER HALF BLOCK'
')INVERSE MEDIUM SHADE AND RIGHT HALF BLOCK'
'\x0cINVERTEBRATE'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INY '
'\x04INYA'
'\x03ION'
'\x08ION MARK'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x05IRACY'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'#IRCLE CONTAINING BLACK SMALL CIRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x06IRCLES'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x0eIRCULAR VIRAMA'
'\x05IRCUT'
'\x1eIRD WHITE RIGHT POINTING INDEX'
'\x04IRED'
'\x04IRON'
'\x08IRPLANE '
'\x0cIRST SUBUNIT'
'\x06IRTEEN'
'\x04IRTY'
'\x0bIRTY-SECOND'
'\x03IRY'
'\x02IS'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\rISH LIRA SIGN'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x0eISSION TICKETS'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x0eITALIC LETTER '
'\x15ITALIC SMALL DOTLESS '
'\x12ITAN SMALL SCRIPT '
'\x06ITARY '
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x0eITERATION MARK'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\x05ITLO '
'\x03ITO'
'\tITRA SIGN'
'\x04ITSA'
'\x07ITTING '
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\rIVE SLOW SIGN'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x0bIVERY TRUCK'
'\x07IVISION'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x06IXTEEN'
'\nIXTHS DISH'
'\x04IXTY'
'\x14IXTY ON BLACK SQUARE'
'\x06IXTY P'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x03IYO'
'\x0fIZED WHEELCHAIR'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x0bJEEM WITH T'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x03JOA'
'\x06JOINED'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\nJONG TILE '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x07K WITH '
'\rK WORK SYMBOL'
'\x02K-'
'\x05K-020'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x08KAIYARAA'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x03KAM'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x05KAROR'
'\x06KASAR '
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x03KAU'
'\x06KAVYKA'
'\rKAVYKA ABOVE '
'\x06KAYAH '
'\x05KBALL'
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\tKEN HEART'
'\x05KERET'
'\x05KESH2'
'\x03KET'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x02KH'
'\x07KHA YAT'
'\x04KHAH'
'\x07KHAMTI '
'\x14KHAMTI REDUPLICATION'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x07KIEVAN '
'\x06KILLER'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING BOOT'
'\tKING FACE'
'\x04KINI'
'\rKISIM5 TIMES '
'\x0fKISIM5 TIMES BI'
'\x04KISS'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x07KKURUNI'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x03KOI'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x02KS'
'\x0bKTIESELSKAB'
'\x05KTOP '
'\x02KU'
'\x03KU3'
'\x03KUE'
'\x03KUG'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x02KW'
'\x05KWAEN'
'\x06KY WAY'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL OF THREAD'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x04LAAM'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x0bLACK CIRCLE'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x0bLACKLETTER '
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x03LAI'
'\x07LAK-050'
'\x04LAKH'
'\tLAKH MARK'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\x04LAMA'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\nLANE MERGE'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x03LAP'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\tLARGEMENT'
'\x03LAS'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x08LATION X'
'\x15LATTENED OPEN A ABOVE'
'\x03LAU'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x04LBOX'
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDE '
'\x04LDER'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x0cLEADING EYES'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x08LEANING '
'\x05LEASE'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\rLEFT CROSSBAR'
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x08LEFT TO '
'\x13LEFT U-SHAPED ARROW'
'\nLEFT-HAND '
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x17LEFT-SHADED WHITE ARROW'
'\x12LEFT-STEM TONE BAR'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\x03LEG'
'\x03LEI'
'\nLEK ATTAK '
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x05LENIS'
'\x04LEPH'
'\x03LES'
'\x08LESS SHA'
'\x08LESSER Y'
'\x03LET'
'\x04LETH'
'\x0bLETION MARK'
'\x06LETTER'
'\x07LETTER '
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x15LETTER SMALL CAPITAL '
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x02LF'
'\x03LF '
'\x07LF FACE'
'\x03LFA'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x11LIAN HIEROGLYPH A'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x03LIF'
'\x04LIFI'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\nLIMITATION'
'\x04LINE'
'\x05LINE '
'\x0eLINE EXTENSION'
'\x0bLINE FILLER'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x04LIPS'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x08LL MOON '
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x07LLEYBUS'
'\x06LLHORN'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\nLLOW HEART'
'\x10LLOW PAN OF FOOD'
'\x07LLOWING'
'\tLLY MARK '
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOAN '
'\x05LOBE '
'\x08LOCATION'
'\x04LOCK'
'\x0eLOCK DIAGONAL '
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x04LONG'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG FINAL'
'\x0fLONG HOOK BELOW'
'\nLONG OVER '
'\tLONG TIP '
'\nLONG TSHEG'
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\x07LOTTAL '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x0eLOTUS POSITION'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\nLOW KAVYKA'
'\x16LOW PARAPHRASE BRACKET'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x08LOW TONE'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x06LOWER '
'\x0cLOWER CENTRE'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x1bLOWER MIDDLE LEFT TO LOWER '
'\x12LOWER MIDDLE RIGHT'
'\x16LOWER ONE EIGHTH BLOCK'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x17LSCHREIBER PAUSE SYMBOL'
'\x02LT'
'\tLT SHAKER'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\x10LTERNATE HASANTA'
'\nLTERNATE U'
'\x0bLTERNATE YA'
'\nLTIC CROSS'
'\x06LTILLO'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x0cLU PLUS ESH2'
'\x0bLU PLUS IGI'
'\x03LU3'
'\x03LUB'
'\x04LUE '
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x03LUS'
'\x05LWAY '
'\x02LX'
'\x02LY'
'\x04LY H'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x08M SYMBOL'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\nMADDA MARK'
'\x06MADDAH'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\nMALAYALAM '
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\nMALL ALEPH'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x06MALL F'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x13MANCHU ALI GALI LHA'
'\x08MANDARIN'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAQ'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\nMARK ABOVE'
'\tMARK CIM '
'\x0eMARK LOWER DOT'
'\tMARK SHAD'
'\rMARKS CHAPTER'
'\x08MARRATAN'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x03MAY'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x0bMBLER GLASS'
'\x05MBOL '
'\x07MBOL B0'
'\tMBOL FOR '
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x06ME DIE'
'\nME PLUS EN'
'\x08MEASURE '
'\x04MED '
'\x05MEDAL'
'\x0cMEDARY CAMEL'
'\x07MEDIAL '
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHADE'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x07MENIAN '
'\x05MENOE'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x06MERANG'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x0bMIC LETTER '
'\x0bMICAL HEART'
'\x03MID'
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE HOOK'
'\x15MIDDLE LEFT TO LOWER '
'\x15MIDDLE LEFT TO UPPER '
'\x0cMIDDLE RIGHT'
'\x1cMIDDLE RIGHT TO LOWER CENTRE'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIM'
'\x04MIIN'
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\nMILLE SIGN'
'\x08MILLIONS'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\rMINDER RIBBON'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\x05MINGO'
'\nMINO TILE '
'\x1eMINTON RACQUET AND SHUTTLECOCK'
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\nMISMA SIGN'
'\x05MISRA'
'\x03MIT'
'\x04MIZE'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x05MMOTH'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'\x1aMODIFIER FITZPATRICK TYPE-'
'\x10MODIFIER LETTER '
'"MODIFIER LETTER LABIALIZATION MARK'
'\rMODIFIER MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\x0bMONOCULAR O'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x04MPET'
'\x05MPIRE'
'\x03MPL'
'\x06MPLING'
'\x05MROCK'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x18MTAVRULI CAPITAL LETTER '
'\x02MU'
'\x04MUAS'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x08MULTIPLE'
'\x15MULTIPLE MEASURE REST'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x0fNA DOUBLE HELIX'
'\tNA KHONNA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x05NADA '
'\x03NAH'
'\x04NAKE'
'\nNAKE BELOW'
'\x03NAM'
'\x04NAM2'
'\x04NANT'
'\x03NAP'
'\x03NAR'
'\x0cNARROW SHAFT'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x03NAU'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\tNCH FRIES'
'\x05NCORA'
'\x13NCTUS ELEVATUS MARK'
'\x02ND'
'\x03ND '
'\x0bND ODD SIGN'
'\x0bND OF PIECE'
'\nND SEGMENT'
'\x15ND TELEPHONE RECEIVER'
'\x0bND TWO DOTS'
'#ND UPPER AND LOWER ONE EIGHTH BLOCK'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\nNDINAGARI '
'\x0cNDING PERSON'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\nNDU TEMPLE'
'\x04NDUE'
'\x02NE'
'\x03NE '
'\x11NE EYEBROW RAISED'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x06NE OF '
'\x10NE QUARTER BLOCK'
'\x04NED '
'\x08NED FOOD'
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x03NEL'
'\x04NEMA'
'\x05NENOE'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x03NET'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x0bNEUTRAL YER'
'\x03NEY'
'\x07NFINITY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x03NG '
'\x08NG ABOVE'
'\x0bNG LEFT LEG'
'\tNG SANDAL'
'\x11NG STROKE OVERLAY'
'\x14NG WITH CROSSED-TAIL'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\tNGER SHIP'
'\x05NGINE'
'\nNGLICANA W'
'\x03NGS'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x05NGUE '
'\tNGUN SIGN'
'\x04NHAY'
'\x02NI'
'\x08NI ABOVE'
'\x03NIE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\x05NIGHT'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x0bNIKOLSBURG '
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x08NINETEEN'
'\x06NINETY'
'\x0eNINETY DEGREES'
'\tNING MOOD'
'\rNING MOVEMENT'
'\tNING SIGN'
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x03NJA'
'\x07NJAEMLI'
'\x0cNJALA GONDI '
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x03NNI'
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\nNOON ABOVE'
'\x0bNOON GHUNNA'
'\nNOON WITH '
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x0cNORTHERN TSE'
'\x04NOSE'
'\x05NOTCH'
'\x0cNOTCHED HOOK'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x06NOVILE'
'\x04NOWC'
'\x08NOWLEDGE'
'\x06NOWMAN'
'\x08NRES TOS'
'\x04NRUA'
'\x02NS'
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\tNSERT AT '
'\x04NSHE'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x07NSPLUTO'
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x10NTAIGANA LETTER '
'\x05NTAIN'
'\x18NTED NORTH ARROW WITH HO'
'\tNTESSENCE'
'\x05NTHA '
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x05NTXIV'
'\x02NU'
'\x03NUB'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUTS'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x03NYA'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x02O '
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\x11O LOWER LEFT FILL'
'\x12O LOWER RIGHT FILL'
'\x06O MARK'
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x04O-YO'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x05OCADO'
'\x07OCALIC '
'\x08OCALIC M'
'\x08OCALIC R'
'\x07OCATION'
'\tOCCLUSION'
'\x06OCENCE'
'\x03OCK'
'\x08OCK SALT'
'\x05OCKET'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x03ODA'
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\nOF HYGIEIA'
'\x0bOF MASHFAAT'
'\x07OF SOAP'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x02OG'
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0cOGOGRAM NYAJ'
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x06OITIC '
'\x04OJI '
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\x05OKARA'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x07OLAPUK '
'\x03OLD'
'\x04OLD '
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x10OLD WHITE CIRCLE'
'\x05OLDER'
'\x0bOLDING BACK'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x05OLLON'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x03OM '
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\x0bOMAN SIYAQ '
'\x08OMANIAN '
'\x05OMBIE'
'\tOMBINING '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x0eOMING ENVELOPE'
'\x04OMMA'
'\x05OMMAE'
'\x05OMMEE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x0fON BLACK SQUARE'
'\x08ON CROSS'
'\x07ON FACE'
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\rONAL COMPUTER'
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x10ONE EIGHTH BLOCK'
'\x11ONE EIGHTH BLOCK-'
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x1fONE HUNDRED THIRTY-FIVE DEGREES'
'\x14ONE HUNDRED THOUSAND'
'\x1bONE LARGE AND ONE SMALL EYE'
'\x14ONE MARK SGAW KAREN '
'\tONE MARK-'
'\x11ONE QUARTER BLOCK'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\tONG GRAVE'
'\x05ONG S'
'\x0bONG S WITH '
'\rONG-LEGGED DE'
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x15ONIAN SIGN CAPITAL ET'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x10ONJOINING MACRON'
'\x06ONOCLE'
'\x1aONOMICAL SYMBOL FOR URANUS'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x04ONUT'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\nOON SELENA'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x03OPH'
'\x0cOPLE HUGGING'
'\x05OPLET'
'\x04OPOD'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x0bORCE SYMBOL'
'\x04ORD '
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x10ORIZONTAL JOINER'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nOROME SIGN'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x06OSING '
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\tOTAL SIGN'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x0cOTTOM HALF O'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\x0cOUGHT BUBBLE'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\tOURA SIGN'
'\x07OURTEEN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\nOUT HANDLE'
'\x07OUT HUB'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\tOUTH WIND'
'\nOUTHERN TA'
'\x04OVAL'
'\x15OVAL WITH OVAL INSIDE'
'\x05OVER '
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\tOVER LONG'
'\tOVER MUSH'
'\x16OVER NU11 BUR OVER BUR'
'\x08OVER NUN'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SAG'
'\x08OVER SHE'
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x05OWER '
'\x03OWN'
'\rOWN POINTING '
'\x15OWN-POINTING TRIANGLE'
'\x03OX '
'\x07OX BACK'
'\x02OY'
'\x07OYSTICK'
'\x03OZE'
'\x06OZENGE'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\tP ELAMITE'
'\x07P PIEET'
'\x0cP TACK ABOVE'
'\x07P WITH '
'\x17P WITH EXCLAMATION MARK'
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x05PALI '
'\x07PALLAWA'
'\x04PALM'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x0ePARATED SYMBOL'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\nPASSIMBANG'
'\x04PAWN'
'\rPAWN ROTATED '
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x0cPE CARTRIDGE'
'\x11PE WITH DESCENDER'
'\x06PEAKS '
'\x0cPEECH BUBBLE'
'\x04PEEI'
'\x04PEEP'
'\x0fPEH WITH SMALL '
'\x03PEN'
'\x04PEN '
'\x05PEN E'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\x0fPEN SQUARED DOT'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\tPENT SIGN'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x06PEPPER'
'\x03PER'
'\x04PER '
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x08PERSIAN '
'\x06PERSON'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x04PHAB'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\x06PICKET'
'\x07PICTURE'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PING '
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x0bPLACEHOLDER'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\nPLE DAGGER'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x07PLOYAN '
'\x04PLUG'
'\x04PLUM'
'\x05PLUS '
'\nPLUS ERIN2'
'\x14PLUS GISH TIMES TAK4'
'\x08PLUS LAL'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x18POINTING DOWNWARDS ABOVE'
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x07POMOFO '
'\x05PONSE'
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\x03POT'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\tPPOINTED '
'\nPPOPOTAMUS'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\tPREFIXED '
'\x13PREFIXED NASAL SIGN'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x06PRINTS'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x07PSTICKS'
'\x05PTIVE'
'\x0ePTUNE FORM TWO'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x17PUNCTUATION END OF TEXT'
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x07PURPLE '
'\x08PUSHPIKA'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x06PWATCH'
'\x01Q'
'\x07Q WITH '
'\x10Q WITH HOOK TAIL'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\tQUADCOLON'
'\x0fQUADRUPLE ARROW'
'\x13QUADRUPLE CRESCENTS'
'\x0bQUALS SIGN '
'\x05QUARE'
'\x06QUARE '
'\x06QUARED'
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x0cQUARTER SIGN'
'\x08QUARTERS'
'\x0eQUARTERS BLOCK'
'\rQUARTERS SIGN'
'\x05QUEEN'
'\tQUEEN OF '
'\x0eQUEEN ROTATED '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x08QUINTILE'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x05R MUG'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x03R S'
'\x06R SIGN'
'\x07R WITH '
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x02R0'
'\x02R2'
'\x07R2 GUNU'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x03RA '
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RAAKAN'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x0bRADITIONAL '
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x04RAN '
'\x0cRANCHING OUT'
'\x06RANGE '
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x07RARIETY'
'\x05RASHA'
'\x08RASMIAN '
'\x03RAT'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x08RAUGHTS '
'\x06RAVEL-'
'\x03RAY'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\nRCHAIC KHA'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\nRDHACANDRA'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x04REAM'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x08RECEIVER'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\x04RED '
'\nRED DRAGON'
'\x08RED HAIR'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x04REE '
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x19REE-HUNDRED-AND-TWENTIETH'
'\x13REE-QUARTER CIRCLE '
'\x05REEK '
'\tREFORMED '
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x05RELAA'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x03REN'
'\x0cREN CROSSING'
'\x06RENGTH'
'\x04REPA'
'\x10REPETITION MARK-'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\nRESH BELOW'
'\tRESH-AYIN'
'\x10RESH-AYIN-DALETH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x0bREVE-MACRON'
'\x08REVERSE '
'\x0fREVERSE SOLIDUS'
'\tREVERSED '
'\nREVERSED I'
'\x0fREVERSED OPEN E'
'\x0eREVERSED-SCHWA'
'\x03REX'
'\x02RF'
'\x04RFER'
'\tRFUL FACE'
'\nRGE CIRCLE'
'\nRGE SQUARE'
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x03RI '
'\x0cRIAGE SYMBOL'
'\x0cRIAL TRAMWAY'
'\x07RIANGLE'
'\x12RIANGLE ARROWHEADS'
'\x16RIANGULAR MEDIUM SHADE'
'\x1bRIANGULAR ONE QUARTER BLOCK'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'/RIGHT AND LOWER TRIANGULAR THREE QUARTERS BLOCK'
'\x0eRIGHT CROSSBAR'
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x17RIGHT HORIZONTAL SECANT'
'\x14RIGHT POINTING INDEX'
'\x0fRIGHT RERENGGAN'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\tRIGHT TO '
'\x1bRIGHT TRIANGULAR HALF BLOCK'
'\x14RIGHT U-SHAPED ARROW'
'\x0bRIGHT-HAND '
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x14RIGHT-POINTING ANGLE'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'"RIGHTWARDS THEN CURVING SOUTH WEST'
'\x03RII'
'\x06RIKRIK'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\nRING BELOW'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\nRING THUMB'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RINKLES'
'&RIOUS FACE WITH SYMBOLS COVERING MOUTH'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x07RIPPLE '
'\x05RIPT '
'\x06RIPT G'
'\tRIS FORM '
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x03RK '
'\rRK SUNGLASSES'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x04RLIC'
'\x06RLICUE'
'\x03RMT'
'\x07RMUKHI '
'\x05RNED '
'\x13RNISH VERSE DIVIDER'
'\x02RO'
'\x03RO '
'\x03ROA'
'\x05ROACH'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\x06ROCKET'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x0cROLLING EYES'
'\x03ROM'
'\x03RON'
'\x05RONOS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROOK'
'\rROOK ROTATED '
'\x04ROSH'
'\x04ROSS'
'\x0eROSS ON SHIELD'
'\x08ROSSED O'
'\x0bROSSED-TAIL'
'\x03ROT'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\x03ROW'
'\x05ROWN '
'\rRPENTRY PLANE'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\x05RRITO'
'\x04RROR'
'\x04RROW'
'\x05RROW '
'\x11RROW SHAFT WIDTH '
'\nRROW WITH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x04RSO-'
'\x02RT'
'\rRTABLE STEREO'
'\tRTER MARK'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x03RUM'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x05RUMP-'
'\x04RUNG'
'\x04RUNI'
'\x0bRUNNING MAN'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x13RY CULTIVATION SIGN'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0cS ABOVE SIGN'
'\x07S BELOW'
'\x1dS DIGRAPH WITH RETROFLEX HOOK'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\rS UP TOGETHER'
'\x07S-SAJDA'
'\x08S-SERIF '
'\x02S0'
'\x02SA'
'\x07SA VAH '
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAD'
'\x05SADHE'
'\x03SAG'
'\x03SAH'
'\x05SAKIN'
'\x05SAKTA'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x1cSALTIRE WITH ROUNDED CORNERS'
'\x03SAM'
'\x10SAMARITAN SOURCE'
'\x06SANDAL'
'\x07SANDHI '
'\x04SANG'
'\x07SANGAN '
'\x10SANS-SERIF ARROW'
'\nSANSKRIT S'
'\x03SAR'
'\x05SARGA'
'\x05SASAK'
'\x03SAU'
'\x06SAUCER'
'\x03SAW'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x07SCOOTER'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x08SCRIPT X'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEMICOLON'
'\x08SENTAGON'
'\x1cSENTATION FORM FOR VERTICAL '
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x07SERPINA'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x15SET PRECEDING SOLIDUS'
'\x13SEVEN EIGHTHS BLOCK'
'\x07SEVENTH'
'\x0fSEVENTY DEGREES'
'\x02SH'
'\x03SH '
'\x15SH AMPERSAND ORNAMENT'
'\x13SH PLUS HU PLUS ASH'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\tSHAB CEEB'
'\x04SHAD'
'\x15SHADOWED WHITE CIRCLE'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x12SHAN REDUPLICATION'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x07SHESHIG'
'\x0eSHESHIG TIMES '
'\x05SHGAB'
'\x03SHI'
'\x07SHIFT T'
'\x05SHIMA'
'\x04SHIN'
'\x05SHIRT'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x0bSHOGI PIECE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x08SHORT ER'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x14SHORT STROKE OVERLAY'
'\x05SHPIN'
'\x05SHTIN'
'\x04SHU '
'\x04SHU2'
'\x10SHU2 PLUS KASKAL'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\nSIDEWAYS I'
'\x14SIDEWAYS NOON GHUNNA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x10SIGN CANDRABINDU'
'\x08SIGN LAE'
'\x11SIGN O WITH CROSS'
'\rSIGN OVERLINE'
'\x10SIGN PALI VIRAMA'
'\x07SIGN UD'
'\x03SII'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\rSIX LATE FORM'
'\x04SIXT'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x13SLANTED NORTH ARROW'
'\x05SLASH'
'\x05SMALL'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'\x1dSMALL ARABIC LETTER TAH ABOVE'
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\x07SMALL W'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\x02SO'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x07SOLDIER'
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x06SOUTH '
'\x0cSOUTHERN TSE'
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x05SPINE'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x03SQU'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x07SQUARES'
'\x08SQUEEZED'
'\x0cSQUIQUADRATE'
'\x02SS'
'\nSS OF MILK'
'\x03SSA'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x03SSI'
'\x1aSSIAN ASTROLOGICAL SYMBOL '
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x07ST TUBE'
'\nST-FEEDING'
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x05START'
'\x07STATERS'
'\x0bSTEAMY ROOM'
'\tSTEBASKET'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x04STLE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x05STONE'
'\x04STOP'
'\x0bSTORIC SITE'
'\x03STR'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x0cSTROKE BELOW'
'\x18STROKE THROUGH DESCENDER'
'\x0eSTRONG ISOLATE'
'\nSTRUCTION '
'\x1bSTRUMENTAL NOTATION SYMBOL-'
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUCK'
'\x06SUCKED'
'\x04SUKU'
'\x06SULAR '
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x03SUS'
'\x03SUU'
'\x07SVARITA'
'\x0bSVASTI SIGN'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\x06SWORDS'
'\x02SY'
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x05T OF '
'\tT OF MEAT'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x0cTACKED COMMA'
'\x05TAGON'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x0fTAI LAING TONE-'
'\x08TAI LUE '
'\x04TAIL'
'\nTAIL GLASS'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\nTAMAN SIGN'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x03TAR'
'\x08TAR EYES'
'\x06TARGET'
'\x11TARTING FROM SIGN'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAW'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\nTCOIN SIGN'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x04TEAR'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\tTED PLANT'
'\x06TEDUNG'
'\x03TEE'
'\x04TEEN'
'\x05TEGEH'
'\tTEH ABOVE'
'\x10TEH WITH SMALL V'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENSE'
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
'\x0eTERMINAL MARK-'
'\x0cTERNATE AYIN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x0bTH-THALATHA'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x06THAKKU'
'\x07THALIYA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x04THER'
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x07THIEUTH'
'\x05THING'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOSCOPE'
'\x08THOUSAND'
'\tTHOUSAND '
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0fTHREE DISH TENU'
'\x10THREE DOTS ABOVE'
'\x0cTHREE HEARTS'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x03THW'
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x04TIC '
'\x06TICAL '
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x07TIKRAMA'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES KUR'
'\tTIMES NA2'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\tTIN CROSS'
'\x05TING '
'\nTING DOLLS'
'\nTING HEART'
'\x0bTION BOTTLE'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x03TIU'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x07TLESS J'
'\x05TMAAU'
'\x02TO'
'\x06TO BAR'
'\x08TO FORM '
'\x0fTO LOWER CENTRE'
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x0bTONAL MARK '
'\x04TONE'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x05TONE-'
'\x06TONGUE'
'\x04TOP '
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x05TRACK'
'\x0cTRAGRAM FOR '
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x04TRAP'
'\x03TRE'
'\tTREDECILE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x03TRI'
'\x08TRI DISH'
'\x0bTRIAN CAMEL'
'\x08TRIANGLE'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x15TRIANGULAR HALF BLOCK'
'\x0fTRIANGULAR MARK'
'\x17TRIANGULAR MEDIUM SHADE'
'\x1cTRIANGULAR ONE QUARTER BLOCK'
'\x08TRICOLON'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x0cTRIPLE FLAME'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'!TRONG CENTRALIZATION STROKE BELOW'
'\x03TSA'
'\x03TSE'
'\x05TSEEB'
'\x05TSHEG'
'\x02TT'
'\x03TTA'
'\x03TTE'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x04TTER'
'\x05TTER '
'\x05TTERN'
'\x05TTOCK'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x03TUJ'
'\x04TUKI'
'\tTUKWENTIS'
'\x0bTUNE COOKIE'
'\x03TUP'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\x05TURN '
'\x07TURNED '
'\nTURNED AYB'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x13TURNED SECTION MARK'
'\x0eTURNED W BELOW'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x13TWENTY-FIVE DEGREES'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\x1bTWO HUNDRED SEVENTY DEGREES'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x12TYPE A ELECTRONICS'
'\x07TYSCAPE'
'\x04TZEL'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x05U U U'
'\x07U WITH '
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x02U0'
'\x02U2'
'\nU2 PLUS BA'
'\x02U3'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUAL WHEELCHAIR'
'\x03UAM'
'\nUAM TSHOOJ'
'\x06UANGXI'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB '
'\x03UB2'
'\x03UBE'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x08UBJOINER'
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x10UBLE PARENTHESIS'
'\x06UBLE R'
'\x0fUBLE RING BELOW'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x05UDAAT'
'\x06UDATTA'
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\x03UG2'
'\x06UGGAGE'
'\x0cUGHT BALLOON'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x04UHUR'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x04UKTA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x05ULAR '
'\x07ULATION'
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULT'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x03UM '
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x12UM WITH DRUMSTICKS'
'\x04UMAN'
'\nUMAN EARTH'
'\x0bUMAN FIGURE'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\x0cUNBLENDED UK'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x03UND'
'\x05UNDER'
'\x06UNDER '
'\x08UNDERTIE'
'\x07UNDRED '
'\x1aUNEVEN EYES AND WAVY MOUTH'
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x11UP POINTING INDEX'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\x08UP TRUCK'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'\x06UPPER '
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x17UPPER CENTRE TO MIDDLE '
'+UPPER CENTRE TO MIDDLE LEFT TO LOWER CENTRE'
'\x1cUPPER CENTRE TO MIDDLE RIGHT'
'\x1bUPPER MIDDLE LEFT TO UPPER '
'\x12UPPER MIDDLE RIGHT'
'\x16UPPER ONE EIGHTH BLOCK'
'\x10UPPER OVER LOWER'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\x17UPWARDS THEN NORTH WEST'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\x06UR OF '
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URL'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'\tURNED GAN'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x0bURRENT SIGN'
'\x03URT'
'\x03URU'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US MARK'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\x06USHPIN'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x06USTER-'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\x04UTAN'
'\x05UTEUX'
'\x04UTH '
'\x0cUTH ARABIAN '
'\x0bUTH CORNERS'
'\nUTH OR SPY'
'\x05UTIES'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\tUVUZHAKKU'
'\x02UX'
'\x02UZ'
'\x07UZHAKKU'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02VA'
'\x03VAA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x07VAPOURS'
'\x07VARIANT'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x05VATOR'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\x08VE SASAK'
'\tVE THUMB '
'\x03VE-'
'\x04VEDE'
'\x0eVEDIC ANUSVARA'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\tVELOPMENT'
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\nVERAGE BOX'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\rVERLAY MIDDLE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x13VERTICAL BAR VIRAMA'
'\x17VERTICAL BAR WITH QUILL'
'\rVERTICAL BARS'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VES'
'\x08VESSEL B'
'\x04VEST'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x10VIEWING CEREMONY'
'\tVIGINTILE'
'\x07VILLAIN'
'\x03VIN'
'\x04VINE'
'\tVINE LEAF'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC L'
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x08VOMITING'
'\x0eVONIC ASTERISK'
'\x03VOP'
'\x04VOS '
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VUU'
'\x02VW'
'\x03VY '
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x03WAN'
'\x05WAQFA'
'\x04WARD'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\tWASH TAIL'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x07WDRIVER'
'\x02WE'
'\x0bWE PALAUNG '
'\x05WELVE'
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x14WET CULTIVATION SIGN'
'\x05WFISH'
'\x02WG'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\nWHITE HAIR'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x0cWHITE SQUARE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\nWHOLE NOTE'
'\x02WI'
'\x05WIANG'
'\x04WIDE'
'\x05WIDTH'
'\x07WIFRUIT'
'\x07WIGNYAN'
'\x06WINDOW'
'\x05WINDU'
'\nWING HEART'
'\x0bWING NEEDLE'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x18WITH CANCELLATION STROKE'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x10WITH HEARING AID'
'\x13WITH INFINITY BELOW'
'\x12WITH JUSTIFICATION'
'\x0eWITH LEFT HOOK'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\nWITH SPOON'
'\nWITH STRAW'
'\x0cWITH STROKE '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x07WN FACE'
'\x08WN HEART'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x07WO DOTS'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\nWO FINGERS'
'\x07WO FOR '
'\x0bWO HUNDRED '
'\x06WO OF '
'\nWO SHORTS '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\x15WO-CIRCLE NUKTA ABOVE'
'\nWO-HEADED '
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\x06WRENCH'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x16XCLAMATION MARK SYMBOL'
'\x02XE'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x04XEYN'
'\x02XG'
'\tXHAUSTION'
'\nXHEEJ CEEV'
'\x02XI'
'\x08XIANGQI '
'\x06XIMIZE'
'\x05XING '
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x0bXTINGUISHER'
'\x15XTRA SHORT VOWEL MARK'
'\x05XTRA-'
'\x05XW XW'
'\x03XWG'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\x08Y BEETLE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x07Y GREEN'
'\x06Y LOOP'
'\x08Y POPPER'
'\x08Y SMALL '
'\x0eY SMALL SQUARE'
'\nY THOUSAND'
'\x07Y WITH '
'\x08Y-FOURTH'
'\tY-FOURTHS'
'\x03Y00'
'\x02YA'
'\x07YA LAMP'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x03YAN'
'\x0cYAN NUMERAL '
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x07YELLOW '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\x08YESIEUNG'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x0eYI WITH STROKE'
'\x16YIAKENG PUACHUE HMONG '
'\x03YIN'
'\x06YIN-DO'
'\nYING CARD '
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YIZET'
'\x0cYLEFT SYMBOL'
'\x08YLLABLE '
'\x12YLLABLE LENGTHENER'
'\x07YMAIC L'
'\x05YMBOL'
'\x06YMBOL '
'\nYMBOL AIVA'
'\x0cYMBOL BINDU '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x0cYOD TRIANGLE'
'\x04YODH'
'\x06YOMBO '
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x12YPTIAN HIEROGLYPH '
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x06YRENE '
'\x08YRILLIC '
'\x05YSTER'
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x1dZ DIGRAPH WITH RETROFLEX HOOK'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\nZAR AMULET'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x0fZERO WITH SLASH'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x03ZHE'
'\x03ZHI'
'\x02ZI'
'\tZIDA TENU'
'\x05ZIDI '
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\tZIR SASAK'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOA'
'\x03ZOO'
'\x03ZOR'
'\nZU OVER ZU'
'\x08ZWARAKAY'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68978,
 -53336,
 -1,
 132661,
 56507,
 -1,
 198179,
 103773,
 -1,
 263553,
 182235,
 -1,
 327930,
 228411,
 -1,
 393401,
 268874,
 74167,
 458852,
 358562,
 -1,
 524324,
 399159,
 -1,
 589846,
 463640,
 75009,
 720895,
 526997,
 -1,
 720910,
 646331,
 -1,
 -65524,
 704799,
 75019,
 -65523,
 736085,
 75018,
 -1,
 791339,
 75017,
 983057,
 708598,
 -1,
 -65520,
 935106,
 75016,
 -1,
 992333,
 75015,
 -65518,
 949381,
 75014,
 -65517,
 1145824,
 75013,
 -65516,
 1197171,
 75012,
 -65515,
 1255793,
 75011,
 -1,
 1320616,
 75010,
 1507362,
 529971,
 75021,
 1638399,
 1444501,
 -1,
 1638427,
 1563835,
 -1,
 -65510,
 1622303,
 75030,
 -1,
 1653589,
 75029,
 1835037,
 1600478,
 75024,
 -1,
 1770334,
 75025,
 -65506,
 1820277,
 75028,
 -65505,
 1944330,
 75027,
 -65504,
 2004643,
 75026,
 -65503,
 2054306,
 75023,
 -1,
 2114637,
 75022,
 -65501,
 1447269,
 75020,
 -1,
 2232817,
 75008,
 2424889,
 464238,
 -1,
 2490415,
 2364782,
 -1,
 2555950,
 2431384,
 74993,
 2686975,
 2493077,
 -1,
 2687019,
 2599654,
 -1,
 -65494,
 2665200,
 74997,
 -1,
 2722047,
 74996,
 -65492,
 2678086,
 74998,
 -65491,
 2845662,
 74995,
 -1,
 2907434,
 74994,
 -1,
 2494971,
 74992,
 3145780,
 2431384,
 -1,
 -65487,
 3085890,
 75006,
 -65486,
 3150928,
 75005,
 -65485,
 3216171,
 75004,
 -1,
 3281131,
 75003,
 3473463,
 3085890,
 -1,
 -65482,
 3414023,
 75000,
 -1,
 3477739,
 74999,
 -65480,
 3414414,
 75002,
 -1,
 3610818,
 75001,
 3801160,
 2363627,
 -1,
 3866685,
 3741927,
 -1,
 -65476,
 3805833,
 74974,
 -1,
 3870955,
 74973,
 4063296,
 3806786,
 -1,
 -65473,
 4002299,
 74970,
 -1,
 4067563,
 74969,
 4259907,
 4002603,
 -1,
 -65470,
 4200002,
 74967,
 -1,
 4264443,
 74966,
 -65468,
 4201017,
 74975,
 -65467,
 4397266,
 74972,
 -65466,
 4462585,
 74971,
 -65465,
 4527435,
 74968,
 -1,
 4592103,
 74965,
 4784212,
 3740459,
 -1,
 4849741,
 4723499,
 -1,
 -65461,
 4790503,
 74982,
 -65460,
 4855362,
 74981,
 -1,
 4919531,
 74980,
 5111888,
 4790071,
 -1,
 -65457,
 5052215,
 74985,
 -1,
 5117506,
 74984,
 5308499,
 5050875,
 -1,
 -65454,
 5249432,
 74979,
 -1,
 5312747,
 74978,
 -1,
 5248360,
 74983,
 5570653,
 4723792,
 -1,
 5636185,
 5510510,
 -1,
 -65449,
 5576935,
 74988,
 -65448,
 5642247,
 74987,
 -1,
 5706832,
 74986,
 5898332,
 5576935,
 -1,
 -65445,
 5838190,
 74990,
 -1,
 5903440,
 74989,
 -1,
 5839411,
 74991,
 6160480,
 5511175,
 -1,
 -65441,
 6100534,
 75032,
 -1,
 6165549,
 75031,
 6357091,
 6099451,
 -1,
 -65438,
 6297136,
 74977,
 -1,
 6362443,
 74976,
 -1,
 6297375,
 75007,
 6619315,
 415906,
 -1,
 6684845,
 6564103,
 74168,
 6815743,
 6619136,
 -1,
 6815916,
 6739457,
 -1,
 6881392,
 6756938,
 74169,
 6946925,
 6817567,
 -1,
 -65429,
 6913381,
 74172,
 -65428,
 6969679,
 74171,
 -1,
 7027727,
 74170,
 -65426,
 6931840,
 74175,
 -65425,
 7180960,
 74174,
 -1,
 7240763,
 74173,
 7405687,
 6872251,
 74213,
 7471220,
 7341855,
 -1,
 -65421,
 7462098,
 74215,
 -1,
 7477834,
 74214,
 -65419,
 7456070,
 74218,
 -65418,
 7617365,
 74217,
 -1,
 7672778,
 74216,
 7864448,
 7389652,
 -1,
 7929983,
 7822780,
 -1,
 7995515,
 7920963,
 74207,
 -1,
 7931954,
 74208,
 8126590,
 7959856,
 -1,
 -65411,
 8114890,
 74206,
 -1,
 8171103,
 74205,
 -1,
 8078732,
 74204,
 -1,
 7921635,
 74209,
 8454279,
 7829600,
 -1,
 8519813,
 8445115,
 -1,
 8585348,
 8485947,
 74194,
 -1,
 8521584,
 74195,
 -1,
 8524880,
 74193,
 8847359,
 8480765,
 74191,
 -1,
 8753824,
 74192,
 8913037,
 8411219,
 -1,
 8978570,
 8904406,
 74182,
 -1,
 8914790,
 74183,
 9109644,
 8919626,
 74180,
 -1,
 9090018,
 74181,
 -1,
 9070589,
 74632,
 9306258,
 8879163,
 -1,
 9371792,
 9297083,
 74198,
 -1,
 9337915,
 74199,
 -65391,
 9335911,
 74197,
 -1,
 9444830,
 74196,
 9633944,
 9267197,
 -1,
 9699479,
 9603404,
 74188,
 9830399,
 9635615,
 -1,
 -65386,
 9734371,
 74190,
 -1,
 9788878,
 74189,
 -1,
 9657205,
 74187,
 10027165,
 9621494,
 -1,
 10092700,
 9968202,
 -1,
 -65381,
 10057917,
 74211,
 -1,
 10115155,
 74210,
 -1,
 10044760,
 74212,
 10354849,
 9996620,
 -1,
 10420384,
 10306754,
 74200,
 -1,
 10356563,
 74201,
 -1,
 10413250,
 74202,
 10616997,
 10313148,
 -1,
 10682532,
 10558026,
 74184,
 -1,
 10648635,
 74185,
 -1,
 10643541,
 74186,
 10879144,
 10561799,
 -1,
 -65369,
 10840061,
 74177,
 -1,
 10886289,
 74176,
 -65367,
 10876911,
 74964,
 -65366,
 11048109,
 74203,
 -65365,
 11094753,
 74179,
 -1,
 11156622,
 74178,
 -1,
 6802394,
 74219,
 11468799,
 6665186,
 74220,
 11534335,
 11337728,
 -1,
 11534513,
 11458096,
 74221,
 -1,
 11470909,
 74222,
 11730943,
 11492709,
 74223,
 -1,
 11601479,
 74224,
 11796662,
 6588748,
 74228,
 11927551,
 11733777,
 74229,
 -1,
 11798531,
 74230,
 11993272,
 11762747,
 74226,
 -1,
 11930396,
 74227,
 -1,
 11953962,
 74225,
 12189942,
 384187,
 74235,
 12255465,
 12129067,
 74237,
 12386303,
 12189696,
 -1,
 12386530,
 12308470,
 -1,
 12452065,
 12348673,
 -1,
 12517572,
 12417120,
 -1,
 12583107,
 12459153,
 -1,
 12648642,
 12522576,
 74246,
 -1,
 12584750,
 74247,
 -1,
 12587819,
 74245,
 -1,
 12543997,
 74248,
 12910793,
 12501460,
 -1,
 12976328,
 12871677,
 -1,
 -65337,
 12941490,
 74255,
 -1,
 12977966,
 74254,
 -1,
 12937041,
 74635,
 13238477,
 12865142,
 74240,
 13369343,
 13172736,
 -1,
 -65332,
 13292234,
 74241,
 -1,
 13348479,
 74634,
 13500624,
 13225974,
 -1,
 -65329,
 13492023,
 74256,
 -1,
 13508418,
 75038,
 13697234,
 13478626,
 75036,
 -1,
 13633511,
 75037,
 13828309,
 13669024,
 -1,
 -65324,
 13819067,
 74253,
 -1,
 13845698,
 74252,
 14024920,
 13794437,
 -1,
 -65321,
 13981882,
 74250,
 -1,
 14026542,
 74249,
 14221531,
 13983164,
 -1,
 -65318,
 14182473,
 74243,
 -1,
 14229348,
 75035,
 -65316,
 14191766,
 74251,
 -65315,
 14380241,
 74244,
 -65314,
 14440732,
 74242,
 -65313,
 14499676,
 75034,
 -65312,
 14559601,
 74239,
 -1,
 14622564,
 74238,
 -1,
 12405874,
 74257,
 14876902,
 12370388,
 -1,
 14942437,
 14836191,
 74261,
 -1,
 14879389,
 74633,
 -1,
 14922450,
 74260,
 -65305,
 14852856,
 74259,
 -65304,
 15097194,
 75033,
 -1,
 15153648,
 74258,
 15335663,
 12212471,
 74263,
 15466495,
 15269888,
 -1,
 15466734,
 15375041,
 -1,
 -65299,
 15460140,
 74264,
 -1,
 15511590,
 74265,
 -1,
 15451779,
 74266,
 15728882,
 15305036,
 74269,
 15859711,
 15664732,
 74270,
 -1,
 15729464,
 74271,
 -65293,
 15694907,
 74268,
 -65292,
 15883708,
 74267,
 -65291,
 15930448,
 74262,
 -1,
 15993501,
 74236,
 16252927,
 12150781,
 74231,
 -65288,
 16172358,
 74234,
 -65287,
 16224327,
 74233,
 -1,
 16284731,
 74232,
 16449977,
 284755,
 -1,
 16515448,
 16390730,
 73909,
 16580964,
 16454443,
 73911,
 16711679,
 16515072,
 -1,
 16712035,
 16635393,
 -1,
 16777482,
 16668755,
 -1,
 16843014,
 16718410,
 74939,
 16908549,
 16823266,
 73932,
 17039359,
 16844575,
 -1,
 -65276,
 16946349,
 74941,
 -1,
 16989773,
 74940,
 -1,
 16880354,
 73931,
 17301503,
 16803837,
 73933,
 17301769,
 17175918,
 73934,
 -1,
 17237798,
 73935,
 -1,
 17282118,
 73936,
 17498389,
 16718410,
 -1,
 17563918,
 17483078,
 73917,
 17694719,
 17503019,
 74618,
 -1,
 17565532,
 73918,
 17760530,
 17499935,
 -1,
 -65264,
 17722334,
 73914,
 -65263,
 17784270,
 73913,
 -1,
 17841167,
 73912,
 18022676,
 17732256,
 73916,
 -1,
 17958784,
 74617,
 -1,
 17967388,
 73915,
 18219296,
 17482196,
 -1,
 18284828,
 18177468,
 -1,
 18350362,
 18245629,
 -1,
 -65255,
 18319692,
 74951,
 -1,
 18365269,
 73959,
 18612223,
 18302146,
 73957,
 -1,
 18483271,
 73958,
 18678047,
 18225738,
 -1,
 -65250,
 18658274,
 73956,
 -1,
 18709563,
 73955,
 -1,
 18669539,
 73960,
 18940203,
 18168661,
 -1,
 19005734,
 18930875,
 -1,
 19071269,
 18962534,
 -1,
 -65244,
 19036531,
 74937,
 -1,
 19098594,
 74936,
 -1,
 19015943,
 73926,
 19333418,
 18966525,
 73924,
 19464191,
 19302734,
 -1,
 -65239,
 19387952,
 73925,
 -1,
 19422565,
 74935,
 -1,
 19274314,
 73923,
 19661108,
 18905184,
 -1,
 19726639,
 19651771,
 -1,
 -65234,
 19711824,
 74943,
 -1,
 19731710,
 73948,
 19923249,
 19687874,
 73946,
 -1,
 19859377,
 73947,
 20119551,
 19864138,
 -1,
 -65229,
 20039974,
 73945,
 -1,
 20084832,
 73944,
 20250941,
 19619260,
 -1,
 20316475,
 20191818,
 -1,
 20382008,
 20282427,
 73938,
 -1,
 20318120,
 73939,
 20578303,
 20317983,
 -1,
 -65222,
 20482278,
 73937,
 -1,
 20519498,
 74942,
 -65220,
 20307391,
 73941,
 -1,
 20670494,
 73940,
 20840772,
 20222624,
 -1,
 20906306,
 20792514,
 74948,
 21037055,
 20842271,
 -1,
 -65215,
 20929394,
 74950,
 -1,
 20989421,
 74949,
 21233663,
 20897865,
 73952,
 -1,
 21104268,
 73953,
 21299530,
 20792514,
 -1,
 21365063,
 21271200,
 73929,
 -1,
 21301976,
 73930,
 21496137,
 21331003,
 73927,
 -1,
 21432232,
 73928,
 -1,
 21477457,
 74938,
 21692753,
 21244167,
 -1,
 21758287,
 21633610,
 -1,
 -65203,
 21738502,
 73920,
 -65202,
 21782523,
 74934,
 -1,
 21838677,
 73919,
 22085631,
 21750694,
 73921,
 -1,
 21956602,
 73922,
 22151510,
 21658683,
 -1,
 22217045,
 22092362,
 73949,
 22347775,
 22186316,
 74944,
 -1,
 22219537,
 74945,
 -1,
 22208340,
 74946,
 22479193,
 22142139,
 73962,
 22609919,
 22428501,
 73963,
 -1,
 22480714,
 73964,
 22675805,
 22448460,
 -1,
 -65189,
 22668482,
 74947,
 -65188,
 22702077,
 73951,
 -1,
 22758769,
 73950,
 22937952,
 22636541,
 -1,
 -65185,
 22922595,
 73943,
 -1,
 22961013,
 73942,
 -65183,
 22935515,
 74952,
 -65182,
 23122191,
 73961,
 -1,
 23177761,
 73954,
 -1,
 16689043,
 73965,
 23396714,
 16552608,
 73974,
 23527423,
 23335723,
 73975,
 23592959,
 23396352,
 -1,
 -65176,
 23515850,
 73976,
 -65175,
 23570332,
 73977,
 -1,
 23607714,
 73978,
 23789933,
 23362619,
 73970,
 -65172,
 23732440,
 73972,
 -1,
 23790365,
 73971,
 23986545,
 23734584,
 73966,
 24117247,
 23920640,
 -1,
 -65168,
 24035340,
 74953,
 -1,
 24066452,
 73967,
 24248691,
 23966690,
 73979,
 -1,
 24187984,
 73980,
 24379765,
 24197973,
 73968,
 -1,
 24315324,
 73969,
 -65162,
 24364510,
 73981,
 -65161,
 24480076,
 73973,
 -1,
 24511326,
 73910,
 24707481,
 16476157,
 73984,
 24772995,
 24687586,
 -1,
 24838529,
 24712272,
 73994,
 24969215,
 24775317,
 -1,
 -65155,
 24881697,
 73999,
 -65154,
 24938739,
 73998,
 -65153,
 24996830,
 73997,
 -65152,
 25057564,
 73996,
 -1,
 25107097,
 73995,
 25362431,
 24777515,
 73992,
 -1,
 25232222,
 73993,
 25428366,
 24756692,
 -1,
 25493901,
 25386428,
 74001,
 25624575,
 25427968,
 -1,
 25624972,
 25546742,
 -1,
 25690507,
 25586945,
 -1,
 -65143,
 25678095,
 74004,
 -65142,
 25713636,
 74955,
 -1,
 25766257,
 74003,
 -1,
 25644146,
 74005,
 -1,
 25573833,
 74002,
 -1,
 25436004,
 74000,
 26149266,
 25367918,
 73988,
 26279935,
 26083328,
 -1,
 -65135,
 26191782,
 73989,
 -1,
 26229180,
 73990,
 26411415,
 26083328,
 -1,
 26476950,
 26400257,
 -1,
 -65131,
 26467515,
 73986,
 -1,
 26494146,
 73985,
 -1,
 26425776,
 73987,
 -65128,
 26368083,
 74620,
 -1,
 26689279,
 73991,
 26870195,
 24698043,
 74006,
 26935715,
 26809131,
 74008,
 27066367,
 26869760,
 -1,
 27066786,
 26990081,
 -1,
 27132319,
 27031836,
 74009,
 -1,
 27069171,
 74010,
 -65120,
 27116262,
 74012,
 -65119,
 27236915,
 74011,
 -1,
 27290594,
 74956,
 -1,
 27024741,
 74013,
 27525546,
 26884949,
 74014,
 27656191,
 27459584,
 -1,
 27656616,
 27579905,
 -1,
 -65113,
 27622400,
 74016,
 -1,
 27663012,
 74015,
 -65111,
 27635306,
 74957,
 -1,
 27830191,
 74017,
 27984303,
 27505634,
 74021,
 28049838,
 27974843,
 -1,
 -65107,
 28034374,
 74024,
 -1,
 28086944,
 74023,
 -1,
 27990023,
 74022,
 28311985,
 27953484,
 74019,
 -1,
 28248871,
 74020,
 -65102,
 28277819,
 74018,
 -1,
 28377644,
 74007,
 28639231,
 26821826,
 -1,
 28639672,
 28559168,
 73982,
 28770303,
 28576405,
 -1,
 -65097,
 28695739,
 74954,
 -1,
 28736512,
 73983,
 -1,
 28578858,
 74619,
 28967488,
 16414816,
 -1,
 29032998,
 28908106,
 74071,
 29098511,
 28969621,
 -1,
 29163979,
 29055059,
 -1,
 29229507,
 29124605,
 74087,
 29295042,
 29214022,
 74624,
 29425663,
 29229056,
 -1,
 -65087,
 29339283,
 74089,
 -1,
 29374921,
 74090,
 -1,
 29275195,
 74088,
 29622728,
 29170250,
 74082,
 29688262,
 29602786,
 74085,
 -1,
 29624342,
 74086,
 -65081,
 29659874,
 74084,
 -1,
 29785147,
 74083,
 30015487,
 29613243,
 74091,
 -65078,
 29930577,
 74092,
 -1,
 29965141,
 74625,
 30147030,
 29147604,
 -1,
 30212562,
 30105020,
 -1,
 30278095,
 30203067,
 74115,
 -1,
 30243899,
 74629,
 -65072,
 30239170,
 74114,
 -65071,
 30360770,
 74113,
 -1,
 30415434,
 74112,
 30605780,
 30153290,
 74110,
 -1,
 30585826,
 74111,
 -65067,
 30596964,
 74117,
 -1,
 30698170,
 74116,
 30867934,
 30137531,
 74119,
 30933465,
 30847970,
 74963,
 -1,
 30872363,
 74631,
 -65062,
 30917958,
 74123,
 -65061,
 31035937,
 74122,
 -65060,
 31079253,
 74121,
 -65059,
 31134507,
 74120,
 -1,
 31198132,
 74962,
 31392230,
 30837068,
 -1,
 31457764,
 31343810,
 74100,
 31588351,
 31393567,
 -1,
 -65054,
 31510999,
 74103,
 -65053,
 31546226,
 74102,
 -1,
 31605814,
 74101,
 31850495,
 31418365,
 74104,
 -1,
 31721435,
 74105,
 31916525,
 31332938,
 74072,
 31982058,
 31900998,
 -1,
 -65047,
 31921232,
 74623,
 -1,
 31986475,
 74075,
 32178668,
 31931221,
 74073,
 -1,
 32114590,
 74074,
 -1,
 32151815,
 74622,
 32375284,
 31860999,
 -1,
 32440818,
 32315978,
 -1,
 -65040,
 32420834,
 74078,
 -65039,
 32472305,
 74077,
 -1,
 32521045,
 74076,
 -65037,
 32431291,
 74960,
 -1,
 32663549,
 74079,
 32834041,
 32340064,
 -1,
 32899575,
 32794621,
 74096,
 -1,
 32848725,
 74097,
 33095679,
 32840266,
 74961,
 -1,
 32995424,
 74095,
 33161725,
 32799803,
 -1,
 33227260,
 33152187,
 74099,
 -1,
 33196364,
 74627,
 -1,
 33187837,
 74098,
 33423872,
 33148918,
 -1,
 -65025,
 33414331,
 74630,
 -1,
 33432653,
 74118,
 33620483,
 33401296,
 -1,
 -65022,
 33581053,
 74108,
 -1,
 33626698,
 74628,
 33817094,
 33591968,
 -1,
 -65019,
 33808457,
 74107,
 -1,
 33834178,
 74106,
 34013705,
 33777661,
 -1,
 -65016,
 33982796,
 74094,
 -1,
 34036594,
 74093,
 34210316,
 33965250,
 -1,
 -65013,
 34194829,
 74081,
 -1,
 34258211,
 74080,
 -65011,
 34207657,
 74124,
 -65010,
 34390295,
 74109,
 -1,
 34431583,
 74626,
 34603541,
 29047637,
 -1,
 34669074,
 34543170,
 74131,
 -1,
 34604591,
 74132,
 -65005,
 34608494,
 74130,
 -65004,
 34739280,
 74129,
 -1,
 34804523,
 74128,
 34996761,
 34588966,
 74140,
 35127295,
 34930688,
 -1,
 -65000,
 35039201,
 74142,
 -1,
 35093755,
 74141,
 35258909,
 34962491,
 74135,
 35389439,
 35192832,
 -1,
 -64996,
 35313160,
 74136,
 -1,
 35338723,
 74137,
 35521056,
 35227980,
 -1,
 -64993,
 35460462,
 74139,
 -1,
 35525419,
 74138,
 35717666,
 35485792,
 74133,
 -1,
 35654387,
 74134,
 35848740,
 35656491,
 74125,
 -1,
 35783225,
 74126,
 -64987,
 35826143,
 74607,
 -1,
 35924231,
 74127,
 36110898,
 29023419,
 74154,
 36176425,
 36090850,
 74163,
 -1,
 36111758,
 74164,
 36307499,
 36142139,
 74160,
 -1,
 36242270,
 74161,
 36438573,
 36246894,
 74157,
 -1,
 36375481,
 74158,
 -64978,
 36423499,
 74165,
 -64977,
 36541088,
 74162,
 -64976,
 36575239,
 74159,
 -64975,
 36639824,
 74156,
 -1,
 36701670,
 74155,
 36897342,
 36071421,
 74144,
 36962872,
 36880852,
 -1,
 37028406,
 36924628,
 74152,
 -1,
 36963898,
 74153,
 -64969,
 36986300,
 74151,
 -1,
 37101412,
 74150,
 37290556,
 36899477,
 -1,
 37356091,
 37280955,
 74146,
 -1,
 37305173,
 74147,
 -1,
 37300593,
 74145,
 -64963,
 37261984,
 74149,
 -1,
 37501781,
 74148,
 -64961,
 36893212,
 74166,
 -1,
 37637750,
 74143,
 37814969,
 28950996,
 -1,
 37880449,
 37772732,
 -1,
 37945947,
 37840893,
 -1,
 38011473,
 37914956,
 74438,
 38141951,
 37948053,
 -1,
 38142535,
 38038494,
 74444,
 -1,
 38077278,
 74445,
 38273610,
 38086919,
 -1,
 -64951,
 38264798,
 74441,
 -1,
 38281060,
 74440,
 -64949,
 38257378,
 74449,
 -64948,
 38441441,
 74448,
 -64947,
 38504720,
 74447,
 -64946,
 38566916,
 74446,
 -64945,
 38623567,
 74443,
 -64944,
 38682385,
 74442,
 -1,
 38738506,
 74439,
 38928981,
 37991394,
 74451,
 39059455,
 38862848,
 -1,
 -64940,
 38982346,
 74452,
 -1,
 39037087,
 74453,
 39191129,
 38878037,
 74435,
 39321599,
 39127701,
 -1,
 -64936,
 39218385,
 74437,
 -1,
 39262794,
 74436,
 -64934,
 39178364,
 74454,
 -1,
 39425728,
 74450,
 39584362,
 37886538,
 74413,
 39649894,
 39523408,
 74414,
 39780351,
 39586453,
 -1,
 39780960,
 39705787,
 74421,
 -1,
 39716646,
 74422,
 -64927,
 39770835,
 74420,
 -64926,
 39896907,
 74419,
 -64925,
 39949485,
 74418,
 -64924,
 40000479,
 74417,
 -64923,
 40053105,
 74416,
 -1,
 40114762,
 74415,
 40305256,
 39589687,
 74423,
 -1,
 40241681,
 75057,
 -64919,
 40285243,
 74425,
 -1,
 40380721,
 74424,
 40567418,
 39535810,
 74426,
 40632949,
 40501248,
 -1,
 40698480,
 40611417,
 -1,
 -64914,
 40682384,
 75061,
 -64913,
 40735556,
 75060,
 -1,
 40789844,
 75059,
 40960628,
 40675478,
 75058,
 41091071,
 40894464,
 -1,
 -64909,
 41013390,
 74429,
 -1,
 41048258,
 74428,
 -1,
 40920913,
 74427,
 41288312,
 40617286,
 74432,
 -64905,
 41254249,
 74434,
 -1,
 41292587,
 74433,
 -64903,
 41259680,
 74431,
 -1,
 41441439,
 74430,
 41680895,
 40557755,
 74455,
 41681535,
 41554731,
 74457,
 41811967,
 41617183,
 -1,
 -64898,
 41698800,
 75063,
 -1,
 41763932,
 75062,
 -64896,
 41627458,
 74458,
 -1,
 41879068,
 74456,
 42074791,
 37821002,
 74387,
 42140323,
 42031187,
 74389,
 42270719,
 42074112,
 -1,
 42271391,
 42194433,
 -1,
 42336907,
 42261691,
 -1,
 -64889,
 42321222,
 74406,
 -64888,
 42382306,
 74405,
 -64887,
 42436940,
 74404,
 -64886,
 42477831,
 74403,
 -1,
 42537771,
 74402,
 42730128,
 42320340,
 -1,
 42795663,
 42687932,
 -1,
 -64882,
 42756546,
 74400,
 -1,
 42812654,
 75055,
 -1,
 42737508,
 74399,
 43057811,
 42717308,
 -1,
 -64878,
 43022525,
 75056,
 -1,
 43067655,
 74401,
 43254422,
 43022432,
 -1,
 -64875,
 43246502,
 74395,
 -1,
 43261748,
 74394,
 43451032,
 43205686,
 74391,
 -1,
 43395335,
 74392,
 -64871,
 43424307,
 74398,
 -64870,
 43552270,
 74397,
 -64869,
 43616532,
 74396,
 -64868,
 43674594,
 74646,
 -64867,
 43736526,
 74393,
 -64866,
 43797217,
 75054,
 -1,
 43850314,
 74390,
 44040865,
 42229093,
 74408,
 -1,
 43977449,
 75053,
 -64862,
 44017805,
 74407,
 -1,
 44145229,
 74388,
 44303013,
 42105915,
 74409,
 -1,
 44237835,
 74410,
 -64858,
 44282850,
 74412,
 -1,
 44406337,
 74411,
 44565168,
 42065083,
 74466,
 44630698,
 44544994,
 74473,
 -1,
 44571032,
 74474,
 44761772,
 44599628,
 74471,
 -1,
 44705448,
 74472,
 44892846,
 44710741,
 74468,
 -1,
 44831531,
 74469,
 -64849,
 44853166,
 74470,
 -1,
 44959447,
 74467,
 45219839,
 44525565,
 74459,
 45220532,
 45111379,
 74461,
 45350911,
 45159790,
 74462,
 -1,
 45221552,
 74463,
 45417143,
 45154304,
 -1,
 -64842,
 45405769,
 75064,
 -1,
 45440357,
 74460,
 -64840,
 45382801,
 74465,
 -1,
 45578415,
 74464,
 45744939,
 37763925,
 -1,
 45810420,
 45735099,
 73850,
 45875940,
 45766739,
 73857,
 45941475,
 45812373,
 -1,
 46006979,
 45907003,
 -1,
 46072514,
 45947466,
 -1,
 46138049,
 46041420,
 74911,
 -1,
 46074641,
 74912,
 -1,
 46102693,
 74910,
 -1,
 46063447,
 74913,
 46400201,
 45971552,
 -1,
 46465736,
 46390459,
 -1,
 46531271,
 46450507,
 74908,
 -1,
 46466961,
 74909,
 -1,
 46511074,
 74907,
 -1,
 46409408,
 74906,
 46793422,
 46356563,
 -1,
 46858957,
 46753789,
 74900,
 -64820,
 46843206,
 74902,
 -1,
 46904382,
 74901,
 -1,
 46799434,
 74899,
 47121106,
 46762316,
 -1,
 -64816,
 47081469,
 74916,
 -64815,
 47140420,
 74915,
 -1,
 47195816,
 74914,
 47383254,
 47061578,
 -1,
 47448789,
 47367494,
 74894,
 -1,
 47382838,
 74895,
 -1,
 47421703,
 74893,
 47645401,
 47366612,
 -1,
 -64808,
 47605762,
 74920,
 -1,
 47669375,
 74919,
 47842012,
 47603132,
 -1,
 -64805,
 47802365,
 74904,
 -1,
 47848010,
 74903,
 48038623,
 47790933,
 -1,
 -64802,
 48029769,
 74897,
 -1,
 48065851,
 74896,
 -64800,
 48016703,
 74918,
 -64799,
 48207523,
 74917,
 -64798,
 48262114,
 74905,
 -1,
 48319948,
 74898,
 -1,
 45932246,
 73858,
 48562921,
 45847200,
 73860,
 48628456,
 48501840,
 73861,
 48758783,
 48563038,
 73862,
 -1,
 48628574,
 73863,
 -1,
 48567662,
 73864,
 48890606,
 48507143,
 73854,
 48956141,
 48827029,
 -1,
 -64788,
 48940608,
 74614,
 -1,
 48975478,
 73855,
 -1,
 48894763,
 73856,
 49218290,
 48824320,
 -1,
 -64784,
 49202819,
 73853,
 -64783,
 49260407,
 73851,
 -1,
 49306981,
 73852,
 -64781,
 49198139,
 73865,
 -1,
 49438140,
 73859,
 49611550,
 45750858,
 73813,
 49677080,
 49567827,
 73814,
 49742615,
 49610752,
 -1,
 49808150,
 49707770,
 -1,
 49873662,
 49764435,
 -1,
 49939195,
 49833981,
 73821,
 -1,
 49919035,
 73822,
 50070269,
 49879626,
 73819,
 -1,
 50005956,
 73820,
 -1,
 50061014,
 73823,
 50266883,
 49839163,
 -1,
 50332418,
 50257083,
 73829,
 -64767,
 50301260,
 73831,
 -1,
 50333647,
 73830,
 -1,
 50272842,
 73828,
 50594568,
 50257083,
 -1,
 50660103,
 50533314,
 -1,
 -64762,
 50629614,
 74611,
 -1,
 50682842,
 73836,
 -1,
 50644294,
 73837,
 50922250,
 50557746,
 73825,
 -1,
 50857915,
 73826,
 51053325,
 50866439,
 -1,
 -64756,
 51013629,
 73818,
 -1,
 51060628,
 73817,
 51249936,
 50993738,
 -1,
 -64753,
 51219285,
 73816,
 -1,
 51251140,
 73815,
 -64751,
 51237135,
 73835,
 -64750,
 51431270,
 73834,
 -64749,
 51489533,
 73833,
 -64748,
 51549357,
 73832,
 -64747,
 51607836,
 73827,
 -1,
 51666382,
 73824,
 -1,
 49796626,
 74889,
 -1,
 49681488,
 74612,
 51970844,
 49656802,
 73839,
 52101119,
 51911242,
 -1,
 -64741,
 51975534,
 73841,
 -1,
 52040784,
 73840,
 -64739,
 51939660,
 73838,
 -1,
 52169522,
 74888,
 52428799,
 49571837,
 73842,
 52429606,
 52332876,
 73844,
 52495140,
 52365973,
 -1,
 -64734,
 52485382,
 74891,
 -64733,
 52545088,
 73845,
 -1,
 52587486,
 74890,
 52822015,
 52433707,
 73846,
 -1,
 52693831,
 74892,
 52888360,
 52413766,
 73849,
 -1,
 52824104,
 74613,
 53019434,
 52859552,
 73847,
 -1,
 52954074,
 73848,
 -1,
 52963591,
 73843,
 53216155,
 45735099,
 74507,
 53281641,
 53195746,
 74536,
 53347154,
 53271739,
 74551,
 53412688,
 53283477,
 -1,
 53478197,
 53368915,
 -1,
 53543732,
 53418570,
 74556,
 -64718,
 53523426,
 74559,
 -64717,
 53580514,
 74558,
 -1,
 53640251,
 74557,
 -1,
 53533883,
 74560,
 53871417,
 53468347,
 -1,
 -64713,
 53854495,
 74574,
 -64712,
 53885781,
 74573,
 -1,
 53938022,
 74572,
 54133566,
 53836859,
 -1,
 54199101,
 54123707,
 -1,
 -64708,
 54167884,
 74566,
 -1,
 54203472,
 75072,
 -1,
 54140731,
 75071,
 54461250,
 54093821,
 -1,
 -64704,
 54445382,
 74564,
 -64703,
 54495564,
 74563,
 -1,
 54549362,
 74562,
 54723397,
 54444500,
 -1,
 -64700,
 54684356,
 74570,
 -1,
 54747263,
 74569,
 54920008,
 54672213,
 -1,
 -64697,
 54911049,
 74555,
 -1,
 54928468,
 75070,
 55116618,
 54860362,
 74552,
 -1,
 55101082,
 74553,
 -64693,
 55106178,
 74571,
 -64692,
 55224865,
 74568,
 -64691,
 55283608,
 74567,
 -64690,
 55343798,
 74565,
 -64689,
 55401934,
 74561,
 -1,
 55454158,
 74554,
 55705599,
 53361664,
 74575,
 -1,
 55577406,
 74576,
 55772003,
 53285675,
 74539,
 55902207,
 55705600,
 -1,
 55903074,
 55825921,
 -1,
 55968603,
 55893179,
 -1,
 56034138,
 55907115,
 74545,
 56164351,
 55969567,
 -1,
 -64679,
 56044483,
 74547,
 -1,
 56108712,
 74546,
 -1,
 55982933,
 75069,
 56361824,
 55908938,
 -1,
 56427359,
 56297247,
 -1,
 -64674,
 56398570,
 74541,
 -1,
 56450510,
 74540,
 -1,
 56392763,
 74542,
 -64671,
 56334899,
 74544,
 -1,
 56647118,
 74543,
 -1,
 55865842,
 75068,
 56886117,
 55732221,
 74549,
 -1,
 56824912,
 74550,
 57017192,
 56819712,
 -1,
 -64665,
 57001603,
 74538,
 -1,
 57031204,
 74537,
 -1,
 56956270,
 74548,
 57279349,
 53250380,
 74525,
 57344880,
 57215637,
 -1,
 57410413,
 57314435,
 74648,
 -1,
 57345848,
 74527,
 -64658,
 57400507,
 74529,
 -64657,
 57525653,
 74528,
 -1,
 57572597,
 74526,
 57738100,
 57335779,
 74531,
 57868287,
 57674389,
 -1,
 -64653,
 57780769,
 74533,
 -1,
 57833843,
 74532,
 -1,
 57682959,
 74530,
 58065793,
 57228117,
 74515,
 58131328,
 57999360,
 -1,
 58196860,
 58119681,
 -1,
 58262394,
 58186971,
 74519,
 -1,
 58196830,
 74520,
 -64645,
 58232334,
 74518,
 -1,
 58337649,
 74517,
 58524542,
 58181251,
 74522,
 -1,
 58460829,
 74523,
 -64641,
 58489860,
 74516,
 -1,
 58613093,
 74521,
 -1,
 58122036,
 74524,
 58852234,
 58049862,
 74577,
 58917767,
 58788501,
 -1,
 58983301,
 58883037,
 74579,
 -1,
 58962914,
 74580,
 -64634,
 58970383,
 74581,
 -1,
 59054666,
 74578,
 -64632,
 58913328,
 74582,
 -64631,
 59236421,
 74584,
 -1,
 59249451,
 74583,
 59442066,
 58785792,
 -1,
 59507599,
 59418850,
 -1,
 -64627,
 59497707,
 74512,
 -64626,
 59559727,
 74511,
 -1,
 59615794,
 74510,
 59769745,
 59497659,
 74649,
 -1,
 59706289,
 74509,
 -1,
 59727173,
 74508,
 59966358,
 59438661,
 -1,
 60031893,
 59905104,
 74586,
 -1,
 59968259,
 74587,
 -1,
 60021947,
 74588,
 60228504,
 59937440,
 74534,
 -1,
 60162910,
 74535,
 -64615,
 60218036,
 74585,
 -64614,
 60303623,
 74514,
 -1,
 60363563,
 74513,
 60556283,
 53187232,
 -1,
 60621768,
 60516349,
 74316,
 60687297,
 60592800,
 74639,
 60752832,
 60636197,
 74322,
 60882943,
 60689045,
 -1,
 60883877,
 60808379,
 75050,
 -64606,
 60867910,
 74335,
 -64605,
 60932383,
 75052,
 -64604,
 60953546,
 74334,
 -1,
 61016145,
 75051,
 61211562,
 60868160,
 74330,
 61341695,
 61146918,
 -1,
 61342633,
 61261126,
 74332,
 -1,
 61277998,
 74333,
 -1,
 61276222,
 74331,
 61539248,
 61167699,
 -1,
 61604782,
 61529275,
 -1,
 -64595,
 61570107,
 75044,
 -1,
 61619029,
 74326,
 61865983,
 61564925,
 74642,
 -1,
 61785414,
 75043,
 61932468,
 61479498,
 -1,
 61998003,
 61916486,
 74324,
 -1,
 61933358,
 74325,
 -1,
 61969056,
 74323,
 62194615,
 61903520,
 -1,
 -64586,
 62185545,
 74329,
 -1,
 62211266,
 74328,
 62391226,
 62163276,
 -1,
 -64583,
 62342523,
 74327,
 -1,
 62400168,
 75048,
 -64581,
 62368509,
 75049,
 -64580,
 62553422,
 75047,
 -64579,
 62618167,
 75046,
 -64578,
 62677590,
 75045,
 -64577,
 62734083,
 75042,
 -1,
 62794127,
 74641,
 -1,
 60692888,
 74640,
 63046597,
 60655948,
 74319,
 63176703,
 62982862,
 -1,
 -64572,
 63091701,
 74321,
 -1,
 63148770,
 74320,
 -64570,
 63029966,
 74336,
 -64569,
 63247147,
 74318,
 -1,
 63310521,
 74317,
 63505385,
 60611771,
 74337,
 63570916,
 63476384,
 74339,
 63636441,
 63563151,
 74349,
 63766527,
 63569920,
 -1,
 63767511,
 63642444,
 -1,
 -64562,
 63757635,
 74359,
 -64561,
 63817803,
 74358,
 -64560,
 63870125,
 74357,
 -64559,
 63929477,
 74356,
 -64558,
 63994107,
 74355,
 -64557,
 64056290,
 74354,
 -64556,
 64118085,
 74353,
 -64555,
 64177240,
 74352,
 -64554,
 64236483,
 74351,
 -1,
 64300721,
 74350,
 64552959,
 63732488,
 74360,
 -1,
 64424881,
 74361,
 64684031,
 63569920,
 -1,
 64685024,
 64584999,
 -1,
 64750557,
 64668386,
 74342,
 -1,
 64685718,
 74343,
 -64546,
 64742594,
 74344,
 -64545,
 64850926,
 74341,
 -1,
 64903503,
 74340,
 65078242,
 64633355,
 74347,
 -1,
 65012765,
 74348,
 -64541,
 65065674,
 74345,
 -1,
 65185886,
 74346,
 65404927,
 63509249,
 74338,
 65470463,
 65273856,
 -1,
 -64537,
 65393354,
 983260,
 -64536,
 65454092,
 74643,
 -1,
 65513543,
 983261,
 65668085,
 63445578,
 74302,
 65733616,
 65624226,
 74304,
 65799151,
 65667072,
 -1,
 -64531,
 65787450,
 74306,
 -64530,
 65839877,
 74307,
 -1,
 65892850,
 74305,
 -1,
 65778658,
 74308,
 66126835,
 65702220,
 74310,
 -64526,
 66065195,
 74311,
 -1,
 66127133,
 74309,
 -64524,
 66065774,
 74638,
 -1,
 66261803,
 74303,
 66519039,
 65619138,
 74312,
 66584575,
 66387968,
 -1,
 66585594,
 66508289,
 -1,
 -64519,
 66576086,
 74314,
 -1,
 66591306,
 74313,
 -1,
 66569859,
 74315,
 66847826,
 60496458,
 73728,
 66913304,
 66791687,
 73738,
 66978832,
 66846720,
 -1,
 67044367,
 66967041,
 -1,
 67109890,
 67028294,
 -1,
 -64511,
 67099971,
 74881,
 -1,
 67128946,
 73747,
 67306500,
 67082803,
 74608,
 -1,
 67242513,
 74880,
 67437575,
 67266557,
 -1,
 -64506,
 67407768,
 73745,
 -1,
 67459957,
 73744,
 67634186,
 67393698,
 -1,
 -64503,
 67605218,
 73742,
 -1,
 67664955,
 73741,
 -64501,
 67624155,
 73748,
 -64500,
 67796213,
 73746,
 -64499,
 67853774,
 73743,
 -64498,
 67912809,
 73740,
 -1,
 67970732,
 73739,
 -1,
 67001701,
 73749,
 68288511,
 66917163,
 73750,
 68354047,
 68160149,
 -1,
 -64493,
 68276495,
 73755,
 -64492,
 68339093,
 73754,
 -64491,
 68390038,
 73753,
 -64490,
 68442396,
 73752,
 -64489,
 68495763,
 73751,
 -1,
 68557386,
 74609,
 68748325,
 66878523,
 73760,
 68813859,
 68684437,
 -1,
 68879389,
 68778080,
 -1,
 -64484,
 68839421,
 73766,
 -1,
 68885685,
 73765,
 -64482,
 68871362,
 73768,
 -64481,
 69060160,
 73767,
 -64480,
 69098958,
 73764,
 -64479,
 69163999,
 73763,
 -64478,
 69222156,
 73762,
 -1,
 69279588,
 73761,
 -64476,
 68766923,
 73770,
 -1,
 69411109,
 73769,
 69600305,
 68731348,
 -1,
 69665840,
 69557692,
 73784,
 69731374,
 69599232,
 -1,
 69796908,
 69707620,
 -1,
 69862443,
 69773147,
 73788,
 -1,
 69796349,
 73789,
 -1,
 69851790,
 73787,
 -64467,
 69793708,
 73785,
 -1,
 70023405,
 73786,
 -64465,
 69687482,
 73791,
 -1,
 70128427,
 73790,
 -1,
 69607307,
 73783,
 70386746,
 69536405,
 -1,
 -64461,
 70369998,
 73736,
 -64460,
 70423139,
 73735,
 -64459,
 70483228,
 73734,
 -64458,
 70544350,
 73733,
 -64457,
 70606286,
 73732,
 -64456,
 70670620,
 73731,
 -64455,
 70723953,
 73730,
 -1,
 70785610,
 73729,
 70976578,
 70357664,
 73773,
 71042113,
 70909952,
 -1,
 71107647,
 71020168,
 -1,
 -64450,
 71093210,
 73777,
 -1,
 71148234,
 73776,
 -64448,
 71095504,
 73775,
 -1,
 71280467,
 73774,
 -1,
 71026240,
 73778,
 71500870,
 70956002,
 -1,
 71566405,
 71441553,
 73780,
 -1,
 71502609,
 73781,
 -1,
 71530729,
 73782,
 71763018,
 71469909,
 73771,
 71892991,
 71699093,
 -1,
 -64439,
 71812672,
 73772,
 -1,
 71859176,
 74610,
 72025166,
 71727200,
 73757,
 72155135,
 71961237,
 -1,
 -64435,
 72074941,
 73759,
 -1,
 72109516,
 73758,
 72287312,
 71973717,
 73756,
 -1,
 72223426,
 74882,
 -64431,
 72265099,
 73779,
 -1,
 72356651,
 73737,
 72549529,
 66798786,
 73866,
 72615033,
 72546070,
 73889,
 72744959,
 72548352,
 -1,
 72746096,
 72668673,
 -1,
 72811611,
 72711227,
 -1,
 72877145,
 72751690,
 73903,
 -1,
 72842329,
 73904,
 -64422,
 72867003,
 73906,
 -1,
 72968189,
 73905,
 73139295,
 72751690,
 73890,
 73204830,
 73074609,
 73891,
 -1,
 73141020,
 73892,
 -1,
 73175712,
 73893,
 73401443,
 73103456,
 -1,
 73466978,
 73344704,
 73900,
 -1,
 73402793,
 73901,
 -1,
 73456977,
 73902,
 73663590,
 73391291,
 -1,
 -64411,
 73612117,
 73908,
 -1,
 73667371,
 73907,
 73860201,
 73646548,
 -1,
 -64408,
 73850043,
 74933,
 -1,
 73883775,
 74616,
 74056811,
 73817550,
 73897,
 -1,
 73991006,
 73898,
 74187885,
 74007657,
 73895,
 -1,
 74122078,
 73896,
 -64402,
 74148834,
 73899,
 -64401,
 74276165,
 74615,
 -1,
 74328433,
 73894,
 74579967,
 72730251,
 -1,
 74581107,
 74484867,
 74930,
 -1,
 74564052,
 74931,
 74712181,
 74546309,
 74928,
 -1,
 74677307,
 74929,
 -64394,
 74698450,
 74932,
 -64393,
 74804194,
 74927,
 -64392,
 74867286,
 74926,
 -1,
 74917544,
 74925,
 75105412,
 72553259,
 73869,
 75235327,
 75041429,
 -1,
 75236478,
 75153876,
 -1,
 -64387,
 75194495,
 73874,
 -1,
 75243364,
 73873,
 -64385,
 75226299,
 73875,
 -64384,
 75410146,
 74922,
 -64383,
 75468302,
 73872,
 -64382,
 75529216,
 74921,
 -64381,
 75585871,
 73871,
 -1,
 75635335,
 73870,
 75826317,
 75076256,
 73879,
 75956223,
 75759616,
 -1,
 75957386,
 75879937,
 -1,
 76022921,
 75913495,
 73880,
 -1,
 75958801,
 73881,
 -1,
 75992195,
 73882,
 -64373,
 75942874,
 73885,
 -64372,
 76194528,
 73884,
 -1,
 76233096,
 73883,
 76416145,
 75805666,
 -1,
 76481680,
 76377462,
 73887,
 -1,
 76418886,
 74923,
 -1,
 76434145,
 73886,
 76678291,
 76400013,
 73888,
 -1,
 76612125,
 74924,
 76809366,
 76611584,
 -1,
 -64363,
 76797478,
 73867,
 -1,
 76851071,
 73868,
 -64361,
 76774459,
 73878,
 -64360,
 76962774,
 73877,
 -1,
 77020945,
 73876,
 77202629,
 72536054,
 -1,
 77268145,
 77142602,
 74475,
 77333668,
 77224019,
 74483,
 77463551,
 77269653,
 -1,
 77464736,
 77382982,
 -1,
 -64353,
 77454523,
 74487,
 -1,
 77481154,
 74486,
 -64351,
 77455062,
 74489,
 -64350,
 77650569,
 74488,
 -64349,
 77684037,
 74485,
 -1,
 77736899,
 74484,
 77923498,
 77266944,
 -1,
 77989032,
 77911553,
 -1,
 -64345,
 77958670,
 74478,
 -1,
 78013014,
 74477,
 -64343,
 77946213,
 74479,
 -1,
 78128894,
 74476,
 78316718,
 77867271,
 74480,
 78446591,
 78249984,
 -1,
 -64339,
 78367706,
 74482,
 -1,
 78424246,
 74481,
 78578864,
 78280893,
 74490,
 -1,
 78514188,
 75065,
 -1,
 78558178,
 74491,
 78775482,
 77257915,
 74501,
 78841014,
 78743884,
 74504,
 78970879,
 78776981,
 -1,
 -64331,
 78894183,
 75067,
 -1,
 78928156,
 75066,
 79103160,
 78820322,
 74505,
 -1,
 79038176,
 74506,
 -64327,
 79067232,
 74503,
 -1,
 79190169,
 74502,
 79365315,
 78735357,
 74494,
 79430848,
 79344610,
 74497,
 79560703,
 79364096,
 -1,
 79561919,
 79472857,
 74499,
 -1,
 79495965,
 74500,
 -1,
 79550025,
 74498,
 -64319,
 79395899,
 74496,
 -64318,
 79696683,
 74647,
 -1,
 79759889,
 74495,
 80019455,
 79316162,
 74492,
 -1,
 79889246,
 74493,
 80086255,
 77171020,
 -1,
 80151776,
 80075963,
 74284,
 80217307,
 80135494,
 74290,
 80282835,
 80150528,
 -1,
 80348366,
 80259133,
 74294,
 80478207,
 80284309,
 -1,
 -64308,
 80378140,
 75041,
 -64307,
 80435362,
 75040,
 -1,
 80485039,
 74295,
 80676050,
 80336385,
 -1,
 -64304,
 80672371,
 74293,
 -64303,
 80706560,
 74292,
 -1,
 80747082,
 74291,
 -1,
 80624125,
 74296,
 81068031,
 80221264,
 74297,
 81133567,
 80936960,
 -1,
 81134810,
 81057281,
 -1,
 81200344,
 81074762,
 74298,
 -1,
 81135425,
 74299,
 -64295,
 81196659,
 74637,
 -1,
 81280589,
 74300,
 -1,
 81091941,
 74301,
 81528029,
 80173139,
 74286,
 -1,
 81462110,
 74287,
 -64290,
 81508778,
 74289,
 -64289,
 81631534,
 74288,
 -1,
 81659523,
 74285,
 81855721,
 80091722,
 74272,
 81921251,
 81839430,
 74278,
 -1,
 81859371,
 74279,
 82052326,
 81854464,
 -1,
 -64283,
 82040393,
 74273,
 -1,
 82074981,
 74274,
 -64281,
 82031586,
 74277,
 -64280,
 82206140,
 74276,
 -1,
 82252587,
 74275,
 82445548,
 81815549,
 74282,
 -64277,
 82416288,
 74283,
 -1,
 82446425,
 75039,
 82706431,
 82396354,
 74280,
 82771967,
 82624980,
 74281,
 -1,
 82664892,
 74636,
 82838798,
 80029959,
 -1,
 82904318,
 82778698,
 73792,
 82969846,
 82862075,
 73795,
 83099647,
 82905749,
 -1,
 -64268,
 83031667,
 74886,
 -64267,
 83072675,
 74885,
 -1,
 83106632,
 74884,
 83297529,
 82934843,
 73796,
 -64264,
 83238363,
 73798,
 -1,
 83297702,
 73797,
 83494139,
 83276770,
 73799,
 -1,
 83434245,
 73800,
 83625213,
 83442517,
 73793,
 -1,
 83561128,
 74883,
 -1,
 83581084,
 73794,
 83821833,
 82894011,
 73805,
 83887365,
 83755008,
 -1,
 83952900,
 83863406,
 -1,
 -64254,
 83943497,
 73807,
 -64253,
 84006428,
 74887,
 -1,
 84024133,
 73806,
 -1,
 83900796,
 73808,
 84280583,
 83866594,
 73811,
 -1,
 84218667,
 73812,
 84475903,
 84248844,
 73809,
 -1,
 84346288,
 73810,
 84606975,
 83781629,
 73801,
 84672511,
 84478613,
 -1,
 -64244,
 84569058,
 73804,
 -64243,
 84629839,
 73803,
 -1,
 84679242,
 73802,
 84870443,
 82795964,
 -1,
 84935963,
 84830205,
 74029,
 85065727,
 84871829,
 -1,
 85067028,
 84944552,
 74030,
 -64237,
 85005099,
 74031,
 -1,
 85067219,
 74959,
 -64235,
 85056699,
 74038,
 -64234,
 85247552,
 74037,
 -64233,
 85301811,
 74036,
 -64232,
 85359309,
 74035,
 -64231,
 85416126,
 74034,
 -64230,
 85475164,
 74033,
 -1,
 85535089,
 74032,
 85722405,
 84925627,
 74039,
 85787939,
 85666073,
 74040,
 85917695,
 85723797,
 -1,
 -64225,
 85843670,
 74045,
 -64224,
 85886168,
 74044,
 -64223,
 85948787,
 74043,
 -64222,
 86007410,
 74042,
 -1,
 86057253,
 74041,
 -64220,
 85771590,
 74621,
 -1,
 86211714,
 74046,
 86441983,
 85662282,
 74025,
 86443306,
 86310912,
 -1,
 86508841,
 86430410,
 74026,
 -1,
 86442846,
 74958,
 -1,
 86465893,
 74027,
 -1,
 86408251,
 74028,
 86771014,
 84830205,
 74047,
 86836531,
 86739276,
 74062,
 86902066,
 86769664,
 -1,
 -64209,
 86890057,
 74063,
 -64208,
 86952922,
 74066,
 -64207,
 87007980,
 74065,
 -1,
 87046615,
 74064,
 -1,
 86863163,
 74067,
 87295290,
 86792275,
 74053,
 87425023,
 87255037,
 74054,
 87490559,
 87293952,
 -1,
 -64201,
 87407050,
 74056,
 -64200,
 87467966,
 74057,
 -64199,
 87514469,
 74058,
 -1,
 87572169,
 74055,
 87754045,
 87260219,
 74059,
 -64196,
 87692075,
 74061,
 -1,
 87755480,
 74060,
 87950657,
 87703295,
 74050,
 88080383,
 87885328,
 -1,
 -64192,
 88001498,
 74052,
 -1,
 88026946,
 74051,
 -64190,
 87934278,
 74070,
 -64189,
 88191970,
 74069,
 -64188,
 88248992,
 74068,
 -64187,
 88287495,
 74049,
 -1,
 88342530,
 74048,
 88540516,
 86747600,
 -1,
 88606046,
 88500221,
 74367,
 88671573,
 88539136,
 -1,
 88737108,
 88659457,
 -1,
 88802636,
 88726715,
 74375,
 -1,
 88740651,
 74376,
 88933710,
 88762365,
 74373,
 -1,
 88877319,
 74374,
 89064785,
 88877319,
 -1,
 -64176,
 89054395,
 74371,
 -1,
 89090045,
 74370,
 89261395,
 89004618,
 74368,
 -1,
 89204999,
 74369,
 -1,
 89212098,
 74372,
 -1,
 88685080,
 74377,
 89587711,
 88650722,
 -1,
 89589085,
 89483962,
 74378,
 89718783,
 89522176,
 -1,
 89720156,
 89642497,
 -1,
 -64166,
 89716339,
 74381,
 -64165,
 89775830,
 74380,
 -1,
 89815333,
 74379,
 -1,
 89694995,
 74382,
 -1,
 89527083,
 74645,
 90113378,
 88545866,
 74362,
 -64160,
 90089936,
 74365,
 -64159,
 90149536,
 74364,
 -1,
 90192725,
 74363,
 90439679,
 90066550,
 74366,
 -1,
 90308899,
 74644,
 90506620,
 88536645,
 -1,
 90572141,
 90496187,
 74602,
 90637674,
 90510914,
 74603,
 90767359,
 90573461,
 -1,
 -64151,
 90690674,
 75075,
 -1,
 90708554,
 74604,
 -64149,
 90605900,
 74606,
 -64148,
 90844994,
 74605,
 -1,
 90900222,
 75074,
 91096436,
 90531837,
 74595,
 91161968,
 91040007,
 74598,
 -1,
 91096008,
 74599,
 -64143,
 91158128,
 74601,
 -64142,
 91248723,
 74600,
 -64141,
 91296848,
 74597,
 -1,
 91358965,
 74596,
 91555195,
 91036234,
 74589,
 91620728,
 91488256,
 -1,
 -64137,
 91607754,
 74590,
 -1,
 91671531,
 74591,
 -64135,
 91591300,
 74593,
 -64134,
 91773011,
 74592,
 -1,
 91822087,
 75073,
 -1,
 91506157,
 74594,
 92143615,
 90485730,
 -1,
 92145023,
 92019274,
 74383,
 -1,
 92088583,
 74384,
 -64128,
 92134587,
 74386,
 -1,
 92235773,
 74385,
 92407324,
 236069,
 -1,
 92472746,
 92361203,
 -1,
 92538264,
 92448284,
 -1,
 92603785,
 92530246,
 74812,
 92669320,
 92536832,
 -1,
 -64121,
 92612871,
 74815,
 -1,
 92674634,
 74814,
 -1,
 92607854,
 74813,
 92931469,
 92547335,
 -1,
 92997004,
 92873023,
 74834,
 -1,
 92933049,
 74835,
 -1,
 92988540,
 74808,
 93193615,
 92921019,
 74767,
 -1,
 93129657,
 74857,
 93324690,
 93177385,
 -1,
 -64111,
 93314235,
 74800,
 -1,
 93328171,
 74790,
 93521301,
 93280877,
 -1,
 -64108,
 93510843,
 74785,
 -1,
 93524779,
 74776,
 93717911,
 93464232,
 74754,
 -1,
 93653521,
 74828,
 -1,
 93667164,
 74761,
 93978623,
 92501486,
 -1,
 93980062,
 93897172,
 -1,
 94045597,
 93937655,
 -1,
 -64100,
 94035131,
 74801,
 -1,
 94049067,
 74791,
 -1,
 94009057,
 74844,
 94307746,
 93923591,
 -1,
 94373281,
 94249279,
 74836,
 -1,
 94309305,
 74837,
 -1,
 94364796,
 74809,
 94569892,
 94297275,
 74768,
 -1,
 94505913,
 74858,
 94700967,
 94526061,
 -1,
 -64090,
 94690491,
 74786,
 -1,
 94704427,
 74777,
 94897577,
 94643880,
 74755,
 -1,
 94833169,
 74829,
 -1,
 94846812,
 74762,
 95094222,
 92458998,
 -1,
 95159742,
 95053348,
 -1,
 95225265,
 95143465,
 -1,
 95290799,
 95214779,
 74798,
 -1,
 95226809,
 74799,
 95485951,
 95228715,
 74788,
 -1,
 95357881,
 74789,
 95552949,
 95168775,
 -1,
 95618484,
 95544444,
 74806,
 -1,
 95554489,
 74807,
 -1,
 95559999,
 74833,
 95815096,
 95544847,
 -1,
 -64073,
 95753255,
 74811,
 -1,
 95818517,
 74810,
 96011707,
 95771245,
 -1,
 -64070,
 96001211,
 74784,
 -1,
 96015147,
 74775,
 96208317,
 95954600,
 74753,
 -1,
 96143889,
 74827,
 -1,
 96157532,
 74760,
 96468991,
 95154230,
 -1,
 96470466,
 96392211,
 -1,
 -64063,
 96462318,
 74846,
 -1,
 96485212,
 74843,
 96667077,
 96454185,
 -1,
 -64060,
 96656571,
 74797,
 -1,
 96670507,
 74787,
 96863688,
 96623213,
 -1,
 -64057,
 96853179,
 74783,
 -1,
 96867115,
 74774,
 97060299,
 96807175,
 -1,
 -64054,
 97051772,
 74805,
 -1,
 97067327,
 74832,
 97256909,
 97003176,
 74752,
 -1,
 97192465,
 74826,
 -1,
 97209979,
 74841,
 97453543,
 95076820,
 -1,
 97519067,
 97406953,
 -1,
 97584597,
 97510964,
 -1,
 97650132,
 97517568,
 -1,
 -64045,
 97593607,
 74819,
 -1,
 97655370,
 74818,
 -1,
 97588304,
 74817,
 97912279,
 97574075,
 74770,
 -1,
 97848249,
 74860,
 -64040,
 97895982,
 74793,
 -64039,
 97999474,
 74779,
 -64038,
 98058076,
 74764,
 -1,
 98117288,
 74757,
 98305508,
 97482407,
 -1,
 98371038,
 98294971,
 74769,
 -1,
 98307001,
 74859,
 98502112,
 98313896,
 74756,
 -1,
 98437649,
 74830,
 -64031,
 98493949,
 74816,
 -64030,
 98616878,
 74792,
 -64029,
 98654834,
 74778,
 -1,
 98713436,
 74763,
 98959359,
 98263040,
 -1,
 -64026,
 98865048,
 74803,
 -1,
 98910044,
 74802,
 99091965,
 97426113,
 -1,
 99157498,
 99062960,
 -1,
 99223020,
 99144702,
 -1,
 -64021,
 99214830,
 74845,
 -1,
 99237724,
 74842,
 99419631,
 99201774,
 -1,
 -64018,
 99376505,
 74851,
 -1,
 99428008,
 74848,
 99616242,
 99375725,
 -1,
 -64015,
 99605691,
 74782,
 -1,
 99619627,
 74773,
 99812853,
 99566786,
 -1,
 -64012,
 99796548,
 74840,
 -1,
 99838915,
 74847,
 100009464,
 99756295,
 -1,
 -64009,
 100000892,
 74804,
 -1,
 100016447,
 74831,
 -64007,
 99993146,
 74796,
 -1,
 100163259,
 74852,
 100401151,
 99122921,
 -1,
 -64004,
 100321545,
 74849,
 -1,
 100381414,
 74850,
 100533772,
 99063459,
 -1,
 100599305,
 100504752,
 -1,
 100664835,
 100591136,
 74822,
 -63999,
 100603246,
 74824,
 -63998,
 100668496,
 74823,
 -1,
 100728834,
 74825,
 100926981,
 100654267,
 74772,
 -1,
 100862905,
 74862,
 -63994,
 100910638,
 74795,
 -63993,
 101014130,
 74781,
 -63992,
 101072732,
 74766,
 -1,
 101131944,
 74759,
 101384191,
 100555672,
 -1,
 -63989,
 101289880,
 74838,
 -1,
 101338738,
 74839,
 101580799,
 100484290,
 -1,
 101582358,
 101477217,
 -1,
 101647888,
 101574233,
 74820,
 -1,
 101586000,
 74821,
 101778962,
 101637307,
 74771,
 -1,
 101714873,
 74861,
 -63981,
 101762606,
 74794,
 -63980,
 101866098,
 74780,
 -63979,
 101924700,
 74765,
 -1,
 101983912,
 74758,
 102236159,
 101547401,
 -1,
 102237722,
 102126067,
 -1,
 -63975,
 102212717,
 74855,
 -1,
 102263456,
 74856,
 -63973,
 102227073,
 74854,
 -1,
 102408190,
 74853,
 102629375,
 92385720,
 -1,
 102630945,
 102514313,
 -1,
 -63969,
 102619529,
 74867,
 -63968,
 102675083,
 74868,
 -1,
 102708875,
 74866,
 -63966,
 102623190,
 74865,
 -1,
 102866256,
 74864,
 103024170,
 177122,
 -1,
 103089703,
 103003106,
 -1,
 -63962,
 103084859,
 127835,
 -1,
 103107424,
 128177,
 103350271,
 103054395,
 -1,
 -63959,
 103281512,
 10160,
 -1,
 103313379,
 129356,
 103482928,
 103000528,
 -1,
 103548462,
 103415808,
 -1,
 -63955,
 103542621,
 129380,
 -1,
 103587461,
 9982,
 -63953,
 103508533,
 11232,
 -1,
 103690258,
 129473,
 103876147,
 103468199,
 -1,
 -63950,
 103849594,
 128707,
 -1,
 103883982,
 127854,
 -63948,
 103862358,
 129385,
 -1,
 104020632,
 129362,
 104204440,
 105153,
 -1,
 104269703,
 104171852,
 -1,
 104335236,
 104213539,
 -1,
 104400518,
 104290387,
 -1,
 104466027,
 104365364,
 -1,
 104531523,
 104461110,
 -1,
 104597056,
 104481986,
 -1,
 104662591,
 104575970,
 -1,
 -63938,
 104651963,
 122911,
 -1,
 104687613,
 122912,
 -1,
 104648381,
 122885,
 -63935,
 104586427,
 122915,
 -63934,
 104897217,
 122918,
 -1,
 104933299,
 122913,
 105121353,
 104491005,
 122891,
 105186887,
 105096423,
 -1,
 -63930,
 105171595,
 122919,
 -1,
 105196531,
 122921,
 -63928,
 105183137,
 122889,
 -1,
 105355121,
 122890,
 105514575,
 105103828,
 -1,
 105580109,
 105471420,
 -1,
 -63924,
 105566332,
 122907,
 -1,
 105585226,
 122910,
 -63922,
 105548527,
 122916,
 -1,
 105744126,
 122900,
 105907794,
 105510469,
 -1,
 -63919,
 105866217,
 122886,
 -1,
 105925319,
 122888,
 106104405,
 105893878,
 -1,
 -63916,
 106097279,
 122901,
 -1,
 106153830,
 122908,
 106301016,
 106058227,
 -1,
 -63913,
 106282685,
 122903,
 -1,
 106329379,
 122922,
 106497627,
 106249045,
 -1,
 -63910,
 106470240,
 122884,
 -1,
 106526655,
 122892,
 106694238,
 106440967,
 -1,
 -63907,
 106684317,
 122881,
 -1,
 106719933,
 122920,
 -63905,
 106686153,
 122882,
 -63904,
 106880916,
 122902,
 -63903,
 106938039,
 122899,
 -63902,
 106999664,
 122898,
 -63901,
 107061571,
 122897,
 -63900,
 107123573,
 122896,
 -63899,
 107188888,
 122895,
 -63898,
 107250972,
 122894,
 -63897,
 107313440,
 122893,
 -63896,
 107373018,
 122904,
 -63895,
 107437050,
 122883,
 -63894,
 107492260,
 122909,
 -1,
 107555075,
 122880,
 107806719,
 104444898,
 -1,
 107808385,
 107682378,
 -1,
 107873918,
 107780507,
 -1,
 107939448,
 107822829,
 -1,
 108004978,
 107925494,
 -1,
 -63887,
 107999283,
 70504,
 -1,
 108029471,
 70505,
 108201589,
 107958771,
 -1,
 -63884,
 108176920,
 70506,
 -1,
 108230122,
 70507,
 -63882,
 108197680,
 70502,
 -63881,
 108382420,
 70508,
 -1,
 108437273,
 70503,
 108658687,
 107905698,
 -1,
 -63878,
 108587185,
 70515,
 -63877,
 108636705,
 70516,
 -63876,
 108696298,
 70514,
 -63875,
 108755136,
 70513,
 -1,
 108796490,
 70512,
 109051903,
 107865797,
 -1,
 -63872,
 108956107,
 7621,
 -1,
 108993669,
 7624,
 109248511,
 107759614,
 -1,
 109250181,
 109170678,
 -1,
 -63868,
 109231717,
 119362,
 -1,
 109268730,
 119363,
 -1,
 109227187,
 119364,
 109512394,
 104345512,
 -1,
 109577928,
 109508134,
 -1,
 109643452,
 109544098,
 -1,
 109708945,
 109593794,
 -1,
 109774476,
 109691348,
 11757,
 -1,
 109711574,
 11765,
 -63859,
 109753314,
 11756,
 -63858,
 109875872,
 11753,
 -63857,
 109939020,
 11752,
 -63856,
 110001211,
 11751,
 -1,
 110055923,
 42654,
 110233239,
 109668349,
 42613,
 110298774,
 110208287,
 -1,
 -63852,
 110249154,
 42655,
 -63851,
 110308339,
 11775,
 -1,
 110369354,
 11772,
 -1,
 110249154,
 11767,
 110626460,
 110228278,
 -1,
 -63847,
 110615739,
 11771,
 -63846,
 110651389,
 42614,
 -63845,
 110710318,
 42617,
 -1,
 110765831,
 11770,
 110954145,
 110608852,
 -1,
 111019680,
 110910908,
 -1,
 -63841,
 110965361,
 11763,
 -1,
 111024714,
 11762,
 -1,
 110992468,
 42618,
 111281828,
 110949957,
 -1,
 -63837,
 111239295,
 11748,
 -1,
 111297730,
 11749,
 111478438,
 111271099,
 42615,
 -1,
 111442876,
 42612,
 111609513,
 111464438,
 -1,
 -63832,
 111592444,
 11760,
 -1,
 111625410,
 11758,
 111806123,
 111581889,
 11754,
 -1,
 111775079,
 42619,
 111937197,
 111762894,
 11759,
 -1,
 111916657,
 42616,
 112068272,
 111885141,
 -1,
 -63825,
 112031674,
 11768,
 -1,
 112084162,
 11747,
 112264883,
 112011527,
 -1,
 -63822,
 112224957,
 11774,
 -1,
 112280770,
 11744,
 -63820,
 112256652,
 11745,
 -63819,
 112438245,
 11755,
 -63818,
 112496891,
 11769,
 -63817,
 112559362,
 11773,
 -63816,
 112621760,
 11750,
 -63815,
 112679649,
 11746,
 -63814,
 112743581,
 11764,
 -63813,
 112800466,
 11761,
 -1,
 112859722,
 11766,
 113051330,
 109629430,
 -1,
 113116864,
 113014208,
 -1,
 -63809,
 113097471,
 65071,
 -1,
 113147972,
 65070,
 -63807,
 113075692,
 42610,
 -1,
 113265392,
 42608,
 113444549,
 113027536,
 -1,
 -63804,
 113417524,
 1159,
 -1,
 113453299,
 42621,
 -63802,
 113437339,
 42607,
 -63801,
 113605054,
 42620,
 -1,
 113665914,
 42609,
 113901567,
 109551840,
 65062,
 -1,
 113770856,
 65069,
 113968903,
 109476923,
 -1,
 114034424,
 113911735,
 -1,
 114099954,
 114018797,
 -1,
 114165459,
 114039370,
 -1,
 -63793,
 114156954,
 7638,
 -63792,
 114203329,
 7637,
 -63791,
 114264123,
 7655,
 -63790,
 114312386,
 7636,
 -1,
 114363502,
 7666,
 114558678,
 114129979,
 7645,
 -63787,
 114532462,
 7653,
 -1,
 114560202,
 7660,
 114755288,
 114551457,
 7665,
 -1,
 114688360,
 6847,
 114886363,
 114744588,
 -1,
 -63782,
 114852848,
 7664,
 -1,
 114900584,
 7668,
 115082973,
 114868692,
 7652,
 -1,
 115028952,
 7658,
 115214048,
 115061732,
 -1,
 -63777,
 115195958,
 7651,
 -1,
 115223277,
 7626,
 115410659,
 115186438,
 -1,
 -63774,
 115377136,
 7661,
 -1,
 115424872,
 7667,
 115607269,
 115364339,
 7659,
 -1,
 115572380,
 7635,
 115738344,
 115557570,
 -1,
 -63769,
 115725133,
 7641,
 -1,
 115787078,
 7663,
 115934954,
 115681543,
 7656,
 -1,
 115887798,
 7657,
 -63765,
 115930693,
 7654,
 -63764,
 116054887,
 6848,
 -63763,
 116107728,
 7662,
 -63762,
 116167328,
 7648,
 -63761,
 116226144,
 7644,
 -63760,
 116289839,
 7640,
 -63759,
 116349011,
 7642,
 -1,
 116404141,
 7639,
 116654079,
 114066127,
 -1,
 -63756,
 116569058,
 7650,
 -63755,
 116626080,
 7649,
 -63754,
 116689228,
 7647,
 -63753,
 116751419,
 7646,
 -1,
 116807763,
 7643,
 116983553,
 113985712,
 -1,
 117049088,
 116916224,
 -1,
 117114623,
 116991424,
 -1,
 117180158,
 117072015,
 -1,
 -63747,
 117123821,
 852,
 -1,
 117185442,
 7678,
 -1,
 117113192,
 8430,
 -1,
 117071591,
 849,
 -1,
 117042059,
 8429,
 117573382,
 116943546,
 -1,
 117638917,
 117516288,
 -1,
 -63740,
 117619466,
 65064,
 -1,
 117669966,
 65063,
 -1,
 117598002,
 6841,
 -1,
 117547081,
 8427,
 117966648,
 113916757,
 -1,
 118032162,
 117916866,
 -1,
 118097697,
 118023628,
 -1,
 118163224,
 118046445,
 -1,
 118228750,
 118149110,
 -1,
 -63731,
 118222899,
 43234,
 -1,
 118253087,
 43235,
 118425361,
 118211028,
 -1,
 -63728,
 118388388,
 43238,
 -1,
 118444004,
 43239,
 118621972,
 118378995,
 -1,
 -63725,
 118597144,
 43236,
 -1,
 118650346,
 43237,
 -63723,
 118617904,
 43232,
 -63722,
 118791961,
 43233,
 -63721,
 118855406,
 43241,
 -1,
 118901150,
 43240,
 119080736,
 118129314,
 -1,
 -63718,
 119072945,
 43248,
 -63717,
 119135419,
 43243,
 -63716,
 119190612,
 43247,
 -63715,
 119253537,
 43246,
 -63714,
 119313130,
 43245,
 -63713,
 119371968,
 43244,
 -1,
 119413322,
 43242,
 -1,
 119064545,
 43249,
 -1,
 118063759,
 7675,
 119736119,
 118004417,
 -1,
 119801647,
 119725567,
 -1,
 119867182,
 119734272,
 -1,
 119932711,
 119835083,
 862,
 -1,
 119865704,
 863,
 120063785,
 119877269,
 861,
 -1,
 119996776,
 860,
 -63702,
 120044862,
 858,
 -63701,
 120171352,
 6844,
 -63700,
 120234577,
 6840,
 -63699,
 120287764,
 7676,
 -1,
 120337597,
 7629,
 -1,
 119815011,
 6832,
 120588086,
 119787510,
 -1,
 120653619,
 120574478,
 -1,
 -63694,
 120609994,
 7616,
 -1,
 120659064,
 7617,
 120913919,
 120586252,
 -1,
 -63691,
 120830631,
 856,
 -1,
 120881184,
 7672,
 -1,
 120582161,
 6835,
 -1,
 119695488,
 6833,
 121177925,
 117947047,
 -1,
 121243460,
 121110528,
 -1,
 121308995,
 121185728,
 -1,
 121374530,
 121266319,
 -1,
 121440065,
 121313866,
 -1,
 121505600,
 121410504,
 -1,
 -63681,
 121495920,
 854,
 -1,
 121520789,
 7679,
 -1,
 121450035,
 848,
 -1,
 121383661,
 853,
 -1,
 121307496,
 8431,
 -1,
 121265895,
 855,
 -1,
 121236363,
 8428,
 122029902,
 121150145,
 -1,
 122095436,
 121995009,
 -1,
 -63672,
 122091262,
 66424,
 -63671,
 122144834,
 66426,
 -63670,
 122197359,
 66425,
 -63669,
 122240931,
 66423,
 -1,
 122298661,
 66422,
 -63667,
 122072132,
 6839,
 -1,
 122444894,
 7630,
 122619736,
 121997771,
 -1,
 122685268,
 122552320,
 -1,
 122750802,
 122665727,
 65061,
 -1,
 122683752,
 65068,
 122945535,
 122716228,
 65060,
 -1,
 122814824,
 65067,
 123076607,
 122621778,
 -1,
 -63658,
 122969284,
 7622,
 -63657,
 123022997,
 7628,
 -1,
 123083890,
 7620,
 123275104,
 122559050,
 -1,
 123340636,
 123260233,
 -1,
 -63653,
 123284205,
 857,
 -1,
 123345826,
 8432,
 123537247,
 123288375,
 -1,
 -63650,
 123505099,
 7623,
 -1,
 123559127,
 7625,
 -1,
 123504080,
 7677,
 123799396,
 123264187,
 -1,
 -63646,
 123781593,
 7634,
 -63645,
 123843559,
 7633,
 -1,
 123906545,
 7669,
 124061545,
 123785206,
 -1,
 124127080,
 124021903,
 -1,
 -63641,
 124107530,
 65066,
 -1,
 124158030,
 65065,
 -1,
 124108302,
 6836,
 124389229,
 124043732,
 -1,
 -63637,
 124380417,
 7619,
 -63636,
 124443141,
 6842,
 -1,
 124490549,
 7618,
 124651377,
 124365643,
 -1,
 -63633,
 124627178,
 6846,
 -63632,
 124660461,
 6845,
 -1,
 124722082,
 6843,
 124913524,
 124647356,
 -1,
 -63629,
 124857069,
 7631,
 -1,
 124918690,
 859,
 125110135,
 124908080,
 -1,
 -63626,
 125047010,
 6837,
 -1,
 125108584,
 851,
 125306746,
 125103580,
 -1,
 -63623,
 125262495,
 6838,
 -1,
 125320459,
 7673,
 125503357,
 125270469,
 -1,
 -63620,
 125483687,
 7670,
 -1,
 125534240,
 7671,
 125699968,
 125462525,
 -1,
 -63617,
 125682158,
 7632,
 -1,
 125736406,
 6834,
 125896579,
 125643015,
 -1,
 -63614,
 125876492,
 7627,
 -1,
 125922956,
 70459,
 -1,
 125850345,
 850,
 126222335,
 104311248,
 -1,
 -63610,
 126138589,
 128476,
 -1,
 126166743,
 129517,
 126355549,
 104245712,
 -1,
 126421084,
 126342470,
 -1,
 126486490,
 126403028,
 -1,
 126552016,
 126454467,
 -1,
 126617506,
 126524097,
 11423,
 126683041,
 126582501,
 -1,
 126748571,
 126629967,
 -1,
 126814099,
 126705084,
 -1,
 126879633,
 126753354,
 11471,
 -1,
 126865398,
 11477,
 -63598,
 126854067,
 11469,
 -1,
 126962061,
 11475,
 127141782,
 126797126,
 -1,
 -63595,
 127102168,
 11483,
 -1,
 127158669,
 11461,
 -63593,
 127115731,
 11455,
 -63592,
 127293745,
 11479,
 -63591,
 127356530,
 11463,
 -63590,
 127418240,
 11481,
 -1,
 127475338,
 11445,
 127729663,
 126720479,
 -1,
 127731615,
 127636128,
 -1,
 -63586,
 127726800,
 11489,
 -1,
 127753074,
 11487,
 -63584,
 127724471,
 11491,
 -1,
 127911596,
 11485,
 -1,
 126657944,
 11441,
 128124841,
 126565205,
 -1,
 128190376,
 128084147,
 -1,
 -63579,
 128161443,
 11451,
 -63578,
 128219447,
 11449,
 -63577,
 128279776,
 11467,
 -1,
 128327602,
 11443,
 -1,
 128130985,
 11399,
 128583600,
 128071856,
 -1,
 128649135,
 128579069,
 -1,
 -63572,
 128632403,
 11500,
 -63571,
 128685731,
 11453,
 -63570,
 128735537,
 11502,
 -1,
 128797082,
 11447,
 -1,
 128623781,
 11459,
 129042356,
 128565716,
 -1,
 -63566,
 129017240,
 11403,
 -63565,
 129068248,
 11429,
 -1,
 129114388,
 11457,
 129304504,
 129005664,
 -1,
 -63562,
 129288038,
 11421,
 -63561,
 129327702,
 11437,
 -1,
 129377253,
 11413,
 129566651,
 129290230,
 -1,
 -63558,
 129524238,
 11409,
 -1,
 129574942,
 11431,
 129763262,
 129542608,
 -1,
 -63555,
 129746790,
 11439,
 -1,
 129787901,
 11425,
 129959873,
 129727547,
 -1,
 -63552,
 129902660,
 11415,
 -1,
 129962134,
 11473,
 130156484,
 129899082,
 -1,
 -63549,
 130122533,
 11393,
 -1,
 130185891,
 11465,
 -63547,
 130152190,
 11405,
 -63546,
 130345153,
 11395,
 -63545,
 130407764,
 11433,
 -63544,
 130465578,
 11427,
 -63543,
 130520739,
 11419,
 -63542,
 130584078,
 11417,
 -63541,
 130640176,
 11411,
 -63540,
 130703442,
 11407,
 -63539,
 130767121,
 11397,
 -63538,
 130831205,
 11435,
 -63537,
 130894234,
 11401,
 -1,
 130952598,
 11507,
 131203071,
 126547301,
 -1,
 131205076,
 131121620,
 -1,
 -63533,
 131191219,
 11495,
 -1,
 131228483,
 11498,
 131401687,
 131168352,
 -1,
 -63530,
 131359321,
 11497,
 -1,
 131407446,
 11492,
 -63528,
 131387820,
 11496,
 -63527,
 131575106,
 11494,
 -1,
 131632661,
 11493,
 131794982,
 126431144,
 -1,
 131860513,
 131736582,
 -1,
 131926003,
 131832513,
 11422,
 131991538,
 131890917,
 -1,
 132057068,
 131938383,
 -1,
 132122596,
 132013500,
 -1,
 132188130,
 132061770,
 11470,
 -1,
 132173814,
 11476,
 -63517,
 132162483,
 11468,
 -1,
 132270477,
 11474,
 132450279,
 132105542,
 -1,
 -63514,
 132410584,
 11482,
 -1,
 132467085,
 11460,
 -63512,
 132424147,
 11454,
 -63511,
 132602161,
 11478,
 -63510,
 132664946,
 11462,
 -63509,
 132726656,
 11480,
 -1,
 132783754,
 11444,
 133038079,
 132028895,
 -1,
 133040112,
 132944544,
 -1,
 -63505,
 133035216,
 11488,
 -1,
 133061490,
 11486,
 -63503,
 133032887,
 11490,
 -1,
 133220012,
 11484,
 -1,
 131966360,
 11440,
 133433338,
 131873621,
 -1,
 133498873,
 133392563,
 -1,
 -63498,
 133469859,
 11450,
 -63497,
 133527863,
 11448,
 -63496,
 133588192,
 11466,
 -1,
 133636018,
 11442,
 -1,
 133439401,
 11398,
 133892097,
 133380272,
 -1,
 133957632,
 133887485,
 -1,
 -63491,
 133940819,
 11499,
 -63490,
 133994147,
 11452,
 -63489,
 134043953,
 11501,
 -1,
 134105498,
 11446,
 -1,
 133932197,
 11458,
 134350853,
 133874132,
 -1,
 -63485,
 134325656,
 11402,
 -63484,
 134376664,
 11428,
 -1,
 134422804,
 11456,
 134613001,
 134314080,
 -1,
 -63481,
 134596454,
 11420,
 -63480,
 134636118,
 11436,
 -1,
 134685669,
 11412,
 134875148,
 134598646,
 -1,
 -63477,
 134832654,
 11408,
 -1,
 134883358,
 11430,
 135071759,
 134851024,
 -1,
 -63474,
 135055206,
 11438,
 -1,
 135096317,
 11424,
 135268370,
 135035963,
 -1,
 -63471,
 135211076,
 11414,
 -1,
 135270550,
 11472,
 135464981,
 135207498,
 -1,
 -63468,
 135430949,
 11392,
 -1,
 135494307,
 11464,
 -63466,
 135460606,
 11404,
 -63465,
 135653569,
 11394,
 -63464,
 135716180,
 11432,
 -63463,
 135773994,
 11426,
 -63462,
 135829155,
 11418,
 -63461,
 135892494,
 11416,
 -63460,
 135948592,
 11410,
 -63459,
 136011858,
 11406,
 -63458,
 136075537,
 11396,
 -63457,
 136139621,
 11434,
 -63456,
 136202650,
 11400,
 -1,
 136261014,
 11506,
 136511487,
 131833381,
 -1,
 136513573,
 136432536,
 -1,
 -63452,
 136479333,
 11505,
 -1,
 136521414,
 11504,
 -1,
 136484518,
 11503,
 136775763,
 131746991,
 -1,
 136841285,
 136747511,
 -1,
 136906800,
 136826870,
 -1,
 136972332,
 136899233,
 -1,
 -63445,
 136944332,
 66292,
 -1,
 136989786,
 66283,
 137168943,
 136928700,
 -1,
 -63442,
 137148343,
 66293,
 -1,
 137196593,
 66284,
 -1,
 137120481,
 66282,
 137431095,
 136888788,
 -1,
 137496628,
 137393828,
 -1,
 -63437,
 137485452,
 66287,
 -1,
 137495425,
 66296,
 137756671,
 137449444,
 -1,
 -63434,
 137682060,
 66288,
 -1,
 137692033,
 66297,
 137889854,
 137384435,
 -1,
 137955387,
 137861825,
 -1,
 -63430,
 137946025,
 66294,
 -1,
 138002707,
 66285,
 138215423,
 137914365,
 -1,
 -63427,
 138143387,
 66295,
 -1,
 138172471,
 66286,
 138348609,
 137860846,
 -1,
 -63424,
 138337420,
 66290,
 -1,
 138347393,
 66299,
 138545220,
 138299806,
 -1,
 -63421,
 138539830,
 66289,
 -1,
 138544001,
 66298,
 -1,
 138518369,
 66291,
 138807378,
 136789741,
 -1,
 138872905,
 138792950,
 -1,
 -63416,
 138866739,
 66274,
 -1,
 138896927,
 66275,
 139069516,
 138854868,
 -1,
 -63413,
 139032228,
 66278,
 -1,
 139087844,
 66279,
 139266127,
 139022835,
 -1,
 -63410,
 139240984,
 66276,
 -1,
 139294186,
 66277,
 -63408,
 139239193,
 66273,
 -63407,
 139433710,
 66281,
 -1,
 139479454,
 66280,
 -1,
 138794065,
 66272,
 139724888,
 136748394,
 -1,
 -63403,
 139716464,
 11516,
 -63402,
 139751029,
 11515,
 -63401,
 139810882,
 11513,
 -1,
 139870007,
 11514,
 140052571,
 139678195,
 -1,
 -63398,
 140042175,
 11518,
 -1,
 140096641,
 11517,
 -1,
 140022041,
 11519,
 -1,
 126416174,
 127279,
 140380283,
 126344379,
 -1,
 140445817,
 140351921,
 -1,
 140511340,
 140435741,
 -1,
 140576867,
 140496886,
 -1,
 -63390,
 140570675,
 119649,
 -1,
 140600863,
 119650,
 140773478,
 140558804,
 -1,
 -63387,
 140736164,
 119653,
 -1,
 140791780,
 119654,
 140970089,
 140726771,
 -1,
 -63384,
 140944920,
 119651,
 -1,
 140998122,
 119652,
 -63382,
 140943129,
 119648,
 -63381,
 141137646,
 119656,
 -1,
 141183390,
 119655,
 141426687,
 140497586,
 -1,
 141428848,
 141348854,
 -1,
 -63377,
 141422643,
 119658,
 -1,
 141452831,
 119659,
 141625459,
 141410772,
 -1,
 -63374,
 141588132,
 119662,
 -1,
 141643748,
 119663,
 141822070,
 141578739,
 -1,
 -63371,
 141796888,
 119660,
 -1,
 141850090,
 119661,
 -63369,
 141795097,
 119657,
 -63368,
 141989614,
 119665,
 -1,
 142035358,
 119664,
 -63366,
 140422658,
 128145,
 -1,
 142160457,
 128715,
 142346375,
 140350112,
 -1,
 142411904,
 142299635,
 -1,
 -63362,
 142402744,
 128533,
 -63361,
 142452226,
 128534,
 -1,
 142495542,
 127882,
 142674051,
 142399991,
 -1,
 -63358,
 142656710,
 983186,
 -1,
 142703446,
 127899,
 142870662,
 142659222,
 -1,
 -63355,
 142864841,
 128119,
 -1,
 142919638,
 128679,
 -1,
 142862105,
 127978,
 143132812,
 142318833,
 -1,
 143198347,
 143091709,
 -1,
 -63350,
 143169008,
 127859,
 -1,
 143213762,
 127850,
 -1,
 143148927,
 127834,
 143460497,
 143077288,
 -1,
 143526032,
 143423584,
 -1,
 -63345,
 143511812,
 127864,
 -1,
 143572789,
 129715,
 -1,
 143499591,
 129381,
 143788179,
 143452833,
 128004,
 -1,
 143721165,
 128046,
 -63340,
 143769366,
 11855,
 -63339,
 143885710,
 128165,
 -63338,
 143945019,
 129689,
 -63337,
 144003915,
 9904,
 -1,
 144058119,
 129509,
 144247313,
 104160700,
 -1,
 144312690,
 144185930,
 -1,
 144378119,
 144279886,
 -1,
 144443614,
 144343714,
 -1,
 144509096,
 144397209,
 -1,
 144574623,
 144478880,
 43590,
 -1,
 144529491,
 43586,
 -63328,
 144569142,
 43592,
 -63327,
 144691190,
 43589,
 -63326,
 144755739,
 43595,
 -63325,
 144815074,
 43593,
 -63324,
 144878032,
 43591,
 -63323,
 144931899,
 43594,
 -63322,
 144996448,
 43584,
 -63321,
 145053779,
 43585,
 -1,
 145109574,
 43588,
 145295538,
 144478880,
 -1,
 145361069,
 145251772,
 -1,
 -63317,
 145350409,
 43536,
 -63316,
 145389407,
 43538,
 -1,
 145431114,
 43537,
 145623216,
 145315923,
 -1,
 -63313,
 145612553,
 43530,
 -1,
 145627722,
 43531,
 -63311,
 145612553,
 43543,
 -1,
 145758794,
 43544,
 145950902,
 145271248,
 -1,
 -63308,
 145926689,
 43547,
 -63307,
 145972686,
 43548,
 -1,
 146020938,
 43546,
 146213050,
 145898325,
 -1,
 -63304,
 146169294,
 43542,
 -63303,
 146226176,
 43545,
 -1,
 146283082,
 43541,
 146475198,
 146155783,
 -1,
 -63300,
 146431438,
 43550,
 -63299,
 146483512,
 43553,
 -1,
 146545226,
 43549,
 146737345,
 146460662,
 -1,
 -63296,
 146693582,
 43540,
 -1,
 146741834,
 43539,
 146933956,
 146719188,
 -1,
 -63293,
 146916009,
 43558,
 -1,
 146938442,
 43559,
 147130567,
 146901324,
 -1,
 -63290,
 147119881,
 43551,
 -1,
 147135050,
 43552,
 147327178,
 147093600,
 -1,
 -63287,
 147283406,
 43527,
 -1,
 147331658,
 43526,
 147523789,
 147289921,
 -1,
 -63284,
 147480014,
 43535,
 -1,
 147528266,
 43534,
 147720400,
 147478611,
 -1,
 -63281,
 147676622,
 43529,
 -1,
 147724874,
 43528,
 147917011,
 147665478,
 -1,
 -63278,
 147873230,
 43533,
 -1,
 147921482,
 43532,
 148113621,
 147855946,
 43520,
 -1,
 148072445,
 43524,
 -63274,
 148108218,
 43554,
 -63273,
 148235693,
 43557,
 -63272,
 148298939,
 43522,
 -63271,
 148354132,
 43555,
 -63270,
 148413121,
 43525,
 -63269,
 148470917,
 43556,
 -63268,
 148531197,
 43521,
 -63267,
 148594126,
 43560,
 -1,
 148653250,
 43523,
 148834538,
 144435754,
 -1,
 148900067,
 148773450,
 -1,
 -63263,
 148888763,
 43569,
 -63262,
 148924413,
 43568,
 -1,
 148970058,
 43561,
 149162213,
 148888763,
 43565,
 -1,
 149112002,
 43570,
 149293287,
 149134017,
 43567,
 -1,
 149243074,
 43566,
 149424361,
 149252093,
 43562,
 -1,
 149383165,
 43563,
 -1,
 149375373,
 43564,
 149620984,
 148782829,
 -1,
 149686510,
 149606390,
 -1,
 -63251,
 149680179,
 43602,
 -1,
 149710367,
 43603,
 149883121,
 149668308,
 -1,
 -63248,
 149845668,
 43606,
 -1,
 149901284,
 43607,
 150079732,
 149836275,
 -1,
 -63245,
 150054424,
 43604,
 -1,
 150107626,
 43605,
 -63243,
 150075184,
 43600,
 -63242,
 150249241,
 43601,
 -63241,
 150312686,
 43609,
 -1,
 150358430,
 43608,
 150538497,
 149567373,
 -1,
 150604029,
 150492057,
 -1,
 -63237,
 150574576,
 43587,
 -63236,
 150636876,
 43596,
 -1,
 150691260,
 43597,
 -63234,
 150598586,
 43571,
 -63233,
 150858465,
 43574,
 -63232,
 150910036,
 43572,
 -1,
 150961285,
 43573,
 151191551,
 150516066,
 -1,
 151193861,
 151075669,
 -1,
 -63228,
 151168418,
 43614,
 -1,
 151200393,
 43613,
 -63226,
 151181765,
 43615,
 -1,
 151374725,
 43612,
 151521638,
 144341835,
 -1,
 151587132,
 151487138,
 -1,
 151652623,
 151572470,
 -1,
 151718157,
 151638006,
 -1,
 -63220,
 151674339,
 69906,
 -1,
 151722767,
 69905,
 -63218,
 151674339,
 69911,
 -1,
 151853839,
 69910,
 152045844,
 151622304,
 -1,
 -63215,
 152040389,
 69904,
 -63214,
 152081174,
 69909,
 -63213,
 152131749,
 69899,
 -1,
 152181519,
 69914,
 152373530,
 151993173,
 -1,
 152439064,
 152320853,
 -1,
 -63209,
 152395235,
 69908,
 -1,
 152443663,
 69907,
 -63207,
 152395235,
 69913,
 -1,
 152574735,
 69912,
 152766749,
 152367926,
 -1,
 -63204,
 152761285,
 69920,
 -1,
 152771343,
 69921,
 152963360,
 152742352,
 -1,
 -63201,
 152919523,
 69916,
 -1,
 152967951,
 69915,
 153159971,
 152927291,
 -1,
 -63198,
 153116131,
 69956,
 -1,
 153164559,
 69923,
 153356582,
 153122912,
 -1,
 -63195,
 153312739,
 69896,
 -1,
 153361167,
 69895,
 153553193,
 153319233,
 -1,
 -63192,
 153509347,
 69903,
 -1,
 153557775,
 69902,
 153749804,
 153507923,
 -1,
 -63189,
 153705955,
 69898,
 -1,
 153754383,
 69897,
 153946415,
 153694120,
 -1,
 -63186,
 153902563,
 69901,
 -1,
 153950991,
 69900,
 154143026,
 153889031,
 -1,
 -63183,
 154099171,
 69918,
 -1,
 154147599,
 69917,
 -63181,
 154135268,
 69924,
 -63180,
 154330544,
 69959,
 -63179,
 154393787,
 69893,
 -63178,
 154452665,
 69925,
 -63177,
 154514543,
 69922,
 -63176,
 154569125,
 69919,
 -63175,
 154626045,
 69892,
 -63174,
 154688995,
 69926,
 -63173,
 154748098,
 69894,
 -1,
 154802959,
 69891,
 154995019,
 151578010,
 -1,
 155060554,
 154970442,
 -1,
 155126082,
 154999370,
 69927,
 -63168,
 155114683,
 69935,
 -63167,
 155150333,
 69933,
 -1,
 155195978,
 69957,
 155388228,
 155114683,
 69930,
 -1,
 155376827,
 69931,
 155519302,
 155359937,
 69934,
 -1,
 155478013,
 69936,
 155650376,
 155478013,
 69928,
 -1,
 155609085,
 69929,
 155844607,
 155600066,
 69932,
 -1,
 155740157,
 69958,
 -1,
 155022152,
 69939,
 155978076,
 154942293,
 -1,
 156043610,
 155937771,
 -1,
 156109136,
 156028918,
 -1,
 -63153,
 156102707,
 69944,
 -1,
 156132895,
 69945,
 156305747,
 156090836,
 -1,
 -63150,
 156268196,
 69948,
 -1,
 156323812,
 69949,
 156502358,
 156258803,
 -1,
 -63147,
 156476952,
 69946,
 -1,
 156530154,
 69947,
 -63145,
 156497712,
 69942,
 -63144,
 156671769,
 69943,
 -63143,
 156735214,
 69951,
 -1,
 156780958,
 69950,
 -63141,
 156018082,
 69954,
 -1,
 156902025,
 69953,
 157092194,
 155959764,
 -1,
 157157729,
 157051906,
 -1,
 -63137,
 157149460,
 69890,
 -63136,
 157167740,
 69888,
 -1,
 157230022,
 69889,
 -1,
 157107984,
 69952,
 -63133,
 157070215,
 69955,
 -63132,
 157457151,
 69937,
 -63131,
 157518255,
 69940,
 -1,
 157558832,
 69938,
 157747567,
 151499746,
 -1,
 157813099,
 157732977,
 -1,
 157878634,
 157803403,
 128200,
 -1,
 157810888,
 128185,
 -1,
 157828051,
 128201,
 158138367,
 157752417,
 983058,
 158203903,
 158007296,
 -1,
 -63122,
 158133946,
 983139,
 -1,
 158188781,
 983136,
 158400511,
 157706237,
 -1,
 -63119,
 158315490,
 129681,
 -1,
 158374089,
 9939,
 158534115,
 144262338,
 -1,
 158599644,
 158512098,
 -1,
 158665177,
 158571803,
 -1,
 158730712,
 158648813,
 -1,
 158796168,
 158715894,
 -1,
 158861694,
 158777812,
 -1,
 -63111,
 158852506,
 43960,
 -63110,
 158915771,
 43959,
 -63109,
 158964417,
 43958,
 -63108,
 159016957,
 43957,
 -63107,
 159073474,
 43956,
 -1,
 159128138,
 43955,
 159320453,
 158825531,
 -1,
 -63104,
 159311258,
 43954,
 -63103,
 159374523,
 43953,
 -63102,
 159423169,
 43952,
 -63101,
 159475709,
 43951,
 -63100,
 159532226,
 43950,
 -1,
 159586890,
 43949,
 -63098,
 159279101,
 43944,
 -63097,
 159728834,
 43942,
 -1,
 159783498,
 43940,
 159975823,
 158777812,
 43933,
 -63094,
 159966618,
 43938,
 -63093,
 160029883,
 43937,
 -63092,
 160078529,
 43936,
 -63091,
 160131069,
 43935,
 -63090,
 160187586,
 43934,
 -1,
 160242250,
 43932,
 160434583,
 159945376,
 -1,
 160500114,
 160373322,
 43918,
 -1,
 160456124,
 43920,
 -63085,
 160490906,
 43925,
 -63084,
 160619707,
 43924,
 -63083,
 160668353,
 43923,
 -63082,
 160720893,
 43922,
 -1,
 160777410,
 43921,
 160958879,
 160390588,
 -1,
 -63079,
 160949658,
 43906,
 -63078,
 161012923,
 43905,
 -63077,
 161061569,
 43904,
 -63076,
 161125098,
 43919,
 -63075,
 161179645,
 43903,
 -63074,
 161236162,
 43902,
 -1,
 161290826,
 43901,
 161483175,
 160906069,
 -1,
 -63071,
 161473946,
 43947,
 -63070,
 161537211,
 43946,
 -63069,
 161585857,
 43945,
 -63068,
 161643653,
 43948,
 -63067,
 161703933,
 43943,
 -63066,
 161760450,
 43941,
 -1,
 161815114,
 43939,
 162007470,
 161477430,
 -1,
 -63063,
 161998234,
 5116,
 -63062,
 162061499,
 5115,
 -63061,
 162110145,
 5114,
 -63060,
 162162685,
 5113,
 -63059,
 162219202,
 5112,
 -1,
 162273866,
 43967,
 162466229,
 161999521,
 -1,
 -63056,
 162456986,
 43966,
 -63055,
 162520251,
 43965,
 -63054,
 162568897,
 43964,
 -63053,
 162621437,
 43963,
 -63052,
 162677954,
 43962,
 -1,
 162732618,
 43961,
 162924988,
 162443908,
 -1,
 -63049,
 162915738,
 43931,
 -63048,
 162979003,
 43930,
 -63047,
 163027649,
 43929,
 -63046,
 163080189,
 43928,
 -63045,
 163136706,
 43927,
 -1,
 163191370,
 43926,
 163383747,
 162892108,
 -1,
 -63042,
 163374490,
 5117,
 -63041,
 163437755,
 43917,
 -63040,
 163486401,
 43916,
 -63039,
 163538941,
 43915,
 -63038,
 163595458,
 43914,
 -1,
 163650122,
 43913,
 163842506,
 163347515,
 -1,
 -63035,
 163833242,
 43912,
 -63034,
 163896507,
 43911,
 -63033,
 163945153,
 43910,
 -63032,
 163997693,
 43909,
 -63031,
 164054210,
 43908,
 -1,
 164108874,
 43907,
 164301265,
 163797075,
 -1,
 -63028,
 164291994,
 43900,
 -63027,
 164355259,
 43899,
 -63026,
 164403905,
 43898,
 -63025,
 164456445,
 43897,
 -63024,
 164512962,
 43896,
 -1,
 164567626,
 43894,
 -63022,
 164291994,
 43893,
 -63021,
 164748475,
 43892,
 -63020,
 164797121,
 43891,
 -63019,
 164853952,
 43895,
 -63018,
 164915197,
 43890,
 -63017,
 164971714,
 43889,
 -1,
 165026378,
 43888,
 -1,
 158696118,
 5109,
 165347327,
 158643170,
 -1,
 -63013,
 165278543,
 127800,
 -1,
 165309015,
 127826,
 165480927,
 158549186,
 -1,
 -63010,
 165463043,
 129472,
 -1,
 165526891,
 128227,
 165677537,
 165426550,
 128638,
 -1,
 165610211,
 129941,
 -63006,
 165662098,
 127792,
 -1,
 165786482,
 127937,
 165939721,
 158505665,
 -1,
 166005255,
 165918121,
 -1,
 166070781,
 165970594,
 -1,
 166136298,
 166052308,
 -1,
 -63000,
 166103706,
 69553,
 -62999,
 166159187,
 69571,
 -1,
 166207737,
 69567,
 166398444,
 166092927,
 69557,
 -1,
 166384461,
 69561,
 166529519,
 166337098,
 -1,
 -62994,
 166524157,
 69568,
 -1,
 166560363,
 69552,
 -62992,
 166524675,
 69560,
 -62991,
 166720958,
 69562,
 -62990,
 166783953,
 69558,
 -62989,
 166842810,
 69572,
 -62988,
 166901930,
 69570,
 -62987,
 166964197,
 69569,
 -62986,
 167025203,
 69566,
 -62985,
 167087493,
 69565,
 -62984,
 167148930,
 69564,
 -62983,
 167213372,
 69563,
 -62982,
 167271344,
 69555,
 -62981,
 167328850,
 69556,
 -62980,
 167393989,
 69559,
 -1,
 167455566,
 69554,
 167706623,
 166042103,
 -1,
 167709188,
 167628790,
 -1,
 167774722,
 167701153,
 -1,
 -62975,
 167746241,
 69574,
 -1,
 167791706,
 69578,
 -62973,
 167732767,
 69575,
 -1,
 167922401,
 69577,
 168102406,
 167681817,
 69573,
 -1,
 168035201,
 69579,
 -1,
 168056434,
 69576,
 -62968,
 165982488,
 129378,
 -1,
 168244853,
 127851,
 168430095,
 165898237,
 -1,
 168495628,
 168394466,
 129490,
 -1,
 168474709,
 128696,
 -62963,
 168476558,
 9911,
 -62962,
 168603308,
 128063,
 -1,
 168637809,
 128020,
 -62960,
 168420311,
 9962,
 -1,
 168804010,
 127876,
 168954662,
 144185930,
 -1,
 169020043,
 168923808,
 983098,
 169085571,
 168959195,
 -1,
 169151012,
 169056961,
 -1,
 169216547,
 169113549,
 -1,
 169282076,
 169185952,
 6361,
 169410559,
 169274017,
 -1,
 169413146,
 169319105,
 6347,
 -1,
 169384641,
 6349,
 169607167,
 169371645,
 6343,
 -1,
 169502717,
 6345,
 169675294,
 169263572,
 6362,
 -1,
 169631164,
 6363,
 -62945,
 169660406,
 6357,
 -62944,
 169781712,
 6356,
 -62943,
 169838924,
 6360,
 -62942,
 169900128,
 6358,
 -1,
 169947048,
 6359,
 -1,
 169210678,
 6320,
 170199605,
 169142945,
 -1,
 170265135,
 170172761,
 -1,
 170330670,
 170251565,
 -1,
 170396201,
 170302145,
 5754,
 -1,
 170367681,
 5755,
 170527275,
 170354685,
 5752,
 -1,
 170485757,
 5753,
 170658349,
 170465866,
 5756,
 -1,
 170596938,
 5757,
 -1,
 170608617,
 5751,
 -1,
 170284043,
 5758,
 170920500,
 170217093,
 -1,
 170986035,
 170856329,
 -1,
 -62926,
 170959180,
 6369,
 -1,
 170990351,
 6370,
 -1,
 170937841,
 6365,
 -1,
 170862792,
 6323,
 171313730,
 170181076,
 -1,
 171379261,
 171256008,
 6335,
 171507711,
 171340921,
 -1,
 171510331,
 171427142,
 -1,
 -62918,
 171502618,
 6378,
 -1,
 171549004,
 6379,
 -62916,
 171472984,
 6385,
 -1,
 171664512,
 6380,
 171838017,
 171335100,
 -1,
 -62913,
 171831760,
 6338,
 -62912,
 171878804,
 6336,
 -1,
 171911368,
 6337,
 -1,
 171813268,
 6334,
 172165710,
 171298806,
 -1,
 172231239,
 172151629,
 -1,
 -62907,
 172223514,
 6373,
 -62906,
 172269900,
 6374,
 -1,
 172301071,
 6375,
 172493386,
 172196664,
 -1,
 -62903,
 172485658,
 6376,
 -1,
 172532044,
 6377,
 172689997,
 172451776,
 -1,
 -62900,
 172639426,
 6371,
 -1,
 172694090,
 6372,
 -1,
 172632264,
 6327,
 172952152,
 172143586,
 -1,
 173017686,
 172944033,
 -1,
 173083218,
 172989121,
 6353,
 -1,
 173054657,
 6354,
 173214292,
 173041661,
 6351,
 -1,
 173172733,
 6352,
 -62891,
 173164521,
 6350,
 -1,
 173283914,
 6355,
 -62889,
 172959944,
 6341,
 -1,
 173412241,
 6368,
 173607520,
 172921504,
 -1,
 173673054,
 173599393,
 -1,
 173738588,
 173644481,
 6346,
 -1,
 173710017,
 6348,
 173932543,
 173697021,
 6342,
 -1,
 173828093,
 6344,
 -62881,
 173648276,
 6331,
 -1,
 173942984,
 6332,
 174131818,
 173551889,
 -1,
 174197350,
 174086227,
 -1,
 174262885,
 174189217,
 -1,
 -62876,
 174251195,
 6381,
 -1,
 174266954,
 6384,
 -1,
 174201615,
 6383,
 174525033,
 174144893,
 -1,
 -62872,
 174510381,
 6389,
 -1,
 174540053,
 6382,
 -1,
 174487644,
 6386,
 174787182,
 174107088,
 -1,
 -62868,
 174780880,
 6326,
 -62867,
 174827924,
 6324,
 -1,
 174860488,
 6325,
 175049331,
 174729479,
 -1,
 175114866,
 174999252,
 -1,
 -62863,
 175092706,
 6388,
 -1,
 175143995,
 6387,
 -1,
 175078618,
 5759,
 175377014,
 175043382,
 -1,
 -62859,
 175352212,
 6339,
 -1,
 175384776,
 6340,
 175573625,
 175339616,
 -1,
 -62856,
 175565805,
 6329,
 -1,
 175581384,
 6328,
 175770236,
 175526809,
 -1,
 -62853,
 175753788,
 6366,
 -1,
 175813854,
 6367,
 175966847,
 175708746,
 -1,
 -62850,
 175960886,
 6321,
 -1,
 175974600,
 6322,
 -62848,
 175934468,
 6330,
 -62847,
 176127674,
 6333,
 -62846,
 176187365,
 5120,
 -1,
 176244388,
 6364,
 176425606,
 169030098,
 983097,
 -62843,
 176389779,
 128473,
 -1,
 176423371,
 983170,
 176622217,
 176372565,
 -1,
 -62840,
 176616246,
 127852,
 -1,
 176652092,
 128367,
 -62838,
 176593937,
 128758,
 -1,
 176788735,
 129387,
 176949963,
 168997858,
 -1,
 177015487,
 176908497,
 -1,
 177080979,
 177003707,
 66226,
 177209343,
 177069243,
 66239,
 177274879,
 177134779,
 66212,
 -62831,
 177200315,
 66235,
 -62830,
 177214544,
 66256,
 -1,
 177279787,
 66248,
 177474201,
 177062356,
 66224,
 177539734,
 177459190,
 66242,
 -1,
 177476395,
 66243,
 177670808,
 177495484,
 66222,
 -1,
 177607467,
 66223,
 -1,
 177652180,
 66232,
 177867422,
 177441100,
 66218,
 177995775,
 177809671,
 66250,
 -62820,
 177870190,
 66253,
 -62819,
 177935440,
 66252,
 -1,
 178000683,
 66251,
 178195106,
 177836704,
 66229,
 -62816,
 178164384,
 66227,
 -62815,
 178214995,
 66244,
 -1,
 178273109,
 66238,
 178457253,
 178180086,
 66221,
 178585599,
 178442230,
 66247,
 -1,
 178459435,
 66230,
 178653864,
 178420795,
 66211,
 178782207,
 178600789,
 66214,
 -1,
 178656043,
 66254,
 178850474,
 178631650,
 66213,
 -1,
 178828258,
 66249,
 178981548,
 178825680,
 66231,
 -1,
 178918187,
 66209,
 179112622,
 178944096,
 66236,
 -1,
 179049259,
 66237,
 179243696,
 179070973,
 66233,
 -1,
 179202045,
 66245,
 179374770,
 179198035,
 66240,
 -1,
 179311403,
 66241,
 179505844,
 179324098,
 66234,
 -1,
 179442475,
 66255,
 179636918,
 179452757,
 66210,
 -1,
 179573547,
 66220,
 179767993,
 179580889,
 -1,
 -62792,
 179705195,
 66246,
 -1,
 179770139,
 66225,
 179964603,
 179706442,
 66208,
 -1,
 179901227,
 66215,
 -62788,
 179958320,
 66228,
 -62787,
 180072974,
 66216,
 -62786,
 180132545,
 66219,
 -1,
 180168967,
 66217,
 180357827,
 176962391,
 -1,
 180423362,
 180317667,
 128199,
 -1,
 180355697,
 128450,
 -1,
 180376443,
 128451,
 180619974,
 180335586,
 -1,
 -62779,
 180593846,
 129365,
 -1,
 180643982,
 983073,
 180816585,
 180595152,
 -1,
 -62776,
 180767824,
 129690,
 -1,
 180816331,
 127887,
 -62774,
 180790978,
 127904,
 -1,
 180947307,
 9936,
 181144343,
 176938680,
 -1,
 181209878,
 181109410,
 -1,
 181275353,
 181153704,
 -1,
 181340883,
 181231036,
 -1,
 181406417,
 181279306,
 66873,
 -1,
 181391350,
 66902,
 -62766,
 181381524,
 66889,
 -1,
 181495805,
 66890,
 181668566,
 181334970,
 -1,
 -62763,
 181662518,
 66891,
 -1,
 181725857,
 66911,
 181927935,
 181606986,
 -1,
 -62760,
 181859739,
 66912,
 -1,
 181908450,
 66882,
 182061791,
 181256660,
 -1,
 182127326,
 182017468,
 -1,
 182192861,
 182065738,
 66877,
 -1,
 182155360,
 66896,
 -1,
 182167956,
 66909,
 -1,
 182079972,
 66906,
 182455013,
 182008661,
 -1,
 182520547,
 182449733,
 -1,
 -62750,
 182514752,
 66895,
 -1,
 182528200,
 66901,
 -62748,
 182514701,
 66881,
 -1,
 182658823,
 66867,
 182848234,
 182449733,
 -1,
 182913769,
 182803900,
 -1,
 -62744,
 182873194,
 66871,
 -1,
 182917706,
 66875,
 -1,
 182854946,
 66869,
 183175918,
 182833142,
 -1,
 -62740,
 183170112,
 66899,
 -62739,
 183203488,
 66908,
 -1,
 183248485,
 66872,
 183438066,
 183134205,
 -1,
 -62736,
 183431125,
 66910,
 -62735,
 183481888,
 66876,
 -1,
 183540369,
 66879,
 183700213,
 183431990,
 -1,
 -62732,
 183675200,
 66874,
 -1,
 183707876,
 66913,
 183896824,
 183677485,
 -1,
 -62729,
 183890742,
 66887,
 -1,
 183940066,
 66893,
 184093435,
 183871952,
 -1,
 -62726,
 184055456,
 66914,
 -1,
 184109793,
 66903,
 184290046,
 184056891,
 -1,
 -62723,
 184284452,
 66885,
 -1,
 184295717,
 66878,
 184486657,
 184252512,
 -1,
 -62720,
 184448669,
 66915,
 -1,
 184493133,
 66884,
 184683268,
 184448833,
 -1,
 -62717,
 184641051,
 66883,
 -1,
 184690943,
 66897,
 184879879,
 184637523,
 -1,
 -62714,
 184839377,
 66866,
 -1,
 184902213,
 66904,
 185076490,
 184829122,
 -1,
 -62711,
 185071003,
 66870,
 -1,
 185084167,
 66868,
 185273101,
 185014858,
 -1,
 -62708,
 185246529,
 66888,
 -1,
 185305207,
 66864,
 -62706,
 185266859,
 66880,
 -62705,
 185460908,
 66907,
 -62704,
 185513394,
 66905,
 -62703,
 185572990,
 66898,
 -62702,
 185637030,
 66894,
 -62701,
 185699153,
 66892,
 -62700,
 185754186,
 66886,
 -62699,
 185815687,
 66900,
 -1,
 185871166,
 66865,
 -1,
 181155067,
 66927,
 186125084,
 181129206,
 128008,
 186253311,
 186057421,
 128049,
 186318847,
 186125266,
 -1,
 -62693,
 186249743,
 128572,
 -1,
 186307073,
 128569,
 186452768,
 186091852,
 -1,
 186518303,
 186404219,
 128247,
 -1,
 186453293,
 128248,
 -1,
 186494351,
 127957,
 186714915,
 186416187,
 -1,
 -62686,
 186678333,
 129305,
 -1,
 186731415,
 128197,
 -62684,
 186699142,
 9963,
 -62683,
 186887598,
 11839,
 -1,
 186923629,
 127797,
 187108391,
 168948534,
 -1,
 187173858,
 187088142,
 -1,
 187239306,
 187156973,
 -1,
 187304757,
 187224054,
 -1,
 187370286,
 187244574,
 -1,
 -62676,
 187364403,
 7303,
 -62675,
 187421143,
 7300,
 -1,
 187457576,
 7302,
 187632433,
 187351508,
 -1,
 -62672,
 187624474,
 42639,
 -1,
 187679740,
 42641,
 -62670,
 187624474,
 42637,
 -62669,
 187787029,
 7301,
 -62668,
 187844021,
 42635,
 -1,
 187904722,
 42643,
 188091202,
 187251541,
 -1,
 188156732,
 188085829,
 -1,
 188222266,
 188151365,
 -1,
 -62663,
 188178559,
 1323,
 -1,
 188236994,
 42633,
 -62661,
 188214298,
 42627,
 -1,
 188369546,
 42563,
 188549951,
 188130715,
 -1,
 -62658,
 188521153,
 42649,
 -1,
 188584164,
 42605,
 -62656,
 188541978,
 42625,
 -62655,
 188708794,
 42569,
 -1,
 188756690,
 1325,
 188943178,
 188068834,
 -1,
 189008712,
 188895349,
 -1,
 -62651,
 189003534,
 1297,
 -62650,
 189068853,
 42581,
 -62649,
 189127211,
 42593,
 -1,
 189154489,
 42565,
 -62647,
 188982798,
 7296,
 -1,
 189291982,
 1303,
 189467475,
 188924372,
 -1,
 189533008,
 189439055,
 -1,
 189598543,
 189482178,
 -1,
 -62642,
 189565260,
 42599,
 -1,
 189627451,
 42597,
 -1,
 189545729,
 42595,
 189923327,
 189488572,
 -1,
 -62638,
 189852698,
 42647,
 -1,
 189881809,
 1319,
 190057307,
 189416642,
 -1,
 190122840,
 190020709,
 -1,
 -62634,
 190090863,
 1313,
 -62633,
 190145668,
 1299,
 -1,
 190201306,
 1327,
 190447615,
 190091964,
 -1,
 -62630,
 190353007,
 1315,
 -1,
 190414992,
 1321,
 190581601,
 190018274,
 -1,
 190647136,
 190540421,
 -1,
 -62626,
 190641203,
 42579,
 -62625,
 190658020,
 42589,
 -1,
 190716490,
 42583,
 -1,
 190585418,
 42567,
 190974821,
 190575414,
 -1,
 -62621,
 190943904,
 42591,
 -62620,
 190991922,
 42577,
 -1,
 191044854,
 1305,
 191236970,
 190930364,
 -1,
 191302505,
 191175373,
 -1,
 -62616,
 191286824,
 1279,
 -1,
 191325316,
 1277,
 -1,
 191294490,
 42645,
 191564654,
 191180712,
 -1,
 -62612,
 191545317,
 42651,
 -62611,
 191596212,
 42585,
 -1,
 191640274,
 42631,
 191826802,
 191506695,
 -1,
 -62608,
 191807291,
 42573,
 -62607,
 191857222,
 42587,
 -1,
 191918294,
 42603,
 192088949,
 191821381,
 -1,
 -62604,
 192047062,
 42629,
 -1,
 192105165,
 42561,
 192285560,
 192080545,
 -1,
 -62601,
 192244193,
 7299,
 -1,
 192300226,
 1309,
 192482171,
 192260560,
 -1,
 -62598,
 192431511,
 1317,
 -1,
 192487505,
 1231,
 192678782,
 192451232,
 -1,
 -62595,
 192630730,
 42575,
 -1,
 192685517,
 7298,
 192875393,
 192647391,
 -1,
 -62592,
 192830615,
 42571,
 -1,
 192887426,
 42601,
 193072004,
 192838715,
 -1,
 -62589,
 193044608,
 7297,
 -1,
 193093070,
 1301,
 193268615,
 193026789,
 -1,
 -62586,
 193252919,
 1275,
 -1,
 193281498,
 1271,
 -62584,
 193257575,
 7304,
 -62583,
 193442349,
 1307,
 -1,
 193470421,
 1311,
 193661917,
 187183322,
 -1,
 193727384,
 193608533,
 -1,
 193792914,
 193721925,
 -1,
 193858448,
 193787461,
 -1,
 -62577,
 193814655,
 1322,
 -1,
 193873090,
 42632,
 -62575,
 193850394,
 42626,
 -1,
 194005642,
 42562,
 194186133,
 193766811,
 -1,
 -62572,
 194157249,
 42648,
 -1,
 194220260,
 42604,
 -62570,
 194178074,
 42624,
 -62569,
 194344890,
 42568,
 -1,
 194392786,
 1324,
 194579359,
 193712118,
 -1,
 194644892,
 194560468,
 -1,
 -62565,
 194636826,
 42638,
 -1,
 194692092,
 42640,
 -62563,
 194636826,
 42636,
 -62562,
 194790837,
 42634,
 -1,
 194851538,
 42642,
 195038120,
 194560468,
 -1,
 195103653,
 195009615,
 -1,
 195169188,
 195052738,
 -1,
 -62557,
 195135820,
 42598,
 -1,
 195198011,
 42596,
 -1,
 195116289,
 42594,
 195493887,
 195059132,
 -1,
 -62553,
 195423258,
 42646,
 -1,
 195452369,
 1318,
 195627951,
 195015650,
 -1,
 195693486,
 195580021,
 -1,
 -62549,
 195688206,
 1296,
 -62548,
 195753525,
 42580,
 -62547,
 195811883,
 42592,
 -1,
 195839161,
 42564,
 -1,
 195648974,
 1302,
 196086711,
 195577026,
 -1,
 196152244,
 196050021,
 -1,
 -62542,
 196120175,
 1312,
 -62541,
 196174980,
 1298,
 -1,
 196230618,
 1326,
 196476927,
 196121276,
 -1,
 -62538,
 196382319,
 1314,
 -1,
 196444304,
 1320,
 196611005,
 196047586,
 -1,
 196676540,
 196569733,
 -1,
 -62534,
 196670515,
 42578,
 -62533,
 196687332,
 42588,
 -1,
 196745802,
 42582,
 -1,
 196614730,
 42566,
 197004225,
 196604726,
 -1,
 -62529,
 196973216,
 42590,
 -62528,
 197021234,
 42576,
 -1,
 197074166,
 1304,
 197266374,
 196959676,
 -1,
 197331909,
 197204685,
 -1,
 -62524,
 197316136,
 1278,
 -1,
 197354628,
 1276,
 -1,
 197323802,
 42644,
 197594058,
 197210024,
 -1,
 -62520,
 197574629,
 42650,
 -62519,
 197625524,
 42584,
 -1,
 197669586,
 42630,
 197856206,
 197536007,
 -1,
 -62516,
 197836603,
 42572,
 -62515,
 197886534,
 42586,
 -1,
 197947606,
 42602,
 198118353,
 197850693,
 -1,
 -62512,
 198076374,
 42628,
 -1,
 198134477,
 42560,
 198314964,
 198086879,
 -1,
 -62509,
 198270103,
 42570,
 -1,
 198326914,
 42600,
 198511575,
 198269669,
 -1,
 -62506,
 198495799,
 1274,
 -1,
 198524378,
 1270,
 -62504,
 198503450,
 1308,
 -62503,
 198685229,
 1306,
 -62502,
 198749173,
 1316,
 -62501,
 198809030,
 42574,
 -62500,
 198869819,
 1300,
 -1,
 198909909,
 1310,
 199101408,
 193626786,
 -1,
 -62497,
 199084468,
 7467,
 -1,
 199135727,
 42606,
 -62495,
 199076816,
 42623,
 -1,
 199260606,
 42622,
 199429158,
 187150530,
 -1,
 199494633,
 199413750,
 -1,
 -62491,
 199482555,
 67633,
 -62490,
 199531201,
 67632,
 -62489,
 199583741,
 67631,
 -62488,
 199640258,
 67630,
 -1,
 199694922,
 67629,
 199887855,
 199475668,
 -1,
 -62485,
 199875771,
 67628,
 -62484,
 199924417,
 67627,
 -62483,
 199976957,
 67626,
 -62482,
 200033474,
 67625,
 -1,
 200088138,
 67624,
 200281077,
 199865314,
 -1,
 -62479,
 200268987,
 67623,
 -62478,
 200317633,
 67622,
 -62477,
 200370173,
 67621,
 -62476,
 200426690,
 67620,
 -1,
 200481354,
 67619,
 200674299,
 200255952,
 -1,
 -62473,
 200662203,
 67618,
 -62472,
 200710849,
 67617,
 -62471,
 200763389,
 67616,
 -62470,
 200819906,
 67615,
 -1,
 200874570,
 67614,
 201067521,
 200643232,
 -1,
 -62467,
 201055419,
 67613,
 -62466,
 201104065,
 67612,
 -62465,
 201156605,
 67611,
 -62464,
 201213122,
 67610,
 -1,
 201267786,
 67609,
 201460743,
 201034060,
 -1,
 -62461,
 201448635,
 67608,
 -62460,
 201497281,
 67607,
 -62459,
 201549821,
 67606,
 -62458,
 201606338,
 67605,
 -1,
 201661002,
 67604,
 201853965,
 201423931,
 -1,
 -62455,
 201841851,
 67603,
 -62454,
 201890497,
 67602,
 -62453,
 201943037,
 67601,
 -62452,
 201999554,
 67600,
 -1,
 202054218,
 67599,
 202247187,
 201816160,
 -1,
 -62449,
 202235067,
 67598,
 -62448,
 202283713,
 67597,
 -62447,
 202336253,
 67596,
 -62446,
 202392770,
 67595,
 -1,
 202447434,
 67594,
 202640408,
 202238625,
 -1,
 -62443,
 202611393,
 67637,
 -62442,
 202663933,
 67636,
 -62441,
 202720450,
 67635,
 -1,
 202775114,
 67634,
 202968091,
 202634821,
 -1,
 -62438,
 202939073,
 67647,
 -1,
 202971722,
 67644,
 203164702,
 202961456,
 -1,
 -62435,
 203113666,
 67640,
 -1,
 203168330,
 67639,
 203361313,
 203126593,
 -1,
 -62432,
 203332289,
 67592,
 -1,
 203364938,
 67589,
 -62430,
 203349179,
 67588,
 -62429,
 203528897,
 67587,
 -62428,
 203581437,
 67586,
 -62427,
 203637954,
 67585,
 -1,
 203692618,
 67584,
 -1,
 199374262,
 127744,
 203951302,
 187070442,
 -1,
 204016801,
 203896563,
 -1,
 204082234,
 203960232,
 -1,
 -62421,
 204034547,
 64207,
 -62420,
 204096706,
 64206,
 -62419,
 204159829,
 64205,
 -62418,
 204222376,
 64204,
 -62417,
 204286215,
 64203,
 -62416,
 204347978,
 64202,
 -62415,
 204413336,
 64201,
 -62414,
 204478695,
 64200,
 -62413,
 204544007,
 64199,
 -62412,
 204609335,
 64198,
 -62411,
 204674626,
 64197,
 -62410,
 204739950,
 64196,
 -62409,
 204805200,
 64195,
 -62408,
 204870443,
 64194,
 -62407,
 204935675,
 64193,
 -1,
 205000939,
 64192,
 205196363,
 204024071,
 -1,
 -62404,
 205148659,
 64191,
 -62403,
 205210818,
 64190,
 -62402,
 205273941,
 64189,
 -62401,
 205336488,
 64188,
 -62400,
 205400327,
 64187,
 -62399,
 205462090,
 64186,
 -62398,
 205527448,
 64185,
 -62397,
 205592807,
 64184,
 -62396,
 205658119,
 64183,
 -62395,
 205723447,
 64182,
 -62394,
 205788738,
 64181,
 -62393,
 205854062,
 64180,
 -62392,
 205919312,
 64179,
 -62391,
 205984555,
 64178,
 -62390,
 206049787,
 64177,
 -1,
 206115051,
 64176,
 206310492,
 205134410,
 -1,
 -62387,
 206262771,
 64175,
 -62386,
 206324930,
 64174,
 -62385,
 206388053,
 64173,
 -62384,
 206450600,
 64172,
 -62383,
 206514439,
 64171,
 -62382,
 206576202,
 64170,
 -62381,
 206641560,
 64169,
 -62380,
 206706919,
 64168,
 -62379,
 206772231,
 64167,
 -62378,
 206837559,
 64166,
 -62377,
 206902850,
 64165,
 -62376,
 206968174,
 64164,
 -62375,
 207033424,
 64163,
 -62374,
 207098667,
 64162,
 -62373,
 207163899,
 64161,
 -1,
 207229163,
 64160,
 207424621,
 206248344,
 -1,
 -62370,
 207376883,
 64159,
 -62369,
 207439042,
 64158,
 -62368,
 207502165,
 64157,
 -62367,
 207564712,
 64156,
 -62366,
 207628551,
 64155,
 -62365,
 207690314,
 64154,
 -62364,
 207755672,
 64153,
 -62363,
 207821031,
 64152,
 -62362,
 207886343,
 64151,
 -62361,
 207951671,
 64150,
 -62360,
 208016962,
 64149,
 -62359,
 208082286,
 64148,
 -62358,
 208147536,
 64147,
 -62357,
 208212779,
 64146,
 -62356,
 208278011,
 64145,
 -1,
 208343275,
 64144,
 208538750,
 207362279,
 -1,
 -62353,
 208490995,
 64143,
 -62352,
 208553154,
 64142,
 -62351,
 208616277,
 64141,
 -62350,
 208678824,
 64140,
 -62349,
 208742663,
 64139,
 -62348,
 208804426,
 64138,
 -62347,
 208869784,
 64137,
 -62346,
 208935143,
 64136,
 -62345,
 209000455,
 64135,
 -62344,
 209065783,
 64134,
 -62343,
 209131074,
 64133,
 -62342,
 209196398,
 64132,
 -62341,
 209261648,
 64131,
 -62340,
 209326891,
 64130,
 -62339,
 209392123,
 64129,
 -1,
 209457387,
 64128,
 209652879,
 208476167,
 -1,
 -62336,
 209605107,
 64127,
 -62335,
 209667266,
 64126,
 -62334,
 209730389,
 64125,
 -62333,
 209792936,
 64124,
 -62332,
 209856775,
 64123,
 -62331,
 209918538,
 64122,
 -62330,
 209983896,
 64121,
 -62329,
 210049255,
 64120,
 -62328,
 210114567,
 64119,
 -62327,
 210179895,
 64118,
 -62326,
 210245186,
 64117,
 -62325,
 210310510,
 64116,
 -62324,
 210375760,
 64115,
 -62323,
 210441003,
 64114,
 -62322,
 210506235,
 64113,
 -1,
 210571499,
 64112,
 210767002,
 209599317,
 -1,
 -62319,
 210704792,
 64217,
 -62318,
 210770151,
 64216,
 -62317,
 210835463,
 64215,
 -62316,
 210900791,
 64214,
 -62315,
 210966082,
 64213,
 -62314,
 211031406,
 64212,
 -62313,
 211096656,
 64211,
 -62312,
 211161899,
 64210,
 -62311,
 211227131,
 64209,
 -1,
 211292395,
 64208,
 211487902,
 210704183,
 -1,
 -62308,
 211434325,
 64109,
 -62307,
 211496872,
 64108,
 -1,
 211560711,
 64107,
 211812351,
 211424043,
 -1,
 -62304,
 211702259,
 64047,
 -1,
 211764418,
 64046,
 212008959,
 204000815,
 -1,
 212012208,
 211901884,
 12752,
 212077740,
 212006469,
 12757,
 212143272,
 212072005,
 12741,
 212208807,
 212137541,
 12750,
 -1,
 212162643,
 12769,
 -1,
 212183504,
 12747,
 212405418,
 212134561,
 12749,
 -1,
 212359251,
 12744,
 -62293,
 212389878,
 12746,
 -1,
 212490323,
 12742,
 212667566,
 212052432,
 12743,
 -1,
 212659428,
 12748,
 -62289,
 212661032,
 12768,
 -1,
 212752467,
 12758,
 212929722,
 211993044,
 12753,
 212995252,
 212923973,
 12759,
 -62285,
 212989509,
 12766,
 -1,
 213052644,
 12745,
 213191863,
 212986529,
 12740,
 -62282,
 213186117,
 12760,
 -1,
 213211219,
 12767,
 -62280,
 213176310,
 12761,
 -62279,
 213363152,
 12755,
 -1,
 213407827,
 12762,
 213585086,
 212904400,
 12754,
 -62276,
 213579333,
 12764,
 -62275,
 213604435,
 12770,
 -1,
 213662549,
 12763,
 213847232,
 213569526,
 12736,
 -1,
 213815968,
 12765,
 -62271,
 213840560,
 12738,
 -62270,
 213970148,
 12737,
 -62269,
 214020622,
 12771,
 -62268,
 214078112,
 12751,
 -62267,
 214121301,
 12756,
 -1,
 214183828,
 12739,
 214371602,
 203914299,
 -1,
 214437127,
 214342337,
 -1,
 214502650,
 214381856,
 -1,
 214568179,
 214434515,
 -1,
 214633688,
 214552566,
 -1,
 214699218,
 214624929,
 -1,
 214764751,
 214670017,
 -1,
 -62258,
 214700250,
 128349,
 -1,
 214762790,
 128337,
 215023615,
 214715031,
 -1,
 -62255,
 214896858,
 128359,
 -1,
 214959398,
 128347,
 215157973,
 214656543,
 -1,
 -62252,
 215093466,
 128350,
 -1,
 215156006,
 128338,
 215416831,
 215108321,
 -1,
 -62249,
 215290074,
 128357,
 -1,
 215352614,
 128345,
 215551199,
 214614484,
 -1,
 215616732,
 215512740,
 -1,
 -62245,
 215552218,
 128353,
 -1,
 215614758,
 128341,
 215875583,
 215568356,
 -1,
 -62242,
 215748826,
 128354,
 -1,
 215811366,
 128342,
 216009958,
 215503347,
 -1,
 216075491,
 215983640,
 -1,
 -62238,
 216010970,
 128351,
 -1,
 216073510,
 128339,
 216334335,
 216036842,
 -1,
 -62235,
 216207578,
 128352,
 -1,
 216270118,
 128340,
 216468717,
 215958722,
 -1,
 216534250,
 216433401,
 -1,
 -62231,
 216469722,
 128358,
 -1,
 216532262,
 128346,
 216793087,
 216492892,
 -1,
 -62228,
 216666330,
 128355,
 -1,
 216728870,
 128343,
 216927472,
 216440601,
 -1,
 -62225,
 216862938,
 128348,
 -1,
 216925478,
 128336,
 217186303,
 216897262,
 -1,
 -62222,
 217059546,
 128356,
 -1,
 217122086,
 128344,
 217382911,
 214560325,
 -1,
 217386232,
 217299623,
 -1,
 217451767,
 217377608,
 128257,
 -1,
 217385980,
 128258,
 -1,
 217383027,
 128472,
 -62215,
 217372940,
 11118,
 -1,
 217596769,
 128259,
 217779457,
 214484028,
 -1,
 217844990,
 217745966,
 -1,
 -62211,
 217822441,
 128235,
 -1,
 217876514,
 128234,
 -62209,
 217833516,
 127746,
 -62208,
 218007061,
 128272,
 -1,
 218050006,
 128213,
 218238214,
 217767641,
 -1,
 -62205,
 218224560,
 127786,
 -62204,
 218286799,
 127784,
 -62203,
 218346713,
 127783,
 -1,
 218399809,
 127785,
 -1,
 218230757,
 129313,
 218631437,
 214374986,
 -1,
 218696971,
 218607602,
 -1,
 -62198,
 218656548,
 128079,
 -1,
 218713393,
 127916,
 -62196,
 218680459,
 127963,
 -1,
 218861980,
 128385,
 219086847,
 218589181,
 -1,
 219090193,
 218994594,
 -1,
 -62192,
 219044866,
 129346,
 -1,
 219097793,
 127867,
 -1,
 219065304,
 128203,
 219352397,
 214329341,
 -1,
 219417930,
 219330083,
 -1,
 219483465,
 219381726,
 -1,
 219548963,
 219441149,
 -1,
 219614495,
 219495841,
 -1,
 219680026,
 219576416,
 -1,
 -62183,
 219653456,
 12871,
 -1,
 219704791,
 12869,
 219876637,
 219617866,
 -1,
 -62180,
 219825309,
 127568,
 -1,
 219885962,
 127569,
 -62178,
 219857856,
 12870,
 -1,
 220050302,
 12868,
 220204322,
 219599163,
 -1,
 -62175,
 220181474,
 127276,
 -1,
 220213160,
 127275,
 -1,
 220173790,
 128712,
 220466479,
 219519479,
 -1,
 220532008,
 220450806,
 -1,
 -62170,
 220523607,
 12873,
 -62169,
 220554157,
 12874,
 -1,
 220613393,
 12872,
 220794155,
 220512724,
 -1,
 -62166,
 220755697,
 12877,
 -1,
 220811336,
 12878,
 220990766,
 220746227,
 -1,
 -62163,
 220963954,
 12875,
 -1,
 221014693,
 12876,
 -1,
 220940806,
 12879,
 221252923,
 220409768,
 -1,
 221318456,
 221233105,
 -1,
 221383991,
 221249536,
 -1,
 221449526,
 221337104,
 129282,
 221577215,
 221383634,
 -1,
 -62155,
 221502418,
 129281,
 -1,
 221533849,
 129280,
 -1,
 221425543,
 128320,
 -1,
 221343592,
 9938,
 -62151,
 221264725,
 127277,
 -62150,
 221786024,
 127341,
 -1,
 221842998,
 127342,
 222039358,
 221215622,
 -1,
 -62147,
 222001234,
 12925,
 -1,
 222048903,
 12924,
 222235969,
 221994428,
 -1,
 -62144,
 222224416,
 127343,
 -1,
 222241567,
 12926,
 -62142,
 222230381,
 127245,
 -62141,
 222425648,
 11198,
 -62140,
 222491181,
 127278,
 -62139,
 222550183,
 128981,
 -62138,
 222612420,
 128983,
 -62137,
 222642122,
 127247,
 -62136,
 222703055,
 11199,
 -1,
 222765972,
 127246,
 -1,
 219473059,
 127914,
 223022412,
 219405486,
 127961,
 -1,
 222953773,
 127750,
 -1,
 222991722,
 127910,
 223219051,
 219329506,
 983074,
 223284576,
 223189697,
 -1,
 223350109,
 223267867,
 -1,
 223415640,
 223281152,
 -1,
 223481175,
 223390160,
 -1,
 223546708,
 223452788,
 128322,
 -1,
 223481145,
 128321,
 223739903,
 223487989,
 -1,
 -62122,
 223656676,
 11856,
 -1,
 223707179,
 11857,
 -1,
 223447906,
 10060,
 223939932,
 223364895,
 -1,
 -62118,
 223924101,
 9876,
 -62117,
 223974709,
 127370,
 -1,
 224023811,
 127884,
 -1,
 223899496,
 9932,
 -62114,
 223342549,
 128081,
 -62113,
 224228558,
 129360,
 -1,
 224278117,
 128010,
 224464229,
 223277878,
 -1,
 224529764,
 224423620,
 -1,
 -62109,
 224481867,
 128546,
 -1,
 224538927,
 128575,
 -1,
 224513249,
 128302,
 224791911,
 224422281,
 129431,
 -1,
 224723269,
 127951,
 224922986,
 224740546,
 -1,
 -62103,
 224904117,
 127769,
 -1,
 224935777,
 128179,
 -1,
 224860997,
 129408,
 225185135,
 223167682,
 -1,
 -62099,
 225163418,
 9907,
 -62098,
 225216706,
 128328,
 -1,
 225263200,
 8373,
 -62096,
 225167206,
 983187,
 -62095,
 225401847,
 983200,
 -1,
 225456710,
 983171,
 225646120,
 53238,
 -1,
 225711123,
 225581642,
 -1,
 225775824,
 225677984,
 -1,
 225841359,
 225728595,
 -1,
 225906894,
 225830170,
 -1,
 225972429,
 225851161,
 -1,
 226037223,
 225908535,
 -1,
 226102660,
 225974680,
 -1,
 -62085,
 226040216,
 101050,
 -62084,
 226105575,
 101049,
 -62083,
 226170887,
 101048,
 -62082,
 226236215,
 101047,
 -62081,
 226301506,
 101046,
 -62080,
 226366830,
 101045,
 -62079,
 226432080,
 101044,
 -62078,
 226497323,
 101043,
 -62077,
 226562555,
 101042,
 -1,
 226627819,
 101041,
 226823567,
 226040039,
 -1,
 -62074,
 226761112,
 101040,
 -62073,
 226826471,
 101039,
 -62072,
 226891783,
 101038,
 -62071,
 226957111,
 101037,
 -62070,
 227022402,
 101036,
 -62069,
 227087726,
 101035,
 -62068,
 227152976,
 101034,
 -62067,
 227218219,
 101033,
 -62066,
 227283451,
 101032,
 -1,
 227348715,
 101031,
 227544474,
 226760711,
 -1,
 -62063,
 227482008,
 101030,
 -62062,
 227547367,
 101029,
 -62061,
 227612679,
 101028,
 -62060,
 227678007,
 101027,
 -62059,
 227743298,
 101026,
 -62058,
 227808622,
 101025,
 -62057,
 227873872,
 101024,
 -62056,
 227939115,
 101023,
 -62055,
 228004347,
 101022,
 -1,
 228069611,
 101021,
 228265381,
 227481399,
 -1,
 -62052,
 228202904,
 101020,
 -62051,
 228268263,
 101019,
 -62050,
 228333575,
 101018,
 -62049,
 228398903,
 101017,
 -62048,
 228464194,
 101016,
 -62047,
 228529518,
 101015,
 -62046,
 228594768,
 101014,
 -62045,
 228660011,
 101013,
 -62044,
 228725243,
 101012,
 -1,
 228790507,
 101011,
 228986288,
 228202050,
 -1,
 -62041,
 228923800,
 101010,
 -62040,
 228989159,
 101009,
 -62039,
 229054471,
 101008,
 -62038,
 229119799,
 101007,
 -62037,
 229185090,
 101006,
 -62036,
 229250414,
 101005,
 -62035,
 229315664,
 101004,
 -62034,
 229380907,
 101003,
 -62033,
 229446139,
 101002,
 -1,
 229511403,
 101001,
 229707195,
 228922734,
 -1,
 -62030,
 229644696,
 101000,
 -62029,
 229710055,
 100999,
 -62028,
 229775367,
 100998,
 -62027,
 229840695,
 100997,
 -62026,
 229905986,
 100996,
 -62025,
 229971310,
 100995,
 -62024,
 230036560,
 100994,
 -62023,
 230101803,
 100993,
 -62022,
 230167035,
 100992,
 -1,
 230232299,
 100991,
 230428102,
 229643344,
 -1,
 -62019,
 230365592,
 100990,
 -62018,
 230430951,
 100989,
 -62017,
 230496263,
 100988,
 -62016,
 230561591,
 100987,
 -62015,
 230626882,
 100986,
 -62014,
 230692206,
 100985,
 -62013,
 230757456,
 100984,
 -62012,
 230822699,
 100983,
 -62011,
 230887931,
 100982,
 -1,
 230953195,
 100981,
 231149009,
 230363947,
 -1,
 -62008,
 231086488,
 100980,
 -62007,
 231151847,
 100979,
 -62006,
 231217159,
 100978,
 -62005,
 231282487,
 100977,
 -62004,
 231347778,
 100976,
 -62003,
 231413102,
 100975,
 -62002,
 231478352,
 100974,
 -62001,
 231543595,
 100973,
 -62000,
 231608827,
 100972,
 -1,
 231674091,
 100971,
 231869916,
 231084539,
 -1,
 -61997,
 231807384,
 100970,
 -61996,
 231872743,
 100969,
 -61995,
 231938055,
 100968,
 -61994,
 232003383,
 100967,
 -61993,
 232068674,
 100966,
 -61992,
 232133998,
 100965,
 -61991,
 232199248,
 100964,
 -61990,
 232264491,
 100963,
 -61989,
 232329723,
 100962,
 -1,
 232394987,
 100961,
 232652799,
 231805163,
 -1,
 -61986,
 232528280,
 100960,
 -61985,
 232593639,
 100959,
 -61984,
 232658951,
 100958,
 -61983,
 232724279,
 100957,
 -61982,
 232789570,
 100956,
 -61981,
 232854894,
 100955,
 -61980,
 232920144,
 100954,
 -61979,
 232985387,
 100953,
 -61978,
 233050619,
 100952,
 -1,
 233115883,
 100951,
 233311830,
 225973826,
 -1,
 233377267,
 233249176,
 -1,
 -61974,
 233314712,
 100950,
 -61973,
 233380071,
 100949,
 -61972,
 233445383,
 100948,
 -61971,
 233510711,
 100947,
 -61970,
 233576002,
 100946,
 -61969,
 233641326,
 100945,
 -61968,
 233706576,
 100944,
 -61967,
 233771819,
 100943,
 -61966,
 233837051,
 100942,
 -1,
 233902315,
 100941,
 234098174,
 233314535,
 -1,
 -61963,
 234035608,
 100940,
 -61962,
 234100967,
 100939,
 -61961,
 234166279,
 100938,
 -61960,
 234231607,
 100937,
 -61959,
 234296898,
 100936,
 -61958,
 234362222,
 100935,
 -61957,
 234427472,
 100934,
 -61956,
 234492715,
 100933,
 -61955,
 234557947,
 100932,
 -1,
 234623211,
 100931,
 234819081,
 234035207,
 -1,
 -61952,
 234756504,
 100930,
 -61951,
 234821863,
 100929,
 -61950,
 234887175,
 100928,
 -61949,
 234952503,
 100927,
 -61948,
 235017794,
 100926,
 -61947,
 235083118,
 100925,
 -61946,
 235148368,
 100924,
 -61945,
 235213611,
 100923,
 -61944,
 235278843,
 100922,
 -1,
 235344107,
 100921,
 235539988,
 234755895,
 -1,
 -61941,
 235477400,
 100920,
 -61940,
 235542759,
 100919,
 -61939,
 235608071,
 100918,
 -61938,
 235673399,
 100917,
 -61937,
 235738690,
 100916,
 -61936,
 235804014,
 100915,
 -61935,
 235869264,
 100914,
 -61934,
 235934507,
 100913,
 -61933,
 235999739,
 100912,
 -1,
 236065003,
 100911,
 236260895,
 235476546,
 -1,
 -61930,
 236198296,
 100910,
 -61929,
 236263655,
 100909,
 -61928,
 236328967,
 100908,
 -61927,
 236394295,
 100907,
 -61926,
 236459586,
 100906,
 -61925,
 236524910,
 100905,
 -61924,
 236590160,
 100904,
 -61923,
 236655403,
 100903,
 -61922,
 236720635,
 100902,
 -1,
 236785899,
 100901,
 236981802,
 236197230,
 -1,
 -61919,
 236919192,
 100900,
 -61918,
 236984551,
 100899,
 -61917,
 237049863,
 100898,
 -61916,
 237115191,
 100897,
 -61915,
 237180482,
 100896,
 -61914,
 237245806,
 100895,
 -61913,
 237311056,
 100894,
 -61912,
 237376299,
 100893,
 -61911,
 237441531,
 100892,
 -1,
 237506795,
 100891,
 237702709,
 236917840,
 -1,
 -61908,
 237640088,
 100890,
 -61907,
 237705447,
 100889,
 -61906,
 237770759,
 100888,
 -61905,
 237836087,
 100887,
 -61904,
 237901378,
 100886,
 -61903,
 237966702,
 100885,
 -61902,
 238031952,
 100884,
 -61901,
 238097195,
 100883,
 -61900,
 238162427,
 100882,
 -1,
 238227691,
 100881,
 238423616,
 237638443,
 -1,
 -61897,
 238360984,
 100880,
 -61896,
 238426343,
 100879,
 -61895,
 238491655,
 100878,
 -61894,
 238556983,
 100877,
 -61893,
 238622274,
 100876,
 -61892,
 238687598,
 100875,
 -61891,
 238752848,
 100874,
 -61890,
 238818091,
 100873,
 -61889,
 238883323,
 100872,
 -1,
 238948587,
 100871,
 239144523,
 238359035,
 -1,
 -61886,
 239081880,
 100870,
 -61885,
 239147239,
 100869,
 -61884,
 239212551,
 100868,
 -61883,
 239277879,
 100867,
 -61882,
 239343170,
 100866,
 -61881,
 239408494,
 100865,
 -61880,
 239473744,
 100864,
 -61879,
 239538987,
 100863,
 -61878,
 239604219,
 100862,
 -1,
 239669483,
 100861,
 239927295,
 239079659,
 -1,
 -61875,
 239802776,
 100860,
 -61874,
 239868135,
 100859,
 -61873,
 239933447,
 100858,
 -61872,
 239998775,
 100857,
 -61871,
 240064066,
 100856,
 -61870,
 240129390,
 100855,
 -61869,
 240194640,
 100854,
 -61868,
 240259883,
 100853,
 -61867,
 240325115,
 100852,
 -1,
 240390379,
 100851,
 240586437,
 233248110,
 -1,
 240651874,
 240523672,
 -1,
 -61863,
 240589208,
 100850,
 -61862,
 240654567,
 100849,
 -61861,
 240719879,
 100848,
 -61860,
 240785207,
 100847,
 -61859,
 240850498,
 100846,
 -61858,
 240915822,
 100845,
 -61857,
 240981072,
 100844,
 -61856,
 241046315,
 100843,
 -61855,
 241111547,
 100842,
 -1,
 241176811,
 100841,
 241372781,
 240589031,
 -1,
 -61852,
 241310104,
 100840,
 -61851,
 241375463,
 100839,
 -61850,
 241440775,
 100838,
 -61849,
 241506103,
 100837,
 -61848,
 241571394,
 100836,
 -61847,
 241636718,
 100835,
 -61846,
 241701968,
 100834,
 -61845,
 241767211,
 100833,
 -61844,
 241832443,
 100832,
 -1,
 241897707,
 100831,
 242093688,
 241309703,
 -1,
 -61841,
 242031000,
 100830,
 -61840,
 242096359,
 100829,
 -61839,
 242161671,
 100828,
 -61838,
 242226999,
 100827,
 -61837,
 242292290,
 100826,
 -61836,
 242357614,
 100825,
 -61835,
 242422864,
 100824,
 -61834,
 242488107,
 100823,
 -61833,
 242553339,
 100822,
 -1,
 242618603,
 100821,
 242814595,
 242030391,
 -1,
 -61830,
 242751896,
 100820,
 -61829,
 242817255,
 100819,
 -61828,
 242882567,
 100818,
 -61827,
 242947895,
 100817,
 -61826,
 243013186,
 100816,
 -61825,
 243078510,
 100815,
 -61824,
 243143760,
 100814,
 -61823,
 243209003,
 100813,
 -61822,
 243274235,
 100812,
 -1,
 243339499,
 100811,
 243535502,
 242751042,
 -1,
 -61819,
 243472792,
 100810,
 -61818,
 243538151,
 100809,
 -61817,
 243603463,
 100808,
 -61816,
 243668791,
 100807,
 -61815,
 243734082,
 100806,
 -61814,
 243799406,
 100805,
 -61813,
 243864656,
 100804,
 -61812,
 243929899,
 100803,
 -61811,
 243995131,
 100802,
 -1,
 244060395,
 100801,
 244256409,
 243471726,
 -1,
 -61808,
 244193688,
 100800,
 -61807,
 244259047,
 100799,
 -61806,
 244324359,
 100798,
 -61805,
 244389687,
 100797,
 -61804,
 244454978,
 100796,
 -61803,
 244520302,
 100795,
 -61802,
 244585552,
 100794,
 -61801,
 244650795,
 100793,
 -61800,
 244716027,
 100792,
 -1,
 244781291,
 100791,
 244977316,
 244192336,
 -1,
 -61797,
 244914584,
 100790,
 -61796,
 244979943,
 100789,
 -61795,
 245045255,
 100788,
 -61794,
 245110583,
 100787,
 -61793,
 245175874,
 100786,
 -61792,
 245241198,
 100785,
 -61791,
 245306448,
 100784,
 -61790,
 245371691,
 100783,
 -61789,
 245436923,
 100782,
 -1,
 245502187,
 100781,
 245698223,
 244912939,
 -1,
 -61786,
 245635480,
 100780,
 -61785,
 245700839,
 100779,
 -61784,
 245766151,
 100778,
 -61783,
 245831479,
 100777,
 -61782,
 245896770,
 100776,
 -61781,
 245962094,
 100775,
 -61780,
 246027344,
 100774,
 -61779,
 246092587,
 100773,
 -61778,
 246157819,
 100772,
 -1,
 246223083,
 100771,
 246419130,
 245633531,
 -1,
 -61775,
 246356376,
 100770,
 -61774,
 246421735,
 100769,
 -61773,
 246487047,
 100768,
 -61772,
 246552375,
 100767,
 -61771,
 246617666,
 100766,
 -61770,
 246682990,
 100765,
 -61769,
 246748240,
 100764,
 -61768,
 246813483,
 100763,
 -61767,
 246878715,
 100762,
 -1,
 246943979,
 100761,
 247201791,
 246354155,
 -1,
 -61764,
 247077272,
 100760,
 -61763,
 247142631,
 100759,
 -61762,
 247207943,
 100758,
 -61761,
 247273271,
 100757,
 -61760,
 247338562,
 100756,
 -61759,
 247403886,
 100755,
 -61758,
 247469136,
 100754,
 -61757,
 247534379,
 100753,
 -61756,
 247599611,
 100752,
 -1,
 247664875,
 100751,
 247861044,
 240522320,
 -1,
 247926481,
 247798168,
 -1,
 -61752,
 247863704,
 100750,
 -61751,
 247929063,
 100749,
 -61750,
 247994375,
 100748,
 -61749,
 248059703,
 100747,
 -61748,
 248124994,
 100746,
 -61747,
 248190318,
 100745,
 -61746,
 248255568,
 100744,
 -61745,
 248320811,
 100743,
 -61744,
 248386043,
 100742,
 -1,
 248451307,
 100741,
 248647388,
 247863527,
 -1,
 -61741,
 248584600,
 100740,
 -61740,
 248649959,
 100739,
 -61739,
 248715271,
 100738,
 -61738,
 248780599,
 100737,
 -61737,
 248845890,
 100736,
 -61736,
 248911214,
 100735,
 -61735,
 248976464,
 100734,
 -61734,
 249041707,
 100733,
 -61733,
 249106939,
 100732,
 -1,
 249172203,
 100731,
 249368295,
 248584199,
 -1,
 -61730,
 249305496,
 100730,
 -61729,
 249370855,
 100729,
 -61728,
 249436167,
 100728,
 -61727,
 249501495,
 100727,
 -61726,
 249566786,
 100726,
 -61725,
 249632110,
 100725,
 -61724,
 249697360,
 100724,
 -61723,
 249762603,
 100723,
 -61722,
 249827835,
 100722,
 -1,
 249893099,
 100721,
 250089202,
 249304887,
 -1,
 -61719,
 250026392,
 100720,
 -61718,
 250091751,
 100719,
 -61717,
 250157063,
 100718,
 -61716,
 250222391,
 100717,
 -61715,
 250287682,
 100716,
 -61714,
 250353006,
 100715,
 -61713,
 250418256,
 100714,
 -61712,
 250483499,
 100713,
 -61711,
 250548731,
 100712,
 -1,
 250613995,
 100711,
 250810109,
 250025538,
 -1,
 -61708,
 250747288,
 100710,
 -61707,
 250812647,
 100709,
 -61706,
 250877959,
 100708,
 -61705,
 250943287,
 100707,
 -61704,
 251008578,
 100706,
 -61703,
 251073902,
 100705,
 -61702,
 251139152,
 100704,
 -61701,
 251204395,
 100703,
 -61700,
 251269627,
 100702,
 -1,
 251334891,
 100701,
 251531016,
 250746222,
 -1,
 -61697,
 251468184,
 100700,
 -61696,
 251533543,
 100699,
 -61695,
 251598855,
 100698,
 -61694,
 251664183,
 100697,
 -61693,
 251729474,
 100696,
 -61692,
 251794798,
 100695,
 -61691,
 251860048,
 100694,
 -61690,
 251925291,
 100693,
 -61689,
 251990523,
 100692,
 -1,
 252055787,
 100691,
 252251923,
 251466832,
 -1,
 -61686,
 252189080,
 100690,
 -61685,
 252254439,
 100689,
 -61684,
 252319751,
 100688,
 -61683,
 252385079,
 100687,
 -61682,
 252450370,
 100686,
 -61681,
 252515694,
 100685,
 -61680,
 252580944,
 100684,
 -61679,
 252646187,
 100683,
 -61678,
 252711419,
 100682,
 -1,
 252776683,
 100681,
 252972830,
 252187435,
 -1,
 -61675,
 252909976,
 100680,
 -61674,
 252975335,
 100679,
 -61673,
 253040647,
 100678,
 -61672,
 253105975,
 100677,
 -61671,
 253171266,
 100676,
 -61670,
 253236590,
 100675,
 -61669,
 253301840,
 100674,
 -61668,
 253367083,
 100673,
 -61667,
 253432315,
 100672,
 -1,
 253497579,
 100671,
 253693737,
 252908027,
 -1,
 -61664,
 253630872,
 100670,
 -61663,
 253696231,
 100669,
 -61662,
 253761543,
 100668,
 -61661,
 253826871,
 100667,
 -61660,
 253892162,
 100666,
 -61659,
 253957486,
 100665,
 -61658,
 254022736,
 100664,
 -61657,
 254087979,
 100663,
 -61656,
 254153211,
 100662,
 -1,
 254218475,
 100661,
 254476287,
 253628651,
 -1,
 -61653,
 254351768,
 100660,
 -61652,
 254417127,
 100659,
 -61651,
 254482439,
 100658,
 -61650,
 254547767,
 100657,
 -61649,
 254613058,
 100656,
 -61648,
 254678382,
 100655,
 -61647,
 254743632,
 100654,
 -61646,
 254808875,
 100653,
 -61645,
 254874107,
 100652,
 -1,
 254939371,
 100651,
 255135651,
 247796523,
 -1,
 255201088,
 255072664,
 -1,
 -61641,
 255138200,
 100650,
 -61640,
 255203559,
 100649,
 -61639,
 255268871,
 100648,
 -61638,
 255334199,
 100647,
 -61637,
 255399490,
 100646,
 -61636,
 255464814,
 100645,
 -61635,
 255530064,
 100644,
 -61634,
 255595307,
 100643,
 -61633,
 255660539,
 100642,
 -1,
 255725803,
 100641,
 255921995,
 255138023,
 -1,
 -61630,
 255859096,
 100640,
 -61629,
 255924455,
 100639,
 -61628,
 255989767,
 100638,
 -61627,
 256055095,
 100637,
 -61626,
 256120386,
 100636,
 -61625,
 256185710,
 100635,
 -61624,
 256250960,
 100634,
 -61623,
 256316203,
 100633,
 -61622,
 256381435,
 100632,
 -1,
 256446699,
 100631,
 256642902,
 255858695,
 -1,
 -61619,
 256579992,
 100630,
 -61618,
 256645351,
 100629,
 -61617,
 256710663,
 100628,
 -61616,
 256775991,
 100627,
 -61615,
 256841282,
 100626,
 -61614,
 256906606,
 100625,
 -61613,
 256971856,
 100624,
 -61612,
 257037099,
 100623,
 -61611,
 257102331,
 100622,
 -1,
 257167595,
 100621,
 257363809,
 256579383,
 -1,
 -61608,
 257300888,
 100620,
 -61607,
 257366247,
 100619,
 -61606,
 257431559,
 100618,
 -61605,
 257496887,
 100617,
 -61604,
 257562178,
 100616,
 -61603,
 257627502,
 100615,
 -61602,
 257692752,
 100614,
 -61601,
 257757995,
 100613,
 -61600,
 257823227,
 100612,
 -1,
 257888491,
 100611,
 258084716,
 257300034,
 -1,
 -61597,
 258021784,
 100610,
 -61596,
 258087143,
 100609,
 -61595,
 258152455,
 100608,
 -61594,
 258217783,
 100607,
 -61593,
 258283074,
 100606,
 -61592,
 258348398,
 100605,
 -61591,
 258413648,
 100604,
 -61590,
 258478891,
 100603,
 -61589,
 258544123,
 100602,
 -1,
 258609387,
 100601,
 258805623,
 258020718,
 -1,
 -61586,
 258742680,
 100600,
 -61585,
 258808039,
 100599,
 -61584,
 258873351,
 100598,
 -61583,
 258938679,
 100597,
 -61582,
 259003970,
 100596,
 -61581,
 259069294,
 100595,
 -61580,
 259134544,
 100594,
 -61579,
 259199787,
 100593,
 -61578,
 259265019,
 100592,
 -1,
 259330283,
 100591,
 259526530,
 258741328,
 -1,
 -61575,
 259463576,
 100590,
 -61574,
 259528935,
 100589,
 -61573,
 259594247,
 100588,
 -61572,
 259659575,
 100587,
 -61571,
 259724866,
 100586,
 -61570,
 259790190,
 100585,
 -61569,
 259855440,
 100584,
 -61568,
 259920683,
 100583,
 -61567,
 259985915,
 100582,
 -1,
 260051179,
 100581,
 260247437,
 259461931,
 -1,
 -61564,
 260184472,
 100580,
 -61563,
 260249831,
 100579,
 -61562,
 260315143,
 100578,
 -61561,
 260380471,
 100577,
 -61560,
 260445762,
 100576,
 -61559,
 260511086,
 100575,
 -61558,
 260576336,
 100574,
 -61557,
 260641579,
 100573,
 -61556,
 260706811,
 100572,
 -1,
 260772075,
 100571,
 260968344,
 260182523,
 -1,
 -61553,
 260905368,
 100570,
 -61552,
 260970727,
 100569,
 -61551,
 261036039,
 100568,
 -61550,
 261101367,
 100567,
 -61549,
 261166658,
 100566,
 -61548,
 261231982,
 100565,
 -61547,
 261297232,
 100564,
 -61546,
 261362475,
 100563,
 -61545,
 261427707,
 100562,
 -1,
 261492971,
 100561,
 261750783,
 260903147,
 -1,
 -61542,
 261626264,
 100560,
 -61541,
 261691623,
 100559,
 -61540,
 261756935,
 100558,
 -61539,
 261822263,
 100557,
 -61538,
 261887554,
 100556,
 -61537,
 261952878,
 100555,
 -61536,
 262018128,
 100554,
 -61535,
 262083371,
 100553,
 -61534,
 262148603,
 100552,
 -1,
 262213867,
 100551,
 262410258,
 255070715,
 -1,
 262475695,
 262347160,
 -1,
 -61530,
 262412696,
 100550,
 -61529,
 262478055,
 100549,
 -61528,
 262543367,
 100548,
 -61527,
 262608695,
 100547,
 -61526,
 262673986,
 100546,
 -61525,
 262739310,
 100545,
 -61524,
 262804560,
 100544,
 -61523,
 262869803,
 100543,
 -61522,
 262935035,
 100542,
 -1,
 263000299,
 100541,
 263196602,
 262412519,
 -1,
 -61519,
 263133592,
 100540,
 -61518,
 263198951,
 100539,
 -61517,
 263264263,
 100538,
 -61516,
 263329591,
 100537,
 -61515,
 263394882,
 100536,
 -61514,
 263460206,
 100535,
 -61513,
 263525456,
 100534,
 -61512,
 263590699,
 100533,
 -61511,
 263655931,
 100532,
 -1,
 263721195,
 100531,
 263917509,
 263133191,
 -1,
 -61508,
 263854488,
 100530,
 -61507,
 263919847,
 100529,
 -61506,
 263985159,
 100528,
 -61505,
 264050487,
 100527,
 -61504,
 264115778,
 100526,
 -61503,
 264181102,
 100525,
 -61502,
 264246352,
 100524,
 -61501,
 264311595,
 100523,
 -61500,
 264376827,
 100522,
 -1,
 264442091,
 100521,
 264638416,
 263853879,
 -1,
 -61497,
 264575384,
 100520,
 -61496,
 264640743,
 100519,
 -61495,
 264706055,
 100518,
 -61494,
 264771383,
 100517,
 -61493,
 264836674,
 100516,
 -61492,
 264901998,
 100515,
 -61491,
 264967248,
 100514,
 -61490,
 265032491,
 100513,
 -61489,
 265097723,
 100512,
 -1,
 265162987,
 100511,
 265359323,
 264574530,
 -1,
 -61486,
 265296280,
 100510,
 -61485,
 265361639,
 100509,
 -61484,
 265426951,
 100508,
 -61483,
 265492279,
 100507,
 -61482,
 265557570,
 100506,
 -61481,
 265622894,
 100505,
 -61480,
 265688144,
 100504,
 -61479,
 265753387,
 100503,
 -61478,
 265818619,
 100502,
 -1,
 265883883,
 100501,
 266080230,
 265295214,
 -1,
 -61475,
 266017176,
 100500,
 -61474,
 266082535,
 100499,
 -61473,
 266147847,
 100498,
 -61472,
 266213175,
 100497,
 -61471,
 266278466,
 100496,
 -61470,
 266343790,
 100495,
 -61469,
 266409040,
 100494,
 -61468,
 266474283,
 100493,
 -61467,
 266539515,
 100492,
 -1,
 266604779,
 100491,
 266801137,
 266015824,
 -1,
 -61464,
 266738072,
 100490,
 -61463,
 266803431,
 100489,
 -61462,
 266868743,
 100488,
 -61461,
 266934071,
 100487,
 -61460,
 266999362,
 100486,
 -61459,
 267064686,
 100485,
 -61458,
 267129936,
 100484,
 -61457,
 267195179,
 100483,
 -61456,
 267260411,
 100482,
 -1,
 267325675,
 100481,
 267522044,
 266736427,
 -1,
 -61453,
 267458968,
 100480,
 -61452,
 267524327,
 100479,
 -61451,
 267589639,
 100478,
 -61450,
 267654967,
 100477,
 -61449,
 267720258,
 100476,
 -61448,
 267785582,
 100475,
 -61447,
 267850832,
 100474,
 -61446,
 267916075,
 100473,
 -61445,
 267981307,
 100472,
 -1,
 268046571,
 100471,
 268242951,
 267457019,
 -1,
 -61442,
 268179864,
 100470,
 -61441,
 268245223,
 100469,
 -61440,
 268310535,
 100468,
 -61439,
 268375863,
 100467,
 -61438,
 268441154,
 100466,
 -61437,
 268506478,
 100465,
 -61436,
 268571728,
 100464,
 -61435,
 268636971,
 100463,
 -61434,
 268702203,
 100462,
 -1,
 268767467,
 100461,
 269025279,
 268177643,
 -1,
 -61431,
 268900760,
 100460,
 -61430,
 268966119,
 100459,
 -61429,
 269031431,
 100458,
 -61428,
 269096759,
 100457,
 -61427,
 269162050,
 100456,
 -61426,
 269227374,
 100455,
 -61425,
 269292624,
 100454,
 -61424,
 269357867,
 100453,
 -61423,
 269423099,
 100452,
 -1,
 269488363,
 100451,
 269684864,
 262344939,
 -1,
 269750302,
 269621656,
 -1,
 -61419,
 269687192,
 100450,
 -61418,
 269752551,
 100449,
 -61417,
 269817863,
 100448,
 -61416,
 269883191,
 100447,
 -61415,
 269948482,
 100446,
 -61414,
 270013806,
 100445,
 -61413,
 270079056,
 100444,
 -61412,
 270144299,
 100443,
 -61411,
 270209531,
 100442,
 -1,
 270274795,
 100441,
 270471209,
 269687015,
 -1,
 -61408,
 270408088,
 100440,
 -61407,
 270473447,
 100439,
 -61406,
 270538759,
 100438,
 -61405,
 270604087,
 100437,
 -61404,
 270669378,
 100436,
 -61403,
 270734702,
 100435,
 -61402,
 270799952,
 100434,
 -61401,
 270865195,
 100433,
 -61400,
 270930427,
 100432,
 -1,
 270995691,
 100431,
 271192116,
 270407687,
 -1,
 -61397,
 271128984,
 100430,
 -61396,
 271194343,
 100429,
 -61395,
 271259655,
 100428,
 -61394,
 271324983,
 100427,
 -61393,
 271390274,
 100426,
 -61392,
 271455598,
 100425,
 -61391,
 271520848,
 100424,
 -61390,
 271586091,
 100423,
 -61389,
 271651323,
 100422,
 -1,
 271716587,
 100421,
 271913023,
 271128375,
 -1,
 -61386,
 271849880,
 100420,
 -61385,
 271915239,
 100419,
 -61384,
 271980551,
 100418,
 -61383,
 272045879,
 100417,
 -61382,
 272111170,
 100416,
 -61381,
 272176494,
 100415,
 -61380,
 272241744,
 100414,
 -61379,
 272306987,
 100413,
 -61378,
 272372219,
 100412,
 -1,
 272437483,
 100411,
 272633930,
 271849026,
 -1,
 -61375,
 272570776,
 100410,
 -61374,
 272636135,
 100409,
 -61373,
 272701447,
 100408,
 -61372,
 272766775,
 100407,
 -61371,
 272832066,
 100406,
 -61370,
 272897390,
 100405,
 -61369,
 272962640,
 100404,
 -61368,
 273027883,
 100403,
 -61367,
 273093115,
 100402,
 -1,
 273158379,
 100401,
 273354837,
 272569710,
 -1,
 -61364,
 273291672,
 100400,
 -61363,
 273357031,
 100399,
 -61362,
 273422343,
 100398,
 -61361,
 273487671,
 100397,
 -61360,
 273552962,
 100396,
 -61359,
 273618286,
 100395,
 -61358,
 273683536,
 100394,
 -61357,
 273748779,
 100393,
 -61356,
 273814011,
 100392,
 -1,
 273879275,
 100391,
 274075744,
 273290320,
 -1,
 -61353,
 274012568,
 100390,
 -61352,
 274077927,
 100389,
 -61351,
 274143239,
 100388,
 -61350,
 274208567,
 100387,
 -61349,
 274273858,
 100386,
 -61348,
 274339182,
 100385,
 -61347,
 274404432,
 100384,
 -61346,
 274469675,
 100383,
 -61345,
 274534907,
 100382,
 -1,
 274600171,
 100381,
 274796651,
 274010923,
 -1,
 -61342,
 274733464,
 100380,
 -61341,
 274798823,
 100379,
 -61340,
 274864135,
 100378,
 -61339,
 274929463,
 100377,
 -61338,
 274994754,
 100376,
 -61337,
 275060078,
 100375,
 -61336,
 275125328,
 100374,
 -61335,
 275190571,
 100373,
 -61334,
 275255803,
 100372,
 -1,
 275321067,
 100371,
 275517558,
 274731515,
 -1,
 -61331,
 275454360,
 100370,
 -61330,
 275519719,
 100369,
 -61329,
 275585031,
 100368,
 -61328,
 275650359,
 100367,
 -61327,
 275715650,
 100366,
 -61326,
 275780974,
 100365,
 -61325,
 275846224,
 100364,
 -61324,
 275911467,
 100363,
 -61323,
 275976699,
 100362,
 -1,
 276041963,
 100361,
 276299775,
 275452139,
 -1,
 -61320,
 276175256,
 100360,
 -61319,
 276240615,
 100359,
 -61318,
 276305927,
 100358,
 -61317,
 276371255,
 100357,
 -61316,
 276436546,
 100356,
 -61315,
 276501870,
 100355,
 -61314,
 276567120,
 100354,
 -61313,
 276632363,
 100353,
 -1,
 276697595,
 100352,
 276955135,
 269621255,
 -1,
 276959372,
 276829762,
 -1,
 -61309,
 276896152,
 101110,
 -61308,
 276961511,
 101109,
 -61307,
 277026823,
 101108,
 -61306,
 277092151,
 101107,
 -61305,
 277157442,
 101106,
 -61304,
 277222766,
 101105,
 -61303,
 277288016,
 101104,
 -61302,
 277353259,
 101103,
 -61301,
 277418491,
 101102,
 -1,
 277483755,
 101101,
 277680279,
 276895086,
 -1,
 -61298,
 277617048,
 101100,
 -61297,
 277682407,
 101099,
 -61296,
 277747719,
 101098,
 -61295,
 277813047,
 101097,
 -61294,
 277878338,
 101096,
 -61293,
 277943662,
 101095,
 -61292,
 278008912,
 101094,
 -61291,
 278074155,
 101093,
 -61290,
 278139387,
 101092,
 -1,
 278204651,
 101091,
 278401186,
 277615696,
 -1,
 -61287,
 278337944,
 101090,
 -61286,
 278403303,
 101089,
 -61285,
 278468615,
 101088,
 -61284,
 278533943,
 101087,
 -61283,
 278599234,
 101086,
 -61282,
 278664558,
 101085,
 -61281,
 278729808,
 101084,
 -61280,
 278795051,
 101083,
 -61279,
 278860283,
 101082,
 -1,
 278925547,
 101081,
 279122093,
 278336299,
 -1,
 -61276,
 279058840,
 101080,
 -61275,
 279124199,
 101079,
 -61274,
 279189511,
 101078,
 -61273,
 279254839,
 101077,
 -61272,
 279320130,
 101076,
 -61271,
 279385454,
 101075,
 -61270,
 279450704,
 101074,
 -61269,
 279515947,
 101073,
 -61268,
 279581179,
 101072,
 -1,
 279646443,
 101071,
 279843000,
 279056891,
 -1,
 -61265,
 279779736,
 101070,
 -61264,
 279845095,
 101069,
 -61263,
 279910407,
 101068,
 -61262,
 279975735,
 101067,
 -61261,
 280041026,
 101066,
 -61260,
 280106350,
 101065,
 -61259,
 280171600,
 101064,
 -61258,
 280236843,
 101063,
 -61257,
 280302075,
 101062,
 -1,
 280367339,
 101061,
 280563907,
 279777515,
 -1,
 -61254,
 280500632,
 101060,
 -61253,
 280565991,
 101059,
 -61252,
 280631303,
 101058,
 -61251,
 280696631,
 101057,
 -61250,
 280761922,
 101056,
 -61249,
 280827246,
 101055,
 -61248,
 280892496,
 101054,
 -61247,
 280957739,
 101053,
 -61246,
 281022971,
 101052,
 -1,
 281088235,
 101051,
 281346047,
 280500023,
 -1,
 -61243,
 281221351,
 101119,
 -61242,
 281286663,
 101118,
 -61241,
 281351991,
 101117,
 -61240,
 281417282,
 101116,
 -61239,
 281482606,
 101115,
 -61238,
 281547856,
 101114,
 -61237,
 281613099,
 101113,
 -61236,
 281678331,
 101112,
 -1,
 281743595,
 101111,
 -1,
 225932695,
 94176,
 -1,
 225856978,
 127818,
 -1,
 225778523,
 127883,
 282137214,
 225741132,
 -1,
 282202749,
 282094701,
 -1,
 282268201,
 282182100,
 -1,
 282333709,
 282260795,
 -1,
 282398997,
 282301088,
 -1,
 282464495,
 282366624,
 -1,
 282530019,
 282432160,
 -1,
 282595547,
 282466890,
 -1,
 -61223,
 282582203,
 983864,
 -61222,
 282617853,
 983861,
 -1,
 282663498,
 983854,
 282857693,
 282582203,
 983857,
 -1,
 282844347,
 983858,
 282988767,
 282827457,
 983862,
 -1,
 282958529,
 983863,
 283119841,
 282945533,
 983855,
 -1,
 283076605,
 983856,
 283312127,
 283067586,
 983859,
 -1,
 283198658,
 983860,
 283381991,
 282466890,
 -1,
 -61211,
 283368635,
 983732,
 -61210,
 283404285,
 983729,
 -1,
 283449930,
 983722,
 283644137,
 283368635,
 983725,
 -1,
 283630779,
 983726,
 283775211,
 283613889,
 983730,
 -1,
 283744961,
 983731,
 283906285,
 283731965,
 983723,
 -1,
 283863037,
 983724,
 284098559,
 283854018,
 983727,
 -1,
 283985090,
 983728,
 284168444,
 282456886,
 -1,
 284233972,
 284105290,
 -1,
 -61198,
 284220603,
 983710,
 -61197,
 284256253,
 983707,
 -1,
 284301898,
 983700,
 284496118,
 284220603,
 983703,
 -1,
 284482747,
 983704,
 284627192,
 284465857,
 983708,
 -1,
 284596929,
 983709,
 284758266,
 284583933,
 983701,
 -1,
 284715005,
 983702,
 284950527,
 284705986,
 983705,
 -1,
 284837058,
 983706,
 285020425,
 284121171,
 -1,
 285085953,
 284957258,
 -1,
 -61185,
 285072571,
 983688,
 -61184,
 285108221,
 983685,
 -1,
 285153866,
 983678,
 285348099,
 285072571,
 983681,
 -1,
 285334715,
 983682,
 285479173,
 285317825,
 983686,
 -1,
 285448897,
 983687,
 285610247,
 285435901,
 983679,
 -1,
 285566973,
 983680,
 285802495,
 285557954,
 983683,
 -1,
 285689026,
 983684,
 285872397,
 284957258,
 -1,
 -61173,
 285859003,
 983754,
 -61172,
 285894653,
 983751,
 -1,
 285940298,
 983744,
 286134543,
 285859003,
 983747,
 -1,
 286121147,
 983748,
 286265617,
 286104257,
 983752,
 -1,
 286235329,
 983753,
 286396691,
 286222333,
 983745,
 -1,
 286353405,
 983746,
 286588927,
 286344386,
 983749,
 -1,
 286475458,
 983750,
 286658877,
 282378708,
 -1,
 286724388,
 286612924,
 -1,
 286789915,
 286661194,
 -1,
 -61159,
 286776507,
 983886,
 -61158,
 286812157,
 983883,
 -1,
 286857802,
 983876,
 287052061,
 286776507,
 983879,
 -1,
 287038651,
 983880,
 287183135,
 287021761,
 983884,
 -1,
 287152833,
 983885,
 287314209,
 287139837,
 983877,
 -1,
 287270909,
 983878,
 287445283,
 287261890,
 983881,
 -1,
 287392962,
 983882,
 -1,
 287423741,
 983932,
 287641905,
 286704084,
 -1,
 287707433,
 287578698,
 -1,
 -61145,
 287694011,
 983897,
 -61144,
 287729661,
 983894,
 -1,
 287775306,
 983887,
 287969579,
 287694011,
 983890,
 -1,
 287956155,
 983891,
 288100653,
 287939265,
 983895,
 -1,
 288070337,
 983896,
 288231727,
 288057341,
 983888,
 -1,
 288188413,
 983889,
 288423935,
 288179394,
 983892,
 -1,
 288310466,
 983893,
 288493877,
 287578698,
 -1,
 -61133,
 288480443,
 983908,
 -61132,
 288516093,
 983905,
 -1,
 288561738,
 983898,
 288756023,
 288480443,
 983901,
 -1,
 288742587,
 983902,
 288887097,
 288725697,
 983906,
 -1,
 288856769,
 983907,
 289018171,
 288843773,
 983899,
 -1,
 288974845,
 983900,
 289210367,
 288965826,
 983903,
 -1,
 289096898,
 983904,
 289280356,
 286620731,
 -1,
 289345880,
 289242171,
 -1,
 289411404,
 289307707,
 -1,
 289476932,
 289348170,
 -1,
 -61118,
 289463483,
 983831,
 -61117,
 289499133,
 983828,
 -1,
 289544778,
 983821,
 289739078,
 289463483,
 983824,
 -1,
 289725627,
 983825,
 289870152,
 289708737,
 983829,
 -1,
 289839809,
 983830,
 290001226,
 289826813,
 983822,
 -1,
 289957885,
 983823,
 290193407,
 289948866,
 983826,
 -1,
 290079938,
 983827,
 290263376,
 289348170,
 -1,
 -61106,
 290249915,
 983842,
 -61105,
 290285565,
 983839,
 -1,
 290331210,
 983832,
 290525522,
 290249915,
 983835,
 -1,
 290512059,
 983836,
 290656596,
 290495169,
 983840,
 -1,
 290626241,
 983841,
 290787670,
 290613245,
 983833,
 -1,
 290744317,
 983834,
 290979839,
 290735298,
 983837,
 -1,
 290866370,
 983838,
 291049820,
 289282634,
 -1,
 -61094,
 291036347,
 983809,
 -61093,
 291071997,
 983806,
 -1,
 291117642,
 983799,
 291311966,
 291036347,
 983802,
 -1,
 291298491,
 983803,
 291443040,
 291281601,
 983807,
 -1,
 291412673,
 983808,
 291574114,
 291399677,
 983800,
 -1,
 291530749,
 983801,
 291766271,
 291521730,
 983804,
 -1,
 291652802,
 983805,
 291836286,
 289241184,
 -1,
 291901810,
 291818523,
 -1,
 291967338,
 291838538,
 983920,
 -61080,
 291953851,
 983931,
 -61079,
 291989501,
 983928,
 -1,
 292035146,
 983921,
 292229484,
 291953851,
 983924,
 -1,
 292215995,
 983925,
 292360558,
 292199105,
 983929,
 -1,
 292330177,
 983930,
 292491632,
 292317181,
 983922,
 -1,
 292448253,
 983923,
 292683775,
 292439234,
 983926,
 -1,
 292570306,
 983927,
 292753782,
 291838538,
 -1,
 -61068,
 292740283,
 983677,
 -61067,
 292775933,
 983674,
 -1,
 292821578,
 983667,
 293015928,
 292740283,
 983670,
 -1,
 293002427,
 983671,
 293147002,
 292985537,
 983675,
 -1,
 293116609,
 983676,
 293278076,
 293103613,
 983668,
 -1,
 293234685,
 983669,
 293470207,
 293225666,
 983672,
 -1,
 293356738,
 983673,
 293540248,
 291819510,
 -1,
 293605772,
 293523446,
 -1,
 293671300,
 293542474,
 -1,
 -61054,
 293657787,
 983721,
 -61053,
 293693437,
 983718,
 -1,
 293739082,
 983711,
 293933446,
 293657787,
 983714,
 -1,
 293919931,
 983715,
 294064520,
 293903041,
 983719,
 -1,
 294034113,
 983720,
 294195594,
 294021117,
 983712,
 -1,
 294152189,
 983713,
 294387711,
 294143170,
 983716,
 -1,
 294274242,
 983717,
 294457744,
 293542474,
 -1,
 -61042,
 294444219,
 983743,
 -61041,
 294479869,
 983740,
 -1,
 294525514,
 983733,
 294719890,
 294444219,
 983736,
 -1,
 294706363,
 983737,
 294850964,
 294689473,
 983741,
 -1,
 294820545,
 983742,
 294982038,
 294807549,
 983734,
 -1,
 294938621,
 983735,
 295174143,
 294929602,
 983738,
 -1,
 295060674,
 983739,
 295244210,
 293516258,
 -1,
 295309734,
 295220194,
 -1,
 295375262,
 295246410,
 -1,
 -61028,
 295361723,
 983853,
 -61027,
 295397373,
 983850,
 -1,
 295443018,
 983843,
 295637408,
 295361723,
 983846,
 -1,
 295623867,
 983847,
 295768482,
 295606977,
 983851,
 -1,
 295738049,
 983852,
 295899556,
 295725053,
 983844,
 -1,
 295856125,
 983845,
 296091647,
 295847106,
 983848,
 -1,
 295978178,
 983849,
 296161706,
 295246410,
 -1,
 -61016,
 296148155,
 983798,
 -61015,
 296183805,
 983795,
 -1,
 296229450,
 983788,
 296423852,
 296148155,
 983791,
 -1,
 296410299,
 983792,
 296554926,
 296393409,
 983796,
 -1,
 296524481,
 983797,
 296686000,
 296511485,
 983789,
 -1,
 296642557,
 983790,
 296878079,
 296633538,
 983793,
 -1,
 296764610,
 983794,
 296948159,
 295236406,
 -1,
 297013687,
 296884810,
 -1,
 -61003,
 297000123,
 983787,
 -61002,
 297035773,
 983784,
 -1,
 297081418,
 983777,
 297275833,
 297000123,
 983780,
 -1,
 297262267,
 983781,
 297406907,
 297245377,
 983785,
 -1,
 297376449,
 983786,
 297537981,
 297363453,
 983778,
 -1,
 297494525,
 983779,
 297730047,
 297485506,
 983782,
 -1,
 297616578,
 983783,
 297800140,
 296936858,
 -1,
 297865668,
 297736778,
 -1,
 -60990,
 297852091,
 983820,
 -60989,
 297887741,
 983817,
 -1,
 297933386,
 983810,
 298127814,
 297852091,
 983813,
 -1,
 298114235,
 983814,
 298258888,
 298097345,
 983818,
 -1,
 298228417,
 983819,
 298389962,
 298215421,
 983811,
 -1,
 298346493,
 983812,
 298582015,
 298337474,
 983815,
 -1,
 298468546,
 983816,
 298652121,
 297773520,
 -1,
 298717649,
 298588746,
 -1,
 -60977,
 298704059,
 983765,
 -60976,
 298739709,
 983762,
 -1,
 298785354,
 983755,
 298979795,
 298704059,
 983758,
 -1,
 298966203,
 983759,
 299110869,
 298949313,
 983763,
 -1,
 299080385,
 983764,
 299241943,
 299067389,
 983756,
 -1,
 299198461,
 983757,
 299433983,
 299189442,
 983760,
 -1,
 299320514,
 983761,
 299504102,
 298617164,
 -1,
 299569630,
 299440714,
 -1,
 -60964,
 299556027,
 983776,
 -60963,
 299591677,
 983773,
 -1,
 299637322,
 983766,
 299831776,
 299556027,
 983769,
 -1,
 299818171,
 983770,
 299962850,
 299801281,
 983774,
 -1,
 299932353,
 983775,
 300093924,
 299919357,
 983767,
 -1,
 300050429,
 983768,
 300285951,
 300041410,
 983771,
 -1,
 300172482,
 983772,
 300356083,
 299464513,
 -1,
 300421611,
 300292682,
 -1,
 -60951,
 300407995,
 983875,
 -60950,
 300443645,
 983872,
 -1,
 300489290,
 983865,
 300683757,
 300407995,
 983868,
 -1,
 300670139,
 983869,
 300814831,
 300653249,
 983873,
 -1,
 300784321,
 983874,
 300945905,
 300771325,
 983866,
 -1,
 300902397,
 983867,
 301137919,
 300893378,
 983870,
 -1,
 301024450,
 983871,
 301208064,
 300309948,
 -1,
 301273592,
 301144650,
 -1,
 -60938,
 301259963,
 983919,
 -60937,
 301295613,
 983916,
 -1,
 301341258,
 983909,
 301535738,
 301259963,
 983912,
 -1,
 301522107,
 983913,
 301666812,
 301505217,
 983917,
 -1,
 301636289,
 983918,
 301797886,
 301623293,
 983910,
 -1,
 301754365,
 983911,
 301989887,
 301745346,
 983914,
 -1,
 301876418,
 983915,
 302120959,
 301150120,
 -1,
 302125573,
 301996618,
 -1,
 -60925,
 302111931,
 983699,
 -60924,
 302147581,
 983696,
 -1,
 302193226,
 983689,
 302387719,
 302111931,
 983692,
 -1,
 302374075,
 983693,
 302518793,
 302357185,
 983697,
 -1,
 302488257,
 983698,
 302649867,
 302475261,
 983690,
 -1,
 302606333,
 983691,
 302841855,
 302597314,
 983694,
 -1,
 302728386,
 983695,
 302912038,
 282291202,
 -1,
 302977556,
 302885328,
 -1,
 303043091,
 302914122,
 -1,
 -60911,
 303027060,
 73691,
 -60910,
 303076160,
 73694,
 -1,
 303113341,
 73697,
 -1,
 303013502,
 73695,
 303370777,
 302966170,
 -1,
 303436312,
 303307338,
 -1,
 -60905,
 303412339,
 73696,
 -1,
 303462675,
 73713,
 -1,
 303385202,
 73699,
 303698461,
 303337933,
 -1,
 -60901,
 303687042,
 73689,
 -60900,
 303747963,
 73712,
 -1,
 303790915,
 73692,
 303960610,
 303659104,
 -1,
 304026145,
 303946939,
 -1,
 -60896,
 304019365,
 73698,
 -1,
 304071024,
 73690,
 -1,
 303962898,
 73693,
 -60893,
 303949202,
 73688,
 -60892,
 304256358,
 73685,
 -60891,
 304296511,
 73686,
 -1,
 304356155,
 73687,
 -60889,
 302895507,
 73711,
 -60888,
 304524438,
 73708,
 -1,
 304554089,
 73703,
 304747077,
 282210216,
 -1,
 304812611,
 304718099,
 -1,
 304878128,
 304779936,
 983650,
 304943662,
 304845472,
 983648,
 -1,
 304911008,
 983660,
 -60881,
 304935734,
 983646,
 -1,
 305027155,
 983644,
 305205811,
 304857556,
 983664,
 -60878,
 305185236,
 983663,
 -1,
 305225148,
 983662,
 305402422,
 305167419,
 983655,
 305528831,
 305364027,
 983658,
 -1,
 305429563,
 983657,
 305599032,
 305385462,
 983649,
 -1,
 305582070,
 983647,
 305730106,
 305574882,
 983654,
 -1,
 305705954,
 983659,
 305861180,
 305690720,
 983643,
 -1,
 305843227,
 983666,
 -60867,
 305853238,
 983653,
 -60866,
 305980826,
 983656,
 -60865,
 306031056,
 983651,
 -60864,
 306088268,
 983652,
 -60863,
 306149185,
 983661,
 -60862,
 306208188,
 983665,
 -1,
 306261928,
 983645,
 -60860,
 304800876,
 73706,
 -1,
 306427811,
 3063,
 306582117,
 304699199,
 -1,
 306647645,
 306552605,
 -1,
 306713165,
 306630646,
 -1,
 306778699,
 306666940,
 -1,
 -60854,
 306755546,
 73664,
 -1,
 306803766,
 73669,
 -60852,
 306768968,
 73672,
 -1,
 306924577,
 73675,
 307106386,
 306694383,
 -1,
 307171921,
 307054675,
 -1,
 -60848,
 307106603,
 73674,
 -1,
 307171835,
 73673,
 -1,
 307164067,
 73667,
 307434069,
 307060481,
 -1,
 -60844,
 307368747,
 73682,
 -1,
 307433979,
 73681,
 307630680,
 307384819,
 -1,
 -60841,
 307602533,
 73668,
 -1,
 307653275,
 73679,
 307827291,
 307579294,
 -1,
 -60838,
 307784283,
 73666,
 -1,
 307846588,
 73676,
 -60836,
 307802854,
 73680,
 -1,
 307994663,
 73665,
 308154980,
 306631776,
 -1,
 308220513,
 308136175,
 -1,
 -60832,
 308212652,
 73671,
 -1,
 308234330,
 73678,
 -60830,
 308206506,
 73677,
 -60829,
 308392741,
 73683,
 -1,
 308431348,
 73670,
 -1,
 308101924,
 73684,
 308679274,
 306527061,
 -1,
 -60825,
 308658586,
 73701,
 -60824,
 308702200,
 3046,
 -60823,
 308758256,
 3062,
 -1,
 308816075,
 3059,
 309006959,
 308662262,
 -1,
 309072494,
 308982930,
 -1,
 -60819,
 309041663,
 73705,
 -1,
 309082330,
 73704,
 -1,
 309044445,
 73709,
 309334642,
 308968507,
 -1,
 -60815,
 309284631,
 2998,
 -1,
 309338706,
 73702,
 309531253,
 309271114,
 -1,
 -60812,
 309510625,
 3064,
 -1,
 309564364,
 73707,
 -60810,
 309523527,
 3061,
 -60809,
 309718217,
 73700,
 -60808,
 309772684,
 3065,
 -60807,
 309834144,
 73727,
 -60806,
 309894635,
 3024,
 -60805,
 309959167,
 3066,
 -60804,
 310022408,
 3060,
 -1,
 310078799,
 73710,
 -1,
 282140590,
 129748,
 310317999,
 282093567,
 -1,
 310383399,
 310301571,
 -1,
 310448836,
 310346402,
 -1,
 310514329,
 310410299,
 -1,
 310579861,
 310487285,
 -1,
 310645383,
 310540384,
 -1,
 -60795,
 310637139,
 6692,
 -60794,
 310664654,
 6693,
 -1,
 310712906,
 6691,
 310907530,
 310628342,
 -1,
 -60791,
 310861262,
 6709,
 -1,
 310909514,
 6708,
 311104141,
 310880720,
 -1,
 -60788,
 311057870,
 6717,
 -1,
 311106122,
 6715,
 311300752,
 311046056,
 -1,
 -60785,
 311254478,
 6699,
 -1,
 311302730,
 6697,
 -60783,
 311292858,
 6719,
 -60782,
 311476905,
 6698,
 -60781,
 311539132,
 6704,
 -60780,
 311582158,
 6732,
 -1,
 311644744,
 6716,
 311825047,
 310516298,
 6723,
 -1,
 311772354,
 6739,
 -60776,
 311811849,
 6724,
 -1,
 311917701,
 6730,
 312087215,
 310469319,
 -1,
 312152734,
 312066516,
 -1,
 -60772,
 312132265,
 6727,
 -60771,
 312171982,
 6726,
 -1,
 312220234,
 6728,
 312414882,
 312113248,
 -1,
 -60768,
 312406611,
 6690,
 -60767,
 312434126,
 6689,
 -1,
 312482378,
 6688,
 312677029,
 312397814,
 -1,
 -60764,
 312630734,
 6707,
 -1,
 312678986,
 6706,
 312873640,
 312650192,
 -1,
 -60761,
 312827342,
 6713,
 -1,
 312875594,
 6712,
 313070251,
 312815528,
 -1,
 -60758,
 313023950,
 6696,
 -1,
 313072202,
 6695,
 -60756,
 313062330,
 6720,
 -60755,
 313243068,
 6702,
 -60754,
 313286094,
 6729,
 -1,
 313348680,
 6714,
 313529012,
 312062946,
 -1,
 313594547,
 313465418,
 6721,
 -60750,
 313577596,
 6701,
 -1,
 313627370,
 6705,
 -1,
 313581321,
 6722,
 313856696,
 313496224,
 -1,
 -60746,
 313848762,
 6700,
 -60745,
 313874594,
 6694,
 -1,
 313924170,
 6710,
 314118842,
 313842875,
 6735,
 -1,
 314105019,
 6736,
 314249916,
 314075133,
 6733,
 -1,
 314206205,
 6734,
 -60739,
 314239713,
 6725,
 -60738,
 314351948,
 6738,
 -60737,
 314411426,
 6718,
 -60736,
 314465507,
 6740,
 -60735,
 314525673,
 6737,
 -60734,
 314588160,
 6703,
 -60733,
 314648888,
 6711,
 -1,
 314710602,
 6731,
 314905318,
 310429659,
 -1,
 314970831,
 314865760,
 -1,
 315036364,
 314926937,
 -1,
 315101899,
 314968977,
 -1,
 -60727,
 315037250,
 6777,
 -60726,
 315102574,
 6776,
 -1,
 315167824,
 6775,
 -1,
 315035620,
 6780,
 315429582,
 314972970,
 6824,
 -1,
 315390987,
 6825,
 -1,
 315378856,
 6819,
 315626196,
 314950313,
 -1,
 315691730,
 315610830,
 6826,
 -1,
 315653131,
 6827,
 -60717,
 315681586,
 6818,
 -1,
 315784107,
 6752,
 315953881,
 315591195,
 -1,
 316019415,
 315914546,
 6772,
 -1,
 315950127,
 6744,
 -60712,
 316011527,
 6823,
 -1,
 316130115,
 6779,
 316281563,
 315944415,
 6816,
 -1,
 316271336,
 6817,
 316412638,
 316266331,
 -1,
 -60707,
 316347179,
 6774,
 -1,
 316412411,
 6773,
 316609249,
 316388322,
 -1,
 -60704,
 316559500,
 6822,
 -1,
 316611171,
 6778,
 316805860,
 316562876,
 -1,
 -60701,
 316778900,
 6820,
 -1,
 316809917,
 6828,
 -60699,
 316751799,
 6821,
 -1,
 316944358,
 6829,
 317133564,
 314894890,
 -1,
 317199085,
 317102785,
 6763,
 317264619,
 317135436,
 -1,
 -60694,
 317205229,
 6764,
 -1,
 317266850,
 6771,
 -60692,
 317256502,
 6765,
 -1,
 317430465,
 6768,
 317592305,
 317185211,
 6761,
 317657840,
 317578427,
 6762,
 -1,
 317605058,
 6760,
 -1,
 317605058,
 6759,
 317854453,
 317528650,
 6753,
 -60685,
 317810685,
 6769,
 -60684,
 317867202,
 6767,
 -1,
 317921866,
 6755,
 318116600,
 317837302,
 -1,
 -60681,
 318070545,
 6770,
 -1,
 318119971,
 6756,
 318313210,
 318072829,
 6757,
 -1,
 318269437,
 6758,
 -60677,
 318278182,
 6754,
 -1,
 318391490,
 6766,
 318575370,
 317117321,
 -1,
 318640896,
 318558198,
 -1,
 -60673,
 318631987,
 6802,
 -1,
 318662175,
 6803,
 318837507,
 318620116,
 -1,
 -60670,
 318797476,
 6806,
 -1,
 318853092,
 6807,
 319034118,
 318788083,
 -1,
 -60667,
 319006232,
 6804,
 -1,
 319059434,
 6805,
 -60665,
 319026992,
 6800,
 -60664,
 319201049,
 6801,
 -60663,
 319264494,
 6809,
 -1,
 319310238,
 6808,
 319492888,
 318530772,
 -1,
 319558414,
 319475702,
 -1,
 -60659,
 319549491,
 6786,
 -1,
 319579679,
 6787,
 319755025,
 319537620,
 -1,
 -60656,
 319714980,
 6790,
 -1,
 319770596,
 6791,
 319951636,
 319705587,
 -1,
 -60653,
 319923736,
 6788,
 -1,
 319976938,
 6789,
 -60651,
 319944496,
 6784,
 -60650,
 320118553,
 6785,
 -60649,
 320181998,
 6793,
 -1,
 320227742,
 6792,
 320471039,
 319436378,
 -1,
 320475942,
 320379154,
 -1,
 320541471,
 320440652,
 -1,
 320607006,
 320489397,
 -1,
 -60643,
 320582740,
 6741,
 -1,
 320633989,
 6742,
 -1,
 320543306,
 6748,
 320869154,
 320502843,
 -1,
 -60639,
 320841985,
 6746,
 -1,
 320871106,
 6743,
 -60637,
 320848553,
 6750,
 -60636,
 321020621,
 6747,
 -60635,
 321082359,
 6745,
 -1,
 321136952,
 6749,
 -1,
 320441385,
 6783,
 321393541,
 310372561,
 -1,
 321459047,
 321356450,
 -1,
 321524552,
 321423111,
 -1,
 321590062,
 321491616,
 -1,
 -60628,
 321582502,
 43664,
 -60627,
 321624769,
 43672,
 -1,
 321674301,
 43656,
 321852211,
 321550432,
 -1,
 321917746,
 321805756,
 -1,
 -60623,
 321886913,
 43650,
 -1,
 321938470,
 43652,
 -1,
 321886913,
 43648,
 322179894,
 321834998,
 -1,
 -60619,
 322149057,
 43668,
 -1,
 322200614,
 43670,
 322376505,
 322152912,
 -1,
 -60616,
 322345665,
 43676,
 -1,
 322397222,
 43678,
 322573116,
 322318248,
 -1,
 -60613,
 322542273,
 43658,
 -1,
 322593830,
 43660,
 -60611,
 322565542,
 43684,
 -60610,
 322758967,
 43690,
 -60609,
 322816724,
 43662,
 -60608,
 322879274,
 43686,
 -60607,
 322935489,
 43694,
 -60606,
 322998376,
 43682,
 -60605,
 323061221,
 43688,
 -60604,
 323118118,
 43692,
 -60603,
 323181629,
 43654,
 -60602,
 323245492,
 43680,
 -60601,
 323305363,
 43666,
 -1,
 323366262,
 43674,
 323616767,
 321479367,
 -1,
 323621709,
 323523232,
 -1,
 -60597,
 323614118,
 43665,
 -60596,
 323656385,
 43673,
 -1,
 323705917,
 43657,
 323883858,
 323582048,
 -1,
 323949393,
 323837372,
 -1,
 -60592,
 323918529,
 43651,
 -1,
 323970086,
 43653,
 -1,
 323918529,
 43649,
 324211541,
 323866614,
 -1,
 -60588,
 324180673,
 43669,
 -1,
 324232230,
 43671,
 324408152,
 324184528,
 -1,
 -60585,
 324377281,
 43677,
 -1,
 324428838,
 43679,
 324604763,
 324349864,
 -1,
 -60582,
 324573889,
 43659,
 -1,
 324625446,
 43661,
 -60580,
 324597158,
 43685,
 -60579,
 324790583,
 43691,
 -60578,
 324848340,
 43663,
 -60577,
 324910890,
 43687,
 -60576,
 324967105,
 43695,
 -60575,
 325029992,
 43683,
 -60574,
 325092837,
 43689,
 -60573,
 325149734,
 43693,
 -60572,
 325213245,
 43655,
 -60571,
 325277108,
 43681,
 -60570,
 325336979,
 43667,
 -1,
 325397878,
 43675,
 325587830,
 321448424,
 -1,
 325653358,
 325524042,
 -1,
 -60566,
 325645110,
 43708,
 -60565,
 325705481,
 43707,
 -60564,
 325751456,
 43709,
 -60563,
 325814604,
 43710,
 -1,
 325851722,
 43697,
 326046578,
 325639355,
 43700,
 326112113,
 325993666,
 43699,
 -1,
 326048330,
 43705,
 -1,
 326048330,
 43706,
 326308724,
 326002685,
 43698,
 -1,
 326244938,
 43704,
 -60555,
 326277825,
 43702,
 -1,
 326386882,
 43701,
 326570877,
 325570490,
 -1,
 326636410,
 326531932,
 -1,
 -60551,
 326603424,
 43739,
 -1,
 326658064,
 43743,
 -60549,
 326615875,
 43741,
 -60548,
 326801895,
 43740,
 -1,
 326853673,
 43742,
 327029634,
 326555473,
 -1,
 -60545,
 327013415,
 43713,
 -60544,
 327076638,
 43714,
 -60543,
 327129575,
 43712,
 -1,
 327174694,
 43711,
 327417855,
 326994464,
 -1,
 -60540,
 327312323,
 43703,
 -1,
 327361213,
 43696,
 327614463,
 321355595,
 -1,
 327619474,
 327536630,
 -1,
 327685005,
 327589922,
 -1,
 -60535,
 327620407,
 6516,
 -60534,
 327685698,
 6515,
 -60533,
 327751022,
 6514,
 -60532,
 327816272,
 6513,
 -1,
 327881515,
 6512,
 328078224,
 327664084,
 -1,
 -60529,
 328031694,
 6497,
 -1,
 328079946,
 6483,
 -60527,
 328031694,
 6487,
 -1,
 328211018,
 6486,
 328405909,
 327566530,
 6507,
 -60524,
 328359356,
 6502,
 -1,
 328418498,
 6501,
 328602520,
 328342090,
 6499,
 -60521,
 328589065,
 6508,
 -1,
 328624125,
 6509,
 328799130,
 328588475,
 6503,
 -1,
 328746178,
 6506,
 328930205,
 328772048,
 -1,
 -60516,
 328883662,
 6490,
 -1,
 328931914,
 6489,
 329126815,
 328899265,
 6505,
 -1,
 329095873,
 6504,
 329257890,
 329093792,
 -1,
 -60511,
 329210018,
 6482,
 -1,
 329259594,
 6498,
 329454501,
 329218144,
 -1,
 -60508,
 329407950,
 6496,
 -1,
 329456202,
 6480,
 -60506,
 329446330,
 6485,
 -60505,
 329642579,
 6481,
 -60504,
 329704877,
 6493,
 -60503,
 329761449,
 6484,
 -60502,
 329822765,
 6495,
 -60501,
 329877922,
 6491,
 -60500,
 329940101,
 6488,
 -60499,
 330000381,
 6500,
 -60498,
 330063310,
 6494,
 -1,
 330125896,
 6492,
 330306571,
 310278240,
 -1,
 330372106,
 330283469,
 -1,
 330437611,
 330334882,
 -1,
 330503095,
 330373706,
 71296,
 -60492,
 330489019,
 71305,
 -60491,
 330544695,
 71352,
 -60490,
 330590205,
 71303,
 -1,
 330635850,
 71297,
 330830781,
 330485750,
 -1,
 330896315,
 330813430,
 -1,
 -60486,
 330849742,
 71317,
 -1,
 330897994,
 71316,
 -60484,
 330849742,
 71322,
 -1,
 331029066,
 71321,
 331224002,
 330797728,
 -1,
 -60481,
 331215802,
 71315,
 -60480,
 331256554,
 71320,
 -60479,
 331307170,
 71310,
 -1,
 331356746,
 71325,
 331551688,
 331168597,
 -1,
 331617222,
 331496277,
 -1,
 -60475,
 331570638,
 71319,
 -1,
 331618890,
 71318,
 -60473,
 331570638,
 71324,
 -1,
 331749962,
 71323,
 331944906,
 331537595,
 71300,
 -1,
 331930811,
 71301,
 332075981,
 331923924,
 -1,
 -60468,
 332029390,
 71335,
 -1,
 332077642,
 71336,
 332272592,
 332051426,
 -1,
 -60465,
 332248148,
 71338,
 -1,
 332274250,
 71332,
 332469203,
 332245456,
 -1,
 -60462,
 332422606,
 71327,
 -1,
 332470858,
 71326,
 332665814,
 332429408,
 -1,
 -60459,
 332619214,
 71307,
 -1,
 332667466,
 71306,
 332862425,
 332625729,
 -1,
 -60456,
 332815822,
 71314,
 -1,
 332864074,
 71313,
 333059035,
 332818429,
 71298,
 -1,
 333015037,
 71299,
 333190110,
 333011027,
 -1,
 -60451,
 333143502,
 71309,
 -1,
 333191754,
 71308,
 333386721,
 333131688,
 -1,
 -60448,
 333340110,
 71312,
 -1,
 333388362,
 71311,
 333583332,
 333326599,
 -1,
 -60445,
 333536718,
 71329,
 -1,
 333584970,
 71328,
 -60443,
 333575098,
 71331,
 -60442,
 333768109,
 71334,
 -60441,
 333814465,
 71304,
 -60440,
 333875618,
 71330,
 -60439,
 333937797,
 71333,
 -60438,
 333995470,
 71337,
 -1,
 334054594,
 71302,
 334238713,
 330383085,
 -1,
 334304239,
 334221302,
 -1,
 -60434,
 334295091,
 71362,
 -1,
 334325279,
 71363,
 334500850,
 334283220,
 -1,
 -60431,
 334460580,
 71366,
 -1,
 334516196,
 71367,
 334697461,
 334451187,
 -1,
 -60428,
 334669336,
 71364,
 -1,
 334722538,
 71365,
 -60426,
 334690096,
 71360,
 -60425,
 334864153,
 71361,
 -60424,
 334927598,
 71369,
 -1,
 334973342,
 71368,
 335156228,
 334228010,
 -1,
 335221758,
 335092298,
 -1,
 -60420,
 335207611,
 71349,
 -60419,
 335243261,
 71347,
 -1,
 335288906,
 71341,
 335483904,
 335207611,
 71344,
 -1,
 335469755,
 71345,
 335614978,
 335439869,
 71342,
 -1,
 335570941,
 71343,
 -60413,
 335583937,
 71348,
 -1,
 335692994,
 71346,
 335937535,
 335136731,
 -1,
 335942664,
 335866033,
 -1,
 -60409,
 335922068,
 71340,
 -1,
 335983973,
 71350,
 -60407,
 335911405,
 71351,
 -1,
 336077766,
 71339,
 -1,
 330321055,
 129377,
 336335886,
 330270150,
 -1,
 -60403,
 336305945,
 119671,
 -1,
 336352418,
 119672,
 336532496,
 336275719,
 983061,
 -1,
 336494422,
 127955,
 -60399,
 336523976,
 128661,
 -60398,
 336636904,
 128429,
 -1,
 336672346,
 127790,
 336860394,
 225667069,
 -1,
 336925829,
 336835554,
 -1,
 336991363,
 336881586,
 -1,
 337056852,
 336954018,
 -1,
 337122334,
 337044890,
 -1,
 337187869,
 337091435,
 -1,
 337253403,
 337163234,
 70791,
 -1,
 337228770,
 70792,
 337444863,
 337214523,
 70793,
 -1,
 337345595,
 70794,
 -1,
 337123914,
 70827,
 337581092,
 337104886,
 -1,
 337646626,
 337563638,
 -1,
 -60383,
 337599950,
 70810,
 -1,
 337648202,
 70809,
 -60381,
 337599950,
 70815,
 -1,
 337779274,
 70814,
 337974313,
 337547936,
 -1,
 -60378,
 337966010,
 70808,
 -60377,
 338006762,
 70813,
 -60376,
 338057378,
 70803,
 -1,
 338106954,
 70818,
 338301999,
 337918805,
 -1,
 338367533,
 338246485,
 -1,
 -60372,
 338320846,
 70812,
 -1,
 338369098,
 70811,
 -60370,
 338320846,
 70817,
 -1,
 338500170,
 70816,
 338695219,
 338238026,
 70785,
 -60367,
 338681019,
 70798,
 -60366,
 338716669,
 70796,
 -1,
 338762314,
 70786,
 338957367,
 338674132,
 -1,
 -60363,
 338936489,
 70829,
 -60362,
 338976206,
 70828,
 -1,
 339024458,
 70830,
 339219513,
 338943163,
 70789,
 -1,
 339205307,
 70790,
 339350588,
 339192272,
 -1,
 -60357,
 339303886,
 70820,
 -1,
 339352138,
 70819,
 339547199,
 339310688,
 -1,
 -60354,
 339500494,
 70800,
 -1,
 339548746,
 70799,
 339743810,
 339507009,
 -1,
 -60351,
 339697102,
 70807,
 -1,
 339745354,
 70806,
 339940420,
 339699709,
 70787,
 -1,
 339896317,
 70788,
 340071495,
 339892307,
 -1,
 -60346,
 340024782,
 70802,
 -1,
 340073034,
 70801,
 340268106,
 340012968,
 -1,
 -60343,
 340221390,
 70805,
 -1,
 340269642,
 70804,
 340464717,
 340207879,
 -1,
 -60340,
 340417998,
 70822,
 -1,
 340466250,
 70821,
 -60338,
 340456378,
 70824,
 -60337,
 340636756,
 70825,
 -60336,
 340695745,
 70797,
 -60335,
 340756898,
 70823,
 -60334,
 340819077,
 70826,
 -60333,
 340876750,
 70831,
 -1,
 340935874,
 70795,
 341120103,
 337046058,
 -1,
 341185626,
 341109073,
 -1,
 341251160,
 341160930,
 70837,
 -1,
 341226466,
 70838,
 341442559,
 341212219,
 70839,
 -1,
 341343291,
 70840,
 341513310,
 341121610,
 -1,
 -60324,
 341499067,
 70846,
 -60323,
 341534717,
 70843,
 -1,
 341580362,
 70832,
 341775456,
 341499067,
 70835,
 -1,
 341761211,
 70836,
 341906531,
 341755632,
 -1,
 -60318,
 341875393,
 70845,
 -1,
 341918914,
 70842,
 342103141,
 341862397,
 70833,
 -1,
 342059005,
 70834,
 -60314,
 342072001,
 70844,
 -1,
 342181058,
 70841,
 342365301,
 341065453,
 -1,
 342430827,
 342347766,
 -1,
 -60310,
 342421555,
 70866,
 -1,
 342451743,
 70867,
 342627438,
 342409684,
 -1,
 -60307,
 342587044,
 70870,
 -1,
 342642660,
 70871,
 342824049,
 342577651,
 -1,
 -60304,
 342795800,
 70868,
 -1,
 342849002,
 70869,
 -60302,
 342816560,
 70864,
 -60301,
 342990617,
 70865,
 -60300,
 343054062,
 70873,
 -1,
 343099806,
 70872,
 343282814,
 342345691,
 -1,
 343348345,
 343271601,
 -1,
 -60296,
 343327636,
 70849,
 -1,
 343389541,
 70850,
 343544956,
 343284298,
 -1,
 -60293,
 343532980,
 70852,
 -1,
 343579196,
 70848,
 -60291,
 343513581,
 70851,
 -1,
 343683196,
 70847,
 343872641,
 343218762,
 -1,
 -60288,
 343840667,
 70784,
 -1,
 343878295,
 70854,
 -60286,
 343842283,
 70855,
 -1,
 344022397,
 70853,
 -60284,
 336961700,
 11858,
 -1,
 344147763,
 128555,
 344331464,
 336876427,
 -1,
 344396997,
 344294050,
 -1,
 344462515,
 344388406,
 -1,
 344528046,
 344398410,
 11568,
 344593549,
 344472405,
 11575,
 344659084,
 344537941,
 11577,
 -1,
 344612284,
 11578,
 -1,
 344612284,
 11576,
 344855696,
 344585797,
 11619,
 -60273,
 344847941,
 11621,
 -1,
 344874428,
 11594,
 345052307,
 344838134,
 11612,
 -60270,
 345034742,
 11615,
 -1,
 345071036,
 11613,
 345248918,
 345031124,
 11609,
 -60267,
 345227732,
 11610,
 -1,
 345267644,
 11611,
 345445529,
 345208928,
 11581,
 345571327,
 345398716,
 11589,
 -1,
 345464252,
 11583,
 345642140,
 345397331,
 11571,
 345767935,
 345595324,
 11606,
 -1,
 345660860,
 11572,
 345838750,
 345617378,
 11604,
 -1,
 345813986,
 11605,
 345969824,
 345791932,
 11584,
 -1,
 345923004,
 11587,
 346100898,
 345909511,
 11569,
 -1,
 346054076,
 11570,
 -60253,
 346092342,
 11618,
 -60252,
 346221217,
 11617,
 -60251,
 346285466,
 11616,
 -60250,
 346337806,
 11591,
 -60249,
 346401232,
 11602,
 -60248,
 346460832,
 11599,
 -60247,
 346523980,
 11598,
 -60246,
 346586171,
 11597,
 -60245,
 346650433,
 11574,
 -60244,
 346706419,
 11580,
 -60243,
 346763846,
 11614,
 -1,
 346823242,
 11588,
 347018416,
 344474818,
 11622,
 -1,
 347009846,
 11579,
 -60239,
 347004091,
 11603,
 -60238,
 347118273,
 11623,
 -1,
 347170813,
 11593,
 347346111,
 344444918,
 -1,
 347411646,
 347332006,
 -1,
 347477175,
 347371616,
 11582,
 -1,
 347430332,
 11590,
 347608250,
 347428947,
 -1,
 -60231,
 347574944,
 11600,
 -1,
 347626940,
 11607,
 -60229,
 347600765,
 11596,
 -60228,
 347779598,
 11592,
 -60227,
 347837936,
 11601,
 -1,
 347889084,
 11586,
 -1,
 347351214,
 11620,
 348132546,
 347286300,
 -1,
 -60223,
 348092225,
 11573,
 -1,
 348151228,
 11585,
 348389375,
 348068426,
 -1,
 -60220,
 348320943,
 11608,
 -1,
 348347901,
 11595,
 -60218,
 344376484,
 11632,
 -60217,
 348491941,
 11631,
 -1,
 348534629,
 11647,
 348722398,
 344271687,
 -1,
 348787923,
 348687207,
 -1,
 348853453,
 348727559,
 -1,
 -60212,
 348834063,
 4048,
 -1,
 348879054,
 983208,
 -60210,
 348837924,
 4058,
 -60209,
 349018796,
 4050,
 -60208,
 349081681,
 4049,
 -60207,
 349142954,
 4057,
 -60206,
 349204598,
 4051,
 -1,
 349255184,
 4052,
 349443291,
 348766676,
 -1,
 349508824,
 349429223,
 -1,
 -60202,
 349473914,
 3982,
 -60201,
 349535958,
 3981,
 -1,
 349598327,
 3983,
 349831167,
 349465602,
 -1,
 -60198,
 349746809,
 4046,
 -1,
 349794935,
 3980,
 350027775,
 349405858,
 -1,
 -60195,
 349945968,
 3948,
 -1,
 349993791,
 3947,
 350164197,
 348684082,
 -1,
 350229732,
 350154320,
 -1,
 350295267,
 350175228,
 -1,
 -60190,
 350235373,
 11807,
 -1,
 350296994,
 11806,
 -1,
 350272819,
 11803,
 -1,
 350200456,
 11081,
 350622951,
 350116446,
 128005,
 -1,
 350552781,
 128047,
 -60184,
 350591596,
 68410,
 -60183,
 350719425,
 9202,
 -1,
 350762369,
 127915,
 350950798,
 336807106,
 -1,
 351016289,
 350935051,
 -1,
 351081726,
 350957480,
 -1,
 351147255,
 351050433,
 -1,
 351212788,
 351113888,
 -1,
 351278323,
 351195126,
 -1,
 -60175,
 351253915,
 119563,
 -60174,
 351292477,
 119582,
 -1,
 351345757,
 119573,
 -1,
 351259890,
 119608,
 351666175,
 351179141,
 -1,
 -60170,
 351561949,
 119634,
 -1,
 351620814,
 119630,
 351802620,
 351110825,
 -1,
 351868155,
 351749314,
 -1,
 -60166,
 351835544,
 119590,
 -1,
 351878033,
 119613,
 -1,
 351855591,
 119631,
 -60163,
 351756258,
 119585,
 -1,
 352078916,
 119558,
 352261388,
 351026005,
 -1,
 352326917,
 352217085,
 -1,
 352392451,
 352291148,
 -1,
 -60158,
 352358314,
 119625,
 -1,
 352415843,
 119612,
 -60156,
 352380737,
 119568,
 -1,
 352539430,
 119636,
 352720137,
 352273602,
 -1,
 -60153,
 352693162,
 119623,
 -60152,
 352735921,
 119567,
 -1,
 352793840,
 119586,
 -60150,
 352707927,
 119584,
 -60149,
 352953802,
 119619,
 -1,
 352986371,
 119624,
 353178901,
 352208066,
 -1,
 353244433,
 353145504,
 -1,
 -60145,
 353205793,
 119603,
 -60144,
 353254724,
 119583,
 -1,
 353319073,
 119600,
 -60142,
 353235635,
 119626,
 -60141,
 353489711,
 119610,
 -60140,
 353537047,
 119618,
 -1,
 353576612,
 119580,
 353768735,
 353154018,
 -1,
 353834270,
 353715394,
 -1,
 353899804,
 353812948,
 -1,
 353965339,
 353855485,
 -1,
 -60134,
 353946859,
 119579,
 -1,
 353975681,
 119596,
 -1,
 353939350,
 119598,
 -60131,
 353861592,
 119578,
 -1,
 354163725,
 119572,
 -1,
 353793505,
 119605,
 354424104,
 353718771,
 -1,
 354489635,
 354410427,
 -1,
 -60126,
 354456984,
 119595,
 -1,
 354484708,
 119559,
 354686246,
 354458305,
 -1,
 -60123,
 354667841,
 119638,
 -1,
 354715070,
 119576,
 -60121,
 354649038,
 119606,
 -1,
 354819715,
 119632,
 355013936,
 354402772,
 -1,
 355079470,
 354996214,
 -1,
 355145005,
 355048129,
 -1,
 -60116,
 355133068,
 119601,
 -1,
 355184629,
 119628,
 -1,
 355121250,
 119593,
 -60113,
 355037367,
 119621,
 -1,
 355356767,
 119627,
 355538230,
 354965587,
 -1,
 355603763,
 355477400,
 119592,
 -1,
 355533718,
 119615,
 -60108,
 355589531,
 119614,
 -60107,
 355710742,
 119602,
 -1,
 355769548,
 119599,
 355931452,
 355510736,
 -1,
 355996986,
 355867210,
 -1,
 -60103,
 355981937,
 119604,
 -1,
 356005270,
 119588,
 -60101,
 355984388,
 119594,
 -1,
 356141993,
 119571,
 356324673,
 355867210,
 -1,
 -60098,
 356303791,
 119564,
 -60097,
 356342466,
 119633,
 -60096,
 356402326,
 119577,
 -1,
 356462998,
 119617,
 356652357,
 356288844,
 -1,
 -60093,
 356611082,
 119560,
 -60092,
 356665006,
 119609,
 -1,
 356722395,
 119616,
 356914506,
 356613179,
 -1,
 356980041,
 356850250,
 -1,
 -60088,
 356969123,
 119597,
 -1,
 356986411,
 119637,
 -1,
 356927822,
 119589,
 357242190,
 356854023,
 -1,
 -60084,
 357217651,
 119566,
 -60083,
 357277046,
 119587,
 -1,
 357311920,
 119561,
 357504337,
 357231329,
 -1,
 -60080,
 357487048,
 119620,
 -1,
 357529004,
 119575,
 357700948,
 357472961,
 -1,
 -60077,
 357675060,
 119565,
 -1,
 357733040,
 119635,
 357897559,
 357660768,
 -1,
 -60074,
 357855487,
 119591,
 -1,
 357910629,
 119562,
 358094170,
 357854523,
 -1,
 -60071,
 358061437,
 119622,
 -1,
 358103251,
 119570,
 358290781,
 358047164,
 -1,
 -60068,
 358260124,
 119574,
 -1,
 358294760,
 119629,
 -60066,
 358282717,
 119569,
 -60065,
 358475371,
 119607,
 -60064,
 358539561,
 119611,
 -1,
 358578223,
 119581,
 358749572,
 350977083,
 -1,
 358815101,
 358735695,
 -1,
 358880623,
 358766409,
 -1,
 358946155,
 358862838,
 -1,
 359011688,
 358936775,
 -1,
 -60057,
 358980566,
 3194,
 -1,
 359026710,
 3197,
 359268351,
 358966954,
 -1,
 -60054,
 359177174,
 3195,
 -1,
 359223318,
 3198,
 359404910,
 358915928,
 -1,
 -60051,
 359373782,
 3193,
 -1,
 359419926,
 3196,
 -1,
 359397179,
 3192,
 359667062,
 358860763,
 -1,
 359732595,
 359610026,
 -1,
 -60046,
 359674005,
 3072,
 -1,
 359736271,
 3076,
 -60044,
 359717765,
 3199,
 -60043,
 359909239,
 3191,
 -1,
 359934070,
 3133,
 360125819,
 359629474,
 -1,
 -60040,
 360110631,
 3160,
 -60039,
 360169645,
 3162,
 -60038,
 360220061,
 3124,
 -1,
 360268981,
 3161,
 360513535,
 360114776,
 3170,
 -1,
 360414267,
 3171,
 360644607,
 358761666,
 -1,
 360650114,
 360557874,
 -1,
 360715649,
 360625951,
 128222,
 -1,
 360648271,
 128380,
 -1,
 360685253,
 128384,
 -60029,
 360638757,
 128250,
 -1,
 360891343,
 128301,
 361043336,
 358716064,
 -1,
 -60026,
 361025526,
 9978,
 -60025,
 361076572,
 127934,
 -1,
 361126385,
 8376,
 361305484,
 360979018,
 -1,
 -60022,
 361280547,
 128198,
 -60021,
 361344982,
 129750,
 -1,
 361380518,
 127861,
 -60019,
 361286858,
 129514,
 -1,
 361512184,
 129528,
 361698746,
 350903740,
 -1,
 361764266,
 361674670,
 -1,
 361829794,
 361693184,
 -1,
 361895318,
 361805321,
 -1,
 -60013,
 361872039,
 128487,
 -60012,
 361922592,
 128486,
 -60011,
 361966317,
 128485,
 -1,
 362027938,
 128484,
 362223003,
 361856059,
 -1,
 362288538,
 362180264,
 -1,
 -60007,
 362265255,
 9886,
 -1,
 362315808,
 9887,
 -1,
 362236209,
 11057,
 362550686,
 362167125,
 -1,
 -60003,
 362521802,
 8278,
 -1,
 362573040,
 10176,
 -60001,
 362531675,
 128491,
 -60000,
 362720989,
 128962,
 -59999,
 362780065,
 128423,
 -1,
 362819459,
 128433,
 363069439,
 361762642,
 -1,
 363074985,
 362953559,
 -1,
 363140519,
 363059097,
 -1,
 -59994,
 363117753,
 11162,
 -1,
 363168162,
 11160,
 -59992,
 363117562,
 11161,
 -1,
 363299073,
 11163,
 -1,
 363023007,
 11835,
 363533745,
 361719805,
 -1,
 363599280,
 363500192,
 -1,
 363664815,
 363528192,
 -1,
 -59986,
 363643678,
 128936,
 -1,
 363683075,
 128929,
 -1,
 363625195,
 129300,
 -1,
 363574882,
 129353,
 363992502,
 363519163,
 -1,
 364058037,
 363957365,
 -1,
 -59980,
 364044732,
 128077,
 -1,
 364069625,
 128078,
 -1,
 364024915,
 9928,
 364320185,
 363961025,
 -1,
 -59976,
 364306242,
 128173,
 -1,
 364353036,
 129652,
 -1,
 364269016,
 127777,
 364582367,
 361667265,
 -1,
 364647883,
 364560625,
 -1,
 364713418,
 364590345,
 -1,
 364778945,
 364648247,
 -1,
 -59969,
 364714187,
 127552,
 -59968,
 364779299,
 127560,
 -1,
 364844090,
 127557,
 365041092,
 364713991,
 -1,
 -59965,
 364976131,
 127558,
 -1,
 365040119,
 127556,
 365237703,
 364975682,
 -1,
 -59962,
 365177140,
 127555,
 -1,
 365237324,
 127559,
 365494271,
 365172287,
 -1,
 -59959,
 365369745,
 127554,
 -1,
 365433332,
 127553,
 -1,
 364674684,
 127274,
 365696471,
 364620242,
 -1,
 365762001,
 365649358,
 -1,
 365827536,
 365724441,
 -1,
 -59953,
 365806639,
 11833,
 -1,
 365833374,
 11210,
 -1,
 365809654,
 127913,
 -59950,
 365752206,
 128285,
 -59949,
 366073795,
 9184,
 -59948,
 366132012,
 11811,
 -59947,
 366193514,
 9180,
 -59946,
 366248046,
 11810,
 -1,
 366295776,
 9182,
 366482907,
 365664961,
 -1,
 366548442,
 366465869,
 129463,
 -1,
 366489309,
 129701,
 -1,
 366509777,
 129520,
 -59940,
 366450313,
 128069,
 -59939,
 366709755,
 127813,
 -59938,
 366771249,
 128508,
 -1,
 366832826,
 128701,
 367007228,
 364567739,
 -1,
 367072762,
 366982114,
 -1,
 367138294,
 367039738,
 -1,
 367203816,
 367116756,
 -1,
 367269350,
 367175447,
 -1,
 -59931,
 367258763,
 128597,
 -1,
 367281767,
 128599,
 -59929,
 367233724,
 8526,
 -1,
 367413946,
 11829,
 367597037,
 367147861,
 -1,
 367662572,
 367553521,
 -1,
 -59925,
 367652915,
 8586,
 -1,
 367683103,
 8587,
 -1,
 367599080,
 11832,
 367924720,
 367564862,
 -1,
 -59921,
 367914123,
 128596,
 -1,
 367937127,
 128598,
 368121331,
 367864971,
 -1,
 -59918,
 368101080,
 9930,
 -1,
 368159904,
 11202,
 -59916,
 368110997,
 9929,
 -59915,
 368286964,
 128399,
 -1,
 368326351,
 11826,
 368514553,
 367097952,
 -1,
 -59912,
 368473195,
 8378,
 -1,
 368529889,
 129411,
 -1,
 368498388,
 128034,
 -59909,
 367037507,
 129347,
 -1,
 368739506,
 127799,
 368907800,
 366982114,
 -1,
 368973318,
 368863229,
 -1,
 369038851,
 368911037,
 -1,
 369104386,
 369024941,
 -1,
 -59903,
 369082677,
 128208,
 -1,
 369120502,
 128681,
 -1,
 369065861,
 128710,
 -59900,
 369012205,
 11851,
 -59899,
 369311121,
 128305,
 -1,
 369374859,
 8285,
 369563150,
 368908874,
 -1,
 369628681,
 369527116,
 128650,
 -1,
 369557941,
 128651,
 369759756,
 369569704,
 -1,
 -59893,
 369743782,
 128668,
 -1,
 369785306,
 128434,
 -59891,
 369727776,
 11223,
 -1,
 369913147,
 128646,
 370087445,
 369531585,
 -1,
 370152980,
 370059728,
 -1,
 370218515,
 370108755,
 -1,
 -59886,
 370168953,
 128032,
 -1,
 370230288,
 127865,
 -1,
 370173914,
 127942,
 -1,
 370115960,
 128654,
 370606079,
 370072763,
 -1,
 -59881,
 370512250,
 127930,
 -1,
 370558250,
 11231,
 370742821,
 368896673,
 -1,
 370808356,
 370711233,
 -1,
 370873891,
 370737152,
 -1,
 370939422,
 370819064,
 -1,
 -59875,
 370917943,
 11818,
 -1,
 370935955,
 8282,
 -59873,
 370930043,
 128109,
 -59872,
 371116891,
 128490,
 -59871,
 371166610,
 128108,
 -59870,
 371220753,
 128149,
 -1,
 371273603,
 128432,
 -1,
 370806683,
 11834,
 -1,
 370767080,
 128256,
 371654655,
 370675538,
 -1,
 -59865,
 371574455,
 128085,
 -1,
 371636581,
 129430,
 371793885,
 225624532,
 -1,
 371858127,
 371746813,
 983080,
 371923461,
 371809322,
 -1,
 371988996,
 371913209,
 -1,
 372053922,
 371940796,
 -1,
 372119445,
 371989066,
 -1,
 372184980,
 372085813,
 -1,
 372250365,
 372134387,
 -1,
 372315865,
 372208868,
 121091,
 372441087,
 372244480,
 -1,
 372446864,
 372338147,
 120832,
 372572159,
 372375552,
 -1,
 372577890,
 372477524,
 120846,
 372703231,
 372506624,
 -1,
 372708937,
 372584360,
 -1,
 372774469,
 372678855,
 120853,
 372899839,
 372703232,
 -1,
 372905535,
 372823301,
 -1,
 372971070,
 372885375,
 120877,
 373096447,
 372899840,
 -1,
 -59843,
 372979547,
 120878,
 -1,
 373041913,
 120879,
 -1,
 372921918,
 120884,
 373298753,
 372859762,
 120857,
 -1,
 373230192,
 120882,
 373429827,
 373242553,
 120856,
 -1,
 373361230,
 120885,
 -59836,
 373395043,
 120855,
 -1,
 373517808,
 120854,
 373751807,
 372752337,
 -1,
 373757512,
 373638940,
 120858,
 -1,
 373688944,
 120883,
 -1,
 373687379,
 121001,
 373954133,
 372692223,
 120862,
 374079487,
 373882880,
 -1,
 374085199,
 373960616,
 -1,
 -59827,
 374071836,
 120872,
 -59826,
 374120656,
 120893,
 -1,
 374174601,
 120873,
 374347346,
 374037948,
 -1,
 -59823,
 374317420,
 120874,
 -1,
 374370323,
 120875,
 374543956,
 374285051,
 120895,
 -1,
 374474145,
 120894,
 -1,
 374483705,
 120866,
 374740571,
 373928930,
 -1,
 374806106,
 374697664,
 120966,
 374931455,
 374734848,
 -1,
 -59815,
 374814555,
 120972,
 -1,
 374876921,
 120971,
 -1,
 374742747,
 120849,
 375133789,
 374694770,
 120850,
 -1,
 375064982,
 120867,
 375264863,
 375073529,
 120848,
 -1,
 375196284,
 120865,
 -59808,
 375251396,
 120871,
 -59807,
 375377390,
 120864,
 -1,
 375424233,
 120996,
 375592577,
 372561157,
 -1,
 375658093,
 375572351,
 121052,
 375783423,
 375586816,
 -1,
 375789161,
 375706885,
 -1,
 -59801,
 375733888,
 121054,
 -59800,
 375797595,
 121055,
 -1,
 375859961,
 121056,
 376051308,
 375746025,
 -1,
 -59797,
 376005477,
 121059,
 -1,
 376056569,
 121057,
 -1,
 375991786,
 121058,
 376313463,
 375599016,
 -1,
 376378997,
 376298683,
 -1,
 376444532,
 376353762,
 -1,
 376510067,
 376432315,
 -1,
 -59790,
 376496310,
 121066,
 -1,
 376533254,
 121064,
 -1,
 376472441,
 121063,
 -1,
 376418299,
 120887,
 376897535,
 376337230,
 121067,
 -1,
 376781701,
 120892,
 376968827,
 376267908,
 121062,
 377094143,
 376915789,
 -1,
 -59782,
 377020755,
 120881,
 -1,
 377054066,
 120899,
 377230974,
 376919622,
 -1,
 -59779,
 377212344,
 121060,
 -1,
 377236217,
 121061,
 377487359,
 377168642,
 -1,
 -59776,
 377399039,
 120890,
 -1,
 377449794,
 120891,
 377624198,
 375546738,
 120843,
 377749503,
 377552896,
 -1,
 377755269,
 377655088,
 120852,
 -1,
 377686640,
 120870,
 -1,
 377718531,
 120844,
 377951882,
 377610627,
 120851,
 378077183,
 377883206,
 -1,
 -59767,
 377997183,
 120868,
 -1,
 378025819,
 120869,
 378214029,
 377926626,
 -1,
 -59764,
 378171250,
 121018,
 -1,
 378216141,
 120841,
 378410639,
 378153721,
 120838,
 -1,
 378340966,
 120861,
 -1,
 378354361,
 120842,
 378607271,
 372430079,
 121077,
 378732543,
 378535936,
 -1,
 378738329,
 378659004,
 -1,
 378803862,
 378720246,
 -1,
 -59755,
 378794172,
 121086,
 -1,
 378824349,
 121088,
 -59753,
 378766584,
 120979,
 -59752,
 378957296,
 120840,
 -1,
 379016926,
 121089,
 379197086,
 378678107,
 -1,
 379262620,
 379153915,
 121083,
 -1,
 379193793,
 120876,
 -59747,
 379239753,
 121085,
 -1,
 379358929,
 121084,
 379524770,
 379176836,
 -1,
 -59744,
 379469440,
 121079,
 -59743,
 379533147,
 121080,
 -1,
 379595513,
 121081,
 379786917,
 379496269,
 -1,
 -59740,
 379771982,
 121087,
 -1,
 379803422,
 121090,
 -59738,
 379740520,
 121078,
 -1,
 379934270,
 121082,
 380114621,
 378572379,
 -1,
 380180149,
 380097797,
 -1,
 380245678,
 380121000,
 -1,
 380311213,
 380203920,
 -1,
 -59732,
 380297555,
 120888,
 -1,
 380330866,
 120889,
 -1,
 380297762,
 120886,
 380573363,
 380183298,
 -1,
 380638898,
 380544756,
 -1,
 -59727,
 380625235,
 120896,
 -1,
 380647783,
 120897,
 -1,
 380595808,
 120898,
 -59724,
 380536041,
 121035,
 -1,
 380855473,
 120880,
 381032119,
 380166483,
 121030,
 -1,
 380963440,
 121033,
 381163194,
 381006818,
 -1,
 -59719,
 381120370,
 121037,
 -1,
 381165261,
 121032,
 -59717,
 381125865,
 121036,
 -59716,
 381305471,
 121028,
 -1,
 381364990,
 120860,
 381556428,
 380077296,
 -1,
 381621956,
 381502079,
 120974,
 381747199,
 381550592,
 -1,
 381753027,
 381664833,
 -1,
 -59710,
 381734328,
 120975,
 -1,
 381762330,
 120976,
 -1,
 381723920,
 120977,
 382015175,
 381603830,
 -1,
 -59706,
 381986255,
 120985,
 -1,
 382035815,
 120986,
 382211785,
 381971939,
 120992,
 -1,
 382143039,
 120988,
 -59702,
 382198099,
 120978,
 -59701,
 382317813,
 120983,
 -1,
 382348025,
 120984,
 382539479,
 381533485,
 -1,
 382605009,
 382504532,
 121012,
 382730239,
 382533632,
 -1,
 -59696,
 382645508,
 121014,
 -1,
 382678875,
 121013,
 -59694,
 382591315,
 121006,
 -59693,
 382850303,
 121016,
 -59692,
 382907637,
 121007,
 -59691,
 382960873,
 121008,
 -59690,
 383020515,
 121015,
 -1,
 383074943,
 121003,
 -59688,
 382493032,
 121092,
 -1,
 383211266,
 120906,
 383451135,
 372276812,
 120922,
 383516671,
 383320064,
 -1,
 383522539,
 383406579,
 -1,
 383588069,
 383481341,
 120908,
 383713279,
 383516672,
 -1,
 383719138,
 383607666,
 120919,
 383844351,
 383647744,
 -1,
 -59679,
 383767834,
 120920,
 -1,
 383817690,
 120921,
 -59677,
 383702284,
 120914,
 -59676,
 383932034,
 120910,
 -1,
 383986425,
 120912,
 384237567,
 383559211,
 120900,
 384303103,
 384106496,
 -1,
 384308969,
 384186203,
 120903,
 -1,
 384240015,
 120904,
 -59670,
 384263026,
 120902,
 -1,
 384379641,
 120901,
 384571121,
 383503273,
 -1,
 384636655,
 384512470,
 120930,
 384761855,
 384567920,
 120931,
 -1,
 384631151,
 120932,
 -59664,
 384599273,
 120933,
 -1,
 384790095,
 120929,
 384964344,
 384524648,
 120924,
 385089535,
 384892928,
 -1,
 385095415,
 384980160,
 120909,
 385220607,
 385024000,
 -1,
 -59658,
 385111682,
 120911,
 -1,
 385166073,
 120913,
 -1,
 385078554,
 120926,
 385423100,
 384947461,
 -1,
 -59654,
 385402751,
 120925,
 -59653,
 385439294,
 120928,
 -1,
 385493753,
 120927,
 -1,
 385362821,
 120923,
 385750841,
 372191144,
 -1,
 385816344,
 385735867,
 -1,
 385881875,
 385788368,
 120941,
 386007039,
 385810432,
 -1,
 386012935,
 385917451,
 120940,
 386138111,
 385941504,
 -1,
 386144006,
 386061573,
 -1,
 -59643,
 386123647,
 120942,
 -1,
 386160190,
 120946,
 -1,
 386111450,
 120944,
 386406156,
 385969635,
 120834,
 386531327,
 386334720,
 -1,
 386537227,
 386454783,
 121068,
 -1,
 386467200,
 121069,
 -1,
 386514249,
 121024,
 386733839,
 386389253,
 -1,
 -59634,
 386713471,
 120943,
 -1,
 386750014,
 120947,
 386930449,
 386684096,
 120915,
 -1,
 386860416,
 120916,
 -59630,
 386897882,
 120945,
 -1,
 387026653,
 121040,
 387252223,
 385859325,
 120949,
 387317759,
 387121152,
 -1,
 -59626,
 387228171,
 120948,
 -59625,
 387288845,
 121039,
 -1,
 387345947,
 121020,
 387520303,
 385774414,
 120950,
 387645439,
 387448832,
 -1,
 387651367,
 387542499,
 120833,
 387776511,
 387579904,
 -1,
 387782436,
 387681876,
 120847,
 387907583,
 387710976,
 -1,
 387913505,
 387791168,
 -1,
 -59616,
 387860252,
 120859,
 -1,
 387908691,
 121002,
 -59614,
 387896575,
 120863,
 -59613,
 388087080,
 120967,
 -1,
 388138217,
 120997,
 -59611,
 387759433,
 121019,
 -59610,
 388260709,
 120845,
 -1,
 388311801,
 120839,
 388503339,
 387616347,
 -1,
 388568874,
 388480329,
 121038,
 -1,
 388497775,
 121045,
 -1,
 388555091,
 121031,
 388765486,
 388465904,
 -1,
 -59603,
 388751699,
 120980,
 -1,
 388787683,
 120993,
 -1,
 388742473,
 121009,
 389087231,
 387481270,
 120934,
 389152767,
 388956160,
 -1,
 389158708,
 389076229,
 -1,
 -59597,
 389138303,
 120935,
 -1,
 389174846,
 120937,
 389355318,
 389123824,
 121046,
 -1,
 389286232,
 121047,
 -59593,
 389322714,
 120936,
 -59592,
 389443120,
 121065,
 -1,
 389502699,
 120905,
 389683057,
 385703356,
 -1,
 389748579,
 389640206,
 120957,
 389873663,
 389677056,
 -1,
 389879627,
 389770723,
 120836,
 390004735,
 389808128,
 -1,
 390010693,
 389928191,
 121072,
 390135807,
 389939200,
 -1,
 390141763,
 390054356,
 -1,
 -59582,
 390105736,
 121073,
 -1,
 390162909,
 121053,
 -59580,
 390111755,
 121070,
 -1,
 390299077,
 121071,
 390469449,
 389975643,
 -1,
 390534984,
 390446376,
 120968,
 -1,
 390463986,
 120973,
 -1,
 390497513,
 120998,
 -59574,
 390446409,
 121025,
 -1,
 390685554,
 121051,
 390862673,
 389849611,
 120955,
 390987775,
 390791168,
 -1,
 390993744,
 390911237,
 -1,
 -59569,
 390973311,
 120959,
 -1,
 391009854,
 120956,
 -1,
 390961114,
 120961,
 391255894,
 390825193,
 120970,
 391380991,
 391184384,
 -1,
 391386965,
 391278051,
 120994,
 -1,
 391318079,
 120989,
 -1,
 391369983,
 120987,
 391583578,
 391238917,
 -1,
 391649113,
 391563135,
 120960,
 -1,
 391580568,
 120963,
 -1,
 391588721,
 120964,
 391845724,
 391560488,
 120999,
 -1,
 391774851,
 121004,
 391976798,
 391810644,
 121029,
 -1,
 391907539,
 121041,
 392107873,
 391926259,
 -1,
 -59552,
 392078903,
 120907,
 -1,
 392132112,
 120917,
 -59550,
 392087883,
 120958,
 -1,
 392271834,
 120962,
 392495103,
 389718376,
 120939,
 392560639,
 392364032,
 -1,
 392566635,
 392466011,
 -1,
 392632170,
 392543573,
 121050,
 392757247,
 392560640,
 -1,
 -59543,
 392668893,
 121048,
 -1,
 392719675,
 121049,
 -1,
 392615167,
 121034,
 392959855,
 392523272,
 -1,
 -59539,
 392945846,
 121023,
 -59538,
 392996573,
 121021,
 -1,
 393047355,
 121022,
 -59536,
 392936858,
 121017,
 -1,
 393165520,
 120938,
 393353098,
 389620469,
 120965,
 393478143,
 393281536,
 -1,
 393484158,
 393375203,
 120837,
 393609215,
 393412608,
 -1,
 393615225,
 393532671,
 121076,
 393740287,
 393543680,
 -1,
 -59528,
 393651933,
 121074,
 -1,
 393702715,
 121075,
 393877371,
 393592137,
 121027,
 -1,
 393807265,
 121026,
 394067967,
 393842267,
 -1,
 -59523,
 393985320,
 120969,
 -1,
 394036457,
 121000,
 394205059,
 393446640,
 -1,
 394270594,
 394161635,
 120995,
 394395647,
 394201693,
 120991,
 -1,
 394266017,
 120990,
 -1,
 394256723,
 120982,
 394532743,
 394170077,
 121044,
 394657791,
 394461184,
 -1,
 -59514,
 394569437,
 121042,
 -1,
 394620219,
 121043,
 394854399,
 394509613,
 -1,
 -59511,
 394757353,
 121011,
 -1,
 394805930,
 121005,
 395051007,
 393324338,
 120951,
 395116543,
 394919936,
 -1,
 395122575,
 395040005,
 -1,
 -59506,
 395102079,
 120952,
 -1,
 395138622,
 120954,
 -59504,
 395099465,
 121010,
 -59503,
 395286490,
 120953,
 -59502,
 395347192,
 120981,
 -59501,
 395406819,
 120835,
 -1,
 395465920,
 120918,
 -1,
 372142898,
 121451,
 395771903,
 372065805,
 121343,
 395837439,
 395640832,
 -1,
 395843489,
 395743546,
 -1,
 395909024,
 395775826,
 -1,
 395974557,
 395897595,
 -1,
 -59493,
 395957737,
 121346,
 -59492,
 396021176,
 121345,
 -1,
 396049165,
 121348,
 396296191,
 395924822,
 -1,
 -59489,
 396217784,
 121347,
 -1,
 396245773,
 121349,
 -1,
 395837924,
 121350,
 -1,
 395820319,
 121344,
 396564700,
 372019304,
 -1,
 396630198,
 396551939,
 -1,
 396695581,
 396618491,
 -1,
 396761032,
 396636072,
 -1,
 396826558,
 396747904,
 -1,
 396892091,
 396754944,
 -1,
 396957617,
 396844476,
 -1,
 397023150,
 396894189,
 -1,
 397088684,
 396983749,
 121230,
 -1,
 397069479,
 121231,
 -59475,
 397068619,
 121228,
 -1,
 397184202,
 121229,
 397410303,
 396981721,
 -1,
 -59472,
 397301693,
 121254,
 -1,
 397357892,
 121261,
 397547446,
 396931822,
 -1,
 397612980,
 397508037,
 121226,
 -1,
 397593767,
 121227,
 -59467,
 397592907,
 121224,
 -1,
 397708490,
 121225,
 397934591,
 397529933,
 -1,
 397940666,
 397850612,
 -1,
 -59463,
 397920587,
 121232,
 -1,
 397970634,
 121233,
 -1,
 397888292,
 121247,
 398262271,
 396835703,
 -1,
 -59459,
 398182731,
 121248,
 -1,
 398232778,
 121249,
 398399427,
 396796962,
 -1,
 -59456,
 398379339,
 121147,
 -59455,
 398442531,
 121150,
 -59454,
 398494922,
 121148,
 -1,
 398556613,
 121149,
 398727111,
 398352726,
 -1,
 -59451,
 398707019,
 121151,
 -59450,
 398757066,
 121152,
 -1,
 398818757,
 121153,
 -1,
 398704593,
 121139,
 399054813,
 396749473,
 -1,
 399120346,
 398993535,
 -1,
 399185875,
 399063827,
 -1,
 399251407,
 399169964,
 -1,
 -59443,
 399231307,
 121244,
 -59442,
 399281354,
 121245,
 -1,
 399343045,
 121246,
 399572991,
 399196441,
 -1,
 -59439,
 399493451,
 121241,
 -59438,
 399543498,
 121242,
 -1,
 399605189,
 121243,
 399775703,
 399130259,
 -1,
 -59435,
 399755595,
 121268,
 -59434,
 399805642,
 121269,
 -1,
 399867333,
 121270,
 400097279,
 399729619,
 -1,
 -59431,
 399988669,
 121257,
 -1,
 400044868,
 121264,
 400293887,
 399097469,
 -1,
 -59428,
 400214123,
 121325,
 -1,
 400245010,
 121326,
 400431078,
 399032788,
 -1,
 400496613,
 400388138,
 -1,
 400562148,
 400477633,
 -1,
 400627682,
 400522693,
 121132,
 -1,
 400608423,
 121133,
 -59421,
 400607563,
 121130,
 -1,
 400723146,
 121131,
 -1,
 400552430,
 121134,
 -1,
 400449115,
 121253,
 401020910,
 400393891,
 -1,
 401086441,
 401000779,
 121237,
 -1,
 401015419,
 121240,
 401217516,
 401040339,
 -1,
 -59413,
 401168317,
 121256,
 -1,
 401224516,
 121263,
 -59411,
 401181898,
 121238,
 -1,
 401374661,
 121239,
 401545207,
 400959751,
 -1,
 401610739,
 401516936,
 -1,
 -59407,
 401590603,
 121154,
 -59406,
 401640650,
 121155,
 -1,
 401702341,
 121156,
 401932287,
 401558386,
 -1,
 -59403,
 401852747,
 121144,
 -59402,
 401902794,
 121145,
 -1,
 401964485,
 121146,
 402135038,
 401500012,
 -1,
 402200571,
 402088915,
 -1,
 -59398,
 402151357,
 121255,
 -1,
 402207556,
 121262,
 -59396,
 402180427,
 121234,
 -59395,
 402361546,
 121235,
 -1,
 402423237,
 121236,
 402593795,
 402119084,
 -1,
 402659329,
 402530480,
 121142,
 -1,
 402591546,
 121143,
 -59390,
 402649582,
 121141,
 -1,
 402771403,
 121140,
 402921480,
 402538777,
 -1,
 402987014,
 402858160,
 121137,
 -1,
 402919226,
 121138,
 -59385,
 402977262,
 121136,
 -1,
 403099064,
 121135,
 403249167,
 402859306,
 -1,
 403314700,
 403229009,
 -1,
 -59381,
 403294315,
 121315,
 -1,
 403325202,
 121317,
 403570687,
 403279057,
 -1,
 -59378,
 403490923,
 121316,
 -1,
 403521810,
 121318,
 403707923,
 403240892,
 -1,
 -59375,
 403687755,
 121157,
 -59374,
 403737802,
 121158,
 -1,
 403799493,
 121159,
 403970071,
 403680263,
 -1,
 -59371,
 403949899,
 121160,
 -59370,
 403999946,
 121161,
 -1,
 404061637,
 121162,
 404232220,
 403919900,
 -1,
 404297755,
 404190129,
 -1,
 -59366,
 404277355,
 121329,
 -1,
 404308242,
 121330,
 -1,
 404267311,
 121128,
 -1,
 404191113,
 121448,
 404625557,
 396645718,
 -1,
 404690994,
 404565928,
 -1,
 404756524,
 404677765,
 -1,
 404822055,
 404710355,
 -1,
 404887588,
 404772175,
 -1,
 -59357,
 404867403,
 121286,
 -1,
 404913605,
 121287,
 405143551,
 404828617,
 -1,
 -59354,
 405064011,
 121271,
 -1,
 405110213,
 121272,
 405280809,
 404782533,
 121303,
 -1,
 405261479,
 121304,
 -59350,
 405260619,
 121301,
 -59349,
 405376202,
 121302,
 -1,
 405419681,
 121305,
 405608496,
 404726818,
 -1,
 -59346,
 405588299,
 121204,
 -59345,
 405638346,
 121205,
 -1,
 405700037,
 121206,
 -59343,
 405585873,
 121198,
 -1,
 405823825,
 121207,
 406001730,
 404679329,
 -1,
 406067263,
 405940351,
 -1,
 406132795,
 406021075,
 -1,
 406198328,
 406082895,
 -1,
 -59337,
 406178123,
 121296,
 -1,
 406224325,
 121297,
 406454271,
 406139337,
 -1,
 -59334,
 406374731,
 121281,
 -1,
 406420933,
 121282,
 406591550,
 406110676,
 -1,
 -59331,
 406557488,
 121308,
 -1,
 406620808,
 121309,
 -1,
 406552005,
 121310,
 406913023,
 406044304,
 -1,
 -59327,
 406833259,
 121327,
 -1,
 406864146,
 121328,
 407050323,
 405964451,
 -1,
 407115858,
 407004115,
 -1,
 407181387,
 407065935,
 -1,
 407246920,
 407161169,
 -1,
 -59321,
 407226475,
 121292,
 -1,
 407257362,
 121294,
 407502847,
 407207371,
 -1,
 -59318,
 407423083,
 121293,
 -1,
 407453970,
 121295,
 407699455,
 407122377,
 -1,
 407705679,
 407619921,
 -1,
 -59314,
 407685227,
 121277,
 -1,
 407716114,
 121279,
 407961599,
 407666123,
 -1,
 -59311,
 407881835,
 121278,
 -1,
 407912722,
 121280,
 -1,
 407095627,
 121307,
 408164451,
 407005036,
 -1,
 408229986,
 408118227,
 -1,
 408295515,
 408180047,
 -1,
 408361049,
 408279468,
 -1,
 -59304,
 408341074,
 121290,
 -1,
 408387092,
 121291,
 -59302,
 408340960,
 121288,
 -1,
 408518098,
 121289,
 408748031,
 408236489,
 -1,
 408754271,
 408668497,
 -1,
 -59298,
 408738213,
 121275,
 -1,
 408764690,
 121273,
 409010175,
 408714699,
 -1,
 -59295,
 408934821,
 121276,
 -1,
 408961298,
 121274,
 -1,
 408209739,
 121306,
 409213036,
 408142292,
 -1,
 409278571,
 409169962,
 -1,
 409344106,
 409259457,
 -1,
 409409640,
 409304517,
 121191,
 -1,
 409390247,
 121192,
 -59287,
 409389387,
 121189,
 -1,
 409504970,
 121190,
 -1,
 409334254,
 121193,
 -1,
 409230946,
 121314,
 409802870,
 409150774,
 -1,
 409868400,
 409782609,
 -1,
 -59281,
 409847915,
 121319,
 -1,
 409878802,
 121322,
 410065011,
 409832657,
 -1,
 -59278,
 410044523,
 121320,
 -1,
 410075410,
 121323,
 410320895,
 410025419,
 -1,
 -59275,
 410241131,
 121321,
 -1,
 410272018,
 121324,
 410458236,
 409786796,
 -1,
 410523770,
 410394812,
 -1,
 -59271,
 410513902,
 121202,
 -1,
 410554682,
 121201,
 -59269,
 410513902,
 121200,
 -1,
 410701259,
 121199,
 410851457,
 410403097,
 -1,
 410916991,
 410788016,
 121196,
 -1,
 410849082,
 121197,
 -59264,
 410907118,
 121195,
 -1,
 411028920,
 121194,
 411179143,
 410790151,
 -1,
 411244678,
 411150728,
 -1,
 -59260,
 411224395,
 121208,
 -59259,
 411274442,
 121209,
 -1,
 411336133,
 121210,
 -1,
 411192174,
 121203,
 411572363,
 411170748,
 -1,
 -59255,
 411552075,
 121211,
 -59254,
 411602122,
 121212,
 -1,
 411663813,
 121213,
 411834511,
 411544583,
 -1,
 -59251,
 411814219,
 121214,
 -59250,
 411864266,
 121215,
 -1,
 411925957,
 121216,
 412096660,
 411784220,
 -1,
 412162195,
 412054457,
 -1,
 -59246,
 412141675,
 121331,
 -1,
 412172562,
 121332,
 -1,
 412131631,
 121129,
 -1,
 412055433,
 121449,
 412489899,
 404569737,
 -1,
 412555425,
 412429147,
 -1,
 412620956,
 412538873,
 -1,
 412686490,
 412581317,
 121187,
 -1,
 412667047,
 121188,
 -59237,
 412666187,
 121185,
 -1,
 412781770,
 121186,
 413007871,
 412559528,
 -1,
 413014175,
 412908997,
 121183,
 -1,
 412994727,
 121184,
 -59232,
 412993867,
 121181,
 -1,
 413109450,
 121182,
 413276326,
 412538873,
 -1,
 413341860,
 413236677,
 121179,
 -1,
 413322407,
 121180,
 -59227,
 413321547,
 121177,
 -1,
 413437130,
 121178,
 413663231,
 413214888,
 -1,
 413669545,
 413564357,
 121175,
 -1,
 413650087,
 121176,
 -59222,
 413649227,
 121173,
 -1,
 413764810,
 121174,
 413990911,
 412443499,
 -1,
 413997236,
 413917526,
 -1,
 414062771,
 413942404,
 -1,
 414128305,
 413999292,
 -1,
 -59216,
 414107979,
 121126,
 -1,
 414154181,
 121125,
 -59214,
 414107979,
 121122,
 -1,
 414285253,
 121121,
 -1,
 414041306,
 121123,
 -59211,
 413976458,
 121127,
 -1,
 414466793,
 121124,
 414711807,
 396617006,
 -1,
 414718147,
 414622224,
 -1,
 414783676,
 414693212,
 121418,
 414908415,
 414711808,
 -1,
 -59205,
 414839867,
 121420,
 -1,
 414904795,
 121419,
 415045824,
 414754610,
 121415,
 415170559,
 414973952,
 -1,
 -59201,
 415102011,
 121417,
 -1,
 415166939,
 121416,
 -59199,
 415035867,
 121414,
 -59198,
 415258174,
 121413,
 -1,
 415314963,
 121412,
 415504585,
 414658472,
 -1,
 415570120,
 415467181,
 -1,
 -59194,
 415536565,
 121403,
 -59193,
 415585854,
 121404,
 -1,
 415643633,
 121405,
 -1,
 415540265,
 121430,
 415897805,
 415486654,
 121424,
 416022527,
 415825920,
 -1,
 -59188,
 415944467,
 121426,
 -1,
 415979070,
 121425,
 416159953,
 415877781,
 121406,
 416284671,
 416088064,
 -1,
 -59184,
 416215515,
 121407,
 -1,
 416260619,
 121408,
 416422101,
 416119576,
 121421,
 416546815,
 416350208,
 -1,
 -59180,
 416477659,
 121423,
 -1,
 416503358,
 121422,
 416684249,
 416372680,
 121409,
 416808959,
 416612352,
 -1,
 -59176,
 416739803,
 121410,
 -1,
 416784907,
 121411,
 417005567,
 416674276,
 -1,
 -59173,
 416925803,
 121431,
 -1,
 416956690,
 121432,
 417143067,
 396546038,
 -1,
 417208568,
 417117689,
 -1,
 417274093,
 417196795,
 -1,
 417339624,
 417251372,
 -1,
 417405156,
 417327867,
 -1,
 -59166,
 417384555,
 121163,
 -59165,
 417415442,
 121164,
 -1,
 417472688,
 121165,
 417726463,
 417355094,
 -1,
 -59162,
 417646699,
 121166,
 -59161,
 417677586,
 121167,
 -1,
 417734832,
 121168,
 417929452,
 417277273,
 -1,
 -59158,
 417913253,
 121172,
 -59157,
 417974379,
 121170,
 -1,
 418005266,
 121171,
 -1,
 417908182,
 121169,
 418316287,
 417224022,
 -1,
 418322679,
 418234412,
 -1,
 418388211,
 418310907,
 -1,
 -59151,
 418367595,
 121220,
 -59150,
 418398482,
 121221,
 -1,
 418455728,
 121222,
 418709503,
 418338134,
 -1,
 -59147,
 418629739,
 121217,
 -59146,
 418660626,
 121218,
 -1,
 418717872,
 121219,
 -1,
 418301398,
 121223,
 418978061,
 417176257,
 -1,
 419043588,
 418944654,
 -1,
 419109117,
 419026583,
 -1,
 -59140,
 419092447,
 121436,
 -1,
 419113828,
 121435,
 419305728,
 419049949,
 -1,
 -59137,
 419286368,
 121439,
 -1,
 419328269,
 121440,
 -59135,
 419286381,
 121433,
 -59134,
 419467587,
 121438,
 -59133,
 419529580,
 121434,
 -1,
 419590426,
 121437,
 419764488,
 419028682,
 -1,
 -59130,
 419743851,
 121093,
 -59129,
 419795453,
 121094,
 -1,
 419834707,
 121095,
 420085759,
 419741897,
 -1,
 420092172,
 420014843,
 -1,
 -59125,
 420072925,
 121458,
 -1,
 420100897,
 121459,
 -1,
 420042099,
 121460,
 420413439,
 418923714,
 -1,
 420419863,
 420302538,
 121441,
 420544511,
 420347904,
 -1,
 420550933,
 420454017,
 -1,
 420616467,
 420534113,
 121443,
 -1,
 420545770,
 121444,
 420806655,
 420578486,
 121445,
 -1,
 420676842,
 121446,
 -59114,
 420516154,
 121442,
 -1,
 420818033,
 121447,
 421068799,
 420387057,
 -1,
 -59111,
 420974164,
 121390,
 -59110,
 421037827,
 121391,
 -1,
 421094082,
 121389,
 421271886,
 417117154,
 -1,
 421337418,
 421242115,
 -1,
 421402937,
 421269330,
 -1,
 421468460,
 421391099,
 -1,
 421533987,
 421447787,
 121250,
 421658623,
 421462893,
 -1,
 -59102,
 421550013,
 121258,
 -1,
 421606212,
 121265,
 421796135,
 421478674,
 121251,
 421920767,
 421725037,
 -1,
 -59098,
 421812157,
 121259,
 -1,
 421868356,
 121266,
 422117375,
 421732470,
 -1,
 422123819,
 422014804,
 -1,
 -59094,
 422074301,
 121260,
 -1,
 422130500,
 121267,
 -1,
 422069442,
 121252,
 422445055,
 421418326,
 -1,
 422451505,
 422365291,
 121311,
 422576127,
 422380397,
 -1,
 -59088,
 422466889,
 121298,
 -1,
 422523329,
 121283,
 422713653,
 422396178,
 121312,
 422838271,
 422642541,
 -1,
 -59084,
 422729033,
 121299,
 -1,
 422785473,
 121284,
 423034879,
 422650032,
 121313,
 423100415,
 422904685,
 -1,
 -59080,
 422991177,
 121300,
 -1,
 423047617,
 121285,
 423297023,
 421332191,
 -1,
 423303490,
 423170555,
 -1,
 -59076,
 423237431,
 121519,
 -59075,
 423302722,
 121518,
 -59074,
 423368046,
 121517,
 -59073,
 423433296,
 121516,
 -59072,
 423498539,
 121515,
 -59071,
 423563771,
 121514,
 -1,
 423629035,
 121513,
 -59069,
 423238040,
 121512,
 -59068,
 423762151,
 121511,
 -59067,
 423827463,
 121510,
 -59066,
 423892791,
 121509,
 -59065,
 423958082,
 121508,
 -59064,
 424023406,
 121507,
 -59063,
 424088656,
 121506,
 -1,
 424153899,
 121505,
 424411135,
 421322171,
 -1,
 -59060,
 424331371,
 121105,
 -59059,
 424382973,
 121106,
 -1,
 424422227,
 121107,
 424614264,
 421217474,
 -1,
 424679798,
 424604740,
 -1,
 424745311,
 424630675,
 -1,
 424810841,
 424733435,
 -1,
 424876374,
 424791480,
 121377,
 425000959,
 424804352,
 -1,
 -59051,
 424886546,
 121378,
 -1,
 424943792,
 121379,
 425197567,
 424816552,
 -1,
 -59048,
 425125003,
 121383,
 -1,
 425161678,
 121385,
 425394175,
 424760662,
 -1,
 425400670,
 425315768,
 121380,
 425525247,
 425328640,
 -1,
 -59043,
 425410834,
 121381,
 -1,
 425468080,
 121382,
 -1,
 425343770,
 121384,
 425728361,
 424722902,
 -1,
 425793891,
 425717221,
 -1,
 -59038,
 425760574,
 121372,
 -1,
 425788800,
 121370,
 425990502,
 425746062,
 -1,
 -59035,
 425959947,
 121369,
 -1,
 425997764,
 121371,
 -59033,
 425970693,
 121365,
 -59032,
 426156555,
 121364,
 -1,
 426194372,
 121366,
 426383725,
 425688623,
 -1,
 -59029,
 426369363,
 121374,
 -59028,
 426399141,
 121376,
 -1,
 426459775,
 121375,
 426645873,
 426323661,
 -1,
 -59025,
 426631507,
 121354,
 -59024,
 426677685,
 121355,
 -1,
 426721919,
 121356,
 426967039,
 426573824,
 -1,
 426973557,
 426847510,
 -1,
 -59020,
 426952811,
 121367,
 -1,
 427004413,
 121368,
 -1,
 426962478,
 121373,
 -59017,
 424669808,
 121452,
 -1,
 427173392,
 121392,
 427366805,
 424574011,
 -1,
 427432329,
 427321341,
 -1,
 427497860,
 427396107,
 -1,
 427563395,
 427459165,
 -1,
 -59011,
 427497479,
 121469,
 -59010,
 427562807,
 121468,
 -59009,
 427628098,
 121467,
 -59008,
 427693422,
 121466,
 -59007,
 427758672,
 121465,
 -59006,
 427823915,
 121464,
 -1,
 427889147,
 121463,
 -1,
 427505301,
 121462,
 428212223,
 427469264,
 -1,
 428218760,
 428081152,
 -1,
 -59001,
 428204802,
 121429,
 -1,
 428247057,
 121428,
 -1,
 428196434,
 121427,
 428539903,
 427400069,
 -1,
 428546450,
 428408832,
 -1,
 428611982,
 428499071,
 -1,
 -58995,
 428567388,
 121473,
 -1,
 428612756,
 121476,
 -58993,
 428600810,
 121474,
 -58992,
 428791736,
 121477,
 -58991,
 428835915,
 121478,
 -1,
 428883404,
 121475,
 429129727,
 428478290,
 -1,
 -58988,
 429058850,
 121471,
 -1,
 429086050,
 121472,
 429267378,
 427315699,
 -1,
 429332897,
 429227067,
 -1,
 429398432,
 429287801,
 -1,
 429463965,
 429375956,
 -1,
 429529500,
 429427341,
 -1,
 -58981,
 429508715,
 121116,
 -1,
 429560317,
 121118,
 -1,
 429477119,
 121119,
 429850623,
 429424075,
 -1,
 -58977,
 429770859,
 121115,
 -1,
 429822461,
 121117,
 -1,
 429367721,
 121456,
 430053801,
 429287421,
 -1,
 430119336,
 430015783,
 -1,
 -58972,
 430053175,
 121503,
 -58971,
 430118466,
 121502,
 -58970,
 430183790,
 121501,
 -58969,
 430249040,
 121500,
 -1,
 430314283,
 121499,
 -1,
 430085719,
 121470,
 430578093,
 430023586,
 -1,
 -58965,
 430567899,
 121363,
 -58964,
 430609845,
 121361,
 -1,
 430651377,
 121362,
 430840241,
 430513128,
 -1,
 430905776,
 430825887,
 121352,
 -1,
 430836364,
 121353,
 -1,
 430855765,
 121351,
 -1,
 430825407,
 121480,
 431167946,
 429244884,
 -1,
 431233469,
 431141738,
 -1,
 431299001,
 431210964,
 -1,
 431364536,
 431262349,
 -1,
 -58953,
 431343723,
 121111,
 -1,
 431395325,
 121113,
 -1,
 431312127,
 121114,
 431626684,
 431259083,
 -1,
 -58949,
 431605867,
 121110,
 -1,
 431657469,
 121112,
 -1,
 431576369,
 121120,
 431888833,
 431217042,
 -1,
 -58945,
 431868011,
 121099,
 -58944,
 431919613,
 121100,
 -1,
 431958867,
 121101,
 432150982,
 431842779,
 -1,
 432216517,
 432104331,
 -1,
 -58940,
 432196479,
 121453,
 -1,
 432254912,
 121454,
 -1,
 432199150,
 121457,
 432478665,
 432137195,
 -1,
 -58936,
 432459746,
 121108,
 -1,
 432483155,
 121109,
 -1,
 432425658,
 121481,
 432740830,
 431110997,
 -1,
 432806360,
 432731550,
 -1,
 432871888,
 432783828,
 -1,
 432937423,
 432827695,
 121339,
 -1,
 432865329,
 121340,
 -1,
 432899843,
 121336,
 433134035,
 432809448,
 -1,
 -58926,
 433113419,
 121333,
 -1,
 433159621,
 121334,
 -58924,
 433115838,
 121337,
 -58923,
 433305644,
 121338,
 -58922,
 433347699,
 121342,
 -58921,
 433410706,
 121335,
 -1,
 433475762,
 121341,
 433717247,
 432781001,
 -1,
 433723868,
 433624509,
 -1,
 -58917,
 433709395,
 121360,
 -1,
 433734271,
 121357,
 -58915,
 433709460,
 121359,
 -1,
 433865416,
 121358,
 434051558,
 432706208,
 -1,
 434117093,
 434021514,
 -1,
 434182627,
 434104993,
 -1,
 -58910,
 434159045,
 121395,
 -1,
 434203473,
 121396,
 -58908,
 434148789,
 121393,
 -1,
 434321393,
 121394,
 -1,
 434063109,
 121450,
 434575854,
 433991592,
 -1,
 434641387,
 434528609,
 -1,
 -58903,
 434622227,
 121388,
 -58902,
 434680134,
 121386,
 -1,
 434738613,
 121387,
 434962431,
 434608833,
 -1,
 -58899,
 434868272,
 121479,
 -1,
 434931240,
 121482,
 435100150,
 434515563,
 -1,
 435165683,
 435086534,
 -1,
 -58895,
 435144811,
 121102,
 -58894,
 435196413,
 121103,
 -1,
 435235667,
 121104,
 435486719,
 435111610,
 -1,
 -58891,
 435384391,
 121401,
 -1,
 435441942,
 121402,
 435624445,
 435035800,
 -1,
 435689978,
 435605262,
 -1,
 -58887,
 435646305,
 121398,
 -1,
 435685748,
 121400,
 435945471,
 435629399,
 -1,
 -58884,
 435842984,
 121397,
 -1,
 435882356,
 121399,
 436083201,
 435575997,
 -1,
 -58881,
 436062315,
 121096,
 -58880,
 436113917,
 121097,
 -1,
 436153171,
 121098,
 -58878,
 436071174,
 121455,
 -58877,
 436331064,
 121461,
 -1,
 436382570,
 121483,
 -1,
 371918185,
 129304,
 436607629,
 371866453,
 -1,
 436673154,
 436551235,
 -1,
 436738634,
 436634274,
 -1,
 436804114,
 436719606,
 -1,
 436869643,
 436793593,
 71129,
 -1,
 436824061,
 71130,
 437000718,
 436850678,
 -1,
 -58867,
 436952526,
 71065,
 -1,
 437000778,
 71064,
 437197329,
 436952508,
 -1,
 -58864,
 437172163,
 71128,
 -1,
 437197386,
 71070,
 -1,
 437131850,
 71069,
 437459481,
 436790682,
 -1,
 437525016,
 437427051,
 -1,
 437590550,
 437498850,
 71046,
 -1,
 437564386,
 71047,
 437780479,
 437550139,
 71048,
 -1,
 437681211,
 71049,
 -1,
 437459530,
 71082,
 437918238,
 437393994,
 71040,
 -58853,
 437902523,
 71053,
 -58852,
 437946539,
 71131,
 -58851,
 438003709,
 71051,
 -1,
 438049354,
 71041,
 438245923,
 437883552,
 -1,
 -58848,
 438236090,
 71063,
 -58847,
 438276842,
 71068,
 -58846,
 438327458,
 71058,
 -1,
 438377034,
 71073,
 438573609,
 438188885,
 -1,
 438639143,
 438516565,
 -1,
 -58842,
 438590926,
 71067,
 -1,
 438639178,
 71066,
 -58840,
 438590926,
 71072,
 -1,
 438770250,
 71071,
 438966829,
 438550996,
 -1,
 -58837,
 438944425,
 71084,
 -58836,
 438984142,
 71083,
 -1,
 439032394,
 71085,
 439228975,
 438951099,
 71044,
 -1,
 439213243,
 71045,
 439360050,
 439200208,
 -1,
 -58831,
 439311822,
 71075,
 -1,
 439360074,
 71074,
 439556661,
 439318624,
 -1,
 -58828,
 439508430,
 71055,
 -1,
 439556682,
 71054,
 439753272,
 439514945,
 -1,
 -58825,
 439705038,
 71062,
 -1,
 439753290,
 71061,
 439949882,
 439707645,
 71042,
 -1,
 439904253,
 71043,
 440080957,
 439900243,
 -1,
 -58820,
 440032718,
 71057,
 -1,
 440080970,
 71056,
 440277568,
 440020904,
 -1,
 -58817,
 440229326,
 71060,
 -1,
 440277578,
 71059,
 440474179,
 440215815,
 -1,
 -58814,
 440425934,
 71077,
 -1,
 440474186,
 71076,
 -58812,
 440464314,
 71079,
 -58811,
 440644692,
 71080,
 -58810,
 440703681,
 71052,
 -58809,
 440764834,
 71078,
 -58808,
 440827013,
 71081,
 -58807,
 440884686,
 71086,
 -1,
 440943810,
 71050,
 441129579,
 436715988,
 -1,
 441195107,
 441074882,
 -1,
 441260640,
 441137737,
 -1,
 441326174,
 441249360,
 -1,
 441391699,
 441309326,
 -1,
 441457234,
 441335175,
 -1,
 -58799,
 441441581,
 71114,
 -1,
 441467071,
 71115,
 -1,
 441429471,
 71122,
 441719383,
 441366031,
 -1,
 -58795,
 441702836,
 71118,
 -58794,
 441729459,
 71117,
 -1,
 441792776,
 71116,
 441981531,
 441660574,
 -1,
 -58791,
 441965631,
 71126,
 -58790,
 442021380,
 71125,
 -1,
 442062542,
 71127,
 -58788,
 441959603,
 71124,
 -58787,
 442217125,
 71123,
 -1,
 442253747,
 71121,
 442499071,
 441270825,
 71119,
 -1,
 442371716,
 71120,
 442630143,
 441232194,
 -1,
 -58782,
 442515448,
 71108,
 -1,
 442575310,
 71109,
 442826751,
 441150466,
 -1,
 442833511,
 442755249,
 -1,
 -58778,
 442811284,
 71102,
 -1,
 442873189,
 71103,
 -58776,
 442812279,
 71105,
 -58775,
 442997229,
 71104,
 -58774,
 443035772,
 71100,
 -1,
 443098054,
 71101,
 443292282,
 441117226,
 -1,
 443357810,
 443226698,
 -1,
 443423343,
 443320491,
 71132,
 -1,
 443407547,
 71133,
 -58768,
 443407547,
 71099,
 -58767,
 443508733,
 71097,
 -1,
 443554378,
 71087,
 443751028,
 443345252,
 71092,
 -1,
 443724770,
 71093,
 443882102,
 443735227,
 71090,
 -1,
 443866299,
 71091,
 444013176,
 443836413,
 71088,
 -1,
 443967485,
 71089,
 -58759,
 443980481,
 71098,
 -1,
 444089538,
 71096,
 444275326,
 443267182,
 -1,
 -58756,
 444208208,
 71112,
 -58755,
 444273451,
 71111,
 -1,
 444338683,
 71110,
 444537473,
 444218197,
 -1,
 -58752,
 444507554,
 71107,
 -1,
 444539529,
 71106,
 -1,
 444484486,
 71113,
 444858367,
 436621510,
 -1,
 444865160,
 444787943,
 -1,
 -58747,
 444850602,
 128414,
 -58746,
 444906338,
 128409,
 -58745,
 444956826,
 128408,
 -1,
 445006549,
 128415,
 445251583,
 444804235,
 -1,
 -58742,
 445178282,
 128416,
 -58741,
 445234018,
 128411,
 -58740,
 445284506,
 128410,
 -1,
 445334229,
 128417,
 445520587,
 436572832,
 -1,
 445586113,
 445472379,
 -1,
 445651629,
 445523095,
 -1,
 445717152,
 445618679,
 -1,
 445782677,
 445698038,
 -1,
 -58733,
 445770833,
 70123,
 -58732,
 445801383,
 70124,
 -1,
 445860577,
 70122,
 446044824,
 445759956,
 -1,
 -58729,
 446002924,
 70127,
 -1,
 446058561,
 70128,
 446241435,
 446013213,
 -1,
 -58726,
 446223412,
 70132,
 -1,
 446261106,
 70131,
 446438046,
 446190067,
 -1,
 -58723,
 446407789,
 70125,
 -1,
 446458528,
 70126,
 -58721,
 446404382,
 70130,
 -1,
 446581247,
 70129,
 446824447,
 445660909,
 -1,
 446831268,
 446746614,
 -1,
 -58717,
 446820403,
 70114,
 -1,
 446850591,
 70115,
 447027879,
 446808532,
 -1,
 -58714,
 446985892,
 70118,
 -1,
 447041508,
 70119,
 447224490,
 446976499,
 -1,
 -58711,
 447194648,
 70116,
 -1,
 447247850,
 70117,
 -58709,
 447192857,
 70113,
 -58708,
 447387374,
 70121,
 -1,
 447433118,
 70120,
 447617723,
 445613277,
 -1,
 447683249,
 447598582,
 -1,
 -58704,
 447672371,
 3560,
 -1,
 447702559,
 3561,
 447879860,
 447660500,
 -1,
 -58701,
 447837860,
 3564,
 -1,
 447893476,
 3565,
 448076471,
 447828467,
 -1,
 -58698,
 448046616,
 3562,
 -1,
 448099818,
 3563,
 -58696,
 448067376,
 3558,
 -58695,
 448241433,
 3559,
 -58694,
 448304878,
 3567,
 -1,
 448350622,
 3566,
 448535232,
 447559565,
 -1,
 448600767,
 448508898,
 -1,
 -58690,
 448548022,
 983935,
 -1,
 448601926,
 983934,
 -1,
 448590891,
 983933,
 -1,
 448514031,
 3457,
 448987135,
 445537290,
 -1,
 448993992,
 448856064,
 -1,
 449059526,
 448972452,
 -1,
 -58683,
 449048627,
 983154,
 -1,
 449078815,
 983157,
 -58681,
 449010848,
 983182,
 -1,
 449196696,
 983184,
 449445887,
 448925870,
 -1,
 -58678,
 449320016,
 983158,
 -1,
 449385259,
 983155,
 449583822,
 445510204,
 -1,
 -58675,
 449563902,
 128303,
 -1,
 449621402,
 128973,
 -1,
 449545023,
 128510,
 449846214,
 371825345,
 983077,
 449911615,
 449836483,
 -1,
 449977097,
 449872546,
 -1,
 450042587,
 449957878,
 -1,
 450108118,
 450023414,
 -1,
 -58667,
 450059726,
 72295,
 -1,
 450107978,
 72294,
 450304729,
 450085332,
 -1,
 -58664,
 450256334,
 72310,
 -1,
 450304586,
 72309,
 -58662,
 450256334,
 72300,
 -1,
 450435658,
 72299,
 450632418,
 449985365,
 -1,
 450697951,
 450575189,
 -1,
 -58658,
 450649550,
 72297,
 -1,
 450697802,
 72296,
 -58656,
 450688627,
 72311,
 -58655,
 450846158,
 72302,
 -1,
 450894410,
 72301,
 451091175,
 450597536,
 -1,
 -58652,
 451081146,
 72293,
 -58651,
 451121898,
 72298,
 -58650,
 451172514,
 72288,
 -1,
 451222090,
 72303,
 451418859,
 451068372,
 -1,
 -58647,
 451396265,
 72320,
 -58646,
 451435982,
 72319,
 -1,
 451484234,
 72321,
 451681007,
 451377248,
 -1,
 -58643,
 451660841,
 72323,
 -58642,
 451698126,
 72285,
 -1,
 451746378,
 72284,
 451943154,
 451671621,
 -1,
 -58639,
 451894734,
 72312,
 -1,
 451942986,
 72313,
 452139765,
 451914192,
 -1,
 -58636,
 452091342,
 72305,
 -1,
 452139594,
 72304,
 452336376,
 452097857,
 -1,
 -58633,
 452287950,
 72292,
 -1,
 452336202,
 72291,
 452532987,
 452286547,
 -1,
 -58630,
 452484558,
 72287,
 -1,
 452532810,
 72286,
 452729598,
 452472744,
 -1,
 -58627,
 452681166,
 72290,
 -1,
 452729418,
 72289,
 452926209,
 452667655,
 -1,
 -58624,
 452877774,
 72307,
 -1,
 452926026,
 72306,
 -58622,
 452916154,
 72315,
 -58621,
 453109165,
 72318,
 -58620,
 453162068,
 72316,
 -58619,
 453216674,
 72308,
 -58618,
 453278853,
 72317,
 -58617,
 453336526,
 72322,
 -58616,
 453384778,
 72272,
 -1,
 453447514,
 72314,
 453647126,
 449926084,
 -1,
 453712652,
 453624276,
 72340,
 -1,
 453664188,
 72339,
 453843726,
 453677728,
 72334,
 -1,
 453793875,
 72332,
 -58609,
 453817314,
 72337,
 -58608,
 453937484,
 72336,
 -58607,
 453999675,
 72338,
 -58606,
 454064224,
 72331,
 -58605,
 454121555,
 72330,
 -58604,
 454179669,
 72333,
 -58603,
 454240519,
 72335,
 -1,
 454299482,
 72341,
 454499109,
 453634536,
 -1,
 454564644,
 454477787,
 -1,
 454630171,
 454551889,
 -1,
 -58598,
 454603746,
 72281,
 -1,
 454655035,
 72282,
 454826781,
 454614203,
 72275,
 -1,
 454771906,
 72274,
 454957855,
 454793921,
 72277,
 -1,
 454902978,
 72278,
 455088930,
 454892106,
 -1,
 -58591,
 455072955,
 72280,
 -1,
 455108605,
 72279,
 -58589,
 455043069,
 72273,
 -1,
 455230658,
 72276,
 -1,
 454525521,
 72283,
 455482156,
 454476244,
 -1,
 455547691,
 455437314,
 -1,
 -58584,
 455534868,
 72343,
 -58583,
 455598594,
 72325,
 -58582,
 455636949,
 72324,
 -1,
 455680966,
 72342,
 -1,
 455532022,
 72345,
 455940913,
 455445351,
 -1,
 -58578,
 455924277,
 72346,
 -58577,
 455984560,
 72347,
 -58576,
 456044198,
 72349,
 -1,
 456081973,
 72348,
 456268599,
 455882306,
 -1,
 456334133,
 456245716,
 -1,
 -58572,
 456285646,
 72328,
 -1,
 456333898,
 72329,
 -58570,
 456307796,
 72326,
 -1,
 456490117,
 72327,
 456661819,
 456220831,
 72352,
 456785919,
 456589378,
 -1,
 -58566,
 456710628,
 72350,
 -1,
 456742153,
 72351,
 456923966,
 456643314,
 -1,
 -58563,
 456856363,
 72354,
 -1,
 456921595,
 72353,
 -1,
 456874537,
 72344,
 457186168,
 449862103,
 -1,
 457251674,
 457147042,
 -1,
 457317190,
 457228756,
 -1,
 457382725,
 457251402,
 -1,
 -58556,
 457346412,
 69436,
 -1,
 457391689,
 69439,
 -1,
 457335635,
 69441,
 457644873,
 457276475,
 -1,
 -58552,
 457592434,
 69444,
 -1,
 457646323,
 69433,
 457841483,
 457597055,
 69427,
 -1,
 457823053,
 69430,
 457972558,
 457775690,
 -1,
 -58547,
 457962749,
 69437,
 -1,
 457998955,
 69424,
 -58545,
 457963267,
 69429,
 -58544,
 458159550,
 69431,
 -58543,
 458222545,
 69428,
 -58542,
 458281402,
 69442,
 -58541,
 458340538,
 69440,
 -58540,
 458402789,
 69438,
 -58539,
 458463795,
 69435,
 -58538,
 458526085,
 69434,
 -58537,
 458586428,
 69432,
 -58536,
 458644400,
 69426,
 -58535,
 458707697,
 69443,
 -1,
 458763086,
 69425,
 458955626,
 457193130,
 -1,
 459021150,
 458939355,
 -1,
 -58531,
 458959597,
 69447,
 -1,
 459021218,
 69449,
 459217761,
 458974345,
 -1,
 -58528,
 459156205,
 69453,
 -1,
 459217826,
 69452,
 459414372,
 459161596,
 -1,
 -58525,
 459352813,
 69446,
 -1,
 459414434,
 69448,
 459610983,
 459356947,
 -1,
 -58522,
 459549421,
 69451,
 -1,
 459611042,
 69450,
 -58520,
 459591265,
 69456,
 -58519,
 459782319,
 69455,
 -1,
 459834970,
 69454,
 460004209,
 458928482,
 -1,
 460069743,
 459987917,
 -1,
 460135278,
 460056520,
 69461,
 -1,
 460065983,
 69462,
 -1,
 460076203,
 69464,
 -58512,
 460021414,
 69465,
 -1,
 460272699,
 69463,
 460462967,
 459971063,
 -1,
 460528501,
 460443638,
 -1,
 -58508,
 460516433,
 69459,
 -1,
 460540641,
 69458,
 460783615,
 460496665,
 69457,
 -1,
 460653441,
 69460,
 -1,
 460418452,
 69445,
 460921764,
 457159779,
 -1,
 460987286,
 460882594,
 -1,
 461052798,
 460952224,
 -1,
 -58500,
 461042633,
 69857,
 -58499,
 461068527,
 69847,
 -1,
 461119013,
 69849,
 461314945,
 461015458,
 -1,
 -58496,
 461266364,
 69846,
 -1,
 461325506,
 69864,
 461511556,
 461259970,
 -1,
 -58493,
 461462972,
 69863,
 -1,
 461523284,
 69859,
 -58491,
 461501385,
 69852,
 -58490,
 461694396,
 69850,
 -58489,
 461758292,
 69861,
 -58488,
 461820119,
 69841,
 -58487,
 461882066,
 69840,
 -58486,
 461944004,
 69853,
 -58485,
 462006887,
 69851,
 -58484,
 462068918,
 69862,
 -58483,
 462126406,
 69848,
 -58482,
 462190852,
 69855,
 -58481,
 462255979,
 69856,
 -58480,
 462318674,
 69860,
 -58479,
 462380553,
 69854,
 -58478,
 462444783,
 69845,
 -58477,
 462502968,
 69844,
 -58476,
 462565386,
 69843,
 -58475,
 462629246,
 69842,
 -1,
 462691877,
 69858,
 462946303,
 460930797,
 -1,
 462953370,
 462868470,
 -1,
 -58471,
 462942259,
 69874,
 -1,
 462972447,
 69875,
 463149981,
 462930388,
 -1,
 -58468,
 463107748,
 69878,
 -1,
 463163364,
 69879,
 463346592,
 463098355,
 -1,
 -58465,
 463316504,
 69876,
 -1,
 463369706,
 69877,
 -58463,
 463337264,
 69872,
 -58462,
 463511321,
 69873,
 -58461,
 463574766,
 69881,
 -1,
 463620510,
 69880,
 463805369,
 460907822,
 -1,
 463870895,
 463793270,
 -1,
 463936426,
 463843056,
 -1,
 -58456,
 463923459,
 128601,
 -58455,
 463962046,
 128593,
 -1,
 464006935,
 128609,
 464198572,
 463919350,
 11113,
 -1,
 464128849,
 11129,
 -58451,
 464186606,
 11011,
 -58450,
 464307060,
 129111,
 -1,
 464333970,
 11019,
 464584703,
 463816274,
 -1,
 464591796,
 464498416,
 -1,
 -58446,
 464578819,
 128603,
 -58445,
 464617406,
 128595,
 -1,
 464662295,
 128611,
 464853942,
 464574710,
 11112,
 -1,
 464784209,
 11128,
 -58441,
 464841966,
 11010,
 -58440,
 464962420,
 129110,
 -1,
 464989330,
 11018,
 465181630,
 463755243,
 -1,
 465247165,
 465108992,
 -1,
 -58436,
 465225310,
 128428,
 -1,
 465267046,
 127846,
 -1,
 465185182,
 129358,
 465509312,
 465142655,
 128618,
 -1,
 465437594,
 128619,
 465640387,
 465448872,
 -1,
 -58430,
 465599432,
 129510,
 -1,
 465646106,
 9917,
 -58428,
 465617364,
 983181,
 -58427,
 465805026,
 128284,
 -1,
 465853884,
 983043,
 466033837,
 449797564,
 -1,
 466099341,
 465967690,
 -1,
 466164811,
 466072546,
 -1,
 466230346,
 466099389,
 -1,
 466295818,
 466191010,
 -1,
 466361298,
 466281882,
 -1,
 466426833,
 466328427,
 -1,
 466492367,
 466400226,
 70025,
 -1,
 466465762,
 70026,
 466681855,
 466451515,
 70027,
 -1,
 466582587,
 70028,
 -1,
 466360906,
 70062,
 466820056,
 466341878,
 -1,
 466885590,
 466800630,
 -1,
 -58411,
 466836942,
 70044,
 -1,
 466885194,
 70043,
 -58409,
 466836942,
 70049,
 -1,
 467016266,
 70048,
 467213277,
 466784928,
 -1,
 -58406,
 467203002,
 70042,
 -58405,
 467243754,
 70047,
 -58404,
 467294370,
 70037,
 -1,
 467343946,
 70052,
 467540963,
 467155797,
 -1,
 467606497,
 467483477,
 -1,
 -58400,
 467557838,
 70046,
 -1,
 467606090,
 70045,
 -58398,
 467557838,
 70051,
 -1,
 467737162,
 70050,
 467934183,
 467475018,
 70019,
 -58395,
 467918011,
 70032,
 -58394,
 467953661,
 70030,
 -1,
 467999306,
 70020,
 468196331,
 467911124,
 -1,
 -58391,
 468173481,
 70064,
 -58390,
 468213198,
 70063,
 -1,
 468261450,
 70065,
 468458477,
 468180155,
 70023,
 -1,
 468442299,
 70024,
 468589552,
 468429264,
 -1,
 -58385,
 468540878,
 70054,
 -1,
 468589130,
 70053,
 468786163,
 468548667,
 -1,
 -58382,
 468745349,
 70061,
 -1,
 468785738,
 70060,
 468982774,
 468744288,
 -1,
 -58379,
 468934094,
 70034,
 -1,
 468982346,
 70033,
 469179385,
 468940609,
 -1,
 -58376,
 469130702,
 70041,
 -1,
 469178954,
 70040,
 469375995,
 469133309,
 70021,
 -1,
 469329917,
 70022,
 469507070,
 469325907,
 -1,
 -58371,
 469458382,
 70036,
 -1,
 469506634,
 70035,
 469703681,
 469446568,
 -1,
 -58368,
 469654990,
 70039,
 -1,
 469703242,
 70038,
 469900292,
 469641479,
 -1,
 -58365,
 469851598,
 70056,
 -1,
 469899850,
 70055,
 -58363,
 469889978,
 70058,
 -58362,
 470070356,
 70059,
 -58361,
 470129345,
 70031,
 -58360,
 470190498,
 70057,
 -58359,
 470244814,
 70066,
 -1,
 470303938,
 70029,
 470490141,
 466282984,
 -1,
 470555676,
 470468571,
 -1,
 470621201,
 470542673,
 -1,
 470686735,
 470594530,
 70072,
 -1,
 470660066,
 70073,
 470876159,
 470645819,
 70074,
 -1,
 470776891,
 70075,
 470948885,
 470555210,
 -1,
 -58349,
 470932667,
 70079,
 -58348,
 470968317,
 70077,
 -1,
 471013962,
 70067,
 471211031,
 470932667,
 70070,
 -1,
 471194811,
 70071,
 471342105,
 471164925,
 70068,
 -1,
 471295997,
 70069,
 -58342,
 471314642,
 70094,
 -58341,
 471440065,
 70078,
 -1,
 471483586,
 70076,
 -1,
 470520008,
 70091,
 471735346,
 470467028,
 -1,
 471800875,
 471690242,
 -1,
 471866402,
 471787697,
 -1,
 -58335,
 471843732,
 70018,
 -1,
 471905637,
 70080,
 472063013,
 471800394,
 -1,
 -58332,
 472049076,
 70081,
 -1,
 472095292,
 70017,
 -58330,
 472048130,
 70083,
 -58329,
 472237943,
 70107,
 -58328,
 472291821,
 70090,
 -58327,
 472348629,
 70082,
 -58326,
 472412713,
 70095,
 -1,
 472461436,
 70016,
 472652848,
 471745730,
 -1,
 472718383,
 472595029,
 -1,
 -58322,
 472650539,
 70111,
 -1,
 472715771,
 70110,
 -1,
 472689466,
 70088,
 -58319,
 472638825,
 70093,
 -1,
 472916638,
 70089,
 473111619,
 471677781,
 -1,
 473177153,
 473066475,
 -1,
 473242679,
 473157622,
 -1,
 -58314,
 473231411,
 70098,
 -1,
 473261599,
 70099,
 473439290,
 473219540,
 -1,
 -58311,
 473396900,
 70102,
 -1,
 473452516,
 70103,
 473635901,
 473387507,
 -1,
 -58308,
 473605656,
 70100,
 -1,
 473658858,
 70101,
 -58306,
 473626416,
 70096,
 -58305,
 473800473,
 70097,
 -58304,
 473863918,
 70105,
 -1,
 473909662,
 70104,
 -58302,
 473146786,
 70086,
 -1,
 474030729,
 70085,
 474225734,
 473056450,
 -1,
 -58299,
 474215174,
 70092,
 -1,
 474249518,
 70106,
 -58297,
 474193387,
 70084,
 -58296,
 474374382,
 70108,
 -58295,
 474429451,
 70109,
 -1,
 474487691,
 70087,
 -1,
 466188384,
 129416,
 474750091,
 466150810,
 -1,
 474815626,
 474704081,
 -1,
 474881111,
 474749514,
 -1,
 474946641,
 474854370,
 -1,
 -58288,
 474920448,
 66684,
 -1,
 474956994,
 66680,
 -58286,
 474934298,
 66679,
 -58285,
 475120966,
 66664,
 -58284,
 475165490,
 66682,
 -58283,
 475225532,
 66669,
 -58282,
 475290078,
 66673,
 -1,
 475348883,
 66665,
 475536478,
 474847937,
 -1,
 -58279,
 475522327,
 66668,
 -58278,
 475575266,
 66681,
 -58277,
 475638175,
 66677,
 -58276,
 475697824,
 66666,
 -58275,
 475753578,
 66678,
 -1,
 475799348,
 66676,
 475995236,
 475481282,
 -1,
 476060770,
 475929162,
 -1,
 -58271,
 476041206,
 66672,
 -1,
 476099554,
 66685,
 -58269,
 476037229,
 66683,
 -1,
 476207736,
 66663,
 476388457,
 475975670,
 -1,
 476453992,
 476339644,
 -1,
 -58265,
 476408664,
 66644,
 -1,
 476467681,
 66654,
 -1,
 476423350,
 66641,
 476716141,
 476342269,
 -1,
 -58261,
 476664307,
 66662,
 -58260,
 476721570,
 66674,
 -1,
 476782885,
 66686,
 476978288,
 476705860,
 -1,
 -58257,
 476965537,
 66687,
 -1,
 476977738,
 66648,
 477174899,
 476966963,
 -1,
 -58254,
 477142332,
 66667,
 -1,
 477185218,
 66658,
 477371510,
 477151700,
 -1,
 -58251,
 477357031,
 66646,
 -1,
 477403841,
 66645,
 477568121,
 477333836,
 -1,
 -58248,
 477523175,
 66661,
 -1,
 477578926,
 66656,
 477764732,
 477519292,
 -1,
 -58245,
 477749487,
 66649,
 -1,
 477764332,
 66659,
 -58243,
 477755367,
 66655,
 -58242,
 477948382,
 66653,
 -58241,
 478011731,
 66675,
 -58240,
 478068550,
 66670,
 -58239,
 478129184,
 66640,
 -58238,
 478190131,
 66671,
 -58237,
 478250531,
 66660,
 -58236,
 478313145,
 66642,
 -58235,
 478378047,
 66657,
 -58234,
 478435552,
 66652,
 -58233,
 478499531,
 66643,
 -58232,
 478559551,
 66651,
 -58231,
 478622667,
 66647,
 -1,
 478686160,
 66650,
 -1,
 474761030,
 127847,
 -58228,
 474714512,
 9752,
 -1,
 478905773,
 129368,
 479075489,
 466066113,
 -1,
 479141019,
 479051982,
 -1,
 479206548,
 479092599,
 -1,
 -58223,
 479191516,
 113827,
 -58222,
 479232704,
 113824,
 -58221,
 479281923,
 113826,
 -1,
 479344669,
 113825,
 479534233,
 479133696,
 -1,
 479599768,
 479471879,
 -1,
 -58217,
 479546356,
 11103,
 -1,
 479599686,
 11087,
 -1,
 479578417,
 11086,
 -58214,
 479510996,
 129651,
 -1,
 479801362,
 127856,
 479992990,
 479113226,
 -1,
 -58211,
 479975933,
 128722,
 -1,
 479996281,
 128717,
 -58209,
 479980653,
 128703,
 -58208,
 480159016,
 127776,
 -1,
 480195923,
 129327,
 480386216,
 479029245,
 -1,
 480451749,
 480335854,
 -1,
 -58204,
 480421597,
 983075,
 -1,
 480472379,
 983078,
 -58202,
 480422352,
 128674,
 -58201,
 480614855,
 9961,
 -1,
 480660026,
 128737,
 480844971,
 480359394,
 -1,
 -58198,
 480829236,
 129335,
 -1,
 480865579,
 129424,
 -58196,
 480834358,
 983197,
 -1,
 480987233,
 128017,
 481172862,
 465967690,
 -1,
 481238301,
 481158054,
 -1,
 481303836,
 481175224,
 -1,
 481369330,
 481264290,
 -1,
 481434808,
 481355162,
 -1,
 481500343,
 481401707,
 -1,
 481565877,
 481473506,
 43144,
 -1,
 481539042,
 43145,
 481755135,
 481524795,
 43146,
 -1,
 481655867,
 43147,
 -1,
 481434186,
 43182,
 481893566,
 481415158,
 -1,
 481959100,
 481873910,
 -1,
 -58181,
 481910222,
 43165,
 -1,
 481958474,
 43164,
 -58179,
 481910222,
 43170,
 -1,
 482089546,
 43169,
 482286787,
 481858208,
 -1,
 -58176,
 482276282,
 43163,
 -58175,
 482317034,
 43168,
 -58174,
 482367650,
 43158,
 -1,
 482417226,
 43173,
 482614473,
 482229077,
 -1,
 482680007,
 482556757,
 -1,
 -58170,
 482631118,
 43167,
 -1,
 482679370,
 43166,
 -58168,
 482631118,
 43172,
 -1,
 482810442,
 43171,
 483007693,
 482548298,
 43138,
 -58165,
 482991291,
 43153,
 -58164,
 483026941,
 43150,
 -1,
 483072586,
 43139,
 483269841,
 482984404,
 -1,
 -58161,
 483246761,
 43184,
 -58160,
 483286478,
 43183,
 -1,
 483334730,
 43185,
 483531987,
 483253435,
 43142,
 -1,
 483515579,
 43143,
 483663062,
 483502544,
 -1,
 -58155,
 483614158,
 43175,
 -1,
 483662410,
 43174,
 483859672,
 483629761,
 43151,
 -1,
 483826369,
 43152,
 483990747,
 483818555,
 -1,
 -58150,
 483949701,
 43187,
 -1,
 483990090,
 43181,
 484187358,
 483948640,
 -1,
 -58147,
 484138446,
 43155,
 -1,
 484186698,
 43154,
 484383969,
 484144961,
 -1,
 -58144,
 484335054,
 43162,
 -1,
 484383306,
 43161,
 484580579,
 484337661,
 43140,
 -1,
 484534269,
 43141,
 484711654,
 484530259,
 -1,
 -58139,
 484662734,
 43157,
 -1,
 484710986,
 43156,
 484908264,
 484656322,
 43148,
 -1,
 484852930,
 43149,
 485039339,
 484847528,
 -1,
 -58134,
 484990414,
 43160,
 -1,
 485038666,
 43159,
 485235950,
 484976903,
 -1,
 -58131,
 485187022,
 43177,
 -1,
 485235274,
 43176,
 -58129,
 485225402,
 43179,
 -58128,
 485405780,
 43180,
 -58127,
 485460386,
 43178,
 -1,
 485514702,
 43186,
 485694724,
 481356330,
 -1,
 485760248,
 485681489,
 -1,
 485825782,
 485733346,
 43194,
 -1,
 485798882,
 43195,
 486014975,
 485784635,
 43196,
 -1,
 485915707,
 43197,
 486087932,
 485694026,
 -1,
 -58118,
 486071483,
 43203,
 -58117,
 486107133,
 43200,
 -1,
 486152778,
 43189,
 486350078,
 486071483,
 43192,
 -1,
 486333627,
 43193,
 486481152,
 486316737,
 43201,
 -1,
 486447809,
 43202,
 486612226,
 486434813,
 43190,
 -1,
 486565885,
 43191,
 486801407,
 486556866,
 43198,
 -1,
 486687938,
 43199,
 486874389,
 485636949,
 -1,
 486939923,
 486829035,
 -1,
 487005449,
 486920182,
 -1,
 -58104,
 486993971,
 43218,
 -1,
 487024159,
 43219,
 487202060,
 486982100,
 -1,
 -58101,
 487159460,
 43222,
 -1,
 487215076,
 43223,
 487398671,
 487150067,
 -1,
 -58098,
 487368216,
 43220,
 -1,
 487421418,
 43221,
 -58096,
 487388976,
 43216,
 -58095,
 487563033,
 43217,
 -58094,
 487626478,
 43225,
 -1,
 487672222,
 43224,
 -58092,
 486909346,
 43215,
 -1,
 487793289,
 43214,
 487988507,
 486852571,
 -1,
 488054041,
 487975089,
 -1,
 -58088,
 488031124,
 43137,
 -1,
 488093029,
 43204,
 -58086,
 487993468,
 43205,
 -1,
 488186822,
 43136,
 -1,
 487929779,
 43188,
 -1,
 481272510,
 129429,
 488512875,
 481200985,
 -1,
 488578361,
 488473250,
 -1,
 488643875,
 488558582,
 -1,
 -58079,
 488620733,
 2065,
 -58078,
 488666385,
 2056,
 -1,
 488708887,
 2069,
 488906023,
 488597501,
 -1,
 -58075,
 488895286,
 2052,
 -58074,
 488951798,
 2055,
 -1,
 489001632,
 2063,
 489168170,
 488882644,
 -1,
 -58071,
 489123847,
 2062,
 -1,
 489185098,
 2068,
 489364781,
 489105671,
 -1,
 -58068,
 489321745,
 2049,
 -1,
 489364239,
 2053,
 -58066,
 489355030,
 2054,
 -58065,
 489551421,
 2057,
 -58064,
 489602668,
 2067,
 -58063,
 489665452,
 2066,
 -58062,
 489724467,
 2061,
 -58061,
 489787284,
 2060,
 -58060,
 489847967,
 2059,
 -58059,
 489912548,
 2058,
 -58058,
 489969921,
 2050,
 -58057,
 490034021,
 2064,
 -58056,
 490093644,
 2051,
 -1,
 490151823,
 2048,
 490347851,
 488565290,
 -1,
 490413376,
 490309179,
 -1,
 490478909,
 490347082,
 2082,
 -1,
 490412618,
 2079,
 -58050,
 490462395,
 2086,
 -58049,
 490563581,
 2089,
 -1,
 490620098,
 2076,
 490806595,
 490379969,
 2091,
 490930175,
 490792806,
 2081,
 -1,
 490805834,
 2078,
 491003206,
 490783188,
 -1,
 -58043,
 490987416,
 2092,
 -1,
 491021713,
 2085,
 491199816,
 490936906,
 2083,
 -1,
 491133514,
 2080,
 -58039,
 491183291,
 2087,
 -58038,
 491284477,
 2090,
 -1,
 491340994,
 2077,
 491527518,
 490320226,
 -1,
 491593043,
 491461194,
 -1,
 491658576,
 491557536,
 -1,
 -58033,
 491623194,
 2110,
 -1,
 491674124,
 2098,
 -58031,
 491640551,
 2100,
 -58030,
 491831010,
 2108,
 -1,
 491870181,
 2097,
 492051798,
 491583045,
 -1,
 -58027,
 492008237,
 2104,
 -1,
 492051709,
 2106,
 492248409,
 492028372,
 -1,
 -58024,
 492215343,
 2109,
 -1,
 492266480,
 2101,
 -58022,
 492231542,
 2107,
 -58021,
 492417645,
 2105,
 -58020,
 492475765,
 2096,
 -58019,
 492539249,
 2103,
 -1,
 492579444,
 2099,
 492772714,
 491489612,
 -1,
 492838246,
 492709118,
 -1,
 492903778,
 492793147,
 2070,
 -1,
 492834653,
 2071,
 -58013,
 492870541,
 2072,
 -58012,
 493000053,
 2093,
 -58011,
 493046972,
 2075,
 -1,
 493108273,
 2073,
 493355007,
 492805116,
 -1,
 -58008,
 493274871,
 2084,
 -58007,
 493316093,
 2088,
 -1,
 493374652,
 2074,
 -1,
 492706662,
 2102,
 493624692,
 488477344,
 -1,
 493690227,
 493601437,
 -1,
 493755762,
 493642020,
 -1,
 493821297,
 493699353,
 -1,
 -58000,
 493804294,
 128630,
 -1,
 493827797,
 128631,
 -1,
 493782796,
 128632,
 -1,
 493711722,
 128634,
 -1,
 493634735,
 129386,
 494214518,
 493605493,
 128752,
 -1,
 494141654,
 128225,
 494345593,
 494162678,
 -1,
 -57992,
 494332047,
 129466,
 -1,
 494382475,
 129527,
 -57990,
 494334689,
 127927,
 -57989,
 494516682,
 129403,
 -57988,
 494569594,
 129474,
 -57987,
 494631400,
 127862,
 -1,
 494693507,
 9973,
 494870064,
 481145476,
 -1,
 494935599,
 494806256,
 -1,
 495001108,
 494877527,
 -1,
 495066560,
 494940072,
 -1,
 495132094,
 495024110,
 -1,
 495197591,
 495064642,
 -1,
 495263112,
 495129387,
 -1,
 -57978,
 495196360,
 127545,
 -57977,
 495261244,
 127516,
 -1,
 495325989,
 127520,
 495525259,
 495196568,
 -1,
 -57974,
 495457350,
 127511,
 -1,
 495522594,
 127509,
 495721870,
 495457646,
 -1,
 -57971,
 495654251,
 127525,
 -1,
 495718897,
 127540,
 495918481,
 495653968,
 -1,
 -57968,
 495866433,
 127534,
 -1,
 495923591,
 127506,
 -57966,
 495866436,
 127517,
 -57965,
 496057659,
 127532,
 -57964,
 496118061,
 127505,
 -57963,
 496179604,
 127524,
 -57962,
 496244531,
 127546,
 -1,
 496309022,
 127518,
 496508328,
 495130423,
 -1,
 496573852,
 496440107,
 -1,
 -57958,
 496507452,
 127527,
 -57957,
 496572185,
 127537,
 -1,
 496637497,
 127504,
 496835999,
 496507074,
 -1,
 -57954,
 496769432,
 127542,
 -1,
 496834791,
 127543,
 497032610,
 496768578,
 -1,
 -57951,
 496970006,
 127519,
 -1,
 497031747,
 127515,
 497229221,
 496964688,
 -1,
 -57948,
 497162012,
 127528,
 -1,
 497226222,
 127535,
 -57946,
 497177149,
 127526,
 -57945,
 497370620,
 127541,
 -1,
 497424380,
 127513,
 497622448,
 496441351,
 -1,
 497687980,
 497555010,
 -1,
 -57941,
 497620319,
 127544,
 -1,
 497685288,
 127522,
 -57939,
 497630200,
 127521,
 -57938,
 497818379,
 127539,
 -57937,
 497883711,
 127538,
 -1,
 497947396,
 127514,
 498146743,
 497555007,
 -1,
 498212276,
 498077931,
 -1,
 -57933,
 498145688,
 127530,
 -1,
 498209003,
 127529,
 -57931,
 498146056,
 127512,
 -57930,
 498342289,
 127508,
 -1,
 498406473,
 127533,
 498605499,
 498079975,
 -1,
 -57927,
 498547708,
 127536,
 -57926,
 498610146,
 127523,
 -1,
 498670150,
 127510,
 498925567,
 498538904,
 -1,
 -57923,
 498799373,
 127547,
 -1,
 498864618,
 127531,
 -57921,
 495100292,
 127378,
 -1,
 499022907,
 127377,
 499195363,
 495025211,
 -1,
 499260894,
 499132343,
 -1,
 499326429,
 499200218,
 -1,
 -57916,
 499316293,
 127305,
 -57915,
 499381046,
 127304,
 -57914,
 499446320,
 127303,
 -57913,
 499509921,
 127302,
 -57912,
 499574170,
 127301,
 -57911,
 499637435,
 127300,
 -57910,
 499699702,
 127299,
 -57909,
 499761620,
 127298,
 -57908,
 499823586,
 127297,
 -57907,
 499888654,
 127296,
 -57906,
 499952080,
 127295,
 -57905,
 500013761,
 127294,
 -57904,
 500077216,
 127293,
 -57903,
 500140364,
 127292,
 -57902,
 500202555,
 127291,
 -57901,
 500267104,
 127290,
 -57900,
 500332353,
 127289,
 -57899,
 500393981,
 127288,
 -57898,
 500456892,
 127287,
 -57897,
 500521043,
 127286,
 -57896,
 500584947,
 127285,
 -57895,
 500647106,
 127284,
 -57894,
 500710229,
 127283,
 -57893,
 500772776,
 127282,
 -57892,
 500836615,
 127281,
 -1,
 500898378,
 127280,
 -1,
 499304955,
 127397,
 501219327,
 499227329,
 -1,
 501226978,
 501111697,
 -1,
 -57887,
 501195585,
 10191,
 -1,
 501227878,
 10190,
 -1,
 501206171,
 127401,
 501489133,
 499171796,
 -1,
 501554663,
 501433538,
 -1,
 -57882,
 501540619,
 127393,
 -1,
 501561167,
 127388,
 -57880,
 501531092,
 127309,
 -57879,
 501720199,
 127384,
 -57878,
 501774086,
 127395,
 -57877,
 501835709,
 127402,
 -57876,
 501889877,
 127308,
 -1,
 501948625,
 9949,
 502144499,
 501446752,
 -1,
 502210034,
 502081313,
 -1,
 -57872,
 502186665,
 127490,
 -57871,
 502233969,
 127489,
 -1,
 502283521,
 127507,
 -1,
 502157793,
 9919,
 502537720,
 502095292,
 -1,
 -57867,
 502523290,
 127306,
 -57866,
 502556790,
 127400,
 -57865,
 502612963,
 127399,
 -1,
 502673320,
 127398,
 502865406,
 502485491,
 -1,
 502930940,
 502834716,
 -1,
 -57861,
 502888544,
 127390,
 -1,
 502939765,
 11820,
 -57859,
 502904750,
 127379,
 -1,
 503084607,
 127392,
 503258627,
 502845430,
 -1,
 503324162,
 503245473,
 -1,
 -57855,
 503290582,
 127389,
 -1,
 503336031,
 127394,
 -1,
 503277120,
 127387,
 503586310,
 503244186,
 -1,
 -57851,
 503562708,
 127386,
 -1,
 503618511,
 127404,
 503782921,
 503569595,
 -1,
 -57848,
 503753222,
 127385,
 -1,
 503799932,
 127403,
 503979532,
 503749313,
 -1,
 -57845,
 503944398,
 127396,
 -1,
 504002656,
 127383,
 504176143,
 503943840,
 -1,
 -57842,
 504125523,
 127382,
 -1,
 504189123,
 127381,
 -57840,
 504163338,
 127311,
 -57839,
 504344646,
 127310,
 -57838,
 504402552,
 127307,
 -57837,
 504457666,
 127380,
 -1,
 504514999,
 127391,
 504758271,
 494927872,
 -1,
 504765978,
 504688208,
 -1,
 -57833,
 504750867,
 11028,
 -57832,
 504813421,
 11026,
 -57831,
 504858540,
 11029,
 -1,
 504901123,
 11027,
 505093664,
 504707925,
 -1,
 505159199,
 505055564,
 13175,
 505282559,
 505085952,
 -1,
 -57826,
 505203674,
 13176,
 -1,
 505231996,
 13177,
 -1,
 505116481,
 127376,
 505486885,
 505038018,
 -1,
 505552420,
 505459682,
 -1,
 -57821,
 505501779,
 13005,
 -1,
 505551473,
 13055,
 -1,
 505537946,
 13006,
 505814568,
 505437628,
 -1,
 -57817,
 505770811,
 127488,
 -1,
 505829459,
 13004,
 -57815,
 505800092,
 13278,
 -57814,
 505991564,
 128918,
 -57813,
 506048429,
 11216,
 -57812,
 506099175,
 13178,
 -57811,
 506157303,
 13311,
 -57810,
 506222220,
 9974,
 -1,
 506272382,
 13279,
 -1,
 494889410,
 129425,
 506535588,
 494853307,
 -1,
 506601114,
 506499744,
 -1,
 506666643,
 506543234,
 -1,
 506732129,
 506626722,
 -1,
 506797624,
 506696352,
 -1,
 -57802,
 506786746,
 7057,
 -57801,
 506812578,
 7053,
 -1,
 506862154,
 7060,
 507059773,
 506745331,
 -1,
 507125308,
 507014522,
 -1,
 -57797,
 507087180,
 7103,
 -1,
 507148384,
 7102,
 -1,
 507058762,
 7062,
 507387456,
 507036116,
 -1,
 -57793,
 507376570,
 7087,
 -1,
 507386442,
 7070,
 507584067,
 507360226,
 -1,
 -57790,
 507531072,
 7099,
 -1,
 507583050,
 7067,
 507780678,
 507542587,
 -1,
 -57787,
 507727680,
 7100,
 -1,
 507779658,
 7068,
 507977289,
 507738208,
 -1,
 -57784,
 507928014,
 7086,
 -1,
 507976266,
 7050,
 508173899,
 507921602,
 7048,
 -1,
 508157115,
 7049,
 508304974,
 508111111,
 -1,
 -57779,
 508255694,
 7101,
 -1,
 508303946,
 7064,
 508501584,
 508238410,
 7043,
 -1,
 508445890,
 7046,
 -57775,
 508491379,
 7056,
 -57774,
 508621754,
 7066,
 -57773,
 508686931,
 7071,
 -57772,
 508750561,
 7069,
 -57771,
 508814765,
 7063,
 -57770,
 508878011,
 7045,
 -57769,
 508940412,
 7058,
 -57768,
 508998189,
 7051,
 -57767,
 509061665,
 7061,
 -57766,
 509123265,
 7047,
 -57765,
 509184418,
 7065,
 -57764,
 509245279,
 7055,
 -57763,
 509306877,
 7044,
 -57762,
 509369806,
 7072,
 -57761,
 509434018,
 7052,
 -57760,
 509492224,
 7059,
 -1,
 509554655,
 7054,
 509746799,
 506674925,
 -1,
 509812325,
 509726710,
 -1,
 -57756,
 509800499,
 7090,
 -1,
 509830687,
 7091,
 510008936,
 509788628,
 -1,
 -57753,
 509965988,
 7094,
 -1,
 510021604,
 7095,
 510205547,
 509956595,
 -1,
 -57750,
 510174744,
 7092,
 -1,
 510227946,
 7093,
 -57748,
 510195504,
 7088,
 -57747,
 510369561,
 7089,
 -57746,
 510433006,
 7097,
 -1,
 510478750,
 7096,
 510664313,
 509718895,
 -1,
 510729843,
 510634448,
 -1,
 -57742,
 510714898,
 7362,
 -1,
 510731018,
 7361,
 -57740,
 510709571,
 7360,
 -57739,
 510886637,
 7364,
 -57738,
 510949571,
 7365,
 -57737,
 510999578,
 7366,
 -57736,
 511062045,
 7363,
 -1,
 511125819,
 7367,
 511319681,
 510650934,
 -1,
 511385216,
 511283872,
 -1,
 -57732,
 511374904,
 7077,
 -57731,
 511417815,
 7079,
 -57730,
 511466343,
 7076,
 -57729,
 511528821,
 7081,
 -1,
 511581441,
 7078,
 -1,
 511348146,
 7080,
 511843978,
 511297499,
 -1,
 511909513,
 511814177,
 -1,
 511975048,
 511873696,
 -1,
 512040583,
 511924307,
 -1,
 -57722,
 512028223,
 7042,
 -1,
 512065214,
 7041,
 -1,
 512029777,
 7040,
 -1,
 511936937,
 7082,
 -1,
 511895821,
 7083,
 512433810,
 511784927,
 -1,
 512499342,
 512410476,
 -1,
 -57715,
 512486113,
 7085,
 -1,
 512526754,
 7084,
 512695953,
 512465513,
 -1,
 -57712,
 512650342,
 7075,
 -1,
 512696159,
 7074,
 -1,
 512659388,
 7073,
 -1,
 512370806,
 7098,
 513023637,
 506642016,
 127749,
 -1,
 512951923,
 127748,
 513154712,
 512950272,
 -1,
 -57705,
 513142399,
 127774,
 -1,
 513157856,
 9925,
 -57703,
 513131761,
 127751,
 -1,
 513299856,
 127803,
 513482398,
 506571978,
 -1,
 -57700,
 513468658,
 129465,
 -57699,
 513524996,
 10185,
 -1,
 513565141,
 129464,
 513744545,
 513458644,
 -1,
 -57696,
 513715334,
 128671,
 -1,
 513761878,
 127843,
 513941155,
 513681671,
 983102,
 -1,
 513920382,
 983101,
 -1,
 513915244,
 127940,
 514137862,
 506524470,
 -1,
 514203363,
 514098885,
 -1,
 514268882,
 514163362,
 -1,
 514334381,
 514248694,
 -1,
 514399915,
 514314230,
 -1,
 -57686,
 514366145,
 43024,
 -1,
 514417702,
 43025,
 -57684,
 514366145,
 43028,
 -1,
 514548774,
 43029,
 514727603,
 514276181,
 -1,
 514793137,
 514669397,
 -1,
 -57680,
 514759361,
 43026,
 -1,
 514810918,
 43027,
 -57678,
 514759361,
 43030,
 -1,
 514941990,
 43031,
 515120822,
 514700258,
 -1,
 -57675,
 515096362,
 43040,
 -1,
 515152577,
 43038,
 515317433,
 515090896,
 -1,
 -57672,
 515283649,
 43033,
 -1,
 515335206,
 43034,
 515514044,
 515274848,
 -1,
 -57669,
 515480257,
 43015,
 -1,
 515531814,
 43016,
 515710655,
 515471169,
 -1,
 -57666,
 515676865,
 43022,
 -1,
 515728422,
 43023,
 515907266,
 515659859,
 -1,
 -57663,
 515873473,
 43017,
 -1,
 515925030,
 43018,
 516103877,
 515846056,
 -1,
 -57660,
 516070081,
 43020,
 -1,
 516121638,
 43021,
 516300488,
 516040967,
 -1,
 -57657,
 516266689,
 43035,
 -1,
 516318246,
 43036,
 -57655,
 516283579,
 43011,
 -57654,
 516475604,
 43041,
 -57653,
 516528833,
 43013,
 -57652,
 516593607,
 43032,
 -57651,
 516657256,
 43037,
 -57650,
 516720101,
 43039,
 -57649,
 516777981,
 43009,
 -57648,
 516842534,
 43042,
 -57647,
 516900034,
 43012,
 -1,
 516954698,
 43008,
 517152472,
 514255402,
 -1,
 -57644,
 517135547,
 43045,
 -57643,
 517185868,
 43047,
 -57642,
 517236733,
 43044,
 -57641,
 517293250,
 43046,
 -1,
 517347914,
 43043,
 517545694,
 517130203,
 -1,
 517611228,
 517478986,
 -1,
 -57637,
 517577276,
 43019,
 -1,
 517638298,
 43052,
 -57635,
 517562432,
 43014,
 -1,
 517751974,
 43010,
 517996543,
 517516999,
 -1,
 -57632,
 517870958,
 43051,
 -57631,
 517936208,
 43050,
 -57630,
 518001451,
 43049,
 -1,
 518066683,
 43048,
 518266623,
 514177482,
 -1,
 518332158,
 518200254,
 -1,
 518397693,
 518292130,
 -1,
 518463221,
 518359638,
 -1,
 518528749,
 518427296,
 -1,
 518594283,
 518492832,
 -1,
 -57622,
 518558442,
 2149,
 -1,
 518593098,
 2148,
 -57620,
 518583226,
 2146,
 -1,
 518740130,
 2144,
 518921968,
 518489380,
 -1,
 -57617,
 518880389,
 2153,
 -1,
 518920778,
 2152,
 -57615,
 518904382,
 2147,
 -57614,
 519097385,
 2154,
 -57613,
 519156820,
 2151,
 -57612,
 519206751,
 2145,
 -1,
 519252906,
 2150,
 519446265,
 518441706,
 -1,
 -57609,
 519436187,
 1869,
 -57608,
 519469717,
 1870,
 -1,
 519525038,
 1871,
 519766015,
 519417077,
 -1,
 -57605,
 519658202,
 1838,
 -57604,
 519716411,
 1839,
 -1,
 519777213,
 1837,
 -1,
 518377182,
 983202,
 -1,
 518297165,
 128137,
 520101634,
 518230688,
 983094,
 -57599,
 520041387,
 983093,
 -1,
 520101389,
 128333,
 520355839,
 520064093,
 -1,
 -57596,
 520281243,
 11159,
 -57595,
 520340295,
 8527,
 -1,
 520391579,
 128325,
 520560443,
 514117622,
 983189,
 520625949,
 520493642,
 -1,
 520691476,
 520598498,
 -1,
 520757009,
 520671312,
 -1,
 520822541,
 520733140,
 -1,
 -57588,
 520804761,
 983180,
 -1,
 520833624,
 983132,
 -57586,
 520803139,
 983044,
 -57585,
 520990956,
 983175,
 -57584,
 521035996,
 983042,
 -1,
 521100600,
 983174,
 521338879,
 520686546,
 -1,
 -57581,
 521255707,
 11243,
 -1,
 521306206,
 11242,
 521477911,
 520671222,
 -1,
 -57578,
 521461526,
 128509,
 -1,
 521499340,
 128649,
 521674522,
 521425665,
 -1,
 -57575,
 521626051,
 9882,
 -1,
 521674049,
 9877,
 -57573,
 521639026,
 129485,
 -57572,
 521834842,
 128387,
 -1,
 521879419,
 127967,
 522067749,
 520579454,
 129989,
 522190847,
 521994240,
 -1,
 522198818,
 522120784,
 -1,
 -57567,
 522142730,
 129993,
 -1,
 522200444,
 129990,
 522452991,
 522158031,
 -1,
 -57564,
 522369703,
 129992,
 -1,
 522420256,
 129991,
 522592044,
 522040290,
 -1,
 522657579,
 522525258,
 -1,
 522723114,
 522611548,
 -1,
 -57559,
 522687896,
 9188,
 -1,
 522717451,
 128207,
 -1,
 522710004,
 127827,
 -1,
 522612717,
 983188,
 523050802,
 522536130,
 -1,
 523116336,
 522985688,
 -1,
 -57553,
 523071186,
 127836,
 -1,
 523109467,
 128642,
 -57551,
 523097131,
 129658,
 -1,
 523278307,
 11836,
 523444022,
 523033787,
 -1,
 -57548,
 523414049,
 128723,
 -57547,
 523457288,
 129369,
 -1,
 523517736,
 127897,
 523706169,
 523410113,
 -1,
 -57544,
 523678215,
 9201,
 -1,
 523711779,
 128480,
 -57542,
 523694640,
 983045,
 -1,
 523878868,
 983169,
 524033885,
 520530384,
 983117,
 524099401,
 523977922,
 -1,
 524164933,
 524033844,
 -1,
 524230467,
 524111146,
 128264,
 524353535,
 524159954,
 -1,
 -57535,
 524276926,
 128266,
 -57534,
 524328943,
 128265,
 -1,
 524365890,
 128263,
 -57532,
 524185395,
 128483,
 -1,
 524488730,
 128586,
 524689224,
 524108994,
 -1,
 -57529,
 524631221,
 128676,
 -1,
 524694101,
 128172,
 -1,
 524667573,
 8375,
 524951376,
 524065473,
 -1,
 525016909,
 524917441,
 -1,
 -57524,
 524980896,
 129348,
 -1,
 525040717,
 129525,
 -57522,
 525002077,
 128051,
 -57521,
 525189385,
 127941,
 -1,
 525243981,
 129533,
 525410135,
 524904445,
 -1,
 525475669,
 525382990,
 -1,
 -57517,
 525452888,
 128026,
 -57516,
 525506699,
 128466,
 -1,
 525545507,
 128467,
 525795327,
 525417938,
 128375,
 -1,
 525667271,
 128376,
 525868892,
 525343306,
 983176,
 525934427,
 525844212,
 -1,
 -57510,
 525889354,
 128150,
 -1,
 525946436,
 10024,
 -1,
 525884143,
 127837,
 -1,
 525827639,
 128166,
 526262140,
 523977922,
 -1,
 526327660,
 526212123,
 -1,
 526393186,
 526307318,
 -1,
 -57503,
 526381107,
 130034,
 -1,
 526411295,
 130035,
 526589797,
 526369236,
 -1,
 -57500,
 526546596,
 130038,
 -1,
 526602212,
 130039,
 526786408,
 526537203,
 -1,
 -57497,
 526755352,
 130036,
 -1,
 526808554,
 130037,
 -57495,
 526776112,
 130032,
 -57494,
 526950169,
 130033,
 -57493,
 527013614,
 130041,
 -1,
 527059358,
 130040,
 527245167,
 526271682,
 -1,
 -57490,
 527187849,
 127793,
 -1,
 527241242,
 128584,
 527441778,
 527178314,
 -1,
 -57487,
 527421430,
 128186,
 -1,
 527465531,
 129453,
 -57485,
 527430388,
 9913,
 -57484,
 527625752,
 129697,
 -57483,
 527683680,
 983168,
 -57482,
 527748110,
 9916,
 -57481,
 527809997,
 129324,
 -57480,
 527870763,
 11259,
 -57479,
 527929352,
 9914,
 -57478,
 527991598,
 129331,
 -57477,
 528039823,
 11250,
 -1,
 528103230,
 129352,
 528293786,
 526223692,
 -1,
 528359316,
 528246781,
 -1,
 528424851,
 528319647,
 -1,
 528490384,
 528372304,
 -1,
 528555910,
 528466388,
 -1,
 528621445,
 528519005,
 128522,
 528744447,
 528547906,
 -1,
 -57468,
 528667795,
 129392,
 -1,
 528703331,
 129325,
 -1,
 528605449,
 128526,
 528949131,
 528523873,
 128515,
 529072127,
 528875586,
 -1,
 -57463,
 528995720,
 128518,
 -57462,
 529058459,
 128516,
 -1,
 529086080,
 128517,
 529276815,
 528899516,
 -1,
 -57459,
 529245232,
 128520,
 -57458,
 529286715,
 128525,
 -1,
 529342541,
 128519,
 -1,
 529256956,
 129394,
 529661951,
 528429368,
 -1,
 -57454,
 529572449,
 128570,
 -1,
 529621247,
 128571,
 -1,
 528400105,
 128527,
 529866649,
 528293918,
 -1,
 -57450,
 529849347,
 68411,
 -57449,
 529900380,
 128312,
 -57448,
 529935721,
 128313,
 -1,
 529997469,
 128745,
 -1,
 529833249,
 128684,
 530259889,
 528251963,
 -1,
 530325412,
 530203842,
 -1,
 530390946,
 530271404,
 -1,
 530456481,
 530345668,
 -1,
 -57441,
 530436019,
 128164,
 -57440,
 530469451,
 128564,
 -1,
 530521046,
 128716,
 -1,
 530445145,
 128554,
 -57437,
 530376012,
 128373,
 -1,
 530725717,
 128759,
 530915241,
 530278397,
 -1,
 530980776,
 530864992,
 -1,
 -57433,
 530959016,
 128578,
 -1,
 530995159,
 128577,
 -1,
 530919849,
 127829,
 531242926,
 530848330,
 -1,
 531308461,
 531208568,
 -1,
 -57428,
 531283650,
 11100,
 -1,
 531340551,
 11098,
 -1,
 531294662,
 42611,
 531628031,
 531211446,
 -1,
 -57424,
 531520956,
 129445,
 -1,
 531563661,
 127920,
 531767233,
 530198440,
 -1,
 531832760,
 531739618,
 -1,
 531898294,
 531776706,
 -1,
 -57419,
 531885074,
 129691,
 -1,
 531909345,
 128437,
 -57417,
 531865023,
 128220,
 -1,
 532050705,
 128624,
 532225979,
 531798721,
 -1,
 -57414,
 532201575,
 129410,
 -1,
 532260107,
 128756,
 532422589,
 532178113,
 127979,
 -1,
 532351263,
 127890,
 532553664,
 532355658,
 -1,
 -57409,
 532527465,
 129507,
 -1,
 532578928,
 9878,
 -1,
 532506621,
 983185,
 532815818,
 531731104,
 -1,
 532881350,
 532785394,
 -1,
 -57404,
 532843265,
 9924,
 -57403,
 532884873,
 127938,
 -1,
 532939172,
 127956,
 533143497,
 532814410,
 -1,
 -57400,
 533101029,
 128013,
 -1,
 533163114,
 128012,
 -1,
 533088380,
 129319,
 533405650,
 532772960,
 -1,
 533471182,
 533388475,
 -1,
 -57395,
 533436319,
 129448,
 -1,
 533497124,
 128128,
 533667793,
 533424125,
 -1,
 -57392,
 533613866,
 9975,
 -1,
 533659804,
 127935,
 -1,
 533604138,
 128761,
 533929944,
 533392033,
 -1,
 533995478,
 533862986,
 -1,
 -57387,
 533972301,
 128629,
 -1,
 534024864,
 129442,
 -57385,
 533979379,
 8275,
 -1,
 534146337,
 127946,
 534323164,
 533905876,
 -1,
 -57382,
 534256202,
 983133,
 -57381,
 534320208,
 983159,
 -1,
 534385451,
 983156,
 -1,
 534272468,
 983183,
 534653066,
 371755340,
 -1,
 534717059,
 534594754,
 -1,
 534782168,
 534680224,
 -1,
 534847702,
 534723876,
 -1,
 534913213,
 534826895,
 -1,
 534978640,
 534843627,
 -1,
 535044078,
 534911384,
 -1,
 -57371,
 534977005,
 125069,
 -57370,
 535042404,
 125123,
 -57369,
 535107593,
 124959,
 -57368,
 535172948,
 125036,
 -57367,
 535238286,
 124932,
 -57366,
 535303621,
 124952,
 -57365,
 535368837,
 125097,
 -57364,
 535434081,
 125088,
 -57363,
 535499457,
 124999,
 -1,
 535564639,
 125047,
 535764985,
 534976743,
 -1,
 -57360,
 535697826,
 124993,
 -57359,
 535763206,
 125024,
 -57358,
 535828533,
 125043,
 -57357,
 535893892,
 125056,
 -57356,
 535959281,
 125117,
 -57355,
 536024499,
 124985,
 -57354,
 536089740,
 125039,
 -57353,
 536155037,
 125049,
 -57352,
 536220317,
 125071,
 -1,
 536285636,
 125015,
 536485892,
 535697415,
 -1,
 -57349,
 536418823,
 124980,
 -57348,
 536484096,
 125021,
 -57347,
 536549554,
 125119,
 -57346,
 536614772,
 124933,
 -57345,
 536680058,
 125022,
 -57344,
 536745384,
 125089,
 -57343,
 536810679,
 124986,
 -57342,
 536875914,
 125080,
 -57341,
 536941121,
 125099,
 -1,
 537006365,
 125100,
 537206799,
 536418103,
 -1,
 -57338,
 537139729,
 125002,
 -57337,
 537205099,
 125068,
 -57336,
 537270388,
 125107,
 -57335,
 537335729,
 125074,
 -57334,
 537400979,
 124931,
 -57333,
 537466322,
 125108,
 -57332,
 537531560,
 125009,
 -57331,
 537596804,
 125076,
 -57330,
 537662169,
 124945,
 -1,
 537727346,
 125124,
 537927706,
 537138754,
 -1,
 -57327,
 537860531,
 124951,
 -57326,
 537925981,
 125121,
 -57325,
 537991305,
 125066,
 -57324,
 538056515,
 125095,
 -57323,
 538121950,
 125000,
 -57322,
 538187193,
 124987,
 -57321,
 538252435,
 125041,
 -57320,
 538317648,
 125044,
 -57319,
 538383000,
 125072,
 -1,
 538448262,
 125070,
 538648613,
 537859438,
 -1,
 -57316,
 538581531,
 124946,
 -57315,
 538646835,
 124934,
 -57314,
 538712160,
 125078,
 -57313,
 538777443,
 125046,
 -57312,
 538842880,
 124942,
 -57311,
 538908065,
 125090,
 -57310,
 538973418,
 125048,
 -57309,
 539038550,
 125037,
 -57308,
 539103823,
 125033,
 -1,
 539169071,
 125035,
 539369520,
 538580048,
 -1,
 -57305,
 539302375,
 125029,
 -57304,
 539367761,
 125028,
 -57303,
 539433112,
 125027,
 -57302,
 539498302,
 125020,
 -57301,
 539563637,
 125019,
 -57300,
 539628945,
 125018,
 -57299,
 539694396,
 125013,
 -57298,
 539759633,
 125012,
 -57297,
 539824867,
 125011,
 -1,
 539889984,
 125005,
 540090427,
 539300651,
 -1,
 -57294,
 540023208,
 125004,
 -57293,
 540088609,
 125003,
 -57292,
 540153947,
 124984,
 -57291,
 540219263,
 124983,
 -57290,
 540284569,
 124982,
 -57289,
 540349949,
 124998,
 -57288,
 540415267,
 124997,
 -57287,
 540480502,
 124996,
 -57286,
 540545724,
 124976,
 -1,
 540610960,
 124975,
 540811334,
 540021243,
 -1,
 -57283,
 540744194,
 124974,
 -57282,
 540809458,
 124992,
 -57281,
 540874766,
 124991,
 -57280,
 540940089,
 124990,
 -57279,
 541005544,
 124964,
 -57278,
 541070704,
 124963,
 -57277,
 541136031,
 124962,
 -57276,
 541201201,
 124957,
 -57275,
 541266441,
 124956,
 -1,
 541331699,
 124955,
 541589503,
 540741867,
 -1,
 -57272,
 541465024,
 124950,
 -57271,
 541530436,
 124949,
 -57270,
 541595758,
 124948,
 -57269,
 541661162,
 124938,
 -57268,
 541726454,
 124937,
 -57267,
 541791757,
 124936,
 -57266,
 541856941,
 124930,
 -57265,
 541922140,
 124929,
 -1,
 541987433,
 124928,
 542244863,
 534909435,
 -1,
 542253148,
 542120167,
 -1,
 -57261,
 542185913,
 124954,
 -57260,
 542251338,
 125079,
 -57259,
 542316647,
 125083,
 -57258,
 542381918,
 125034,
 -57257,
 542447340,
 125114,
 -57256,
 542512605,
 125065,
 -57255,
 542577857,
 125058,
 -57254,
 542643195,
 125113,
 -57253,
 542708262,
 124995,
 -1,
 542773505,
 124994,
 542974055,
 542185479,
 -1,
 -57250,
 542906797,
 124935,
 -57249,
 542972155,
 124973,
 -57248,
 543037584,
 125067,
 -57247,
 543102809,
 125032,
 -57246,
 543168158,
 125010,
 -57245,
 543233471,
 125082,
 -57244,
 543298856,
 125116,
 -57243,
 543363984,
 125081,
 -57242,
 543429293,
 125101,
 -1,
 543494521,
 125122,
 543694962,
 542906167,
 -1,
 -57239,
 543627745,
 125031,
 -57238,
 543693073,
 125061,
 -57237,
 543758382,
 125064,
 -57236,
 543823689,
 125063,
 -57235,
 543889113,
 124967,
 -57234,
 543954411,
 125120,
 -57233,
 544019570,
 124965,
 -57232,
 544084971,
 124977,
 -57231,
 544150131,
 125084,
 -1,
 544215354,
 125008,
 544415869,
 543626818,
 -1,
 -57228,
 544348626,
 125054,
 -57227,
 544414014,
 125093,
 -57226,
 544479300,
 125006,
 -57225,
 544544681,
 125052,
 -57224,
 544609919,
 125059,
 -57223,
 544675275,
 124953,
 -57222,
 544740540,
 124988,
 -57221,
 544805796,
 125109,
 -57220,
 544871117,
 125115,
 -1,
 544936173,
 124958,
 545136776,
 544347502,
 -1,
 -57217,
 545069530,
 125111,
 -57216,
 545134859,
 125096,
 -57215,
 545200286,
 124968,
 -57214,
 545265570,
 125051,
 -57213,
 545330868,
 125075,
 -57212,
 545396226,
 125118,
 -57211,
 545461550,
 124944,
 -57210,
 545526649,
 125086,
 -57209,
 545592045,
 125016,
 -1,
 545657141,
 125038,
 545857683,
 545068112,
 -1,
 -57206,
 545790497,
 124947,
 -57205,
 545855725,
 124961,
 -57204,
 545921053,
 124969,
 -57203,
 545986513,
 124979,
 -57202,
 546051716,
 124971,
 -57201,
 546117092,
 125112,
 -57200,
 546182271,
 125023,
 -57199,
 546247527,
 125087,
 -57198,
 546312804,
 124970,
 -1,
 546378025,
 125042,
 546578590,
 545788715,
 -1,
 -57195,
 546511302,
 125103,
 -57194,
 546576662,
 125040,
 -57193,
 546642049,
 125055,
 -57192,
 546707428,
 124939,
 -57191,
 546772678,
 125104,
 -57190,
 546837910,
 125094,
 -57189,
 546903268,
 125102,
 -57188,
 546968471,
 125077,
 -57187,
 547033832,
 125017,
 -1,
 547098982,
 125053,
 547299497,
 546509307,
 -1,
 -57184,
 547232204,
 125106,
 -57183,
 547297664,
 124940,
 -57182,
 547362939,
 125030,
 -57181,
 547428294,
 124978,
 -57180,
 547493580,
 125050,
 -57179,
 547558930,
 124941,
 -57178,
 547624099,
 125007,
 -57177,
 547689325,
 125092,
 -57176,
 547754556,
 125060,
 -1,
 547819850,
 124989,
 548020404,
 547229931,
 -1,
 -57173,
 547953191,
 125014,
 -57172,
 548018488,
 125091,
 -57171,
 548083752,
 125098,
 -57170,
 548149136,
 125057,
 -57169,
 548214440,
 125085,
 -57168,
 548279799,
 125001,
 -57167,
 548344936,
 124960,
 -57166,
 548410325,
 125073,
 -57165,
 548475446,
 125026,
 -1,
 548540685,
 124966,
 548798463,
 547953048,
 -1,
 -57162,
 548673570,
 125025,
 -57161,
 548739019,
 124981,
 -57160,
 548804169,
 124972,
 -57159,
 548869656,
 124943,
 -57158,
 548934809,
 125045,
 -57157,
 549000106,
 125110,
 -57156,
 549065342,
 125105,
 -1,
 549130531,
 125062,
 549331146,
 534855405,
 -1,
 549396673,
 549310454,
 -1,
 -57152,
 549384243,
 125128,
 -1,
 549414431,
 125129,
 549593284,
 549372372,
 -1,
 -57149,
 549549732,
 125132,
 -1,
 549605348,
 125133,
 549789895,
 549540339,
 -1,
 -57146,
 549758488,
 125130,
 -1,
 549811690,
 125131,
 -57144,
 549756697,
 125127,
 -57143,
 549951214,
 125135,
 -1,
 549996958,
 125134,
 550240255,
 549271221,
 -1,
 550248658,
 550162422,
 -1,
 550314193,
 550192322,
 -1,
 550379728,
 550277792,
 -1,
 -57137,
 550355412,
 125137,
 -1,
 550373921,
 125140,
 -1,
 550325213,
 125136,
 -1,
 550266386,
 125139,
 550707413,
 550201202,
 -1,
 -57132,
 550683092,
 125138,
 -1,
 550701601,
 125141,
 -1,
 550670214,
 125142,
 -57129,
 534823550,
 128697,
 -1,
 550937412,
 128334,
 551100794,
 534754274,
 -1,
 551166329,
 551066847,
 -1,
 551231827,
 551107332,
 -1,
 551297312,
 551197175,
 -1,
 551362799,
 551276534,
 -1,
 551428325,
 551348897,
 -1,
 551493859,
 551393985,
 68033,
 551616511,
 551419904,
 -1,
 551624930,
 551511922,
 68051,
 -1,
 551553559,
 68078,
 -1,
 551605300,
 68060,
 551878655,
 551439450,
 68042,
 -1,
 551750167,
 68069,
 551952621,
 551378364,
 -1,
 552018155,
 551925678,
 68034,
 552140799,
 551944192,
 -1,
 552149226,
 552036210,
 68052,
 -1,
 552077847,
 68079,
 -1,
 552129588,
 68061,
 552402943,
 551973937,
 68043,
 -1,
 552274455,
 68070,
 552534015,
 551897825,
 68041,
 -1,
 552405527,
 68068,
 552607998,
 551338452,
 -1,
 552673527,
 552564388,
 68037,
 552739061,
 552599552,
 -1,
 552804596,
 552691570,
 68055,
 -1,
 552733207,
 68082,
 -1,
 552784948,
 68064,
 553058303,
 552721548,
 68046,
 -1,
 552929815,
 68073,
 553189375,
 552620004,
 68038,
 553197820,
 553058304,
 -1,
 553263355,
 553150322,
 68056,
 -1,
 553191959,
 68083,
 -1,
 553243700,
 68065,
 553517055,
 553180300,
 68047,
 -1,
 553388567,
 68074,
 553591055,
 552554995,
 -1,
 553656583,
 553556673,
 -1,
 553722117,
 553640870,
 68035,
 553844735,
 553648128,
 -1,
 553853188,
 553740146,
 68053,
 -1,
 553781783,
 68080,
 -1,
 553833524,
 68062,
 554106879,
 553697555,
 68044,
 -1,
 553978391,
 68071,
 554237951,
 553609213,
 -1,
 554246413,
 554165900,
 68036,
 554369023,
 554172416,
 -1,
 554377484,
 554264434,
 68054,
 -1,
 554306071,
 68081,
 -1,
 554357812,
 68063,
 554631167,
 554194999,
 68045,
 -1,
 554502679,
 68072,
 554705173,
 553555694,
 68040,
 554770708,
 554631168,
 -1,
 554836243,
 554723186,
 68058,
 -1,
 554764823,
 68085,
 -1,
 554816564,
 68067,
 -1,
 554753167,
 68076,
 555098395,
 554650014,
 68039,
 555163930,
 555024384,
 -1,
 555229465,
 555116402,
 68057,
 -1,
 555158039,
 68084,
 -1,
 555209780,
 68066,
 -1,
 555152272,
 68075,
 555548671,
 555065113,
 68032,
 555614207,
 555417600,
 -1,
 555622687,
 555509618,
 68050,
 -1,
 555551255,
 68077,
 -1,
 555602996,
 68059,
 555819329,
 551255099,
 -1,
 555884862,
 555765520,
 -1,
 555950374,
 555864054,
 -1,
 -57052,
 555915969,
 68022,
 -57051,
 555959490,
 68021,
 -1,
 556014154,
 68020,
 556212521,
 555925972,
 -1,
 -57048,
 556156098,
 68017,
 -1,
 556210762,
 68015,
 556409132,
 556176032,
 -1,
 -57045,
 556352706,
 68010,
 -1,
 556407370,
 68009,
 556605743,
 556365920,
 -1,
 -57042,
 556555726,
 68013,
 -1,
 556603978,
 68018,
 556802353,
 556538442,
 68000,
 -1,
 556774978,
 68016,
 -57038,
 556790714,
 68004,
 -57037,
 556919521,
 68005,
 -57036,
 556971092,
 68011,
 -57035,
 557036077,
 68019,
 -57034,
 557099553,
 68007,
 -57033,
 557161153,
 68003,
 -57032,
 557222306,
 68008,
 -57031,
 557284485,
 68012,
 -57030,
 557344765,
 68002,
 -57029,
 557408850,
 68014,
 -57028,
 557466818,
 68001,
 -57027,
 557530112,
 68023,
 -1,
 557590840,
 68006,
 557842431,
 555850853,
 -1,
 -57024,
 557760260,
 68030,
 -1,
 557804839,
 68031,
 558039039,
 555767615,
 -1,
 558047558,
 557961206,
 -1,
 -57020,
 558035181,
 68087,
 -57019,
 558065394,
 68088,
 -1,
 558123836,
 68095,
 558309705,
 558023124,
 -1,
 -57016,
 558266062,
 68091,
 -1,
 558321706,
 68092,
 558506316,
 558276381,
 -1,
 -57013,
 558488466,
 68086,
 -1,
 558521993,
 68029,
 558702927,
 558453235,
 -1,
 -57010,
 558671509,
 68089,
 -1,
 558724719,
 68090,
 558899538,
 558646466,
 -1,
 -57007,
 558859007,
 68028,
 -1,
 558918549,
 68093,
 -1,
 558864135,
 68094,
 559218687,
 551182976,
 -1,
 559227255,
 559121058,
 -1,
 559292763,
 559206390,
 -1,
 559358296,
 559236290,
 67994,
 -1,
 559288151,
 67995,
 559489370,
 559290954,
 67992,
 -1,
 559419223,
 67993,
 -1,
 559454913,
 67996,
 559685984,
 559256224,
 -1,
 559751518,
 559629506,
 67980,
 -1,
 559681367,
 67981,
 559939583,
 559684170,
 67978,
 -1,
 559812439,
 67979,
 560013668,
 559661524,
 -1,
 560079203,
 559946314,
 67987,
 -1,
 560009047,
 67988,
 -1,
 560022722,
 67989,
 560275814,
 559985748,
 67982,
 -1,
 560205655,
 67983,
 560406889,
 560232544,
 -1,
 -56984,
 560356814,
 67985,
 -1,
 560405066,
 67990,
 560603499,
 560343352,
 67974,
 -1,
 560533335,
 67975,
 -56980,
 560591802,
 67972,
 -56979,
 560720609,
 67973,
 -56978,
 560771629,
 67991,
 -56977,
 560835105,
 67976,
 -56976,
 560896705,
 67971,
 -56975,
 560957858,
 67977,
 -56974,
 561020037,
 67984,
 -56973,
 561080317,
 67970,
 -56972,
 561144402,
 67986,
 -56971,
 561202370,
 67969,
 -56970,
 561265664,
 67997,
 -1,
 561322570,
 67968,
 561577983,
 559206358,
 67998,
 -1,
 561450839,
 67999,
 -1,
 551136510,
 129500,
 561717763,
 551041877,
 -1,
 561783272,
 561662091,
 -1,
 561848737,
 561758676,
 -1,
 561914272,
 561810115,
 -1,
 561979777,
 561877664,
 93819,
 -56960,
 561967926,
 93815,
 -1,
 561993811,
 983265,
 562176388,
 561912394,
 93805,
 -56957,
 562157258,
 93796,
 -1,
 562194429,
 93822,
 562372998,
 562164534,
 93823,
 -1,
 562355387,
 93811,
 562504072,
 562338497,
 93821,
 -1,
 562447554,
 93818,
 562635146,
 562460768,
 93804,
 -1,
 562604496,
 93798,
 562766220,
 562585020,
 983264,
 -1,
 562735568,
 93814,
 -56947,
 562755141,
 93797,
 -56946,
 562885168,
 93816,
 -56945,
 562948769,
 93795,
 -56944,
 563013018,
 93794,
 -56943,
 563076283,
 93810,
 -56942,
 563138550,
 93800,
 -56941,
 563200468,
 93793,
 -56940,
 563262434,
 93820,
 -56939,
 563327502,
 93813,
 -56938,
 563390928,
 93799,
 -56937,
 563448140,
 93792,
 -56936,
 563510331,
 93812,
 -56935,
 563574593,
 93806,
 -56934,
 563636221,
 93803,
 -56933,
 563697747,
 93801,
 -56932,
 563761651,
 93802,
 -56931,
 563823810,
 93807,
 -56930,
 563886933,
 93817,
 -56929,
 563949480,
 93809,
 -1,
 564013319,
 93808,
 -1,
 561902956,
 93849,
 564273606,
 561786792,
 -1,
 564339141,
 564208646,
 -1,
 564404646,
 564302496,
 93787,
 -56923,
 564392758,
 93783,
 -1,
 564418643,
 983263,
 564601257,
 564337226,
 93773,
 -56920,
 564582090,
 93764,
 -1,
 564619261,
 93790,
 564797867,
 564589366,
 93791,
 -1,
 564780219,
 93779,
 564928941,
 564763329,
 93789,
 -1,
 564872386,
 93786,
 565060015,
 564885600,
 93772,
 -1,
 565029328,
 93766,
 565191089,
 565009852,
 983262,
 -1,
 565160400,
 93782,
 -56910,
 565179973,
 93765,
 -56909,
 565310000,
 93784,
 -56908,
 565373601,
 93763,
 -56907,
 565437850,
 93762,
 -56906,
 565501115,
 93778,
 -56905,
 565563382,
 93768,
 -56904,
 565625300,
 93761,
 -56903,
 565687266,
 93788,
 -56902,
 565752334,
 93781,
 -56901,
 565815760,
 93767,
 -56900,
 565872972,
 93760,
 -56899,
 565935163,
 93780,
 -56898,
 565999425,
 93774,
 -56897,
 566061053,
 93771,
 -56896,
 566122579,
 93769,
 -56895,
 566186483,
 93770,
 -56894,
 566248642,
 93775,
 -56893,
 566311765,
 93785,
 -56892,
 566374312,
 93777,
 -1,
 566438151,
 93776,
 -1,
 564305513,
 93847,
 566698455,
 564215533,
 -1,
 566763980,
 566677494,
 -1,
 566829514,
 566751283,
 93826,
 -1,
 566755361,
 93845,
 567017471,
 566781471,
 93827,
 -1,
 566886433,
 93846,
 567091663,
 566739412,
 -1,
 -56882,
 567047844,
 93830,
 -1,
 567103460,
 93831,
 567288273,
 567058201,
 93825,
 -1,
 567214113,
 93844,
 567419348,
 567235059,
 -1,
 -56877,
 567387672,
 93828,
 -1,
 567440874,
 93829,
 -56875,
 567408432,
 93824,
 -56874,
 567580398,
 93833,
 -1,
 567626142,
 93832,
 567812582,
 566663671,
 -1,
 567878108,
 567791606,
 -1,
 -56870,
 567864361,
 93836,
 -56869,
 567894943,
 93837,
 -1,
 567954145,
 93834,
 568140255,
 567853524,
 -1,
 -56866,
 568096474,
 93840,
 -1,
 568152120,
 93841,
 568336866,
 568087027,
 -1,
 -56863,
 568305324,
 93838,
 -1,
 568355476,
 93839,
 568533477,
 568280258,
 -1,
 -56860,
 568492793,
 93835,
 -1,
 568552379,
 93842,
 -1,
 568497941,
 93843,
 -56857,
 567760962,
 93848,
 -1,
 568742151,
 93850,
 568983551,
 561735677,
 -1,
 568992258,
 568909798,
 -1,
 569057776,
 568967636,
 -1,
 569123310,
 569013927,
 -1,
 -56851,
 569101232,
 128950,
 -1,
 569159389,
 128971,
 -56849,
 569084637,
 9900,
 -1,
 569254097,
 128938,
 569450997,
 569004531,
 -1,
 569516532,
 569419364,
 -1,
 -56845,
 569486746,
 128967,
 -1,
 569519300,
 128965,
 -1,
 569472603,
 128944,
 569778680,
 569437415,
 -1,
 -56841,
 569756612,
 128911,
 -1,
 569783315,
 9898,
 569975291,
 569758880,
 -1,
 -56838,
 569945498,
 128963,
 -1,
 569978052,
 128961,
 570171902,
 569919908,
 -1,
 -56835,
 570149808,
 128956,
 -1,
 570207965,
 128974,
 570368513,
 570108167,
 -1,
 -56832,
 570334597,
 128901,
 -1,
 570391735,
 9899,
 -1,
 570318083,
 128931,
 -1,
 568938457,
 11852,
 570696301,
 561663678,
 -1,
 570761793,
 570653755,
 -1,
 570827328,
 570707728,
 -1,
 570892813,
 570790560,
 -1,
 570958345,
 570842223,
 43977,
 -1,
 570885230,
 44001,
 571089419,
 570890826,
 43973,
 -1,
 571016302,
 43999,
 -56820,
 571077562,
 43747,
 -1,
 571183850,
 43752,
 571351572,
 570871798,
 -1,
 571417105,
 571330550,
 -1,
 -56816,
 571366862,
 43749,
 -1,
 571415114,
 43748,
 571613715,
 571370602,
 43975,
 -1,
 571540590,
 44000,
 -1,
 571565527,
 43978,
 571810330,
 571292501,
 -1,
 571875864,
 571751253,
 -1,
 -56809,
 571825614,
 43751,
 -1,
 571873866,
 43750,
 -56807,
 571829354,
 43991,
 -1,
 572024279,
 43993,
 572203550,
 571785684,
 -1,
 -56804,
 572179113,
 43754,
 -56803,
 572218830,
 43753,
 -1,
 572268760,
 43969,
 572465698,
 572172752,
 -1,
 572531233,
 572398154,
 43972,
 -1,
 572458094,
 43998,
 -1,
 572481293,
 43984,
 572727846,
 572422240,
 -1,
 572793381,
 572693745,
 43968,
 -1,
 572720238,
 43995,
 -1,
 572745175,
 43976,
 572989992,
 572690467,
 43971,
 -1,
 572916846,
 43997,
 573121066,
 572947786,
 43970,
 -1,
 573047918,
 43996,
 573252141,
 573077313,
 -1,
 -56788,
 573205610,
 43990,
 -1,
 573267725,
 43987,
 573448751,
 573204477,
 43983,
 -1,
 573375598,
 44002,
 573579826,
 573397075,
 -1,
 -56783,
 573545713,
 43986,
 -1,
 573597143,
 43992,
 573776437,
 573518406,
 -1,
 -56780,
 573729898,
 43974,
 -1,
 573774410,
 43746,
 573973048,
 573712647,
 -1,
 -56777,
 573923085,
 43994,
 -1,
 573971018,
 43989,
 -56775,
 573961246,
 43980,
 -56774,
 574155511,
 43979,
 -56773,
 574218313,
 43982,
 -56772,
 574272712,
 43988,
 -56771,
 574331585,
 43745,
 -56770,
 574383971,
 43981,
 -56769,
 574440642,
 43744,
 -1,
 574498765,
 43985,
 -1,
 570810346,
 44012,
 574759510,
 570746266,
 -1,
 574825045,
 574728522,
 -1,
 574890569,
 574757450,
 -1,
 574956103,
 574822986,
 -1,
 -56762,
 574938299,
 43759,
 -1,
 574973949,
 43757,
 -56760,
 574938299,
 43758,
 -1,
 575116110,
 44005,
 575283788,
 574872763,
 -1,
 -56757,
 575265979,
 43756,
 -1,
 575312718,
 44008,
 575480399,
 575236093,
 -1,
 -56754,
 575443790,
 44004,
 -1,
 575498237,
 43755,
 -56752,
 575468688,
 44006,
 -56751,
 575662356,
 43765,
 -56750,
 575720231,
 44007,
 -56749,
 575774484,
 44003,
 -56748,
 575838775,
 44010,
 -1,
 575877908,
 44009,
 -1,
 574780232,
 43766,
 576135780,
 574701293,
 -1,
 576201306,
 576114678,
 -1,
 -56743,
 576188467,
 44018,
 -1,
 576218655,
 44019,
 576397917,
 576176596,
 -1,
 -56740,
 576353956,
 44022,
 -1,
 576409572,
 44023,
 576594528,
 576344563,
 -1,
 -56737,
 576562712,
 44020,
 -1,
 576615914,
 44021,
 -56735,
 576583472,
 44016,
 -56734,
 576757529,
 44017,
 -56733,
 576820974,
 44025,
 -1,
 576866718,
 44024,
 577053288,
 576068170,
 -1,
 -56730,
 577024333,
 44013,
 -56729,
 577083291,
 43762,
 -1,
 577134550,
 43761,
 577315435,
 576992013,
 -1,
 -56726,
 577259917,
 44011,
 -1,
 577315109,
 43760,
 -56724,
 577302944,
 43764,
 -1,
 577490842,
 43763,
 577643132,
 570677250,
 -1,
 577708667,
 577595731,
 -1,
 577774197,
 577687542,
 -1,
 577839731,
 577761506,
 -1,
 -56718,
 577808435,
 9173,
 -1,
 577861643,
 9174,
 -56716,
 577814117,
 9175,
 -1,
 577982202,
 9176,
 578167416,
 577734250,
 -1,
 -56713,
 578149494,
 9172,
 -1,
 578209514,
 9170,
 -56711,
 578144008,
 9171,
 -56710,
 578333875,
 9177,
 -1,
 578367125,
 9169,
 -1,
 577673921,
 128647,
 578626175,
 577581710,
 -1,
 -56706,
 578585139,
 129471,
 -1,
 578626854,
 129470,
 -56704,
 578604077,
 983172,
 -56703,
 578785384,
 128221,
 -56702,
 578848296,
 127816,
 -1,
 578889482,
 127830,
 579085517,
 534649418,
 -1,
 579150586,
 579048096,
 128104,
 579216075,
 579103088,
 -1,
 579281591,
 579175074,
 -1,
 579347085,
 579256788,
 -1,
 579412619,
 579279434,
 -1,
 -56694,
 579374444,
 68312,
 -1,
 579419721,
 68317,
 -56692,
 579389106,
 68323,
 -1,
 579560275,
 68322,
 579740305,
 579325942,
 -1,
 -56689,
 579690278,
 68309,
 -56688,
 579751626,
 68302,
 -1,
 579807397,
 68324,
 580002453,
 579672650,
 -1,
 -56685,
 579990781,
 68313,
 -56684,
 580026987,
 68288,
 -1,
 580069626,
 68314,
 580264600,
 579991109,
 -1,
 -56681,
 580214897,
 68298,
 -1,
 580266234,
 68297,
 580461211,
 580252208,
 -1,
 -56678,
 580428455,
 68319,
 -1,
 580461562,
 68305,
 580657822,
 580432398,
 -1,
 -56675,
 580625063,
 68318,
 -1,
 580674767,
 68320,
 580854433,
 580614240,
 -1,
 -56672,
 580804590,
 68306,
 -1,
 580854778,
 68304,
 581051044,
 580810561,
 -1,
 -56669,
 581001329,
 68300,
 -1,
 581052666,
 68299,
 581247654,
 581001343,
 68294,
 -1,
 581227341,
 68301,
 581378729,
 581195859,
 -1,
 -56664,
 581332203,
 68291,
 -1,
 581395277,
 68292,
 581575340,
 581319509,
 -1,
 -56661,
 581525286,
 68308,
 -1,
 581574607,
 68293,
 581771951,
 581511431,
 -1,
 -56658,
 581722633,
 68290,
 -1,
 581783242,
 68289,
 -56656,
 581760446,
 68303,
 -56655,
 581954513,
 68295,
 -56654,
 582006954,
 68321,
 -56653,
 582069221,
 68315,
 -56652,
 582130227,
 68311,
 -56651,
 582192517,
 68310,
 -56650,
 582253954,
 68307,
 -1,
 582308526,
 68316,
 582492864,
 579252578,
 -1,
 582558396,
 582434707,
 -1,
 582623931,
 582537206,
 68340,
 -1,
 582553382,
 68339,
 -1,
 582606366,
 68338,
 -56643,
 582540242,
 68341,
 -56642,
 582798585,
 68336,
 -56641,
 582845565,
 68342,
 -1,
 582898985,
 68337,
 583082695,
 582457847,
 -1,
 583148228,
 583061494,
 -1,
 -56637,
 583134289,
 68334,
 -1,
 583158497,
 68333,
 583344838,
 583114521,
 68331,
 -1,
 583271297,
 68335,
 -1,
 583292066,
 68332,
 583541450,
 583015288,
 -1,
 -56631,
 583477997,
 68326,
 -1,
 583539618,
 68325,
 -1,
 583518266,
 68296,
 583803628,
 579157052,
 -1,
 583869160,
 583762594,
 -1,
 583934689,
 583801418,
 -1,
 584000209,
 583909844,
 2126,
 -56624,
 583988805,
 2129,
 -1,
 584015292,
 2132,
 584196819,
 583978998,
 2133,
 -1,
 584175606,
 2120,
 584327893,
 584153184,
 2122,
 -1,
 584303273,
 2121,
 -56618,
 584316485,
 2118,
 -56617,
 584430562,
 2131,
 -56616,
 584495630,
 2130,
 -56615,
 584559056,
 2128,
 -56614,
 584618656,
 2125,
 -56613,
 584681804,
 2124,
 -56612,
 584743995,
 2123,
 -56611,
 584805691,
 2136,
 -56610,
 584867260,
 2116,
 -56609,
 584931411,
 2114,
 -56608,
 584989525,
 2115,
 -1,
 585050375,
 2113,
 585245412,
 583886845,
 -1,
 -56605,
 585224182,
 2119,
 -1,
 585274016,
 2127,
 -56603,
 585229526,
 2117,
 -56602,
 585398519,
 2135,
 -56601,
 585457415,
 2112,
 -1,
 585516173,
 2134,
 -56599,
 583854446,
 2138,
 -56598,
 585675094,
 2142,
 -56597,
 585718313,
 2139,
 -1,
 585768381,
 2137,
 585966325,
 583729152,
 -1,
 586031856,
 585952848,
 -1,
 -56593,
 586013399,
 128115,
 -1,
 586046765,
 128114,
 586228467,
 585985342,
 -1,
 -56590,
 586210187,
 129333,
 -1,
 586231633,
 128372,
 -56588,
 586169460,
 128378,
 -1,
 586359409,
 128107,
 -56586,
 585948534,
 129469,
 -56585,
 586535549,
 128368,
 -56584,
 586596983,
 128094,
 -56583,
 586636349,
 129389,
 -1,
 586688277,
 8380,
 586883961,
 579100092,
 -1,
 586949442,
 586840100,
 -1,
 587014922,
 586924500,
 -1,
 587080450,
 586970804,
 -1,
 587145985,
 587018152,
 -1,
 -56576,
 587101098,
 127006,
 -1,
 587161621,
 126988,
 -1,
 587082161,
 126997,
 587408135,
 587026445,
 -1,
 587473670,
 587345832,
 -1,
 -56571,
 587428778,
 127007,
 -1,
 587489301,
 126989,
 -1,
 587409841,
 126998,
 -56568,
 587391039,
 127015,
 -56567,
 587706549,
 127014,
 -1,
 587769629,
 126977,
 587932437,
 586993654,
 -1,
 587997968,
 587919579,
 -1,
 588063503,
 587935656,
 -1,
 -56562,
 588018602,
 127002,
 -1,
 588079125,
 126984,
 -1,
 587999665,
 126993,
 588382207,
 587949777,
 -1,
 588391188,
 588263336,
 -1,
 -56557,
 588346282,
 127003,
 -1,
 588406805,
 126985,
 -1,
 588327345,
 126994,
 588653344,
 587878899,
 -1,
 588718875,
 588621404,
 -1,
 588784410,
 588656552,
 -1,
 -56551,
 588739498,
 127004,
 -1,
 588800021,
 126986,
 -1,
 588720561,
 126995,
 589103103,
 588674615,
 -1,
 589112095,
 588984232,
 -1,
 -56546,
 589067178,
 127005,
 -1,
 589127701,
 126987,
 -1,
 589048241,
 126996,
 589374247,
 588618433,
 -1,
 589439782,
 589337826,
 -1,
 589505317,
 589377448,
 -1,
 -56540,
 589460394,
 127001,
 -1,
 589520917,
 126983,
 -1,
 589441457,
 126992,
 -1,
 589411916,
 127011,
 589833006,
 589337248,
 -1,
 589898541,
 589786779,
 -1,
 589964076,
 589836200,
 -1,
 -56533,
 589919146,
 127009,
 -1,
 589979669,
 126991,
 -1,
 589900209,
 127000,
 -1,
 589866064,
 126979,
 590291765,
 589776066,
 -1,
 590357300,
 590244738,
 -1,
 590422835,
 590294952,
 -1,
 -56526,
 590377898,
 127008,
 -1,
 590438421,
 126990,
 -1,
 590358961,
 126999,
 -1,
 590292706,
 126976,
 590750521,
 590277281,
 -1,
 -56521,
 590704963,
 127017,
 -56520,
 590767047,
 126982,
 -1,
 590827145,
 126978,
 591012668,
 590686520,
 -1,
 -56517,
 590974055,
 127012,
 -1,
 591017248,
 127019,
 -56515,
 590985067,
 126980,
 -56514,
 591179348,
 127010,
 -56513,
 591231001,
 127018,
 -56512,
 591289622,
 126981,
 -56511,
 591344569,
 127013,
 -1,
 591407212,
 127016,
 591659007,
 586882851,
 -1,
 591668085,
 591559739,
 -1,
 591733620,
 591613712,
 -1,
 591799115,
 591712246,
 -1,
 591864649,
 591777782,
 -1,
 -56504,
 591814094,
 69983,
 -1,
 591862346,
 69982,
 -56502,
 591814094,
 69988,
 -1,
 591993418,
 69987,
 592192337,
 591739733,
 -1,
 592257871,
 592132949,
 -1,
 -56498,
 592207310,
 69985,
 -1,
 592255562,
 69984,
 -56496,
 592207310,
 69990,
 -1,
 592386634,
 69989,
 592585557,
 592155296,
 -1,
 -56493,
 592573370,
 69981,
 -56492,
 592614122,
 69986,
 -1,
 592648778,
 69991,
 592847704,
 592557026,
 -1,
 -56489,
 592819284,
 70002,
 -1,
 592845386,
 69997,
 593044315,
 592816592,
 -1,
 -56486,
 592993742,
 69993,
 -1,
 593041994,
 69992,
 593240926,
 593000544,
 -1,
 -56483,
 593190350,
 69974,
 -1,
 593238602,
 69973,
 593437537,
 593196865,
 -1,
 -56480,
 593386958,
 69980,
 -1,
 593435210,
 69979,
 593634148,
 593385555,
 -1,
 -56477,
 593583566,
 69976,
 -1,
 593631818,
 69975,
 593830759,
 593571752,
 -1,
 -56474,
 593780174,
 69978,
 -1,
 593828426,
 69977,
 594027370,
 593766663,
 -1,
 -56471,
 593976782,
 69995,
 -1,
 594025034,
 69994,
 -56469,
 594011565,
 69999,
 -56468,
 594205883,
 69970,
 -56467,
 594264745,
 70000,
 -56466,
 594320065,
 69972,
 -56465,
 594381218,
 69996,
 -56464,
 594443397,
 69998,
 -56463,
 594503677,
 69969,
 -56462,
 594566606,
 70001,
 -56461,
 594625730,
 69971,
 -1,
 594680394,
 69968,
 -1,
 591686449,
 70006,
 594944888,
 591643092,
 -1,
 -56457,
 594897953,
 70003,
 -1,
 594954000,
 70005,
 -1,
 594877323,
 70004,
 595207134,
 586858964,
 -1,
 595272669,
 595141762,
 -1,
 595338168,
 595231394,
 -1,
 595403651,
 595316726,
 -1,
 595469184,
 595382262,
 -1,
 -56449,
 595418574,
 72983,
 -1,
 595466826,
 72982,
 -56447,
 595440724,
 73008,
 -56446,
 595615182,
 72988,
 -1,
 595663434,
 72987,
 595862408,
 595366560,
 -1,
 -56443,
 595850170,
 72981,
 -56442,
 595890922,
 72986,
 -56441,
 595941538,
 72976,
 -1,
 595991114,
 72991,
 596190094,
 595802965,
 -1,
 596255628,
 596130645,
 -1,
 -56437,
 596205006,
 72985,
 -1,
 596253258,
 72984,
 -56435,
 596205006,
 72990,
 -1,
 596384330,
 72989,
 596583314,
 596122186,
 72960,
 -56432,
 596565179,
 72971,
 -56431,
 596600829,
 72968,
 -1,
 596646474,
 72961,
 596845462,
 596558292,
 -1,
 -56428,
 596820649,
 73002,
 -56427,
 596860366,
 73001,
 -1,
 596908618,
 73003,
 597107610,
 596801632,
 -1,
 -56424,
 597085225,
 73006,
 -56423,
 597122510,
 72973,
 -1,
 597170762,
 72972,
 597369758,
 597063489,
 -1,
 -56420,
 597334673,
 73007,
 -56419,
 597384654,
 72980,
 -1,
 597432906,
 72979,
 597631904,
 597351611,
 72964,
 -1,
 597613755,
 72965,
 597762979,
 597600720,
 -1,
 -56414,
 597712334,
 72993,
 -1,
 597760586,
 72992,
 597959590,
 597720123,
 -1,
 -56411,
 597916805,
 73005,
 -1,
 597957194,
 72999,
 598156200,
 597911549,
 72962,
 -1,
 598108157,
 72963,
 598287275,
 598104147,
 -1,
 -56406,
 598236622,
 72975,
 -1,
 598284874,
 72974,
 598483886,
 598224808,
 -1,
 -56403,
 598433230,
 72978,
 -1,
 598481482,
 72977,
 598680497,
 598419719,
 -1,
 -56400,
 598629838,
 72995,
 -1,
 598678090,
 72994,
 -56398,
 598668218,
 72997,
 -56397,
 598861229,
 73000,
 -56396,
 598914132,
 72998,
 -56395,
 598973121,
 72969,
 -56394,
 599034274,
 72996,
 -56393,
 599088590,
 73004,
 -1,
 599147714,
 72966,
 599335878,
 595322266,
 -1,
 599401413,
 599304522,
 -1,
 599466942,
 599333450,
 -1,
 -56388,
 599448763,
 73023,
 -56387,
 599484413,
 73020,
 -1,
 599530058,
 73009,
 599729088,
 599448763,
 73012,
 -1,
 599710907,
 73013,
 599860162,
 599681021,
 73010,
 -1,
 599812093,
 73011,
 -56381,
 599845220,
 73014,
 -56380,
 599956161,
 73021,
 -1,
 599999682,
 73018,
 -1,
 599356232,
 73029,
 600253396,
 599277293,
 -1,
 600318922,
 600231926,
 -1,
 -56375,
 600305715,
 73042,
 -1,
 600335903,
 73043,
 600515533,
 600293844,
 -1,
 -56372,
 600471204,
 73046,
 -1,
 600526820,
 73047,
 600712144,
 600461811,
 -1,
 -56369,
 600679960,
 73044,
 -1,
 600733162,
 73045,
 -56367,
 600700720,
 73040,
 -56366,
 600874777,
 73041,
 -56365,
 600938222,
 73049,
 -1,
 600983966,
 73048,
 601170906,
 600229851,
 -1,
 -56362,
 601155860,
 73025,
 -56361,
 601201133,
 73026,
 -56360,
 601251457,
 73028,
 -56359,
 601305174,
 73027,
 -1,
 601367494,
 73024,
 601620479,
 601142242,
 -1,
 -56356,
 601509071,
 73030,
 -1,
 601561841,
 73031,
 -1,
 595228820,
 127405,
 601826365,
 595178466,
 -1,
 601891899,
 601764657,
 -1,
 601957387,
 601866708,
 -1,
 602022920,
 601939414,
 -1,
 602088424,
 602001398,
 -1,
 602153958,
 602063316,
 -1,
 -56347,
 602103246,
 72867,
 -1,
 602151498,
 72866,
 -56345,
 602103246,
 72859,
 -1,
 602282570,
 72858,
 602481644,
 602051232,
 -1,
 -56342,
 602469306,
 72857,
 -56341,
 602495138,
 72853,
 -1,
 602544714,
 72861,
 602743791,
 602469957,
 -1,
 -56338,
 602693070,
 72870,
 -1,
 602741322,
 72871,
 602940402,
 602718676,
 -1,
 -56335,
 602889678,
 72876,
 -1,
 602937930,
 72877,
 603137013,
 602909136,
 -1,
 -56332,
 603086286,
 72863,
 -1,
 603134538,
 72862,
 603333624,
 603093088,
 -1,
 -56329,
 603282894,
 72851,
 -1,
 603331146,
 72850,
 603530235,
 603274069,
 -1,
 -56326,
 603518579,
 72868,
 -1,
 603527754,
 72860,
 603726846,
 603467688,
 -1,
 -56323,
 603676110,
 72855,
 -1,
 603724362,
 72854,
 -56321,
 603714490,
 72873,
 -56320,
 603908833,
 72869,
 -56319,
 603960404,
 72874,
 -56318,
 604015010,
 72865,
 -56317,
 604077189,
 72875,
 -56316,
 604141407,
 72856,
 -56315,
 604200398,
 72878,
 -56314,
 604264610,
 72852,
 -56313,
 604318008,
 72864,
 -1,
 604379722,
 72879,
 604635135,
 601975810,
 -1,
 -56310,
 604516476,
 72886,
 -1,
 604578758,
 72885,
 604775475,
 601916066,
 -1,
 604840978,
 604753910,
 -1,
 604906512,
 604815828,
 -1,
 -56305,
 604855758,
 72835,
 -1,
 604904010,
 72834,
 -56303,
 604855758,
 72827,
 -1,
 605035082,
 72826,
 605234198,
 604803744,
 -1,
 -56300,
 605221818,
 72825,
 -56299,
 605247650,
 72821,
 -1,
 605297226,
 72829,
 605496345,
 605222469,
 -1,
 -56296,
 605445582,
 72838,
 -1,
 605493834,
 72839,
 605692956,
 605471188,
 -1,
 -56293,
 605642190,
 72844,
 -1,
 605690442,
 72845,
 605889567,
 605661648,
 -1,
 -56290,
 605838798,
 72831,
 -1,
 605887050,
 72830,
 606086178,
 605845600,
 -1,
 -56287,
 606035406,
 72819,
 -1,
 606083658,
 72818,
 606282789,
 606026581,
 -1,
 -56284,
 606271091,
 72836,
 -1,
 606280266,
 72828,
 606479400,
 606220200,
 -1,
 -56281,
 606428622,
 72823,
 -1,
 606476874,
 72822,
 -56279,
 606467002,
 72841,
 -56278,
 606661345,
 72837,
 -56277,
 606712916,
 72842,
 -56276,
 606767522,
 72833,
 -56275,
 606829701,
 72843,
 -56274,
 606893919,
 72824,
 -56273,
 606952910,
 72846,
 -56272,
 607017122,
 72820,
 -56271,
 607070520,
 72832,
 -56270,
 607132234,
 72847,
 -1,
 607194970,
 72840,
 607396921,
 604760618,
 -1,
 -56267,
 607378619,
 72882,
 -56266,
 607427265,
 72884,
 -56265,
 607479805,
 72881,
 -56264,
 607536322,
 72883,
 -1,
 607591183,
 72880,
 -56262,
 607357841,
 72817,
 -1,
 607740053,
 72816,
 -56260,
 601871668,
 129355,
 -1,
 607893969,
 9901,
 608052344,
 601783355,
 -1,
 608117875,
 607987932,
 -1,
 608183375,
 608076450,
 -1,
 608248906,
 608121692,
 -1,
 608314436,
 608205883,
 3453,
 608436223,
 608271419,
 3454,
 -1,
 608336955,
 3414,
 608511046,
 608277152,
 3451,
 -1,
 608473760,
 3450,
 -56249,
 608498486,
 3413,
 -56248,
 608616557,
 3452,
 -56247,
 608667980,
 3412,
 -1,
 608729184,
 3455,
 -56245,
 608233166,
 3332,
 -56244,
 608885373,
 3386,
 -56243,
 608933826,
 3369,
 -56242,
 608977029,
 3406,
 -1,
 609035424,
 3423,
 609231969,
 608130879,
 -1,
 609297500,
 609197853,
 -1,
 609363028,
 609275894,
 -1,
 -56237,
 609348680,
 3419,
 -1,
 609373217,
 3420,
 609559639,
 609309171,
 -1,
 -56234,
 609526885,
 3417,
 -1,
 609577627,
 3422,
 -56232,
 609536244,
 3446,
 -56231,
 609727206,
 3443,
 -56230,
 609787943,
 3416,
 -56229,
 609836681,
 3444,
 -1,
 609896927,
 3447,
 610140159,
 609277024,
 -1,
 -56226,
 610065322,
 3421,
 -56225,
 610126078,
 3448,
 -56224,
 610186021,
 3445,
 -1,
 610224628,
 3418,
 610411625,
 609208283,
 -1,
 610477158,
 610348968,
 -1,
 -56220,
 610442799,
 3328,
 -56219,
 610497494,
 3388,
 -1,
 610542249,
 3329,
 -56217,
 610461596,
 3387,
 -56216,
 610708256,
 3407,
 -1,
 610740342,
 3389,
 610935917,
 610396740,
 -1,
 611001452,
 610892859,
 3426,
 -1,
 610958395,
 3427,
 -1,
 610975853,
 3396,
 611198066,
 610900471,
 -1,
 611263601,
 611163933,
 -1,
 -56208,
 611243060,
 3442,
 -1,
 611280754,
 3441,
 -1,
 611242647,
 3440,
 -1,
 611138731,
 3449,
 611647487,
 608060612,
 -1,
 611656823,
 611577704,
 -1,
 -56202,
 611633110,
 9894,
 -1,
 611656115,
 9895,
 -1,
 611590544,
 9893,
 611918997,
 608008556,
 -1,
 611984525,
 611877538,
 -1,
 612050046,
 611947168,
 -1,
 -56196,
 612037562,
 73451,
 -56195,
 612063394,
 73442,
 -1,
 612112970,
 73448,
 -56193,
 612037562,
 73452,
 -56192,
 612296109,
 73455,
 -56191,
 612356220,
 73446,
 -56190,
 612418217,
 73456,
 -56189,
 612480084,
 73453,
 -56188,
 612543009,
 73443,
 -56187,
 612600226,
 73445,
 -56186,
 612662405,
 73454,
 -56185,
 612726976,
 73440,
 -56184,
 612792159,
 73450,
 -56183,
 612849826,
 73441,
 -56182,
 612908032,
 73447,
 -56181,
 612970463,
 73449,
 -56180,
 613034296,
 73444,
 -1,
 613096010,
 73457,
 613295250,
 611969578,
 -1,
 -56177,
 613276859,
 73460,
 -56176,
 613325505,
 73462,
 -56175,
 613378045,
 73459,
 -1,
 613434562,
 73461,
 -56173,
 613264306,
 73463,
 -56172,
 613567351,
 73464,
 -1,
 613622496,
 73458,
 613819569,
 611906577,
 -1,
 613885086,
 613797878,
 -1,
 613950618,
 613870241,
 -1,
 -56167,
 613915329,
 119522,
 -1,
 613960343,
 119532,
 614147229,
 613899708,
 -1,
 -56164,
 614119342,
 119523,
 -1,
 614167594,
 119533,
 -1,
 614091489,
 119530,
 614409379,
 613859796,
 -1,
 614474913,
 614364836,
 119526,
 -1,
 614453839,
 119536,
 614662143,
 614420452,
 119527,
 -1,
 614584911,
 119537,
 614737065,
 614355443,
 -1,
 614802598,
 614704664,
 119524,
 -1,
 614781519,
 119534,
 614989823,
 614754301,
 -1,
 -56152,
 614917772,
 119525,
 -1,
 614946849,
 119535,
 615130285,
 614679746,
 -1,
 615195820,
 615082844,
 119528,
 -1,
 615139392,
 119538,
 -1,
 615154425,
 119531,
 615392431,
 615093998,
 119529,
 -1,
 615371343,
 119539,
 -56144,
 615380784,
 119520,
 -1,
 615489305,
 119521,
 615654596,
 613797878,
 -1,
 615720131,
 615604622,
 -1,
 615785656,
 615692746,
 -1,
 615851191,
 615734036,
 -1,
 -56138,
 615837108,
 10221,
 -1,
 615863567,
 10223,
 -1,
 615827549,
 10187,
 616113339,
 615743525,
 -1,
 -56134,
 616099252,
 10220,
 -1,
 616125711,
 10222,
 616309950,
 616068430,
 -1,
 -56131,
 616265537,
 120485,
 -1,
 616327165,
 120484,
 616506561,
 616246701,
 -1,
 -56128,
 616483282,
 120779,
 -1,
 616509632,
 120778,
 -56126,
 616481749,
 120001,
 -1,
 616649334,
 10189,
 -1,
 615662861,
 129481,
 616899784,
 615602259,
 -1,
 -56122,
 616863133,
 129522,
 -56121,
 616917323,
 129668,
 -1,
 616973506,
 129497,
 617161931,
 616868304,
 -1,
 -56118,
 617119555,
 127809,
 -1,
 617155037,
 9967,
 -56116,
 617149140,
 128470,
 -1,
 617320513,
 129443,
 617490008,
 579050177,
 -1,
 617555473,
 617429845,
 -1,
 617621008,
 617506813,
 -1,
 617686437,
 617567080,
 -1,
 617751972,
 617644706,
 -1,
 617817392,
 617726420,
 -1,
 617882922,
 617777805,
 -1,
 617948387,
 617861110,
 7511,
 618013920,
 617931801,
 -1,
 618079449,
 617945674,
 7492,
 -56104,
 618039355,
 7579,
 -1,
 618087618,
 7494,
 618276059,
 618039628,
 7514,
 -1,
 618204664,
 7597,
 -56100,
 618261153,
 43881,
 -56099,
 618390938,
 7610,
 -56098,
 618439215,
 7500,
 -56097,
 618489853,
 7502,
 -1,
 618552764,
 7587,
 -56095,
 617980378,
 7508,
 -56094,
 618684932,
 7615,
 -1,
 618729050,
 7605,
 618931436,
 617885608,
 7580,
 618996970,
 618865662,
 -1,
 619062503,
 618948605,
 7590,
 -1,
 618991312,
 7591,
 -56088,
 619044027,
 7608,
 -56087,
 619156128,
 7600,
 -1,
 619215931,
 7595,
 -56085,
 618947158,
 7521,
 -1,
 619318348,
 7581,
 619521267,
 618888251,
 -1,
 619586802,
 619449298,
 -1,
 -56081,
 619559141,
 7593,
 -56080,
 619620994,
 7594,
 -56079,
 619679523,
 43870,
 -1,
 619737703,
 43869,
 -1,
 619539213,
 43001,
 619980024,
 619463874,
 7497,
 -56075,
 619968381,
 7614,
 -56074,
 620024653,
 7582,
 -56073,
 620086598,
 7604,
 -1,
 620140016,
 7505,
 620307709,
 619961531,
 7512,
 620373244,
 620232704,
 -1,
 -56069,
 620359373,
 43871,
 -1,
 620374478,
 7606,
 -1,
 620343550,
 7607,
 620635395,
 620282324,
 -1,
 620700929,
 620572584,
 -1,
 -56064,
 620674639,
 7586,
 -1,
 620718019,
 7498,
 -56062,
 620653081,
 7513,
 -1,
 620825937,
 7603,
 621028615,
 620570887,
 7495,
 -56059,
 620995924,
 7509,
 -56058,
 621039286,
 7517,
 -1,
 621094298,
 7601,
 621290763,
 621016645,
 7611,
 621412351,
 621218770,
 -1,
 -56054,
 621328613,
 7612,
 -1,
 621361856,
 7613,
 621552911,
 621255361,
 7506,
 621674495,
 621521977,
 -1,
 -56050,
 621583041,
 7507,
 -1,
 621626562,
 7499,
 621815059,
 621500499,
 7501,
 621936639,
 621787144,
 -1,
 -56046,
 621849888,
 7520,
 -1,
 621893905,
 7518,
 622077206,
 621755221,
 7496,
 -56043,
 622044475,
 7585,
 -1,
 622086802,
 7519,
 622273817,
 622008906,
 7491,
 -56040,
 622233659,
 7493,
 -1,
 622292283,
 7516,
 622470427,
 622257562,
 7515,
 -1,
 622398801,
 7609,
 622601501,
 622438864,
 7510,
 -1,
 622551638,
 7602,
 622732576,
 622564028,
 -1,
 -56033,
 622704869,
 7599,
 -1,
 622755984,
 7598,
 622929186,
 622692684,
 7504,
 -1,
 622857553,
 7596,
 623060261,
 622880765,
 -1,
 -56028,
 623027417,
 7589,
 -1,
 623054544,
 7588,
 -56026,
 623032646,
 7583,
 -56025,
 623212640,
 7503,
 -56024,
 623277899,
 7592,
 -56023,
 623337900,
 43868,
 -1,
 623399411,
 7584,
 623584557,
 617863289,
 -1,
 -56020,
 623544177,
 42785,
 -1,
 623600383,
 42784,
 623837183,
 623533500,
 -1,
 -56017,
 623748160,
 42890,
 -1,
 623790702,
 765,
 623977820,
 617754536,
 -1,
 624043340,
 623911934,
 -1,
 624108854,
 624014306,
 7487,
 624230399,
 624054389,
 -1,
 -56011,
 624136864,
 7483,
 -1,
 624182466,
 7474,
 624371000,
 624073409,
 7484,
 -1,
 624352443,
 7485,
 624502074,
 624319932,
 7476,
 -1,
 624430800,
 43000,
 624633148,
 624437511,
 7470,
 -1,
 624567698,
 7471,
 624764222,
 624564810,
 7468,
 -1,
 624706754,
 7469,
 -56001,
 624749217,
 7490,
 -56000,
 624879002,
 11389,
 -55999,
 624942267,
 7489,
 -55998,
 625004534,
 7488,
 -55997,
 625060304,
 7486,
 -55996,
 625119904,
 7482,
 -55995,
 625183052,
 7481,
 -55994,
 625245243,
 7480,
 -55993,
 625309792,
 7479,
 -55992,
 625375041,
 7478,
 -55991,
 625436669,
 7477,
 -55990,
 625498195,
 7475,
 -55989,
 625558722,
 7473,
 -1,
 625621845,
 7472,
 625812823,
 623993687,
 -1,
 625878354,
 625765694,
 -1,
 -55985,
 625853963,
 42754,
 -55984,
 625918231,
 42758,
 -55983,
 625980036,
 42756,
 -1,
 626044303,
 42752,
 626262015,
 625812161,
 -1,
 -55980,
 626181643,
 42755,
 -55979,
 626245911,
 42759,
 -55978,
 626307716,
 42757,
 -1,
 626371983,
 42753,
 626533723,
 625800742,
 -1,
 -55975,
 626510551,
 42653,
 -55974,
 626548776,
 42652,
 -1,
 626608865,
 7544,
 -1,
 626499026,
 42889,
 626861425,
 623934523,
 -1,
 626926960,
 626829554,
 -1,
 626992495,
 626851840,
 -1,
 627058019,
 626950176,
 -1,
 627123554,
 626983135,
 767,
 -1,
 627073162,
 753,
 -1,
 627052726,
 42773,
 627320168,
 626999187,
 -1,
 627385703,
 627300934,
 -1,
 -55962,
 627365704,
 42763,
 -1,
 627409222,
 42768,
 -1,
 627371992,
 751,
 627647851,
 627292618,
 -1,
 -55958,
 627611120,
 755,
 -1,
 627661593,
 754,
 -55956,
 627630435,
 752,
 -55955,
 627824051,
 759,
 -55954,
 627864141,
 42783,
 -1,
 627913934,
 42888,
 -1,
 626937170,
 42778,
 -1,
 626870525,
 43882,
 628237698,
 626803906,
 -1,
 628303231,
 628224796,
 -1,
 628368761,
 628262663,
 -1,
 628434295,
 628310199,
 -1,
 -55946,
 628414280,
 42764,
 -1,
 628457798,
 42769,
 -55944,
 628392262,
 42774,
 -1,
 628576682,
 983993,
 628817919,
 628318919,
 -1,
 628827517,
 628703415,
 -1,
 -55940,
 628807496,
 42760,
 -1,
 628851014,
 42765,
 -55938,
 628785478,
 42770,
 -1,
 628969926,
 983992,
 629211135,
 628265928,
 -1,
 -55935,
 629114737,
 764,
 -1,
 629170943,
 762,
 629351818,
 628208610,
 -1,
 629417353,
 629284518,
 -1,
 -55931,
 629399898,
 42779,
 -55930,
 629437005,
 42782,
 -55929,
 629493980,
 42781,
 -55928,
 629555850,
 42780,
 -1,
 629618315,
 760,
 -1,
 629369739,
 43883,
 629876117,
 629313075,
 -1,
 629941648,
 629817220,
 -1,
 630007183,
 629883161,
 -1,
 -55922,
 629955786,
 757,
 -1,
 630004856,
 758,
 -1,
 629955786,
 756,
 630325247,
 629866496,
 -1,
 630334868,
 630210743,
 -1,
 -55917,
 630314824,
 42762,
 -1,
 630358342,
 42767,
 -1,
 630292806,
 42772,
 630597018,
 629826247,
 -1,
 630662553,
 630538423,
 -1,
 -55912,
 630642504,
 42761,
 -1,
 630686022,
 42766,
 -1,
 630620486,
 42771,
 630924702,
 630538236,
 -1,
 -55908,
 630908815,
 42775,
 -55907,
 630966597,
 42776,
 -1,
 631006448,
 42777,
 631186849,
 630860491,
 -1,
 -55904,
 631146353,
 763,
 -1,
 631202559,
 761,
 -55902,
 631170200,
 42864,
 -55901,
 631349875,
 766,
 -1,
 631396945,
 4348,
 -1,
 617688731,
 43867,
 631701503,
 617611264,
 -1,
 631711206,
 631603874,
 -1,
 631776686,
 631694746,
 -1,
 631842221,
 631741291,
 -1,
 631907755,
 631813090,
 71174,
 -1,
 631878626,
 71175,
 632094719,
 631864379,
 71176,
 -1,
 631995451,
 71177,
 -1,
 631773770,
 71210,
 632235444,
 631754742,
 -1,
 632300978,
 632213494,
 -1,
 -55887,
 632249806,
 71193,
 -1,
 632298058,
 71192,
 -55885,
 632249806,
 71198,
 -1,
 632429130,
 71197,
 632628665,
 632197792,
 -1,
 -55882,
 632615866,
 71191,
 -55881,
 632656618,
 71196,
 -55880,
 632707234,
 71186,
 -1,
 632756810,
 71201,
 632956351,
 632568661,
 -1,
 633021885,
 632896341,
 -1,
 -55876,
 632970702,
 71195,
 -1,
 633018954,
 71194,
 -55874,
 632970702,
 71200,
 -1,
 633150026,
 71199,
 633349571,
 632887882,
 71168,
 -55871,
 633330875,
 71181,
 -55870,
 633366525,
 71179,
 -1,
 633412170,
 71169,
 633611719,
 633323988,
 -1,
 -55867,
 633586345,
 71212,
 -55866,
 633626062,
 71211,
 -1,
 633674314,
 71213,
 633873865,
 633593019,
 71172,
 -1,
 633855163,
 71173,
 634004940,
 633842128,
 -1,
 -55861,
 633953742,
 71203,
 -1,
 634001994,
 71202,
 634201551,
 633961531,
 -1,
 -55858,
 634158213,
 71215,
 -1,
 634198602,
 71209,
 634398162,
 634157152,
 -1,
 -55855,
 634346958,
 71183,
 -1,
 634395210,
 71182,
 634594773,
 634353473,
 -1,
 -55852,
 634543566,
 71190,
 -1,
 634591818,
 71189,
 634791383,
 634546173,
 71170,
 -1,
 634742781,
 71171,
 634922458,
 634738771,
 -1,
 -55847,
 634871246,
 71185,
 -1,
 634919498,
 71184,
 635119069,
 634859432,
 -1,
 -55844,
 635067854,
 71188,
 -1,
 635116106,
 71187,
 635315680,
 635054343,
 -1,
 -55841,
 635264462,
 71205,
 -1,
 635312714,
 71204,
 -55839,
 635302842,
 71207,
 -55838,
 635483220,
 71208,
 -55837,
 635542209,
 71180,
 -55836,
 635603362,
 71206,
 -55835,
 635657678,
 71214,
 -1,
 635716802,
 71178,
 635905526,
 631695914,
 -1,
 635971052,
 635890001,
 -1,
 636036586,
 635941858,
 71221,
 -1,
 636007394,
 71222,
 636223487,
 635993147,
 71223,
 -1,
 636124219,
 71224,
 636298736,
 635902538,
 -1,
 -55826,
 636279995,
 71228,
 -55825,
 636315645,
 71226,
 -1,
 636361290,
 71216,
 636560882,
 636279995,
 71219,
 -1,
 636542139,
 71220,
 636691956,
 636512253,
 71217,
 -1,
 636643325,
 71218,
 -55819,
 636656321,
 71227,
 -1,
 636765378,
 71225,
 636954119,
 635845461,
 -1,
 637019653,
 636906475,
 -1,
 637085179,
 636997622,
 -1,
 -55814,
 637071411,
 71250,
 -1,
 637101599,
 71251,
 637281790,
 637059540,
 -1,
 -55811,
 637236900,
 71254,
 -1,
 637292516,
 71255,
 637478401,
 637227507,
 -1,
 -55808,
 637445656,
 71252,
 -1,
 637498858,
 71253,
 -55806,
 637466416,
 71248,
 -55805,
 637640473,
 71249,
 -55804,
 637703918,
 71257,
 -1,
 637749662,
 71256,
 -55802,
 636986786,
 71234,
 -1,
 637870729,
 71233,
 638068239,
 636930011,
 -1,
 638133771,
 638052529,
 -1,
 -55798,
 638108564,
 71230,
 -1,
 638170469,
 71231,
 638330382,
 638065226,
 -1,
 -55795,
 638301836,
 71232,
 -1,
 638360124,
 71229,
 -1,
 638281656,
 71236,
 -1,
 638000011,
 71235,
 -1,
 617565666,
 129339,
 638723637,
 617517728,
 -1,
 638789159,
 638671949,
 -1,
 638854679,
 638766969,
 71273,
 638975999,
 638782418,
 -1,
 -55786,
 638886937,
 71274,
 -1,
 638927385,
 71275,
 639116827,
 638828542,
 71265,
 639238143,
 639044562,
 -1,
 -55782,
 639149081,
 71269,
 -1,
 639189529,
 71270,
 639378974,
 639094774,
 -1,
 -55779,
 639362108,
 71276,
 -1,
 639417844,
 71267,
 639575585,
 639337122,
 -1,
 -55776,
 639535890,
 6314,
 -1,
 639578741,
 6264,
 639772195,
 639529477,
 71271,
 -1,
 639700196,
 71272,
 639903270,
 639708225,
 -1,
 -55771,
 639869977,
 71264,
 -1,
 639910425,
 71268,
 -1,
 639844697,
 71266,
 640165422,
 638753473,
 -1,
 640230957,
 640113787,
 -1,
 640296492,
 640217910,
 -1,
 -55765,
 640249147,
 9867,
 -1,
 640295613,
 9866,
 -1,
 640239180,
 119552,
 -1,
 640201932,
 128669,
 640624179,
 640111073,
 -1,
 640689714,
 640548864,
 -1,
 -55759,
 640675751,
 128184,
 -1,
 640690549,
 128176,
 -1,
 640618502,
 129297,
 641007615,
 640580174,
 128018,
 -1,
 640877261,
 128053,
 641082946,
 638704827,
 -1,
 641148477,
 641046852,
 -1,
 641214012,
 641080970,
 9968,
 641335295,
 641138688,
 -1,
 -55750,
 641250513,
 128670,
 -55749,
 641282049,
 128672,
 -1,
 641346516,
 128693,
 -1,
 641139479,
 128507,
 641607233,
 641123324,
 128001,
 641728511,
 641531904,
 -1,
 -55744,
 641652822,
 129700,
 -1,
 641684043,
 128045,
 -1,
 641585997,
 128068,
 641934922,
 641060854,
 -1,
 642000457,
 641901377,
 -1,
 642065991,
 641925120,
 -1,
 -55738,
 642040775,
 128757,
 -1,
 642067857,
 128741,
 -55736,
 642051053,
 128739,
 -1,
 642217768,
 129468,
 -1,
 641950133,
 129334,
 642459215,
 641899201,
 -1,
 642524750,
 642421410,
 -1,
 -55731,
 642509015,
 127889,
 -1,
 642527250,
 129390,
 -1,
 642464602,
 128496,
 642786899,
 642395131,
 128241,
 642908159,
 642711552,
 -1,
 -55726,
 642838296,
 128242,
 -1,
 642882627,
 128244,
 643049046,
 642763712,
 -1,
 -55723,
 643003846,
 129439,
 -1,
 643056834,
 128332,
 -55721,
 643036117,
 128511,
 -1,
 643229894,
 127909,
 643376939,
 617441277,
 -1,
 643442456,
 643310558,
 -1,
 643507927,
 643400354,
 -1,
 643573359,
 643485686,
 -1,
 643638884,
 643538978,
 -1,
 -55714,
 643569895,
 94105,
 -55713,
 643635207,
 94104,
 -55712,
 643700535,
 94103,
 -55711,
 643765826,
 94102,
 -55710,
 643831150,
 94101,
 -55709,
 643896400,
 94100,
 -1,
 643961643,
 94099,
 644163177,
 643613140,
 -1,
 -55706,
 644137641,
 93994,
 -55705,
 644177358,
 93998,
 -55704,
 644236482,
 94025,
 -1,
 644291146,
 94007,
 644490860,
 644121400,
 -1,
 -55701,
 644477882,
 93980,
 -1,
 644487754,
 93978,
 -55699,
 644468860,
 93966,
 -55698,
 644629698,
 94024,
 -1,
 644684362,
 93962,
 644884092,
 643535520,
 -1,
 644949619,
 644870966,
 -1,
 -55694,
 644898254,
 93997,
 -1,
 644946506,
 93996,
 645146230,
 644911776,
 -1,
 -55691,
 645094862,
 93973,
 -1,
 645143114,
 93972,
 645342841,
 645093459,
 -1,
 -55688,
 645291470,
 93988,
 -1,
 645339722,
 93987,
 645539451,
 645274186,
 93968,
 -1,
 645513978,
 94032,
 -1,
 645488078,
 93969,
 645736072,
 644871749,
 -1,
 645801603,
 645723717,
 -1,
 645867137,
 645775828,
 -1,
 -55680,
 645854138,
 94017,
 -1,
 645864010,
 94014,
 -55678,
 645854138,
 94016,
 -1,
 645995082,
 94013,
 646194822,
 645775828,
 -1,
 -55675,
 646143438,
 94006,
 -1,
 646191690,
 94012,
 -55673,
 646143438,
 94005,
 -1,
 646322762,
 94011,
 646522515,
 645723347,
 -1,
 646588047,
 646500342,
 -1,
 646653581,
 646562260,
 -1,
 -55668,
 646602190,
 94000,
 -1,
 646650442,
 94009,
 -55666,
 646631548,
 93964,
 -1,
 646781514,
 93965,
 -55664,
 646556193,
 93954,
 -55663,
 646944691,
 93970,
 -55662,
 647002304,
 93984,
 -1,
 647054525,
 94001,
 647243422,
 646493154,
 -1,
 647308957,
 647186598,
 -1,
 647374492,
 647274530,
 -1,
 -55657,
 647305447,
 94111,
 -55656,
 647370551,
 94110,
 -55655,
 647435842,
 94109,
 -55654,
 647501166,
 94108,
 -55653,
 647566123,
 94107,
 -1,
 647631355,
 94106,
 -1,
 647349649,
 94002,
 -1,
 647287255,
 94026,
 647964329,
 647183189,
 -1,
 648029860,
 647951941,
 -1,
 -55647,
 648017523,
 93995,
 -55646,
 648082640,
 94023,
 -55645,
 648109518,
 93999,
 -1,
 648157770,
 94008,
 648357543,
 647988024,
 -1,
 -55642,
 648344506,
 93981,
 -1,
 648354378,
 93979,
 -55640,
 648297472,
 93967,
 -1,
 648485450,
 93963,
 648685233,
 647895626,
 -1,
 648750768,
 648656422,
 -1,
 648816302,
 648712864,
 -1,
 -55635,
 648763554,
 93989,
 -1,
 648813130,
 93971,
 -55633,
 648804367,
 94015,
 -1,
 648972706,
 93958,
 -1,
 648699324,
 94019,
 649209526,
 648659412,
 -1,
 -55629,
 649196752,
 94022,
 -55628,
 649249449,
 94004,
 -55627,
 649289166,
 94003,
 -1,
 649337418,
 94010,
 649537212,
 649165883,
 -1,
 649602746,
 649485756,
 -1,
 -55623,
 649589690,
 93977,
 -1,
 649599562,
 93976,
 -55621,
 649589690,
 93975,
 -1,
 649730634,
 93974,
 649930433,
 649484371,
 -1,
 649995968,
 649878972,
 -1,
 -55617,
 649944526,
 93993,
 -1,
 649992778,
 93992,
 -1,
 649927242,
 93983,
 650258116,
 649913754,
 -1,
 -55613,
 650203720,
 93961,
 -1,
 650254922,
 93960,
 650454727,
 650228238,
 -1,
 -55610,
 650401954,
 93986,
 -1,
 650451530,
 93985,
 650651338,
 650422736,
 -1,
 -55607,
 650607749,
 93955,
 -1,
 650648138,
 93952,
 650847949,
 650611020,
 -1,
 -55604,
 650796494,
 93957,
 -1,
 650844746,
 93956,
 651044560,
 650796476,
 -1,
 -55601,
 650993102,
 94020,
 -1,
 651041354,
 93990,
 651241171,
 650979591,
 -1,
 -55598,
 651213258,
 94021,
 -1,
 651237962,
 93953,
 -55596,
 651227731,
 93991,
 -55595,
 651422433,
 94018,
 -55594,
 651458752,
 93982,
 -1,
 651514440,
 93959,
 651699981,
 643492394,
 -1,
 651765475,
 651651069,
 94049,
 651831004,
 651696714,
 94050,
 651952127,
 651793056,
 94051,
 -1,
 651843667,
 94052,
 652027614,
 651795137,
 94053,
 -1,
 651990512,
 94086,
 -55585,
 652008635,
 94056,
 -55584,
 652121584,
 94057,
 -55583,
 652175357,
 94055,
 -55582,
 652236883,
 94084,
 -1,
 652297410,
 94054,
 652486380,
 651746491,
 94058,
 652551911,
 652417610,
 94059,
 652673023,
 652513952,
 94060,
 -1,
 652564563,
 94061,
 -55576,
 652532923,
 94062,
 -55575,
 652713058,
 94079,
 -55574,
 652776944,
 94064,
 -55573,
 652830717,
 94087,
 -1,
 652888461,
 94063,
 653076213,
 652417610,
 94036,
 653141743,
 653038240,
 94039,
 -1,
 653088851,
 94040,
 653272817,
 653083842,
 94067,
 -1,
 653214914,
 94068,
 -55566,
 653253819,
 94075,
 -55565,
 653355005,
 94073,
 -55564,
 653419087,
 94038,
 -1,
 653466186,
 94037,
 653666044,
 653018306,
 94045,
 653731576,
 653636578,
 94071,
 -1,
 653702114,
 94069,
 653862650,
 653693600,
 94046,
 -1,
 653809747,
 94047,
 -55557,
 653813757,
 94074,
 -1,
 653924938,
 94085,
 654124803,
 653630145,
 94041,
 654190336,
 654066882,
 -1,
 -55553,
 654177078,
 94048,
 -1,
 654226402,
 94082,
 -55551,
 654171323,
 94076,
 -55550,
 654351041,
 94042,
 -1,
 654399571,
 94081,
 654583558,
 654111542,
 94065,
 -55547,
 654565225,
 94080,
 -1,
 654600189,
 94066,
 654780168,
 654568097,
 94044,
 -1,
 654744257,
 94043,
 654911242,
 654753860,
 94072,
 -1,
 654881762,
 94070,
 655042316,
 654873248,
 94077,
 -1,
 654989395,
 94078,
 -1,
 655026836,
 94083,
 655238930,
 651679554,
 -1,
 -55537,
 655218556,
 94096,
 -55536,
 655276711,
 94095,
 -55535,
 655305453,
 94098,
 -1,
 655367074,
 94097,
 655622143,
 655214555,
 -1,
 655632150,
 655538190,
 -1,
 -55531,
 655616415,
 94034,
 -1,
 655632076,
 94035,
 -55529,
 655570806,
 94031,
 -1,
 655763148,
 94033,
 655959840,
 643381424,
 -1,
 656025373,
 655923905,
 -1,
 -55525,
 655999951,
 128300,
 -55524,
 656059692,
 127908,
 -1,
 656091816,
 129440,
 656343039,
 655949824,
 -1,
 -55521,
 656252629,
 983235,
 -1,
 656293010,
 983236,
 656484132,
 655922851,
 -1,
 -55518,
 656445479,
 128469,
 -55517,
 656490327,
 128189,
 -1,
 656551757,
 128656,
 656746281,
 656440379,
 -1,
 656811816,
 656700791,
 -1,
 -55513,
 656772271,
 127894,
 -1,
 656826759,
 129686,
 -1,
 656768024,
 127756,
 -55510,
 656720000,
 129694,
 -1,
 657013970,
 129986,
 657205245,
 643363875,
 -1,
 657270674,
 657161275,
 -1,
 657336206,
 657215248,
 -1,
 657401677,
 657310164,
 -1,
 657467212,
 657350076,
 -1,
 657532745,
 657400104,
 -1,
 657598261,
 657494688,
 -1,
 -55501,
 657585082,
 4218,
 -55500,
 657625834,
 43491,
 -1,
 657660490,
 4220,
 657860408,
 657553504,
 -1,
 -55497,
 657808846,
 4214,
 -1,
 657857098,
 4213,
 658057019,
 657807443,
 -1,
 -55494,
 658005454,
 43488,
 -1,
 658053706,
 4215,
 658253630,
 657993640,
 -1,
 -55491,
 658202062,
 43489,
 -1,
 658250314,
 4216,
 658450241,
 658188551,
 -1,
 -55488,
 658398670,
 43492,
 -1,
 658446922,
 4223,
 -55486,
 658437747,
 4217,
 -55485,
 658625377,
 4224,
 -55484,
 658681105,
 4221,
 -55483,
 658733001,
 43490,
 -55482,
 658791886,
 4225,
 -55481,
 658854472,
 4222,
 -55480,
 658914304,
 4219,
 -1,
 658971210,
 4130,
 659226623,
 657517597,
 -1,
 -55477,
 659146129,
 43647,
 -1,
 659174001,
 43646,
 -1,
 657414533,
 4193,
 659433320,
 657357419,
 -1,
 659498835,
 659372885,
 -1,
 659564370,
 659438421,
 -1,
 -55471,
 659512782,
 43625,
 -1,
 659561034,
 43624,
 -1,
 659512782,
 43626,
 659826518,
 659479099,
 -1,
 -55467,
 659774926,
 43623,
 -1,
 659823178,
 43622,
 660023129,
 659788448,
 -1,
 -55464,
 660009914,
 43621,
 -1,
 660019786,
 43627,
 660219740,
 659978049,
 -1,
 -55461,
 660168142,
 43620,
 -1,
 660216394,
 43619,
 660416351,
 660168124,
 -1,
 -55458,
 660364750,
 43630,
 -1,
 660413002,
 43629,
 660612962,
 660352936,
 -1,
 -55455,
 660561358,
 43618,
 -1,
 660609610,
 43617,
 -55453,
 660600435,
 43634,
 -55452,
 660795987,
 43633,
 -55451,
 660849321,
 43628,
 -55450,
 660911188,
 43635,
 -55449,
 660953250,
 43616,
 -1,
 661017160,
 43631,
 661202813,
 659411163,
 -1,
 661268335,
 661142357,
 -1,
 661333869,
 661207893,
 -1,
 -55444,
 661282254,
 43502,
 -1,
 661330506,
 43501,
 -55442,
 661282254,
 43516,
 -1,
 661461578,
 43515,
 661661554,
 661230240,
 -1,
 -55439,
 661648314,
 43495,
 -1,
 661689066,
 43503,
 661858165,
 661616449,
 -1,
 -55436,
 661806542,
 43500,
 -1,
 661854794,
 43499,
 662054776,
 661805139,
 -1,
 -55433,
 662003150,
 43498,
 -1,
 662051402,
 43497,
 662251387,
 661989639,
 -1,
 -55430,
 662199758,
 43518,
 -1,
 662248010,
 43517,
 -55428,
 662209853,
 43514,
 -1,
 662393416,
 43496,
 662579076,
 661164250,
 -1,
 662644609,
 662514301,
 -1,
 -55424,
 662586562,
 4189,
 -1,
 662641226,
 4188,
 -55422,
 662607421,
 4186,
 -55421,
 662796233,
 4187,
 -1,
 662848706,
 4136,
 663037832,
 662521489,
 -1,
 -55418,
 663025217,
 4207,
 -55417,
 663066547,
 4206,
 -1,
 663116653,
 4208,
 663299979,
 663022750,
 -1,
 -55414,
 663278433,
 4197,
 -1,
 663335427,
 4198,
 -55412,
 663273791,
 4238,
 -55411,
 663444707,
 4159,
 -1,
 663494423,
 43642,
 663748607,
 657300590,
 -1,
 -55408,
 663663219,
 43637,
 -55407,
 663722790,
 43636,
 -1,
 663774221,
 43638,
 663955397,
 657244628,
 -1,
 664020911,
 663907330,
 -1,
 664086432,
 663995875,
 -1,
 664151962,
 664065883,
 -1,
 -55401,
 664082231,
 4234,
 -55400,
 664147522,
 4233,
 -55399,
 664212560,
 4232,
 -1,
 664277803,
 4231,
 664479647,
 664090776,
 -1,
 664545182,
 664459099,
 -1,
 -55395,
 664474704,
 4236,
 -1,
 664539947,
 4235,
 -1,
 664488659,
 4237,
 -1,
 664454059,
 43493,
 664872870,
 664071345,
 -1,
 -55390,
 664802882,
 4205,
 -55389,
 664868206,
 4204,
 -55388,
 664933456,
 4203,
 -55387,
 664998699,
 4202,
 -1,
 665063931,
 4201,
 665266089,
 664850662,
 -1,
 -55384,
 665196098,
 43645,
 -1,
 665260843,
 43644,
 665462700,
 665221768,
 -1,
 -55381,
 665392208,
 4251,
 -1,
 665457147,
 4250,
 -55379,
 665436496,
 4239,
 -55378,
 665627347,
 43643,
 -1,
 665659015,
 4154,
 665855933,
 663969619,
 -1,
 665921459,
 665833462,
 -1,
 -55374,
 665907251,
 4242,
 -1,
 665937439,
 4243,
 666118070,
 665895380,
 -1,
 -55371,
 666072740,
 4246,
 -1,
 666128356,
 4247,
 666314681,
 666063347,
 -1,
 -55368,
 666281496,
 4244,
 -1,
 666334698,
 4245,
 -55366,
 666302256,
 4240,
 -55365,
 666476313,
 4241,
 -55364,
 666539758,
 4249,
 -1,
 666585502,
 4248,
 666828799,
 665843045,
 -1,
 666838978,
 666705672,
 -1,
 -55360,
 666819529,
 43641,
 -55359,
 666869529,
 43640,
 -1,
 666915024,
 43639,
 667156479,
 666813923,
 -1,
 -55356,
 667066137,
 4254,
 -1,
 667111632,
 4255,
 667297756,
 663939626,
 -1,
 667363277,
 667271636,
 -1,
 667428812,
 667311950,
 -1,
 667494346,
 667370690,
 4228,
 -1,
 667418629,
 4229,
 -55349,
 667440148,
 4230,
 -1,
 667556623,
 4227,
 -1,
 667375992,
 4194,
 667822033,
 667318739,
 -1,
 -55345,
 667802811,
 4211,
 -55344,
 667851793,
 4210,
 -1,
 667895785,
 4212,
 668084180,
 667806878,
 -1,
 -55341,
 668065545,
 4200,
 -1,
 668094272,
 4199,
 668280791,
 668045530,
 -1,
 -55338,
 668244673,
 4148,
 -1,
 668298325,
 4147,
 668477401,
 668213007,
 4252,
 -1,
 668428285,
 4253,
 -55334,
 668455255,
 4139,
 -55333,
 668555775,
 4209,
 -1,
 668615879,
 4149,
 668805102,
 667275254,
 -1,
 668870635,
 668737113,
 -1,
 668936161,
 668848118,
 -1,
 -55328,
 668921907,
 43506,
 -1,
 668952095,
 43507,
 669132772,
 668910036,
 -1,
 -55325,
 669087396,
 43510,
 -1,
 669143012,
 43511,
 669329383,
 669078003,
 -1,
 -55322,
 669296152,
 43508,
 -1,
 669349354,
 43509,
 -55320,
 669316912,
 43504,
 -55319,
 669490969,
 43505,
 -55318,
 669554414,
 43513,
 -1,
 669600158,
 43512,
 669843455,
 668835774,
 -1,
 -55315,
 669743610,
 4196,
 -1,
 669802583,
 4195,
 669984762,
 668743565,
 -1,
 670050297,
 669944140,
 -1,
 670115829,
 669992885,
 -1,
 -55310,
 670102458,
 4155,
 -55309,
 670165729,
 4157,
 -55308,
 670217300,
 4156,
 -1,
 670260686,
 4158,
 670498815,
 670080688,
 -1,
 -55305,
 670405354,
 4190,
 -55304,
 670468514,
 4191,
 -1,
 670530693,
 4192,
 -1,
 670025193,
 4226,
 670826495,
 669946004,
 -1,
 -55300,
 670746104,
 43494,
 -1,
 670792307,
 43632,
 670967886,
 657185979,
 -1,
 671033396,
 670926967,
 -1,
 671098931,
 670966573,
 -1,
 671164466,
 671056546,
 -1,
 671229960,
 671103829,
 -1,
 671295494,
 671169365,
 -1,
 -55292,
 671243726,
 70292,
 -55291,
 671300608,
 70291,
 -1,
 671357514,
 70290,
 -55289,
 671243726,
 70297,
 -1,
 671488586,
 70296,
 671688718,
 671207414,
 -1,
 671754252,
 671666166,
 -1,
 -55285,
 671702478,
 70289,
 -1,
 671750730,
 70288,
 -55283,
 671702478,
 70295,
 -1,
 671881802,
 70294,
 672081938,
 671658978,
 -1,
 -55280,
 672052308,
 70311,
 -55279,
 672095694,
 70312,
 -1,
 672143946,
 70306,
 672344086,
 672043680,
 -1,
 -55276,
 672330682,
 70287,
 -55275,
 672371434,
 70293,
 -1,
 672406090,
 70298,
 672606233,
 672311760,
 -1,
 -55272,
 672554446,
 70300,
 -1,
 672602698,
 70299,
 672802844,
 672561248,
 -1,
 -55269,
 672751054,
 70277,
 -1,
 672799306,
 70276,
 672999455,
 672757569,
 -1,
 -55266,
 672954207,
 70285,
 -1,
 672995914,
 70284,
 673196066,
 672946259,
 -1,
 -55263,
 673144270,
 70280,
 -1,
 673192522,
 70278,
 673392677,
 673132456,
 -1,
 -55260,
 673340878,
 70283,
 -1,
 673389130,
 70282,
 673589288,
 673327367,
 -1,
 -55257,
 673537486,
 70303,
 -1,
 673585738,
 70301,
 -55255,
 673575866,
 70305,
 -55254,
 673768877,
 70308,
 -55253,
 673832123,
 70274,
 -55252,
 673890985,
 70309,
 -55251,
 673941922,
 70304,
 -55250,
 674004101,
 70307,
 -55249,
 674064381,
 70273,
 -55248,
 674127310,
 70310,
 -55247,
 674186434,
 70275,
 -1,
 674241098,
 70272,
 -1,
 671138850,
 70313,
 -1,
 671052525,
 127926,
 674627583,
 671007188,
 -1,
 674637901,
 674523475,
 -1,
 674703434,
 674611668,
 -1,
 674768969,
 674690405,
 -1,
 674834504,
 674724542,
 -1,
 674900030,
 674776258,
 -1,
 674965565,
 674851789,
 -1,
 -55236,
 674947411,
 119271,
 -1,
 674972287,
 119270,
 -1,
 674927576,
 119263,
 675227713,
 674870021,
 -1,
 -55232,
 675209555,
 119269,
 -1,
 675234431,
 119268,
 675424324,
 675172851,
 -1,
 -55229,
 675380816,
 119272,
 -1,
 675442048,
 119264,
 -55227,
 675409361,
 119266,
 -55226,
 675592003,
 119265,
 -55225,
 675634909,
 119267,
 -1,
 675688375,
 119262,
 -1,
 674796038,
 119081,
 -1,
 674707551,
 127932,
 676014156,
 674658898,
 127929,
 -1,
 675941835,
 127896,
 -1,
 675977350,
 127925,
 -1,
 674588452,
 127812,
 676276359,
 670940973,
 -1,
 676341878,
 676233890,
 -1,
 676407380,
 676319222,
 -1,
 -55214,
 676356230,
 92757,
 -55213,
 676416038,
 92766,
 -1,
 676469322,
 92736,
 676669527,
 676371137,
 92754,
 -55210,
 676633281,
 92753,
 -1,
 676691003,
 92749,
 676866139,
 676624480,
 -1,
 -55207,
 676829889,
 92761,
 -55206,
 676879898,
 92744,
 -1,
 676939267,
 92748,
 677128286,
 676836322,
 -1,
 -55203,
 677092033,
 92755,
 -1,
 677144573,
 92765,
 677324897,
 677095888,
 -1,
 -55200,
 677274198,
 92743,
 -1,
 677321290,
 92752,
 677521508,
 677286560,
 -1,
 -55197,
 677473595,
 92751,
 -1,
 677534578,
 92737,
 677718119,
 677480780,
 -1,
 -55194,
 677670097,
 92739,
 -1,
 677715209,
 92750,
 677914729,
 677674117,
 92763,
 -1,
 677876384,
 92762,
 678045804,
 677862862,
 -1,
 -55189,
 678009537,
 92745,
 -1,
 678062077,
 92764,
 678242414,
 677987522,
 92760,
 -1,
 678173258,
 92758,
 678373488,
 678181888,
 92741,
 -1,
 678324221,
 92746,
 -55183,
 678360486,
 92738,
 -55182,
 678488801,
 92759,
 -55181,
 678545056,
 92756,
 -55180,
 678572999,
 92747,
 -55179,
 678635832,
 92740,
 -1,
 678697546,
 92742,
 678952959,
 676281173,
 -1,
 678963333,
 678849515,
 -1,
 679028859,
 678940662,
 -1,
 -55174,
 679014451,
 92770,
 -1,
 679044639,
 92771,
 679225470,
 679002580,
 -1,
 -55171,
 679179940,
 92774,
 -1,
 679235556,
 92775,
 679422081,
 679170547,
 -1,
 -55168,
 679388696,
 92772,
 -1,
 679441898,
 92773,
 -55166,
 679409456,
 92768,
 -55165,
 679583513,
 92769,
 -55164,
 679646958,
 92777,
 -1,
 679692702,
 92776,
 -55162,
 678929826,
 92783,
 -1,
 679813769,
 92782,
 -55160,
 676260513,
 983173,
 -55159,
 679996037,
 983216,
 -1,
 680038832,
 983228,
 680210505,
 534608955,
 -1,
 680274915,
 680159229,
 -1,
 680340263,
 680235680,
 -1,
 680405796,
 680281282,
 -1,
 680471328,
 680338512,
 -1,
 680536604,
 680401593,
 -1,
 680601840,
 680470791,
 -1,
 680667361,
 680530155,
 -1,
 680732833,
 680596267,
 -1,
 680798358,
 680661803,
 67090,
 -55147,
 680757580,
 67092,
 -1,
 680808947,
 67091,
 680994969,
 680727035,
 67087,
 -55144,
 680954188,
 67089,
 -1,
 681005555,
 67088,
 681191579,
 680924240,
 67093,
 -1,
 681150796,
 67094,
 -55140,
 681122200,
 67100,
 -55139,
 681253095,
 67098,
 -55138,
 681318407,
 67097,
 -55137,
 681383735,
 67096,
 -55136,
 681448814,
 67095,
 -1,
 681513195,
 67086,
 681715883,
 680662594,
 -1,
 -55133,
 681646488,
 67123,
 -55132,
 681711847,
 67122,
 -55131,
 681777159,
 67121,
 -55130,
 681842487,
 67120,
 -55129,
 681907778,
 67119,
 -55128,
 681973102,
 67118,
 -55127,
 682038352,
 67117,
 -55126,
 682103291,
 67116,
 -1,
 682168555,
 67115,
 682371253,
 681644267,
 -1,
 -55123,
 682301848,
 67080,
 -55122,
 682367207,
 67079,
 -55121,
 682432519,
 67078,
 -55120,
 682497847,
 67077,
 -55119,
 682563138,
 67076,
 -55118,
 682628462,
 67075,
 -55117,
 682693712,
 67074,
 -55116,
 682758955,
 67073,
 -1,
 682824187,
 67072,
 683026622,
 682300782,
 -1,
 -55113,
 682957208,
 67114,
 -55112,
 683022567,
 67113,
 -55111,
 683087879,
 67112,
 -55110,
 683153207,
 67111,
 -55109,
 683218498,
 67110,
 -55108,
 683283822,
 67109,
 -55107,
 683348475,
 67108,
 -1,
 683413739,
 67107,
 683616454,
 682956807,
 -1,
 -55104,
 683547032,
 67136,
 -55103,
 683612391,
 67135,
 -55102,
 683677703,
 67134,
 -55101,
 683743031,
 67133,
 -55100,
 683808110,
 67132,
 -55099,
 683873360,
 67131,
 -1,
 683938027,
 67130,
 684140749,
 683546855,
 -1,
 -55096,
 684070919,
 67142,
 -55095,
 684136247,
 67141,
 -55094,
 684201538,
 67140,
 -55093,
 684266283,
 67139,
 -55092,
 684331515,
 67138,
 -1,
 684396779,
 67137,
 684599508,
 684070711,
 -1,
 -55089,
 684530072,
 67129,
 -55088,
 684595207,
 67128,
 -55087,
 684660535,
 67127,
 -55086,
 684725826,
 67126,
 -55085,
 684790267,
 67125,
 -1,
 684855531,
 67124,
 685058267,
 684528720,
 -1,
 -55082,
 684988824,
 67106,
 -55081,
 685054183,
 67105,
 -55080,
 685119495,
 67104,
 -55079,
 685184366,
 67103,
 -55078,
 685249019,
 67102,
 -1,
 685314283,
 67101,
 685572095,
 684986875,
 -1,
 -55075,
 685447175,
 67085,
 -55074,
 685512503,
 67084,
 -55073,
 685577296,
 67083,
 -55072,
 685642235,
 67082,
 -1,
 685707499,
 67081,
 685965311,
 680595963,
 -1,
 685975782,
 685839147,
 -1,
 -55068,
 685904976,
 67148,
 -55067,
 685970219,
 67147,
 -1,
 686035179,
 67145,
 686237929,
 685906151,
 -1,
 -55064,
 686168295,
 67155,
 -1,
 686231787,
 67154,
 686434540,
 686167378,
 -1,
 -55061,
 686369031,
 67150,
 -1,
 686430794,
 67149,
 -55059,
 686365238,
 67156,
 -55058,
 686561477,
 67153,
 -55057,
 686626816,
 67152,
 -1,
 686691099,
 67144,
 686893387,
 680531522,
 -1,
 686958844,
 686823655,
 -1,
 -55053,
 686889368,
 67324,
 -55052,
 686954727,
 67323,
 -55051,
 687020039,
 67322,
 -55050,
 687085367,
 67321,
 -55049,
 687150658,
 67320,
 -55048,
 687215982,
 67319,
 -55047,
 687281232,
 67318,
 -55046,
 687346475,
 67317,
 -55045,
 687411707,
 67316,
 -1,
 687476971,
 67315,
 687679751,
 686888967,
 -1,
 -55042,
 687610264,
 67314,
 -55041,
 687675623,
 67313,
 -55040,
 687740935,
 67312,
 -55039,
 687806263,
 67311,
 -55038,
 687871554,
 67310,
 -55037,
 687936878,
 67309,
 -55036,
 688002128,
 67308,
 -55035,
 688067371,
 67307,
 -55034,
 688132603,
 67306,
 -1,
 688197867,
 67305,
 688400657,
 687609410,
 -1,
 -55031,
 688331160,
 67298,
 -55030,
 688396295,
 67297,
 -55029,
 688461623,
 67296,
 -55028,
 688526914,
 67295,
 -55027,
 688592238,
 67294,
 -55026,
 688657488,
 67293,
 -55025,
 688722731,
 67292,
 -55024,
 688787963,
 67291,
 -1,
 688853227,
 67290,
 689056027,
 688329808,
 -1,
 -55021,
 688986520,
 67282,
 -55020,
 689051879,
 67281,
 -55019,
 689117191,
 67280,
 -55018,
 689182519,
 67279,
 -55017,
 689247810,
 67278,
 -55016,
 689313134,
 67277,
 -55015,
 689378091,
 67276,
 -55014,
 689443323,
 67275,
 -1,
 689508587,
 67274,
 689711397,
 688984875,
 -1,
 -55011,
 689641880,
 67273,
 -55010,
 689707239,
 67272,
 -55009,
 689772551,
 67271,
 -55008,
 689837879,
 67270,
 -55007,
 689903170,
 67269,
 -55006,
 689968494,
 67268,
 -55005,
 690033744,
 67267,
 -55004,
 690098683,
 67266,
 -1,
 690163947,
 67265,
 690366766,
 689639659,
 -1,
 -55001,
 690297240,
 67258,
 -55000,
 690362599,
 67257,
 -54999,
 690427703,
 67256,
 -54998,
 690492994,
 67255,
 -54997,
 690558318,
 67254,
 -54996,
 690623568,
 67253,
 -54995,
 690688811,
 67252,
 -1,
 690754043,
 67251,
 690956598,
 690296174,
 -1,
 -54992,
 690887064,
 67289,
 -54991,
 690952423,
 67288,
 -54990,
 691017735,
 67287,
 -54989,
 691082818,
 67286,
 -54988,
 691147563,
 67285,
 -54987,
 691212795,
 67284,
 -1,
 691278059,
 67283,
 691480893,
 690887064,
 -1,
 -54984,
 691411175,
 67330,
 -54983,
 691476279,
 67329,
 -54982,
 691541570,
 67328,
 -54981,
 691606894,
 67327,
 -54980,
 691671851,
 67326,
 -1,
 691737083,
 67325,
 691939652,
 691410743,
 -1,
 -54977,
 691870104,
 67304,
 -54976,
 691935463,
 67303,
 -54975,
 692000567,
 67302,
 -54974,
 692065858,
 67301,
 -54973,
 692131182,
 67300,
 -1,
 692196432,
 67299,
 692453375,
 691868155,
 -1,
 -54970,
 692328247,
 67264,
 -54969,
 692393538,
 67263,
 -54968,
 692458576,
 67262,
 -54967,
 692523819,
 67261,
 -54966,
 692589051,
 67260,
 -1,
 692654315,
 67259,
 692857249,
 686822480,
 -1,
 692922714,
 692785659,
 -1,
 692988241,
 692851792,
 -1,
 -54961,
 692924328,
 67173,
 -54960,
 692988167,
 67172,
 -1,
 693049930,
 67171,
 -54958,
 692918680,
 67179,
 -54957,
 693180647,
 67178,
 -54956,
 693245959,
 67177,
 -54955,
 693311287,
 67176,
 -54954,
 693376578,
 67175,
 -54953,
 693441902,
 67174,
 -54952,
 693506859,
 67170,
 -54951,
 693572091,
 67169,
 -1,
 693637355,
 67168,
 693840231,
 692850923,
 -1,
 693905759,
 693770648,
 -1,
 -54947,
 693841832,
 67167,
 -54946,
 693905671,
 67166,
 -1,
 693967434,
 67165,
 -54944,
 693836007,
 67164,
 -54943,
 694097927,
 67163,
 -54942,
 694163255,
 67162,
 -54941,
 694228546,
 67161,
 -54940,
 694293870,
 67160,
 -54939,
 694359120,
 67159,
 -54938,
 694424363,
 67158,
 -1,
 694489595,
 67157,
 694692210,
 693770039,
 -1,
 -54935,
 694622616,
 67229,
 -54934,
 694687975,
 67228,
 -54933,
 694753287,
 67227,
 -54932,
 694818615,
 67226,
 -54931,
 694883906,
 67225,
 -54930,
 694949230,
 67224,
 -54929,
 695014480,
 67223,
 -54928,
 695079723,
 67222,
 -54927,
 695144955,
 67221,
 -1,
 695210219,
 67220,
 695413117,
 694621762,
 -1,
 -54924,
 695343512,
 67219,
 -54923,
 695408871,
 67218,
 -54922,
 695474183,
 67217,
 -54921,
 695539511,
 67216,
 -54920,
 695604802,
 67215,
 -54919,
 695670126,
 67214,
 -54918,
 695735376,
 67213,
 -54917,
 695800619,
 67212,
 -54916,
 695865851,
 67211,
 -1,
 695931115,
 67210,
 696134024,
 695342446,
 -1,
 -54913,
 696064408,
 67209,
 -54912,
 696129767,
 67208,
 -54911,
 696195079,
 67207,
 -54910,
 696260407,
 67206,
 -54909,
 696325698,
 67205,
 -54908,
 696391022,
 67204,
 -54907,
 696456272,
 67203,
 -54906,
 696521515,
 67202,
 -54905,
 696586747,
 67201,
 -1,
 696652011,
 67200,
 696854931,
 696063056,
 -1,
 -54902,
 696785304,
 67199,
 -54901,
 696850663,
 67198,
 -54900,
 696915975,
 67197,
 -54899,
 696981303,
 67196,
 -54898,
 697046594,
 67195,
 -54897,
 697111918,
 67194,
 -54896,
 697177168,
 67193,
 -54895,
 697242411,
 67192,
 -54894,
 697307643,
 67191,
 -1,
 697372907,
 67190,
 697575838,
 696783659,
 -1,
 -54891,
 697506200,
 67189,
 -54890,
 697571559,
 67188,
 -54889,
 697636871,
 67187,
 -54888,
 697702199,
 67186,
 -54887,
 697767490,
 67185,
 -54886,
 697832814,
 67184,
 -54885,
 697898064,
 67183,
 -54884,
 697963307,
 67182,
 -54883,
 698028539,
 67181,
 -1,
 698093803,
 67180,
 698351615,
 697505799,
 -1,
 -54880,
 698225147,
 67231,
 -1,
 698290411,
 67230,
 698493405,
 692786999,
 -1,
 698558893,
 698421755,
 -1,
 -54876,
 698489240,
 67348,
 -54875,
 698554599,
 67347,
 -54874,
 698619911,
 67346,
 -54873,
 698685239,
 67345,
 -54872,
 698750530,
 67344,
 -54871,
 698815854,
 67343,
 -54870,
 698881104,
 67342,
 -54869,
 698946347,
 67341,
 -54868,
 699011579,
 67340,
 -1,
 699076843,
 67339,
 699279799,
 698488386,
 -1,
 -54865,
 699210136,
 67377,
 -54864,
 699275495,
 67376,
 -54863,
 699340807,
 67375,
 -54862,
 699406135,
 67374,
 -54861,
 699471426,
 67373,
 -54860,
 699536750,
 67372,
 -54859,
 699602000,
 67371,
 -54858,
 699667243,
 67370,
 -1,
 699732475,
 67369,
 699935169,
 699208491,
 -1,
 -54855,
 699865496,
 67357,
 -54854,
 699930855,
 67356,
 -54853,
 699996167,
 67355,
 -54852,
 700061495,
 67354,
 -54851,
 700126574,
 67353,
 -54850,
 700191824,
 67352,
 -54849,
 700257067,
 67351,
 -54848,
 700322299,
 67350,
 -1,
 700387563,
 67349,
 700590538,
 699864430,
 -1,
 -54845,
 700520856,
 67368,
 -54844,
 700586215,
 67367,
 -54843,
 700651319,
 67366,
 -54842,
 700716610,
 67365,
 -54841,
 700781934,
 67364,
 -54840,
 700847184,
 67363,
 -54839,
 700912427,
 67362,
 -1,
 700977387,
 67361,
 701180371,
 700518635,
 -1,
 -54836,
 701110680,
 67338,
 -54835,
 701176039,
 67337,
 -54834,
 701241143,
 67336,
 -54833,
 701306222,
 67335,
 -54832,
 701371472,
 67334,
 -54831,
 701436715,
 67333,
 -54830,
 701501947,
 67332,
 -1,
 701567211,
 67331,
 701770201,
 701110071,
 -1,
 -54827,
 701699438,
 67382,
 -54826,
 701764688,
 67381,
 -54825,
 701829931,
 67380,
 -54824,
 701895163,
 67379,
 -1,
 701960427,
 67378,
 702218239,
 701699152,
 -1,
 -54821,
 702093543,
 67360,
 -54820,
 702158855,
 67359,
 -1,
 702223726,
 67358,
 702425592,
 698423303,
 -1,
 702491118,
 702353643,
 -1,
 702556646,
 702421400,
 -1,
 702622181,
 702484306,
 -1,
 -54814,
 702551930,
 67404,
 -54813,
 702617006,
 67403,
 -54812,
 702682290,
 67402,
 -1,
 702747508,
 67401,
 -1,
 702546946,
 67400,
 -54809,
 702486822,
 67399,
 -54808,
 702945339,
 67398,
 -54807,
 703010640,
 67397,
 -54806,
 703075953,
 67396,
 -54805,
 703141261,
 67395,
 -54804,
 703206510,
 67394,
 -54803,
 703271725,
 67393,
 -1,
 703336957,
 67392,
 703539702,
 702419451,
 -1,
 -54800,
 703469587,
 67411,
 -54799,
 703534685,
 67410,
 -54798,
 703599988,
 67409,
 -54797,
 703665393,
 67408,
 -54796,
 703730701,
 67407,
 -54795,
 703795935,
 67406,
 -1,
 703861153,
 67405,
 -54793,
 703468889,
 67413,
 -1,
 703992894,
 67412,
 704195086,
 702354798,
 -1,
 704260612,
 704123115,
 -1,
 -54789,
 704191021,
 67241,
 -54788,
 704256389,
 67240,
 -54787,
 704321724,
 67239,
 -54786,
 704387059,
 67238,
 -54785,
 704452368,
 67237,
 -54784,
 704517671,
 67236,
 -54783,
 704582981,
 67235,
 -54782,
 704648218,
 67234,
 -54781,
 704713467,
 67233,
 -1,
 704778706,
 67232,
 705036287,
 704188923,
 -1,
 -54778,
 704911749,
 67250,
 -54777,
 704977084,
 67249,
 -54776,
 705042419,
 67248,
 -54775,
 705107728,
 67247,
 -54774,
 705173031,
 67246,
 -54773,
 705238341,
 67245,
 -54772,
 705303578,
 67244,
 -54771,
 705368827,
 67243,
 -1,
 705434066,
 67242,
 705636887,
 704125323,
 -1,
 -54768,
 705566727,
 67431,
 -54767,
 705632055,
 67430,
 -54766,
 705697346,
 67429,
 -54765,
 705762670,
 67428,
 -54764,
 705827920,
 67427,
 -54763,
 705893163,
 67426,
 -54762,
 705958395,
 67425,
 -1,
 706023659,
 67424,
 706226715,
 705565179,
 -1,
 -54759,
 706155861,
 67151,
 -54758,
 706221091,
 67146,
 -1,
 706286043,
 67143,
 -1,
 706154978,
 67099,
 706609151,
 680470793,
 -1,
 706620077,
 706505209,
 -1,
 706685579,
 706554119,
 -1,
 706751085,
 706613755,
 -1,
 706816564,
 706679019,
 -1,
 706882085,
 706745922,
 -1,
 -54749,
 706840963,
 65669,
 -54748,
 706892292,
 65668,
 -1,
 706937542,
 65667,
 707144232,
 706812312,
 -1,
 -54745,
 707103064,
 65677,
 -1,
 707154424,
 65676,
 707340843,
 707074279,
 -1,
 -54742,
 707299665,
 65675,
 -1,
 707351070,
 65674,
 707537454,
 707270663,
 -1,
 -54739,
 707496294,
 65673,
 -1,
 707547667,
 65672,
 707734065,
 707467063,
 -1,
 -54736,
 707692925,
 65671,
 -1,
 707744254,
 65670,
 -54734,
 707663233,
 65666,
 -54733,
 707859461,
 65665,
 -1,
 707924313,
 65664,
 708127295,
 706746167,
 -1,
 -54730,
 708057496,
 65713,
 -54729,
 708122855,
 65712,
 -54728,
 708188167,
 65711,
 -54727,
 708253495,
 65710,
 -54726,
 708318786,
 65709,
 -54725,
 708384110,
 65708,
 -54724,
 708449375,
 65707,
 -54723,
 708514630,
 65706,
 -54722,
 708579835,
 65705,
 -1,
 708645099,
 65704,
 708848201,
 708057095,
 -1,
 -54719,
 708778392,
 65722,
 -54718,
 708843751,
 65721,
 -54717,
 708909063,
 65720,
 -54716,
 708974557,
 65719,
 -54715,
 709039470,
 65718,
 -54714,
 709104855,
 65717,
 -54713,
 709169963,
 65716,
 -54712,
 709235195,
 65715,
 -1,
 709300459,
 65714,
 709503570,
 708777538,
 -1,
 -54709,
 709433754,
 65703,
 -54708,
 709499111,
 65702,
 -54707,
 709564423,
 65701,
 -54706,
 709629294,
 65699,
 -54705,
 709694544,
 65698,
 -54704,
 709759787,
 65697,
 -54703,
 709825117,
 65696,
 -1,
 709890283,
 65695,
 710093402,
 709433575,
 -1,
 -54700,
 710023576,
 65729,
 -54699,
 710088258,
 65728,
 -54698,
 710153582,
 65727,
 -54697,
 710218832,
 65726,
 -54696,
 710284075,
 65725,
 -54695,
 710349307,
 65724,
 -1,
 710414571,
 65723,
 710617696,
 710022510,
 -1,
 -54692,
 710547255,
 65694,
 -54691,
 710612741,
 65693,
 -54690,
 710677291,
 65692,
 -54689,
 710742600,
 65691,
 -1,
 710807800,
 65690,
 711010918,
 710546219,
 -1,
 -54686,
 710940258,
 65682,
 -54685,
 711005459,
 65681,
 -54684,
 711070645,
 65680,
 -54683,
 711135758,
 65679,
 -1,
 711201189,
 65678,
 711404138,
 710939728,
 -1,
 -54680,
 711332651,
 65687,
 -54679,
 711398098,
 65686,
 -1,
 711463296,
 65685,
 711720959,
 711334296,
 -1,
 -54676,
 711594580,
 65731,
 -1,
 711659755,
 65730,
 711917567,
 706679595,
 -1,
 711928440,
 711792194,
 -1,
 -54672,
 711858584,
 65757,
 -54671,
 711923943,
 65756,
 -54670,
 711989255,
 65755,
 -54669,
 712054583,
 65754,
 -54668,
 712119874,
 65753,
 -54667,
 712185210,
 65752,
 -54666,
 712250448,
 65751,
 -54665,
 712315691,
 65750,
 -1,
 712380923,
 65749,
 712583809,
 711857518,
 -1,
 -54662,
 712513944,
 65748,
 -54661,
 712579303,
 65747,
 -54660,
 712644407,
 65745,
 -54659,
 712709698,
 65744,
 -54658,
 712774964,
 65743,
 -54657,
 712839990,
 65742,
 -54656,
 712905239,
 65741,
 -1,
 712970669,
 65740,
 713173640,
 712512592,
 -1,
 -54653,
 713103159,
 65739,
 -54652,
 713168238,
 65738,
 -54651,
 713233691,
 65737,
 -54650,
 713298731,
 65736,
 -54649,
 713363969,
 65735,
 -1,
 713429397,
 65734,
 713687039,
 713102123,
 -1,
 -54646,
 713561683,
 65733,
 -1,
 713625873,
 65732,
 713883647,
 706668678,
 -1,
 713894571,
 713757483,
 -1,
 713960088,
 713822715,
 -1,
 -54641,
 713890200,
 65778,
 -54640,
 713955559,
 65777,
 -54639,
 714020871,
 65776,
 -54638,
 714086199,
 65775,
 -54637,
 714151490,
 65774,
 -54636,
 714216814,
 65773,
 -54635,
 714282064,
 65772,
 -54634,
 714347307,
 65771,
 -54633,
 714412539,
 65770,
 -1,
 714477803,
 65769,
 714680995,
 713887979,
 -1,
 -54630,
 714611096,
 65768,
 -54629,
 714676455,
 65767,
 -54628,
 714741767,
 65766,
 -54627,
 714807095,
 65765,
 -54626,
 714872386,
 65764,
 -54625,
 714937710,
 65763,
 -54624,
 715002960,
 65762,
 -54623,
 715068203,
 65761,
 -54622,
 715133435,
 65760,
 -1,
 715198699,
 65759,
 715401898,
 714609451,
 -1,
 -54619,
 715331992,
 65784,
 -54618,
 715397351,
 65783,
 -54617,
 715462663,
 65782,
 -54616,
 715527991,
 65781,
 -54615,
 715592491,
 65780,
 -1,
 715657723,
 65779,
 -1,
 715331350,
 65785,
 -54612,
 713823566,
 65786,
 -1,
 715854609,
 65758,
 716057366,
 706596748,
 -1,
 716122883,
 716014921,
 -1,
 716188345,
 716052487,
 -1,
 -54607,
 716118384,
 65572,
 -54606,
 716183626,
 65551,
 -54605,
 716249019,
 65608,
 -54604,
 716314363,
 65592,
 -54603,
 716379678,
 65597,
 -54602,
 716444882,
 65558,
 -54601,
 716510141,
 65567,
 -54600,
 716575280,
 65603,
 -1,
 716640581,
 65554,
 716843715,
 716117570,
 -1,
 -54597,
 716773900,
 65586,
 -54596,
 716839291,
 65585,
 -54595,
 716904511,
 65546,
 -54594,
 716969684,
 65565,
 -54593,
 717035016,
 65591,
 -54592,
 717100302,
 65578,
 -54591,
 717165488,
 65564,
 -54590,
 717230635,
 65545,
 -1,
 717296006,
 65570,
 717499085,
 716772139,
 -1,
 -54587,
 717429239,
 65606,
 -54586,
 717494557,
 65538,
 -54585,
 717559970,
 65577,
 -54584,
 717625281,
 65580,
 -54583,
 717690436,
 65600,
 -54582,
 717755864,
 65562,
 -54581,
 717821151,
 65560,
 -54580,
 717886120,
 65573,
 -1,
 717951433,
 65599,
 718154455,
 717426923,
 -1,
 -54577,
 718084605,
 65582,
 -54576,
 718149865,
 65536,
 -54575,
 718215192,
 65543,
 -54574,
 718280605,
 65561,
 -54573,
 718345955,
 65589,
 -54572,
 718411250,
 65587,
 -54571,
 718476537,
 65566,
 -54570,
 718541798,
 65579,
 -1,
 718606881,
 65541,
 718809824,
 718083895,
 -1,
 -54567,
 718739990,
 65590,
 -54566,
 718805365,
 65610,
 -54565,
 718870614,
 65553,
 -54564,
 718936023,
 65611,
 -54563,
 719001225,
 65550,
 -54562,
 719066075,
 65607,
 -54561,
 719131269,
 65539,
 -1,
 719196555,
 65576,
 719399657,
 718738798,
 -1,
 -54558,
 719329623,
 65605,
 -54557,
 719394666,
 65547,
 -54556,
 719459948,
 65542,
 -54555,
 719525276,
 65552,
 -54554,
 719590482,
 65601,
 -54553,
 719655936,
 65594,
 -54552,
 719721143,
 65583,
 -1,
 719786431,
 65593,
 719989490,
 719328336,
 -1,
 -54549,
 719919602,
 65568,
 -54548,
 719984887,
 65537,
 -54547,
 720050343,
 65588,
 -54546,
 720115567,
 65549,
 -54545,
 720180488,
 65609,
 -54544,
 720245729,
 65574,
 -54543,
 720310962,
 65581,
 -1,
 720376173,
 65563,
 720579323,
 719917563,
 -1,
 -54540,
 720509111,
 65596,
 -54539,
 720574390,
 65571,
 -54538,
 720639681,
 65559,
 -54537,
 720704904,
 65544,
 -54536,
 720770253,
 65557,
 -54535,
 720835569,
 65584,
 -54534,
 720900771,
 65569,
 -1,
 720966045,
 65540,
 721169152,
 720509159,
 -1,
 -54531,
 721098924,
 65612,
 -54530,
 721163854,
 65602,
 -54529,
 721228398,
 65555,
 -1,
 721293652,
 65556,
 721551359,
 721099160,
 -1,
 -54526,
 721425095,
 65613,
 -1,
 721490183,
 65604,
 721747967,
 716082261,
 -1,
 721758985,
 721623271,
 -1,
 -54522,
 721688984,
 65629,
 -54521,
 721753911,
 65628,
 -54520,
 721818704,
 65627,
 -1,
 721883947,
 65626,
 722086668,
 721688375,
 -1,
 -54517,
 722015598,
 65624,
 -1,
 722080848,
 65623,
 722283279,
 722015598,
 -1,
 -54514,
 722213272,
 65621,
 -1,
 722278407,
 65620,
 722479890,
 722211323,
 -1,
 -54511,
 722409880,
 65617,
 -1,
 722475239,
 65616,
 -54509,
 722409679,
 65625,
 -54508,
 722605863,
 65622,
 -54507,
 722670946,
 65619,
 -1,
 722736170,
 65618,
 722993151,
 716017904,
 -1,
 723004191,
 722866683,
 -1,
 723069723,
 722932816,
 -1,
 -54502,
 722998970,
 65689,
 -1,
 723063895,
 65688,
 723266334,
 722998059,
 -1,
 -54499,
 723196202,
 65684,
 -1,
 723261519,
 65683,
 -1,
 723195690,
 65700,
 -1,
 722932784,
 65746,
 723648511,
 680394752,
 -1,
 723659555,
 723570866,
 983068,
 -1,
 723585350,
 983142,
 -1,
 723604175,
 983062,
 723910655,
 680360032,
 -1,
 -54490,
 723797848,
 128391,
 -1,
 723847637,
 128279,
 724052868,
 680298828,
 -1,
 724118403,
 723988243,
 -1,
 724183890,
 724075170,
 -1,
 724249390,
 724160502,
 -1,
 -54484,
 724218964,
 6430,
 -54483,
 724262350,
 6412,
 -1,
 724310602,
 6411,
 724511538,
 724222420,
 -1,
 -54480,
 724484777,
 6426,
 -54479,
 724524494,
 6425,
 -1,
 724572746,
 6427,
 724773686,
 724457555,
 -1,
 -54476,
 724759565,
 6429,
 -54475,
 724786638,
 6404,
 -1,
 724834890,
 6403,
 725035832,
 724759482,
 6421,
 -1,
 724996768,
 6410,
 725166907,
 725002704,
 -1,
 -54470,
 725114318,
 6417,
 -1,
 725162570,
 6416,
 725363518,
 725127840,
 -1,
 -54467,
 725309602,
 6405,
 -1,
 725359178,
 6415,
 725560129,
 725317728,
 -1,
 -54464,
 725507534,
 6402,
 -1,
 725555786,
 6401,
 725756740,
 725514049,
 -1,
 -54461,
 725704142,
 6409,
 -1,
 725752394,
 6408,
 725953351,
 725695317,
 -1,
 -54458,
 725900750,
 6414,
 -1,
 725949002,
 6413,
 726149962,
 725888936,
 -1,
 -54455,
 726097358,
 6407,
 -1,
 726145610,
 6406,
 726346573,
 726083847,
 -1,
 -54452,
 726293966,
 6419,
 -1,
 726342218,
 6418,
 -54450,
 726330081,
 6424,
 -54449,
 726512724,
 6422,
 -54448,
 726567330,
 6420,
 -54447,
 726629509,
 6423,
 -1,
 726687182,
 6428,
 726870887,
 724156884,
 -1,
 726936414,
 726829763,
 -1,
 727001943,
 726897312,
 -1,
 -54442,
 726948002,
 6449,
 -1,
 726997578,
 6452,
 -54440,
 726978684,
 6451,
 -54439,
 727168084,
 6455,
 -54438,
 727231009,
 6453,
 -54437,
 727288226,
 6454,
 -54436,
 727350405,
 6456,
 -54435,
 727414976,
 6448,
 -1,
 727458758,
 6450,
 727657315,
 726887426,
 -1,
 -54432,
 727630516,
 6459,
 -54431,
 727683557,
 6457,
 -54430,
 727746186,
 6464,
 -1,
 727808541,
 6458,
 728039423,
 727637462,
 -1,
 -54427,
 727970746,
 6441,
 -54426,
 728034017,
 6443,
 -1,
 728085588,
 6442,
 728247155,
 726854114,
 -1,
 728312690,
 728172900,
 -1,
 728378220,
 728242762,
 6432,
 -54421,
 728358075,
 6438,
 -1,
 728393725,
 6436,
 728574830,
 728341185,
 6440,
 -1,
 728537793,
 6437,
 728705904,
 728515778,
 6439,
 -1,
 728646850,
 6435,
 -54415,
 728685755,
 6434,
 -1,
 728786941,
 6433,
 -1,
 728239981,
 6400,
 729033601,
 728186605,
 -1,
 729099127,
 729010166,
 -1,
 -54410,
 729083955,
 6472,
 -1,
 729114143,
 6473,
 729295738,
 729072084,
 -1,
 -54407,
 729249444,
 6476,
 -1,
 729305060,
 6477,
 729492349,
 729240051,
 -1,
 -54404,
 729458200,
 6474,
 -1,
 729511402,
 6475,
 -54402,
 729478960,
 6470,
 -54401,
 729653017,
 6471,
 -54400,
 729716462,
 6479,
 -1,
 729762206,
 6478,
 -54398,
 729002887,
 6469,
 -1,
 729895132,
 6468,
 -1,
 724071811,
 13007,
 730147782,
 724029141,
 -1,
 730213315,
 730104482,
 -1,
 730278804,
 730189814,
 -1,
 730344335,
 730242845,
 -1,
 730409870,
 730305171,
 -1,
 -54390,
 730387761,
 42232,
 -54389,
 730436330,
 42236,
 -54388,
 730494917,
 42237,
 -54387,
 730544972,
 42234,
 -1,
 730606966,
 42235,
 -1,
 730370832,
 42233,
 730868626,
 730317268,
 -1,
 -54383,
 730815950,
 42206,
 -1,
 730864202,
 42205,
 -54381,
 730815950,
 42197,
 -1,
 730995274,
 42196,
 731196311,
 730258619,
 42228,
 -54378,
 731143612,
 42230,
 -1,
 731202754,
 42229,
 731392922,
 731182661,
 -1,
 -54375,
 731340238,
 42211,
 -1,
 731388490,
 42212,
 731589533,
 731378486,
 -1,
 -54372,
 731536846,
 73648,
 -1,
 731585098,
 42220,
 731786144,
 731562452,
 -1,
 -54369,
 731733454,
 42219,
 -1,
 731781706,
 42210,
 731982755,
 731752912,
 -1,
 -54366,
 731930062,
 42194,
 -1,
 731978314,
 42193,
 732179365,
 731945665,
 42227,
 -1,
 732120258,
 42231,
 732310440,
 732140192,
 -1,
 -54361,
 732256418,
 42213,
 -1,
 732305994,
 42208,
 732507051,
 732264544,
 -1,
 -54358,
 732454350,
 42200,
 -1,
 732502602,
 42199,
 732703662,
 732454332,
 -1,
 -54355,
 732650958,
 42216,
 -1,
 732699210,
 42214,
 732900273,
 732649555,
 -1,
 -54352,
 732847566,
 42221,
 -1,
 732895818,
 42198,
 733096883,
 732841154,
 42224,
 -1,
 733076667,
 42225,
 733227958,
 733035349,
 -1,
 -54347,
 733214323,
 42204,
 -1,
 733223498,
 42195,
 733424569,
 733163432,
 -1,
 -54344,
 733371854,
 42203,
 -1,
 733420106,
 42202,
 733621179,
 733354570,
 42222,
 -1,
 733562050,
 42223,
 -54340,
 733606483,
 42215,
 -54339,
 733735649,
 42218,
 -54338,
 733776290,
 42207,
 -54337,
 733838469,
 42209,
 -54336,
 733902687,
 42201,
 -54335,
 733964285,
 42226,
 -54334,
 734024264,
 42217,
 -1,
 734079288,
 42192,
 734330879,
 730181986,
 -1,
 -54331,
 734222402,
 42239,
 -1,
 734279375,
 42238,
 734473182,
 730093651,
 -1,
 734538717,
 734422831,
 -1,
 734604251,
 734461952,
 -1,
 734669776,
 734548467,
 -1,
 734735309,
 734635633,
 -1,
 -54324,
 734711033,
 128964,
 -1,
 734739245,
 11212,
 734986239,
 734688750,
 -1,
 -54321,
 734907312,
 128943,
 -1,
 734965469,
 128969,
 735128531,
 734646262,
 -1,
 -54318,
 735112239,
 128978,
 -1,
 735143642,
 128960,
 735325142,
 735101396,
 -1,
 -54315,
 735278779,
 128949,
 -1,
 735322321,
 128937,
 -54313,
 735309223,
 128910,
 -54312,
 735491276,
 128648,
 -54311,
 735534339,
 128930,
 -54310,
 735594953,
 128955,
 -1,
 735654620,
 128504,
 735903743,
 734566196,
 128498,
 -1,
 735773052,
 128497,
 -1,
 734472199,
 128626,
 736046048,
 734441723,
 128482,
 -1,
 736023915,
 128132,
 -54303,
 736032505,
 129422,
 -54302,
 736160365,
 8374,
 -1,
 736206494,
 129409,
 736374448,
 680204874,
 -1,
 736439909,
 736351828,
 -1,
 736505195,
 736412116,
 -1,
 736570712,
 736463501,
 -1,
 736636245,
 736527010,
 -1,
 736701455,
 736612342,
 -1,
 736766978,
 736681147,
 -1,
 736832513,
 736739088,
 -1,
 736898035,
 736795329,
 -1,
 736963568,
 736838850,
 7444,
 737083391,
 736889810,
 -1,
 -54289,
 737005096,
 43841,
 -1,
 737043765,
 43842,
 737225714,
 736888198,
 43843,
 -1,
 737152720,
 43844,
 -1,
 737193022,
 7432,
 737422326,
 736880037,
 -1,
 -54283,
 737369284,
 983627,
 -1,
 737418354,
 983628,
 737618937,
 737391643,
 -1,
 -54280,
 737595647,
 11385,
 -1,
 737644323,
 43880,
 737815547,
 737568765,
 7433,
 -1,
 737777979,
 42879,
 737946621,
 737762750,
 686,
 -1,
 737869994,
 687,
 -54274,
 737927017,
 43857,
 -54273,
 738032699,
 42881,
 -54272,
 738089043,
 7543,
 -1,
 738139382,
 7426,
 -1,
 736790860,
 42871,
 738405382,
 736714172,
 -1,
 738470917,
 738370569,
 42853,
 -1,
 738396716,
 42855,
 -1,
 738397884,
 7546,
 738667530,
 738331602,
 -1,
 -54264,
 738627363,
 7541,
 -54263,
 738672290,
 11366,
 -1,
 738736832,
 566,
 -54261,
 738653765,
 42793,
 -54260,
 738902518,
 43879,
 -54259,
 738965717,
 42795,
 -54258,
 739025370,
 7446,
 -1,
 739057271,
 11383,
 739257388,
 736674260,
 -1,
 739322903,
 739207696,
 -1,
 739388436,
 739285697,
 7441,
 -54253,
 739355741,
 7442,
 -1,
 739380944,
 7443,
 -54251,
 739368123,
 7453,
 -54250,
 739564342,
 7455,
 -1,
 739589746,
 7454,
 739781664,
 739258280,
 -1,
 739847196,
 739753545,
 -1,
 739912731,
 739816418,
 43851,
 -1,
 739839647,
 43852,
 -1,
 739858543,
 43830,
 740163583,
 739796935,
 -1,
 -54242,
 740079845,
 7573,
 -54241,
 740121796,
 983629,
 -1,
 740170866,
 983630,
 740371496,
 739707858,
 -1,
 740437028,
 740344276,
 -1,
 -54237,
 740420525,
 575,
 -1,
 740451758,
 42954,
 -54235,
 740419557,
 983583,
 -54234,
 740600450,
 7562,
 -54233,
 740662086,
 42921,
 -1,
 740724515,
 7540,
 740895787,
 740301386,
 -1,
 -54230,
 740853965,
 42892,
 -1,
 740915806,
 43872,
 -1,
 740873900,
 43845,
 741157960,
 739198146,
 -1,
 741223487,
 741084114,
 -1,
 741289010,
 741205989,
 983571,
 741408767,
 741212226,
 -1,
 -54223,
 741301444,
 983573,
 -1,
 741350514,
 983575,
 741551157,
 741252235,
 -1,
 -54220,
 741529011,
 983597,
 -1,
 741547122,
 983595,
 741747768,
 741490699,
 -1,
 -54217,
 741725619,
 983601,
 -1,
 741743730,
 983599,
 741944379,
 741684448,
 -1,
 -54214,
 741902795,
 983585,
 -1,
 741945611,
 983587,
 -54212,
 741920296,
 583,
 -54211,
 742111461,
 7570,
 -54210,
 742168678,
 11384,
 -1,
 742217095,
 43828,
 742403138,
 741197175,
 -1,
 -54207,
 742373605,
 7576,
 -1,
 742435458,
 7563,
 742599749,
 742350253,
 -1,
 -54204,
 742555637,
 42787,
 -1,
 742616379,
 42789,
 -54202,
 742586240,
 7578,
 -54201,
 742772726,
 42859,
 -1,
 742823464,
 43836,
 742992994,
 741107709,
 -1,
 743058516,
 742953632,
 -1,
 743124049,
 743034655,
 -1,
 -54196,
 743100406,
 42887,
 -54195,
 743162324,
 42885,
 -54194,
 743224290,
 42883,
 -54193,
 743266387,
 7545,
 -54192,
 743330291,
 42876,
 -1,
 743390037,
 42874,
 743636991,
 743106430,
 -1,
 -54189,
 743545873,
 43840,
 -1,
 743579747,
 43876,
 743779422,
 742984658,
 -1,
 743844953,
 743718923,
 -1,
 -54185,
 743822771,
 983603,
 -54184,
 743857348,
 983602,
 -1,
 743906418,
 983588,
 744107100,
 743808151,
 -1,
 -54181,
 744084915,
 983607,
 -1,
 744103026,
 983605,
 -54179,
 744077541,
 7574,
 -1,
 744262110,
 983567,
 744434785,
 743744694,
 -1,
 -54176,
 744385164,
 43873,
 -1,
 744430293,
 7548,
 -1,
 744407508,
 42861,
 744696951,
 742972603,
 -1,
 744762482,
 744620032,
 -1,
 744828017,
 744746576,
 -1,
 744893545,
 744786386,
 -1,
 -54169,
 744871347,
 983623,
 -54168,
 744905924,
 983569,
 -1,
 744954994,
 983621,
 745155692,
 744866260,
 -1,
 -54165,
 745134577,
 42937,
 -1,
 745170335,
 43854,
 745352303,
 745118859,
 -1,
 -54162,
 745330099,
 983619,
 -1,
 745348210,
 983617,
 -54160,
 745322725,
 7577,
 -1,
 745504912,
 43858,
 -1,
 744761847,
 43855,
 -54157,
 744730885,
 7551,
 -54156,
 745708225,
 43875,
 -54155,
 745769292,
 42872,
 -54154,
 745826301,
 43856,
 -1,
 745882818,
 7531,
 746073227,
 744666082,
 -1,
 746138756,
 745996288,
 -1,
 746204291,
 746122827,
 -1,
 746269826,
 746127360,
 -1,
 -54148,
 746247603,
 983615,
 -54147,
 746311208,
 589,
 -54146,
 746367618,
 7561,
 -54145,
 746429254,
 42919,
 -54144,
 746491683,
 7538,
 -54143,
 746542206,
 7539,
 -1,
 746600815,
 43849,
 -1,
 746235617,
 43847,
 -1,
 746176566,
 42843,
 746925193,
 746082421,
 -1,
 746990727,
 746860456,
 8580,
 -1,
 746917012,
 42815,
 -54136,
 746955318,
 7572,
 -1,
 747069124,
 42998,
 747307007,
 746905571,
 42869,
 -1,
 747178242,
 42845,
 747383966,
 746003018,
 -1,
 747449493,
 747307008,
 -1,
 747515028,
 747433552,
 -1,
 747580561,
 747478155,
 -1,
 -54128,
 747558323,
 983593,
 -1,
 747576434,
 983591,
 -54126,
 747556392,
 11365,
 -54125,
 747747557,
 7567,
 -1,
 747801054,
 983565,
 -1,
 747485526,
 43825,
 748039319,
 747431322,
 42809,
 -1,
 747965788,
 42811,
 -54120,
 748024630,
 42813,
 -54119,
 748149947,
 42807,
 -54118,
 748198593,
 42805,
 -54117,
 748263020,
 42947,
 -54116,
 748324928,
 7568,
 -54115,
 748373416,
 983624,
 -1,
 748427850,
 42803,
 748629171,
 747346625,
 -1,
 748694696,
 748596281,
 -1,
 748760231,
 748657345,
 -1,
 748825766,
 748686290,
 -1,
 -54109,
 748801576,
 43839,
 -54108,
 748861669,
 7575,
 -54107,
 748903620,
 983625,
 -1,
 748952690,
 983626,
 -1,
 748766402,
 43874,
 -1,
 748701128,
 7571,
 749284529,
 748620754,
 -1,
 749350061,
 749266917,
 983577,
 749469695,
 749273154,
 -1,
 -54100,
 749362372,
 983579,
 -1,
 749411442,
 983581,
 749666303,
 749307365,
 -1,
 -54097,
 749595332,
 11386,
 -54096,
 749642199,
 42829,
 -1,
 749704726,
 42827,
 -54094,
 749247169,
 42831,
 -1,
 749833575,
 42935,
 750005444,
 748583995,
 -1,
 750070975,
 749931474,
 -1,
 750136504,
 750010649,
 -1,
 -54089,
 750096163,
 43832,
 -1,
 750135758,
 11361,
 -54087,
 750114227,
 983611,
 -54086,
 750303476,
 42894,
 -54085,
 750365314,
 7557,
 -54084,
 750423761,
 43833,
 -54083,
 750482023,
 43831,
 -54082,
 750543603,
 42825,
 -1,
 750598848,
 564,
 750791874,
 750035060,
 -1,
 -54079,
 750740211,
 7837,
 -1,
 750796450,
 7836,
 -54077,
 750772195,
 42866,
 -1,
 750930881,
 43829,
 751119571,
 749943637,
 -1,
 751185099,
 751045586,
 -1,
 -54073,
 751159077,
 42952,
 -54072,
 751217282,
 7553,
 -54071,
 751275811,
 7533,
 -54070,
 751330447,
 7569,
 -1,
 751385280,
 545,
 751578319,
 751147713,
 -1,
 751643854,
 751558211,
 43848,
 -1,
 751569977,
 43850,
 -1,
 751621855,
 567,
 -54064,
 751564359,
 43878,
 -54063,
 751820771,
 42865,
 -54062,
 751848082,
 7839,
 -1,
 751905036,
 568,
 752102628,
 751053063,
 -1,
 752168152,
 752057573,
 -1,
 752233687,
 752130753,
 43837,
 -1,
 752160464,
 43838,
 -1,
 752174274,
 43826,
 752430301,
 752097866,
 -1,
 752495836,
 752402548,
 -1,
 -54053,
 752436418,
 43827,
 -1,
 752492643,
 43824,
 -1,
 752469076,
 43853,
 752757985,
 752356306,
 -1,
 -54049,
 752724610,
 7552,
 -54048,
 752783139,
 7532,
 -1,
 752833927,
 42903,
 -54046,
 752729961,
 42823,
 -54045,
 752985428,
 7447,
 -1,
 753028790,
 42933,
 753216753,
 752084378,
 -1,
 753282282,
 753142738,
 -1,
 -54041,
 753253183,
 11377,
 -54040,
 753314434,
 7564,
 -54039,
 753352354,
 42847,
 -1,
 753416896,
 11380,
 753609966,
 753245503,
 -1,
 -54036,
 753590025,
 42911,
 -54035,
 753638417,
 42909,
 -1,
 753671414,
 42907,
 -54033,
 753595190,
 42849,
 -54032,
 753824906,
 42851,
 -1,
 753879918,
 42857,
 754068733,
 753151912,
 -1,
 754134262,
 754016854,
 43859,
 754253823,
 754060807,
 -1,
 -54027,
 754170759,
 43860,
 -1,
 754221262,
 43861,
 754396410,
 754060242,
 -1,
 -54024,
 754372136,
 572,
 -54023,
 754428546,
 42900,
 -1,
 754461134,
 42899,
 754658556,
 754376111,
 42797,
 -1,
 754584621,
 42799,
 -1,
 754622078,
 42863,
 754855176,
 754029216,
 -1,
 754920710,
 754781138,
 -1,
 754986242,
 754855848,
 -1,
 -54015,
 754967562,
 565,
 -1,
 755023854,
 43835,
 -54013,
 754952834,
 7559,
 -54012,
 755145542,
 42917,
 -54011,
 755207971,
 7536,
 -1,
 755252698,
 42897,
 -54009,
 754900963,
 42868,
 -1,
 755390595,
 983589,
 755576082,
 754813260,
 -1,
 755641614,
 755502034,
 -1,
 -54005,
 755619251,
 983613,
 -54004,
 755673730,
 7558,
 -54003,
 755732259,
 7535,
 -1,
 755775855,
 43834,
 755969297,
 755591632,
 -1,
 -54000,
 755951002,
 7933,
 -1,
 755991844,
 7931,
 -1,
 755949539,
 42867,
 756231452,
 755521619,
 -1,
 756296984,
 756188881,
 -1,
 -53995,
 756276411,
 42943,
 -53994,
 756338083,
 578,
 -53993,
 756377597,
 42941,
 -1,
 756423242,
 42939,
 756624667,
 756222930,
 -1,
 -53990,
 756591234,
 7555,
 -1,
 756652870,
 42913,
 -1,
 756571598,
 983199,
 756886820,
 756197886,
 -1,
 756952353,
 756859348,
 -1,
 757017888,
 756931057,
 7549,
 -1,
 756943404,
 42833,
 -1,
 756986837,
 42837,
 -53982,
 756918914,
 7560,
 -53981,
 757174051,
 7537,
 -1,
 757224839,
 42835,
 757411116,
 756840588,
 -1,
 757476647,
 757386792,
 42817,
 -1,
 757399635,
 42821,
 757607722,
 757414741,
 -1,
 -53975,
 757557402,
 42819,
 -1,
 757616217,
 11370,
 -53973,
 757574274,
 7556,
 -1,
 757766982,
 42915,
 757935413,
 757358012,
 -1,
 758000944,
 757899634,
 -1,
 -53969,
 757947588,
 983631,
 -1,
 757996658,
 983632,
 758197555,
 757926866,
 -1,
 -53966,
 758164098,
 42901,
 -1,
 758201818,
 11368,
 -53964,
 758139828,
 42791,
 -1,
 758325223,
 11382,
 758525245,
 757920327,
 -1,
 758590780,
 758482405,
 -1,
 758656315,
 758552064,
 43863,
 758775807,
 758579200,
 -1,
 -53958,
 758705974,
 43865,
 -1,
 758718880,
 43864,
 -1,
 758639287,
 43862,
 -1,
 758557314,
 7565,
 759049538,
 758511205,
 -1,
 -53953,
 759025509,
 576,
 -53952,
 759081602,
 7566,
 -53951,
 759140131,
 7542,
 -1,
 759184858,
 11372,
 759377224,
 759017998,
 -1,
 759442759,
 759303122,
 -1,
 -53947,
 759418478,
 42839,
 -53946,
 759456935,
 587,
 -1,
 759512738,
 42841,
 -1,
 759409109,
 569,
 759770445,
 759362459,
 -1,
 759835980,
 759742932,
 -1,
 -53941,
 759814641,
 591,
 -1,
 759850399,
 43866,
 -1,
 759793310,
 7935,
 760098129,
 759714340,
 -1,
 -53937,
 760073768,
 42905,
 -53936,
 760130178,
 7554,
 -1,
 760188707,
 7534,
 760360276,
 760051523,
 -1,
 -53933,
 760335912,
 585,
 -1,
 760365082,
 983609,
 -1,
 760343250,
 11379,
 760676351,
 736571610,
 -1,
 -53929,
 760601876,
 7550,
 -1,
 760637537,
 7547,
 760872959,
 736550541,
 -1,
 760884571,
 760791508,
 8347,
 -1,
 760820696,
 8340,
 -53924,
 760869424,
 8339,
 -53923,
 760997274,
 7525,
 -53922,
 761060539,
 7524,
 -53921,
 761122806,
 8348,
 -53920,
 761181154,
 7523,
 -53919,
 761244112,
 8346,
 -53918,
 761305793,
 8338,
 -53917,
 761369248,
 8345,
 -53916,
 761432396,
 8344,
 -53915,
 761494587,
 8343,
 -53914,
 761559136,
 8342,
 -53913,
 761624385,
 11388,
 -53912,
 761686013,
 7522,
 -53911,
 761748924,
 8341,
 -53910,
 761808066,
 8337,
 -1,
 761862730,
 8336,
 762064436,
 736440538,
 -1,
 762129787,
 762040310,
 -1,
 762195318,
 762111001,
 -1,
 762260848,
 762124874,
 11375,
 -1,
 762218555,
 11376,
 -53903,
 762242458,
 581,
 -53902,
 762367990,
 42929,
 -53901,
 762412091,
 42880,
 -53900,
 762476640,
 42928,
 -53899,
 762540345,
 42878,
 -1,
 762600892,
 42893,
 762785144,
 762144122,
 42852,
 -1,
 762710572,
 42854,
 -53895,
 762771013,
 42792,
 -53894,
 762886357,
 42794,
 -1,
 762907774,
 574,
 763112847,
 762070210,
 -1,
 763178379,
 763038674,
 -1,
 763243905,
 763160549,
 983570,
 763363327,
 763166786,
 -1,
 -53888,
 763256004,
 983572,
 -1,
 763305074,
 983574,
 763506052,
 763206795,
 -1,
 -53885,
 763483571,
 983596,
 -1,
 763501682,
 983594,
 763702663,
 763445259,
 -1,
 -53882,
 763680179,
 983600,
 -1,
 763698290,
 983598,
 763899274,
 763639008,
 -1,
 -53879,
 763857355,
 983584,
 -1,
 763900171,
 983586,
 -1,
 763874856,
 582,
 764161422,
 763125165,
 -1,
 -53875,
 764116981,
 42786,
 -1,
 764177723,
 42788,
 -1,
 764137462,
 42858,
 764423582,
 763042378,
 -1,
 764489110,
 764349394,
 -1,
 764554644,
 764451979,
 -1,
 -53869,
 764532147,
 983592,
 -1,
 764550258,
 983590,
 -53867,
 764530216,
 570,
 -1,
 764709342,
 983564,
 764882328,
 764470682,
 42808,
 -1,
 764808540,
 42810,
 -53863,
 764867382,
 42812,
 -53862,
 764992699,
 42806,
 -53861,
 765041345,
 42804,
 -53860,
 765105772,
 42946,
 -53859,
 765167675,
 11373,
 -1,
 765205066,
 42802,
 765406636,
 764395988,
 -1,
 765472166,
 765332434,
 -1,
 765537699,
 765444564,
 -1,
 -53854,
 765520813,
 11390,
 -1,
 765552046,
 42953,
 -53852,
 765519845,
 983582,
 -53851,
 765696838,
 42920,
 -1,
 765748356,
 42949,
 765930921,
 765430413,
 -1,
 -53848,
 765899288,
 586,
 -1,
 765931728,
 42926,
 -53846,
 765878329,
 7838,
 -53845,
 766064914,
 42924,
 -1,
 766124233,
 42891,
 766324154,
 765356029,
 -1,
 766389684,
 766286131,
 -1,
 -53841,
 766365686,
 42886,
 -53840,
 766427604,
 42884,
 -53839,
 766489570,
 42882,
 -53838,
 766531667,
 42877,
 -53837,
 766595571,
 42875,
 -1,
 766655317,
 42873,
 766848441,
 766315474,
 -1,
 766913976,
 766811275,
 -1,
 -53833,
 766891443,
 983606,
 -1,
 766909554,
 983604,
 -1,
 766872030,
 983566,
 -1,
 766820820,
 42860,
 767241672,
 766292962,
 -1,
 767307203,
 767164416,
 -1,
 767372738,
 767290960,
 -1,
 767438272,
 767348726,
 -1,
 -53825,
 767388810,
 983614,
 -1,
 767434345,
 11364,
 -53823,
 767413800,
 588,
 -1,
 767597382,
 42918,
 -1,
 767344694,
 42842,
 767831495,
 767250549,
 -1,
 -53819,
 767795759,
 42923,
 -53818,
 767844036,
 42997,
 -1,
 767897550,
 42814,
 -1,
 767811570,
 42844,
 768159185,
 767223194,
 -1,
 768224717,
 768122175,
 -1,
 -53813,
 768204553,
 42910,
 -53812,
 768252945,
 42908,
 -1,
 768285942,
 42906,
 -53810,
 768209718,
 42848,
 -53809,
 768439434,
 42850,
 -53808,
 768494446,
 42856,
 -1,
 768543870,
 42846,
 768749020,
 768138429,
 -1,
 768814555,
 768732752,
 -1,
 768880087,
 768772562,
 -1,
 -53803,
 768857523,
 983622,
 -53802,
 768892100,
 983568,
 -1,
 768941170,
 983620,
 769142234,
 768842891,
 -1,
 -53799,
 769119667,
 983618,
 -1,
 769137778,
 983616,
 -1,
 769117736,
 42936,
 -1,
 768747982,
 580,
 769469927,
 768711361,
 -1,
 769535461,
 769395666,
 -1,
 769600994,
 769517541,
 983576,
 769720319,
 769523778,
 -1,
 -53791,
 769612996,
 983578,
 -1,
 769662066,
 983580,
 769916927,
 769557989,
 -1,
 -53788,
 769827287,
 42828,
 -1,
 769889814,
 42826,
 -53786,
 769497793,
 42830,
 -1,
 770018663,
 42934,
 770190832,
 769404840,
 -1,
 770256364,
 770116562,
 -1,
 -53782,
 770231848,
 571,
 -53781,
 770288258,
 42948,
 -1,
 770320846,
 42898,
 770518510,
 770235823,
 42796,
 -1,
 770444333,
 42798,
 -53777,
 770481790,
 42862,
 -1,
 770597462,
 42931,
 770780664,
 770145381,
 -1,
 770846196,
 770713863,
 -1,
 -53773,
 770787982,
 42925,
 -1,
 770843725,
 573,
 -53771,
 770823603,
 983610,
 -53770,
 771002147,
 11362,
 -53769,
 771056371,
 42824,
 -1,
 771113294,
 11360,
 771304960,
 770725971,
 -1,
 771370494,
 771262161,
 -1,
 -53765,
 771349691,
 42942,
 -53764,
 771411363,
 577,
 -53763,
 771450877,
 42940,
 -1,
 771496522,
 42938,
 -53761,
 771317198,
 983198,
 -1,
 771624466,
 42912,
 771829255,
 771258508,
 -1,
 771894787,
 771804712,
 42816,
 -1,
 771817555,
 42820,
 772025862,
 771832661,
 -1,
 -53755,
 771975322,
 42818,
 -1,
 772034137,
 11369,
 -1,
 771988294,
 42914,
 772288013,
 771795454,
 -1,
 772353548,
 772260308,
 -1,
 772419083,
 772332017,
 11363,
 -1,
 772344364,
 42832,
 -1,
 772387797,
 42836,
 -1,
 772298119,
 42834,
 772681236,
 772245836,
 -1,
 772746769,
 772630992,
 -1,
 -53744,
 772728218,
 7932,
 -1,
 772769060,
 7930,
 772997119,
 772672466,
 -1,
 -53741,
 772920755,
 983612,
 -1,
 772957316,
 11374,
 773139994,
 772627900,
 -1,
 773205528,
 773065682,
 -1,
 -53737,
 773153924,
 42922,
 -1,
 773209562,
 11367,
 -53735,
 773147572,
 42790,
 -1,
 773332967,
 11381,
 773533216,
 773073159,
 -1,
 773598750,
 773458898,
 -1,
 -53731,
 773574184,
 579,
 -1,
 773608839,
 42902,
 -53729,
 773570409,
 42822,
 -1,
 773738166,
 42932,
 773926436,
 773518949,
 -1,
 -53726,
 773902181,
 11391,
 -53725,
 773958274,
 42950,
 -1,
 773995994,
 11371,
 774188584,
 773879619,
 -1,
 -53722,
 774165939,
 983608,
 -53721,
 774229544,
 584,
 -1,
 774257007,
 42930,
 774450731,
 774173595,
 -1,
 -53718,
 774426152,
 590,
 -1,
 774473374,
 7934,
 774647342,
 774418960,
 -1,
 -53715,
 774622830,
 42838,
 -1,
 774651554,
 42840,
 774843953,
 774607548,
 -1,
 -53712,
 774806342,
 42916,
 -1,
 774847962,
 42896,
 -53710,
 774826706,
 11378,
 -53709,
 774984236,
 42904,
 -1,
 775044042,
 42951,
 775237212,
 762020514,
 -1,
 775302746,
 775209428,
 -1,
 775368281,
 775260846,
 -1,
 775433788,
 775344118,
 7451,
 775553023,
 775414809,
 -1,
 -53702,
 775468002,
 7450,
 -53701,
 775522636,
 43002,
 -1,
 775570626,
 11387,
 775761474,
 775402466,
 -1,
 775827008,
 775704693,
 -1,
 -53697,
 775795682,
 7449,
 -1,
 775852704,
 7438,
 -53695,
 775806947,
 42870,
 -1,
 775949967,
 43846,
 776154693,
 775723713,
 7439,
 -53692,
 776133819,
 7445,
 -1,
 776186973,
 7440,
 776351304,
 776094914,
 7431,
 -53689,
 776337277,
 7459,
 -1,
 776393549,
 7430,
 776547914,
 776280650,
 7424,
 -1,
 776488130,
 7425,
 -53685,
 776533573,
 7458,
 -53684,
 776661665,
 7457,
 -53683,
 776725914,
 7456,
 -53682,
 776789179,
 7452,
 -53681,
 776847828,
 42801,
 -53680,
 776909326,
 42927,
 -53679,
 776972752,
 7448,
 -53678,
 777029964,
 7437,
 -53677,
 777092205,
 7436,
 -53676,
 777156704,
 7435,
 -53675,
 777221953,
 7434,
 -53674,
 777277939,
 42800,
 -53673,
 777337685,
 7429,
 -53672,
 777400232,
 7428,
 -1,
 777464347,
 7427,
 -1,
 775319777,
 42895,
 -53669,
 775285126,
 7460,
 -1,
 777657994,
 7461,
 777912319,
 775179488,
 -1,
 777924192,
 777828657,
 -1,
 -53665,
 777890256,
 43004,
 -1,
 777933299,
 43003,
 778120803,
 777873405,
 -1,
 -53662,
 778082911,
 43005,
 -1,
 778110055,
 43006,
 -53660,
 778094511,
 42999,
 -1,
 778249387,
 43007,
 778448519,
 736408546,
 -1,
 778514054,
 778394081,
 -1,
 778579567,
 778476225,
 -1,
 778645100,
 778548608,
 -1,
 -53654,
 778619844,
 128999,
 -53653,
 778649266,
 128310,
 -1,
 778712083,
 128992,
 778960895,
 778605744,
 -1,
 -53650,
 778878330,
 68415,
 -1,
 778911831,
 68413,
 779103863,
 778512647,
 -1,
 779169396,
 779061511,
 -1,
 -53646,
 779144132,
 128998,
 -53645,
 779173554,
 128311,
 -1,
 779236371,
 128309,
 779485183,
 779141203,
 -1,
 -53642,
 779406276,
 129003,
 -1,
 779432979,
 128996,
 779628154,
 779089023,
 -1,
 -53639,
 779602884,
 129000,
 -1,
 779629587,
 128993,
 779824765,
 779606989,
 -1,
 -53636,
 779795877,
 68414,
 -1,
 779829401,
 68412,
 780021376,
 779794278,
 -1,
 -53633,
 779996100,
 128997,
 -1,
 780022803,
 128308,
 780217987,
 779989454,
 -1,
 -53630,
 780192708,
 129002,
 -1,
 780219411,
 128995,
 780468223,
 780164367,
 -1,
 -53627,
 780389316,
 129001,
 -1,
 780416019,
 128994,
 -1,
 778463272,
 8382,
 780676774,
 778410691,
 -1,
 780742309,
 780632738,
 -1,
 780807834,
 780708495,
 -1,
 780873359,
 780745557,
 -1,
 780938894,
 780811093,
 -1,
 -53619,
 780885454,
 3730,
 -1,
 780933706,
 3729,
 -1,
 780885454,
 3736,
 781201042,
 780851771,
 -1,
 -53615,
 781147598,
 3728,
 -1,
 781195850,
 3727,
 781397653,
 781161120,
 -1,
 -53612,
 781382586,
 3726,
 -1,
 781423338,
 3731,
 -53610,
 781354301,
 3756,
 -53609,
 781547465,
 3724,
 -53608,
 781605584,
 3718,
 -53607,
 781660785,
 3721,
 -1,
 781724586,
 3744,
 781921949,
 780780421,
 -1,
 -53604,
 781894313,
 3753,
 -1,
 781934030,
 3752,
 782118560,
 781875888,
 -1,
 -53601,
 782080695,
 3807,
 -1,
 782130237,
 3806,
 782315171,
 782063031,
 -1,
 -53598,
 782278270,
 983204,
 -1,
 782313672,
 983205,
 -53596,
 782286634,
 983206,
 -1,
 782468581,
 983207,
 -1,
 780716073,
 3770,
 782708393,
 780651705,
 -1,
 -53592,
 782691967,
 127772,
 -1,
 782749619,
 127767,
 782905004,
 782646101,
 -1,
 -53589,
 782889798,
 128030,
 -1,
 782908882,
 129692,
 783101615,
 782838023,
 -1,
 -53586,
 783043119,
 127991,
 -1,
 783090156,
 129404,
 -1,
 783038801,
 129357,
 783364022,
 736314562,
 -1,
 783429449,
 783308779,
 -1,
 783494918,
 783412033,
 -1,
 783560407,
 783470582,
 -1,
 783625929,
 783530475,
 -1,
 783691464,
 783552442,
 -1,
 783756998,
 783623616,
 11104,
 783876095,
 783679488,
 -1,
 783888068,
 783806032,
 -1,
 783953596,
 783844981,
 -1,
 -53573,
 783934259,
 11172,
 -1,
 783958845,
 11174,
 784150207,
 783892761,
 -1,
 -53570,
 784132105,
 983237,
 -1,
 784164149,
 11130,
 -53568,
 784132172,
 129072,
 -53567,
 784307030,
 129056,
 -53566,
 784370951,
 129060,
 -53565,
 784425276,
 129068,
 -1,
 784477636,
 129064,
 -53563,
 783865584,
 11120,
 -1,
 784640103,
 11136,
 -53561,
 783723115,
 11140,
 -1,
 784743582,
 11114,
 -1,
 783614232,
 129168,
 785002198,
 783610149,
 -1,
 785067733,
 784934342,
 -1,
 785133268,
 785051216,
 -1,
 785198802,
 785108982,
 -1,
 785264337,
 785129065,
 11067,
 785383423,
 785189842,
 -1,
 -53552,
 785311753,
 11068,
 -1,
 785334865,
 11069,
 -1,
 785234419,
 11244,
 -53549,
 785180681,
 11060,
 -1,
 785531473,
 11061,
 -1,
 785078167,
 11062,
 -1,
 785045970,
 11063,
 -1,
 784966127,
 129186,
 785919728,
 783492550,
 -1,
 785985256,
 785903184,
 -1,
 786050784,
 785960950,
 -1,
 786116317,
 786002665,
 -1,
 -53540,
 786096947,
 11025,
 -1,
 786121533,
 11024,
 786366463,
 786046573,
 -1,
 -53537,
 786294793,
 11065,
 -1,
 786317905,
 11066,
 786509539,
 786024785,
 -1,
 -53534,
 786487472,
 129024,
 -1,
 786517268,
 129040,
 -53532,
 786471033,
 129176,
 -53531,
 786664738,
 129028,
 -53530,
 786726395,
 129032,
 -53529,
 786779412,
 129044,
 -1,
 786841835,
 11064,
 787033839,
 785914442,
 -1,
 787099374,
 786968120,
 -1,
 787164909,
 787069208,
 -1,
 -53524,
 787142073,
 11083,
 -1,
 787161149,
 11074,
 -1,
 787095613,
 11082,
 -1,
 787059729,
 129973,
 -1,
 787010789,
 11070,
 787558134,
 785852679,
 -1,
 787623668,
 787512497,
 -1,
 -53517,
 787559562,
 11144,
 -1,
 787621312,
 11013,
 -53515,
 787588474,
 129184,
 -1,
 787749914,
 129192,
 787951353,
 787530196,
 -1,
 -53512,
 787919577,
 129080,
 -1,
 787948369,
 129104,
 788147964,
 787919842,
 -1,
 -53509,
 788110251,
 128620,
 -1,
 788163491,
 129190,
 788344575,
 788095268,
 -1,
 -53506,
 788281124,
 129088,
 -1,
 788342208,
 129092,
 788541186,
 788287987,
 -1,
 -53503,
 788512664,
 129194,
 -1,
 788557849,
 129076,
 -53501,
 788524295,
 129172,
 -53500,
 788705941,
 11077,
 -53499,
 788758830,
 129188,
 -1,
 788805412,
 129084,
 789000000,
 783417344,
 -1,
 789065494,
 788946382,
 -1,
 789131029,
 789021465,
 -1,
 789196560,
 789066771,
 129287,
 789315583,
 789122002,
 -1,
 789327630,
 789237750,
 -1,
 -53491,
 789311564,
 129285,
 -1,
 789341767,
 129284,
 -53489,
 789272217,
 129283,
 -1,
 789463032,
 129286,
 -53487,
 789168501,
 129970,
 -53486,
 789613818,
 129932,
 -53485,
 789672379,
 129940,
 -53484,
 789730761,
 129977,
 -1,
 789785796,
 11240,
 -1,
 789091311,
 128379,
 790048548,
 788994634,
 -1,
 790114081,
 790008480,
 -1,
 790179616,
 790051671,
 -1,
 790245148,
 790159921,
 -1,
 -53477,
 790208309,
 129917,
 -1,
 790241832,
 129899,
 790441759,
 790202264,
 -1,
 -53474,
 790404917,
 129916,
 -1,
 790438440,
 129897,
 -1,
 790412221,
 129947,
 -1,
 790125154,
 128494,
 790822911,
 790085794,
 -1,
 -53469,
 790743493,
 11056,
 -1,
 790770783,
 11058,
 790966059,
 790016994,
 -1,
 791031594,
 790915937,
 -1,
 -53465,
 791014638,
 11012,
 -53464,
 791075062,
 11108,
 -53463,
 791135092,
 129112,
 -1,
 791162002,
 11020,
 -1,
 790961898,
 11788,
 791424818,
 790941686,
 -1,
 791490351,
 791393250,
 -1,
 -53458,
 791439626,
 129900,
 -1,
 791487337,
 11785,
 791740415,
 791436732,
 -1,
 -53455,
 791651823,
 128492,
 -1,
 791704555,
 129985,
 791883575,
 791396820,
 -1,
 -53452,
 791862948,
 11778,
 -53451,
 791915534,
 128488,
 -53450,
 791964195,
 11814,
 -1,
 792006784,
 10181,
 792211258,
 791837755,
 -1,
 -53447,
 792190779,
 128709,
 -1,
 792242439,
 11804,
 792407869,
 792149907,
 -1,
 -53444,
 792387122,
 11816,
 -1,
 792451660,
 11780,
 -53442,
 792392194,
 128398,
 -53441,
 792586160,
 11808,
 -1,
 792606155,
 9948,
 792854527,
 788926290,
 -1,
 792866630,
 792744539,
 -1,
 792932164,
 792842073,
 4054,
 -1,
 792857791,
 4056,
 -53435,
 792876184,
 129307,
 -1,
 792995173,
 1422,
 -53433,
 792844064,
 8294,
 -53432,
 793161535,
 128269,
 -1,
 793206703,
 9958,
 793391022,
 783395807,
 -1,
 793456512,
 793346722,
 -1,
 793522004,
 793432054,
 -1,
 793587535,
 793497590,
 -1,
 -53426,
 793533902,
 7246,
 -1,
 793582154,
 7245,
 793784146,
 793559508,
 -1,
 -53423,
 793730510,
 7192,
 -1,
 793778762,
 7191,
 -53421,
 793730510,
 7179,
 -1,
 793909834,
 7178,
 794111832,
 793487824,
 -1,
 -53418,
 794066053,
 7183,
 -53417,
 794123726,
 7184,
 -1,
 794171978,
 7182,
 794373980,
 794071712,
 -1,
 -53414,
 794358714,
 7177,
 -53413,
 794384546,
 7173,
 -1,
 794434122,
 7181,
 794636128,
 794327136,
 -1,
 -53410,
 794590341,
 7169,
 -53409,
 794648014,
 7170,
 -1,
 794696266,
 7168,
 794898276,
 794573653,
 -1,
 -53406,
 794883699,
 7193,
 -53405,
 794901504,
 7247,
 -1,
 794958410,
 7180,
 795160423,
 794870228,
 -1,
 -53402,
 795106766,
 7201,
 -1,
 795155018,
 7200,
 795357034,
 795117900,
 -1,
 -53399,
 795311237,
 7190,
 -1,
 795351626,
 7189,
 795553645,
 795303356,
 -1,
 -53396,
 795507845,
 7198,
 -1,
 795548234,
 7197,
 795750256,
 795498579,
 -1,
 -53393,
 795704453,
 7172,
 -1,
 795744842,
 7171,
 795946867,
 795693555,
 -1,
 -53390,
 795901061,
 7186,
 -1,
 795941450,
 7185,
 796143478,
 795881384,
 -1,
 -53387,
 796089806,
 7175,
 -1,
 796138058,
 7174,
 796340089,
 796076295,
 -1,
 -53384,
 796294277,
 7188,
 -1,
 796334666,
 7187,
 -53382,
 796324794,
 7194,
 -53381,
 796519137,
 7202,
 -53380,
 796583341,
 7199,
 -53379,
 796636244,
 7195,
 -53378,
 796687493,
 7196,
 -53377,
 796751711,
 7176,
 -1,
 796793418,
 7203,
 796995470,
 793394925,
 -1,
 797060996,
 796970998,
 -1,
 -53373,
 797044787,
 7234,
 -1,
 797074975,
 7235,
 797257607,
 797032916,
 -1,
 -53370,
 797210276,
 7238,
 -1,
 797265892,
 7239,
 797454218,
 797200883,
 -1,
 -53367,
 797419032,
 7236,
 -1,
 797472234,
 7237,
 -53365,
 797439792,
 7232,
 -53364,
 797613849,
 7233,
 -53363,
 797677294,
 7241,
 -1,
 797723038,
 7240,
 797912984,
 796931981,
 -1,
 797978513,
 797872800,
 7216,
 -1,
 797963521,
 7220,
 798109587,
 797931616,
 7213,
 -1,
 798040765,
 7221,
 -53356,
 798085110,
 7219,
 -53355,
 798208994,
 7218,
 -53354,
 798271952,
 7217,
 -53353,
 798329164,
 7214,
 -1,
 798391355,
 7215,
 798568352,
 797895210,
 -1,
 798633883,
 798547131,
 7210,
 -1,
 798612667,
 7211,
 798764957,
 798595777,
 7208,
 -1,
 798726849,
 7209,
 -53346,
 798713853,
 7207,
 -53345,
 798835906,
 7212,
 -1,
 798890767,
 7206,
 799092647,
 798536034,
 -1,
 799158181,
 799068150,
 -1,
 799223716,
 799131364,
 7231,
 -1,
 799146435,
 7230,
 -1,
 799152888,
 7227,
 -53338,
 799120021,
 7228,
 -1,
 799355427,
 7229,
 799604735,
 799064532,
 -1,
 799616939,
 799530454,
 -1,
 -53334,
 799601594,
 7204,
 -1,
 799650900,
 7205,
 799866879,
 799566850,
 -1,
 -53331,
 799782250,
 7222,
 -1,
 799840749,
 7223,
 800010161,
 793320819,
 -1,
 -53328,
 799994720,
 129388,
 -1,
 799998704,
 127811,
 -53326,
 799991521,
 127898,
 -53325,
 800170501,
 128006,
 -53324,
 800231638,
 127819,
 -53323,
 800282707,
 129461,
 -1,
 800341551,
 128210,
 800534515,
 783348534,
 -1,
 800600021,
 800469992,
 -1,
 800665531,
 800575478,
 66199,
 -53318,
 800641014,
 66200,
 -1,
 800677308,
 66185,
 800862141,
 800625312,
 66191,
 -1,
 800821920,
 66193,
 800993215,
 800819532,
 66190,
 -1,
 800950604,
 66192,
 801124289,
 800946272,
 66187,
 -1,
 801077344,
 66196,
 801255363,
 801064130,
 66177,
 -1,
 801215136,
 66202,
 801386437,
 801188103,
 66178,
 -1,
 801332668,
 66179,
 801517511,
 801315402,
 66176,
 -1,
 801477280,
 66201,
 -53304,
 801502789,
 66184,
 -53303,
 801632816,
 66204,
 -53302,
 801696417,
 66183,
 -53301,
 801758395,
 66194,
 -53300,
 801817044,
 66198,
 -53299,
 801879010,
 66197,
 -53298,
 801944078,
 66188,
 -53297,
 802007504,
 66195,
 -53296,
 802061371,
 66189,
 -53295,
 802125633,
 66186,
 -53294,
 802187261,
 66182,
 -53293,
 802250172,
 66203,
 -53292,
 802314323,
 66180,
 -1,
 802372437,
 66181,
 802566130,
 800538307,
 -1,
 802631665,
 802521762,
 -1,
 802697177,
 802607094,
 67887,
 -1,
 802672630,
 67892,
 802828251,
 802669012,
 67891,
 -1,
 802800084,
 67886,
 802959325,
 802788000,
 67883,
 -1,
 802919072,
 67896,
 803090399,
 802913339,
 67881,
 -1,
 803074870,
 67895,
 803221473,
 803030210,
 67876,
 -1,
 803181216,
 67894,
 803352547,
 803150410,
 67872,
 -1,
 803312288,
 67893,
 -53276,
 803337014,
 67879,
 -53275,
 803464602,
 67877,
 -53274,
 803527867,
 67888,
 -53273,
 803582946,
 67885,
 -53272,
 803648014,
 67890,
 -53271,
 803707585,
 67884,
 -53270,
 803768652,
 67882,
 -53269,
 803829856,
 67880,
 -53268,
 803891197,
 67878,
 -53267,
 803952723,
 67874,
 -53266,
 804016627,
 67889,
 -53265,
 804076373,
 67875,
 -53264,
 804138920,
 67897,
 -1,
 804202759,
 67873,
 -1,
 802609476,
 67903,
 -1,
 802516744,
 129317,
 804532287,
 800496321,
 -1,
 804597806,
 804514465,
 -1,
 804663338,
 804539693,
 -1,
 804728850,
 804618277,
 -1,
 804794380,
 804661511,
 -1,
 804859915,
 804750854,
 -1,
 804925448,
 804839985,
 -1,
 804990974,
 804884091,
 -1,
 -53252,
 804960935,
 129855,
 -53251,
 805015207,
 129873,
 -1,
 805056982,
 129854,
 805253123,
 804946137,
 -1,
 805318658,
 805210008,
 -1,
 -53247,
 805277351,
 129871,
 -1,
 805319126,
 129856,
 -1,
 805298904,
 129869,
 805634047,
 805188069,
 -1,
 805646343,
 805537688,
 -1,
 -53242,
 805616295,
 129872,
 -1,
 805670567,
 129870,
 -1,
 805626584,
 129868,
 805961727,
 804882379,
 -1,
 -53238,
 805878439,
 129853,
 -1,
 805908950,
 129852,
 -1,
 804790320,
 128394,
 806170639,
 804760016,
 -1,
 -53234,
 806112090,
 128393,
 -1,
 806166158,
 128396,
 -53232,
 806148436,
 129951,
 -53231,
 806311525,
 128395,
 -1,
 806369467,
 128397,
 806563880,
 804698797,
 -1,
 806629414,
 806497607,
 -1,
 806694947,
 806586264,
 -1,
 806760473,
 806653585,
 -1,
 -53225,
 806730407,
 129860,
 -53224,
 806784679,
 129862,
 -1,
 806826454,
 129859,
 807022622,
 806715609,
 -1,
 807088157,
 807002673,
 -1,
 -53220,
 807046823,
 129866,
 -1,
 807088598,
 129861,
 -1,
 807045095,
 129864,
 807403519,
 806957541,
 -1,
 807415842,
 807330353,
 -1,
 -53215,
 807385767,
 129867,
 -1,
 807440039,
 129865,
 -1,
 807372775,
 129863,
 807731199,
 806675132,
 -1,
 -53211,
 807647911,
 129858,
 -1,
 807678422,
 129857,
 -53209,
 806607188,
 129950,
 -1,
 807847349,
 128318,
 -53207,
 806541676,
 129903,
 -1,
 807952075,
 129935,
 808189951,
 804585472,
 -1,
 808202285,
 808090046,
 11847,
 -1,
 808127636,
 11848,
 -1,
 808136379,
 128261,
 808398899,
 804533536,
 128274,
 808464434,
 808349692,
 -1,
 -53199,
 808449840,
 983079,
 -1,
 808492825,
 983076,
 -1,
 808390077,
 128271,
 808726584,
 808359411,
 -1,
 808792119,
 808663893,
 -1,
 -53194,
 808763707,
 129688,
 -1,
 808810120,
 10188,
 -1,
 808747546,
 11059,
 809054267,
 808707727,
 -1,
 -53190,
 809009819,
 128140,
 -1,
 809067985,
 127977,
 -53188,
 809033464,
 128557,
 -53187,
 809227903,
 129524,
 -53186,
 809272711,
 127853,
 -1,
 809316095,
 129438,
 809513028,
 804500450,
 -1,
 -53183,
 809474753,
 983225,
 -53182,
 809535820,
 983220,
 -53181,
 809592829,
 983230,
 -1,
 809649346,
 983222,
 809840711,
 809491643,
 -1,
 -53178,
 809801335,
 129729,
 -1,
 809851515,
 129523,
 -53176,
 809794930,
 129433,
 -1,
 809980403,
 983065,
 810170397,
 680143111,
 -1,
 810235203,
 810097226,
 -1,
 810300401,
 810193436,
 -1,
 810365926,
 810255010,
 -1,
 810431368,
 810330576,
 -1,
 810496896,
 810377288,
 -1,
 810561838,
 810435780,
 -1,
 810627212,
 810521248,
 -1,
 810692715,
 810571859,
 -1,
 810758235,
 810645600,
 -1,
 810823766,
 810736827,
 -1,
 -53163,
 810789328,
 92598,
 -1,
 810846540,
 92619,
 811020377,
 810766144,
 -1,
 -53160,
 811004464,
 92543,
 -1,
 811015433,
 92553,
 811270143,
 810949194,
 92531,
 -1,
 811147519,
 92601,
 811348068,
 810702931,
 -1,
 811413600,
 811326651,
 -1,
 -53154,
 811381918,
 92550,
 -53153,
 811444688,
 92624,
 -1,
 811474253,
 92563,
 811728895,
 811353282,
 -1,
 811741283,
 811654487,
 92607,
 -1,
 811716598,
 92535,
 -1,
 811681772,
 92557,
 811937894,
 811326807,
 92640,
 -1,
 811913206,
 92657,
 812068969,
 811899585,
 -1,
 -53144,
 812036622,
 92544,
 -1,
 812100048,
 92541,
 -53142,
 812011426,
 92579,
 -1,
 812194378,
 92658,
 812396661,
 810629973,
 -1,
 812462193,
 812325450,
 -1,
 812527728,
 812390988,
 -1,
 -53137,
 812501729,
 92562,
 -1,
 812552842,
 92637,
 -1,
 812493264,
 92518,
 812789876,
 812410877,
 -1,
 -53133,
 812757518,
 92558,
 -1,
 812786762,
 92592,
 -1,
 812769353,
 92528,
 813052027,
 812349249,
 -1,
 813117562,
 812991682,
 -1,
 813183097,
 813057218,
 92628,
 -1,
 813105855,
 92648,
 -1,
 813163916,
 92547,
 -1,
 813047059,
 92554,
 813445248,
 813024582,
 -1,
 813510783,
 813423803,
 -1,
 -53122,
 813474263,
 92527,
 -1,
 813515970,
 92545,
 -1,
 813460039,
 92540,
 813772931,
 813430341,
 -1,
 -53118,
 813753241,
 92609,
 -1,
 813769802,
 92583,
 813969542,
 813757651,
 -1,
 -53115,
 813905317,
 92589,
 -1,
 813968211,
 92608,
 814166153,
 813944822,
 -1,
 -53112,
 814145507,
 92604,
 -1,
 814162914,
 92622,
 814362763,
 814094922,
 92662,
 -1,
 814302402,
 92613,
 -1,
 814316406,
 92584,
 814559396,
 810592720,
 -1,
 814624915,
 814537915,
 92576,
 814690449,
 814553674,
 -1,
 -53104,
 814658062,
 92618,
 -1,
 814695618,
 92529,
 -53102,
 814647628,
 92561,
 -1,
 814826690,
 92649,
 815018137,
 814553674,
 -1,
 815083670,
 814946890,
 92524,
 -1,
 815040844,
 92536,
 815267839,
 815007504,
 -1,
 -53096,
 815171889,
 92634,
 -1,
 815221913,
 92625,
 815411357,
 814966781,
 92663,
 815529983,
 815350978,
 -1,
 -53092,
 815452150,
 92621,
 -1,
 815484147,
 92593,
 815673506,
 815350978,
 -1,
 815739041,
 815652027,
 -1,
 -53088,
 815723056,
 92647,
 -1,
 815779830,
 92605,
 -1,
 815680156,
 92548,
 816054271,
 815635137,
 92568,
 -1,
 815963774,
 92610,
 816132279,
 814516556,
 -1,
 816197802,
 816061002,
 92667,
 816263336,
 816137410,
 92600,
 -1,
 816220492,
 92542,
 -53079,
 816230926,
 92668,
 -1,
 816359888,
 92555,
 816525484,
 816146429,
 92654,
 -1,
 816465897,
 92611,
 816656559,
 816470425,
 -1,
 -53074,
 816597729,
 92581,
 -1,
 816650826,
 92551,
 816853170,
 816589480,
 -1,
 -53071,
 816832483,
 92520,
 -1,
 816858306,
 92582,
 -53069,
 816834737,
 92617,
 -53068,
 817028439,
 92614,
 -53067,
 817077886,
 92671,
 -53066,
 817124092,
 92591,
 -1,
 817187553,
 92666,
 817377482,
 816107510,
 -1,
 817443006,
 817306186,
 -1,
 817508539,
 817371722,
 92635,
 -1,
 817476110,
 92577,
 -53060,
 817476110,
 92636,
 -53059,
 817596748,
 92530,
 -1,
 817646337,
 92559,
 817836226,
 817421499,
 -1,
 817901761,
 817793356,
 92586,
 -1,
 817831158,
 92569,
 -1,
 817831158,
 92566,
 818098374,
 817797825,
 -1,
 818163909,
 818059969,
 92537,
 -1,
 818123424,
 92519,
 -1,
 818131470,
 92630,
 818413567,
 818037954,
 -1,
 818426057,
 818339003,
 92669,
 -1,
 818355511,
 92572,
 -1,
 818385568,
 92672,
 818622684,
 817361718,
 -1,
 818688208,
 818601147,
 -1,
 -53043,
 818655758,
 92644,
 -53042,
 818713248,
 92645,
 -53041,
 818760947,
 92594,
 -1,
 818814240,
 92641,
 819015893,
 818630464,
 -1,
 819081427,
 818945270,
 92567,
 -1,
 819056630,
 92623,
 -53036,
 819065392,
 92639,
 -1,
 819169612,
 92606,
 819343576,
 818979626,
 -1,
 -53033,
 819318640,
 92642,
 -1,
 819345578,
 92643,
 819540187,
 819292157,
 -1,
 -53030,
 819515382,
 92590,
 -1,
 819546089,
 92564,
 -1,
 819471330,
 92588,
 819802344,
 818594260,
 -1,
 819867874,
 819748284,
 -1,
 819933408,
 819829441,
 92659,
 -1,
 819900942,
 92660,
 -53023,
 819884842,
 92638,
 -1,
 820006758,
 92580,
 820195557,
 819807426,
 -1,
 -53020,
 820170742,
 92560,
 -1,
 820200642,
 92534,
 -53018,
 820174176,
 92571,
 -53017,
 820354539,
 92525,
 -1,
 820386575,
 92549,
 820588789,
 819756091,
 -1,
 820654319,
 820550337,
 -1,
 820719853,
 820615873,
 -1,
 -53012,
 820695030,
 92556,
 -1,
 820744864,
 92523,
 -53010,
 820687374,
 92664,
 -1,
 820873548,
 92539,
 821047539,
 820582986,
 -1,
 -53007,
 821015054,
 92633,
 -53006,
 821078480,
 92521,
 -1,
 821108952,
 92575,
 -53004,
 821025979,
 92653,
 -1,
 821251923,
 92595,
 821440770,
 820541536,
 -1,
 821506298,
 821419195,
 -1,
 -53000,
 821481462,
 92620,
 -52999,
 821535191,
 92538,
 -1,
 821579417,
 92587,
 821768447,
 821445826,
 -1,
 821833982,
 821746875,
 -1,
 -52995,
 821817904,
 92646,
 -1,
 821828854,
 92570,
 -1,
 821809142,
 92599,
 -52992,
 821734665,
 92532,
 -52991,
 822057665,
 92665,
 -1,
 822110205,
 92670,
 822292750,
 821383667,
 -1,
 822358282,
 822271163,
 -1,
 822423816,
 822280192,
 -1,
 -52986,
 822392906,
 92661,
 -52985,
 822437885,
 92616,
 -1,
 822489136,
 92626,
 822738943,
 822363330,
 92596,
 -1,
 822661110,
 92612,
 822817036,
 822286922,
 92603,
 -1,
 822784526,
 92673,
 -52979,
 822779371,
 92627,
 -1,
 822888425,
 92651,
 823079195,
 822237267,
 -1,
 823144728,
 823025084,
 -1,
 823210262,
 823084226,
 -1,
 823275797,
 823188667,
 -1,
 -52973,
 823259696,
 92552,
 -52972,
 823300768,
 92565,
 -1,
 823336182,
 92615,
 -1,
 823250934,
 92602,
 -52969,
 823172587,
 92674,
 -1,
 823532324,
 92578,
 823787519,
 823077544,
 -1,
 -52966,
 823715212,
 92597,
 -1,
 823775222,
 92585,
 823931169,
 823047138,
 -1,
 823996703,
 823859786,
 -1,
 -52962,
 823964174,
 92526,
 -1,
 824001730,
 92656,
 -52960,
 823946503,
 92546,
 -1,
 824135637,
 92655,
 824324390,
 823913121,
 -1,
 824389925,
 824302779,
 -1,
 -52956,
 824351425,
 92533,
 -1,
 824394946,
 92650,
 -1,
 824332245,
 92574,
 824652075,
 824305050,
 -1,
 824717610,
 824591554,
 -1,
 -52951,
 824696151,
 92573,
 -1,
 824722626,
 92652,
 -1,
 824679915,
 92522,
 -52948,
 824613569,
 92631,
 -52947,
 824928253,
 92632,
 -1,
 824973898,
 92629,
 825176533,
 810498903,
 -1,
 825241955,
 825135776,
 -1,
 825307457,
 825186387,
 -1,
 825372985,
 825260128,
 -1,
 825438517,
 825315136,
 -1,
 -52940,
 825407946,
 92432,
 -1,
 825433399,
 92457,
 -52938,
 825422935,
 92435,
 -52937,
 825614409,
 92412,
 -52936,
 825649735,
 92476,
 -1,
 825697250,
 92414,
 825950207,
 825317459,
 -1,
 825962814,
 825825866,
 -1,
 826028349,
 825893080,
 92465,
 -1,
 825957622,
 92409,
 -1,
 825993680,
 92483,
 -52929,
 825944813,
 92467,
 -52928,
 826204482,
 92485,
 -1,
 826232789,
 92475,
 826421577,
 825259841,
 -1,
 826487108,
 826370045,
 92403,
 -1,
 826427369,
 92405,
 826618183,
 826429248,
 -1,
 -52922,
 826593270,
 92407,
 -1,
 826613001,
 92430,
 -52920,
 826597156,
 92487,
 -1,
 826745826,
 92418,
 826945873,
 826393044,
 -1,
 827011405,
 826894919,
 -1,
 -52916,
 826986486,
 92459,
 -1,
 827042256,
 92447,
 827208016,
 826957244,
 -1,
 -52913,
 827188503,
 92486,
 -1,
 827213801,
 92408,
 -1,
 827187171,
 92480,
 827470166,
 826929974,
 -1,
 -52909,
 827449097,
 92463,
 -52908,
 827484157,
 92493,
 -52907,
 827543193,
 92450,
 -1,
 827597016,
 92410,
 827797852,
 827407189,
 -1,
 827863386,
 827737282,
 -1,
 -52903,
 827843980,
 92425,
 -1,
 827868354,
 92437,
 -52901,
 827825790,
 92440,
 -1,
 827990232,
 92471,
 828191073,
 827772918,
 -1,
 828256608,
 828130498,
 -1,
 -52897,
 828235747,
 92472,
 -1,
 828261570,
 92505,
 -1,
 828237176,
 92514,
 -52894,
 828169403,
 92503,
 -1,
 828467197,
 92507,
 828649854,
 825198924,
 92497,
 828715371,
 828592627,
 -1,
 828780903,
 828676801,
 92445,
 -1,
 828740256,
 92404,
 828911978,
 828723008,
 -1,
 -52887,
 828887030,
 92424,
 -1,
 828906742,
 92458,
 -1,
 828860999,
 92466,
 829174127,
 828660121,
 -1,
 -52883,
 829135965,
 92438,
 -52882,
 829188679,
 92444,
 -1,
 829247361,
 92442,
 829436276,
 829113538,
 -1,
 829501811,
 829414587,
 -1,
 -52878,
 829476854,
 92427,
 -1,
 829526688,
 92478,
 -1,
 829442028,
 92496,
 829763960,
 829368583,
 -1,
 829829495,
 829692687,
 92448,
 -1,
 829753675,
 92515,
 -1,
 829808959,
 92401,
 830026107,
 829692490,
 -1,
 -52870,
 829980655,
 92426,
 -1,
 830032840,
 92482,
 -52868,
 830007765,
 92510,
 -52867,
 830201019,
 92499,
 -1,
 830251168,
 92441,
 830419345,
 828621268,
 -1,
 830484872,
 830365116,
 -1,
 830550405,
 830424258,
 -1,
 830615940,
 830528699,
 -1,
 -52861,
 830599728,
 92501,
 -1,
 830610678,
 92417,
 -1,
 830555330,
 92413,
 -52858,
 830528699,
 92504,
 -52857,
 830841639,
 92508,
 -1,
 830893141,
 92500,
 831074700,
 830463163,
 -1,
 -52854,
 831052987,
 92498,
 -52853,
 831079618,
 92419,
 -1,
 831134966,
 92473,
 831336847,
 831003210,
 -1,
 -52850,
 831304206,
 92516,
 -1,
 831367632,
 92423,
 -52848,
 831300790,
 92452,
 -1,
 831475558,
 92428,
 831664543,
 830371936,
 -1,
 831730073,
 831603906,
 -1,
 831795608,
 831708347,
 -1,
 -52843,
 831760848,
 92460,
 -52842,
 831825081,
 92431,
 -52841,
 831883596,
 92454,
 -1,
 831921497,
 92415,
 -1,
 831770614,
 92420,
 832188829,
 831708347,
 92489,
 -52837,
 832156174,
 92479,
 -52836,
 832216555,
 92422,
 -1,
 832279200,
 92474,
 -52834,
 832173143,
 92502,
 -1,
 832432882,
 92449,
 832582059,
 831639542,
 -1,
 832647590,
 832521410,
 -1,
 832713125,
 832625851,
 -1,
 -52829,
 832688118,
 92416,
 -52828,
 832737952,
 92481,
 -1,
 832773408,
 92451,
 -1,
 832653292,
 92456,
 833040808,
 832625851,
 92433,
 -1,
 833004726,
 92477,
 -52823,
 833004327,
 92492,
 -52822,
 833120253,
 92513,
 -1,
 833166582,
 92491,
 833368501,
 832535611,
 -1,
 833434034,
 833307842,
 -1,
 833499568,
 833412283,
 -1,
 -52817,
 833456460,
 92484,
 -1,
 833494317,
 92439,
 -52815,
 833474550,
 92464,
 -1,
 833636332,
 92495,
 -52813,
 833413091,
 92446,
 -52812,
 833790759,
 92511,
 -1,
 833841735,
 92406,
 834023870,
 833333712,
 -1,
 834089401,
 834002107,
 -1,
 -52808,
 834069783,
 92443,
 -1,
 834122254,
 92509,
 834286012,
 834028738,
 -1,
 -52805,
 834266398,
 92462,
 -1,
 834290882,
 92506,
 -52803,
 834237158,
 92461,
 -1,
 834413538,
 92469,
 834613702,
 834007862,
 -1,
 834679236,
 834591931,
 -1,
 834744771,
 834640577,
 -1,
 -52798,
 834709968,
 92470,
 -1,
 834767180,
 92468,
 -1,
 834728335,
 92453,
 -52795,
 834620129,
 92429,
 -1,
 834936089,
 92421,
 835137996,
 834581474,
 -1,
 835203530,
 835078884,
 -1,
 -52791,
 835165511,
 92490,
 -1,
 835228124,
 92512,
 -52789,
 835152981,
 92494,
 -1,
 835329289,
 92455,
 835531215,
 835119777,
 -1,
 -52786,
 835509600,
 92411,
 -1,
 835527650,
 92402,
 835727826,
 835476173,
 -1,
 -52783,
 835669838,
 92488,
 -1,
 835721999,
 92434,
 835977215,
 835670515,
 -1,
 -52780,
 835866476,
 92436,
 -1,
 835918607,
 92517,
 836121192,
 825110442,
 -1,
 836186634,
 836080288,
 -1,
 836252132,
 836130899,
 -1,
 836317663,
 836196435,
 -1,
 836383198,
 836295867,
 92362,
 -52773,
 836345470,
 92341,
 -52772,
 836405580,
 92347,
 -52771,
 836454520,
 92370,
 -1,
 836508964,
 92336,
 -1,
 836324065,
 92307,
 836776418,
 836270176,
 -1,
 -52767,
 836755212,
 92303,
 -1,
 836772938,
 92309,
 -52765,
 836738539,
 92368,
 -1,
 836904010,
 92395,
 837104108,
 836223444,
 -1,
 837169640,
 837082299,
 -1,
 -52761,
 837133506,
 92359,
 -1,
 837194400,
 92374,
 -52759,
 837131755,
 92371,
 -52758,
 837312499,
 92351,
 -52757,
 837373785,
 92325,
 -1,
 837425738,
 92350,
 837628405,
 837040981,
 -1,
 837693936,
 837570368,
 -1,
 -52753,
 837668854,
 92349,
 -1,
 837688635,
 92308,
 837890547,
 837622346,
 -1,
 -52750,
 837855696,
 92378,
 -1,
 837912908,
 92375,
 -52748,
 837852743,
 92317,
 -1,
 838035909,
 92331,
 838218237,
 837580609,
 -1,
 838283769,
 838157506,
 -1,
 -52744,
 838264204,
 92389,
 -1,
 838289388,
 92360,
 838480380,
 838212170,
 -1,
 -52741,
 838437196,
 92367,
 -1,
 838486684,
 92356,
 -1,
 838459172,
 92333,
 838742531,
 838193142,
 -1,
 838808065,
 838681794,
 -1,
 -52736,
 838787331,
 92345,
 -1,
 838832800,
 92372,
 -52734,
 838786251,
 92314,
 -1,
 838933263,
 92340,
 839135750,
 838727237,
 -1,
 -52731,
 839077757,
 92323,
 -1,
 839129674,
 92304,
 839332361,
 839064138,
 -1,
 -52728,
 839299598,
 92396,
 -1,
 839358698,
 92338,
 -1,
 839316755,
 92313,
 839594535,
 836143436,
 -1,
 839660061,
 839526663,
 -1,
 839725586,
 839599298,
 -1,
 839791120,
 839703739,
 -1,
 -52721,
 839774768,
 92385,
 -1,
 839813452,
 92315,
 -52719,
 839759006,
 92354,
 -1,
 839928361,
 92311,
 840118805,
 839673853,
 92381,
 -52716,
 840093686,
 92326,
 -1,
 840153715,
 92343,
 840315418,
 840047178,
 -1,
 840380953,
 840243788,
 -1,
 -52712,
 840346961,
 92387,
 -1,
 840380396,
 92318,
 -1,
 840342184,
 92383,
 840695807,
 840293563,
 -1,
 -52708,
 840582338,
 92324,
 -1,
 840637705,
 92364,
 840839716,
 839588426,
 -1,
 840905249,
 840778946,
 -1,
 -52704,
 840877926,
 92363,
 -1,
 840928271,
 92382,
 841154559,
 840826880,
 -1,
 -52701,
 841062668,
 92376,
 -1,
 841120321,
 92339,
 -52699,
 840818007,
 92391,
 -52698,
 841247303,
 92390,
 -1,
 841308593,
 92344,
 841495096,
 839546976,
 -1,
 841560627,
 841434306,
 -1,
 841626159,
 841538747,
 -1,
 841691693,
 841597396,
 -1,
 -52692,
 841638426,
 92319,
 -1,
 841699285,
 92384,
 -52690,
 841648460,
 92386,
 -1,
 841840975,
 92321,
 842019378,
 841585314,
 -1,
 -52687,
 841973430,
 92393,
 -1,
 842027686,
 92394,
 -1,
 841994230,
 92361,
 842281526,
 841538747,
 -1,
 -52683,
 842256374,
 92366,
 -1,
 842310116,
 92373,
 -52681,
 842246949,
 92328,
 -1,
 842406671,
 92329,
 842609215,
 841478966,
 -1,
 842674749,
 842587323,
 -1,
 -52677,
 842658191,
 92388,
 -52676,
 842697036,
 92305,
 -1,
 842728692,
 92322,
 -52674,
 842616728,
 92327,
 -1,
 842865423,
 92377,
 843067975,
 842584054,
 -1,
 843133507,
 843019537,
 -1,
 -52670,
 843111781,
 92358,
 -1,
 843127523,
 92334,
 843330118,
 843072706,
 -1,
 -52667,
 843310376,
 92346,
 -1,
 843370486,
 92400,
 -1,
 843258676,
 92332,
 843592271,
 843039188,
 -1,
 843657803,
 843537852,
 -1,
 -52662,
 843636516,
 92379,
 -1,
 843674410,
 92392,
 843854414,
 843596994,
 -1,
 -52659,
 843834764,
 92330,
 -1,
 843895624,
 92380,
 -1,
 843832689,
 92335,
 844116565,
 843545659,
 -1,
 844182099,
 844044874,
 -1,
 -52654,
 844147152,
 92342,
 -1,
 844204364,
 92357,
 -52652,
 844160187,
 92365,
 -1,
 844329770,
 92397,
 844509786,
 844081616,
 -1,
 844575321,
 844457981,
 -1,
 -52648,
 844544627,
 92316,
 -1,
 844599968,
 92398,
 -1,
 844516065,
 92399,
 844837471,
 844453971,
 -1,
 844903006,
 844783054,
 -1,
 -52643,
 844870814,
 92310,
 -1,
 844933584,
 92320,
 -1,
 844835448,
 92312,
 845165154,
 844819105,
 -1,
 -52639,
 845144403,
 92369,
 -1,
 845161197,
 92306,
 845361765,
 845146260,
 -1,
 -52636,
 845345328,
 92337,
 -1,
 845356337,
 92353,
 -52634,
 845332759,
 92355,
 -52633,
 845502526,
 92348,
 -1,
 845557565,
 92352,
 845755110,
 836049484,
 -1,
 845820556,
 845714080,
 -1,
 845886064,
 845795318,
 -1,
 845951599,
 845816802,
 92223,
 846069759,
 845873152,
 -1,
 -52626,
 845977948,
 92194,
 -1,
 846040573,
 92185,
 -1,
 845914939,
 92178,
 846279286,
 845830227,
 -1,
 846344820,
 846232548,
 -1,
 -52621,
 846305979,
 92182,
 -1,
 846333135,
 92160,
 -52619,
 846289465,
 92229,
 -1,
 846471962,
 92173,
 846672506,
 846263094,
 -1,
 846738041,
 846620669,
 92239,
 -1,
 846712883,
 92225,
 -1,
 846679705,
 92233,
 846934653,
 846657093,
 -1,
 -52612,
 846913612,
 92191,
 -1,
 846928490,
 92167,
 847131264,
 846906694,
 -1,
 -52609,
 847080007,
 92237,
 -1,
 847125066,
 92241,
 847327875,
 847083616,
 -1,
 -52606,
 847277673,
 92180,
 -1,
 847321902,
 92227,
 847524486,
 847264768,
 -1,
 -52603,
 847454934,
 92212,
 -1,
 847512635,
 92201,
 847721097,
 847452746,
 -1,
 -52600,
 847688206,
 92245,
 -1,
 847714922,
 92164,
 -52598,
 847673207,
 92231,
 -52597,
 847866972,
 92204,
 -1,
 847923937,
 92244,
 848114339,
 845777228,
 -1,
 848179864,
 848042570,
 -1,
 848245398,
 848118978,
 -1,
 848310931,
 848202060,
 92238,
 -52591,
 848292007,
 92174,
 -52590,
 848329655,
 92203,
 -1,
 848374691,
 92171,
 -52588,
 848283494,
 92230,
 -52587,
 848534184,
 92210,
 -1,
 848591433,
 92186,
 -52585,
 848210409,
 92221,
 -1,
 848730408,
 92175,
 848900765,
 848140993,
 -1,
 848966300,
 848862699,
 -1,
 -52581,
 848933322,
 92198,
 -1,
 848973766,
 92214,
 -1,
 848925349,
 92190,
 849228448,
 848832824,
 -1,
 -52577,
 849195534,
 92246,
 -1,
 849255080,
 92232,
 -52575,
 849209496,
 92176,
 -52574,
 849369515,
 92196,
 -1,
 849432453,
 92197,
 849621683,
 848085460,
 -1,
 849687212,
 849567164,
 -1,
 849752744,
 849665211,
 -1,
 -52569,
 849709388,
 92215,
 -1,
 849759212,
 92165,
 849949355,
 849700861,
 -1,
 -52566,
 849917086,
 92222,
 -1,
 849974329,
 92168,
 -1,
 849912622,
 92224,
 850211504,
 849648321,
 -1,
 -52562,
 850186230,
 92235,
 -52561,
 850244110,
 92220,
 -1,
 850302870,
 92208,
 -52559,
 850191736,
 92181,
 -52558,
 850424914,
 92195,
 -1,
 850481041,
 92177,
 850670276,
 849586640,
 -1,
 850735803,
 850598474,
 -1,
 850801336,
 850664010,
 -1,
 -52553,
 850769054,
 92226,
 -1,
 850823500,
 92236,
 -52551,
 850773451,
 92187,
 -52550,
 850956694,
 92189,
 -1,
 850986043,
 92200,
 851194562,
 850697857,
 -1,
 851260095,
 851159588,
 -1,
 -52546,
 851204545,
 92169,
 -1,
 851257656,
 92170,
 851509247,
 851217922,
 -1,
 -52543,
 851401153,
 92162,
 -1,
 851454264,
 92163,
 -52541,
 851173715,
 92205,
 -1,
 851594905,
 92202,
 851784397,
 850622560,
 -1,
 851849928,
 851723458,
 -1,
 -52537,
 851828614,
 92179,
 -1,
 851890166,
 92211,
 852046539,
 851778122,
 -1,
 -52534,
 852013582,
 92240,
 -1,
 852054600,
 92199,
 -52532,
 852025679,
 92213,
 -1,
 852209564,
 92219,
 852374229,
 851759094,
 -1,
 852439761,
 852352187,
 -1,
 -52528,
 852368685,
 92206,
 -1,
 852427934,
 92172,
 852636372,
 852381504,
 -1,
 -52525,
 852611900,
 92209,
 -1,
 852630816,
 92234,
 -1,
 852587815,
 92166,
 852898523,
 852327483,
 -1,
 852964056,
 852876475,
 92243,
 -1,
 852892973,
 92207,
 -52519,
 852926062,
 92216,
 -52518,
 853036704,
 92184,
 -1,
 853091305,
 92183,
 853291744,
 852842579,
 -1,
 853357279,
 853238292,
 -1,
 -52514,
 853324958,
 92188,
 -1,
 853367542,
 92193,
 -1,
 853289962,
 92161,
 853619427,
 853269691,
 -1,
 -52510,
 853579689,
 92228,
 -1,
 853610313,
 92192,
 -52508,
 853599965,
 92242,
 -52507,
 853786506,
 92218,
 -1,
 853824628,
 92217,
 854012727,
 845687049,
 -1,
 854078202,
 853969228,
 -1,
 854143727,
 854010119,
 -1,
 854209260,
 854071882,
 -1,
 -52501,
 854140024,
 92255,
 -1,
 854197398,
 92252,
 -52499,
 854188367,
 92292,
 -52498,
 854357272,
 92268,
 -1,
 854413225,
 92286,
 854602483,
 854071882,
 92300,
 854720511,
 854525190,
 -1,
 -52494,
 854647708,
 92296,
 -1,
 854675295,
 92295,
 854864630,
 854544883,
 -1,
 -52491,
 854826683,
 92267,
 -1,
 854882066,
 92284,
 855061241,
 854806336,
 -1,
 -52488,
 855035968,
 92290,
 -1,
 855093774,
 92281,
 -1,
 855023931,
 92287,
 855323403,
 854037152,
 -1,
 855388931,
 855267411,
 -1,
 855454465,
 855332947,
 -1,
 855519999,
 855433551,
 92282,
 -1,
 855442484,
 92283,
 -52480,
 855461699,
 92277,
 -1,
 855579424,
 92298,
 -52478,
 855416299,
 92302,
 -1,
 855734993,
 92276,
 855913222,
 855372598,
 -1,
 -52475,
 855861270,
 92269,
 -1,
 855907597,
 92288,
 856109833,
 855884244,
 -1,
 -52472,
 856057694,
 92247,
 -1,
 856115937,
 92299,
 -52470,
 856085872,
 92260,
 -1,
 856245305,
 92261,
 856437523,
 855294420,
 -1,
 856503055,
 856383615,
 -1,
 -52466,
 856481130,
 92266,
 -1,
 856543305,
 92265,
 -52464,
 856481545,
 92285,
 -52463,
 856648263,
 92249,
 -52462,
 856706736,
 92250,
 -1,
 856760152,
 92279,
 856961820,
 856389728,
 -1,
 857027352,
 856903488,
 -1,
 -52458,
 857011403,
 92272,
 -52457,
 857059786,
 92270,
 -1,
 857087241,
 92294,
 857289499,
 856975357,
 -1,
 -52454,
 857256462,
 92301,
 -1,
 857294893,
 92253,
 -1,
 857219288,
 92256,
 857551649,
 856926672,
 -1,
 -52450,
 857530620,
 92289,
 -52449,
 857568529,
 92263,
 -52448,
 857622642,
 92257,
 -1,
 857679429,
 92274,
 857879335,
 857504827,
 -1,
 857944869,
 857807434,
 -1,
 -52444,
 857901424,
 92259,
 -1,
 857940312,
 92273,
 -52442,
 857906674,
 92251,
 -1,
 858082969,
 92297,
 858272556,
 857853942,
 -1,
 858338091,
 858250429,
 -1,
 -52438,
 858298636,
 92264,
 -1,
 858360327,
 92248,
 -1,
 858266400,
 92280,
 858600239,
 858256182,
 -1,
 -52434,
 858541980,
 92254,
 -1,
 858594766,
 92258,
 858796850,
 858544893,
 -1,
 -52431,
 858774875,
 92262,
 -1,
 858821280,
 92271,
 858993461,
 858739374,
 -1,
 -52428,
 858973580,
 92291,
 -1,
 858997954,
 92293,
 -52426,
 858976802,
 92278,
 -1,
 859170978,
 92275,
 859373567,
 853955061,
 -1,
 859386694,
 859280032,
 -1,
 859452219,
 859364539,
 92697,
 -1,
 859380982,
 92696,
 859583294,
 859404097,
 -1,
 -52419,
 859561303,
 92698,
 -1,
 859577609,
 92688,
 859779905,
 859527251,
 -1,
 -52416,
 859733010,
 92711,
 -1,
 859789474,
 92712,
 -52414,
 859763920,
 92681,
 -52413,
 859951691,
 92704,
 -52412,
 860013969,
 92702,
 -52411,
 860055549,
 92708,
 -1,
 860109865,
 92687,
 860304207,
 859357652,
 -1,
 860369739,
 860249532,
 -1,
 -52407,
 860347579,
 92700,
 -52406,
 860396225,
 92713,
 -1,
 860449877,
 92691,
 -52404,
 860349816,
 92690,
 -52403,
 860579837,
 92692,
 -52402,
 860639189,
 92693,
 -1,
 860692708,
 92727,
 860894040,
 860256352,
 -1,
 860959571,
 860832962,
 -1,
 -52398,
 860934134,
 92695,
 -1,
 860983968,
 92710,
 -52396,
 860943447,
 92694,
 -52395,
 861134011,
 92677,
 -52394,
 861186593,
 92726,
 -52393,
 861248193,
 92719,
 -1,
 861280842,
 92675,
 861483873,
 860861410,
 -1,
 861549405,
 861422786,
 -1,
 -52389,
 861529484,
 92709,
 -52388,
 861573792,
 92721,
 -1,
 861619394,
 92679,
 861811552,
 861497341,
 -1,
 -52385,
 861759485,
 92683,
 -1,
 861816809,
 92684,
 -1,
 861789371,
 92707,
 862073704,
 861440332,
 92689,
 862139237,
 862005511,
 -1,
 -52380,
 862079713,
 92720,
 -1,
 862133007,
 92724,
 -52378,
 862100161,
 92723,
 -52377,
 862275568,
 92685,
 -1,
 862329418,
 92722,
 862532461,
 862048246,
 -1,
 862597996,
 862460490,
 -1,
 -52373,
 862536898,
 92680,
 -1,
 862591562,
 92686,
 -1,
 862539417,
 92725,
 862860146,
 862497232,
 -1,
 862925681,
 862799042,
 -1,
 -52368,
 862905740,
 92703,
 -1,
 862930114,
 92706,
 -1,
 862903639,
 92714,
 863187830,
 862813243,
 -1,
 -52364,
 863150887,
 92718,
 -52363,
 863201277,
 92717,
 -1,
 863246922,
 92682,
 863449977,
 863171382,
 -1,
 -52360,
 863413031,
 92699,
 -1,
 863443530,
 92701,
 863646588,
 863431329,
 -1,
 -52357,
 863624969,
 92705,
 -1,
 863640138,
 92716,
 -52355,
 863627915,
 92728,
 -52354,
 863820987,
 92676,
 -52353,
 863851984,
 92715,
 -1,
 863913961,
 92678,
 864105347,
 810474683,
 -1,
 -52350,
 864044226,
 42696,
 -1,
 864099574,
 42711,
 864301958,
 864044226,
 -1,
 -52347,
 864281996,
 42693,
 -1,
 864306370,
 42698,
 -52345,
 864249853,
 42717,
 -1,
 864426570,
 42667,
 864629659,
 810390176,
 -1,
 864695181,
 864581441,
 -1,
 -52341,
 864673111,
 42686,
 -52340,
 864700393,
 42694,
 -1,
 864754953,
 42674,
 864957329,
 864639059,
 -1,
 -52337,
 864910354,
 42707,
 -52336,
 864966818,
 42708,
 -1,
 865016394,
 42709,
 865219475,
 864935099,
 42685,
 -1,
 865148150,
 42684,
 865350550,
 865193974,
 -1,
 -52331,
 865330552,
 42731,
 -1,
 865355753,
 42695,
 -52329,
 865334480,
 42664,
 -52328,
 865518993,
 42691,
 -52327,
 865560573,
 42703,
 -52326,
 865614889,
 42673,
 -1,
 865671754,
 42715,
 865874856,
 864581728,
 -1,
 865940383,
 865835713,
 42719,
 -52322,
 865921680,
 42734,
 -1,
 865950475,
 42735,
 866136995,
 865879234,
 -1,
 -52319,
 866117004,
 42692,
 -52318,
 866177014,
 42683,
 -1,
 866226848,
 42706,
 -52316,
 866120791,
 42682,
 -52315,
 866376891,
 42659,
 -52314,
 866429473,
 42729,
 -52313,
 866478077,
 42725,
 -1,
 866523722,
 42657,
 866726835,
 865831244,
 42675,
 866792364,
 866665666,
 -1,
 -52309,
 866751136,
 42722,
 -1,
 866797548,
 42671,
 866988975,
 866724103,
 -1,
 -52306,
 866929377,
 42720,
 -1,
 866982671,
 42727,
 -52304,
 866966715,
 42677,
 -52303,
 867146433,
 42726,
 -52302,
 867198973,
 42702,
 -1,
 867244618,
 42723,
 867447741,
 866697684,
 -1,
 867513273,
 867392956,
 -1,
 -52298,
 867491003,
 42688,
 -52297,
 867539649,
 42710,
 -52296,
 867593301,
 42678,
 -1,
 867651541,
 42680,
 -52294,
 867493240,
 42676,
 -52293,
 867788797,
 42679,
 -52292,
 867848149,
 42681,
 -1,
 867901668,
 42732,
 868103111,
 867415010,
 -1,
 868168642,
 868041922,
 -1,
 -52288,
 868148620,
 42704,
 -52287,
 868192928,
 42721,
 -1,
 868238530,
 42661,
 868430789,
 868116477,
 -1,
 -52284,
 868378621,
 42668,
 -1,
 868435945,
 42669,
 -52282,
 868408507,
 42700,
 -1,
 868556022,
 42705,
 868758479,
 868077558,
 -1,
 868824011,
 868697282,
 -1,
 -52278,
 868798454,
 42728,
 -1,
 868848288,
 42730,
 869020622,
 868751946,
 -1,
 -52275,
 868959426,
 42662,
 -1,
 869014090,
 42672,
 -1,
 868968445,
 42724,
 869282773,
 868711483,
 -1,
 -52271,
 869260475,
 42701,
 -52270,
 869311271,
 42718,
 -52269,
 869361661,
 42716,
 -52268,
 869418992,
 42670,
 -1,
 869472842,
 42666,
 869675994,
 869224947,
 -1,
 -52265,
 869653691,
 42712,
 -52264,
 869703147,
 42713,
 -52263,
 869746665,
 42699,
 -1,
 869800740,
 42733,
 870003678,
 869659446,
 -1,
 -52260,
 869983129,
 42689,
 -52259,
 870032167,
 42687,
 -1,
 870062666,
 42690,
 870265825,
 869984929,
 -1,
 -52256,
 870244105,
 42697,
 -1,
 870259274,
 42714,
 -52254,
 870243515,
 42658,
 -52253,
 870423233,
 42663,
 -52252,
 870475773,
 42665,
 -52251,
 870533097,
 42660,
 -1,
 870586954,
 42656,
 870790125,
 810301018,
 -1,
 870855660,
 870746444,
 -1,
 870921195,
 870788139,
 -1,
 -52246,
 870898361,
 42737,
 -1,
 870939518,
 42736,
 -1,
 870877602,
 42741,
 -1,
 870811176,
 42740,
 -52242,
 870761567,
 42742,
 -52241,
 871216007,
 42743,
 -52240,
 871274369,
 42738,
 -1,
 871323714,
 42739,
 871511201,
 810253371,
 -1,
 871576720,
 871460537,
 -1,
 871642163,
 871531170,
 -1,
 871707643,
 871616502,
 -1,
 871773178,
 871635530,
 6946,
 871890943,
 871694336,
 -1,
 -52232,
 871813566,
 6947,
 -52231,
 871862867,
 6942,
 -1,
 871923289,
 6941,
 -1,
 871757777,
 6983,
 872166400,
 871666336,
 -1,
 872231934,
 872094282,
 6950,
 -1,
 872155314,
 6945,
 -52225,
 872215482,
 6940,
 -1,
 872306850,
 6935,
 872494085,
 872118368,
 -1,
 872559620,
 872421962,
 6931,
 -52221,
 872501771,
 6981,
 -1,
 872547494,
 6932,
 -1,
 872506823,
 6982,
 872821771,
 872430592,
 6948,
 872939519,
 872744074,
 -1,
 872952842,
 872866785,
 -1,
 -52215,
 872909329,
 6944,
 -1,
 872947801,
 6943,
 -1,
 872881388,
 6949,
 873214992,
 872749642,
 -1,
 873280526,
 873167187,
 6917,
 -1,
 873204227,
 6918,
 -52209,
 873254890,
 6987,
 -1,
 873360480,
 6928,
 873542676,
 873185961,
 6962,
 873660415,
 873466133,
 -1,
 -52205,
 873572897,
 6961,
 -1,
 873617570,
 6960,
 873804823,
 873509972,
 6957,
 873922559,
 873728195,
 6923,
 -1,
 873794051,
 6924,
 874001434,
 873757829,
 6958,
 874119167,
 873923660,
 6925,
 -1,
 873990659,
 6926,
 874198044,
 873979776,
 6921,
 -1,
 874121731,
 6922,
 874329118,
 874162721,
 6951,
 -1,
 874251219,
 6952,
 874460192,
 874290433,
 6929,
 -1,
 874383875,
 6930,
 874591266,
 874411871,
 6938,
 -1,
 874513346,
 6939,
 874722340,
 874540128,
 6919,
 -1,
 874646019,
 6920,
 874853414,
 874666146,
 6933,
 -1,
 874775366,
 6934,
 874984489,
 874792130,
 -1,
 -52184,
 874936659,
 6927,
 -1,
 874992139,
 6984,
 875181099,
 874917855,
 6936,
 -1,
 875103237,
 6937,
 875312173,
 875112760,
 6953,
 -1,
 875234292,
 6954,
 -52178,
 875296433,
 6986,
 -52177,
 875426746,
 6956,
 -52176,
 875490017,
 6959,
 -52175,
 875554482,
 6985,
 -52174,
 875596194,
 6955,
 -1,
 875650510,
 6963,
 875836508,
 871600744,
 -1,
 875902018,
 875772757,
 -1,
 875967548,
 875829834,
 -1,
 876033082,
 875927024,
 7012,
 876150783,
 875954176,
 -1,
 -52167,
 876072764,
 7013,
 -1,
 876108304,
 7018,
 -52165,
 875982528,
 7017,
 -1,
 876235700,
 7015,
 876426303,
 875906242,
 -1,
 -52162,
 876404975,
 7016,
 -1,
 876451312,
 7010,
 -52160,
 876404975,
 7011,
 -52159,
 876585024,
 7009,
 -1,
 876637888,
 7014,
 876819533,
 875837098,
 -1,
 876885064,
 876771864,
 -1,
 876950598,
 876863393,
 7021,
 -1,
 876875223,
 7024,
 877133823,
 876905297,
 7022,
 -1,
 877006295,
 7025,
 -52151,
 876859988,
 7019,
 -52150,
 877164461,
 7023,
 -52149,
 877223018,
 7027,
 -52148,
 877284253,
 7020,
 -1,
 877341427,
 7026,
 877540437,
 876773622,
 -1,
 877605970,
 877503084,
 -1,
 -52144,
 877584623,
 7033,
 -52143,
 877620928,
 7036,
 -1,
 877667005,
 7032,
 877920255,
 877540854,
 -1,
 -52140,
 877846397,
 7035,
 -1,
 877862708,
 7034,
 878116863,
 877509614,
 -1,
 878130265,
 878027304,
 -1,
 -52136,
 878108468,
 7028,
 -1,
 878124507,
 7029,
 878379007,
 878065152,
 -1,
 -52133,
 878305149,
 7030,
 -1,
 878321460,
 7031,
 878523502,
 875817514,
 -1,
 878589028,
 878497782,
 -1,
 878654563,
 878518292,
 6974,
 878772223,
 878575616,
 -1,
 878785634,
 878688361,
 6975,
 -1,
 878709251,
 6977,
 -1,
 878760516,
 6976,
 -1,
 878594019,
 6965,
 879047782,
 878567381,
 6966,
 -1,
 878971161,
 6967,
 879178856,
 879021850,
 6968,
 -1,
 879100816,
 6969,
 879309930,
 879146075,
 6970,
 -1,
 879233539,
 6971,
 879441004,
 879275197,
 6978,
 -1,
 879364611,
 6979,
 879624191,
 879393928,
 6972,
 -1,
 879495683,
 6973,
 879703164,
 878460653,
 -1,
 879768690,
 879677430,
 -1,
 -52111,
 879751219,
 6994,
 -1,
 879781407,
 6995,
 879965301,
 879739348,
 -1,
 -52108,
 879916708,
 6998,
 -1,
 879972324,
 6999,
 880161912,
 879907315,
 -1,
 -52105,
 880125464,
 6996,
 -1,
 880178666,
 6997,
 -52103,
 880146224,
 6992,
 -52102,
 880320281,
 6993,
 -52101,
 880383726,
 7001,
 -1,
 880429470,
 7000,
 880620676,
 879675355,
 -1,
 880686208,
 880599001,
 -1,
 -52097,
 880654935,
 6912,
 -1,
 880685142,
 6913,
 -52095,
 880660284,
 6915,
 -52094,
 880851084,
 6964,
 -52093,
 880882107,
 6914,
 -1,
 880946253,
 6916,
 881144969,
 880585249,
 -1,
 881210504,
 881101132,
 -1,
 -52089,
 881150883,
 7008,
 -1,
 881204409,
 7003,
 -1,
 881170849,
 7002,
 881472654,
 881078532,
 -1,
 881538189,
 881437217,
 -1,
 -52084,
 881506452,
 7007,
 -1,
 881562170,
 7005,
 -1,
 881510470,
 7006,
 -52081,
 881454599,
 7004,
 -1,
 881728721,
 6980,
 881983487,
 871529531,
 -1,
 881996959,
 881892033,
 -1,
 882062494,
 881971192,
 -1,
 882128029,
 881995126,
 -1,
 882193564,
 882111047,
 -1,
 882259098,
 882125063,
 -1,
 882324633,
 882220363,
 -1,
 -52072,
 882295780,
 128503,
 -1,
 882324182,
 128505,
 -1,
 882253866,
 128499,
 -52069,
 882230244,
 128501,
 -1,
 882541610,
 11197,
 -1,
 882147091,
 128502,
 -1,
 882099172,
 128500,
 -1,
 882024062,
 127880,
 -52064,
 881938087,
 129648,
 -1,
 882836855,
 129526,
 883045611,
 871485430,
 129415,
 883111144,
 882974519,
 -1,
 883176655,
 883065506,
 -1,
 883242162,
 883147220,
 -1,
 883307696,
 883191004,
 -1,
 -52057,
 883291066,
 7132,
 -52056,
 883354337,
 7116,
 -52055,
 883409577,
 7129,
 -52054,
 883471444,
 7123,
 -52053,
 883534369,
 7112,
 -52052,
 883591586,
 7125,
 -52051,
 883653765,
 7135,
 -52050,
 883711438,
 7107,
 -52049,
 883775650,
 7119,
 -1,
 883825226,
 7105,
 -52047,
 883271463,
 7126,
 -1,
 883956298,
 7128,
 884159672,
 883200672,
 -1,
 -52044,
 884143034,
 7136,
 -52043,
 884188250,
 7127,
 -52042,
 884234402,
 7133,
 -52041,
 884292608,
 7138,
 -1,
 884349514,
 7113,
 884552895,
 884115788,
 -1,
 884618430,
 884480586,
 7124,
 884735999,
 884577348,
 -1,
 -52036,
 884654761,
 7130,
 -52035,
 884708074,
 7114,
 -1,
 884760014,
 7108,
 -1,
 884549944,
 7139,
 885011649,
 884517409,
 7111,
 -1,
 884964271,
 7117,
 -52030,
 884995002,
 7131,
 -52029,
 885123809,
 7115,
 -52028,
 885185723,
 7141,
 -52027,
 885240916,
 7122,
 -52026,
 885292165,
 7134,
 -52025,
 885356894,
 7110,
 -52024,
 885421919,
 7120,
 -52023,
 885483517,
 7140,
 -52022,
 885546446,
 7106,
 -52021,
 885610658,
 7118,
 -52020,
 885668864,
 7121,
 -52019,
 885731295,
 7137,
 -52018,
 885795128,
 7109,
 -1,
 885856842,
 7104,
 886060250,
 883157546,
 -1,
 886125778,
 886037691,
 7150,
 -1,
 886047492,
 7151,
 886256853,
 886077784,
 -1,
 -52012,
 886217409,
 7149,
 -1,
 886269949,
 7147,
 886453463,
 886195394,
 7143,
 -1,
 886392002,
 7145,
 -52008,
 886418041,
 7144,
 -52007,
 886545089,
 7148,
 -1,
 886597629,
 7146,
 886781154,
 886030804,
 -1,
 886846689,
 886764919,
 -1,
 886912223,
 886811088,
 -1,
 -52002,
 886861194,
 7165,
 -1,
 886907666,
 7167,
 -52000,
 886870791,
 7164,
 -1,
 887060556,
 7166,
 -1,
 886795317,
 7142,
 887305445,
 886745781,
 -1,
 -51996,
 887267470,
 7155,
 -1,
 887315527,
 7154,
 887554047,
 887240589,
 -1,
 -51993,
 887461360,
 7152,
 -1,
 887512508,
 7153,
 887698666,
 883056060,
 128704,
 -1,
 887675525,
 128705,
 -1,
 887673655,
 128267,
 887895324,
 883016148,
 -1,
 887960857,
 887866028,
 -1,
 888026384,
 887915170,
 -1,
 888091889,
 887964866,
 92908,
 -51984,
 888051639,
 92880,
 -1,
 888095938,
 92907,
 888288500,
 888075062,
 -1,
 -51981,
 888236601,
 92885,
 -1,
 888293917,
 92900,
 888485110,
 888269537,
 92891,
 -1,
 888421566,
 92902,
 888616184,
 888462523,
 92906,
 -1,
 888599065,
 92896,
 888747258,
 888576705,
 92904,
 -1,
 888707777,
 92905,
 888878333,
 888698976,
 -1,
 -51972,
 888842855,
 92888,
 -1,
 888871498,
 92881,
 889074944,
 888821843,
 -1,
 -51969,
 889007888,
 92893,
 -1,
 889069093,
 92886,
 889271555,
 889011029,
 -1,
 -51966,
 889232065,
 92894,
 -1,
 889283358,
 92887,
 -51964,
 889255904,
 92892,
 -51963,
 889449096,
 92899,
 -51962,
 889509613,
 92897,
 -51961,
 889570300,
 92882,
 -51960,
 889629217,
 92901,
 -51959,
 889687059,
 92884,
 -51958,
 889747460,
 92889,
 -51957,
 889808893,
 92909,
 -51956,
 889874385,
 92890,
 -51955,
 889934408,
 92883,
 -51954,
 889991586,
 92895,
 -51953,
 890054968,
 92898,
 -1,
 890116682,
 92903,
 890320152,
 887961258,
 -1,
 890385684,
 890275587,
 -1,
 -51949,
 890310652,
 92915,
 -1,
 890375051,
 92913,
 890582295,
 890331842,
 -1,
 -51946,
 890507226,
 92916,
 -1,
 890571659,
 92912,
 -1,
 890539580,
 92914,
 -1,
 890263618,
 92917,
 890909979,
 887913021,
 129530,
 -1,
 890841507,
 127936,
 -1,
 890848992,
 9918,
 891106597,
 887853728,
 -1,
 891172131,
 891058272,
 127974,
 891289599,
 891132052,
 -1,
 -51936,
 891221127,
 128180,
 -51935,
 891269082,
 128183,
 -51934,
 891309998,
 128182,
 -1,
 891371454,
 128181,
 -51932,
 891123716,
 129685,
 -1,
 891494723,
 127820,
 891696433,
 891039656,
 -1,
 891761967,
 891648096,
 -1,
 891827500,
 891732436,
 -1,
 891893035,
 891780518,
 -1,
 -51926,
 891862722,
 11101,
 -1,
 891919633,
 11099,
 -1,
 891857482,
 983056,
 892207103,
 891748352,
 -1,
 -51922,
 892137197,
 128281,
 -1,
 892181528,
 128386,
 -51920,
 891738267,
 128043,
 -1,
 892313214,
 129363,
 892482871,
 891629464,
 128118,
 892600319,
 892403712,
 -1,
 -51916,
 892522419,
 128700,
 -51915,
 892547918,
 128036,
 -51914,
 892612084,
 127868,
 -1,
 892674768,
 128124,
 892876092,
 892449762,
 -1,
 892941627,
 892796928,
 -1,
 -51910,
 892902459,
 129532,
 -1,
 892940999,
 128202,
 -1,
 892873491,
 128136,
 893203776,
 892819539,
 -1,
 -51906,
 893181736,
 129366,
 -51905,
 893212900,
 128708,
 -1,
 893274671,
 129391,
 893517823,
 893139797,
 -1,
 -51902,
 893423573,
 127992,
 -1,
 893475422,
 129441,
 893662767,
 810187835,
 -1,
 893728234,
 893590549,
 -1,
 893793662,
 893661096,
 -1,
 893859183,
 893739518,
 -1,
 893924697,
 893810784,
 -1,
 893990230,
 893884100,
 -1,
 894055762,
 893913312,
 -1,
 894121295,
 894029814,
 -1,
 894186830,
 894103759,
 -1,
 -51891,
 894163893,
 129585,
 -1,
 894223670,
 129597,
 -1,
 894133940,
 129606,
 -51888,
 894082925,
 129564,
 -51887,
 894408485,
 129555,
 -1,
 894457387,
 129543,
 894697471,
 893980498,
 -1,
 -51884,
 894615481,
 129618,
 -51883,
 894677835,
 129617,
 -1,
 894708826,
 129619,
 894959615,
 893939650,
 -1,
 -51880,
 894884954,
 129593,
 -1,
 894932773,
 129551,
 895104353,
 893901555,
 -1,
 895169885,
 895055968,
 -1,
 -51876,
 895129284,
 129576,
 -1,
 895184576,
 129572,
 -51874,
 895139769,
 129574,
 -51873,
 895333195,
 129573,
 -51872,
 895396797,
 129577,
 -1,
 895429722,
 129575,
 895628644,
 895074238,
 -1,
 -51869,
 895605850,
 129595,
 -1,
 895653669,
 129553,
 895825255,
 895595355,
 -1,
 -51866,
 895802458,
 129594,
 -1,
 895850277,
 129552,
 896021866,
 895790018,
 -1,
 -51863,
 895999066,
 129598,
 -1,
 896046885,
 129556,
 896218476,
 895962377,
 129609,
 -1,
 896141546,
 129612,
 896401407,
 896150625,
 -1,
 -51858,
 896326746,
 129596,
 -1,
 896374565,
 129554,
 896546172,
 893838481,
 -1,
 896611699,
 896525124,
 -1,
 -51854,
 896580753,
 11179,
 -1,
 896631186,
 11178,
 896808310,
 896580737,
 -1,
 -51851,
 896787281,
 11181,
 -1,
 896811914,
 11183,
 897004921,
 896762243,
 -1,
 -51848,
 896983889,
 11180,
 -1,
 897008522,
 11182,
 897253375,
 896942930,
 -1,
 -51845,
 897170577,
 11177,
 -1,
 897221010,
 11176,
 -51843,
 896516054,
 9960,
 -1,
 897348472,
 9210,
 897529232,
 893749580,
 -1,
 897594767,
 897468380,
 -1,
 897660292,
 897547323,
 -1,
 897725827,
 897599750,
 9204,
 -1,
 897647034,
 11207,
 -1,
 897690019,
 11047,
 897922440,
 897596245,
 -1,
 897987975,
 897886578,
 9207,
 -1,
 897909178,
 11206,
 -1,
 897935549,
 11045,
 898184586,
 897901037,
 9206,
 -1,
 898105786,
 11205,
 898315661,
 898156881,
 -1,
 -51828,
 898271279,
 128927,
 -1,
 898318002,
 128921,
 898564095,
 898284626,
 9205,
 -1,
 898433466,
 11208,
 -1,
 897556876,
 9912,
 898708895,
 897499604,
 -1,
 898774421,
 898675403,
 -1,
 -51821,
 898717161,
 9209,
 -51820,
 898773488,
 11200,
 -1,
 898838396,
 128306,
 899036569,
 898730637,
 -1,
 -51817,
 899009785,
 11089,
 -51816,
 899057711,
 11050,
 -1,
 899104434,
 11049,
 899298716,
 898991154,
 -1,
 -51813,
 899271620,
 128909,
 -1,
 899298323,
 128900,
 -51811,
 899258548,
 9927,
 -51810,
 899447788,
 128369,
 -1,
 899489181,
 9984,
 899691950,
 898644821,
 -1,
 899757478,
 899656032,
 -1,
 899823012,
 899682384,
 -1,
 -51805,
 899773601,
 128899,
 -1,
 899826241,
 9196,
 -51803,
 899804015,
 11167,
 -1,
 899942517,
 128419,
 900150699,
 899724258,
 -1,
 900216234,
 900081720,
 -1,
 -51799,
 900172536,
 9922,
 -1,
 900233948,
 9923,
 -1,
 900178616,
 127778,
 900530175,
 900098244,
 -1,
 -51795,
 900439701,
 11230,
 -1,
 900477424,
 11201,
 900675001,
 899658722,
 -1,
 900740536,
 900623196,
 -1,
 900806070,
 900665424,
 -1,
 900871603,
 900743745,
 9193,
 -1,
 900796159,
 9197,
 -51788,
 900847811,
 9199,
 -51787,
 900967584,
 11091,
 -1,
 901018785,
 128898,
 -51785,
 900787055,
 11166,
 -1,
 901122165,
 128413,
 -1,
 900703375,
 127990,
 901395910,
 900627515,
 -1,
 901461443,
 901335216,
 -1,
 901526975,
 901386320,
 -1,
 901592510,
 901464641,
 9194,
 -1,
 901517055,
 9198,
 -1,
 901543073,
 128896,
 901789122,
 901447680,
 -1,
 -51775,
 901754618,
 128412,
 -1,
 901807515,
 9944,
 -1,
 901770095,
 11164,
 902103039,
 901391604,
 -1,
 -51771,
 902024132,
 11035,
 -1,
 902050835,
 11044,
 902247886,
 901369846,
 -1,
 902313419,
 902197954,
 -1,
 -51767,
 902286276,
 128908,
 -51766,
 902334511,
 128925,
 -1,
 902381234,
 128919,
 -51764,
 902295897,
 9942,
 -51763,
 902545690,
 9951,
 -1,
 902604252,
 128383,
 902772180,
 902227752,
 -1,
 902837715,
 902755192,
 -1,
 -51759,
 902810564,
 11037,
 -51758,
 902858799,
 128926,
 -1,
 902905522,
 128920,
 -1,
 902813021,
 11054,
 903165402,
 902750547,
 -1,
 903230936,
 903090256,
 -1,
 -51753,
 903181473,
 128897,
 -1,
 903234113,
 9195,
 -51751,
 903211887,
 11165,
 -1,
 903350389,
 128418,
 903558624,
 903110076,
 -1,
 903624158,
 903496898,
 -1,
 -51747,
 903606870,
 11042,
 -1,
 903620131,
 128420,
 -51745,
 903586759,
 11052,
 -1,
 903750866,
 128426,
 903951845,
 903522768,
 -1,
 904017380,
 903891681,
 -1,
 -51741,
 903991498,
 11039,
 -1,
 904041289,
 127986,
 -1,
 903996652,
 128392,
 904279528,
 903893491,
 -1,
 -51737,
 904240534,
 128447,
 -1,
 904297713,
 9873,
 -51735,
 904246165,
 10067,
 -1,
 904436657,
 11204,
 904607274,
 893688513,
 -1,
 904672808,
 904541492,
 -1,
 904738314,
 904598011,
 129792,
 904803836,
 904663851,
 129794,
 904869365,
 904729680,
 129798,
 904934898,
 904795502,
 129806,
 -51727,
 904861495,
 129836,
 -1,
 904926786,
 129821,
 905131508,
 904861250,
 129813,
 -1,
 905058103,
 129844,
 -1,
 905058103,
 129829,
 905328121,
 904795502,
 129802,
 905393656,
 905254466,
 129817,
 -1,
 905320247,
 129848,
 -1,
 905320247,
 129832,
 905590267,
 905254466,
 129810,
 -1,
 905516855,
 129840,
 -1,
 905516855,
 129825,
 905786883,
 904729680,
 129796,
 905852417,
 905713006,
 129804,
 905917952,
 905778754,
 129819,
 -1,
 905844535,
 129850,
 -1,
 905844535,
 129834,
 -51710,
 905778999,
 129827,
 -1,
 906041127,
 129842,
 906245639,
 905713006,
 129800,
 906311174,
 906171970,
 129815,
 -1,
 906237751,
 129846,
 -1,
 906237751,
 129831,
 906507785,
 906171970,
 129808,
 -1,
 906434359,
 129838,
 -1,
 906434359,
 129823,
 906704409,
 904663851,
 129793,
 906769939,
 906630224,
 129797,
 906835472,
 906696046,
 129805,
 906901007,
 906761794,
 129820,
 -1,
 906827575,
 129851,
 -1,
 906827575,
 129835,
 907097618,
 906761794,
 129812,
 -1,
 907024183,
 129843,
 -1,
 907024183,
 129828,
 907294230,
 906696046,
 129801,
 907411455,
 907220546,
 129816,
 -1,
 907286327,
 129847,
 907490840,
 907220546,
 129809,
 -1,
 907417399,
 129839,
 -1,
 907417399,
 129824,
 907687457,
 906630224,
 129795,
 907752990,
 907613550,
 129803,
 907818525,
 907679298,
 129818,
 -1,
 907745079,
 129849,
 -1,
 907745079,
 129833,
 908015136,
 907679298,
 129811,
 -1,
 907941687,
 129841,
 -1,
 907941687,
 129826,
 908211749,
 907613550,
 129799,
 908277284,
 908138050,
 129814,
 -1,
 908203831,
 129845,
 -1,
 908203831,
 129830,
 908473895,
 908138050,
 129807,
 -1,
 908400439,
 129837,
 -1,
 908400439,
 129822,
 -51671,
 904654046,
 128033,
 -1,
 908643490,
 127804,
 908853247,
 904584969,
 -1,
 908867118,
 908722176,
 -1,
 -51667,
 908812537,
 128153,
 -1,
 908864982,
 128216,
 -1,
 908798774,
 129744,
 909129432,
 893629410,
 -1,
 909194951,
 909056586,
 -1,
 909260486,
 909141025,
 -1,
 909325942,
 909214370,
 -1,
 909391418,
 909305242,
 -1,
 909456953,
 909351787,
 -1,
 909522487,
 909423586,
 69643,
 -1,
 909489122,
 69644,
 909705215,
 909474875,
 69645,
 -1,
 909605947,
 69646,
 -1,
 909384266,
 69679,
 909850176,
 909365238,
 -1,
 909915710,
 909823990,
 -1,
 -51651,
 909860302,
 69662,
 -1,
 909908554,
 69661,
 -51649,
 909860302,
 69667,
 -1,
 910039626,
 69666,
 910243397,
 909810369,
 69649,
 910360575,
 910196520,
 -1,
 -51645,
 910278768,
 69686,
 -51644,
 910333890,
 69687,
 -1,
 910394781,
 69685,
 910571082,
 910201504,
 -1,
 -51641,
 910554042,
 69660,
 -51640,
 910594794,
 69665,
 -51639,
 910645410,
 69655,
 -1,
 910694986,
 69670,
 910898768,
 910506837,
 -1,
 910964302,
 910834517,
 -1,
 -51635,
 910908878,
 69664,
 -1,
 910957130,
 69663,
 -51633,
 910908878,
 69669,
 -1,
 911088202,
 69668,
 911291988,
 910826058,
 69637,
 -51630,
 911269051,
 69650,
 -51629,
 911304701,
 69648,
 -1,
 911350346,
 69638,
 911554136,
 911262164,
 -1,
 -51626,
 911524521,
 69681,
 -51625,
 911564238,
 69680,
 -1,
 911612490,
 69682,
 911816282,
 911531195,
 69641,
 -1,
 911793339,
 69642,
 911947357,
 911780304,
 -1,
 -51620,
 911891918,
 69672,
 -1,
 911940170,
 69671,
 912143968,
 911899707,
 -1,
 -51617,
 912096389,
 69684,
 -1,
 912136778,
 69678,
 912340579,
 912095328,
 -1,
 -51614,
 912285134,
 69652,
 -1,
 912333386,
 69651,
 912537190,
 912291649,
 -1,
 -51611,
 912481742,
 69659,
 -1,
 912529994,
 69658,
 912733800,
 912484349,
 69639,
 -1,
 912680957,
 69640,
 912864875,
 912676947,
 -1,
 -51606,
 912809422,
 69654,
 -1,
 912857674,
 69653,
 913061486,
 912797608,
 -1,
 -51603,
 913006030,
 69657,
 -1,
 913054282,
 69656,
 913258097,
 912992519,
 -1,
 -51600,
 913202638,
 69674,
 -1,
 913250890,
 69673,
 -51598,
 913241018,
 69676,
 -51597,
 913421396,
 69677,
 -51596,
 913476002,
 69675,
 -51595,
 913530318,
 69683,
 -1,
 913589442,
 69647,
 913782420,
 909285879,
 -1,
 913847935,
 913756150,
 -1,
 913913467,
 913828513,
 -1,
 -51590,
 913873601,
 69715,
 -1,
 913919066,
 69724,
 914110078,
 913857980,
 -1,
 -51587,
 914077614,
 69716,
 -1,
 914125873,
 69725,
 -1,
 914049761,
 69723,
 914372228,
 913818068,
 -1,
 914437762,
 914323108,
 69719,
 -1,
 914414732,
 69728,
 914620415,
 914378724,
 69720,
 -1,
 914545804,
 69729,
 914699915,
 914313715,
 -1,
 914765448,
 914660033,
 -1,
 -51577,
 914744230,
 69717,
 -1,
 914800915,
 69726,
 915013631,
 914712573,
 -1,
 -51574,
 914941580,
 69718,
 -1,
 914970679,
 69727,
 915158671,
 914661145,
 69714,
 915275775,
 915079168,
 -1,
 -51570,
 915199028,
 69733,
 -1,
 915236722,
 69732,
 915420817,
 915117806,
 69722,
 -1,
 915397772,
 69731,
 915551891,
 915360158,
 69721,
 -1,
 915534646,
 69730,
 -1,
 915503122,
 69759,
 915748519,
 913761690,
 -1,
 915814054,
 915712330,
 -1,
 915879579,
 915794257,
 -1,
 915945113,
 915846114,
 69694,
 -1,
 915911650,
 69695,
 916127743,
 915897403,
 69696,
 -1,
 916028475,
 69697,
 916207263,
 915806794,
 -1,
 -51555,
 916184251,
 69701,
 -51554,
 916219901,
 69699,
 -1,
 916265546,
 69688,
 916469409,
 916184251,
 69692,
 -1,
 916446395,
 69693,
 916600483,
 916416509,
 69690,
 -1,
 916547581,
 69691,
 -51548,
 916560577,
 69700,
 -51547,
 916669634,
 69698,
 -1,
 916728750,
 69689,
 -1,
 915764040,
 69702,
 916993720,
 915684181,
 -1,
 917059254,
 916941803,
 -1,
 917124780,
 917032950,
 -1,
 -51541,
 917106739,
 69736,
 -1,
 917136927,
 69737,
 917321391,
 917094868,
 -1,
 -51538,
 917272228,
 69740,
 -1,
 917327844,
 69741,
 917518002,
 917262835,
 -1,
 -51535,
 917480984,
 69738,
 -1,
 917534186,
 69739,
 -51533,
 917501744,
 69734,
 -51532,
 917675801,
 69735,
 -51531,
 917739246,
 69743,
 -1,
 917784990,
 69742,
 -51529,
 917022114,
 69704,
 -1,
 917906057,
 69703,
 918107838,
 916965339,
 -1,
 -51526,
 918087956,
 69634,
 -51525,
 918151682,
 69636,
 -51524,
 918190037,
 69635,
 -51523,
 918237308,
 69632,
 -1,
 918299590,
 69633,
 918552575,
 918073698,
 -1,
 918566594,
 918453307,
 -1,
 -51519,
 918529427,
 69709,
 -1,
 918580887,
 69707,
 918763205,
 918503315,
 -1,
 -51516,
 918740501,
 69706,
 -1,
 918802422,
 69705,
 -1,
 918698214,
 69708,
 -1,
 909208891,
 129504,
 919090895,
 909142013,
 -1,
 919156427,
 919029896,
 -1,
 -51510,
 919126484,
 129650,
 -1,
 919154970,
 128188,
 919353038,
 919092053,
 -1,
 -51507,
 919296485,
 127753,
 -1,
 919356894,
 128112,
 -1,
 919287072,
 129521,
 919615188,
 919050945,
 -1,
 -51503,
 919597037,
 129294,
 -51502,
 919641579,
 129529,
 -51501,
 919697959,
 128148,
 -1,
 919744912,
 129382,
 919994367,
 919553536,
 -1,
 -51498,
 919915730,
 129329,
 -51497,
 919959675,
 983124,
 -1,
 920009557,
 127838,
 920205149,
 909073950,
 -1,
 920270614,
 920158882,
 -1,
 920336096,
 920249754,
 -1,
 920401631,
 920296299,
 -1,
 920467166,
 920368098,
 72710,
 -1,
 920433634,
 72711,
 -1,
 920419387,
 72712,
 -1,
 920328778,
 72746,
 920729318,
 920309750,
 -1,
 920794852,
 920702966,
 -1,
 -51485,
 920739278,
 72729,
 -1,
 920787530,
 72728,
 -51483,
 920739278,
 72734,
 -1,
 920918602,
 72733,
 921122539,
 920687264,
 -1,
 -51480,
 921105338,
 72727,
 -51479,
 921146090,
 72732,
 -51478,
 921196706,
 72722,
 -1,
 921246282,
 72737,
 921450225,
 921058133,
 -1,
 921515759,
 921385813,
 -1,
 -51474,
 921460174,
 72731,
 -1,
 921508426,
 72730,
 -51472,
 921460174,
 72736,
 -1,
 921639498,
 72735,
 921843445,
 921377354,
 72704,
 -51469,
 921820347,
 72717,
 -51468,
 921855997,
 72715,
 -1,
 921901642,
 72705,
 922105593,
 921813460,
 -1,
 -51465,
 922075817,
 72748,
 -51464,
 922115534,
 72747,
 -1,
 922163786,
 72749,
 922367739,
 922082491,
 72708,
 -1,
 922344635,
 72709,
 922498814,
 922331600,
 -1,
 -51459,
 922443214,
 72739,
 -1,
 922491466,
 72738,
 922695425,
 922450016,
 -1,
 -51456,
 922639822,
 72719,
 -1,
 922688074,
 72718,
 922892036,
 922646337,
 -1,
 -51453,
 922836430,
 72726,
 -1,
 922884682,
 72725,
 923088646,
 922839037,
 72706,
 -1,
 923035645,
 72707,
 923219721,
 923031635,
 -1,
 -51448,
 923164110,
 72721,
 -1,
 923212362,
 72720,
 923416332,
 923152296,
 -1,
 -51445,
 923360718,
 72724,
 -1,
 923408970,
 72723,
 923612943,
 923347207,
 -1,
 -51442,
 923557326,
 72741,
 -1,
 923605578,
 72740,
 -51440,
 923595706,
 72743,
 -51439,
 923776084,
 72744,
 -51438,
 923835073,
 72716,
 -51437,
 923896226,
 72742,
 -51436,
 923958405,
 72745,
 -51435,
 924016078,
 72750,
 -1,
 924075202,
 72714,
 924268336,
 920230391,
 -1,
 924333855,
 924241910,
 -1,
 924399387,
 924314273,
 -1,
 -51430,
 924359361,
 72795,
 -1,
 924404826,
 72804,
 924595998,
 924343740,
 -1,
 -51427,
 924563374,
 72796,
 -1,
 924611633,
 72805,
 -1,
 924535521,
 72803,
 924858148,
 924303828,
 -1,
 924923682,
 924808868,
 72799,
 -1,
 924900492,
 72808,
 925106175,
 924864484,
 72800,
 -1,
 925031564,
 72809,
 925185835,
 924799475,
 -1,
 925251368,
 925145793,
 -1,
 -51417,
 925229990,
 72797,
 -1,
 925286675,
 72806,
 925499391,
 925198333,
 -1,
 -51414,
 925427340,
 72798,
 -1,
 925456439,
 72807,
 925644589,
 925144814,
 72802,
 -1,
 925621388,
 72811,
 925775663,
 925583774,
 72801,
 -1,
 925758262,
 72810,
 -1,
 925736729,
 72794,
 925972287,
 924248618,
 -1,
 926037813,
 925952337,
 -1,
 926103348,
 926004194,
 72756,
 -1,
 926069730,
 72757,
 -1,
 926055483,
 72758,
 926299961,
 925964874,
 -1,
 -51401,
 926276795,
 72763,
 -51400,
 926312445,
 72761,
 -1,
 926358090,
 72751,
 926562107,
 926276795,
 72754,
 -1,
 926538939,
 72755,
 926693181,
 926509053,
 72752,
 -1,
 926640125,
 72753,
 -51394,
 926653121,
 72762,
 -1,
 926762178,
 72760,
 926955344,
 925907797,
 -1,
 927020878,
 926903275,
 -1,
 927086404,
 926994422,
 -1,
 -51389,
 927068211,
 72786,
 -1,
 927098399,
 72787,
 927283015,
 927056340,
 -1,
 -51386,
 927233700,
 72790,
 -1,
 927289316,
 72791,
 927479626,
 927224307,
 -1,
 -51383,
 927442456,
 72788,
 -1,
 927495658,
 72789,
 -51381,
 927463216,
 72784,
 -51380,
 927637273,
 72785,
 -51379,
 927700718,
 72793,
 -1,
 927746462,
 72792,
 -51377,
 926983586,
 72770,
 -1,
 927867529,
 72769,
 928069464,
 926926811,
 -1,
 928134996,
 928049329,
 -1,
 -51373,
 928105364,
 72766,
 -1,
 928167269,
 72767,
 928331607,
 928062026,
 -1,
 -51370,
 928310708,
 72768,
 -1,
 928356924,
 72765,
 -1,
 928264316,
 72764,
 928593755,
 928012611,
 -1,
 -51366,
 928518955,
 72773,
 -1,
 928584187,
 72772,
 -51364,
 928575925,
 72771,
 -1,
 928737168,
 72812,
 928921519,
 920165057,
 -1,
 928987000,
 928903728,
 -1,
 929052535,
 928907947,
 -1,
 929118070,
 928988809,
 -1,
 929183596,
 929096283,
 -1,
 929249127,
 929151655,
 129953,
 929366015,
 929169408,
 -1,
 929380198,
 929289984,
 129957,
 -1,
 929303402,
 129962,
 -1,
 929309132,
 129961,
 929628159,
 929202208,
 129952,
 929693695,
 929497088,
 -1,
 929707883,
 929617664,
 129956,
 -1,
 929631098,
 129963,
 -1,
 929636844,
 129960,
 929904501,
 929140315,
 -1,
 929970034,
 929857753,
 -1,
 930035568,
 929948319,
 129959,
 -1,
 929958745,
 129964,
 930217983,
 929990559,
 129954,
 -1,
 930089850,
 129958,
 930349055,
 929938355,
 -1,
 -51340,
 930275955,
 129965,
 -1,
 930318239,
 129955,
 -1,
 929840818,
 129966,
 -1,
 929064263,
 129967,
 -1,
 929001233,
 129354,
 930690951,
 928952206,
 -1,
 930756486,
 930644642,
 -1,
 930822013,
 930716353,
 -1,
 -51332,
 930759874,
 12734,
 -1,
 930811038,
 12590,
 931018624,
 930764883,
 -1,
 -51329,
 930998945,
 12732,
 -1,
 931028412,
 12728,
 -51327,
 931002380,
 12730,
 -51326,
 931174320,
 12591,
 -51325,
 931234616,
 12729,
 -51324,
 931298319,
 12733,
 -51323,
 931359826,
 12589,
 -1,
 931405349,
 12735,
 -1,
 930698216,
 12731,
 931674000,
 930667067,
 -1,
 931739535,
 931634670,
 -1,
 -51318,
 931715011,
 9185,
 -51317,
 931773228,
 11813,
 -51316,
 931834730,
 9181,
 -51315,
 931889262,
 11812,
 -51314,
 931946132,
 11211,
 -1,
 932002528,
 9183,
 -1,
 931692400,
 127870,
 932263834,
 931626725,
 -1,
 932329364,
 932244711,
 -1,
 -51309,
 932301764,
 128912,
 -1,
 932328467,
 128902,
 932525975,
 932299220,
 -1,
 -51306,
 932476603,
 128951,
 -1,
 932520145,
 128939,
 -51304,
 932470019,
 128932,
 -51303,
 932664545,
 128945,
 -1,
 932727241,
 128957,
 932919200,
 932223681,
 -1,
 932984735,
 932870240,
 128366,
 933050270,
 932940642,
 128278,
 -1,
 932973044,
 128209,
 -1,
 933020116,
 128218,
 -1,
 932941259,
 129667,
 933312423,
 932899489,
 -1,
 933377958,
 933264443,
 -1,
 933443493,
 933298176,
 -1,
 -51292,
 933424978,
 129379,
 -1,
 933469220,
 128335,
 -1,
 933392064,
 127923,
 -1,
 933298248,
 127993,
 933771177,
 933294902,
 128102,
 -1,
 933741182,
 128713,
 933902251,
 933749664,
 128144,
 -1,
 933823818,
 127893,
 934033325,
 933857612,
 983258,
 -1,
 933964039,
 128163,
 -51282,
 933991597,
 129460,
 -1,
 934093901,
 128023,
 934295523,
 928898235,
 -1,
 934361046,
 934238291,
 128027,
 934477823,
 934309561,
 -1,
 934492110,
 934380194,
 -1,
 934557628,
 934449824,
 -1,
 934623159,
 934540086,
 -1,
 -51274,
 934555615,
 6671,
 -1,
 934615626,
 6670,
 934819770,
 934565971,
 -1,
 -51271,
 934770880,
 6659,
 -1,
 934812234,
 6658,
 -51269,
 934786132,
 6667,
 -1,
 934943306,
 6666,
 935147455,
 934512972,
 -1,
 -51266,
 935111201,
 6663,
 -1,
 935139914,
 6662,
 -51264,
 935130042,
 6672,
 -51263,
 935323053,
 6675,
 -51262,
 935383164,
 6664,
 -51261,
 935445161,
 6676,
 -51260,
 935507028,
 6673,
 -51259,
 935569953,
 6660,
 -51258,
 935623813,
 6674,
 -51257,
 935688384,
 6656,
 -51256,
 935753567,
 6669,
 -51255,
 935812558,
 6678,
 -51254,
 935876770,
 6657,
 -51253,
 935934976,
 6665,
 -51252,
 935997407,
 6668,
 -51251,
 936061240,
 6661,
 -1,
 936122954,
 6677,
 936327124,
 934472234,
 -1,
 -51248,
 936303803,
 6680,
 -51247,
 936352449,
 6682,
 -51246,
 936404989,
 6679,
 -51245,
 936461506,
 6681,
 -1,
 936516854,
 6683,
 -51243,
 936290965,
 6686,
 -1,
 936659831,
 6687,
 936851419,
 934330836,
 128652,
 936916954,
 936824822,
 -1,
 -51239,
 936886804,
 128101,
 -1,
 936903595,
 128100,
 -1,
 936839611,
 128655,
 937179101,
 936827494,
 129480,
 -1,
 937121200,
 129419,
 937310175,
 937133440,
 128363,
 -1,
 937234090,
 128364,
 -51232,
 937279610,
 127791,
 -51231,
 937389205,
 127959,
 -51230,
 937440641,
 129699,
 -1,
 937503369,
 129483,
 937703435,
 934233282,
 -1,
 937768950,
 937661088,
 -1,
 937834482,
 937711867,
 -1,
 937900011,
 937788066,
 -1,
 937965546,
 937851483,
 -1,
 -51223,
 937915079,
 983642,
 -1,
 937960078,
 2510,
 -1,
 937944782,
 2556,
 938227694,
 937869780,
 -1,
 -51219,
 938175508,
 2493,
 -1,
 938222238,
 2558,
 938424305,
 938154570,
 -1,
 -51216,
 938383259,
 2432,
 -1,
 938420887,
 2557,
 -1,
 938367270,
 2555,
 938686453,
 937807862,
 -1,
 -51212,
 938646214,
 127857,
 -1,
 938672366,
 11102,
 -1,
 938669850,
 9187,
 938948608,
 937695818,
 -1,
 939014138,
 938914786,
 -1,
 -51207,
 938949975,
 129492,
 -1,
 939000525,
 128059,
 939210749,
 938970282,
 -1,
 -51204,
 939146724,
 127901,
 -1,
 939206284,
 127900,
 -51202,
 939190056,
 129451,
 -51201,
 939382388,
 128147,
 -1,
 939405920,
 127958,
 939603974,
 938900539,
 983055,
 939720703,
 939555899,
 128276,
 939735045,
 939589632,
 -1,
 -51196,
 939716189,
 128277,
 -1,
 939764931,
 129745,
 -1,
 939680966,
 128718,
 939997193,
 939541698,
 -1,
 -51192,
 939972308,
 129714,
 -1,
 940028911,
 127866,
 -51190,
 939976502,
 129475,
 -1,
 940129109,
 128719,
 940324888,
 937650173,
 -1,
 940390415,
 940291042,
 -1,
 -51186,
 940364713,
 127874,
 -1,
 940391253,
 128038,
 940587026,
 940344612,
 -1,
 -51183,
 940534058,
 127921,
 -1,
 940590892,
 129506,
 940783637,
 940522320,
 -1,
 -51180,
 940733668,
 128692,
 -1,
 940786882,
 128690,
 -51178,
 940757452,
 8383,
 -51177,
 940952346,
 129452,
 -1,
 940997365,
 128089,
 941176859,
 940307254,
 -1,
 -51174,
 941160123,
 983267,
 -1,
 941216218,
 983257,
 -51172,
 941146580,
 983057,
 -1,
 941337870,
 983125,
 941506130,
 810108098,
 -1,
 941571288,
 941447251,
 -1,
 941636823,
 941553130,
 -1,
 941701280,
 941562442,
 -1,
 941766777,
 941625579,
 -1,
 941832241,
 941692270,
 -1,
 941897765,
 941758018,
 77877,
 -1,
 941824586,
 77878,
 942028839,
 941823056,
 77874,
 -1,
 941955658,
 77875,
 942159913,
 941953835,
 77872,
 -1,
 942086730,
 77873,
 942290987,
 942084331,
 77869,
 -1,
 942217802,
 77870,
 -51156,
 942217624,
 77882,
 -51155,
 942348519,
 77881,
 -51154,
 942413831,
 77880,
 -51153,
 942479159,
 77879,
 -51152,
 942544238,
 77876,
 -1,
 942608891,
 77871,
 942815294,
 941756923,
 -1,
 942880820,
 942741511,
 77844,
 -1,
 942807626,
 77845,
 943011894,
 942806382,
 77840,
 -1,
 942938698,
 77841,
 -51145,
 942938520,
 77847,
 -51144,
 943069415,
 77846,
 -51143,
 943134519,
 77843,
 -51142,
 943199810,
 77842,
 -51141,
 943264848,
 77839,
 -51140,
 943330091,
 77838,
 -51139,
 943395323,
 77837,
 -1,
 943460587,
 77836,
 943667275,
 942739691,
 -1,
 943732802,
 943593271,
 77830,
 -51135,
 943663367,
 77832,
 -1,
 943725130,
 77831,
 943929412,
 943658562,
 77828,
 -1,
 943856202,
 77829,
 -51131,
 943856024,
 77835,
 -51130,
 943986919,
 77834,
 -51129,
 944052231,
 77833,
 -51128,
 944117102,
 77827,
 -51127,
 944182352,
 77826,
 -51126,
 944247595,
 77825,
 -1,
 944312827,
 77824,
 944519255,
 943592528,
 -1,
 944584782,
 944444203,
 77860,
 -1,
 944511562,
 77861,
 -51121,
 944511384,
 77868,
 -51120,
 944642279,
 77867,
 -51119,
 944707591,
 77866,
 -51118,
 944772919,
 77865,
 -51117,
 944838210,
 77864,
 -51116,
 944903534,
 77863,
 -51115,
 944968784,
 77862,
 -51114,
 945033723,
 77859,
 -1,
 945098987,
 77858,
 945305698,
 944445239,
 -1,
 -51111,
 945232280,
 77902,
 -51110,
 945297639,
 77901,
 -51109,
 945362951,
 77900,
 -51108,
 945428279,
 77899,
 -51107,
 945493570,
 77898,
 -51106,
 945558894,
 77897,
 -51105,
 945624144,
 77896,
 -51104,
 945689387,
 77895,
 -51103,
 945754619,
 77894,
 -1,
 945819883,
 77893,
 946026605,
 945231426,
 -1,
 -51100,
 945953176,
 77892,
 -51099,
 946018535,
 77891,
 -51098,
 946083847,
 77890,
 -51097,
 946149175,
 77889,
 -51096,
 946214466,
 77888,
 -51095,
 946279790,
 77887,
 -51094,
 946345040,
 77886,
 -51093,
 946410283,
 77885,
 -51092,
 946475515,
 77884,
 -1,
 946540779,
 77883,
 946747512,
 945951531,
 -1,
 -51089,
 946674072,
 77857,
 -51088,
 946739431,
 77856,
 -51087,
 946804743,
 77855,
 -51086,
 946870071,
 77854,
 -51085,
 946935362,
 77853,
 -51084,
 947000686,
 77852,
 -51083,
 947065936,
 77851,
 -51082,
 947131179,
 77850,
 -51081,
 947196411,
 77849,
 -1,
 947261675,
 77848,
 -1,
 946673858,
 77903,
 947585023,
 941693698,
 -1,
 947599494,
 947458283,
 -1,
 947665022,
 947525639,
 78867,
 -51075,
 947595527,
 78869,
 -1,
 947657290,
 78868,
 -51073,
 947591576,
 78871,
 -51072,
 947788007,
 78870,
 -51071,
 947853111,
 78866,
 -51070,
 947918402,
 78865,
 -51069,
 947983726,
 78864,
 -51068,
 948048976,
 78863,
 -51067,
 948114219,
 78862,
 -1,
 948179451,
 78861,
 948385937,
 947524395,
 -1,
 -51064,
 948312472,
 78891,
 -51063,
 948377831,
 78890,
 -51062,
 948443143,
 78889,
 -51061,
 948508471,
 78888,
 -51060,
 948573762,
 78887,
 -51059,
 948639086,
 78886,
 -51058,
 948704336,
 78885,
 -51057,
 948769579,
 78884,
 -51056,
 948834811,
 78883,
 -1,
 948900075,
 78882,
 949106844,
 948310523,
 -1,
 -51053,
 949033368,
 78881,
 -51052,
 949098727,
 78880,
 -51051,
 949164039,
 78879,
 -51050,
 949229367,
 78878,
 -51049,
 949294658,
 78877,
 -51048,
 949359982,
 78876,
 -51047,
 949425232,
 78875,
 -51046,
 949490475,
 78874,
 -51045,
 949555707,
 78873,
 -1,
 949620971,
 78872,
 949878783,
 949032016,
 -1,
 -51042,
 949752619,
 78894,
 -51041,
 949817851,
 78893,
 -1,
 949883115,
 78892,
 950089999,
 941658784,
 -1,
 950155480,
 950014187,
 -1,
 950220977,
 950080592,
 -1,
 950286501,
 950147079,
 78361,
 -1,
 950213194,
 78362,
 950417575,
 950212162,
 78358,
 -1,
 950344266,
 78359,
 950548649,
 950343022,
 78356,
 -1,
 950475338,
 78357,
 950679723,
 950473808,
 78354,
 -1,
 950606410,
 78355,
 -51028,
 950606232,
 78364,
 -51027,
 950737127,
 78363,
 -51026,
 950802231,
 78360,
 -51025,
 950866731,
 78353,
 -51024,
 950931963,
 78352,
 -1,
 950997227,
 78351,
 951204030,
 950145531,
 -1,
 951269557,
 951130343,
 78336,
 -51020,
 951200007,
 78338,
 -1,
 951261770,
 78337,
 -51018,
 951196056,
 78339,
 -51017,
 951392263,
 78335,
 -51016,
 951457591,
 78334,
 -51015,
 951522882,
 78333,
 -51014,
 951588206,
 78332,
 -51013,
 951653456,
 78331,
 -51012,
 951718699,
 78330,
 -51011,
 951783931,
 78329,
 -1,
 951849195,
 78328,
 952056010,
 951128875,
 -1,
 952121537,
 951981634,
 78345,
 -1,
 952048202,
 78346,
 -51006,
 952048024,
 78350,
 -51005,
 952178919,
 78349,
 -51004,
 952244231,
 78348,
 -51003,
 952309559,
 78347,
 -51002,
 952374638,
 78344,
 -51001,
 952439888,
 78343,
 -51000,
 952505131,
 78342,
 -50999,
 952570363,
 78341,
 -1,
 952635627,
 78340,
 952842452,
 951980267,
 -1,
 -50996,
 952768920,
 78327,
 -50995,
 952834279,
 78326,
 -50994,
 952899591,
 78325,
 -50993,
 952964919,
 78324,
 -50992,
 953030210,
 78323,
 -50991,
 953095534,
 78322,
 -50990,
 953160784,
 78321,
 -50989,
 953226027,
 78320,
 -1,
 953291259,
 78319,
 953548799,
 952767854,
 -1,
 -50986,
 953422635,
 78367,
 -50985,
 953487867,
 78366,
 -1,
 953553131,
 78365,
 953759990,
 950132032,
 -1,
 953825511,
 953684475,
 -1,
 953891036,
 953751783,
 78409,
 -1,
 953817674,
 78410,
 954022110,
 953815547,
 78401,
 -1,
 953948746,
 78402,
 954153184,
 953946347,
 78399,
 -1,
 954079818,
 78400,
 -50975,
 954079640,
 78411,
 -50974,
 954210311,
 78408,
 -50973,
 954275639,
 78407,
 -50972,
 954340930,
 78406,
 -50971,
 954406254,
 78405,
 -50970,
 954471504,
 78404,
 -1,
 954536747,
 78403,
 954743025,
 953749739,
 -1,
 -50967,
 954669464,
 78398,
 -50966,
 954734823,
 78397,
 -50965,
 954800135,
 78396,
 -50964,
 954865463,
 78395,
 -50963,
 954930754,
 78394,
 -50962,
 954996078,
 78393,
 -50961,
 955061328,
 78392,
 -50960,
 955126571,
 78391,
 -1,
 955191803,
 78390,
 955449343,
 954667819,
 -1,
 955463924,
 955323179,
 78414,
 -1,
 955390538,
 78415,
 -50955,
 955388411,
 78413,
 -1,
 955519211,
 78412,
 955777023,
 953711739,
 -1,
 955791619,
 955650555,
 -1,
 955857146,
 955717639,
 78385,
 -1,
 955783754,
 78386,
 -50949,
 955783576,
 78388,
 -50948,
 955914471,
 78387,
 -50947,
 955979575,
 78384,
 -50946,
 956044866,
 78383,
 -50945,
 956110190,
 78382,
 -50944,
 956175440,
 78381,
 -50943,
 956240683,
 78380,
 -50942,
 956305915,
 78379,
 -1,
 956371179,
 78378,
 956578062,
 955715819,
 -1,
 956643590,
 956503618,
 78372,
 -1,
 956570186,
 78373,
 -50937,
 956570008,
 78377,
 -50936,
 956700903,
 78376,
 -50935,
 956766215,
 78375,
 -50934,
 956831543,
 78374,
 -50933,
 956896622,
 78371,
 -50932,
 956961872,
 78370,
 -50931,
 957027115,
 78369,
 -1,
 957092347,
 78368,
 -1,
 956503072,
 78389,
 957364595,
 950025205,
 -1,
 957430054,
 957290050,
 -1,
 957495579,
 957354219,
 77997,
 -50925,
 957442045,
 78006,
 -50924,
 957504956,
 78005,
 -50923,
 957569107,
 78004,
 -50922,
 957633011,
 78003,
 -50921,
 957695170,
 78002,
 -50920,
 957758293,
 78001,
 -50919,
 957820840,
 78000,
 -50918,
 957884679,
 77999,
 -1,
 957946442,
 77998,
 958150941,
 957420910,
 78011,
 -1,
 958077514,
 78012,
 958282015,
 958075691,
 78008,
 -1,
 958208586,
 78009,
 -50912,
 958208408,
 78017,
 -50911,
 958339303,
 78016,
 -50910,
 958404615,
 78015,
 -50909,
 958469943,
 78014,
 -50908,
 958535234,
 78013,
 -50907,
 958600272,
 78010,
 -1,
 958665211,
 78007,
 958871863,
 957355831,
 -1,
 958937392,
 958797831,
 78025,
 -50903,
 958881212,
 78033,
 -50902,
 958945363,
 78032,
 -50901,
 959009267,
 78031,
 -50900,
 959071426,
 78030,
 -50899,
 959134549,
 78029,
 -50898,
 959197096,
 78028,
 -50897,
 959260935,
 78027,
 -1,
 959322698,
 78026,
 -50895,
 958863159,
 78024,
 -50894,
 959452738,
 78023,
 -50893,
 959518062,
 78022,
 -50892,
 959583312,
 78021,
 -50891,
 959648555,
 78020,
 -50890,
 959713787,
 78019,
 -1,
 959779051,
 78018,
 959985988,
 958797166,
 -1,
 960051514,
 959912167,
 77994,
 -1,
 959978058,
 77995,
 960182588,
 959977271,
 77991,
 -1,
 960109130,
 77992,
 -50883,
 960108952,
 77996,
 -50882,
 960239623,
 77993,
 -50881,
 960304706,
 77990,
 -50880,
 960370030,
 77989,
 -50879,
 960435280,
 77988,
 -50878,
 960500523,
 77987,
 -50877,
 960565755,
 77986,
 -1,
 960631019,
 77985,
 960837969,
 959910992,
 -1,
 960903495,
 960763246,
 77978,
 -1,
 960830026,
 77979,
 961034569,
 960827899,
 77974,
 -1,
 960961098,
 77975,
 -50870,
 960960920,
 77984,
 -50869,
 961091815,
 77983,
 -50868,
 961157127,
 77982,
 -50867,
 961222455,
 77981,
 -50866,
 961287746,
 77980,
 -50865,
 961352784,
 77977,
 -50864,
 961418027,
 77976,
 -1,
 961482987,
 77973,
 961689949,
 960762667,
 -1,
 961755476,
 961615879,
 77969,
 -1,
 961681994,
 77970,
 -50859,
 961681816,
 77972,
 -50858,
 961812711,
 77971,
 -50857,
 961877815,
 77968,
 -50856,
 961943106,
 77967,
 -50855,
 962008430,
 77966,
 -50854,
 962073680,
 77965,
 -50853,
 962138923,
 77964,
 -50852,
 962204155,
 77963,
 -1,
 962269419,
 77962,
 962476392,
 961614331,
 -1,
 -50849,
 962402712,
 77961,
 -50848,
 962468071,
 77960,
 -50847,
 962533383,
 77959,
 -50846,
 962598711,
 77958,
 -50845,
 962664002,
 77957,
 -50844,
 962729326,
 77956,
 -50843,
 962794576,
 77955,
 -50842,
 962859819,
 77954,
 -50841,
 962925051,
 77953,
 -1,
 962990315,
 77952,
 963248127,
 962400491,
 -1,
 963262827,
 963123431,
 77949,
 -1,
 963189322,
 77950,
 -50836,
 963189144,
 77951,
 -50835,
 963319815,
 77948,
 -50834,
 963385143,
 77947,
 -50833,
 963450434,
 77946,
 -50832,
 963515758,
 77945,
 -50831,
 963581008,
 77944,
 -50830,
 963646251,
 77943,
 -1,
 963711483,
 77942,
 963918279,
 957343130,
 -1,
 963983814,
 963842283,
 -1,
 964049295,
 963908395,
 -1,
 964114819,
 963973355,
 78726,
 -50824,
 964066363,
 78738,
 -50823,
 964130912,
 78737,
 -50822,
 964196161,
 78736,
 -50821,
 964257789,
 78735,
 -50820,
 964320700,
 78734,
 -50819,
 964384851,
 78733,
 -50818,
 964448755,
 78732,
 -50817,
 964510914,
 78731,
 -50816,
 964574037,
 78730,
 -50815,
 964636584,
 78729,
 -50814,
 964700423,
 78728,
 -1,
 964762186,
 78727,
 964966789,
 964041112,
 78749,
 -1,
 964893258,
 78750,
 965097863,
 964892903,
 78747,
 -1,
 965024330,
 78748,
 965228937,
 965022800,
 78741,
 -1,
 965155402,
 78742,
 -50806,
 965154823,
 78746,
 -50805,
 965285687,
 78745,
 -50804,
 965350978,
 78744,
 -50803,
 965416302,
 78743,
 -50802,
 965481259,
 78740,
 -1,
 965546491,
 78739,
 965753253,
 963973355,
 -1,
 965818778,
 965677563,
 78690,
 -50798,
 965765117,
 78699,
 -50797,
 965828028,
 78698,
 -50796,
 965892179,
 78697,
 -50795,
 965956083,
 78696,
 -50794,
 966018242,
 78695,
 -50793,
 966081365,
 78694,
 -50792,
 966143912,
 78693,
 -50791,
 966207751,
 78692,
 -1,
 966269514,
 78691,
 966474141,
 965744647,
 78706,
 -50788,
 966404359,
 78708,
 -1,
 966466122,
 78707,
 966670751,
 966398763,
 78700,
 -1,
 966597194,
 78701,
 -50784,
 966597016,
 78710,
 -50783,
 966727911,
 78709,
 -50782,
 966793015,
 78705,
 -50781,
 966858306,
 78704,
 -50780,
 966923630,
 78703,
 -1,
 966988880,
 78702,
 967195061,
 965677563,
 -1,
 967260586,
 967119355,
 78712,
 -50776,
 967192488,
 78715,
 -50775,
 967256327,
 78714,
 -1,
 967318090,
 78713,
 967522733,
 967185195,
 78716,
 -50772,
 967452935,
 78718,
 -1,
 967514698,
 78717,
 -50770,
 967448984,
 78725,
 -50769,
 967645415,
 78724,
 -50768,
 967710727,
 78723,
 -50767,
 967776055,
 78722,
 -50766,
 967841346,
 78721,
 -50765,
 967906670,
 78720,
 -50764,
 967971920,
 78719,
 -1,
 968036587,
 78711,
 968243652,
 967119952,
 -1,
 968309176,
 968169479,
 78761,
 -1,
 968235594,
 78762,
 968440250,
 968234064,
 78756,
 -1,
 968366666,
 78757,
 968571324,
 968364539,
 78753,
 -1,
 968497738,
 78754,
 968702398,
 968495339,
 78751,
 -1,
 968628810,
 78752,
 -50753,
 968628632,
 78764,
 -50752,
 968759527,
 78763,
 -50751,
 968824631,
 78760,
 -50750,
 968889922,
 78759,
 -50749,
 968955246,
 78758,
 -1,
 969020203,
 78755,
 969277439,
 968169005,
 78765,
 -1,
 969153098,
 78766,
 -1,
 963923487,
 78896,
 969423387,
 963877569,
 -1,
 969488922,
 969347307,
 -1,
 969554395,
 969412843,
 -1,
 969619921,
 969479991,
 78423,
 -50740,
 969560563,
 78429,
 -50739,
 969622722,
 78428,
 -50738,
 969685845,
 78427,
 -50737,
 969748392,
 78426,
 -50736,
 969812231,
 78425,
 -1,
 969873994,
 78424,
 970078675,
 969545282,
 78421,
 -1,
 970005066,
 78422,
 970209749,
 970002939,
 78416,
 -1,
 970136138,
 78417,
 -50730,
 970135960,
 78432,
 -50729,
 970266855,
 78431,
 -50728,
 970332167,
 78430,
 -50727,
 970397038,
 78420,
 -50726,
 970462288,
 78419,
 -1,
 970527531,
 78418,
 970734060,
 969479248,
 -1,
 970799585,
 970659639,
 78469,
 -50722,
 970734421,
 78473,
 -50721,
 970796968,
 78472,
 -50720,
 970860807,
 78471,
 -1,
 970922570,
 78470,
 971127267,
 970724432,
 78465,
 -1,
 971053642,
 78466,
 971258341,
 971051243,
 78461,
 -1,
 971184714,
 78462,
 -50714,
 971184536,
 78476,
 -50713,
 971315431,
 78475,
 -50712,
 971380743,
 78474,
 -50711,
 971445826,
 78468,
 -50710,
 971511150,
 78467,
 -50709,
 971576107,
 78464,
 -1,
 971641339,
 78463,
 971848187,
 970658603,
 -1,
 971913711,
 971774360,
 78459,
 -1,
 971840074,
 78460,
 972044785,
 971839042,
 78454,
 -1,
 971971146,
 78455,
 972175859,
 971969902,
 78452,
 -1,
 972102218,
 78453,
 972306933,
 972099819,
 78447,
 -1,
 972233290,
 78448,
 -50698,
 972232935,
 78458,
 -50697,
 972363783,
 78457,
 -50696,
 972429111,
 78456,
 -50695,
 972493904,
 78451,
 -50694,
 972559147,
 78450,
 -1,
 972624379,
 78449,
 972831242,
 971772411,
 -1,
 972896768,
 972755179,
 78433,
 -50690,
 972828584,
 78436,
 -50689,
 972892423,
 78435,
 -1,
 972954186,
 78434,
 973158914,
 972822936,
 78445,
 -1,
 973085258,
 78446,
 -50685,
 973084903,
 78444,
 -50684,
 973215751,
 78443,
 -50683,
 973281079,
 78442,
 -50682,
 973346370,
 78441,
 -50681,
 973411694,
 78440,
 -50680,
 973476944,
 78439,
 -50679,
 973542187,
 78438,
 -1,
 973607419,
 78437,
 973814293,
 972756334,
 -1,
 -50676,
 973740440,
 78486,
 -50675,
 973805799,
 78485,
 -50674,
 973871111,
 78484,
 -50673,
 973936439,
 78483,
 -50672,
 974001730,
 78482,
 -50671,
 974067054,
 78481,
 -50670,
 974132304,
 78480,
 -50669,
 974197547,
 78479,
 -50668,
 974262779,
 78478,
 -1,
 974328043,
 78477,
 974585855,
 973739586,
 -1,
 974600729,
 974459115,
 78487,
 -50664,
 974530823,
 78489,
 -1,
 974592586,
 78488,
 -1,
 974524923,
 78490,
 -1,
 969467736,
 78902,
 974928483,
 969378207,
 -1,
 974993971,
 974852603,
 -1,
 975059494,
 974918443,
 78268,
 -50657,
 975003068,
 78276,
 -50656,
 975067219,
 78275,
 -50655,
 975131123,
 78274,
 -50654,
 975193282,
 78273,
 -50653,
 975256405,
 78272,
 -50652,
 975318952,
 78271,
 -50651,
 975382791,
 78270,
 -1,
 975444554,
 78269,
 975649320,
 974985223,
 78283,
 -1,
 975575626,
 78284,
 975780394,
 975574839,
 78281,
 -1,
 975706698,
 78282,
 975911468,
 975705666,
 78279,
 -1,
 975837770,
 78280,
 976042542,
 975835371,
 78265,
 -1,
 975968842,
 78266,
 -50641,
 975968664,
 78286,
 -50640,
 976099559,
 78285,
 -50639,
 976164206,
 78278,
 -50638,
 976229456,
 78277,
 -1,
 976294395,
 78267,
 976501313,
 974918736,
 -1,
 976566839,
 976426064,
 78304,
 -50634,
 976496903,
 78306,
 -1,
 976558666,
 78305,
 976763449,
 976491003,
 78301,
 -1,
 976689738,
 78302,
 -50630,
 976689560,
 78312,
 -50629,
 976820455,
 78311,
 -50628,
 976885767,
 78310,
 -50627,
 976951095,
 78309,
 -50626,
 977016386,
 78308,
 -50625,
 977081710,
 78307,
 -50624,
 977146667,
 78303,
 -1,
 977211627,
 78300,
 977418831,
 976425771,
 -1,
 977484356,
 977344743,
 78297,
 -1,
 977410634,
 78298,
 977615430,
 977409390,
 78292,
 -1,
 977541706,
 78293,
 977746504,
 977539883,
 78289,
 -1,
 977672778,
 78290,
 -50615,
 977672600,
 78299,
 -50614,
 977803271,
 78296,
 -50613,
 977868599,
 78295,
 -50612,
 977933890,
 78294,
 -50611,
 977998928,
 78291,
 -50610,
 978063867,
 78288,
 -1,
 978129131,
 78287,
 978336348,
 977342699,
 -1,
 978401875,
 978260475,
 78253,
 -50606,
 978331911,
 78255,
 -1,
 978393674,
 78254,
 978598485,
 978326608,
 78257,
 -1,
 978524746,
 78258,
 -50602,
 978524568,
 78264,
 -50601,
 978655463,
 78263,
 -50600,
 978720775,
 78262,
 -50599,
 978786103,
 78261,
 -50598,
 978851394,
 78260,
 -50597,
 978916718,
 78259,
 -1,
 978981675,
 78256,
 979238911,
 978261358,
 -1,
 979253855,
 979112171,
 78313,
 -1,
 979180106,
 78314,
 -50592,
 979178862,
 78318,
 -50591,
 979309648,
 78317,
 -50590,
 979374891,
 78316,
 -1,
 979440123,
 78315,
 979647147,
 974869050,
 -1,
 979712626,
 979572078,
 -1,
 979778151,
 979638279,
 78132,
 -1,
 979704394,
 78133,
 979909225,
 979703607,
 78130,
 -1,
 979835466,
 78131,
 980040299,
 979834434,
 78128,
 -1,
 979966538,
 78129,
 -50580,
 979966360,
 78135,
 -50579,
 980097255,
 78134,
 -50578,
 980161902,
 78127,
 -50577,
 980227152,
 78126,
 -50576,
 980292395,
 78125,
 -50575,
 980357627,
 78124,
 -1,
 980422891,
 78123,
 980630144,
 979637328,
 -1,
 980695669,
 980556007,
 78120,
 -1,
 980621898,
 78121,
 980826743,
 980621319,
 78118,
 -1,
 980752970,
 78119,
 980957817,
 980750843,
 78111,
 -1,
 980884042,
 78112,
 -50566,
 980883864,
 78122,
 -50565,
 981014327,
 78117,
 -50564,
 981079618,
 78116,
 -50563,
 981144942,
 78115,
 -50562,
 981210192,
 78114,
 -50561,
 981275435,
 78113,
 -1,
 981340395,
 78110,
 981547660,
 980554539,
 -1,
 981613187,
 981471739,
 78100,
 -1,
 981539402,
 78101,
 -50556,
 981539224,
 78109,
 -50555,
 981670119,
 78108,
 -50554,
 981735431,
 78107,
 -50553,
 981800759,
 78106,
 -50552,
 981866050,
 78105,
 -50551,
 981931374,
 78104,
 -50550,
 981996624,
 78103,
 -50549,
 982061867,
 78102,
 -1,
 982126827,
 78099,
 982334104,
 981471739,
 -1,
 982399631,
 982258768,
 78091,
 -1,
 982325834,
 78092,
 -50544,
 982325656,
 78098,
 -50543,
 982456551,
 78097,
 -50542,
 982521863,
 78096,
 -50541,
 982587191,
 78095,
 -50540,
 982652482,
 78094,
 -50539,
 982717806,
 78093,
 -50538,
 982782763,
 78090,
 -50537,
 982847995,
 78089,
 -1,
 982913259,
 78088,
 983120547,
 982257899,
 -1,
 983186075,
 983044603,
 78078,
 -1,
 983112266,
 78079,
 -50532,
 983112088,
 78087,
 -50531,
 983242983,
 78086,
 -50530,
 983308295,
 78085,
 -50529,
 983373623,
 78084,
 -50528,
 983438914,
 78083,
 -50527,
 983504238,
 78082,
 -50526,
 983569488,
 78081,
 -1,
 983634731,
 78080,
 983891967,
 983045698,
 -1,
 983906984,
 983765499,
 78137,
 -50522,
 983838632,
 78140,
 -50521,
 983902471,
 78139,
 -1,
 983964234,
 78138,
 -50519,
 983831632,
 78142,
 -50518,
 984093483,
 78141,
 -1,
 984158443,
 78136,
 984365810,
 979589270,
 -1,
 984431289,
 984290670,
 -1,
 984496815,
 984356418,
 78196,
 -1,
 984422986,
 78197,
 984627889,
 984421456,
 78193,
 -1,
 984554058,
 78194,
 -50510,
 984553880,
 78201,
 -50509,
 984684775,
 78200,
 -50508,
 984750087,
 78199,
 -50507,
 984815415,
 78198,
 -50506,
 984880494,
 78195,
 -50505,
 984945451,
 78192,
 -50504,
 985010683,
 78191,
 -1,
 985075947,
 78190,
 985283270,
 984355920,
 -1,
 985348796,
 985208839,
 78186,
 -1,
 985274954,
 78187,
 985479870,
 985274167,
 78184,
 -1,
 985406026,
 78185,
 -50497,
 985405848,
 78189,
 -50496,
 985536743,
 78188,
 -50495,
 985601602,
 78183,
 -50494,
 985666926,
 78182,
 -50493,
 985732176,
 78181,
 -50492,
 985797419,
 78180,
 -50491,
 985862651,
 78179,
 -1,
 985927915,
 78178,
 986135251,
 985207595,
 -1,
 986200777,
 986060599,
 78173,
 -1,
 986126922,
 78174,
 986331851,
 986124523,
 78166,
 -1,
 986257994,
 78167,
 -50484,
 986257816,
 78177,
 -50483,
 986388711,
 78176,
 -50482,
 986454023,
 78175,
 -50481,
 986519106,
 78172,
 -50480,
 986584430,
 78171,
 -50479,
 986649680,
 78170,
 -50478,
 986714923,
 78169,
 -1,
 986780155,
 78168,
 986987232,
 986058987,
 -1,
 987052759,
 986912775,
 78150,
 -50474,
 986982663,
 78152,
 -1,
 987044426,
 78151,
 987249369,
 986978103,
 78148,
 -1,
 987175498,
 78149,
 -50470,
 987175320,
 78154,
 -50469,
 987306215,
 78153,
 -50468,
 987371074,
 78147,
 -50467,
 987436398,
 78146,
 -50466,
 987501648,
 78145,
 -50465,
 987566891,
 78144,
 -1,
 987632123,
 78143,
 987839212,
 986911227,
 -1,
 987904739,
 987763195,
 78156,
 -1,
 987830858,
 78157,
 -50460,
 987830680,
 78165,
 -50459,
 987961575,
 78164,
 -50458,
 988026887,
 78163,
 -50457,
 988092215,
 78162,
 -50456,
 988157506,
 78161,
 -50455,
 988222830,
 78160,
 -50454,
 988288080,
 78159,
 -50453,
 988353323,
 78158,
 -1,
 988418283,
 78155,
 988676095,
 987764290,
 -1,
 -50450,
 988550510,
 78206,
 -50449,
 988615760,
 78205,
 -50448,
 988681003,
 78204,
 -50447,
 988746235,
 78203,
 -1,
 988811499,
 78202,
 989018926,
 984335014,
 -1,
 989084417,
 988942843,
 -1,
 989149943,
 989009262,
 78560,
 -50442,
 989079815,
 78562,
 -1,
 989141578,
 78561,
 989346553,
 989075463,
 78565,
 -1,
 989272650,
 78566,
 -50438,
 989272472,
 78568,
 -50437,
 989403367,
 78567,
 -50436,
 989468471,
 78564,
 -50435,
 989533762,
 78563,
 -50434,
 989598800,
 78559,
 -50433,
 989664043,
 78558,
 -50432,
 989729275,
 78557,
 -1,
 989794539,
 78556,
 990001934,
 989008683,
 -1,
 990067461,
 989927223,
 78575,
 -50428,
 989997319,
 78577,
 -1,
 990059082,
 78576,
 -50426,
 989993368,
 78580,
 -50425,
 990189799,
 78579,
 -50424,
 990255111,
 78578,
 -50423,
 990320194,
 78574,
 -50422,
 990385518,
 78573,
 -50421,
 990450768,
 78572,
 -50420,
 990516011,
 78571,
 -50419,
 990581243,
 78570,
 -1,
 990646507,
 78569,
 990853914,
 989926480,
 -1,
 990919441,
 990778946,
 78586,
 -1,
 990845514,
 78587,
 -50414,
 990845336,
 78591,
 -50413,
 990976231,
 78590,
 -50412,
 991041543,
 78589,
 -50411,
 991106871,
 78588,
 -50410,
 991171950,
 78585,
 -50409,
 991237200,
 78584,
 -50408,
 991302443,
 78583,
 -50407,
 991367675,
 78582,
 -1,
 991432939,
 78581,
 991640358,
 990777579,
 -1,
 991705885,
 991565623,
 78551,
 -1,
 991631946,
 78552,
 991836959,
 991630123,
 78546,
 -1,
 991763018,
 78547,
 -50400,
 991762840,
 78555,
 -50399,
 991893735,
 78554,
 -50398,
 991959047,
 78553,
 -50397,
 992024130,
 78550,
 -50396,
 992089454,
 78549,
 -50395,
 992154704,
 78548,
 -1,
 992219643,
 78545,
 992477183,
 991565166,
 -1,
 -50392,
 992352055,
 78598,
 -50391,
 992417346,
 78597,
 -50390,
 992482670,
 78596,
 -50389,
 992547920,
 78595,
 -50388,
 992613163,
 78594,
 -50387,
 992678395,
 78593,
 -1,
 992743659,
 78592,
 992951139,
 988994880,
 -1,
 993016636,
 992875307,
 -1,
 993082162,
 992942488,
 78674,
 -1,
 993008202,
 78675,
 993213236,
 993006672,
 78667,
 -1,
 993139274,
 78668,
 -50379,
 993138919,
 78673,
 -50378,
 993269767,
 78672,
 -50377,
 993335095,
 78671,
 -50376,
 993400386,
 78670,
 -50375,
 993465710,
 78669,
 -50374,
 993530667,
 78666,
 -50373,
 993595899,
 78665,
 -1,
 993661163,
 78664,
 993868616,
 992941136,
 -1,
 993934143,
 993792811,
 78678,
 -1,
 993860170,
 78679,
 -50368,
 993859992,
 78686,
 -50367,
 993990887,
 78685,
 -50366,
 994056199,
 78684,
 -50365,
 994121527,
 78683,
 -50364,
 994186818,
 78682,
 -50363,
 994252142,
 78681,
 -50362,
 994317392,
 78680,
 -50361,
 994382331,
 78677,
 -1,
 994447595,
 78676,
 994655060,
 993792235,
 -1,
 994720588,
 994580279,
 78648,
 -50357,
 994650375,
 78650,
 -1,
 994712138,
 78649,
 -50355,
 994646424,
 78653,
 -50354,
 994842855,
 78652,
 -50353,
 994908167,
 78651,
 -50352,
 994973250,
 78647,
 -50351,
 995038574,
 78646,
 -50350,
 995103824,
 78645,
 -50349,
 995169067,
 78644,
 -1,
 995234299,
 78643,
 995441503,
 994578939,
 -1,
 -50346,
 995367320,
 78663,
 -50345,
 995432679,
 78662,
 -50344,
 995497991,
 78661,
 -50343,
 995563319,
 78660,
 -50342,
 995628610,
 78659,
 -50341,
 995693934,
 78658,
 -50340,
 995759184,
 78657,
 -50339,
 995824427,
 78656,
 -50338,
 995889659,
 78655,
 -1,
 995954923,
 78654,
 996212735,
 995366254,
 -1,
 -50335,
 996086571,
 78689,
 -50334,
 996151803,
 78688,
 -1,
 996217067,
 78687,
 996424598,
 992888002,
 -1,
 996490133,
 996348139,
 -1,
 996555634,
 996414251,
 -1,
 996621160,
 996481255,
 78066,
 -1,
 996547146,
 78067,
 996752234,
 996544747,
 78057,
 -1,
 996678218,
 78058,
 -50325,
 996678040,
 78068,
 -50324,
 996808711,
 78065,
 -50323,
 996874039,
 78064,
 -50322,
 996939330,
 78063,
 -50321,
 997004654,
 78062,
 -50320,
 997069904,
 78061,
 -50319,
 997135147,
 78060,
 -1,
 997200379,
 78059,
 997407615,
 996479483,
 -1,
 997473141,
 997332999,
 78053,
 -1,
 997399114,
 78054,
 997604215,
 997398327,
 78051,
 -1,
 997530186,
 78052,
 -50312,
 997530008,
 78056,
 -50311,
 997660903,
 78055,
 -50310,
 997725762,
 78050,
 -50309,
 997791086,
 78049,
 -50308,
 997856336,
 78048,
 -50307,
 997921579,
 78047,
 -50306,
 997986811,
 78046,
 -1,
 998052075,
 78045,
 998259595,
 997331179,
 -1,
 998325122,
 998185368,
 78043,
 -1,
 998251082,
 78044,
 998456196,
 998250727,
 78041,
 -1,
 998382154,
 78042,
 -50299,
 998381575,
 78040,
 -50298,
 998512439,
 78039,
 -50297,
 998577730,
 78038,
 -50296,
 998643054,
 78037,
 -50295,
 998708304,
 78036,
 -50294,
 998773547,
 78035,
 -1,
 998838779,
 78034,
 999096319,
 998184016,
 -1,
 999111566,
 998970734,
 78073,
 -1,
 999037514,
 78074,
 -50289,
 999037159,
 78077,
 -50288,
 999168007,
 78076,
 -50287,
 999233335,
 78075,
 -50286,
 999298128,
 78072,
 -50285,
 999363371,
 78071,
 -50284,
 999428603,
 78070,
 -1,
 999493867,
 78069,
 -1,
 996447204,
 78904,
 999766983,
 996397177,
 -1,
 999832485,
 999690475,
 -1,
 999898010,
 999758232,
 78610,
 -1,
 999823946,
 78611,
 1000029084,
 999823591,
 78608,
 -1,
 999955018,
 78609,
 1000160158,
 999954439,
 78606,
 -1,
 1000086090,
 78607,
 1000291232,
 1000084560,
 78601,
 -1,
 1000217162,
 78602,
 -50271,
 1000216375,
 78605,
 -50270,
 1000347202,
 78604,
 -50269,
 1000412526,
 78603,
 -50268,
 1000477483,
 78600,
 -1,
 1000542715,
 78599,
 1000750002,
 999756283,
 -1,
 1000815528,
 1000675127,
 78619,
 -1,
 1000741450,
 78620,
 1000946602,
 1000739323,
 78613,
 -1,
 1000872522,
 78614,
 -50261,
 1000872344,
 78623,
 -50260,
 1001003239,
 78622,
 -50259,
 1001068551,
 78621,
 -50258,
 1001133634,
 78618,
 -50257,
 1001198958,
 78617,
 -50256,
 1001264208,
 78616,
 -50255,
 1001329451,
 78615,
 -1,
 1001394411,
 78612,
 1001601981,
 1000674091,
 -1,
 -50252,
 1001527704,
 78633,
 -50251,
 1001593063,
 78632,
 -50250,
 1001658375,
 78631,
 -50249,
 1001723703,
 78630,
 -50248,
 1001788994,
 78629,
 -50247,
 1001854318,
 78628,
 -50246,
 1001919568,
 78627,
 -50245,
 1001984811,
 78626,
 -50244,
 1002050043,
 78625,
 -1,
 1002115307,
 78624,
 1002373119,
 1001526352,
 -1,
 1002388416,
 1002247248,
 78638,
 -1,
 1002314314,
 78639,
 1002519490,
 1002312491,
 78636,
 -1,
 1002445386,
 78637,
 -50237,
 1002444599,
 78642,
 -50236,
 1002575426,
 78641,
 -50235,
 1002640750,
 78640,
 -50234,
 1002705403,
 78635,
 -1,
 1002770667,
 78634,
 1002978291,
 999749229,
 -1,
 1003043809,
 1002902011,
 -1,
 1003109331,
 1002968642,
 78842,
 -50229,
 1003055101,
 78851,
 -50228,
 1003118012,
 78850,
 -50227,
 1003182163,
 78849,
 -50226,
 1003246067,
 78848,
 -50225,
 1003308226,
 78847,
 -50224,
 1003371349,
 78846,
 -50223,
 1003433896,
 78845,
 -50222,
 1003497735,
 78844,
 -1,
 1003559498,
 78843,
 1003764700,
 1003034423,
 78852,
 -50219,
 1003707836,
 78860,
 -50218,
 1003771987,
 78859,
 -50217,
 1003835891,
 78858,
 -50216,
 1003898050,
 78857,
 -50215,
 1003961173,
 78856,
 -50214,
 1004023720,
 78855,
 -50213,
 1004087559,
 78854,
 -1,
 1004149322,
 78853,
 -50211,
 1003689326,
 78841,
 -50210,
 1004278864,
 78840,
 -50209,
 1004344107,
 78839,
 -50208,
 1004409339,
 78838,
 -1,
 1004474603,
 78837,
 1004732415,
 1002967275,
 -1,
 1004747751,
 1004606251,
 78821,
 -50204,
 1004682069,
 78825,
 -50203,
 1004744616,
 78824,
 -50202,
 1004808455,
 78823,
 -1,
 1004870218,
 78822,
 1005075434,
 1004672080,
 78826,
 -50199,
 1005005063,
 78828,
 -1,
 1005066826,
 78827,
 1005272044,
 1005000258,
 78831,
 -1,
 1005197898,
 78832,
 1005403118,
 1005196654,
 78829,
 -1,
 1005328970,
 78830,
 -50193,
 1005328792,
 78836,
 -50192,
 1005459687,
 78835,
 -50191,
 1005524999,
 78834,
 -50190,
 1005590327,
 78833,
 -1,
 1005654523,
 78820,
 1005861913,
 1002943544,
 -1,
 1005927425,
 1005785595,
 -1,
 1005992951,
 1005852471,
 78530,
 -1,
 1005918794,
 78531,
 1006124025,
 1005916395,
 78523,
 -1,
 1006049866,
 78524,
 -50182,
 1006049688,
 78534,
 -50181,
 1006180583,
 78533,
 -50180,
 1006245895,
 78532,
 -50179,
 1006310978,
 78529,
 -50178,
 1006376302,
 78528,
 -50177,
 1006441552,
 78527,
 -50176,
 1006506795,
 78526,
 -1,
 1006572027,
 78525,
 1006779406,
 1005850859,
 -1,
 1006844933,
 1006703696,
 78514,
 -50172,
 1006774535,
 78516,
 -1,
 1006836298,
 78515,
 1007041543,
 1006768939,
 78512,
 -1,
 1006967370,
 78513,
 -50168,
 1006967192,
 78522,
 -50167,
 1007098087,
 78521,
 -50166,
 1007163399,
 78520,
 -50165,
 1007228727,
 78519,
 -50164,
 1007294018,
 78518,
 -50163,
 1007359342,
 78517,
 -1,
 1007423995,
 78511,
 1007681535,
 1006703403,
 -1,
 -50160,
 1007557016,
 78544,
 -50159,
 1007622375,
 78543,
 -50158,
 1007687687,
 78542,
 -50157,
 1007753015,
 78541,
 -50156,
 1007818306,
 78540,
 -50155,
 1007883630,
 78539,
 -50154,
 1007948880,
 78538,
 -50153,
 1008014123,
 78537,
 -50152,
 1008079355,
 78536,
 -1,
 1008144619,
 78535,
 1008352317,
 1005841118,
 -1,
 1008417833,
 1008275963,
 -1,
 1008483357,
 1008343271,
 78789,
 -1,
 1008409162,
 78790,
 1008614431,
 1008408583,
 78787,
 -1,
 1008540234,
 78788,
 1008745505,
 1008538990,
 78783,
 -1,
 1008671306,
 78784,
 1008876579,
 1008668907,
 78778,
 -1,
 1008802378,
 78779,
 -50140,
 1008802200,
 78791,
 -50139,
 1008932663,
 78786,
 -50138,
 1008997954,
 78785,
 -50137,
 1009062992,
 78782,
 -50136,
 1009128235,
 78781,
 -1,
 1009193467,
 78780,
 1009400885,
 1008341227,
 -1,
 1009466412,
 1009326488,
 78776,
 -1,
 1009392202,
 78777,
 1009597486,
 1009390672,
 78769,
 -1,
 1009523274,
 78770,
 -50129,
 1009522919,
 78775,
 -50128,
 1009653767,
 78774,
 -50127,
 1009719095,
 78773,
 -50126,
 1009784386,
 78772,
 -50125,
 1009849710,
 78771,
 -50124,
 1009914667,
 78768,
 -1,
 1009979899,
 78767,
 1010237439,
 1009324843,
 -1,
 1010252856,
 1010111854,
 78796,
 -1,
 1010178634,
 78797,
 -50119,
 1010177602,
 78798,
 -50118,
 1010308176,
 78795,
 -50117,
 1010373419,
 78794,
 -50116,
 1010438651,
 78793,
 -1,
 1010503915,
 78792,
 1010711645,
 1008283612,
 -1,
 1010777163,
 1010634987,
 -1,
 1010842691,
 1010701099,
 77915,
 -50111,
 1010773928,
 77918,
 -50110,
 1010837767,
 77917,
 -1,
 1010899530,
 77916,
 -50108,
 1010768280,
 77925,
 -50107,
 1011030247,
 77924,
 -50106,
 1011095559,
 77923,
 -50105,
 1011160887,
 77922,
 -50104,
 1011226178,
 77921,
 -50103,
 1011291502,
 77920,
 -50102,
 1011356752,
 77919,
 -1,
 1011421691,
 77914,
 1011629143,
 1010700795,
 -1,
 1011694670,
 1011552491,
 77926,
 -1,
 1011620426,
 77927,
 -50097,
 1011620248,
 77936,
 -50096,
 1011751143,
 77935,
 -50095,
 1011816455,
 77934,
 -50094,
 1011881783,
 77933,
 -50093,
 1011947074,
 77932,
 -50092,
 1012012398,
 77931,
 -50091,
 1012077648,
 77930,
 -50090,
 1012142891,
 77929,
 -1,
 1012208123,
 77928,
 1012465663,
 1011553067,
 -1,
 -50087,
 1012340078,
 77941,
 -50086,
 1012405328,
 77940,
 -50085,
 1012470571,
 77939,
 -50084,
 1012535803,
 77938,
 -1,
 1012601067,
 77937,
 1012808827,
 1010657277,
 -1,
 1012874356,
 1012732139,
 -1,
 1012939883,
 1012797675,
 -1,
 1013005410,
 1012865432,
 78225,
 -1,
 1012931146,
 78226,
 1013136484,
 1012930114,
 78220,
 -1,
 1013062218,
 78221,
 -50075,
 1013061863,
 78224,
 -50074,
 1013192711,
 78223,
 -50073,
 1013258039,
 78222,
 -50072,
 1013323118,
 78219,
 -50071,
 1013388368,
 78218,
 -50070,
 1013453611,
 78217,
 -1,
 1013518843,
 78216,
 1013776383,
 1012863483,
 -1,
 1013791854,
 1013649915,
 78229,
 -1,
 1013717578,
 78230,
 1013922928,
 1013715179,
 78227,
 -1,
 1013848650,
 78228,
 -50063,
 1013847618,
 78234,
 -50062,
 1013978478,
 78233,
 -50061,
 1014043728,
 78232,
 -1,
 1014108971,
 78231,
 1014366207,
 1012832509,
 -1,
 1014381688,
 1014290280,
 -1,
 -50057,
 1014353171,
 78898,
 -1,
 1014385518,
 78900,
 1014628351,
 1014312443,
 -1,
 -50054,
 1014549779,
 78899,
 -1,
 1014582126,
 78901,
 1014774923,
 1012771358,
 -1,
 1014840456,
 1014698219,
 -1,
 1014905983,
 1014764624,
 78494,
 -1,
 1014831690,
 78495,
 1015037057,
 1014829563,
 78491,
 -1,
 1014962762,
 78492,
 -50046,
 1014962584,
 78501,
 -50045,
 1015093479,
 78500,
 -50044,
 1015158791,
 78499,
 -50043,
 1015224119,
 78498,
 -50042,
 1015289410,
 78497,
 -50041,
 1015354734,
 78496,
 -1,
 1015419691,
 78493,
 1015676927,
 1014764027,
 -1,
 -50038,
 1015550459,
 78503,
 -1,
 1015615723,
 78502,
 1015823512,
 1014755919,
 -1,
 1015889039,
 1015747950,
 78802,
 -50034,
 1015818503,
 78804,
 -1,
 1015880266,
 78803,
 1016085649,
 1015814375,
 78809,
 -1,
 1016011338,
 78810,
 1016216723,
 1016010551,
 78806,
 -1,
 1016142410,
 78807,
 -50028,
 1016141831,
 78808,
 -50027,
 1016272450,
 78805,
 -50026,
 1016337488,
 78801,
 -50025,
 1016402731,
 78800,
 -1,
 1016467963,
 78799,
 1016675493,
 1015752967,
 -1,
 1016741028,
 1016599000,
 -1,
 1016806556,
 1016665666,
 77908,
 -1,
 1016732234,
 77909,
 -50019,
 1016732056,
 77913,
 -50018,
 1016862951,
 77912,
 -50017,
 1016928263,
 77911,
 -50016,
 1016993591,
 77910,
 -50015,
 1017058670,
 77907,
 -50014,
 1017123920,
 77906,
 -50013,
 1017189163,
 77905,
 -1,
 1017254395,
 77904,
 -1,
 1016678721,
 78903,
 1017527472,
 1016626302,
 -1,
 1017593000,
 1017452343,
 78249,
 -1,
 1017518666,
 78250,
 1017724074,
 1017516843,
 78244,
 -1,
 1017649738,
 78245,
 -50005,
 1017649383,
 78252,
 -50004,
 1017780231,
 78251,
 -50003,
 1017845314,
 78248,
 -50002,
 1017910638,
 78247,
 -50001,
 1017975888,
 78246,
 -1,
 1018040827,
 78243,
 1018248380,
 1017470396,
 -1,
 1018313915,
 1018171864,
 -1,
 1018379444,
 1018238775,
 78212,
 -1,
 1018305098,
 78213,
 -49995,
 1018304743,
 78215,
 -49994,
 1018435591,
 78214,
 -49993,
 1018500674,
 78211,
 -49992,
 1018565998,
 78210,
 -49991,
 1018631248,
 78209,
 -49990,
 1018696491,
 78208,
 -1,
 1018761723,
 78207,
 -1,
 1018274777,
 78897,
 1019034822,
 1018229686,
 -1,
 1019100351,
 1018958331,
 78811,
 -1,
 1019025994,
 78812,
 -49984,
 1019025639,
 78819,
 -49983,
 1019156487,
 78818,
 -49982,
 1019221815,
 78817,
 -49981,
 1019287106,
 78816,
 -49980,
 1019352430,
 78815,
 -49979,
 1019417680,
 78814,
 -1,
 1019482923,
 78813,
 1019690191,
 1018984619,
 -1,
 -49976,
 1019615463,
 78242,
 -49975,
 1019680775,
 78241,
 -49974,
 1019746103,
 78240,
 -49973,
 1019811394,
 78239,
 -49972,
 1019876718,
 78238,
 -49971,
 1019941968,
 78237,
 -49970,
 1020007211,
 78236,
 -1,
 1020072443,
 78235,
 1020329983,
 1019654697,
 -1,
 -49967,
 1020205063,
 78510,
 -49966,
 1020270391,
 78509,
 -49965,
 1020335682,
 78508,
 -49964,
 1020401006,
 78507,
 -49963,
 1020466256,
 78506,
 -49962,
 1020531499,
 78505,
 -1,
 1020596731,
 78504,
 -1,
 941578323,
 129370,
 1020870042,
 941543414,
 -1,
 1020935576,
 1020814211,
 -1,
 1021001094,
 1020903892,
 -1,
 1021066629,
 1020982587,
 -1,
 1021132023,
 1020997544,
 -1,
 1021197557,
 1021063080,
 -1,
 1021263086,
 1021140412,
 -1,
 1021328615,
 1021205948,
 -1,
 1021394146,
 1021265090,
 43813,
 -1,
 1021330626,
 43812,
 1021525220,
 1021319754,
 43808,
 -1,
 1021450826,
 43811,
 -49947,
 1021500603,
 43809,
 -49946,
 1021614785,
 43814,
 -1,
 1021667325,
 43810,
 1021852905,
 1021265090,
 11709,
 -1,
 1021789378,
 11708,
 1021983979,
 1021778506,
 11704,
 -1,
 1021909578,
 11707,
 -49940,
 1021959355,
 11705,
 -49939,
 1022073537,
 11710,
 -1,
 1022126077,
 11706,
 1022311664,
 1021199554,
 11693,
 -1,
 1022248130,
 11692,
 1022442738,
 1022237258,
 11688,
 -1,
 1022368330,
 11691,
 -49933,
 1022418107,
 11689,
 -49932,
 1022532289,
 11694,
 -1,
 1022584829,
 11690,
 -49930,
 1021156122,
 11655,
 -1,
 1022714928,
 11664,
 1022901512,
 1021073491,
 -1,
 1022967040,
 1022882614,
 -1,
 1023032571,
 1022903490,
 11741,
 -1,
 1022969026,
 11740,
 1023163645,
 1022958154,
 11736,
 -1,
 1023089226,
 11739,
 -49922,
 1023139003,
 11737,
 -49921,
 1023253185,
 11742,
 -1,
 1023305725,
 11738,
 1023491334,
 1022909863,
 -1,
 1023556867,
 1023427778,
 11670,
 -1,
 1023493314,
 11669,
 1023687941,
 1023482442,
 11667,
 -1,
 1023613514,
 4895,
 -1,
 1023633405,
 11668,
 -49913,
 1023449882,
 4879,
 -1,
 1023837913,
 11658,
 1024015642,
 1022835541,
 -1,
 1024081170,
 1023949653,
 -1,
 1024146705,
 1024023996,
 -1,
 1024212237,
 1024083138,
 43789,
 -1,
 1024148674,
 43788,
 -49906,
 1024187579,
 43785,
 -49905,
 1024301761,
 43790,
 -49904,
 1024354301,
 43786,
 -1,
 1024400143,
 43787,
 -1,
 1024105242,
 11661,
 1024671001,
 1024063045,
 -1,
 1024736533,
 1024607426,
 43797,
 -1,
 1024672962,
 43796,
 -49898,
 1024711867,
 43793,
 -49897,
 1024826049,
 43798,
 -49896,
 1024878589,
 43794,
 -1,
 1024924431,
 43795,
 -1,
 1024629530,
 11660,
 1025195306,
 1023984084,
 -1,
 1025260835,
 1025163732,
 -1,
 1025326366,
 1025197250,
 11685,
 -1,
 1025262786,
 11684,
 1025457440,
 1025251914,
 11680,
 -1,
 1025382986,
 11683,
 -49887,
 1025432763,
 11681,
 -49886,
 1025546945,
 11686,
 -1,
 1025599485,
 11682,
 1025785128,
 1025197798,
 -1,
 -49883,
 1025749507,
 5004,
 -49882,
 1025806976,
 4992,
 -49881,
 1025857615,
 5000,
 -1,
 1025912720,
 4996,
 -49879,
 1025743642,
 11651,
 -1,
 1026057264,
 11652,
 1026243896,
 1025124615,
 -1,
 1026309427,
 1026173191,
 -1,
 1026374958,
 1026245826,
 43821,
 -1,
 1026311362,
 43820,
 1026506032,
 1026300490,
 43816,
 -1,
 1026431562,
 43819,
 -49871,
 1026481339,
 43817,
 -49870,
 1026595521,
 43822,
 -1,
 1026648061,
 43818,
 1026833719,
 1026288289,
 -1,
 1026899254,
 1026770114,
 4999,
 -1,
 1026835650,
 4998,
 -1,
 1026844669,
 4997,
 -1,
 1026792218,
 11653,
 1027161411,
 1026215926,
 -1,
 1027226944,
 1027134285,
 -1,
 1027292476,
 1027163330,
 43781,
 -1,
 1027228866,
 43780,
 -49859,
 1027267771,
 43777,
 -49858,
 1027381953,
 43782,
 -49857,
 1027434493,
 43778,
 -1,
 1027480335,
 43779,
 -49855,
 1027209187,
 4935,
 -49854,
 1027644186,
 11654,
 -1,
 1027695664,
 11663,
 1027882317,
 1027143237,
 -1,
 1027947852,
 1027864133,
 -1,
 1028013383,
 1027884226,
 11701,
 -1,
 1027949762,
 11700,
 1028144457,
 1027938890,
 11696,
 -1,
 1028069962,
 11699,
 -49846,
 1028119739,
 11697,
 -49845,
 1028233921,
 11702,
 -1,
 1028286461,
 11698,
 -1,
 1027906330,
 11659,
 1028537687,
 1027863088,
 -1,
 1028603222,
 1028518710,
 -1,
 1028668753,
 1028539586,
 11733,
 -1,
 1028605122,
 11732,
 1028799827,
 1028594250,
 11728,
 -1,
 1028725322,
 11731,
 -49836,
 1028775099,
 11729,
 -49835,
 1028889281,
 11734,
 -1,
 1028941821,
 11730,
 -1,
 1028561690,
 4743,
 1029193057,
 1028502030,
 -1,
 1029258592,
 1029174070,
 -1,
 1029324123,
 1029194946,
 11717,
 -1,
 1029260482,
 11716,
 1029455197,
 1029249610,
 11712,
 -1,
 1029380682,
 11715,
 -49826,
 1029430459,
 11713,
 -49825,
 1029544641,
 11718,
 -1,
 1029597181,
 11714,
 -1,
 1029217050,
 4679,
 1029848427,
 1029142624,
 -1,
 1029913962,
 1029829430,
 -1,
 1029979493,
 1029850306,
 11725,
 -1,
 1029915842,
 11724,
 1030110567,
 1029904970,
 11720,
 -1,
 1030036042,
 11723,
 -49816,
 1030085819,
 11721,
 -49815,
 1030200001,
 11726,
 -1,
 1030252541,
 11722,
 -1,
 1029872410,
 4783,
 1030503794,
 1029810640,
 -1,
 1030569328,
 1030482593,
 -1,
 1030634863,
 1030505666,
 5007,
 -1,
 1030571202,
 5006,
 -1,
 1030580221,
 5005,
 -49807,
 1030527770,
 11666,
 -1,
 1030775856,
 11665,
 1030962552,
 1030457676,
 -1,
 1031028087,
 1030941345,
 -1,
 1031093622,
 1030964418,
 4995,
 -1,
 1031029954,
 4994,
 -1,
 1031038973,
 4993,
 -1,
 1030986522,
 11649,
 1031355772,
 1030903884,
 -1,
 1031421307,
 1031292098,
 5003,
 -1,
 1031357634,
 5002,
 -1,
 1031366653,
 5001,
 1031617919,
 1031312032,
 -1,
 -49794,
 1031599529,
 11657,
 -1,
 1031641882,
 11656,
 -49792,
 1031599529,
 4847,
 -49791,
 1031795057,
 4815,
 -49790,
 1031847729,
 11650,
 -49789,
 1031898600,
 11648,
 -49788,
 1031960583,
 11662,
 -1,
 1032021040,
 4615,
 -1,
 1021003536,
 4960,
 1032273299,
 1020974897,
 -1,
 1032338827,
 1032207189,
 -1,
 1032404362,
 1032277401,
 5009,
 -1,
 1032327107,
 5016,
 -1,
 1032350322,
 5012,
 1032600974,
 1032288352,
 -1,
 -49779,
 1032578168,
 5017,
 -1,
 1032604501,
 5013,
 -49777,
 1032582440,
 5008,
 -49776,
 1032767256,
 5011,
 -49775,
 1032830209,
 5010,
 -49774,
 1032872570,
 5015,
 -1,
 1032926079,
 5014,
 1033175039,
 1032205994,
 -1,
 1033190807,
 1033067037,
 -1,
 -49770,
 1033145186,
 4959,
 -1,
 1033183835,
 4957,
 -1,
 1033169399,
 4958,
 -49767,
 1020916272,
 983047,
 -1,
 1033382151,
 983096,
 1033584118,
 1020820539,
 -1,
 1033649615,
 1033513550,
 -1,
 1033715105,
 1033605792,
 -1,
 -49762,
 1033664397,
 66837,
 -49761,
 1033716930,
 66835,
 -49760,
 1033780481,
 66821,
 -1,
 1033837130,
 66836,
 1034042791,
 1033656403,
 -1,
 1034108325,
 1033985468,
 -1,
 -49756,
 1034044610,
 66853,
 -1,
 1034101000,
 66854,
 -49754,
 1034057613,
 66827,
 -1,
 1034241218,
 66826,
 1034436010,
 1034024517,
 -1,
 -49751,
 1034379391,
 66852,
 -1,
 1034437826,
 66851,
 1034632621,
 1034407926,
 -1,
 -49748,
 1034575999,
 66846,
 -1,
 1034634434,
 66845,
 1034829232,
 1034600916,
 -1,
 -49745,
 1034772607,
 66844,
 -1,
 1034831042,
 66843,
 1035025843,
 1034793954,
 -1,
 -49742,
 1034991267,
 66842,
 -1,
 1035027650,
 66841,
 1035222454,
 1034976315,
 -1,
 -49739,
 1035173692,
 66833,
 -1,
 1035224258,
 66832,
 1035419065,
 1035171936,
 -1,
 -49736,
 1035362431,
 66855,
 -1,
 1035420866,
 66831,
 1035615675,
 1035355330,
 66824,
 -1,
 1035560957,
 66823,
 1035746750,
 1035549525,
 -1,
 -49731,
 1035690111,
 66822,
 -1,
 1035748546,
 66820,
 1035943361,
 1035677608,
 -1,
 -49728,
 1035886719,
 66819,
 -1,
 1035945154,
 66818,
 -49726,
 1035924278,
 66850,
 -49725,
 1036120721,
 66849,
 -49724,
 1036183180,
 66848,
 -49723,
 1036246203,
 66847,
 -49722,
 1036300893,
 66840,
 -49721,
 1036364773,
 66839,
 -49720,
 1036425921,
 66838,
 -49719,
 1036487811,
 66834,
 -49718,
 1036547981,
 66830,
 -49717,
 1036609533,
 66829,
 -49716,
 1036673151,
 66828,
 -49715,
 1036735150,
 66825,
 -49714,
 1036790440,
 66817,
 -1,
 1036851786,
 66816,
 1037057516,
 1033631063,
 -1,
 1037123051,
 1036996368,
 -1,
 1037188566,
 1037091284,
 -1,
 1037254101,
 1037113930,
 -1,
 -49708,
 1037208940,
 69614,
 -1,
 1037254217,
 69617,
 -1,
 1037198163,
 69620,
 1037516249,
 1037160438,
 -1,
 -49704,
 1037455050,
 69608,
 -1,
 1037510821,
 69621,
 1037712859,
 1037459583,
 69604,
 -1,
 1037685581,
 69607,
 1037843934,
 1037638218,
 -1,
 -49699,
 1037825277,
 69615,
 -1,
 1037861483,
 69600,
 -49697,
 1037825795,
 69606,
 -49696,
 1038022078,
 69609,
 -49695,
 1038085073,
 69605,
 -49694,
 1038137514,
 69619,
 -49693,
 1038201471,
 69618,
 -49692,
 1038265317,
 69616,
 -49691,
 1038326323,
 69613,
 -49690,
 1038388613,
 69612,
 -49689,
 1038450050,
 69611,
 -49688,
 1038514492,
 69610,
 -49687,
 1038572464,
 69602,
 -49686,
 1038629970,
 69603,
 -1,
 1038691150,
 69601,
 -1,
 1037069118,
 69622,
 1038958069,
 1036993730,
 -1,
 1039023603,
 1038891617,
 -1,
 1039089138,
 1038942208,
 -1,
 -49680,
 1039062954,
 128294,
 -49679,
 1039117903,
 128268,
 -1,
 1039172581,
 128161,
 -1,
 1039015803,
 9191,
 -49676,
 1039001215,
 128727,
 -1,
 1039379738,
 128024,
 -1,
 1038897651,
 129501,
 1039613451,
 1033537868,
 -1,
 1039678979,
 1039572198,
 -1,
 1039744510,
 1039634553,
 -1,
 -49670,
 1039669047,
 127999,
 -49669,
 1039734338,
 127998,
 -49668,
 1039799662,
 127997,
 -49667,
 1039864912,
 127996,
 -1,
 1039930103,
 127995,
 1040187391,
 1039677198,
 -1,
 -49664,
 1040117072,
 129459,
 -49663,
 1040168822,
 129456,
 -49662,
 1040202478,
 129457,
 -1,
 1040263577,
 129458,
 1040515071,
 1039642933,
 -1,
 1040530952,
 1040423046,
 128453,
 1040646143,
 1040451347,
 -1,
 -49657,
 1040538078,
 128454,
 -1,
 1040595797,
 128455,
 1040793098,
 1040493154,
 128460,
 -1,
 1040761300,
 128461,
 -1,
 1040727958,
 128459,
 1040989725,
 1039569568,
 -1,
 1041055256,
 1040923479,
 -1,
 1041120791,
 1041013780,
 -1,
 1041186322,
 1041092598,
 -1,
 1041251857,
 1041151375,
 983048,
 -1,
 1041170805,
 983095,
 -1,
 1041191197,
 983046,
 -49645,
 1041155142,
 983134,
 -49644,
 1041412332,
 983178,
 -49643,
 1041468618,
 983099,
 -49642,
 1041532003,
 983064,
 -1,
 1041587512,
 983177,
 -1,
 1041100525,
 128282,
 1041841691,
 1041032940,
 -1,
 -49638,
 1041794113,
 128388,
 -1,
 1041843098,
 128233,
 1042087935,
 1041805838,
 983051,
 -1,
 1042014060,
 983050,
 1042169388,
 1040915018,
 -1,
 1042234923,
 1042133986,
 128066,
 1042300454,
 1042207568,
 -1,
 1042365989,
 1042253298,
 -1,
 1042431524,
 1042291274,
 -1,
 -49629,
 1042401129,
 127759,
 -1,
 1042451922,
 127758,
 -1,
 1042370488,
 127757,
 -1,
 1042333758,
 9178,
 1042808831,
 1042219008,
 -1,
 1042824746,
 1042717716,
 -1,
 -49623,
 1042790994,
 127806,
 -1,
 1042844220,
 127805,
 -1,
 1042804373,
 129467,
 -1,
 1042177034,
 129413,
 1043152441,
 1042149936,
 -1,
 1043217976,
 1043126274,
 -1,
 1043283511,
 1043155629,
 -1,
 1043349042,
 1043262695,
 -1,
 -49615,
 1043319748,
 128915,
 -1,
 1043346451,
 128905,
 1043545653,
 1043317204,
 -1,
 -49612,
 1043494587,
 128954,
 -1,
 1043538129,
 128942,
 -49610,
 1043488003,
 128935,
 -1,
 1043682529,
 128948,
 -1,
 1043212103,
 128125,
 -1,
 1043181731,
 128529,
 1044004412,
 1043133508,
 128065,
 -49605,
 1043972564,
 128064,
 -1,
 1044012034,
 128083,
 1044201024,
 1043972564,
 -1,
 1044266559,
 1044131752,
 983104,
 -1,
 1044194286,
 983103,
 -1,
 1044191818,
 983135,
 1044463172,
 1044159169,
 -1,
 -49598,
 1044434934,
 983049,
 -49597,
 1044482380,
 983100,
 -1,
 1044544571,
 983067,
 1044725319,
 1044440163,
 -1,
 -49594,
 1044688842,
 127972,
 -1,
 1044721960,
 127984,
 1044921930,
 1044692566,
 -1,
 -49591,
 1044896713,
 11249,
 -1,
 1044946713,
 11248,
 1045118541,
 1044886201,
 -1,
 -49588,
 1045098150,
 11257,
 -1,
 1045109672,
 11072,
 -49586,
 1045096266,
 127794,
 -49585,
 1045277217,
 983179,
 -49584,
 1045329808,
 9167,
 -49583,
 1045380970,
 11790,
 -1,
 1045434351,
 128231,
 1045644569,
 941431370,
 -1,
 1045709035,
 1045598880,
 -1,
 1045774556,
 1045637075,
 -1,
 1045840091,
 1045726036,
 -1,
 1045905109,
 1045762555,
 -1,
 1045970541,
 1045827819,
 -1,
 1046036060,
 1045895175,
 83070,
 -49574,
 1045966760,
 83073,
 -49573,
 1046030599,
 83072,
 -1,
 1046092362,
 83071,
 1046298208,
 1045960046,
 83062,
 -49570,
 1046228904,
 83065,
 -49569,
 1046292743,
 83064,
 -1,
 1046354506,
 83063,
 1046560355,
 1046222402,
 83066,
 -49566,
 1046489351,
 83068,
 -1,
 1046551114,
 83067,
 1046756965,
 1046483755,
 83059,
 -1,
 1046682186,
 83060,
 1046888039,
 1046680059,
 83057,
 -1,
 1046813258,
 83058,
 1047019113,
 1046810859,
 83055,
 -1,
 1046944330,
 83056,
 -49558,
 1046944152,
 83075,
 -49557,
 1047075047,
 83074,
 -49556,
 1047140151,
 83069,
 -1,
 1047204944,
 83061,
 1047412347,
 1045893627,
 -1,
 1047477873,
 1047335147,
 83076,
 -49552,
 1047406855,
 83078,
 -1,
 1047468618,
 83077,
 1047674483,
 1047402050,
 83083,
 -1,
 1047599690,
 83084,
 -49548,
 1047599512,
 83088,
 -49547,
 1047730407,
 83087,
 -49546,
 1047795719,
 83086,
 -49545,
 1047861047,
 83085,
 -49544,
 1047926126,
 83082,
 -49543,
 1047991376,
 83081,
 -49542,
 1048056619,
 83080,
 -1,
 1048121851,
 83079,
 1048329863,
 1047336016,
 -1,
 1048395390,
 1048254018,
 83105,
 -1,
 1048320586,
 83106,
 -49537,
 1048320408,
 83110,
 -49536,
 1048451303,
 83109,
 -49535,
 1048516615,
 83108,
 -49534,
 1048581943,
 83107,
 -49533,
 1048647022,
 83104,
 -49532,
 1048712272,
 83103,
 -49531,
 1048777515,
 83102,
 -49530,
 1048842747,
 83101,
 -1,
 1048908011,
 83100,
 1049116307,
 1048253227,
 -1,
 1049181834,
 1049040450,
 83094,
 -1,
 1049107018,
 83095,
 -49525,
 1049106840,
 83099,
 -49524,
 1049237735,
 83098,
 -49523,
 1049303047,
 83097,
 -49522,
 1049368375,
 83096,
 -49521,
 1049433454,
 83093,
 -49520,
 1049498704,
 83092,
 -49519,
 1049563947,
 83091,
 -49518,
 1049629179,
 83090,
 -1,
 1049694443,
 83089,
 1049902750,
 1049041304,
 -1,
 -49515,
 1049827736,
 83170,
 -49514,
 1049893095,
 83169,
 -49513,
 1049958407,
 83168,
 -49512,
 1050023735,
 83167,
 -49511,
 1050089026,
 83166,
 -49510,
 1050154350,
 83165,
 -49509,
 1050219600,
 83164,
 -49508,
 1050284843,
 83163,
 -49507,
 1050350075,
 83162,
 -1,
 1050415339,
 83161,
 1050623657,
 1049827559,
 -1,
 -49504,
 1050548632,
 83160,
 -49503,
 1050613991,
 83159,
 -49502,
 1050679303,
 83158,
 -49501,
 1050744631,
 83157,
 -49500,
 1050809922,
 83156,
 -49499,
 1050875246,
 83155,
 -49498,
 1050940496,
 83154,
 -49497,
 1051005739,
 83153,
 -49496,
 1051070971,
 83152,
 -1,
 1051136235,
 83151,
 1051344564,
 1050548231,
 -1,
 -49493,
 1051269528,
 83150,
 -49492,
 1051334887,
 83149,
 -49491,
 1051400199,
 83148,
 -49490,
 1051465527,
 83147,
 -49489,
 1051530818,
 83146,
 -49488,
 1051596142,
 83145,
 -49487,
 1051661392,
 83144,
 -49486,
 1051726635,
 83143,
 -49485,
 1051791867,
 83142,
 -1,
 1051857131,
 83141,
 1052065471,
 1051268919,
 -1,
 -49482,
 1051990424,
 83140,
 -49481,
 1052055783,
 83139,
 -49480,
 1052121095,
 83138,
 -49479,
 1052186423,
 83137,
 -49478,
 1052251714,
 83136,
 -49477,
 1052317038,
 83135,
 -49476,
 1052382288,
 83134,
 -49475,
 1052447531,
 83133,
 -49474,
 1052512763,
 83132,
 -1,
 1052578027,
 83131,
 1052786378,
 1051989570,
 -1,
 -49471,
 1052711320,
 83130,
 -49470,
 1052776679,
 83129,
 -49469,
 1052841991,
 83128,
 -49468,
 1052907319,
 83127,
 -49467,
 1052972610,
 83126,
 -49466,
 1053037934,
 83125,
 -49465,
 1053103184,
 83124,
 -49464,
 1053168427,
 83123,
 -49463,
 1053233659,
 83122,
 -1,
 1053298923,
 83121,
 1053556735,
 1052710254,
 -1,
 -49460,
 1053432216,
 83120,
 -49459,
 1053497575,
 83119,
 -49458,
 1053562887,
 83118,
 -49457,
 1053628215,
 83117,
 -49456,
 1053693506,
 83116,
 -49455,
 1053758830,
 83115,
 -49454,
 1053824080,
 83114,
 -49453,
 1053889323,
 83113,
 -49452,
 1053954555,
 83112,
 -1,
 1054019819,
 83111,
 1054228308,
 1045828688,
 -1,
 1054293735,
 1054151760,
 -1,
 1054359259,
 1054218039,
 83322,
 -49447,
 1054289832,
 83325,
 -49446,
 1054353671,
 83324,
 -1,
 1054415434,
 83323,
 1054621407,
 1054282539,
 -1,
 -49443,
 1054551976,
 83318,
 -49442,
 1054615815,
 83317,
 -1,
 1054677578,
 83316,
 -49440,
 1054546328,
 83328,
 -49439,
 1054808295,
 83327,
 -49438,
 1054873607,
 83326,
 -49437,
 1054938690,
 83321,
 -49436,
 1055004014,
 83320,
 -49435,
 1055069264,
 83319,
 -49434,
 1055134203,
 83315,
 -1,
 1055199467,
 83314,
 1055407862,
 1054218471,
 -1,
 1055473386,
 1055332151,
 83381,
 -1,
 1055398474,
 83382,
 1055604461,
 1055396944,
 -1,
 -49428,
 1055529546,
 83378,
 -1,
 1055590568,
 83377,
 1055801071,
 1055527419,
 83374,
 -1,
 1055726154,
 83375,
 -49424,
 1055725976,
 83385,
 -49423,
 1055856871,
 83384,
 -49422,
 1055922183,
 83383,
 -49421,
 1055987266,
 83380,
 -49420,
 1056052590,
 83379,
 -49419,
 1056117547,
 83376,
 -1,
 1056182507,
 83373,
 1056390915,
 1055332151,
 -1,
 1056456441,
 1056315623,
 83359,
 -1,
 1056381514,
 83360,
 1056587515,
 1056380270,
 83354,
 -1,
 1056512586,
 83355,
 -49412,
 1056512408,
 83361,
 -49411,
 1056643079,
 83358,
 -49410,
 1056708407,
 83357,
 -49409,
 1056773698,
 83356,
 -49408,
 1056838736,
 83353,
 -49407,
 1056903979,
 83352,
 -49406,
 1056969211,
 83351,
 -1,
 1057034475,
 83350,
 1057242895,
 1056315399,
 -1,
 1057308422,
 1057165819,
 83363,
 -1,
 1057233482,
 83364,
 -49401,
 1057233304,
 83372,
 -49400,
 1057364199,
 83371,
 -49399,
 1057429511,
 83370,
 -49398,
 1057494839,
 83369,
 -49397,
 1057560130,
 83368,
 -49396,
 1057625454,
 83367,
 -49395,
 1057690704,
 83366,
 -49394,
 1057755947,
 83365,
 -1,
 1057820907,
 83362,
 1058029339,
 1057166914,
 -1,
 1058094866,
 1057954200,
 83348,
 -1,
 1058019914,
 83349,
 -49389,
 1058019559,
 83347,
 -49388,
 1058150407,
 83346,
 -49387,
 1058215735,
 83345,
 -49386,
 1058281026,
 83344,
 -49385,
 1058346350,
 83343,
 -49384,
 1058411600,
 83342,
 -49383,
 1058476843,
 83341,
 -49382,
 1058542075,
 83340,
 -1,
 1058607339,
 83339,
 1058815783,
 1057952555,
 -1,
 1058881310,
 1058740632,
 83312,
 -1,
 1058806346,
 83313,
 -49377,
 1058805991,
 83311,
 -49376,
 1058936839,
 83310,
 -49375,
 1059002167,
 83309,
 -49374,
 1059067458,
 83308,
 -49373,
 1059132782,
 83307,
 -49372,
 1059198032,
 83306,
 -49371,
 1059263275,
 83305,
 -49370,
 1059328507,
 83304,
 -1,
 1059393771,
 83303,
 1059602227,
 1058738411,
 -1,
 1059667754,
 1059527064,
 83291,
 -1,
 1059592778,
 83292,
 -49365,
 1059592423,
 83290,
 -49364,
 1059723271,
 83289,
 -49363,
 1059788599,
 83288,
 -49362,
 1059853890,
 83287,
 -49361,
 1059919214,
 83286,
 -49360,
 1059984464,
 83285,
 -49359,
 1060049707,
 83284,
 -49358,
 1060114939,
 83283,
 -1,
 1060180203,
 83282,
 1060388670,
 1059527064,
 -1,
 -49355,
 1060313496,
 83395,
 -49354,
 1060378855,
 83394,
 -49353,
 1060444167,
 83393,
 -49352,
 1060509495,
 83392,
 -49351,
 1060574786,
 83391,
 -49350,
 1060640110,
 83390,
 -49349,
 1060705399,
 83389,
 -49348,
 1060770603,
 83388,
 -49347,
 1060835835,
 83387,
 -1,
 1060901099,
 83386,
 1061109577,
 1060312430,
 -1,
 -49344,
 1061034392,
 83338,
 -49343,
 1061099751,
 83337,
 -49342,
 1061165063,
 83336,
 -49341,
 1061230391,
 83335,
 -49340,
 1061295682,
 83334,
 -49339,
 1061361006,
 83333,
 -49338,
 1061426256,
 83332,
 -49337,
 1061491499,
 83331,
 -49336,
 1061556731,
 83330,
 -1,
 1061621995,
 83329,
 1061879807,
 1061032443,
 -1,
 -49333,
 1061755288,
 83302,
 -49332,
 1061820647,
 83301,
 -49331,
 1061885959,
 83300,
 -49330,
 1061951287,
 83299,
 -49329,
 1062016578,
 83298,
 -49328,
 1062081902,
 83297,
 -49327,
 1062147152,
 83296,
 -49326,
 1062212395,
 83295,
 -49325,
 1062277627,
 83294,
 -1,
 1062342891,
 83293,
 1062551502,
 1054151467,
 -1,
 1062616932,
 1062473963,
 -1,
 1062682457,
 1062540075,
 83173,
 -49320,
 1062611207,
 83175,
 -1,
 1062672970,
 83174,
 1062879067,
 1062607256,
 83183,
 -1,
 1062804042,
 83184,
 1063010141,
 1062803463,
 83180,
 -1,
 1062935114,
 83181,
 -49314,
 1062934759,
 83182,
 -49313,
 1063065399,
 83179,
 -49312,
 1063130690,
 83178,
 -49311,
 1063196014,
 83177,
 -49310,
 1063261264,
 83176,
 -49309,
 1063326203,
 83172,
 -1,
 1063391467,
 83171,
 1063599985,
 1062541720,
 -1,
 1063665511,
 1063524760,
 83280,
 -1,
 1063590474,
 83281,
 1063796585,
 1063589230,
 83274,
 -1,
 1063721546,
 83275,
 -49302,
 1063721191,
 83279,
 -49301,
 1063852039,
 83278,
 -49300,
 1063917367,
 83277,
 -49299,
 1063982658,
 83276,
 -49298,
 1064047696,
 83273,
 -49297,
 1064112939,
 83272,
 -49296,
 1064178171,
 83271,
 -1,
 1064243435,
 83270,
 1064451966,
 1063522811,
 -1,
 1064517492,
 1064376119,
 83192,
 -1,
 1064442442,
 83193,
 1064648566,
 1064441410,
 83190,
 -1,
 1064573514,
 83191,
 -49289,
 1064573336,
 83196,
 -49288,
 1064704231,
 83195,
 -49287,
 1064769543,
 83194,
 -49286,
 1064834414,
 83189,
 -49285,
 1064899664,
 83188,
 -49284,
 1064964907,
 83187,
 -49283,
 1065030139,
 83186,
 -1,
 1065095403,
 83185,
 1065303946,
 1064376551,
 -1,
 1065369473,
 1065228696,
 83268,
 -1,
 1065294410,
 83269,
 -49278,
 1065294055,
 83267,
 -49277,
 1065424903,
 83266,
 -49276,
 1065490231,
 83265,
 -49275,
 1065555522,
 83264,
 -49274,
 1065620846,
 83263,
 -49273,
 1065686096,
 83262,
 -49272,
 1065751339,
 83261,
 -49271,
 1065816571,
 83260,
 -1,
 1065881835,
 83259,
 1066090390,
 1065228087,
 -1,
 1066155917,
 1066014727,
 83245,
 -1,
 1066080842,
 83246,
 -49266,
 1066080664,
 83248,
 -49265,
 1066211559,
 83247,
 -49264,
 1066276663,
 83244,
 -49263,
 1066341954,
 83243,
 -49262,
 1066407278,
 83242,
 -49261,
 1066472528,
 83241,
 -49260,
 1066537771,
 83240,
 -49259,
 1066603003,
 83239,
 -1,
 1066668267,
 83238,
 1066876834,
 1066013483,
 -1,
 1066942361,
 1066801159,
 83204,
 -1,
 1066867274,
 83205,
 -49254,
 1066867096,
 83207,
 -49253,
 1066997991,
 83206,
 -49252,
 1067063095,
 83203,
 -49251,
 1067128386,
 83202,
 -49250,
 1067193710,
 83201,
 -49249,
 1067258960,
 83200,
 -49248,
 1067324203,
 83199,
 -49247,
 1067389435,
 83198,
 -1,
 1067454699,
 83197,
 1067663277,
 1066801159,
 -1,
 -49244,
 1067587992,
 83258,
 -49243,
 1067653351,
 83257,
 -49242,
 1067718663,
 83256,
 -49241,
 1067783991,
 83255,
 -49240,
 1067849282,
 83254,
 -49239,
 1067914606,
 83253,
 -49238,
 1067979856,
 83252,
 -49237,
 1068045099,
 83251,
 -49236,
 1068110331,
 83250,
 -1,
 1068175595,
 83249,
 1068384184,
 1067587138,
 -1,
 -49233,
 1068308888,
 83237,
 -49232,
 1068374247,
 83236,
 -49231,
 1068439559,
 83235,
 -49230,
 1068504887,
 83234,
 -49229,
 1068570178,
 83233,
 -49228,
 1068635502,
 83232,
 -49227,
 1068700752,
 83231,
 -49226,
 1068765995,
 83230,
 -49225,
 1068831227,
 83229,
 -1,
 1068896491,
 83228,
 1069105091,
 1068307822,
 -1,
 -49222,
 1069029784,
 83227,
 -49221,
 1069095143,
 83226,
 -49220,
 1069160455,
 83225,
 -49219,
 1069225783,
 83224,
 -49218,
 1069291074,
 83223,
 -49217,
 1069356398,
 83222,
 -49216,
 1069421648,
 83221,
 -49215,
 1069486891,
 83220,
 -49214,
 1069552123,
 83219,
 -1,
 1069617387,
 83218,
 1069875199,
 1069028432,
 -1,
 -49211,
 1069750680,
 83217,
 -49210,
 1069816039,
 83216,
 -49209,
 1069881351,
 83215,
 -49208,
 1069946679,
 83214,
 -49207,
 1070011970,
 83213,
 -49206,
 1070077294,
 83212,
 -49205,
 1070142544,
 83211,
 -49204,
 1070207787,
 83210,
 -49203,
 1070273019,
 83209,
 -1,
 1070338283,
 83208,
 1070547016,
 1062473963,
 -1,
 1070612446,
 1070470510,
 -1,
 1070677971,
 1070536503,
 82994,
 -49198,
 1070606599,
 82996,
 -1,
 1070668362,
 82995,
 1070874581,
 1070601794,
 82992,
 -1,
 1070799434,
 82993,
 1071005655,
 1070797307,
 82987,
 -1,
 1070930506,
 82988,
 -49192,
 1070930328,
 82999,
 -49191,
 1071061223,
 82998,
 -49190,
 1071126535,
 82997,
 -49189,
 1071191406,
 82991,
 -49188,
 1071256656,
 82990,
 -49187,
 1071321899,
 82989,
 -1,
 1071386859,
 82986,
 1071595500,
 1070536503,
 -1,
 1071661027,
 1071519543,
 83016,
 -49183,
 1071591336,
 83019,
 -49182,
 1071655175,
 83018,
 -1,
 1071716938,
 83017,
 -49180,
 1071585688,
 83022,
 -49179,
 1071847655,
 83021,
 -49178,
 1071912967,
 83020,
 -49177,
 1071978050,
 83015,
 -49176,
 1072043374,
 83014,
 -49175,
 1072108624,
 83013,
 -49174,
 1072173867,
 83012,
 -49173,
 1072239099,
 83011,
 -1,
 1072304363,
 83010,
 1072513017,
 1071520152,
 -1,
 1072578543,
 1072437479,
 83052,
 -1,
 1072503370,
 83053,
 1072709617,
 1072502791,
 83050,
 -1,
 1072634442,
 83051,
 -49166,
 1072634264,
 83054,
 -49165,
 1072764727,
 83049,
 -49164,
 1072830018,
 83048,
 -49163,
 1072895342,
 83047,
 -49162,
 1072960592,
 83046,
 -49161,
 1073025835,
 83045,
 -49160,
 1073091067,
 83044,
 -1,
 1073156331,
 83043,
 1073364997,
 1072436304,
 -1,
 1073430524,
 1073289624,
 82984,
 -1,
 1073355338,
 82985,
 -49155,
 1073354983,
 82983,
 -49154,
 1073485831,
 82982,
 -49153,
 1073551159,
 82981,
 -49152,
 1073616450,
 82980,
 -49151,
 1073681774,
 82979,
 -49150,
 1073747024,
 82978,
 -49149,
 1073812267,
 82977,
 -49148,
 1073877499,
 82976,
 -1,
 1073942763,
 82975,
 1074151441,
 1073287979,
 -1,
 1074216968,
 1074075447,
 82970,
 -1,
 1074141770,
 82971,
 -49143,
 1074141592,
 82974,
 -49142,
 1074272487,
 82973,
 -49141,
 1074337799,
 82972,
 -49140,
 1074402882,
 82969,
 -49139,
 1074468206,
 82968,
 -49138,
 1074533456,
 82967,
 -49137,
 1074598699,
 82966,
 -49136,
 1074663931,
 82965,
 -1,
 1074729195,
 82964,
 1074937885,
 1074074107,
 -1,
 1075003412,
 1074860267,
 82953,
 -1,
 1074928202,
 82954,
 -49131,
 1074928024,
 82963,
 -49130,
 1075058919,
 82962,
 -49129,
 1075124231,
 82961,
 -49128,
 1075189559,
 82960,
 -49127,
 1075254850,
 82959,
 -49126,
 1075320174,
 82958,
 -49125,
 1075385424,
 82957,
 -49124,
 1075450667,
 82956,
 -1,
 1075515899,
 82955,
 1075724328,
 1074862311,
 -1,
 -49121,
 1075648920,
 83042,
 -49120,
 1075714279,
 83041,
 -49119,
 1075779591,
 83040,
 -49118,
 1075844919,
 83039,
 -49117,
 1075910210,
 83038,
 -49116,
 1075975534,
 83037,
 -49115,
 1076040784,
 83036,
 -49114,
 1076106027,
 83035,
 -49113,
 1076171259,
 83034,
 -1,
 1076236523,
 83033,
 1076445235,
 1075648519,
 -1,
 -49110,
 1076369816,
 83032,
 -49109,
 1076435175,
 83031,
 -49108,
 1076500487,
 83030,
 -49107,
 1076565815,
 83029,
 -49106,
 1076631106,
 83028,
 -49105,
 1076696430,
 83027,
 -49104,
 1076761680,
 83026,
 -49103,
 1076826923,
 83025,
 -49102,
 1076892155,
 83024,
 -1,
 1076957419,
 83023,
 1077166142,
 1076368962,
 -1,
 -49099,
 1077090712,
 83009,
 -49098,
 1077156071,
 83008,
 -49097,
 1077221383,
 83007,
 -49096,
 1077286711,
 83006,
 -49095,
 1077352002,
 83005,
 -49094,
 1077417326,
 83004,
 -49093,
 1077482576,
 83003,
 -49092,
 1077547819,
 83002,
 -49091,
 1077613051,
 83001,
 -1,
 1077678315,
 83000,
 1077936127,
 1077088491,
 -1,
 -49088,
 1077811608,
 82952,
 -49087,
 1077876967,
 82951,
 -49086,
 1077942279,
 82950,
 -49085,
 1078007607,
 82949,
 -49084,
 1078072898,
 82948,
 -49083,
 1078138222,
 82947,
 -49082,
 1078203472,
 82946,
 -49081,
 1078268715,
 82945,
 -1,
 1078333947,
 82944,
 1078542521,
 1070470510,
 -1,
 1078607958,
 1078466114,
 -1,
 1078673484,
 1078532103,
 83455,
 -1,
 1078598218,
 83456,
 1078804558,
 1078595819,
 83447,
 -1,
 1078729290,
 83448,
 -49073,
 1078729112,
 83458,
 -49072,
 1078860007,
 83457,
 -49071,
 1078925111,
 83454,
 -49070,
 1078990402,
 83453,
 -49069,
 1079055726,
 83452,
 -49068,
 1079120976,
 83451,
 -49067,
 1079186219,
 83450,
 -1,
 1079251451,
 83449,
 1079459939,
 1078530555,
 -1,
 1079525466,
 1079382251,
 -1,
 -49063,
 1079450191,
 83407,
 -1,
 1079509331,
 83406,
 -49061,
 1079450008,
 83416,
 -49060,
 1079646439,
 83415,
 -49059,
 1079711751,
 83414,
 -49058,
 1079777079,
 83413,
 -49057,
 1079842370,
 83412,
 -49056,
 1079907694,
 83411,
 -49055,
 1079972944,
 83410,
 -49054,
 1080038187,
 83409,
 -1,
 1080103419,
 83408,
 1080311918,
 1079384295,
 -1,
 -49051,
 1080236440,
 83488,
 -49050,
 1080301799,
 83487,
 -49049,
 1080367111,
 83486,
 -49048,
 1080432439,
 83485,
 -49047,
 1080497730,
 83484,
 -49046,
 1080563054,
 83483,
 -49045,
 1080628304,
 83482,
 -49044,
 1080693547,
 83481,
 -49043,
 1080758779,
 83480,
 -1,
 1080824043,
 83479,
 1081032825,
 1080236039,
 -1,
 -49040,
 1080957336,
 83478,
 -49039,
 1081022695,
 83477,
 -49038,
 1081088007,
 83476,
 -49037,
 1081153335,
 83475,
 -49036,
 1081218626,
 83474,
 -49035,
 1081283950,
 83473,
 -49034,
 1081349200,
 83472,
 -49033,
 1081414443,
 83471,
 -49032,
 1081479675,
 83470,
 -1,
 1081544939,
 83469,
 1081753732,
 1080956727,
 -1,
 -49029,
 1081678232,
 83468,
 -49028,
 1081743591,
 83467,
 -49027,
 1081808903,
 83466,
 -49026,
 1081874231,
 83465,
 -49025,
 1081939522,
 83464,
 -49024,
 1082004846,
 83463,
 -49023,
 1082070096,
 83462,
 -49022,
 1082135339,
 83461,
 -49021,
 1082200571,
 83460,
 -1,
 1082265835,
 83459,
 1082474639,
 1081677166,
 -1,
 -49018,
 1082399128,
 83446,
 -49017,
 1082464487,
 83445,
 -49016,
 1082529799,
 83444,
 -49015,
 1082595127,
 83443,
 -49014,
 1082660418,
 83442,
 -49013,
 1082725742,
 83441,
 -49012,
 1082790992,
 83440,
 -49011,
 1082856235,
 83439,
 -49010,
 1082921467,
 83438,
 -1,
 1082986731,
 83437,
 1083195546,
 1082397776,
 -1,
 -49007,
 1083120024,
 83436,
 -49006,
 1083185383,
 83435,
 -49005,
 1083250695,
 83434,
 -49004,
 1083316023,
 83433,
 -49003,
 1083381314,
 83432,
 -49002,
 1083446638,
 83431,
 -49001,
 1083511888,
 83430,
 -49000,
 1083577131,
 83429,
 -48999,
 1083642363,
 83428,
 -1,
 1083707627,
 83427,
 1083916453,
 1083118379,
 -1,
 -48996,
 1083840920,
 83426,
 -48995,
 1083906279,
 83425,
 -48994,
 1083971591,
 83424,
 -48993,
 1084036919,
 83423,
 -48992,
 1084102210,
 83422,
 -48991,
 1084167534,
 83421,
 -48990,
 1084232784,
 83420,
 -48989,
 1084298027,
 83419,
 -48988,
 1084363259,
 83418,
 -1,
 1084428523,
 83417,
 1084637360,
 1083838699,
 -1,
 -48985,
 1084561816,
 83405,
 -48984,
 1084627175,
 83404,
 -48983,
 1084692487,
 83403,
 -48982,
 1084757815,
 83402,
 -48981,
 1084823106,
 83401,
 -48980,
 1084888430,
 83400,
 -48979,
 1084953680,
 83399,
 -48978,
 1085018923,
 83398,
 -48977,
 1085084155,
 83397,
 -1,
 1085149419,
 83396,
 1085407231,
 1084561816,
 -1,
 -48974,
 1085282311,
 83496,
 -48973,
 1085347639,
 83495,
 -48972,
 1085412930,
 83494,
 -48971,
 1085478254,
 83493,
 -48970,
 1085543504,
 83492,
 -48969,
 1085608747,
 83491,
 -48968,
 1085673979,
 83490,
 -1,
 1085739243,
 83489,
 1085997055,
 1078466114,
 -1,
 1086013637,
 1085870891,
 -1,
 -48964,
 1085938072,
 83525,
 -48963,
 1086003431,
 83524,
 -48962,
 1086068743,
 83523,
 -48961,
 1086134071,
 83522,
 -48960,
 1086199362,
 83521,
 -48959,
 1086264686,
 83520,
 -48958,
 1086329936,
 83519,
 -48957,
 1086395179,
 83518,
 -48956,
 1086460411,
 83517,
 -1,
 1086525675,
 83516,
 1086734544,
 1085936123,
 -1,
 -48953,
 1086658968,
 83515,
 -48952,
 1086724327,
 83514,
 -48951,
 1086789639,
 83513,
 -48950,
 1086854967,
 83512,
 -48949,
 1086920258,
 83511,
 -48948,
 1086985582,
 83510,
 -48947,
 1087050832,
 83509,
 -48946,
 1087116075,
 83508,
 -48945,
 1087181307,
 83507,
 -1,
 1087246571,
 83506,
 1087455450,
 1086656747,
 -1,
 -48942,
 1087379864,
 83505,
 -48941,
 1087445223,
 83504,
 -48940,
 1087510535,
 83503,
 -48939,
 1087575863,
 83502,
 -48938,
 1087641154,
 83501,
 -48937,
 1087706478,
 83500,
 -48936,
 1087771728,
 83499,
 -48935,
 1087836971,
 83498,
 -1,
 1087902203,
 83497,
 -1,
 1087378763,
 83526,
 -1,
 1045794343,
 129728,
 1088241894,
 1045745654,
 128028,
 1088307429,
 1088186767,
 -1,
 1088372964,
 1088280805,
 -1,
 -48928,
 1088345990,
 11151,
 -48927,
 1088404441,
 11148,
 -48926,
 1088463382,
 11119,
 -48925,
 1088520418,
 11150,
 -1,
 1088564757,
 11149,
 -1,
 1088308065,
 128260,
 -1,
 1088244686,
 128246,
 1088897258,
 1088182355,
 -1,
 -48920,
 1088872305,
 128551,
 -48919,
 1088930222,
 128544,
 -1,
 1088965992,
 128162,
 -1,
 1088828309,
 9875,
 1089225448,
 1045672930,
 -1,
 1089290971,
 1089149853,
 -1,
 1089356501,
 1089208320,
 -1,
 1089421741,
 1089309090,
 -1,
 1089487274,
 1089393588,
 -1,
 1089552665,
 1089420117,
 -1,
 1089618198,
 1089510081,
 -1,
 1089683729,
 1089592946,
 -1,
 1089749241,
 1089654774,
 -1,
 1089814775,
 1089691068,
 -1,
 -48906,
 1089751380,
 126646,
 -1,
 1089806180,
 126648,
 -48904,
 1089751380,
 126645,
 -1,
 1089936933,
 126632,
 1090142461,
 1089716692,
 -1,
 -48901,
 1090085246,
 126644,
 -48900,
 1090144320,
 126638,
 -1,
 1090198673,
 126641,
 1090404608,
 1090123379,
 -1,
 -48897,
 1090350395,
 126630,
 -1,
 1090411964,
 126650,
 1090601219,
 1090337792,
 -1,
 -48894,
 1090550843,
 126627,
 -1,
 1090599765,
 126649,
 -48892,
 1090581595,
 126633,
 -48891,
 1090776017,
 126629,
 -48890,
 1090828318,
 126643,
 -48889,
 1090892341,
 126642,
 -48888,
 1090951159,
 126637,
 -48887,
 1091013948,
 126636,
 -48886,
 1091075433,
 126635,
 -48885,
 1091140198,
 126647,
 -48884,
 1091205020,
 126626,
 -48883,
 1091264009,
 126631,
 -48882,
 1091328724,
 126651,
 -48881,
 1091392217,
 126640,
 -48880,
 1091447506,
 126625,
 -1,
 1091509898,
 126639,
 1091764223,
 1089656536,
 -1,
 -48877,
 1091678773,
 126495,
 -48876,
 1091737591,
 126493,
 -48875,
 1091785433,
 126494,
 -1,
 1091840722,
 126492,
 1092091903,
 1089542730,
 -1,
 -48872,
 1091992635,
 126467,
 -1,
 1092041557,
 126489,
 1092239678,
 1089502267,
 -1,
 1092305213,
 1092198818,
 -1,
 1092370721,
 1092276214,
 -1,
 1092436255,
 1092312508,
 -1,
 -48866,
 1092372820,
 126614,
 -1,
 1092427620,
 126616,
 -48864,
 1092372820,
 126613,
 -1,
 1092558373,
 126600,
 1092763941,
 1092338132,
 -1,
 -48861,
 1092706686,
 126612,
 -48860,
 1092765760,
 126606,
 -1,
 1092820113,
 126609,
 1093026088,
 1092744819,
 -1,
 -48857,
 1092971835,
 126598,
 -1,
 1093033404,
 126618,
 1093222699,
 1092967868,
 -1,
 -48854,
 1093159252,
 126596,
 -1,
 1093213733,
 126599,
 1093419310,
 1093155840,
 -1,
 -48851,
 1093368891,
 126595,
 -1,
 1093417813,
 126617,
 1093615921,
 1093343818,
 -1,
 -48848,
 1093566453,
 126592,
 -1,
 1093627195,
 126607,
 -48846,
 1093596251,
 126601,
 -48845,
 1093790673,
 126597,
 -48844,
 1093842974,
 126611,
 -48843,
 1093906997,
 126610,
 -48842,
 1093965815,
 126605,
 -48841,
 1094028604,
 126604,
 -48840,
 1094090089,
 126603,
 -48839,
 1094154854,
 126615,
 -48838,
 1094219676,
 126594,
 -48837,
 1094277844,
 126619,
 -48836,
 1094341337,
 126608,
 -1,
 1094396626,
 126593,
 -1,
 1092231384,
 126475,
 1094664544,
 1092207060,
 -1,
 1094730077,
 1094637700,
 -1,
 1094795588,
 1094701046,
 -1,
 -48830,
 1094738307,
 126582,
 -48829,
 1094797652,
 126581,
 -1,
 1094852133,
 126568,
 1095057736,
 1094762964,
 -1,
 -48826,
 1095000446,
 126580,
 -48825,
 1095059520,
 126574,
 -1,
 1095113873,
 126577,
 1095319885,
 1094990677,
 -1,
 1095385420,
 1095279923,
 -1,
 -48821,
 1095324377,
 126590,
 -1,
 1095379666,
 126588,
 -1,
 1095310481,
 126585,
 1095647568,
 1095268448,
 -1,
 -48817,
 1095589385,
 126583,
 -1,
 1095638387,
 126570,
 1095844179,
 1095589308,
 -1,
 -48814,
 1095780692,
 126564,
 -1,
 1095835173,
 126567,
 -48812,
 1095825014,
 126586,
 -48811,
 1096021083,
 126569,
 -48810,
 1096069685,
 126578,
 -48809,
 1096128503,
 126573,
 -48808,
 1096191292,
 126572,
 -48807,
 1096251292,
 126562,
 -48806,
 1096309460,
 126587,
 -48805,
 1096372953,
 126576,
 -48804,
 1096428242,
 126561,
 -1,
 1096490634,
 126575,
 -48802,
 1094672766,
 126484,
 -48801,
 1096632384,
 126478,
 -1,
 1096686737,
 126481,
 1096892793,
 1094611053,
 -1,
 1096958309,
 1096860116,
 -1,
 -48797,
 1096900990,
 126516,
 -48796,
 1096960064,
 126510,
 -1,
 1097014417,
 126513,
 1097220456,
 1096929270,
 -1,
 -48793,
 1097163139,
 126518,
 -1,
 1097222484,
 126517,
 1097417067,
 1097168992,
 -1,
 -48790,
 1097358857,
 126519,
 -1,
 1097407859,
 126506,
 1097613678,
 1097358780,
 -1,
 -48787,
 1097550164,
 126500,
 -1,
 1097604645,
 126503,
 -48785,
 1097593947,
 126505,
 -48784,
 1097773621,
 126514,
 -48783,
 1097832439,
 126509,
 -48782,
 1097895228,
 126508,
 -48781,
 1097956713,
 126507,
 -48780,
 1098020764,
 126498,
 -48779,
 1098078932,
 126523,
 -48778,
 1098142425,
 126512,
 -48777,
 1098202157,
 126521,
 -48776,
 1098263250,
 126497,
 -1,
 1098325642,
 126511,
 1098531219,
 1096863734,
 -1,
 1098596751,
 1098455626,
 -1,
 1098662286,
 1098542260,
 -1,
 1098727808,
 1098629588,
 -1,
 -48770,
 1098670462,
 126548,
 -48769,
 1098729536,
 126542,
 -1,
 1098783889,
 126545,
 1098989957,
 1098660693,
 -1,
 1099055492,
 1098949939,
 -1,
 -48765,
 1099018805,
 126559,
 -1,
 1099077623,
 126557,
 -1,
 1098980497,
 126553,
 -48762,
 1098970203,
 126537,
 -48761,
 1099280949,
 126546,
 -48760,
 1099339767,
 126541,
 -48759,
 1099398505,
 126539,
 -48758,
 1099463270,
 126551,
 -48757,
 1099528092,
 126530,
 -48756,
 1099587081,
 126535,
 -48755,
 1099651796,
 126555,
 -1,
 1099701898,
 126543,
 -1,
 1098603964,
 126472,
 1099973010,
 1098538428,
 -1,
 -48751,
 1099909460,
 126486,
 -1,
 1099964260,
 126488,
 -1,
 1099909460,
 126485,
 1100235158,
 1098511987,
 -1,
 -48747,
 1100180795,
 126470,
 -1,
 1100242364,
 126490,
 1100431769,
 1100194430,
 -1,
 -48744,
 1100385612,
 126704,
 -1,
 1100439053,
 126705,
 1100628380,
 1100380256,
 -1,
 -48741,
 1100570121,
 126487,
 -1,
 1100619123,
 126474,
 1100824991,
 1100552778,
 -1,
 -48738,
 1100775413,
 126464,
 -1,
 1100836155,
 126479,
 -48736,
 1100805211,
 126473,
 -48735,
 1100999633,
 126469,
 -48734,
 1101051934,
 126483,
 -48733,
 1101115957,
 126482,
 -48732,
 1101174775,
 126477,
 -48731,
 1101237564,
 126476,
 -48730,
 1101297564,
 126466,
 -48729,
 1101356553,
 126471,
 -48728,
 1101421268,
 126491,
 -48727,
 1101484761,
 126480,
 -1,
 1101540050,
 126465,
 1101791231,
 1089453776,
 -1,
 -48724,
 1101711290,
 2303,
 -1,
 1101764615,
 1624,
 1101939276,
 1089371195,
 -1,
 1102004811,
 1101874370,
 -1,
 1102070344,
 1101978219,
 -1,
 1102135742,
 1101998806,
 -1,
 1102201271,
 1102106614,
 -1,
 1102266806,
 1102145105,
 -1,
 1102332341,
 1102229337,
 1874,
 -1,
 1102250164,
 1875,
 -1,
 1102275943,
 1872,
 -1,
 1102246009,
 1876,
 1102594491,
 1102170449,
 -1,
 1102660026,
 1102570906,
 1878,
 -1,
 1102578024,
 2208,
 -1,
 1102613825,
 2230,
 -48708,
 1102541472,
 1877,
 -48707,
 1102798643,
 2209,
 -1,
 1102856248,
 1873,
 1103053262,
 1102060106,
 -1,
 1103118790,
 1102998892,
 -1,
 1103184323,
 1103097940,
 -1,
 -48702,
 1103161381,
 1887,
 -1,
 1103174562,
 1885,
 1103429631,
 1103128145,
 -1,
 -48699,
 1103343398,
 1886,
 -1,
 1103375085,
 2227,
 1103577547,
 1103058831,
 -1,
 1103643081,
 1103540789,
 2236,
 -1,
 1103564520,
 2244,
 -48694,
 1103599607,
 2237,
 -1,
 1103712985,
 2235,
 1103953919,
 1103527929,
 -1,
 -48691,
 1103884346,
 1907,
 -1,
 1103914538,
 1908,
 1104101853,
 1103001696,
 -1,
 1104167384,
 1104038274,
 -1,
 1104232918,
 1104138230,
 -1,
 1104298453,
 1104176721,
 -1,
 -48685,
 1104260953,
 1892,
 -48684,
 1104292589,
 1596,
 -1,
 1104354210,
 1891,
 -1,
 1104277597,
 1595,
 -48681,
 1104202335,
 2242,
 -1,
 1104560129,
 1890,
 1104805887,
 1104091722,
 -1,
 1104822748,
 1104695844,
 -1,
 -48677,
 1104796645,
 1919,
 -1,
 1104822318,
 2228,
 -1,
 1104791245,
 1568,
 1105084909,
 1104040435,
 -1,
 1105150440,
 1105012244,
 -1,
 1105215972,
 1105088801,
 -1,
 1105281507,
 1105186806,
 -1,
 -48670,
 1105260602,
 1909,
 -1,
 1105290794,
 1910,
 -1,
 1105221239,
 1911,
 1105543655,
 1105186806,
 -1,
 -48666,
 1105522781,
 1598,
 -1,
 1105552988,
 1599,
 -1,
 1105490615,
 1597,
 1105854463,
 1105086807,
 -1,
 1105871340,
 1105776630,
 -1,
 -48661,
 1105850475,
 1888,
 -1,
 1105880700,
 1889,
 -1,
 1105805368,
 2212,
 1106133497,
 1105048546,
 -1,
 1106199032,
 1106069847,
 -1,
 1106264564,
 1106166228,
 -1,
 1106330099,
 1106217613,
 -1,
 -48654,
 1106286588,
 2233,
 -1,
 1106322521,
 1905,
 -1,
 1106303473,
 1883,
 -48651,
 1106238501,
 1899,
 -48650,
 1106544286,
 2218,
 -48649,
 1106604727,
 1775,
 -1,
 1106665267,
 1900,
 -1,
 1106156729,
 2220,
 1106919938,
 1106100692,
 -1,
 1106985472,
 1106856004,
 -1,
 -48644,
 1106959397,
 1901,
 -48643,
 1107020175,
 1904,
 -48642,
 1107063479,
 1918,
 -48641,
 1107121838,
 1884,
 -1,
 1107185982,
 1917,
 -48639,
 1106958360,
 2225,
 -1,
 1107303580,
 2223,
 1107509774,
 1106861500,
 -1,
 1107575309,
 1107435048,
 -1,
 1107640841,
 1107544408,
 -1,
 1107706376,
 1107565130,
 -1,
 -48633,
 1107661829,
 1903,
 -1,
 1107701299,
 1906,
 -1,
 1107634925,
 1902,
 1107968524,
 1107611638,
 -1,
 -48629,
 1107947613,
 1879,
 -1,
 1107977852,
 1880,
 -1,
 1107906917,
 1916,
 -1,
 1107511648,
 1791,
 1108296214,
 1107489887,
 -1,
 1108361747,
 1108275061,
 -1,
 -48623,
 1108331032,
 2234,
 -48622,
 1108369203,
 2216,
 -1,
 1108426753,
 2217,
 1108672511,
 1108290084,
 -1,
 -48619,
 1108602938,
 1914,
 -1,
 1108633130,
 1915,
 1108820509,
 1108266998,
 -1,
 1108886042,
 1108756851,
 -1,
 -48615,
 1108862362,
 2239,
 -1,
 1108922970,
 2232,
 -48613,
 1108857444,
 2240,
 -48612,
 1109013243,
 2241,
 -1,
 1109073457,
 2211,
 1109279268,
 1108773196,
 -1,
 1109344803,
 1109215286,
 -1,
 1109410338,
 1109278716,
 -1,
 -48607,
 1109338861,
 1894,
 -1,
 1109400482,
 1893,
 -1,
 1109382274,
 2215,
 -1,
 1109271802,
 1564,
 1109738026,
 1109228603,
 -1,
 1109803561,
 1109663963,
 -1,
 -48601,
 1109772657,
 2247,
 -48600,
 1109803342,
 2214,
 -1,
 1109862862,
 1898,
 -1,
 1109764345,
 2221,
 1110131249,
 1109670978,
 -1,
 1110196782,
 1110102006,
 -1,
 -48595,
 1110175893,
 1881,
 -1,
 1110206060,
 2222,
 1110441983,
 1110143483,
 -1,
 -48592,
 1110369690,
 1774,
 -1,
 1110428277,
 1882,
 1110590006,
 1110109141,
 -1,
 1110655541,
 1110528396,
 -1,
 -48588,
 1110634554,
 1912,
 -1,
 1110664746,
 1913,
 -1,
 1110589582,
 2219,
 1110917691,
 1110546451,
 -1,
 1110983226,
 1110886737,
 -1,
 -48583,
 1110959514,
 1897,
 -1,
 1111019735,
 1896,
 -1,
 1110957044,
 1895,
 1111245376,
 1110865825,
 -1,
 1111310911,
 1111189073,
 -1,
 -48578,
 1111239405,
 2246,
 -1,
 1111301026,
 2245,
 -1,
 1111289949,
 2210,
 1111573059,
 1111206949,
 -1,
 -48574,
 1111549338,
 2238,
 -1,
 1111592257,
 2231,
 1111769670,
 1111513171,
 -1,
 -48571,
 1111711277,
 2243,
 -1,
 1111760256,
 2224,
 -48569,
 1111750275,
 2226,
 -1,
 1111929401,
 2213,
 1112145919,
 1102010354,
 -1,
 -48566,
 1112025837,
 2297,
 -1,
 1112087458,
 2295,
 -1,
 1101949671,
 65021,
 1112359581,
 1101906388,
 -1,
 1112425066,
 1112312461,
 -1,
 1112490596,
 1112367815,
 -1,
 1112556122,
 1112468129,
 -1,
 1112621657,
 1112515452,
 -1,
 1112687190,
 1112545866,
 -1,
 -48557,
 1112658773,
 2266,
 -48556,
 1112720021,
 2267,
 -48555,
 1112781874,
 2260,
 -1,
 1112838852,
 2268,
 -48553,
 1112664886,
 2271,
 -48552,
 1112982236,
 2269,
 -1,
 1113043557,
 2270,
 -1,
 1112549541,
 2291,
 1113277021,
 1112523220,
 -1,
 -48548,
 1113222187,
 2273,
 -1,
 1113267345,
 2261,
 -48546,
 1113257598,
 1559,
 -48545,
 1113444567,
 1557,
 -48544,
 1113502261,
 2263,
 -48543,
 1113561118,
 2264,
 -48542,
 1113621422,
 1558,
 -48541,
 1113675220,
 2272,
 -1,
 1113726602,
 2262,
 1113932391,
 1112442631,
 -1,
 -48538,
 1113910225,
 2259,
 -1,
 1113954334,
 2265,
 -48536,
 1113880954,
 1562,
 -48535,
 1114067607,
 1560,
 -1,
 1114127461,
 1561,
 1114325636,
 1112405349,
 -1,
 1114391160,
 1114296310,
 -1,
 1114456690,
 1114370132,
 -1,
 1114522224,
 1114433561,
 -1,
 -48529,
 1114450669,
 64446,
 -1,
 1114512290,
 64445,
 -48527,
 1114450669,
 64437,
 -1,
 1114643362,
 64436,
 1114898431,
 1114400337,
 -1,
 1114915446,
 1114812178,
 -1,
 -48523,
 1114843885,
 64441,
 -1,
 1114905506,
 64440,
 -48521,
 1114843885,
 64439,
 -1,
 1115036578,
 64438,
 1115243133,
 1114324883,
 -1,
 1115308668,
 1115213816,
 -1,
 -48517,
 1115237101,
 64435,
 -1,
 1115298722,
 64434,
 -1,
 1115283034,
 64444,
 1115570816,
 1115212359,
 -1,
 -48513,
 1115499245,
 64449,
 -1,
 1115560866,
 64448,
 1115767427,
 1115510435,
 -1,
 -48510,
 1115695853,
 64443,
 -1,
 1115757474,
 64442,
 -1,
 1115733288,
 64447,
 1116029584,
 1114270722,
 -1,
 1116095114,
 1115996841,
 -1,
 -48505,
 1116050220,
 1537,
 -48504,
 1116115579,
 1540,
 -48503,
 1116177747,
 1552,
 -1,
 1116230497,
 1539,
 1116422797,
 1116058708,
 -1,
 -48500,
 1116365840,
 1554,
 -1,
 1116421712,
 1555,
 -48498,
 1116393763,
 1556,
 -48497,
 1116573725,
 1551,
 -1,
 1116610457,
 1553,
 1116816028,
 1115966710,
 -1,
 1116881563,
 1116796004,
 -1,
 1116947094,
 1116805706,
 -1,
 1117012629,
 1116897269,
 983633,
 -1,
 1116931249,
 983635,
 -1,
 1116947650,
 983640,
 -48489,
 1116927541,
 983638,
 -48488,
 1117187025,
 983634,
 -48487,
 1117248699,
 983637,
 -48486,
 1117297681,
 983636,
 -1,
 1117340866,
 983639,
 -1,
 1116837934,
 983641,
 -1,
 1116790399,
 1622,
 1117668010,
 1112330230,
 -1,
 1117733544,
 1117626141,
 -1,
 1117799074,
 1117707227,
 -1,
 -48479,
 1117727469,
 2286,
 -1,
 1117789090,
 2283,
 1117995685,
 1117757228,
 -1,
 -48476,
 1117924077,
 2285,
 -1,
 1117985698,
 2282,
 1118240767,
 1117947555,
 -1,
 -48473,
 1118120685,
 2287,
 -1,
 1118182306,
 2284,
 -48471,
 1117709344,
 2275,
 -1,
 1118354968,
 1566,
 1118519985,
 1117600473,
 -1,
 1118585517,
 1118468474,
 2278,
 -1,
 1118556529,
 2281,
 1118716591,
 1118524055,
 2276,
 -1,
 1118687601,
 2279,
 1118896127,
 1118649445,
 2277,
 -1,
 1118818673,
 2280,
 1118978744,
 1118483426,
 -1,
 1119044278,
 1118923634,
 -1,
 1119109813,
 1118968738,
 2296,
 -1,
 1119030420,
 2301,
 -1,
 1119038189,
 2298,
 -48457,
 1118982270,
 1629,
 -1,
 1119234248,
 1544,
 1119437503,
 1118911317,
 -1,
 1119503035,
 1119397294,
 2299,
 -1,
 1119423636,
 2300,
 1119634110,
 1119427146,
 -1,
 -48451,
 1119605224,
 1549,
 -1,
 1119653940,
 2302,
 -1,
 1119581370,
 2274,
 1119896261,
 1119375859,
 -1,
 1119961796,
 1119823714,
 -1,
 -48446,
 1119935442,
 1630,
 -48445,
 1119993128,
 2292,
 -1,
 1120026625,
 2293,
 -1,
 1119920580,
 1538,
 1120289481,
 1119873578,
 -1,
 -48441,
 1120258663,
 1626,
 -48440,
 1120301705,
 1627,
 -1,
 1120354350,
 1628,
 1120551629,
 1120248336,
 -1,
 -48437,
 1120500117,
 2290,
 -48436,
 1120555677,
 2288,
 -1,
 1120615531,
 2289,
 1120813776,
 1120508407,
 -1,
 -48433,
 1120782294,
 1536,
 -1,
 1120832365,
 1541,
 -48431,
 1120794618,
 1625,
 -48430,
 1120988096,
 1631,
 -48429,
 1121038005,
 1550,
 -48428,
 1121089920,
 2294,
 -1,
 1121153598,
 1623,
 1121386495,
 1089277898,
 -1,
 1121403609,
 1121299662,
 -1,
 -48424,
 1121374880,
 1546,
 -1,
 1121423227,
 1545,
 -48422,
 1121343283,
 1543,
 -1,
 1121532530,
 1542,
 1121731296,
 1089257551,
 -1,
 1121796831,
 1121650794,
 -1,
 -48418,
 1121772403,
 129200,
 -1,
 1121828058,
 129201,
 -1,
 1121738952,
 129968,
 1122058981,
 1121684900,
 -1,
 1122124516,
 1122028013,
 -1,
 -48413,
 1122104535,
 1416,
 -1,
 1122163451,
 1376,
 -1,
 1122059264,
 1423,
 1122435071,
 1122030897,
 -1,
 -48409,
 1122356398,
 127912,
 -1,
 1122384522,
 128667,
 1122583443,
 1089174587,
 -1,
 1122648972,
 1122513692,
 -1,
 1122714371,
 1122615764,
 -1,
 1122779893,
 1122688187,
 -1,
 1122845428,
 1122708751,
 -1,
 1122910963,
 1122780476,
 -1,
 1122976497,
 1122878213,
 -1,
 -48400,
 1122908213,
 128807,
 -1,
 1122968500,
 128814,
 -48398,
 1122908213,
 128802,
 -1,
 1123099572,
 128812,
 -1,
 1122857676,
 128862,
 -1,
 1122796339,
 128781,
 1123435259,
 1122705252,
 -1,
 1123500794,
 1123405814,
 128788,
 1123614719,
 1123419438,
 -1,
 -48391,
 1123498044,
 128806,
 -1,
 1123558324,
 128813,
 -1,
 1123422051,
 128825,
 1123828479,
 1123405814,
 -1,
 1123894014,
 1123792344,
 128860,
 -1,
 1123815255,
 128861,
 -1,
 1123820962,
 128850,
 -48384,
 1123790248,
 128839,
 -48383,
 1124047650,
 128852,
 -48382,
 1124101323,
 128795,
 -1,
 1124151815,
 128847,
 1124352790,
 1122638410,
 -1,
 1124418315,
 1124315783,
 -1,
 1124483850,
 1124335616,
 -1,
 1124549384,
 1124460844,
 128776,
 -1,
 1124470615,
 128777,
 1124728831,
 1124513816,
 128774,
 -1,
 1124601687,
 128775,
 -1,
 1124423204,
 128773,
 1124877072,
 1124367419,
 -1,
 1124942606,
 1124825385,
 128822,
 -1,
 1124863831,
 128823,
 -48369,
 1124917219,
 128837,
 -1,
 1125010087,
 128874,
 -48367,
 1124852729,
 128829,
 -48366,
 1125172848,
 128855,
 -48365,
 1125236923,
 128826,
 -48364,
 1125292453,
 128811,
 -48363,
 1125354113,
 128859,
 -1,
 1125413682,
 128769,
 1125597994,
 1124282280,
 -1,
 1125663522,
 1125561314,
 -1,
 1125729054,
 1125637839,
 128869,
 1125842943,
 1125650258,
 -1,
 -48357,
 1125717570,
 128873,
 -48356,
 1125782894,
 128872,
 -48355,
 1125848144,
 128871,
 -1,
 1125913387,
 128870,
 1126170623,
 1125686214,
 -1,
 1126187809,
 1126053941,
 128803,
 -1,
 1126109015,
 128804,
 -1,
 1126134799,
 128798,
 1126384422,
 1125587530,
 -1,
 -48348,
 1126347239,
 128846,
 -48347,
 1126402369,
 128844,
 -1,
 1126450257,
 128848,
 1126646569,
 1126343363,
 -1,
 -48344,
 1126605726,
 128800,
 -1,
 1126638504,
 128805,
 -1,
 1126592708,
 128787,
 1126908730,
 1125561314,
 -1,
 1126974264,
 1126843586,
 -1,
 1127039797,
 1126915423,
 128818,
 1127105329,
 1126960978,
 -1,
 -48337,
 1127028078,
 128821,
 -48336,
 1127093328,
 128820,
 -1,
 1127158571,
 128819,
 1127415807,
 1127023918,
 -1,
 1127433012,
 1127293876,
 128816,
 -1,
 1127354199,
 128817,
 -1,
 1127379983,
 128799,
 1127629623,
 1126965241,
 128827,
 -1,
 1127550807,
 128828,
 -1,
 1127602110,
 128877,
 1127874559,
 1126931362,
 128792,
 -1,
 1127747415,
 128793,
 1127957317,
 1126836487,
 -1,
 1128022847,
 1127916395,
 128834,
 1128136703,
 1127944018,
 -1,
 -48322,
 1128010832,
 128836,
 -1,
 1128076075,
 128835,
 1128284994,
 1127950170,
 -1,
 -48319,
 1128261086,
 128876,
 -1,
 1128303593,
 128875,
 -48317,
 1128249949,
 128857,
 -48316,
 1128430798,
 128783,
 -1,
 1128494230,
 128830,
 1128678223,
 1127933338,
 -1,
 1128743758,
 1128622077,
 -1,
 1128809292,
 1128699144,
 128778,
 1128874827,
 1128730450,
 -1,
 -48310,
 1128797264,
 128780,
 -1,
 1128862507,
 128779,
 -1,
 1128793395,
 128815,
 1129185279,
 1128782239,
 128790,
 -1,
 1129058135,
 128791,
 -1,
 1128680848,
 128808,
 1129333593,
 1128638928,
 -1,
 1129399124,
 1129290433,
 -1,
 1129464659,
 1129376781,
 128843,
 -1,
 1129400099,
 128858,
 -1,
 1129435142,
 128856,
 1129661271,
 1129372859,
 -1,
 -48298,
 1129633902,
 128868,
 -1,
 1129691810,
 128867,
 -48296,
 1129625400,
 128863,
 -1,
 1129800492,
 128782,
 1129988961,
 1129304054,
 -1,
 1130054493,
 1129934139,
 -1,
 -48292,
 1129986663,
 128840,
 -1,
 1130038684,
 128809,
 1130251103,
 1129981479,
 128831,
 -1,
 1130172247,
 128832,
 -48288,
 1130227059,
 128845,
 -1,
 1130347106,
 128849,
 1130513256,
 1129941324,
 -1,
 1130578790,
 1130450303,
 128784,
 1130692607,
 1130499922,
 -1,
 -48283,
 1130566736,
 128786,
 -1,
 1130631979,
 128785,
 -48281,
 1130537270,
 128881,
 -1,
 1130767502,
 128824,
 1130972015,
 1130454460,
 -1,
 1131037548,
 1130928833,
 -1,
 -48277,
 1131013030,
 128878,
 -1,
 1131069618,
 128854,
 1131282431,
 1130962914,
 -1,
 -48274,
 1131193852,
 128883,
 -1,
 1131234299,
 128882,
 1131430773,
 1130904405,
 -1,
 1131496308,
 1131377734,
 -1,
 1131561843,
 1131465492,
 128865,
 -1,
 1131482967,
 128866,
 -1,
 1131533796,
 128864,
 -1,
 1131423955,
 128880,
 1131823993,
 1131377679,
 -1,
 1131889528,
 1131742620,
 128796,
 -1,
 1131810647,
 128797,
 -1,
 1131810685,
 128801,
 1132086140,
 1131801313,
 -1,
 -48261,
 1132065328,
 128842,
 -1,
 1132122831,
 128772,
 1132282751,
 1132049328,
 -1,
 -48258,
 1132239249,
 128768,
 -1,
 1132279084,
 128833,
 1132479362,
 1132238499,
 -1,
 -48255,
 1132451931,
 128789,
 -1,
 1132485392,
 128879,
 1132675973,
 1132428347,
 -1,
 -48252,
 1132633065,
 128851,
 -1,
 1132676625,
 128810,
 1132872584,
 1132615763,
 -1,
 -48249,
 1132847075,
 128841,
 -1,
 1132895559,
 128794,
 -48247,
 1132848115,
 128853,
 -48246,
 1133026504,
 128838,
 -48245,
 1133073507,
 128770,
 -1,
 1133135436,
 128771,
 1133331343,
 1122583746,
 -1,
 -48242,
 1133297870,
 983054,
 -1,
 1133349924,
 9879,
 -48240,
 1133302542,
 9941,
 -48239,
 1133480268,
 983201,
 -48238,
 1133537867,
 128126,
 -1,
 1133585743,
 9200,
 1133790218,
 1122515797,
 -1,
 1133855749,
 1133739373,
 -1,
 1133921217,
 1133785000,
 -1,
 1133986752,
 1133847558,
 -1,
 1134052251,
 1133941408,
 -1,
 -48231,
 1134031802,
 125209,
 -48230,
 1134092361,
 125200,
 -1,
 1134124494,
 125211,
 1134314399,
 1134000224,
 -1,
 -48227,
 1134276274,
 125216,
 -48226,
 1134321102,
 125213,
 -1,
 1134370163,
 125201,
 1134576546,
 1134293814,
 -1,
 -48223,
 1134518399,
 125198,
 -1,
 1134565962,
 125202,
 1134773157,
 1134543316,
 -1,
 -48220,
 1134719180,
 125189,
 -1,
 1134779854,
 125217,
 1134969768,
 1134712915,
 -1,
 -48217,
 1134897832,
 125214,
 -1,
 1134959178,
 125208,
 1135166379,
 1134902101,
 -1,
 -48214,
 1135107534,
 125197,
 -1,
 1135155995,
 125185,
 1135362990,
 1135094023,
 -1,
 -48211,
 1135304831,
 125191,
 -1,
 1135352394,
 125188,
 -48209,
 1135343277,
 125215,
 -48208,
 1135537105,
 125199,
 -48207,
 1135601069,
 125212,
 -48206,
 1135664315,
 125203,
 -48205,
 1135729282,
 125210,
 -48204,
 1135785044,
 125192,
 -48203,
 1135850032,
 125207,
 -48202,
 1135913957,
 125190,
 -48201,
 1135975105,
 125196,
 -48200,
 1136037715,
 125187,
 -48199,
 1136098453,
 125186,
 -48198,
 1136162785,
 125204,
 -48197,
 1136224253,
 125195,
 -48196,
 1136287182,
 125206,
 -48195,
 1136349768,
 125194,
 -48194,
 1136411842,
 125193,
 -48193,
 1136472906,
 125205,
 -1,
 1136533503,
 125184,
 -1,
 1133945117,
 125256,
 1136804843,
 1133890029,
 -1,
 1136870342,
 1136759456,
 -1,
 -48188,
 1136849850,
 125243,
 -48187,
 1136910409,
 125234,
 -1,
 1136942542,
 125245,
 1137132490,
 1136818272,
 -1,
 -48184,
 1137094322,
 125250,
 -48183,
 1137139150,
 125247,
 -1,
 1137188211,
 125235,
 1137394637,
 1137111862,
 -1,
 -48180,
 1137336447,
 125232,
 -1,
 1137384010,
 125236,
 1137591248,
 1137361364,
 -1,
 -48177,
 1137537228,
 125223,
 -1,
 1137597902,
 125251,
 1137787859,
 1137530963,
 -1,
 -48174,
 1137715880,
 125248,
 -1,
 1137777226,
 125242,
 1137984470,
 1137720149,
 -1,
 -48171,
 1137925582,
 125231,
 -1,
 1137974043,
 125219,
 1138181081,
 1137912071,
 -1,
 -48168,
 1138122879,
 125225,
 -1,
 1138170442,
 125222,
 -48166,
 1138161325,
 125249,
 -48165,
 1138355153,
 125233,
 -48164,
 1138419117,
 125246,
 -48163,
 1138482363,
 125237,
 -48162,
 1138547330,
 125244,
 -48161,
 1138603092,
 125226,
 -48160,
 1138668080,
 125241,
 -48159,
 1138732005,
 125224,
 -48158,
 1138793153,
 125230,
 -48157,
 1138855763,
 125221,
 -48156,
 1138916501,
 125220,
 -48155,
 1138980833,
 125238,
 -48154,
 1139042301,
 125229,
 -48153,
 1139105230,
 125240,
 -48152,
 1139167816,
 125228,
 -48151,
 1139229890,
 125227,
 -48150,
 1139290954,
 125239,
 -1,
 1139351551,
 125218,
 1139557369,
 1136738029,
 -1,
 1139622895,
 1139527670,
 -1,
 -48146,
 1139601459,
 125266,
 -1,
 1139631647,
 125267,
 1139819506,
 1139589588,
 -1,
 -48143,
 1139766948,
 125270,
 -1,
 1139822564,
 125271,
 1140016117,
 1139757555,
 -1,
 -48140,
 1139975704,
 125268,
 -1,
 1140028906,
 125269,
 -48138,
 1139996464,
 125264,
 -48137,
 1140170521,
 125265,
 -48136,
 1140233966,
 125273,
 -1,
 1140279710,
 125272,
 1140474876,
 1139511968,
 -1,
 -48133,
 1140449167,
 125258,
 -1,
 1140467318,
 125259,
 1140671487,
 1140420717,
 -1,
 -48130,
 1140634503,
 125279,
 -1,
 1140674780,
 125278,
 1140868098,
 1140611605,
 -1,
 -48127,
 1140814544,
 125254,
 -1,
 1140868344,
 125257,
 -48125,
 1140845065,
 125253,
 -48124,
 1141006125,
 125255,
 -1,
 1141055492,
 125252,
 1141261320,
 1133807948,
 -1,
 -48121,
 1141208277,
 127903,
 -1,
 1141264117,
 11237,
 -48119,
 1141235665,
 129489,
 -1,
 1141400038,
 129657,
 1141589082,
 1133732987,
 -1,
 1141654576,
 1141539490,
 -1,
 1141720081,
 1141578314,
 71442,
 1141833727,
 1141672080,
 -1,
 -48113,
 1141756028,
 71429,
 -48112,
 1141790882,
 71446,
 -1,
 1141844280,
 71450,
 1142047765,
 1141674656,
 -1,
 -48109,
 1142027194,
 71440,
 -48108,
 1142053026,
 71426,
 -1,
 1142102602,
 71427,
 1142309912,
 1142018038,
 -1,
 -48105,
 1142250958,
 71436,
 -1,
 1142299210,
 71428,
 1142506523,
 1142270416,
 -1,
 -48102,
 1142447566,
 71431,
 -1,
 1142495818,
 71430,
 1142703134,
 1142454368,
 -1,
 -48099,
 1142644174,
 71425,
 -1,
 1142692426,
 71424,
 1142899745,
 1142650689,
 -1,
 -48096,
 1142840782,
 71449,
 -1,
 1142889034,
 71434,
 1143096356,
 1142839379,
 -1,
 -48093,
 1143037390,
 71447,
 -1,
 1143085642,
 71445,
 1143292967,
 1143028565,
 -1,
 -48090,
 1143233998,
 71444,
 -1,
 1143282250,
 71443,
 1143489578,
 1143220487,
 -1,
 -48087,
 1143430606,
 71448,
 -1,
 1143478858,
 71432,
 -48085,
 1143456425,
 71439,
 -48084,
 1143649364,
 71437,
 -48083,
 1143703970,
 71433,
 -48082,
 1143766149,
 71438,
 -48081,
 1143823822,
 71441,
 -1,
 1143878257,
 71435,
 1144079420,
 1141631530,
 -1,
 1144144950,
 1144003146,
 71456,
 -48077,
 1144122017,
 71463,
 -48076,
 1144162636,
 71466,
 -48075,
 1144219645,
 71465,
 -1,
 1144265290,
 71457,
 1144472632,
 1144118459,
 71460,
 -1,
 1144446139,
 71461,
 1144603706,
 1144416253,
 71458,
 -1,
 1144547325,
 71459,
 -48069,
 1144560321,
 71464,
 -1,
 1144669378,
 71462,
 1144865866,
 1144012525,
 -1,
 1144931392,
 1144836086,
 -1,
 -48065,
 1144909875,
 71474,
 -1,
 1144940063,
 71475,
 1145128003,
 1144898004,
 -1,
 -48062,
 1145075364,
 71478,
 -1,
 1145130980,
 71479,
 1145324614,
 1145065971,
 -1,
 -48059,
 1145284120,
 71476,
 -1,
 1145337322,
 71477,
 -48057,
 1145304880,
 71472,
 -48056,
 1145478937,
 71473,
 -48055,
 1145542382,
 71481,
 -1,
 1145588126,
 71480,
 1145783378,
 1144832468,
 -1,
 1145848913,
 1145728002,
 -1,
 1145914447,
 1145815508,
 -1,
 -48050,
 1145866960,
 71484,
 -1,
 1145915145,
 71485,
 -48048,
 1145880879,
 71486,
 -1,
 1146059462,
 71467,
 -1,
 1145828754,
 71487,
 1146307671,
 1145714632,
 -1,
 1146373206,
 1146256443,
 -1,
 -48043,
 1146317512,
 71455,
 -1,
 1146362442,
 71453,
 -1,
 1146336340,
 71454,
 1146683391,
 1146264075,
 -1,
 -48039,
 1146612817,
 71483,
 -1,
 1146637025,
 71482,
 1146832044,
 1141523650,
 -1,
 1146897579,
 1146771961,
 -1,
 1146963098,
 1146853879,
 -1,
 1147028590,
 1146933238,
 -1,
 1147094117,
 1147005601,
 -1,
 1147159651,
 1147050689,
 65800,
 1147273215,
 1147076608,
 -1,
 -48030,
 1147196468,
 65827,
 -1,
 1147234162,
 65818,
 1147469823,
 1147096154,
 65809,
 -1,
 1147341335,
 65836,
 1147552876,
 1147035068,
 -1,
 1147618410,
 1147516846,
 65801,
 1147731967,
 1147535360,
 -1,
 -48023,
 1147655220,
 65828,
 -1,
 1147692914,
 65819,
 1147928575,
 1147565105,
 65810,
 -1,
 1147800087,
 65837,
 1148059647,
 1147488993,
 65808,
 -1,
 1147931159,
 65835,
 1148142715,
 1146995156,
 -1,
 1148208245,
 1148090020,
 65804,
 1148273778,
 1148181644,
 65813,
 -1,
 1148193303,
 65840,
 1148452863,
 1148190720,
 -1,
 -48012,
 1148376116,
 65831,
 -1,
 1148413810,
 65822,
 1148649471,
 1148145636,
 65805,
 1148667000,
 1148574860,
 65814,
 -1,
 1148586519,
 65841,
 1148846079,
 1148583936,
 -1,
 -48006,
 1148769332,
 65832,
 -1,
 1148807026,
 65823,
 1148994698,
 1148080627,
 -1,
 1149060227,
 1148951233,
 -1,
 1149125761,
 1149035430,
 65802,
 1149239295,
 1149042688,
 -1,
 -48000,
 1149162548,
 65829,
 -1,
 1149200242,
 65820,
 1149435903,
 1149092115,
 65811,
 -1,
 1149307415,
 65838,
 1149566975,
 1149003773,
 -1,
 1149584520,
 1149494924,
 65803,
 1149698047,
 1149501440,
 -1,
 -47993,
 1149621300,
 65830,
 -1,
 1149658994,
 65821,
 1149894655,
 1149524023,
 65812,
 -1,
 1149766167,
 65839,
 1149977744,
 1148950254,
 65807,
 1150043277,
 1149951116,
 65816,
 -1,
 1149962775,
 65843,
 1150222335,
 1149960192,
 -1,
 -47985,
 1150145588,
 65834,
 -1,
 1150183282,
 65825,
 1150370966,
 1149913502,
 65806,
 1150436499,
 1150350134,
 65815,
 -1,
 1150355991,
 65842,
 1150615551,
 1150353408,
 -1,
 -47979,
 1150538804,
 65833,
 -1,
 1150576498,
 65824,
 1150812159,
 1150328601,
 65799,
 1150877695,
 1150681088,
 -1,
 -47975,
 1150800948,
 65826,
 -1,
 1150838642,
 65817,
 1151026341,
 1146940065,
 -1,
 1151091874,
 1150962084,
 -1,
 1151157407,
 1151029747,
 -1,
 -47970,
 1151116980,
 65851,
 -1,
 1151169565,
 65848,
 -47968,
 1151128581,
 65850,
 -47967,
 1151321107,
 65849,
 -1,
 1151347292,
 65847,
 1151598591,
 1151050639,
 -1,
 -47964,
 1151501411,
 65792,
 -1,
 1151549432,
 65793,
 1151747240,
 1150979233,
 -1,
 -47961,
 1151718405,
 65855,
 -1,
 1151779859,
 65854,
 -47959,
 1151698107,
 65853,
 -47958,
 1151878166,
 65852,
 -1,
 1151939292,
 65794,
 -1,
 1146862046,
 128673,
 1152206067,
 1146807706,
 -1,
 1152271602,
 1152142994,
 -1,
 1152337137,
 1152221858,
 -1,
 1152402615,
 1152260682,
 68352,
 1152468147,
 1152326218,
 68353,
 -47950,
 1152424641,
 68355,
 -1,
 1152488096,
 68357,
 1152664757,
 1152402626,
 68358,
 -1,
 1152599234,
 68359,
 -47946,
 1152621249,
 68354,
 -1,
 1152750240,
 68356,
 1152926911,
 1152357024,
 -1,
 1152992444,
 1152866387,
 -1,
 -47942,
 1152971844,
 68387,
 -47941,
 1153033868,
 68388,
 -1,
 1153057986,
 68386,
 -47939,
 1152971844,
 68390,
 -47938,
 1153209517,
 68391,
 -1,
 1153254594,
 68389,
 1153451205,
 1152893396,
 -1,
 1153516739,
 1153392060,
 -1,
 -47934,
 1153496132,
 68403,
 -1,
 1153516738,
 68401,
 -47932,
 1153484352,
 68404,
 -1,
 1153647810,
 68399,
 1153844425,
 1153430064,
 -1,
 -47929,
 1153823812,
 68370,
 -47928,
 1153885836,
 68371,
 -1,
 1153909954,
 68369,
 1154106573,
 1153814518,
 -1,
 -47925,
 1154077143,
 68381,
 -47924,
 1154113663,
 68378,
 -1,
 1154172098,
 68377,
 1154368721,
 1154046035,
 -1,
 -47921,
 1154310271,
 68374,
 -47920,
 1154374110,
 68373,
 -1,
 1154434242,
 68372,
 1154630868,
 1154348613,
 -1,
 -47917,
 1154572415,
 68402,
 -1,
 1154630850,
 68400,
 1154827479,
 1154609974,
 -1,
 -47914,
 1154806852,
 68394,
 -1,
 1154827458,
 68395,
 1155024089,
 1154800827,
 68366,
 -1,
 1154997435,
 68367,
 1155155163,
 1154980545,
 68362,
 -1,
 1155111617,
 68363,
 1155286237,
 1155098621,
 68364,
 -1,
 1155229693,
 68365,
 1155417312,
 1155227068,
 -1,
 -47905,
 1155370115,
 68393,
 -1,
 1155417282,
 68405,
 1155613922,
 1155351746,
 68360,
 -1,
 1155548354,
 68361,
 1155744997,
 1155545941,
 -1,
 -47900,
 1155686527,
 68380,
 -1,
 1155744962,
 68379,
 1155941608,
 1155672327,
 -1,
 -47897,
 1155883135,
 68385,
 -1,
 1155941570,
 68384,
 -47895,
 1155917452,
 68396,
 -47894,
 1156101795,
 68397,
 -47893,
 1156164581,
 68382,
 -47892,
 1156222083,
 68392,
 -47891,
 1156284220,
 68398,
 -47890,
 1156348389,
 68368,
 -47889,
 1156413325,
 68376,
 -47888,
 1156469422,
 68383,
 -1,
 1156526498,
 68375,
 -1,
 1152260966,
 68409,
 -1,
 1152228197,
 129361,
 1156859131,
 1152179387,
 -1,
 1156924665,
 1156830957,
 -1,
 1156990200,
 1156876620,
 -1,
 -47881,
 1156946737,
 128663,
 -1,
 1156982579,
 127975,
 -1,
 1156909257,
 128762,
 -47878,
 1156894210,
 8371,
 -1,
 1157180206,
 127814,
 1157383426,
 1156825556,
 -1,
 1157448961,
 1157353462,
 -1,
 1157514496,
 1157411810,
 -1,
 -47873,
 1157472504,
 9954,
 -1,
 1157504249,
 11225,
 -1,
 1157472442,
 128562,
 -1,
 1157379037,
 65948,
 1157842183,
 1157312424,
 -1,
 1157907717,
 1157789792,
 983053,
 -1,
 1157863595,
 983052,
 -47866,
 1157838935,
 129687,
 -1,
 1157956167,
 9190,
 1158169867,
 1157802448,
 -1,
 -47863,
 1158131223,
 983194,
 -47862,
 1158192579,
 11236,
 -1,
 1158229928,
 983195,
 1158432015,
 1158121804,
 -1,
 -47859,
 1158393145,
 127994,
 -47858,
 1158434236,
 127944,
 -1,
 1158491948,
 128657,
 1158694162,
 1158402038,
 -1,
 -47855,
 1158651387,
 9883,
 -1,
 1158702081,
 128095,
 1158890773,
 1158640660,
 -1,
 -47852,
 1158823362,
 128747,
 -1,
 1158882743,
 128748,
 -47850,
 1158869649,
 129683,
 -47849,
 1159035851,
 8525,
 -47848,
 1159091029,
 1547,
 -1,
 1159145835,
 129518,
 1159350726,
 1045598880,
 -1,
 1159415496,
 1159322811,
 -1,
 1159481029,
 1159382854,
 -1,
 1159546564,
 1159410362,
 -1,
 1159611946,
 1159467819,
 -1,
 1159677231,
 1159546050,
 -1,
 -47840,
 1159614963,
 111343,
 -47839,
 1159677122,
 111342,
 -47838,
 1159740245,
 111341,
 -47837,
 1159802792,
 111340,
 -47836,
 1159866631,
 111339,
 -47835,
 1159928394,
 111338,
 -47834,
 1159993752,
 111337,
 -47833,
 1160059111,
 111336,
 -47832,
 1160124423,
 111335,
 -47831,
 1160189751,
 111334,
 -47830,
 1160255042,
 111333,
 -47829,
 1160320366,
 111332,
 -47828,
 1160385616,
 111331,
 -47827,
 1160450859,
 111330,
 -47826,
 1160516091,
 111329,
 -1,
 1160581355,
 111328,
 1160791360,
 1159609173,
 -1,
 -47823,
 1160729075,
 111327,
 -47822,
 1160791234,
 111326,
 -47821,
 1160854357,
 111325,
 -47820,
 1160916904,
 111324,
 -47819,
 1160980743,
 111323,
 -47818,
 1161042506,
 111322,
 -47817,
 1161107864,
 111321,
 -47816,
 1161173223,
 111320,
 -47815,
 1161238535,
 111319,
 -47814,
 1161303863,
 111318,
 -47813,
 1161369154,
 111317,
 -47812,
 1161434478,
 111316,
 -47811,
 1161499728,
 111315,
 -47810,
 1161564971,
 111314,
 -47809,
 1161630203,
 111313,
 -1,
 1161695467,
 111312,
 1161905489,
 1160720296,
 -1,
 -47806,
 1161843187,
 111311,
 -47805,
 1161905346,
 111310,
 -47804,
 1161968469,
 111309,
 -47803,
 1162031016,
 111308,
 -47802,
 1162094855,
 111307,
 -47801,
 1162156618,
 111306,
 -47800,
 1162221976,
 111305,
 -47799,
 1162287335,
 111304,
 -47798,
 1162352647,
 111303,
 -47797,
 1162417975,
 111302,
 -47796,
 1162483266,
 111301,
 -47795,
 1162548590,
 111300,
 -47794,
 1162613840,
 111299,
 -47793,
 1162679083,
 111298,
 -47792,
 1162744315,
 111297,
 -1,
 1162809579,
 111296,
 1163019618,
 1161832711,
 -1,
 -47789,
 1162957299,
 111295,
 -47788,
 1163019458,
 111294,
 -47787,
 1163082581,
 111293,
 -47786,
 1163145128,
 111292,
 -47785,
 1163208967,
 111291,
 -47784,
 1163270730,
 111290,
 -47783,
 1163336088,
 111289,
 -47782,
 1163401447,
 111288,
 -47781,
 1163466759,
 111287,
 -47780,
 1163532087,
 111286,
 -47779,
 1163597378,
 111285,
 -47778,
 1163662702,
 111284,
 -47777,
 1163727952,
 111283,
 -47776,
 1163793195,
 111282,
 -47775,
 1163858427,
 111281,
 -1,
 1163923691,
 111280,
 1164133747,
 1162943050,
 -1,
 -47772,
 1164071411,
 111279,
 -47771,
 1164133570,
 111278,
 -47770,
 1164196693,
 111277,
 -47769,
 1164259240,
 111276,
 -47768,
 1164323079,
 111275,
 -47767,
 1164384842,
 111274,
 -47766,
 1164450200,
 111273,
 -47765,
 1164515559,
 111272,
 -47764,
 1164580871,
 111271,
 -47763,
 1164646199,
 111270,
 -47762,
 1164711490,
 111269,
 -47761,
 1164776814,
 111268,
 -47760,
 1164842064,
 111267,
 -47759,
 1164907307,
 111266,
 -47758,
 1164972539,
 111265,
 -1,
 1165037803,
 111264,
 1165247876,
 1164056984,
 -1,
 -47755,
 1165185523,
 111263,
 -47754,
 1165247682,
 111262,
 -47753,
 1165310805,
 111261,
 -47752,
 1165373352,
 111260,
 -47751,
 1165437191,
 111259,
 -47750,
 1165498954,
 111258,
 -47749,
 1165564312,
 111257,
 -47748,
 1165629671,
 111256,
 -47747,
 1165694983,
 111255,
 -47746,
 1165760311,
 111254,
 -47745,
 1165825602,
 111253,
 -47744,
 1165890926,
 111252,
 -47743,
 1165956176,
 111251,
 -47742,
 1166021419,
 111250,
 -47741,
 1166086651,
 111249,
 -1,
 1166151915,
 111248,
 1166362005,
 1165170919,
 -1,
 -47738,
 1166299635,
 111247,
 -47737,
 1166361794,
 111246,
 -47736,
 1166424917,
 111245,
 -47735,
 1166487464,
 111244,
 -47734,
 1166551303,
 111243,
 -47733,
 1166613066,
 111242,
 -47732,
 1166678424,
 111241,
 -47731,
 1166743783,
 111240,
 -47730,
 1166809095,
 111239,
 -47729,
 1166874423,
 111238,
 -47728,
 1166939714,
 111237,
 -47727,
 1167005038,
 111236,
 -47726,
 1167070288,
 111235,
 -47725,
 1167135531,
 111234,
 -47724,
 1167200763,
 111233,
 -1,
 1167266027,
 111232,
 1167476134,
 1166284807,
 -1,
 -47721,
 1167413747,
 111231,
 -47720,
 1167475906,
 111230,
 -47719,
 1167539029,
 111229,
 -47718,
 1167601576,
 111228,
 -47717,
 1167665415,
 111227,
 -47716,
 1167727178,
 111226,
 -47715,
 1167792536,
 111225,
 -47714,
 1167857895,
 111224,
 -47713,
 1167923207,
 111223,
 -47712,
 1167988535,
 111222,
 -47711,
 1168053826,
 111221,
 -47710,
 1168119150,
 111220,
 -47709,
 1168184400,
 111219,
 -47708,
 1168249643,
 111218,
 -47707,
 1168314875,
 111217,
 -1,
 1168380139,
 111216,
 1168590263,
 1167398711,
 -1,
 -47704,
 1168527859,
 111215,
 -47703,
 1168590018,
 111214,
 -47702,
 1168653141,
 111213,
 -47701,
 1168715688,
 111212,
 -47700,
 1168779527,
 111211,
 -47699,
 1168841290,
 111210,
 -47698,
 1168906648,
 111209,
 -47697,
 1168972007,
 111208,
 -47696,
 1169037319,
 111207,
 -47695,
 1169102647,
 111206,
 -47694,
 1169167938,
 111205,
 -47693,
 1169233262,
 111204,
 -47692,
 1169298512,
 111203,
 -47691,
 1169363755,
 111202,
 -47690,
 1169428987,
 111201,
 -1,
 1169494251,
 111200,
 1169704392,
 1168512578,
 -1,
 -47687,
 1169641971,
 111199,
 -47686,
 1169704130,
 111198,
 -47685,
 1169767253,
 111197,
 -47684,
 1169829800,
 111196,
 -47683,
 1169893639,
 111195,
 -47682,
 1169955402,
 111194,
 -47681,
 1170020760,
 111193,
 -47680,
 1170086119,
 111192,
 -47679,
 1170151431,
 111191,
 -47678,
 1170216759,
 111190,
 -47677,
 1170282050,
 111189,
 -47676,
 1170347374,
 111188,
 -47675,
 1170412624,
 111187,
 -47674,
 1170477867,
 111186,
 -47673,
 1170543099,
 111185,
 -1,
 1170608363,
 111184,
 1170818521,
 1169626478,
 -1,
 -47670,
 1170756083,
 111183,
 -47669,
 1170818242,
 111182,
 -47668,
 1170881365,
 111181,
 -47667,
 1170943912,
 111180,
 -47666,
 1171007751,
 111179,
 -47665,
 1171069514,
 111178,
 -47664,
 1171134872,
 111177,
 -47663,
 1171200231,
 111176,
 -47662,
 1171265543,
 111175,
 -47661,
 1171330871,
 111174,
 -47660,
 1171396162,
 111173,
 -47659,
 1171461486,
 111172,
 -47658,
 1171526736,
 111171,
 -47657,
 1171591979,
 111170,
 -47656,
 1171657211,
 111169,
 -1,
 1171722475,
 111168,
 1171932650,
 1170740304,
 -1,
 -47653,
 1171870195,
 111167,
 -47652,
 1171932354,
 111166,
 -47651,
 1171995477,
 111165,
 -47650,
 1172058024,
 111164,
 -47649,
 1172121863,
 111163,
 -47648,
 1172183626,
 111162,
 -47647,
 1172248984,
 111161,
 -47646,
 1172314343,
 111160,
 -47645,
 1172379655,
 111159,
 -47644,
 1172444983,
 111158,
 -47643,
 1172510274,
 111157,
 -47642,
 1172575598,
 111156,
 -47641,
 1172640848,
 111155,
 -47640,
 1172706091,
 111154,
 -47639,
 1172771323,
 111153,
 -1,
 1172836587,
 111152,
 1173046779,
 1171854123,
 -1,
 -47636,
 1172984307,
 111151,
 -47635,
 1173046466,
 111150,
 -47634,
 1173109589,
 111149,
 -47633,
 1173172136,
 111148,
 -47632,
 1173235975,
 111147,
 -47631,
 1173297738,
 111146,
 -47630,
 1173363096,
 111145,
 -47629,
 1173428455,
 111144,
 -47628,
 1173493767,
 111143,
 -47627,
 1173559095,
 111142,
 -47626,
 1173624386,
 111141,
 -47625,
 1173689710,
 111140,
 -47624,
 1173754960,
 111139,
 -47623,
 1173820203,
 111138,
 -47622,
 1173885435,
 111137,
 -1,
 1173950699,
 111136,
 1174160908,
 1172967931,
 -1,
 -47619,
 1174098419,
 111135,
 -47618,
 1174160578,
 111134,
 -47617,
 1174223701,
 111133,
 -47616,
 1174286248,
 111132,
 -47615,
 1174350087,
 111131,
 -47614,
 1174411850,
 111130,
 -47613,
 1174477208,
 111129,
 -47612,
 1174542567,
 111128,
 -47611,
 1174607879,
 111127,
 -47610,
 1174673207,
 111126,
 -47609,
 1174738498,
 111125,
 -47608,
 1174803822,
 111124,
 -47607,
 1174869072,
 111123,
 -47606,
 1174934315,
 111122,
 -47605,
 1174999547,
 111121,
 -1,
 1175064811,
 111120,
 1175275037,
 1174081771,
 -1,
 -47602,
 1175212531,
 111119,
 -47601,
 1175274690,
 111118,
 -47600,
 1175337813,
 111117,
 -47599,
 1175400360,
 111116,
 -47598,
 1175464199,
 111115,
 -47597,
 1175525962,
 111114,
 -47596,
 1175591320,
 111113,
 -47595,
 1175656679,
 111112,
 -47594,
 1175721991,
 111111,
 -47593,
 1175787319,
 111110,
 -47592,
 1175852610,
 111109,
 -47591,
 1175917934,
 111108,
 -47590,
 1175983184,
 111107,
 -47589,
 1176048427,
 111106,
 -47588,
 1176113659,
 111105,
 -1,
 1176178923,
 111104,
 1176436735,
 1175212531,
 -1,
 -47585,
 1176316167,
 111355,
 -47584,
 1176377930,
 111354,
 -47583,
 1176443288,
 111353,
 -47582,
 1176508647,
 111352,
 -47581,
 1176573959,
 111351,
 -47580,
 1176639287,
 111350,
 -47579,
 1176704578,
 111349,
 -47578,
 1176769902,
 111348,
 -47577,
 1176835152,
 111347,
 -47576,
 1176900395,
 111346,
 -47575,
 1176965627,
 111345,
 -1,
 1177030891,
 111344,
 1177288703,
 1159533051,
 -1,
 1177306684,
 1177178611,
 -1,
 -47571,
 1177244147,
 111103,
 -47570,
 1177306306,
 111102,
 -47569,
 1177369429,
 111101,
 -47568,
 1177431976,
 111100,
 -47567,
 1177495815,
 111099,
 -47566,
 1177557578,
 111098,
 -47565,
 1177622936,
 111097,
 -47564,
 1177688295,
 111096,
 -47563,
 1177753607,
 111095,
 -47562,
 1177818935,
 111094,
 -47561,
 1177884226,
 111093,
 -47560,
 1177949550,
 111092,
 -47559,
 1178014800,
 111091,
 -47558,
 1178080043,
 111090,
 -47557,
 1178145275,
 111089,
 -1,
 1178210539,
 111088,
 1178420813,
 1177240770,
 -1,
 -47554,
 1178358259,
 111087,
 -47553,
 1178420418,
 111086,
 -47552,
 1178483541,
 111085,
 -47551,
 1178546088,
 111084,
 -47550,
 1178609927,
 111083,
 -47549,
 1178671690,
 111082,
 -47548,
 1178737048,
 111081,
 -47547,
 1178802407,
 111080,
 -47546,
 1178867719,
 111079,
 -47545,
 1178933047,
 111078,
 -47544,
 1178998338,
 111077,
 -47543,
 1179063662,
 111076,
 -47542,
 1179128912,
 111075,
 -47541,
 1179194155,
 111074,
 -47540,
 1179259387,
 111073,
 -1,
 1179324651,
 111072,
 1179534942,
 1178352469,
 -1,
 -47537,
 1179472371,
 111071,
 -47536,
 1179534530,
 111070,
 -47535,
 1179597653,
 111069,
 -47534,
 1179660200,
 111068,
 -47533,
 1179724039,
 111067,
 -47532,
 1179785802,
 111066,
 -47531,
 1179851160,
 111065,
 -47530,
 1179916519,
 111064,
 -47529,
 1179981831,
 111063,
 -47528,
 1180047159,
 111062,
 -47527,
 1180112450,
 111061,
 -47526,
 1180177774,
 111060,
 -47525,
 1180243024,
 111059,
 -47524,
 1180308267,
 111058,
 -47523,
 1180373499,
 111057,
 -1,
 1180438763,
 111056,
 1180649071,
 1179463592,
 -1,
 -47520,
 1180586483,
 111055,
 -47519,
 1180648642,
 111054,
 -47518,
 1180711765,
 111053,
 -47517,
 1180774312,
 111052,
 -47516,
 1180838151,
 111051,
 -47515,
 1180899914,
 111050,
 -47514,
 1180965272,
 111049,
 -47513,
 1181030631,
 111048,
 -47512,
 1181095943,
 111047,
 -47511,
 1181161271,
 111046,
 -47510,
 1181226562,
 111045,
 -47509,
 1181291886,
 111044,
 -47508,
 1181357136,
 111043,
 -47507,
 1181422379,
 111042,
 -47506,
 1181487611,
 111041,
 -1,
 1181552875,
 111040,
 1181763200,
 1180576007,
 -1,
 -47503,
 1181700595,
 111039,
 -47502,
 1181762754,
 111038,
 -47501,
 1181825877,
 111037,
 -47500,
 1181888424,
 111036,
 -47499,
 1181952263,
 111035,
 -47498,
 1182014026,
 111034,
 -47497,
 1182079384,
 111033,
 -47496,
 1182144743,
 111032,
 -47495,
 1182210055,
 111031,
 -47494,
 1182275383,
 111030,
 -47493,
 1182340674,
 111029,
 -47492,
 1182405998,
 111028,
 -47491,
 1182471248,
 111027,
 -47490,
 1182536491,
 111026,
 -47489,
 1182601723,
 111025,
 -1,
 1182666987,
 111024,
 1182877329,
 1181686346,
 -1,
 -47486,
 1182814707,
 111023,
 -47485,
 1182876866,
 111022,
 -47484,
 1182939989,
 111021,
 -47483,
 1183002536,
 111020,
 -47482,
 1183066375,
 111019,
 -47481,
 1183128138,
 111018,
 -47480,
 1183193496,
 111017,
 -47479,
 1183258855,
 111016,
 -47478,
 1183324167,
 111015,
 -47477,
 1183389495,
 111014,
 -47476,
 1183454786,
 111013,
 -47475,
 1183520110,
 111012,
 -47474,
 1183585360,
 111011,
 -47473,
 1183650603,
 111010,
 -47472,
 1183715835,
 111009,
 -1,
 1183781099,
 111008,
 1183991458,
 1182800280,
 -1,
 -47469,
 1183928819,
 111007,
 -47468,
 1183990978,
 111006,
 -47467,
 1184054101,
 111005,
 -47466,
 1184116648,
 111004,
 -47465,
 1184180487,
 111003,
 -47464,
 1184242250,
 111002,
 -47463,
 1184307608,
 111001,
 -47462,
 1184372967,
 111000,
 -47461,
 1184438279,
 110999,
 -47460,
 1184503607,
 110998,
 -47459,
 1184568898,
 110997,
 -47458,
 1184634222,
 110996,
 -47457,
 1184699472,
 110995,
 -47456,
 1184764715,
 110994,
 -47455,
 1184829947,
 110993,
 -1,
 1184895211,
 110992,
 1185105587,
 1183914215,
 -1,
 -47452,
 1185042931,
 110991,
 -47451,
 1185105090,
 110990,
 -47450,
 1185168213,
 110989,
 -47449,
 1185230760,
 110988,
 -47448,
 1185294599,
 110987,
 -47447,
 1185356362,
 110986,
 -47446,
 1185421720,
 110985,
 -47445,
 1185487079,
 110984,
 -47444,
 1185552391,
 110983,
 -47443,
 1185617719,
 110982,
 -47442,
 1185683010,
 110981,
 -47441,
 1185748334,
 110980,
 -47440,
 1185813584,
 110979,
 -47439,
 1185878827,
 110978,
 -47438,
 1185944059,
 110977,
 -1,
 1186009323,
 110976,
 1186267135,
 1185028103,
 -1,
 -47435,
 1186157043,
 110975,
 -47434,
 1186219202,
 110974,
 -47433,
 1186282325,
 110973,
 -47432,
 1186344872,
 110972,
 -47431,
 1186408711,
 110971,
 -47430,
 1186470474,
 110970,
 -47429,
 1186535832,
 110969,
 -47428,
 1186601191,
 110968,
 -47427,
 1186666503,
 110967,
 -47426,
 1186731831,
 110966,
 -47425,
 1186797122,
 110965,
 -47424,
 1186862446,
 110964,
 -47423,
 1186927696,
 110963,
 -47422,
 1186992939,
 110962,
 -47421,
 1187058171,
 110961,
 -1,
 1187123435,
 110960,
 -1,
 1159493015,
 94177,
 1187399367,
 1159429179,
 983041,
 -1,
 1187347515,
 983040,
 -1,
 1187368955,
 128297,
 1187596354,
 1159349442,
 -1,
 1187661764,
 1187572385,
 -1,
 1187727182,
 1187584588,
 -1,
 1187792661,
 1187676834,
 -1,
 1187858134,
 1187746464,
 -1,
 1187923664,
 1187836726,
 -1,
 -47409,
 1187864014,
 70681,
 -1,
 1187912266,
 70680,
 1188120275,
 1187862611,
 -1,
 -47406,
 1188060622,
 70675,
 -1,
 1188108874,
 70674,
 -47404,
 1188074218,
 70686,
 -47403,
 1188257230,
 70692,
 -1,
 1188305482,
 70691,
 1188513501,
 1187833242,
 -1,
 1188579036,
 1188469611,
 -1,
 1188644570,
 1188541410,
 70662,
 -1,
 1188606946,
 70663,
 1188823039,
 1188592699,
 70664,
 -1,
 1188723771,
 70665,
 -1,
 1188513730,
 70751,
 1188972259,
 1188483062,
 -1,
 1189037793,
 1188941814,
 -1,
 -47392,
 1188978126,
 70683,
 -1,
 1189026378,
 70682,
 -47390,
 1188978126,
 70688,
 -1,
 1189157450,
 70687,
 1189365481,
 1188903765,
 -1,
 1189431015,
 1189296981,
 -1,
 -47386,
 1189371342,
 70685,
 -1,
 1189419594,
 70684,
 -47384,
 1189371342,
 70690,
 -1,
 1189550666,
 70689,
 1189758701,
 1189288522,
 70656,
 -47381,
 1189731515,
 70669,
 -47380,
 1189767165,
 70667,
 -1,
 1189812810,
 70657,
 1190020849,
 1189724628,
 -1,
 -47377,
 1189986985,
 70706,
 -47376,
 1190026702,
 70705,
 -1,
 1190074954,
 70707,
 1190282995,
 1189993659,
 70660,
 -1,
 1190255803,
 70661,
 1190414070,
 1190245346,
 -1,
 -47371,
 1190354382,
 70701,
 -1,
 1190402634,
 70700,
 1190610681,
 1190373840,
 -1,
 -47368,
 1190550990,
 70694,
 -1,
 1190599242,
 70693,
 1190807292,
 1190562124,
 -1,
 -47365,
 1190747598,
 70698,
 -1,
 1190795850,
 70697,
 1191003903,
 1190755387,
 -1,
 -47362,
 1190944206,
 70703,
 -1,
 1190992458,
 70702,
 1191200514,
 1190951008,
 -1,
 -47359,
 1191140814,
 70671,
 -1,
 1191189066,
 70670,
 1191397125,
 1191147329,
 -1,
 -47356,
 1191337422,
 70679,
 -1,
 1191385674,
 70678,
 1191593735,
 1191340029,
 70658,
 -1,
 1191536637,
 70659,
 1191724810,
 1191532627,
 -1,
 -47351,
 1191665102,
 70673,
 -1,
 1191713354,
 70672,
 1191921421,
 1191653288,
 -1,
 -47348,
 1191861710,
 70677,
 -1,
 1191909962,
 70676,
 1192118032,
 1191848199,
 -1,
 -47345,
 1192058318,
 70696,
 -1,
 1192106570,
 70695,
 -47343,
 1192096698,
 70699,
 -47342,
 1192291041,
 70704,
 -47341,
 1192336065,
 70668,
 -47340,
 1192385998,
 70708,
 -1,
 1192445122,
 70666,
 1192642341,
 1187768874,
 -1,
 1192707867,
 1192618321,
 -1,
 1192773401,
 1192670178,
 70714,
 -1,
 1192735714,
 70715,
 1192951807,
 1192721467,
 70716,
 -1,
 1192852539,
 70717,
 1193035551,
 1192630858,
 -1,
 -47331,
 1193008315,
 70721,
 -47330,
 1193043965,
 70719,
 -1,
 1193089610,
 70709,
 1193297697,
 1193008315,
 70712,
 -1,
 1193270459,
 70713,
 1193428771,
 1193240573,
 70710,
 -1,
 1193371645,
 70711,
 -47324,
 1193384641,
 70720,
 -1,
 1193493698,
 70718,
 1193690936,
 1192573781,
 -1,
 1193756468,
 1193634795,
 -1,
 1193821994,
 1193725942,
 -1,
 -47319,
 1193799731,
 70738,
 -1,
 1193829919,
 70739,
 1194018605,
 1193787860,
 -1,
 -47316,
 1193965220,
 70742,
 -1,
 1194020836,
 70743,
 1194215216,
 1193955827,
 -1,
 -47313,
 1194173976,
 70740,
 -1,
 1194227178,
 70741,
 -47311,
 1194194736,
 70736,
 -47310,
 1194368793,
 70737,
 -47309,
 1194432238,
 70745,
 -1,
 1194477982,
 70744,
 1194673975,
 1193715099,
 -1,
 -47306,
 1194605692,
 70732,
 -1,
 1194669775,
 70746,
 -1,
 1194599049,
 70731,
 1194936136,
 1193656788,
 -1,
 1195001671,
 1194878973,
 -1,
 1195067206,
 1194941485,
 -1,
 1195132734,
 1195042993,
 -1,
 -47299,
 1195099028,
 70725,
 -1,
 1195160933,
 70722,
 1195329345,
 1195055690,
 -1,
 -47296,
 1195304372,
 70727,
 -1,
 1195350588,
 70724,
 -47294,
 1195303426,
 70753,
 -47293,
 1195481581,
 70726,
 -47292,
 1195538389,
 70752,
 -47291,
 1195594656,
 70728,
 -1,
 1195651196,
 70723,
 -1,
 1194998983,
 70730,
 -1,
 1194926750,
 70750,
 -47287,
 1194896846,
 70747,
 -47286,
 1195941355,
 70729,
 -47285,
 1195995376,
 70749,
 -47284,
 1196054840,
 70734,
 -47283,
 1196111567,
 70733,
 -1,
 1196170123,
 70735,
 1196378048,
 1187643392,
 -1,
 1196443580,
 1196347638,
 -1,
 1196509075,
 1196393122,
 -1,
 1196574574,
 1196459783,
 -1,
 1196640086,
 1196543990,
 -1,
 -47276,
 1196606121,
 6539,
 -47275,
 1196645838,
 6546,
 -1,
 1196694090,
 6545,
 1196902233,
 1196618288,
 -1,
 -47272,
 1196877229,
 6569,
 -1,
 1196890698,
 6534,
 1197098844,
 1196868052,
 -1,
 -47269,
 1197071700,
 6571,
 -1,
 1197087306,
 6540,
 1197295455,
 1197058512,
 -1,
 -47266,
 1197235662,
 6552,
 -1,
 1197283914,
 6551,
 1197492066,
 1197249184,
 -1,
 -47263,
 1197430946,
 6535,
 -1,
 1197480522,
 6547,
 1197688677,
 1197439072,
 -1,
 -47260,
 1197663661,
 6568,
 -1,
 1197677130,
 6533,
 -47258,
 1197667258,
 6541,
 -47257,
 1197860269,
 6558,
 -47256,
 1197912621,
 6529,
 -47255,
 1197967778,
 6553,
 -47254,
 1198029957,
 6559,
 -47253,
 1198087630,
 6563,
 -47252,
 1198150216,
 6557,
 -47251,
 1198210048,
 6564,
 -1,
 1198270776,
 6565,
 1198475147,
 1196516039,
 -1,
 1198540659,
 1198444534,
 -1,
 -47247,
 1198506665,
 6536,
 -47246,
 1198546382,
 6543,
 -1,
 1198594634,
 6542,
 1198802806,
 1198518832,
 -1,
 -47243,
 1198777773,
 6567,
 -1,
 1198791242,
 6531,
 1198999417,
 1198768596,
 -1,
 -47240,
 1198972244,
 6570,
 -1,
 1198987850,
 6537,
 1199196028,
 1198959056,
 -1,
 -47237,
 1199136206,
 6549,
 -1,
 1199184458,
 6548,
 1199392639,
 1199149728,
 -1,
 -47234,
 1199331490,
 6532,
 -1,
 1199381066,
 6544,
 1199589250,
 1199339616,
 -1,
 -47231,
 1199564205,
 6566,
 -1,
 1199577674,
 6530,
 -47229,
 1199567802,
 6538,
 -47228,
 1199760813,
 6555,
 -47227,
 1199813165,
 6528,
 -47226,
 1199868322,
 6550,
 -47225,
 1199930501,
 6556,
 -47224,
 1199988174,
 6560,
 -47223,
 1200050760,
 6554,
 -47222,
 1200110592,
 6561,
 -1,
 1200171320,
 6562,
 1200422911,
 1198412697,
 -1,
 1200441230,
 1200329376,
 6595,
 -1,
 1200379987,
 6594,
 -47217,
 1200416154,
 6593,
 -47216,
 1200523596,
 6596,
 -47215,
 1200584800,
 6597,
 -47214,
 1200634709,
 6598,
 -1,
 1200695559,
 6599,
 1200900007,
 1196485162,
 -1,
 1200965529,
 1200872635,
 6579,
 1201031063,
 1200899266,
 6585,
 -1,
 1201009462,
 6591,
 -47208,
 1201009462,
 6588,
 -1,
 1201134779,
 6580,
 1201293213,
 1200921281,
 6583,
 1201358748,
 1201216074,
 6584,
 -1,
 1201337142,
 6590,
 -1,
 1201337142,
 6589,
 1201555362,
 1201216074,
 -1,
 1201620896,
 1201478218,
 6577,
 -1,
 1201599286,
 6587,
 -47199,
 1201599286,
 6586,
 -1,
 1201685698,
 6582,
 1201883045,
 1201498109,
 -1,
 -47196,
 1201861430,
 6592,
 -1,
 1201891325,
 6578,
 -47194,
 1201859098,
 6576,
 -1,
 1202013378,
 6581,
 1202210741,
 1200832237,
 -1,
 1202276267,
 1202180086,
 -1,
 -47190,
 1202253875,
 6610,
 -1,
 1202284063,
 6611,
 1202472878,
 1202242004,
 -1,
 -47187,
 1202419364,
 6614,
 -1,
 1202474980,
 6615,
 1202669489,
 1202409971,
 -1,
 -47184,
 1202628120,
 6612,
 -1,
 1202681322,
 6613,
 -47182,
 1202648880,
 6608,
 -47181,
 1202822937,
 6609,
 -47180,
 1202886382,
 6617,
 -1,
 1202932126,
 6616,
 1203128250,
 1202180086,
 -1,
 1203193785,
 1203085267,
 -1,
 -47176,
 1203114795,
 6601,
 -1,
 1203180027,
 6600,
 -1,
 1203134232,
 6618,
 1203503103,
 1203095552,
 6622,
 -1,
 1203430810,
 6623,
 1203587007,
 1196396819,
 -1,
 -47170,
 1203564159,
 127770,
 -1,
 1203621811,
 127761,
 -1,
 1203536995,
 983063,
 1203849155,
 1196328040,
 -1,
 -47166,
 1203813031,
 11155,
 -1,
 1203863584,
 11154,
 -1,
 1203817300,
 128240,
 1204111372,
 1187600752,
 -1,
 1204176872,
 1204079586,
 -1,
 1204242401,
 1204125286,
 -1,
 -47160,
 1204221509,
 127369,
 -47159,
 1204286262,
 127368,
 -47158,
 1204351536,
 127367,
 -47157,
 1204415137,
 127366,
 -47156,
 1204479386,
 127365,
 -47155,
 1204542651,
 127364,
 -47154,
 1204604918,
 127363,
 -47153,
 1204666836,
 127362,
 -47152,
 1204728802,
 127361,
 -47151,
 1204793870,
 127360,
 -47150,
 1204857296,
 127359,
 -47149,
 1204918977,
 127358,
 -47148,
 1204982432,
 127357,
 -47147,
 1205045580,
 127356,
 -47146,
 1205107771,
 127355,
 -47145,
 1205172320,
 127354,
 -47144,
 1205237569,
 127353,
 -47143,
 1205299197,
 127352,
 -47142,
 1205362108,
 127351,
 -47141,
 1205426259,
 127350,
 -47140,
 1205490163,
 127349,
 -47139,
 1205552322,
 127348,
 -47138,
 1205615445,
 127347,
 -47137,
 1205677992,
 127346,
 -47136,
 1205741831,
 127345,
 -1,
 1205803594,
 127344,
 -47134,
 1204218890,
 127375,
 -47133,
 1205977769,
 127373,
 -47132,
 1206039431,
 129988,
 -47131,
 1206102561,
 127372,
 -47130,
 1206151485,
 127371,
 -47129,
 1206204742,
 10062,
 -1,
 1206262597,
 127374,
 1206470663,
 1204106315,
 -1,
 1206536196,
 1206419046,
 -1,
 -47125,
 1206515269,
 127337,
 -47124,
 1206580022,
 127336,
 -47123,
 1206645296,
 127335,
 -47122,
 1206708897,
 127334,
 -47121,
 1206773146,
 127333,
 -47120,
 1206836411,
 127332,
 -47119,
 1206898678,
 127331,
 -47118,
 1206960596,
 127330,
 -47117,
 1207022562,
 127329,
 -47116,
 1207087630,
 127328,
 -47115,
 1207151056,
 127327,
 -47114,
 1207212737,
 127326,
 -47113,
 1207276192,
 127325,
 -47112,
 1207339340,
 127324,
 -47111,
 1207401531,
 127323,
 -47110,
 1207466080,
 127322,
 -47109,
 1207531329,
 127321,
 -47108,
 1207592957,
 127320,
 -47107,
 1207655868,
 127319,
 -47106,
 1207720019,
 127318,
 -47105,
 1207783923,
 127317,
 -47104,
 1207846082,
 127316,
 -47103,
 1207909205,
 127315,
 -47102,
 1207971752,
 127314,
 -47101,
 1208035591,
 127313,
 -1,
 1208097354,
 127312,
 -47099,
 1206507687,
 128982,
 -47098,
 1208273860,
 128984,
 -1,
 1208303348,
 9471,
 1208502283,
 1206402697,
 -1,
 -47095,
 1208454836,
 129982,
 -47094,
 1208499890,
 129983,
 -1,
 1208564032,
 129981,
 -1,
 1208425530,
 983091,
 1208830010,
 1204086039,
 -1,
 1208895545,
 1208792398,
 -1,
 1208961080,
 1208824637,
 -1,
 1209026590,
 1208907872,
 -1,
 1209092122,
 1208981188,
 129540,
 1209204735,
 1209010400,
 -1,
 1209223191,
 1209126902,
 -1,
 1209288726,
 1209200847,
 -1,
 -47083,
 1209260981,
 129586,
 -1,
 1209320758,
 129603,
 -1,
 1209231028,
 129607,
 -47080,
 1209180013,
 129565,
 -47079,
 1209505573,
 129561,
 -1,
 1209554475,
 129544,
 1209794559,
 1209036480,
 129536,
 1209860095,
 1209665760,
 -1,
 -47075,
 1209785434,
 129599,
 -1,
 1209833253,
 129557,
 1210009638,
 1208998643,
 -1,
 1210075170,
 1209956448,
 -1,
 -47071,
 1210029764,
 129582,
 -1,
 1210085056,
 129578,
 -47069,
 1210040249,
 129580,
 -47068,
 1210233675,
 129579,
 -47067,
 1210297277,
 129583,
 -1,
 1210330202,
 129581,
 1210533930,
 1209974713,
 129538,
 1210646527,
 1210452192,
 -1,
 -47063,
 1210571866,
 129601,
 -1,
 1210619685,
 129559,
 1210796078,
 1210495819,
 129537,
 1210908671,
 1210714336,
 -1,
 -47059,
 1210834010,
 129600,
 -1,
 1210881829,
 129558,
 1211058226,
 1210756029,
 129541,
 1211170815,
 1210976480,
 -1,
 -47055,
 1211096154,
 129604,
 -1,
 1211143973,
 129562,
 1211320374,
 1210985562,
 129539,
 1211432959,
 1211238624,
 -1,
 -47051,
 1211358298,
 129602,
 -1,
 1211406117,
 129560,
 1211629567,
 1211256073,
 129610,
 -1,
 1211500778,
 129613,
 -1,
 1208898123,
 128528,
 -1,
 1208831274,
 9906,
 1211844669,
 1208795604,
 -1,
 -47044,
 1211815529,
 129670,
 -1,
 1211879241,
 11228,
 -47042,
 1211822828,
 983130,
 -47041,
 1212003930,
 129299,
 -47040,
 1212068134,
 11209,
 -47039,
 1212120123,
 983131,
 -1,
 1212167580,
 128084,
 1212369107,
 1187519050,
 -1,
 1212434586,
 1212322919,
 -1,
 1212500099,
 1212383906,
 -1,
 1212565579,
 1212469238,
 -1,
 1212631113,
 1212534774,
 -1,
 -47032,
 1212571086,
 72121,
 -1,
 1212619338,
 72120,
 -47030,
 1212571086,
 72126,
 -1,
 1212750410,
 72125,
 1212958800,
 1212519072,
 -1,
 -47027,
 1212937146,
 72119,
 -47026,
 1212977898,
 72124,
 -47025,
 1213028514,
 72114,
 -1,
 1213078090,
 72129,
 1213286486,
 1212889941,
 -1,
 1213352020,
 1213217621,
 -1,
 -47021,
 1213291982,
 72123,
 -1,
 1213340234,
 72122,
 -47019,
 1213291982,
 72128,
 -1,
 1213471306,
 72127,
 1213679706,
 1213209162,
 72096,
 -47016,
 1213652155,
 72109,
 -47015,
 1213687805,
 72107,
 -1,
 1213733450,
 72097,
 1213941854,
 1213654426,
 -1,
 1214007389,
 1213897596,
 72102,
 -1,
 1213969378,
 72103,
 -1,
 1213930058,
 72138,
 1214204002,
 1213907412,
 -1,
 -47008,
 1214169769,
 72140,
 -47007,
 1214209486,
 72139,
 -1,
 1214257738,
 72141,
 1214466148,
 1214176443,
 72100,
 -1,
 1214438587,
 72101,
 1214597223,
 1214428130,
 -1,
 -47002,
 1214559316,
 72144,
 -1,
 1214585418,
 72136,
 1214793834,
 1214556624,
 -1,
 -46999,
 1214733774,
 72131,
 -1,
 1214782026,
 72130,
 1214990445,
 1214741563,
 -1,
 -46996,
 1214938245,
 72143,
 -1,
 1214978634,
 72137,
 1215187056,
 1214937184,
 -1,
 -46993,
 1215126990,
 72111,
 -1,
 1215175242,
 72110,
 1215383667,
 1215133505,
 -1,
 -46990,
 1215323598,
 72118,
 -1,
 1215371850,
 72117,
 1215580277,
 1215326205,
 72098,
 -1,
 1215522813,
 72099,
 1215711352,
 1215518803,
 -1,
 -46985,
 1215651278,
 72113,
 -1,
 1215699530,
 72112,
 1215907963,
 1215639464,
 -1,
 -46982,
 1215847886,
 72116,
 -1,
 1215896138,
 72115,
 1216104574,
 1215834375,
 -1,
 -46979,
 1216044494,
 72133,
 -1,
 1216092746,
 72132,
 -46977,
 1216082874,
 72135,
 -46976,
 1216256705,
 72108,
 -46975,
 1216317858,
 72134,
 -46974,
 1216372174,
 72142,
 -1,
 1216431298,
 72106,
 1216628881,
 1212475946,
 -1,
 1216694408,
 1216551498,
 -1,
 -46970,
 1216666811,
 72157,
 -46969,
 1216702461,
 72155,
 -1,
 1216748106,
 72145,
 1216956554,
 1216670052,
 72150,
 -1,
 1216918498,
 72151,
 1217087628,
 1216928955,
 72148,
 -1,
 1217060027,
 72149,
 1217218702,
 1217030141,
 72146,
 -1,
 1217161213,
 72147,
 -46961,
 1217179858,
 72164,
 -46960,
 1217305281,
 72156,
 -1,
 1217348802,
 72154,
 1217546393,
 1216595931,
 -1,
 1217611925,
 1217521841,
 -1,
 -46956,
 1217577876,
 72159,
 -1,
 1217639781,
 72160,
 1217808536,
 1217534538,
 -1,
 -46953,
 1217783220,
 72161,
 -1,
 1217829436,
 72158,
 -1,
 1217775479,
 72162,
 -1,
 1217487086,
 72163,
 1218136269,
 1212361323,
 -1,
 1218201792,
 1218085538,
 -1,
 1218267302,
 1218139033,
 -1,
 -46946,
 1218246078,
 67724,
 -46945,
 1218299570,
 67740,
 -46944,
 1218353715,
 67732,
 -46943,
 1218416005,
 67730,
 -46942,
 1218477442,
 67728,
 -46941,
 1218541884,
 67726,
 -46940,
 1218601087,
 67718,
 -46939,
 1218653006,
 67714,
 -1,
 1218715593,
 67712,
 1218922667,
 1218232788,
 -1,
 1218988202,
 1218845258,
 -1,
 -46935,
 1218940268,
 67734,
 -1,
 1218985545,
 67737,
 -1,
 1218929491,
 67741,
 1219250350,
 1218891766,
 -1,
 -46931,
 1219186378,
 67723,
 -1,
 1219242149,
 67742,
 1219446960,
 1219190911,
 67719,
 -1,
 1219416909,
 67722,
 1219578035,
 1219369546,
 -1,
 -46926,
 1219556605,
 67735,
 -1,
 1219592811,
 67713,
 -46924,
 1219557123,
 67721,
 -46923,
 1219753406,
 67725,
 -46922,
 1219816401,
 67720,
 -46921,
 1219868842,
 67739,
 -46920,
 1219932799,
 67738,
 -46919,
 1219996645,
 67736,
 -46918,
 1220057651,
 67733,
 -46917,
 1220119941,
 67731,
 -46916,
 1220181378,
 67729,
 -46915,
 1220245820,
 67727,
 -46914,
 1220303792,
 67716,
 -46913,
 1220361298,
 67717,
 -1,
 1220422478,
 67715,
 1220626636,
 1218157047,
 -1,
 1220692167,
 1220595702,
 -1,
 1220757701,
 1220668065,
 -1,
 -46908,
 1220713153,
 67752,
 -1,
 1220758618,
 67758,
 -46906,
 1220699679,
 67753,
 -1,
 1220889313,
 67757,
 1221085385,
 1220648729,
 67751,
 -1,
 1221002113,
 67759,
 1221263359,
 1221022195,
 -1,
 -46901,
 1221174808,
 67754,
 -1,
 1221228010,
 67756,
 -1,
 1220557360,
 67755,
 -46898,
 1218115310,
 129535,
 -46897,
 1221452971,
 129314,
 -46896,
 1221514891,
 127966,
 -46895,
 1221561478,
 128219,
 -46894,
 1221621856,
 983092,
 -1,
 1221684345,
 128133,
 1221871918,
 1212347622,
 -1,
 1221937421,
 1221819451,
 -1,
 1222002956,
 1221873424,
 -1,
 1222068452,
 1221956256,
 -1,
 1222133979,
 1222037494,
 -1,
 -46887,
 1222111827,
 123155,
 -46886,
 1222165161,
 123149,
 -1,
 1222187594,
 123138,
 1222396126,
 1222093264,
 -1,
 -46883,
 1222343813,
 123166,
 -1,
 1222384202,
 123164,
 -46881,
 1222374330,
 123152,
 -46880,
 1222554708,
 123153,
 -46879,
 1222619693,
 123161,
 -46878,
 1222670528,
 123143,
 -46877,
 1222717407,
 123148,
 -1,
 1222777418,
 123141,
 1222985960,
 1222037494,
 -1,
 -46874,
 1222963795,
 123156,
 -46873,
 1223017129,
 123137,
 -1,
 1223039562,
 123139,
 1223248107,
 1222963760,
 -1,
 -46870,
 1223226298,
 123163,
 -1,
 1223236170,
 123142,
 1223444718,
 1223209954,
 -1,
 -46867,
 1223406676,
 123171,
 -1,
 1223432778,
 123158,
 1223641329,
 1223403984,
 -1,
 -46864,
 1223588997,
 123169,
 -1,
 1223629386,
 123162,
 1223837939,
 1223596737,
 123176,
 -1,
 1223793345,
 123177,
 1223969014,
 1223788876,
 -1,
 -46859,
 1223916677,
 123168,
 -1,
 1223957066,
 123136,
 1224165624,
 1223908814,
 123140,
 -1,
 1224105404,
 123167,
 1224296698,
 1224099010,
 123178,
 -1,
 1224230082,
 123179,
 1224427773,
 1224227669,
 -1,
 -46852,
 1224375429,
 123165,
 -1,
 1224415818,
 123151,
 1224624383,
 1224350282,
 123172,
 -1,
 1224546890,
 123173,
 -46848,
 1224603251,
 123147,
 -46847,
 1224733626,
 123160,
 -46846,
 1224796833,
 123180,
 -46845,
 1224861101,
 123154,
 -46844,
 1224924347,
 123175,
 -46843,
 1224983209,
 123146,
 -46842,
 1225044525,
 123159,
 -46841,
 1225096325,
 123145,
 -46840,
 1225160896,
 123150,
 -46839,
 1225222141,
 123174,
 -46838,
 1225283746,
 123170,
 -46837,
 1225347656,
 123157,
 -1,
 1225404383,
 123144,
 -1,
 1221958782,
 123214,
 1225672987,
 1221869293,
 -1,
 1225738513,
 1225641974,
 -1,
 -46832,
 1225715763,
 123202,
 -1,
 1225745951,
 123203,
 1225935124,
 1225703892,
 -1,
 -46829,
 1225881252,
 123206,
 -1,
 1225936868,
 123207,
 1226131735,
 1225871859,
 -1,
 -46826,
 1226090008,
 123204,
 -1,
 1226143210,
 123205,
 -46824,
 1226110768,
 123200,
 -46823,
 1226284825,
 123201,
 -46822,
 1226348270,
 123209,
 -1,
 1226394014,
 123208,
 1226590499,
 1225643867,
 -1,
 -46819,
 1226565018,
 123187,
 -46818,
 1226621396,
 123188,
 -46817,
 1226672460,
 123185,
 -46816,
 1226733377,
 123186,
 -46815,
 1226790995,
 123189,
 -46814,
 1226849109,
 123190,
 -1,
 1226909959,
 123184,
 1227114797,
 1226555860,
 -1,
 1227180332,
 1227058178,
 -1,
 1227245867,
 1227118052,
 -1,
 -46809,
 1227215858,
 123192,
 -46808,
 1227271422,
 123191,
 -46807,
 1227326968,
 123193,
 -46806,
 1227387365,
 123195,
 -1,
 1227432763,
 123194,
 -1,
 1227223842,
 123196,
 -1,
 1227158852,
 123197,
 -1,
 1227043924,
 123215,
 1227835772,
 1221819231,
 -1,
 1227901271,
 1227783227,
 -1,
 1227966805,
 1227837200,
 -1,
 1228032310,
 1227920032,
 2002,
 1228097844,
 1228010426,
 2018,
 -1,
 1228017458,
 2023,
 1228275711,
 1228020298,
 2019,
 -1,
 1228148530,
 2016,
 1228359996,
 1227978561,
 -1,
 1228425531,
 1228316417,
 -1,
 -46791,
 1228387412,
 2026,
 -46790,
 1228437343,
 2024,
 -1,
 1228485233,
 2025,
 -1,
 1228347978,
 2006,
 1228753215,
 1228321762,
 -1,
 -46786,
 1228715092,
 2010,
 -1,
 1228741194,
 2009,
 1228949825,
 1228708545,
 2000,
 -1,
 1228905153,
 1999,
 1229080899,
 1228883138,
 1997,
 -1,
 1229014210,
 1995,
 1229211973,
 1229011968,
 2008,
 -1,
 1229150648,
 2001,
 -46778,
 1229190074,
 2022,
 -46777,
 1229318881,
 2021,
 -46776,
 1229380795,
 1998,
 -46775,
 1229443196,
 2005,
 -46774,
 1229505193,
 2011,
 -46773,
 1229564449,
 2004,
 -46772,
 1229621666,
 2017,
 -46771,
 1229683845,
 2015,
 -46770,
 1229748416,
 2014,
 -46769,
 1229809661,
 1996,
 -46768,
 1229872590,
 2020,
 -46767,
 1229937052,
 2012,
 -46766,
 1230000712,
 2013,
 -46765,
 1230058097,
 2007,
 -46764,
 1230121272,
 2003,
 -1,
 1230182986,
 1994,
 -46762,
 1227925789,
 2037,
 -1,
 1230315306,
 2042,
 1230522728,
 1227832149,
 -1,
 1230588262,
 1230466027,
 -1,
 1230653788,
 1230557174,
 -1,
 -46757,
 1230630963,
 1986,
 -1,
 1230661151,
 1987,
 1230850399,
 1230619092,
 -1,
 -46754,
 1230796452,
 1990,
 -1,
 1230852068,
 1991,
 1231047010,
 1230787059,
 -1,
 -46751,
 1231005208,
 1988,
 -1,
 1231058410,
 1989,
 -46749,
 1231025968,
 1984,
 -46748,
 1231200025,
 1985,
 -46747,
 1231263470,
 1993,
 -1,
 1231309214,
 1992,
 -46745,
 1230545973,
 2046,
 -1,
 1231430538,
 2045,
 1231636854,
 1230452369,
 -1,
 1231702389,
 1231563811,
 -1,
 1231767919,
 1231652411,
 -1,
 -46740,
 1231732337,
 2033,
 -46739,
 1231783793,
 2032,
 -46738,
 1231839999,
 2031,
 -1,
 1231896061,
 2030,
 1232095603,
 1231734512,
 -1,
 -46735,
 1232060017,
 2029,
 -46734,
 1232111473,
 2028,
 -1,
 1232167679,
 2027,
 -46732,
 1232048995,
 2034,
 -1,
 1232290244,
 2035,
 -1,
 1231653282,
 2040,
 1232554361,
 1231605690,
 -1,
 -46728,
 1232511311,
 2038,
 -1,
 1232558496,
 2039,
 -46726,
 1232523615,
 2047,
 -46725,
 1232691977,
 2036,
 -1,
 1232752860,
 2041,
 1232947646,
 1227791041,
 -1,
 1233013157,
 1232909282,
 -1,
 1233078692,
 1232982861,
 -1,
 1233144227,
 1232994304,
 -1,
 1233209743,
 1233088110,
 -1,
 1233275274,
 1233147711,
 -1,
 1233340807,
 1233231645,
 -1,
 -46716,
 1233307892,
 43059,
 -46715,
 1233367782,
 43056,
 -46714,
 1233411721,
 43057,
 -1,
 1233471967,
 43060,
 1233715199,
 1233310816,
 -1,
 -46711,
 1233635582,
 43061,
 -1,
 1233695525,
 43058,
 1233865101,
 1233236615,
 -1,
 -46708,
 1233830111,
 43062,
 -1,
 1233885628,
 43065,
 -46706,
 1233830273,
 43064,
 -1,
 1234021838,
 43063,
 1234192793,
 1233185910,
 -1,
 1234258324,
 1234153200,
 -1,
 -46702,
 1234233603,
 128600,
 -46701,
 1234272190,
 128592,
 -1,
 1234317079,
 128608,
 1234520470,
 1234229494,
 11110,
 -1,
 1234438993,
 11126,
 -46697,
 1234496750,
 11009,
 -46696,
 1234617204,
 129108,
 -1,
 1234644114,
 11017,
 1234894847,
 1234126418,
 -1,
 1234913694,
 1234808560,
 -1,
 -46692,
 1234888963,
 128602,
 -46691,
 1234927550,
 128594,
 -1,
 1234972439,
 128610,
 1235175840,
 1234884854,
 11111,
 -1,
 1235094353,
 11127,
 -46687,
 1235152110,
 11008,
 -46686,
 1235272564,
 129109,
 -1,
 1235299474,
 11016,
 -1,
 1233077882,
 128746,
 -1,
 1233010386,
 8379,
 1235634609,
 1232928768,
 -1,
 1235700137,
 1235593680,
 -1,
 -46680,
 1235645237,
 128370,
 -1,
 1235699626,
 128695,
 1235896747,
 1235635274,
 9940,
 -1,
 1235814750,
 128683,
 1236027822,
 1235822855,
 -1,
 -46675,
 1235990190,
 983126,
 -1,
 1236036026,
 128691,
 -46673,
 1235995328,
 128685,
 -46672,
 1236181000,
 128286,
 -1,
 1236242539,
 128245,
 1236421051,
 1235603446,
 -1,
 1236486584,
 1236354242,
 128456,
 1236552117,
 1236413910,
 128211,
 -1,
 1236470871,
 128212,
 1236729855,
 1236469523,
 -1,
 -46665,
 1236621790,
 128457,
 -1,
 1236679509,
 128458,
 1236926463,
 1236415221,
 -1,
 -46662,
 1236843410,
 128324,
 -1,
 1236893870,
 128323,
 -46660,
 1236386812,
 128067,
 -46659,
 1237029579,
 128689,
 -1,
 1237094418,
 65934,
 1237273025,
 1232889853,
 -1,
 -46656,
 1237227389,
 129399,
 -1,
 1237277521,
 127747,
 1237469636,
 1237199111,
 -1,
 -46653,
 1237437258,
 983196,
 -1,
 1237474748,
 983127,
 -46651,
 1237422995,
 983227,
 -1,
 1237613627,
 983066,
 1237798458,
 1159297120,
 -1,
 1237863766,
 1237736892,
 -1,
 1237928897,
 1237808484,
 -1,
 1237994432,
 1237856941,
 -1,
 1238059739,
 1237920007,
 -1,
 1238125020,
 1237996019,
 -1,
 -46643,
 1238061555,
 101375,
 -46642,
 1238123714,
 101374,
 -46641,
 1238186837,
 101373,
 -46640,
 1238249384,
 101372,
 -46639,
 1238313223,
 101371,
 -46638,
 1238374986,
 101370,
 -46637,
 1238440344,
 101369,
 -46636,
 1238505703,
 101368,
 -46635,
 1238571015,
 101367,
 -46634,
 1238636343,
 101366,
 -46633,
 1238701634,
 101365,
 -46632,
 1238766958,
 101364,
 -46631,
 1238832208,
 101363,
 -46630,
 1238897451,
 101362,
 -46629,
 1238962683,
 101361,
 -1,
 1239027947,
 101360,
 1239239149,
 1238058178,
 -1,
 -46626,
 1239175667,
 101359,
 -46625,
 1239237826,
 101358,
 -46624,
 1239300949,
 101357,
 -46623,
 1239363496,
 101356,
 -46622,
 1239427335,
 101355,
 -46621,
 1239489098,
 101354,
 -46620,
 1239554456,
 101353,
 -46619,
 1239619815,
 101352,
 -46618,
 1239685127,
 101351,
 -46617,
 1239750455,
 101350,
 -46616,
 1239815746,
 101349,
 -46615,
 1239881070,
 101348,
 -46614,
 1239946320,
 101347,
 -46613,
 1240011563,
 101346,
 -46612,
 1240076795,
 101345,
 -1,
 1240142059,
 101344,
 1240353278,
 1239169877,
 -1,
 -46609,
 1240289779,
 101343,
 -46608,
 1240351938,
 101342,
 -46607,
 1240415061,
 101341,
 -46606,
 1240477608,
 101340,
 -46605,
 1240541447,
 101339,
 -46604,
 1240603210,
 101338,
 -46603,
 1240668568,
 101337,
 -46602,
 1240733927,
 101336,
 -46601,
 1240799239,
 101335,
 -46600,
 1240864567,
 101334,
 -46599,
 1240929858,
 101333,
 -46598,
 1240995182,
 101332,
 -46597,
 1241060432,
 101331,
 -46596,
 1241125675,
 101330,
 -46595,
 1241190907,
 101329,
 -1,
 1241256171,
 101328,
 1241467407,
 1240281000,
 -1,
 -46592,
 1241403891,
 101327,
 -46591,
 1241466050,
 101326,
 -46590,
 1241529173,
 101325,
 -46589,
 1241591720,
 101324,
 -46588,
 1241655559,
 101323,
 -46587,
 1241717322,
 101322,
 -46586,
 1241782680,
 101321,
 -46585,
 1241848039,
 101320,
 -46584,
 1241913351,
 101319,
 -46583,
 1241978679,
 101318,
 -46582,
 1242043970,
 101317,
 -46581,
 1242109294,
 101316,
 -46580,
 1242174544,
 101315,
 -46579,
 1242239787,
 101314,
 -46578,
 1242305019,
 101313,
 -1,
 1242370283,
 101312,
 1242581536,
 1241393415,
 -1,
 -46575,
 1242518003,
 101311,
 -46574,
 1242580162,
 101310,
 -46573,
 1242643285,
 101309,
 -46572,
 1242705832,
 101308,
 -46571,
 1242769671,
 101307,
 -46570,
 1242831434,
 101306,
 -46569,
 1242896792,
 101305,
 -46568,
 1242962151,
 101304,
 -46567,
 1243027463,
 101303,
 -46566,
 1243092791,
 101302,
 -46565,
 1243158082,
 101301,
 -46564,
 1243223406,
 101300,
 -46563,
 1243288656,
 101299,
 -46562,
 1243353899,
 101298,
 -46561,
 1243419131,
 101297,
 -1,
 1243484395,
 101296,
 1243695665,
 1242503754,
 -1,
 -46558,
 1243632115,
 101295,
 -46557,
 1243694274,
 101294,
 -46556,
 1243757397,
 101293,
 -46555,
 1243819944,
 101292,
 -46554,
 1243883783,
 101291,
 -46553,
 1243945546,
 101290,
 -46552,
 1244010904,
 101289,
 -46551,
 1244076263,
 101288,
 -46550,
 1244141575,
 101287,
 -46549,
 1244206903,
 101286,
 -46548,
 1244272194,
 101285,
 -46547,
 1244337518,
 101284,
 -46546,
 1244402768,
 101283,
 -46545,
 1244468011,
 101282,
 -46544,
 1244533243,
 101281,
 -1,
 1244598507,
 101280,
 1244809794,
 1243617688,
 -1,
 -46541,
 1244746227,
 101279,
 -46540,
 1244808386,
 101278,
 -46539,
 1244871509,
 101277,
 -46538,
 1244934056,
 101276,
 -46537,
 1244997895,
 101275,
 -46536,
 1245059658,
 101274,
 -46535,
 1245125016,
 101273,
 -46534,
 1245190375,
 101272,
 -46533,
 1245255687,
 101271,
 -46532,
 1245321015,
 101270,
 -46531,
 1245386306,
 101269,
 -46530,
 1245451630,
 101268,
 -46529,
 1245516880,
 101267,
 -46528,
 1245582123,
 101266,
 -46527,
 1245647355,
 101265,
 -1,
 1245712619,
 101264,
 1245923923,
 1244731623,
 -1,
 -46524,
 1245860339,
 101263,
 -46523,
 1245922498,
 101262,
 -46522,
 1245985621,
 101261,
 -46521,
 1246048168,
 101260,
 -46520,
 1246112007,
 101259,
 -46519,
 1246173770,
 101258,
 -46518,
 1246239128,
 101257,
 -46517,
 1246304487,
 101256,
 -46516,
 1246369799,
 101255,
 -46515,
 1246435127,
 101254,
 -46514,
 1246500418,
 101253,
 -46513,
 1246565742,
 101252,
 -46512,
 1246630992,
 101251,
 -46511,
 1246696235,
 101250,
 -46510,
 1246761467,
 101249,
 -1,
 1246826731,
 101248,
 1247038052,
 1245845511,
 -1,
 -46507,
 1246974451,
 101247,
 -46506,
 1247036610,
 101246,
 -46505,
 1247099733,
 101245,
 -46504,
 1247162280,
 101244,
 -46503,
 1247226119,
 101243,
 -46502,
 1247287882,
 101242,
 -46501,
 1247353240,
 101241,
 -46500,
 1247418599,
 101240,
 -46499,
 1247483911,
 101239,
 -46498,
 1247549239,
 101238,
 -46497,
 1247614530,
 101237,
 -46496,
 1247679854,
 101236,
 -46495,
 1247745104,
 101235,
 -46494,
 1247810347,
 101234,
 -46493,
 1247875579,
 101233,
 -1,
 1247940843,
 101232,
 1248152181,
 1246959415,
 -1,
 -46490,
 1248088563,
 101231,
 -46489,
 1248150722,
 101230,
 -46488,
 1248213845,
 101229,
 -46487,
 1248276392,
 101228,
 -46486,
 1248340231,
 101227,
 -46485,
 1248401994,
 101226,
 -46484,
 1248467352,
 101225,
 -46483,
 1248532711,
 101224,
 -46482,
 1248598023,
 101223,
 -46481,
 1248663351,
 101222,
 -46480,
 1248728642,
 101221,
 -46479,
 1248793966,
 101220,
 -46478,
 1248859216,
 101219,
 -46477,
 1248924459,
 101218,
 -46476,
 1248989691,
 101217,
 -1,
 1249054955,
 101216,
 1249266310,
 1248073282,
 -1,
 -46473,
 1249202675,
 101215,
 -46472,
 1249264834,
 101214,
 -46471,
 1249327957,
 101213,
 -46470,
 1249390504,
 101212,
 -46469,
 1249454343,
 101211,
 -46468,
 1249516106,
 101210,
 -46467,
 1249581464,
 101209,
 -46466,
 1249646823,
 101208,
 -46465,
 1249712135,
 101207,
 -46464,
 1249777463,
 101206,
 -46463,
 1249842754,
 101205,
 -46462,
 1249908078,
 101204,
 -46461,
 1249973328,
 101203,
 -46460,
 1250038571,
 101202,
 -46459,
 1250103803,
 101201,
 -1,
 1250169067,
 101200,
 1250380439,
 1249187182,
 -1,
 -46456,
 1250316787,
 101199,
 -46455,
 1250378946,
 101198,
 -46454,
 1250442069,
 101197,
 -46453,
 1250504616,
 101196,
 -46452,
 1250568455,
 101195,
 -46451,
 1250630218,
 101194,
 -46450,
 1250695576,
 101193,
 -46449,
 1250760935,
 101192,
 -46448,
 1250826247,
 101191,
 -46447,
 1250891575,
 101190,
 -46446,
 1250956866,
 101189,
 -46445,
 1251022190,
 101188,
 -46444,
 1251087440,
 101187,
 -46443,
 1251152683,
 101186,
 -46442,
 1251217915,
 101185,
 -1,
 1251283179,
 101184,
 1251494568,
 1250301008,
 -1,
 -46439,
 1251430899,
 101183,
 -46438,
 1251493058,
 101182,
 -46437,
 1251556181,
 101181,
 -46436,
 1251618728,
 101180,
 -46435,
 1251682567,
 101179,
 -46434,
 1251744330,
 101178,
 -46433,
 1251809688,
 101177,
 -46432,
 1251875047,
 101176,
 -46431,
 1251940359,
 101175,
 -46430,
 1252005687,
 101174,
 -46429,
 1252070978,
 101173,
 -46428,
 1252136302,
 101172,
 -46427,
 1252201552,
 101171,
 -46426,
 1252266795,
 101170,
 -46425,
 1252332027,
 101169,
 -1,
 1252397291,
 101168,
 1252608697,
 1251414827,
 -1,
 -46422,
 1252545011,
 101167,
 -46421,
 1252607170,
 101166,
 -46420,
 1252670293,
 101165,
 -46419,
 1252732840,
 101164,
 -46418,
 1252796679,
 101163,
 -46417,
 1252858442,
 101162,
 -46416,
 1252923800,
 101161,
 -46415,
 1252989159,
 101160,
 -46414,
 1253054471,
 101159,
 -46413,
 1253119799,
 101158,
 -46412,
 1253185090,
 101157,
 -46411,
 1253250414,
 101156,
 -46410,
 1253315664,
 101155,
 -46409,
 1253380907,
 101154,
 -46408,
 1253446139,
 101153,
 -1,
 1253511403,
 101152,
 1253722826,
 1252528635,
 -1,
 -46405,
 1253659123,
 101151,
 -46404,
 1253721282,
 101150,
 -46403,
 1253784405,
 101149,
 -46402,
 1253846952,
 101148,
 -46401,
 1253910791,
 101147,
 -46400,
 1253972554,
 101146,
 -46399,
 1254037912,
 101145,
 -46398,
 1254103271,
 101144,
 -46397,
 1254168583,
 101143,
 -46396,
 1254233911,
 101142,
 -46395,
 1254299202,
 101141,
 -46394,
 1254364526,
 101140,
 -46393,
 1254429776,
 101139,
 -46392,
 1254495019,
 101138,
 -46391,
 1254560251,
 101137,
 -1,
 1254625515,
 101136,
 1254883327,
 1253642475,
 -1,
 -46388,
 1254773235,
 101135,
 -46387,
 1254835394,
 101134,
 -46386,
 1254898517,
 101133,
 -46385,
 1254961064,
 101132,
 -46384,
 1255024903,
 101131,
 -46383,
 1255086666,
 101130,
 -46382,
 1255152024,
 101129,
 -46381,
 1255217383,
 101128,
 -46380,
 1255282695,
 101127,
 -46379,
 1255348023,
 101126,
 -46378,
 1255413314,
 101125,
 -46377,
 1255478638,
 101124,
 -46376,
 1255543888,
 101123,
 -46375,
 1255609131,
 101122,
 -46374,
 1255674363,
 101121,
 -1,
 1255739627,
 101120,
 1255997439,
 1237987240,
 -1,
 1256016621,
 1255878568,
 -1,
 -46370,
 1255952883,
 101583,
 -46369,
 1256015042,
 101582,
 -46368,
 1256078165,
 101581,
 -46367,
 1256140712,
 101580,
 -46366,
 1256204551,
 101579,
 -46365,
 1256266314,
 101578,
 -46364,
 1256331672,
 101577,
 -46363,
 1256397031,
 101576,
 -46362,
 1256462343,
 101575,
 -46361,
 1256527671,
 101574,
 -46360,
 1256592962,
 101573,
 -46359,
 1256658286,
 101572,
 -46358,
 1256723536,
 101571,
 -46357,
 1256788779,
 101570,
 -46356,
 1256854011,
 101569,
 -1,
 1256919275,
 101568,
 1257130750,
 1255942407,
 -1,
 -46353,
 1257066995,
 101567,
 -46352,
 1257129154,
 101566,
 -46351,
 1257192277,
 101565,
 -46350,
 1257254824,
 101564,
 -46349,
 1257318663,
 101563,
 -46348,
 1257380426,
 101562,
 -46347,
 1257445784,
 101561,
 -46346,
 1257511143,
 101560,
 -46345,
 1257576455,
 101559,
 -46344,
 1257641783,
 101558,
 -46343,
 1257707074,
 101557,
 -46342,
 1257772398,
 101556,
 -46341,
 1257837648,
 101555,
 -46340,
 1257902891,
 101554,
 -46339,
 1257968123,
 101553,
 -1,
 1258033387,
 101552,
 1258244879,
 1257052746,
 -1,
 -46336,
 1258181107,
 101551,
 -46335,
 1258243266,
 101550,
 -46334,
 1258306389,
 101549,
 -46333,
 1258368936,
 101548,
 -46332,
 1258432775,
 101547,
 -46331,
 1258494538,
 101546,
 -46330,
 1258559896,
 101545,
 -46329,
 1258625255,
 101544,
 -46328,
 1258690567,
 101543,
 -46327,
 1258755895,
 101542,
 -46326,
 1258821186,
 101541,
 -46325,
 1258886510,
 101540,
 -46324,
 1258951760,
 101539,
 -46323,
 1259017003,
 101538,
 -46322,
 1259082235,
 101537,
 -1,
 1259147499,
 101536,
 1259359008,
 1258166680,
 -1,
 -46319,
 1259295219,
 101535,
 -46318,
 1259357378,
 101534,
 -46317,
 1259420501,
 101533,
 -46316,
 1259483048,
 101532,
 -46315,
 1259546887,
 101531,
 -46314,
 1259608650,
 101530,
 -46313,
 1259674008,
 101529,
 -46312,
 1259739367,
 101528,
 -46311,
 1259804679,
 101527,
 -46310,
 1259870007,
 101526,
 -46309,
 1259935298,
 101525,
 -46308,
 1260000622,
 101524,
 -46307,
 1260065872,
 101523,
 -46306,
 1260131115,
 101522,
 -46305,
 1260196347,
 101521,
 -1,
 1260261611,
 101520,
 1260473137,
 1259280615,
 -1,
 -46302,
 1260409331,
 101519,
 -46301,
 1260471490,
 101518,
 -46300,
 1260534613,
 101517,
 -46299,
 1260597160,
 101516,
 -46298,
 1260660999,
 101515,
 -46297,
 1260722762,
 101514,
 -46296,
 1260788120,
 101513,
 -46295,
 1260853479,
 101512,
 -46294,
 1260918791,
 101511,
 -46293,
 1260984119,
 101510,
 -46292,
 1261049410,
 101509,
 -46291,
 1261114734,
 101508,
 -46290,
 1261179984,
 101507,
 -46289,
 1261245227,
 101506,
 -46288,
 1261310459,
 101505,
 -1,
 1261375723,
 101504,
 1261587266,
 1260394503,
 -1,
 -46285,
 1261523443,
 101503,
 -46284,
 1261585602,
 101502,
 -46283,
 1261648725,
 101501,
 -46282,
 1261711272,
 101500,
 -46281,
 1261775111,
 101499,
 -46280,
 1261836874,
 101498,
 -46279,
 1261902232,
 101497,
 -46278,
 1261967591,
 101496,
 -46277,
 1262032903,
 101495,
 -46276,
 1262098231,
 101494,
 -46275,
 1262163522,
 101493,
 -46274,
 1262228846,
 101492,
 -46273,
 1262294096,
 101491,
 -46272,
 1262359339,
 101490,
 -46271,
 1262424571,
 101489,
 -1,
 1262489835,
 101488,
 1262701395,
 1261508407,
 -1,
 -46268,
 1262637555,
 101487,
 -46267,
 1262699714,
 101486,
 -46266,
 1262762837,
 101485,
 -46265,
 1262825384,
 101484,
 -46264,
 1262889223,
 101483,
 -46263,
 1262950986,
 101482,
 -46262,
 1263016344,
 101481,
 -46261,
 1263081703,
 101480,
 -46260,
 1263147015,
 101479,
 -46259,
 1263212343,
 101478,
 -46258,
 1263277634,
 101477,
 -46257,
 1263342958,
 101476,
 -46256,
 1263408208,
 101475,
 -46255,
 1263473451,
 101474,
 -46254,
 1263538683,
 101473,
 -1,
 1263603947,
 101472,
 1263815524,
 1262622274,
 -1,
 -46251,
 1263751667,
 101471,
 -46250,
 1263813826,
 101470,
 -46249,
 1263876949,
 101469,
 -46248,
 1263939496,
 101468,
 -46247,
 1264003335,
 101467,
 -46246,
 1264065098,
 101466,
 -46245,
 1264130456,
 101465,
 -46244,
 1264195815,
 101464,
 -46243,
 1264261127,
 101463,
 -46242,
 1264326455,
 101462,
 -46241,
 1264391746,
 101461,
 -46240,
 1264457070,
 101460,
 -46239,
 1264522320,
 101459,
 -46238,
 1264587563,
 101458,
 -46237,
 1264652795,
 101457,
 -1,
 1264718059,
 101456,
 1264929653,
 1263736174,
 -1,
 -46234,
 1264865779,
 101455,
 -46233,
 1264927938,
 101454,
 -46232,
 1264991061,
 101453,
 -46231,
 1265053608,
 101452,
 -46230,
 1265117447,
 101451,
 -46229,
 1265179210,
 101450,
 -46228,
 1265244568,
 101449,
 -46227,
 1265309927,
 101448,
 -46226,
 1265375239,
 101447,
 -46225,
 1265440567,
 101446,
 -46224,
 1265505858,
 101445,
 -46223,
 1265571182,
 101444,
 -46222,
 1265636432,
 101443,
 -46221,
 1265701675,
 101442,
 -46220,
 1265766907,
 101441,
 -1,
 1265832171,
 101440,
 1266043782,
 1264850000,
 -1,
 -46217,
 1265979891,
 101439,
 -46216,
 1266042050,
 101438,
 -46215,
 1266105173,
 101437,
 -46214,
 1266167720,
 101436,
 -46213,
 1266231559,
 101435,
 -46212,
 1266293322,
 101434,
 -46211,
 1266358680,
 101433,
 -46210,
 1266424039,
 101432,
 -46209,
 1266489351,
 101431,
 -46208,
 1266554679,
 101430,
 -46207,
 1266619970,
 101429,
 -46206,
 1266685294,
 101428,
 -46205,
 1266750544,
 101427,
 -46204,
 1266815787,
 101426,
 -46203,
 1266881019,
 101425,
 -1,
 1266946283,
 101424,
 1267157911,
 1265963819,
 -1,
 -46200,
 1267094003,
 101423,
 -46199,
 1267156162,
 101422,
 -46198,
 1267219285,
 101421,
 -46197,
 1267281832,
 101420,
 -46196,
 1267345671,
 101419,
 -46195,
 1267407434,
 101418,
 -46194,
 1267472792,
 101417,
 -46193,
 1267538151,
 101416,
 -46192,
 1267603463,
 101415,
 -46191,
 1267668791,
 101414,
 -46190,
 1267734082,
 101413,
 -46189,
 1267799406,
 101412,
 -46188,
 1267864656,
 101411,
 -46187,
 1267929899,
 101410,
 -46186,
 1267995131,
 101409,
 -1,
 1268060395,
 101408,
 1268272040,
 1267077627,
 -1,
 -46183,
 1268208115,
 101407,
 -46182,
 1268270274,
 101406,
 -46181,
 1268333397,
 101405,
 -46180,
 1268395944,
 101404,
 -46179,
 1268459783,
 101403,
 -46178,
 1268521546,
 101402,
 -46177,
 1268586904,
 101401,
 -46176,
 1268652263,
 101400,
 -46175,
 1268717575,
 101399,
 -46174,
 1268782903,
 101398,
 -46173,
 1268848194,
 101397,
 -46172,
 1268913518,
 101396,
 -46171,
 1268978768,
 101395,
 -46170,
 1269044011,
 101394,
 -46169,
 1269109243,
 101393,
 -1,
 1269174507,
 101392,
 1269386169,
 1268191467,
 -1,
 -46166,
 1269322227,
 101391,
 -46165,
 1269384386,
 101390,
 -46164,
 1269447509,
 101389,
 -46163,
 1269510056,
 101388,
 -46162,
 1269573895,
 101387,
 -46161,
 1269635658,
 101386,
 -46160,
 1269701016,
 101385,
 -46159,
 1269766375,
 101384,
 -46158,
 1269831687,
 101383,
 -46157,
 1269897015,
 101382,
 -46156,
 1269962306,
 101381,
 -46155,
 1270027630,
 101380,
 -46154,
 1270092880,
 101379,
 -46153,
 1270158123,
 101378,
 -46152,
 1270223355,
 101377,
 -1,
 1270288619,
 101376,
 1270546431,
 1269316437,
 -1,
 -46149,
 1270421058,
 101589,
 -46148,
 1270486382,
 101588,
 -46147,
 1270551632,
 101587,
 -46146,
 1270616875,
 101586,
 -46145,
 1270682107,
 101585,
 -1,
 1270747371,
 101584,
 -1,
 1237930884,
 94180,
 1271024710,
 1237880252,
 -1,
 1271090188,
 1270989268,
 -1,
 1271155723,
 1271068005,
 -1,
 1271221211,
 1271114192,
 -1,
 1271286743,
 1271182675,
 -1,
 1271352276,
 1271205714,
 -1,
 1271417806,
 1271277831,
 -1,
 1271483339,
 1271390538,
 -1,
 -46134,
 1271447371,
 6649,
 -1,
 1271495523,
 6633,
 1271726079,
 1271417232,
 -1,
 -46131,
 1271643979,
 6648,
 -1,
 1271692131,
 6632,
 1271876561,
 1271377286,
 -1,
 -46128,
 1271840587,
 6647,
 -1,
 1271888739,
 6631,
 1272119295,
 1271829063,
 -1,
 -46125,
 1272037195,
 6646,
 -1,
 1272085347,
 6630,
 1272315903,
 1271267328,
 -1,
 -46122,
 1272233803,
 6645,
 -1,
 1272281955,
 6629,
 1272466394,
 1271229528,
 -1,
 -46119,
 1272430411,
 6642,
 -1,
 1272478563,
 6626,
 -1,
 1272391533,
 6624,
 1272728561,
 1271151754,
 -1,
 1272794094,
 1272647506,
 -1,
 1272859620,
 1272752592,
 -1,
 1272925153,
 1272821079,
 -1,
 -46112,
 1272889163,
 6655,
 -1,
 1272937315,
 6639,
 1273167871,
 1272867928,
 -1,
 -46109,
 1273085771,
 6652,
 -1,
 1273133923,
 6636,
 1273318379,
 1272785159,
 -1,
 1273383912,
 1273291082,
 -1,
 -46105,
 1273347915,
 6654,
 -1,
 1273396067,
 6638,
 1273626623,
 1273317776,
 -1,
 -46102,
 1273544523,
 6653,
 -1,
 1273592675,
 6637,
 1273823231,
 1273270855,
 -1,
 -46099,
 1273741131,
 6651,
 -1,
 1273789283,
 6635,
 1274019839,
 1272709120,
 -1,
 -46096,
 1273937739,
 6650,
 -1,
 1273985891,
 6634,
 1274170368,
 1272676923,
 -1,
 1274235899,
 1274128848,
 -1,
 1274301434,
 1274197331,
 6133,
 1274413055,
 1274220370,
 -1,
 1274432504,
 1274292487,
 -1,
 -46089,
 1274405190,
 6137,
 -1,
 1274431885,
 6136,
 -46087,
 1274391938,
 6135,
 -1,
 1274581570,
 6134,
 -1,
 1274244181,
 6130,
 1274825726,
 1274161415,
 -1,
 -46083,
 1274798406,
 6132,
 -1,
 1274825101,
 6131,
 -46081,
 1274792730,
 6128,
 -1,
 1274974786,
 6129,
 1275153415,
 1274095879,
 -1,
 1275218948,
 1275126090,
 -1,
 -46077,
 1275182923,
 6644,
 -1,
 1275231075,
 6628,
 1275461631,
 1275152784,
 -1,
 -46074,
 1275379531,
 6643,
 -1,
 1275427683,
 6627,
 1275612170,
 1275105863,
 -1,
 -46071,
 1275576139,
 6641,
 -1,
 1275624291,
 6625,
 -1,
 1275583355,
 6640,
 -1,
 1271098375,
 6109,
 1275939900,
 1271019421,
 -1,
 1276005398,
 1275908086,
 -1,
 1276070929,
 1275974477,
 -1,
 -46064,
 1276025537,
 983950,
 -1,
 1276058186,
 983948,
 1276267540,
 1276009916,
 -1,
 -46061,
 1276222145,
 983955,
 -1,
 1276254794,
 983953,
 -46059,
 1276222145,
 983954,
 -1,
 1276385866,
 983952,
 1276595227,
 1275957920,
 -1,
 -46056,
 1276573094,
 983946,
 -46055,
 1276615361,
 983956,
 -46054,
 1276664893,
 983941,
 -1,
 1276713546,
 983951,
 1276922913,
 1276541024,
 -1,
 1276988447,
 1276861884,
 -1,
 -46050,
 1276943041,
 983940,
 -1,
 1276975690,
 983938,
 -46048,
 1276943041,
 983939,
 -1,
 1277106762,
 983937,
 1277316135,
 1276850088,
 -1,
 1277381669,
 1277255100,
 -1,
 -46044,
 1277336257,
 983945,
 -1,
 1277368906,
 983943,
 -46042,
 1277336257,
 983944,
 -1,
 1277499978,
 983942,
 1277709355,
 1277280724,
 -1,
 -46039,
 1277674153,
 983967,
 -46038,
 1277713870,
 983966,
 -1,
 1277762122,
 983968,
 1277971504,
 1277667792,
 -1,
 1278037039,
 1277910460,
 -1,
 -46034,
 1277991617,
 983960,
 -1,
 1278024266,
 983958,
 -1,
 1277991617,
 983959,
 1278299187,
 1277918267,
 -1,
 -46030,
 1278253761,
 983964,
 -1,
 1278286410,
 983970,
 1278495798,
 1278229333,
 -1,
 -46027,
 1278450369,
 983949,
 -1,
 1278483018,
 983947,
 -46025,
 1278473638,
 983962,
 -46024,
 1278667063,
 983965,
 -46023,
 1278721834,
 983963,
 -46022,
 1278775400,
 983961,
 -46021,
 1278827982,
 983969,
 -1,
 1278880056,
 983957,
 1279085634,
 1275882937,
 -1,
 1279151167,
 1279050135,
 983973,
 -1,
 1279128374,
 983974,
 1279328255,
 1279111694,
 -1,
 -46015,
 1279253691,
 983972,
 -1,
 1279280322,
 983975,
 1279524863,
 1279060522,
 -1,
 -46012,
 1279434219,
 983976,
 -46011,
 1279473260,
 983971,
 -1,
 1279531808,
 983977,
 1279741089,
 1270996719,
 -1,
 1279806596,
 1279689378,
 -1,
 1279872079,
 1279736661,
 -1,
 1279937613,
 1279802197,
 -1,
 -46005,
 1279876558,
 70347,
 -46004,
 1279933440,
 70345,
 -1,
 1279990346,
 70344,
 -46002,
 1279876558,
 70352,
 -1,
 1280121418,
 70351,
 1280330837,
 1279840246,
 -1,
 1280396371,
 1280298998,
 -1,
 -45998,
 1280335310,
 70343,
 -1,
 1280383562,
 70342,
 -45996,
 1280335310,
 70350,
 -1,
 1280514634,
 70349,
 1280724058,
 1280283296,
 -1,
 -45993,
 1280701370,
 70341,
 -45992,
 1280742122,
 70348,
 -45991,
 1280792738,
 70335,
 -1,
 1280842314,
 70353,
 1281051742,
 1280645706,
 70320,
 -45988,
 1281023163,
 70329,
 -45987,
 1281058813,
 70327,
 -1,
 1281104458,
 70321,
 1281313890,
 1280997185,
 -1,
 -45984,
 1281259359,
 70339,
 -45983,
 1281318350,
 70340,
 -1,
 1281366602,
 70338,
 1281576038,
 1281251411,
 -1,
 -45980,
 1281514958,
 70334,
 -45979,
 1281579170,
 70333,
 -1,
 1281628746,
 70332,
 1281838186,
 1281501447,
 -1,
 -45976,
 1281777102,
 70358,
 -45975,
 1281829176,
 70357,
 -1,
 1281890890,
 70356,
 1282100332,
 1281809595,
 70324,
 -1,
 1282071739,
 70325,
 1282231407,
 1282064852,
 -1,
 -45970,
 1282170318,
 70364,
 -1,
 1282218570,
 70365,
 1282428018,
 1282192354,
 -1,
 -45967,
 1282389076,
 70346,
 -1,
 1282415178,
 70361,
 1282624629,
 1282386384,
 -1,
 -45964,
 1282563534,
 70355,
 -1,
 1282611786,
 70354,
 1282821240,
 1282570336,
 -1,
 -45961,
 1282760142,
 70331,
 -1,
 1282808394,
 70330,
 1283017850,
 1282762749,
 70322,
 -1,
 1282959357,
 70323,
 1283148925,
 1282944936,
 -1,
 -45956,
 1283087822,
 70337,
 -1,
 1283136074,
 70336,
 -45954,
 1283126202,
 70360,
 -45953,
 1283319213,
 70363,
 -45952,
 1283365569,
 70328,
 -45951,
 1283426722,
 70359,
 -45950,
 1283488901,
 70362,
 -45949,
 1283546574,
 70366,
 -1,
 1283605698,
 70326,
 1283804306,
 1279737581,
 -1,
 1283869832,
 1283772406,
 -1,
 -45945,
 1283846195,
 70386,
 -1,
 1283876383,
 70387,
 1284066443,
 1283834324,
 -1,
 -45942,
 1284011684,
 70390,
 -1,
 1284067300,
 70391,
 1284263054,
 1284002291,
 -1,
 -45939,
 1284220440,
 70388,
 -1,
 1284273642,
 70389,
 -45937,
 1284241200,
 70384,
 -45936,
 1284415257,
 70385,
 -45935,
 1284478702,
 70393,
 -1,
 1284524446,
 70392,
 1284721821,
 1283779114,
 -1,
 1284787351,
 1284643402,
 -1,
 -45931,
 1284758715,
 70376,
 -45930,
 1284794365,
 70374,
 -1,
 1284840010,
 70368,
 1285049497,
 1284758715,
 70371,
 -1,
 1285020859,
 70372,
 1285180571,
 1284990973,
 70369,
 -1,
 1285122045,
 70370,
 -45924,
 1285135041,
 70375,
 -1,
 1285244098,
 70373,
 1285488639,
 1284687835,
 -1,
 -45921,
 1285417229,
 70378,
 -45920,
 1285462509,
 70377,
 -1,
 1285497798,
 70367,
 1285704963,
 1279665544,
 -1,
 1285770453,
 1285653154,
 -1,
 1285835948,
 1285738486,
 -1,
 1285901482,
 1285804022,
 -1,
 1285967016,
 1285869558,
 -1,
 -45913,
 1285905870,
 68147,
 -1,
 1285954122,
 68148,
 -45911,
 1285905870,
 68123,
 -1,
 1286085194,
 68122,
 -45909,
 1285840334,
 68128,
 -1,
 1286216266,
 68127,
 1286425778,
 1285765973,
 -1,
 1286491312,
 1286355797,
 -1,
 -45905,
 1286430158,
 68125,
 -1,
 1286478410,
 68124,
 -45903,
 1286430158,
 68130,
 -1,
 1286609482,
 68129,
 1286818998,
 1286390228,
 -1,
 -45900,
 1286783657,
 68142,
 -45899,
 1286823374,
 68141,
 -1,
 1286871626,
 68143,
 1287081146,
 1286771360,
 -1,
 -45896,
 1287058362,
 68121,
 -45895,
 1287099114,
 68126,
 -1,
 1287133770,
 68131,
 1287343294,
 1287026784,
 -1,
 -45892,
 1287289024,
 68146,
 -45891,
 1287347662,
 68113,
 -1,
 1287395914,
 68112,
 1287605441,
 1287316890,
 -1,
 -45888,
 1287544270,
 68149,
 -1,
 1287592522,
 68140,
 1287802052,
 1287563728,
 -1,
 -45885,
 1287740878,
 68133,
 -1,
 1287789130,
 68132,
 1287998663,
 1287739475,
 -1,
 -45882,
 1287937486,
 68115,
 -1,
 1287985738,
 68114,
 1288195274,
 1287925672,
 -1,
 -45879,
 1288134094,
 68118,
 -1,
 1288182346,
 68117,
 1288391885,
 1288120583,
 -1,
 -45876,
 1288330702,
 68135,
 -1,
 1288378954,
 68134,
 -45874,
 1288369779,
 68144,
 -45873,
 1288565690,
 68137,
 -45872,
 1288614996,
 68138,
 -45871,
 1288669602,
 68136,
 -45870,
 1288731781,
 68139,
 -45869,
 1288795999,
 68119,
 -45868,
 1288854990,
 68145,
 -1,
 1288903242,
 68096,
 1289112803,
 1285730658,
 -1,
 1289178331,
 1289042773,
 -1,
 1289243866,
 1289132737,
 -1,
 -45863,
 1289215498,
 68183,
 -1,
 1289277430,
 68176,
 -1,
 1289167497,
 68182,
 1289506014,
 1289124923,
 -1,
 -45859,
 1289463187,
 68181,
 -1,
 1289514659,
 68184,
 1289702625,
 1289433000,
 -1,
 -45856,
 1289664670,
 68179,
 -1,
 1289712462,
 68178,
 -45854,
 1289669061,
 68177,
 -1,
 1289849665,
 68180,
 1290030317,
 1289086362,
 -1,
 1290095852,
 1289988420,
 -1,
 1290161387,
 1290061787,
 -1,
 -45849,
 1290135908,
 68099,
 -45848,
 1290198203,
 68098,
 -45847,
 1290246849,
 68102,
 -45846,
 1290299389,
 68097,
 -1,
 1290355906,
 68101,
 -1,
 1290109521,
 68108,
 -1,
 1290040136,
 68159,
 1290685685,
 1289996251,
 -1,
 1290751217,
 1290616723,
 -1,
 -45840,
 1290722890,
 68109,
 -1,
 1290784782,
 68154,
 -45838,
 1290725652,
 68111,
 -45837,
 1290875260,
 68153,
 -45836,
 1290938834,
 68152,
 -1,
 1291002822,
 68110,
 1291209980,
 1290639863,
 -1,
 1291275513,
 1291177974,
 -1,
 -45832,
 1291250769,
 68165,
 -1,
 1291274977,
 68164,
 1291517951,
 1291231005,
 -1,
 -45829,
 1291441204,
 68167,
 -1,
 1291478898,
 68166,
 1291668738,
 1291140845,
 -1,
 1291734272,
 1291636726,
 -1,
 -45825,
 1291710515,
 68161,
 -1,
 1291740703,
 68162,
 -45823,
 1291689753,
 68160,
 -1,
 1291867762,
 68163,
 -1,
 1291605863,
 68168,
 1292173311,
 1285659883,
 -1,
 1292193084,
 1292075682,
 -1,
 1292258572,
 1292122965,
 -1,
 1292324106,
 1292188501,
 -1,
 -45816,
 1292262862,
 70167,
 -45815,
 1292319744,
 70172,
 -1,
 1292376650,
 70166,
 -45813,
 1292262862,
 70173,
 -1,
 1292507722,
 70171,
 1292717330,
 1292226550,
 -1,
 1292782864,
 1292685302,
 -1,
 -45809,
 1292721614,
 70165,
 -1,
 1292769866,
 70164,
 -45807,
 1292721614,
 70170,
 -1,
 1292900938,
 70169,
 1293110551,
 1292669600,
 -1,
 -45804,
 1293087674,
 70163,
 -45803,
 1293128426,
 70168,
 -45802,
 1293179042,
 70157,
 -1,
 1293228618,
 70174,
 1293438235,
 1293032010,
 70144,
 -45799,
 1293409467,
 70151,
 -45798,
 1293445117,
 70149,
 -1,
 1293490762,
 70145,
 1293700383,
 1293375571,
 -1,
 -45795,
 1293639118,
 70156,
 -45794,
 1293703330,
 70155,
 -1,
 1293752906,
 70154,
 1293962531,
 1293625607,
 -1,
 -45791,
 1293901262,
 70179,
 -45790,
 1293953336,
 70178,
 -1,
 1294015050,
 70177,
 1294224678,
 1293920720,
 -1,
 -45787,
 1294163406,
 70176,
 -1,
 1294211658,
 70175,
 1294421289,
 1294171195,
 -1,
 -45784,
 1294367877,
 70187,
 -1,
 1294408266,
 70183,
 1294617900,
 1294366816,
 -1,
 -45781,
 1294556622,
 70153,
 -1,
 1294604874,
 70152,
 1294814511,
 1294563137,
 -1,
 -45778,
 1294759775,
 70161,
 -1,
 1294801482,
 70160,
 1295011122,
 1294741416,
 -1,
 -45775,
 1294949838,
 70159,
 -1,
 1294998090,
 70158,
 -45773,
 1294988218,
 70181,
 -45772,
 1295181229,
 70184,
 -45771,
 1295244475,
 70147,
 -45770,
 1295303337,
 70185,
 -45769,
 1295365204,
 70182,
 -45768,
 1295424193,
 70150,
 -45767,
 1295485346,
 70180,
 -45766,
 1295542269,
 70146,
 -45765,
 1295605198,
 70186,
 -1,
 1295664322,
 70148,
 1295863110,
 1292167722,
 -1,
 1295928641,
 1295784522,
 -1,
 -45761,
 1295899835,
 70195,
 -45760,
 1295935485,
 70193,
 -1,
 1295981130,
 70188,
 1296190787,
 1295869949,
 70189,
 -1,
 1296132093,
 70190,
 -45756,
 1296161979,
 70191,
 -45755,
 1296276161,
 70194,
 -1,
 1296319682,
 70192,
 1296518479,
 1295827412,
 -1,
 1296584014,
 1296460802,
 -1,
 1296649547,
 1296548308,
 -1,
 -45750,
 1296621464,
 70206,
 -1,
 1296653811,
 70199,
 -45748,
 1296623885,
 70197,
 -45747,
 1296800237,
 70198,
 -1,
 1296835526,
 70196,
 -1,
 1296516880,
 70203,
 1297108308,
 1296448341,
 -1,
 1297173843,
 1297065371,
 -1,
 -45742,
 1297138722,
 70204,
 -1,
 1297169532,
 70201,
 -1,
 1297097353,
 70200,
 -45739,
 1297084853,
 70202,
 -1,
 1297357707,
 70205,
 1297567253,
 1237785162,
 -1,
 1297632688,
 1297511846,
 -1,
 1297698195,
 1297580706,
 -1,
 1297763680,
 1297627989,
 -1,
 1297829214,
 1297693525,
 -1,
 -45732,
 1297767886,
 69787,
 -45731,
 1297825335,
 69786,
 -1,
 1297881674,
 69785,
 -45729,
 1297767886,
 69793,
 -1,
 1298012746,
 69792,
 1298222438,
 1297731574,
 -1,
 1298287972,
 1298190326,
 -1,
 -45725,
 1298226638,
 69784,
 -1,
 1298274890,
 69783,
 -45723,
 1298226638,
 69791,
 -1,
 1298405962,
 69790,
 1298615659,
 1298174624,
 -1,
 -45720,
 1298592698,
 69782,
 -45719,
 1298633450,
 69789,
 -45718,
 1298684066,
 69777,
 -1,
 1298733642,
 69794,
 1298943343,
 1298537034,
 69763,
 -45715,
 1298914491,
 69772,
 -45714,
 1298950141,
 69770,
 -1,
 1298995786,
 69764,
 1299205491,
 1298907604,
 -1,
 -45711,
 1299169961,
 69805,
 -45710,
 1299209678,
 69804,
 -1,
 1299257930,
 69806,
 1299467637,
 1299176635,
 69767,
 -1,
 1299438779,
 69768,
 1299598712,
 1299428322,
 -1,
 -45705,
 1299537358,
 69788,
 -1,
 1299585610,
 69801,
 1299795323,
 1299556816,
 -1,
 -45702,
 1299733966,
 69796,
 -1,
 1299782218,
 69795,
 1299991934,
 1299740768,
 -1,
 -45699,
 1299930574,
 69774,
 -1,
 1299978826,
 69773,
 1300188545,
 1299937089,
 -1,
 -45696,
 1300127182,
 69781,
 -1,
 1300175434,
 69780,
 1300385155,
 1300129789,
 69765,
 -1,
 1300326397,
 69766,
 1300516230,
 1300322387,
 -1,
 -45691,
 1300454862,
 69776,
 -1,
 1300503114,
 69775,
 1300712841,
 1300443048,
 -1,
 -45688,
 1300651470,
 69779,
 -1,
 1300699722,
 69778,
 1300909452,
 1300637959,
 -1,
 -45685,
 1300848078,
 69798,
 -1,
 1300896330,
 69797,
 -45683,
 1300886458,
 69800,
 -45682,
 1301079469,
 69803,
 -45681,
 1301125825,
 69771,
 -45680,
 1301186978,
 69799,
 -45679,
 1301249157,
 69802,
 -45678,
 1301306830,
 69807,
 -1,
 1301365954,
 69769,
 1301564830,
 1297672746,
 -1,
 1301630360,
 1301486154,
 -1,
 -45674,
 1301601467,
 69816,
 -45673,
 1301637117,
 69814,
 -1,
 1301682762,
 69808,
 1301892506,
 1301601467,
 69811,
 -1,
 1301863611,
 69812,
 1302023580,
 1301833725,
 69809,
 -1,
 1301964797,
 69810,
 -45667,
 1301977793,
 69815,
 -1,
 1302086850,
 69813,
 1302285735,
 1301529044,
 -1,
 1302351270,
 1302227970,
 -1,
 1302416803,
 1302325425,
 -1,
 -45662,
 1302381460,
 69762,
 -1,
 1302443365,
 69817,
 -45660,
 1302370797,
 69818,
 -45659,
 1302540412,
 69760,
 -1,
 1302602694,
 69761,
 -1,
 1302284048,
 69822,
 1302875564,
 1302215509,
 -1,
 1302941099,
 1302832539,
 -1,
 -45654,
 1302905890,
 69823,
 -1,
 1302936700,
 69825,
 -1,
 1302864521,
 69824,
 1303203246,
 1302829567,
 69821,
 -1,
 1303117829,
 69837,
 -45649,
 1303137398,
 69820,
 -1,
 1303255947,
 69819,
 1303465456,
 1297609677,
 -1,
 1303530965,
 1303413410,
 -1,
 1303596470,
 1303483040,
 -1,
 -45644,
 1303573434,
 43281,
 -45643,
 1303599266,
 43277,
 -1,
 1303648842,
 43284,
 1303858617,
 1303564278,
 -1,
 -45640,
 1303797198,
 43294,
 -1,
 1303845450,
 43282,
 1304055228,
 1303822804,
 -1,
 -45637,
 1303993806,
 43279,
 -1,
 1304042058,
 43278,
 1304251839,
 1304013264,
 -1,
 -45634,
 1304190414,
 43286,
 -1,
 1304238666,
 43285,
 1304448450,
 1304206017,
 -1,
 -45631,
 1304402625,
 43301,
 -1,
 1304446146,
 43299,
 1304645061,
 1304393824,
 -1,
 -45628,
 1304583630,
 43275,
 -1,
 1304631882,
 43274,
 1304841672,
 1304583612,
 -1,
 -45625,
 1304809596,
 43283,
 -1,
 1304828490,
 43295,
 -45623,
 1304819315,
 43280,
 -45622,
 1305015226,
 43291,
 -45621,
 1305078497,
 43293,
 -45620,
 1305142701,
 43296,
 -45619,
 1305195604,
 43290,
 -45618,
 1305250210,
 43287,
 -45617,
 1305312389,
 43292,
 -45616,
 1305372669,
 43300,
 -45615,
 1305434274,
 43276,
 -45614,
 1305492480,
 43288,
 -45613,
 1305554911,
 43297,
 -45612,
 1305618744,
 43289,
 -1,
 1305680458,
 43298,
 1305890275,
 1303461613,
 -1,
 1305955801,
 1305858038,
 -1,
 -45608,
 1305931827,
 43266,
 -1,
 1305962015,
 43267,
 1306152412,
 1305919956,
 -1,
 -45605,
 1306097316,
 43270,
 -1,
 1306152932,
 43271,
 1306349023,
 1306087923,
 -1,
 -45602,
 1306306072,
 43268,
 -1,
 1306359274,
 43269,
 -45600,
 1306326832,
 43264,
 -45599,
 1306500889,
 43265,
 -45598,
 1306564334,
 43273,
 -1,
 1306610078,
 43272,
 1306807785,
 1305864680,
 -1,
 1306873318,
 1306778811,
 43304,
 -1,
 1306805442,
 43302,
 1307004392,
 1306805442,
 43303,
 -1,
 1306936514,
 43305,
 -1,
 1306958529,
 43306,
 1307201005,
 1306777410,
 -1,
 1307266540,
 1307127861,
 43308,
 -1,
 1307182871,
 43309,
 -1,
 1307225664,
 43307,
 1307508735,
 1307166683,
 -1,
 -45585,
 1307428705,
 43311,
 -1,
 1307458365,
 43310,
 1307659781,
 1303433492,
 -1,
 1307725303,
 1307585502,
 -1,
 -45581,
 1307696315,
 983985,
 -45580,
 1307744961,
 983987,
 -45579,
 1307797501,
 983984,
 -45578,
 1307854018,
 983986,
 -1,
 1307908682,
 983983,
 1308118527,
 1307646538,
 -1,
 1308184062,
 1308062079,
 -1,
 1308249596,
 1308151798,
 -1,
 -45573,
 1308220603,
 983989,
 -1,
 1308269249,
 983990,
 -45571,
 1308207568,
 983991,
 -1,
 1308373410,
 983988,
 -1,
 1308145198,
 110592,
 1308688383,
 1308084561,
 -1,
 1308708356,
 1308617377,
 -1,
 -45566,
 1308662465,
 110950,
 -45565,
 1308715005,
 110948,
 -1,
 1308771522,
 110949,
 -1,
 1308660384,
 110951,
 1309036052,
 1307611808,
 -1,
 1309101587,
 1308988198,
 -1,
 1309167120,
 1309067227,
 -1,
 1309232651,
 1309131220,
 -1,
 -45558,
 1309190735,
 3200,
 -1,
 1309239753,
 3204,
 -45556,
 1309204994,
 3314,
 -45555,
 1309383149,
 3260,
 -45554,
 1309439957,
 3313,
 -45553,
 1309487228,
 3201,
 -1,
 1309550710,
 3261,
 1309756946,
 1309141592,
 3298,
 -1,
 1309703227,
 3299,
 -1,
 1309704874,
 983203,
 -1,
 1309038954,
 129432,
 -1,
 1308957527,
 128331,
 1310084649,
 1297502689,
 128273,
 1310150184,
 1310011570,
 -1,
 1310215717,
 1310080749,
 -1,
 1310281243,
 1310183414,
 -1,
 -45542,
 1310257203,
 983556,
 -1,
 1310287391,
 983557,
 1310477854,
 1310245332,
 -1,
 -45539,
 1310422692,
 983560,
 -1,
 1310478308,
 983561,
 1310674465,
 1310413299,
 -1,
 -45536,
 1310631448,
 983558,
 -1,
 1310684650,
 983559,
 -45534,
 1310652208,
 983554,
 -45533,
 1310826265,
 983555,
 -45532,
 1310889710,
 983563,
 -1,
 1310935454,
 983562,
 -45530,
 1310184087,
 128287,
 -45529,
 1311087103,
 983552,
 -1,
 1311123198,
 983553,
 -1,
 1310076281,
 128422,
 1311395381,
 1310025725,
 -1,
 1311460914,
 1311362075,
 128143,
 1311526449,
 1311403716,
 -1,
 1311591984,
 1311461963,
 128535,
 1311703039,
 1311509458,
 -1,
 -45521,
 1311623835,
 128537,
 -1,
 1311651288,
 128538,
 -1,
 1311519047,
 128573,
 -1,
 1311442106,
 128139,
 -45517,
 1311436272,
 129373,
 -45516,
 1311953367,
 129665,
 -1,
 1312002271,
 128088,
 1312181816,
 1311347360,
 -1,
 -45513,
 1312138422,
 129698,
 -1,
 1312180255,
 129486,
 -45511,
 1312145298,
 11235,
 -1,
 1312332573,
 128040,
 1312510485,
 1237771674,
 -1,
 1312575641,
 1312430666,
 -1,
 1312640919,
 1312516095,
 -1,
 1312706438,
 1312608140,
 -1,
 1312771955,
 1312654657,
 -1,
 1312837234,
 1312723616,
 -1,
 1312902733,
 1312774227,
 42507,
 1312968266,
 1312839763,
 -1,
 1313033797,
 1312900290,
 42500,
 -45500,
 1312985760,
 42501,
 -1,
 1313031362,
 42271,
 1313230407,
 1312987841,
 42460,
 -1,
 1313184449,
 42384,
 -45496,
 1313201339,
 42421,
 -45495,
 1313302525,
 42308,
 -1,
 1313348170,
 42348,
 -45493,
 1312923262,
 42428,
 -45492,
 1313491681,
 42467,
 -1,
 1313546533,
 42315,
 1313754715,
 1312832341,
 -1,
 1313820246,
 1313708737,
 42450,
 1313885781,
 1313767231,
 -1,
 -45487,
 1313852195,
 42514,
 -45486,
 1313900962,
 42538,
 -45485,
 1313962176,
 42513,
 -45484,
 1314017864,
 42512,
 -1,
 1314078611,
 42539,
 -1,
 1313839809,
 42374,
 1314344536,
 1313752258,
 42490,
 -1,
 1314276546,
 42261,
 -45479,
 1314315451,
 42411,
 -45478,
 1314416637,
 42298,
 -1,
 1314462282,
 42337,
 1314672227,
 1313731382,
 -1,
 1314737758,
 1314626241,
 42464,
 -1,
 1314691777,
 42388,
 1314868832,
 1314669762,
 42506,
 -1,
 1314800834,
 42275,
 -45471,
 1314839739,
 42425,
 -45470,
 1314940925,
 42312,
 -1,
 1314986570,
 42352,
 1315196523,
 1314617153,
 -1,
 1315262054,
 1315150529,
 42457,
 -1,
 1315216065,
 42381,
 1315393128,
 1315194050,
 42497,
 -1,
 1315325122,
 42268,
 -45463,
 1315364027,
 42418,
 -45462,
 1315465213,
 42305,
 -1,
 1315510858,
 42344,
 1315720813,
 1315150529,
 42463,
 -1,
 1315674817,
 42387,
 1315851887,
 1315652802,
 42505,
 -1,
 1315783874,
 42274,
 -45456,
 1315822779,
 42424,
 -45455,
 1315923965,
 42311,
 -1,
 1315969610,
 42351,
 1316179594,
 1312786764,
 -1,
 1316245115,
 1316116889,
 -1,
 1316310646,
 1316199105,
 42438,
 -1,
 1316264641,
 42363,
 1316441720,
 1316242626,
 42478,
 -1,
 1316373698,
 42250,
 -45447,
 1316412603,
 42400,
 -45446,
 1316513789,
 42287,
 -1,
 1316559434,
 42326,
 1316769411,
 1316169991,
 -1,
 1316834942,
 1316723393,
 42436,
 -1,
 1316788929,
 42361,
 1316966016,
 1316766914,
 42475,
 -1,
 1316897986,
 42248,
 -45439,
 1316936891,
 42398,
 -45438,
 1317038077,
 42285,
 -1,
 1317083722,
 42323,
 1317293701,
 1316723393,
 42462,
 -1,
 1317247681,
 42386,
 1317424775,
 1317225666,
 42504,
 -1,
 1317356738,
 42273,
 -45432,
 1317395643,
 42423,
 -45431,
 1317496829,
 42310,
 -1,
 1317542474,
 42350,
 1317752482,
 1316109141,
 -1,
 1317818011,
 1317690812,
 -1,
 1317883540,
 1317756348,
 -1,
 1317949071,
 1317837505,
 42446,
 -1,
 1317903041,
 42370,
 1318080145,
 1317881026,
 42486,
 -1,
 1318012098,
 42257,
 -45422,
 1318051003,
 42407,
 -45421,
 1318152189,
 42294,
 -1,
 1318197834,
 42333,
 1318407830,
 1317837505,
 42445,
 -1,
 1318361793,
 42369,
 1318538904,
 1318339778,
 42485,
 -1,
 1318470850,
 42256,
 -45415,
 1318509755,
 42406,
 -45414,
 1318610941,
 42293,
 -1,
 1318656586,
 42332,
 1318866589,
 1317771969,
 42449,
 -1,
 1318820545,
 42373,
 1318997663,
 1318798530,
 42489,
 -1,
 1318929602,
 42260,
 -45408,
 1318968507,
 42410,
 -45407,
 1319069693,
 42297,
 -1,
 1319115338,
 42336,
 1319325365,
 1317697632,
 -1,
 1319390893,
 1319283152,
 -1,
 1319456423,
 1319322818,
 42476,
 -45402,
 1319408288,
 42477,
 -1,
 1319453890,
 42249,
 1319653033,
 1319410369,
 42437,
 -1,
 1319606977,
 42362,
 1319784107,
 1319574090,
 42324,
 -1,
 1319735968,
 42325,
 -45396,
 1319754939,
 42399,
 -1,
 1319856125,
 42286,
 1320046255,
 1319344833,
 42459,
 -1,
 1320000193,
 42383,
 1320177329,
 1319978178,
 42499,
 -1,
 1320109250,
 42270,
 1320308403,
 1320098378,
 42346,
 -1,
 1320260256,
 42347,
 -45388,
 1320279227,
 42420,
 -1,
 1320380413,
 42307,
 1320570568,
 1319262291,
 -1,
 1320636096,
 1320495367,
 -1,
 1320701626,
 1320590017,
 42439,
 -45383,
 1320655553,
 42364,
 -1,
 1320719008,
 42440,
 1320898237,
 1320633538,
 42479,
 -45380,
 1320850080,
 42480,
 -1,
 1320895682,
 42251,
 -45378,
 1320869051,
 42401,
 -45377,
 1321035773,
 42288,
 -1,
 1321081418,
 42327,
 1321291459,
 1320568002,
 42502,
 -45374,
 1321243296,
 42503,
 -1,
 1321288898,
 42272,
 1321488069,
 1321245377,
 42461,
 -1,
 1321441985,
 42385,
 -45370,
 1321458875,
 42422,
 -45369,
 1321560061,
 42309,
 -1,
 1321605706,
 42349,
 1321815768,
 1320547909,
 -1,
 1321881297,
 1321754044,
 -1,
 1321946828,
 1321835201,
 42454,
 -1,
 1321900737,
 42378,
 1322077902,
 1321878722,
 42494,
 -1,
 1322009794,
 42265,
 -45361,
 1322048699,
 42415,
 -45360,
 1322149885,
 42302,
 -1,
 1322195530,
 42341,
 1322405587,
 1321835201,
 42453,
 -1,
 1322359489,
 42377,
 1322536661,
 1322337474,
 42493,
 -1,
 1322468546,
 42264,
 -45354,
 1322507451,
 42414,
 -45353,
 1322608637,
 42301,
 -1,
 1322654282,
 42340,
 1322864359,
 1321790113,
 -1,
 1322929885,
 1322818241,
 42431,
 1322995420,
 1322883777,
 42356,
 -1,
 1322947232,
 42357,
 -1,
 1322947232,
 42432,
 1323192033,
 1322861762,
 42470,
 1323257568,
 1323123906,
 42243,
 -1,
 1323209376,
 42244,
 -1,
 1323209376,
 42471,
 1323454179,
 1323162811,
 42393,
 -1,
 1323405984,
 42394,
 1323585253,
 1323395069,
 42280,
 -1,
 1323537056,
 42281,
 1323761663,
 1323506250,
 42318,
 -1,
 1323668128,
 42319,
 1323847415,
 1322831862,
 -1,
 1323912944,
 1323785660,
 -1,
 1323978475,
 1323866817,
 42444,
 -1,
 1323932353,
 42368,
 1324109549,
 1323910338,
 42484,
 -1,
 1324041410,
 42255,
 -45330,
 1324080315,
 42405,
 -45329,
 1324181501,
 42292,
 -1,
 1324227146,
 42331,
 1324437234,
 1323866817,
 42443,
 -1,
 1324391105,
 42367,
 1324568308,
 1324369090,
 42483,
 -1,
 1324500162,
 42254,
 -45323,
 1324539067,
 42404,
 -45322,
 1324640253,
 42291,
 -1,
 1324685898,
 42330,
 1324896007,
 1323811284,
 -1,
 1324961536,
 1324834236,
 -1,
 1325027067,
 1324915393,
 42452,
 -1,
 1324980929,
 42376,
 1325158141,
 1324958914,
 42492,
 -1,
 1325089986,
 42263,
 -45314,
 1325128891,
 42413,
 -45313,
 1325230077,
 42300,
 -1,
 1325275722,
 42339,
 1325485826,
 1324915393,
 42451,
 -1,
 1325439681,
 42375,
 1325616900,
 1325417666,
 42491,
 -1,
 1325548738,
 42262,
 -45307,
 1325587643,
 42412,
 -45306,
 1325688829,
 42299,
 -1,
 1325734474,
 42338,
 1325944599,
 1324820743,
 -1,
 1326010128,
 1325882812,
 -1,
 1326075659,
 1325963969,
 42434,
 -1,
 1326029505,
 42359,
 1326206733,
 1326007490,
 42473,
 -1,
 1326138562,
 42246,
 -45298,
 1326177467,
 42396,
 -45297,
 1326278653,
 42283,
 -1,
 1326324298,
 42321,
 1326534418,
 1325963969,
 42435,
 -1,
 1326488257,
 42360,
 1326665492,
 1326466242,
 42474,
 -1,
 1326597314,
 42247,
 -45291,
 1326636219,
 42397,
 -45290,
 1326737405,
 42284,
 -1,
 1326783050,
 42322,
 1326993188,
 1325882812,
 -1,
 1327058715,
 1326947009,
 42429,
 -45286,
 1327012545,
 42355,
 -1,
 1327076000,
 42430,
 1327255326,
 1326990530,
 42468,
 -45283,
 1327207072,
 42469,
 -1,
 1327252674,
 42242,
 1327451936,
 1327226043,
 42391,
 -1,
 1327403680,
 42392,
 1327583010,
 1327392765,
 42278,
 -1,
 1327534752,
 42279,
 1327759359,
 1327503946,
 42316,
 -1,
 1327665824,
 42317,
 1327845165,
 1326939195,
 -1,
 1327910696,
 1327776962,
 42487,
 -45273,
 1327863424,
 42508,
 -1,
 1327908034,
 42258,
 1328107306,
 1327864513,
 42447,
 -1,
 1328061121,
 42371,
 -45269,
 1328078011,
 42408,
 -45268,
 1328179197,
 42295,
 -1,
 1328224842,
 42334,
 1328434997,
 1327821622,
 -1,
 1328500528,
 1328388801,
 42458,
 -1,
 1328454337,
 42382,
 1328631602,
 1328432322,
 42498,
 -1,
 1328563394,
 42269,
 -45261,
 1328602299,
 42419,
 -45260,
 1328703485,
 42306,
 -1,
 1328749130,
 42345,
 1328959293,
 1328407962,
 -1,
 1329024824,
 1328913089,
 42442,
 -1,
 1328978625,
 42366,
 1329155898,
 1328956610,
 42482,
 -1,
 1329087682,
 42253,
 -45253,
 1329126587,
 42403,
 -45252,
 1329227773,
 42290,
 -1,
 1329273418,
 42329,
 1329483589,
 1328919522,
 -1,
 1329549120,
 1329437377,
 42448,
 -1,
 1329502913,
 42372,
 1329680194,
 1329480898,
 42488,
 -1,
 1329611970,
 42259,
 -45245,
 1329650875,
 42409,
 -45244,
 1329752061,
 42296,
 -1,
 1329797706,
 42335,
 1330007885,
 1329441232,
 -1,
 1330073416,
 1329961665,
 42433,
 -1,
 1330027201,
 42358,
 1330204490,
 1330005186,
 42472,
 -1,
 1330136258,
 42245,
 -45237,
 1330175163,
 42395,
 -45236,
 1330276349,
 42282,
 -1,
 1330321994,
 42320,
 1330532181,
 1329952577,
 -1,
 1330597712,
 1330485953,
 42456,
 -1,
 1330551489,
 42380,
 1330728786,
 1330529474,
 42496,
 -1,
 1330660546,
 42267,
 -45229,
 1330699451,
 42417,
 -45228,
 1330800637,
 42304,
 -1,
 1330846282,
 42343,
 1331056477,
 1330467315,
 -1,
 1331122008,
 1331010241,
 42441,
 -1,
 1331075777,
 42365,
 1331253082,
 1331053762,
 42481,
 -1,
 1331184834,
 42252,
 -45221,
 1331223739,
 42402,
 -45220,
 1331324925,
 42289,
 -1,
 1331370570,
 42328,
 1331580773,
 1330982824,
 -1,
 1331646304,
 1331534529,
 42455,
 -1,
 1331600065,
 42379,
 1331777378,
 1331578050,
 42495,
 -1,
 1331709122,
 42266,
 -45213,
 1331748027,
 42416,
 -45212,
 1331849213,
 42303,
 -1,
 1331894858,
 42342,
 1332105065,
 1331534529,
 42426,
 1332170600,
 1332058817,
 42353,
 -1,
 1332122272,
 42354,
 -1,
 1332122272,
 42427,
 1332367213,
 1332036802,
 42465,
 1332432748,
 1332298946,
 42240,
 -1,
 1332384416,
 42241,
 -1,
 1332384416,
 42466,
 1332629359,
 1332337851,
 42389,
 -1,
 1332581024,
 42390,
 1332760433,
 1332570109,
 42276,
 -1,
 1332712096,
 42277,
 1332936703,
 1332681290,
 42313,
 -1,
 1332843168,
 42314,
 1333067775,
 1312721999,
 -1,
 1333088120,
 1332989942,
 -1,
 -45194,
 1333043264,
 42525,
 -45193,
 1333096128,
 42517,
 -1,
 1333140239,
 42521,
 1333350269,
 1333017429,
 -1,
 1333415804,
 1333304001,
 -1,
 -45189,
 1333370944,
 42523,
 -1,
 1333399594,
 42526,
 -1,
 1333338813,
 42522,
 1333677952,
 1333295200,
 -1,
 -45185,
 1333649647,
 42524,
 -1,
 1333676110,
 42516,
 1333874563,
 1333613043,
 -1,
 -45182,
 1333807182,
 42515,
 -1,
 1333861135,
 42520,
 -45180,
 1333827294,
 42518,
 -45179,
 1334016031,
 42527,
 -1,
 1334061501,
 42519,
 1334267796,
 1312636653,
 -1,
 1334333322,
 1334235126,
 -1,
 -45175,
 1334308915,
 42530,
 -1,
 1334339103,
 42531,
 1334529933,
 1334297044,
 -1,
 -45172,
 1334474404,
 42534,
 -1,
 1334530020,
 42535,
 1334726544,
 1334465011,
 -1,
 -45169,
 1334683160,
 42532,
 -1,
 1334736362,
 42533,
 -45167,
 1334703920,
 42528,
 -45166,
 1334877977,
 42529,
 -45165,
 1334941422,
 42537,
 -1,
 1334987166,
 42536,
 -45163,
 1334227847,
 42511,
 -45162,
 1335121986,
 42510,
 -1,
 1335178959,
 42509,
 1335382168,
 1312602681,
 -1,
 1335447559,
 1335300603,
 -1,
 1335512996,
 1335368088,
 917762,
 -45157,
 1335433624,
 917942,
 -45156,
 1335498983,
 917941,
 -45155,
 1335564295,
 917940,
 -45154,
 1335629623,
 917939,
 -45153,
 1335694914,
 917938,
 -45152,
 1335760238,
 917937,
 -45151,
 1335825488,
 917936,
 -45150,
 1335890731,
 917935,
 -45149,
 1335955963,
 917934,
 -1,
 1336021227,
 917933,
 1336233903,
 1335433447,
 917761,
 -45146,
 1336154520,
 917932,
 -45145,
 1336219879,
 917931,
 -45144,
 1336285191,
 917930,
 -45143,
 1336350519,
 917929,
 -45142,
 1336415810,
 917928,
 -45141,
 1336481134,
 917927,
 -45140,
 1336546384,
 917926,
 -45139,
 1336611627,
 917925,
 -45138,
 1336676859,
 917924,
 -1,
 1336742123,
 917923,
 1336954810,
 1336154119,
 917760,
 -45135,
 1336875416,
 917922,
 -45134,
 1336940775,
 917921,
 -45133,
 1337006087,
 917920,
 -45132,
 1337071415,
 917919,
 -45131,
 1337136706,
 917918,
 -45130,
 1337202030,
 917917,
 -45129,
 1337267280,
 917916,
 -45128,
 1337332523,
 917915,
 -45127,
 1337397755,
 917914,
 -1,
 1337463019,
 917913,
 1337675717,
 1336874807,
 -1,
 -45124,
 1337596312,
 917912,
 -45123,
 1337661671,
 917911,
 -45122,
 1337726983,
 917910,
 -45121,
 1337792311,
 917909,
 -45120,
 1337857602,
 917908,
 -45119,
 1337922926,
 917907,
 -45118,
 1337988176,
 917906,
 -45117,
 1338053419,
 917905,
 -45116,
 1338118651,
 917904,
 -1,
 1338183915,
 917903,
 1338396624,
 1337595458,
 -1,
 -45113,
 1338317208,
 917902,
 -45112,
 1338382567,
 917901,
 -45111,
 1338447879,
 917900,
 -45110,
 1338513207,
 917899,
 -45109,
 1338578498,
 917898,
 -45108,
 1338643822,
 917897,
 -45107,
 1338709072,
 917896,
 -45106,
 1338774315,
 917895,
 -45105,
 1338839547,
 917894,
 -1,
 1338904811,
 917893,
 1339117531,
 1338316142,
 -1,
 -45102,
 1339038104,
 917892,
 -45101,
 1339103463,
 917891,
 -45100,
 1339168775,
 917890,
 -45099,
 1339234103,
 917889,
 -45098,
 1339299394,
 917888,
 -45097,
 1339364718,
 917887,
 -45096,
 1339429968,
 917886,
 -45095,
 1339495211,
 917885,
 -45094,
 1339560443,
 917884,
 -1,
 1339625707,
 917883,
 1339838438,
 1339036752,
 -1,
 -45091,
 1339759000,
 917882,
 -45090,
 1339824359,
 917881,
 -45089,
 1339889671,
 917880,
 -45088,
 1339954999,
 917879,
 -45087,
 1340020290,
 917878,
 -45086,
 1340085614,
 917877,
 -45085,
 1340150864,
 917876,
 -45084,
 1340216107,
 917875,
 -45083,
 1340281339,
 917874,
 -1,
 1340346603,
 917873,
 1340559345,
 1339757355,
 -1,
 -45080,
 1340479896,
 917872,
 -45079,
 1340545255,
 917871,
 -45078,
 1340610567,
 917870,
 -45077,
 1340675895,
 917869,
 -45076,
 1340741186,
 917868,
 -45075,
 1340806510,
 917867,
 -45074,
 1340871760,
 917866,
 -45073,
 1340937003,
 917865,
 -45072,
 1341002235,
 917864,
 -1,
 1341067499,
 917863,
 1341280252,
 1340477947,
 -1,
 -45069,
 1341200792,
 917862,
 -45068,
 1341266151,
 917861,
 -45067,
 1341331463,
 917860,
 -45066,
 1341396791,
 917859,
 -45065,
 1341462082,
 917858,
 -45064,
 1341527406,
 917857,
 -45063,
 1341592656,
 917856,
 -45062,
 1341657899,
 917855,
 -45061,
 1341723131,
 917854,
 -1,
 1341788395,
 917853,
 1342046207,
 1341198571,
 -1,
 -45058,
 1341921688,
 917852,
 -45057,
 1341987047,
 917851,
 -45056,
 1342052359,
 917850,
 -45055,
 1342117687,
 917849,
 -45054,
 1342182978,
 917848,
 -45053,
 1342248302,
 917847,
 -45052,
 1342313552,
 917846,
 -45051,
 1342378795,
 917845,
 -45050,
 1342444027,
 917844,
 -1,
 1342509291,
 917843,
 1342722123,
 1335366443,
 -1,
 1342787603,
 1342641518,
 917767,
 -45046,
 1342708120,
 917992,
 -45045,
 1342773479,
 917991,
 -45044,
 1342838791,
 917990,
 -45043,
 1342904119,
 917989,
 -45042,
 1342969410,
 917988,
 -45041,
 1343034734,
 917987,
 -45040,
 1343099984,
 917986,
 -45039,
 1343165227,
 917985,
 -45038,
 1343230459,
 917984,
 -1,
 1343295723,
 917983,
 1343508510,
 1342706768,
 917766,
 -45035,
 1343429016,
 917982,
 -45034,
 1343494375,
 917981,
 -45033,
 1343559687,
 917980,
 -45032,
 1343625015,
 917979,
 -45031,
 1343690306,
 917978,
 -45030,
 1343755630,
 917977,
 -45029,
 1343820880,
 917976,
 -45028,
 1343886123,
 917975,
 -45027,
 1343951355,
 917974,
 -1,
 1344016619,
 917973,
 1344229417,
 1343427371,
 917765,
 -45024,
 1344149912,
 917972,
 -45023,
 1344215271,
 917971,
 -45022,
 1344280583,
 917970,
 -45021,
 1344345911,
 917969,
 -45020,
 1344411202,
 917968,
 -45019,
 1344476526,
 917967,
 -45018,
 1344541776,
 917966,
 -45017,
 1344607019,
 917965,
 -45016,
 1344672251,
 917964,
 -1,
 1344737515,
 917963,
 1344950324,
 1344147963,
 917764,
 -45013,
 1344870808,
 917962,
 -45012,
 1344936167,
 917961,
 -45011,
 1345001479,
 917960,
 -45010,
 1345066807,
 917959,
 -45009,
 1345132098,
 917958,
 -45008,
 1345197422,
 917957,
 -45007,
 1345262672,
 917956,
 -45006,
 1345327915,
 917955,
 -45005,
 1345393147,
 917954,
 -1,
 1345458411,
 917953,
 1345671231,
 1344868587,
 917763,
 -45002,
 1345591704,
 917952,
 -45001,
 1345657063,
 917951,
 -45000,
 1345722375,
 917950,
 -44999,
 1345787703,
 917949,
 -44998,
 1345852994,
 917948,
 -44997,
 1345918318,
 917947,
 -44996,
 1345983568,
 917946,
 -44995,
 1346048811,
 917945,
 -44994,
 1346114043,
 917944,
 -1,
 1346179307,
 917943,
 1346392135,
 1345590850,
 917768,
 -44991,
 1346311991,
 917999,
 -44990,
 1346377282,
 917998,
 -44989,
 1346442606,
 917997,
 -44988,
 1346507856,
 917996,
 -44987,
 1346573099,
 917995,
 -44986,
 1346638331,
 917994,
 -1,
 1346703595,
 917993,
 -44984,
 1346312600,
 917772,
 -44983,
 1346836711,
 917771,
 -44982,
 1346902023,
 917770,
 -1,
 1346967351,
 917769,
 1347178582,
 1342642584,
 -1,
 -44979,
 1347099032,
 917842,
 -44978,
 1347164391,
 917841,
 -44977,
 1347229703,
 917840,
 -44976,
 1347295031,
 917839,
 -44975,
 1347360322,
 917838,
 -44974,
 1347425646,
 917837,
 -44973,
 1347490896,
 917836,
 -44972,
 1347556139,
 917835,
 -44971,
 1347621371,
 917834,
 -1,
 1347686635,
 917833,
 1347899489,
 1347098855,
 -1,
 -44968,
 1347819928,
 917832,
 -44967,
 1347885287,
 917831,
 -44966,
 1347950599,
 917830,
 -44965,
 1348015927,
 917829,
 -44964,
 1348081218,
 917828,
 -44963,
 1348146542,
 917827,
 -44962,
 1348211792,
 917826,
 -44961,
 1348277035,
 917825,
 -44960,
 1348342267,
 917824,
 -1,
 1348407531,
 917823,
 1348620396,
 1347819527,
 -1,
 -44957,
 1348540824,
 917822,
 -44956,
 1348606183,
 917821,
 -44955,
 1348671495,
 917820,
 -44954,
 1348736823,
 917819,
 -44953,
 1348802114,
 917818,
 -44952,
 1348867438,
 917817,
 -44951,
 1348932688,
 917816,
 -44950,
 1348997931,
 917815,
 -44949,
 1349063163,
 917814,
 -1,
 1349128427,
 917813,
 1349341303,
 1348540215,
 -1,
 -44946,
 1349261720,
 917812,
 -44945,
 1349327079,
 917811,
 -44944,
 1349392391,
 917810,
 -44943,
 1349457719,
 917809,
 -44942,
 1349523010,
 917808,
 -44941,
 1349588334,
 917807,
 -44940,
 1349653584,
 917806,
 -44939,
 1349718827,
 917805,
 -44938,
 1349784059,
 917804,
 -1,
 1349849323,
 917803,
 1350062210,
 1349260866,
 -1,
 -44935,
 1349982616,
 917802,
 -44934,
 1350047975,
 917801,
 -44933,
 1350113287,
 917800,
 -44932,
 1350178615,
 917799,
 -44931,
 1350243906,
 917798,
 -44930,
 1350309230,
 917797,
 -44929,
 1350374480,
 917796,
 -44928,
 1350439723,
 917795,
 -44927,
 1350504955,
 917794,
 -1,
 1350570219,
 917793,
 1350783117,
 1349981550,
 -1,
 -44924,
 1350703512,
 917792,
 -44923,
 1350768871,
 917791,
 -44922,
 1350834183,
 917790,
 -44921,
 1350899511,
 917789,
 -44920,
 1350964802,
 917788,
 -44919,
 1351030126,
 917787,
 -44918,
 1351095376,
 917786,
 -44917,
 1351160619,
 917785,
 -44916,
 1351225851,
 917784,
 -1,
 1351291115,
 917783,
 1351548927,
 1350702160,
 -1,
 -44913,
 1351424408,
 917782,
 -44912,
 1351489767,
 917781,
 -44911,
 1351555079,
 917780,
 -44910,
 1351620407,
 917779,
 -44909,
 1351685698,
 917778,
 -44908,
 1351751022,
 917777,
 -44907,
 1351816272,
 917776,
 -44906,
 1351881515,
 917775,
 -44905,
 1351946747,
 917774,
 -1,
 1352012011,
 917773,
 -1,
 1335333247,
 129499,
 1352290714,
 1312539092,
 -1,
 1352356105,
 1352208891,
 983240,
 1352421542,
 1352276376,
 983270,
 -44899,
 1352341912,
 983450,
 -44898,
 1352407271,
 983449,
 -44897,
 1352472583,
 983448,
 -44896,
 1352537911,
 983447,
 -44895,
 1352603202,
 983446,
 -44894,
 1352668526,
 983445,
 -44893,
 1352733776,
 983444,
 -44892,
 1352799019,
 983443,
 -44891,
 1352864251,
 983442,
 -1,
 1352929515,
 983441,
 1353142449,
 1352341735,
 983269,
 -44888,
 1353062808,
 983440,
 -44887,
 1353128167,
 983439,
 -44886,
 1353193479,
 983438,
 -44885,
 1353258807,
 983437,
 -44884,
 1353324098,
 983436,
 -44883,
 1353389422,
 983435,
 -44882,
 1353454672,
 983434,
 -44881,
 1353519915,
 983433,
 -44880,
 1353585147,
 983432,
 -1,
 1353650411,
 983431,
 1353863356,
 1353062407,
 983268,
 -44877,
 1353783704,
 983430,
 -44876,
 1353849063,
 983429,
 -44875,
 1353914375,
 983428,
 -44874,
 1353979703,
 983427,
 -44873,
 1354044994,
 983426,
 -44872,
 1354110318,
 983425,
 -44871,
 1354175568,
 983424,
 -44870,
 1354240811,
 983423,
 -44869,
 1354306043,
 983422,
 -1,
 1354371307,
 983421,
 1354584263,
 1353783095,
 983255,
 -44866,
 1354504600,
 983420,
 -44865,
 1354569959,
 983419,
 -44864,
 1354635271,
 983418,
 -44863,
 1354700599,
 983417,
 -44862,
 1354765890,
 983416,
 -44861,
 1354831214,
 983415,
 -44860,
 1354896464,
 983414,
 -44859,
 1354961707,
 983413,
 -44858,
 1355026939,
 983412,
 -1,
 1355092203,
 983411,
 1355305170,
 1354503746,
 983254,
 -44855,
 1355225496,
 983410,
 -44854,
 1355290855,
 983409,
 -44853,
 1355356167,
 983408,
 -44852,
 1355421495,
 983407,
 -44851,
 1355486786,
 983406,
 -44850,
 1355552110,
 983405,
 -44849,
 1355617360,
 983404,
 -44848,
 1355682603,
 983403,
 -44847,
 1355747835,
 983402,
 -1,
 1355813099,
 983401,
 1356026077,
 1355224430,
 983253,
 -44844,
 1355946392,
 983400,
 -44843,
 1356011751,
 983399,
 -44842,
 1356077063,
 983398,
 -44841,
 1356142391,
 983397,
 -44840,
 1356207682,
 983396,
 -44839,
 1356273006,
 983395,
 -44838,
 1356338256,
 983394,
 -44837,
 1356403499,
 983393,
 -44836,
 1356468731,
 983392,
 -1,
 1356533995,
 983391,
 1356746984,
 1355945040,
 983252,
 -44833,
 1356667288,
 983390,
 -44832,
 1356732647,
 983389,
 -44831,
 1356797959,
 983388,
 -44830,
 1356863287,
 983387,
 -44829,
 1356928578,
 983386,
 -44828,
 1356993902,
 983385,
 -44827,
 1357059152,
 983384,
 -44826,
 1357124395,
 983383,
 -44825,
 1357189627,
 983382,
 -1,
 1357254891,
 983381,
 1357467891,
 1356665643,
 983251,
 -44822,
 1357388184,
 983380,
 -44821,
 1357453543,
 983379,
 -44820,
 1357518855,
 983378,
 -44819,
 1357584183,
 983377,
 -44818,
 1357649474,
 983376,
 -44817,
 1357714798,
 983375,
 -44816,
 1357780048,
 983374,
 -44815,
 1357845291,
 983373,
 -44814,
 1357910523,
 983372,
 -1,
 1357975787,
 983371,
 1358188798,
 1357386235,
 983250,
 -44811,
 1358109080,
 983370,
 -44810,
 1358174439,
 983369,
 -44809,
 1358239751,
 983368,
 -44808,
 1358305079,
 983367,
 -44807,
 1358370370,
 983366,
 -44806,
 1358435694,
 983365,
 -44805,
 1358500944,
 983364,
 -44804,
 1358566187,
 983363,
 -44803,
 1358631419,
 983362,
 -1,
 1358696683,
 983361,
 1358954495,
 1358106859,
 983249,
 -44800,
 1358829976,
 983360,
 -44799,
 1358895335,
 983359,
 -44798,
 1358960647,
 983358,
 -44797,
 1359025975,
 983357,
 -44796,
 1359091266,
 983356,
 -44795,
 1359156590,
 983355,
 -44794,
 1359221840,
 983354,
 -44793,
 1359287083,
 983353,
 -44792,
 1359352315,
 983352,
 -1,
 1359417579,
 983351,
 1359630669,
 1352274731,
 983241,
 1359696149,
 1359549806,
 983275,
 -44788,
 1359616408,
 983500,
 -44787,
 1359681767,
 983499,
 -44786,
 1359747079,
 983498,
 -44785,
 1359812407,
 983497,
 -44784,
 1359877698,
 983496,
 -44783,
 1359943022,
 983495,
 -44782,
 1360008272,
 983494,
 -44781,
 1360073515,
 983493,
 -44780,
 1360138747,
 983492,
 -1,
 1360204011,
 983491,
 1360417056,
 1359615056,
 983274,
 -44777,
 1360337304,
 983490,
 -44776,
 1360402663,
 983489,
 -44775,
 1360467975,
 983488,
 -44774,
 1360533303,
 983487,
 -44773,
 1360598594,
 983486,
 -44772,
 1360663918,
 983485,
 -44771,
 1360729168,
 983484,
 -44770,
 1360794411,
 983483,
 -44769,
 1360859643,
 983482,
 -1,
 1360924907,
 983481,
 1361137963,
 1360335659,
 983273,
 -44766,
 1361058200,
 983480,
 -44765,
 1361123559,
 983479,
 -44764,
 1361188871,
 983478,
 -44763,
 1361254199,
 983477,
 -44762,
 1361319490,
 983476,
 -44761,
 1361384814,
 983475,
 -44760,
 1361450064,
 983474,
 -44759,
 1361515307,
 983473,
 -44758,
 1361580539,
 983472,
 -1,
 1361645803,
 983471,
 1361858870,
 1361056251,
 983272,
 -44755,
 1361779096,
 983470,
 -44754,
 1361844455,
 983469,
 -44753,
 1361909767,
 983468,
 -44752,
 1361975095,
 983467,
 -44751,
 1362040386,
 983466,
 -44750,
 1362105710,
 983465,
 -44749,
 1362170960,
 983464,
 -44748,
 1362236203,
 983463,
 -44747,
 1362301435,
 983462,
 -1,
 1362366699,
 983461,
 1362579777,
 1361776875,
 983271,
 -44744,
 1362499992,
 983460,
 -44743,
 1362565351,
 983459,
 -44742,
 1362630663,
 983458,
 -44741,
 1362695991,
 983457,
 -44740,
 1362761282,
 983456,
 -44739,
 1362826606,
 983455,
 -44738,
 1362891856,
 983454,
 -44737,
 1362957099,
 983453,
 -44736,
 1363022331,
 983452,
 -1,
 1363087595,
 983451,
 1363300681,
 1362499138,
 983276,
 -44733,
 1363220279,
 983507,
 -44732,
 1363285570,
 983506,
 -44731,
 1363350894,
 983505,
 -44730,
 1363416144,
 983504,
 -44729,
 1363481387,
 983503,
 -44728,
 1363546619,
 983502,
 -1,
 1363611883,
 983501,
 -44726,
 1363220888,
 983280,
 -44725,
 1363744999,
 983279,
 -44724,
 1363810311,
 983278,
 -1,
 1363875639,
 983277,
 1364087128,
 1359550872,
 983248,
 -44721,
 1364007320,
 983350,
 -44720,
 1364072679,
 983349,
 -44719,
 1364137991,
 983348,
 -44718,
 1364203319,
 983347,
 -44717,
 1364268610,
 983346,
 -44716,
 1364333934,
 983345,
 -44715,
 1364399184,
 983344,
 -44714,
 1364464427,
 983343,
 -44713,
 1364529659,
 983342,
 -1,
 1364594923,
 983341,
 1364808035,
 1364007143,
 983247,
 -44710,
 1364728216,
 983340,
 -44709,
 1364793575,
 983339,
 -44708,
 1364858887,
 983338,
 -44707,
 1364924215,
 983337,
 -44706,
 1364989506,
 983336,
 -44705,
 1365054830,
 983335,
 -44704,
 1365120080,
 983334,
 -44703,
 1365185323,
 983333,
 -44702,
 1365250555,
 983332,
 -1,
 1365315819,
 983331,
 1365528942,
 1364727815,
 983246,
 -44699,
 1365449112,
 983330,
 -44698,
 1365514471,
 983329,
 -44697,
 1365579783,
 983328,
 -44696,
 1365645111,
 983327,
 -44695,
 1365710402,
 983326,
 -44694,
 1365775726,
 983325,
 -44693,
 1365840976,
 983324,
 -44692,
 1365906219,
 983323,
 -44691,
 1365971451,
 983322,
 -1,
 1366036715,
 983321,
 1366249849,
 1365448503,
 983245,
 -44688,
 1366170008,
 983320,
 -44687,
 1366235367,
 983319,
 -44686,
 1366300679,
 983318,
 -44685,
 1366366007,
 983317,
 -44684,
 1366431298,
 983316,
 -44683,
 1366496622,
 983315,
 -44682,
 1366561872,
 983314,
 -44681,
 1366627115,
 983313,
 -44680,
 1366692347,
 983312,
 -1,
 1366757611,
 983311,
 1366970756,
 1366169154,
 983244,
 -44677,
 1366890904,
 983310,
 -44676,
 1366956263,
 983309,
 -44675,
 1367021575,
 983308,
 -44674,
 1367086903,
 983307,
 -44673,
 1367152194,
 983306,
 -44672,
 1367217518,
 983305,
 -44671,
 1367282768,
 983304,
 -44670,
 1367348011,
 983303,
 -44669,
 1367413243,
 983302,
 -1,
 1367478507,
 983301,
 1367691663,
 1366889838,
 983243,
 -44666,
 1367611800,
 983300,
 -44665,
 1367677159,
 983299,
 -44664,
 1367742471,
 983298,
 -44663,
 1367807799,
 983297,
 -44662,
 1367873090,
 983296,
 -44661,
 1367938414,
 983295,
 -44660,
 1368003664,
 983294,
 -44659,
 1368068907,
 983293,
 -44658,
 1368134139,
 983292,
 -1,
 1368199403,
 983291,
 1368457215,
 1367610448,
 983242,
 -44655,
 1368332696,
 983290,
 -44654,
 1368398055,
 983289,
 -44653,
 1368463367,
 983288,
 -44652,
 1368528695,
 983287,
 -44651,
 1368593986,
 983286,
 -44650,
 1368659310,
 983285,
 -44649,
 1368724560,
 983284,
 -44648,
 1368789803,
 983283,
 -44647,
 1368855035,
 983282,
 -1,
 1368920299,
 983281,
 1369133563,
 1352221890,
 -1,
 1369199061,
 1369063117,
 -1,
 1369264570,
 1369163739,
 -1,
 1369330086,
 1369184842,
 -1,
 1369395620,
 1369283140,
 -1,
 1369461153,
 1369368000,
 7403,
 -1,
 1369378525,
 7404,
 -44638,
 1369431495,
 7409,
 -44637,
 1369516418,
 7402,
 -1,
 1369580413,
 7401,
 -44635,
 1369363883,
 7415,
 -1,
 1369749143,
 7410,
 1369919916,
 1369303324,
 -1,
 1369985449,
 1369890536,
 7395,
 -1,
 1369902813,
 7399,
 1370116523,
 1369908157,
 7397,
 -1,
 1370033885,
 7400,
 -1,
 1370083153,
 7394,
 1370313138,
 1369879522,
 -1,
 1370378672,
 1370247329,
 -1,
 -44625,
 1370349288,
 7396,
 -1,
 1370366909,
 7398,
 -44623,
 1370346389,
 7408,
 -1,
 1370531055,
 7411,
 -44621,
 1370289125,
 7380,
 -44620,
 1370677762,
 7414,
 -44619,
 1370740419,
 7405,
 -44618,
 1370789588,
 7379,
 -44617,
 1370850881,
 7407,
 -44616,
 1370912725,
 7413,
 -44615,
 1370972713,
 7406,
 -1,
 1371029809,
 7418,
 1371275263,
 1369233218,
 -1,
 1371296192,
 1371206617,
 -1,
 1371361726,
 1371240862,
 7383,
 -1,
 1371277608,
 7385,
 -44609,
 1371303333,
 7382,
 -1,
 1371413998,
 7381,
 1371623876,
 1371262966,
 -1,
 -44606,
 1371598955,
 7390,
 -44605,
 1371651635,
 7387,
 -1,
 1371694700,
 7391,
 1371886025,
 1371553683,
 -1,
 1371951560,
 1371856388,
 -1,
 -44601,
 1371918161,
 7386,
 -1,
 1371979059,
 7417,
 -1,
 1371918350,
 7389,
 1372213708,
 1371847114,
 -1,
 -44597,
 1372165623,
 7416,
 -1,
 1372216707,
 7392,
 1372410319,
 1372158144,
 -1,
 -44594,
 1372377957,
 7388,
 -1,
 1372438722,
 7376,
 1372606930,
 1372336221,
 -1,
 -44591,
 1372531437,
 7384,
 -1,
 1372593058,
 7412,
 -44589,
 1372571188,
 7377,
 -44588,
 1372762253,
 7378,
 -1,
 1372792695,
 7393,
 1373000186,
 1369158626,
 -1,
 1373065706,
 1372968267,
 -1,
 1373131230,
 1373019974,
 -1,
 -44583,
 1373050887,
 129909,
 -44582,
 1373116215,
 129908,
 -44581,
 1373181506,
 129907,
 -44580,
 1373246830,
 129906,
 -44579,
 1373312080,
 129905,
 -1,
 1373377323,
 129904,
 1373589989,
 1373097974,
 -1,
 1373655523,
 1373510469,
 -1,
 1373721058,
 1373626291,
 983069,
 -1,
 1373636934,
 983143,
 -1,
 1373635581,
 11135,
 -44572,
 1373615272,
 128678,
 -1,
 1373858954,
 11823,
 -44570,
 1373554904,
 11837,
 -44569,
 1373997675,
 9896,
 -44568,
 1374061678,
 9168,
 -44567,
 1374115481,
 8286,
 -1,
 1374169564,
 10186,
 1374420991,
 1373041464,
 -1,
 1374441977,
 1374314788,
 -1,
 1374507504,
 1374405076,
 -1,
 -44562,
 1374461352,
 128636,
 -44561,
 1374516923,
 128953,
 -1,
 1374560465,
 128941,
 1374769651,
 1374481639,
 -1,
 -44558,
 1374735300,
 128914,
 -1,
 1374762003,
 128904,
 1374966262,
 1374701988,
 -1,
 -44555,
 1374931888,
 128959,
 -1,
 1374990045,
 128976,
 -44553,
 1374927137,
 128637,
 -44552,
 1375100163,
 128934,
 -1,
 1375163617,
 128947,
 -1,
 1374367155,
 128933,
 -1,
 1372966109,
 9910,
 1375490566,
 1369073661,
 -1,
 1375556097,
 1375419805,
 -1,
 1375621632,
 1375469568,
 -1,
 -44545,
 1375557895,
 127918,
 -1,
 1375612987,
 128249,
 -1,
 1375547679,
 128252,
 1375883780,
 1375489748,
 -1,
 -44541,
 1375835806,
 94193,
 -1,
 1375875039,
 94192,
 -44539,
 1375837615,
 127931,
 -1,
 1376005762,
 128243,
 1376211470,
 1375461281,
 -1,
 1376277005,
 1376147795,
 -1,
 1376342540,
 1376231197,
 -1,
 -44534,
 1376309956,
 8530,
 -44533,
 1376372014,
 8528,
 -1,
 1376425814,
 8529,
 -1,
 1376319329,
 8585,
 -1,
 1376202924,
 11238,
 1376735763,
 1376164545,
 -1,
 1376801298,
 1376681019,
 -1,
 -44527,
 1376748302,
 127952,
 -1,
 1376792743,
 127755,
 -1,
 1376741864,
 129979,
 1377107967,
 1376702454,
 983070,
 -1,
 1377026516,
 983144,
 1377195452,
 1312447932,
 -1,
 1377260604,
 1377125570,
 -1,
 1377325935,
 1377212769,
 -1,
 1377391171,
 1377269856,
 -1,
 1377456678,
 1377311465,
 -1,
 1377522205,
 1377374715,
 110615,
 -44516,
 1377440251,
 110625,
 -1,
 1377505515,
 110624,
 -44514,
 1377466853,
 110626,
 -44513,
 1377638808,
 110623,
 -44512,
 1377704167,
 110622,
 -44511,
 1377769479,
 110621,
 -44510,
 1377834807,
 110620,
 -44509,
 1377900098,
 110619,
 -44508,
 1377965422,
 110618,
 -44507,
 1378030672,
 110617,
 -1,
 1378095915,
 110616,
 1378308655,
 1377396847,
 -1,
 -44504,
 1378228455,
 110634,
 -44503,
 1378293767,
 110633,
 -44502,
 1378359095,
 110632,
 -44501,
 1378424386,
 110631,
 -44500,
 1378489710,
 110630,
 -44499,
 1378554960,
 110629,
 -44498,
 1378620203,
 110628,
 -1,
 1378685435,
 110627,
 1378898487,
 1378278690,
 -1,
 -44495,
 1378818055,
 110641,
 -44494,
 1378883383,
 110640,
 -44493,
 1378948674,
 110639,
 -44492,
 1379013998,
 110638,
 -44491,
 1379079248,
 110637,
 -44490,
 1379144491,
 110636,
 -1,
 1379209723,
 110635,
 1379422782,
 1378829802,
 -1,
 -44487,
 1379342135,
 110647,
 -44486,
 1379407426,
 110646,
 -44485,
 1379472750,
 110645,
 -44484,
 1379538000,
 110644,
 -44483,
 1379603243,
 110643,
 -1,
 1379668475,
 110642,
 1379926015,
 1379375886,
 -1,
 -44480,
 1379826358,
 110651,
 -44479,
 1379865680,
 110650,
 -44478,
 1379930923,
 110649,
 -1,
 1379996155,
 110648,
 1380209261,
 1377328572,
 -1,
 1380274768,
 1380129513,
 -1,
 1380340296,
 1380192763,
 110750,
 -44473,
 1380258299,
 110760,
 -1,
 1380323563,
 110759,
 -44471,
 1380260248,
 110758,
 -44470,
 1380456679,
 110757,
 -44469,
 1380521991,
 110756,
 -44468,
 1380587319,
 110755,
 -44467,
 1380652610,
 110754,
 -44466,
 1380717934,
 110753,
 -44465,
 1380783184,
 110752,
 -1,
 1380848427,
 110751,
 1381061209,
 1380227854,
 -1,
 -44462,
 1380980967,
 110785,
 -44461,
 1381046279,
 110784,
 -44460,
 1381111607,
 110783,
 -44459,
 1381176898,
 110782,
 -44458,
 1381242222,
 110781,
 -44457,
 1381307472,
 110780,
 -44456,
 1381372715,
 110779,
 -1,
 1381437947,
 110778,
 1381651041,
 1381001327,
 -1,
 -44453,
 1381570567,
 110767,
 -44452,
 1381635895,
 110766,
 -44451,
 1381701186,
 110765,
 -44450,
 1381766510,
 110764,
 -44449,
 1381831760,
 110763,
 -44448,
 1381897003,
 110762,
 -1,
 1381962235,
 110761,
 1382175337,
 1381582314,
 -1,
 -44445,
 1382094855,
 110777,
 -44444,
 1382160183,
 110776,
 -44443,
 1382225474,
 110775,
 -44442,
 1382290798,
 110774,
 -44441,
 1382356048,
 110773,
 -44440,
 1382421291,
 110772,
 -1,
 1382486523,
 110771,
 1382744063,
 1382145314,
 -1,
 -44437,
 1382618192,
 110770,
 -44436,
 1382683435,
 110769,
 -1,
 1382748667,
 110768,
 1382961813,
 1380172244,
 -1,
 1383027319,
 1382931746,
 -1,
 -44432,
 1382947047,
 110673,
 -44431,
 1383012359,
 110672,
 -44430,
 1383077687,
 110671,
 -44429,
 1383142978,
 110670,
 -44428,
 1383208302,
 110669,
 -44427,
 1383273552,
 110668,
 -44426,
 1383338795,
 110667,
 -1,
 1383404027,
 110666,
 1383617152,
 1382947561,
 -1,
 -44423,
 1383536871,
 110659,
 -44422,
 1383602183,
 110658,
 -44421,
 1383667511,
 110657,
 -44420,
 1383732802,
 110656,
 -44419,
 1383798126,
 110655,
 -44418,
 1383863376,
 110654,
 -44417,
 1383928619,
 110653,
 -1,
 1383993851,
 110652,
 1384206984,
 1383570190,
 -1,
 -44414,
 1384126471,
 110685,
 -44413,
 1384191799,
 110684,
 -44412,
 1384257090,
 110683,
 -44411,
 1384322414,
 110682,
 -44410,
 1384387664,
 110681,
 -44409,
 1384452907,
 110680,
 -1,
 1384518139,
 110679,
 1384731279,
 1384147055,
 -1,
 -44406,
 1384650551,
 110665,
 -44405,
 1384715842,
 110664,
 -44404,
 1384781166,
 110663,
 -44403,
 1384846416,
 110662,
 -44402,
 1384911659,
 110661,
 -1,
 1384976891,
 110660,
 1385234431,
 1384662506,
 -1,
 -44399,
 1385109058,
 110678,
 -44398,
 1385174382,
 110677,
 -44397,
 1385239632,
 110676,
 -44396,
 1385304875,
 110675,
 -1,
 1385370107,
 110674,
 1385583294,
 1382912672,
 -1,
 1385648800,
 1385503465,
 -1,
 -44392,
 1385568664,
 110726,
 -44391,
 1385634023,
 110725,
 -44390,
 1385699335,
 110724,
 -44389,
 1385764663,
 110723,
 -44388,
 1385829954,
 110722,
 -44387,
 1385895278,
 110721,
 -44386,
 1385960528,
 110720,
 -44385,
 1386025771,
 110719,
 -1,
 1386091003,
 110718,
 1386304169,
 1385588847,
 -1,
 -44382,
 1386271191,
 110734,
 -44381,
 1386289159,
 110733,
 -44380,
 1386354487,
 110732,
 -44379,
 1386419778,
 110731,
 -44378,
 1386485102,
 110730,
 -44377,
 1386550352,
 110729,
 -44376,
 1386615595,
 110728,
 -1,
 1386680827,
 110727,
 1386894001,
 1386235370,
 -1,
 -44373,
 1386838876,
 110744,
 -44372,
 1386878775,
 110743,
 -44371,
 1386944066,
 110742,
 -44370,
 1387009390,
 110741,
 -44369,
 1387074640,
 110740,
 -44368,
 1387139883,
 110739,
 -1,
 1387205115,
 110738,
 1387418295,
 1386846990,
 -1,
 -44365,
 1387337282,
 110749,
 -44364,
 1387402606,
 110748,
 -44363,
 1387467856,
 110747,
 -44362,
 1387533099,
 110746,
 -1,
 1387598331,
 110745,
 1387811515,
 1387388194,
 -1,
 -44359,
 1387730000,
 110737,
 -44358,
 1387795243,
 110736,
 -1,
 1387860475,
 110735,
 1388118015,
 1387728914,
 -1,
 -44355,
 1387991851,
 110878,
 -1,
 1388057083,
 110877,
 1388270308,
 1385549814,
 -1,
 1388335817,
 1388201450,
 -1,
 -44351,
 1388255640,
 110710,
 -44350,
 1388320999,
 110709,
 -44349,
 1388386311,
 110708,
 -44348,
 1388451639,
 110707,
 -44347,
 1388516930,
 110706,
 -44346,
 1388582254,
 110705,
 -44345,
 1388647504,
 110704,
 -44344,
 1388712747,
 110703,
 -1,
 1388777979,
 110702,
 1388991185,
 1388288782,
 -1,
 -44341,
 1388950612,
 110717,
 -44340,
 1388975927,
 110716,
 -44339,
 1389041218,
 110715,
 -44338,
 1389106542,
 110714,
 -44337,
 1389171792,
 110713,
 -44336,
 1389237035,
 110712,
 -1,
 1389302267,
 110711,
 1389515481,
 1388931183,
 -1,
 -44333,
 1389434887,
 110696,
 -44332,
 1389500215,
 110695,
 -44331,
 1389565506,
 110694,
 -44330,
 1389630830,
 110693,
 -44329,
 1389696080,
 110692,
 -44328,
 1389761323,
 110691,
 -1,
 1389826555,
 110690,
 1390039775,
 1389485346,
 -1,
 -44325,
 1390008045,
 110701,
 -44324,
 1390024046,
 110700,
 -44323,
 1390089296,
 110699,
 -44322,
 1390154539,
 110698,
 -1,
 1390219771,
 110697,
 1390477311,
 1389959913,
 -1,
 -44319,
 1390351726,
 110689,
 -44318,
 1390416976,
 110688,
 -44317,
 1390482219,
 110687,
 -1,
 1390547451,
 110686,
 1390760709,
 1388229602,
 -1,
 1390826221,
 1390700655,
 -1,
 -44313,
 1390745607,
 110839,
 -44312,
 1390810935,
 110838,
 -44311,
 1390876226,
 110837,
 -44310,
 1390941550,
 110836,
 -44309,
 1391006800,
 110835,
 -44308,
 1391072043,
 110834,
 -1,
 1391137275,
 110833,
 1391350516,
 1390796066,
 -1,
 -44305,
 1391269687,
 110845,
 -44304,
 1391334978,
 110844,
 -44303,
 1391400302,
 110843,
 -44302,
 1391465552,
 110842,
 -44301,
 1391530795,
 110841,
 -1,
 1391596027,
 110840,
 1391809275,
 1391303438,
 -1,
 -44298,
 1391728439,
 110855,
 -44297,
 1391793730,
 110854,
 -44296,
 1391859054,
 110853,
 -44295,
 1391924304,
 110852,
 -44294,
 1391989547,
 110851,
 -1,
 1392054779,
 110850,
 1392268032,
 1391740394,
 -1,
 -44291,
 1392186734,
 110849,
 -44290,
 1392251984,
 110848,
 -44289,
 1392317227,
 110847,
 -1,
 1392382459,
 110846,
 1392639999,
 1392188137,
 -1,
 -44286,
 1392514414,
 110832,
 -44285,
 1392579664,
 110831,
 -44284,
 1392644907,
 110830,
 -1,
 1392710139,
 110829,
 1392923430,
 1390709068,
 -1,
 1392988942,
 1392863343,
 -1,
 -44280,
 1392908295,
 110799,
 -44279,
 1392973623,
 110798,
 -44278,
 1393038914,
 110797,
 -44277,
 1393104238,
 110796,
 -44276,
 1393169488,
 110795,
 -44275,
 1393234731,
 110794,
 -1,
 1393299963,
 110793,
 1393513238,
 1392909033,
 -1,
 -44272,
 1393432583,
 110792,
 -44271,
 1393497911,
 110791,
 -44270,
 1393563202,
 110790,
 -44269,
 1393628526,
 110789,
 -44268,
 1393693776,
 110788,
 -44267,
 1393759019,
 110787,
 -1,
 1393824251,
 110786,
 1394037533,
 1393466126,
 -1,
 -44264,
 1393956663,
 110812,
 -44263,
 1394021954,
 110811,
 -44262,
 1394087278,
 110810,
 -44261,
 1394152528,
 110809,
 -44260,
 1394217771,
 110808,
 -1,
 1394283003,
 110807,
 1394496290,
 1394007330,
 -1,
 -44257,
 1394414958,
 110803,
 -44256,
 1394480208,
 110802,
 -44255,
 1394545451,
 110801,
 -1,
 1394610683,
 110800,
 1394868223,
 1394427370,
 -1,
 -44252,
 1394772386,
 110806,
 -44251,
 1394807595,
 110805,
 -1,
 1394872827,
 110804,
 1395086144,
 1392896673,
 -1,
 1395151663,
 1395038990,
 -1,
 -44247,
 1395070983,
 110876,
 -44246,
 1395136311,
 110875,
 -44245,
 1395201602,
 110874,
 -44244,
 1395266926,
 110873,
 -44243,
 1395332176,
 110872,
 -44242,
 1395397419,
 110871,
 -1,
 1395462651,
 110870,
 1395675957,
 1395091567,
 -1,
 -44239,
 1395594818,
 110865,
 -44238,
 1395660142,
 110864,
 -44237,
 1395725392,
 110863,
 -44236,
 1395790635,
 110862,
 -1,
 1395855867,
 110861,
 1396069179,
 1395596009,
 -1,
 -44233,
 1395988034,
 110860,
 -44232,
 1396053358,
 110859,
 -44231,
 1396118608,
 110858,
 -44230,
 1396183851,
 110857,
 -1,
 1396249083,
 110856,
 1396506623,
 1396000234,
 -1,
 -44227,
 1396381038,
 110869,
 -44226,
 1396446288,
 110868,
 -44225,
 1396511531,
 110867,
 -1,
 1396576763,
 110866,
 1396790100,
 1395061558,
 -1,
 1396855624,
 1396742926,
 -1,
 -44221,
 1396774711,
 110828,
 -44220,
 1396840002,
 110827,
 -44219,
 1396905326,
 110826,
 -44218,
 1396970576,
 110825,
 -44217,
 1397035819,
 110824,
 -1,
 1397101051,
 110823,
 1397314383,
 1396775657,
 -1,
 -44214,
 1397290406,
 110818,
 -44213,
 1397298754,
 110817,
 -44212,
 1397364078,
 110816,
 -44211,
 1397429328,
 110815,
 -44210,
 1397494571,
 110814,
 -1,
 1397559803,
 110813,
 1397817343,
 1397284130,
 -1,
 -44207,
 1397691758,
 110822,
 -44206,
 1397757008,
 110821,
 -44205,
 1397822251,
 110820,
 -1,
 1397887483,
 110819,
 1398100827,
 1396721130,
 -1,
 -44202,
 1398019895,
 110611,
 -44201,
 1398085186,
 110610,
 -44200,
 1398150510,
 110609,
 -44199,
 1398215760,
 110608,
 -44198,
 1398281003,
 110607,
 -1,
 1398346235,
 983266,
 1398559585,
 1398070562,
 -1,
 -44195,
 1398478402,
 110606,
 -44194,
 1398543726,
 110605,
 -44193,
 1398608976,
 110604,
 -44192,
 1398674219,
 110603,
 -1,
 1398739451,
 110602,
 1398952806,
 1398499439,
 -1,
 -44189,
 1398871406,
 110601,
 -44188,
 1398936656,
 110600,
 -44187,
 1399001899,
 110599,
 -1,
 1399067131,
 110598,
 1399280491,
 1398872809,
 -1,
 -44184,
 1399255091,
 110597,
 -44183,
 1399264336,
 110596,
 -44182,
 1399329579,
 110595,
 -1,
 1399394811,
 110594,
 1399652351,
 1399233294,
 -1,
 -44179,
 1399526480,
 110614,
 -44178,
 1399591723,
 110613,
 -1,
 1399656955,
 110612,
 1399870414,
 1377301084,
 -1,
 1399935877,
 1399836662,
 -1,
 1400001412,
 1399873666,
 -1,
 1400066934,
 1399926696,
 -1,
 -44172,
 1400026887,
 19904,
 -44171,
 1400079525,
 19933,
 -1,
 1400121417,
 19953,
 1400329083,
 1399986762,
 -1,
 1400394618,
 1400288226,
 -1,
 -44167,
 1400350414,
 19954,
 -1,
 1400410759,
 19910,
 -1,
 1400319899,
 19932,
 1400656766,
 1400302241,
 -1,
 -44163,
 1400588918,
 19951,
 -1,
 1400644246,
 19959,
 -44161,
 1400616744,
 19905,
 -44160,
 1400802253,
 19957,
 -44159,
 1400863233,
 19955,
 -44158,
 1400928307,
 19961,
 -44157,
 1400986181,
 19960,
 -1,
 1401049739,
 19940,
 -1,
 1399961254,
 19913,
 1401312143,
 1399864149,
 -1,
 1401377674,
 1401242818,
 -1,
 -44152,
 1401349881,
 19956,
 -44151,
 1401390354,
 19943,
 -1,
 1401436371,
 19944,
 1401639821,
 1401317373,
 -1,
 -44148,
 1401604982,
 19962,
 -1,
 1401639729,
 19906,
 -44146,
 1401611215,
 19935,
 -1,
 1401758988,
 19939,
 1401967514,
 1401247827,
 -1,
 1402033049,
 1401926626,
 -1,
 1402098584,
 1401964213,
 -1,
 1402164119,
 1402055120,
 -1,
 1402229654,
 1402116801,
 -1,
 -44139,
 1402203245,
 19937,
 -1,
 1402260579,
 19917,
 -1,
 1402189951,
 19931,
 -1,
 1402130794,
 19929,
 -1,
 1402018788,
 19925,
 -1,
 1401956257,
 19948,
 1402688416,
 1401930196,
 -1,
 1402753950,
 1402636941,
 -1,
 -44131,
 1402720618,
 19912,
 -1,
 1402777749,
 19965,
 -44129,
 1402720629,
 19915,
 -1,
 1402908209,
 19926,
 1403081638,
 1402629435,
 -1,
 1403147172,
 1403032224,
 -1,
 -44125,
 1403100055,
 19928,
 -1,
 1403145586,
 19964,
 -44123,
 1403082135,
 19934,
 -1,
 1403271379,
 19945,
 1403474859,
 1403041443,
 -1,
 1403540394,
 1403441142,
 -1,
 -44119,
 1403511822,
 19927,
 -1,
 1403565808,
 19936,
 -1,
 1403513268,
 19952,
 1403802543,
 1403431376,
 -1,
 -44115,
 1403774174,
 19949,
 -44114,
 1403830113,
 19938,
 -1,
 1403864584,
 19914,
 1404064692,
 1403755201,
 -1,
 1404130227,
 1404022770,
 -1,
 -44110,
 1404090589,
 19950,
 -1,
 1404150941,
 19941,
 -1,
 1404055301,
 19942,
 1404392377,
 1403991642,
 -1,
 1404457912,
 1404342944,
 -1,
 -44105,
 1404424844,
 19923,
 -1,
 1404458307,
 19909,
 -1,
 1404407727,
 19947,
 1404720061,
 1404315911,
 -1,
 -44101,
 1404679864,
 19946,
 -44100,
 1404728754,
 19924,
 -1,
 1404782741,
 19967,
 1404982209,
 1404639818,
 -1,
 -44097,
 1404940350,
 19922,
 -44096,
 1404983335,
 19966,
 -1,
 1405038388,
 19958,
 1405244356,
 1404955297,
 -1,
 -44093,
 1405199338,
 19921,
 -1,
 1405230849,
 19908,
 1405440967,
 1405194344,
 -1,
 -44090,
 1405412672,
 19930,
 -1,
 1405435426,
 19918,
 1405637578,
 1405374963,
 -1,
 -44087,
 1405590985,
 19920,
 -1,
 1405635194,
 19916,
 -44085,
 1405613518,
 19907,
 -44084,
 1405781080,
 19963,
 -44083,
 1405838438,
 19911,
 -1,
 1405897778,
 19919,
 1406096429,
 1399790154,
 -1,
 1406161953,
 1406069399,
 -1,
 1406227423,
 1406124500,
 -1,
 1406292952,
 1406183191,
 -1,
 1406358485,
 1406266492,
 -1,
 -44076,
 1406331139,
 128605,
 -1,
 1406349079,
 128613,
 1406599167,
 1406289496,
 -1,
 -44073,
 1406527747,
 128607,
 -1,
 1406545687,
 128615,
 1406751707,
 1406236327,
 -1,
 -44070,
 1406716848,
 128952,
 -1,
 1406775005,
 128972,
 1406948318,
 1406671434,
 -1,
 -44067,
 1406900428,
 128635,
 -1,
 1406961876,
 128940,
 -1,
 1406875930,
 128625,
 1407210474,
 1406172219,
 -1,
 1407276003,
 1407166709,
 -1,
 -44062,
 1407240306,
 10079,
 -1,
 1407271310,
 10080,
 1407472614,
 1407207708,
 -1,
 -44059,
 1407417823,
 129052,
 -1,
 1407470868,
 129048,
 1407669225,
 1407392330,
 -1,
 -44056,
 1407637081,
 128327,
 -1,
 1407695227,
 11093,
 -1,
 1407609624,
 128627,
 1407931378,
 1407130186,
 -1,
 1407996913,
 1407893648,
 -1,
 1408062448,
 1407950617,
 129180,
 1408172031,
 1407975424,
 -1,
 -44049,
 1408095224,
 129183,
 -1,
 1408130697,
 129182,
 -1,
 1408031873,
 129181,
 -1,
 1407947112,
 128628,
 1408455673,
 1407883326,
 -1,
 1408521206,
 1408429180,
 -1,
 -44043,
 1408493827,
 128604,
 -1,
 1408511767,
 128612,
 1408761855,
 1408452184,
 -1,
 -44040,
 1408690435,
 128606,
 -1,
 1408708375,
 128614,
 1408914432,
 1408386242,
 -1,
 1408979967,
 1408854881,
 -1,
 1409045502,
 1408937684,
 -1,
 -44035,
 1409002906,
 128977,
 -1,
 1409035460,
 128975,
 -1,
 1409010608,
 128958,
 -1,
 1408955002,
 10071,
 1409373191,
 1408842581,
 -1,
 1409438726,
 1409325761,
 -1,
 1409504261,
 1409413151,
 -1,
 -44028,
 1409449439,
 129055,
 -1,
 1409502484,
 129051,
 -1,
 1409451374,
 128178,
 -1,
 1409382032,
 10135,
 1409831948,
 1409299475,
 11096,
 1409897483,
 1409747922,
 -1,
 -44022,
 1409863239,
 9955,
 -1,
 1409889306,
 11095,
 -1,
 1409825689,
 11097,
 1410159632,
 1409805543,
 -1,
 -44018,
 1410124740,
 128913,
 -44017,
 1410155277,
 9947,
 -1,
 1410216979,
 128903,
 1410421779,
 1410130783,
 -1,
 -44014,
 1410366943,
 129053,
 -1,
 1410419988,
 129049,
 1410618390,
 1410390938,
 -1,
 -44011,
 1410575770,
 128980,
 -1,
 1410608324,
 128979,
 1410815001,
 1410579618,
 -1,
 -44008,
 1410760159,
 129054,
 -1,
 1410813204,
 129050,
 1411011612,
 1410749607,
 -1,
 -44005,
 1410976688,
 128946,
 -1,
 1411034845,
 128970,
 -44003,
 1410969244,
 10133,
 -44002,
 1411163959,
 11094,
 -44001,
 1411223540,
 10134,
 -44000,
 1411281258,
 128633,
 -1,
 1411343635,
 129943,
 1411535913,
 1406120930,
 -1,
 1411601448,
 1411502072,
 -1,
 1411666983,
 1411575376,
 -1,
 -43995,
 1411634844,
 127892,
 -43994,
 1411693131,
 128157,
 -1,
 1411720640,
 128152,
 -1,
 1411595596,
 128159,
 -1,
 1411518490,
 128585,
 1412104191,
 1411464021,
 -1,
 1412125740,
 1412025757,
 129702,
 -1,
 1412039500,
 9980,
 -1,
 1412082988,
 127911,
 1412322358,
 1406021301,
 -1,
 1412387891,
 1412278736,
 -1,
 1412453426,
 1412340953,
 -1,
 -43983,
 1412411980,
 1479,
 -1,
 1412457554,
 1466,
 -1,
 1412423835,
 1478,
 -43980,
 1412363697,
 1519,
 -43979,
 1412664194,
 1477,
 -1,
 1412701122,
 1442,
 1412912186,
 1412267067,
 -1,
 -43976,
 1412861416,
 9937,
 -43975,
 1412925535,
 11263,
 -1,
 1412983200,
 128641,
 -43973,
 1412871712,
 127807,
 -1,
 1413103144,
 129428,
 1413305697,
 1377180234,
 -1,
 1413371186,
 1413255840,
 -1,
 1413436649,
 1413307738,
 -1,
 1413502139,
 1413379905,
 -1,
 1413567634,
 1413456022,
 -1,
 1413633111,
 1413530068,
 -1,
 1413698638,
 1413596007,
 -1,
 1413764165,
 1413666204,
 55245,
 -1,
 1413681225,
 55246,
 1413895240,
 1413728412,
 -1,
 -43961,
 1413862812,
 55277,
 -1,
 1413905181,
 55276,
 -43959,
 1413870776,
 983211,
 -43958,
 1414052486,
 55255,
 -43957,
 1414114666,
 55270,
 -43956,
 1414174387,
 4607,
 -43955,
 1414238010,
 55264,
 -1,
 1414280181,
 55289,
 1414529023,
 1413640925,
 -1,
 1414550610,
 1414410152,
 -1,
 -43951,
 1414490720,
 55279,
 -1,
 1414554254,
 55280,
 -43949,
 1414517738,
 55281,
 -43948,
 1414703809,
 55278,
 -43947,
 1414762298,
 55274,
 -43946,
 1414822209,
 55275,
 -1,
 1414881941,
 55282,
 1415074918,
 1413589456,
 -1,
 1415140448,
 1415015020,
 -1,
 1415205980,
 1415065512,
 -1,
 -43941,
 1415146080,
 55272,
 -1,
 1415209614,
 55273,
 -43939,
 1415173532,
 55267,
 -43938,
 1415366842,
 55271,
 -43937,
 1415428756,
 55268,
 -1,
 1415483194,
 55269,
 1415664739,
 1415078573,
 -1,
 -43934,
 1415631850,
 55291,
 -1,
 1415694487,
 55290,
 1415905279,
 1415586657,
 -1,
 -43931,
 1415818602,
 55283,
 -1,
 1415870785,
 55284,
 1416057968,
 1415035519,
 -1,
 1416123498,
 1416033348,
 -1,
 -43927,
 1416087503,
 55259,
 -1,
 1416143799,
 55260,
 1416320109,
 1416080752,
 -1,
 -43924,
 1416287644,
 55257,
 -1,
 1416342820,
 55258,
 -43922,
 1416285249,
 55253,
 -43921,
 1416466247,
 55256,
 -1,
 1416526628,
 55254,
 1416713336,
 1416025507,
 -1,
 1416778867,
 1416677527,
 55248,
 -1,
 1416695762,
 55249,
 1416909942,
 1416703912,
 -1,
 -43915,
 1416850016,
 55250,
 -1,
 1416913550,
 55251,
 -43913,
 1416877034,
 55252,
 -1,
 1417063786,
 55247,
 1417237632,
 1416656992,
 -1,
 1417303167,
 1417180957,
 -1,
 -43909,
 1417260394,
 4603,
 -43908,
 1417320115,
 4602,
 -43907,
 1417378459,
 4605,
 -43906,
 1417437845,
 4606,
 -1,
 1417491284,
 4604,
 -1,
 1417225270,
 55261,
 1417761927,
 1417213121,
 -1,
 1417827460,
 1417705568,
 -1,
 -43901,
 1417770775,
 983209,
 -1,
 1417831078,
 983212,
 -43899,
 1417792577,
 983210,
 -43898,
 1417973562,
 55285,
 -1,
 1418027669,
 55286,
 1418220684,
 1417711424,
 -1,
 -43895,
 1418185805,
 55263,
 -43894,
 1418243447,
 55265,
 -43893,
 1418303155,
 55262,
 -1,
 1418343413,
 55266,
 1418548367,
 1418172089,
 -1,
 -43890,
 1418508921,
 55243,
 -1,
 1418539860,
 55244,
 1418788863,
 1418474491,
 -1,
 -43887,
 1418710104,
 55288,
 -1,
 1418767722,
 55287,
 1418985471,
 1413538067,
 -1,
 1419007134,
 1418881135,
 -1,
 1419072668,
 1418982198,
 -1,
 1419138199,
 1419003074,
 55232,
 -1,
 1419090625,
 55231,
 1419269274,
 1419057738,
 -1,
 -43879,
 1419199682,
 55230,
 -1,
 1419251754,
 55229,
 -43877,
 1419238587,
 55235,
 -1,
 1419418305,
 55234,
 -43875,
 1419025169,
 55233,
 -1,
 1419536381,
 55236,
 1419728040,
 1418982198,
 -1,
 1419793571,
 1419680526,
 -1,
 1419859106,
 1419713098,
 55218,
 -1,
 1419789506,
 55219,
 -1,
 1419791504,
 55220,
 1420055718,
 1419762978,
 -1,
 -43867,
 1420008129,
 55224,
 -1,
 1420041462,
 55223,
 -43865,
 1419988115,
 4517,
 -1,
 1420172030,
 4516,
 1420383406,
 1419680526,
 -1,
 1420448941,
 1420358454,
 -1,
 1420514476,
 1420368458,
 4518,
 -1,
 1420444866,
 4519,
 -1,
 1420446864,
 55216,
 -1,
 1420401425,
 55217,
 1420776627,
 1420316490,
 -1,
 1420842161,
 1420707010,
 55227,
 -1,
 1420794561,
 55226,
 -43854,
 1420794561,
 55228,
 -1,
 1420892746,
 55225,
 1421104312,
 1420696138,
 -1,
 1421169847,
 1421063330,
 -1,
 -43850,
 1421100226,
 55238,
 -1,
 1421154890,
 55237,
 -1,
 1421086628,
 4515,
 1421475839,
 1421073698,
 -1,
 -43846,
 1421407391,
 55221,
 -1,
 1421437042,
 55222,
 1421672447,
 1413428122,
 -1,
 1421694155,
 1421589119,
 -1,
 1421759683,
 1421656532,
 -1,
 1421825218,
 1421722471,
 -1,
 -43840,
 1421792668,
 43367,
 -43839,
 1421847914,
 43370,
 -1,
 1421900573,
 43365,
 -1,
 1421767385,
 43372,
 1422152903,
 1421703264,
 -1,
 -43835,
 1422096151,
 43364,
 -43834,
 1422156454,
 43374,
 -1,
 1422205993,
 43371,
 -43832,
 1422120348,
 43366,
 -43831,
 1422372202,
 43369,
 -43830,
 1422430010,
 43368,
 -1,
 1422472181,
 43373,
 1422677201,
 1421661603,
 -1,
 -43827,
 1422641303,
 43362,
 -43826,
 1422703225,
 4446,
 -43825,
 1422765418,
 43361,
 -43824,
 1422823226,
 43360,
 -1,
 1422865397,
 43363,
 1423070422,
 1422642235,
 -1,
 -43821,
 1423045795,
 43388,
 -43820,
 1423102954,
 43385,
 -43819,
 1423165602,
 43381,
 -1,
 1423193090,
 43384,
 1423398108,
 1423026640,
 -1,
 1423463643,
 1423338092,
 -1,
 -43815,
 1423427757,
 43378,
 -43814,
 1423473307,
 43379,
 -1,
 1423532693,
 43380,
 -1,
 1423401653,
 43386,
 1423791328,
 1423349433,
 -1,
 -43810,
 1423755415,
 4443,
 -43809,
 1423794837,
 4445,
 -1,
 1423848437,
 4444,
 1424053476,
 1423740736,
 -1,
 -43806,
 1424020892,
 43376,
 -43805,
 1424083095,
 43377,
 -1,
 1424128797,
 43375,
 1424315623,
 1423993445,
 -1,
 -43802,
 1424276089,
 43382,
 -1,
 1424319125,
 43383,
 -43800,
 1424259889,
 4442,
 -1,
 1424450203,
 43387,
 1424643372,
 1413376631,
 -1,
 1424708879,
 1424589474,
 -1,
 1424774385,
 1424652384,
 -1,
 1424839919,
 1424715966,
 -1,
 -43794,
 1424815034,
 68889,
 -1,
 1424878305,
 68887,
 -43792,
 1424776654,
 68872,
 -1,
 1424955978,
 68881,
 1425167605,
 1424724640,
 -1,
 -43789,
 1425142714,
 68891,
 -43788,
 1425168546,
 68890,
 -1,
 1425218122,
 68885,
 1425429752,
 1425133558,
 -1,
 -43785,
 1425395836,
 68868,
 -1,
 1425414730,
 68867,
 1425626363,
 1425392084,
 -1,
 -43782,
 1425563086,
 68880,
 -1,
 1425611338,
 68879,
 1425822974,
 1425585122,
 -1,
 -43779,
 1425781844,
 68877,
 -1,
 1425807946,
 68876,
 1426019585,
 1425750869,
 -1,
 -43776,
 1425947648,
 68875,
 -1,
 1426004554,
 68874,
 -43774,
 1425995379,
 68878,
 -43773,
 1426191290,
 68888,
 -43772,
 1426254561,
 68886,
 -43771,
 1426318765,
 68892,
 -43770,
 1426369057,
 68866,
 -43769,
 1426426274,
 68884,
 -43768,
 1426488453,
 68883,
 -43767,
 1426552671,
 68869,
 -43766,
 1426611662,
 68871,
 -43765,
 1426675874,
 68882,
 -43764,
 1426739784,
 68873,
 -43763,
 1426796511,
 68870,
 -43762,
 1426860344,
 68865,
 -1,
 1426922058,
 68864,
 1427133725,
 1424637677,
 -1,
 1427199251,
 1427099638,
 -1,
 -43758,
 1427173427,
 68914,
 -1,
 1427203615,
 68915,
 1427395862,
 1427161556,
 -1,
 -43755,
 1427338916,
 68918,
 -1,
 1427394532,
 68919,
 1427592473,
 1427329523,
 -1,
 -43752,
 1427547672,
 68916,
 -1,
 1427600874,
 68917,
 -43750,
 1427568432,
 68912,
 -43749,
 1427742489,
 68913,
 -43748,
 1427805934,
 68921,
 -1,
 1427851678,
 68920,
 1428051235,
 1427106280,
 -1,
 -43745,
 1428020411,
 68895,
 -43744,
 1428069057,
 68897,
 -43743,
 1428121597,
 68894,
 -43742,
 1428178114,
 68896,
 -1,
 1428232778,
 68893,
 1428444457,
 1428015067,
 -1,
 1428509992,
 1428410492,
 -1,
 -43738,
 1428474988,
 68903,
 -43737,
 1428525802,
 68902,
 -1,
 1428577910,
 68901,
 -1,
 1428447263,
 68900,
 1428881407,
 1428392807,
 -1,
 -43733,
 1428800214,
 68898,
 -1,
 1428853501,
 68899,
 1429078015,
 1424571221,
 -1,
 1429099824,
 1428957496,
 -1,
 -43729,
 1429046564,
 129342,
 -1,
 1429100627,
 128092,
 -43727,
 1429063120,
 129309,
 -1,
 1429212566,
 129310,
 1429427542,
 1413337078,
 -1,
 1429493077,
 1429386606,
 -1,
 1429558606,
 1429439138,
 -1,
 1429624122,
 1429520852,
 -1,
 1429689657,
 1429543498,
 -1,
 -43720,
 1429638508,
 67822,
 -1,
 1429683785,
 67825,
 -1,
 1429627731,
 67828,
 1429951805,
 1429590006,
 -1,
 -43716,
 1429884618,
 67816,
 -1,
 1429940389,
 67829,
 1430148415,
 1429889151,
 67812,
 -1,
 1430115149,
 67815,
 1430279490,
 1430067786,
 -1,
 -43711,
 1430255003,
 67823,
 -1,
 1430291051,
 67808,
 -43709,
 1430255369,
 67814,
 -43708,
 1430451646,
 67817,
 -43707,
 1430514641,
 67813,
 -43706,
 1430565503,
 67826,
 -43705,
 1430629349,
 67824,
 -43704,
 1430690355,
 67821,
 -43703,
 1430752645,
 67820,
 -43702,
 1430814082,
 67819,
 -43701,
 1430878524,
 67818,
 -43700,
 1430936496,
 67810,
 -43699,
 1430994009,
 67811,
 -1,
 1431055182,
 67809,
 1431306239,
 1429510647,
 -1,
 1431328082,
 1431228406,
 -1,
 -43695,
 1431301201,
 67838,
 -1,
 1431325409,
 67837,
 1431524692,
 1431281433,
 67835,
 -1,
 1431438209,
 67839,
 -1,
 1431458978,
 67836,
 -1,
 1429418867,
 128035,
 1431786845,
 1429375308,
 -1,
 1431852379,
 1431735736,
 128296,
 1431961599,
 1431765058,
 -1,
 -43686,
 1431892436,
 128736,
 -1,
 1431940428,
 9874,
 -43684,
 1431817527,
 128057,
 -1,
 1432039238,
 127828,
 -43682,
 1431746130,
 128436,
 -43681,
 1432203347,
 128587,
 -43680,
 1432253413,
 128135,
 -1,
 1432305110,
 11233,
 1432507795,
 1413257921,
 -1,
 1432573308,
 1432466402,
 -1,
 1432638840,
 1432516408,
 -1,
 1432704364,
 1432592198,
 -1,
 -43674,
 1432623111,
 129915,
 -43673,
 1432688439,
 129914,
 -43672,
 1432753730,
 129913,
 -43671,
 1432819054,
 129912,
 -43670,
 1432884304,
 129911,
 -43669,
 1432949547,
 129910,
 -1,
 1433015048,
 129921,
 1433228660,
 1432670198,
 -1,
 1433294195,
 1433148229,
 -1,
 1433359730,
 1433264051,
 983059,
 1433468927,
 1433272320,
 -1,
 -43663,
 1433398970,
 983140,
 -1,
 1433453805,
 983137,
 -1,
 1433273341,
 11134,
 -1,
 1433253032,
 128677,
 1433752951,
 1433152651,
 -1,
 -43658,
 1433705393,
 11203,
 -1,
 1433756193,
 11043,
 -1,
 1433700971,
 9897,
 1434058751,
 1432601596,
 128014,
 1434124287,
 1433927680,
 -1,
 -43653,
 1434039418,
 127943,
 -1,
 1434079819,
 128052,
 1434277250,
 1432542395,
 -1,
 1434342785,
 1434239999,
 -1,
 1434408320,
 1434267427,
 127968,
 -1,
 1434370516,
 127960,
 -1,
 1434381961,
 127969,
 -1,
 1434302865,
 9203,
 1434670472,
 1434243062,
 -1,
 1434736007,
 1434583040,
 -1,
 -43643,
 1434692803,
 127798,
 -43642,
 1434730399,
 127789,
 -1,
 1434790810,
 9749,
 -1,
 1434667567,
 127976,
 1435063692,
 1434614843,
 -1,
 1435129227,
 1435010903,
 128616,
 -1,
 1435042714,
 128617,
 -1,
 1435059394,
 128371,
 1435325839,
 1435014610,
 -1,
 -43634,
 1435249341,
 128029,
 -1,
 1435306126,
 127855,
 -43632,
 1435290530,
 127973,
 -43631,
 1435478480,
 983123,
 -43630,
 1435540721,
 129693,
 -1,
 1435579270,
 128298,
 1435784622,
 1432446973,
 -1,
 1435850144,
 1435743413,
 -1,
 1435915675,
 1435773918,
 -1,
 -43625,
 1435884731,
 983980,
 -43624,
 1435933377,
 983982,
 -43623,
 1435985917,
 983979,
 -43622,
 1436042434,
 983981,
 -1,
 1436097098,
 983978,
 1436308895,
 1435880067,
 -1,
 -43619,
 1436261057,
 110930,
 -43618,
 1436313597,
 110928,
 -1,
 1436370114,
 110929,
 -1,
 1436230851,
 110593,
 1436636585,
 1435785933,
 -1,
 1436702117,
 1436553042,
 -1,
 1436767652,
 1436666730,
 128644,
 -1,
 1436683225,
 128645,
 -1,
 1436705133,
 128096,
 1437007871,
 1436614656,
 -1,
 -43609,
 1436936615,
 9889,
 -43608,
 1436982201,
 983122,
 -1,
 1437019835,
 128262,
 -43606,
 1436601768,
 9964,
 -43605,
 1437184027,
 129435,
 -43604,
 1437242525,
 128725,
 -43603,
 1437301473,
 129406,
 -1,
 1437346899,
 127802,
 1437554099,
 1435753659,
 -1,
 -43600,
 1437519862,
 128726,
 -43599,
 1437582921,
 128559,
 -43598,
 1437635721,
 128175,
 -1,
 1437686407,
 129303,
 1437881784,
 1437528886,
 -1,
 1437947319,
 1437837776,
 -1,
 -43594,
 1437899762,
 11794,
 -1,
 1437950361,
 11802,
 -1,
 1437883293,
 11226,
 1438209467,
 1437847542,
 983060,
 -43590,
 1438171604,
 983138,
 -1,
 1438218049,
 983141,
 -1,
 1438171592,
 8372,
 1438472463,
 1377147585,
 -1,
 1438537690,
 1438415931,
 -1,
 1438603161,
 1438464853,
 -1,
 1438668693,
 1438515200,
 -1,
 1438733878,
 1438607267,
 -1,
 1438799351,
 1438697965,
 -1,
 1438864865,
 1438729410,
 68809,
 1438930376,
 1438814880,
 68825,
 1438995910,
 1438896118,
 68839,
 -1,
 1438912673,
 68849,
 -43577,
 1438970678,
 68826,
 -1,
 1439051688,
 68805,
 1439258059,
 1438855080,
 68804,
 -43574,
 1439220180,
 68806,
 -1,
 1439260092,
 68841,
 1439454669,
 1439233605,
 68847,
 -1,
 1439416788,
 68848,
 1439585743,
 1439420406,
 68838,
 -1,
 1439560502,
 68840,
 1439716817,
 1439547860,
 68836,
 -1,
 1439692357,
 68837,
 1439847891,
 1439664460,
 68824,
 -1,
 1439803856,
 68833,
 1439978965,
 1439792187,
 68822,
 -1,
 1439953718,
 68823,
 1440110039,
 1439914067,
 68813,
 -1,
 1440084790,
 68814,
 -43560,
 1440081306,
 68846,
 -43559,
 1440199650,
 68834,
 -43558,
 1440262608,
 68832,
 -43557,
 1440315488,
 68819,
 -43556,
 1440380737,
 68818,
 -43555,
 1440439740,
 68815,
 -43554,
 1440502259,
 68812,
 -43553,
 1440564418,
 68811,
 -43552,
 1440627541,
 68807,
 -1,
 1440688391,
 68802,
 1440896486,
 1438784074,
 68800,
 -43549,
 1440846789,
 68808,
 -43548,
 1440910344,
 68803,
 -43547,
 1440970848,
 68820,
 -1,
 1441012298,
 68801,
 1441224170,
 1440865467,
 68842,
 -43544,
 1441193147,
 68843,
 -43543,
 1441251796,
 68850,
 -1,
 1441306527,
 68821,
 1441486317,
 1441176257,
 68827,
 -43540,
 1441438401,
 68828,
 -1,
 1441482729,
 68831,
 1441682928,
 1441448228,
 -1,
 -43537,
 1441652489,
 68845,
 -1,
 1441700881,
 68830,
 1441879539,
 1441634018,
 -1,
 -43534,
 1441849097,
 68844,
 -1,
 1441897489,
 68829,
 1442076149,
 1441818621,
 68816,
 -1,
 1442015229,
 68817,
 -43530,
 1442039551,
 68835,
 -1,
 1442133436,
 68810,
 1442338349,
 1438724314,
 -1,
 1442403863,
 1442268354,
 68745,
 1442469374,
 1442353824,
 68761,
 1442534908,
 1442435062,
 68775,
 -1,
 1442451617,
 68785,
 -43523,
 1442509622,
 68762,
 -1,
 1442590632,
 68741,
 1442797057,
 1442394024,
 68740,
 -43520,
 1442759124,
 68742,
 -1,
 1442799036,
 68777,
 1442993667,
 1442772549,
 68783,
 -1,
 1442955732,
 68784,
 1443124741,
 1442959350,
 68774,
 -1,
 1443099446,
 68776,
 1443255815,
 1443086804,
 68772,
 -1,
 1443231301,
 68773,
 1443386889,
 1443203404,
 68760,
 -1,
 1443342800,
 68769,
 1443517963,
 1443331131,
 68758,
 -1,
 1443492662,
 68759,
 1443649037,
 1443453011,
 68749,
 -1,
 1443623734,
 68750,
 -43506,
 1443620250,
 68782,
 -43505,
 1443738594,
 68770,
 -43504,
 1443801552,
 68768,
 -43503,
 1443854432,
 68755,
 -43502,
 1443919681,
 68754,
 -43501,
 1443978684,
 68751,
 -43500,
 1444041203,
 68748,
 -43499,
 1444103362,
 68747,
 -43498,
 1444166485,
 68743,
 -1,
 1444227335,
 68738,
 1444435484,
 1442323018,
 68736,
 -43495,
 1444385733,
 68744,
 -43494,
 1444449288,
 68739,
 -43493,
 1444509792,
 68756,
 -1,
 1444551242,
 68737,
 1444763168,
 1444404411,
 68778,
 -43490,
 1444732091,
 68779,
 -43489,
 1444790740,
 68786,
 -1,
 1444845471,
 68757,
 1445025315,
 1444715201,
 68763,
 -43486,
 1444977345,
 68764,
 -1,
 1445021673,
 68767,
 1445221926,
 1444987172,
 -1,
 -43483,
 1445191433,
 68781,
 -1,
 1445239825,
 68766,
 1445418537,
 1445172962,
 -1,
 -43480,
 1445388041,
 68780,
 -1,
 1445436433,
 68765,
 1445615147,
 1445357565,
 68752,
 -1,
 1445554173,
 68753,
 -43476,
 1445578495,
 68771,
 -1,
 1445672380,
 68746,
 1445920767,
 1442290167,
 -1,
 1445942834,
 1445830425,
 68858,
 1446051839,
 1445855232,
 -1,
 -43471,
 1445975092,
 68863,
 -1,
 1446012786,
 68862,
 1446204981,
 1445876581,
 -1,
 -43468,
 1446176396,
 68859,
 -1,
 1446205495,
 68861,
 -1,
 1446171287,
 68860,
 1446467243,
 1438690506,
 -1,
 1446532732,
 1446429140,
 -1,
 1446598267,
 1446471884,
 -1,
 1446663794,
 1446561755,
 -1,
 1446729280,
 1446591317,
 -1,
 1446794814,
 1446648394,
 66477,
 1446903807,
 1446733789,
 66508,
 -1,
 1446776663,
 66509,
 -43457,
 1446763707,
 66479,
 -1,
 1446930429,
 66478,
 1447122500,
 1446648394,
 66464,
 1447231487,
 1447093189,
 66504,
 -43453,
 1447124430,
 66506,
 -1,
 1447169879,
 66505,
 1447384648,
 1447088118,
 -1,
 -43450,
 1447353531,
 66476,
 -43449,
 1447386574,
 66480,
 -1,
 1447434826,
 66475,
 1447646796,
 1447346644,
 -1,
 -43446,
 1447609001,
 66498,
 -43445,
 1447648718,
 66497,
 -1,
 1447696970,
 66495,
 1447908944,
 1447594316,
 -1,
 -43442,
 1447877819,
 66488,
 -43441,
 1447913469,
 66487,
 -1,
 1447959114,
 66486,
 1448171092,
 1447831815,
 -1,
 1448236627,
 1448090186,
 66482,
 -1,
 1448171682,
 66510,
 -1,
 1448207739,
 66511,
 1448433239,
 1448145456,
 -1,
 -43434,
 1448396186,
 66507,
 -1,
 1448417866,
 66471,
 1448629850,
 1448404378,
 -1,
 -43431,
 1448568829,
 66491,
 -1,
 1448614474,
 66490,
 1448826461,
 1448588258,
 -1,
 -43428,
 1448795323,
 66493,
 -1,
 1448811082,
 66492,
 1449023072,
 1448776352,
 -1,
 -43425,
 1448991931,
 66485,
 -1,
 1449007690,
 66484,
 1449219683,
 1448966240,
 -1,
 -43422,
 1449188539,
 66468,
 -1,
 1449204298,
 66467,
 1449416294,
 1449162561,
 -1,
 -43419,
 1449355261,
 66474,
 -1,
 1449400906,
 66473,
 1449612905,
 1449351251,
 -1,
 -43416,
 1449581755,
 66470,
 -1,
 1449597514,
 66469,
 -43414,
 1449588339,
 66496,
 -43413,
 1449784250,
 66489,
 -43412,
 1449843899,
 66466,
 -43411,
 1449896481,
 66481,
 -43410,
 1449950341,
 66494,
 -43409,
 1450010621,
 66465,
 -43408,
 1450073550,
 66499,
 -43407,
 1450136136,
 66483,
 -1,
 1450192863,
 66472,
 1450399354,
 1446615543,
 -1,
 1450464888,
 1450364918,
 -1,
 1450530423,
 1450437281,
 -1,
 -43402,
 1450482369,
 66514,
 -1,
 1450527834,
 66516,
 -1,
 1450461921,
 66515,
 -43399,
 1450417945,
 66513,
 -1,
 1450731378,
 66517,
 -1,
 1450373523,
 66512,
 -1,
 1446551302,
 128435,
 1451098111,
 1446481435,
 -1,
 1451120261,
 1451029302,
 -1,
 1451185793,
 1451052330,
 66415,
 -43392,
 1451154619,
 66408,
 -1,
 1451190269,
 66416,
 1451382403,
 1451104842,
 66420,
 -1,
 1451347958,
 66417,
 -43388,
 1451351227,
 66419,
 -1,
 1451475351,
 66407,
 1451644554,
 1451082196,
 -1,
 1451710089,
 1451580860,
 -1,
 -43384,
 1451663716,
 66405,
 -1,
 1451701135,
 66406,
 -1,
 1451650133,
 66401,
 1451972237,
 1451583485,
 66393,
 -43380,
 1451902146,
 66418,
 -1,
 1451956810,
 66421,
 1452168850,
 1451899733,
 -1,
 1452234385,
 1452144197,
 -1,
 -43376,
 1452176675,
 66392,
 -1,
 1452237898,
 66390,
 -1,
 1452186821,
 66387,
 1452496533,
 1452144197,
 -1,
 -43372,
 1452434506,
 66389,
 -1,
 1452484381,
 66391,
 1452693144,
 1452467610,
 -1,
 -43369,
 1452646756,
 66398,
 -1,
 1452690730,
 66414,
 1452889755,
 1452658678,
 -1,
 -43366,
 1452853446,
 66413,
 -1,
 1452875350,
 66402,
 1453086365,
 1452841665,
 66409,
 -1,
 1453038273,
 66410,
 1453217439,
 1453016258,
 66388,
 -1,
 1453150707,
 66411,
 -43360,
 1453186235,
 66403,
 -43359,
 1453307938,
 66400,
 -43358,
 1453370395,
 66399,
 -43357,
 1453430127,
 66397,
 -43356,
 1453493676,
 66396,
 -43355,
 1453556279,
 66395,
 -43354,
 1453620076,
 66394,
 -43353,
 1453678030,
 66412,
 -43352,
 1453742323,
 66386,
 -43351,
 1453798199,
 66404,
 -43350,
 1453862722,
 66385,
 -1,
 1453924645,
 66384,
 1454135036,
 1446435550,
 -1,
 1454200538,
 1454089213,
 -1,
 1454266052,
 1454119498,
 68608,
 1454331577,
 1454195906,
 -1,
 -43344,
 1454306102,
 68632,
 -43343,
 1454362614,
 68677,
 -43342,
 1454424532,
 68670,
 -43341,
 1454486498,
 68668,
 -43340,
 1454543520,
 68644,
 -43339,
 1454603323,
 68640,
 -43338,
 1454667872,
 68634,
 -43337,
 1454725203,
 68623,
 -43336,
 1454783317,
 68627,
 -1,
 1454844167,
 68619,
 1455052475,
 1454293460,
 68669,
 -1,
 1454988732,
 68671,
 -43332,
 1455026998,
 68630,
 -43331,
 1455149046,
 68675,
 -43330,
 1455207394,
 68666,
 -43329,
 1455272462,
 68660,
 -43328,
 1455329952,
 68643,
 -43327,
 1455389755,
 68638,
 -43326,
 1455446099,
 68621,
 -43325,
 1455504213,
 68625,
 -1,
 1455565063,
 68617,
 1455773392,
 1454195906,
 -1,
 1455838922,
 1455723168,
 -1,
 -43321,
 1455813430,
 68650,
 -43320,
 1455869942,
 68646,
 -43319,
 1455904851,
 68653,
 -1,
 1455959976,
 68648,
 -43317,
 1455814213,
 68628,
 -43316,
 1456129350,
 68673,
 -43315,
 1456187856,
 68655,
 -43314,
 1456245068,
 68642,
 -43313,
 1456310391,
 68641,
 -1,
 1456353192,
 68658,
 1456559830,
 1455725249,
 68614,
 1456625363,
 1456489666,
 68615,
 -1,
 1456568416,
 68636,
 -43308,
 1456590838,
 68679,
 -43307,
 1456714254,
 68664,
 -1,
 1456777680,
 68656,
 1456953049,
 1456498685,
 68611,
 -43304,
 1456910862,
 68662,
 -1,
 1456943016,
 68657,
 -1,
 1456876134,
 68680,
 1457258495,
 1454175382,
 -1,
 1457280750,
 1457134154,
 68609,
 1457346276,
 1457210562,
 68610,
 1457411807,
 1457296032,
 68645,
 -1,
 1457346643,
 68654,
 -43296,
 1457386294,
 68633,
 -43295,
 1457508342,
 68678,
 -43294,
 1457551456,
 68635,
 -43293,
 1457608787,
 68624,
 -1,
 1457662215,
 68620,
 -43291,
 1457320758,
 68631,
 -43290,
 1457836022,
 68676,
 -43289,
 1457898822,
 68672,
 -43288,
 1457959906,
 68667,
 -43287,
 1458024974,
 68661,
 -43286,
 1458083312,
 68652,
 -43285,
 1458142267,
 68639,
 -43284,
 1458198611,
 68622,
 -43283,
 1458256725,
 68626,
 -1,
 1458317575,
 68618,
 1458525942,
 1457210562,
 68613,
 1458591475,
 1458475680,
 -1,
 -43279,
 1458565942,
 68651,
 -43278,
 1458622454,
 68647,
 -1,
 1458646952,
 68649,
 -43276,
 1458566725,
 68629,
 -43275,
 1458816326,
 68674,
 -1,
 1458843560,
 68659,
 1459050234,
 1458477761,
 -1,
 1459115769,
 1458980034,
 68616,
 -1,
 1459058784,
 68637,
 -1,
 1459073550,
 68665,
 1459355647,
 1458989053,
 68612,
 -1,
 1459270158,
 68663,
 1459443551,
 1454099156,
 -1,
 1459509042,
 1459378647,
 -1,
 1459574563,
 1459452987,
 -1,
 1459640098,
 1459506960,
 -1,
 1459705610,
 1459573657,
 -1,
 1459771139,
 1459671482,
 69403,
 -1,
 1459687186,
 69404,
 1459902213,
 1459733192,
 69398,
 -1,
 1459818258,
 69399,
 1460033287,
 1459853875,
 69391,
 -1,
 1459949330,
 69392,
 -43256,
 1459970175,
 69382,
 -43255,
 1460087630,
 69379,
 -1,
 1460150217,
 69377,
 1460360975,
 1459667412,
 -1,
 1460426510,
 1460279882,
 -1,
 -43251,
 1460374892,
 69393,
 -1,
 1460420169,
 69397,
 -1,
 1460364115,
 69401,
 1460688660,
 1460279882,
 -1,
 1460754195,
 1460632635,
 -1,
 -43246,
 1460720385,
 69395,
 -1,
 1460751563,
 69376,
 -1,
 1460729085,
 69394,
 1461016342,
 1460625535,
 69381,
 -1,
 1460982605,
 69385,
 -43241,
 1460991747,
 69384,
 -43240,
 1461122494,
 69386,
 -43239,
 1461185489,
 69383,
 -43238,
 1461244346,
 69402,
 -43237,
 1461303492,
 69400,
 -43236,
 1461365733,
 69396,
 -43235,
 1461426739,
 69390,
 -43234,
 1461489029,
 69389,
 -43233,
 1461550466,
 69388,
 -43232,
 1461614908,
 69387,
 -43231,
 1461672880,
 69380,
 -1,
 1461726030,
 69378,
 -1,
 1459579603,
 69415,
 1461999409,
 1459526135,
 -1,
 1462064940,
 1461964790,
 -1,
 1462130472,
 1462037153,
 -1,
 -43225,
 1462082241,
 69406,
 -1,
 1462127706,
 69411,
 1462327083,
 1462066620,
 -1,
 -43222,
 1462286254,
 69407,
 -1,
 1462334513,
 69412,
 -1,
 1462258401,
 69410,
 1462589230,
 1462017817,
 69405,
 -1,
 1462502273,
 69413,
 1462763519,
 1462522355,
 -1,
 -43216,
 1462674968,
 69408,
 -1,
 1462728170,
 69409,
 -1,
 1461933927,
 69414,
 1463025663,
 1459479859,
 -1,
 1463048026,
 1462928034,
 -1,
 1463113530,
 1463013366,
 -1,
 1463179064,
 1463049660,
 -1,
 -43209,
 1463111370,
 68220,
 -1,
 1463167141,
 68219,
 -43207,
 1463111370,
 68215,
 -1,
 1463298213,
 68201,
 1463506752,
 1463075284,
 -1,
 1463572287,
 1463425610,
 -1,
 -43203,
 1463537654,
 68202,
 -43202,
 1463586156,
 68207,
 -1,
 1463631433,
 68206,
 -1,
 1463509843,
 68198,
 1463899973,
 1463434069,
 -1,
 1463965508,
 1463836110,
 -1,
 -43197,
 1463911050,
 68217,
 -1,
 1463959113,
 68211,
 -1,
 1463885775,
 68213,
 1464227656,
 1463842912,
 -1,
 -43193,
 1464164873,
 68205,
 -1,
 1464214522,
 68203,
 1464424266,
 1464164479,
 68192,
 -1,
 1464390477,
 68194,
 1464555341,
 1464358995,
 -1,
 -43188,
 1464495339,
 68212,
 -1,
 1464557687,
 68214,
 1464751952,
 1464474186,
 -1,
 -43185,
 1464726939,
 68210,
 -1,
 1464762357,
 68209,
 -43183,
 1464727305,
 68216,
 -43182,
 1464923582,
 68218,
 -43181,
 1464986577,
 68197,
 -43180,
 1465039018,
 68199,
 -43179,
 1465102975,
 68196,
 -43178,
 1465162291,
 68204,
 -43177,
 1465224581,
 68195,
 -43176,
 1465286018,
 68193,
 -43175,
 1465340590,
 68208,
 -1,
 1465396046,
 68200,
 1465647103,
 1462999539,
 -1,
 1465669470,
 1465527054,
 -1,
 -43171,
 1465622297,
 68221,
 -1,
 1465668462,
 68222,
 -1,
 1465601453,
 68223,
 1465931660,
 1459394629,
 -1,
 1465997191,
 1465877154,
 -1,
 1466062695,
 1465962486,
 -1,
 1466128229,
 1465998780,
 -1,
 -43164,
 1466059092,
 68251,
 -1,
 1466113892,
 68249,
 -43162,
 1466059092,
 68233,
 -1,
 1466244645,
 68247,
 1466455915,
 1465994833,
 -1,
 -43159,
 1466373200,
 68239,
 -43158,
 1466438443,
 68230,
 -1,
 1466503675,
 68234,
 1466718062,
 1466431091,
 -1,
 -43155,
 1466658107,
 68248,
 -1,
 1466719676,
 68252,
 1466914673,
 1466660960,
 -1,
 -43152,
 1466850825,
 68237,
 -1,
 1466899827,
 68235,
 1467111284,
 1466850748,
 -1,
 -43149,
 1467042132,
 68224,
 -1,
 1467096613,
 68226,
 1467307895,
 1467045971,
 -1,
 -43146,
 1467244072,
 68246,
 -1,
 1467303981,
 68244,
 1467504506,
 1467235328,
 -1,
 -43143,
 1467448379,
 68245,
 -1,
 1467497301,
 68243,
 1467701117,
 1467423306,
 -1,
 -43140,
 1467645941,
 68241,
 -1,
 1467706683,
 68242,
 -43138,
 1467675739,
 68250,
 -43137,
 1467870161,
 68229,
 -43136,
 1467925188,
 68238,
 -43135,
 1467987998,
 68231,
 -43134,
 1468052021,
 68228,
 -43133,
 1468110839,
 68236,
 -43132,
 1468173628,
 68227,
 -43131,
 1468235113,
 68225,
 -43130,
 1468289753,
 68240,
 -1,
 1468345042,
 68232,
 1468596223,
 1465948663,
 -1,
 1468618635,
 1468518390,
 -1,
 -43126,
 1468591185,
 68255,
 -1,
 1468615393,
 68254,
 -1,
 1468571417,
 68253,
 1468880785,
 1465873727,
 -1,
 -43122,
 1468855364,
 66349,
 -43121,
 1468910389,
 66351,
 -43120,
 1468962900,
 66350,
 -1,
 1469009537,
 66335,
 1469208468,
 1468805994,
 -1,
 -43117,
 1469150615,
 94179,
 -1,
 1469211805,
 94178,
 -1,
 1469151822,
 128477,
 1469513727,
 1438600493,
 -1,
 -43113,
 1469444469,
 128117,
 -43112,
 1469483768,
 128116,
 -1,
 1469521136,
 129491,
 1469732825,
 1438515670,
 -1,
 1469798336,
 1469678242,
 -1,
 1469863845,
 1469717066,
 -1,
 1469929377,
 1469782602,
 -1,
 -43106,
 1469901473,
 7267,
 -43105,
 1469942092,
 7266,
 -43104,
 1470003296,
 7264,
 -1,
 1470068545,
 7265,
 -43102,
 1469894646,
 7259,
 -43101,
 1470207472,
 7261,
 -43100,
 1470266427,
 7262,
 -1,
 1470322771,
 7260,
 1470519212,
 1469807675,
 -1,
 1470584744,
 1470437962,
 7258,
 -1,
 1470503498,
 7263,
 -43095,
 1470553275,
 7273,
 -43094,
 1470667457,
 7283,
 -43093,
 1470719997,
 7268,
 -1,
 1470776514,
 7278,
 1470977969,
 1470487739,
 -1,
 -43090,
 1470952246,
 7277,
 -43089,
 1470994352,
 7276,
 -43088,
 1471036245,
 7275,
 -1,
 1471098792,
 7274,
 1471305654,
 1470929601,
 -1,
 -43085,
 1471276442,
 7286,
 -43084,
 1471339067,
 7284,
 -43083,
 1471372732,
 7287,
 -1,
 1471424775,
 7285,
 1471633339,
 1471244285,
 -1,
 -43080,
 1471594964,
 7269,
 -43079,
 1471656930,
 7272,
 -43078,
 1471715945,
 7271,
 -1,
 1471765948,
 7270,
 1472004095,
 1471562946,
 -1,
 -43075,
 1471922285,
 7282,
 -43074,
 1471982032,
 7279,
 -43073,
 1472041632,
 7281,
 -1,
 1472085179,
 7280,
 1472288718,
 1469726445,
 -1,
 1472354244,
 1472253942,
 -1,
 -43069,
 1472327731,
 7250,
 -1,
 1472357919,
 7251,
 1472550855,
 1472315860,
 -1,
 -43066,
 1472493220,
 7254,
 -1,
 1472548836,
 7255,
 1472747466,
 1472483827,
 -1,
 -43063,
 1472701976,
 7252,
 -1,
 1472755178,
 7253,
 -43061,
 1472722736,
 7248,
 -43060,
 1472896793,
 7249,
 -43059,
 1472960238,
 7257,
 -1,
 1473005982,
 7256,
 1473206227,
 1472244176,
 -1,
 1473271762,
 1473175679,
 -1,
 -43055,
 1473221077,
 7294,
 -1,
 1473266187,
 7295,
 -1,
 1473207783,
 7292,
 1473533910,
 1473155533,
 -1,
 -43051,
 1473449896,
 7290,
 -1,
 1473514408,
 7288,
 -43049,
 1473493030,
 7291,
 -43048,
 1473665193,
 7289,
 -1,
 1473715784,
 7293,
 -1,
 1469674986,
 129746,
 1473992808,
 1438499284,
 -1,
 1474058294,
 1473912291,
 -1,
 1474123785,
 1474021869,
 -1,
 1474189286,
 1474053314,
 66783,
 1474254821,
 1474125244,
 -1,
 1474320354,
 1474220022,
 -1,
 -43039,
 1474282153,
 66803,
 -1,
 1474304586,
 66801,
 -43037,
 1474275873,
 66797,
 -43036,
 1474459840,
 66789,
 -1,
 1474507377,
 66782,
 -1,
 1474194747,
 66784,
 1474779114,
 1474107978,
 66776,
 1474844649,
 1474717693,
 66777,
 -1,
 1474794144,
 66778,
 -1,
 1474780604,
 66779,
 1475041263,
 1474744310,
 -1,
 1475106798,
 1475002836,
 -1,
 -43027,
 1475042766,
 66804,
 -1,
 1475091018,
 66802,
 -1,
 1475025482,
 66800,
 1475368947,
 1474984032,
 -1,
 -43023,
 1475343290,
 66790,
 -43022,
 1475370446,
 66808,
 -1,
 1475418698,
 66788,
 1475631094,
 1475343941,
 -1,
 -43019,
 1475567054,
 66811,
 -1,
 1475615306,
 66810,
 1475827705,
 1475592660,
 -1,
 -43016,
 1475763662,
 66799,
 -1,
 1475811914,
 66798,
 1476024315,
 1475779265,
 66794,
 -1,
 1475964219,
 66795,
 1476155390,
 1475960252,
 -1,
 -43011,
 1476129722,
 66786,
 -1,
 1476139594,
 66785,
 -43009,
 1476127457,
 66807,
 -43008,
 1476320443,
 66806,
 -43007,
 1476373025,
 66796,
 -43006,
 1476432618,
 66793,
 -43005,
 1476495778,
 66792,
 -43004,
 1476557957,
 66791,
 -43003,
 1476618237,
 66787,
 -43002,
 1476680400,
 66809,
 -43001,
 1476738615,
 66805,
 -43000,
 1476801137,
 66781,
 -1,
 1476865646,
 66780,
 1477115903,
 1474048218,
 -1,
 1477138451,
 1477002434,
 66743,
 1477203986,
 1477074364,
 -1,
 1477269519,
 1477169142,
 -1,
 -42994,
 1477231273,
 66763,
 -1,
 1477253706,
 66761,
 -42992,
 1477224993,
 66757,
 -42991,
 1477408960,
 66749,
 -1,
 1477456497,
 66742,
 -1,
 1477143867,
 66744,
 1477728279,
 1477057098,
 66736,
 1477793814,
 1477666813,
 66737,
 -1,
 1477743264,
 66738,
 -1,
 1477729724,
 66739,
 1477990428,
 1477693430,
 -1,
 1478055963,
 1477951956,
 -1,
 -42982,
 1477991886,
 66764,
 -1,
 1478040138,
 66762,
 -1,
 1477974602,
 66760,
 1478318112,
 1477933152,
 -1,
 -42978,
 1478292410,
 66750,
 -42977,
 1478319566,
 66768,
 -1,
 1478367818,
 66748,
 1478580259,
 1478293061,
 -1,
 -42974,
 1478516174,
 66771,
 -1,
 1478564426,
 66770,
 1478776870,
 1478541780,
 -1,
 -42971,
 1478712782,
 66759,
 -1,
 1478761034,
 66758,
 1478973480,
 1478728385,
 66754,
 -1,
 1478913339,
 66755,
 1479104555,
 1478909372,
 -1,
 -42966,
 1479078842,
 66746,
 -1,
 1479088714,
 66745,
 -42964,
 1479076577,
 66767,
 -42963,
 1479269563,
 66766,
 -42962,
 1479322145,
 66756,
 -42961,
 1479381738,
 66753,
 -42960,
 1479444898,
 66752,
 -42959,
 1479507077,
 66751,
 -42958,
 1479567357,
 66747,
 -42957,
 1479629520,
 66769,
 -42956,
 1479687735,
 66765,
 -42955,
 1479750257,
 66741,
 -1,
 1479814766,
 66740,
 1480022119,
 1474005834,
 -1,
 1480087641,
 1479967394,
 -1,
 1480153147,
 1480006218,
 66710,
 -42950,
 1480097781,
 66688,
 -1,
 1480137290,
 66715,
 1480349758,
 1480114644,
 -1,
 -42947,
 1480287010,
 66697,
 -1,
 1480333898,
 66696,
 1480546368,
 1480301249,
 66713,
 -1,
 1480497857,
 66717,
 1480677443,
 1480489056,
 -1,
 -42942,
 1480613326,
 66693,
 -1,
 1480661783,
 66703,
 1480874053,
 1480606914,
 66711,
 -1,
 1480803522,
 66716,
 1481005128,
 1480801109,
 -1,
 -42937,
 1480941006,
 66698,
 -1,
 1481000971,
 66694,
 -42935,
 1480979386,
 66709,
 -42934,
 1481175635,
 66692,
 -42933,
 1481239505,
 66707,
 -42932,
 1481301179,
 66714,
 -42931,
 1481363580,
 66690,
 -42930,
 1481421908,
 66695,
 -42929,
 1481486896,
 66702,
 -42928,
 1481546330,
 66706,
 -42927,
 1481609048,
 66705,
 -42926,
 1481669786,
 66704,
 -42925,
 1481733983,
 66691,
 -42924,
 1481795581,
 66712,
 -42923,
 1481858510,
 66708,
 -42922,
 1481922722,
 66700,
 -42921,
 1481986632,
 66701,
 -42920,
 1482043778,
 66699,
 -1,
 1482107192,
 66689,
 1482358783,
 1480015597,
 -1,
 1482381405,
 1482280950,
 -1,
 -42916,
 1482354739,
 66722,
 -1,
 1482384927,
 66723,
 1482578016,
 1482342868,
 -1,
 -42913,
 1482520228,
 66726,
 -1,
 1482575844,
 66727,
 1482774627,
 1482510835,
 -1,
 -42910,
 1482728984,
 66724,
 -1,
 1482782186,
 66725,
 -42908,
 1482749744,
 66720,
 -42907,
 1482923801,
 66721,
 -42906,
 1482987246,
 66729,
 -1,
 1483032990,
 66728,
 -1,
 1479946152,
 983191,
 1483299006,
 1473960507,
 -1,
 1483364541,
 1483251210,
 -1,
 1483430056,
 1483315703,
 -1,
 1483495548,
 1483395062,
 -1,
 1483561075,
 1483467425,
 -1,
 1483626609,
 1483512513,
 126210,
 1483735039,
 1483538432,
 -1,
 -42896,
 1483658292,
 126237,
 -1,
 1483695986,
 126228,
 1483931647,
 1483557978,
 126219,
 -1,
 1483803159,
 126246,
 1484019834,
 1483496892,
 -1,
 1484085368,
 1483978670,
 126211,
 1484193791,
 1483997184,
 -1,
 -42889,
 1484117044,
 126238,
 -1,
 1484154738,
 126229,
 1484390399,
 1484026929,
 126220,
 -1,
 1484261911,
 126247,
 1484521471,
 1483950817,
 126218,
 -1,
 1484392983,
 126245,
 1484609673,
 1483456980,
 -1,
 1484675203,
 1484551844,
 126214,
 1484740736,
 1484643468,
 126223,
 -1,
 1484655127,
 126250,
 1484914687,
 1484652544,
 -1,
 -42878,
 1484837940,
 126241,
 -1,
 1484875634,
 126232,
 1485111295,
 1484607460,
 126215,
 1485133958,
 1485036684,
 126224,
 -1,
 1485048343,
 126251,
 1485307903,
 1485045760,
 -1,
 -42872,
 1485231156,
 126242,
 -1,
 1485268850,
 126233,
 1485461656,
 1484542451,
 -1,
 1485527185,
 1485413057,
 -1,
 1485592719,
 1485497254,
 126212,
 1485701119,
 1485504512,
 -1,
 -42866,
 1485624372,
 126239,
 -1,
 1485662066,
 126230,
 1485897727,
 1485553939,
 126221,
 -1,
 1485769239,
 126248,
 1486028799,
 1485465597,
 -1,
 1486051478,
 1485956748,
 126213,
 1486159871,
 1485963264,
 -1,
 -42859,
 1486083124,
 126240,
 -1,
 1486120818,
 126231,
 1486356479,
 1485985847,
 126222,
 -1,
 1486227991,
 126249,
 1486444702,
 1485412078,
 126217,
 1486510235,
 1486412940,
 126226,
 -1,
 1486424599,
 126253,
 1486684159,
 1486422016,
 -1,
 -42851,
 1486607412,
 126244,
 -1,
 1486645106,
 126235,
 1486837924,
 1486375326,
 126216,
 1486903457,
 1486811958,
 126225,
 -1,
 1486817815,
 126252,
 1487077375,
 1486815232,
 -1,
 -42845,
 1487000628,
 126243,
 -1,
 1487038322,
 126234,
 1487273983,
 1486790425,
 126209,
 1487339519,
 1487142912,
 -1,
 -42841,
 1487262772,
 126236,
 -1,
 1487300466,
 126227,
 1487493305,
 1483350174,
 -1,
 1487558831,
 1487458294,
 -1,
 1487624364,
 1487532083,
 126255,
 -1,
 1487538711,
 126266,
 1487755438,
 1487555297,
 126263,
 -1,
 1487669783,
 126267,
 -1,
 1487693343,
 126256,
 1487952051,
 1487520212,
 -1,
 1488017586,
 1487894180,
 126259,
 -1,
 1487930241,
 126265,
 -1,
 1487949796,
 126260,
 1488214199,
 1487884787,
 -1,
 1488279734,
 1488168472,
 126257,
 -1,
 1488192385,
 126264,
 -1,
 1488221674,
 126258,
 -42824,
 1488164590,
 126262,
 -1,
 1488406942,
 126261,
 1488607420,
 1487427417,
 -1,
 -42821,
 1488570633,
 126269,
 -1,
 1488608905,
 126268,
 -1,
 1488554921,
 126254,
 -1,
 1483296042,
 129446,
 1488935127,
 1483256802,
 -1,
 1489000657,
 1488877325,
 -1,
 1489066185,
 1488934719,
 -1,
 1489131718,
 1489018653,
 -1,
 -42813,
 1489094900,
 2933,
 -42812,
 1489154790,
 2930,
 -42811,
 1489198729,
 2931,
 -1,
 1489258975,
 2934,
 1489502207,
 1489097824,
 -1,
 -42808,
 1489422590,
 2935,
 -1,
 1489482533,
 2932,
 1489656013,
 1489037892,
 -1,
 1489721548,
 1489599547,
 2914,
 -1,
 1489665083,
 2915,
 -1,
 1489682541,
 2884,
 1489918160,
 1489601186,
 -1,
 -42801,
 1489890017,
 2929,
 -1,
 1489954221,
 2869,
 -1,
 1489881115,
 2901,
 1490180310,
 1488921277,
 -1,
 1490245845,
 1490109636,
 -1,
 -42796,
 1490182393,
 129505,
 -1,
 1490234838,
 128217,
 -1,
 1490216227,
 129447,
 -1,
 1490095278,
 10183,
 1490573546,
 1488890320,
 -1,
 1490639079,
 1490502850,
 -1,
 1490704614,
 1490588322,
 -1,
 1490770141,
 1490669266,
 -1,
 -42788,
 1490726126,
 10180,
 -1,
 1490759414,
 10179,
 1490966752,
 1490717230,
 -1,
 -42785,
 1490924777,
 128236,
 -1,
 1490978850,
 128237,
 1491163363,
 1490899443,
 -1,
 -42782,
 1491115414,
 128449,
 -1,
 1491168425,
 128194,
 -42780,
 1491109377,
 128275,
 -42779,
 1491296203,
 128080,
 -1,
 1491348950,
 128214,
 -1,
 1490662850,
 983190,
 1491622121,
 1490605394,
 128191,
 -1,
 1491534730,
 128440,
 -1,
 1491559388,
 9934,
 1491818744,
 1490522784,
 -1,
 1491884273,
 1491744455,
 -1,
 -42771,
 1491849667,
 128662,
 -42770,
 1491906423,
 128660,
 -42769,
 1491948648,
 128753,
 -42768,
 1492004685,
 128653,
 -1,
 1492068449,
 128664,
 1492277494,
 1491813570,
 -1,
 1492343029,
 1492189184,
 -1,
 -42764,
 1492271191,
 11819,
 -1,
 1492332419,
 128431,
 -1,
 1492258873,
 129649,
 -42761,
 1492218572,
 129477,
 -1,
 1492520186,
 128283,
 1492736256,
 1491789608,
 -1,
 1492801791,
 1492680129,
 128471,
 1492910079,
 1492757908,
 -1,
 1492932862,
 1492839655,
 -1,
 -42755,
 1492896765,
 11194,
 -1,
 1492918639,
 11195,
 -1,
 1492855990,
 11196,
 -1,
 1492738328,
 129397,
 1493260547,
 1492706583,
 -1,
 -42750,
 1493206153,
 9885,
 -1,
 1493249634,
 128228,
 1493457158,
 1493187142,
 -1,
 -42747,
 1493410594,
 128025,
 -1,
 1493442073,
 128721,
 -42745,
 1493431855,
 129450,
 -42744,
 1493627440,
 128002,
 -42743,
 1493692367,
 129417,
 -42742,
 1493731734,
 128329,
 -42741,
 1493792879,
 128076,
 -42740,
 1493855345,
 128738,
 -42739,
 1493914391,
 127970,
 -42738,
 1493974397,
 127842,
 -1,
 1494036195,
 9215,
 1494244465,
 1438427600,
 -1,
 1494309514,
 1494161994,
 -1,
 1494374858,
 1494245477,
 -1,
 1494440263,
 1494298536,
 -1,
 1494505772,
 1494393107,
 -1,
 1494571292,
 1494454944,
 -1,
 1494636824,
 1494536182,
 -1,
 -42729,
 1494598560,
 92957,
 -1,
 1494638685,
 92971,
 -42727,
 1494580914,
 92960,
 -42726,
 1494776250,
 92962,
 -42725,
 1494823629,
 92968,
 -1,
 1494886430,
 92972,
 1495095584,
 1494506940,
 -1,
 -42722,
 1495044987,
 92969,
 -42721,
 1495105202,
 92965,
 -1,
 1495148574,
 92959,
 1495357731,
 1495019432,
 -1,
 -42718,
 1495294045,
 92967,
 -1,
 1495345182,
 92975,
 -42716,
 1495331895,
 92964,
 -42715,
 1495528044,
 92974,
 -42714,
 1495590533,
 92956,
 -42713,
 1495643628,
 92961,
 -42712,
 1495708256,
 92963,
 -42711,
 1495772689,
 92970,
 -42710,
 1495829504,
 92966,
 -42709,
 1495891634,
 92958,
 -1,
 1495935006,
 92973,
 1496186879,
 1494449553,
 -1,
 1496209715,
 1496109046,
 -1,
 1496275250,
 1496170964,
 -1,
 -42704,
 1496247281,
 93069,
 -42703,
 1496277340,
 93053,
 -1,
 1496324933,
 93062,
 -1,
 1496212558,
 93061,
 1496602935,
 1496152160,
 -1,
 -42699,
 1496575954,
 93070,
 -42698,
 1496621388,
 93058,
 -1,
 1496669679,
 93064,
 1496865082,
 1496576822,
 -1,
 -42695,
 1496795125,
 93054,
 -1,
 1496850208,
 93068,
 1497061693,
 1496835482,
 -1,
 -42692,
 1497034700,
 93071,
 -1,
 1497046816,
 93066,
 1497258304,
 1497005115,
 -1,
 -42689,
 1497199686,
 93055,
 -1,
 1497245760,
 93056,
 1497454915,
 1497193934,
 -1,
 -42686,
 1497427916,
 93059,
 -1,
 1497467212,
 93065,
 -42684,
 1497428784,
 93057,
 -42683,
 1497607445,
 93063,
 -42682,
 1497666000,
 93060,
 -1,
 1497715314,
 93067,
 1497913722,
 1494403035,
 -1,
 1497979219,
 1497838606,
 -1,
 1498044749,
 1497944054,
 -1,
 1498110284,
 1498018604,
 93044,
 -1,
 1498022366,
 93045,
 -1,
 1498073922,
 92997,
 1498306896,
 1497968552,
 -1,
 -42673,
 1498275209,
 93043,
 -1,
 1498308985,
 92985,
 -42671,
 1498263869,
 93046,
 -42670,
 1498454203,
 93047,
 -1,
 1498504776,
 93042,
 1498700125,
 1497952816,
 -1,
 1498765659,
 1498673974,
 -1,
 1498831194,
 1498695729,
 -1,
 -42665,
 1498798069,
 92990,
 -42664,
 1498855855,
 92989,
 -42663,
 1498913234,
 92988,
 -1,
 1498960493,
 92991,
 -1,
 1498784076,
 93028,
 -42660,
 1498703996,
 93034,
 -1,
 1499146333,
 92996,
 1499355495,
 1498671577,
 -1,
 1499421027,
 1499320310,
 -1,
 1499486562,
 1499356604,
 -1,
 -42655,
 1499438571,
 92983,
 -1,
 1499490428,
 92986,
 -1,
 1499448742,
 92984,
 -42652,
 1499382849,
 92992,
 -42651,
 1499699396,
 92994,
 -42650,
 1499760899,
 93027,
 -1,
 1499812564,
 92987,
 1500010859,
 1499320310,
 -1,
 -42647,
 1499984573,
 93037,
 -42646,
 1500013456,
 93030,
 -1,
 1500063774,
 93039,
 1500273008,
 1499957580,
 -1,
 1500338543,
 1500203001,
 -1,
 -42642,
 1500305967,
 93038,
 -1,
 1500368601,
 92993,
 -1,
 1500308632,
 93041,
 1500600691,
 1500222112,
 -1,
 -42638,
 1500568240,
 93035,
 -1,
 1500623465,
 93033,
 1500797302,
 1500536252,
 -1,
 -42635,
 1500748251,
 93032,
 -1,
 1500808017,
 93029,
 -42633,
 1500772355,
 93031,
 -42632,
 1500939945,
 93040,
 -42631,
 1500997942,
 92995,
 -1,
 1501046899,
 93036,
 1501256101,
 1497885167,
 -1,
 1501321610,
 1501174346,
 -1,
 1501387135,
 1501293217,
 -1,
 -42626,
 1501357466,
 92943,
 -1,
 1501374727,
 92942,
 1501583746,
 1501355195,
 -1,
 -42623,
 1501554074,
 92933,
 -1,
 1501571335,
 92932,
 1501780357,
 1501521917,
 -1,
 -42620,
 1501750682,
 92939,
 -1,
 1501767943,
 92938,
 1501976968,
 1501698634,
 -1,
 -42617,
 1501947290,
 92955,
 -1,
 1501964551,
 92954,
 -42615,
 1501947290,
 92951,
 -1,
 1502095623,
 92950,
 1502304656,
 1501289659,
 -1,
 1502370190,
 1502222922,
 -1,
 -42611,
 1502340506,
 92945,
 -1,
 1502357767,
 92944,
 -42609,
 1502340506,
 92935,
 -1,
 1502488839,
 92934,
 1502697878,
 1502255809,
 -1,
 1502763412,
 1502649025,
 -1,
 -42605,
 1502733722,
 92941,
 -1,
 1502750983,
 92940,
 -42603,
 1502733722,
 92947,
 -1,
 1502882055,
 92946,
 1503091100,
 1502636029,
 -1,
 1503156634,
 1503009354,
 -1,
 -42599,
 1503126938,
 92949,
 -1,
 1503144199,
 92948,
 -42597,
 1503126938,
 92931,
 -1,
 1503275271,
 92930,
 1503484322,
 1503020226,
 -1,
 1503549856,
 1503413442,
 -1,
 -42593,
 1503520154,
 92929,
 -1,
 1503537415,
 92928,
 -42591,
 1503520154,
 92937,
 -1,
 1503668487,
 92936,
 1503920127,
 1503455905,
 -1,
 -42588,
 1503847834,
 92953,
 -1,
 1503865095,
 92952,
 1504074163,
 1501183725,
 -1,
 1504139689,
 1504038902,
 -1,
 -42584,
 1504112691,
 93010,
 -1,
 1504142879,
 93011,
 1504336300,
 1504100820,
 -1,
 -42581,
 1504278180,
 93014,
 -1,
 1504333796,
 93015,
 1504532911,
 1504268787,
 -1,
 -42578,
 1504486936,
 93012,
 -1,
 1504540138,
 93013,
 -42576,
 1504507696,
 93008,
 -42575,
 1504681753,
 93009,
 -42574,
 1504745198,
 93017,
 -1,
 1504790942,
 93016,
 1504991679,
 1504025079,
 -1,
 1505057211,
 1504956406,
 -1,
 1505122746,
 1504987873,
 -1,
 1505188281,
 1505034240,
 -1,
 -42568,
 1505154119,
 93021,
 -1,
 1505176582,
 93024,
 -1,
 1505149396,
 93019,
 -1,
 1505082646,
 93025,
 1505515966,
 1504995186,
 -1,
 -42563,
 1505477076,
 93020,
 -1,
 1505494229,
 93023,
 -1,
 1505464198,
 93022,
 1505820671,
 1504938872,
 -1,
 1505843651,
 1505742838,
 -1,
 -42558,
 1505811896,
 92976,
 -1,
 1505830993,
 92982,
 1506040262,
 1505804756,
 -1,
 -42555,
 1506008453,
 92980,
 -1,
 1506056897,
 92977,
 1506236873,
 1505982560,
 -1,
 -42552,
 1506173025,
 92979,
 -1,
 1506233924,
 92978,
 -1,
 1506174071,
 92981,
 1506499091,
 1494342848,
 -1,
 1506564606,
 1506442299,
 -1,
 1506630137,
 1506496272,
 -1,
 1506695641,
 1506562547,
 -1,
 1506761176,
 1506635130,
 -1,
 1506826705,
 1506710176,
 72416,
 -1,
 1506760787,
 72419,
 -42542,
 1506800438,
 72420,
 -42541,
 1506929313,
 72418,
 -42540,
 1506988022,
 72414,
 -42539,
 1507043792,
 72412,
 -42538,
 1507101004,
 72415,
 -42537,
 1507163195,
 72417,
 -1,
 1507227744,
 72413,
 -1,
 1506679370,
 72403,
 1507482075,
 1506663611,
 72409,
 -1,
 1507400266,
 72410,
 1507613150,
 1507446774,
 -1,
 -42531,
 1507548622,
 72399,
 -1,
 1507596874,
 72398,
 1507809761,
 1507568080,
 -1,
 -42528,
 1507745230,
 72401,
 -1,
 1507793482,
 72384,
 1508006372,
 1507758752,
 -1,
 -42525,
 1507940514,
 72391,
 -1,
 1507990090,
 72400,
 1508202983,
 1507948640,
 -1,
 -42522,
 1508138446,
 72394,
 -1,
 1508186698,
 72385,
 1508399593,
 1508141053,
 72407,
 -1,
 1508317770,
 72411,
 1508530668,
 1508323240,
 -1,
 -42517,
 1508466126,
 72404,
 -1,
 1508514378,
 72397,
 -42515,
 1508505203,
 72389,
 -42514,
 1508697517,
 72390,
 -42513,
 1508754089,
 72395,
 -42512,
 1508815956,
 72402,
 -42511,
 1508874945,
 72408,
 -42510,
 1508936098,
 72387,
 -42509,
 1508998277,
 72386,
 -42508,
 1509055950,
 72392,
 -42507,
 1509120162,
 72393,
 -42506,
 1509180610,
 72406,
 -42505,
 1509243904,
 72388,
 -42504,
 1509304632,
 72396,
 -1,
 1509366346,
 72405,
 1509621759,
 1506584880,
 72436,
 1509687295,
 1509490688,
 -1,
 1509710333,
 1509590582,
 72435,
 -1,
 1509622505,
 72438,
 -1,
 1509643155,
 72439,
 1509906950,
 1506526047,
 -1,
 1509972484,
 1509873469,
 72428,
 1510080511,
 1509883904,
 -1,
 1510103555,
 1509983798,
 72427,
 -1,
 1510015721,
 72429,
 -1,
 1510036371,
 72430,
 1510342655,
 1509907470,
 72423,
 -1,
 1510212329,
 72426,
 1510431243,
 1509867121,
 72422,
 1510539263,
 1510342656,
 -1,
 1510562314,
 1510442550,
 72421,
 -1,
 1510474473,
 72424,
 -1,
 1510495123,
 72425,
 1510758927,
 1510379077,
 72431,
 1510866943,
 1510670336,
 -1,
 -42482,
 1510770255,
 72433,
 -1,
 1510822803,
 72434,
 1511063551,
 1510693902,
 72437,
 1511129087,
 1510932480,
 -1,
 -42478,
 1511056870,
 72432,
 -1,
 1511084947,
 72440,
 1511283265,
 1506456546,
 -1,
 1511348787,
 1511214118,
 -1,
 1511414320,
 1511292518,
 -1,
 -42473,
 1511388741,
 127273,
 -42472,
 1511453494,
 127272,
 -42471,
 1511518768,
 127271,
 -42470,
 1511582369,
 127270,
 -42469,
 1511646618,
 127269,
 -42468,
 1511709883,
 127268,
 -42467,
 1511772150,
 127267,
 -42466,
 1511834068,
 127266,
 -42465,
 1511896034,
 127265,
 -42464,
 1511961102,
 127264,
 -42463,
 1512024528,
 127263,
 -42462,
 1512086209,
 127262,
 -42461,
 1512149664,
 127261,
 -42460,
 1512212812,
 127260,
 -42459,
 1512275003,
 127259,
 -42458,
 1512339552,
 127258,
 -42457,
 1512404801,
 127257,
 -42456,
 1512466429,
 127256,
 -42455,
 1512529340,
 127255,
 -42454,
 1512593491,
 127254,
 -42453,
 1512657395,
 127253,
 -42452,
 1512719554,
 127252,
 -42451,
 1512782677,
 127251,
 -42450,
 1512845224,
 127250,
 -42449,
 1512909063,
 127249,
 -1,
 1512970826,
 127248,
 1513226239,
 1511357336,
 -1,
 -42446,
 1513125813,
 12829,
 -1,
 1513161597,
 12830,
 1513380411,
 1511313398,
 -1,
 1513445945,
 1513318569,
 -1,
 -42442,
 1513414995,
 983149,
 -42441,
 1513444926,
 983145,
 -42440,
 1513505407,
 983146,
 -1,
 1513564514,
 983148,
 -42438,
 1513419631,
 127881,
 -1,
 1513723275,
 12880,
 1513904704,
 1513298506,
 -1,
 1513970239,
 1513839761,
 -1,
 -42434,
 1513940123,
 11853,
 -1,
 1513989255,
 11791,
 -1,
 1513894866,
 129666,
 -1,
 1513865210,
 129436,
 1514297971,
 1511226427,
 -1,
 1514363506,
 1514244428,
 -1,
 1514429038,
 1514337823,
 -1,
 1514494562,
 1514372924,
 -1,
 1514560097,
 1514461803,
 -1,
 1514625611,
 1514521044,
 -1,
 1514691146,
 1514543690,
 -1,
 -42423,
 1514638700,
 67695,
 -1,
 1514683977,
 67698,
 -1,
 1514627923,
 67701,
 1514953294,
 1514590198,
 -1,
 -42419,
 1514884810,
 67688,
 -1,
 1514940581,
 67702,
 1515149904,
 1514889343,
 67684,
 -1,
 1515115341,
 67687,
 1515280979,
 1515067978,
 -1,
 -42414,
 1515255037,
 67696,
 -1,
 1515291243,
 67680,
 -42412,
 1515255555,
 67686,
 -42411,
 1515451838,
 67689,
 -42410,
 1515514833,
 67685,
 -42409,
 1515567274,
 67700,
 -42408,
 1515631231,
 67699,
 -42407,
 1515695077,
 67697,
 -42406,
 1515756083,
 67694,
 -42405,
 1515818373,
 67692,
 -42404,
 1515879810,
 67691,
 -42403,
 1515944252,
 67690,
 -42402,
 1516002224,
 67682,
 -42401,
 1516065793,
 67693,
 -42400,
 1516125266,
 67683,
 -1,
 1516186446,
 67681,
 -1,
 1514493965,
 67703,
 1516460653,
 1514445303,
 -1,
 1516526185,
 1516425206,
 -1,
 1516591719,
 1516497569,
 -1,
 -42394,
 1516542657,
 67706,
 -1,
 1516588122,
 67711,
 -42392,
 1516529183,
 67707,
 -1,
 1516718817,
 67710,
 1516919404,
 1516458483,
 -1,
 -42389,
 1516873240,
 67708,
 -1,
 1516926442,
 67709,
 -1,
 1516871449,
 67705,
 -1,
 1516420155,
 67704,
 1517247089,
 1514340352,
 -1,
 -42384,
 1517213801,
 127796,
 -1,
 1517235835,
 11801,
 -1,
 1517208199,
 129330,
 -1,
 1514307115,
 9908,
 1517574781,
 1514231891,
 -1,
 1517640316,
 1517503682,
 128463,
 1517705850,
 1517551616,
 -1,
 1517771385,
 1517678166,
 -1,
 -42376,
 1517741066,
 128195,
 -1,
 1517777822,
 128479,
 -1,
 1517703779,
 128196,
 -42373,
 1517666772,
 128464,
 -1,
 1517990882,
 128223,
 -1,
 1517591506,
 128724,
 1518230146,
 1517538331,
 -1,
 1518295681,
 1518159042,
 -1,
 -42368,
 1518245468,
 128755,
 -1,
 1518287809,
 11261,
 -1,
 1518251936,
 128706,
 1518557829,
 1518178976,
 -1,
 -42364,
 1518484487,
 128060,
 -1,
 1518546967,
 129374,
 1518754439,
 1518484309,
 983121,
 -1,
 1518681877,
 983120,
 -42360,
 1518725806,
 128062,
 -42359,
 1518841043,
 128206,
 -1,
 1518875981,
 128230,
 1519082301,
 1494244796,
 -1,
 1519147798,
 1519000138,
 -1,
 1519213270,
 1519082787,
 -1,
 1519278794,
 1519157922,
 -1,
 1519344279,
 1519243254,
 -1,
 1519409810,
 1519308790,
 -1,
 -42351,
 1519345102,
 43114,
 -1,
 1519393354,
 43113,
 1519606421,
 1519370708,
 -1,
 -42348,
 1519541710,
 43089,
 -1,
 1519589962,
 43088,
 -42346,
 1519541710,
 43081,
 -1,
 1519721034,
 43080,
 1519934108,
 1519293088,
 -1,
 -42343,
 1519907770,
 43079,
 -42342,
 1519948522,
 43116,
 -42341,
 1519999138,
 43075,
 -1,
 1520048714,
 43083,
 1520261792,
 1519894996,
 -1,
 -42338,
 1520208531,
 43094,
 -42337,
 1520262606,
 43098,
 -1,
 1520310858,
 43099,
 1520523940,
 1520188245,
 -1,
 -42334,
 1520498291,
 43090,
 -42333,
 1520516096,
 43115,
 -1,
 1520573002,
 43082,
 1520786088,
 1520447400,
 -1,
 1520851623,
 1520704074,
 43076,
 -1,
 1520800895,
 43123,
 -1,
 1520786894,
 43077,
 1521048235,
 1520704074,
 43101,
 -42326,
 1521011596,
 43120,
 -1,
 1521060022,
 43117,
 1521244846,
 1521022533,
 -1,
 -42323,
 1521180110,
 43092,
 -1,
 1521228362,
 43093,
 1521441457,
 1521215872,
 -1,
 -42320,
 1521386100,
 43118,
 -1,
 1521433472,
 43119,
 1521638068,
 1521396176,
 -1,
 -42317,
 1521573326,
 43085,
 -1,
 1521621578,
 43084,
 1521834679,
 1521580128,
 -1,
 -42314,
 1521769934,
 43073,
 -1,
 1521818186,
 43072,
 1522031290,
 1521768531,
 -1,
 -42311,
 1521965218,
 43109,
 -1,
 1522014794,
 43074,
 1522227900,
 1521960130,
 43104,
 -1,
 1522156738,
 43110,
 -42307,
 1522201530,
 43095,
 -42306,
 1522332243,
 43107,
 -42305,
 1522395873,
 43091,
 -42304,
 1522457787,
 43103,
 -42303,
 1522512980,
 43096,
 -42302,
 1522577965,
 43106,
 -42301,
 1522637505,
 43105,
 -42300,
 1522698658,
 43087,
 -42299,
 1522760837,
 43097,
 -42298,
 1522825055,
 43078,
 -42297,
 1522886653,
 43102,
 -42296,
 1522949582,
 43100,
 -42295,
 1523012168,
 43108,
 -1,
 1523067192,
 43086,
 1523276498,
 1519239636,
 -1,
 1523342033,
 1523244219,
 -1,
 1523407568,
 1523264635,
 -1,
 -42290,
 1523381178,
 43112,
 -42289,
 1523444449,
 43111,
 -1,
 1523496020,
 43121,
 -1,
 1523363035,
 43122,
 -1,
 1523281969,
 43124,
 1523800789,
 1523223399,
 -1,
 -42284,
 1523762608,
 43126,
 -1,
 1523794485,
 43127,
 -1,
 1523728853,
 43125,
 1524105215,
 1519154432,
 -1,
 1524128482,
 1523986344,
 -1,
 1524194012,
 1524079297,
 -1,
 1524259547,
 1524141064,
 66020,
 -1,
 1524199502,
 66045,
 -1,
 1524205848,
 66022,
 1524456160,
 1524111946,
 -1,
 -42274,
 1524420598,
 66028,
 -42273,
 1524482137,
 66018,
 -1,
 1524543776,
 66003,
 -42271,
 1524402435,
 66012,
 -1,
 1524654887,
 66004,
 1524849386,
 1524089300,
 -1,
 1524914918,
 1524785750,
 -1,
 -42267,
 1524869584,
 66024,
 -1,
 1524910650,
 66011,
 -42265,
 1524881465,
 66042,
 -42264,
 1525058213,
 66043,
 -42263,
 1525122202,
 66021,
 -1,
 1525164197,
 66015,
 1525373681,
 1524771079,
 -1,
 1525439214,
 1525324481,
 -1,
 -42259,
 1525410465,
 66010,
 -1,
 1525456466,
 66017,
 1525635824,
 1525368809,
 66033,
 -1,
 1525572580,
 66023,
 -1,
 1525604296,
 66027,
 1525832439,
 1525328336,
 -1,
 1525897973,
 1525775419,
 -1,
 -42252,
 1525866549,
 66001,
 -1,
 1525883572,
 66034,
 -42250,
 1525827488,
 66000,
 -1,
 1526015043,
 66036,
 1526225659,
 1525796854,
 -1,
 -42247,
 1526194490,
 66032,
 -42246,
 1526229285,
 66008,
 -1,
 1526278120,
 66002,
 1526487807,
 1526160828,
 -1,
 -42243,
 1526440965,
 66025,
 -42242,
 1526491613,
 66026,
 -1,
 1526549124,
 66006,
 1526749954,
 1526459041,
 -1,
 -42239,
 1526701573,
 66005,
 -1,
 1526737052,
 66044,
 1526946565,
 1526707170,
 -1,
 -42236,
 1526899855,
 66037,
 -1,
 1526931672,
 66029,
 1527143176,
 1526892962,
 -1,
 -42233,
 1527110263,
 66014,
 -1,
 1527157535,
 66013,
 1527339787,
 1527087953,
 -1,
 -42230,
 1527286084,
 66038,
 -1,
 1527331669,
 66016,
 1527536398,
 1527273555,
 -1,
 -42227,
 1527494070,
 66041,
 -1,
 1527523413,
 66007,
 1527733009,
 1527463827,
 -1,
 -42224,
 1527703180,
 66031,
 -1,
 1527743757,
 66019,
 -42222,
 1527703806,
 66035,
 -42221,
 1527884172,
 66039,
 -42220,
 1527928223,
 66040,
 -42219,
 1527989785,
 66030,
 -1,
 1528047040,
 66009,
 1528299519,
 1519098561,
 -1,
 1528322876,
 1528187832,
 -1,
 1528388402,
 1528267426,
 -1,
 1528453917,
 1528349140,
 -1,
 -42213,
 1528390483,
 67860,
 -42212,
 1528449731,
 67854,
 -1,
 1528503501,
 67857,
 1528716064,
 1528418294,
 -1,
 -42209,
 1528647321,
 67848,
 -1,
 1528703006,
 67861,
 1528912674,
 1528651903,
 67844,
 -1,
 1528877046,
 67847,
 1529043749,
 1528830538,
 -1,
 -42204,
 1528988438,
 67840,
 -1,
 1529048379,
 67855,
 -42202,
 1529017978,
 67846,
 -42201,
 1529214381,
 67849,
 -42200,
 1529277367,
 67845,
 -42199,
 1529331660,
 67859,
 -42198,
 1529393782,
 67858,
 -42197,
 1529457637,
 67856,
 -42196,
 1529518643,
 67853,
 -42195,
 1529580933,
 67852,
 -42194,
 1529642359,
 67851,
 -42193,
 1529706752,
 67850,
 -42192,
 1529764108,
 67842,
 -42191,
 1529822584,
 67843,
 -1,
 1529883454,
 67841,
 1530092347,
 1528338935,
 -1,
 1530157881,
 1530056694,
 -1,
 1530223415,
 1530129057,
 -1,
 -42186,
 1530174145,
 67866,
 -1,
 1530219610,
 67864,
 -42184,
 1530160671,
 67867,
 -1,
 1530350305,
 67863,
 1530593279,
 1530109721,
 67862,
 -1,
 1530463105,
 67865,
 -1,
 1530065333,
 67871,
 -1,
 1528269111,
 11227,
 1530813364,
 1519025211,
 -1,
 1530878890,
 1530731082,
 -1,
 1530944423,
 1530852616,
 -1,
 1531009894,
 1530908662,
 -1,
 1531075415,
 1530970469,
 -1,
 1531140941,
 1530991099,
 127201,
 -42172,
 1531058584,
 127219,
 -42171,
 1531123943,
 127218,
 -42170,
 1531189255,
 127217,
 -42169,
 1531254583,
 127216,
 -42168,
 1531319874,
 127215,
 -42167,
 1531385198,
 127214,
 -42166,
 1531450448,
 127213,
 -42165,
 1531515691,
 127212,
 -42164,
 1531580923,
 127211,
 -1,
 1531646187,
 127210,
 1531861840,
 1531056939,
 127202,
 -42161,
 1531777531,
 127221,
 -1,
 1531842795,
 127220,
 -42159,
 1531779480,
 127209,
 -42158,
 1531975911,
 127208,
 -42157,
 1532041223,
 127207,
 -42156,
 1532106551,
 127206,
 -42155,
 1532171842,
 127205,
 -42154,
 1532237166,
 127204,
 -1,
 1532302416,
 127203,
 1532517212,
 1531048155,
 -1,
 -42151,
 1532480333,
 127138,
 -42150,
 1532518673,
 127154,
 -42149,
 1532575418,
 127170,
 -1,
 1532638780,
 127186,
 1532844897,
 1532454609,
 -1,
 -42146,
 1532808013,
 127139,
 -42145,
 1532846353,
 127155,
 -42144,
 1532903098,
 127171,
 -1,
 1532966460,
 127187,
 1533214719,
 1532775178,
 -1,
 -42141,
 1533135693,
 127146,
 -42140,
 1533174033,
 127162,
 -42139,
 1533230778,
 127178,
 -1,
 1533294140,
 127194,
 1533500275,
 1530941939,
 -1,
 1533565806,
 1533450945,
 -1,
 1533631341,
 1533535156,
 -1,
 -42134,
 1533594445,
 127140,
 -42133,
 1533632785,
 127156,
 -42132,
 1533689530,
 127172,
 -1,
 1533752892,
 127188,
 -1,
 1533582652,
 127200,
 1534066687,
 1533507127,
 -1,
 -42128,
 1533987661,
 127141,
 -42127,
 1534026001,
 127157,
 -42126,
 1534082746,
 127173,
 -1,
 1534146108,
 127189,
 1534352254,
 1533460948,
 -1,
 1534417785,
 1534293684,
 -1,
 -42122,
 1534380877,
 127142,
 -42121,
 1534419217,
 127158,
 -42120,
 1534475962,
 127174,
 -1,
 1534539324,
 127190,
 1534787583,
 1534349325,
 -1,
 -42117,
 1534708557,
 127143,
 -42116,
 1534746897,
 127159,
 -42115,
 1534803642,
 127175,
 -1,
 1534867004,
 127191,
 1535073161,
 1534294112,
 -1,
 1535138692,
 1535022794,
 -1,
 -42111,
 1535101773,
 127148,
 -42110,
 1535140113,
 127164,
 -42109,
 1535196858,
 127180,
 -1,
 1535260220,
 127196,
 1535508479,
 1535078278,
 -1,
 -42106,
 1535429453,
 127150,
 -42105,
 1535467793,
 127166,
 -42104,
 1535524538,
 127182,
 -1,
 1535587900,
 127198,
 1535794062,
 1535030097,
 -1,
 -42101,
 1535757133,
 127149,
 -42100,
 1535795473,
 127165,
 -42099,
 1535852218,
 127181,
 -1,
 1535915580,
 127197,
 1536121747,
 1535743742,
 -1,
 -42096,
 1536084813,
 127145,
 -42095,
 1536123153,
 127161,
 -42094,
 1536179898,
 127177,
 -1,
 1536243260,
 127193,
 1536449432,
 1536063330,
 -1,
 -42091,
 1536412493,
 127147,
 -42090,
 1536450833,
 127163,
 -42089,
 1536507578,
 127179,
 -1,
 1536570940,
 127195,
 1536777117,
 1536379327,
 -1,
 -42086,
 1536740173,
 127144,
 -42085,
 1536778513,
 127160,
 -42084,
 1536835258,
 127176,
 -1,
 1536898620,
 127192,
 1537104802,
 1536695301,
 -1,
 -42081,
 1537067853,
 127137,
 -42080,
 1537106193,
 127153,
 -42079,
 1537162938,
 127169,
 -1,
 1537226300,
 127185,
 1537432485,
 1537026311,
 -1,
 -42076,
 1537375427,
 127183,
 -1,
 1537416209,
 127136,
 -42074,
 1537404251,
 127199,
 -1,
 1537587071,
 127167,
 1537802239,
 1530867624,
 -1,
 -42071,
 1537688907,
 128720,
 -1,
 1537746126,
 129703,
 1537956787,
 1530846395,
 983150,
 1538022322,
 1537922807,
 -1,
 1538087855,
 1537986550,
 -1,
 -42066,
 1538060339,
 11219,
 -1,
 1538090527,
 11220,
 1538326527,
 1538019827,
 -1,
 -42063,
 1538237976,
 11221,
 -1,
 1538291178,
 11222,
 -1,
 1537971799,
 129696,
 -1,
 1537882965,
 983147,
 1538612185,
 1530774286,
 -1,
 1538677706,
 1538556578,
 -1,
 1538743227,
 1538638292,
 -1,
 1538808762,
 1538660938,
 -1,
 -42055,
 1538755948,
 68493,
 -1,
 1538801225,
 68495,
 -1,
 1538745171,
 68496,
 1539070909,
 1538678911,
 68484,
 -1,
 1539035981,
 68487,
 -42050,
 1539045123,
 68486,
 -42049,
 1539175870,
 68488,
 -42048,
 1539238879,
 68485,
 -42047,
 1539297722,
 68497,
 -42046,
 1539353573,
 68494,
 -42045,
 1539414579,
 68492,
 -42044,
 1539476873,
 68491,
 -42043,
 1539538306,
 68490,
 -42042,
 1539602748,
 68489,
 -42041,
 1539660720,
 68482,
 -42040,
 1539718226,
 68483,
 -42039,
 1539779406,
 68481,
 -1,
 1539841993,
 68480,
 1540053972,
 1538628087,
 -1,
 1540119505,
 1540018166,
 -1,
 1540185039,
 1540090529,
 -1,
 -42034,
 1540135617,
 68522,
 -1,
 1540181082,
 68526,
 -42032,
 1540122143,
 68523,
 -1,
 1540311777,
 68525,
 1540512723,
 1540071193,
 68521,
 -1,
 1540424577,
 68527,
 -1,
 1540445810,
 68524,
 1540709335,
 1539987134,
 -1,
 -42026,
 1540636664,
 68508,
 -1,
 1540700480,
 68507,
 -42024,
 1540676435,
 68506,
 -1,
 1540867106,
 68505,
 1541037057,
 1538540738,
 -1,
 1541102579,
 1540994018,
 -1,
 1541168111,
 1541063124,
 -1,
 1541233646,
 1541119614,
 -1,
 1541299181,
 1541144576,
 -1,
 1541364709,
 1541271120,
 -1,
 1541430242,
 1541286151,
 -1,
 -42015,
 1541375532,
 128113,
 -1,
 1541414938,
 9977,
 -42013,
 1541386213,
 128590,
 -42012,
 1541562596,
 129493,
 -1,
 1541625276,
 128591,
 1541823464,
 1541303614,
 -1,
 -42009,
 1541786913,
 129494,
 -1,
 1541834479,
 129496,
 -42007,
 1541780780,
 128588,
 -42006,
 1541953486,
 128589,
 -42005,
 1542012839,
 129336,
 -42004,
 1542075821,
 129495,
 -1,
 1542139472,
 128583,
 -1,
 1541218151,
 128187,
 -1,
 1541165160,
 128547,
 -42000,
 1541123187,
 10178,
 -41999,
 1542425391,
 9854,
 -41998,
 1542477335,
 127917,
 -1,
 1542523230,
 8524,
 1542740984,
 1541051040,
 -1,
 -41995,
 1542705360,
 9956,
 -41994,
 1542768842,
 128532,
 -41993,
 1542806857,
 128039,
 -1,
 1542850240,
 128390,
 1543068670,
 1542658634,
 -1,
 1543134204,
 1542991784,
 -1,
 -41989,
 1543084958,
 129434,
 -1,
 1543134652,
 127825,
 -41987,
 1543091170,
 127824,
 -1,
 1543281237,
 129372,
 -41985,
 1543035026,
 129515,
 -41984,
 1543414443,
 129730,
 -1,
 1543454233,
 128694,
 1543658540,
 1540994018,
 -1,
 1543724056,
 1543587010,
 -1,
 1543789590,
 1543685234,
 -1,
 1543855113,
 1543748269,
 -1,
 1543920648,
 1543826791,
 -1,
 -41977,
 1543862752,
 65048,
 -1,
 1543910785,
 983256,
 -1,
 1543883723,
 65096,
 1544182796,
 1543798821,
 -1,
 -41973,
 1544154492,
 65047,
 -1,
 1544211403,
 65095,
 1544379407,
 1544120835,
 -1,
 -41970,
 1544312898,
 65042,
 -1,
 1544369871,
 65041,
 1544576018,
 1544304218,
 -1,
 -41967,
 1544523824,
 65040,
 -1,
 1544586792,
 65043,
 -41965,
 1544537183,
 65044,
 -41964,
 1544729479,
 65046,
 -41963,
 1544774911,
 65049,
 -1,
 1544835292,
 65045,
 -41961,
 1543756982,
 129384,
 -1,
 1544969265,
 129328,
 1545165863,
 1543661565,
 -1,
 1545231394,
 1545135533,
 -1,
 1545296929,
 1545196021,
 -1,
 1545362462,
 1545211730,
 -1,
 -41955,
 1545278251,
 983166,
 -1,
 1545343483,
 983163,
 1545601023,
 1545273344,
 -1,
 -41952,
 1545526217,
 983165,
 -1,
 1545576217,
 983162,
 -1,
 1545222977,
 983192,
 1545863167,
 1545179808,
 -1,
 1545886757,
 1545786063,
 128424,
 -1,
 1545798538,
 128438,
 1546059775,
 1545810338,
 129332,
 -1,
 1545980955,
 128120,
 1546148907,
 1545116353,
 -1,
 -41943,
 1546110181,
 11224,
 -41942,
 1546150509,
 128711,
 -1,
 1546202137,
 129455,
 -1,
 1546070248,
 128255,
 1546476623,
 1543609025,
 -1,
 1546542132,
 1546447985,
 -1,
 1546607665,
 1546502612,
 -1,
 -41936,
 1546581343,
 9211,
 -1,
 1546616803,
 9214,
 1546846207,
 1546559102,
 -1,
 -41933,
 1546719277,
 9212,
 -1,
 1546783189,
 9213,
 1547000890,
 1546509499,
 -1,
 1547066424,
 1546966627,
 -1,
 -41929,
 1546998347,
 128545,
 -1,
 1547055407,
 128574,
 -41927,
 1547012314,
 127831,
 -1,
 1547186758,
 128093,
 1547394112,
 1546964982,
 -1,
 1547459646,
 1547311690,
 -1,
 -41923,
 1547425517,
 129364,
 -1,
 1547447516,
 128688,
 -41921,
 1547424314,
 129716,
 -1,
 1547568470,
 127858,
 1547787333,
 1547354580,
 -1,
 1547852868,
 1547751414,
 -1,
 -41917,
 1547775582,
 128238,
 -1,
 1547837299,
 128239,
 -1,
 1547782548,
 11239,
 1548115017,
 1547731814,
 -1,
 1548180552,
 1548038394,
 128659,
 -1,
 1548141157,
 128680,
 -1,
 1548131399,
 128110,
 1548377164,
 1548069328,
 -1,
 -41909,
 1548302436,
 127871,
 -1,
 1548354140,
 8297,
 -41907,
 1548337361,
 128254,
 -41906,
 1548524556,
 128041,
 -1,
 1548563846,
 128425,
 1548770403,
 1546414077,
 -1,
 1548835928,
 1548718752,
 -1,
 1548901460,
 1548764354,
 -1,
 -41901,
 1548821539,
 127821,
 -1,
 1548878416,
 127885,
 1549098071,
 1548825158,
 -1,
 -41898,
 1549037339,
 129295,
 -1,
 1549092667,
 129292,
 -1,
 1549018909,
 129669,
 1549360220,
 1548769363,
 128022,
 1549467647,
 1549271040,
 -1,
 -41893,
 1549375585,
 128061,
 -1,
 1549423179,
 128055,
 1549622367,
 1549302843,
 -1,
 -41890,
 1549564987,
 128138,
 -1,
 1549616450,
 128169,
 1549818977,
 1549546784,
 9935,
 -1,
 1549787620,
 128763,
 -41886,
 1549782424,
 128299,
 -1,
 1549878466,
 129383,
 1550081133,
 1548737723,
 -1,
 1550146663,
 1550037986,
 -1,
 -41882,
 1550107644,
 128091,
 -1,
 1550167544,
 128156,
 -41880,
 1550110742,
 128686,
 -41879,
 1550305082,
 128204,
 -41878,
 1550357425,
 11854,
 -41877,
 1550396662,
 128226,
 -41876,
 1550455595,
 983167,
 -1,
 1550520827,
 983164,
 1550736496,
 1550007125,
 -1,
 -41873,
 1550673917,
 983233,
 -1,
 1550733811,
 983224,
 -1,
 1550682444,
 983193,
 1550999384,
 1494170453,
 -1,
 1551064472,
 1550949057,
 -1,
 1551129834,
 1551011786,
 -1,
 1551195311,
 1551099782,
 -1,
 1551260846,
 1551109972,
 -1,
 1551326334,
 1551177711,
 -1,
 -41864,
 1551243063,
 127123,
 -41863,
 1551308354,
 127122,
 -41862,
 1551373678,
 127121,
 -41861,
 1551438928,
 127120,
 -41860,
 1551504171,
 127119,
 -41859,
 1551569403,
 127118,
 -1,
 1551634667,
 127117,
 1551850630,
 1551243020,
 -1,
 -41856,
 1551767351,
 127116,
 -41855,
 1551832642,
 127115,
 -41854,
 1551897966,
 127114,
 -41853,
 1551963216,
 127113,
 -41852,
 1552028459,
 127112,
 -41851,
 1552093691,
 127111,
 -1,
 1552158955,
 127110,
 1552374926,
 1551767075,
 -1,
 -41848,
 1552291639,
 127109,
 -41847,
 1552356930,
 127108,
 -41846,
 1552422254,
 127107,
 -41845,
 1552487504,
 127106,
 -41844,
 1552552747,
 127105,
 -41843,
 1552617979,
 127104,
 -1,
 1552683243,
 127103,
 1552899222,
 1552291137,
 -1,
 -41840,
 1552815927,
 127102,
 -41839,
 1552881218,
 127101,
 -41838,
 1552946542,
 127100,
 -41837,
 1553011792,
 127099,
 -41836,
 1553077035,
 127098,
 -41835,
 1553142267,
 127097,
 -1,
 1553207531,
 127096,
 1553423518,
 1552815126,
 -1,
 -41832,
 1553340215,
 127095,
 -41831,
 1553405506,
 127094,
 -41830,
 1553470830,
 127093,
 -41829,
 1553536080,
 127092,
 -41828,
 1553601323,
 127091,
 -41827,
 1553666555,
 127090,
 -1,
 1553731819,
 127089,
 1553947814,
 1553339123,
 -1,
 -41824,
 1553864503,
 127088,
 -41823,
 1553929794,
 127087,
 -41822,
 1553995118,
 127086,
 -41821,
 1554060368,
 127085,
 -41820,
 1554125611,
 127084,
 -41819,
 1554190843,
 127083,
 -1,
 1554256107,
 127082,
 1554513919,
 1553863118,
 -1,
 -41816,
 1554388791,
 127081,
 -41815,
 1554454082,
 127080,
 -41814,
 1554519406,
 127079,
 -41813,
 1554584656,
 127078,
 -41812,
 1554649899,
 127077,
 -41811,
 1554715131,
 127076,
 -1,
 1554780395,
 127075,
 -1,
 1551171903,
 127074,
 1555103743,
 1551131877,
 -1,
 1555127529,
 1554976596,
 -1,
 1555193017,
 1555044335,
 -1,
 -41805,
 1555109687,
 127073,
 -41804,
 1555174978,
 127072,
 -41803,
 1555240302,
 127071,
 -41802,
 1555305552,
 127070,
 -41801,
 1555370795,
 127069,
 -41800,
 1555436027,
 127068,
 -1,
 1555501291,
 127067,
 1555717313,
 1555109644,
 -1,
 -41797,
 1555633975,
 127066,
 -41796,
 1555699266,
 127065,
 -41795,
 1555764590,
 127064,
 -41794,
 1555829840,
 127063,
 -41793,
 1555895083,
 127062,
 -41792,
 1555960315,
 127061,
 -1,
 1556025579,
 127060,
 1556241609,
 1555633699,
 -1,
 -41789,
 1556158263,
 127059,
 -41788,
 1556223554,
 127058,
 -41787,
 1556288878,
 127057,
 -41786,
 1556354128,
 127056,
 -41785,
 1556419371,
 127055,
 -41784,
 1556484603,
 127054,
 -1,
 1556549867,
 127053,
 1556765905,
 1556157761,
 -1,
 -41781,
 1556682551,
 127052,
 -41780,
 1556747842,
 127051,
 -41779,
 1556813166,
 127050,
 -41778,
 1556878416,
 127049,
 -41777,
 1556943659,
 127048,
 -41776,
 1557008891,
 127047,
 -1,
 1557074155,
 127046,
 1557290201,
 1556681750,
 -1,
 -41773,
 1557206839,
 127045,
 -41772,
 1557272130,
 127044,
 -41771,
 1557337454,
 127043,
 -41770,
 1557402704,
 127042,
 -41769,
 1557467947,
 127041,
 -41768,
 1557533179,
 127040,
 -1,
 1557598443,
 127039,
 1557814497,
 1557205747,
 -1,
 -41765,
 1557731127,
 127038,
 -41764,
 1557796418,
 127037,
 -41763,
 1557861742,
 127036,
 -41762,
 1557926992,
 127035,
 -41761,
 1557992235,
 127034,
 -41760,
 1558057467,
 127033,
 -1,
 1558122731,
 127032,
 1558380543,
 1557729742,
 -1,
 -41757,
 1558255415,
 127031,
 -41756,
 1558320706,
 127030,
 -41755,
 1558386030,
 127029,
 -41754,
 1558451280,
 127028,
 -41753,
 1558516523,
 127027,
 -41752,
 1558581755,
 127026,
 -1,
 1558647019,
 127025,
 -1,
 1555038527,
 127024,
 1558928699,
 1551063123,
 128021,
 1558994234,
 1558885463,
 -1,
 1559059750,
 1558938274,
 -1,
 1559125235,
 1559023606,
 -1,
 1559190769,
 1559089142,
 -1,
 -41744,
 1559125454,
 71701,
 -1,
 1559173706,
 71700,
 -41742,
 1559125454,
 71706,
 -1,
 1559304778,
 71705,
 1559518456,
 1559073440,
 -1,
 -41739,
 1559491514,
 71699,
 -41738,
 1559532266,
 71704,
 -41737,
 1559582882,
 71694,
 -1,
 1559632458,
 71709,
 1559846142,
 1559444309,
 -1,
 1559911676,
 1559771989,
 -1,
 -41733,
 1559846350,
 71703,
 -1,
 1559894602,
 71702,
 -41731,
 1559846350,
 71708,
 -1,
 1560025674,
 71707,
 1560239362,
 1559763530,
 71680,
 -41728,
 1560206523,
 71689,
 -41727,
 1560242173,
 71687,
 -1,
 1560287818,
 71681,
 1560501510,
 1560199636,
 -1,
 -41724,
 1560461993,
 71720,
 -41723,
 1560501710,
 71719,
 -1,
 1560549962,
 71721,
 1560763656,
 1560468667,
 71684,
 -1,
 1560730811,
 71685,
 1560894731,
 1560720354,
 -1,
 -41718,
 1560851540,
 71723,
 -1,
 1560877642,
 71716,
 1561091342,
 1560848848,
 -1,
 -41715,
 1561025998,
 71711,
 -1,
 1561074250,
 71710,
 1561287953,
 1561032800,
 -1,
 -41712,
 1561222606,
 71691,
 -1,
 1561270858,
 71690,
 1561484564,
 1561229121,
 -1,
 -41709,
 1561419214,
 71698,
 -1,
 1561467466,
 71697,
 1561681174,
 1561421821,
 71682,
 -1,
 1561618429,
 71683,
 1561812249,
 1561614419,
 -1,
 -41704,
 1561746894,
 71693,
 -1,
 1561795146,
 71692,
 1562008860,
 1561735080,
 -1,
 -41701,
 1561943502,
 71696,
 -1,
 1561991754,
 71695,
 1562205471,
 1561929991,
 -1,
 -41698,
 1562140110,
 71713,
 -1,
 1562188362,
 71712,
 -41696,
 1562178490,
 71715,
 -41695,
 1562371501,
 71718,
 -41694,
 1562417857,
 71688,
 -41693,
 1562479010,
 71714,
 -41692,
 1562541189,
 71717,
 -41691,
 1562598862,
 71722,
 -1,
 1562657986,
 71686,
 1562860851,
 1559030314,
 -1,
 1562926379,
 1562778186,
 -1,
 -41687,
 1562893499,
 71734,
 -41686,
 1562929149,
 71732,
 -1,
 1562974794,
 71724,
 1563188525,
 1562896740,
 71729,
 -1,
 1563145186,
 71730,
 1563319599,
 1563155643,
 71727,
 -1,
 1563286715,
 71728,
 1563450673,
 1563256829,
 71725,
 -1,
 1563387901,
 71726,
 -41678,
 1563400897,
 71733,
 -1,
 1563509954,
 71731,
 1563712825,
 1562822619,
 -1,
 1563778359,
 1563682993,
 -1,
 -41674,
 1563739028,
 71736,
 -1,
 1563800933,
 71737,
 -41672,
 1563728365,
 71738,
 -1,
 1563894726,
 71735,
 -1,
 1563630475,
 71739,
 -1,
 1558905549,
 128054,
 1564237173,
 1558900693,
 -1,
 1564302706,
 1564207932,
 -1,
 1564368237,
 1564262870,
 -1,
 1564433748,
 1564332022,
 -1,
 1564499283,
 1564391915,
 -1,
 1564564818,
 1564413882,
 -1,
 1564630351,
 1564485056,
 11107,
 1564737535,
 1564540928,
 -1,
 1564761421,
 1564667472,
 -1,
 1564826951,
 1564706421,
 -1,
 -41658,
 1564785770,
 11169,
 -1,
 1564836206,
 11168,
 -41656,
 1564797004,
 129075,
 -41655,
 1564971862,
 129059,
 -41654,
 1565035783,
 129063,
 -41653,
 1565090108,
 129071,
 -41652,
 1565147622,
 11133,
 -1,
 1565208004,
 129067,
 -41650,
 1564727024,
 11123,
 -1,
 1565360623,
 11139,
 -41648,
 1564604356,
 11085,
 -41647,
 1565502059,
 11143,
 -1,
 1565539486,
 11117,
 -1,
 1564475672,
 129171,
 -1,
 1564471600,
 11247,
 1565875552,
 1564351050,
 -1,
 1565941087,
 1565835402,
 -1,
 1566006622,
 1565912656,
 -1,
 1566072154,
 1565968721,
 -1,
 -41639,
 1566038192,
 129027,
 -1,
 1566067988,
 129043,
 -41637,
 1566021753,
 129179,
 -41636,
 1566215458,
 129031,
 -41635,
 1566277115,
 129035,
 -1,
 1566330132,
 129047,
 -1,
 1565925901,
 129975,
 -1,
 1565889451,
 11796,
 1566661987,
 1565835732,
 -1,
 -41630,
 1566618329,
 129083,
 -1,
 1566647121,
 129107,
 1566858598,
 1566597412,
 -1,
 -41627,
 1566783268,
 129091,
 -1,
 1566844352,
 129095,
 1567055209,
 1566780555,
 -1,
 -41624,
 1566979210,
 11147,
 -1,
 1567040960,
 11015,
 -41622,
 1567026439,
 129175,
 -41621,
 1567211343,
 128623,
 -41620,
 1567249473,
 129079,
 -1,
 1567307556,
 129087,
 1567555583,
 1564279514,
 -1,
 1567579504,
 1567463532,
 129289,
 -1,
 1567493268,
 129291,
 1567752191,
 1567515780,
 129288,
 -1,
 1567624340,
 129290,
 1567883263,
 1564217424,
 -1,
 -41612,
 1567803945,
 128317,
 -1,
 1567864726,
 128315,
 1568038278,
 1564204219,
 -1,
 1568103813,
 1567960271,
 -1,
 1568169344,
 1568014336,
 -1,
 1568234875,
 1568129492,
 -1,
 -41606,
 1568204033,
 11844,
 -1,
 1568264381,
 11849,
 -41604,
 1568204687,
 9208,
 -41603,
 1568381751,
 11799,
 -41602,
 1568442234,
 11842,
 -41601,
 1568499685,
 11840,
 -1,
 1568553721,
 10175,
 1568759172,
 1568095063,
 -1,
 -41598,
 1568722867,
 11260,
 -41597,
 1568770657,
 9891,
 -1,
 1568821981,
 9890,
 -1,
 1568673989,
 8508,
 -1,
 1568037637,
 127849,
 1569152398,
 1568004678,
 -1,
 1569217930,
 1569112532,
 -1,
 -41591,
 1569174213,
 11034,
 -1,
 1569234344,
 11850,
 -41589,
 1569183809,
 11784,
 -41588,
 1569373222,
 11798,
 -41587,
 1569430314,
 11795,
 -1,
 1569470784,
 8284,
 1569676691,
 1569077919,
 128462,
 1569783807,
 1569590226,
 -1,
 1569807762,
 1569706819,
 128441,
 -1,
 1569718415,
 128442,
 -1,
 1569762648,
 128443,
 -41580,
 1569646246,
 128330,
 -41579,
 1569956673,
 128682,
 -41578,
 1570015321,
 128044,
 -41577,
 1570062227,
 129444,
 -1,
 1570112778,
 128687,
 1570332227,
 1551031483,
 -1,
 1570397761,
 1570287175,
 -1,
 1570463251,
 1570341538,
 -1,
 1570528695,
 1570423252,
 113692,
 1570594218,
 1570439168,
 -1,
 1570659743,
 1570565750,
 113701,
 -1,
 1570570600,
 113702,
 1570790817,
 1570623478,
 113714,
 -1,
 1570703520,
 113715,
 1570921891,
 1570744784,
 113716,
 -1,
 1570834592,
 113717,
 1571052965,
 1570863200,
 113727,
 -1,
 1570965664,
 113728,
 1571184039,
 1570993985,
 113696,
 -1,
 1571096850,
 113710,
 -41560,
 1571144148,
 113706,
 -41559,
 1571263136,
 113723,
 -1,
 1571326284,
 113724,
 1571511734,
 1570538988,
 -1,
 1571577263,
 1571439810,
 -1,
 -41555,
 1571525280,
 113767,
 -41554,
 1571577276,
 113740,
 -1,
 1571636418,
 113742,
 1571839410,
 1571527361,
 -1,
 -41551,
 1571809953,
 113730,
 -1,
 1571852960,
 113769,
 -41549,
 1571806395,
 113752,
 -41548,
 1571977025,
 113685,
 -41547,
 1572027956,
 113682,
 -1,
 1572086053,
 113768,
 -1,
 1571448216,
 113737,
 1572363714,
 1570476704,
 113690,
 1572429245,
 1572284016,
 -1,
 -41542,
 1572396219,
 113761,
 -41541,
 1572444865,
 113762,
 -41540,
 1572497405,
 113763,
 -1,
 1572543050,
 113764,
 1572798463,
 1572339712,
 -1,
 1572822464,
 1572702540,
 113694,
 -1,
 1572735250,
 113708,
 -41535,
 1572793974,
 113698,
 -1,
 1572913620,
 113704,
 1573084620,
 1572304705,
 113691,
 1573191679,
 1572995072,
 -1,
 1573215686,
 1573121654,
 113699,
 -1,
 1573175844,
 113700,
 1573346760,
 1573175764,
 113705,
 -1,
 1573260436,
 113711,
 1573477834,
 1573294752,
 113712,
 -1,
 1573390610,
 113713,
 1573650431,
 1573423436,
 113695,
 -1,
 1573521682,
 113709,
 1573739988,
 1573055137,
 113720,
 1573805519,
 1573690049,
 113757,
 -1,
 1573776033,
 113760,
 -41520,
 1573742589,
 113758,
 -41519,
 1573871036,
 113721,
 -41518,
 1573931405,
 113759,
 -41517,
 1573984842,
 113756,
 -1,
 1574045856,
 113722,
 1574264282,
 1573696482,
 113675,
 1574329816,
 1574215190,
 -1,
 -41513,
 1574296763,
 113750,
 -1,
 1574332413,
 113741,
 -41511,
 1574264252,
 113688,
 -1,
 1574439186,
 113680,
 1574657503,
 1574214337,
 113732,
 -41508,
 1574628001,
 113754,
 -41507,
 1574689979,
 113755,
 -41506,
 1574739126,
 113753,
 -1,
 1574771274,
 113731,
 1574985189,
 1574603084,
 113689,
 1575092223,
 1574895616,
 -1,
 1575116259,
 1574998688,
 113693,
 -1,
 1575029010,
 113707,
 -41500,
 1575087734,
 113697,
 -1,
 1575207380,
 113703,
 1575378409,
 1574952123,
 113745,
 -41497,
 1575315453,
 113738,
 -41496,
 1575378364,
 113751,
 -1,
 1575421187,
 113748,
 1575640558,
 1575342070,
 113667,
 1575706093,
 1575550976,
 -1,
 -41492,
 1575666132,
 113718,
 -1,
 1575728144,
 113719,
 -1,
 1575640508,
 113681,
 1575968243,
 1575594448,
 113666,
 1576033778,
 1575898615,
 -1,
 -41487,
 1575981728,
 113765,
 -1,
 1576044876,
 113766,
 -1,
 1575945475,
 113676,
 1576295928,
 1575910459,
 113670,
 1576361463,
 1576247364,
 -1,
 -41482,
 1576328379,
 113749,
 -1,
 1576364029,
 113743,
 -1,
 1576295868,
 113687,
 1576623613,
 1576237152,
 113669,
 1576689148,
 1576534016,
 -1,
 -41477,
 1576645648,
 113725,
 -1,
 1576700236,
 113679,
 -1,
 1576630368,
 113684,
 1576951296,
 1576551618,
 113735,
 -41473,
 1576918203,
 113746,
 -1,
 1576944834,
 113739,
 1577147907,
 1576876885,
 113672,
 -41470,
 1577082300,
 113683,
 -1,
 1577126162,
 113677,
 1577344517,
 1577120304,
 113665,
 -1,
 1577314977,
 113747,
 1577475591,
 1577313690,
 113673,
 -1,
 1577425779,
 113770,
 1577606665,
 1577412605,
 113734,
 -1,
 1577534658,
 113736,
 1577737739,
 1577541052,
 113664,
 -1,
 1577679931,
 113686,
 1577868813,
 1577670739,
 113674,
 -1,
 1577781411,
 113726,
 1577999887,
 1577800179,
 113668,
 -1,
 1577911555,
 113678,
 1578130961,
 1577917002,
 113729,
 -1,
 1578083736,
 113733,
 -41454,
 1578103876,
 113744,
 -1,
 1578182919,
 113671,
 1578393149,
 1570381238,
 -1,
 1578458660,
 1578335291,
 -1,
 1578524195,
 1578412277,
 -1,
 1578589720,
 1578493830,
 113816,
 -1,
 1578502451,
 113779,
 1578720795,
 1578531899,
 -1,
 -41446,
 1578672228,
 113811,
 -1,
 1578725015,
 113814,
 1578917406,
 1578637898,
 -1,
 -41443,
 1578877061,
 113817,
 -1,
 1578908466,
 113808,
 -41441,
 1578888123,
 113815,
 -41440,
 1579079036,
 113809,
 -41439,
 1579113668,
 113810,
 -41438,
 1579171832,
 113812,
 -1,
 1579234323,
 113813,
 -1,
 1578453223,
 113776,
 1579507248,
 1578394311,
 -1,
 1579572775,
 1579476870,
 113800,
 -1,
 1579485491,
 113781,
 1579703850,
 1579514939,
 -1,
 -41431,
 1579655268,
 113795,
 -1,
 1579708055,
 113798,
 -41429,
 1579674555,
 113799,
 -41428,
 1579865468,
 113793,
 -41427,
 1579900100,
 113794,
 -41426,
 1579958264,
 113796,
 -41425,
 1580020755,
 113797,
 -1,
 1580080242,
 113792,
 1580293689,
 1579427799,
 -1,
 1580359221,
 1580257404,
 -1,
 1580424756,
 1580308049,
 113784,
 -1,
 1580335991,
 113788,
 -1,
 1580362858,
 113785,
 -41418,
 1580319756,
 113782,
 -41417,
 1580564825,
 113783,
 -41416,
 1580623881,
 113787,
 -1,
 1580680483,
 113786,
 1580883516,
 1580240439,
 -1,
 -41413,
 1580853241,
 113780,
 -1,
 1580885283,
 113777,
 -1,
 1580841802,
 113778,
 -41410,
 1578357716,
 113821,
 -41409,
 1581107209,
 113820,
 -41408,
 1581166978,
 113823,
 -1,
 1581203967,
 113822,
 -41406,
 1570345353,
 129375,
 -1,
 1581331744,
 129414,
 1581539038,
 1570269181,
 -1,
 1581604519,
 1581507994,
 -1,
 1581670053,
 1581534791,
 -1,
 1581735549,
 1581613730,
 -1,
 1581801036,
 1581683360,
 -1,
 -41399,
 1581773754,
 71957,
 -41398,
 1581814506,
 71962,
 -41397,
 1581865122,
 71952,
 -1,
 1581914698,
 71967,
 1582128722,
 1581726549,
 -1,
 1582194256,
 1582054229,
 -1,
 -41393,
 1582128590,
 71961,
 -1,
 1582176842,
 71960,
 -41391,
 1582128590,
 71966,
 -1,
 1582307914,
 71965,
 1582521942,
 1582092278,
 -1,
 -41388,
 1582485628,
 71958,
 -41387,
 1582521806,
 71964,
 -1,
 1582570058,
 71963,
 1582784090,
 1582481876,
 -1,
 -41384,
 1582744233,
 71979,
 -41383,
 1582783950,
 71978,
 -1,
 1582832202,
 71980,
 1583046237,
 1582756662,
 -1,
 -41380,
 1583018938,
 71974,
 -1,
 1583028810,
 71973,
 1583242847,
 1583013051,
 71940,
 -1,
 1583209659,
 71941,
 1583373922,
 1583196624,
 -1,
 -41375,
 1583308238,
 71969,
 -1,
 1583356490,
 71968,
 1583570533,
 1583316027,
 -1,
 -41372,
 1583512709,
 71982,
 -1,
 1583553098,
 71976,
 1583767144,
 1583511648,
 -1,
 -41369,
 1583701454,
 71949,
 -1,
 1583749706,
 71948,
 1583963754,
 1583704061,
 71938,
 -1,
 1583900669,
 71939,
 1584094829,
 1583896659,
 -1,
 -41364,
 1584029134,
 71951,
 -1,
 1584077386,
 71950,
 1584291440,
 1584017320,
 -1,
 -41361,
 1584225742,
 71954,
 -1,
 1584273994,
 71953,
 1584488051,
 1584212231,
 -1,
 -41358,
 1584422350,
 71971,
 -1,
 1584470602,
 71970,
 1584684661,
 1584405066,
 71936,
 -1,
 1584601674,
 71937,
 -41354,
 1584658035,
 71983,
 -41353,
 1584784813,
 71977,
 -41352,
 1584837716,
 71975,
 -41351,
 1584896705,
 71945,
 -41350,
 1584957858,
 71972,
 -41349,
 1585018719,
 71955,
 -41348,
 1585077710,
 71981,
 -1,
 1585136834,
 71942,
 1585340045,
 1581661013,
 -1,
 1585405580,
 1585277931,
 -1,
 1585471106,
 1585369078,
 -1,
 -41343,
 1585442867,
 72018,
 -1,
 1585473055,
 72019,
 1585667717,
 1585430996,
 -1,
 -41340,
 1585608356,
 72022,
 -1,
 1585663972,
 72023,
 1585864328,
 1585598963,
 -1,
 -41337,
 1585817112,
 72020,
 -1,
 1585870314,
 72021,
 -41335,
 1585837872,
 72016,
 -41334,
 1586011929,
 72017,
 -41333,
 1586075374,
 72025,
 -1,
 1586121118,
 72024,
 -1,
 1585358242,
 72004,
 1586388633,
 1585309082,
 -1,
 1586454168,
 1586342218,
 -1,
 1586519697,
 1586420923,
 71987,
 -1,
 1586486459,
 71988,
 1586650771,
 1586456573,
 71985,
 -1,
 1586587645,
 71986,
 1586781846,
 1586567754,
 -1,
 -41323,
 1586718717,
 71991,
 -1,
 1586764362,
 71984,
 -41321,
 1586731713,
 71992,
 -1,
 1586906306,
 71989,
 -1,
 1586393928,
 71998,
 1587175070,
 1586350043,
 -1,
 -41317,
 1587124717,
 72003,
 -41316,
 1587175041,
 71997,
 -41315,
 1587228796,
 71996,
 -1,
 1587291078,
 71995,
 1587502753,
 1587121346,
 -1,
 -41312,
 1587475386,
 72000,
 -1,
 1587524692,
 72002,
 -41310,
 1587458169,
 71999,
 -41309,
 1587638444,
 72001,
 -41308,
 1587697976,
 72005,
 -1,
 1587760006,
 72006,
 -41306,
 1581622128,
 9902,
 -1,
 1587900285,
 129343,
 1588092614,
 1581537363,
 -1,
 1588158136,
 1588032788,
 -1,
 1588223660,
 1588131637,
 -1,
 -41301,
 1588156482,
 127232,
 -1,
 1588213455,
 127233,
 1588420271,
 1588187126,
 -1,
 -41298,
 1588392003,
 127235,
 -1,
 1588422197,
 127236,
 1588616882,
 1588380116,
 -1,
 -41295,
 1588557483,
 127239,
 -1,
 1588613103,
 127240,
 1588813493,
 1588548083,
 -1,
 -41292,
 1588766241,
 127237,
 -1,
 1588819443,
 127238,
 -41290,
 1588764450,
 127234,
 -41289,
 1588958963,
 127242,
 -1,
 1589004715,
 127241,
 1589247999,
 1588114780,
 -1,
 1589272253,
 1589134924,
 119557,
 1589379071,
 1589217607,
 -1,
 -41284,
 1589305360,
 119556,
 -1,
 1589331648,
 119555,
 1589534400,
 1589215869,
 -1,
 -41281,
 1589472571,
 9869,
 -1,
 1589519037,
 9870,
 1589731011,
 1589468604,
 -1,
 -41278,
 1589698581,
 119554,
 -1,
 1589724870,
 119553,
 1589968895,
 1589665004,
 -1,
 -41275,
 1589865787,
 9871,
 -1,
 1589912253,
 9868,
 1590124238,
 1588011277,
 -1,
 1590189772,
 1590095440,
 -1,
 -41271,
 1590155117,
 11032,
 -41270,
 1590213403,
 11031,
 -41269,
 1590263902,
 11030,
 -1,
 1590308355,
 11033,
 -41267,
 1590153612,
 128924,
 -1,
 1590478353,
 128160,
 1590648533,
 1590084052,
 -1,
 1590714068,
 1590565450,
 -1,
 1590779603,
 1590669329,
 -1,
 -41262,
 1590710859,
 128542,
 -1,
 1590767466,
 128549,
 -1,
 1590701293,
 9933,
 -1,
 1590648142,
 129400,
 1591107288,
 1590622227,
 -1,
 -41257,
 1591070643,
 128171,
 -1,
 1591104075,
 128565,
 1591303899,
 1591055942,
 -1,
 -41254,
 1591252238,
 127244,
 -1,
 1591293036,
 127243,
 -41252,
 1591276477,
 129684,
 -41251,
 1591457619,
 127919,
 -1,
 1591496290,
 128754,
 1591697205,
 1581466818,
 -1,
 1591762715,
 1591666074,
 -1,
 1591828244,
 1591681373,
 -1,
 1591893750,
 1591771810,
 -1,
 1591959269,
 1591860411,
 -1,
 -41244,
 1591926537,
 2423,
 -1,
 1591952578,
 2422,
 1592155880,
 1591909057,
 -1,
 -41241,
 1592106001,
 2420,
 -1,
 1592149186,
 2419,
 1592352491,
 1592088659,
 -1,
 -41238,
 1592297187,
 2429,
 -1,
 1592350882,
 2427,
 1592549102,
 1592269386,
 -1,
 -41235,
 1592521526,
 43262,
 -1,
 1592584865,
 2421,
 -41233,
 1592522647,
 2425,
 -41232,
 1592706807,
 2308,
 -41231,
 1592757213,
 2424,
 -41230,
 1592817638,
 2428,
 -41229,
 1592877384,
 2426,
 -41228,
 1592933570,
 2430,
 -41227,
 1592995941,
 2418,
 -1,
 1593059968,
 2431,
 1593270020,
 1591855067,
 -1,
 1593335549,
 1593192584,
 -1,
 1593401083,
 1593298934,
 -1,
 -41222,
 1593372723,
 43253,
 -1,
 1593402911,
 43254,
 -41220,
 1593370893,
 43251,
 -1,
 1593518198,
 43255,
 1593728768,
 1593295316,
 -1,
 -41217,
 1593682511,
 43250,
 -1,
 1593731529,
 43260,
 -41215,
 1593684438,
 43256,
 -41214,
 1593864745,
 2304,
 -41213,
 1593926370,
 2417,
 -1,
 1593983348,
 43252,
 1594187536,
 1593240106,
 -1,
 1594253064,
 1594154171,
 -1,
 -41209,
 1594220297,
 2391,
 -1,
 1594246338,
 2390,
 1594449675,
 1594202817,
 -1,
 -41206,
 1594399761,
 2363,
 -1,
 1594442946,
 2362,
 1594646286,
 1594366538,
 -1,
 -41203,
 1594618678,
 43263,
 -1,
 1594682017,
 2383,
 -41201,
 1594601682,
 2382,
 -1,
 1594765422,
 2389,
 -41199,
 1594128239,
 43261,
 -41198,
 1594908910,
 43259,
 -41197,
 1594972472,
 43257,
 -1,
 1595027710,
 43258,
 1595277311,
 1591765337,
 -1,
 1595301656,
 1595199478,
 -1,
 -41193,
 1595273267,
 983085,
 -1,
 1595303455,
 983087,
 -41191,
 1595264545,
 983160,
 -41190,
 1595449113,
 983083,
 -1,
 1595496050,
 983089,
 1595694889,
 1591722452,
 -1,
 1595760422,
 1595624746,
 -1,
 1595825956,
 1595690652,
 -1,
 1595891489,
 1595787757,
 -1,
 -41184,
 1595841733,
 66638,
 -1,
 1595887811,
 66639,
 1596129279,
 1595814106,
 -1,
 -41181,
 1596038341,
 66598,
 -1,
 1596084419,
 66599,
 1596325887,
 1595789302,
 127964,
 -1,
 1596195770,
 127965,
 1596456959,
 1595702231,
 -1,
 -41176,
 1596386816,
 128468,
 -1,
 1596405557,
 128421,
 1596612396,
 1595636795,
 983119,
 -41173,
 1596552828,
 128666,
 -1,
 1596608186,
 983118,
 1596809009,
 1596534696,
 -1,
 1596874544,
 1596745725,
 -1,
 -41169,
 1596820034,
 9192,
 -1,
 1596867714,
 127795,
 -1,
 1596831449,
 128475,
 -41166,
 1596766260,
 127962,
 -41165,
 1597090715,
 127980,
 -41164,
 1597132074,
 129420,
 -1,
 1597185398,
 129487,
 1597398849,
 1591653346,
 -1,
 1597464380,
 1597348545,
 -1,
 1597529914,
 1597417936,
 -1,
 -41159,
 1597473414,
 128167,
 -1,
 1597506880,
 129656,
 -41157,
 1597480372,
 129316,
 -1,
 1597672629,
 128042,
 1597857598,
 1597382164,
 128009,
 -1,
 1597768397,
 128050,
 -41153,
 1597825021,
 129345,
 -41152,
 1597929037,
 9946,
 -1,
 1597984385,
 128087,
 1598185295,
 1597315658,
 -1,
 1598250823,
 1598118529,
 -1,
 1598316358,
 1598221904,
 -1,
 -41147,
 1598274291,
 11831,
 -1,
 1598324793,
 11830,
 -1,
 1598258000,
 128481,
 1598578506,
 1598211401,
 -1,
 -41143,
 1598549724,
 11843,
 -1,
 1598607283,
 128168,
 1598775117,
 1598526112,
 -1,
 -41140,
 1598708797,
 127841,
 -1,
 1598763542,
 128131,
 -41138,
 1598738559,
 983081,
 -1,
 1598930644,
 128374,
 1599102805,
 1598107560,
 -1,
 -41135,
 1599062484,
 983161,
 -41134,
 1599083886,
 983090,
 -41133,
 1599149136,
 983088,
 -41132,
 1599214379,
 983086,
 -1,
 1599279611,
 983084,
 -41130,
 1599071881,
 128192,
 -41129,
 1599443693,
 129516,
 -1,
 1599504188,
 983082,
 1599693389,
 1550932051,
 -1,
 1599758524,
 1599648738,
 -1,
 1599823944,
 1599686633,
 -1,
 1599889475,
 1599764578,
 -1,
 1599954864,
 1599806026,
 -1,
 1600020397,
 1599879477,
 -1,
 1600085891,
 1599940577,
 -1,
 1600151410,
 1600017253,
 -1,
 1600216939,
 1600120460,
 65859,
 1600323583,
 1600126976,
 -1,
 1600348006,
 1600245750,
 -1,
 1600413541,
 1600284132,
 65862,
 -1,
 1600326138,
 65870,
 -1,
 1600331714,
 65864,
 1600610154,
 1600284530,
 65861,
 1600716799,
 1600520192,
 -1,
 -41111,
 1600639283,
 65868,
 -1,
 1600703769,
 65875,
 -1,
 1600572697,
 65871,
 1600978943,
 1600149559,
 65860,
 1601044479,
 1600847872,
 -1,
 1601068913,
 1600966646,
 -1,
 1601134448,
 1601005028,
 65863,
 -1,
 1601046962,
 65878,
 -1,
 1601052610,
 65866,
 -1,
 1601031449,
 65873,
 1601396605,
 1600102173,
 -1,
 1601462136,
 1601330620,
 -1,
 1601527671,
 1601429708,
 -1,
 -41098,
 1601491251,
 65867,
 -1,
 1601555737,
 65874,
 -1,
 1601445854,
 65857,
 1601789819,
 1601426493,
 -1,
 -41094,
 1601753395,
 65869,
 -1,
 1601817881,
 65876,
 -41092,
 1601745638,
 65856,
 -1,
 1601913830,
 65858,
 1602158591,
 1601360539,
 -1,
 1602183041,
 1602080758,
 -1,
 -41088,
 1602119170,
 65877,
 -1,
 1602166722,
 65865,
 -41086,
 1602145561,
 65872,
 -1,
 1602326604,
 65879,
 1602510748,
 1600049142,
 -1,
 1602576276,
 1602445813,
 -1,
 1602641803,
 1602539510,
 -1,
 1602707337,
 1602575804,
 -1,
 -41080,
 1602664375,
 65899,
 -1,
 1602712625,
 65893,
 -41078,
 1602678835,
 65884,
 -1,
 1602833121,
 65892,
 1603035023,
 1602592537,
 65881,
 1603141631,
 1602945024,
 -1,
 -41074,
 1603064884,
 65905,
 -1,
 1603102578,
 65898,
 1603338239,
 1602966373,
 -1,
 1603362707,
 1603266191,
 -1,
 -41070,
 1603327028,
 65906,
 -1,
 1603364722,
 65902,
 -1,
 1603295287,
 65897,
 1603665919,
 1602535254,
 -1,
 1603690394,
 1603556197,
 -1,
 1603755928,
 1603659404,
 65887,
 -1,
 1603666817,
 65901,
 1603928063,
 1603688503,
 65894,
 -1,
 1603797025,
 65895,
 1604059135,
 1603654295,
 65888,
 -1,
 1603928097,
 65889,
 1604149154,
 1602445745,
 -1,
 1604214689,
 1604095999,
 -1,
 -41057,
 1604178583,
 65890,
 -41056,
 1604230937,
 65882,
 -1,
 1604277102,
 65896,
 -1,
 1604132193,
 65880,
 1604542374,
 1604078804,
 -1,
 1604607909,
 1604508617,
 65883,
 -1,
 1604518561,
 65886,
 -1,
 1604539604,
 65900,
 1604804521,
 1604464552,
 -1,
 -41048,
 1604777482,
 65885,
 -1,
 1604789839,
 65903,
 -41046,
 1604767245,
 65908,
 -41045,
 1604948863,
 65904,
 -41044,
 1605012954,
 65891,
 -1,
 1605057894,
 65907,
 1605304319,
 1599976418,
 -1,
 -41041,
 1605226664,
 65926,
 -1,
 1605281442,
 65927,
 1605459929,
 1599892795,
 -1,
 1605525464,
 1605422753,
 -1,
 1605590970,
 1605440878,
 119327,
 -41036,
 1605507480,
 119356,
 -41035,
 1605572839,
 119355,
 -41034,
 1605638151,
 119354,
 -41033,
 1605703234,
 119353,
 -41032,
 1605768272,
 119352,
 -41031,
 1605833515,
 119351,
 -1,
 1605898475,
 119350,
 1606115266,
 1605505531,
 119325,
 -41028,
 1606031768,
 119337,
 -41027,
 1606097127,
 119336,
 -41026,
 1606162439,
 119335,
 -41025,
 1606227310,
 119334,
 -41024,
 1606292560,
 119333,
 -41023,
 1606357803,
 119332,
 -1,
 1606423035,
 119331,
 1606639561,
 1606030123,
 119326,
 -41020,
 1606556056,
 119343,
 -41019,
 1606621191,
 119342,
 -41018,
 1606686519,
 119341,
 -41017,
 1606751810,
 119340,
 -41016,
 1606817134,
 119339,
 -1,
 1606882384,
 119338,
 1607098319,
 1606555202,
 119328,
 -41013,
 1607013742,
 119361,
 -41012,
 1607078992,
 119360,
 -41011,
 1607144235,
 119359,
 -41010,
 1607209467,
 119358,
 -1,
 1607274731,
 119357,
 1607491542,
 1607013456,
 -1,
 -41007,
 1607408024,
 119349,
 -41006,
 1607473383,
 119348,
 -41005,
 1607538695,
 119347,
 -41004,
 1607604023,
 119346,
 -41003,
 1607668523,
 119345,
 -1,
 1607733483,
 119344,
 -41001,
 1607407847,
 119330,
 -1,
 1607866375,
 119329,
 -1,
 1605451488,
 65933,
 1608146935,
 1605429562,
 -1,
 1608212453,
 1608061435,
 119296,
 -40996,
 1608128920,
 119314,
 -40995,
 1608194279,
 119313,
 -40994,
 1608259591,
 119312,
 -40993,
 1608324919,
 119311,
 -40992,
 1608390210,
 119310,
 -40991,
 1608455534,
 119309,
 -40990,
 1608520784,
 119308,
 -40989,
 1608586027,
 119307,
 -40988,
 1608651259,
 119306,
 -1,
 1608716523,
 119305,
 1608933355,
 1608128066,
 119300,
 -40985,
 1608848750,
 119324,
 -40984,
 1608914000,
 119323,
 -40983,
 1608979243,
 119322,
 -40982,
 1609044475,
 119321,
 -1,
 1609109739,
 119320,
 1609326577,
 1608848171,
 119297,
 -40979,
 1609241966,
 119319,
 -40978,
 1609307216,
 119318,
 -40977,
 1609372459,
 119317,
 -40976,
 1609437691,
 119316,
 -1,
 1609502955,
 119315,
 -40974,
 1609243032,
 119304,
 -40973,
 1609636071,
 119303,
 -40972,
 1609701383,
 119302,
 -40971,
 1609766711,
 119301,
 -40970,
 1609831790,
 119299,
 -1,
 1609897040,
 119298,
 1610113036,
 1608106452,
 -1,
 1610178564,
 1610058381,
 -1,
 1610244096,
 1610121890,
 -1,
 1610309629,
 1610203604,
 -1,
 -40964,
 1610245158,
 1016,
 -1,
 1610293541,
 1019,
 -40962,
 1610263202,
 887,
 -40961,
 1610441220,
 881,
 -1,
 1610491061,
 883,
 1610702851,
 1610201393,
 -1,
 -40958,
 1610647837,
 891,
 -1,
 1610694864,
 893,
 -1,
 1610629328,
 892,
 1610965002,
 1610145421,
 -1,
 -40954,
 1610922415,
 7528,
 -40953,
 1610984736,
 7529,
 -40952,
 1611028753,
 7527,
 -40951,
 1611084618,
 7530,
 -1,
 1611148098,
 7526,
 -40949,
 1610937732,
 65952,
 -1,
 1611297156,
 65932,
 1611489308,
 1610035383,
 -1,
 1611554839,
 1611430971,
 -1,
 1611620374,
 1611484944,
 -1,
 1611685906,
 1611579860,
 -1,
 -40943,
 1611621414,
 1015,
 -1,
 1611669797,
 1018,
 -40941,
 1611658698,
 895,
 -40940,
 1611836066,
 886,
 -40939,
 1611883012,
 880,
 -1,
 1611932853,
 882,
 -1,
 1611587668,
 1017,
 1612210202,
 1611512113,
 -1,
 -40935,
 1612155165,
 1021,
 -1,
 1612202192,
 1023,
 -40933,
 1612151048,
 975,
 -1,
 1612333264,
 1022,
 1612537894,
 1611430971,
 -1,
 1612603429,
 1612468001,
 -1,
 1612668961,
 1612556752,
 -1,
 -40928,
 1612629862,
 7466,
 -1,
 1612670973,
 7464,
 -40926,
 1612626351,
 7465,
 -40925,
 1612815948,
 43877,
 -40924,
 1612873084,
 7463,
 -1,
 1612929297,
 7462,
 -1,
 1612543434,
 65923,
 1613193263,
 1612500982,
 -1,
 1613258794,
 1613164598,
 -1,
 -40919,
 1613222939,
 65911,
 -1,
 1613273941,
 65917,
 1613455405,
 1613194788,
 -1,
 -40916,
 1613411133,
 65912,
 -1,
 1613470549,
 65918,
 -40914,
 1613414838,
 65929,
 -1,
 1613569975,
 65914,
 1613783094,
 1613142721,
 -1,
 1613848628,
 1613730992,
 -1,
 1613914163,
 1613782775,
 65909,
 -1,
 1613824033,
 65910,
 -1,
 1613869848,
 65931,
 -40907,
 1613816111,
 65924,
 -1,
 1614032292,
 65916,
 1614241849,
 1613728076,
 -1,
 -40904,
 1614210291,
 119365,
 -1,
 1614237443,
 65921,
 1614438460,
 1614172659,
 -1,
 -40901,
 1614390861,
 65919,
 -1,
 1614444072,
 65920,
 -40899,
 1614411607,
 65930,
 -40898,
 1614607431,
 65913,
 -40897,
 1614672543,
 65925,
 -40896,
 1614723507,
 1020,
 -40895,
 1614773279,
 65922,
 -40894,
 1614830725,
 65928,
 -1,
 1614889966,
 65915,
 1615134719,
 1599836834,
 -1,
 -40891,
 1615053556,
 129367,
 -40890,
 1615094009,
 128154,
 -40889,
 1615146454,
 128215,
 -1,
 1615209507,
 127823,
 1615421613,
 1599740490,
 -1,
 1615487147,
 1615370651,
 -1,
 1615552653,
 1615430306,
 -1,
 1615618133,
 1615521178,
 -1,
 1615683665,
 1615567723,
 -1,
 1615749199,
 1615639522,
 70411,
 -1,
 1615705058,
 70496,
 1615921151,
 1615690811,
 70412,
 -1,
 1615821883,
 70497,
 1616011348,
 1615611836,
 -1,
 -40877,
 1615937825,
 70495,
 -1,
 1615995846,
 70494,
 -1,
 1615927882,
 70453,
 1616273499,
 1615581174,
 -1,
 1616339033,
 1616236534,
 -1,
 -40872,
 1616272846,
 70432,
 -1,
 1616321098,
 70431,
 -40870,
 1616272846,
 70437,
 -1,
 1616452170,
 70436,
 1616666720,
 1616220832,
 -1,
 -40867,
 1616638906,
 70430,
 -40866,
 1616679658,
 70435,
 -40865,
 1616730274,
 70425,
 -1,
 1616779850,
 70440,
 1616994406,
 1616591701,
 -1,
 1617059940,
 1616919381,
 -1,
 -40861,
 1616993742,
 70434,
 -1,
 1617041994,
 70433,
 -40859,
 1616993742,
 70439,
 -1,
 1617173066,
 70438,
 1617387626,
 1616910922,
 70405,
 -40856,
 1617353915,
 70420,
 -40855,
 1617389565,
 70416,
 -1,
 1617435210,
 70406,
 1617649774,
 1617347028,
 -1,
 -40852,
 1617609385,
 70455,
 -40851,
 1617649102,
 70454,
 -1,
 1617697354,
 70456,
 1617911920,
 1617616059,
 70409,
 -1,
 1617878203,
 70410,
 1618042995,
 1617865168,
 -1,
 -40846,
 1617976782,
 70443,
 -1,
 1618025034,
 70442,
 1618239606,
 1617984571,
 -1,
 -40843,
 1618181253,
 70451,
 -1,
 1618221642,
 70450,
 1618436217,
 1618180192,
 -1,
 -40840,
 1618369998,
 70422,
 -1,
 1618418250,
 70421,
 1618632828,
 1618376513,
 -1,
 -40837,
 1618566606,
 70429,
 -1,
 1618614858,
 70428,
 1618829438,
 1618569213,
 70407,
 -1,
 1618765821,
 70408,
 1618960513,
 1618761811,
 -1,
 -40832,
 1618894286,
 70424,
 -1,
 1618942538,
 70423,
 1619157124,
 1618882472,
 -1,
 -40829,
 1619090894,
 70427,
 -1,
 1619139146,
 70426,
 1619353735,
 1619077383,
 -1,
 -40826,
 1619287502,
 70445,
 -1,
 1619335754,
 70444,
 -40824,
 1619325882,
 70447,
 -40823,
 1619506260,
 70448,
 -40822,
 1619566924,
 70419,
 -40821,
 1619626402,
 70446,
 -40820,
 1619680718,
 70457,
 -1,
 1619740649,
 70415,
 1619943581,
 1615522346,
 -1,
 1620009107,
 1619913041,
 -1,
 1620074641,
 1619964898,
 70467,
 -1,
 1620030434,
 70468,
 1620246527,
 1620016187,
 70498,
 -1,
 1620147259,
 70499,
 1620336791,
 1619925578,
 -1,
 -40811,
 1620303035,
 70476,
 -40810,
 1620338685,
 70472,
 -1,
 1620384330,
 70462,
 1620598937,
 1620303035,
 70465,
 -1,
 1620565179,
 70466,
 1620730011,
 1620535293,
 70463,
 -1,
 1620666365,
 70464,
 -40804,
 1620681036,
 70475,
 -1,
 1620789225,
 70471,
 1620992169,
 1619904475,
 -1,
 1621057697,
 1620961457,
 -1,
 -40800,
 1621017492,
 70403,
 -1,
 1621079397,
 70477,
 1621254308,
 1620979624,
 -1,
 -40797,
 1621204527,
 70400,
 -1,
 1621238441,
 70401,
 1621450919,
 1621170762,
 -1,
 -40794,
 1621419444,
 70461,
 -1,
 1621465660,
 70402,
 -40792,
 1621405350,
 70493,
 -1,
 1621596653,
 70460,
 -40790,
 1620942315,
 70480,
 -1,
 1621698593,
 70487,
 -40788,
 1615441157,
 127815,
 -1,
 1621836865,
 127891,
 1622040759,
 1615357949,
 -1,
 1622106294,
 1621989307,
 -1,
 1622171829,
 1622037067,
 128512,
 1622278143,
 1622084562,
 -1,
 1622302900,
 1622196692,
 -1,
 -40781,
 1622266243,
 129321,
 -1,
 1622314845,
 128513,
 -1,
 1622253474,
 129322,
 -1,
 1622094177,
 128568,
 -1,
 1622051263,
 128556,
 1622736895,
 1621990081,
 -1,
 1622761659,
 1622663510,
 -1,
 -40774,
 1622721679,
 983109,
 -1,
 1622772578,
 11218,
 -1,
 1622732301,
 128151,
 1623023938,
 1599685826,
 -1,
 1623089468,
 1622975403,
 -1,
 1623154940,
 1623036340,
 -1,
 1623220423,
 1623088572,
 -1,
 1623285956,
 1623136842,
 -1,
 1623351491,
 1623241698,
 7348,
 -1,
 1623276474,
 7358,
 -1,
 1623278786,
 7344,
 -40763,
 1623235601,
 7349,
 -40762,
 1623484985,
 7346,
 -1,
 1623540930,
 7345,
 1623744717,
 1623142312,
 -1,
 1623810251,
 1623678396,
 -1,
 -40758,
 1623747899,
 7337,
 -1,
 1623794765,
 7341,
 -40756,
 1623747690,
 7340,
 -1,
 1623925029,
 7338,
 1624137938,
 1623707638,
 -1,
 1624203473,
 1624054346,
 -1,
 -40752,
 1624159202,
 7330,
 -1,
 1624216224,
 7319,
 -1,
 1624171570,
 7353,
 1624465622,
 1624054346,
 -1,
 -40748,
 1624412832,
 7312,
 -40747,
 1624468795,
 7354,
 -1,
 1624525537,
 7357,
 1624727769,
 1624438341,
 -1,
 -40744,
 1624662007,
 7327,
 -1,
 1624722145,
 7318,
 1624924380,
 1624687060,
 -1,
 -40741,
 1624859475,
 7336,
 -1,
 1624908069,
 7329,
 1625120991,
 1624877520,
 -1,
 -40738,
 1625055223,
 7332,
 -1,
 1625105485,
 7326,
 1625317602,
 1625062533,
 -1,
 -40735,
 1625276884,
 7322,
 -1,
 1625304006,
 7359,
 1625514213,
 1625258080,
 -1,
 -40732,
 1625448439,
 7333,
 -1,
 1625497893,
 7321,
 1625710824,
 1625454401,
 -1,
 -40729,
 1625648234,
 7339,
 -1,
 1625710410,
 7343,
 1625907435,
 1625643091,
 -1,
 -40726,
 1625841482,
 7334,
 -1,
 1625891109,
 7314,
 1626104046,
 1625834690,
 -1,
 -40723,
 1626051232,
 7316,
 -1,
 1626112937,
 7352,
 -40721,
 1626076571,
 7351,
 -40720,
 1626272360,
 7342,
 -40719,
 1626336282,
 7347,
 -40718,
 1626401018,
 7317,
 -40717,
 1626464329,
 7331,
 -40716,
 1626518686,
 7328,
 -40715,
 1626583641,
 7335,
 -40714,
 1626644094,
 7325,
 -40713,
 1626706770,
 7324,
 -40712,
 1626770168,
 7323,
 -40711,
 1626828091,
 7320,
 -40710,
 1626887013,
 7350,
 -40709,
 1626947572,
 7315,
 -1,
 1627007417,
 7313,
 1627218225,
 1623116269,
 -1,
 1627283716,
 1627151804,
 -1,
 1627349249,
 1627200074,
 -1,
 -40704,
 1627304930,
 11556,
 -1,
 1627342018,
 11552,
 -40702,
 1627298833,
 11557,
 -40701,
 1627482681,
 11554,
 -1,
 1627538626,
 11553,
 1627742474,
 1627205544,
 -1,
 1627808008,
 1627676092,
 -1,
 -40697,
 1627745595,
 11545,
 -1,
 1627792461,
 11549,
 -40695,
 1627745386,
 11548,
 -1,
 1627922725,
 11546,
 1628135693,
 1627715141,
 -1,
 -40692,
 1628069879,
 11535,
 -1,
 1628130017,
 11526,
 1628332304,
 1628098684,
 -1,
 -40689,
 1628287970,
 11538,
 -1,
 1628344992,
 11527,
 1628528915,
 1628291540,
 -1,
 -40686,
 1628463955,
 11544,
 -1,
 1628512549,
 11537,
 1628725526,
 1628482000,
 -1,
 -40683,
 1628659703,
 11540,
 -1,
 1628709965,
 11534,
 1628922137,
 1628665952,
 -1,
 -40680,
 1628856311,
 11541,
 -1,
 1628905765,
 11529,
 1629118748,
 1628862273,
 -1,
 -40677,
 1629056106,
 11547,
 -1,
 1629118282,
 11551,
 1629315359,
 1629050963,
 -1,
 -40674,
 1629249354,
 11542,
 -1,
 1629298981,
 11522,
 1629511970,
 1629231690,
 -1,
 -40671,
 1629459104,
 11520,
 -1,
 1629506273,
 11565,
 -40669,
 1629484443,
 11559,
 -40668,
 1629680232,
 11550,
 -40667,
 1629744154,
 11555,
 -40666,
 1629808890,
 11525,
 -40665,
 1629872201,
 11539,
 -40664,
 1629926558,
 11536,
 -40663,
 1629991513,
 11543,
 -40662,
 1630051966,
 11533,
 -40661,
 1630114642,
 11532,
 -40660,
 1630178040,
 11531,
 -40659,
 1630240299,
 11530,
 -40658,
 1630301499,
 11528,
 -40657,
 1630358241,
 11524,
 -40656,
 1630420980,
 11523,
 -1,
 1630480825,
 11521,
 1630691641,
 1627161250,
 -1,
 1630757173,
 1630607946,
 -1,
 -40652,
 1630694715,
 4346,
 -1,
 1630751457,
 4349,
 -40650,
 1630723365,
 983936,
 -40649,
 1630919467,
 4345,
 -40648,
 1630960805,
 4351,
 -1,
 1631019048,
 4350,
 1631256575,
 1630613722,
 -1,
 -40645,
 1631188379,
 4295,
 -1,
 1631198496,
 4301,
 1631412544,
 1623008333,
 9881,
 1631518719,
 1631325132,
 -1,
 -40641,
 1631430380,
 9965,
 -1,
 1631454052,
 9966,
 -40639,
 1631360687,
 129502,
 -1,
 1631619470,
 128142,
 1631805896,
 1622965307,
 -1,
 1631871428,
 1631722058,
 -1,
 1631936963,
 1631804501,
 -1,
 1632002436,
 1631898093,
 -1,
 1632067919,
 1631961556,
 -1,
 1632133451,
 1632001468,
 -1,
 1632198986,
 1632096380,
 11339,
 -1,
 1632152904,
 11356,
 -1,
 1632115274,
 11342,
 1632395597,
 1632078575,
 11348,
 -1,
 1632308957,
 11349,
 -40626,
 1632349536,
 11346,
 -1,
 1632470782,
 11332,
 1632657752,
 1632039734,
 -1,
 1632723285,
 1632584898,
 -1,
 1632788820,
 1632678882,
 -1,
 -40621,
 1632754875,
 11343,
 -1,
 1632790525,
 11344,
 -1,
 1632751293,
 11317,
 -40618,
 1632689339,
 11347,
 -40617,
 1633000129,
 11350,
 -1,
 1633036211,
 11345,
 1633247584,
 1632593917,
 11323,
 1633313116,
 1633220477,
 -1,
 -40613,
 1633252820,
 11355,
 -1,
 1633305794,
 11321,
 1633509727,
 1633264871,
 -1,
 -40610,
 1633471115,
 11351,
 -1,
 1633496051,
 11353,
 -1,
 1633458033,
 11322,
 1633771876,
 1633210358,
 -1,
 -40606,
 1633741439,
 11333,
 -40605,
 1633797990,
 11340,
 -1,
 1633861489,
 11357,
 1634034024,
 1633696597,
 -1,
 -40602,
 1634006801,
 11319,
 -40601,
 1634048864,
 11316,
 -1,
 1634105279,
 11324,
 1634296171,
 1634006597,
 -1,
 -40598,
 1634231273,
 11318,
 -1,
 1634290375,
 11320,
 1634492782,
 1634249168,
 -1,
 -40595,
 1634442542,
 11330,
 -1,
 1634485442,
 11338,
 1634689393,
 1634441921,
 -1,
 -40592,
 1634654850,
 11337,
 -1,
 1634703832,
 11329,
 1634886004,
 1634630715,
 -1,
 -40589,
 1634826309,
 11326,
 -1,
 1634871229,
 11358,
 1635082615,
 1634816499,
 -1,
 -40586,
 1635040957,
 11335,
 -1,
 1635087651,
 11354,
 1635279226,
 1635002631,
 -1,
 -40583,
 1635245981,
 11313,
 -1,
 1635281597,
 11352,
 -40581,
 1635247817,
 11314,
 -40580,
 1635442580,
 11334,
 -40579,
 1635499703,
 11331,
 -40578,
 1635554165,
 11328,
 -40577,
 1635619480,
 11327,
 -40576,
 1635678496,
 11325,
 -40575,
 1635738074,
 11336,
 -40574,
 1635802106,
 11315,
 -40573,
 1635857316,
 11341,
 -1,
 1635920131,
 11312,
 1636171775,
 1631924442,
 -1,
 1636196750,
 1636090324,
 -1,
 1636262282,
 1636130236,
 -1,
 1636327817,
 1636225148,
 11291,
 -1,
 1636281672,
 11308,
 -1,
 1636244042,
 11294,
 1636524428,
 1636207343,
 11300,
 -1,
 1636437725,
 11301,
 -40563,
 1636478304,
 11298,
 -1,
 1636599550,
 11284,
 1636786583,
 1636168502,
 -1,
 1636852116,
 1636713666,
 -1,
 1636917651,
 1636807650,
 -1,
 -40558,
 1636883643,
 11295,
 -1,
 1636919293,
 11296,
 -1,
 1636880061,
 11269,
 -40555,
 1636818107,
 11299,
 -40554,
 1637128897,
 11302,
 -1,
 1637164979,
 11297,
 1637376415,
 1636722685,
 11275,
 1637441947,
 1637349245,
 -1,
 -40550,
 1637381588,
 11307,
 -1,
 1637434562,
 11273,
 1637638558,
 1637393639,
 -1,
 -40547,
 1637599883,
 11303,
 -1,
 1637624819,
 11305,
 -1,
 1637586801,
 11274,
 1637900707,
 1637339126,
 -1,
 -40543,
 1637870207,
 11285,
 -40542,
 1637926758,
 11292,
 -1,
 1637990257,
 11309,
 1638162855,
 1637825365,
 -1,
 -40539,
 1638135569,
 11271,
 -40538,
 1638177632,
 11268,
 -1,
 1638234047,
 11276,
 1638425002,
 1638135365,
 -1,
 -40535,
 1638360041,
 11270,
 -1,
 1638419143,
 11272,
 1638621613,
 1638377936,
 -1,
 -40532,
 1638571310,
 11282,
 -1,
 1638614210,
 11290,
 1638818224,
 1638570689,
 -1,
 -40529,
 1638783618,
 11289,
 -1,
 1638832600,
 11281,
 1639014835,
 1638759483,
 -1,
 -40526,
 1638955077,
 11278,
 -1,
 1638999997,
 11310,
 1639211446,
 1638945267,
 -1,
 -40523,
 1639169725,
 11287,
 -1,
 1639216419,
 11306,
 1639408057,
 1639131399,
 -1,
 -40520,
 1639374749,
 11265,
 -1,
 1639410365,
 11304,
 -40518,
 1639376585,
 11266,
 -40517,
 1639571348,
 11286,
 -40516,
 1639628471,
 11283,
 -40515,
 1639682933,
 11280,
 -40514,
 1639748248,
 11279,
 -40513,
 1639807264,
 11277,
 -40512,
 1639866842,
 11288,
 -40511,
 1639930874,
 11267,
 -40510,
 1639986084,
 11293,
 -1,
 1640048899,
 11264,
 -1,
 1631898654,
 129371,
 1640366079,
 1631820481,
 -1,
 -40506,
 1640295972,
 127775,
 -40505,
 1640360066,
 129508,
 -1,
 1640377003,
 127760,
 1640587837,
 1631771835,
 -1,
 1640653342,
 1640535945,
 -1,
 1640718847,
 1640596130,
 -1,
 1640784337,
 1640681462,
 -1,
 1640849871,
 1640746998,
 -1,
 -40498,
 1640783310,
 73086,
 -1,
 1640831562,
 73085,
 -40496,
 1640783310,
 73076,
 -1,
 1640962634,
 73075,
 1641177559,
 1640708949,
 -1,
 1641243093,
 1641102165,
 -1,
 -40492,
 1641176526,
 73091,
 -1,
 1641224778,
 73090,
 -40490,
 1641176526,
 73081,
 -1,
 1641355850,
 73080,
 1641570779,
 1641093706,
 73056,
 -40487,
 1641536699,
 73067,
 -40486,
 1641572349,
 73064,
 -1,
 1641617994,
 73057,
 1641832925,
 1641536699,
 73060,
 -1,
 1641798843,
 73061,
 1641964000,
 1641785808,
 -1,
 -40481,
 1641897422,
 73094,
 -1,
 1641945674,
 73093,
 1642160611,
 1641910944,
 -1,
 -40478,
 1642092706,
 73092,
 -1,
 1642142282,
 73082,
 1642357222,
 1642101819,
 -1,
 -40475,
 1642298501,
 73087,
 -1,
 1642338890,
 73077,
 1642553833,
 1642297440,
 -1,
 -40472,
 1642487246,
 73074,
 -1,
 1642535498,
 73073,
 1642750444,
 1642493761,
 -1,
 -40469,
 1642683854,
 73089,
 -1,
 1642732106,
 73088,
 1642947054,
 1642686461,
 73058,
 -1,
 1642883069,
 73059,
 1643078129,
 1642879059,
 -1,
 -40464,
 1643011534,
 73079,
 -1,
 1643059786,
 73078,
 1643274740,
 1642999720,
 -1,
 -40461,
 1643208142,
 73084,
 -1,
 1643256394,
 73083,
 1643471351,
 1643194631,
 -1,
 -40458,
 1643404750,
 73071,
 -1,
 1643453002,
 73070,
 -40456,
 1643443130,
 73068,
 -40455,
 1643636141,
 73069,
 -40454,
 1643692713,
 73097,
 -40453,
 1643754580,
 73096,
 -40452,
 1643815244,
 73066,
 -40451,
 1643874722,
 73072,
 -40450,
 1643929038,
 73095,
 -1,
 1643988969,
 73063,
 1644192268,
 1640687002,
 -1,
 1644257803,
 1644144970,
 -1,
 1644323333,
 1644173898,
 -1,
 -40445,
 1644289211,
 73108,
 -40444,
 1644324861,
 73105,
 -1,
 1644370506,
 73098,
 1644585479,
 1644289211,
 73101,
 -1,
 1644551355,
 73102,
 1644716553,
 1644521469,
 73099,
 -1,
 1644652541,
 73100,
 -40438,
 1644667212,
 73107,
 -1,
 1644775401,
 73104,
 -1,
 1644196680,
 73111,
 1645044250,
 1644117741,
 -1,
 1645109776,
 1645006838,
 -1,
 -40433,
 1645080627,
 73122,
 -1,
 1645110815,
 73123,
 1645306387,
 1645068756,
 -1,
 -40430,
 1645246116,
 73126,
 -1,
 1645301732,
 73127,
 1645502998,
 1645236723,
 -1,
 -40427,
 1645454872,
 73124,
 -1,
 1645508074,
 73125,
 -40425,
 1645475632,
 73120,
 -40424,
 1645649689,
 73121,
 -40423,
 1645713134,
 73129,
 -1,
 1645758878,
 73128,
 1645961757,
 1645004763,
 -1,
 -40420,
 1645930772,
 73110,
 -1,
 1645945798,
 73109,
 -1,
 1645911531,
 73112,
 1646223920,
 1640593281,
 -1,
 1646289448,
 1646184411,
 -1,
 1646354979,
 1646252022,
 -1,
 -40414,
 1646326031,
 2815,
 -1,
 1646356224,
 2813,
 1646551590,
 1646313940,
 -1,
 -40411,
 1646518168,
 2810,
 -1,
 1646550515,
 2811,
 -40409,
 1646496250,
 2812,
 -1,
 1646670888,
 2814,
 1646879276,
 1646232226,
 -1,
 1646944811,
 1646848346,
 2700,
 -1,
 1646885947,
 2785,
 -1,
 1646917527,
 2809,
 1647141422,
 1646848600,
 2786,
 -1,
 1647082555,
 2787,
 -40401,
 1647100300,
 2801,
 -1,
 1647188875,
 2800,
 1647403575,
 1646182152,
 -1,
 1647469110,
 1647364059,
 -1,
 -40397,
 1647440896,
 2677,
 -40396,
 1647503636,
 2563,
 -40395,
 1647566562,
 2641,
 -1,
 1647582402,
 2561,
 -1,
 1647385483,
 2678,
 1647862330,
 1647339517,
 -1,
 -40391,
 1647825279,
 127928,
 -1,
 1647852804,
 129454,
 1648099327,
 1647780941,
 -1,
 -40388,
 1647985712,
 128130,
 -1,
 1648042802,
 8370,
 1648255556,
 1640536769,
 -1,
 1648321089,
 1648171594,
 -1,
 -40384,
 1648283638,
 128016,
 -1,
 1648327751,
 129349,
 -40382,
 1648278792,
 129421,
 -40381,
 1648460585,
 127948,
 -1,
 1648515730,
 129405,
 1648714312,
 1648194354,
 -1,
 1648779847,
 1648655419,
 128103,
 -1,
 1648738942,
 128714,
 -1,
 1648696748,
 129426,
 1648976459,
 1648630346,
 -1,
 -40374,
 1648934648,
 129476,
 -1,
 1648987279,
 127922,
 -40372,
 1648935380,
 983110,
 -1,
 1649108418,
 128123,
 1649304579,
 1599648738,
 -1,
 1649369826,
 1649240061,
 983153,
 1649435340,
 1649302288,
 -1,
 1649500819,
 1649404737,
 -1,
 1649566313,
 1649463286,
 -1,
 1649631847,
 1649523179,
 -1,
 1649697382,
 1649545146,
 -1,
 1649762916,
 1649616320,
 11106,
 1649868799,
 1649672192,
 -1,
 1649893986,
 1649798736,
 -1,
 1649959514,
 1649837685,
 -1,
 -40359,
 1649926963,
 11173,
 -1,
 1649951549,
 11175,
 1650156125,
 1649885465,
 -1,
 -40356,
 1650124809,
 983238,
 -1,
 1650156853,
 11132,
 -40354,
 1650124876,
 129074,
 -40353,
 1650299734,
 129058,
 -40352,
 1650363655,
 129062,
 -40351,
 1650417980,
 129070,
 -1,
 1650470340,
 129066,
 -40349,
 1649858288,
 11122,
 -1,
 1650632718,
 11138,
 -40347,
 1649715819,
 11142,
 -1,
 1650736286,
 11116,
 -1,
 1649606936,
 129170,
 -40344,
 1649602864,
 11246,
 -1,
 1650958831,
 129187,
 1651139197,
 1649485254,
 -1,
 1651204725,
 1651109456,
 -1,
 1651270254,
 1651168919,
 -1,
 -40339,
 1651237683,
 11023,
 -1,
 1651262269,
 11022,
 1651466865,
 1651231057,
 -1,
 -40336,
 1651431600,
 129026,
 -1,
 1651461396,
 129042,
 -40334,
 1651415161,
 129178,
 -40333,
 1651608866,
 129030,
 -40332,
 1651670523,
 129034,
 -1,
 1651723540,
 129046,
 1651925626,
 1651120714,
 -1,
 1651991161,
 1651846718,
 -1,
 -40328,
 1651955129,
 11084,
 -1,
 1651974205,
 11080,
 -1,
 1651938321,
 129974,
 1652293631,
 1651889372,
 -1,
 -40324,
 1652215590,
 11076,
 -1,
 1652251894,
 11075,
 1652449923,
 1651058951,
 -1,
 1652515457,
 1652391089,
 -1,
 -40320,
 1652438154,
 11146,
 -1,
 1652499904,
 11157,
 -40318,
 1652467041,
 129185,
 -1,
 1652628506,
 129193,
 1652843142,
 1652408788,
 -1,
 -40315,
 1652798169,
 129082,
 -1,
 1652826961,
 129106,
 1653039753,
 1652798434,
 -1,
 -40312,
 1652988843,
 128622,
 -1,
 1653042083,
 129189,
 1653236364,
 1652973860,
 -1,
 -40309,
 1653159716,
 129090,
 -1,
 1653220800,
 129094,
 1653432975,
 1653166579,
 -1,
 -40306,
 1653391256,
 129195,
 -1,
 1653436441,
 129078,
 -40304,
 1653402887,
 129174,
 -40303,
 1653584533,
 11078,
 -40302,
 1653637422,
 129191,
 -1,
 1653684004,
 129086,
 1653891779,
 1649410048,
 -1,
 1653957279,
 1653850580,
 -1,
 1654022811,
 1653910501,
 -1,
 1654088346,
 1653940051,
 128360,
 1654194175,
 1654000594,
 -1,
 -40295,
 1654117566,
 128362,
 -1,
 1654169583,
 128361,
 -1,
 1654015738,
 128489,
 -40292,
 1653989028,
 11779,
 -40291,
 1654352419,
 11815,
 -40290,
 1654411258,
 129931,
 -1,
 1654460544,
 10182,
 1654678185,
 1653919734,
 -1,
 1654743718,
 1654611388,
 -1,
 1654809252,
 1654699954,
 -1,
 -40285,
 1654764334,
 129930,
 -1,
 1654802918,
 129928,
 -40283,
 1654760943,
 128493,
 -1,
 1654944747,
 129987,
 1655177215,
 1654698978,
 -1,
 -40280,
 1655073034,
 129902,
 -1,
 1655120745,
 11786,
 1655333552,
 1654611406,
 -1,
 1655399087,
 1655276313,
 -1,
 -40276,
 1655357813,
 129971,
 -40275,
 1655409914,
 129933,
 -40274,
 1655461321,
 129978,
 -1,
 1655516356,
 11241,
 -1,
 1655346159,
 128381,
 1655792313,
 1655251237,
 -1,
 1655857846,
 1655724115,
 -1,
 1655923381,
 1655799615,
 -1,
 -40268,
 1655885562,
 11776,
 -1,
 1655914743,
 11777,
 -1,
 1655852360,
 128495,
 1656225791,
 1655782231,
 -1,
 -40264,
 1656152811,
 129918,
 -1,
 1656195066,
 129919,
 1656382140,
 1655741121,
 -1,
 -40261,
 1656335459,
 129980,
 -1,
 1656394985,
 129927,
 1656578751,
 1656307603,
 -1,
 -40258,
 1656544818,
 11817,
 -1,
 1656609356,
 11781,
 -40256,
 1656547248,
 11809,
 -40255,
 1656730900,
 11789,
 -40254,
 1656784704,
 11805,
 -1,
 1656837293,
 129929,
 1657077759,
 1653804882,
 -1,
 1657103049,
 1656967771,
 -1,
 1657168583,
 1657065305,
 4053,
 -1,
 1657081023,
 4055,
 -40248,
 1657099416,
 129308,
 -1,
 1657218405,
 1421,
 -40246,
 1657067280,
 8295,
 -40245,
 1657384767,
 128270,
 -1,
 1657429935,
 9957,
 1657627354,
 1649355410,
 127872,
 1657733119,
 1657536742,
 -1,
 1657758417,
 1657659734,
 -1,
 -40240,
 1657715367,
 11187,
 -1,
 1657765920,
 11186,
 1657955028,
 1657715373,
 -1,
 -40237,
 1657921875,
 11189,
 -1,
 1657946751,
 11191,
 1658151639,
 1657896997,
 -1,
 -40234,
 1658118483,
 11188,
 -1,
 1658143359,
 11190,
 1658388479,
 1658077828,
 -1,
 -40231,
 1658305191,
 11185,
 -1,
 1658355744,
 11184,
 1658544862,
 1657574896,
 128141,
 -40228,
 1658482377,
 128365,
 -40227,
 1658537845,
 129680,
 -1,
 1658587235,
 11824,
 1658807009,
 1658466725,
 -1,
 -40224,
 1658730675,
 127832,
 -1,
 1658792350,
 127833,
 -1,
 1658737957,
 129350,
 1659069271,
 1649296578,
 -1,
 1659134738,
 1659008891,
 -1,
 1659200256,
 1659077282,
 -1,
 1659265774,
 1659146912,
 -1,
 1659331305,
 1659237174,
 -1,
 -40216,
 1659271007,
 43333,
 -1,
 1659312714,
 43323,
 1659527916,
 1659263059,
 -1,
 -40213,
 1659459746,
 43331,
 -1,
 1659509322,
 43314,
 -40211,
 1659452416,
 43332,
 -1,
 1659640394,
 43317,
 1659855601,
 1659210060,
 -1,
 -40208,
 1659775288,
 43330,
 -1,
 1659837002,
 43320,
 -40206,
 1659827130,
 43327,
 -40205,
 1660021473,
 43328,
 -40204,
 1660080252,
 43315,
 -40203,
 1660142249,
 43324,
 -40202,
 1660204116,
 43325,
 -40201,
 1660267041,
 43318,
 -40200,
 1660320901,
 43326,
 -40199,
 1660385472,
 43312,
 -40198,
 1660450655,
 43322,
 -40197,
 1660509646,
 43329,
 -40196,
 1660573858,
 43313,
 -40195,
 1660632064,
 43316,
 -40194,
 1660694495,
 43321,
 -40193,
 1660758328,
 43319,
 -1,
 1660820042,
 43334,
 1661035276,
 1659168154,
 -1,
 1661100811,
 1660987722,
 -1,
 1661166341,
 1661027522,
 43337,
 -40188,
 1661131963,
 43341,
 -1,
 1661147722,
 43342,
 1661362952,
 1661082186,
 -1,
 -40185,
 1661328571,
 43340,
 -1,
 1661364221,
 43338,
 -40183,
 1661328571,
 43336,
 -40182,
 1661508289,
 43339,
 -1,
 1661560829,
 43335,
 -1,
 1661039432,
 43347,
 1661821713,
 1660958605,
 -1,
 1661887247,
 1661768352,
 43344,
 -1,
 1661818963,
 43343,
 -40176,
 1661842402,
 43345,
 -1,
 1661951420,
 43346,
 -1,
 1661781026,
 43359,
 1662214957,
 1659067318,
 -1,
 -40172,
 1662187077,
 127487,
 -40171,
 1662251830,
 127486,
 -40170,
 1662317104,
 127485,
 -40169,
 1662380705,
 127484,
 -40168,
 1662444954,
 127483,
 -40167,
 1662508219,
 127482,
 -40166,
 1662570486,
 127481,
 -40165,
 1662632404,
 127480,
 -40164,
 1662694370,
 127479,
 -40163,
 1662759438,
 127478,
 -40162,
 1662822864,
 127477,
 -40161,
 1662884545,
 127476,
 -40160,
 1662948000,
 127475,
 -40159,
 1663011148,
 127474,
 -40158,
 1663073339,
 127473,
 -40157,
 1663137888,
 127472,
 -40156,
 1663203137,
 127471,
 -40155,
 1663264765,
 127470,
 -40154,
 1663327676,
 127469,
 -40153,
 1663391827,
 127468,
 -40152,
 1663455731,
 127467,
 -40151,
 1663517890,
 127466,
 -40150,
 1663581013,
 127465,
 -40149,
 1663643560,
 127464,
 -40148,
 1663707399,
 127463,
 -1,
 1663769162,
 127462,
 1663984454,
 1662182810,
 -1,
 1664049989,
 1663913471,
 -1,
 1664115515,
 1663974231,
 -1,
 1664181043,
 1664079141,
 -1,
 -40142,
 1664147900,
 128402,
 -1,
 1664172793,
 128403,
 1664377654,
 1664136162,
 -1,
 -40139,
 1664314215,
 11262,
 -1,
 1664360109,
 128401,
 -40137,
 1664346292,
 128404,
 -40136,
 1664529287,
 11822,
 -40135,
 1664573326,
 128405,
 -40134,
 1664636402,
 11793,
 -1,
 1664693967,
 11841,
 1664942079,
 1664024576,
 -1,
 1664967487,
 1664865736,
 -1,
 -40130,
 1664924817,
 11079,
 -1,
 1664975250,
 11073,
 1665164098,
 1664910161,
 -1,
 -40127,
 1665111238,
 983151,
 -1,
 1665162023,
 128968,
 -40125,
 1665125115,
 10184,
 -40124,
 1665297891,
 983152,
 -1,
 1665348327,
 128639,
 -1,
 1663999453,
 128158,
 1665622859,
 1663946164,
 -1,
 1665688394,
 1665558952,
 -1,
 -40119,
 1665602347,
 9953,
 -1,
 1665667579,
 9952,
 -1,
 1665638792,
 128699,
 1665950543,
 1665544104,
 -1,
 -40115,
 1665906421,
 128665,
 -40114,
 1665966977,
 983112,
 -1,
 1666009633,
 129534,
 1666212690,
 1665915629,
 -1,
 -40111,
 1666169511,
 11153,
 -1,
 1666220064,
 11152,
 1666409301,
 1666136919,
 -1,
 -40108,
 1666341794,
 129511,
 -1,
 1666393123,
 127822,
 -40106,
 1666355100,
 127895,
 -1,
 1666548633,
 128524,
 1666737058,
 1659034811,
 -1,
 1666802570,
 1666682385,
 -1,
 1666868087,
 1666750967,
 -1,
 1666933602,
 1666830326,
 -1,
 1666999134,
 1666902689,
 -1,
 -40099,
 1666947788,
 69235,
 -1,
 1666993242,
 69226,
 1667195745,
 1666932156,
 -1,
 -40096,
 1667151799,
 69236,
 -1,
 1667200049,
 69227,
 -1,
 1667123937,
 69225,
 1667457897,
 1666892244,
 -1,
 1667523430,
 1667397284,
 -1,
 -40091,
 1667488908,
 69230,
 -1,
 1667498881,
 69239,
 1667760127,
 1667452900,
 -1,
 -40088,
 1667685516,
 69231,
 -1,
 1667695489,
 69240,
 1667916656,
 1667387891,
 -1,
 1667982189,
 1667865281,
 -1,
 -40084,
 1667949481,
 69237,
 -1,
 1668006163,
 69228,
 1668218879,
 1667917821,
 -1,
 -40081,
 1668146843,
 69238,
 -1,
 1668175927,
 69229,
 1668375411,
 1667864302,
 -1,
 -40078,
 1668340876,
 69233,
 -1,
 1668350849,
 69242,
 1668572022,
 1668303262,
 -1,
 -40075,
 1668543286,
 69232,
 -1,
 1668547457,
 69241,
 -1,
 1668521825,
 69234,
 1668834180,
 1666793197,
 -1,
 1668899707,
 1668796406,
 -1,
 -40070,
 1668870195,
 69217,
 -1,
 1668900383,
 69218,
 1669096318,
 1668858324,
 -1,
 -40067,
 1669035684,
 69221,
 -1,
 1669091300,
 69222,
 1669292929,
 1669026291,
 -1,
 -40064,
 1669244440,
 69219,
 -1,
 1669297642,
 69220,
 -40062,
 1669242649,
 69216,
 -40061,
 1669437166,
 69224,
 -1,
 1669482910,
 69223,
 1669726207,
 1668765503,
 -1,
 1669751689,
 1669635869,
 -1,
 -40057,
 1669714936,
 69245,
 -40056,
 1669772006,
 69244,
 -1,
 1669815945,
 69243,
 -1,
 1669717121,
 69246,
 1670079385,
 1666749088,
 -1,
 1670144918,
 1670015296,
 -1,
 1670210451,
 1670076288,
 -1,
 1670275984,
 1670126154,
 -1,
 -40049,
 1670205013,
 5880,
 -1,
 1670262696,
 5879,
 -40047,
 1670227079,
 5876,
 -40046,
 1670411334,
 5877,
 -1,
 1670465876,
 5878,
 -40044,
 1670169926,
 5874,
 -40043,
 1670619468,
 5875,
 -1,
 1670674528,
 5873,
 1670905855,
 1670091424,
 -1,
 -40040,
 1670803407,
 127933,
 -1,
 1670860074,
 127939,
 1671062432,
 1670040688,
 -1,
 -40037,
 1671031016,
 11251,
 -40036,
 1671092319,
 11256,
 -40035,
 1671152745,
 11255,
 -40034,
 1671214028,
 11253,
 -40033,
 1671272607,
 11252,
 -1,
 1671310392,
 11254,
 -40031,
 1670994375,
 127945,
 -1,
 1671441619,
 8381,
 1671652313,
 1666685633,
 -1,
 1671717818,
 1671596796,
 -1,
 1671783340,
 1671676372,
 -1,
 1671848875,
 1671709890,
 -1,
 1671914409,
 1671820009,
 -1,
 -40024,
 1671880612,
 65939,
 -1,
 1671897928,
 65936,
 -40022,
 1671875922,
 65944,
 -1,
 1672057390,
 65938,
 -1,
 1671785663,
 65941,
 1672307634,
 1671731740,
 -1,
 1672373168,
 1672237940,
 -1,
 -40017,
 1672336436,
 8583,
 -1,
 1672365604,
 8582,
 -40015,
 1672333537,
 8581,
 -1,
 1672519565,
 8584,
 1672700854,
 1672231765,
 -1,
 -40012,
 1672667662,
 65945,
 -40011,
 1672703245,
 65940,
 -1,
 1672760136,
 65942,
 -40009,
 1672667252,
 65937,
 -40008,
 1672917940,
 65943,
 -40007,
 1672950264,
 65947,
 -1,
 1673012840,
 65946,
 1673225158,
 1671684274,
 -1,
 1673290691,
 1673152401,
 -1,
 1673356223,
 1673250118,
 -1,
 -40002,
 1673321876,
 127588,
 -1,
 1673373080,
 127586,
 -40000,
 1673327304,
 127587,
 -39999,
 1673496803,
 127585,
 -39998,
 1673549883,
 127584,
 -1,
 1673605134,
 127589,
 1673854975,
 1673199616,
 -1,
 -39995,
 1673777548,
 128907,
 -1,
 1673834975,
 128205,
 1674011598,
 1673168164,
 -1,
 1674077132,
 1673938114,
 -1,
 1674142667,
 1674032100,
 -1,
 -39990,
 1674103083,
 128764,
 -1,
 1674131037,
 127906,
 -1,
 1674066918,
 128478,
 -39987,
 1674014606,
 129315,
 -1,
 1674315103,
 129531,
 1674535889,
 1673974181,
 -1,
 -39984,
 1674505528,
 11215,
 -1,
 1674544140,
 11213,
 1674732499,
 1674494972,
 127801,
 -1,
 1674697282,
 127989,
 1674863573,
 1674655008,
 129704,
 -1,
 1674792601,
 128640,
 -39978,
 1674832891,
 128675,
 -39977,
 1674945712,
 128019,
 -39976,
 1674980833,
 129302,
 -1,
 1675044587,
 127840,
 1675256828,
 1671567946,
 -1,
 1675322352,
 1675192317,
 -1,
 1675387883,
 1675281468,
 -1,
 1675453408,
 1675331916,
 -1,
 -39970,
 1675408404,
 127340,
 -39969,
 1675443130,
 127339,
 -1,
 1675505598,
 127338,
 1675715556,
 1675386718,
 9995,
 1675821055,
 1675627474,
 -1,
 -39965,
 1675733878,
 128406,
 -1,
 1675777107,
 128400,
 1675977702,
 1675640824,
 11827,
 -1,
 1675940385,
 11783,
 -39961,
 1675938756,
 11787,
 -39960,
 1676046665,
 11782,
 -39959,
 1676104856,
 9994,
 -39958,
 1676162767,
 11828,
 -1,
 1676224838,
 129306,
 1676436461,
 1675334304,
 9926,
 -1,
 1676357196,
 127752,
 1676607487,
 1676380475,
 -1,
 -39953,
 1676531717,
 128740,
 -1,
 1676554490,
 128643,
 1676764149,
 1675243432,
 -1,
 1676829684,
 1676701380,
 -1,
 -39949,
 1676775727,
 127949,
 -1,
 1676816634,
 127950,
 -1,
 1676752944,
 129437,
 1677091831,
 1676689188,
 128251,
 -1,
 1677001092,
 128280,
 1677222905,
 1677011588,
 128007,
 -1,
 1677132493,
 128048,
 -39942,
 1677195243,
 129682,
 -39941,
 1677316086,
 128000,
 -1,
 1677363532,
 128015,
 1677550593,
 1675197499,
 -1,
 -39938,
 1677499073,
 983226,
 -39937,
 1677560140,
 983221,
 -39936,
 1677617149,
 983231,
 -1,
 1677673666,
 983223,
 -39934,
 1677509076,
 983113,
 -1,
 1677812601,
 129423,
 1678009775,
 1649273505,
 -1,
 1678075091,
 1677924938,
 -1,
 1678140532,
 1678029794,
 -1,
 1678206067,
 1678058182,
 -1,
 1678271535,
 1678166509,
 -1,
 1678337037,
 1678242614,
 -1,
 1678402571,
 1678302395,
 71875,
 -1,
 1678341953,
 71886,
 -39924,
 1678351041,
 71877,
 -1,
 1678449226,
 71876,
 1678664723,
 1678269884,
 -1,
 1678730257,
 1678613185,
 -1,
 -39920,
 1678688365,
 71899,
 -1,
 1678738917,
 71898,
 -39918,
 1678669604,
 71897,
 -1,
 1678845005,
 71900,
 1679057943,
 1678580298,
 71873,
 -39915,
 1679020022,
 71893,
 -39914,
 1679070704,
 71882,
 -1,
 1679133004,
 71894,
 1679320091,
 1678984386,
 71880,
 1679425535,
 1679266464,
 -1,
 -39910,
 1679356726,
 71885,
 -1,
 1679397536,
 71888,
 1679582238,
 1679285435,
 -1,
 -39907,
 1679547579,
 71879,
 -1,
 1679568808,
 71887,
 1679778849,
 1679540692,
 -1,
 -39904,
 1679740749,
 71901,
 -1,
 1679780949,
 71902,
 1679975459,
 1679727297,
 71881,
 -1,
 1679899835,
 71889,
 1680106534,
 1679921824,
 -1,
 -39899,
 1680072943,
 71891,
 -1,
 1680103589,
 71872,
 -39897,
 1680076252,
 71874,
 -39896,
 1680271666,
 71903,
 -39895,
 1680333378,
 71890,
 -39894,
 1680388410,
 71896,
 -39893,
 1680440156,
 71884,
 -39892,
 1680501845,
 71878,
 -39891,
 1680562338,
 71883,
 -39890,
 1680620544,
 71892,
 -1,
 1680682768,
 71895,
 1680893015,
 1678192858,
 -1,
 1680958517,
 1680864054,
 -1,
 1681024051,
 1680923835,
 71843,
 -1,
 1680963393,
 71854,
 -39884,
 1680972481,
 71845,
 -1,
 1681070666,
 71844,
 1681286203,
 1680891324,
 -1,
 1681351737,
 1681234625,
 -1,
 -39880,
 1681309805,
 71867,
 -1,
 1681360357,
 71866,
 -39878,
 1681291044,
 71865,
 -1,
 1681466445,
 71868,
 1681679423,
 1681201738,
 71841,
 -39875,
 1681641462,
 71861,
 -39874,
 1681692144,
 71850,
 -1,
 1681754444,
 71862,
 1681941571,
 1681605826,
 71848,
 1682046975,
 1681887904,
 -1,
 -39870,
 1681978166,
 71853,
 -1,
 1682018976,
 71856,
 1682203718,
 1681906875,
 -1,
 -39867,
 1682169019,
 71847,
 -1,
 1682190248,
 71855,
 1682400329,
 1682162132,
 -1,
 -39864,
 1682362189,
 71869,
 -1,
 1682402389,
 71870,
 1682596939,
 1682348737,
 71849,
 -1,
 1682521275,
 71857,
 1682728014,
 1682543264,
 -1,
 -39859,
 1682694383,
 71859,
 -1,
 1682725029,
 71840,
 -39857,
 1682697692,
 71842,
 -39856,
 1682893106,
 71871,
 -39855,
 1682954818,
 71858,
 -39854,
 1683009850,
 71864,
 -39853,
 1683061596,
 71852,
 -39852,
 1683123285,
 71846,
 -39851,
 1683183778,
 71851,
 -39850,
 1683241984,
 71860,
 -1,
 1683304208,
 71863,
 1683514469,
 1680817901,
 -1,
 1683579995,
 1683476470,
 -1,
 -39846,
 1683550259,
 71906,
 -1,
 1683580447,
 71907,
 1683776606,
 1683538388,
 -1,
 -39843,
 1683715748,
 71910,
 -1,
 1683771364,
 71911,
 1683973217,
 1683706355,
 -1,
 -39840,
 1683924504,
 71908,
 -1,
 1683977706,
 71909,
 -39838,
 1683945264,
 71904,
 -39837,
 1684119321,
 71905,
 -39836,
 1684182766,
 71913,
 -1,
 1684228510,
 71912,
 1684431986,
 1683462647,
 -1,
 1684497514,
 1684393974,
 -1,
 -39832,
 1684466769,
 71915,
 -39831,
 1684497319,
 71916,
 -1,
 1684556513,
 71914,
 1684759661,
 1684455892,
 -1,
 -39828,
 1684698860,
 71919,
 -1,
 1684754497,
 71920,
 1684956272,
 1684689395,
 -1,
 -39825,
 1684907117,
 71917,
 -1,
 1684957856,
 71918,
 -39823,
 1684903710,
 71922,
 -1,
 1685080575,
 71921,
 -1,
 1684381163,
 71935,
 -1,
 1678153548,
 9888,
 1685415105,
 1678086816,
 -1,
 1685480638,
 1685336970,
 -1,
 1685546154,
 1685422754,
 -1,
 1685611645,
 1685461578,
 123585,
 1685677179,
 1685527114,
 123584,
 1685782527,
 1685623456,
 123624,
 -1,
 1685674067,
 123619,
 -39812,
 1685642427,
 123606,
 -1,
 1685820912,
 123620,
 1686004866,
 1685573622,
 -1,
 -39809,
 1685963433,
 123616,
 -39808,
 1686025300,
 123617,
 -39807,
 1686068686,
 123596,
 -1,
 1686116938,
 123595,
 1686332549,
 1685953217,
 123605,
 1686437887,
 1686278816,
 123622,
 -1,
 1686329427,
 123618,
 1686529161,
 1686278816,
 -1,
 -39801,
 1686500282,
 123625,
 -39800,
 1686526114,
 123613,
 -1,
 1686575690,
 123593,
 1686791308,
 1686500150,
 -1,
 -39797,
 1686727762,
 123627,
 -1,
 1686772298,
 123590,
 1686987918,
 1686756539,
 123614,
 -1,
 1686915809,
 123626,
 1687118993,
 1686946260,
 -1,
 -39792,
 1687051726,
 123599,
 -1,
 1687099978,
 123598,
 1687315604,
 1687071184,
 -1,
 -39789,
 1687248334,
 123591,
 -1,
 1687296586,
 123594,
 1687512215,
 1687256123,
 -1,
 -39786,
 1687454523,
 123615,
 -1,
 1687493194,
 123592,
 1687708826,
 1687451744,
 -1,
 -39783,
 1687641550,
 123609,
 -1,
 1687689802,
 123604,
 1687905436,
 1687644157,
 123612,
 -1,
 1687852528,
 123621,
 1688036510,
 1687831746,
 123611,
 -1,
 1687982752,
 123623,
 -39777,
 1688008307,
 123601,
 -39776,
 1688136417,
 123602,
 -39775,
 1688200621,
 123603,
 -39774,
 1688253524,
 123607,
 -39773,
 1688308130,
 123608,
 -39772,
 1688368991,
 123600,
 -39771,
 1688427982,
 123610,
 -39770,
 1688492194,
 123589,
 -39769,
 1688556104,
 123597,
 -39768,
 1688615936,
 123588,
 -39767,
 1688678367,
 123587,
 -1,
 1688742200,
 123586,
 1688954040,
 1685470957,
 -1,
 1689019566,
 1688915958,
 -1,
 -39763,
 1688989747,
 123634,
 -1,
 1689019935,
 123635,
 1689216177,
 1688977876,
 -1,
 -39760,
 1689155236,
 123638,
 -1,
 1689210852,
 123639,
 1689412788,
 1689145843,
 -1,
 -39757,
 1689363992,
 123636,
 -1,
 1689417194,
 123637,
 -39755,
 1689384752,
 123632,
 -39754,
 1689558809,
 123633,
 -39753,
 1689622254,
 123641,
 -1,
 1689667998,
 123640,
 1689871549,
 1688917826,
 -1,
 1689937083,
 1689836239,
 123628,
 -1,
 1689884323,
 123629,
 1690107903,
 1689877352,
 123630,
 -1,
 1690015395,
 123631,
 -1,
 1689818772,
 123647,
 1690304511,
 1685417668,
 -1,
 -39744,
 1690196861,
 127766,
 -1,
 1690253555,
 127768,
 1690461384,
 1685377743,
 -1,
 1690526919,
 1690370048,
 -1,
 -39740,
 1690495931,
 127754,
 -39739,
 1690546050,
 129341,
 -39738,
 1690580489,
 128702,
 -1,
 1690644251,
 128003,
 -1,
 1690471807,
 127817,
 1690920142,
 1690428826,
 -1,
 1690985677,
 1690857156,
 -1,
 -39733,
 1690955053,
 127987,
 -39732,
 1690984324,
 128075,
 -1,
 1691036843,
 127988,
 -1,
 1690911951,
 11071,
 1691313361,
 1690890971,
 -1,
 -39728,
 1691245437,
 127764,
 -1,
 1691302131,
 127762,
 -39726,
 1691274541,
 128465,
 -1,
 1691439952,
 129479,
 1691641169,
 1678007740,
 -1,
 1691706703,
 1691579774,
 -1,
 1691772160,
 1691627432,
 -1,
 1691837695,
 1691705854,
 -1,
 1691903209,
 1691777120,
 -1,
 1691968742,
 1691850436,
 -1,
 1692034274,
 1691879648,
 -1,
 1692099807,
 1691996150,
 -1,
 1692165342,
 1692070095,
 -1,
 -39715,
 1692130229,
 129584,
 -1,
 1692190006,
 129591,
 -1,
 1692100276,
 129605,
 -39712,
 1692049261,
 129563,
 -39711,
 1692374821,
 129549,
 -1,
 1692423723,
 129542,
 1692663807,
 1691946834,
 -1,
 -39708,
 1692581817,
 129615,
 -39707,
 1692644171,
 129614,
 -1,
 1692675162,
 129616,
 1692925951,
 1691905986,
 -1,
 -39704,
 1692851290,
 129587,
 -1,
 1692899109,
 129545,
 1693082865,
 1691867891,
 -1,
 1693148397,
 1693022304,
 -1,
 -39700,
 1693095620,
 129570,
 -1,
 1693150912,
 129566,
 -39698,
 1693106105,
 129568,
 -39697,
 1693299531,
 129567,
 -39696,
 1693363133,
 129571,
 -1,
 1693396058,
 129569,
 1693607156,
 1693040574,
 -1,
 -39693,
 1693572186,
 129589,
 -1,
 1693620005,
 129547,
 1693803767,
 1693561691,
 -1,
 -39690,
 1693768794,
 129588,
 -1,
 1693816613,
 129546,
 1694000378,
 1693756354,
 -1,
 -39687,
 1693965402,
 129592,
 -1,
 1694013221,
 129550,
 1694196988,
 1693928713,
 129608,
 -1,
 1694107882,
 129611,
 1694367743,
 1694116961,
 -1,
 -39682,
 1694293082,
 129590,
 -1,
 1694340901,
 129548,
 -1,
 1691775828,
 128906,
 1694590222,
 1691730388,
 -1,
 1694655750,
 1694556233,
 127779,
 1694760959,
 1694564352,
 -1,
 1694786821,
 1694640864,
 127781,
 -1,
 1694699129,
 127782,
 -1,
 1694756673,
 127780,
 1694983435,
 1694610123,
 -1,
 1695048970,
 1694906361,
 -1,
 -39671,
 1695017072,
 128916,
 -1,
 1695059220,
 128917,
 -1,
 1694969724,
 128307,
 1695350783,
 1694927501,
 -1,
 -39667,
 1695272185,
 11090,
 -1,
 1695320111,
 11051,
 1695507738,
 1694514005,
 -1,
 1695573268,
 1695443140,
 -1,
 1695638803,
 1695496185,
 -1,
 -39662,
 1695606877,
 128922,
 -1,
 1695649003,
 128923,
 -1,
 1695575394,
 9931,
 1695900951,
 1695528432,
 -1,
 -39658,
 1695845112,
 9920,
 -1,
 1695906524,
 9921,
 1696137215,
 1695852900,
 -1,
 -39655,
 1696039040,
 128407,
 -1,
 1696082259,
 128071,
 1696294180,
 1695440316,
 -1,
 1696359714,
 1696220354,
 -1,
 1696425249,
 1696275018,
 -1,
 1696490784,
 1696393879,
 -1,
 -39649,
 1696449318,
 129984,
 -1,
 1696477916,
 9989,
 -1,
 1696448718,
 129293,
 -1,
 1696395862,
 11041,
 -39645,
 1696310215,
 11053,
 -1,
 1696736466,
 128427,
 1696949548,
 1696234555,
 -1,
 1697015080,
 1696876724,
 -1,
 -39641,
 1696968442,
 128072,
 -1,
 1697021339,
 9945,
 1697211691,
 1696930378,
 -1,
 -39638,
 1697175129,
 128326,
 -1,
 1697233286,
 11036,
 -1,
 1697163690,
 128928,
 1697473842,
 1696911350,
 -1,
 1697539376,
 1697428450,
 -1,
 -39633,
 1697474787,
 10177,
 -1,
 1697522674,
 9186,
 -39631,
 1697509721,
 9943,
 -1,
 1697687004,
 128382,
 1697867064,
 1697417548,
 -1,
 1697932599,
 1697794012,
 -1,
 -39627,
 1697893625,
 11088,
 -39626,
 1697941551,
 11048,
 -1,
 1697988274,
 11046,
 -1,
 1697882519,
 11229,
 1698260286,
 1697796595,
 -1,
 1698325821,
 1698200635,
 -1,
 1698391356,
 1698242011,
 9872,
 -1,
 1698303345,
 9983,
 -1,
 1698343253,
 128174,
 -1,
 1698276996,
 11214,
 1698653505,
 1698228008,
 -1,
 -39616,
 1698624385,
 11038,
 -1,
 1698682205,
 11055,
 1698850116,
 1698619731,
 -1,
 -39613,
 1698762843,
 129994,
 -1,
 1698826357,
 128070,
 1699046727,
 1698806439,
 -1,
 -39610,
 1698959469,
 11092,
 -1,
 1699022965,
 128073,
 1699243338,
 1698999349,
 -1,
 -39607,
 1699205322,
 11040,
 -1,
 1699255113,
 127985,
 1699439949,
 1699161557,
 -1,
 -39604,
 1699404929,
 129197,
 -1,
 1699454745,
 129196,
 -39602,
 1699394453,
 10068,
 -1,
 1699565805,
 10069,
 -39600,
 1691633679,
 9855,
 -1,
 1699684270,
 128011,
 1699898768,
 1691576317,
 -1,
 1699964293,
 1699822896,
 -1,
 1700029792,
 1699924782,
 -1,
 1700095322,
 1699998838,
 -1,
 -39594,
 1700063286,
 129159,
 -39593,
 1700105433,
 129143,
 -39592,
 1700168660,
 129127,
 -39591,
 1700225323,
 129151,
 -1,
 1700276752,
 129135,
 1700528127,
 1700021842,
 -1,
 -39588,
 1700456502,
 129158,
 -39587,
 1700498649,
 129142,
 -39586,
 1700561876,
 129126,
 -39585,
 1700618539,
 129150,
 -1,
 1700669968,
 129134,
 1700881773,
 1699977278,
 -1,
 1700947303,
 1700850806,
 -1,
 -39581,
 1700915254,
 129156,
 -39580,
 1700957401,
 129140,
 -39579,
 1701020628,
 129124,
 -39578,
 1701077291,
 129148,
 -1,
 1701128720,
 129132,
 1701380095,
 1700873810,
 -1,
 -39575,
 1701308470,
 129157,
 -39574,
 1701350617,
 129141,
 -39573,
 1701413844,
 129125,
 -39572,
 1701470507,
 129149,
 -1,
 1701521936,
 129133,
 1701733747,
 1700848443,
 -1,
 -39569,
 1701701686,
 129153,
 -39568,
 1701743833,
 129137,
 -39567,
 1701807060,
 129121,
 -39566,
 1701863723,
 129145,
 -1,
 1701915152,
 129129,
 1702126969,
 1701690485,
 -1,
 -39563,
 1702094902,
 129154,
 -39562,
 1702137049,
 129138,
 -39561,
 1702200276,
 129122,
 -39560,
 1702256939,
 129146,
 -1,
 1702308368,
 129130,
 1702520191,
 1702068600,
 -1,
 -39557,
 1702488118,
 129152,
 -39556,
 1702530265,
 129136,
 -39555,
 1702593492,
 129120,
 -39554,
 1702650155,
 129144,
 -1,
 1702701584,
 129128,
 1702952959,
 1702445895,
 -1,
 -39551,
 1702881334,
 129155,
 -39550,
 1702923481,
 129139,
 -39549,
 1702986708,
 129123,
 -39548,
 1703043371,
 129147,
 -1,
 1703094800,
 129131,
 1703306637,
 1699910304,
 -1,
 1703372171,
 1703230293,
 -1,
 1703437706,
 1703280640,
 -1,
 -39543,
 1703359332,
 127888,
 -1,
 1703423324,
 127788,
 -1,
 1703389426,
 129695,
 -39540,
 1703312107,
 128521,
 -1,
 1703626011,
 127863,
 -39538,
 1703262089,
 128430,
 -39537,
 1703774340,
 129344,
 -1,
 1703828143,
 11838,
 1704027553,
 1699846849,
 -1,
 1704093082,
 1703971148,
 -1,
 1704158617,
 1704010021,
 128105,
 1704224152,
 1704116694,
 -1,
 -39531,
 1704182616,
 128097,
 -39530,
 1704222798,
 128082,
 -39529,
 1704277556,
 128090,
 -1,
 1704340955,
 128098,
 -1,
 1704135659,
 128111,
 -1,
 1704086497,
 128698,
 1704682911,
 1704047586,
 -1,
 -39524,
 1704639081,
 128543,
 -39523,
 1704692044,
 129713,
 -39522,
 1704754938,
 128506,
 -1,
 1704803235,
 11825,
 -39520,
 1704631247,
 129717,
 -1,
 1704952605,
 128058,
 1705141673,
 1703953602,
 -1,
 1705207205,
 1705076733,
 -1,
 -39516,
 1705139014,
 127947,
 -1,
 1705201156,
 983234,
 1705403816,
 1705125450,
 -1,
 -39513,
 1705333323,
 128553,
 -1,
 1705390383,
 128576,
 -1,
 1705327820,
 128146,
 1705665966,
 1705096162,
 -1,
 1705731501,
 1705592002,
 -1,
 -39508,
 1705692555,
 129340,
 -1,
 1705743261,
 128295,
 -1,
 1705649173,
 127873,
 -1,
 1705604929,
 983229,
 1706059453,
 1677944829,
 -1,
 1706124931,
 1706005152,
 -1,
 1706190355,
 1706048341,
 983129,
 1706255890,
 1706125309,
 -1,
 1706321425,
 1706176453,
 -1,
 1706386952,
 1706269175,
 -1,
 1706452422,
 1706348534,
 -1,
 1706517949,
 1706420897,
 -1,
 1706583483,
 1706465985,
 126066,
 1706688511,
 1706491904,
 -1,
 -39494,
 1706611764,
 126093,
 -1,
 1706649458,
 126084,
 1706885119,
 1706511450,
 126075,
 -1,
 1706756631,
 126102,
 1706976708,
 1706450364,
 -1,
 1707042242,
 1706932142,
 126067,
 1707147263,
 1706950656,
 -1,
 -39487,
 1707070516,
 126094,
 -1,
 1707108210,
 126085,
 1707343871,
 1706980401,
 126076,
 -1,
 1707215383,
 126103,
 1707474943,
 1706904289,
 126074,
 -1,
 1707346455,
 126101,
 1707566547,
 1706410452,
 -1,
 1707632077,
 1707505316,
 126070,
 1707697610,
 1707596940,
 126079,
 -1,
 1707608599,
 126106,
 1707868159,
 1707606016,
 -1,
 -39476,
 1707791412,
 126097,
 -1,
 1707829106,
 126088,
 1708064767,
 1707560932,
 126071,
 1708090832,
 1707990156,
 126080,
 -1,
 1708001815,
 126107,
 1708261375,
 1707999232,
 -1,
 -39470,
 1708184628,
 126098,
 -1,
 1708222322,
 126089,
 1708418530,
 1707495923,
 -1,
 1708484059,
 1708366529,
 -1,
 1708549593,
 1708450726,
 126068,
 1708654591,
 1708457984,
 -1,
 -39464,
 1708577844,
 126095,
 -1,
 1708615538,
 126086,
 1708851199,
 1708507411,
 126077,
 -1,
 1708722711,
 126104,
 1708982271,
 1708419069,
 -1,
 1709008352,
 1708910220,
 126069,
 1709113343,
 1708916736,
 -1,
 -39457,
 1709036596,
 126096,
 -1,
 1709074290,
 126087,
 1709309951,
 1708939319,
 126078,
 -1,
 1709181463,
 126105,
 1709401583,
 1708372079,
 -1,
 1709467110,
 1709363190,
 -1,
 -39451,
 1709436979,
 126116,
 -1,
 1709467167,
 126117,
 1709663721,
 1709425108,
 -1,
 -39448,
 1709602468,
 126120,
 -1,
 1709658084,
 126121,
 1709860332,
 1709593075,
 -1,
 -39445,
 1709811224,
 126118,
 -1,
 1709864426,
 126119,
 -39443,
 1709809433,
 126115,
 -39442,
 1710003950,
 126123,
 -1,
 1710049694,
 126122,
 1710253557,
 1709348590,
 126073,
 1710319090,
 1710218380,
 126082,
 -1,
 1710230039,
 126109,
 1710489599,
 1710227456,
 -1,
 -39436,
 1710412852,
 126100,
 -1,
 1710450546,
 126091,
 1710646779,
 1710180766,
 126072,
 1710712312,
 1710617398,
 126081,
 -1,
 1710623255,
 126108,
 1710882815,
 1710620672,
 -1,
 -39430,
 1710806068,
 126099,
 -1,
 1710843762,
 126090,
 1711039999,
 1710595865,
 126065,
 1711144959,
 1710948352,
 -1,
 -39426,
 1711068212,
 126092,
 -1,
 1711105906,
 126083,
 1711302148,
 1710956671,
 -1,
 1711367683,
 1711263734,
 -1,
 -39422,
 1711337523,
 126130,
 -1,
 1711360816,
 126131,
 -1,
 1711316761,
 126129,
 1711629830,
 1711242582,
 126110,
 -1,
 1711546661,
 126111,
 1711800319,
 1711569254,
 126113,
 -1,
 1711677733,
 126114,
 1711891981,
 1706317631,
 -1,
 1711957516,
 1711841053,
 -1,
 -39413,
 1711911654,
 126125,
 -1,
 1711955593,
 126126,
 -1,
 1711920303,
 126127,
 -39410,
 1711849857,
 126128,
 -39409,
 1712172482,
 126124,
 -39408,
 1712225627,
 126112,
 -1,
 1712267402,
 126132,
 -1,
 1706238252,
 8377,
 -1,
 1706184909,
 983128,
 1712612960,
 1706148845,
 -1,
 1712678460,
 1712570601,
 -1,
 1712743984,
 1712620194,
 -1,
 1712809499,
 1712701908,
 -1,
 1712875034,
 1712724554,
 -1,
 -39399,
 1712819564,
 68430,
 -1,
 1712864841,
 68433,
 -1,
 1712808787,
 68436,
 1713137182,
 1712771062,
 -1,
 -39395,
 1713065674,
 68424,
 -1,
 1713121445,
 68437,
 1713333792,
 1713070207,
 68420,
 -1,
 1713296205,
 68423,
 1713464867,
 1713248842,
 -1,
 -39390,
 1713435901,
 68431,
 -1,
 1713472107,
 68416,
 -39388,
 1713436419,
 68422,
 -39387,
 1713632702,
 68425,
 -39386,
 1713695697,
 68421,
 -39385,
 1713748138,
 68435,
 -39384,
 1713812095,
 68434,
 -39383,
 1713875941,
 68432,
 -39382,
 1713936947,
 68429,
 -39381,
 1713999237,
 68428,
 -39380,
 1714060674,
 68427,
 -39379,
 1714125116,
 68426,
 -39378,
 1714183088,
 68418,
 -39377,
 1714240594,
 68419,
 -1,
 1714301774,
 68417,
 1714552831,
 1712691703,
 -1,
 1714578999,
 1714474998,
 -1,
 1714644533,
 1714547361,
 -1,
 -39372,
 1714592449,
 68441,
 -1,
 1714637914,
 68445,
 -39370,
 1714578975,
 68442,
 -1,
 1714768609,
 68444,
 1714972219,
 1714528025,
 68440,
 1715077119,
 1714880512,
 -1,
 -39366,
 1715000372,
 68447,
 -1,
 1715038066,
 68446,
 -1,
 1714902642,
 68443,
 1715339263,
 1712612346,
 -1,
 1715365460,
 1715241634,
 -1,
 1715430979,
 1715323348,
 -1,
 1715496514,
 1715345994,
 -1,
 -39359,
 1715441004,
 68462,
 -1,
 1715486281,
 68464,
 -1,
 1715430227,
 68465,
 1715758662,
 1715392502,
 -1,
 -39355,
 1715687114,
 68456,
 -1,
 1715742885,
 68466,
 1715955272,
 1715691647,
 68452,
 -1,
 1715917645,
 68455,
 -39351,
 1715926787,
 68454,
 -39350,
 1716057534,
 68457,
 -39349,
 1716120543,
 68453,
 -39348,
 1716169701,
 68463,
 -39347,
 1716230707,
 68461,
 -39346,
 1716293001,
 68460,
 -39345,
 1716354434,
 68459,
 -39344,
 1716418876,
 68458,
 -39343,
 1716476848,
 68450,
 -39342,
 1716534354,
 68451,
 -39341,
 1716595534,
 68449,
 -1,
 1716658121,
 68448,
 1716912127,
 1715313143,
 -1,
 1716938331,
 1716834294,
 -1,
 1717003865,
 1716906657,
 -1,
 -39336,
 1716951745,
 68473,
 -1,
 1716997210,
 68477,
 -39334,
 1716938271,
 68474,
 -1,
 1717127905,
 68476,
 1717331551,
 1716887321,
 68472,
 1717436415,
 1717239808,
 -1,
 -39330,
 1717359668,
 68479,
 -1,
 1717397362,
 68478,
 -1,
 1717261938,
 68475,
 1717659247,
 1712579994,
 -1,
 1717724782,
 1717587242,
 -1,
 1717790312,
 1717686798,
 -1,
 1717855845,
 1717733173,
 11845,
 -1,
 1717767653,
 11846,
 -39322,
 1717821635,
 8276,
 -39321,
 1717939369,
 9959,
 -1,
 1717989726,
 11800,
 1718222847,
 1717748735,
 -1,
 1718249068,
 1718104790,
 -1,
 -39317,
 1718177082,
 129942,
 -1,
 1718224058,
 129969,
 -39315,
 1718193402,
 129936,
 -1,
 1718371248,
 129972,
 -1,
 1717662846,
 8292,
 1718642294,
 1717613043,
 -1,
 1718707828,
 1718582879,
 -1,
 -39310,
 1718667786,
 128289,
 -39309,
 1718715109,
 128292,
 -1,
 1718759658,
 128288,
 -39307,
 1718669282,
 128291,
 -1,
 1718917652,
 128290,
 1719101054,
 1718572549,
 -1,
 1719166589,
 1719059609,
 -1,
 1719232123,
 1719128054,
 -1,
 -39302,
 1719201843,
 983111,
 -1,
 1719232031,
 983108,
 -39300,
 1719181081,
 983114,
 -1,
 1719359090,
 983105,
 -1,
 1719090701,
 128129,
 1719625345,
 1719021480,
 -1,
 -39296,
 1719580377,
 128474,
 -1,
 1719639642,
 128232,
 -39294,
 1719587539,
 9892,
 -1,
 1719742050,
 128229,
 1719953069,
 1706070359,
 128127,
 1720057855,
 1719881118,
 -1,
 1720084128,
 1719960226,
 -1,
 1720149643,
 1720041940,
 -1,
 1720215178,
 1720064586,
 -1,
 -39287,
 1720159596,
 67662,
 -1,
 1720204873,
 67665,
 -1,
 1720148819,
 67668,
 1720477326,
 1720111094,
 -1,
 -39283,
 1720405706,
 67656,
 -1,
 1720461477,
 67669,
 1720673936,
 1720410239,
 67652,
 -1,
 1720636237,
 67655,
 1720805011,
 1720588874,
 -1,
 -39278,
 1720775933,
 67663,
 -1,
 1720812139,
 67648,
 -39276,
 1720776451,
 67654,
 -39275,
 1720972734,
 67657,
 -39274,
 1721035729,
 67653,
 -39273,
 1721088170,
 67667,
 -39272,
 1721152127,
 67666,
 -39271,
 1721215973,
 67664,
 -39270,
 1721276979,
 67661,
 -39269,
 1721339269,
 67660,
 -39268,
 1721400706,
 67659,
 -39267,
 1721465148,
 67658,
 -39266,
 1721523120,
 67650,
 -39265,
 1721580626,
 67651,
 -1,
 1721641806,
 67649,
 1721853612,
 1720031735,
 -1,
 1721919144,
 1721815030,
 -1,
 1721984677,
 1721887393,
 -1,
 -39260,
 1721932481,
 67673,
 -1,
 1721977946,
 67676,
 1722181287,
 1721912033,
 67675,
 -1,
 1722092055,
 67679,
 -1,
 1722115615,
 67674,
 1722417151,
 1721868057,
 67672,
 1722482687,
 1722286080,
 -1,
 -39253,
 1722405940,
 67678,
 -1,
 1722443634,
 67677,
 -1,
 1721812015,
 67671,
 1722705589,
 1719877035,
 -1,
 1722771121,
 1722666998,
 -1,
 -39248,
 1722740787,
 119667,
 -1,
 1722770975,
 119668,
 1722967732,
 1722700275,
 -1,
 -39245,
 1722918424,
 119669,
 -1,
 1722971626,
 119670,
 -1,
 1722916633,
 119666,
 1723229883,
 1722626469,
 -1,
 1723295417,
 1723150248,
 -1,
 -39240,
 1723260355,
 129482,
 -1,
 1723315908,
 127848,
 -39238,
 1723255083,
 9976,
 -1,
 1723425844,
 127954,
 -39236,
 1723201182,
 127982,
 -1,
 1723532406,
 129311,
 1723754359,
 1706024123,
 -1,
 1723819841,
 1723705808,
 -1,
 1723885314,
 1723772110,
 -1,
 1723950808,
 1723841197,
 -1,
 1724016340,
 1723870535,
 -1,
 1724081873,
 1723982385,
 -1,
 1724147399,
 1724026491,
 -1,
 -39227,
 1724103335,
 129877,
 -39226,
 1724157607,
 129895,
 -1,
 1724199382,
 129876,
 1724409548,
 1724088537,
 -1,
 1724475083,
 1724352408,
 -1,
 -39222,
 1724419751,
 129893,
 -1,
 1724461526,
 129878,
 -1,
 1724441304,
 129891,
 1724776447,
 1724330469,
 -1,
 1724802768,
 1724680088,
 -1,
 -39217,
 1724758695,
 129894,
 -1,
 1724812967,
 129892,
 -1,
 1724768984,
 129890,
 1725104127,
 1724024779,
 -1,
 -39213,
 1725020839,
 129875,
 -1,
 1725051350,
 129874,
 1725261527,
 1723977718,
 -1,
 -39210,
 1725217286,
 129949,
 -1,
 1725274842,
 129945,
 -1,
 1725220277,
 128319,
 1725523695,
 1723891749,
 -1,
 1725589228,
 1725443399,
 -1,
 1725654761,
 1725532056,
 -1,
 1725720287,
 1725599377,
 -1,
 -39203,
 1725676199,
 129882,
 -39202,
 1725730471,
 129884,
 -1,
 1725772246,
 129881,
 1725982436,
 1725661401,
 -1,
 1726047971,
 1725948465,
 -1,
 -39198,
 1725992615,
 129888,
 -1,
 1726034390,
 129883,
 -1,
 1725990887,
 129886,
 1726349311,
 1725903333,
 -1,
 1726375656,
 1726276145,
 -1,
 -39193,
 1726331559,
 129889,
 -1,
 1726385831,
 129887,
 -1,
 1726318567,
 129885,
 1726676991,
 1725620924,
 -1,
 -39189,
 1726593703,
 129880,
 -1,
 1726624214,
 129879,
 1726873599,
 1725550582,
 -1,
 -39186,
 1726790150,
 129948,
 -1,
 1726847724,
 129944,
 1727031030,
 1725440362,
 -1,
 1727096565,
 1726970939,
 -1,
 1727162100,
 1727048026,
 -1,
 -39181,
 1727125806,
 129946,
 -1,
 1727176501,
 129920,
 -1,
 1727088825,
 129898,
 -1,
 1727052468,
 129896,
 1727489787,
 1726992374,
 -1,
 1727555322,
 1727424036,
 -1,
 -39175,
 1727509294,
 129925,
 -1,
 1727547878,
 129923,
 -1,
 1727511069,
 129901,
 1727817471,
 1727422094,
 -1,
 -39171,
 1727761658,
 129934,
 -39170,
 1727820177,
 129938,
 -1,
 1727868189,
 129937,
 -39168,
 1727776026,
 129926,
 -39167,
 1728028637,
 129922,
 -1,
 1728074925,
 129924,
 1728276275,
 1723853633,
 -1,
 1728341784,
 1728237558,
 -1,
 1728407319,
 1728297451,
 -1,
 1728472854,
 1728319418,
 -1,
 1728538388,
 1728390592,
 11105,
 1728643071,
 1728446464,
 -1,
 1728669458,
 1728573008,
 -1,
 1728734988,
 1728611957,
 -1,
 -39157,
 1728691306,
 11171,
 -1,
 1728741742,
 11170,
 -39155,
 1728702540,
 129073,
 -39154,
 1728877398,
 129057,
 -39153,
 1728941319,
 129061,
 -39152,
 1728995644,
 129069,
 -39151,
 1729053158,
 11131,
 -1,
 1729113540,
 129065,
 -39149,
 1728632560,
 11121,
 -1,
 1729266114,
 11137,
 -39147,
 1728490091,
 11141,
 -1,
 1729379486,
 11115,
 -1,
 1728381208,
 129169,
 -1,
 1728377136,
 11245,
 1729718052,
 1728256586,
 -1,
 1729783587,
 1729675402,
 -1,
 1729849122,
 1729752656,
 -1,
 1729914654,
 1729808721,
 -1,
 -39139,
 1729878192,
 129025,
 -1,
 1729907988,
 129041,
 -39137,
 1729861753,
 129177,
 -39136,
 1730055458,
 129029,
 -39135,
 1730117115,
 129033,
 -1,
 1730170132,
 129045,
 -1,
 1729765901,
 129976,
 -1,
 1729729451,
 11797,
 1730504487,
 1729686778,
 -1,
 -39130,
 1730473906,
 129173,
 -1,
 1730500512,
 11192,
 1730701098,
 1730462164,
 -1,
 -39127,
 1730654937,
 129081,
 -1,
 1730683729,
 129105,
 1730897709,
 1730634020,
 -1,
 -39124,
 1730819876,
 129089,
 -1,
 1730880960,
 129093,
 1731094320,
 1730817163,
 -1,
 -39121,
 1731015818,
 11145,
 -1,
 1731077568,
 11014,
 -39119,
 1731051343,
 128621,
 -39118,
 1731220545,
 129077,
 -1,
 1731278628,
 129085,
 1731487546,
 1728188496,
 -1,
 1731553079,
 1731447121,
 -1,
 -39114,
 1731508118,
 128316,
 -1,
 1731534493,
 128744,
 -39112,
 1731508118,
 128314,
 -39111,
 1731694441,
 128742,
 -1,
 1731731101,
 128743,
 1731946304,
 1731395584,
 -1,
 1732011839,
 1731871364,
 -1,
 -39107,
 1731975414,
 11109,
 -39106,
 1732035444,
 129113,
 -1,
 1732062354,
 11021,
 -1,
 1731929587,
 11193,
 -1,
 1731905440,
 128579,
 1732405098,
 1723750753,
 -1,
 1732470633,
 1732346530,
 -1,
 1732536137,
 1732428244,
 -1,
 1732601671,
 1732450890,
 -1,
 -39098,
 1732546604,
 66450,
 -1,
 1732590849,
 66453,
 -39096,
 1732562642,
 66461,
 -1,
 1732731731,
 66444,
 1732929357,
 1732497398,
 -1,
 -39093,
 1732876993,
 66458,
 -39092,
 1732927464,
 66456,
 -1,
 1732988569,
 66441,
 1733191504,
 1732900421,
 -1,
 -39089,
 1733156027,
 66449,
 -1,
 1733185206,
 66439,
 1733388115,
 1733130336,
 -1,
 -39086,
 1733320142,
 66435,
 -1,
 1733369203,
 66443,
 1733584725,
 1733321766,
 66437,
 -1,
 1733546108,
 66440,
 1733715800,
 1733515347,
 -1,
 -39081,
 1733647912,
 66457,
 -1,
 1733697795,
 66434,
 1733912411,
 1733638997,
 -1,
 -39078,
 1733844594,
 66447,
 -1,
 1733905042,
 66436,
 1734109022,
 1733827146,
 -1,
 -39075,
 1734051895,
 66432,
 -1,
 1734110523,
 66451,
 -39073,
 1734079917,
 66442,
 -39072,
 1734275123,
 66438,
 -39071,
 1734335675,
 66460,
 -39070,
 1734391203,
 66455,
 -39069,
 1734455930,
 66454,
 -39068,
 1734521146,
 66452,
 -39067,
 1734580787,
 66448,
 -39066,
 1734643077,
 66446,
 -39065,
 1734704508,
 66445,
 -39064,
 1734764541,
 66459,
 -1,
 1734814530,
 66433,
 -1,
 1732440467,
 66463,
 1735092083,
 1732350624,
 -1,
 1735157616,
 1735026685,
 -1,
 1735223151,
 1735118838,
 -1,
 -39058,
 1735149447,
 11258,
 -1,
 1735199035,
 983115,
 -1,
 1735145577,
 129412,
 -39055,
 1735101362,
 9903,
 -39054,
 1735406128,
 11217,
 -1,
 1735467289,
 128530,
 1735681910,
 1735036012,
 -1,
 -39051,
 1735651080,
 9748,
 -1,
 1735696038,
 9969,
 -1,
 1735639508,
 983116,
 1735944225,
 1723683315,
 -1,
 1736009646,
 1735858762,
 -1,
 1736075171,
 1735929768,
 -1,
 1736140705,
 1736000708,
 -1,
 1736206235,
 1736109643,
 -1,
 1736271770,
 1736114176,
 -1,
 1736337284,
 1736219329,
 -1,
 1736402818,
 1736289363,
 128558,
 1736507391,
 1736310784,
 -1,
 -39039,
 1736436157,
 129326,
 -1,
 1736450433,
 128560,
 -39037,
 1736348852,
 129320,
 -1,
 1736603749,
 128582,
 1736796040,
 1736298177,
 128539,
 1736900607,
 1736704066,
 -1,
 -39033,
 1736830515,
 128540,
 -1,
 1736889736,
 128541,
 1737058187,
 1736757238,
 -1,
 -39030,
 1736991178,
 129298,
 -1,
 1737049647,
 128514,
 1737254798,
 1737009616,
 -1,
 -39027,
 1737195421,
 129402,
 -1,
 1737238061,
 129395,
 1737451409,
 1737197900,
 -1,
 -39024,
 1737400561,
 129488,
 -1,
 1737443280,
 128567,
 1737648020,
 1737373274,
 -1,
 -39021,
 1737616385,
 129312,
 -1,
 1737654047,
 128531,
 -39019,
 1737613524,
 129396,
 -39018,
 1737801597,
 128580,
 -39017,
 1737856970,
 128581,
 -39016,
 1737918094,
 128548,
 -39015,
 1737973947,
 129301,
 -1,
 1738036261,
 129323,
 -1,
 1736222477,
 128566,
 1738303390,
 1736163796,
 -1,
 -39011,
 1738225858,
 128561,
 -1,
 1738287236,
 128523,
 -39009,
 1738265839,
 128536,
 -39008,
 1738451613,
 129318,
 -1,
 1738509299,
 128134,
 -39006,
 1736103898,
 127981,
 -1,
 1738655825,
 8507,
 1738827688,
 1736014907,
 -1,
 1738893223,
 1738767419,
 -1,
 -39002,
 1738829531,
 9950,
 -1,
 1738885864,
 127810,
 -1,
 1738808728,
 129478,
 1739155371,
 1738797618,
 -1,
 -38998,
 1739098551,
 128224,
 -1,
 1739155867,
 128439,
 -38996,
 1739117509,
 127877,
 -38995,
 1739296655,
 128106,
 -1,
 1739355202,
 129498,
 1739548623,
 1735944189,
 -1,
 1739614142,
 1739502562,
 -1,
 1739679672,
 1739539650,
 128293,
 1739745204,
 1739649476,
 -1,
 -38989,
 1739702740,
 127878,
 -1,
 1739721093,
 127879,
 1739941815,
 1739653820,
 -1,
 -38986,
 1739911930,
 129519,
 -1,
 1739953766,
 128658,
 -1,
 1739864243,
 129512,
 1740242943,
 1739639978,
 -1,
 1740269500,
 1740157687,
 -1,
 -38981,
 1740238463,
 127771,
 -1,
 1740296115,
 127763,
 -38979,
 1740230279,
 8296,
 -1,
 1740418486,
 129351,
 1740597190,
 1739553851,
 -1,
 1740662723,
 1740522692,
 -1,
 -38975,
 1740620943,
 983106,
 -38974,
 1740658121,
 128193,
 -1,
 1740713977,
 128452,
 1740963839,
 1740605774,
 -1,
 -38971,
 1740878050,
 128253,
 -1,
 1740920697,
 127902,
 1741121483,
 1740554708,
 -1,
 1741187018,
 1741053372,
 128031,
 -38967,
 1741123504,
 127907,
 -1,
 1741160844,
 127845,
 -1,
 1741148691,
 128074,
 1741449166,
 1741088403,
 -1,
 -38963,
 1741402454,
 8281,
 -1,
 1741458274,
 11821,
 -1,
 1741376062,
 127953,
 1741711335,
 1739496129,
 -1,
 1741776857,
 1741675707,
 -1,
 1741842392,
 1741730788,
 -1,
 1741907925,
 1741766652,
 -1,
 -38956,
 1741861206,
 8280,
 -1,
 1741917026,
 8283,
 -38954,
 1741860573,
 128966,
 -38953,
 1742045123,
 127808,
 -1,
 1742092403,
 11156,
 -1,
 1741789554,
 9970,
 1742366688,
 1741730786,
 -1,
 1742432222,
 1742305376,
 -1,
 1742497757,
 1742340200,
 127860,
 -1,
 1742409325,
 127869,
 -1,
 1742423910,
 11792,
 -38945,
 1742396099,
 129376,
 -1,
 1742637407,
 983071,
 1742825442,
 1742316726,
 129462,
 -1,
 1742778555,
 128099,
 1742956516,
 1742755923,
 127787,
 -1,
 1742888362,
 127745,
 -38939,
 1742926389,
 129418,
 -38938,
 1743033512,
 129749,
 -1,
 1743093559,
 128448,
 1743284222,
 1741651003,
 -1,
 1743349743,
 1743198794,
 -1,
 1743415277,
 1743310838,
 -1,
 -38933,
 1743361432,
 9189,
 -38932,
 1743400591,
 129747,
 -1,
 1743456594,
 129407,
 -38930,
 1743359940,
 129449,
 -1,
 1743607900,
 9971,
 1743808500,
 1743319862,
 129712,
 1743912959,
 1743744708,
 -1,
 -38926,
 1743831972,
 128760,
 -38925,
 1743867015,
 128389,
 -1,
 1743929175,
 129359,
 1744136186,
 1743755969,
 -1,
 1744201721,
 1744104557,
 9880,
 1744306175,
 1744111376,
 -1,
 -38920,
 1744232587,
 8277,
 -1,
 1744273092,
 127924,
 -1,
 1744154698,
 128190,
 1744529405,
 1744061634,
 -1,
 -38916,
 1744499348,
 128170,
 -1,
 1744561083,
 9884,
 -1,
 1744495819,
 128563,
 1744791563,
 1743238114,
 -1,
 1744857091,
 1744739009,
 -1,
 -38911,
 1744826358,
 128550,
 -38910,
 1744869703,
 128037,
 -1,
 1744918613,
 128056,
 1745119239,
 1744773353,
 -1,
 -38907,
 1745081822,
 128445,
 -38906,
 1745136984,
 128444,
 -1,
 1745166650,
 128446,
 1745381386,
 1745044674,
 -1,
 -38903,
 1745327009,
 127839,
 -1,
 1745375720,
 129398,
 -1,
 1745316412,
 127844,
 1745643538,
 1744755899,
 -1,
 1745709071,
 1745585460,
 -1,
 -38898,
 1745677951,
 127773,
 -1,
 1745735603,
 127765,
 -38896,
 1745667068,
 9179,
 -38895,
 1745851777,
 9905,
 -1,
 1745898034,
 9981,
 1746102298,
 1745568962,
 -1,
 1746167830,
 1746059373,
 -1,
 -38891,
 1746137910,
 9972,
 -1,
 1746170953,
 127905,
 1746364441,
 1746082378,
 -1,
 -38888,
 1746326464,
 129718,
 -1,
 1746385265,
 128552,
 -1,
 1746310040,
 129338,
 1746626590,
 1746070149,
 -1,
 -38884,
 1746539600,
 983215,
 -38883,
 1746604843,
 983214,
 -1,
 1746670075,
 983213,
 1746888736,
 1746584020,
 983107,
 -1,
 1746823165,
 983232,
 -1,
 1746817523,
 983072,
 1747085478,
 1735882561,
 -1,
 1747151008,
 1746999882,
 -1,
 1747216535,
 1747117526,
 -1,
 1747282012,
 1747156796,
 -1,
 1747347547,
 1747245675,
 -1,
 1747413038,
 1747292832,
 -1,
 1747478570,
 1747343522,
 43412,
 1747582975,
 1747387461,
 43402,
 -1,
 1747454138,
 43403,
 1747675180,
 1747448762,
 43418,
 -1,
 1747584252,
 43416,
 1747845119,
 1747589706,
 43428,
 -1,
 1747715324,
 43423,
 1747937331,
 1747374070,
 -1,
 1748002865,
 1747898492,
 43419,
 -1,
 1747911846,
 43420,
 1748172799,
 1747917386,
 43424,
 -1,
 1748043004,
 43425,
 1748265016,
 1747860309,
 -1,
 1748330550,
 1748188160,
 43421,
 -1,
 1748239526,
 43422,
 1748500479,
 1748245066,
 43426,
 -1,
 1748370598,
 43427,
 1748592700,
 1748222633,
 43441,
 1748697087,
 1748501642,
 -1,
 -38853,
 1748624348,
 43439,
 -1,
 1748639309,
 43440,
 1748854848,
 1748544033,
 43429,
 1748959231,
 1748762624,
 -1,
 -38849,
 1748865613,
 43430,
 -1,
 1748906538,
 43401,
 1749116996,
 1748793536,
 43407,
 1749221375,
 1749024768,
 -1,
 -38845,
 1749140378,
 43408,
 -1,
 1749193293,
 43409,
 1749379143,
 1749051389,
 43398,
 -38842,
 1749313533,
 43399,
 -1,
 1749353454,
 43397,
 1749575753,
 1749333076,
 43435,
 -1,
 1749483546,
 43436,
 1749706827,
 1749514079,
 43415,
 -1,
 1749615782,
 43417,
 1749837901,
 1749637282,
 43410,
 -1,
 1749746940,
 43411,
 1749968975,
 1749757919,
 43413,
 -1,
 1749878012,
 43414,
 1750100049,
 1749887288,
 43431,
 -1,
 1750009084,
 43432,
 1750231123,
 1750014538,
 43396,
 -1,
 1750165501,
 43405,
 -38828,
 1750201274,
 43434,
 -38827,
 1750330081,
 43438,
 -38826,
 1750391995,
 43400,
 -38825,
 1750440641,
 43406,
 -38824,
 1750501794,
 43433,
 -38823,
 1750563973,
 43437,
 -38822,
 1750621646,
 43442,
 -1,
 1750680770,
 43404,
 -1,
 1747277824,
 43457,
 1750952049,
 1747233313,
 -1,
 1751017582,
 1750875139,
 -1,
 1751083107,
 1750957115,
 -1,
 1751148642,
 1751047355,
 -1,
 -38815,
 1751094907,
 43465,
 -1,
 1751148462,
 43461,
 -1,
 1751085121,
 43464,
 1751410791,
 1750997578,
 -1,
 1751476326,
 1751334242,
 43466,
 -1,
 1751384084,
 43467,
 -1,
 1751422030,
 43459,
 1751672938,
 1751362000,
 -1,
 -38807,
 1751610454,
 43468,
 -1,
 1751655142,
 43463,
 -38805,
 1751641607,
 43462,
 -38804,
 1751832245,
 43486,
 -38803,
 1751878145,
 43460,
 -1,
 1751938141,
 43487,
 1752170495,
 1750963696,
 -1,
 -38800,
 1752085895,
 43471,
 -1,
 1752136570,
 43456,
 1752328319,
 1750875885,
 -1,
 1752393845,
 1752289270,
 -1,
 -38796,
 1752363059,
 43474,
 -1,
 1752393247,
 43475,
 1752590456,
 1752351188,
 -1,
 -38793,
 1752528548,
 43478,
 -1,
 1752584164,
 43479,
 1752787067,
 1752519155,
 -1,
 -38790,
 1752737304,
 43476,
 -1,
 1752790506,
 43477,
 -38788,
 1752758064,
 43472,
 -38787,
 1752932121,
 43473,
 -38786,
 1752995566,
 43481,
 -1,
 1753041310,
 43480,
 1753245835,
 1752295978,
 -1,
 1753311365,
 1753206774,
 -1,
 1753376900,
 1753225802,
 -1,
 -38781,
 1753334123,
 43444,
 -1,
 1753384090,
 43450,
 -1,
 1753325015,
 43445,
 1753639047,
 1753281064,
 43446,
 -1,
 1753547968,
 43447,
 1753770121,
 1753599770,
 43448,
 -1,
 1753679047,
 43449,
 -38774,
 1753722045,
 43452,
 -1,
 1753825100,
 43451,
 1754032273,
 1753204699,
 -1,
 1754097806,
 1753952693,
 43393,
 -1,
 1754008075,
 43443,
 -38769,
 1754066424,
 43395,
 -38768,
 1754180297,
 43392,
 -1,
 1754234558,
 43394,
 1754425493,
 1753954189,
 -1,
 -38765,
 1754377342,
 43454,
 -38764,
 1754430001,
 43453,
 -1,
 1754476573,
 43455,
 -38762,
 1754389311,
 43469,
 -1,
 1754643319,
 43458,
 1754818719,
 1747167929,
 -1,
 -38759,
 1754779586,
 128304,
 -38758,
 1754836938,
 127971,
 -38757,
 1754897585,
 128121,
 -38756,
 1754946624,
 128122,
 -38755,
 1755004910,
 127886,
 -38754,
 1755066664,
 127983,
 -1,
 1755130306,
 9979,
 -1,
 1754740032,
 127875,
 1755408547,
 1747115195,
 -1,
 -38750,
 1755355079,
 9909,
 -1,
 1755404952,
 129337,
 -38748,
 1755359639,
 128377,
 -38747,
 1755540543,
 129513,
 -1,
 1755596319,
 128086,
 1755801879,
 1747056197,
 -1,
 1755867404,
 1755717959,
 -1,
 1755932896,
 1755808418,
 -1,
 1755998386,
 1755893750,
 -1,
 1756063917,
 1755959286,
 -1,
 -38740,
 1755995598,
 72213,
 -1,
 1756043850,
 72212,
 1756260528,
 1756021204,
 -1,
 -38737,
 1756192206,
 72228,
 -1,
 1756240458,
 72227,
 -38735,
 1756192206,
 72218,
 -1,
 1756371530,
 72217,
 1756588219,
 1755921237,
 -1,
 1756653750,
 1756558917,
 -1,
 -38731,
 1756585422,
 72230,
 -1,
 1756633674,
 72229,
 1756850361,
 1756576597,
 -1,
 -38728,
 1756782030,
 72215,
 -1,
 1756830282,
 72214,
 -38726,
 1756782030,
 72220,
 -1,
 1756961354,
 72219,
 1757178048,
 1756533408,
 -1,
 -38723,
 1757148090,
 72211,
 -38722,
 1757188842,
 72216,
 -38721,
 1757239458,
 72207,
 -1,
 1757289034,
 72221,
 1757505732,
 1757135316,
 -1,
 -38718,
 1757463209,
 72239,
 -38717,
 1757502926,
 72238,
 -1,
 1757551178,
 72240,
 1757767880,
 1757444192,
 -1,
 -38714,
 1757727785,
 72242,
 -38713,
 1757765070,
 72204,
 -1,
 1757813322,
 72203,
 1758030027,
 1757738565,
 -1,
 -38710,
 1757961678,
 72231,
 -1,
 1758009930,
 72232,
 1758226638,
 1757981136,
 -1,
 -38707,
 1758158286,
 72223,
 -1,
 1758206538,
 72222,
 1758423249,
 1758156883,
 -1,
 -38704,
 1758354894,
 72206,
 -1,
 1758403146,
 72205,
 1758619860,
 1758343080,
 -1,
 -38701,
 1758551502,
 72209,
 -1,
 1758599754,
 72208,
 1758816471,
 1758537991,
 -1,
 -38698,
 1758748110,
 72225,
 -1,
 1758796362,
 72224,
 -38696,
 1758786490,
 72234,
 -38695,
 1758979501,
 72237,
 -38694,
 1759032404,
 72235,
 -38693,
 1759087010,
 72226,
 -38692,
 1759149189,
 72236,
 -38691,
 1759213407,
 72210,
 -38690,
 1759272398,
 72241,
 -38689,
 1759320650,
 72192,
 -1,
 1759383386,
 72233,
 1759602925,
 1755900392,
 -1,
 1759668460,
 1759561691,
 -1,
 1759733988,
 1759632571,
 72195,
 -1,
 1759659202,
 72194,
 1759865062,
 1759681217,
 72198,
 -1,
 1759790274,
 72197,
 1759996137,
 1759779402,
 -1,
 -38680,
 1759960251,
 72200,
 -1,
 1759995901,
 72199,
 -38678,
 1759951163,
 72201,
 -38677,
 1760126973,
 72193,
 -1,
 1760183490,
 72196,
 -1,
 1759609425,
 72202,
 1760454904,
 1759560148,
 -1,
 1760520439,
 1760390146,
 -1,
 1760585971,
 1760440406,
 -1,
 1760651506,
 1760504851,
 72245,
 -1,
 1760562727,
 72246,
 -1,
 1760562727,
 72247,
 1760848118,
 1760553137,
 -1,
 -38667,
 1760805780,
 72249,
 -1,
 1760867685,
 72244,
 -1,
 1760764870,
 72248,
 -1,
 1760484854,
 72263,
 1761175811,
 1760376226,
 -1,
 1761241344,
 1761142032,
 -1,
 1761306879,
 1761170394,
 -1,
 -38660,
 1761276858,
 72251,
 -38659,
 1761338797,
 72254,
 -38658,
 1761391700,
 72252,
 -1,
 1761442949,
 72253,
 -1,
 1761243290,
 72250,
 1761738751,
 1761191062,
 -1,
 -38654,
 1761632405,
 72256,
 -1,
 1761690216,
 72262,
 1761896712,
 1761119079,
 -1,
 -38651,
 1761860149,
 72257,
 -38650,
 1761920432,
 72258,
 -38649,
 1761969791,
 72260,
 -1,
 1762017845,
 72259,
 1762224395,
 1761833069,
 -1,
 -38646,
 1762156693,
 72255,
 -1,
 1762214504,
 72261,
 -1,
 1762153391,
 72243,
 1762486546,
 1755835041,
 -1,
 1762552080,
 1762431648,
 -1,
 -38641,
 1762490177,
 983218,
 -1,
 1762537211,
 983259,
 -38639,
 1762511690,
 983217,
 -1,
 1762686785,
 983219,
 1762879765,
 1762411714,
 -1,
 -38636,
 1762845848,
 11234,
 -1,
 1762864754,
 129427,
 -38634,
 1762827807,
 129503,
 -1,
 1763013376,
 129296,
 1763207515,
 1755771702,
 -1,
 1763273048,
 1763132610,
 -1,
 1763338583,
 1763243958,
 -1,
 1763404115,
 1763279522,
 -1,
 1763469600,
 1763361236,
 -1,
 -38627,
 1763405115,
 69265,
 -38626,
 1763468115,
 69266,
 -38625,
 1763525826,
 69253,
 -1,
 1763581073,
 69267,
 1763797285,
 1763394754,
 -1,
 -38622,
 1763767707,
 69271,
 -38621,
 1763830433,
 69286,
 -38620,
 1763889142,
 69289,
 -1,
 1763935141,
 69248,
 1764124969,
 1763767877,
 -1,
 1764190504,
 1764039242,
 69263,
 -1,
 1764129851,
 69260,
 -1,
 1764115650,
 69270,
 1764387118,
 1764044712,
 -1,
 1764452653,
 1764318652,
 -1,
 -38612,
 1764388049,
 69255,
 -1,
 1764451135,
 69256,
 -1,
 1764388049,
 69254,
 1764714800,
 1764357578,
 69288,
 -1,
 1764625430,
 69297,
 1764845875,
 1764684336,
 -1,
 -38606,
 1764778560,
 69272,
 -1,
 1764825674,
 69258,
 1765042485,
 1764812205,
 69274,
 -1,
 1764950049,
 69275,
 1765173560,
 1765003254,
 -1,
 -38601,
 1765105791,
 69252,
 -1,
 1765153354,
 69269,
 1765370171,
 1765127138,
 -1,
 -38598,
 1765301710,
 69262,
 -1,
 1765349962,
 69261,
 1765566782,
 1765321168,
 -1,
 -38595,
 1765499007,
 69251,
 -1,
 1765557442,
 69250,
 1765763392,
 1765506409,
 69280,
 -1,
 1765674142,
 69296,
 1765894467,
 1765701728,
 -1,
 -38590,
 1765826041,
 69278,
 -1,
 1765875059,
 69277,
 1766091078,
 1765825980,
 -1,
 -38587,
 1766022606,
 69257,
 -1,
 1766074568,
 69287,
 1766287689,
 1766013952,
 -1,
 -38584,
 1766227003,
 69259,
 -1,
 1766275925,
 69268,
 -38582,
 1766255569,
 69284,
 -38581,
 1766449123,
 69283,
 -38580,
 1766502965,
 69276,
 -38579,
 1766566130,
 69285,
 -38578,
 1766627891,
 69282,
 -38577,
 1766690708,
 69281,
 -38576,
 1766750047,
 69264,
 -38575,
 1766807772,
 69279,
 -38574,
 1766871624,
 69273,
 -1,
 1766927016,
 69249,
 1767139670,
 1763325610,
 -1,
 -38571,
 1767082479,
 69292,
 -1,
 1767137087,
 69291,
 -1,
 1767073772,
 69293,
 -1,
 1763280290,
 128155,
 -38567,
 1763220245,
 129664,
 -38566,
 1767401519,
 983239,
 -1,
 1767450812,
 129393,
 1767663982,
 1763177163,
 -1,
 1767729509,
 1767618406,
 -1,
 1767795040,
 1767649192,
 -1,
 -38561,
 1767727154,
 129636,
 -1,
 1767777090,
 129637,
 -38559,
 1767754483,
 129638,
 -38558,
 1767934758,
 129633,
 -38557,
 1767990667,
 129635,
 -38556,
 1768053309,
 129632,
 -1,
 1768114789,
 129634,
 1768357887,
 1767648395,
 -1,
 1768384873,
 1768239016,
 -1,
 -38552,
 1768316978,
 129643,
 -1,
 1768366914,
 129644,
 -38550,
 1768344307,
 129645,
 -38549,
 1768524582,
 129640,
 -38548,
 1768580491,
 129642,
 -38547,
 1768643133,
 129639,
 -1,
 1768704613,
 129641,
 -1,
 1767617475,
 9915]
_charnames_564 = [
11454,
11520,
11273,
11470,
11474,
11591,
11668,
11753,
11511,
11763,
11642,
11298,
11582,
11771,
11541,
11804,
11739,
11632,
11658,
11323,
11814,
11602,
11687,
11589,
11712,
11388,
11817,
11594,
]

_charnames_751 = [
9575,
9579,
9569,
9578,
9577,
9615,
9613,
9614,
9580,
9608,
9632,
9601,
9631,
9600,
9519,
9634,
9568,
]

_charnames_848 = [
1856,
1791,
1923,
1910,
1788,
1857,
1854,
1859,
1844,
1882,
1833,
1907,
1832,
1831,
1829,
1830,
]

_charnames_880 = [
24596,
24574,
24597,
24575,
-1,
-1,
24595,
24573,
-1,
-1,
-1,
24577,
24579,
24578,
-1,
24594,
]

_charnames_1015 = [
24592,
24571,
24598,
24593,
24572,
24639,
24600,
24603,
24601,
]

_charnames_1270 = [
3030,
2950,
-1,
-1,
3029,
2949,
3012,
2920,
3011,
2919,
]

_charnames_1296 = [
2986,
2884,
2994,
2902,
3035,
2947,
2990,
2889,
3008,
2916,
3032,
2952,
3031,
2935,
3036,
2953,
2993,
2901,
2997,
2905,
3033,
2937,
2983,
2898,
2998,
2906,
2958,
2872,
2967,
2881,
2995,
2903,
]

_charnames_1416 = [
17122,
-1,
-1,
-1,
-1,
25288,
12101,
17124,
]

_charnames_1536 = [
17102,
17030,
17092,
17033,
17031,
17103,
17114,
17113,
17079,
17112,
17111,
17687,
-1,
17084,
17106,
17038,
17032,
17039,
17035,
17036,
17037,
16990,
16993,
16989,
17000,
17001,
16999,
-1,
16931,
-1,
17065,
-1,
16860,
]

_charnames_1622 = [
17052,
17108,
16812,
17104,
17094,
17095,
17096,
17078,
17089,
17105,
]

_charnames_1869 = [
7926,
7927,
7928,
16821,
16829,
16819,
16820,
16822,
16827,
16824,
16906,
16907,
16940,
16944,
16883,
16894,
16834,
16836,
16833,
16874,
16875,
16855,
16852,
16850,
16929,
16928,
16954,
16953,
16952,
16936,
16884,
16887,
16891,
16904,
16902,
16892,
16882,
16903,
16844,
16845,
16865,
16866,
16867,
16947,
16948,
16916,
16917,
16908,
16895,
16893,
16858,
]

_charnames_1984 = [
18786,
18787,
18778,
18779,
18784,
18785,
18781,
18782,
18789,
18788,
18772,
18754,
18766,
18753,
18759,
18752,
18751,
18756,
18737,
18771,
18762,
18760,
18747,
18770,
18755,
18750,
18749,
18761,
18768,
18769,
18765,
18764,
18741,
18763,
18738,
18740,
18767,
18758,
18757,
18739,
18745,
18746,
18744,
18802,
18801,
18800,
18798,
18797,
18796,
18795,
18803,
18804,
18810,
18773,
18807,
18808,
18805,
18811,
18774,
-1,
-1,
18791,
18790,
18809,
7480,
7467,
7477,
7479,
7460,
7468,
7469,
7461,
7457,
7470,
7476,
7475,
7474,
7473,
7464,
7462,
7478,
7456,
7472,
7471,
7465,
7458,
7520,
7521,
7522,
7525,
7529,
7524,
7487,
7498,
7490,
7484,
7495,
7489,
7483,
7494,
7527,
7493,
7485,
7496,
7528,
7486,
7497,
7488,
7492,
7523,
-1,
-1,
7515,
7506,
7503,
7517,
7504,
7512,
7530,
7516,
7508,
7514,
7509,
7513,
7505,
7511,
7502,
-1,
8934,
8928,
8926,
8927,
8925,
8932,
8917,
8930,
8914,
8916,
8915,
8923,
8922,
8921,
8910,
8931,
8920,
8911,
8919,
8918,
8912,
8913,
8935,
8933,
8924,
8939,
8936,
8938,
-1,
-1,
8937,
-1,
7916,
7923,
7915,
7920,
7914,
7913,
7924,
7922,
7919,
7918,
7921,
]

_charnames_2208 = [
16825,
16828,
16959,
16924,
16876,
16967,
16935,
16930,
16913,
16914,
16885,
16949,
16888,
16937,
16941,
16897,
16965,
16896,
16966,
16837,
16859,
-1,
16826,
16962,
16921,
16881,
16912,
16842,
16839,
16841,
16961,
16920,
16922,
16923,
16854,
16964,
16840,
16958,
16957,
16934,
]

_charnames_2259 = [
16997,
16980,
16988,
16995,
16991,
16992,
16998,
16978,
16979,
16981,
16983,
16984,
16982,
16994,
16987,
17086,
17064,
17069,
17071,
17067,
17070,
17072,
17068,
17060,
17057,
17063,
17059,
17056,
17062,
17099,
17100,
17098,
16985,
17090,
17091,
17107,
16970,
17075,
16969,
17077,
17081,
17082,
17076,
17085,
16811,
24321,
-1,
-1,
-1,
24303,
]

_charnames_2382 = [
24334,
24333,
-1,
-1,
-1,
-1,
-1,
24335,
24327,
24326,
]

_charnames_2417 = [
24322,
24308,
24295,
24294,
24301,
24292,
24291,
24304,
24302,
24306,
24298,
24305,
24297,
24307,
24309,
14319,
]

_charnames_2555 = [
14321,
14314,
14320,
14317,
-1,
-1,
25141,
-1,
25139,
]

_charnames_2809 = [
25131,
25124,
25125,
25126,
25122,
25127,
25121,
]

_charnames_2929 = [
22734,
22723,
22724,
22728,
22722,
22725,
22727,
]

_charnames_3059 = [
4713,
4731,
4725,
4712,
4676,
4723,
4727,
4730,
-1,
-1,
-1,
-1,
-1,
5489,
-1,
-1,
-1,
5490,
]

_charnames_3191 = [
5492,
5486,
5484,
5478,
5481,
5485,
5479,
5482,
5491,
19977,
19982,
-1,
-1,
19978,
]

_charnames_3386 = [
9291,
9318,
9316,
9320,
-1,
-1,
-1,
-1,
-1,
-1,
9324,
]

_charnames_3406 = [
9293,
9319,
-1,
-1,
-1,
-1,
9288,
9286,
9283,
-1,
9305,
9301,
9312,
9298,
9299,
9309,
9302,
9294,
-1,
-1,
9322,
9323,
]

_charnames_3440 = [
9329,
9328,
9327,
9304,
9306,
9311,
9303,
9307,
9310,
9330,
9285,
9284,
9287,
9281,
9282,
9289,
-1,
6848,
]

_charnames_3558 = [
6839,
6840,
6831,
6832,
6837,
6838,
6834,
6835,
6842,
6841,
]

_charnames_3718 = [
11927,
-1,
-1,
11928,
-1,
-1,
11926,
-1,
11923,
11921,
11920,
11917,
11916,
11924,
-1,
-1,
-1,
-1,
11918,
]

_charnames_4046 = [
5337,
-1,
5323,
5327,
5326,
5329,
5330,
25285,
12098,
25286,
12099,
5328,
5325,
]

_charnames_4130 = [
10056,
-1,
-1,
-1,
-1,
-1,
10115,
-1,
-1,
10201,
]

_charnames_4147 = [
10198,
10197,
10203,
-1,
-1,
-1,
-1,
10158,
10225,
10227,
10226,
10228,
10124,
]

_charnames_4186 = [
10113,
10114,
10112,
10111,
10230,
10231,
10232,
10060,
10188,
10221,
10220,
10121,
10122,
10195,
10194,
10149,
10148,
10147,
10146,
10145,
10118,
10117,
10119,
10202,
10191,
10190,
10192,
10039,
10038,
10042,
10045,
10049,
10034,
10055,
10036,
10051,
10054,
10048,
10050,
10053,
10233,
10187,
10184,
10185,
10186,
10137,
10136,
10135,
10134,
10141,
10140,
10142,
10123,
10156,
10169,
10170,
10161,
10162,
10167,
10168,
10164,
10165,
10172,
10171,
10155,
10154,
10199,
10200,
10179,
10180,
]

_charnames_4295 = [
24890,
-1,
-1,
-1,
-1,
-1,
24891,
]

_charnames_4345 = [
24886,
24883,
-1,
9635,
24884,
24888,
24887,
]

_charnames_4992 = [
15653,
15734,
15733,
15732,
15655,
15670,
15669,
15668,
15654,
15739,
15738,
15737,
15652,
15727,
15726,
15725,
15758,
15752,
15760,
15759,
15754,
15757,
15762,
15761,
15753,
15756,
]

_charnames_5109 = [
2520,
-1,
-1,
2476,
2475,
2474,
2473,
2472,
2493,
-1,
-1,
2689,
]

_charnames_5751 = [
2605,
2601,
2602,
2599,
2600,
2603,
2604,
2606,
2674,
]

_charnames_5873 = [
25493,
25491,
25492,
25488,
25489,
25490,
25487,
25486,
]

_charnames_6128 = [
19454,
19455,
19450,
19453,
19452,
19443,
19449,
19448,
19447,
19446,
]

_charnames_6314 = [
9759,
-1,
-1,
-1,
-1,
-1,
2595,
2685,
2686,
2612,
2668,
2669,
2667,
2637,
2680,
2679,
2687,
2654,
2655,
2688,
2625,
2614,
2623,
2624,
2622,
2676,
2677,
2646,
2652,
2586,
2653,
2587,
2650,
2584,
2651,
2585,
2644,
2642,
2643,
2640,
2641,
2645,
2591,
2590,
2593,
2594,
2592,
2582,
2588,
2589,
2690,
2611,
2682,
2683,
2647,
2609,
2610,
2635,
2636,
2628,
2629,
2630,
2632,
2633,
2617,
2618,
2620,
2659,
2664,
2661,
2660,
2619,
2665,
2673,
2672,
2663,
]

_charnames_6400 = [
11122,
11072,
11071,
11061,
11060,
11068,
11081,
11080,
11075,
11074,
11063,
11053,
11052,
11078,
11077,
11069,
11066,
11065,
11084,
11083,
11087,
11062,
11086,
11088,
11085,
11056,
11055,
11057,
11089,
11059,
11051,
-1,
11113,
11121,
11120,
11119,
11115,
11117,
11114,
11118,
11116,
11108,
11110,
11109,
-1,
-1,
-1,
-1,
11100,
11093,
11101,
11095,
11094,
11097,
11098,
11096,
11099,
11104,
11106,
11103,
-1,
-1,
-1,
-1,
11105,
-1,
-1,
-1,
11138,
11137,
11133,
11134,
11125,
11126,
11131,
11132,
11128,
11129,
11136,
11135,
5028,
5030,
5024,
5007,
5032,
5029,
5009,
5008,
5035,
5020,
5019,
5034,
5038,
5031,
5037,
5033,
5027,
5006,
5025,
5013,
5036,
5012,
5011,
5016,
5022,
5021,
5017,
5010,
5014,
5015,
-1,
-1,
5004,
5003,
5002,
5001,
5000,
]

_charnames_6528 = [
18308,
18279,
18305,
18293,
18301,
18276,
18264,
18272,
18288,
18296,
18306,
18259,
18267,
18277,
18290,
18289,
18302,
18261,
18260,
18273,
18299,
18298,
18309,
18270,
18269,
18280,
18312,
18307,
18310,
18283,
18278,
18281,
18311,
18313,
18314,
18282,
18284,
18285,
18304,
18292,
18275,
18263,
18295,
18266,
-1,
-1,
-1,
-1,
18341,
18334,
18340,
18324,
18328,
18342,
18337,
18329,
18330,
18325,
18336,
18335,
18327,
18332,
18331,
18326,
18339,
18318,
18317,
18316,
18319,
18320,
18321,
18322,
18360,
18359,
-1,
-1,
-1,
-1,
-1,
-1,
18353,
18354,
18345,
18346,
18351,
18352,
18348,
18349,
18356,
18355,
18361,
-1,
-1,
-1,
18362,
18363,
19418,
19465,
19417,
19462,
19459,
19414,
19411,
19408,
19405,
19402,
19440,
19437,
19427,
19434,
19431,
19424,
19466,
19464,
19416,
19461,
19458,
19413,
19410,
19407,
19404,
19401,
19439,
19436,
19426,
19433,
19430,
19423,
14278,
14281,
14265,
14264,
14276,
14284,
14270,
14269,
14273,
14282,
14267,
14266,
14283,
14279,
14262,
14261,
14271,
14275,
14277,
14272,
14274,
14285,
14280,
14289,
14287,
14290,
14288,
14291,
-1,
-1,
14292,
14293,
4769,
4768,
4767,
4742,
4740,
4741,
4790,
4778,
4777,
4751,
4753,
4750,
4789,
4785,
4780,
4801,
4754,
4786,
4772,
4771,
4745,
4744,
4791,
4802,
4775,
4774,
4782,
4748,
4756,
4747,
4798,
4752,
4779,
4784,
4787,
4757,
4759,
4796,
4764,
4763,
4765,
4781,
4760,
4803,
4755,
4794,
4795,
4792,
4793,
4800,
4797,
4758,
4799,
4892,
4893,
4897,
4822,
4900,
4896,
4899,
4894,
4901,
4898,
-1,
4819,
4849,
4858,
4852,
4855,
4856,
4857,
4848,
4847,
4845,
4846,
4839,
4841,
4843,
4859,
4851,
4844,
4850,
4854,
4842,
4821,
4829,
4828,
4810,
4809,
4808,
4832,
4824,
4811,
-1,
-1,
4902,
4884,
4885,
4876,
4877,
4882,
4883,
4879,
4880,
4887,
4886,
-1,
-1,
-1,
-1,
-1,
-1,
4870,
4871,
4862,
4863,
4868,
4869,
4865,
4866,
4873,
4872,
-1,
-1,
-1,
-1,
-1,
-1,
4825,
4826,
4818,
4814,
4834,
4836,
4831,
4823,
4812,
4813,
4816,
4817,
4835,
4837,
-1,
-1,
1838,
1847,
1919,
1846,
1896,
1909,
1912,
1868,
1835,
1797,
1899,
1904,
1834,
1903,
1902,
1751,
1771,
]

_charnames_6912 = [
13438,
13439,
13442,
13440,
13443,
13324,
13325,
13346,
13347,
13338,
13339,
13333,
13334,
13336,
13337,
13351,
13327,
13342,
13343,
13313,
13315,
13348,
13349,
13311,
13353,
13354,
13344,
13345,
13310,
13305,
13304,
13321,
13320,
13309,
13301,
13303,
13317,
13322,
13308,
13340,
13341,
13355,
13356,
13361,
13358,
13332,
13335,
13359,
13331,
13330,
13328,
13362,
13441,
13411,
13412,
13413,
13414,
13415,
13416,
13417,
13420,
13421,
13406,
13408,
13410,
13409,
13418,
13419,
13455,
13314,
13316,
13306,
13352,
13360,
13357,
13326,
-1,
-1,
-1,
-1,
13432,
13433,
13424,
13425,
13430,
13431,
13427,
13428,
13435,
13434,
13448,
13447,
13454,
13452,
13453,
13451,
13446,
13376,
13374,
13375,
13366,
13368,
13377,
13371,
13373,
13370,
13369,
13384,
13387,
13380,
13382,
13385,
13381,
13383,
13388,
13386,
13399,
13400,
13402,
13403,
13393,
13391,
13396,
13395,
13392,
-1,
-1,
-1,
7815,
7814,
7813,
7758,
7772,
7765,
7759,
7769,
7753,
7754,
7752,
7767,
7774,
7734,
7776,
7771,
7760,
7733,
7766,
7775,
7735,
7768,
7740,
7764,
7757,
7770,
7761,
7746,
7749,
7763,
7743,
7762,
7773,
7825,
7824,
7823,
7805,
7803,
7807,
7804,
7808,
7806,
7816,
7817,
7821,
7820,
7751,
7742,
7787,
7788,
7779,
7780,
7785,
7786,
7782,
7783,
7790,
7789,
7826,
7745,
7748,
7756,
7739,
7738,
13518,
13487,
13513,
13485,
13501,
13517,
13510,
13503,
13482,
13495,
13500,
13506,
13479,
13504,
13514,
13486,
13511,
13515,
13508,
13481,
13497,
13483,
13488,
13492,
13489,
13480,
13499,
13505,
13478,
13493,
13509,
13484,
13491,
13516,
13494,
13502,
13512,
13507,
13537,
13525,
13527,
13526,
13529,
13524,
13528,
13523,
13520,
13521,
13542,
13543,
13540,
13539,
]

_charnames_7164 = [
13535,
13533,
13536,
13534,
12127,
12125,
12126,
12143,
12142,
12122,
12149,
12148,
12158,
12121,
12115,
12114,
12131,
12123,
12119,
12117,
12118,
12146,
12145,
12152,
12151,
12137,
12136,
12113,
12112,
12129,
12153,
12156,
12157,
12140,
12139,
12155,
12134,
12133,
12154,
12159,
12201,
12202,
12191,
12189,
12187,
12188,
12185,
12186,
12190,
12177,
12182,
12183,
12175,
12181,
12180,
12179,
12176,
12178,
12204,
12205,
-1,
-1,
-1,
12196,
12197,
12198,
12195,
12194,
12170,
12171,
12162,
12163,
12168,
12169,
12165,
12166,
12173,
12172,
-1,
-1,
-1,
12110,
12109,
12130,
22474,
22475,
22466,
22467,
22472,
22473,
22469,
22470,
22477,
22476,
22438,
22433,
22436,
22434,
22435,
22439,
22431,
22432,
22430,
22429,
22442,
22455,
22458,
22457,
22456,
22440,
22448,
22447,
22446,
22445,
22443,
22461,
22463,
22462,
22460,
22441,
22451,
22453,
22450,
22452,
22485,
22487,
22484,
22486,
22482,
22488,
22480,
22481,
2888,
2946,
2941,
2934,
2860,
2866,
2861,
2859,
2951,
]

_charnames_7312 = [
24787,
24827,
24810,
24826,
24812,
24817,
24792,
24784,
24824,
24804,
24800,
24823,
24822,
24821,
24798,
24791,
24819,
24795,
24783,
24818,
24797,
24803,
24809,
24820,
24794,
24777,
24780,
24806,
24779,
24778,
24815,
24807,
24771,
24774,
24773,
24816,
24769,
24772,
24825,
24814,
24813,
24785,
24788,
-1,
-1,
24789,
24770,
24801,
7795,
7794,
7793,
7799,
7796,
7797,
7798,
7800,
]

_charnames_7376 = [
20942,
20946,
20947,
20917,
20914,
20927,
20926,
20924,
20944,
20925,
20934,
20930,
20941,
20936,
20929,
20931,
20939,
20948,
20907,
20903,
20910,
20905,
20911,
20904,
20906,
20899,
20898,
20895,
20896,
20916,
20920,
20918,
20912,
20897,
20901,
20913,
20945,
20919,
20915,
20900,
20938,
20935,
20921,
-1,
-1,
-1,
-1,
-1,
11848,
11849,
11264,
11864,
11863,
11862,
11847,
11845,
11250,
11257,
11860,
11859,
11858,
11857,
11839,
11842,
11844,
11281,
11282,
11283,
11244,
11843,
11277,
11490,
11856,
11838,
11833,
11831,
11853,
11284,
11286,
11285,
11852,
11851,
11850,
11846,
11866,
11867,
24612,
24611,
24608,
24609,
24607,
3038,
9532,
9533,
9530,
9531,
9547,
9546,
9525,
9545,
9528,
9544,
9543,
9542,
9541,
9540,
9539,
9524,
9526,
9527,
9538,
9522,
9537,
9536,
9534,
9494,
9430,
9495,
9432,
9475,
9491,
9459,
9472,
9486,
9437,
9487,
9438,
9510,
9504,
9463,
9483,
9485,
9440,
9476,
9499,
9428,
9464,
9473,
9433,
9497,
9496,
9477,
9490,
9493,
9489,
9450,
11623,
11615,
11613,
11612,
24585,
24583,
24581,
24582,
24584,
11382,
11487,
11464,
11600,
11532,
11524,
11554,
11391,
11392,
11303,
11271,
11584,
11263,
9562,
11342,
11269,
11607,
11360,
11550,
11606,
11378,
11486,
11463,
11599,
11545,
11562,
11450,
11531,
11522,
11553,
11389,
11301,
11329,
11495,
11580,
11583,
11410,
11419,
11465,
11324,
11431,
11399,
11293,
11356,
11427,
11328,
11375,
11333,
9431,
9443,
9451,
9461,
9509,
9513,
9492,
9471,
9439,
9508,
9507,
9445,
9446,
9511,
9454,
9455,
9449,
9505,
9434,
9503,
9502,
9448,
9478,
9500,
9474,
9462,
9442,
9467,
9468,
9447,
9498,
9436,
9479,
9481,
9482,
9460,
9441,
1841,
1842,
1900,
1898,
1879,
1663,
1877,
1885,
1664,
1886,
1759,
1921,
1878,
1837,
1869,
1906,
1918,
1890,
1889,
1764,
1745,
1743,
1742,
1777,
1775,
1766,
1776,
1783,
1774,
1747,
1782,
1781,
1773,
1780,
1779,
1758,
1755,
1748,
1770,
1744,
1768,
1769,
1756,
1763,
1749,
1761,
1772,
1767,
1753,
1750,
1746,
1762,
1754,
1891,
1915,
1916,
1845,
1913,
-1,
1825,
1836,
1887,
1789,
1855,
]

_charnames_8275 = [
8150,
26213,
26615,
5532,
-1,
26579,
26572,
5661,
26580,
23949,
5637,
20968,
-1,
-1,
-1,
-1,
-1,
26222,
-1,
12102,
25289,
26556,
23627,
]

_charnames_8336 = [
11626,
11625,
11617,
11611,
11610,
11624,
11621,
11620,
11619,
11618,
11616,
11609,
11614,
]

_charnames_8370 = [
25148,
17657,
21947,
3438,
11233,
8008,
5511,
26129,
5623,
18852,
8953,
25505,
11910,
14357,
]

_charnames_8524 = [
23538,
17686,
5606,
7940,
21002,
21003,
21001,
]

_charnames_8580 = [
11397,
25520,
25519,
25518,
25521,
21004,
5610,
5611,
]

_charnames_9167 = [
15951,
20967,
8826,
8823,
8824,
8822,
8817,
8818,
8819,
8820,
8825,
15909,
26639,
5588,
14219,
5590,
14222,
5586,
14217,
25903,
14325,
7976,
26602,
17670,
15858,
24366,
13745,
13756,
13783,
13731,
13746,
13757,
13747,
17298,
7991,
5352,
21889,
13697,
13709,
13704,
13701,
23931,
13714,
13693,
23599,
23602,
23603,
23600,
22798,
]

_charnames_9866 = [
9771,
9770,
24261,
24254,
24255,
24260,
25914,
13799,
21850,
16618,
3417,
7961,
8127,
17294,
26613,
24892,
7960,
17680,
26620,
22785,
5528,
5529,
25715,
21926,
23939,
23938,
26241,
9335,
9333,
9334,
20966,
21879,
8695,
8704,
8686,
9276,
24229,
26480,
2198,
26640,
18489,
3436,
23154,
26785,
20986,
2572,
13711,
8050,
8056,
26990,
8053,
7106,
13595,
7666,
25877,
25878,
13736,
13737,
8131,
7831,
25579,
13724,
5557,
5619,
5617,
25875,
3420,
24275,
22761,
23647,
2762,
21559,
3383,
2417,
18857,
17295,
13771,
25904,
13761,
25895,
24383,
21518,
12095,
7660,
26533,
13772,
25417,
25416,
17662,
21513,
23540,
25291,
12104,
26214,
13692,
7334,
2575,
2851,
21929,
24894,
24895,
9418,
9783,
26485,
26584,
26606,
26644,
7549,
7725,
8143,
26297,
23521,
5509,
26782,
21547,
26641,
1581,
25915,
13726,
-1,
-1,
-1,
-1,
25887,
-1,
-1,
-1,
-1,
25576,
25568,
]

_charnames_10060 = [
3415,
-1,
18406,
-1,
-1,
-1,
-1,
13800,
25933,
25934,
-1,
21503,
]

_charnames_10175 = [
23935,
5533,
25902,
23535,
22748,
22747,
12086,
25246,
22742,
25410,
7836,
20969,
9399,
12342,
9410,
7649,
7648,
]

_charnames_11008 = [
18848,
18838,
7094,
7084,
12070,
12019,
26415,
23912,
18850,
18840,
7096,
7086,
12073,
26430,
25197,
25196,
11996,
11995,
7703,
7705,
7702,
7704,
24266,
24265,
24264,
24267,
23944,
13764,
25898,
13776,
25919,
13794,
25928,
25889,
13788,
21878,
13765,
13703,
25910,
13699,
25909,
13720,
13719,
25869,
13790,
25890,
13779,
25920,
12066,
5530,
12067,
12343,
11986,
11987,
11988,
11989,
12007,
11998,
11999,
11981,
11983,
11984,
12015,
25805,
15948,
25406,
12012,
25212,
25211,
12035,
25232,
25405,
25208,
5348,
12013,
12011,
25207,
23887,
7320,
7319,
25908,
13718,
25868,
13748,
25925,
21480,
21533,
21514,
21511,
21515,
8108,
13610,
8107,
13609,
14324,
7318,
11958,
26374,
25172,
23873,
12071,
26428,
18836,
18846,
7092,
7082,
11975,
26389,
25189,
23889,
3320,
16609,
11972,
26386,
25186,
23885,
-1,
-1,
18837,
18847,
7093,
7083,
11966,
26384,
25180,
23883,
21874,
20962,
11973,
26387,
25187,
23886,
11974,
26388,
25188,
23888,
12018,
26414,
25215,
23911,
16608,
16611,
16610,
16607,
25425,
25424,
18370,
18369,
26583,
25216,
-1,
7939,
5542,
5543,
5541,
5544,
13762,
13784,
13750,
13732,
23878,
23877,
26379,
26378,
11962,
25176,
11963,
25177,
13691,
13690,
13682,
13681,
13687,
13684,
13688,
13685,
25305,
25304,
25296,
25295,
25301,
25298,
25302,
25299,
26406,
26431,
22780,
22781,
22782,
13467,
3394,
3399,
13715,
13741,
5618,
21877,
13801,
13705,
13702,
13698,
13710,
18495,
5583,
14221,
11212,
25552,
25917,
25551,
7722,
26481,
24762,
23469,
23470,
23472,
23473,
5644,
23592,
17663,
21943,
23356,
18492,
25911,
13740,
5655,
1582,
21856,
26899,
20024,
17673,
17415,
21005,
23620,
12052,
25262,
7955,
7954,
11985,
26391,
25191,
23891,
15945,
15944,
8058,
25498,
25502,
25501,
25503,
25500,
25499,
15947,
26477,
8055,
23937,
23168,
25396,
21560,
25026,
25015,
25017,
25024,
24997,
24979,
25000,
24996,
25001,
24986,
24990,
24983,
24998,
25022,
25009,
25021,
25020,
25007,
25003,
25019,
24973,
24992,
25018,
25012,
25023,
25006,
25004,
24967,
24993,
25025,
24969,
24977,
24978,
24982,
24972,
24980,
24970,
24971,
24981,
24988,
25016,
24989,
25013,
24985,
24968,
24994,
25010,
-1,
24963,
24952,
24954,
24961,
24934,
24916,
24937,
24933,
24938,
24923,
24927,
24920,
24935,
24959,
24946,
24958,
24957,
24944,
24940,
24956,
24910,
24929,
24955,
24949,
24960,
24943,
24941,
24904,
24930,
24962,
24906,
24914,
24915,
24919,
24909,
24917,
24907,
24908,
24918,
24925,
24953,
24926,
24950,
24922,
24905,
24931,
24947,
-1,
11767,
11447,
11765,
11785,
11711,
11409,
11272,
11799,
11570,
11781,
11561,
11811,
11585,
11676,
11795,
11630,
11631,
11494,
11825,
11604,
11497,
11801,
11572,
11278,
11325,
11255,
11438,
11835,
11622,
9535,
11681,
11809,
2067,
1986,
2070,
1989,
2077,
1996,
2041,
1960,
2079,
1998,
2050,
1969,
2069,
1988,
2076,
1995,
2058,
1977,
2075,
1994,
2056,
1975,
2064,
1983,
2074,
1993,
2073,
1992,
2054,
1973,
2012,
1931,
2062,
1981,
2072,
1991,
2051,
1970,
2059,
1978,
2071,
1990,
2078,
1997,
2055,
1974,
2061,
1980,
2034,
1953,
2040,
1959,
2027,
1946,
2047,
1966,
2038,
1957,
2037,
1956,
2045,
1964,
2023,
1942,
2052,
1971,
2048,
1967,
2022,
1941,
2025,
1944,
2068,
1987,
2039,
1958,
2018,
1937,
2016,
1935,
2065,
1984,
2019,
1938,
2017,
1936,
2024,
1943,
2026,
1945,
2021,
1940,
2033,
1952,
2031,
1950,
2030,
1949,
2032,
1951,
2006,
2009,
2008,
2002,
2007,
2005,
2003,
2044,
1963,
2046,
1965,
2085,
2084,
2083,
2080,
1999,
-1,
-1,
-1,
-1,
-1,
2134,
2135,
2133,
2132,
2138,
2137,
2139,
24864,
24880,
24862,
24879,
24878,
24869,
24844,
24847,
24877,
24856,
24876,
24875,
24874,
24873,
24853,
24843,
24871,
24850,
24846,
24870,
24852,
24855,
24861,
24872,
24849,
24838,
24841,
24858,
24840,
24839,
24867,
24859,
24832,
24835,
24834,
24868,
24831,
24833,
-1,
24866,
-1,
-1,
-1,
-1,
-1,
24865,
-1,
-1,
5256,
5280,
5281,
5273,
5275,
5312,
5290,
5257,
5260,
5258,
5259,
5295,
5291,
5270,
5301,
5272,
5278,
5313,
5309,
5279,
5293,
5271,
5302,
5285,
5307,
5298,
5263,
5316,
5306,
5289,
5288,
5287,
5304,
5308,
5286,
5296,
5276,
5277,
5274,
5305,
5315,
5267,
5268,
5269,
5264,
5266,
5292,
5265,
5284,
5283,
5282,
5261,
5310,
5262,
5294,
5297,
]

_charnames_11647 = [
5319,
15746,
15735,
15745,
15656,
15657,
15671,
15681,
15605,
15742,
15741,
15623,
15692,
15641,
15633,
15747,
15682,
15606,
15729,
15728,
15619,
15621,
15618,
15617,
]

_charnames_11680 = [
15646,
15648,
15650,
15647,
15645,
15644,
15649,
-1,
15600,
15602,
15604,
15601,
15599,
15598,
15603,
-1,
15687,
15689,
15691,
15688,
15686,
15685,
15690,
-1,
15593,
15595,
15597,
15594,
15592,
15591,
15596,
-1,
15707,
15709,
15711,
15708,
15706,
15705,
15710,
-1,
15717,
15719,
15721,
15718,
15716,
15715,
15720,
-1,
15697,
15699,
15701,
15698,
15696,
15695,
15700,
-1,
15611,
15613,
15615,
15612,
15610,
15609,
15614,
-1,
1714,
1715,
1720,
1711,
1698,
1699,
1719,
1679,
1678,
1677,
1705,
1716,
1676,
1674,
1704,
1707,
1703,
1722,
1695,
1694,
1721,
1675,
1723,
1686,
1710,
1717,
1691,
1688,
1685,
1718,
1713,
1684,
25267,
25268,
12083,
25243,
12092,
25278,
25575,
25573,
23946,
12078,
25256,
25574,
12074,
25280,
15952,
23102,
26589,
25401,
21941,
23948,
23903,
26403,
23947,
23932,
26215,
23152,
21942,
5347,
12089,
25281,
5346,
5345,
12094,
25279,
5589,
5587,
14220,
14218,
12085,
25244,
12091,
25277,
5660,
22771,
7675,
26573,
25399,
20964,
25309,
26014,
5621,
25572,
25577,
5607,
24389,
24388,
5612,
5582,
5667,
5545,
7985,
20965,
25999,
2852,
23934,
25402,
23933,
24392,
23929,
26211,
26212,
12331,
12332,
23930,
23945,
5635,
8706,
23101,
23657,
2195,
3413,
3414,
5251,
]

_charnames_12728 = [
14207,
14210,
14208,
14214,
14206,
14211,
14203,
14213,
3262,
3265,
3264,
3269,
3252,
3236,
3243,
3244,
3241,
3251,
3242,
3239,
3245,
3240,
3237,
3267,
3234,
3248,
3258,
3256,
3268,
3235,
3247,
3249,
3253,
3255,
3257,
3261,
3259,
3263,
3250,
3254,
3246,
3238,
3260,
3266,
]

_charnames_12868 = [
3358,
3353,
3357,
3352,
3367,
3365,
3366,
3372,
3373,
3369,
3370,
3374,
23098,
]

_charnames_19904 = [
21363,
21374,
21388,
21450,
21443,
21431,
21369,
21452,
21404,
21380,
21422,
21406,
21449,
21397,
21446,
21453,
21448,
21442,
21438,
21430,
21435,
21400,
21407,
21416,
21410,
21399,
21445,
21398,
21370,
21364,
21412,
21389,
21417,
21396,
21421,
21390,
21379,
21426,
21427,
21384,
21385,
21413,
21434,
21432,
21401,
21420,
21425,
21372,
21418,
21365,
21368,
21376,
21383,
21375,
21440,
21373,
21378,
21377,
21387,
21451,
21411,
21405,
21439,
21436,
]

_charnames_42192 = [
11202,
11170,
11169,
11189,
11155,
11154,
11184,
11178,
11177,
11199,
11192,
11191,
11188,
11153,
11152,
11197,
11175,
11198,
11167,
11160,
11161,
11174,
11181,
11195,
11180,
11201,
11196,
11166,
11164,
11183,
11193,
11194,
11185,
11186,
11200,
11171,
11156,
11158,
11157,
11172,
11145,
11150,
11148,
11149,
11146,
11147,
11205,
11204,
20330,
20331,
20253,
20190,
20191,
20297,
20236,
20243,
20095,
20134,
20087,
20156,
20313,
20281,
20211,
20204,
20119,
20112,
20263,
20289,
20126,
20055,
20227,
20220,
20180,
20173,
20321,
20305,
20071,
20273,
20144,
20036,
20162,
20102,
20078,
20063,
20335,
20336,
20256,
20257,
20195,
20196,
20299,
20238,
20245,
20097,
20140,
20089,
20158,
20315,
20283,
20213,
20206,
20121,
20114,
20267,
20291,
20128,
20057,
20229,
20222,
20182,
20175,
20323,
20307,
20073,
20275,
20148,
20040,
20166,
20104,
20080,
20065,
20337,
20338,
20044,
20258,
20259,
20197,
20198,
20300,
20239,
20246,
20098,
20137,
20138,
20090,
20159,
20316,
20284,
20214,
20207,
20122,
20115,
20268,
20292,
20129,
20058,
20230,
20223,
20183,
20176,
20324,
20308,
20074,
20276,
20145,
20146,
20041,
20167,
20105,
20081,
20066,
20326,
20327,
20249,
20186,
20187,
20295,
20234,
20241,
20093,
20136,
20085,
20152,
20311,
20279,
20209,
20202,
20117,
20110,
20265,
20287,
20124,
20053,
20225,
20218,
20178,
20171,
20319,
20303,
20069,
20271,
20142,
20038,
20164,
20100,
20076,
20061,
20333,
20334,
20254,
20255,
20193,
20194,
20298,
20237,
20244,
20096,
20139,
20088,
20157,
20314,
20282,
20212,
20205,
20120,
20113,
20266,
20290,
20127,
20056,
20228,
20221,
20181,
20174,
20322,
20306,
20072,
20274,
20147,
20039,
20165,
20103,
20079,
20064,
20325,
20328,
20042,
20248,
20250,
20185,
20188,
20294,
20233,
20240,
20092,
20135,
20084,
20151,
20153,
20310,
20278,
20208,
20201,
20116,
20109,
20264,
20286,
20123,
20046,
20224,
20217,
20177,
20170,
20318,
20302,
20068,
20270,
20141,
20037,
20163,
20099,
20075,
20060,
20329,
20332,
20043,
20251,
20252,
20189,
20192,
20296,
20235,
20242,
20094,
20132,
20133,
20086,
20154,
20155,
20312,
20280,
20210,
20203,
20118,
20111,
20261,
20288,
20125,
20054,
20226,
20219,
20179,
20172,
20320,
20304,
20070,
20272,
20143,
20034,
20035,
20160,
20161,
20101,
20077,
20062,
20032,
20262,
20374,
20373,
20372,
20051,
20050,
20048,
20353,
20351,
20342,
20355,
20357,
20354,
20343,
20348,
20346,
20350,
20341,
20347,
20356,
20368,
20369,
20360,
20361,
20366,
20367,
20363,
20364,
20371,
20370,
20049,
20052,
]

_charnames_42560 = [
3024,
2932,
2961,
2875,
2989,
2887,
3004,
2912,
2966,
2880,
3026,
2943,
3019,
2927,
3034,
2940,
3007,
2915,
3001,
2909,
2987,
2885,
3003,
2911,
3016,
2924,
3020,
2928,
3002,
2910,
3006,
2914,
2988,
2886,
2980,
2895,
2979,
2894,
2978,
2893,
3027,
2944,
3021,
2929,
2964,
2878,
3039,
1733,
1729,
1735,
1728,
8109,
1701,
1681,
1689,
1700,
1708,
1690,
1696,
1706,
1734,
1732,
3041,
3040,
2965,
2879,
2960,
2874,
3023,
2931,
3017,
2925,
2959,
2873,
2973,
2867,
2972,
2865,
2970,
2863,
2971,
2864,
2974,
2868,
3013,
2921,
2982,
2897,
2963,
2877,
3015,
2923,
9561,
9560,
1680,
1683,
13285,
13223,
13281,
13220,
13284,
13249,
13260,
13282,
13206,
13283,
13268,
13191,
13251,
13252,
13267,
13227,
13261,
13209,
13196,
13224,
13241,
13231,
13239,
13242,
13240,
13243,
13219,
13217,
13202,
13201,
13194,
13276,
13237,
13275,
13277,
13207,
13216,
13188,
13195,
13205,
13185,
13279,
13189,
13272,
13253,
13264,
13233,
13208,
13247,
13254,
13218,
13198,
13199,
13200,
13238,
13186,
13270,
13271,
13280,
13210,
13266,
13190,
13265,
13212,
13229,
13248,
13226,
13234,
13262,
13222,
13232,
13230,
13257,
13221,
13258,
13204,
13244,
13273,
13213,
13214,
13290,
13289,
13295,
13296,
13292,
13291,
13293,
13294,
]

_charnames_42752 = [
9553,
9558,
9550,
9555,
9552,
9557,
9551,
9556,
9595,
9623,
9618,
9573,
9589,
9596,
9624,
9619,
9574,
9590,
9597,
9625,
9620,
9570,
9591,
9627,
9628,
9629,
9583,
9604,
9607,
9606,
9605,
9581,
9516,
9515,
11660,
11331,
11661,
11332,
11800,
11571,
11640,
11274,
11641,
11276,
11756,
11514,
11757,
11515,
11861,
11854,
11677,
11421,
11674,
11417,
11673,
11416,
11670,
11413,
11671,
11414,
11672,
11415,
11718,
11398,
11777,
11557,
11780,
11560,
11778,
11558,
11806,
11489,
11766,
11453,
11748,
11440,
11747,
11439,
11749,
11441,
11786,
11551,
11788,
11555,
11787,
11552,
11820,
11588,
11821,
11590,
11714,
11395,
11719,
11402,
11728,
11496,
11725,
11502,
11726,
11503,
11638,
11267,
11639,
11268,
11727,
11504,
11662,
11334,
11705,
11361,
11758,
11516,
9633,
11472,
11458,
11537,
11526,
11401,
11840,
11265,
11380,
11699,
11344,
11698,
11343,
11697,
11636,
11258,
11634,
11262,
11696,
11341,
11695,
11340,
11694,
11339,
9582,
9563,
9518,
11691,
11305,
11637,
11449,
11865,
11824,
11525,
11755,
11513,
11512,
11569,
11805,
11488,
11826,
11598,
11724,
11501,
11723,
11500,
11722,
11499,
11775,
11546,
11782,
11563,
11823,
11523,
11713,
11390,
11684,
11302,
11798,
11716,
11690,
11762,
11688,
11855,
11635,
11633,
11815,
11759,
11807,
11491,
11750,
11442,
11738,
11370,
11773,
11543,
11772,
11542,
11770,
11540,
-1,
-1,
11675,
11418,
11754,
11685,
11810,
11827,
11462,
11682,
11299,
]

_charnames_42997 = [
11717,
11400,
11875,
9529,
9458,
11834,
11871,
11870,
11873,
11874,
11876,
7889,
7886,
7901,
7880,
7888,
7882,
7900,
7866,
7867,
7872,
7873,
7898,
7875,
7876,
7869,
7870,
7849,
7850,
7855,
7856,
7851,
7852,
7857,
7858,
7883,
7863,
7864,
7878,
7879,
7884,
7861,
7885,
7860,
7881,
7887,
7895,
7893,
7891,
7894,
7892,
7906,
7905,
7904,
7903,
7899,
-1,
-1,
-1,
18820,
18821,
18825,
18819,
18822,
18824,
18827,
18830,
18829,
18828,
-1,
-1,
-1,
-1,
-1,
-1,
23222,
23221,
23225,
23194,
23205,
23207,
23237,
23192,
23190,
23189,
23203,
23195,
23219,
23218,
23241,
23235,
23188,
23187,
23201,
23230,
23212,
23213,
23197,
23228,
23232,
23236,
23198,
23199,
23239,
23208,
23238,
23231,
23226,
23234,
23233,
23229,
23240,
23224,
23227,
23246,
23245,
23185,
23184,
23202,
23193,
23210,
23215,
23216,
23209,
23247,
23248,
23206,
23249,
23253,
23251,
23252,
]

_charnames_43136 = [
7450,
7447,
7369,
7372,
7393,
7394,
7377,
7378,
7347,
7348,
7349,
7350,
7398,
7399,
7371,
7382,
7383,
7370,
7389,
7388,
7397,
7396,
7361,
7402,
7401,
7392,
7391,
7359,
7355,
7354,
7366,
7365,
7360,
7357,
7356,
7368,
7367,
7362,
7381,
7380,
7405,
7404,
7408,
7406,
7407,
7386,
7351,
7375,
7374,
7376,
7409,
7385,
7451,
7419,
7424,
7425,
7420,
7421,
7412,
7413,
7414,
7415,
7426,
7427,
7418,
7422,
7423,
7417,
7448,
7449,
]

_charnames_43214 = [
7444,
7443,
7439,
7440,
7431,
7432,
7437,
7438,
7434,
7435,
7442,
7441,
-1,
-1,
-1,
-1,
-1,
-1,
1812,
1813,
1804,
1805,
1810,
1811,
1807,
1808,
1815,
1814,
1823,
1818,
1822,
1821,
1820,
1819,
1817,
1824,
24318,
24315,
24323,
24313,
24314,
24316,
24320,
24338,
24339,
24337,
24319,
24336,
24300,
24332,
19935,
19936,
19927,
19928,
19933,
19934,
19930,
19931,
19938,
19937,
19908,
19907,
19920,
19892,
19899,
19898,
19912,
19891,
19896,
19910,
19893,
19902,
19901,
19917,
19921,
19923,
19916,
19913,
19918,
19914,
19895,
19911,
19915,
19922,
19924,
19905,
19919,
19904,
19941,
19942,
19940,
19943,
19944,
19948,
19946,
19947,
19951,
19950,
25336,
25339,
25323,
25331,
25340,
25325,
25334,
25342,
25328,
25341,
25337,
25320,
25332,
25333,
25335,
25329,
25330,
25338,
25327,
25322,
25324,
25319,
25343,
25354,
25352,
25346,
25351,
25353,
25350,
25347,
25348,
25358,
25357,
25359,
25360,
25355,
]

_charnames_43359 = [
25361,
21711,
21710,
21708,
21712,
21700,
21697,
21703,
21695,
21705,
21704,
21696,
21702,
21698,
21706,
21701,
21731,
21729,
21730,
21720,
21721,
21722,
21716,
21733,
21734,
21717,
21715,
21723,
21736,
21714,
-1,
-1,
-1,
26767,
26764,
26768,
26766,
26705,
26694,
26692,
26693,
26709,
26687,
26664,
26665,
26714,
26706,
26710,
26688,
26690,
26691,
26699,
26700,
26663,
26701,
26702,
26697,
26667,
26698,
26666,
26671,
26672,
26676,
26677,
26669,
26673,
26674,
26678,
26679,
26668,
26684,
26686,
26703,
26704,
26711,
26707,
26695,
26696,
26712,
26708,
26682,
26683,
26680,
26713,
26765,
26754,
26756,
26757,
26758,
26759,
26760,
26755,
26762,
26761,
26771,
26770,
26772,
26736,
26715,
26774,
26726,
26732,
26721,
26730,
26729,
26722,
26720,
26724,
26725,
26728,
26773,
-1,
26735,
26747,
26748,
26739,
26740,
26745,
26746,
26742,
26743,
26750,
26749,
-1,
-1,
-1,
-1,
26731,
26733,
10041,
10044,
10052,
10035,
10047,
10143,
10235,
10096,
10108,
10103,
10102,
10100,
10099,
10092,
10091,
10097,
10215,
10216,
10207,
10208,
10213,
10214,
10210,
10211,
10218,
10217,
10107,
10094,
10093,
10106,
10105,
-1,
2259,
2267,
2263,
2269,
2260,
2265,
2249,
2248,
2255,
2254,
2222,
2223,
2258,
2257,
2252,
2251,
2218,
2220,
2219,
2240,
2239,
2233,
2231,
2224,
2225,
2232,
2229,
2227,
2228,
2237,
2235,
2245,
2246,
2236,
2261,
2264,
2266,
2262,
2242,
2243,
2268,
2274,
2279,
2280,
2281,
2275,
2278,
2277,
2273,
2272,
2276,
2301,
2303,
2304,
2302,
]

_charnames_43584 = [
2213,
2214,
2206,
2298,
2215,
2208,
2205,
2211,
2207,
2210,
2212,
2209,
2299,
2300,
-1,
-1,
2292,
2293,
2284,
2285,
2290,
2291,
2287,
2288,
2295,
2294,
-1,
-1,
2310,
2308,
2307,
2309,
10086,
10081,
10080,
10075,
10074,
10071,
10069,
10068,
10065,
10064,
10066,
10072,
10084,
10078,
10077,
10087,
10236,
10083,
10082,
10085,
10128,
10127,
10129,
10177,
10176,
10175,
10125,
10157,
10152,
10151,
10059,
10058,
4914,
4945,
4912,
4943,
4913,
4944,
4932,
4963,
4909,
4940,
4922,
4953,
4923,
4954,
4926,
4957,
4907,
4938,
4934,
4965,
4916,
4947,
4917,
4948,
4908,
4939,
4935,
4966,
4919,
4950,
4920,
4951,
4933,
4964,
4929,
4960,
4924,
4955,
4927,
4958,
4930,
4961,
4925,
4956,
4931,
4962,
4928,
4959,
4996,
4973,
4978,
4975,
4974,
4981,
4980,
4995,
4979,
4976,
4977,
4970,
4969,
4971,
4972,
4993,
4992,
4990,
4991,
]

_charnames_43739 = [
4984,
4987,
4986,
4988,
4985,
8766,
8764,
8756,
8715,
8720,
8719,
8727,
8726,
8716,
8732,
8731,
8782,
8778,
8774,
8775,
8773,
8810,
8807,
8806,
8812,
8811,
8784,
8789,
]

_charnames_43777 = [
15676,
15678,
15679,
15675,
15674,
15677,
-1,
-1,
15629,
15631,
15632,
15628,
15627,
15630,
-1,
-1,
15637,
15639,
15640,
15636,
15635,
15638,
]

_charnames_43808 = [
15586,
15588,
15590,
15587,
15585,
15584,
15589,
-1,
15662,
15664,
15666,
15663,
15661,
15660,
15665,
-1,
11483,
11412,
11479,
11482,
11326,
11459,
11291,
11452,
11446,
11451,
11533,
11521,
11335,
11477,
11478,
11426,
11346,
11246,
11247,
11248,
11249,
11307,
11841,
11394,
11468,
11393,
11469,
11289,
11290,
11484,
11371,
11377,
11381,
11261,
11376,
11506,
11508,
11509,
11579,
11575,
11578,
11577,
11595,
9636,
9512,
9457,
9456,
9466,
11306,
11359,
11430,
11379,
11347,
24610,
11471,
11275,
11256,
9435,
9584,
9609,
-1,
-1,
-1,
-1,
2519,
2518,
2517,
2515,
2514,
2513,
2512,
2516,
2511,
2510,
2509,
2508,
2507,
2462,
2461,
2460,
2458,
2457,
2456,
2505,
2504,
2503,
2502,
2501,
2500,
2498,
2497,
2496,
2495,
2494,
2448,
2459,
2449,
2454,
2453,
2452,
2451,
2450,
2491,
2490,
2489,
2488,
2487,
2486,
2446,
2440,
2445,
2444,
2443,
2442,
2441,
2470,
2439,
2469,
2438,
2468,
2437,
2466,
2465,
2464,
2467,
2436,
2435,
2434,
2433,
2432,
2431,
2429,
2428,
2427,
2426,
2425,
2424,
2484,
2483,
2482,
2481,
2480,
2479,
2477,
8739,
8733,
8744,
8742,
8735,
8713,
8755,
8721,
8741,
8711,
8723,
8761,
8760,
8765,
8762,
8749,
8737,
8767,
8752,
8748,
8763,
8759,
8747,
8728,
8753,
8729,
8758,
8740,
8745,
8743,
8736,
8714,
8722,
8712,
8750,
8786,
8781,
8776,
8783,
8785,
8779,
8788,
8787,
8809,
8768,
8805,
-1,
-1,
8800,
8801,
8792,
8793,
8798,
8799,
8795,
8796,
8803,
8802,
]

_charnames_55216 = [
21676,
21677,
21664,
21665,
21666,
21689,
21690,
21669,
21668,
21682,
21680,
21679,
21681,
21657,
21656,
21654,
21653,
21660,
21659,
21658,
21661,
21686,
21685,
-1,
-1,
-1,
-1,
21645,
21646,
21571,
21572,
21623,
21617,
21618,
21620,
21621,
21622,
21613,
21615,
21577,
21614,
21611,
21612,
21608,
21609,
21631,
21642,
21640,
21580,
21641,
21643,
21596,
21598,
21599,
21578,
21597,
21594,
21595,
21588,
21589,
21575,
21574,
21587,
21584,
21585,
21586,
21590,
21604,
21605,
21637,
21638,
21649,
21648,
21581,
21602,
21601,
]

_charnames_64107 = [
3229,
3228,
3227,
-1,
-1,
3214,
3213,
3212,
3211,
3210,
3209,
3208,
3207,
3206,
3205,
3204,
3203,
3202,
3201,
3200,
3199,
3197,
3196,
3195,
3194,
3193,
3192,
3191,
3190,
3189,
3188,
3187,
3186,
3185,
3184,
3183,
3182,
3180,
3179,
3178,
3177,
3176,
3175,
3174,
3173,
3172,
3171,
3170,
3169,
3168,
3167,
3166,
3165,
3163,
3162,
3161,
3160,
3159,
3158,
3157,
3156,
3155,
3154,
3153,
3152,
3151,
3150,
3149,
3148,
3146,
3145,
3144,
3143,
3142,
3141,
3140,
3139,
3138,
3137,
3136,
3135,
3134,
3133,
3132,
3131,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3121,
3120,
3119,
3118,
3117,
3116,
3115,
3114,
3225,
3224,
3223,
3222,
3221,
3220,
3219,
3218,
3217,
3216,
]

_charnames_64434 = [
17019,
17018,
17009,
17008,
17015,
17014,
17013,
17012,
17026,
17025,
17020,
17007,
17006,
17027,
17023,
17022,
]

_charnames_65040 = [
23568,
23566,
23565,
23569,
23570,
23573,
23571,
23562,
23558,
23572,
]

_charnames_65060 = [
1874,
1872,
1736,
1796,
1795,
1895,
1894,
1875,
1873,
1737,
1727,
1726,
]

_charnames_65536 = [
10959,
10987,
10949,
10974,
11002,
10966,
10979,
10960,
10998,
10945,
10940,
10978,
-1,
10989,
10972,
10929,
10980,
10970,
10936,
11006,
11007,
10999,
10933,
10997,
10954,
10961,
10953,
10993,
10944,
10941,
10964,
10934,
10986,
11001,
10946,
10996,
10928,
10955,
10991,
-1,
10975,
10950,
10943,
10965,
10951,
10992,
10958,
10983,
11000,
10939,
10938,
10963,
10988,
10962,
10968,
10942,
10931,
10984,
10982,
-1,
10995,
10932,
-1,
10956,
10952,
10981,
11005,
10935,
11010,
10977,
10948,
10973,
10930,
10990,
10969,
10971,
11004,
11009,
-1,
-1,
11025,
11024,
11029,
11028,
11022,
11021,
11027,
11019,
11018,
11026,
11016,
11015,
11014,
11013,
]

_charnames_65664 = [
10803,
10802,
10801,
10788,
10787,
10786,
10800,
10799,
10797,
10796,
10794,
10793,
10791,
10790,
10853,
10852,
10851,
10850,
10849,
11037,
11036,
10857,
10856,
10855,
11034,
11033,
10847,
10846,
10845,
10844,
10843,
10833,
10832,
10831,
10830,
10829,
11038,
10828,
10827,
10826,
10814,
10813,
10812,
10811,
10810,
10809,
10808,
10807,
10806,
10805,
10824,
10823,
10822,
10821,
10820,
10819,
10818,
10817,
10816,
10841,
10840,
10839,
10838,
10837,
10836,
10835,
10860,
10859,
10890,
10889,
10887,
10886,
10885,
10884,
10883,
10882,
10880,
10879,
10878,
10877,
10876,
10875,
11039,
10874,
10873,
10871,
10870,
10869,
10868,
10867,
10866,
10865,
10864,
10863,
10924,
10914,
10913,
10912,
10911,
10910,
10909,
10908,
10907,
10906,
10905,
10903,
10902,
10901,
10900,
10899,
10898,
10897,
10896,
10895,
10894,
10921,
10920,
10919,
10918,
10917,
10916,
10922,
10923,
-1,
-1,
-1,
-1,
-1,
17571,
17572,
17578,
-1,
-1,
-1,
-1,
17558,
17503,
17510,
17533,
17540,
17519,
17525,
17552,
17546,
17516,
17507,
17514,
17537,
17544,
17520,
17526,
17553,
17547,
17561,
17506,
17513,
17536,
17543,
17524,
17530,
17557,
17551,
17560,
17505,
17512,
17535,
17542,
17523,
17529,
17556,
17550,
17517,
17508,
17515,
17538,
17545,
17521,
17527,
17554,
17548,
-1,
-1,
-1,
17569,
17566,
17568,
17567,
17565,
17577,
17576,
17575,
17574,
24443,
24439,
24444,
24416,
24427,
24422,
24419,
24430,
24421,
24448,
24432,
24437,
24424,
24441,
24420,
24426,
24449,
24433,
24438,
24425,
24442,
24447,
24431,
24450,
24481,
24459,
24479,
24483,
24457,
24487,
24484,
24470,
24474,
24475,
24478,
24491,
24458,
24456,
24472,
24473,
24480,
24467,
24462,
24455,
24485,
24471,
24466,
24488,
24490,
24461,
24465,
24492,
24489,
24625,
24626,
24616,
24619,
24637,
24622,
24642,
24629,
24617,
24620,
24634,
24635,
24632,
24640,
24613,
24628,
24638,
24494,
24495,
24641,
24621,
24636,
24627,
24587,
24536,
18877,
-1,
25512,
25526,
25514,
25511,
25524,
25515,
25525,
25527,
25513,
25523,
25529,
25528,
17665,
-1,
-1,
-1,
24586,
]

_charnames_66000 = [
23285,
23283,
23290,
23263,
23265,
23296,
23294,
23309,
23289,
23317,
23276,
23269,
23264,
23303,
23302,
23273,
23306,
23277,
23262,
23312,
23257,
23272,
23259,
23279,
23268,
23292,
23293,
23280,
23261,
23300,
23316,
23311,
23288,
23278,
23284,
23313,
23286,
23299,
23305,
23314,
23315,
23308,
23270,
23271,
23297,
23258,
]

_charnames_66176 = [
12229,
12225,
12227,
12228,
12243,
12244,
12241,
12233,
12231,
12218,
12240,
12223,
12237,
12239,
12221,
12219,
12222,
12220,
12234,
12238,
12224,
12236,
12235,
12216,
12217,
12230,
12226,
12242,
12232,
-1,
-1,
-1,
2745,
2731,
2740,
2725,
2703,
2728,
2726,
2746,
2748,
2750,
2713,
2749,
2741,
2722,
2710,
2711,
2707,
2744,
2701,
2719,
2747,
2718,
2724,
2730,
2712,
2734,
2738,
2704,
2732,
2733,
2721,
2702,
2736,
2737,
2708,
2709,
2720,
2735,
2743,
2723,
2706,
2729,
2714,
2717,
2716,
2715,
2727,
2739,
2705,
]

_charnames_66272 = [
2130,
2127,
2119,
2120,
2125,
2126,
2122,
2123,
2129,
2128,
2095,
2091,
2094,
2106,
2109,
2098,
2101,
2114,
2111,
2116,
2090,
2093,
2105,
2108,
2099,
2102,
2115,
2112,
]

_charnames_66384 = [
22186,
22185,
22183,
22161,
22173,
22163,
22160,
22164,
22159,
22154,
22181,
22180,
22179,
22178,
22166,
22177,
22176,
22153,
22170,
22175,
22184,
22151,
22152,
22148,
22143,
22171,
22172,
22174,
22182,
22169,
22167,
22142,
22144,
22146,
22155,
22147,
22145,
22156,
1867,
1866,
1863,
1865,
1864,
-1,
-1,
-1,
-1,
-1,
26460,
26472,
26455,
26449,
26458,
26451,
26463,
26447,
26452,
26444,
26462,
26450,
26440,
26470,
26469,
26457,
26468,
26446,
26437,
26461,
26467,
26438,
26466,
26465,
26443,
26454,
26442,
26471,
26464,
26439,
-1,
26473,
22080,
22126,
22123,
22114,
22113,
22120,
22119,
22102,
22129,
22117,
22116,
22087,
22085,
22075,
22079,
22078,
22086,
22124,
22097,
22128,
22111,
22110,
22095,
22094,
22093,
22122,
22105,
22104,
22108,
22107,
22125,
22091,
22121,
22090,
22089,
22127,
-1,
-1,
-1,
-1,
22081,
22083,
22082,
22101,
22076,
22077,
22098,
22099,
22138,
22136,
22133,
22135,
22134,
22137,
]

_charnames_66638 = [
24351,
24352,
7296,
7272,
7299,
7302,
7270,
7285,
7284,
7304,
7279,
7290,
7305,
7303,
7301,
7293,
7271,
7292,
7288,
7300,
7282,
7291,
7298,
7287,
7274,
7267,
7250,
7254,
7259,
7281,
7256,
7252,
7295,
7297,
7264,
7253,
7275,
7294,
7261,
7258,
7260,
7249,
7248,
7257,
7251,
7266,
7247,
7265,
7276,
7278,
22585,
22616,
22604,
22610,
22601,
22593,
22599,
22605,
22589,
22588,
22598,
22615,
22613,
22614,
22606,
22594,
22609,
22608,
22607,
22602,
22612,
22600,
22584,
22595,
22611,
22590,
22603,
22586,
22596,
22591,
-1,
-1,
22627,
22628,
22619,
22620,
22625,
22626,
22622,
22623,
22630,
22629,
-1,
-1,
-1,
-1,
-1,
-1,
22547,
22548,
22549,
22550,
22581,
22580,
22545,
22538,
22546,
22570,
22569,
22577,
22559,
22544,
22557,
22576,
22575,
22574,
22566,
22567,
22573,
22543,
22565,
22564,
22555,
22542,
22554,
22541,
22553,
22579,
22572,
22571,
22558,
22578,
22562,
22561,
-1,
-1,
-1,
-1,
22502,
22503,
22504,
22505,
22536,
22535,
22500,
22493,
22501,
22525,
22524,
22532,
22514,
22499,
22512,
22531,
22530,
22529,
22521,
22522,
22528,
22498,
22520,
22519,
22510,
22497,
22509,
22496,
22508,
22534,
22527,
22526,
22513,
22533,
22517,
22516,
-1,
-1,
-1,
-1,
15822,
15821,
15808,
15807,
15805,
15775,
15804,
15802,
15801,
15820,
15782,
15781,
15819,
15818,
15817,
15800,
15797,
15796,
15816,
15774,
15776,
15773,
15815,
15814,
15813,
15794,
15793,
15791,
15790,
15788,
15787,
15812,
15811,
15810,
15809,
15785,
15784,
15779,
15780,
15799,
]

_charnames_66864 = [
2828,
2837,
2821,
2788,
2825,
2793,
2824,
2791,
2797,
2767,
2803,
2792,
2800,
2779,
2813,
2801,
2829,
2787,
2776,
2818,
2816,
2812,
2835,
2806,
2827,
2769,
2770,
2772,
2834,
2807,
2833,
2785,
2780,
2819,
2832,
2795,
2836,
2786,
2768,
2810,
2822,
2831,
2782,
2830,
2796,
2781,
2799,
2773,
2775,
2804,
2809,
2815,
]

_charnames_67072 = [
10420,
10419,
10418,
10417,
10416,
10415,
10414,
10413,
10412,
10464,
10463,
10462,
10461,
10460,
10400,
10390,
10392,
10391,
10387,
10389,
10388,
10393,
10394,
10399,
10398,
10397,
10396,
10779,
10395,
10458,
10457,
10456,
10455,
10454,
10453,
10429,
10428,
10427,
10426,
10425,
10424,
10423,
10422,
10410,
10409,
10408,
10407,
10406,
10405,
10404,
10403,
10402,
10451,
10450,
10449,
10448,
10447,
10446,
10437,
10436,
10435,
10434,
10433,
10432,
10431,
10444,
10443,
10442,
10441,
10440,
10439,
10778,
10479,
10469,
10777,
10468,
10467,
10475,
10474,
10776,
10478,
10477,
10472,
10471,
10476,
10598,
10597,
10596,
10595,
10594,
10593,
10592,
10591,
10590,
10589,
10588,
10585,
10584,
10583,
10576,
10575,
10574,
10582,
10581,
10580,
10579,
10578,
10577,
10653,
10652,
10651,
10650,
10649,
10648,
10647,
10646,
10645,
10644,
10642,
10641,
10640,
10639,
10638,
10637,
10636,
10635,
10634,
10633,
10631,
10630,
10629,
10628,
10627,
10626,
10625,
10624,
10623,
10622,
10620,
10619,
10618,
10617,
10616,
10615,
10614,
10613,
10612,
10611,
10609,
10608,
10607,
10606,
10605,
10604,
10603,
10602,
10601,
10600,
10656,
10655,
10755,
10754,
10753,
10752,
10751,
10750,
10749,
10748,
10747,
10746,
10765,
10764,
10763,
10762,
10761,
10760,
10759,
10758,
10757,
10541,
10540,
10539,
10538,
10537,
10536,
10535,
10534,
10570,
10569,
10568,
10567,
10566,
10565,
10532,
10531,
10530,
10529,
10528,
10527,
10526,
10525,
10524,
10522,
10521,
10520,
10519,
10518,
10517,
10516,
10515,
10514,
10549,
10548,
10547,
10546,
10545,
10544,
10543,
10512,
10511,
10510,
10509,
10508,
10507,
10506,
10505,
10504,
10563,
10562,
10561,
10560,
10559,
10558,
10502,
10501,
10500,
10499,
10498,
10497,
10496,
10495,
10494,
10493,
10491,
10490,
10489,
10488,
10487,
10486,
10485,
10484,
10483,
10482,
10556,
10555,
10554,
10553,
10552,
10551,
10706,
10705,
10704,
10703,
10702,
10701,
10700,
10699,
10668,
10667,
10666,
10665,
10664,
10663,
10662,
10661,
10660,
10659,
10688,
10687,
10686,
10685,
10684,
10683,
10682,
10681,
10680,
10716,
10715,
10714,
10697,
10696,
10695,
10694,
10693,
10692,
10691,
10690,
10678,
10677,
10676,
10675,
10674,
10673,
10672,
10671,
10670,
10712,
10711,
10710,
10709,
10708,
]

_charnames_67392 = [
10733,
10732,
10731,
10730,
10729,
10728,
10727,
10726,
10725,
10724,
10723,
10722,
10721,
10741,
10740,
10739,
10738,
10737,
10736,
10735,
10743,
10742,
]

_charnames_67424 = [
10774,
10773,
10772,
10771,
10770,
10769,
10768,
10767,
]

_charnames_67584 = [
3109,
3108,
3107,
3106,
3105,
3104,
-1,
-1,
3103,
-1,
3090,
3089,
3088,
3087,
3086,
3084,
3083,
3082,
3081,
3080,
3078,
3077,
3076,
3075,
3074,
3072,
3071,
3070,
3069,
3068,
3066,
3065,
3064,
3063,
3062,
3060,
3059,
3058,
3057,
3056,
3054,
3053,
3052,
3051,
3050,
3048,
3047,
3046,
3045,
3044,
3095,
3094,
3093,
3092,
-1,
3101,
3100,
-1,
-1,
-1,
3098,
-1,
-1,
3097,
26258,
26271,
26269,
26270,
26254,
26261,
26259,
26255,
26252,
26260,
26268,
26267,
26266,
26265,
26248,
26257,
26264,
26249,
26263,
26262,
26250,
26253,
-1,
26284,
26280,
26275,
26279,
26277,
26276,
26283,
26282,
26278,
23122,
23136,
23133,
23135,
23118,
23125,
23123,
23119,
23116,
23124,
23132,
23131,
23130,
23134,
23129,
23112,
23121,
23128,
23113,
23127,
23126,
23114,
23117,
23137,
23149,
23148,
23141,
23143,
23146,
23147,
23144,
23142,
18597,
18610,
18596,
18623,
18621,
18622,
18595,
18606,
18613,
18611,
18607,
18604,
18589,
18612,
18594,
18620,
18593,
18619,
18592,
18618,
18591,
18617,
18600,
18609,
18616,
18601,
18615,
18614,
18590,
18602,
18605,
]

_charnames_67751 = [
18631,
18627,
18629,
18634,
18636,
18635,
18630,
18628,
18632,
]

_charnames_67808 = [
21825,
21837,
21835,
21836,
21821,
21828,
21826,
21822,
21819,
21827,
21834,
21833,
21832,
21831,
21815,
21824,
21830,
21816,
21829,
-1,
21817,
21820,
-1,
-1,
-1,
-1,
-1,
21842,
21844,
21841,
21840,
21843,
23331,
23345,
23343,
23344,
23328,
23335,
23333,
23329,
23326,
23334,
23342,
23341,
23340,
23339,
23323,
23332,
23338,
23324,
23337,
23336,
23322,
23327,
23353,
23352,
23350,
23354,
23349,
23351,
-1,
-1,
-1,
23355,
12257,
12272,
12268,
12270,
12255,
12260,
12267,
12259,
12266,
12253,
12265,
12251,
12264,
12262,
12250,
12247,
12261,
12269,
12263,
12249,
12248,
12258,
12256,
12254,
12252,
12271,
-1,
-1,
-1,
-1,
-1,
12273,
]

_charnames_67968 = [
8566,
8564,
8562,
8559,
8555,
8556,
8553,
8554,
8558,
8560,
8542,
8543,
8540,
8541,
8548,
8549,
8561,
8551,
8563,
8545,
8546,
8547,
8552,
8557,
8536,
8537,
8534,
8535,
8538,
8565,
8567,
8568,
8495,
8507,
8505,
8502,
8497,
8498,
8509,
8501,
8503,
8491,
8490,
8499,
8504,
8493,
8506,
8488,
8496,
8487,
8494,
8500,
8485,
8484,
8483,
8508,
-1,
-1,
-1,
-1,
8528,
8523,
8511,
8512,
8475,
8414,
8422,
8448,
8456,
8432,
8439,
8469,
8463,
8429,
8419,
8427,
8453,
8461,
8437,
8444,
-1,
-1,
8477,
8416,
8424,
8450,
8458,
8434,
8441,
8471,
8465,
8479,
8418,
8426,
8452,
8460,
8436,
8443,
8473,
8467,
8430,
8420,
8428,
8454,
8462,
8438,
8445,
8474,
8468,
8478,
8417,
8425,
8451,
8459,
8435,
8442,
8472,
8466,
8522,
8515,
8516,
8525,
8526,
8519,
8520,
8529,
8530,
8517,
19668,
19689,
19687,
19686,
-1,
19690,
19688,
-1,
-1,
-1,
-1,
-1,
19691,
19695,
19700,
19697,
19645,
19644,
19654,
19653,
-1,
19657,
19656,
19666,
-1,
19639,
19625,
19624,
19631,
19630,
19640,
19627,
19626,
19633,
19632,
19641,
19651,
19650,
19660,
19659,
19664,
19662,
19663,
19665,
19648,
19636,
19635,
19637,
19661,
19667,
19643,
19622,
19623,
19647,
-1,
-1,
19699,
19698,
19696,
-1,
-1,
-1,
-1,
19692,
19712,
19710,
19711,
19713,
19704,
19703,
19707,
19706,
19714,
]

_charnames_68176 = [
19673,
19681,
19680,
19679,
19682,
19676,
19674,
19672,
19677,
]

_charnames_68192 = [
22344,
22359,
22345,
22358,
22356,
22354,
22335,
22355,
22361,
22329,
22332,
22343,
22357,
22342,
22334,
22333,
22360,
22351,
22350,
22339,
22347,
22340,
22348,
22328,
22352,
22338,
22353,
22327,
22326,
22364,
22365,
22366,
22386,
22404,
22387,
22403,
22401,
22398,
22377,
22400,
22406,
22373,
22378,
22384,
22402,
22383,
22399,
22376,
22405,
22395,
22396,
22393,
22390,
22392,
22389,
22374,
22380,
22372,
22397,
22371,
22381,
22411,
22410,
22409,
]

_charnames_68288 = [
8851,
8878,
8877,
8871,
8872,
8875,
8868,
8880,
8906,
8855,
8854,
8867,
8866,
8869,
8847,
8879,
8864,
8858,
8863,
8885,
8874,
8846,
8884,
8883,
8841,
8850,
8852,
8882,
8886,
8842,
8860,
8857,
8861,
8881,
8844,
8843,
8848,
8905,
8904,
-1,
-1,
-1,
-1,
8900,
8902,
8899,
8898,
8901,
8893,
8895,
8891,
8890,
8889,
8892,
8894,
]

_charnames_68352 = [
17583,
17584,
17589,
17585,
17590,
17586,
17587,
17588,
17632,
17633,
17625,
17626,
17627,
17628,
17623,
17624,
17645,
17608,
17606,
17607,
17616,
17615,
17614,
17648,
17646,
17612,
17611,
17636,
17635,
17610,
17642,
17647,
17639,
17638,
17595,
17593,
17594,
17598,
17596,
17597,
17643,
17630,
17621,
17622,
17640,
17641,
17644,
17604,
17619,
17602,
17618,
17601,
17603,
17631,
-1,
-1,
-1,
17649,
5351,
8085,
11900,
11886,
11899,
11885,
26146,
26159,
26157,
26158,
26142,
26149,
26147,
26143,
26140,
26148,
26156,
26155,
26154,
26153,
26136,
26145,
26152,
26137,
26151,
26150,
26138,
26141,
-1,
-1,
26167,
26163,
26165,
26171,
26166,
26164,
26170,
26169,
26195,
26194,
26192,
26193,
26182,
26186,
26184,
26183,
26180,
26185,
26191,
26190,
26189,
26188,
26176,
26187,
26177,
26178,
26181,
-1,
-1,
-1,
-1,
-1,
26203,
26199,
26201,
26207,
26202,
26200,
26206,
26205,
23497,
23496,
23494,
23495,
23483,
23487,
23485,
23484,
23486,
23493,
23492,
23491,
23490,
23480,
23489,
23481,
23482,
23488,
]

_charnames_68521 = [
23505,
23501,
23503,
23507,
23504,
23502,
23506,
]

_charnames_68608 = [
22189,
22235,
22236,
22230,
22266,
22254,
22224,
22225,
22263,
22211,
22253,
22200,
22243,
22209,
22251,
22198,
22242,
22210,
22252,
22199,
22218,
22259,
22203,
22244,
22191,
22239,
22197,
22241,
22226,
22264,
22208,
22250,
22196,
22222,
22221,
22207,
22195,
22237,
22215,
22257,
22217,
22258,
22214,
22256,
22249,
22216,
22238,
22220,
22229,
22232,
22223,
22261,
22206,
22248,
22231,
22267,
22228,
22265,
22205,
22247,
22194,
22201,
22193,
22202,
22246,
22219,
22260,
22204,
22245,
22192,
22240,
22227,
22233,
]

_charnames_68736 = [
22039,
22043,
22038,
22041,
22014,
22013,
22015,
22037,
22040,
22008,
22060,
22036,
22035,
22027,
22028,
22034,
22057,
22058,
22033,
22032,
22042,
22047,
22025,
22026,
22023,
22009,
22012,
22048,
22049,
22056,
22053,
22050,
22031,
22024,
22030,
22059,
22021,
22022,
22019,
22010,
22020,
22016,
22044,
22045,
22055,
22052,
22029,
22017,
22018,
22011,
22046,
]

_charnames_68800 = [
21985,
21989,
21984,
21987,
21960,
21959,
21961,
21983,
21986,
21954,
22006,
21982,
21981,
21973,
21974,
21980,
22003,
22004,
21979,
21978,
21988,
21993,
21971,
21972,
21969,
21955,
21958,
21994,
21995,
22002,
21999,
21996,
21977,
21970,
21976,
22005,
21967,
21968,
21965,
21956,
21966,
21962,
21990,
21991,
22001,
21998,
21975,
21963,
21964,
21957,
21992,
]

_charnames_68858 = [
22062,
22067,
22069,
22068,
22065,
22064,
21774,
21773,
21765,
21751,
21750,
21768,
21772,
21769,
21743,
21771,
21760,
21759,
21757,
21756,
21761,
21754,
21753,
21744,
21770,
21767,
21766,
21748,
21763,
21742,
21762,
21741,
21747,
21746,
21764,
21794,
21792,
21790,
21793,
21791,
21802,
21803,
21800,
21799,
21798,
21797,
]

_charnames_68912 = [
21785,
21786,
21777,
21778,
21783,
21784,
21780,
21781,
21788,
21787,
]

_charnames_69216 = [
25473,
25465,
25466,
25471,
25472,
25468,
25469,
25475,
25474,
25441,
25437,
25440,
25452,
25455,
25444,
25447,
25460,
25457,
25462,
25436,
25439,
25451,
25454,
25445,
25448,
25461,
25458,
25480,
25479,
25478,
25481,
-1,
26916,
26962,
26941,
26940,
26934,
26910,
26925,
26923,
26924,
26948,
26930,
26951,
26919,
26938,
26937,
26918,
26959,
26908,
26909,
26911,
26952,
26935,
26920,
26913,
26929,
26961,
26931,
26932,
26955,
26946,
26945,
26960,
26942,
26958,
26957,
26954,
26953,
26956,
26914,
26949,
26926,
26915,
-1,
26965,
26964,
26966,
-1,
-1,
26943,
26927,
]

_charnames_69376 = [
22290,
22281,
22305,
22280,
22304,
22292,
22279,
22296,
22294,
22293,
22295,
22303,
22302,
22301,
22300,
22277,
22278,
22284,
22291,
22289,
22299,
22285,
22275,
22276,
22298,
22286,
22297,
22273,
22274,
22316,
22310,
22313,
22319,
22320,
22315,
22311,
22314,
22317,
22321,
22306,
]

_charnames_69424 = [
6989,
7001,
6999,
6985,
6992,
6990,
6986,
6991,
6998,
6984,
6997,
6996,
6979,
6988,
6995,
6980,
6994,
6981,
6993,
7000,
6983,
7031,
7010,
7004,
7011,
7005,
7014,
7013,
7008,
7007,
7017,
7016,
7015,
7029,
7028,
7027,
7030,
7020,
7021,
7024,
7022,
7023,
]

_charnames_69552 = [
2542,
2535,
2556,
2553,
2554,
2538,
2545,
2555,
2543,
2539,
2544,
2552,
2551,
2550,
2549,
2537,
2541,
2548,
2547,
2536,
2546,
2564,
2560,
2562,
2566,
2563,
2561,
2565,
]

_charnames_69600 = [
15837,
15850,
15848,
15849,
15833,
15840,
15838,
15834,
15831,
15839,
15847,
15846,
15845,
15844,
15827,
15836,
15843,
15828,
15842,
15841,
15829,
15832,
15851,
]

_charnames_69632 = [
14012,
14013,
14009,
14011,
14010,
13904,
13907,
13926,
13927,
13912,
13913,
13877,
13878,
13879,
13880,
13941,
13906,
13888,
13905,
13922,
13921,
13930,
13929,
13896,
13933,
13932,
13925,
13924,
13894,
13885,
13884,
13901,
13900,
13895,
13887,
13886,
13903,
13902,
13897,
13916,
13915,
13936,
13935,
13939,
13937,
13938,
13919,
13881,
13910,
13909,
13911,
13940,
13918,
13892,
13890,
13891,
13982,
13989,
13985,
13986,
13983,
13984,
13975,
13976,
13977,
13978,
13988,
13981,
13987,
13980,
13990,
14007,
14006,
14020,
14019,
14017,
14021,
14016,
-1,
-1,
-1,
-1,
13963,
13945,
13948,
13958,
13961,
13952,
13954,
13969,
13967,
13950,
13946,
13949,
13959,
13962,
13953,
13955,
13970,
13968,
13966,
13965,
14002,
14003,
13994,
13995,
14000,
14001,
13997,
13998,
14005,
14004,
]

_charnames_69759 = [
13971,
19876,
19877,
19873,
19819,
19822,
19841,
19842,
19827,
19828,
19858,
19821,
19854,
19820,
19837,
19836,
19845,
19844,
19817,
19848,
19847,
19840,
19839,
19815,
19811,
19810,
19805,
19804,
19803,
19830,
19816,
19813,
19812,
19807,
19806,
19818,
19834,
19833,
19851,
19850,
19855,
19852,
19831,
19856,
19853,
19825,
19824,
19826,
19857,
19863,
19866,
19867,
19864,
19865,
19869,
19862,
19868,
19861,
19874,
19875,
19887,
19886,
19884,
19878,
19881,
19883,
19882,
]

_charnames_69837 = [
19885,
-1,
-1,
7048,
7047,
7060,
7059,
7058,
7057,
7039,
7036,
7052,
7037,
7045,
7050,
7044,
7049,
7056,
7053,
7054,
7035,
7061,
7043,
7055,
7046,
7051,
7042,
7040,
]

_charnames_69872 = [
7072,
7073,
7064,
7065,
7070,
7071,
7067,
7068,
7075,
7074,
-1,
-1,
-1,
-1,
-1,
-1,
2399,
2400,
2398,
2363,
2360,
2356,
2362,
2341,
2340,
2347,
2346,
2322,
2350,
2349,
2344,
2343,
2320,
2316,
2315,
2327,
2326,
2321,
2318,
2317,
2329,
2328,
2323,
2335,
2334,
2353,
2352,
2359,
2331,
2332,
2358,
2338,
2354,
2357,
2361,
2366,
2374,
2375,
2370,
2371,
2376,
2368,
2372,
2367,
2373,
2403,
2405,
2378,
2404,
-1,
2390,
2391,
2382,
2383,
2388,
2389,
2385,
2386,
2393,
2392,
2401,
2395,
2394,
2402,
2337,
2369,
2377,
2355,
]

_charnames_69968 = [
9075,
9072,
9067,
9074,
9069,
9053,
9052,
9059,
9058,
9062,
9061,
9056,
9055,
9042,
9032,
9031,
9038,
9037,
9043,
9034,
9033,
9040,
9039,
9044,
9050,
9049,
9065,
9064,
9070,
9047,
9071,
9066,
9068,
9073,
9046,
9078,
9080,
9079,
9076,
]

_charnames_70016 = [
7210,
7204,
7200,
7139,
7142,
7161,
7162,
7147,
7148,
7117,
7118,
7119,
7120,
7177,
7141,
7174,
7140,
7157,
7156,
7165,
7164,
7131,
7168,
7167,
7160,
7159,
7129,
7125,
7124,
7136,
7135,
7130,
7127,
7126,
7138,
7137,
7132,
7151,
7150,
7171,
7170,
7175,
7172,
7173,
7154,
7153,
7121,
7145,
7144,
7146,
7176,
7188,
7191,
7192,
7189,
7190,
7181,
7182,
7183,
7184,
7195,
7187,
7194,
7186,
7201,
7203,
7208,
7205,
7238,
7234,
7233,
7241,
7215,
7217,
7207,
7196,
7236,
7216,
7193,
7209,
7229,
7230,
7221,
7222,
7227,
7228,
7224,
7225,
7232,
7231,
7237,
7206,
7239,
7240,
7214,
7213,
-1,
6826,
6818,
6819,
6824,
6825,
6821,
6822,
6828,
6827,
6804,
6802,
6803,
6812,
6813,
6806,
6807,
6815,
6814,
6810,
6809,
]

_charnames_70144 = [
19735,
19738,
19769,
19764,
19771,
19737,
19767,
19736,
19755,
19754,
19742,
19741,
19740,
19733,
19761,
19760,
19758,
19757,
-1,
19731,
19727,
19726,
19721,
19719,
19732,
19729,
19728,
19723,
19720,
19722,
19734,
19749,
19748,
19746,
19745,
19744,
19768,
19762,
19766,
19752,
19763,
19765,
19770,
19751,
19776,
19777,
19778,
19779,
19781,
19775,
19780,
19774,
19789,
19787,
19788,
19786,
19795,
19794,
19796,
19790,
19793,
19797,
19785,
]

_charnames_70272 = [
10289,
10286,
10282,
10288,
10267,
10266,
10273,
-1,
10272,
-1,
10276,
10275,
10270,
10269,
-1,
10259,
10251,
10250,
10245,
10244,
10243,
10260,
10253,
10252,
10247,
10246,
10261,
10264,
10263,
10279,
-1,
10278,
10284,
10280,
10257,
10285,
10281,
10283,
10287,
10255,
10256,
10290,
-1,
-1,
-1,
-1,
-1,
-1,
19546,
19549,
19576,
19577,
19562,
19563,
19587,
19548,
19583,
19547,
19575,
19574,
19557,
19556,
19555,
19544,
19580,
19579,
19553,
19551,
19552,
19542,
19538,
19537,
19532,
19531,
19568,
19530,
19543,
19540,
19539,
19534,
19533,
19545,
19572,
19571,
19561,
19560,
19559,
19584,
19581,
19569,
19585,
19582,
19565,
19566,
19586,
19616,
19606,
19609,
19610,
19607,
19608,
19612,
19605,
19611,
19604,
19615,
19614,
-1,
-1,
-1,
-1,
-1,
19598,
19599,
19590,
19591,
19596,
19597,
19593,
19594,
19601,
19600,
-1,
-1,
-1,
-1,
-1,
-1,
24738,
24739,
24742,
24735,
-1,
24678,
24681,
24700,
24701,
24686,
24687,
24653,
24655,
-1,
-1,
24716,
24680,
-1,
-1,
24713,
24679,
24696,
24695,
24704,
24703,
24670,
24707,
24706,
24699,
24698,
24668,
24664,
24663,
24675,
24674,
24669,
24666,
24665,
24677,
24676,
24671,
-1,
24690,
24689,
24710,
24709,
24714,
24711,
24712,
-1,
24693,
24692,
-1,
24660,
24684,
24683,
24685,
24715,
-1,
1922,
24744,
24741,
24726,
24729,
24730,
24727,
24728,
24719,
24720,
-1,
-1,
24732,
24725,
-1,
-1,
24731,
24724,
24736,
-1,
-1,
24745,
-1,
-1,
-1,
-1,
-1,
-1,
24746,
-1,
-1,
-1,
-1,
-1,
24743,
24659,
24658,
24654,
24656,
24721,
24722,
-1,
-1,
1653,
1655,
1648,
1649,
1651,
1652,
1654,
-1,
-1,
-1,
1661,
1660,
1659,
1657,
1658,
]

_charnames_70656 = [
18153,
18156,
18181,
18182,
18161,
18162,
18136,
18137,
18138,
18139,
18196,
18155,
18194,
18154,
18177,
18176,
18185,
18184,
18130,
18129,
18188,
18187,
18180,
18179,
18127,
18126,
18144,
18143,
18150,
18149,
18131,
18146,
18145,
18152,
18151,
18133,
18132,
18168,
18167,
18191,
18190,
18171,
18170,
18192,
18165,
18164,
18174,
18173,
18193,
18159,
18158,
18160,
18195,
18206,
18209,
18210,
18207,
18208,
18199,
18200,
18201,
18202,
18212,
18205,
18211,
18204,
18237,
18245,
18240,
18236,
18242,
18239,
18244,
18249,
18246,
18231,
18229,
18252,
18251,
18253,
18224,
18225,
18216,
18217,
18222,
18223,
18219,
18220,
18227,
18226,
18230,
18248,
-1,
18250,
18247,
18140,
18243,
18241,
]

_charnames_70784 = [
5247,
5167,
5170,
5186,
5187,
5175,
5176,
5145,
5146,
5147,
5148,
5203,
5169,
5199,
5168,
5182,
5181,
5190,
5189,
5159,
5193,
5192,
5185,
5184,
5157,
5153,
5152,
5164,
5163,
5158,
5155,
5154,
5166,
5165,
5160,
5179,
5178,
5196,
5195,
5200,
5197,
5198,
5201,
5149,
5173,
5172,
5174,
5202,
5213,
5219,
5220,
5214,
5215,
5206,
5207,
5208,
5209,
5222,
5218,
5212,
5221,
5217,
5211,
5245,
5243,
5239,
5240,
5244,
5242,
5250,
5248,
5249,
]

_charnames_70864 = [
5233,
5234,
5225,
5226,
5231,
5232,
5228,
5229,
5236,
5235,
]

_charnames_71040 = [
6681,
6685,
6712,
6713,
6701,
6702,
6676,
6677,
6678,
6679,
6729,
6684,
6725,
6682,
6708,
6707,
6716,
6715,
6689,
6719,
6718,
6711,
6710,
6687,
6669,
6668,
6694,
6693,
6688,
6673,
6672,
6696,
6695,
6690,
6705,
6704,
6722,
6721,
6726,
6723,
6724,
6727,
6680,
6699,
6698,
6700,
6728,
6769,
6774,
6775,
6772,
6773,
6770,
6771,
-1,
-1,
6777,
6768,
6776,
6767,
6761,
6762,
6757,
6758,
6760,
6759,
6784,
6783,
6753,
6754,
6781,
6780,
6779,
6785,
6736,
6737,
6742,
6741,
6740,
6750,
6751,
6749,
6738,
6748,
6747,
6745,
6744,
6746,
6671,
6665,
6666,
6683,
6765,
6766,
]

_charnames_71168 = [
9663,
9666,
9685,
9686,
9671,
9672,
9641,
9642,
9643,
9644,
9701,
9665,
9698,
9664,
9681,
9680,
9689,
9688,
9655,
9692,
9691,
9684,
9683,
9653,
9649,
9648,
9660,
9659,
9654,
9651,
9650,
9662,
9661,
9656,
9675,
9674,
9695,
9694,
9699,
9696,
9697,
9678,
9645,
9669,
9668,
9670,
9700,
9677,
9711,
9714,
9715,
9712,
9713,
9704,
9705,
9706,
9707,
9717,
9710,
9716,
9709,
9741,
9737,
9738,
9740,
9734,
9733,
9743,
9742,
]

_charnames_71248 = [
9729,
9730,
9721,
9722,
9727,
9728,
9724,
9725,
9732,
9731,
-1,
-1,
-1,
-1,
-1,
-1,
9764,
9751,
9766,
9757,
9765,
9753,
9754,
9761,
9762,
9747,
9749,
9750,
9756,
]

_charnames_71296 = [
5042,
5046,
5081,
5082,
5064,
5065,
5098,
5045,
5094,
5043,
5077,
5076,
5085,
5084,
5056,
5088,
5087,
5080,
5079,
5054,
5050,
5049,
5061,
5060,
5055,
5052,
5051,
5063,
5062,
5057,
5074,
5073,
5091,
5090,
5095,
5092,
5071,
5096,
5093,
5067,
5068,
5097,
5070,
5129,
5126,
5117,
5120,
5121,
5118,
5119,
5123,
5116,
5122,
5115,
5127,
5128,
5044,
]

_charnames_71360 = [
5109,
5110,
5101,
5102,
5107,
5108,
5104,
5105,
5112,
5111,
]

_charnames_71424 = [
17437,
17436,
17427,
17428,
17431,
17422,
17434,
17433,
17449,
17452,
17440,
17455,
17430,
17451,
17453,
17450,
17426,
17454,
17420,
17446,
17445,
17443,
17423,
17442,
17448,
17439,
17424,
-1,
-1,
17493,
17494,
17492,
17457,
17461,
17464,
17465,
17462,
17463,
17467,
17458,
17466,
17460,
17459,
17488,
-1,
-1,
-1,
-1,
17478,
17479,
17470,
17471,
17476,
17477,
17473,
17474,
17481,
17480,
17497,
17496,
17485,
17486,
17487,
17489,
]

_charnames_71680 = [
23806,
23809,
23828,
23829,
23814,
23815,
23845,
23808,
23841,
23807,
23824,
23823,
23832,
23831,
23798,
23835,
23834,
23827,
23826,
23796,
23792,
23791,
23803,
23802,
23797,
23794,
23793,
23805,
23804,
23799,
23821,
23820,
23838,
23837,
23842,
23839,
23818,
23843,
23840,
23812,
23811,
23813,
23844,
23817,
23850,
23855,
23856,
23853,
23854,
23851,
23852,
23858,
23849,
23857,
23848,
23864,
23861,
23862,
23863,
23865,
]

_charnames_71840 = [
25677,
25659,
25678,
25649,
25652,
25651,
25683,
25668,
25663,
25673,
25661,
25684,
25682,
25665,
25650,
25669,
25666,
25674,
25680,
25676,
25685,
25660,
25662,
25686,
25681,
25657,
25656,
25655,
25658,
25671,
25672,
25679,
25637,
25619,
25638,
25609,
25612,
25611,
25643,
25628,
25623,
25633,
25621,
25644,
25642,
25625,
25610,
25629,
25626,
25634,
25640,
25636,
25645,
25620,
25622,
25646,
25641,
25617,
25616,
25615,
25618,
25631,
25632,
25639,
25697,
25698,
25689,
25690,
25695,
25696,
25692,
25693,
25700,
25699,
25705,
25703,
25704,
25710,
25711,
25707,
25708,
25713,
25712,
]

_charnames_71935 = [
25714,
24179,
24180,
24168,
24169,
24157,
24158,
24188,
-1,
-1,
24184,
-1,
-1,
24167,
24166,
24172,
24171,
24138,
24175,
24174,
24186,
-1,
24136,
24147,
-1,
24143,
24142,
24137,
24149,
24148,
24145,
24144,
24139,
24161,
24160,
24178,
24177,
24185,
24156,
24155,
24183,
24164,
24182,
24152,
24151,
24153,
24187,
24163,
24181,
24213,
24209,
24210,
24207,
24208,
24215,
-1,
24212,
24214,
-1,
-1,
24221,
24220,
24219,
24216,
24225,
24223,
24226,
24224,
24218,
24204,
24227,
24228,
]

_charnames_72016 = [
24200,
24201,
24192,
24193,
24198,
24199,
24195,
24196,
24203,
24202,
]

_charnames_72096 = [
18518,
18521,
18547,
18548,
18530,
18531,
18523,
18524,
-1,
-1,
18562,
18520,
18559,
18519,
18543,
18542,
18551,
18550,
18510,
18554,
18553,
18546,
18545,
18508,
18504,
18503,
18515,
18514,
18509,
18506,
18505,
18517,
18516,
18511,
18537,
18536,
18557,
18556,
18560,
18558,
18534,
18540,
18525,
18528,
18527,
18529,
18561,
18539,
18533,
18567,
18572,
18573,
18570,
18571,
18568,
18569,
-1,
-1,
18576,
18566,
18575,
18565,
18583,
18579,
18580,
18582,
18584,
18585,
18574,
]

_charnames_72192 = [
26846,
26858,
26851,
26850,
26859,
26853,
26852,
26856,
26855,
26857,
26860,
26823,
26822,
26832,
26831,
26814,
26835,
26834,
26844,
26812,
26796,
26795,
26808,
26807,
26813,
26801,
26800,
26810,
26809,
26815,
26829,
26828,
26838,
26837,
26842,
26799,
26798,
26805,
26804,
26825,
26826,
26847,
26839,
26841,
26843,
26840,
26818,
26817,
26819,
26845,
26821,
26891,
26869,
26864,
26865,
26866,
26870,
26868,
26879,
26875,
26877,
26878,
26876,
26889,
26881,
26884,
26885,
26887,
26886,
26890,
26882,
26871,
]

_charnames_72272 = [
6919,
6946,
6940,
6939,
6947,
6941,
6942,
6945,
6944,
6937,
6938,
6948,
6894,
6893,
6906,
6905,
6885,
6909,
6908,
6903,
6902,
6883,
6869,
6868,
6878,
6877,
6884,
6874,
6873,
6881,
6880,
6886,
6900,
6899,
6912,
6911,
6916,
6872,
6871,
6879,
6896,
6897,
6920,
6913,
6915,
6917,
6914,
6889,
6888,
6890,
6918,
6892,
6953,
6952,
6965,
6966,
6963,
6964,
6930,
6929,
6925,
6931,
6924,
6932,
6927,
6926,
6928,
6923,
6922,
6933,
6954,
6951,
6974,
6955,
6957,
6958,
6960,
6959,
6969,
6970,
6967,
6973,
6972,
]

_charnames_72384 = [
23008,
23014,
23026,
23025,
23030,
23020,
23021,
23010,
23027,
23028,
23013,
23022,
23031,
23019,
23005,
23004,
23011,
23007,
23023,
23000,
23018,
23032,
23029,
23015,
23024,
23001,
23002,
23016,
22996,
22999,
22995,
22997,
22991,
22998,
22994,
22992,
22993,
23048,
23046,
23044,
23049,
23050,
23045,
23041,
23039,
23042,
23043,
23051,
23057,
23053,
23054,
23035,
23033,
23055,
23036,
23037,
23058,
]

_charnames_72704 = [
14065,
14068,
14084,
14085,
14073,
14074,
14044,
14045,
14046,
-1,
14101,
14067,
14097,
14066,
14080,
14079,
14088,
14087,
14057,
14091,
14090,
14083,
14082,
14055,
14051,
14050,
14062,
14061,
14056,
14053,
14052,
14064,
14063,
14058,
14077,
14076,
14094,
14093,
14098,
14095,
14096,
14099,
14047,
14071,
14070,
14072,
14100,
14136,
14139,
14140,
14137,
14138,
14130,
14131,
14132,
-1,
14142,
14135,
14141,
14134,
14167,
14166,
14162,
14163,
14165,
14159,
14158,
14171,
14170,
14169,
]

_charnames_72784 = [
14154,
14155,
14146,
14147,
14152,
14153,
14149,
14150,
14157,
14156,
14127,
14105,
14108,
14118,
14121,
14112,
14114,
14125,
14123,
14110,
14106,
14109,
14119,
14122,
14113,
14115,
14126,
14124,
14172,
-1,
-1,
-1,
9274,
9273,
9249,
9248,
9263,
9236,
9255,
9254,
9261,
9235,
9233,
9232,
9252,
9237,
9246,
9245,
9264,
9259,
9231,
9230,
9251,
9257,
9239,
9240,
9266,
9256,
9258,
9260,
9242,
9243,
9262,
9265,
-1,
-1,
9207,
9206,
9221,
9194,
9213,
9212,
9219,
9193,
9191,
9190,
9210,
9195,
9204,
9203,
9222,
9217,
9189,
9188,
9209,
9215,
9197,
9198,
-1,
9214,
9216,
9218,
9200,
9201,
9220,
9223,
9272,
9270,
9268,
9271,
9269,
9226,
9225,
]

_charnames_72960 = [
9102,
9105,
9126,
9127,
9118,
9119,
9143,
-1,
9104,
9140,
-1,
9103,
9113,
9112,
9130,
9129,
9094,
9133,
9132,
9117,
9116,
9092,
9087,
9086,
9099,
9098,
9093,
9090,
9089,
9101,
9100,
9095,
9122,
9121,
9136,
9135,
9141,
9137,
9139,
9125,
9138,
9108,
9107,
9109,
9142,
9124,
9111,
9115,
9088,
9149,
9152,
9153,
9150,
9151,
9154,
-1,
-1,
-1,
9156,
-1,
9148,
9155,
-1,
9147,
9177,
9173,
9174,
9176,
9175,
9157,
9179,
9180,
]

_charnames_73040 = [
9168,
9169,
9160,
9161,
9166,
9167,
9163,
9164,
9171,
9170,
-1,
-1,
-1,
-1,
-1,
-1,
25047,
25050,
25068,
25069,
25051,
25052,
-1,
25086,
25049,
-1,
25083,
25048,
25079,
25080,
25078,
25077,
25084,
25064,
25063,
25040,
25039,
25061,
25072,
25071,
25046,
25045,
25058,
25075,
25074,
25038,
25037,
25060,
25067,
25066,
25044,
25043,
25057,
25055,
25054,
25085,
25082,
25081,
25092,
25095,
25096,
25093,
25094,
-1,
25098,
25091,
-1,
25097,
25090,
25116,
25115,
25099,
25117,
]

_charnames_73120 = [
25110,
25111,
25102,
25103,
25108,
25109,
25105,
25106,
25113,
25112,
]

_charnames_73440 = [
9350,
9352,
9340,
9347,
9355,
9348,
9344,
9353,
9341,
9354,
9351,
9339,
9342,
9346,
9349,
9343,
9345,
9356,
9364,
9360,
9358,
9361,
9359,
9362,
9363,
]

_charnames_73664 = [
4681,
4700,
4697,
4689,
4694,
4682,
4707,
4703,
4683,
4688,
4687,
4684,
4698,
4705,
4704,
4695,
4699,
4692,
4691,
4706,
4708,
4643,
4644,
4645,
4642,
4634,
4640,
4624,
4636,
4641,
4625,
4627,
4630,
4626,
4639,
4632,
4726,
4710,
4721,
4648,
4717,
4716,
4675,
4724,
4647,
4718,
4732,
4646,
4635,
4631,
]

_charnames_73727 = [
4728,
1019,
1081,
1080,
1079,
1078,
1077,
1076,
1075,
1074,
1105,
1020,
1038,
1037,
1033,
1032,
1036,
1030,
1029,
1035,
1025,
1034,
1039,
1040,
1046,
1045,
1044,
1043,
1042,
1102,
1098,
1101,
1100,
1048,
1058,
1057,
1056,
1055,
1052,
1051,
1054,
1053,
1060,
1059,
1094,
1096,
1082,
1088,
1087,
1086,
1085,
1089,
1104,
1091,
1092,
1093,
1072,
1062,
1068,
1069,
1067,
1065,
1066,
1071,
1070,
1264,
1275,
1277,
1265,
1270,
1272,
1271,
1273,
1274,
1289,
1293,
1292,
1291,
1278,
1283,
1281,
1284,
1287,
1288,
1285,
1286,
756,
757,
783,
782,
780,
779,
763,
764,
761,
762,
765,
789,
776,
777,
788,
770,
767,
769,
768,
787,
786,
785,
784,
774,
775,
796,
792,
795,
794,
798,
810,
799,
802,
804,
808,
809,
806,
698,
752,
753,
751,
745,
748,
749,
699,
739,
755,
740,
741,
742,
743,
744,
754,
1106,
1172,
1173,
1145,
1155,
1154,
1152,
1149,
1148,
1150,
1176,
1175,
1174,
1156,
1159,
1160,
1161,
1164,
1163,
1162,
1168,
1166,
1169,
1107,
1115,
1116,
1117,
1118,
1135,
1131,
1132,
1129,
1130,
1133,
1120,
1121,
1122,
1111,
1112,
1114,
1113,
1125,
1124,
251,
375,
252,
273,
272,
271,
276,
274,
267,
269,
334,
332,
335,
336,
298,
294,
296,
293,
327,
328,
325,
326,
261,
257,
262,
263,
264,
265,
313,
310,
311,
316,
315,
351,
350,
307,
306,
303,
304,
302,
338,
348,
347,
322,
323,
354,
286,
285,
282,
283,
281,
287,
353,
342,
343,
344,
355,
365,
368,
371,
372,
362,
364,
363,
374,
356,
357,
359,
360,
361,
369,
370,
373,
436,
439,
376,
405,
404,
406,
398,
400,
401,
408,
385,
386,
378,
384,
383,
382,
381,
380,
397,
388,
396,
394,
392,
395,
409,
434,
410,
413,
414,
416,
415,
418,
419,
423,
422,
425,
433,
431,
432,
426,
430,
429,
428,
1317,
1319,
1321,
1322,
1295,
1297,
1298,
1306,
1305,
1304,
1303,
1302,
1301,
1300,
1307,
1308,
1314,
1313,
1312,
1311,
1310,
1316,
1323,
1349,
1348,
1341,
1344,
1343,
1331,
1332,
1337,
1334,
1335,
1336,
1338,
1340,
1339,
1324,
1326,
1329,
1328,
1327,
1330,
1347,
1346,
1345,
442,
486,
490,
491,
489,
497,
496,
495,
499,
523,
522,
451,
455,
454,
452,
453,
445,
450,
448,
449,
456,
457,
520,
519,
504,
501,
502,
508,
506,
479,
483,
482,
481,
484,
485,
517,
516,
513,
525,
466,
467,
465,
464,
463,
461,
469,
468,
511,
470,
476,
475,
474,
473,
524,
546,
547,
549,
532,
531,
530,
528,
529,
544,
545,
537,
539,
540,
543,
542,
533,
536,
535,
575,
562,
571,
569,
570,
573,
572,
567,
566,
564,
565,
550,
561,
560,
555,
556,
559,
553,
554,
558,
551,
552,
557,
574,
5,
101,
104,
108,
107,
106,
111,
110,
109,
167,
166,
171,
170,
138,
139,
136,
137,
162,
163,
164,
151,
147,
150,
149,
133,
134,
132,
130,
131,
145,
144,
142,
143,
158,
159,
160,
169,
126,
125,
124,
121,
122,
127,
155,
154,
156,
112,
115,
114,
118,
117,
116,
172,
173,
175,
176,
177,
178,
184,
182,
183,
179,
180,
181,
246,
249,
248,
247,
185,
245,
186,
224,
223,
201,
203,
221,
217,
220,
194,
192,
193,
195,
215,
214,
219,
212,
211,
199,
198,
206,
225,
232,
230,
229,
227,
244,
233,
236,
237,
238,
243,
242,
239,
240,
241,
1248,
1252,
1253,
1256,
1255,
1254,
1249,
1250,
1260,
1261,
1257,
1258,
1222,
1247,
1243,
1244,
1246,
1245,
1223,
1233,
1232,
1231,
1225,
1229,
1234,
1235,
1238,
1239,
1241,
1242,
1001,
1012,
1002,
1006,
1004,
1005,
1007,
1010,
1008,
1009,
1013,
1017,
1016,
1018,
924,
967,
966,
961,
964,
963,
926,
947,
945,
946,
941,
952,
950,
949,
933,
937,
935,
936,
931,
929,
965,
968,
996,
969,
991,
990,
987,
988,
989,
994,
995,
992,
993,
970,
982,
981,
980,
979,
978,
977,
976,
975,
974,
973,
983,
984,
1374,
1377,
1376,
1375,
1378,
1351,
1361,
1362,
1360,
1359,
1363,
1356,
1357,
1354,
1355,
1364,
1366,
1371,
1370,
1369,
1372,
1405,
1406,
1408,
1407,
641,
674,
642,
670,
662,
663,
668,
661,
660,
666,
665,
664,
655,
653,
658,
650,
649,
648,
647,
646,
673,
671,
675,
676,
678,
677,
603,
604,
613,
612,
611,
610,
609,
608,
606,
607,
614,
617,
616,
618,
628,
627,
626,
633,
632,
629,
631,
630,
597,
600,
599,
579,
592,
585,
584,
591,
590,
581,
582,
589,
588,
587,
586,
602,
593,
595,
596,
601,
634,
640,
635,
639,
688,
694,
689,
690,
691,
696,
695,
679,
687,
684,
685,
686,
682,
683,
680,
681,
1178,
1193,
1191,
1190,
1192,
1194,
1197,
1196,
1179,
1187,
1186,
1183,
1182,
1185,
1184,
1198,
1200,
1219,
1220,
1210,
1218,
1216,
1211,
1215,
1213,
1214,
1201,
1209,
1208,
1202,
1206,
1207,
811,
913,
912,
910,
909,
908,
922,
921,
885,
894,
891,
890,
888,
889,
895,
892,
893,
896,
873,
879,
876,
878,
877,
884,
880,
883,
882,
918,
919,
812,
871,
870,
850,
862,
861,
863,
865,
864,
854,
857,
856,
872,
867,
868,
813,
840,
841,
847,
838,
816,
819,
818,
817,
820,
846,
833,
832,
831,
845,
827,
844,
843,
836,
835,
842,
824,
823,
822,
848,
849,
897,
902,
899,
900,
901,
903,
905,
904,
920,
915,
916,
917,
1396,
1398,
1399,
1401,
1400,
1403,
1389,
1395,
1394,
1390,
1391,
1393,
1392,
1381,
1382,
1385,
1387,
1386,
548,
1026,
1047,
1097,
773,
791,
807,
747,
1134,
1128,
275,
268,
440,
407,
1315,
492,
488,
446,
458,
526,
507,
514,
462,
510,
472,
140,
228,
204,
200,
1262,
1240,
1011,
925,
960,
959,
942,
999,
1379,
1373,
667,
1217,
875,
911,
]

_charnames_74752 = [
1483,
1467,
1429,
1447,
1502,
1498,
1557,
1544,
1469,
1431,
1449,
1507,
1497,
1556,
1543,
1421,
1442,
1500,
1493,
1552,
1539,
1521,
1479,
1466,
1428,
1446,
1506,
1496,
1555,
1542,
1520,
1478,
1465,
1427,
1445,
1476,
1455,
1456,
1425,
1436,
1505,
1495,
1554,
1541,
1528,
1475,
1453,
1454,
1424,
1435,
1510,
1509,
1526,
1481,
1458,
1459,
1420,
1441,
1463,
1462,
1412,
1416,
1415,
1414,
1504,
1492,
1491,
1490,
1550,
1551,
1535,
1537,
1536,
1538,
1484,
1468,
1430,
1448,
1503,
1527,
1482,
1460,
1418,
1419,
1439,
1440,
1546,
1547,
1523,
1485,
1515,
1473,
1437,
1514,
1472,
1524,
1518,
1531,
1532,
1517,
1529,
1563,
1562,
1560,
1561,
1422,
1443,
1501,
1494,
1553,
1540,
-1,
1570,
1569,
1568,
1566,
1567,
]

_charnames_74880 = [
1027,
1024,
1103,
1276,
1269,
1268,
1267,
1282,
797,
790,
803,
801,
805,
725,
723,
724,
734,
733,
738,
717,
714,
716,
715,
731,
730,
737,
712,
711,
709,
710,
705,
703,
704,
706,
721,
720,
719,
736,
735,
728,
727,
1153,
1151,
1167,
1170,
1144,
1143,
1142,
1139,
1140,
1137,
1138,
1141,
1127,
333,
297,
292,
291,
329,
256,
260,
259,
314,
301,
339,
340,
341,
346,
318,
321,
320,
280,
352,
367,
438,
393,
417,
424,
1320,
1299,
498,
503,
477,
471,
168,
71,
66,
65,
70,
63,
62,
69,
68,
60,
59,
67,
98,
97,
82,
81,
76,
75,
74,
83,
79,
78,
88,
87,
86,
91,
90,
92,
46,
38,
45,
44,
42,
41,
43,
54,
53,
56,
55,
51,
50,
49,
48,
99,
35,
8,
21,
20,
19,
18,
17,
16,
15,
13,
12,
11,
34,
22,
33,
32,
27,
28,
31,
30,
29,
26,
25,
95,
94,
231,
222,
218,
208,
209,
207,
1259,
1228,
1227,
958,
943,
940,
957,
956,
955,
953,
954,
928,
932,
930,
672,
669,
654,
657,
615,
624,
623,
622,
621,
638,
637,
693,
1199,
1205,
1204,
866,
858,
839,
829,
828,
1402,
1388,
1384,
]

_charnames_77824 = [
14410,
14409,
14408,
14407,
14402,
14403,
14399,
14401,
14400,
14406,
14405,
14404,
14397,
14396,
14395,
14394,
14388,
14389,
14393,
14392,
14386,
14387,
14391,
14390,
14455,
14454,
14453,
14452,
14451,
14450,
14449,
14448,
14447,
14446,
14422,
14421,
14412,
14413,
14420,
14419,
14418,
14417,
14416,
14415,
14414,
14377,
14378,
14384,
14375,
14376,
14373,
14374,
14383,
14371,
14372,
14382,
14381,
14380,
14379,
14444,
14443,
14442,
14441,
14440,
14439,
14438,
14437,
14436,
14435,
14433,
14432,
14431,
14430,
14429,
14428,
14427,
14426,
14425,
14424,
14456,
15523,
15522,
15521,
15520,
15514,
15515,
15519,
15518,
15517,
15516,
15434,
15423,
15426,
15425,
15424,
15433,
15432,
15431,
15430,
15429,
15428,
15427,
15436,
15437,
15446,
15445,
15444,
15443,
15442,
15441,
15440,
15439,
15438,
15452,
15451,
15450,
15449,
15448,
14706,
14705,
14704,
14703,
14702,
14701,
14700,
14697,
14698,
14699,
14695,
14694,
14693,
14692,
14691,
14690,
14689,
14688,
14687,
14686,
14684,
14683,
14682,
14681,
14680,
14679,
14678,
14674,
14675,
14677,
14676,
14672,
14663,
14664,
14671,
14670,
14661,
14662,
14669,
14668,
14667,
14666,
14665,
14659,
14658,
14657,
14656,
14655,
14654,
14650,
14651,
14653,
14648,
14649,
14652,
14609,
14618,
14617,
14616,
14615,
14614,
14613,
14612,
14611,
14610,
14629,
14621,
14622,
14628,
14619,
14620,
14627,
14626,
14625,
14624,
14623,
14646,
14645,
14644,
14643,
14642,
14641,
14640,
14631,
14639,
14638,
14637,
14636,
14635,
14634,
14633,
14632,
15242,
15241,
15240,
15239,
15238,
15237,
15236,
15234,
15235,
15232,
15233,
15230,
15229,
15228,
15227,
15226,
15225,
15221,
15222,
15219,
15220,
15224,
15223,
15208,
15209,
15217,
15216,
15215,
15214,
15213,
15212,
15211,
15206,
15207,
15210,
15252,
15251,
15250,
15249,
15244,
15245,
15248,
15247,
15246,
15001,
15002,
15010,
15009,
15008,
15007,
15006,
15005,
15004,
15003,
14999,
14998,
14997,
14989,
14990,
14996,
14995,
14994,
14993,
14992,
14991,
14987,
14977,
14978,
14986,
14985,
14984,
14983,
14982,
14981,
14980,
14979,
14975,
14967,
14968,
14974,
14973,
14972,
14971,
14970,
14965,
14966,
14963,
14964,
14969,
14961,
14960,
14959,
14958,
14957,
14953,
14954,
14951,
14952,
14949,
14950,
14956,
14955,
15018,
15012,
15015,
15014,
15013,
15017,
15016,
15071,
15070,
15069,
15068,
15067,
15063,
15064,
15060,
15062,
15061,
15066,
15065,
15083,
15073,
15074,
15082,
15081,
15080,
15079,
15078,
15077,
15076,
15075,
15049,
15050,
15058,
15057,
15056,
15055,
15054,
15047,
15048,
15053,
15052,
15051,
15045,
15044,
15043,
15042,
15041,
15040,
15036,
15037,
15034,
15035,
15039,
15038,
15032,
15031,
15030,
15023,
15024,
15029,
15021,
15022,
15028,
15027,
15026,
15025,
15089,
15088,
15087,
15086,
15085,
15546,
15545,
15544,
15543,
15542,
15538,
15539,
15541,
15540,
15466,
15465,
15464,
15463,
15458,
15459,
15462,
15461,
15460,
15456,
15457,
15470,
15471,
15468,
15469,
15475,
15474,
15473,
15472,
15566,
15565,
15564,
15563,
15562,
15561,
15560,
15559,
15535,
15528,
15529,
15534,
15533,
15532,
15526,
15527,
15531,
15530,
14928,
14930,
14929,
14939,
14931,
14932,
14938,
14937,
14936,
14935,
14934,
14933,
14892,
14893,
14898,
14877,
14885,
14884,
14883,
14882,
14881,
14880,
14879,
14878,
14897,
14896,
14890,
14891,
14888,
14889,
14886,
14887,
14895,
14894,
14926,
14925,
14918,
14919,
14924,
14916,
14917,
14923,
14922,
14921,
14914,
14915,
14920,
14912,
14903,
14904,
14911,
14900,
14902,
14901,
14910,
14909,
14908,
14907,
14906,
14905,
14941,
14942,
14946,
14945,
14944,
14943,
14547,
14546,
14545,
14544,
14543,
14542,
14541,
14540,
14539,
14525,
14524,
14523,
14522,
14521,
14520,
14519,
14518,
14514,
14516,
14515,
14517,
14537,
14536,
14535,
14534,
14533,
14527,
14528,
14532,
14531,
14530,
14529,
14512,
14511,
14510,
14505,
14506,
14503,
14504,
14501,
14502,
14509,
14499,
14500,
14508,
14507,
14551,
14550,
14549,
14605,
14604,
14603,
14602,
14596,
14597,
14601,
14600,
14599,
14598,
14594,
14593,
14592,
14591,
14590,
14589,
14588,
14584,
14585,
14587,
14586,
14606,
14576,
14575,
14574,
14573,
14572,
14571,
14570,
14569,
14568,
14558,
14559,
14556,
14557,
14566,
14565,
14564,
14563,
14562,
14561,
14554,
14555,
14560,
14581,
14580,
14578,
14579,
14803,
14804,
14810,
14809,
14808,
14801,
14802,
14794,
14800,
14799,
14798,
14797,
14796,
14795,
14807,
14806,
14805,
14844,
14847,
14846,
14845,
14857,
14856,
14855,
14854,
14853,
14852,
14851,
14850,
14848,
14849,
14835,
14836,
14842,
14841,
14840,
14833,
14834,
14831,
14832,
14839,
14838,
14837,
14829,
14830,
14819,
14820,
14827,
14826,
14817,
14818,
14825,
14824,
14812,
14816,
14815,
14814,
14813,
14823,
14822,
14821,
14868,
14867,
14866,
14865,
14864,
14863,
14862,
14861,
14860,
14859,
14870,
14872,
14871,
14873,
15487,
15488,
15495,
15485,
15486,
15494,
15493,
15492,
15491,
15490,
15489,
15498,
15497,
15574,
15573,
15572,
15571,
15570,
15569,
15568,
15373,
15365,
15366,
15362,
15364,
15363,
15372,
15371,
15370,
15369,
15368,
15367,
15351,
15352,
15360,
15359,
15358,
15357,
15356,
15349,
15350,
15355,
15354,
15353,
15384,
15383,
15382,
15381,
15380,
15379,
15378,
15377,
15376,
15375,
15141,
15133,
15134,
15140,
15139,
15138,
15131,
15132,
15137,
15136,
15135,
15104,
15103,
15102,
15101,
15092,
15094,
15093,
15100,
15099,
15095,
15096,
15098,
15097,
15117,
15116,
15115,
15114,
15113,
15112,
15106,
15108,
15107,
15111,
15110,
15109,
15129,
15128,
15127,
15126,
15125,
15119,
15120,
15124,
15123,
15122,
15121,
15149,
15148,
15147,
15146,
15145,
15144,
15143,
15268,
15267,
15262,
15263,
15266,
15265,
15264,
15260,
15261,
15258,
15259,
15256,
15257,
15281,
15272,
15273,
15280,
15279,
15278,
15277,
15270,
15271,
15276,
15275,
15274,
15292,
15291,
15290,
15289,
15288,
15287,
15286,
15285,
15284,
15283,
15302,
15301,
15296,
15297,
15294,
15295,
15300,
15299,
15298,
15187,
15186,
15185,
15184,
15183,
15177,
15179,
15178,
15182,
15181,
15180,
15198,
15197,
15196,
15195,
15194,
15193,
15192,
15191,
15190,
15189,
15163,
15162,
15161,
15154,
15155,
15160,
15159,
15158,
15157,
15156,
15152,
15153,
15175,
15174,
15165,
15166,
15173,
15172,
15171,
15170,
15169,
15168,
15167,
15202,
15201,
15200,
14736,
14745,
14744,
14743,
14742,
14741,
14740,
14739,
14738,
14737,
14749,
14750,
14756,
14755,
14754,
14753,
14746,
14748,
14747,
14752,
14751,
14772,
14758,
14761,
14760,
14759,
14762,
14764,
14763,
14771,
14770,
14769,
14768,
14767,
14766,
14765,
14710,
14722,
14721,
14720,
14719,
14718,
14717,
14716,
14715,
14714,
14713,
14712,
14711,
14734,
14733,
14727,
14728,
14732,
14731,
14730,
14729,
14725,
14726,
14723,
14724,
14780,
14781,
14778,
14779,
14787,
14776,
14777,
14786,
14785,
14784,
14774,
14775,
14783,
14782,
14788,
14789,
15412,
15411,
15404,
15405,
15410,
15409,
15408,
15407,
15406,
15402,
15403,
15393,
15394,
15400,
15399,
15398,
15391,
15392,
15397,
15396,
15389,
15390,
15387,
15388,
15395,
15420,
15419,
15418,
15417,
15414,
15415,
15416,
15511,
15510,
15509,
15500,
15502,
15501,
15508,
15505,
15506,
15507,
15503,
15504,
15549,
15550,
15557,
15556,
15555,
15554,
15553,
15552,
15551,
15346,
15330,
15334,
15333,
15332,
15331,
15335,
15337,
15336,
15340,
15341,
15338,
15339,
15345,
15344,
15343,
15342,
15328,
15327,
15326,
15325,
15324,
15305,
15314,
15313,
15312,
15311,
15310,
15309,
15308,
15307,
15306,
15315,
15323,
15322,
15321,
15320,
15319,
15318,
15317,
15316,
14469,
14468,
14467,
14466,
14465,
14464,
14459,
14461,
14460,
14463,
14462,
14491,
14490,
14489,
14488,
14487,
14486,
14485,
14484,
14483,
14482,
14480,
14479,
14478,
14477,
14476,
14475,
14474,
14473,
14472,
14471,
14495,
14494,
14493,
-1,
14790,
15547,
15478,
15481,
15479,
15482,
14874,
15524,
15253,
]

_charnames_82944 = [
16455,
16454,
16453,
16452,
16451,
16450,
16449,
16448,
16447,
16402,
16403,
16412,
16411,
16410,
16409,
16408,
16407,
16406,
16405,
16404,
16400,
16399,
16398,
16397,
16396,
16395,
16390,
16391,
16394,
16393,
16392,
16388,
16387,
16386,
16385,
16384,
16383,
16382,
16381,
16380,
16378,
16379,
16349,
16341,
16342,
16348,
16347,
16346,
16339,
16340,
16336,
16338,
16337,
16345,
16344,
16343,
16445,
16444,
16443,
16442,
16441,
16440,
16439,
16438,
16437,
16436,
16363,
16362,
16361,
16360,
16359,
16358,
16351,
16354,
16353,
16352,
16357,
16356,
16355,
16434,
16433,
16432,
16431,
16430,
16429,
16428,
16427,
16426,
16425,
16423,
16422,
16421,
16420,
16419,
16418,
16417,
16416,
16415,
16414,
16376,
16375,
16374,
16373,
16372,
16371,
16370,
16367,
16368,
16365,
16366,
16369,
15975,
15976,
15973,
15974,
15971,
15972,
15980,
15964,
15967,
15966,
15965,
15968,
15970,
15969,
15979,
15960,
15963,
15962,
15961,
15978,
15977,
15982,
15984,
15983,
15994,
15993,
15992,
15991,
15985,
15986,
15990,
15989,
15988,
15987,
16018,
16017,
16016,
16015,
16014,
16008,
16009,
16013,
16012,
16011,
16010,
16006,
16005,
16004,
16003,
16002,
15996,
15997,
16001,
16000,
15999,
15998,
16084,
16083,
16082,
16081,
16080,
16079,
16078,
16077,
16076,
16075,
16073,
16072,
16071,
16070,
16069,
16068,
16067,
16066,
16065,
16064,
16062,
16061,
16060,
16059,
16058,
16057,
16056,
16055,
16054,
16053,
16051,
16050,
16049,
16048,
16047,
16046,
16045,
16044,
16043,
16042,
16040,
16039,
16038,
16037,
16036,
16035,
16034,
16033,
16032,
16031,
16029,
16028,
16027,
16026,
16025,
16024,
16023,
16022,
16021,
16020,
16227,
16226,
16214,
16216,
16215,
16225,
16224,
16223,
16222,
16219,
16220,
16221,
16217,
16218,
16253,
16252,
16251,
16250,
16249,
16244,
16245,
16242,
16243,
16248,
16247,
16246,
16289,
16288,
16287,
16286,
16285,
16284,
16283,
16279,
16280,
16282,
16281,
16333,
16332,
16331,
16330,
16329,
16328,
16327,
16326,
16325,
16324,
16322,
16321,
16320,
16319,
16318,
16317,
16316,
16315,
16314,
16313,
16311,
16310,
16309,
16308,
16307,
16306,
16305,
16304,
16303,
16302,
16277,
16276,
16275,
16274,
16273,
16272,
16271,
16267,
16268,
16270,
16269,
16300,
16299,
16298,
16297,
16296,
16295,
16294,
16293,
16292,
16291,
16265,
16264,
16263,
16262,
16261,
16260,
16259,
16258,
16257,
16255,
16256,
16240,
16239,
16238,
16237,
16231,
16232,
16236,
16235,
16234,
16233,
16229,
16230,
16178,
16177,
16176,
16175,
16174,
16173,
16172,
16171,
16170,
16168,
16169,
16211,
16210,
16209,
16208,
16207,
16206,
16205,
16204,
16203,
16202,
16166,
16165,
16164,
16163,
16162,
16161,
16160,
16159,
16158,
16156,
16157,
16102,
16101,
16094,
16093,
16092,
16100,
16099,
16098,
16087,
16090,
16089,
16088,
16097,
16096,
16095,
16200,
16199,
16198,
16197,
16196,
16195,
16194,
16193,
16192,
16191,
16154,
16153,
16152,
16151,
16150,
16149,
16148,
16147,
16146,
16144,
16145,
16130,
16129,
16128,
16127,
16121,
16122,
16126,
16125,
16124,
16119,
16120,
16123,
16142,
16132,
16133,
16141,
16140,
16139,
16138,
16137,
16136,
16135,
16134,
16117,
16109,
16110,
16116,
16108,
16107,
16115,
16114,
16104,
16105,
16113,
16112,
16111,
16189,
16188,
16187,
16186,
16185,
16184,
16183,
16182,
16181,
16180,
16559,
16558,
16557,
16556,
16555,
16554,
16553,
16552,
16551,
16550,
16473,
16472,
16482,
16481,
16480,
16479,
16478,
16477,
16476,
16475,
16474,
16548,
16547,
16546,
16545,
16544,
16543,
16542,
16541,
16540,
16539,
16537,
16536,
16535,
16534,
16533,
16532,
16531,
16530,
16529,
16528,
16526,
16525,
16524,
16523,
16522,
16521,
16520,
16519,
16518,
16517,
16460,
16461,
16469,
16468,
16467,
16466,
16465,
16464,
16458,
16459,
16463,
16462,
16515,
16514,
16513,
16512,
16511,
16510,
16509,
16508,
16507,
16506,
16504,
16503,
16502,
16501,
16500,
16499,
16498,
16497,
16496,
16495,
16493,
16492,
16491,
16490,
16489,
16488,
16487,
16486,
16485,
16484,
16568,
16567,
16566,
16565,
16564,
16563,
16562,
16561,
16601,
16600,
16599,
16598,
16597,
16596,
16595,
16594,
16593,
16591,
16590,
16589,
16588,
16587,
16586,
16585,
16584,
16583,
16582,
16580,
16579,
16578,
16577,
16576,
16575,
16574,
16573,
16572,
16571,
16602,
]

_charnames_92160 = [
12915,
13023,
12992,
12993,
12936,
12967,
13012,
12924,
12970,
12989,
12990,
12946,
13008,
12917,
12944,
12951,
12960,
12978,
12911,
12998,
12929,
12976,
12914,
13018,
13017,
12910,
12949,
12984,
13021,
12985,
12956,
12923,
13026,
13022,
12909,
12977,
12961,
12962,
12954,
13002,
12986,
12933,
12995,
12945,
12938,
12994,
13007,
13015,
12975,
13010,
12948,
12999,
12932,
13003,
12955,
12966,
13016,
13029,
13028,
13004,
12974,
12950,
12969,
12907,
12971,
12920,
12982,
12930,
13025,
12916,
12947,
12937,
12959,
12921,
13011,
12973,
12983,
12926,
12943,
12919,
13001,
12927,
13027,
13014,
12939,
12935,
12958,
13063,
13098,
13072,
13073,
13093,
13035,
13082,
13101,
13034,
13083,
13087,
13102,
13091,
13065,
13066,
13104,
13086,
13097,
13070,
13069,
13044,
13037,
13060,
13078,
13105,
13077,
13092,
13088,
13110,
13058,
13055,
13109,
13074,
13099,
13048,
13053,
13054,
13045,
13071,
13038,
13049,
13061,
13085,
13047,
13107,
13036,
13108,
13079,
13042,
13041,
13094,
13056,
13064,
13039,
13081,
13057,
12768,
12805,
12859,
12897,
12766,
12783,
12769,
12892,
12817,
12894,
12809,
12801,
12815,
12887,
12787,
12824,
12843,
12893,
12846,
12860,
12804,
12827,
12778,
12819,
12861,
12854,
12855,
12876,
12788,
12870,
12796,
12866,
12878,
12765,
12899,
12808,
12835,
12802,
12762,
12881,
12820,
12838,
12799,
12868,
12763,
12902,
12782,
12779,
12777,
12903,
12900,
12816,
12901,
12795,
12882,
12865,
12774,
12792,
12850,
12761,
12831,
12828,
12883,
12852,
12794,
12770,
12896,
12764,
12776,
12800,
12853,
12775,
12786,
12834,
12862,
12785,
12873,
12877,
12818,
12832,
12825,
12844,
12814,
12845,
12823,
12858,
12791,
12837,
12836,
12874,
12848,
12849,
12771,
12807,
12884,
12888,
12889,
12869,
12663,
12750,
12610,
12646,
12611,
12724,
12613,
12623,
12604,
12629,
12749,
12598,
12676,
12600,
12695,
12706,
12675,
12616,
12682,
12696,
12741,
12699,
12686,
12648,
12632,
12665,
12657,
12688,
12740,
12614,
12693,
12595,
12710,
12753,
12597,
12755,
12633,
12652,
12719,
12634,
12669,
12654,
12727,
12653,
12645,
12722,
12620,
12661,
12702,
12628,
12708,
12687,
12739,
12694,
12747,
12709,
12596,
12649,
12619,
12692,
12732,
12730,
12626,
12720,
12603,
12650,
12606,
12738,
12733,
12737,
12635,
12638,
12683,
12700,
12608,
12599,
12711,
12658,
12698,
12624,
12707,
12666,
12605,
12718,
12607,
12622,
12615,
12752,
12697,
12744,
12714,
12712,
12627,
12746,
12721,
12659,
12643,
12681,
12668,
12679,
12674,
12701,
12641,
12677,
12639,
12731,
12642,
12678,
12728,
12667,
12723,
12745,
12713,
12640,
12662,
12685,
12756,
12400,
12484,
12464,
12529,
12586,
12524,
12436,
12518,
12573,
12413,
12404,
12432,
12476,
12377,
12543,
12579,
12516,
12386,
12437,
12483,
12536,
12526,
12415,
12392,
12455,
12375,
12391,
12414,
12575,
12409,
12449,
12519,
12381,
12462,
12562,
12376,
12410,
12457,
12523,
12387,
12402,
12477,
12515,
12433,
12398,
12383,
12506,
12563,
12481,
12497,
12450,
12480,
12541,
12517,
12488,
12584,
12581,
12530,
12429,
12474,
12567,
12393,
12513,
12461,
12465,
12418,
12427,
12570,
12479,
12537,
12507,
12420,
12505,
12469,
12403,
12444,
12494,
12532,
12552,
12569,
12372,
12542,
12454,
12378,
12565,
12554,
12423,
12448,
12500,
12385,
12421,
12417,
12451,
12459,
12553,
12426,
12467,
12564,
12550,
12466,
12431,
12373,
12535,
12443,
12424,
12498,
12382,
12440,
12551,
12556,
12407,
12589,
12485,
12587,
12588,
12528,
12439,
12473,
12475,
12399,
12512,
12499,
12388,
12495,
12502,
12503,
12492,
12493,
12540,
12447,
12408,
12434,
12580,
12557,
12585,
12531,
12458,
12576,
12574,
12389,
12394,
12510,
12511,
12549,
12425,
12441,
12525,
12544,
12470,
12453,
12456,
12487,
12545,
12468,
12489,
12555,
12566,
13143,
13181,
13140,
13183,
13148,
13162,
13121,
13173,
13150,
13151,
13158,
13163,
13125,
13117,
13153,
13131,
13130,
13132,
13133,
13139,
13137,
13114,
13113,
13116,
13175,
13128,
13176,
13123,
13167,
13122,
13178,
13168,
13152,
13124,
13146,
13138,
13119,
13120,
13129,
13169,
13182,
13179,
13172,
13171,
13142,
13155,
13147,
13159,
13157,
13156,
13164,
13141,
13134,
13180,
]

_charnames_92736 = [
10323,
10339,
10352,
10341,
10356,
10350,
10357,
10335,
10329,
10346,
10351,
10355,
10330,
10326,
10342,
10338,
10336,
10325,
10324,
10332,
10354,
10321,
10349,
10353,
10348,
10328,
10344,
10343,
10347,
10333,
10322,
-1,
10369,
10370,
10361,
10362,
10367,
10368,
10364,
10365,
10372,
10371,
-1,
-1,
-1,
-1,
10374,
10373,
]

_charnames_92880 = [
13551,
13564,
13574,
13580,
13576,
13554,
13567,
13570,
13563,
13577,
13579,
13556,
13571,
13566,
13569,
13581,
13559,
13573,
13582,
13572,
13555,
13575,
13557,
13583,
13560,
13561,
13558,
13552,
13550,
13578,
-1,
-1,
13590,
13587,
13591,
13586,
13589,
13592,
]

_charnames_92928 = [
22943,
22942,
22939,
22938,
22913,
22912,
22927,
22926,
22945,
22944,
22916,
22915,
22931,
22930,
22910,
22909,
22925,
22924,
22933,
22932,
22937,
22936,
22921,
22920,
22948,
22947,
22919,
22918,
22821,
22806,
22826,
22815,
22808,
22822,
22809,
22823,
22819,
22814,
22825,
22817,
22810,
22813,
22824,
22807,
22811,
22827,
22820,
22818,
22977,
22981,
22984,
22983,
22980,
22985,
22978,
22880,
22882,
22863,
22881,
22886,
22872,
22871,
22870,
22873,
22883,
22894,
22884,
22904,
22876,
22860,
]

_charnames_93008 = [
22959,
22960,
22951,
22952,
22957,
22958,
22954,
22955,
22962,
22961,
-1,
22969,
22972,
22967,
22974,
22973,
22968,
22970,
-1,
22885,
22874,
22901,
22889,
22902,
22900,
22898,
22875,
22897,
22905,
22888,
22893,
22890,
22903,
22895,
22866,
22862,
22858,
22859,
22864,
22865,
-1,
-1,
-1,
-1,
-1,
22832,
22840,
22846,
22847,
22851,
22837,
22849,
22853,
22834,
22833,
22852,
22838,
22850,
22844,
22854,
22841,
22831,
22836,
22843,
]

_charnames_93760 = [
8635,
8631,
8628,
8627,
8615,
8625,
8622,
8634,
8630,
8639,
8640,
8638,
8621,
8614,
8637,
8641,
8644,
8643,
8629,
8618,
8636,
8633,
8624,
8612,
8626,
8642,
8620,
8611,
8632,
8619,
8616,
8617,
8598,
8594,
8591,
8590,
8578,
8588,
8585,
8597,
8593,
8602,
8603,
8601,
8584,
8577,
8600,
8604,
8607,
8606,
8592,
8581,
8599,
8596,
8587,
8575,
8589,
8605,
8583,
8574,
8595,
8582,
8579,
8580,
8660,
8655,
8648,
8650,
8658,
8659,
8653,
8654,
8662,
8661,
8667,
8675,
8665,
8666,
8672,
8673,
8669,
8670,
8676,
8677,
8656,
8649,
8651,
8645,
8678,
8608,
8679,
]

_charnames_93952 = [
9929,
9938,
9871,
9928,
9932,
9931,
9903,
9942,
9923,
9922,
9838,
9896,
9869,
9870,
9836,
9895,
9849,
9851,
9872,
9901,
9845,
9844,
9915,
9914,
9913,
9912,
9835,
9894,
9834,
9893,
9941,
9920,
9873,
9926,
9925,
9848,
9847,
9900,
9935,
9939,
9919,
9918,
9829,
9888,
9842,
9841,
9830,
9890,
9867,
9874,
9884,
9908,
9907,
9862,
9860,
9832,
9891,
9868,
9909,
9863,
9861,
9858,
9856,
9902,
9857,
9855,
9940,
9904,
9934,
9937,
9906,
9889,
9837,
9831,
9885,
-1,
-1,
-1,
-1,
10006,
9850,
10007,
10004,
10005,
9964,
9972,
9971,
9965,
9966,
9980,
9985,
9991,
9990,
9973,
9976,
9977,
9982,
9944,
9945,
9946,
9947,
9948,
9954,
9952,
9950,
9951,
9955,
9956,
9957,
9958,
9959,
9963,
9961,
9987,
9989,
9967,
9968,
9975,
9993,
9974,
9992,
9970,
9978,
9969,
9984,
9994,
9995,
9960,
9988,
9986,
9983,
9996,
9953,
9979,
9949,
9962,
]

_charnames_94095 = [
9999,
9998,
10001,
10000,
9827,
9826,
9825,
9824,
9823,
9822,
9821,
9883,
9882,
9881,
9880,
9879,
9878,
]

_charnames_100352 = [
4223,
4222,
4221,
4220,
4219,
4218,
4217,
4216,
4215,
4213,
4212,
4211,
4210,
4209,
4208,
4207,
4206,
4205,
4204,
4202,
4201,
4200,
4199,
4198,
4197,
4196,
4195,
4194,
4193,
4191,
4190,
4189,
4188,
4187,
4186,
4185,
4184,
4183,
4182,
4180,
4179,
4178,
4177,
4176,
4175,
4174,
4173,
4172,
4171,
4169,
4168,
4167,
4166,
4165,
4164,
4163,
4162,
4161,
4160,
4158,
4157,
4156,
4155,
4154,
4153,
4152,
4151,
4150,
4149,
4147,
4146,
4145,
4144,
4143,
4142,
4141,
4140,
4139,
4138,
4136,
4135,
4134,
4133,
4132,
4131,
4130,
4129,
4128,
4127,
4125,
4124,
4123,
4122,
4121,
4120,
4119,
4118,
4117,
4116,
4113,
4112,
4111,
4110,
4109,
4108,
4107,
4106,
4105,
4104,
4102,
4101,
4100,
4099,
4098,
4097,
4096,
4095,
4094,
4093,
4091,
4090,
4089,
4088,
4087,
4086,
4085,
4084,
4083,
4082,
4080,
4079,
4078,
4077,
4076,
4075,
4074,
4073,
4072,
4071,
4069,
4068,
4067,
4066,
4065,
4064,
4063,
4062,
4061,
4060,
4058,
4057,
4056,
4055,
4054,
4053,
4052,
4051,
4050,
4049,
4047,
4046,
4045,
4044,
4043,
4042,
4041,
4040,
4039,
4038,
4036,
4035,
4034,
4033,
4032,
4031,
4030,
4029,
4028,
4027,
4025,
4024,
4023,
4022,
4021,
4020,
4019,
4018,
4017,
4016,
4014,
4013,
4012,
4011,
4010,
4009,
4008,
4007,
4006,
4005,
4002,
4001,
4000,
3999,
3998,
3997,
3996,
3995,
3994,
3993,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3982,
3980,
3979,
3978,
3977,
3976,
3975,
3974,
3973,
3972,
3971,
3969,
3968,
3967,
3966,
3965,
3964,
3963,
3962,
3961,
3960,
3958,
3957,
3956,
3955,
3954,
3953,
3952,
3951,
3950,
3949,
3947,
3946,
3945,
3944,
3943,
3942,
3941,
3940,
3939,
3938,
3936,
3935,
3934,
3933,
3932,
3931,
3930,
3929,
3928,
3927,
3925,
3924,
3923,
3922,
3921,
3920,
3919,
3918,
3917,
3916,
3914,
3913,
3912,
3911,
3910,
3909,
3908,
3907,
3906,
3905,
3903,
3902,
3901,
3900,
3899,
3898,
3897,
3896,
3895,
3894,
3891,
3890,
3889,
3888,
3887,
3886,
3885,
3884,
3883,
3882,
3880,
3879,
3878,
3877,
3876,
3875,
3874,
3873,
3872,
3871,
3869,
3868,
3867,
3866,
3865,
3864,
3863,
3862,
3861,
3860,
3858,
3857,
3856,
3855,
3854,
3853,
3852,
3851,
3850,
3849,
3847,
3846,
3845,
3844,
3843,
3842,
3841,
3840,
3839,
3838,
3836,
3835,
3834,
3833,
3832,
3831,
3830,
3829,
3828,
3827,
3825,
3824,
3823,
3822,
3821,
3820,
3819,
3818,
3817,
3816,
3814,
3813,
3812,
3811,
3810,
3809,
3808,
3807,
3806,
3805,
3803,
3802,
3801,
3800,
3799,
3798,
3797,
3796,
3795,
3794,
3792,
3791,
3790,
3789,
3788,
3787,
3786,
3785,
3784,
3783,
3780,
3779,
3778,
3777,
3776,
3775,
3774,
3773,
3772,
3771,
3769,
3768,
3767,
3766,
3765,
3764,
3763,
3762,
3761,
3760,
3758,
3757,
3756,
3755,
3754,
3753,
3752,
3751,
3750,
3749,
3747,
3746,
3745,
3744,
3743,
3742,
3741,
3740,
3739,
3738,
3736,
3735,
3734,
3733,
3732,
3731,
3730,
3729,
3728,
3727,
3725,
3724,
3723,
3722,
3721,
3720,
3719,
3718,
3717,
3716,
3714,
3713,
3712,
3711,
3710,
3709,
3708,
3707,
3706,
3705,
3703,
3702,
3701,
3700,
3699,
3698,
3697,
3696,
3695,
3694,
3692,
3691,
3690,
3689,
3688,
3687,
3686,
3685,
3684,
3683,
3681,
3680,
3679,
3678,
3677,
3676,
3675,
3674,
3673,
3672,
3669,
3668,
3667,
3666,
3665,
3664,
3663,
3662,
3661,
3660,
3658,
3657,
3656,
3655,
3654,
3653,
3652,
3651,
3650,
3649,
3647,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3638,
3636,
3635,
3634,
3633,
3632,
3631,
3630,
3629,
3628,
3627,
3625,
3624,
3623,
3622,
3621,
3620,
3619,
3618,
3617,
3616,
3614,
3613,
3612,
3611,
3610,
3609,
3608,
3607,
3606,
3605,
3603,
3602,
3601,
3600,
3599,
3598,
3597,
3596,
3595,
3594,
3592,
3591,
3590,
3589,
3588,
3587,
3586,
3585,
3584,
3583,
3581,
3580,
3579,
3578,
3577,
3576,
3575,
3574,
3573,
3572,
3570,
3569,
3568,
3567,
3566,
3565,
3564,
3563,
3562,
3561,
3558,
3557,
3556,
3555,
3554,
3553,
3552,
3551,
3550,
3549,
3547,
3546,
3545,
3544,
3543,
3542,
3541,
3540,
3539,
3538,
3536,
3535,
3534,
3533,
3532,
3531,
3530,
3529,
3528,
3527,
3525,
3524,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3516,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3505,
3503,
3502,
3501,
3500,
3499,
3498,
3497,
3496,
3495,
3494,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3485,
3484,
3483,
3481,
3480,
3479,
3478,
3477,
3476,
3475,
3474,
3473,
3472,
3470,
3469,
3468,
3467,
3466,
3465,
3464,
3463,
3462,
3461,
3459,
3458,
3457,
3456,
3455,
3454,
3453,
3452,
3451,
3450,
4290,
4289,
4288,
4287,
4286,
4285,
4284,
4283,
4282,
4281,
4279,
4278,
4277,
4276,
4275,
4274,
4273,
4272,
4271,
4270,
4268,
4267,
4266,
4265,
4264,
4263,
4262,
4261,
4260,
4259,
4257,
4256,
4255,
4254,
4253,
4252,
4251,
4250,
4249,
4248,
4246,
4245,
4244,
4243,
4242,
4241,
4240,
4239,
4238,
4237,
4235,
4234,
4233,
4232,
4231,
4230,
4229,
4228,
4227,
4226,
4300,
4299,
4298,
4297,
4296,
4295,
4294,
4293,
4292,
19162,
19161,
19160,
19159,
19158,
19157,
19156,
19155,
19154,
19153,
19152,
19151,
19150,
19149,
19148,
19147,
19145,
19144,
19143,
19142,
19141,
19140,
19139,
19138,
19137,
19136,
19135,
19134,
19133,
19132,
19131,
19130,
19128,
19127,
19126,
19125,
19124,
19123,
19122,
19121,
19120,
19119,
19118,
19117,
19116,
19115,
19114,
19113,
19111,
19110,
19109,
19108,
19107,
19106,
19105,
19104,
19103,
19102,
19101,
19100,
19099,
19098,
19097,
19096,
19094,
19093,
19092,
19091,
19090,
19089,
19088,
19087,
19086,
19085,
19084,
19083,
19082,
19081,
19080,
19079,
19077,
19076,
19075,
19074,
19073,
19072,
19071,
19070,
19069,
19068,
19067,
19066,
19065,
19064,
19063,
19062,
19060,
19059,
19058,
19057,
19056,
19055,
19054,
19053,
19052,
19051,
19050,
19049,
19048,
19047,
19046,
19045,
19043,
19042,
19041,
19040,
19039,
19038,
19037,
19036,
19035,
19034,
19033,
19032,
19031,
19030,
19029,
19028,
19026,
19025,
19024,
19023,
19022,
19021,
19020,
19019,
19018,
19017,
19016,
19015,
19014,
19013,
19012,
19011,
19009,
19008,
19007,
19006,
19005,
19004,
19003,
19002,
19001,
19000,
18999,
18998,
18997,
18996,
18995,
18994,
18992,
18991,
18990,
18989,
18988,
18987,
18986,
18985,
18984,
18983,
18982,
18981,
18980,
18979,
18978,
18977,
18975,
18974,
18973,
18972,
18971,
18970,
18969,
18968,
18967,
18966,
18965,
18964,
18963,
18962,
18961,
18960,
18958,
18957,
18956,
18955,
18954,
18953,
18952,
18951,
18950,
18949,
18948,
18947,
18946,
18945,
18944,
18943,
18941,
18940,
18939,
18938,
18937,
18936,
18935,
18934,
18933,
18932,
18931,
18930,
18929,
18928,
18927,
18926,
18924,
18923,
18922,
18921,
18920,
18919,
18918,
18917,
18916,
18915,
18914,
18913,
18912,
18911,
18910,
18909,
18907,
18906,
18905,
18904,
18903,
18902,
18901,
18900,
18899,
18898,
18897,
18896,
18895,
18894,
18893,
18892,
19384,
19383,
19382,
19381,
19380,
19379,
19378,
19377,
19376,
19375,
19374,
19373,
19372,
19371,
19370,
19369,
19367,
19366,
19365,
19364,
19363,
19362,
19361,
19360,
19359,
19358,
19357,
19356,
19355,
19354,
19353,
19352,
19350,
19349,
19348,
19347,
19346,
19345,
19344,
19343,
19342,
19341,
19340,
19339,
19338,
19337,
19336,
19335,
19333,
19332,
19331,
19330,
19329,
19328,
19327,
19326,
19325,
19324,
19323,
19322,
19321,
19320,
19319,
19318,
19316,
19315,
19314,
19313,
19312,
19311,
19310,
19309,
19308,
19307,
19306,
19305,
19304,
19303,
19302,
19301,
19299,
19298,
19297,
19296,
19295,
19294,
19293,
19292,
19291,
19290,
19289,
19288,
19287,
19286,
19285,
19284,
19282,
19281,
19280,
19279,
19278,
19277,
19276,
19275,
19274,
19273,
19272,
19271,
19270,
19269,
19268,
19267,
19265,
19264,
19263,
19262,
19261,
19260,
19259,
19258,
19257,
19256,
19255,
19254,
19253,
19252,
19251,
19250,
19248,
19247,
19246,
19245,
19244,
19243,
19242,
19241,
19240,
19239,
19238,
19237,
19236,
19235,
19234,
19233,
19231,
19230,
19229,
19228,
19227,
19226,
19225,
19224,
19223,
19222,
19221,
19220,
19219,
19218,
19217,
19216,
19214,
19213,
19212,
19211,
19210,
19209,
19208,
19207,
19206,
19205,
19204,
19203,
19202,
19201,
19200,
19199,
19197,
19196,
19195,
19194,
19193,
19192,
19191,
19190,
19189,
19188,
19187,
19186,
19185,
19184,
19183,
19182,
19180,
19179,
19178,
19177,
19176,
19175,
19174,
19173,
19172,
19171,
19170,
19169,
19168,
19167,
19166,
19165,
19391,
19390,
19389,
19388,
19387,
19386,
]

_charnames_110592 = [
19966,
21919,
21354,
21353,
21352,
21351,
21349,
21348,
21347,
21346,
21344,
21343,
21342,
21341,
21340,
21337,
21336,
21335,
21334,
21333,
21358,
21357,
21356,
21018,
21029,
21028,
21027,
21026,
21025,
21024,
21023,
21022,
21020,
21019,
21021,
21038,
21037,
21036,
21035,
21034,
21033,
21032,
21031,
21046,
21045,
21044,
21043,
21042,
21041,
21040,
21053,
21052,
21051,
21050,
21049,
21048,
21058,
21057,
21056,
21055,
21119,
21118,
21117,
21116,
21115,
21114,
21113,
21112,
21134,
21133,
21132,
21131,
21130,
21129,
21110,
21109,
21108,
21107,
21106,
21105,
21104,
21103,
21140,
21139,
21138,
21137,
21136,
21127,
21126,
21125,
21124,
21123,
21122,
21121,
21219,
21218,
21217,
21216,
21208,
21207,
21206,
21205,
21204,
21203,
21202,
21214,
21213,
21212,
21211,
21210,
21192,
21191,
21190,
21189,
21188,
21187,
21186,
21185,
21184,
21200,
21199,
21198,
21197,
21196,
21195,
21194,
21151,
21150,
21149,
21148,
21147,
21146,
21145,
21144,
21143,
21160,
21159,
21158,
21157,
21156,
21155,
21154,
21153,
21178,
21177,
21176,
21168,
21167,
21166,
21165,
21164,
21163,
21162,
21174,
21173,
21172,
21171,
21170,
21061,
21071,
21070,
21069,
21068,
21067,
21066,
21065,
21064,
21063,
21062,
21088,
21087,
21086,
21085,
21084,
21083,
21082,
21100,
21099,
21098,
21096,
21095,
21094,
21093,
21092,
21091,
21090,
21080,
21079,
21078,
21077,
21076,
21075,
21074,
21073,
21269,
21268,
21267,
21266,
21265,
21264,
21263,
21261,
21260,
21259,
21258,
21257,
21256,
21255,
21281,
21280,
21279,
21278,
21285,
21284,
21283,
21276,
21275,
21274,
21273,
21272,
21271,
21326,
21325,
21324,
21323,
21322,
21321,
21331,
21330,
21329,
21328,
21319,
21318,
21317,
21316,
21315,
21314,
21252,
21251,
21250,
21249,
21228,
21227,
21226,
21225,
21224,
21223,
21222,
21235,
21234,
21233,
21232,
21231,
21230,
21247,
21246,
21245,
21244,
21242,
21241,
21240,
21239,
21238,
21237,
21306,
21305,
21304,
21303,
21302,
21300,
21299,
21298,
21297,
21296,
21311,
21310,
21309,
21308,
21294,
21293,
21292,
21291,
21290,
21289,
21288,
21181,
21180,
]

_charnames_110960 = [
18115,
18114,
18113,
18112,
18111,
18110,
18109,
18108,
18107,
18106,
18105,
18104,
18103,
18102,
18101,
18100,
18098,
18097,
18096,
18095,
18094,
18093,
18092,
18091,
18090,
18089,
18088,
18087,
18086,
18085,
18084,
18083,
18081,
18080,
18079,
18078,
18077,
18076,
18075,
18074,
18073,
18072,
18071,
18070,
18069,
18068,
18067,
18066,
18064,
18063,
18062,
18061,
18060,
18059,
18058,
18057,
18056,
18055,
18054,
18053,
18052,
18051,
18050,
18049,
18047,
18046,
18045,
18044,
18043,
18042,
18041,
18040,
18039,
18038,
18037,
18036,
18035,
18034,
18033,
18032,
18030,
18029,
18028,
18027,
18026,
18025,
18024,
18023,
18022,
18021,
18020,
18019,
18018,
18017,
18016,
18015,
18013,
18012,
18011,
18010,
18009,
18008,
18007,
18006,
18005,
18004,
18003,
18002,
18001,
18000,
17999,
17998,
17996,
17995,
17994,
17993,
17992,
17991,
17990,
17989,
17988,
17987,
17986,
17985,
17984,
17983,
17982,
17981,
17979,
17978,
17977,
17976,
17975,
17974,
17973,
17972,
17971,
17970,
17969,
17968,
17967,
17966,
17965,
17964,
17948,
17947,
17946,
17945,
17944,
17943,
17942,
17941,
17940,
17939,
17938,
17937,
17936,
17935,
17934,
17933,
17931,
17930,
17929,
17928,
17927,
17926,
17925,
17924,
17923,
17922,
17921,
17920,
17919,
17918,
17917,
17916,
17914,
17913,
17912,
17911,
17910,
17909,
17908,
17907,
17906,
17905,
17904,
17903,
17902,
17901,
17900,
17899,
17897,
17896,
17895,
17894,
17893,
17892,
17891,
17890,
17889,
17888,
17887,
17886,
17885,
17884,
17883,
17882,
17880,
17879,
17878,
17877,
17876,
17875,
17874,
17873,
17872,
17871,
17870,
17869,
17868,
17867,
17866,
17865,
17863,
17862,
17861,
17860,
17859,
17858,
17857,
17856,
17855,
17854,
17853,
17852,
17851,
17850,
17849,
17848,
17846,
17845,
17844,
17843,
17842,
17841,
17840,
17839,
17838,
17837,
17836,
17835,
17834,
17833,
17832,
17831,
17829,
17828,
17827,
17826,
17825,
17824,
17823,
17822,
17821,
17820,
17819,
17818,
17817,
17816,
17815,
17814,
17812,
17811,
17810,
17809,
17808,
17807,
17806,
17805,
17804,
17803,
17802,
17801,
17800,
17799,
17798,
17797,
17795,
17794,
17793,
17792,
17791,
17790,
17789,
17788,
17787,
17786,
17785,
17784,
17783,
17782,
17781,
17780,
17778,
17777,
17776,
17775,
17774,
17773,
17772,
17771,
17770,
17769,
17768,
17767,
17766,
17765,
17764,
17763,
17761,
17760,
17759,
17758,
17757,
17756,
17755,
17754,
17753,
17752,
17751,
17750,
17749,
17748,
17747,
17746,
17744,
17743,
17742,
17741,
17740,
17739,
17738,
17737,
17736,
17735,
17734,
17733,
17732,
17731,
17730,
17729,
17727,
17726,
17725,
17724,
17723,
17722,
17721,
17720,
17719,
17718,
17717,
17716,
17715,
17714,
17713,
17712,
17710,
17709,
17708,
17707,
17706,
17705,
17704,
17703,
17702,
17701,
17700,
17699,
17698,
17697,
17696,
17695,
17961,
17960,
17959,
17958,
17957,
17956,
17955,
17954,
17953,
17952,
17951,
17950,
]

_charnames_113664 = [
24073,
24067,
24046,
24041,
24077,
24056,
24051,
24082,
24064,
24069,
24075,
24020,
24050,
24066,
24078,
24059,
24025,
24045,
23988,
24065,
24060,
23987,
24074,
24055,
24024,
24031,
23991,
24002,
23963,
24033,
23998,
24010,
23973,
24035,
24000,
24004,
24005,
23965,
23966,
24036,
24001,
24006,
23975,
24034,
23999,
24011,
23974,
24007,
24008,
24009,
23967,
23968,
23969,
23970,
24043,
24044,
24012,
24016,
24019,
23976,
23977,
24058,
24076,
23971,
23972,
24079,
23984,
24030,
24026,
24080,
24071,
24061,
24072,
23990,
24038,
24063,
23981,
24023,
23982,
24054,
24081,
24037,
24062,
24068,
24040,
24053,
24022,
24039,
23986,
24029,
24027,
24028,
24018,
24013,
24015,
24017,
24014,
23993,
23994,
23995,
23996,
24048,
24049,
23980,
23989,
23985,
24070,
-1,
-1,
-1,
-1,
-1,
24099,
24123,
24124,
24087,
24122,
24102,
24117,
24118,
24114,
24116,
24120,
24119,
24115,
-1,
-1,
-1,
24111,
24107,
24108,
24104,
24109,
24110,
24105,
24106,
24101,
]

_charnames_113808 = [
24093,
24095,
24096,
24089,
24097,
24098,
24090,
24094,
24086,
24092,
-1,
-1,
24126,
24125,
24128,
24127,
7313,
7315,
7314,
7312,
]

_charnames_119262 = [
10311,
10301,
10307,
10309,
10308,
10310,
10304,
10303,
10300,
10299,
10306,
]

_charnames_119296 = [
24538,
24555,
24566,
24565,
24549,
24564,
24563,
24562,
24561,
24548,
24547,
24546,
24545,
24544,
24543,
24542,
24541,
24540,
24539,
24560,
24559,
24558,
24557,
24556,
24554,
24553,
24552,
24551,
24550,
24506,
24514,
24498,
24521,
24535,
24534,
24513,
24512,
24511,
24510,
24509,
24508,
24507,
24520,
24519,
24518,
24517,
24516,
24515,
24533,
24532,
24531,
24530,
24529,
24528,
24505,
24504,
24503,
24502,
24501,
24500,
24499,
24526,
24525,
24524,
24523,
24522,
1667,
1668,
1669,
24631,
]

_charnames_119520 = [
9391,
9392,
9368,
9371,
9380,
9383,
9375,
9377,
9386,
9389,
9373,
9388,
9369,
9372,
9381,
9384,
9376,
9378,
9387,
9390,
]

_charnames_119552 = [
9772,
24258,
24257,
24252,
24251,
24249,
5373,
5410,
5442,
5453,
5462,
5360,
5437,
5458,
5451,
5383,
5379,
5469,
5465,
5435,
5405,
5362,
5467,
5456,
5413,
5439,
5404,
5401,
5396,
5472,
5361,
5391,
5385,
5372,
5384,
5452,
5433,
5449,
5369,
5461,
5425,
5421,
5434,
5409,
5402,
5447,
5403,
5429,
5392,
5419,
5428,
5390,
5432,
5406,
5414,
5470,
5363,
5443,
5394,
5471,
5378,
5370,
5427,
5426,
5444,
5440,
5395,
5386,
5455,
5422,
5464,
5382,
5387,
5377,
5393,
5423,
5420,
5468,
5366,
5371,
5415,
5438,
5365,
5459,
5380,
5448,
5412,
]

_charnames_119648 = [
2153,
2145,
2146,
2151,
2152,
2148,
2149,
2155,
2154,
2166,
2158,
2159,
2164,
2165,
2161,
2162,
2168,
2167,
26292,
26287,
26288,
26290,
26291,
5132,
5133,
]

_charnames_120832 = [
5682,
5914,
5895,
6034,
5948,
6003,
5773,
5926,
5783,
5772,
5775,
5761,
5765,
5925,
5684,
5916,
5725,
5722,
5723,
5766,
5763,
5687,
5700,
5699,
5697,
5695,
5702,
5919,
5820,
5774,
5705,
5921,
5728,
5726,
5716,
5724,
5768,
5769,
5764,
5727,
5708,
5710,
5712,
5713,
5787,
5690,
5692,
5693,
5812,
5753,
5696,
5703,
5694,
5698,
5805,
5748,
5803,
5804,
5759,
5760,
5750,
5709,
5715,
5714,
5808,
5809,
5810,
5754,
5861,
5866,
5865,
5863,
5864,
5944,
5848,
5983,
5852,
5875,
5859,
5877,
5860,
5878,
5858,
5903,
5904,
5984,
6035,
5854,
5856,
5857,
5849,
5884,
5873,
5881,
5879,
5883,
5882,
5872,
5868,
5869,
5870,
5871,
5935,
5938,
5942,
5939,
6000,
5987,
5889,
5887,
5892,
5901,
5894,
5905,
5893,
5902,
5909,
5907,
5912,
6026,
6029,
6032,
6030,
5963,
5967,
5946,
5985,
5966,
5975,
5968,
5986,
5976,
5977,
6001,
5718,
5922,
5958,
6012,
5969,
5721,
5720,
5959,
5822,
5825,
5826,
5827,
5833,
5782,
5932,
6033,
6018,
5834,
5835,
5829,
5830,
5973,
5832,
5972,
6017,
6016,
5831,
5933,
5971,
6015,
5729,
5923,
5960,
5978,
6013,
5704,
5920,
5846,
5979,
6025,
5841,
5843,
5844,
5934,
6031,
6024,
5837,
5840,
5839,
5845,
5842,
5999,
5771,
5924,
5911,
5997,
5998,
5996,
5899,
5961,
6010,
6009,
5819,
5980,
5813,
5930,
5817,
5814,
5994,
5811,
5818,
5816,
5928,
5910,
5906,
5981,
6021,
6022,
6019,
5929,
5940,
5941,
5992,
5993,
5990,
5962,
5731,
5954,
5734,
5735,
5736,
5739,
5740,
5738,
5756,
5757,
5751,
5747,
5746,
5943,
5745,
5749,
5897,
5898,
5955,
5956,
5950,
5953,
6007,
6008,
6005,
5776,
5797,
5791,
5792,
5793,
5798,
5786,
5789,
5788,
5780,
5795,
5781,
5784,
5796,
5680,
5847,
6405,
6406,
6407,
6654,
6655,
6656,
6590,
6591,
6592,
6640,
6641,
6642,
6475,
6476,
6477,
6599,
6600,
6586,
6582,
6587,
6583,
6584,
6558,
6554,
6559,
6555,
6556,
6588,
6322,
6321,
6323,
6325,
6320,
6319,
6324,
6171,
6291,
6114,
6115,
6112,
6113,
6116,
6151,
6150,
6148,
6149,
6087,
6146,
6145,
6143,
6144,
6132,
6133,
6134,
6079,
6081,
6082,
6080,
6084,
6085,
6086,
6128,
6129,
6130,
6160,
6161,
6162,
6164,
6165,
6166,
6369,
6370,
6371,
6373,
6374,
6375,
6380,
6378,
6379,
6377,
6313,
6314,
6311,
6312,
6308,
6309,
6306,
6307,
6303,
6304,
6301,
6302,
6298,
6299,
6296,
6297,
6248,
6249,
6246,
6247,
6250,
6272,
6271,
6269,
6270,
6192,
6267,
6266,
6265,
6264,
6278,
6189,
6190,
6191,
6193,
6275,
6276,
6277,
6280,
6281,
6282,
6284,
6285,
6286,
6388,
6389,
6390,
6384,
6385,
6386,
6391,
6068,
6069,
6066,
6067,
6060,
6061,
6058,
6059,
6072,
6073,
6139,
6140,
6141,
6119,
6124,
6125,
6120,
6096,
6097,
6098,
6092,
6093,
6094,
6074,
6076,
6077,
6431,
6435,
6443,
6117,
6063,
6137,
6122,
6104,
6433,
6437,
6441,
6064,
6138,
6123,
6105,
6434,
6438,
6442,
6100,
6101,
6102,
6181,
6182,
6238,
6241,
6237,
6240,
6221,
6224,
6222,
6225,
6201,
6202,
6448,
6452,
6456,
6178,
6179,
6233,
6234,
6231,
6232,
6214,
6217,
6215,
6218,
6198,
6199,
6447,
6451,
6455,
6185,
6186,
6183,
6184,
6187,
6242,
6226,
6204,
6205,
6206,
6445,
6449,
6453,
6251,
6154,
6157,
6155,
6158,
6254,
6257,
6260,
6255,
6258,
6261,
6107,
6108,
6208,
6209,
6169,
6170,
6289,
6290,
6609,
6610,
6614,
6607,
6611,
6612,
6605,
6606,
6615,
6613,
6037,
6049,
6043,
6042,
6046,
6044,
6047,
6048,
6576,
6574,
6575,
6510,
6511,
6512,
6619,
6621,
6620,
6618,
6571,
6572,
6570,
6503,
6502,
6504,
6515,
6516,
6500,
6498,
6501,
6497,
6517,
6506,
6508,
6507,
6482,
6484,
6485,
6490,
6492,
6493,
6487,
6494,
6488,
6633,
6634,
6632,
6426,
6424,
6425,
6519,
6627,
6628,
6625,
6626,
6651,
6648,
6652,
6649,
6644,
6645,
6341,
6342,
6343,
6349,
6351,
6352,
6357,
6359,
6360,
6338,
6337,
6336,
6332,
6335,
6334,
6328,
6331,
6330,
6353,
6356,
6355,
6345,
6348,
6347,
6536,
6535,
6534,
6344,
6362,
6363,
6400,
6402,
6396,
6395,
6403,
6401,
6398,
6399,
6414,
6421,
6417,
6418,
6419,
6420,
6422,
6172,
6292,
6629,
6036,
6518,
6595,
6596,
6657,
6560,
6597,
6410,
6411,
6412,
6658,
6531,
6530,
6529,
6528,
6527,
6526,
6525,
6524,
6568,
6547,
6548,
6540,
6542,
6545,
6541,
6543,
6544,
6636,
6577,
6601,
6637,
6659,
]

_charnames_121499 = [
6567,
6566,
6565,
6564,
6563,
-1,
6473,
6472,
6471,
6470,
6469,
6468,
6467,
6466,
6465,
6464,
6463,
6462,
6461,
6460,
6459,
]

_charnames_122880 = [
1642,
1628,
1630,
1640,
1625,
1599,
1616,
-1,
1617,
1607,
1608,
1603,
1626,
1638,
1637,
1636,
1635,
1634,
1633,
1632,
1614,
1619,
1631,
1622,
1639,
-1,
-1,
1611,
1620,
1641,
1612,
1597,
1598,
1602,
-1,
1600,
1613,
-1,
1601,
1605,
1629,
1606,
1623,
]

_charnames_123136 = [
18677,
18662,
18650,
18663,
18678,
18659,
18666,
18657,
18699,
18694,
18692,
18687,
18658,
18649,
18695,
18684,
18654,
18655,
18690,
18648,
18661,
18698,
18669,
18693,
18688,
18656,
18672,
18665,
18653,
18683,
18652,
18679,
18676,
18671,
18697,
18668,
18685,
18686,
18696,
18691,
18673,
18674,
18680,
18681,
18689,
-1,
-1,
-1,
18722,
18718,
18719,
18716,
18717,
18720,
18721,
18727,
18726,
18728,
18730,
18729,
18731,
18732,
-1,
-1,
18711,
18712,
18703,
18704,
18709,
18710,
18706,
18707,
18714,
18713,
-1,
-1,
-1,
-1,
18700,
18733,
]

_charnames_123584 = [
25720,
25719,
25769,
25768,
25767,
25765,
25739,
25746,
25750,
25736,
25747,
25729,
25728,
25766,
25744,
25743,
25763,
25758,
25759,
25760,
25753,
25730,
25723,
25761,
25762,
25752,
25764,
25756,
25754,
25735,
25740,
25749,
25726,
25727,
25732,
25722,
25724,
25755,
25731,
25757,
25721,
25734,
25741,
25738,
25785,
25786,
25787,
25788,
25780,
25781,
25772,
25773,
25778,
25779,
25775,
25776,
25783,
25782,
-1,
-1,
-1,
-1,
-1,
25789,
]

_charnames_124928 = [
8271,
8270,
8269,
8201,
8168,
8189,
8220,
8285,
8268,
8267,
8266,
8343,
8352,
8356,
8223,
8376,
8324,
8205,
8219,
8329,
8265,
8264,
8263,
8208,
8169,
8312,
8274,
8261,
8260,
8259,
8316,
8166,
8368,
8330,
8258,
8257,
8256,
8302,
8371,
8300,
8320,
8331,
8337,
8333,
8375,
8286,
8252,
8250,
8249,
8303,
8354,
8332,
8186,
8374,
8245,
8244,
8243,
8180,
8192,
8213,
8313,
8360,
8255,
8254,
8253,
8175,
8283,
8282,
8248,
8247,
8246,
8172,
8212,
8367,
8197,
8242,
8241,
8239,
8309,
8357,
8305,
8203,
8289,
8238,
8237,
8236,
8362,
8184,
8326,
8348,
8235,
8234,
8233,
8187,
8190,
8335,
8176,
8373,
8370,
8232,
8231,
8230,
8353,
8296,
8288,
8227,
8277,
8228,
8167,
8226,
8327,
8181,
8341,
8214,
8338,
8177,
8215,
8377,
8222,
8173,
8225,
8182,
8355,
8321,
8310,
8349,
8307,
8342,
8178,
8365,
8280,
8311,
8359,
8297,
8380,
8299,
8298,
8279,
8210,
8287,
8198,
8164,
8217,
8183,
8216,
8369,
8200,
8322,
8204,
8347,
8221,
8275,
8193,
8292,
8290,
8276,
8304,
8366,
8325,
8336,
8171,
8191,
8224,
8363,
8358,
8308,
8345,
8211,
8319,
8170,
8364,
8194,
8195,
8293,
8346,
8340,
8344,
8379,
8351,
8199,
8202,
8314,
8378,
8318,
8334,
8281,
8278,
8315,
8291,
8179,
8323,
8188,
8301,
8209,
8294,
8165,
8206,
-1,
-1,
8391,
8383,
8384,
8389,
8390,
8386,
8387,
8393,
8392,
8400,
8398,
8403,
8401,
8399,
8404,
8405,
]

_charnames_125184 = [
17343,
17322,
17336,
17335,
17325,
17315,
17333,
17324,
17331,
17341,
17340,
17338,
17334,
17321,
17312,
17327,
17305,
17310,
17313,
17329,
17337,
17342,
17339,
17332,
17319,
17304,
17330,
17306,
17328,
17309,
17318,
17326,
17308,
17316,
17386,
17365,
17379,
17378,
17368,
17358,
17376,
17367,
17374,
17384,
17383,
17381,
17377,
17364,
17355,
17370,
17348,
17353,
17356,
17372,
17380,
17385,
17382,
17375,
17362,
17347,
17373,
17349,
17371,
17352,
17361,
17369,
17351,
17359,
17412,
17410,
17408,
17411,
17344,
17409,
17402,
17403,
-1,
-1,
-1,
-1,
17397,
17398,
17389,
17390,
17395,
17396,
17392,
17393,
17400,
17399,
-1,
-1,
-1,
-1,
17406,
17405,
]

_charnames_126065 = [
26107,
26039,
26046,
26069,
26076,
26055,
26061,
26101,
26095,
26052,
26043,
26050,
26073,
26080,
26056,
26062,
26102,
26096,
26110,
26042,
26049,
26072,
26079,
26060,
26066,
26106,
26100,
26109,
26041,
26048,
26071,
26078,
26059,
26065,
26105,
26099,
26053,
26044,
26051,
26074,
26081,
26057,
26063,
26103,
26097,
26116,
26117,
26127,
26118,
26119,
26092,
26084,
26085,
26090,
26091,
26087,
26088,
26094,
26093,
26126,
26122,
26123,
26124,
26125,
26115,
26113,
26114,
26128,
]

_charnames_126209 = [
22692,
22637,
22644,
22667,
22674,
22653,
22659,
22686,
22680,
22650,
22641,
22648,
22671,
22678,
22654,
22660,
22687,
22681,
22695,
22640,
22647,
22670,
22677,
22658,
22664,
22691,
22685,
22694,
22639,
22646,
22669,
22676,
22657,
22663,
22690,
22684,
22651,
22642,
22649,
22672,
22679,
22655,
22661,
22688,
22682,
22716,
22698,
22702,
22708,
22710,
22704,
22706,
22712,
22711,
22700,
22709,
22705,
22699,
22701,
22715,
22714,
]

_charnames_126464 = [
16797,
16809,
16805,
16663,
-1,
16800,
16788,
16806,
16782,
16799,
16795,
16701,
16804,
16803,
16734,
16798,
16808,
16735,
16802,
16801,
16733,
16786,
16784,
16794,
16785,
16664,
16789,
16807,
16661,
16659,
16660,
16658,
-1,
16759,
16755,
-1,
16748,
-1,
-1,
16749,
-1,
16750,
16746,
16754,
16753,
16752,
16739,
16760,
16757,
16740,
16751,
-1,
16738,
16743,
16742,
16745,
-1,
16758,
-1,
16756,
-1,
-1,
-1,
-1,
-1,
-1,
16778,
-1,
-1,
-1,
-1,
16779,
-1,
16773,
-1,
16776,
-1,
16775,
16766,
16781,
-1,
16767,
16774,
-1,
16765,
-1,
-1,
16777,
-1,
16772,
-1,
16780,
-1,
16771,
-1,
16770,
-1,
16731,
16728,
-1,
16721,
-1,
-1,
16722,
16707,
16724,
16719,
-1,
16727,
16726,
16710,
16732,
16730,
16711,
16725,
-1,
16709,
16706,
16705,
16718,
-1,
16716,
16723,
16729,
16715,
-1,
16714,
-1,
16687,
16700,
16697,
16684,
16681,
16690,
16678,
16682,
16672,
16689,
-1,
16695,
16694,
16693,
16675,
16688,
16699,
16676,
16692,
16691,
16674,
16671,
16669,
16696,
16670,
16685,
16679,
16698,
-1,
-1,
-1,
-1,
-1,
16655,
16651,
16641,
-1,
16644,
16638,
16652,
16632,
16643,
-1,
16649,
16648,
16647,
16635,
16656,
16654,
16636,
16646,
16645,
16634,
16631,
16629,
16650,
16630,
16642,
16639,
16653,
]

_charnames_126976 = [
9012,
8969,
9016,
9005,
9020,
9023,
9015,
8996,
8974,
8979,
8985,
8990,
8960,
8965,
9010,
9003,
8997,
8975,
8980,
8986,
8991,
8961,
8966,
9011,
9004,
8995,
8973,
8978,
8984,
8989,
8959,
8964,
9009,
9002,
9021,
8998,
9018,
9024,
8968,
8967,
9025,
9014,
9022,
9019,
-1,
-1,
-1,
-1,
23785,
23784,
23783,
23782,
23781,
23780,
23779,
23778,
23776,
23775,
23774,
23773,
23772,
23771,
23770,
23768,
23767,
23766,
23765,
23764,
23763,
23762,
23760,
23759,
23758,
23757,
23756,
23755,
23754,
23752,
23751,
23750,
23749,
23748,
23747,
23746,
23744,
23743,
23742,
23741,
23740,
23739,
23738,
23736,
23735,
23734,
23733,
23732,
23731,
23730,
23726,
23725,
23724,
23723,
23722,
23721,
23720,
23719,
23717,
23716,
23715,
23714,
23713,
23712,
23711,
23709,
23708,
23707,
23706,
23705,
23704,
23703,
23701,
23700,
23699,
23698,
23697,
23696,
23695,
23693,
23692,
23691,
23690,
23689,
23688,
23687,
23685,
23684,
23683,
23682,
23681,
23680,
23679,
23677,
23676,
23675,
23674,
23673,
23672,
23671,
]

_charnames_127136 = [
23460,
23454,
23384,
23389,
23401,
23407,
23413,
23418,
23449,
23439,
23394,
23444,
23424,
23434,
23429,
-1,
-1,
23455,
23385,
23390,
23402,
23408,
23414,
23419,
23450,
23440,
23395,
23445,
23425,
23435,
23430,
23462,
-1,
23456,
23386,
23391,
23403,
23409,
23415,
23420,
23451,
23441,
23396,
23446,
23426,
23436,
23431,
23459,
-1,
23457,
23387,
23392,
23404,
23410,
23416,
23421,
23452,
23442,
23397,
23447,
23427,
23437,
23432,
23461,
23405,
23362,
23373,
23382,
23381,
23380,
23379,
23378,
23377,
23376,
23372,
23371,
23370,
23369,
23368,
23367,
23366,
23365,
23364,
23363,
23375,
23374,
]

_charnames_127232 = [
24234,
24235,
24245,
24237,
24238,
24243,
24244,
24240,
24241,
24247,
24246,
24282,
24281,
3393,
3400,
3398,
23087,
23086,
23085,
23084,
23083,
23082,
23081,
23080,
23079,
23078,
23077,
23076,
23075,
23074,
23073,
23072,
23071,
23070,
23069,
23068,
23067,
23066,
23065,
23064,
23063,
23062,
5578,
3361,
3360,
3384,
3395,
2140,
7644,
7643,
7642,
7641,
7640,
7639,
7638,
7637,
7636,
7635,
7634,
7633,
7632,
7631,
7630,
7629,
7628,
7627,
7626,
7625,
7624,
7623,
7622,
7621,
7620,
7619,
7668,
7697,
7659,
7655,
7696,
7695,
18435,
