# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=9.0.0 --output=unicodedb_9_0_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '9.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x0c ABOVE RIGHT'
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x03 AN'
'\x05 AND '
'\n AND ARROW'
'\x0f AND COLD SWEAT'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x06 ARROW'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\t ASTERISK'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x05 BACK'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x12 BRIGHTNESS SYMBOL'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\x07 CER-WA'
'\n CHARACTER'
'\x06 CHART'
'\x07 CHIKI '
'\x05 CHWV'
'\x07 CIRCLE'
'\n CONJOINED'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING ESH2'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\t DRACHMAS'
'\x07 ENGINE'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x06 FINAL'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\t HITTING '
'\x05 HOOK'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ICON'
'\x05 ILUT'
'\x03 IN'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x04 KEY'
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x08 MAKSURA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x06 MURDA'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\x0b OF HYGIEIA'
'\r OF THE HORNS'
'\x05 OPEN'
'\x07 OPEN-O'
'\r OPPOSING KUR'
'\x04 ORE'
'\x04 OUT'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
'\x12 OVER HI TIMES ASH'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x16 OVER STAMPED ENVELOPE'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DA'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GAL'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\x10 PLUS KAK PLUS A'
'\x0c PLUS KASKAL'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x12 PLUS PAP PLUS LU3'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\t PLUS SAG'
'\x11 PLUS SHA3 PLUS A'
'\t PLUS SHU'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x07 PLUS U'
'\t PLUS ZA7'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x07 POMMEE'
'\x04 POT'
'\x0c PUNCTUATION'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x0c RING LITTLE'
'\x08 ROTUNDA'
'\x06 RULER'
'\x02 S'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x07 SECANT'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x12 THROUGH DESCENDER'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES BAD'
'\x10 TIMES DISH TENU'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\t TIMES HA'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x0b TIMES TAK4'
'\x08 TIMES U'
'\t TIMES UD'
'\x07 TO BAR'
'\x05 TONE'
'\x06 TONE-'
'\x0f TOUCHING INDEX'
'\x08 TTUDDAG'
'\x02 U'
'\x04 U U'
'\r VARIANT FORM'
'\x04 WEB'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE MIDDLE TILDE'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x0b WITH FLASH'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\x0f WITH RIGHT LEG'
'\n WITH RING'
'\x12 WITH SMILING EYES'
'\x11 WITH SOUND WAVES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x0b WITHIN DOT'
'\x07 WOLOSO'
'\x0b WRIST FLEX'
'\x02 X'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x02-A'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\t-LOW TONE'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x0b-OFF SYMBOL'
'\x06-PIEUP'
'\n-POINTING '
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x08-X BELOW'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x080 BRONZE'
'\x050 DOO'
'\x050 DWO'
'\x030 E'
'\x0b0 FOOTSTOOL'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\x040 KO'
'\t0 LONG LE'
'\x040 MA'
'\x050 MAN'
'\x060 NGGI'
'\x060 NGGO'
'\x040 NI'
'\x060 NYON'
'\x060 NYUN'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x040 SA'
'\x070 SPEAR'
'\x030 U'
'\x030 W'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 YE'
'\x040 ZO'
'\x030-0'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0304A'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x031 A'
'\x071 ARROW'
'\x041 BA'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DO'
'\x041 DU'
'\x051 DWE'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x061 GOLD'
'\x041 HA'
'\x081 HELMET'
'\x061 HORN'
'\x041 IN'
'\x041 KI'
'\x041 KU'
'\n1 LONG MBE'
'\x061 NDEE'
'\x031 O'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 PO'
'\x041 QI'
'\x041 RA'
'\x041 SA'
'\x041 SI'
'\x041 SU'
'\x051 TEE'
'\x051 TWO'
'\x041 VU'
'\x061 WINE'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-0'
'\x031-2'
'\x051-VAS'
'\x0211'
'\x03121'
'\x0314D'
'\x03155'
'\x0216'
'\x0217'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x032 B'
'\x042 BU'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\x072 PLUS '
'\n2 PLUS ASH'
'\x052 POO'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x052 SEE'
'\x042 SO'
'\x042 TI'
'\x042 VI'
'\x042 WO'
'\x072 WOMAN'
'\x032 Y'
'\x042 YA'
'\x032-0'
'\x052-VAS'
'\x0220'
'\x0320B'
'\x0221'
'\x0222'
'\x0224'
'\t247 DIPTE'
'\x03253'
'\x0726 EYYY'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 PA'
'\t3 PLUS AN'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x043 TA'
'\x053 VEE'
'\x053 WEI'
'\x073 WHEEL'
'\x043 YU'
'\x033-0'
'\x053-VAS'
'\x0230'
'\x03305'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0233'
'\x0234'
'\x0236'
'\x0238'
'\x0239'
'\x014'
'\x034 A'
'\x054 ABB'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x044 KE'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x044 NE'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x044 TE'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WA'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x044 ZE'
'\x034-0'
'\x054-VAS'
'\x0240'
'\x0242'
'\x0248'
'\x0249'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AN'
'\x045 AU'
'\t5 BATHTUB'
'\x045 BB'
'\t5 CYPERUS'
'\x045 DE'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 JU'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x065 MERI'
'\x045 MO'
'\x055 NDU'
'\x075 NGGEE'
'\x045 NU'
'\x045 OO'
'\x045 TE'
'\x045 TO'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WE'
'\x045 WO'
'\x065 WOOL'
'\x035-0'
'\x055-VAS'
'\x0250'
'\x0253'
'\x0255'
'\x03550'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x046 JE'
'\x046 JO'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x046 NA'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 TA2'
'\x066 TREE'
'\x056 WEE'
'\x046 WU'
'\x036-0'
'\x056-VAS'
'\x0262'
'\x03620'
'\x0264'
'\x036D7'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 DI'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x047 JA'
'\x057 JEE'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 VO'
'\x047 ZA'
'\x057-VAS'
'\x0270'
'\x0271'
'\x0272'
'\x0372C'
'\x0279'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x038 A'
'\x048 BO'
'\x048 DU'
'\x038 E'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x038 I'
'\x048 JI'
'\x038 K'
'\x088 KANAKO'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x058 NWA'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 SI'
'\x049 SO'
'\x049 TA'
'\x049 TO'
'\x049 TU'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x0292'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\tA PLUS NA'
'\x08A SIGN A'
'\nA TANG LAI'
'\x07A WITH '
'\rA WITH STROKE'
'\x05A YUE'
'\x04A-HA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\nAB2 TIMES '
'\x03ABA'
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x05ABOVE'
'\x06ABOVE '
'\x0eABOVE REVERSE '
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\rACCOMMODATION'
'\x03ACE'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x03AD3'
'\x03ADA'
'\x04ADA '
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x02AE'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x0eAFETY SCISSORS'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x04AGE '
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x08AGRAPHOS'
'\x02AH'
'\x08AH WITH '
'\x16AH WITH TWO DOTS ABOVE'
'\x04AHAD'
'\x08AHAPRANA'
'\x05AHMI '
'\x02AI'
'\x0fAI LAING DIGIT '
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\x02AJ'
'\x06AJANI '
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x03AK4'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x05ALLOT'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x05ALPHA'
'\x08ALTERNAT'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x08AM WITH '
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x03AMI'
'\x04AMLA'
'\x04AMMA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\x04AN X'
'\x03AN2'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x0fAND FEMALE SIGN'
'\x12AND LOW RIGHT RING'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\nANDHI MARK'
'\nANDRABINDU'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANG CITI '
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x08ANI SIGN'
'\x04ANJI'
'\x08ANS SIGN'
'\x0fANS-SERIF ARROW'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x03AR '
'\x04ARA3'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDNESS'
'\x03ARE'
'\nARFUL FACE'
'\x05ARGE '
'\x03ARK'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x08ARRIVING'
'\x05ARROW'
'\x06ARROW '
'\x07ARROW O'
'\x12ARROW SHAFT WIDTH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x0eARSI YEH WITH '
'\x03ART'
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x05ASAL '
'\x04ASAT'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASE'
'\x03ASH'
'\x16ASH AMPERSAND ORNAMENT'
'\x04ASH2'
'\x06ASHGAB'
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATAKANA '
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x07AUGHTS '
'\x03AUJ'
'\x04AULA'
'\x07AULDRON'
'\x03AUM'
'\x07AUNTLET'
'\x03AUS'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\x05AWAY '
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x03AYD'
'\nAYER BEADS'
'\x06AYEROK'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x03BAL'
'\x05BALAG'
'\x04BALL'
'\rBALLPOINT PEN'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rBASAN LETTER '
'\tBASE UNIT'
'\x04BASH'
'\x08BATAEAN '
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x03BEL'
'\x05BELOW'
'\x05BENDE'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x08BEVERAGE'
'\x06BGBIEE'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x03BIN'
'\x07BINING '
'\x0cBINING MARK '
'\x0bBIRGA WITH '
'\x05BISAH'
'\x06BISCUS'
'\tBITE LIPS'
'\x0fBJOINED LETTER '
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\nBLACK FLAG'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x15BOTTOM U-SHAPED ARROW'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x19BREVE WITH INVERTED BREVE'
'\x0cBREVE-MACRON'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x04BSET'
'\x03BSP'
'\nBSTRUCTION'
'\x02BU'
'\x03BU '
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C CLEF'
'\x06C SIGN'
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x04CANO'
'\x07CAP TEN'
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\tCAPITAL I'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x05CECAK'
'\x05CECEK'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x06CER-WA'
'\x05CEREK'
'\x0eCERTAINTY SIGN'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x06CHAMKO'
'\x14CHARACTER INTRODUCER'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x05CHIME'
'\x0bCHING CHICK'
'\x06CHIRET'
'\x03CHO'
'\x05CHOOI'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x03CHU'
'\x06CHURCH'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x04CIM '
'\x05CING '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\rCIRCLE INSIDE'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\rCITATION MARK'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x05CKING'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x1bCOMBINING CANDRABINDU ABOVE'
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x16CONSONANT SIGN MEDIAL '
'\x11CONSONANT SIGN PA'
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x07CROSSED'
'\x0cCROSSED-TAIL'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GABA'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x04CURL'
'\x08CURLICUE'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x04D HA'
'\x0bD MIDDLE UP'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x0eD-UP NEWSPAPER'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\x07DA FACE'
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DA2'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\tDATE MARK'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDDA'
'\x04DDHI'
'\x05DDING'
'\x02DE'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x07DHALATH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\tDIAERESIS'
'\rDIAERESIZED U'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\rDIC MARK SIGN'
'\x0cDICTION SIGN'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x08DIM GUNU'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x04DIUM'
'\x05DIUM '
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x1fDMINTON RACQUET AND SHUTTLECOCK'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x0fDOT PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x10DOTTED CRESCENTS'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\nDOUBLE BAR'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\rDOUBLE MUCAAD'
'\x0fDOUBLE ORNAMENT'
'\x0bDOUBLE RING'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x04DOWN'
'\x05DOWN '
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x02DR'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x03DUG'
'\x0cDUG TIMES NI'
'\tDUN3 GUNU'
'\x0eDUN3 GUNU GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\tE AT LEFT'
'\x14E CONSONANT MODIFIER'
'\x05E GEE'
'\x07E GLASS'
'\x06E HOOK'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\x10E PLUS GAN2 TENU'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E0'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x04EANS'
'\nEARLY FORM'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EATH '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'\x08ED BRICK'
'\x07ED FACE'
'\x06ED ICE'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tEDESTRIAN'
'\nEDESTRIANS'
'\x06EDIAL '
'\x05EDIC '
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x04EEM '
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x15EFT HORIZONTAL SECANT'
'\x15EFT-POINTING TRIANGLE'
'\x14EFTWARDS ARROW WITH '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\x17EH WITH SMALL TEH ABOVE'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x16EIGHTY ON BLACK SQUARE'
'\x03EIN'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x03ELT'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0bEN STRAIGHT'
'\x0bEN TWELFTHS'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\nENCH FRIES'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\nENGER SHIP'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x03EOW'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\tER BUBBLE'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x05ERN W'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x06ERTED '
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x08ESCENDER'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x06ESTAN '
'\x02ET'
'\x03ET '
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\nEUTRAL YER'
'\x03EUX'
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\rEVEN TWELFTHS'
'\x06EVENTY'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x06EXHALE'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EYK'
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\rF WITH STROKE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x06FAMILY'
'\x04FAST'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIER '
'\x05FIFTY'
'\x06FIFTY '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\tFINAL NGA'
'\tFINAL NUN'
'\x08FINAL TH'
'\x07FINAL Y'
'\x08FINGER C'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x0cFIVE HUNDRED'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x15FLATTENED PARENTHESIS'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLICT'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\nFLUTTERING'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x08FOR STOP'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\nFOUR BELOW'
'\tFOUR BENT'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x08FROM BAR'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT RERENGGAN'
'\x13FT-POINTING FLEURON'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x18GAF WITH INVERTED STROKE'
'\x03GAG'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x03GAR'
'\x08GARITIC '
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x05GAZE-'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x07GEMINAT'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x05GGER '
'\nGGING FACE'
'\x06GGLING'
'\x12GGLY VERTICAL LINE'
'\nGGRAVATION'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\x04GIDA'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GIR2'
'\x04GISH'
'\x12GISH CROSSING GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x08GOLITIC '
'\x0bGONEK ABOVE'
'\x04GONG'
'\x03GOU'
'\x07GRADUAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0bGREEK CROSS'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x0eGUNU TIMES ASH'
'\x03GUR'
'\x05GVANG'
'#GVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x02GW'
'\x02GY'
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x03HAB'
'\x05HADDA'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x05HALA '
'\x04HALF'
'\x05HALF '
'\x11HALF BLACK CIRCLE'
'\x08HALF GUR'
'\tHALF NOTE'
'\x0fHALF RING ABOVE'
'\tHALF SIGN'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x0cHAND FORMAT '
'\tHAND SIGN'
'\x17HAND TELEPHONE RECEIVER'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\tHARD SIGN'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x04HAYN'
'\x02HD'
'\x02HE'
'\x03HE '
'\x03HEA'
'\x04HEAD'
'\x05HEAD '
'\tHEAD MARK'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x08HEAVY YA'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x12HEN WITH DIAERESIS'
'\x04HENG'
'\x03HER'
'\rHER CHRISTMAS'
'\x06HERMES'
'\nHERMOMETER'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x07HEXAGON'
'\x16HEXIFORM LONG ANUSVARA'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\rHI TIMES ASH2'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x04HIGH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x03HII'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x05HIMEL'
'\x03HIN'
'\rHINESE TONE Y'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x05HIRTY'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x08HITTING '
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOM'
'\x04HOM '
'\x03HOO'
'\x04HOOK'
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x06HORT A'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\rHOUGHT BUBBLE'
'\x08HOULDER '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\x06HREE D'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
' HREE DOTS POINTING UPWARDS BELOW'
'\x0cHREE FINGERS'
'\tHREE FOR '
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x04HSHU'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x02HU'
'\x04HUB2'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x03HUR'
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\x02HW'
'\x03HWA'
'\tHWA WITH '
'\x04HWAH'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x06I GUNU'
'\x06I HOOK'
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES BAD'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x05I-RES'
'\x02I0'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x06IAMOND'
'\x07IAMOND '
'\x0eIAMOND CENTRED'
'\x04IAN '
'\x0bIAN LETTER '
'\x0eIAN RUPEE SIGN'
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IAUDA'
'\x06IB YAM'
'\x02IC'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x12ICKET BAT AND BALL'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x06IDE ES'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\x06IFIED '
'\x07IFIED E'
'\x04IFTH'
'\x04IFTY'
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\nIGATING RA'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\rIGHT TWELFTHS'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\tIGHTH ASH'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\tIN SQUARE'
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x08ING FACE'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\tING LANES'
'\nING LITTLE'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x06INHALE'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x06INKING'
'\x07INNABAR'
'\tINNYIIYHE'
'\nINOCULAR O'
'\x0eINOLOGICAL DOT'
'\x03INS'
'\x0eINSERTION SIGN'
'\x06INSHIP'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INY '
'\x04INYA'
'\x03ION'
'\x08ION MARK'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x05IRACY'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x06IRCLES'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x05IRCUT'
'\x04IRED'
'\x03IRL'
'\x04IRON'
'\x08IRPLANE '
'\x0cIRST SUBUNIT'
'\x04IRTY'
'\x02IS'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\rISH LIRA SIGN'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x11ITALIC LETTER ESS'
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x0eITERATION MARK'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\x05ITLO '
'\tITRA SIGN'
'\x04ITSA'
'\x07ITTING '
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\rIVE SLOW SIGN'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\nIXTHS DISH'
'\x04IXTY'
'\x14IXTY ON BLACK SQUARE'
'\x06IXTY P'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x03JOA'
'\x06JOINED'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\nJONG TILE '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x07K WITH '
'\x02K-'
'\x05K-020'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x03KAM'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x03KAU'
'\x06KAVYKA'
'\x06KAYAH '
'\x05KBALL'
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x05KESH2'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x07KHA YAT'
'\x04KHAH'
'\x07KHAMTI '
'\x14KHAMTI REDUPLICATION'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x07KIEVAN '
'\x06KILLER'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING FACE'
'\x04KINI'
'\rKISIM5 TIMES '
'\x0fKISIM5 TIMES BI'
'\x04KISS'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x0bKTIESELSKAB'
'\x05KTOP '
'\x02KU'
'\x03KU3'
'\x03KUE'
'\x03KUG'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x06KY WAY'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x03LAA'
'\x04LAAM'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x0bLACK CIRCLE'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x0bLACKLETTER '
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x03LAI'
'\x07LAK-050'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\nLANE MERGE'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\tLARGEMENT'
'\x03LAS'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x08LATION X'
'\x15LATTENED OPEN A ABOVE'
'\x03LAU'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x0bLCE TSA CAN'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDE '
'\x04LDER'
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
'\nLEFT-HAND '
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x17LEFT-SHADED WHITE ARROW'
'\x12LEFT-STEM TONE BAR'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\x03LEI'
'\nLEK ATTAK '
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x05LENIS'
'\x04LEPH'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x0bLETION MARK'
'\x06LETTER'
'\x07LETTER '
'\tLETTER KH'
'\x0bLETTER LLLA'
'\x1aLETTER MANCHU ALI GALI LHA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x02LF'
'\x03LF '
'\x07LF FACE'
'\x03LFA'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\nLIMITATION'
'\x04LINE'
'\x05LINE '
'\x0eLINE EXTENSION'
'\x0bLINE FILLER'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x04LIPS'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x08LL MOON '
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x07LLEYBUS'
'\x06LLHORN'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x10LLOW PAN OF FOOD'
'\x07LLOWING'
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOAN '
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x04LONG'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG FINAL'
'\nLONG OVER '
'\tLONG TIP '
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x13LOW NOON WITH KASRA'
'\x16LOW PARAPHRASE BRACKET'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x08LOW TONE'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x0bLTERNATE YA'
'\nLTIC CROSS'
'\x06LTILLO'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x0cLU PLUS ESH2'
'\x0bLU PLUS IGI'
'\x03LU3'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x02LY'
'\x04LY H'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x08M SYMBOL'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x06MALL F'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAQ'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\nMARK ABOVE'
'\tMARK CIM '
'\x0eMARK LOWER DOT'
'\tMARK SHAD'
'\rMARKS CHAPTER'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x03MAY'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x0bMBLER GLASS'
'\x05MBOL '
'\x07MBOL B0'
'\tMBOL FOR '
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS EN'
'\x08MEASURE '
'\x04MED '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MENOE'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x0bMIC LETTER '
'\x03MID'
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE HOOK'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIM'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\nMILLE SIGN'
'\x08MILLIONS'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\rMINDER RIBBON'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\nMISMA SIGN'
'\x05MISRA'
'\x0fMISSION TICKETS'
'\x03MIT'
'\x04MIZE'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'\x10MODIFIER LETTER '
'"MODIFIER LETTER LABIALIZATION MARK'
'\rMODIFIER MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\x0bMONOCULAR O'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x03MPL'
'\x05MROCK'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x02MU'
'\x04MUAS'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x08MULTIPLE'
'\x15MULTIPLE MEASURE REST'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x12N VIEWING CEREMONY'
'\x07N WITH '
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x03NAH'
'\x04NAKE'
'\nNAKE BELOW'
'\x04NAM2'
'\x04NANT'
'\x03NAP'
'\x03NAR'
'\x0cNARROW SHAFT'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x03NAU'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\x05NCORA'
'\x02ND'
'\x03ND '
'\x0bND OF PIECE'
'\x0bND TWO DOTS'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x03NE '
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x06NE OF '
'\x04NED '
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x0bNEUTRAL YER'
'\x03NEY'
'\x07NFINITY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x03NG '
'\x08NG ABOVE'
'\x0bNG LEFT LEG'
'\x11NG STROKE OVERLAY'
'\x14NG WITH CROSSED-TAIL'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x0bNGER BUBBLE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\x08NI ABOVE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x0bNIKOLSBURG '
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\tNING SIGN'
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x06NNADA '
'\x03NNI'
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\nNOON ABOVE'
'\x0bNOON GHUNNA'
'\nNOON WITH '
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x04NOSE'
'\x05NOTCH'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x04NOWC'
'\x08NOWLEDGE'
'\x06NOWMAN'
'\x08NRES TOS'
'\x04NRUA'
'\tNS-SERIF '
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x05NTAIN'
'\x18NTED NORTH ARROW WITH HO'
'\tNTESSENCE'
'\x05NTHA '
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x05NTXIV'
'\x02NU'
'\x03NUB'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUTS'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x03NYA'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x05OCADO'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\tOCCLUSION'
'\x06OCENCE'
'\x08OCK SALT'
'\x05OCKET'
'\x0bOCOLATE BAR'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\tOENICIAN '
'\x03OF '
'\x0bOF ENVELOPE'
'\x0bOF MASHFAAT'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\rOHIBITED SIGN'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x1eOJI MODIFIER FITZPATRICK TYPE-'
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\x05OKARA'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x07OLAPUK '
'\x03OLD'
'\x04OLD '
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x10OLD WHITE CIRCLE'
'\x05OLDER'
'\x0bOLDING BACK'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x03OM '
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\x08OMANIAN '
'\tOMBINING '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x0eOMING ENVELOPE'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x07ON FACE'
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\rONAL COMPUTER'
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\x14ONE MARK SGAW KAREN '
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\tONG GRAVE'
'\x05ONG S'
'\x0bONG S WITH '
'\rONG-LEGGED DE'
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x10ONJOINING MACRON'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x03OPH'
'\x05OPLET'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x04ORD '
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x08OTPRINTS'
'\x0cOTTOM HALF O'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\tOURA SIGN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\nOUT HANDLE'
'\x07OUT HUB'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\tOUTH WIND'
'\nOUTHERN TA'
'\x04OVAL'
'\x15OVAL WITH OVAL INSIDE'
'\x05OVER '
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\tOVER LONG'
'\tOVER MUSH'
'\x16OVER NU11 BUR OVER BUR'
'\x08OVER NUN'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SAG'
'\x08OVER SHE'
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x03OWN'
'\rOWN POINTING '
'\x15OWN-POINTING TRIANGLE'
'\x03OX '
'\x07OX BACK'
'\x02OY'
'\x07OYSTICK'
'\x03OZE'
'\x06OZENGE'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\tP ELAMITE'
'\x11P ON BLACK SQUARE'
'\x07P PIEET'
'\nP STREAMER'
'\x0cP TACK ABOVE'
'\x07P WITH '
'\x17P WITH EXCLAMATION MARK'
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x04PALM'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x0cPE CARTRIDGE'
'\x11PE WITH DESCENDER'
'\x06PEAKS '
'\x0cPEECH BUBBLE'
'\x04PEEI'
'\x04PEEP'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x03PEN'
'\x04PEN '
'\x05PEN E'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x06PEPPER'
'\x03PER'
'\x04PER '
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x18PERSET PRECEDING SOLIDUS'
'\x08PERSIAN '
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x04PHAB'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\x06PICKET'
'\x07PICTURE'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x07PLOYAN '
'\x04PLUG'
'\x04PLUM'
'\x05PLUS '
'\nPLUS ERIN2'
'\x14PLUS GISH TIMES TAK4'
'\x08PLUS LAL'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x18POINTING DOWNWARDS ABOVE'
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\tPPOINTED '
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x08PRESSION'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x05PTIC '
'\x05PTIVE'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x06PWATCH'
'\x01Q'
'\x07Q WITH '
'\x10Q WITH HOOK TAIL'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\tQUADCOLON'
'\x0fQUADRUPLE ARROW'
'\x13QUADRUPLE CRESCENTS'
' QUALS SIGN ABOVE LEFTWARDS ARROW'
'\x06QUARE '
'\x06QUARED'
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x0cQUARTER SIGN'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\tR COASTER'
'\x06R FACE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x03R S'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x02R0'
'\x02R2'
'\x07R2 GUNU'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
' RAISED HAND WITH FINGERS SPLAYED'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x04RAN '
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x14RANSPOSITION BRACKET'
'\x07RARIETY'
'\x05RASHA'
'\x03RAT'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x08RAUGHTS '
'\x06RAVEL-'
'\x03RAY'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\nRDHACANDRA'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x08RECEIVER'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\nRED CIRCLE'
'\nRED DRAGON'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\x05REEK '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x05RELAA'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x03REN'
'\x06RENGTH'
'\x04REPA'
'\x10REPETITION MARK-'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x08REVERSE '
'\x0fREVERSE SOLIDUS'
'\tREVERSED '
'\x0fREVERSED OPEN E'
'\x0eREVERSED-SCHWA'
'\x04RFER'
'\x02RG'
'\nRGE CIRCLE'
'\nRGE SQUARE'
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x0cRIAGE SYMBOL'
'\x0cRIAL TRAMWAY'
'\x07RIANGLE'
'\x12RIANGLE ARROWHEADS'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x17RIGHT HORIZONTAL SECANT'
'\x14RIGHT POINTING INDEX'
'\x0fRIGHT RERENGGAN'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'\x0bRIGHT-HAND '
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x14RIGHT-POINTING ANGLE'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x06RIKRIK'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\nRING BELOW'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\nRING THUMB'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RINKLES'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x07RIPPLE '
'\x05RIPT '
'\x06RIPT G'
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x03RK '
'\rRK SUNGLASSES'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x0cRMUKHI SIGN '
'\x05RNED '
'\x02RO'
'\x03RO '
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\x06ROCKET'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROITIC '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x0cROLLING EYES'
'\x03ROM'
'\x03RON'
'\x1bRONOMICAL SYMBOL FOR URANUS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROSH'
'\x04ROSS'
'\x0eROSS ON SHIELD'
'\x08ROSSED O'
'\x0bROSSED-TAIL'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\rRPENTRY PLANE'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\nRROW WITH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x04RSO-'
'\x02RT'
'\x06RT OF '
'\rRTABLE STEREO'
'\tRTER MARK'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x05RUMP-'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x07S BELOW'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\x07S-SAJDA'
'\x02S0'
'\x02SA'
'\x07SA VAH '
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAD'
'\x03SAG'
'\x03SAH'
'\x05SAKTA'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x03SAM'
'\x10SAMARITAN SOURCE'
'\x06SANDAL'
'\x07SANDHI '
'\x04SANG'
'\x07SANGAN '
'\x10SANS-SERIF ARROW'
'\x03SAR'
'\x05SARGA'
'\x05SASAK'
'\x03SAU'
'\x03SAW'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x07SCOOTER'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x08SCRIPT X'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEMICOLON'
'\x1cSENTATION FORM FOR VERTICAL '
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\tSHAB CEEB'
'\x04SHAD'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x12SHAN REDUPLICATION'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x07SHESHIG'
'\x0eSHESHIG TIMES '
'\x05SHGAB'
'\x03SHI'
'\x07SHIFT T'
'\x05SHIMA'
'\x04SHIN'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x0bSHOGI PIECE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x08SHORT ER'
'\x0fSHORT OVER LONG'
'\x0fSHORT RIGHT LEG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x05SHTIN'
'\x04SHU2'
'\x10SHU2 PLUS KASKAL'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\nSIDEWAYS I'
'\x14SIDEWAYS NOON GHUNNA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x11SIGN O WITH CROSS'
'\x07SIGN UD'
'\x03SII'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x13SLANTED NORTH ARROW'
'\x05SLASH'
'\x05SMALL'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\x02SO'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x06SOUTH '
'\x0eSOUTH ARABIAN '
'\x07SOV ROG'
'\x02SP'
'\x13SPACING CANDRABINDU'
'\x06SPADES'
'\x06SPAPER'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x05SPINE'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x04SQUE'
'\x08SQUEEZED'
'\x0cSQUIQUADRATE'
'\x02SS'
'\nSS OF MILK'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x07STATERS'
'\tSTEBASKET'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x04STLE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x18STROKE THROUGH DESCENDER'
'\x0eSTRONG ISOLATE'
'\nSTRUCTION '
'\x1bSTRUMENTAL NOTATION SYMBOL-'
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUCK'
'\x06SUCKED'
'\x04SUKU'
'\x06SULAR '
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x0fSUSPENSION MARK'
'\x03SUU'
'\x07SVARITA'
'\x0bSVASTI SIGN'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x0bT SEPARATOR'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x05TAGON'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x0fTAI LAING TONE-'
'\x08TAI LUE '
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x06TARGET'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAW'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x05TEGEH'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENSE'
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x0bTH-THALATHA'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x07THIEUTH'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0fTHREE DISH TENU'
'\x10THREE DOTS ABOVE'
'\x0eTHREE POINTED '
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x03THW'
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x06TICAL '
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES KUR'
'\tTIMES NA2'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\tTIN CROSS'
'\x05TING '
'\nTING HEART'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x07TLESS J'
'\x05TMAAU'
'\x05TNESS'
'\x02TO'
'\x06TO BAR'
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x0bTONAL MARK '
'\x04TONE'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x05TONE-'
'\x06TONGUE'
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x05TRACK'
'\x0cTRAGRAM FOR '
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x03TRE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x03TRI'
'\x0bTRIAN CAMEL'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'!TRONG CENTRALIZATION STROKE BELOW'
'\x03TSA'
'\x03TSE'
'\x05TSEEB'
'\x02TT'
'\x03TTE'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x07TTERFLY'
'\x05TTERN'
'\x05TTOCK'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x03TUJ'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\x05TURN '
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x13TURNED SECTION MARK'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x05U U U'
'\x07U WITH '
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x02U0'
'\x02U2'
'\nU2 PLUS BA'
'\x02U3'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB '
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x10UBLE PARENTHESIS'
'\x06UBLE R'
'\x0fUBLE RING BELOW'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x05UDAAT'
'\x06UDATTA'
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\x03UG2'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x04UHUR'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x05ULAR '
'\x07ULATION'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x12UM WITH DRUMSTICKS'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x05UMPET'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\x0cUNBLENDED UK'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x04UND '
'\x05UNDER'
'\x06UNDER '
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\x06UR OF '
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URL'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\x06USHPIN'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0bUTH CORNERS'
'\nUTH OR SPY'
'\x05UTIES'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x07VAPOURS'
'\x07VARIANT'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\x08VE SASAK'
'\tVE THUMB '
'\x03VE-'
'\x04VEDE'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\tVELOPMENT'
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\x06VERLAP'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x17VERTICAL BAR WITH QUILL'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x08VESSEL B'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x03VIN'
'\x04VINE'
'\tVINE LEAF'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC L'
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x0eVONIC ASTERISK'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x04VOS '
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x03WAN'
'\x05WAQFA'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x0cWHITE SQUARE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\nWHOLE NOTE'
'\x02WI'
'\x05WIANG'
'\x04WIDE'
'\x05WIDTH'
'\x07WIFRUIT'
'\x11WIGGLY LINE BELOW'
'\x07WIGNYAN'
'\x06WINDOW'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x0eWITH LEFT HOOK'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\x0cWITH STROKE '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x07WN FACE'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\nWO FINGERS'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\nWO-HEADED '
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\x06WRENCH'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x16XCLAMATION MARK SYMBOL'
'\x02XE'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x04XEYN'
'\x02XG'
'\tXHAUSTION'
'\nXHEEJ CEEV'
'\x02XI'
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x15XTRA SHORT VOWEL MARK'
'\x05XTRA-'
'\x03XWG'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x08Y SMALL '
'\x0eY SMALL SQUARE'
'\nY THOUSAND'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x03YAN'
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\x06YIN-DO'
'\nYING CARD '
'\rYING ENVELOPE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YIZET'
'\x08YLLABLE '
'\x05YMBOL'
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x04YODH'
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x02YP'
'\x12YPTIAN HIEROGLYPH '
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x03ZHE'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\tZIR SASAK'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOA'
'\x03ZOO'
'\nZU OVER ZU'
'\x08ZWARAKAY'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68880,
 -54398,
 -1,
 132653,
 50378,
 -1,
 198179,
 99549,
 -1,
 263553,
 176783,
 -1,
 327930,
 224967,
 -1,
 393401,
 268527,
 74167,
 458852,
 355177,
 -1,
 524324,
 398812,
 -1,
 589846,
 463293,
 75009,
 720895,
 526839,
 -1,
 720910,
 640202,
 -1,
 -65524,
 699648,
 75019,
 -65523,
 734685,
 75018,
 -1,
 790992,
 75017,
 983057,
 703003,
 -1,
 -65520,
 933436,
 75016,
 -1,
 991518,
 75015,
 -65518,
 945925,
 75014,
 -65517,
 1142383,
 75013,
 -65516,
 1195497,
 75012,
 -65515,
 1254938,
 75011,
 -1,
 1319752,
 75010,
 1507362,
 529624,
 75021,
 1638399,
 1444343,
 -1,
 1638427,
 1557706,
 -1,
 -65510,
 1617152,
 75030,
 -1,
 1652189,
 75029,
 1835037,
 1597513,
 75024,
 -1,
 1770296,
 75025,
 -65506,
 1814841,
 75028,
 -65505,
 1939647,
 75027,
 -65504,
 2000367,
 75026,
 -65503,
 2051975,
 75023,
 -1,
 2112963,
 75022,
 -65501,
 1446922,
 75020,
 -1,
 2232475,
 75008,
 2424889,
 463891,
 -1,
 2490415,
 2364435,
 -1,
 2555950,
 2431037,
 74993,
 2686975,
 2492919,
 -1,
 2687019,
 2594971,
 -1,
 -65494,
 2660517,
 74997,
 -1,
 2718323,
 74996,
 -65492,
 2671957,
 74998,
 -65491,
 2842697,
 74995,
 -1,
 2904988,
 74994,
 -1,
 2494629,
 74992,
 3145780,
 2431037,
 -1,
 -65487,
 3085543,
 75006,
 -65486,
 3150581,
 75005,
 -65485,
 3215824,
 75004,
 -1,
 3280792,
 75003,
 3473463,
 3085543,
 -1,
 -65482,
 3413676,
 75000,
 -1,
 3477400,
 74999,
 -65480,
 3414067,
 75002,
 -1,
 3610471,
 75001,
 3801160,
 2363288,
 -1,
 3866685,
 3741580,
 -1,
 -65476,
 3805491,
 74974,
 -1,
 3870616,
 74973,
 4063296,
 3806439,
 -1,
 -65473,
 4001957,
 74970,
 -1,
 4067224,
 74969,
 4259907,
 4002256,
 -1,
 -65470,
 4199655,
 74967,
 -1,
 4264101,
 74966,
 -65468,
 4200670,
 74975,
 -65467,
 4396919,
 74972,
 -65466,
 4462238,
 74971,
 -65465,
 4527088,
 74968,
 -1,
 4591761,
 74965,
 4784212,
 3740112,
 -1,
 4849741,
 4723152,
 -1,
 -65461,
 4790156,
 74982,
 -65460,
 4855015,
 74981,
 -1,
 4919192,
 74980,
 5111888,
 4789724,
 -1,
 -65457,
 5051868,
 74985,
 -1,
 5117159,
 74984,
 5308499,
 5050533,
 -1,
 -65454,
 5249085,
 74979,
 -1,
 5312408,
 74978,
 -1,
 5248013,
 74983,
 5570653,
 4723445,
 -1,
 5636185,
 5510163,
 -1,
 -65449,
 5576588,
 74988,
 -65448,
 5641900,
 74987,
 -1,
 5706485,
 74986,
 5898332,
 5576588,
 -1,
 -65445,
 5837843,
 74990,
 -1,
 5903093,
 74989,
 -1,
 5839064,
 74991,
 6160480,
 5510828,
 -1,
 -65441,
 6100187,
 75032,
 -1,
 6165202,
 75031,
 6357091,
 6099109,
 -1,
 -65438,
 6296789,
 74977,
 -1,
 6362096,
 74976,
 -1,
 6297028,
 75007,
 6619315,
 413575,
 -1,
 6684845,
 6563250,
 74168,
 6815743,
 6619136,
 -1,
 6815916,
 6733625,
 -1,
 6881392,
 6756591,
 74169,
 6946925,
 6817483,
 -1,
 -65429,
 6909914,
 74172,
 -65428,
 6967369,
 74171,
 -1,
 7026298,
 74170,
 -65426,
 6926426,
 74175,
 -65425,
 7176948,
 74174,
 -1,
 7237319,
 74173,
 7405687,
 6866122,
 74213,
 7471220,
 7341771,
 -1,
 -65421,
 7455969,
 74215,
 -1,
 7477487,
 74214,
 -65419,
 7450678,
 74218,
 -65418,
 7615965,
 74217,
 -1,
 7672431,
 74216,
 7864448,
 7384460,
 -1,
 7929983,
 7820322,
 -1,
 7995515,
 7914834,
 74207,
 -1,
 7931870,
 74208,
 8126590,
 7956513,
 -1,
 -65411,
 8109162,
 74206,
 -1,
 8166385,
 74205,
 -1,
 8077023,
 74204,
 -1,
 7915469,
 74209,
 8454279,
 7826229,
 -1,
 8519813,
 8438986,
 -1,
 8585348,
 8482503,
 74194,
 -1,
 8521500,
 74195,
 -1,
 8524533,
 74193,
 8847359,
 8477905,
 74191,
 -1,
 8749812,
 74192,
 8913037,
 8408888,
 -1,
 8978570,
 8898242,
 74182,
 -1,
 8914706,
 74183,
 9109644,
 8919279,
 74180,
 -1,
 9085185,
 74181,
 -1,
 9067729,
 74632,
 9306258,
 8875719,
 -1,
 9371792,
 9290954,
 74198,
 -1,
 9334471,
 74199,
 -65391,
 9332583,
 74197,
 -1,
 9444408,
 74196,
 9633944,
 9264337,
 -1,
 9699479,
 9599679,
 74188,
 9830399,
 9635531,
 -1,
 -65386,
 9730647,
 74190,
 -1,
 9786424,
 74189,
 -1,
 9654806,
 74187,
 10027165,
 9615899,
 -1,
 10092700,
 9967855,
 -1,
 -65381,
 10054532,
 74211,
 -1,
 10112824,
 74210,
 -1,
 10043051,
 74212,
 10354849,
 9992895,
 -1,
 10420384,
 10305084,
 74200,
 -1,
 10356479,
 74201,
 -1,
 10406861,
 74202,
 10616997,
 10310690,
 -1,
 10682532,
 10557679,
 74184,
 -1,
 10645191,
 74185,
 -1,
 10640681,
 74186,
 10879144,
 10560946,
 -1,
 -65369,
 10837201,
 74177,
 -1,
 10885904,
 74176,
 -65367,
 10869906,
 74964,
 -65366,
 11043929,
 74203,
 -65365,
 11092836,
 74179,
 -1,
 11155193,
 74178,
 -1,
 6796853,
 74219,
 11468799,
 6660353,
 74220,
 11534335,
 11337728,
 -1,
 11534513,
 11452264,
 74221,
 -1,
 11470825,
 74222,
 11730943,
 11490251,
 74223,
 -1,
 11601395,
 74224,
 11796662,
 6585023,
 74228,
 11927551,
 11733619,
 74229,
 -1,
 11798447,
 74230,
 11993272,
 11759303,
 74226,
 -1,
 11930238,
 74227,
 -1,
 11951119,
 74225,
 12189942,
 378058,
 74235,
 12255465,
 12128720,
 74237,
 12386303,
 12189696,
 -1,
 12386530,
 12302875,
 -1,
 12452065,
 12345672,
 -1,
 12517572,
 12413749,
 -1,
 12583107,
 12458768,
 -1,
 12648642,
 12522229,
 74246,
 -1,
 12584666,
 74247,
 -1,
 12587472,
 74245,
 -1,
 12541137,
 74248,
 12910793,
 12496268,
 -1,
 12976328,
 12868817,
 -1,
 -65337,
 12938105,
 74255,
 -1,
 12977882,
 74254,
 -1,
 12934198,
 74635,
 13238477,
 12863157,
 74240,
 13369343,
 13172736,
 -1,
 -65332,
 13286506,
 74241,
 -1,
 13343761,
 74634,
 13500624,
 13220379,
 -1,
 -65329,
 13485863,
 74256,
 -1,
 13507972,
 75038,
 13697234,
 13473943,
 75036,
 -1,
 13633427,
 75037,
 13828309,
 13665012,
 -1,
 -65324,
 13812938,
 74253,
 -1,
 13844028,
 74252,
 14024920,
 13790981,
 -1,
 -65321,
 13979551,
 74250,
 -1,
 14026458,
 74249,
 14221531,
 13980706,
 -1,
 -65318,
 14179613,
 74243,
 -1,
 14228902,
 75035,
 -65316,
 14187956,
 74251,
 -65315,
 14377240,
 74244,
 -65314,
 14438422,
 74242,
 -65313,
 14498123,
 75034,
 -65312,
 14558746,
 74239,
 -1,
 14622118,
 74238,
 -1,
 12403948,
 74257,
 14876902,
 12365196,
 -1,
 14942437,
 14833540,
 74261,
 -1,
 14879231,
 74633,
 -1,
 14917662,
 74260,
 -65305,
 14848200,
 74259,
 -65304,
 15094736,
 75033,
 -1,
 15152270,
 74258,
 15335663,
 12210161,
 74263,
 15466495,
 15269888,
 -1,
 15466734,
 15370666,
 -1,
 -65299,
 15453686,
 74264,
 -1,
 15506864,
 74265,
 -1,
 15446343,
 74266,
 15728882,
 15301311,
 74269,
 15859711,
 15664648,
 74270,
 -1,
 15729444,
 74271,
 -65293,
 15691463,
 74268,
 -65292,
 15881250,
 74267,
 -65291,
 15930101,
 74262,
 -1,
 15993343,
 74236,
 16252927,
 12147921,
 74231,
 -65288,
 16166966,
 74234,
 -65287,
 16220385,
 74233,
 -1,
 16281287,
 74232,
 16449977,
 282424,
 -1,
 16515448,
 16390383,
 73909,
 16580964,
 16454096,
 73911,
 16711679,
 16515072,
 -1,
 16712035,
 16629561,
 -1,
 16777482,
 16666424,
 -1,
 16843014,
 16718063,
 74939,
 16908549,
 16818433,
 73932,
 17039359,
 16844491,
 -1,
 -65276,
 16942169,
 74941,
 -1,
 16988220,
 74940,
 -1,
 16876361,
 73931,
 17301503,
 16800977,
 73933,
 17301769,
 17175571,
 73934,
 -1,
 17237714,
 73935,
 -1,
 17277293,
 73936,
 17498389,
 16718063,
 -1,
 17563918,
 17477686,
 73917,
 17694719,
 17502672,
 74618,
 -1,
 17565448,
 73918,
 17760530,
 17499851,
 -1,
 -65264,
 17719369,
 73914,
 -65263,
 17781816,
 73913,
 -1,
 17839738,
 73912,
 18022676,
 17728244,
 73916,
 -1,
 17958700,
 74617,
 -1,
 17966539,
 73915,
 18219296,
 17477004,
 -1,
 18284828,
 18175010,
 -1,
 18350362,
 18242769,
 -1,
 -65255,
 18315967,
 74951,
 -1,
 18363869,
 73959,
 18612223,
 18300476,
 73957,
 -1,
 18483187,
 73958,
 18678047,
 18225391,
 -1,
 -65250,
 18653441,
 73956,
 -1,
 18706119,
 73955,
 -1,
 18663373,
 73960,
 18940203,
 18167261,
 -1,
 19005734,
 18924746,
 -1,
 19071269,
 18960203,
 -1,
 -65244,
 19033124,
 74937,
 -1,
 19095629,
 74936,
 -1,
 19015090,
 73926,
 19333418,
 18963665,
 73924,
 19464191,
 19299009,
 -1,
 -65239,
 19382120,
 73925,
 -1,
 19420107,
 74935,
 -1,
 19273967,
 73923,
 19661108,
 18901813,
 -1,
 19726639,
 19645642,
 -1,
 -65234,
 19706372,
 74943,
 -1,
 19731363,
 73948,
 19923249,
 19685008,
 73946,
 -1,
 19859293,
 73947,
 20119551,
 19863791,
 -1,
 -65229,
 20034469,
 73945,
 -1,
 20081461,
 73944,
 20250941,
 19616802,
 -1,
 20316475,
 20191471,
 -1,
 20382008,
 20278983,
 73938,
 -1,
 20318036,
 73939,
 20578303,
 20317899,
 -1,
 -65222,
 20478554,
 73937,
 -1,
 20519151,
 74942,
 -65220,
 20301240,
 73941,
 -1,
 20667634,
 73940,
 20840772,
 20218612,
 -1,
 20906306,
 20790844,
 74948,
 21037055,
 20842187,
 -1,
 -65215,
 20926995,
 74950,
 -1,
 20987712,
 74949,
 21233663,
 20891689,
 73952,
 -1,
 21104184,
 73953,
 21299530,
 20790844,
 -1,
 21365063,
 21267188,
 73929,
 -1,
 21301818,
 73930,
 21496137,
 21327559,
 73927,
 -1,
 21432148,
 73928,
 -1,
 21472639,
 74938,
 21692753,
 21243314,
 -1,
 21758287,
 21633263,
 -1,
 -65203,
 21733680,
 73920,
 -65202,
 21779981,
 74934,
 -1,
 21837277,
 73919,
 22085631,
 21744325,
 73921,
 -1,
 21956518,
 73922,
 22151510,
 21655239,
 -1,
 22217045,
 22092015,
 73949,
 22347775,
 22182591,
 74944,
 -1,
 22219379,
 74945,
 -1,
 22202167,
 74946,
 22479193,
 22136010,
 73962,
 22609919,
 22427101,
 73963,
 -1,
 22480630,
 73964,
 22675805,
 22444735,
 -1,
 -65189,
 22662093,
 74947,
 -65188,
 22699217,
 73951,
 -1,
 22757060,
 73950,
 22937952,
 22633681,
 -1,
 -65185,
 22917181,
 73943,
 -1,
 22958614,
 73942,
 -65183,
 22928514,
 74952,
 -65182,
 23116563,
 73961,
 -1,
 23173084,
 73954,
 -1,
 16684343,
 73965,
 23396714,
 16548596,
 73974,
 23527423,
 23335376,
 73975,
 23592959,
 23396352,
 -1,
 -65176,
 23510122,
 73976,
 -65175,
 23565632,
 73977,
 -1,
 23606336,
 73978,
 23789933,
 23359175,
 73970,
 -65172,
 23731924,
 73972,
 -1,
 23790345,
 73971,
 23986545,
 23733735,
 73966,
 24117247,
 23920640,
 -1,
 -65168,
 24030203,
 74953,
 -1,
 24065074,
 73967,
 24248691,
 23961857,
 73979,
 -1,
 24187637,
 73980,
 24379765,
 24196573,
 73968,
 -1,
 24315240,
 73969,
 -65162,
 24359074,
 73981,
 -65161,
 24476351,
 73973,
 -1,
 24511288,
 73910,
 24707481,
 16473297,
 73984,
 24772995,
 24682753,
 -1,
 24838529,
 24711925,
 73994,
 24969215,
 24775159,
 -1,
 -65155,
 24877020,
 73999,
 -65154,
 24935015,
 73998,
 -65153,
 24993865,
 73997,
 -65152,
 25055254,
 73996,
 -1,
 25106737,
 73995,
 25362431,
 24777168,
 73992,
 -1,
 25232184,
 73993,
 25428366,
 24751500,
 -1,
 25493901,
 25383970,
 74001,
 25624575,
 25427968,
 -1,
 25624972,
 25541147,
 -1,
 25690507,
 25583944,
 -1,
 -65143,
 25672467,
 74004,
 -65142,
 25711218,
 74955,
 -1,
 25765402,
 74003,
 -1,
 25642220,
 74005,
 -1,
 25572455,
 74002,
 -1,
 25435558,
 74000,
 26149266,
 25367571,
 73988,
 26279935,
 26083328,
 -1,
 -65135,
 26187082,
 73989,
 -1,
 26227802,
 73990,
 26411415,
 26083328,
 -1,
 26476950,
 26394425,
 -1,
 -65131,
 26461386,
 73986,
 -1,
 26492476,
 73985,
 -1,
 26424398,
 73987,
 -65128,
 26365752,
 74620,
 -1,
 26687726,
 73991,
 26870195,
 24691914,
 74006,
 26935715,
 26808784,
 74008,
 27066367,
 26869760,
 -1,
 27066786,
 26984249,
 -1,
 27132319,
 27028442,
 74009,
 -1,
 27069013,
 74010,
 -65120,
 27110992,
 74012,
 -65119,
 27232540,
 74011,
 -1,
 27287629,
 74956,
 -1,
 27022283,
 74013,
 27525546,
 26883549,
 74014,
 27656191,
 27459584,
 -1,
 27656616,
 27574073,
 -1,
 -65113,
 27618959,
 74016,
 -1,
 27662652,
 74015,
 -65111,
 27630588,
 74957,
 -1,
 27825491,
 74017,
 27984303,
 27500801,
 74021,
 28049838,
 27968714,
 -1,
 -65107,
 28028982,
 74024,
 -1,
 28082932,
 74023,
 -1,
 27989676,
 74022,
 28311985,
 27949759,
 74019,
 -1,
 28248713,
 74020,
 -65102,
 28274375,
 74018,
 -1,
 28377671,
 74007,
 28639231,
 26820156,
 -1,
 28639672,
 28553721,
 73982,
 28770303,
 28576247,
 -1,
 -65097,
 28689610,
 74954,
 -1,
 28733071,
 73983,
 -1,
 28578511,
 74619,
 28967488,
 16411445,
 -1,
 29032998,
 28907759,
 74071,
 29098511,
 28969463,
 -1,
 29163979,
 29052728,
 -1,
 29229507,
 29121745,
 74087,
 29295042,
 29208630,
 74624,
 29425663,
 29229056,
 -1,
 -65087,
 29334565,
 74089,
 -1,
 29373543,
 74090,
 -1,
 29270370,
 74088,
 29622728,
 29169903,
 74082,
 29688262,
 29597953,
 74085,
 -1,
 29624258,
 74086,
 -65081,
 29655881,
 74084,
 -1,
 29781703,
 74083,
 30015487,
 29607114,
 74091,
 -65078,
 29925752,
 74092,
 -1,
 29963741,
 74625,
 30147030,
 29142412,
 -1,
 30212562,
 30102562,
 -1,
 30278095,
 30196938,
 74115,
 -1,
 30240455,
 74629,
 -65072,
 30236304,
 74114,
 -65071,
 30359100,
 74113,
 -1,
 30415087,
 74112,
 30605780,
 30152943,
 74110,
 -1,
 30580993,
 74111,
 -65067,
 30590791,
 74117,
 -1,
 30695257,
 74116,
 30867934,
 30131402,
 74119,
 30933465,
 30843137,
 74963,
 -1,
 30872016,
 74631,
 -65062,
 30912566,
 74123,
 -65061,
 31031925,
 74122,
 -65060,
 31077853,
 74121,
 -65059,
 31134160,
 74120,
 -1,
 31197924,
 74962,
 31392230,
 30833343,
 -1,
 31457764,
 31342140,
 74100,
 31588351,
 31393483,
 -1,
 -65054,
 31505318,
 74103,
 -65053,
 31543827,
 74102,
 -1,
 31604140,
 74101,
 31850495,
 31415505,
 74104,
 -1,
 31721351,
 74105,
 31916525,
 31332591,
 74072,
 31982058,
 31895606,
 -1,
 -65047,
 31920885,
 74623,
 -1,
 31986128,
 74075,
 32178668,
 31929821,
 74073,
 -1,
 32114506,
 74074,
 -1,
 32147465,
 74622,
 32375284,
 31860146,
 -1,
 32440818,
 32315631,
 -1,
 -65040,
 32416001,
 74078,
 -65039,
 32468853,
 74077,
 -1,
 32519645,
 74076,
 -65037,
 32425162,
 74960,
 -1,
 32660689,
 74079,
 32834041,
 32336693,
 -1,
 32899575,
 32791761,
 74096,
 -1,
 32847325,
 74097,
 33095679,
 32839919,
 74961,
 -1,
 32992053,
 74095,
 33161725,
 32796359,
 -1,
 33227260,
 33146058,
 74099,
 -1,
 33192639,
 74627,
 -1,
 33184977,
 74098,
 33423872,
 33143323,
 -1,
 -65025,
 33408202,
 74630,
 -1,
 33431838,
 74118,
 33620483,
 33396590,
 -1,
 -65022,
 33578193,
 74108,
 -1,
 33626351,
 74628,
 33817094,
 33587956,
 -1,
 -65019,
 33802281,
 74107,
 -1,
 33832508,
 74106,
 34013705,
 33774801,
 -1,
 -65016,
 33979071,
 74094,
 -1,
 34034195,
 74093,
 34210316,
 33963580,
 -1,
 -65013,
 34189415,
 74081,
 -1,
 34253142,
 74080,
 -65011,
 34200662,
 74124,
 -65010,
 34385144,
 74109,
 -1,
 34428906,
 74626,
 34603541,
 29046237,
 -1,
 34669074,
 34542823,
 74131,
 -1,
 34604507,
 74132,
 -65005,
 34608147,
 74130,
 -65004,
 34738933,
 74129,
 -1,
 34804176,
 74128,
 34996761,
 34583461,
 74140,
 35127295,
 34930688,
 -1,
 -65000,
 35034501,
 74142,
 -1,
 35090303,
 74141,
 35258909,
 34959047,
 74135,
 35389439,
 35192832,
 -1,
 -64996,
 35307328,
 74136,
 -1,
 35337345,
 74137,
 35521056,
 35224255,
 -1,
 -64993,
 35460115,
 74139,
 -1,
 35525072,
 74138,
 35717666,
 35482421,
 74133,
 -1,
 35654229,
 74134,
 35848740,
 35656144,
 74125,
 -1,
 35783252,
 74126,
 -64987,
 35821437,
 74607,
 -1,
 35923378,
 74127,
 36110898,
 29017290,
 74154,
 36176425,
 36086017,
 74163,
 -1,
 36111674,
 74164,
 36307499,
 36138695,
 74160,
 -1,
 36242232,
 74161,
 36438573,
 36246547,
 74157,
 -1,
 36375273,
 74158,
 -64978,
 36418047,
 74165,
 -64977,
 36537076,
 74162,
 -64976,
 36574892,
 74159,
 -64975,
 36639477,
 74156,
 -1,
 36701586,
 74155,
 36897342,
 36068561,
 74144,
 36962872,
 36875660,
 -1,
 37028406,
 36921627,
 74152,
 -1,
 36963814,
 74153,
 -64969,
 36983842,
 74151,
 -1,
 37100966,
 74150,
 37290556,
 36899319,
 -1,
 37356091,
 37274826,
 74146,
 -1,
 37303773,
 74147,
 -1,
 37299738,
 74145,
 -64963,
 37257972,
 74149,
 -1,
 37500381,
 74148,
 -64961,
 36886473,
 74166,
 -1,
 37635765,
 74143,
 37814969,
 28945804,
 -1,
 37880449,
 37770274,
 -1,
 37945947,
 37838033,
 -1,
 38011473,
 37911231,
 74438,
 38141951,
 37947895,
 -1,
 38142535,
 38035529,
 74444,
 -1,
 38077240,
 74445,
 38273610,
 38086066,
 -1,
 -64951,
 38258632,
 74441,
 -1,
 38280614,
 74440,
 -64949,
 38252108,
 74449,
 -64948,
 38437429,
 74448,
 -64947,
 38500991,
 74447,
 -64946,
 38563475,
 74446,
 -64945,
 38621257,
 74443,
 -64944,
 38680832,
 74442,
 -1,
 38738159,
 74439,
 38928981,
 37986561,
 74451,
 39059455,
 38862848,
 -1,
 -64940,
 38976618,
 74452,
 -1,
 39032387,
 74453,
 39191129,
 38876637,
 74435,
 39321599,
 39127543,
 -1,
 -64936,
 39215384,
 74437,
 -1,
 39262447,
 74436,
 -64934,
 39172765,
 74454,
 -1,
 39421448,
 74450,
 39584362,
 37886191,
 74413,
 39649894,
 39523061,
 74414,
 39780351,
 39586295,
 -1,
 39780960,
 39699658,
 74421,
 -1,
 39716562,
 74422,
 -64927,
 39764812,
 74420,
 -64926,
 39891455,
 74419,
 -64925,
 39945305,
 74418,
 -64924,
 39998061,
 74417,
 -64923,
 40052250,
 74416,
 -1,
 40114415,
 74415,
 40305256,
 39589340,
 74423,
 -1,
 40241523,
 75057,
 -64919,
 40280418,
 74425,
 -1,
 40379872,
 74424,
 40567418,
 39534140,
 74426,
 40632949,
 40501248,
 -1,
 40698480,
 40606699,
 -1,
 -64914,
 40677074,
 75061,
 -64913,
 40731527,
 75060,
 -1,
 40787001,
 75059,
 40960628,
 40670778,
 75058,
 41091071,
 40894464,
 -1,
 -64909,
 41007791,
 74429,
 -1,
 41045927,
 74428,
 -1,
 40918070,
 74427,
 41288312,
 40611894,
 74432,
 -64905,
 41250782,
 74434,
 -1,
 41292240,
 74433,
 -64903,
 41255668,
 74431,
 -1,
 41439108,
 74430,
 41680895,
 40551626,
 74455,
 41681535,
 41554384,
 74457,
 41811967,
 41617099,
 -1,
 -64898,
 41697091,
 75063,
 -1,
 41762258,
 75062,
 -64896,
 41626396,
 74458,
 -1,
 41878984,
 74456,
 42074791,
 37820655,
 74387,
 42140323,
 42028856,
 74389,
 42270719,
 42074112,
 -1,
 42271391,
 42188601,
 -1,
 42336907,
 42255562,
 -1,
 -64889,
 42315830,
 74406,
 -64888,
 42377473,
 74405,
 -64887,
 42433215,
 74404,
 -64886,
 42476978,
 74403,
 -1,
 42537424,
 74402,
 42730128,
 42315148,
 -1,
 42795663,
 42685474,
 -1,
 -64882,
 42753680,
 74400,
 -1,
 42810984,
 75055,
 -1,
 42737062,
 74399,
 43057811,
 42711709,
 -1,
 -64878,
 43019140,
 75056,
 -1,
 43066802,
 74401,
 43254422,
 43019061,
 -1,
 -64875,
 43240133,
 74395,
 -1,
 43261302,
 74394,
 43451032,
 43204012,
 74391,
 -1,
 43394482,
 74392,
 -64871,
 43419932,
 74398,
 -64870,
 43548448,
 74397,
 -64869,
 43612803,
 74396,
 -64868,
 43671629,
 74646,
 -64867,
 43734072,
 74393,
 -64866,
 43795300,
 75054,
 -1,
 43849967,
 74390,
 44040865,
 42226635,
 74408,
 -1,
 43977291,
 75053,
 -64862,
 44013105,
 74407,
 -1,
 44140854,
 74388,
 44303013,
 42102471,
 74409,
 -1,
 44237797,
 74410,
 -64858,
 44278017,
 74412,
 -1,
 44402095,
 74411,
 44565168,
 42058954,
 74466,
 44630698,
 44540161,
 74473,
 -1,
 44570685,
 74474,
 44761772,
 44595903,
 74471,
 -1,
 44704584,
 74472,
 44892846,
 44709341,
 74468,
 -1,
 44831184,
 74469,
 -64849,
 44850323,
 74470,
 -1,
 44959363,
 74467,
 45219839,
 44522705,
 74459,
 45220532,
 45109048,
 74461,
 45350911,
 45159443,
 74462,
 -1,
 45221468,
 74463,
 45417143,
 45154304,
 -1,
 -64842,
 45399937,
 75064,
 -1,
 45437899,
 74460,
 -64840,
 45379345,
 74465,
 -1,
 45575030,
 74464,
 45744939,
 37762525,
 -1,
 45810420,
 45728970,
 73850,
 45875940,
 45764408,
 73857,
 45941475,
 45812215,
 -1,
 46006979,
 45903559,
 -1,
 46072514,
 45947119,
 -1,
 46138049,
 46037695,
 74911,
 -1,
 46074483,
 74912,
 -1,
 46099308,
 74910,
 -1,
 46057274,
 74913,
 46400201,
 45968181,
 -1,
 46465736,
 46384330,
 -1,
 46531271,
 46445055,
 74908,
 -1,
 46466877,
 74909,
 -1,
 46506241,
 74907,
 -1,
 46408559,
 74906,
 46793422,
 46354232,
 -1,
 46858957,
 46750929,
 74900,
 -64820,
 46837814,
 74902,
 -1,
 46899557,
 74901,
 -1,
 46799087,
 74899,
 47121106,
 46758591,
 -1,
 -64816,
 47078609,
 74916,
 -64815,
 47138445,
 74915,
 -1,
 47194952,
 74914,
 47383254,
 47061231,
 -1,
 47448789,
 47362102,
 74894,
 -1,
 47382859,
 74895,
 -1,
 47417353,
 74893,
 47645401,
 47361420,
 -1,
 -64808,
 47602902,
 74920,
 -1,
 47666817,
 74919,
 47842012,
 47600674,
 -1,
 -64805,
 47799505,
 74904,
 -1,
 47847663,
 74903,
 48038623,
 47789533,
 -1,
 -64802,
 48023593,
 74897,
 -1,
 48062850,
 74896,
 -64800,
 48012009,
 74918,
 -64799,
 48203247,
 74917,
 -64798,
 48259149,
 74905,
 -1,
 48317981,
 74898,
 -1,
 45926082,
 73858,
 48562921,
 45843188,
 73860,
 48628456,
 48501493,
 73861,
 48758783,
 48563000,
 73862,
 -1,
 48628536,
 73863,
 -1,
 48567315,
 73864,
 48890606,
 48506290,
 73854,
 48956141,
 48826871,
 -1,
 -64788,
 48935172,
 74614,
 -1,
 48973493,
 73855,
 -1,
 48894416,
 73856,
 49218290,
 48824320,
 -1,
 -64784,
 49197383,
 73853,
 -64783,
 49255707,
 73851,
 -1,
 49304523,
 73852,
 -64781,
 49193314,
 73865,
 -1,
 49435682,
 73859,
 49611550,
 45750511,
 73813,
 49677080,
 49565496,
 73814,
 49742615,
 49610752,
 -1,
 49808150,
 49704339,
 -1,
 49873662,
 49762104,
 -1,
 49939195,
 49831121,
 73821,
 -1,
 49914210,
 73822,
 50070269,
 49879279,
 73819,
 -1,
 50005872,
 73820,
 -1,
 50054850,
 73823,
 50266883,
 49835719,
 -1,
 50332418,
 50250954,
 73829,
 -64767,
 50297535,
 73831,
 -1,
 50333563,
 73830,
 -1,
 50272495,
 73828,
 50594568,
 50250954,
 -1,
 50660103,
 50532967,
 -1,
 -64762,
 50625811,
 74611,
 -1,
 50680424,
 73836,
 -1,
 50638902,
 73837,
 50922250,
 50554519,
 73825,
 -1,
 50857831,
 73826,
 51053325,
 50865586,
 -1,
 -64756,
 51010769,
 73818,
 -1,
 51060182,
 73817,
 51249936,
 50993391,
 -1,
 -64753,
 51215491,
 73816,
 -1,
 51251056,
 73815,
 -64751,
 51231507,
 73835,
 -64750,
 51425818,
 73834,
 -64749,
 51484850,
 73833,
 -64748,
 51545177,
 73832,
 -64747,
 51604442,
 73827,
 -1,
 51663928,
 73824,
 -1,
 49790794,
 74889,
 -1,
 49681141,
 74612,
 51970844,
 49651969,
 73839,
 52101119,
 51910895,
 -1,
 -64741,
 51975187,
 73841,
 -1,
 52040437,
 73840,
 -64739,
 51935935,
 73838,
 -1,
 52169364,
 74888,
 52428799,
 49568977,
 73842,
 52429606,
 52329151,
 73844,
 52495140,
 52365815,
 -1,
 -64734,
 52479253,
 74891,
 -64733,
 52539652,
 73845,
 -1,
 52584521,
 74890,
 52822015,
 52433360,
 73846,
 -1,
 52693673,
 74892,
 52888360,
 52408374,
 73849,
 -1,
 52824020,
 74613,
 53019434,
 52855540,
 73847,
 -1,
 52954036,
 73848,
 -1,
 52962738,
 73843,
 53216155,
 45728970,
 74507,
 53281641,
 53190913,
 74536,
 53347154,
 53265610,
 74551,
 53412688,
 53283319,
 -1,
 53478197,
 53366584,
 -1,
 53543732,
 53418223,
 74556,
 -64718,
 53518593,
 74559,
 -64717,
 53576521,
 74558,
 -1,
 53636807,
 74557,
 -1,
 53527754,
 74560,
 53871417,
 53462218,
 -1,
 -64713,
 53849344,
 74574,
 -64712,
 53884381,
 74573,
 -1,
 53937938,
 74572,
 54133566,
 53833415,
 -1,
 54199101,
 54117578,
 -1,
 -64708,
 54164159,
 74566,
 -1,
 54203125,
 75072,
 -1,
 54140285,
 75071,
 54461250,
 54090961,
 -1,
 -64704,
 54439990,
 74564,
 -64703,
 54491839,
 74563,
 -1,
 54546963,
 74562,
 54723397,
 54439308,
 -1,
 -64700,
 54681443,
 74570,
 -1,
 54744705,
 74569,
 54920008,
 54670813,
 -1,
 -64697,
 54904873,
 74555,
 -1,
 54927653,
 75070,
 55116618,
 54860015,
 74552,
 -1,
 55095646,
 74553,
 -64693,
 55100171,
 74571,
 -64692,
 55220188,
 74568,
 -64691,
 55279693,
 74567,
 -64690,
 55340377,
 74565,
 -64689,
 55399480,
 74561,
 -1,
 55453298,
 74554,
 55705599,
 53360235,
 74575,
 -1,
 55577248,
 74576,
 55772003,
 53285328,
 74539,
 55902207,
 55705600,
 -1,
 55903074,
 55820089,
 -1,
 55968603,
 55887050,
 -1,
 56034138,
 55906768,
 74545,
 56164351,
 55969483,
 -1,
 -64679,
 56043606,
 74547,
 -1,
 56107848,
 74546,
 -1,
 55981533,
 75069,
 56361824,
 55908591,
 -1,
 56427359,
 56297163,
 -1,
 -64674,
 56394577,
 74541,
 -1,
 56448056,
 74540,
 -1,
 56389319,
 74542,
 -64671,
 56330524,
 74544,
 -1,
 56644664,
 74543,
 -1,
 55862615,
 75068,
 56886117,
 55729361,
 74549,
 -1,
 56824565,
 74550,
 57017192,
 56819712,
 -1,
 -64665,
 56996167,
 74538,
 -1,
 57029826,
 74537,
 -1,
 56955923,
 74548,
 57279349,
 53246655,
 74525,
 57344880,
 57215479,
 -1,
 57410413,
 57310632,
 74648,
 -1,
 57345764,
 74527,
 -64658,
 57394378,
 74529,
 -64657,
 57520239,
 74528,
 -1,
 57569145,
 74526,
 57738100,
 57329613,
 74531,
 57868287,
 57674231,
 -1,
 -64653,
 57776092,
 74533,
 -1,
 57830436,
 74532,
 -1,
 57682072,
 74530,
 58065793,
 57226717,
 74515,
 58131328,
 57999360,
 -1,
 58196860,
 58113849,
 -1,
 58262394,
 58180842,
 74519,
 -1,
 58196792,
 74520,
 -64645,
 58228512,
 74518,
 -1,
 58336794,
 74517,
 58524542,
 58175815,
 74522,
 -1,
 58460671,
 74523,
 -64641,
 58486419,
 74516,
 -1,
 58610635,
 74521,
 -1,
 58115876,
 74524,
 58852234,
 58044470,
 74577,
 58917767,
 58788343,
 -1,
 58983301,
 58879596,
 74579,
 -1,
 58958081,
 74580,
 -64634,
 58964755,
 74581,
 -1,
 59054319,
 74578,
 -64632,
 58906589,
 74582,
 -64631,
 59230245,
 74584,
 -1,
 59249104,
 74583,
 59442066,
 58785792,
 -1,
 59507599,
 59414150,
 -1,
 -64627,
 59491578,
 74512,
 -64626,
 59554110,
 74511,
 -1,
 59611117,
 74510,
 59769745,
 59491530,
 74649,
 -1,
 59706081,
 74509,
 -1,
 59724727,
 74508,
 59966358,
 59431727,
 -1,
 60031893,
 59904757,
 74586,
 -1,
 59968101,
 74587,
 -1,
 60015818,
 74588,
 60228504,
 59933428,
 74534,
 -1,
 60162872,
 74535,
 -64615,
 60212029,
 74585,
 -64614,
 60302770,
 74514,
 -1,
 60363216,
 74513,
 60556283,
 53183220,
 -1,
 60621768,
 60513489,
 74316,
 60687297,
 60588788,
 74639,
 60752832,
 60634768,
 74322,
 60882943,
 60688887,
 -1,
 60883877,
 60802250,
 75050,
 -64606,
 60862518,
 74335,
 -64605,
 60927232,
 75052,
 -64604,
 60953199,
 74334,
 -1,
 61016061,
 75051,
 61211562,
 60862724,
 74330,
 61341695,
 61146834,
 -1,
 61342633,
 61255734,
 74332,
 -1,
 61277914,
 74333,
 -1,
 61276227,
 74331,
 61539248,
 61165368,
 -1,
 61604782,
 61523146,
 -1,
 -64595,
 61566663,
 75044,
 -1,
 61617629,
 74326,
 61865983,
 61562065,
 74642,
 -1,
 61780022,
 75043,
 61932468,
 61479151,
 -1,
 61998003,
 61911094,
 74324,
 -1,
 61933274,
 74325,
 -1,
 61965044,
 74323,
 62194615,
 61899508,
 -1,
 -64586,
 62179369,
 74329,
 -1,
 62209596,
 74328,
 62391226,
 62159551,
 -1,
 -64583,
 62340814,
 74327,
 -1,
 62399304,
 75048,
 -64581,
 62363826,
 75049,
 -64580,
 62549970,
 75047,
 -64579,
 62614736,
 75046,
 -64578,
 62674913,
 75045,
 -64577,
 62732530,
 75042,
 -1,
 62793272,
 74641,
 -1,
 60692541,
 74640,
 63046597,
 60652223,
 74319,
 63176703,
 62982704,
 -1,
 -64572,
 63086879,
 74321,
 -1,
 63144777,
 74320,
 -64570,
 63024702,
 74336,
 -64569,
 63246800,
 74318,
 -1,
 63310363,
 74317,
 63505385,
 60605642,
 74337,
 63570916,
 63472372,
 74339,
 63636441,
 63556727,
 74349,
 63766527,
 63569920,
 -1,
 63767511,
 63642059,
 -1,
 -64562,
 63751506,
 74359,
 -64561,
 63812303,
 74358,
 -64560,
 63865945,
 74357,
 -64559,
 63926021,
 74356,
 -64558,
 63990722,
 74355,
 -64557,
 64053325,
 74354,
 -64556,
 64115639,
 74353,
 -64555,
 64175566,
 74352,
 -64554,
 64235606,
 74351,
 -1,
 64299880,
 74350,
 64552959,
 63729057,
 74360,
 -1,
 64424673,
 74361,
 64684031,
 63569920,
 -1,
 64685024,
 64581547,
 -1,
 64750557,
 64663116,
 74342,
 -1,
 64685634,
 74343,
 -64546,
 64736205,
 74344,
 -64545,
 64847123,
 74341,
 -1,
 64901193,
 74340,
 65078242,
 64631977,
 74347,
 -1,
 65012727,
 74348,
 -64541,
 65059946,
 74345,
 -1,
 65181186,
 74346,
 65404927,
 63508907,
 74338,
 65470463,
 65273856,
 -1,
 -64537,
 65387626,
 983256,
 -64536,
 65448955,
 74643,
 -1,
 65508843,
 983257,
 65668085,
 63445231,
 74302,
 65733616,
 65621895,
 74304,
 65799151,
 65667072,
 -1,
 -64531,
 65781618,
 74306,
 -64530,
 65835221,
 74307,
 -1,
 65889623,
 74305,
 -1,
 65773825,
 74308,
 66126835,
 65698495,
 74310,
 -64526,
 66064848,
 74311,
 -1,
 66127066,
 74309,
 -64524,
 66065427,
 74638,
 -1,
 66261456,
 74303,
 66519039,
 65617468,
 74312,
 66584575,
 66387968,
 -1,
 66585594,
 66502457,
 -1,
 -64519,
 66569922,
 74314,
 -1,
 66590959,
 74313,
 -1,
 66564423,
 74315,
 66847826,
 60496111,
 73728,
 66913304,
 66790834,
 73738,
 66978832,
 66846720,
 -1,
 67044367,
 66961209,
 -1,
 67109890,
 67022902,
 -1,
 -64511,
 67093842,
 74881,
 -1,
 67126961,
 73747,
 67306500,
 67078428,
 74608,
 -1,
 67242355,
 74880,
 67437575,
 67263697,
 -1,
 -64506,
 67403853,
 73745,
 -1,
 67457558,
 73744,
 67634186,
 67391367,
 -1,
 -64503,
 67601225,
 73742,
 -1,
 67661511,
 73741,
 -64501,
 67618026,
 73748,
 -64500,
 67792761,
 73746,
 -64499,
 67851320,
 73743,
 -64498,
 67911135,
 73740,
 -1,
 67969891,
 73739,
 -1,
 66999243,
 73749,
 68288511,
 66916816,
 73750,
 68354047,
 68159991,
 -1,
 -64493,
 68270867,
 73755,
 -64492,
 68333679,
 73754,
 -64491,
 68386228,
 73753,
 -64490,
 68440086,
 73752,
 -64489,
 68494908,
 73751,
 -1,
 68557039,
 74609,
 68748325,
 66875079,
 73760,
 68813859,
 68684279,
 -1,
 68879389,
 68774709,
 -1,
 -64484,
 68836561,
 73766,
 -1,
 68885300,
 73765,
 -64482,
 68864973,
 73768,
 -64481,
 69054724,
 73767,
 -64480,
 69096504,
 73764,
 -64479,
 69161581,
 73763,
 -64478,
 69220603,
 73762,
 -1,
 69279142,
 73761,
 -64476,
 68764979,
 73770,
 -1,
 69410589,
 73769,
 69600305,
 68726156,
 -1,
 69665840,
 69555234,
 73784,
 69731374,
 69599232,
 -1,
 69796908,
 69702920,
 -1,
 69862443,
 69768447,
 73788,
 -1,
 69796376,
 73789,
 -1,
 69845783,
 73787,
 -64467,
 69786713,
 73785,
 -1,
 70020020,
 73786,
 -64465,
 69685151,
 73791,
 -1,
 70128080,
 73790,
 -1,
 69606861,
 73783,
 70386746,
 69536247,
 -1,
 -64461,
 70364734,
 73736,
 -64460,
 70419127,
 73735,
 -64459,
 70479776,
 73734,
 -64458,
 70541385,
 73733,
 -64457,
 70603832,
 73732,
 -64456,
 70668310,
 73731,
 -64455,
 70723098,
 73730,
 -1,
 70785263,
 73729,
 70976578,
 70353652,
 73773,
 71042113,
 70909952,
 -1,
 71107647,
 71015450,
 -1,
 -64450,
 71087669,
 73777,
 -1,
 71143578,
 73776,
 -64448,
 71089685,
 73775,
 -1,
 71275767,
 73774,
 -1,
 71020804,
 73778,
 71500870,
 70951169,
 -1,
 71566405,
 71441168,
 73780,
 -1,
 71502451,
 73781,
 -1,
 71527344,
 73782,
 71763018,
 71466115,
 73771,
 71892991,
 71698935,
 -1,
 -64439,
 71807236,
 73772,
 -1,
 71855735,
 74610,
 72025166,
 71723829,
 73757,
 72155135,
 71961079,
 -1,
 -64435,
 72069499,
 73759,
 -1,
 72107549,
 73758,
 72287312,
 71972317,
 73756,
 -1,
 72223268,
 74882,
 -64431,
 72260405,
 73779,
 -1,
 72356304,
 73737,
 72549529,
 66797116,
 73866,
 72615033,
 72539095,
 73889,
 72744959,
 72548352,
 -1,
 72746096,
 72662841,
 -1,
 72811611,
 72707783,
 -1,
 72877145,
 72751343,
 73903,
 -1,
 72838873,
 73904,
 -64422,
 72860874,
 73906,
 -1,
 72965329,
 73905,
 73139295,
 72751343,
 73890,
 73204830,
 73074525,
 73891,
 -1,
 73140862,
 73892,
 -1,
 73171700,
 73893,
 73401443,
 73100085,
 -1,
 73466978,
 73343855,
 73900,
 -1,
 73402645,
 73901,
 -1,
 73450848,
 73902,
 73663590,
 73385162,
 -1,
 -64411,
 73610717,
 73908,
 -1,
 73667024,
 73907,
 73860201,
 73641356,
 -1,
 -64408,
 73843914,
 74933,
 -1,
 73881217,
 74616,
 74056811,
 73815096,
 73897,
 -1,
 73990968,
 73898,
 74187885,
 74005983,
 73895,
 -1,
 74122040,
 73896,
 -64402,
 74145869,
 73899,
 -64401,
 74273719,
 74615,
 -1,
 74327578,
 73894,
 74579967,
 72724815,
 -1,
 74581107,
 74481064,
 74930,
 -1,
 74558860,
 74931,
 74712181,
 74542853,
 74928,
 -1,
 74673863,
 74929,
 -64394,
 74692833,
 74932,
 -64393,
 74801229,
 74927,
 -64392,
 74864609,
 74926,
 -1,
 74916680,
 74925,
 75105412,
 72552912,
 73869,
 75235327,
 75041271,
 -1,
 75236478,
 75148684,
 -1,
 -64387,
 75191937,
 73874,
 -1,
 75242918,
 73873,
 -64385,
 75220170,
 73875,
 -64384,
 75405463,
 74922,
 -64383,
 75464480,
 73872,
 -64382,
 75525775,
 74921,
 -64381,
 75583561,
 73871,
 -1,
 75634975,
 73870,
 75826317,
 75072244,
 73879,
 75956223,
 75759616,
 -1,
 75957386,
 75874105,
 -1,
 76022921,
 75911185,
 73880,
 -1,
 75958643,
 73881,
 -1,
 75988392,
 73882,
 -64373,
 75937333,
 73885,
 -64372,
 76189872,
 73884,
 -1,
 76231718,
 73883,
 76416145,
 75800833,
 -1,
 76481680,
 76374442,
 73887,
 -1,
 76418582,
 74923,
 -1,
 76432228,
 73886,
 76678291,
 76394599,
 73888,
 -1,
 76612152,
 74924,
 76809366,
 76611584,
 -1,
 -64363,
 76791646,
 73867,
 -1,
 76846371,
 73868,
 -64361,
 76771015,
 73878,
 -64360,
 76960356,
 73877,
 -1,
 77019392,
 73876,
 77202629,
 72530459,
 -1,
 77268145,
 77142255,
 74475,
 77333668,
 77221688,
 74483,
 77463551,
 77269495,
 -1,
 77464736,
 77377590,
 -1,
 -64353,
 77448394,
 74487,
 -1,
 77479484,
 74486,
 -64351,
 77448898,
 74489,
 -64350,
 77644562,
 74488,
 -64349,
 77681591,
 74485,
 -1,
 77736022,
 74484,
 77923498,
 77266944,
 -1,
 77989032,
 77905721,
 -1,
 -64345,
 77954848,
 74478,
 -1,
 78010337,
 74477,
 -64343,
 77943755,
 74479,
 -1,
 78128041,
 74476,
 78316718,
 77866418,
 74480,
 78446591,
 78249984,
 -1,
 -64339,
 78362165,
 74482,
 -1,
 78419546,
 74481,
 78578864,
 78277508,
 74490,
 -1,
 78514104,
 75065,
 -1,
 78553345,
 74491,
 78775482,
 77251786,
 74501,
 78841014,
 78740159,
 74504,
 78970879,
 78776823,
 -1,
 -64331,
 78888392,
 75067,
 -1,
 78925846,
 75066,
 79103160,
 78815489,
 74505,
 -1,
 79038092,
 74506,
 -64327,
 79063861,
 74503,
 -1,
 79187838,
 74502,
 79365315,
 78732497,
 74494,
 79430848,
 79339777,
 74497,
 79560703,
 79364096,
 -1,
 79561919,
 79468157,
 74499,
 -1,
 79495945,
 74500,
 -1,
 79544193,
 74498,
 -64319,
 79392455,
 74496,
 -64318,
 79696336,
 74647,
 -1,
 79759731,
 74495,
 80019455,
 79314492,
 74492,
 -1,
 79889208,
 74493,
 80086255,
 77167295,
 -1,
 80151776,
 80069834,
 74284,
 80217307,
 80130102,
 74290,
 80282835,
 80150528,
 -1,
 80348366,
 80254433,
 74294,
 80478207,
 80284151,
 -1,
 -64308,
 80374746,
 75041,
 -64307,
 80433031,
 75040,
 -1,
 80484679,
 74295,
 80676050,
 80330553,
 -1,
 -64304,
 80665407,
 74293,
 -64303,
 80703119,
 74292,
 -1,
 80746735,
 74291,
 -1,
 80622747,
 74296,
 81068031,
 80220917,
 74297,
 81133567,
 80936960,
 -1,
 81134810,
 81051449,
 -1,
 81200344,
 81074415,
 74298,
 -1,
 81135341,
 74299,
 -64295,
 81189695,
 74637,
 -1,
 81279036,
 74300,
 -1,
 81089483,
 74301,
 81528029,
 80170808,
 74286,
 -1,
 81462072,
 74287,
 -64290,
 81503872,
 74289,
 -64289,
 81627176,
 74288,
 -1,
 81659439,
 74285,
 81855721,
 80091375,
 74272,
 81921251,
 81834038,
 74278,
 -1,
 81859024,
 74279,
 82052326,
 81854464,
 -1,
 -64283,
 82034561,
 74273,
 -1,
 82072523,
 74274,
 -64281,
 82026753,
 74277,
 -64280,
 82203682,
 74276,
 -1,
 82252240,
 74275,
 82445548,
 81812689,
 74282,
 -64277,
 82412276,
 74283,
 -1,
 82446341,
 75039,
 82706431,
 82394684,
 74280,
 82771967,
 82619788,
 74281,
 -1,
 82662434,
 74636,
 82838798,
 80029106,
 -1,
 82904318,
 82778351,
 73792,
 82969846,
 82859533,
 73795,
 83099647,
 82905591,
 -1,
 -64268,
 83024703,
 74886,
 -64267,
 83068399,
 74885,
 -1,
 83106247,
 74884,
 83297529,
 82931399,
 73796,
 -64264,
 83237941,
 73798,
 -1,
 83297618,
 73797,
 83494139,
 83271937,
 73799,
 -1,
 83433875,
 73800,
 83625213,
 83441117,
 73793,
 -1,
 83560970,
 74883,
 -1,
 83578753,
 73794,
 83821833,
 82887882,
 73805,
 83887365,
 83755008,
 -1,
 83952900,
 83858706,
 -1,
 -64254,
 83937321,
 73807,
 -64253,
 84000596,
 74887,
 -1,
 84023748,
 73806,
 -1,
 83899418,
 73808,
 84280583,
 83861761,
 73811,
 -1,
 84218320,
 73812,
 84475903,
 84245115,
 73809,
 -1,
 84346204,
 73810,
 84606975,
 83778769,
 73801,
 84672511,
 84478455,
 -1,
 -64244,
 84566093,
 73804,
 -64243,
 84627529,
 73803,
 -1,
 84678895,
 73802,
 84870443,
 82793506,
 -1,
 84935963,
 84827345,
 74029,
 85065727,
 84871671,
 -1,
 85067028,
 84943688,
 74030,
 -64237,
 85004752,
 74031,
 -1,
 85067135,
 74959,
 -64235,
 85050570,
 74038,
 -64234,
 85242116,
 74037,
 -64233,
 85297436,
 74036,
 -64232,
 85355888,
 74035,
 -64231,
 85413795,
 74034,
 -64230,
 85473611,
 74033,
 -1,
 85534234,
 74032,
 85722405,
 84919498,
 74039,
 85787939,
 85665224,
 74040,
 85917695,
 85723639,
 -1,
 -64225,
 85837506,
 74045,
 -64224,
 85882663,
 74044,
 -64223,
 85945380,
 74043,
 -64222,
 86004925,
 74042,
 -1,
 86056733,
 74041,
 -64220,
 85766198,
 74621,
 -1,
 86208258,
 74046,
 86441983,
 85661935,
 74025,
 86443306,
 86310912,
 -1,
 86508841,
 86424682,
 74026,
 -1,
 86442808,
 74958,
 -1,
 86463435,
 74027,
 -1,
 86404807,
 74028,
 86771014,
 84827345,
 74047,
 86836531,
 86735551,
 74062,
 86902066,
 86769664,
 -1,
 -64209,
 86884225,
 74063,
 -64208,
 86947381,
 74066,
 -64207,
 87003324,
 74065,
 -1,
 87045237,
 74064,
 -1,
 86860162,
 74067,
 87295290,
 86789944,
 74053,
 87425023,
 87252177,
 74054,
 87490559,
 87293952,
 -1,
 -64201,
 87402144,
 74056,
 -64200,
 87463266,
 74057,
 -64199,
 87512011,
 74058,
 -1,
 87570616,
 74055,
 87754045,
 87256775,
 74059,
 -64196,
 87691728,
 74061,
 -1,
 87755322,
 74060,
 87950657,
 87701742,
 74050,
 88080383,
 87885244,
 -1,
 -64192,
 87995957,
 74052,
 -1,
 88025884,
 74051,
 -64190,
 87928886,
 74070,
 -64189,
 88187137,
 74069,
 -64188,
 88244980,
 74068,
 -64187,
 88286642,
 74049,
 -1,
 88342530,
 74048,
 88540516,
 86742894,
 -1,
 88606046,
 88497361,
 74367,
 88671573,
 88539136,
 -1,
 88737108,
 88653625,
 -1,
 88802636,
 88720586,
 74375,
 -1,
 88740304,
 74376,
 88933710,
 88759505,
 74373,
 -1,
 88876466,
 74374,
 89064785,
 88876466,
 -1,
 -64176,
 89048266,
 74371,
 -1,
 89087185,
 74370,
 89261395,
 89004271,
 74368,
 -1,
 89204146,
 74369,
 -1,
 89210428,
 74372,
 -1,
 88683702,
 74377,
 89587711,
 88645889,
 -1,
 89589085,
 89481049,
 74378,
 89718783,
 89522176,
 -1,
 89720156,
 89636665,
 -1,
 -64166,
 89709375,
 74381,
 -64165,
 89769666,
 74380,
 -1,
 89811939,
 74379,
 -1,
 89690339,
 74382,
 -1,
 89526736,
 74645,
 90113378,
 88545519,
 74362,
 -64160,
 90085230,
 74365,
 -64159,
 90145524,
 74364,
 -1,
 90191325,
 74363,
 90439679,
 90064565,
 74366,
 -1,
 90308920,
 74644,
 90506620,
 88529711,
 -1,
 90572141,
 90490058,
 74602,
 90637674,
 90510567,
 74603,
 90767359,
 90573303,
 -1,
 -64151,
 90684883,
 75075,
 -1,
 90708207,
 74604,
 -64149,
 90602175,
 74606,
 -64148,
 90843932,
 74605,
 -1,
 90900138,
 75074,
 91096436,
 90528977,
 74595,
 91161968,
 91039154,
 74598,
 -1,
 91095970,
 74599,
 -64143,
 91151164,
 74601,
 -64142,
 91246392,
 74600,
 -64141,
 91296501,
 74597,
 -1,
 91358881,
 74596,
 91555195,
 91035887,
 74589,
 91620728,
 91488256,
 -1,
 -64137,
 91602026,
 74590,
 -1,
 91665990,
 74591,
 -64135,
 91587288,
 74593,
 -64134,
 91770680,
 74592,
 -1,
 91821740,
 75073,
 -1,
 91504448,
 74594,
 92143615,
 90480897,
 -1,
 92145023,
 92018927,
 74383,
 -1,
 92087730,
 74384,
 -64128,
 92128458,
 74386,
 -1,
 92232913,
 74385,
 92407324,
 231694,
 -1,
 92472746,
 92359096,
 -1,
 92538264,
 92443592,
 -1,
 92603785,
 92523813,
 74812,
 92669320,
 92536832,
 -1,
 -64121,
 92612018,
 74815,
 -1,
 92674287,
 74814,
 -1,
 92607507,
 74813,
 92931469,
 92546482,
 -1,
 92997004,
 92872489,
 74834,
 -1,
 92932841,
 74835,
 -1,
 92982159,
 74808,
 93193615,
 92914890,
 74767,
 -1,
 93129449,
 74857,
 93324690,
 93171949,
 -1,
 -64111,
 93308106,
 74800,
 -1,
 93327824,
 74790,
 93521301,
 93278521,
 -1,
 -64108,
 93504714,
 74785,
 -1,
 93524432,
 74776,
 93717911,
 93463368,
 74754,
 -1,
 93653363,
 74828,
 -1,
 93665611,
 74761,
 93978623,
 92498133,
 -1,
 93980062,
 93891980,
 -1,
 94045597,
 93935113,
 -1,
 -64100,
 94029002,
 74801,
 -1,
 94048720,
 74791,
 -1,
 94005689,
 74844,
 94307746,
 93922738,
 -1,
 94373281,
 94248745,
 74836,
 -1,
 94309097,
 74837,
 -1,
 94358415,
 74809,
 94569892,
 94291146,
 74768,
 -1,
 94505705,
 74858,
 94700967,
 94523705,
 -1,
 -64090,
 94684362,
 74786,
 -1,
 94704080,
 74777,
 94897577,
 94643016,
 74755,
 -1,
 94833011,
 74829,
 -1,
 94845259,
 74762,
 95094222,
 92453403,
 -1,
 95159742,
 95050565,
 -1,
 95225265,
 95138029,
 -1,
 95290799,
 95208650,
 74798,
 -1,
 95226601,
 74799,
 95485951,
 95228368,
 74788,
 -1,
 95357673,
 74789,
 95552949,
 95167922,
 -1,
 95618484,
 95538063,
 74806,
 -1,
 95554281,
 74807,
 -1,
 95559465,
 74833,
 95815096,
 95538414,
 -1,
 -64073,
 95752908,
 74811,
 -1,
 95818170,
 74810,
 96011707,
 95768889,
 -1,
 -64070,
 95995082,
 74784,
 -1,
 96014800,
 74775,
 96208317,
 95953736,
 74753,
 -1,
 96143731,
 74827,
 -1,
 96155979,
 74760,
 96468991,
 95147533,
 -1,
 96470466,
 96386429,
 -1,
 -64063,
 96455885,
 74846,
 -1,
 96483659,
 74843,
 96667077,
 96448749,
 -1,
 -64060,
 96650442,
 74797,
 -1,
 96670160,
 74787,
 96863688,
 96620857,
 -1,
 -64057,
 96847050,
 74783,
 -1,
 96866768,
 74774,
 97060299,
 96806322,
 -1,
 -64054,
 97045391,
 74805,
 -1,
 97066793,
 74832,
 97256909,
 97002312,
 74752,
 -1,
 97192307,
 74826,
 -1,
 97207994,
 74841,
 97453543,
 95071628,
 -1,
 97519067,
 97404900,
 -1,
 97584597,
 97504531,
 -1,
 97650132,
 97517568,
 -1,
 -64045,
 97592754,
 74819,
 -1,
 97655023,
 74818,
 -1,
 97587957,
 74817,
 97912279,
 97567946,
 74770,
 -1,
 97848041,
 74860,
 -64040,
 97890546,
 74793,
 -64039,
 97997118,
 74779,
 -64038,
 98056523,
 74764,
 -1,
 98116424,
 74757,
 98305508,
 97479046,
 -1,
 98371038,
 98288842,
 74769,
 -1,
 98306793,
 74859,
 98502112,
 98313032,
 74756,
 -1,
 98437491,
 74830,
 -64031,
 98487516,
 74816,
 -64030,
 98611442,
 74792,
 -64029,
 98652478,
 74778,
 -1,
 98711883,
 74763,
 98959359,
 98260498,
 -1,
 -64026,
 98861133,
 74803,
 -1,
 98908491,
 74802,
 99091965,
 97421738,
 -1,
 99157498,
 99058780,
 -1,
 99223020,
 99138920,
 -1,
 -64021,
 99208397,
 74845,
 -1,
 99236171,
 74842,
 99419631,
 99196986,
 -1,
 -64018,
 99374047,
 74851,
 -1,
 99427144,
 74848,
 99616242,
 99373369,
 -1,
 -64015,
 99599562,
 74782,
 -1,
 99619280,
 74773,
 99812853,
 99565116,
 -1,
 -64012,
 99791112,
 74840,
 -1,
 99835950,
 74847,
 100009464,
 99755442,
 -1,
 -64009,
 99994511,
 74804,
 -1,
 100015913,
 74831,
 -64007,
 99987710,
 74796,
 -1,
 100160740,
 74852,
 100401151,
 99119437,
 -1,
 -64004,
 100316040,
 74849,
 -1,
 100376626,
 74850,
 100533772,
 99059183,
 -1,
 100599305,
 100500572,
 -1,
 100664835,
 100584703,
 74822,
 -63999,
 100602899,
 74824,
 -63998,
 100668149,
 74823,
 -1,
 100728834,
 74825,
 100926981,
 100648138,
 74772,
 -1,
 100862697,
 74862,
 -63994,
 100905202,
 74795,
 -63993,
 101011774,
 74781,
 -63992,
 101071179,
 74766,
 -1,
 101131080,
 74759,
 101384191,
 100553273,
 -1,
 -63989,
 101285965,
 74838,
 -1,
 101336753,
 74839,
 101580799,
 100482620,
 -1,
 101582358,
 101474265,
 -1,
 101647888,
 101567800,
 74820,
 -1,
 101585653,
 74821,
 101778962,
 101631178,
 74771,
 -1,
 101714665,
 74861,
 -63981,
 101757170,
 74794,
 -63980,
 101863742,
 74780,
 -63979,
 101923147,
 74765,
 -1,
 101983048,
 74758,
 102236159,
 101543929,
 -1,
 102237722,
 102123960,
 -1,
 -63975,
 102208021,
 74855,
 -1,
 102260543,
 74856,
 -63973,
 102220968,
 74854,
 -1,
 102403624,
 74853,
 102629375,
 92380925,
 -1,
 102630945,
 102512760,
 -1,
 -63969,
 102613542,
 74867,
 -63968,
 102670280,
 74868,
 -1,
 102707544,
 74866,
 -63966,
 102616684,
 74865,
 -1,
 102861863,
 74864,
 103024168,
 172289,
 -1,
 103089703,
 102998273,
 -1,
 -63962,
 103078104,
 127835,
 -1,
 103105506,
 128177,
 -1,
 103054007,
 10160,
 103351851,
 103003868,
 -1,
 -63958,
 103320878,
 128707,
 -1,
 103358862,
 127854,
 -63956,
 103323527,
 9982,
 -1,
 103494966,
 129362,
 103680122,
 100778,
 -1,
 103745394,
 103643839,
 -1,
 103810929,
 103688348,
 -1,
 103876222,
 103763768,
 -1,
 103941731,
 103837624,
 -1,
 104007227,
 103930067,
 -1,
 104072760,
 103956028,
 -1,
 104138295,
 104046849,
 -1,
 -63946,
 104121546,
 122911,
 -1,
 104160465,
 122912,
 -1,
 104118476,
 122885,
 -63943,
 104056010,
 122915,
 -63942,
 104368554,
 122918,
 -1,
 104408149,
 122913,
 104597057,
 103963857,
 122891,
 104662591,
 104567433,
 -1,
 -63938,
 104641756,
 122919,
 -1,
 104671356,
 122921,
 -63936,
 104651858,
 122889,
 -1,
 104826529,
 122890,
 104990279,
 104574348,
 -1,
 105055813,
 104944674,
 -1,
 -63932,
 105036445,
 122907,
 -1,
 105060591,
 122910,
 -63930,
 105020474,
 122916,
 -1,
 105216246,
 122900,
 105383498,
 104979247,
 -1,
 -63927,
 105339227,
 122886,
 -1,
 105399114,
 122888,
 105580109,
 105363995,
 -1,
 -63924,
 105566445,
 122901,
 -1,
 105624090,
 122908,
 105776720,
 105531832,
 -1,
 -63921,
 105753279,
 122903,
 -1,
 105801748,
 122922,
 105973331,
 105723357,
 -1,
 -63918,
 105941545,
 122884,
 -1,
 105998996,
 122892,
 106169942,
 105915826,
 -1,
 -63915,
 106153851,
 122881,
 -1,
 106192732,
 122920,
 -63913,
 106155426,
 122882,
 -63912,
 106350450,
 122902,
 -63911,
 106408633,
 122899,
 -63910,
 106470658,
 122898,
 -63909,
 106532661,
 122897,
 -63908,
 106595256,
 122896,
 -63907,
 106660588,
 122895,
 -63906,
 106723179,
 122894,
 -63905,
 106785758,
 122893,
 -63904,
 106846079,
 122904,
 -63903,
 106910344,
 122883,
 -63902,
 106966763,
 122909,
 -1,
 107029934,
 122880,
 107282431,
 103915777,
 -1,
 107284089,
 107157743,
 -1,
 107349622,
 107251844,
 -1,
 107415152,
 107296988,
 -1,
 107480682,
 107395611,
 -1,
 -63895,
 107468298,
 70504,
 -1,
 107502400,
 70505,
 107677293,
 107432376,
 -1,
 -63892,
 107647940,
 70506,
 -1,
 107702481,
 70507,
 -63890,
 107666417,
 70502,
 -63889,
 107852632,
 70508,
 -1,
 107908532,
 70503,
 108134399,
 107377884,
 -1,
 -63886,
 108056382,
 70515,
 -63885,
 108107740,
 70516,
 -63884,
 108168017,
 70514,
 -63883,
 108227463,
 70513,
 -1,
 108271855,
 70512,
 108527615,
 107335070,
 -1,
 -63880,
 108428094,
 7621,
 -1,
 108468996,
 7624,
 108724223,
 107233538,
 -1,
 108725885,
 108640795,
 -1,
 -63876,
 108702311,
 119362,
 -1,
 108742410,
 119363,
 -1,
 108698155,
 119364,
 108988098,
 103820162,
 -1,
 109053632,
 108976918,
 -1,
 109119156,
 109016284,
 -1,
 109184649,
 109067836,
 -1,
 109250180,
 109161868,
 11757,
 -1,
 109186947,
 11765,
 -63867,
 109224193,
 11756,
 -63866,
 109347572,
 11753,
 -63865,
 109411007,
 11752,
 -63864,
 109473479,
 11751,
 -1,
 109529528,
 42654,
 109708943,
 109141201,
 42613,
 109774478,
 109679297,
 -1,
 -63860,
 109723196,
 42655,
 -63859,
 109783164,
 11775,
 -1,
 109844719,
 11772,
 -1,
 109723196,
 11767,
 110102164,
 109697235,
 -1,
 -63855,
 110085322,
 11771,
 -63854,
 110124241,
 42614,
 -63853,
 110184055,
 42617,
 -1,
 110240690,
 11770,
 110429849,
 110079372,
 -1,
 110495384,
 110384162,
 -1,
 -63849,
 110439963,
 11763,
 -1,
 110500079,
 11762,
 -1,
 110463759,
 42618,
 110757532,
 110418735,
 -1,
 -63845,
 110712449,
 11748,
 -1,
 110771772,
 11749,
 110954142,
 110740682,
 42615,
 -1,
 110915145,
 42612,
 111085217,
 110934555,
 -1,
 -63840,
 111062839,
 11760,
 -1,
 111099452,
 11758,
 111281827,
 111053226,
 11754,
 -1,
 111246967,
 42619,
 111412901,
 111236152,
 11759,
 -1,
 111387579,
 42616,
 111543976,
 111359453,
 -1,
 -63833,
 111504015,
 11768,
 -1,
 111558204,
 11747,
 111740587,
 111486386,
 -1,
 -63830,
 111697756,
 11774,
 -1,
 111754812,
 11744,
 -63828,
 111725925,
 11745,
 -63827,
 111909229,
 11755,
 -63826,
 111968634,
 11769,
 -63825,
 112031569,
 11773,
 -63824,
 112094087,
 11750,
 -63823,
 112152977,
 11746,
 -63822,
 112217063,
 11764,
 -63821,
 112275008,
 11761,
 -1,
 112335087,
 11766,
 112527034,
 109099547,
 -1,
 112592568,
 112486571,
 -1,
 -63817,
 112568159,
 65071,
 -1,
 112620179,
 65070,
 -63815,
 112548621,
 42610,
 -1,
 112739187,
 42608,
 112920253,
 112498542,
 -1,
 -63812,
 112888843,
 1159,
 -1,
 112928158,
 42621,
 -63810,
 112906502,
 42607,
 -63809,
 113077359,
 42620,
 -1,
 113138783,
 42609,
 113377279,
 109022964,
 65062,
 -1,
 113246575,
 65069,
 113444605,
 108949191,
 -1,
 113510126,
 113386585,
 -1,
 113575656,
 113488974,
 -1,
 113641163,
 113514735,
 -1,
 -63801,
 113626234,
 7638,
 -63800,
 113674666,
 7637,
 -63799,
 113736162,
 7655,
 -63798,
 113786428,
 7636,
 -1,
 113839009,
 7666,
 114034382,
 113602247,
 7645,
 -63795,
 114003608,
 7653,
 -1,
 114035693,
 7660,
 114230993,
 114017563,
 -1,
 -63792,
 114193983,
 7664,
 -1,
 114243671,
 7668,
 114427603,
 114208140,
 7652,
 -1,
 114372377,
 7658,
 114558678,
 114401539,
 -1,
 -63787,
 114535461,
 7651,
 -1,
 114567052,
 7626,
 114755289,
 114526673,
 -1,
 -63784,
 114718271,
 7661,
 -1,
 114767959,
 7667,
 114951899,
 114706872,
 7659,
 -1,
 114913544,
 7635,
 115082974,
 114900540,
 -1,
 -63779,
 115064017,
 7641,
 -1,
 115126326,
 7663,
 115279584,
 115025330,
 7656,
 -1,
 115230444,
 7657,
 -63775,
 115268399,
 7654,
 -63774,
 115396876,
 7665,
 -63773,
 115447662,
 7662,
 -63772,
 115507956,
 7648,
 -63771,
 115567413,
 7644,
 -63770,
 115631349,
 7640,
 -63769,
 115691320,
 7642,
 -1,
 115747719,
 7639,
 115998719,
 113538361,
 -1,
 -63766,
 115908865,
 7650,
 -63765,
 115966708,
 7649,
 -63764,
 116030143,
 7647,
 -63763,
 116092615,
 7646,
 -1,
 116150072,
 7643,
 116328183,
 113459592,
 -1,
 116393718,
 116260864,
 -1,
 116459253,
 116335227,
 -1,
 116524788,
 116414097,
 -1,
 -63757,
 116467596,
 852,
 -1,
 116529697,
 7678,
 -1,
 116457839,
 8430,
 -1,
 116413687,
 849,
 -1,
 116380145,
 8429,
 116918012,
 116285273,
 -1,
 116983547,
 116860072,
 -1,
 -63750,
 116959082,
 65064,
 -1,
 117011101,
 65063,
 -1,
 116939799,
 6841,
 -1,
 116887155,
 8427,
 117311276,
 113391069,
 -1,
 117376792,
 117259836,
 -1,
 117442327,
 117361835,
 -1,
 117507854,
 117389532,
 -1,
 117573380,
 117488155,
 -1,
 -63741,
 117560842,
 43234,
 -1,
 117594944,
 43235,
 117769991,
 117550476,
 -1,
 -63738,
 117729667,
 43238,
 -1,
 117786591,
 43239,
 117966602,
 117721528,
 -1,
 -63735,
 117937092,
 43236,
 -1,
 117991633,
 43237,
 -63733,
 117955569,
 43232,
 -63732,
 118132148,
 43233,
 -63731,
 118195760,
 43241,
 -1,
 118243893,
 43240,
 118425366,
 117470428,
 -1,
 -63728,
 118411070,
 43248,
 -63727,
 118473930,
 43243,
 -63726,
 118530427,
 43247,
 -63725,
 118593500,
 43246,
 -63724,
 118653777,
 43245,
 -63723,
 118713223,
 43244,
 -1,
 118757615,
 43242,
 -1,
 118403733,
 43249,
 -1,
 117404873,
 7675,
 119080747,
 117344682,
 -1,
 119146277,
 119064043,
 -1,
 119211812,
 119078912,
 -1,
 119277341,
 119175998,
 862,
 -1,
 119210351,
 863,
 119408415,
 119220865,
 861,
 -1,
 119341423,
 860,
 -63712,
 119384433,
 858,
 -63711,
 119511294,
 6844,
 -63710,
 119574579,
 6840,
 -63709,
 119629177,
 7676,
 -1,
 119680990,
 7629,
 -1,
 119158259,
 6832,
 119932714,
 119126555,
 -1,
 119998249,
 119913432,
 -1,
 -63704,
 119952195,
 7616,
 -1,
 120003319,
 7617,
 -1,
 119930892,
 856,
 -1,
 119920104,
 6835,
 -1,
 119037271,
 6833,
 120391481,
 117286726,
 -1,
 120457016,
 120324096,
 -1,
 120522551,
 120398459,
 -1,
 120588086,
 120477329,
 -1,
 120653621,
 120527087,
 -1,
 120719156,
 120620013,
 -1,
 -63693,
 120703286,
 854,
 -1,
 120732759,
 7679,
 -1,
 120662594,
 848,
 -1,
 120596364,
 853,
 -1,
 120521071,
 8431,
 -1,
 120476919,
 855,
 -1,
 120443377,
 8428,
 121243458,
 120359338,
 -1,
 121308992,
 121205093,
 -1,
 -63684,
 121297855,
 66424,
 -63683,
 121352902,
 66426,
 -63682,
 121406699,
 66425,
 -63681,
 121452989,
 66423,
 -1,
 121511709,
 66422,
 -63679,
 121280982,
 6839,
 -1,
 121656029,
 7630,
 121833292,
 121207614,
 -1,
 121898824,
 121765888,
 -1,
 121964358,
 121874271,
 65061,
 -1,
 121897327,
 65068,
 122159103,
 121926291,
 65060,
 -1,
 122028399,
 65067,
 122290175,
 121835042,
 -1,
 -63670,
 122180413,
 7622,
 -63669,
 122235521,
 7628,
 -1,
 122297073,
 7620,
 122488660,
 121772271,
 -1,
 122554192,
 122468185,
 -1,
 -63665,
 122496908,
 857,
 -1,
 122559009,
 8432,
 122750803,
 122500543,
 -1,
 -63662,
 122714942,
 7623,
 -1,
 122770256,
 7625,
 -1,
 122714130,
 7677,
 123012952,
 122471626,
 -1,
 -63658,
 122989969,
 7634,
 -63657,
 123052294,
 7633,
 -1,
 123115436,
 7669,
 123275101,
 122993179,
 -1,
 123340636,
 123232470,
 -1,
 -63653,
 123316074,
 65066,
 -1,
 123368093,
 65065,
 -1,
 123316762,
 6836,
 123602785,
 123252108,
 -1,
 -63649,
 123587596,
 7619,
 -63648,
 123650709,
 6842,
 -1,
 123700092,
 7618,
 123864933,
 123574513,
 -1,
 -63645,
 123836046,
 6846,
 -63644,
 123873164,
 6845,
 -1,
 123935265,
 6843,
 124127080,
 123853923,
 -1,
 -63641,
 124069772,
 7631,
 -1,
 124131873,
 859,
 124323691,
 124114909,
 -1,
 -63638,
 124260239,
 6837,
 -1,
 124322159,
 851,
 124520302,
 124280017,
 -1,
 -63635,
 124497305,
 7632,
 -1,
 124552526,
 6834,
 -63633,
 124507174,
 6838,
 -63632,
 124668590,
 850,
 -1,
 124725921,
 7627,
 -1,
 103783951,
 128476,
 124979270,
 103718534,
 -1,
 125044676,
 124956044,
 -1,
 125110202,
 125008910,
 -1,
 125175692,
 125077930,
 11423,
 125241227,
 125137225,
 -1,
 125306757,
 125186833,
 -1,
 125372285,
 125260834,
 -1,
 125437819,
 125311215,
 11471,
 -1,
 125418011,
 11477,
 -63620,
 125407607,
 11469,
 -1,
 125518378,
 11475,
 125699968,
 125349942,
 -1,
 -63617,
 125657375,
 11483,
 -1,
 125714986,
 11461,
 -63615,
 125669301,
 11455,
 -63614,
 125849643,
 11479,
 -63613,
 125912753,
 11463,
 -63612,
 125974910,
 11481,
 -1,
 126033139,
 11445,
 126287871,
 125274312,
 -1,
 126289801,
 126190324,
 -1,
 -63608,
 126278172,
 11489,
 -1,
 126308883,
 11487,
 -63606,
 126276115,
 11491,
 -1,
 126464368,
 11485,
 -1,
 125211459,
 11441,
 126683027,
 125122013,
 -1,
 126748562,
 126639498,
 -1,
 -63601,
 126715375,
 11451,
 -63600,
 126774261,
 11449,
 -63599,
 126835261,
 11467,
 -1,
 126885364,
 11443,
 -1,
 126688747,
 11399,
 127141786,
 126628714,
 -1,
 127207321,
 127130349,
 -1,
 -63594,
 127185175,
 11500,
 -63593,
 127239663,
 11453,
 -63592,
 127291435,
 11502,
 -1,
 127353393,
 11447,
 -1,
 127177286,
 11459,
 127600542,
 127118732,
 -1,
 -63588,
 127570755,
 11403,
 -63587,
 127623455,
 11429,
 -1,
 127672076,
 11457,
 127862690,
 127560501,
 -1,
 -63584,
 127840794,
 11421,
 -63583,
 127883233,
 11437,
 -1,
 127934646,
 11413,
 128124837,
 127842843,
 -1,
 -63580,
 128079774,
 11409,
 -1,
 128132294,
 11431,
 128321448,
 128096110,
 -1,
 -63577,
 128299546,
 11439,
 -1,
 128343249,
 11425,
 128518059,
 128282311,
 -1,
 -63574,
 128460012,
 11415,
 -1,
 128519996,
 11473,
 128714670,
 128456943,
 -1,
 -63571,
 128677263,
 11393,
 -1,
 128740678,
 11465,
 -63569,
 128703423,
 11405,
 -63568,
 128896846,
 11395,
 -63567,
 128959843,
 11433,
 -63566,
 129018648,
 11427,
 -63565,
 129074671,
 11419,
 -63564,
 129138464,
 11417,
 -63563,
 129195524,
 11411,
 -63562,
 129259092,
 11407,
 -63561,
 129323019,
 11397,
 -63560,
 129387290,
 11435,
 -63559,
 129450545,
 11401,
 -1,
 129509805,
 11507,
 129761279,
 125098609,
 -1,
 129763262,
 129674636,
 -1,
 -63555,
 129743757,
 11495,
 -1,
 129783997,
 11498,
 129959873,
 129723189,
 -1,
 -63552,
 129914852,
 11497,
 -1,
 129965247,
 11492,
 -63550,
 129940358,
 11496,
 -63549,
 130128620,
 11494,
 -1,
 130187047,
 11493,
 130353168,
 124988290,
 -1,
 130418699,
 130293975,
 -1,
 130484189,
 130386346,
 11422,
 130549724,
 130445641,
 -1,
 130615254,
 130495249,
 -1,
 130680782,
 130569250,
 -1,
 130746316,
 130619631,
 11470,
 -1,
 130726427,
 11476,
 -63539,
 130716023,
 11468,
 -1,
 130826794,
 11474,
 131008465,
 130658358,
 -1,
 -63536,
 130965791,
 11482,
 -1,
 131023402,
 11460,
 -63534,
 130977717,
 11454,
 -63533,
 131158059,
 11478,
 -63532,
 131221169,
 11462,
 -63531,
 131283326,
 11480,
 -1,
 131341555,
 11444,
 131596287,
 130582728,
 -1,
 131598298,
 131498740,
 -1,
 -63527,
 131586588,
 11488,
 -1,
 131617299,
 11486,
 -63525,
 131584531,
 11490,
 -1,
 131772784,
 11484,
 -1,
 130519875,
 11440,
 131991524,
 130430429,
 -1,
 132057059,
 131947914,
 -1,
 -63520,
 132023791,
 11450,
 -63519,
 132082677,
 11448,
 -63518,
 132143677,
 11466,
 -1,
 132193780,
 11442,
 -1,
 131997163,
 11398,
 132450283,
 131937130,
 -1,
 132515818,
 132438765,
 -1,
 -63513,
 132493591,
 11499,
 -63512,
 132548079,
 11452,
 -63511,
 132599851,
 11501,
 -1,
 132661809,
 11446,
 -1,
 132485702,
 11458,
 132909039,
 132427148,
 -1,
 -63507,
 132879171,
 11402,
 -63506,
 132931871,
 11428,
 -1,
 132980492,
 11456,
 133171187,
 132868917,
 -1,
 -63503,
 133149210,
 11420,
 -63502,
 133191649,
 11436,
 -1,
 133243062,
 11412,
 133433334,
 133151259,
 -1,
 -63499,
 133388190,
 11408,
 -1,
 133440710,
 11430,
 133629945,
 133404526,
 -1,
 -63496,
 133607962,
 11438,
 -1,
 133651665,
 11424,
 133826556,
 133590727,
 -1,
 -63493,
 133768428,
 11414,
 -1,
 133828412,
 11472,
 134023167,
 133765359,
 -1,
 -63490,
 133985679,
 11392,
 -1,
 134049094,
 11464,
 -63488,
 134011839,
 11404,
 -63487,
 134205262,
 11394,
 -63486,
 134268259,
 11432,
 -63485,
 134327064,
 11426,
 -63484,
 134383087,
 11418,
 -63483,
 134446880,
 11416,
 -63482,
 134503940,
 11410,
 -63481,
 134567508,
 11406,
 -63480,
 134631435,
 11396,
 -63479,
 134695706,
 11434,
 -63478,
 134758961,
 11400,
 -1,
 134818221,
 11506,
 135069695,
 130387172,
 -1,
 135071759,
 134985207,
 -1,
 -63474,
 135034023,
 11505,
 -1,
 135078773,
 11504,
 -1,
 135038450,
 11503,
 135333949,
 130303255,
 -1,
 135399471,
 135301344,
 -1,
 135464986,
 135379483,
 -1,
 135530518,
 135450892,
 -1,
 -63467,
 135498162,
 66292,
 -1,
 135546068,
 66283,
 135727129,
 135484450,
 -1,
 -63464,
 135701748,
 66293,
 -1,
 135751489,
 66284,
 -1,
 135676772,
 66282,
 135989281,
 135441804,
 -1,
 136054814,
 135948675,
 -1,
 -63459,
 136037555,
 66287,
 -1,
 136053595,
 66296,
 136314879,
 136005599,
 -1,
 -63456,
 136234163,
 66288,
 -1,
 136250203,
 66297,
 136448040,
 135940536,
 -1,
 136513573,
 136415658,
 -1,
 -63452,
 136497864,
 66294,
 -1,
 136555764,
 66285,
 136773631,
 136469713,
 -1,
 -63449,
 136695156,
 66295,
 -1,
 136728351,
 66286,
 136906795,
 136414768,
 -1,
 -63446,
 136889523,
 66290,
 -1,
 136905563,
 66299,
 137103406,
 136856117,
 -1,
 -63443,
 137091283,
 66289,
 -1,
 137102171,
 66298,
 -1,
 137072089,
 66291,
 137365564,
 135346396,
 -1,
 137431091,
 137345563,
 -1,
 -63438,
 137418250,
 66274,
 -1,
 137452352,
 66275,
 137627702,
 137407884,
 -1,
 -63435,
 137587075,
 66278,
 -1,
 137643999,
 66279,
 137824313,
 137578936,
 -1,
 -63432,
 137794500,
 66276,
 -1,
 137849041,
 66277,
 -63430,
 137792948,
 66273,
 -63429,
 137987632,
 66281,
 -1,
 138035765,
 66280,
 -1,
 137346482,
 66272,
 138283074,
 135302209,
 -1,
 -63425,
 138268200,
 11516,
 -63424,
 138306200,
 11515,
 -63423,
 138366759,
 11513,
 -1,
 138426662,
 11514,
 138610757,
 138234296,
 -1,
 -63420,
 138594221,
 11518,
 -1,
 138650013,
 11517,
 -1,
 138576280,
 11519,
 138872932,
 124961994,
 -1,
 138938466,
 138840218,
 -1,
 139003989,
 138922211,
 -1,
 139069516,
 138983963,
 -1,
 -63413,
 139056650,
 119649,
 -1,
 139090752,
 119650,
 139266127,
 139046284,
 -1,
 -63410,
 139225475,
 119653,
 -1,
 139282399,
 119654,
 139462738,
 139217336,
 -1,
 -63407,
 139432900,
 119651,
 -1,
 139487441,
 119652,
 -63405,
 139431348,
 119648,
 -63404,
 139626032,
 119656,
 -1,
 139674165,
 119655,
 139919359,
 138984530,
 -1,
 139921497,
 139835931,
 -1,
 -63400,
 139908618,
 119658,
 -1,
 139942720,
 119659,
 140118108,
 139898252,
 -1,
 -63397,
 140077443,
 119662,
 -1,
 140134367,
 119663,
 140314719,
 140069304,
 -1,
 -63394,
 140284868,
 119660,
 -1,
 140339409,
 119661,
 -63392,
 140283316,
 119657,
 -63391,
 140478000,
 119665,
 -1,
 140526133,
 119664,
 -63389,
 138910607,
 128145,
 -1,
 140652019,
 128715,
 140839024,
 138838772,
 -1,
 140904553,
 140790200,
 -1,
 -63385,
 140889027,
 128533,
 -63384,
 140940206,
 128534,
 -1,
 140986172,
 127882,
 141166700,
 140886663,
 -1,
 -63381,
 141144056,
 983186,
 -1,
 141192679,
 127899,
 141363311,
 141146277,
 -1,
 -63378,
 141350774,
 128119,
 -1,
 141406858,
 128679,
 -1,
 141348323,
 127978,
 141625461,
 140807101,
 -1,
 141690996,
 141581521,
 -1,
 -63373,
 141657448,
 127859,
 -1,
 141704764,
 127850,
 -1,
 141639862,
 127834,
 141953143,
 141611276,
 128004,
 -1,
 141886172,
 128046,
 -63368,
 141916133,
 128165,
 -63367,
 142035717,
 9904,
 -1,
 142094483,
 127864,
 142281157,
 103633954,
 -1,
 142346573,
 142219503,
 -1,
 142412009,
 142310081,
 -1,
 142477504,
 142374108,
 -1,
 142542986,
 142428999,
 -1,
 142608513,
 142508788,
 43590,
 -1,
 142561080,
 43586,
 -63358,
 142596307,
 43592,
 -63357,
 142719515,
 43589,
 -63356,
 142784115,
 43595,
 -63355,
 142844161,
 43593,
 -63354,
 142907246,
 43591,
 -63353,
 142962375,
 43594,
 -63352,
 143026997,
 43584,
 -63351,
 143085368,
 43585,
 -1,
 143142384,
 43588,
 143329428,
 142508788,
 -1,
 143394959,
 143283234,
 -1,
 -63347,
 143378165,
 43536,
 -63346,
 143419943,
 43538,
 -1,
 143464687,
 43537,
 143657106,
 143347512,
 -1,
 -63343,
 143640309,
 43530,
 -1,
 143661295,
 43531,
 -63341,
 143640309,
 43543,
 -1,
 143792367,
 43544,
 143984792,
 143300462,
 -1,
 -63338,
 143955932,
 43547,
 -63337,
 144004152,
 43548,
 -1,
 144054511,
 43546,
 144246940,
 143930845,
 -1,
 -63334,
 144200760,
 43542,
 -63333,
 144258667,
 43545,
 -1,
 144316655,
 43541,
 144509088,
 144188850,
 -1,
 -63330,
 144462904,
 43550,
 -63329,
 144516583,
 43553,
 -1,
 144578799,
 43549,
 144771235,
 144488987,
 -1,
 -63326,
 144725048,
 43540,
 -1,
 144775407,
 43539,
 144967846,
 144747916,
 -1,
 -63323,
 144944671,
 43558,
 -1,
 144972015,
 43559,
 145164457,
 144931519,
 -1,
 -63320,
 145147637,
 43551,
 -1,
 145168623,
 43552,
 145361068,
 145124149,
 -1,
 -63317,
 145314872,
 43527,
 -1,
 145365231,
 43526,
 145557679,
 145320457,
 -1,
 -63314,
 145511480,
 43535,
 -1,
 145561839,
 43534,
 145754290,
 145510200,
 -1,
 -63311,
 145708088,
 43529,
 -1,
 145758447,
 43528,
 145950901,
 145698288,
 -1,
 -63308,
 145904696,
 43533,
 -1,
 145955055,
 43532,
 146147511,
 145889519,
 43520,
 -1,
 146103505,
 43524,
 -63304,
 146135340,
 43554,
 -63303,
 146263184,
 43557,
 -63302,
 146326730,
 43522,
 -63301,
 146383227,
 43555,
 -63300,
 146442666,
 43525,
 -63299,
 146501381,
 43556,
 -63298,
 146562257,
 43521,
 -63297,
 146625592,
 43560,
 -1,
 146685500,
 43523,
 146868428,
 142463128,
 -1,
 146933957,
 146807023,
 -1,
 -63293,
 146916554,
 43569,
 -63292,
 146955473,
 43568,
 -1,
 147003631,
 43561,
 147196103,
 146916554,
 43565,
 -1,
 147144252,
 43570,
 147327177,
 147163562,
 43567,
 -1,
 147275324,
 43566,
 147458251,
 147283153,
 43562,
 -1,
 147414225,
 43563,
 -1,
 147407402,
 43564,
 147654874,
 146815196,
 -1,
 147720400,
 147634715,
 -1,
 -63281,
 147707402,
 43602,
 -1,
 147741504,
 43603,
 147917011,
 147697036,
 -1,
 -63278,
 147876227,
 43606,
 -1,
 147933151,
 43607,
 148113622,
 147868088,
 -1,
 -63275,
 148083652,
 43604,
 -1,
 148138193,
 43605,
 -63273,
 148102129,
 43600,
 -63272,
 148278708,
 43601,
 -63271,
 148342320,
 43609,
 -1,
 148390453,
 43608,
 148572387,
 147599956,
 -1,
 148637919,
 148523847,
 -1,
 -63267,
 148604264,
 43587,
 -63266,
 148667071,
 43596,
 -1,
 148722722,
 43597,
 -63264,
 148625708,
 43571,
 -63263,
 148885836,
 43574,
 -63262,
 148939131,
 43572,
 -1,
 148991749,
 43573,
 149225471,
 148545215,
 -1,
 149227751,
 149108189,
 -1,
 -63258,
 149197645,
 43614,
 -1,
 149233581,
 43613,
 -63256,
 149209698,
 43615,
 -1,
 149403108,
 43612,
 149555523,
 142372316,
 -1,
 149621019,
 149517532,
 -1,
 149686513,
 149600795,
 -1,
 149752047,
 149666331,
 -1,
 -63250,
 149705805,
 69906,
 -1,
 149756317,
 69905,
 -63248,
 149705805,
 69911,
 -1,
 149887389,
 69910,
 150079734,
 149652212,
 -1,
 -63245,
 150067503,
 69904,
 -63244,
 150111075,
 69909,
 -63243,
 150163338,
 69899,
 -1,
 150215069,
 69914,
 150407420,
 150025693,
 -1,
 150472954,
 150353373,
 -1,
 -63239,
 150426701,
 69908,
 -1,
 150477213,
 69907,
 -63237,
 150426701,
 69913,
 -1,
 150608285,
 69912,
 150800639,
 150395091,
 -1,
 -63234,
 150788399,
 69920,
 -1,
 150804893,
 69921,
 150997250,
 150771566,
 -1,
 -63231,
 150950989,
 69916,
 -1,
 151001501,
 69915,
 151193861,
 150956853,
 -1,
 -63228,
 151147597,
 69896,
 -1,
 151198109,
 69895,
 151390472,
 151153161,
 -1,
 -63225,
 151344205,
 69903,
 -1,
 151394717,
 69902,
 151587083,
 151342904,
 -1,
 -63222,
 151540813,
 69898,
 -1,
 151591325,
 69897,
 151783694,
 151530370,
 -1,
 -63219,
 151737421,
 69901,
 -1,
 151787933,
 69900,
 151980305,
 151725490,
 -1,
 -63216,
 151934029,
 69918,
 -1,
 151984541,
 69917,
 -63214,
 151966031,
 69924,
 -63213,
 152159434,
 69893,
 -63212,
 152219183,
 69925,
 -63211,
 152281490,
 69922,
 -63210,
 152337176,
 69919,
 -63209,
 152399637,
 69923,
 -63208,
 152460497,
 69892,
 -63207,
 152523853,
 69926,
 -63206,
 152583740,
 69894,
 -1,
 152639901,
 69891,
 152832300,
 149566941,
 -1,
 152897834,
 152789078,
 -1,
 152963360,
 152877595,
 -1,
 -63201,
 152950282,
 69944,
 -1,
 152984384,
 69945,
 153159971,
 152939916,
 -1,
 -63198,
 153119107,
 69948,
 -1,
 153176031,
 69949,
 153356582,
 153110968,
 -1,
 -63195,
 153326532,
 69946,
 -1,
 153381073,
 69947,
 -63193,
 153345009,
 69942,
 -63192,
 153521588,
 69943,
 -63191,
 153585200,
 69951,
 -1,
 153633333,
 69950,
 -63189,
 152867661,
 69954,
 -1,
 153755565,
 69953,
 153946425,
 152816762,
 -1,
 154011960,
 153917166,
 -1,
 154077489,
 153950447,
 69927,
 -63184,
 154059978,
 69935,
 -1,
 154098897,
 69933,
 154274099,
 154059978,
 69930,
 -1,
 154256586,
 69931,
 154405173,
 154241450,
 69934,
 -1,
 154361041,
 69936,
 154536247,
 154361041,
 69928,
 -1,
 154492113,
 69929,
 -1,
 154484284,
 69932,
 -1,
 153970349,
 69939,
 154798399,
 153922956,
 -1,
 154863934,
 154755181,
 -1,
 -63172,
 154849150,
 69890,
 -63171,
 154872905,
 69888,
 -1,
 154935462,
 69889,
 -1,
 154812515,
 69952,
 -63168,
 154771631,
 69955,
 -63167,
 155158986,
 69937,
 -63166,
 155220770,
 69940,
 -1,
 155264216,
 69938,
 155453772,
 149528833,
 -1,
 155519304,
 155433618,
 -1,
 155584839,
 155503274,
 128200,
 -1,
 155517149,
 128185,
 -1,
 155532633,
 128201,
 155844607,
 155458272,
 983058,
 155910143,
 155713536,
 -1,
 -63157,
 155833520,
 983139,
 -1,
 155889687,
 983136,
 -1,
 155411634,
 9939,
 156109245,
 142294588,
 -1,
 156174775,
 156082433,
 -1,
 156240308,
 156142567,
 -1,
 156305843,
 156218446,
 -1,
 156371299,
 156285467,
 -1,
 156436825,
 156347788,
 -1,
 -63148,
 156421242,
 43960,
 -63147,
 156484810,
 43959,
 -63146,
 156535210,
 43958,
 -63145,
 156589265,
 43957,
 -63144,
 156646972,
 43956,
 -1,
 156702959,
 43955,
 156895584,
 156397255,
 -1,
 -63141,
 156879994,
 43954,
 -63140,
 156943562,
 43953,
 -63139,
 156993962,
 43952,
 -63138,
 157048017,
 43951,
 -63137,
 157105724,
 43950,
 -1,
 157161711,
 43949,
 -63135,
 156851409,
 43944,
 -63134,
 157302332,
 43942,
 -1,
 157358319,
 43940,
 157550954,
 156347788,
 43933,
 -63131,
 157535354,
 43938,
 -63130,
 157598922,
 43937,
 -63129,
 157649322,
 43936,
 -63128,
 157703377,
 43935,
 -63127,
 157761084,
 43934,
 -1,
 157817071,
 43932,
 158009714,
 157516532,
 -1,
 158075245,
 157948143,
 43918,
 -1,
 158028834,
 43920,
 -63122,
 158059642,
 43925,
 -63121,
 158188746,
 43924,
 -63120,
 158239146,
 43923,
 -63119,
 158293201,
 43922,
 -1,
 158350908,
 43921,
 158534010,
 157963298,
 -1,
 -63116,
 158518394,
 43906,
 -63115,
 158581962,
 43905,
 -63114,
 158632362,
 43904,
 -63113,
 158696273,
 43919,
 -63112,
 158751953,
 43903,
 -63111,
 158809660,
 43902,
 -1,
 158865647,
 43901,
 159058306,
 158479837,
 -1,
 -63108,
 159042682,
 43947,
 -63107,
 159106250,
 43946,
 -63106,
 159156650,
 43945,
 -63105,
 159215365,
 43948,
 -63104,
 159276241,
 43943,
 -63103,
 159333948,
 43941,
 -1,
 159389935,
 43939,
 159582601,
 159045843,
 -1,
 -63100,
 159566970,
 5116,
 -63099,
 159630538,
 5115,
 -63098,
 159680938,
 5114,
 -63097,
 159734993,
 5113,
 -63096,
 159792700,
 5112,
 -1,
 159848687,
 43967,
 160041360,
 159568140,
 -1,
 -63093,
 160025722,
 43966,
 -63092,
 160089290,
 43965,
 -63091,
 160139690,
 43964,
 -63090,
 160193745,
 43963,
 -63089,
 160251452,
 43962,
 -1,
 160307439,
 43961,
 160500119,
 160014273,
 -1,
 -63086,
 160484474,
 43931,
 -63085,
 160548042,
 43930,
 -63084,
 160598442,
 43929,
 -63083,
 160652497,
 43928,
 -63082,
 160710204,
 43927,
 -1,
 160766191,
 43926,
 160958878,
 160463551,
 -1,
 -63079,
 160943226,
 5117,
 -63078,
 161006794,
 43917,
 -63077,
 161057194,
 43916,
 -63076,
 161111249,
 43915,
 -63075,
 161168956,
 43914,
 -1,
 161224943,
 43913,
 161417637,
 160919239,
 -1,
 -63072,
 161401978,
 43912,
 -63071,
 161465546,
 43911,
 -63070,
 161515946,
 43910,
 -63069,
 161570001,
 43909,
 -63068,
 161627708,
 43908,
 -1,
 161683695,
 43907,
 161876396,
 161369912,
 -1,
 -63065,
 161860730,
 43900,
 -63064,
 161924298,
 43899,
 -63063,
 161974698,
 43898,
 -63062,
 162028753,
 43897,
 -63061,
 162086460,
 43896,
 -1,
 162142447,
 43894,
 -63059,
 161860730,
 43893,
 -63058,
 162317514,
 43892,
 -63057,
 162367914,
 43891,
 -63056,
 162425735,
 43895,
 -63055,
 162487505,
 43890,
 -63054,
 162545212,
 43889,
 -1,
 162601199,
 43888,
 -1,
 156267797,
 5109,
 162922495,
 156213505,
 -1,
 -63050,
 162846947,
 127800,
 -1,
 162881296,
 127826,
 163056058,
 156122684,
 -1,
 -63047,
 163032894,
 129472,
 -1,
 163096990,
 128227,
 -63045,
 163035042,
 127792,
 -63044,
 163225754,
 127937,
 -1,
 163262573,
 128638,
 163449282,
 156064977,
 -1,
 -63041,
 163425150,
 9911,
 -63040,
 163486782,
 128063,
 -63039,
 163541408,
 128696,
 -1,
 163590248,
 128020,
 -63037,
 163433216,
 9962,
 -63036,
 163752620,
 127876,
 -1,
 163809901,
 127851,
 163973847,
 142219503,
 -1,
 164039230,
 163939060,
 983098,
 164104759,
 163978074,
 -1,
 164170200,
 164071850,
 -1,
 164235735,
 164129442,
 -1,
 164301264,
 164201204,
 6361,
 164429823,
 164286732,
 -1,
 164432334,
 164333994,
 6347,
 -1,
 164399530,
 6349,
 164626431,
 164388049,
 6343,
 -1,
 164519121,
 6345,
 164694482,
 164277644,
 6362,
 -1,
 164647970,
 6363,
 -63021,
 164674075,
 6357,
 -63020,
 164796270,
 6356,
 -63019,
 164854463,
 6360,
 -63018,
 164916021,
 6358,
 -1,
 164965250,
 6359,
 -1,
 164223187,
 6320,
 165218793,
 164155660,
 -1,
 165284323,
 165187398,
 -1,
 165349858,
 165265010,
 -1,
 165415389,
 165317034,
 5754,
 -1,
 165382570,
 5755,
 165546463,
 165371089,
 5752,
 -1,
 165502161,
 5753,
 165677537,
 165484783,
 5756,
 -1,
 165615855,
 5757,
 -1,
 165626093,
 5751,
 -1,
 165301105,
 5758,
 165939688,
 165234372,
 -1,
 166005223,
 165875289,
 -1,
 -63002,
 165973817,
 6369,
 -1,
 166009245,
 6370,
 -1,
 165955138,
 6365,
 -1,
 165881203,
 6323,
 166332918,
 165195148,
 -1,
 166398449,
 166274419,
 6335,
 166526975,
 166356857,
 -1,
 166529519,
 166441014,
 -1,
 -62994,
 166515310,
 6378,
 -1,
 166563641,
 6379,
 -62992,
 166488877,
 6385,
 -1,
 166681069,
 6380,
 166857205,
 166351906,
 -1,
 -62989,
 166844285,
 6338,
 -62988,
 166893362,
 6336,
 -1,
 166929779,
 6337,
 -1,
 166827826,
 6334,
 167184898,
 166312475,
 -1,
 167250427,
 167165137,
 -1,
 -62983,
 167236206,
 6373,
 -62982,
 167284537,
 6374,
 -1,
 167319965,
 6375,
 167512574,
 167212450,
 -1,
 -62979,
 167498350,
 6376,
 -1,
 167546681,
 6377,
 167709185,
 167468197,
 -1,
 -62976,
 167657020,
 6371,
 -1,
 167713007,
 6372,
 -1,
 167650675,
 6327,
 167971340,
 167158017,
 -1,
 168036874,
 167956748,
 -1,
 168102406,
 168004010,
 6353,
 -1,
 168069546,
 6354,
 168233480,
 168058065,
 6351,
 -1,
 168189137,
 6352,
 -62967,
 168181997,
 6350,
 -1,
 168302831,
 6355,
 -62965,
 167978355,
 6341,
 -1,
 168431201,
 6368,
 168626708,
 167936756,
 -1,
 168692242,
 168612108,
 -1,
 168757776,
 168659370,
 6346,
 -1,
 168724906,
 6348,
 168951807,
 168713425,
 6342,
 -1,
 168844497,
 6344,
 -62957,
 168662834,
 6331,
 -1,
 168961395,
 6332,
 169151006,
 168570057,
 -1,
 169216538,
 169103160,
 -1,
 169282073,
 169201932,
 -1,
 -62952,
 169264330,
 6381,
 -1,
 169285871,
 6384,
 -1,
 169220509,
 6383,
 169544221,
 169162638,
 -1,
 -62948,
 169524017,
 6389,
 -1,
 169557639,
 6382,
 -1,
 169503537,
 6386,
 169806370,
 169121646,
 -1,
 -62944,
 169793405,
 6326,
 -62943,
 169842482,
 6324,
 -1,
 169878899,
 6325,
 170068519,
 169747890,
 -1,
 170134054,
 170016807,
 -1,
 -62939,
 170107137,
 6388,
 -1,
 170159815,
 6387,
 -1,
 170094430,
 5759,
 170396202,
 170055891,
 -1,
 -62935,
 170366770,
 6339,
 -1,
 170403187,
 6340,
 170592813,
 170355509,
 -1,
 -62932,
 170578505,
 6329,
 -1,
 170599795,
 6328,
 170789424,
 170543943,
 -1,
 -62929,
 170767517,
 6366,
 -1,
 170828278,
 6367,
 170986035,
 170727663,
 -1,
 -62926,
 170973395,
 6321,
 -1,
 170993011,
 6322,
 -62924,
 170949929,
 6330,
 -62923,
 171143462,
 6333,
 -62922,
 171203786,
 5120,
 -1,
 171261943,
 6364,
 171444794,
 164048279,
 983097,
 -62919,
 171405567,
 128473,
 -1,
 171442661,
 983170,
 171641405,
 171390429,
 -1,
 -62916,
 171628755,
 127852,
 -1,
 171667887,
 128367,
 -1,
 171608789,
 128758,
 171903612,
 164012289,
 -1,
 171969138,
 171859383,
 -1,
 172034630,
 171951306,
 66226,
 172163071,
 172016842,
 66239,
 172228607,
 172082378,
 66212,
 -62908,
 172147914,
 66235,
 -62907,
 172167925,
 66256,
 -1,
 172233168,
 66248,
 172427852,
 172010892,
 66224,
 172493385,
 172407323,
 66242,
 -1,
 172429776,
 66243,
 172624459,
 172446754,
 66222,
 -1,
 172560848,
 66223,
 -1,
 172600716,
 66232,
 172821073,
 172391103,
 66218,
 172949503,
 172762546,
 66250,
 -62897,
 172823571,
 66253,
 -62896,
 172888821,
 66252,
 -1,
 172954064,
 66251,
 173148757,
 172786420,
 66229,
 -62893,
 173114100,
 66227,
 -62892,
 173166392,
 66244,
 -1,
 173225437,
 66238,
 173410904,
 173128219,
 66221,
 173539327,
 173390363,
 66247,
 -1,
 173412816,
 66230,
 173607515,
 173371079,
 66211,
 173735935,
 173553117,
 66214,
 -1,
 173609424,
 66254,
 173804125,
 173580545,
 66213,
 -1,
 173777153,
 66249,
 173935199,
 173774702,
 66231,
 -1,
 173871568,
 66209,
 174066273,
 173894453,
 66236,
 -1,
 174002640,
 66237,
 174197347,
 174021841,
 66233,
 -1,
 174152913,
 66245,
 174328421,
 174149432,
 66240,
 -1,
 174264784,
 66241,
 174459495,
 174276156,
 66234,
 -1,
 174395856,
 66255,
 174590569,
 174405085,
 66210,
 -1,
 174526928,
 66220,
 174721644,
 174533546,
 -1,
 -62869,
 174658576,
 66246,
 -1,
 174723520,
 66225,
 174918254,
 174659823,
 66208,
 -1,
 174854608,
 66215,
 -62865,
 174905309,
 66228,
 -62864,
 175021899,
 66216,
 -62863,
 175081898,
 66219,
 -1,
 175121842,
 66217,
 175311478,
 171914719,
 -1,
 175377013,
 175268358,
 128199,
 -1,
 175309452,
 128450,
 -1,
 175328048,
 128451,
 175573625,
 175284481,
 -1,
 -62856,
 175542871,
 129365,
 -1,
 175594853,
 983073,
 -62854,
 175544225,
 127887,
 -62853,
 175740006,
 127904,
 -1,
 175769815,
 9936,
 175966920,
 171886244,
 -1,
 176032455,
 175928540,
 -1,
 176097930,
 175975298,
 -1,
 176163460,
 176051234,
 -1,
 176228994,
 176101615,
 66873,
 -1,
 176208411,
 66902,
 -62845,
 176199474,
 66889,
 -1,
 176315601,
 66890,
 176491143,
 176150828,
 -1,
 -62842,
 176478419,
 66891,
 -1,
 176541964,
 66911,
 176750591,
 176429295,
 -1,
 -62839,
 176675484,
 66912,
 -1,
 176726273,
 66882,
 176884368,
 176074124,
 -1,
 176949903,
 176837666,
 -1,
 177015438,
 176888047,
 66877,
 -1,
 176974645,
 66896,
 -1,
 176985906,
 66909,
 -1,
 176900532,
 66906,
 177277590,
 176829917,
 -1,
 177343124,
 177265455,
 -1,
 -62829,
 177330589,
 66895,
 -1,
 177350003,
 66901,
 -62827,
 177330551,
 66881,
 -1,
 177480626,
 66867,
 177670811,
 177265455,
 -1,
 177736346,
 177624098,
 -1,
 -62823,
 177692853,
 66871,
 -1,
 177740015,
 66875,
 -1,
 177676781,
 66869,
 177998495,
 177650203,
 -1,
 -62819,
 177985949,
 66899,
 -62818,
 178022783,
 66908,
 -1,
 178070280,
 66872,
 178260643,
 177954001,
 -1,
 -62815,
 178247093,
 66910,
 -62814,
 178299765,
 66876,
 -1,
 178358650,
 66879,
 178522790,
 178247891,
 -1,
 -62811,
 178493156,
 66874,
 -1,
 178529679,
 66913,
 178719401,
 178495338,
 -1,
 -62808,
 178706643,
 66887,
 -1,
 178757889,
 66893,
 178916012,
 178689902,
 -1,
 -62805,
 178874751,
 66914,
 -1,
 178930532,
 66903,
 179112623,
 178876103,
 -1,
 -62802,
 179100248,
 66885,
 -1,
 179117853,
 66878,
 179309234,
 179071797,
 -1,
 -62799,
 179267964,
 66915,
 -1,
 179314974,
 66884,
 179505845,
 179268105,
 -1,
 -62796,
 179460924,
 66883,
 -1,
 179512746,
 66897,
 179702456,
 179457848,
 -1,
 -62793,
 179659032,
 66866,
 -1,
 179722192,
 66904,
 179899067,
 179650108,
 -1,
 -62790,
 179886748,
 66870,
 -1,
 179905970,
 66868,
 180095678,
 179837167,
 -1,
 -62787,
 180064529,
 66888,
 -1,
 180124166,
 66864,
 -62785,
 180082776,
 66880,
 -62784,
 180277049,
 66907,
 -62783,
 180331271,
 66905,
 -62782,
 180391218,
 66898,
 -62781,
 180455339,
 66894,
 -62780,
 180518015,
 66892,
 -62779,
 180574165,
 66886,
 -62778,
 180636236,
 66900,
 -1,
 180692949,
 66865,
 -1,
 175976476,
 66927,
 180947661,
 175946267,
 128008,
 181075967,
 180880092,
 128049,
 181141503,
 180947714,
 -1,
 -62772,
 181065660,
 128572,
 -1,
 181124043,
 128569,
 181275345,
 180910783,
 -1,
 181340880,
 181224908,
 128247,
 -1,
 181275728,
 128248,
 -1,
 181312313,
 127957,
 181537492,
 181235399,
 -1,
 -62765,
 181497545,
 129305,
 -1,
 181552153,
 128197,
 -62763,
 181516182,
 9963,
 -62762,
 181705554,
 11839,
 -1,
 181744907,
 127797,
 181930968,
 163961043,
 -1,
 181996435,
 181905729,
 -1,
 182061883,
 181974094,
 -1,
 182127334,
 182041115,
 -1,
 182192863,
 182066789,
 -1,
 -62755,
 182180240,
 7303,
 -62754,
 182238118,
 7300,
 -1,
 182277681,
 7302,
 182455010,
 182168972,
 -1,
 -62751,
 182440558,
 42639,
 -1,
 182497079,
 42641,
 -62749,
 182440558,
 42637,
 -62748,
 182606842,
 7301,
 -62747,
 182664968,
 42635,
 -1,
 182726208,
 42643,
 182913779,
 182072797,
 -1,
 182979309,
 182901551,
 -1,
 183044843,
 182967087,
 -1,
 -62742,
 182998657,
 1323,
 -1,
 183057980,
 42633,
 -62740,
 183030382,
 42627,
 -1,
 183190285,
 42563,
 183372528,
 182948678,
 -1,
 -62737,
 183339434,
 42649,
 -1,
 183402851,
 42605,
 -62735,
 183358062,
 42625,
 -62734,
 183528079,
 42569,
 -1,
 183578176,
 1325,
 183765755,
 182886657,
 -1,
 183831289,
 183715924,
 -1,
 -62730,
 183819215,
 1297,
 -62729,
 183884575,
 42581,
 -62728,
 183943867,
 42593,
 -1,
 183975475,
 42565,
 -62726,
 183800762,
 7296,
 -1,
 184112184,
 1303,
 184290052,
 183741836,
 -1,
 184355585,
 184257290,
 -1,
 184421120,
 184303164,
 -1,
 -62721,
 184384191,
 42599,
 -1,
 184446663,
 42597,
 -1,
 184366909,
 42595,
 184745983,
 184308770,
 -1,
 -62717,
 184668782,
 42647,
 -1,
 184702011,
 1319,
 184879884,
 184237628,
 -1,
 184945417,
 184839909,
 -1,
 -62713,
 184909685,
 1313,
 -62712,
 184965617,
 1299,
 -1,
 185022416,
 1327,
 185270271,
 184910627,
 -1,
 -62709,
 185171829,
 1315,
 -1,
 185234143,
 1321,
 185404178,
 184837703,
 -1,
 185469713,
 185360171,
 -1,
 -62705,
 185457040,
 42579,
 -62704,
 185479388,
 42589,
 -1,
 185538799,
 42583,
 -1,
 185407727,
 42567,
 185797398,
 185391315,
 -1,
 -62700,
 185762548,
 42591,
 -62699,
 185812603,
 42577,
 -1,
 185867119,
 1305,
 186059547,
 185750562,
 -1,
 186125082,
 185997669,
 -1,
 -62695,
 186103876,
 1279,
 -1,
 186145265,
 1277,
 -1,
 186110574,
 42645,
 186387231,
 186002306,
 -1,
 -62691,
 186362840,
 42651,
 -62690,
 186415299,
 42585,
 -1,
 186461760,
 42631,
 186649379,
 186328498,
 -1,
 -62687,
 186624803,
 42573,
 -62686,
 186676360,
 42587,
 -1,
 186737816,
 42603,
 186911526,
 186637103,
 -1,
 -62683,
 186866875,
 42629,
 -1,
 186925904,
 42561,
 187108137,
 186896652,
 -1,
 -62680,
 187063983,
 7299,
 -1,
 187121212,
 1309,
 187304748,
 187078510,
 -1,
 -62677,
 187252458,
 1317,
 -1,
 187309707,
 1231,
 187501359,
 187269876,
 -1,
 -62674,
 187451344,
 42575,
 -1,
 187507336,
 7298,
 187697970,
 187466078,
 -1,
 -62671,
 187650832,
 42571,
 -1,
 187708704,
 42601,
 187894581,
 187657927,
 -1,
 -62668,
 187862698,
 7297,
 -1,
 187913272,
 1301,
 188091192,
 187847061,
 -1,
 -62665,
 188069971,
 1275,
 -1,
 188102608,
 1271,
 -62663,
 188074055,
 7304,
 -62662,
 188260202,
 1307,
 -1,
 188292636,
 1311,
 188484494,
 182004882,
 -1,
 188549961,
 188429789,
 -1,
 188615491,
 188537647,
 -1,
 188681025,
 188603183,
 -1,
 -62656,
 188634753,
 1322,
 -1,
 188694076,
 42632,
 -62654,
 188666478,
 42626,
 -1,
 188826381,
 42562,
 189008710,
 188584774,
 -1,
 -62651,
 188975530,
 42648,
 -1,
 189038947,
 42604,
 -62649,
 188994158,
 42624,
 -62648,
 189164175,
 42568,
 -1,
 189214272,
 1324,
 189401936,
 188529179,
 -1,
 189467469,
 189377932,
 -1,
 -62644,
 189452910,
 42638,
 -1,
 189509431,
 42640,
 -62642,
 189452910,
 42636,
 -62641,
 189611784,
 42634,
 -1,
 189673024,
 42642,
 189860697,
 189377932,
 -1,
 189926230,
 189827850,
 -1,
 189991765,
 189873724,
 -1,
 -62636,
 189954751,
 42598,
 -1,
 190017223,
 42596,
 -1,
 189937469,
 42594,
 190316543,
 189879330,
 -1,
 -62632,
 190239342,
 42646,
 -1,
 190272571,
 1318,
 190450528,
 189833473,
 -1,
 190516063,
 190400596,
 -1,
 -62628,
 190503887,
 1296,
 -62627,
 190569247,
 42580,
 -62626,
 190628539,
 42592,
 -1,
 190660147,
 42564,
 -1,
 190469176,
 1302,
 190909288,
 190398012,
 -1,
 190974821,
 190869221,
 -1,
 -62621,
 190938997,
 1312,
 -62620,
 190994929,
 1298,
 -1,
 191051728,
 1326,
 191299583,
 190939939,
 -1,
 -62617,
 191201141,
 1314,
 -1,
 191263455,
 1320,
 191433582,
 190867015,
 -1,
 191499117,
 191389483,
 -1,
 -62613,
 191486352,
 42578,
 -62612,
 191508700,
 42588,
 -1,
 191568111,
 42582,
 -1,
 191437039,
 42566,
 191826802,
 191420627,
 -1,
 -62608,
 191791860,
 42590,
 -62607,
 191841915,
 42576,
 -1,
 191896431,
 1304,
 192088951,
 191779874,
 -1,
 192154486,
 192026981,
 -1,
 -62603,
 192133188,
 1278,
 -1,
 192174577,
 1276,
 -1,
 192139886,
 42644,
 192416635,
 192031618,
 -1,
 -62599,
 192392152,
 42650,
 -62598,
 192444611,
 42584,
 -1,
 192491072,
 42630,
 192678783,
 192357810,
 -1,
 -62595,
 192654115,
 42572,
 -62594,
 192705672,
 42586,
 -1,
 192767128,
 42602,
 192940930,
 192666415,
 -1,
 -62591,
 192896187,
 42628,
 -1,
 192955216,
 42560,
 193137541,
 192905566,
 -1,
 -62588,
 193090320,
 42570,
 -1,
 193148192,
 42600,
 193334152,
 193089941,
 -1,
 -62585,
 193312851,
 1274,
 -1,
 193345488,
 1270,
 -62583,
 193319534,
 1308,
 -62582,
 193503082,
 1306,
 -62581,
 193567101,
 1316,
 -62580,
 193627454,
 42574,
 -62579,
 193688997,
 1300,
 -1,
 193732124,
 1310,
 193923985,
 188445916,
 -1,
 -62576,
 193901589,
 7467,
 -1,
 193954371,
 42606,
 -62574,
 193894744,
 42623,
 -1,
 194079855,
 42622,
 194251735,
 181968432,
 -1,
 194317210,
 194230811,
 -1,
 -62570,
 194299082,
 67633,
 -62569,
 194349482,
 67632,
 -62568,
 194403537,
 67631,
 -62567,
 194461244,
 67630,
 -1,
 194517231,
 67629,
 194710432,
 194293132,
 -1,
 -62564,
 194692298,
 67628,
 -62563,
 194742698,
 67627,
 -62562,
 194796753,
 67626,
 -62561,
 194854460,
 67625,
 -1,
 194910447,
 67624,
 195103654,
 194683137,
 -1,
 -62558,
 195085514,
 67623,
 -62557,
 195135914,
 67622,
 -62556,
 195189969,
 67621,
 -62555,
 195247676,
 67620,
 -1,
 195303663,
 67619,
 195496876,
 195073902,
 -1,
 -62552,
 195478730,
 67618,
 -62551,
 195529130,
 67617,
 -62550,
 195583185,
 67616,
 -62549,
 195640892,
 67615,
 -1,
 195696879,
 67614,
 195890098,
 195461876,
 -1,
 -62546,
 195871946,
 67613,
 -62545,
 195922346,
 67612,
 -62544,
 195976401,
 67611,
 -62543,
 196034108,
 67610,
 -1,
 196090095,
 67609,
 196283320,
 195852991,
 -1,
 -62540,
 196265162,
 67608,
 -62539,
 196315562,
 67607,
 -62538,
 196369617,
 67606,
 -62537,
 196427324,
 67605,
 -1,
 196483311,
 67604,
 196676542,
 196243143,
 -1,
 -62534,
 196658378,
 67603,
 -62533,
 196708778,
 67602,
 -62532,
 196762833,
 67601,
 -62531,
 196820540,
 67600,
 -1,
 196876527,
 67599,
 197069764,
 196635445,
 -1,
 -62528,
 197051594,
 67598,
 -62527,
 197101994,
 67597,
 -62526,
 197156049,
 67596,
 -62525,
 197213756,
 67595,
 -1,
 197269743,
 67594,
 197462985,
 197054732,
 -1,
 -62522,
 197429674,
 67637,
 -62521,
 197483729,
 67636,
 -62520,
 197541436,
 67635,
 -1,
 197597423,
 67634,
 197790668,
 197450543,
 -1,
 -62517,
 197757354,
 67647,
 -1,
 197794031,
 67644,
 197987279,
 197777373,
 -1,
 -62514,
 197934652,
 67640,
 -1,
 197990639,
 67639,
 198183890,
 197945865,
 -1,
 -62511,
 198150570,
 67592,
 -1,
 198187247,
 67589,
 -62509,
 198165706,
 67588,
 -62508,
 198347178,
 67587,
 -62507,
 198401233,
 67586,
 -62506,
 198458940,
 67585,
 -1,
 198514927,
 67584,
 -1,
 194195630,
 127744,
 198773879,
 181889727,
 -1,
 198839378,
 198717916,
 -1,
 198904811,
 198781826,
 -1,
 -62500,
 198855096,
 64207,
 -62499,
 198917692,
 64206,
 -62498,
 198981085,
 64205,
 -62497,
 199043970,
 64204,
 -62496,
 199108018,
 64203,
 -62495,
 199170287,
 64202,
 -62494,
 199235645,
 64201,
 -62493,
 199301004,
 64200,
 -62492,
 199366316,
 64199,
 -62491,
 199431644,
 64198,
 -62490,
 199496935,
 64197,
 -62489,
 199562259,
 64196,
 -62488,
 199627509,
 64195,
 -62487,
 199692752,
 64194,
 -62486,
 199757989,
 64193,
 -1,
 199823256,
 64192,
 200018940,
 198845874,
 -1,
 -62483,
 199969208,
 64191,
 -62482,
 200031804,
 64190,
 -62481,
 200095197,
 64189,
 -62480,
 200158082,
 64188,
 -62479,
 200222130,
 64187,
 -62478,
 200284399,
 64186,
 -62477,
 200349757,
 64185,
 -62476,
 200415116,
 64184,
 -62475,
 200480428,
 64183,
 -62474,
 200545756,
 64182,
 -62473,
 200611047,
 64181,
 -62472,
 200676371,
 64180,
 -62471,
 200741621,
 64179,
 -62470,
 200806864,
 64178,
 -62469,
 200872101,
 64177,
 -1,
 200937368,
 64176,
 201133069,
 199956719,
 -1,
 -62466,
 201083320,
 64175,
 -62465,
 201145916,
 64174,
 -62464,
 201209309,
 64173,
 -62463,
 201272194,
 64172,
 -62462,
 201336242,
 64171,
 -62461,
 201398511,
 64170,
 -62460,
 201463869,
 64169,
 -62459,
 201529228,
 64168,
 -62458,
 201594540,
 64167,
 -62457,
 201659868,
 64166,
 -62456,
 201725159,
 64165,
 -62455,
 201790483,
 64164,
 -62454,
 201855733,
 64163,
 -62453,
 201920976,
 64162,
 -62452,
 201986213,
 64161,
 -1,
 202051480,
 64160,
 202247198,
 201070653,
 -1,
 -62449,
 202197432,
 64159,
 -62448,
 202260028,
 64158,
 -62447,
 202323421,
 64157,
 -62446,
 202386306,
 64156,
 -62445,
 202450354,
 64155,
 -62444,
 202512623,
 64154,
 -62443,
 202577981,
 64153,
 -62442,
 202643340,
 64152,
 -62441,
 202708652,
 64151,
 -62440,
 202773980,
 64150,
 -62439,
 202839271,
 64149,
 -62438,
 202904595,
 64148,
 -62437,
 202969845,
 64147,
 -62436,
 203035088,
 64146,
 -62435,
 203100325,
 64145,
 -1,
 203165592,
 64144,
 203361327,
 202184588,
 -1,
 -62432,
 203311544,
 64143,
 -62431,
 203374140,
 64142,
 -62430,
 203437533,
 64141,
 -62429,
 203500418,
 64140,
 -62428,
 203564466,
 64139,
 -62427,
 203626735,
 64138,
 -62426,
 203692093,
 64137,
 -62425,
 203757452,
 64136,
 -62424,
 203822764,
 64135,
 -62423,
 203888092,
 64134,
 -62422,
 203953383,
 64133,
 -62421,
 204018707,
 64132,
 -62420,
 204083957,
 64131,
 -62419,
 204149200,
 64130,
 -62418,
 204214437,
 64129,
 -1,
 204279704,
 64128,
 204475456,
 203298476,
 -1,
 -62415,
 204425656,
 64127,
 -62414,
 204488252,
 64126,
 -62413,
 204551645,
 64125,
 -62412,
 204614530,
 64124,
 -62411,
 204678578,
 64123,
 -62410,
 204740847,
 64122,
 -62409,
 204806205,
 64121,
 -62408,
 204871564,
 64120,
 -62407,
 204936876,
 64119,
 -62406,
 205002204,
 64118,
 -62405,
 205067495,
 64117,
 -62404,
 205132819,
 64116,
 -62403,
 205198069,
 64115,
 -62402,
 205263312,
 64114,
 -62401,
 205328549,
 64113,
 -1,
 205393816,
 64112,
 205589579,
 204420573,
 -1,
 -62398,
 205527101,
 64217,
 -62397,
 205592460,
 64216,
 -62396,
 205657772,
 64215,
 -62395,
 205723100,
 64214,
 -62394,
 205788391,
 64213,
 -62393,
 205853715,
 64212,
 -62392,
 205918965,
 64211,
 -62391,
 205984208,
 64210,
 -62390,
 206049445,
 64209,
 -1,
 206114712,
 64208,
 206310479,
 205526492,
 -1,
 -62387,
 206255581,
 64109,
 -62386,
 206318466,
 64108,
 -1,
 206382514,
 64107,
 206635007,
 206246352,
 -1,
 -62383,
 206522808,
 64047,
 -1,
 206585404,
 64046,
 206831615,
 198817867,
 -1,
 206834785,
 206722082,
 12752,
 206900317,
 206822191,
 12757,
 206965849,
 206887727,
 12741,
 207031384,
 206953263,
 12750,
 -1,
 206982968,
 12769,
 -1,
 207001454,
 12747,
 207227995,
 206950668,
 12749,
 -1,
 207179576,
 12744,
 -62372,
 207206939,
 12746,
 -1,
 207310648,
 12742,
 207490143,
 206870382,
 12743,
 -1,
 207475485,
 12748,
 -62368,
 207476933,
 12768,
 -1,
 207572792,
 12758,
 207752299,
 206810508,
 12753,
 207817829,
 207739695,
 12759,
 -62364,
 207805231,
 12766,
 -1,
 207868701,
 12745,
 208014440,
 207802636,
 12740,
 -62361,
 208001839,
 12760,
 -1,
 208031544,
 12767,
 -62359,
 207993371,
 12761,
 -62358,
 208181102,
 12755,
 -1,
 208228152,
 12762,
 208407663,
 207722350,
 12754,
 -62355,
 208395055,
 12764,
 -62354,
 208424760,
 12770,
 -1,
 208483805,
 12763,
 208669809,
 208386587,
 12736,
 -1,
 208634612,
 12765,
 -62350,
 208656477,
 12738,
 -62349,
 208786205,
 12737,
 -62348,
 208838475,
 12771,
 -62347,
 208896756,
 12751,
 -62346,
 208942557,
 12756,
 -1,
 209005422,
 12739,
 209194179,
 198733511,
 -1,
 209259704,
 209160618,
 -1,
 209325227,
 209203265,
 -1,
 209390756,
 209257186,
 -1,
 209456265,
 209369627,
 -1,
 209521795,
 209441036,
 -1,
 209587328,
 209488298,
 -1,
 -62337,
 209522567,
 128349,
 -1,
 209585379,
 128337,
 209846271,
 209535770,
 -1,
 -62334,
 209719175,
 128359,
 -1,
 209781987,
 128347,
 209980550,
 209476416,
 -1,
 -62331,
 209915783,
 128350,
 -1,
 209978595,
 128338,
 210239487,
 209929060,
 -1,
 -62328,
 210112391,
 128357,
 -1,
 210175203,
 128345,
 210373776,
 209431948,
 -1,
 210439309,
 210332035,
 -1,
 -62324,
 210374535,
 128353,
 -1,
 210437347,
 128341,
 210698239,
 210388959,
 -1,
 -62321,
 210571143,
 128354,
 -1,
 210633955,
 128342,
 210832535,
 210323896,
 -1,
 210898068,
 210801604,
 -1,
 -62317,
 210833287,
 128351,
 -1,
 210896099,
 128339,
 211156991,
 210856145,
 -1,
 -62314,
 211029895,
 128352,
 -1,
 211092707,
 128340,
 211291294,
 210779708,
 -1,
 211356827,
 211252579,
 -1,
 -62310,
 211292039,
 128358,
 -1,
 211354851,
 128346,
 211615743,
 211312596,
 -1,
 -62307,
 211488647,
 128355,
 -1,
 211551459,
 128343,
 211750049,
 211258804,
 -1,
 -62304,
 211685255,
 128348,
 -1,
 211748067,
 128336,
 212008959,
 211715632,
 -1,
 -62301,
 211881863,
 128356,
 -1,
 211944675,
 128344,
 212205567,
 209376377,
 -1,
 212208809,
 212117318,
 -1,
 212274344,
 212193710,
 128257,
 -1,
 212208454,
 128258,
 -1,
 212205704,
 128472,
 -62294,
 212189684,
 11118,
 -1,
 212417802,
 128259,
 212602034,
 209301367,
 -1,
 212667567,
 212564879,
 -1,
 -62290,
 212640257,
 128235,
 -1,
 212695497,
 128234,
 -62288,
 212649990,
 127746,
 -62287,
 212826175,
 128272,
 -1,
 212871661,
 128213,
 213060791,
 212584133,
 -1,
 -62284,
 213041337,
 127786,
 -62283,
 213103904,
 127784,
 -62282,
 213164521,
 127783,
 -1,
 213218960,
 127785,
 -1,
 213046725,
 129313,
 213454014,
 209197295,
 -1,
 213519548,
 213425543,
 -1,
 -62277,
 213476137,
 128079,
 -1,
 213534089,
 127916,
 -62275,
 213497536,
 127963,
 -1,
 213680649,
 128385,
 213909503,
 213408977,
 -1,
 213912770,
 213812929,
 -1,
 -62271,
 213865104,
 129346,
 -1,
 213919580,
 127867,
 -1,
 213883232,
 128203,
 214174960,
 209149137,
 -1,
 214240493,
 214147960,
 -1,
 214306028,
 214200891,
 -1,
 214371540,
 214260945,
 -1,
 214437072,
 214316978,
 -1,
 214502603,
 214395701,
 -1,
 -62262,
 214471410,
 12871,
 -1,
 214524410,
 12869,
 214699214,
 214440175,
 -1,
 -62259,
 214646291,
 127568,
 -1,
 214707517,
 127569,
 -62257,
 214675195,
 12870,
 -1,
 214868134,
 12868,
 215026899,
 214416191,
 -1,
 -62254,
 214999297,
 127276,
 -1,
 215034754,
 127275,
 -1,
 214992214,
 128712,
 215289056,
 214337760,
 -1,
 215354585,
 215267867,
 -1,
 -62249,
 215339685,
 12873,
 -62248,
 215374111,
 12874,
 -1,
 215434132,
 12872,
 215616732,
 215330188,
 -1,
 -62245,
 215574985,
 12877,
 -1,
 215631911,
 12878,
 215813343,
 215566776,
 -1,
 -62242,
 215781914,
 12875,
 -1,
 215834436,
 12876,
 -1,
 215761551,
 12879,
 216075493,
 215231362,
 -1,
 216141028,
 216050628,
 -1,
 -62237,
 216097645,
 9938,
 -1,
 216139823,
 128320,
 -1,
 216085981,
 127277,
 216403176,
 216034835,
 -1,
 -62233,
 216361767,
 12925,
 -1,
 216411679,
 12924,
 -62231,
 216389597,
 11198,
 -62230,
 216586202,
 127278,
 -62229,
 216618475,
 12926,
 -1,
 216672742,
 11199,
 -1,
 214289326,
 127914,
 216927471,
 214222018,
 127961,
 -1,
 216858946,
 127750,
 -1,
 216892646,
 127910,
 217124105,
 214147329,
 983074,
 217189631,
 217090474,
 -1,
 217255164,
 217167475,
 -1,
 217320695,
 217202802,
 -1,
 -62219,
 217299360,
 9876,
 -62218,
 217351349,
 127370,
 -1,
 217402426,
 127884,
 217582843,
 217251840,
 -1,
 217648378,
 217554201,
 128322,
 -1,
 217582684,
 128321,
 -1,
 217611408,
 10060,
 -1,
 217539437,
 9932,
 -62211,
 217241013,
 128081,
 -62210,
 217868238,
 129360,
 -1,
 217919805,
 128010,
 218107140,
 217176275,
 -1,
 218172675,
 218063580,
 -1,
 -62206,
 218122768,
 128546,
 -1,
 218180834,
 128575,
 -1,
 218150659,
 128302,
 218434823,
 218054204,
 -1,
 -62202,
 218410736,
 127769,
 -1,
 218446160,
 128179,
 -62200,
 218390090,
 127951,
 -1,
 218569156,
 129408,
 218762509,
 217071164,
 -1,
 -62197,
 218736059,
 9907,
 -62196,
 218790454,
 128328,
 -1,
 218839119,
 8373,
 -62194,
 218739226,
 983187,
 -62193,
 218976901,
 983200,
 -1,
 219033072,
 983171,
 219223378,
 47643,
 -1,
 219288400,
 219158767,
 -1,
 219353184,
 219251444,
 -1,
 219418719,
 219303736,
 -1,
 219484254,
 219401246,
 -1,
 219549789,
 219427319,
 -1,
 219614597,
 219485660,
 -1,
 219680034,
 219551805,
 -1,
 -62183,
 219617341,
 101050,
 -62182,
 219682700,
 101049,
 -62181,
 219748012,
 101048,
 -62180,
 219813340,
 101047,
 -62179,
 219878631,
 101046,
 -62178,
 219943955,
 101045,
 -62177,
 220009205,
 101044,
 -62176,
 220074448,
 101043,
 -62175,
 220139685,
 101042,
 -1,
 220204952,
 101041,
 220400941,
 219617164,
 -1,
 -62172,
 220338237,
 101040,
 -62171,
 220403596,
 101039,
 -62170,
 220468908,
 101038,
 -62169,
 220534236,
 101037,
 -62168,
 220599527,
 101036,
 -62167,
 220664851,
 101035,
 -62166,
 220730101,
 101034,
 -62165,
 220795344,
 101033,
 -62164,
 220860581,
 101032,
 -1,
 220925848,
 101031,
 221121848,
 220337836,
 -1,
 -62161,
 221059133,
 101030,
 -62160,
 221124492,
 101029,
 -62159,
 221189804,
 101028,
 -62158,
 221255132,
 101027,
 -62157,
 221320423,
 101026,
 -62156,
 221385747,
 101025,
 -62155,
 221450997,
 101024,
 -62154,
 221516240,
 101023,
 -62153,
 221581477,
 101022,
 -1,
 221646744,
 101021,
 221842755,
 221058524,
 -1,
 -62150,
 221780029,
 101020,
 -62149,
 221845388,
 101019,
 -62148,
 221910700,
 101018,
 -62147,
 221976028,
 101017,
 -62146,
 222041319,
 101016,
 -62145,
 222106643,
 101015,
 -62144,
 222171893,
 101014,
 -62143,
 222237136,
 101013,
 -62142,
 222302373,
 101012,
 -1,
 222367640,
 101011,
 222563662,
 221779175,
 -1,
 -62139,
 222500925,
 101010,
 -62138,
 222566284,
 101009,
 -62137,
 222631596,
 101008,
 -62136,
 222696924,
 101007,
 -62135,
 222762215,
 101006,
 -62134,
 222827539,
 101005,
 -62133,
 222892789,
 101004,
 -62132,
 222958032,
 101003,
 -62131,
 223023269,
 101002,
 -1,
 223088536,
 101001,
 223284569,
 222499859,
 -1,
 -62128,
 223221821,
 101000,
 -62127,
 223287180,
 100999,
 -62126,
 223352492,
 100998,
 -62125,
 223417820,
 100997,
 -62124,
 223483111,
 100996,
 -62123,
 223548435,
 100995,
 -62122,
 223613685,
 100994,
 -62121,
 223678928,
 100993,
 -62120,
 223744165,
 100992,
 -1,
 223809432,
 100991,
 224005476,
 223220469,
 -1,
 -62117,
 223942717,
 100990,
 -62116,
 224008076,
 100989,
 -62115,
 224073388,
 100988,
 -62114,
 224138716,
 100987,
 -62113,
 224204007,
 100986,
 -62112,
 224269331,
 100985,
 -62111,
 224334581,
 100984,
 -62110,
 224399824,
 100983,
 -62109,
 224465061,
 100982,
 -1,
 224530328,
 100981,
 224726383,
 223941072,
 -1,
 -62106,
 224663613,
 100980,
 -62105,
 224728972,
 100979,
 -62104,
 224794284,
 100978,
 -62103,
 224859612,
 100977,
 -62102,
 224924903,
 100976,
 -62101,
 224990227,
 100975,
 -62100,
 225055477,
 100974,
 -62099,
 225120720,
 100973,
 -62098,
 225185957,
 100972,
 -1,
 225251224,
 100971,
 225447290,
 224661669,
 -1,
 -62095,
 225384509,
 100970,
 -62094,
 225449868,
 100969,
 -62093,
 225515180,
 100968,
 -62092,
 225580508,
 100967,
 -62091,
 225645799,
 100966,
 -62090,
 225711123,
 100965,
 -62089,
 225776373,
 100964,
 -62088,
 225841616,
 100963,
 -62087,
 225906853,
 100962,
 -1,
 225972120,
 100961,
 226230271,
 225382296,
 -1,
 -62084,
 226105405,
 100960,
 -62083,
 226170764,
 100959,
 -62082,
 226236076,
 100958,
 -62081,
 226301404,
 100957,
 -62080,
 226366695,
 100956,
 -62079,
 226432019,
 100955,
 -62078,
 226497269,
 100954,
 -62077,
 226562512,
 100953,
 -62076,
 226627749,
 100952,
 -1,
 226693016,
 100951,
 226889204,
 219550951,
 -1,
 226954641,
 226826301,
 -1,
 -62072,
 226891837,
 100950,
 -62071,
 226957196,
 100949,
 -62070,
 227022508,
 100948,
 -62069,
 227087836,
 100947,
 -62068,
 227153127,
 100946,
 -62067,
 227218451,
 100945,
 -62066,
 227283701,
 100944,
 -62065,
 227348944,
 100943,
 -62064,
 227414181,
 100942,
 -1,
 227479448,
 100941,
 227675548,
 226891660,
 -1,
 -62061,
 227612733,
 100940,
 -62060,
 227678092,
 100939,
 -62059,
 227743404,
 100938,
 -62058,
 227808732,
 100937,
 -62057,
 227874023,
 100936,
 -62056,
 227939347,
 100935,
 -62055,
 228004597,
 100934,
 -62054,
 228069840,
 100933,
 -62053,
 228135077,
 100932,
 -1,
 228200344,
 100931,
 228396455,
 227612332,
 -1,
 -62050,
 228333629,
 100930,
 -62049,
 228398988,
 100929,
 -62048,
 228464300,
 100928,
 -62047,
 228529628,
 100927,
 -62046,
 228594919,
 100926,
 -62045,
 228660243,
 100925,
 -62044,
 228725493,
 100924,
 -62043,
 228790736,
 100923,
 -62042,
 228855973,
 100922,
 -1,
 228921240,
 100921,
 229117362,
 228333020,
 -1,
 -62039,
 229054525,
 100920,
 -62038,
 229119884,
 100919,
 -62037,
 229185196,
 100918,
 -62036,
 229250524,
 100917,
 -62035,
 229315815,
 100916,
 -62034,
 229381139,
 100915,
 -62033,
 229446389,
 100914,
 -62032,
 229511632,
 100913,
 -62031,
 229576869,
 100912,
 -1,
 229642136,
 100911,
 229838269,
 229053671,
 -1,
 -62028,
 229775421,
 100910,
 -62027,
 229840780,
 100909,
 -62026,
 229906092,
 100908,
 -62025,
 229971420,
 100907,
 -62024,
 230036711,
 100906,
 -62023,
 230102035,
 100905,
 -62022,
 230167285,
 100904,
 -62021,
 230232528,
 100903,
 -62020,
 230297765,
 100902,
 -1,
 230363032,
 100901,
 230559176,
 229774355,
 -1,
 -62017,
 230496317,
 100900,
 -62016,
 230561676,
 100899,
 -62015,
 230626988,
 100898,
 -62014,
 230692316,
 100897,
 -62013,
 230757607,
 100896,
 -62012,
 230822931,
 100895,
 -62011,
 230888181,
 100894,
 -62010,
 230953424,
 100893,
 -62009,
 231018661,
 100892,
 -1,
 231083928,
 100891,
 231280083,
 230494965,
 -1,
 -62006,
 231217213,
 100890,
 -62005,
 231282572,
 100889,
 -62004,
 231347884,
 100888,
 -62003,
 231413212,
 100887,
 -62002,
 231478503,
 100886,
 -62001,
 231543827,
 100885,
 -62000,
 231609077,
 100884,
 -61999,
 231674320,
 100883,
 -61998,
 231739557,
 100882,
 -1,
 231804824,
 100881,
 232000990,
 231215568,
 -1,
 -61995,
 231938109,
 100880,
 -61994,
 232003468,
 100879,
 -61993,
 232068780,
 100878,
 -61992,
 232134108,
 100877,
 -61991,
 232199399,
 100876,
 -61990,
 232264723,
 100875,
 -61989,
 232329973,
 100874,
 -61988,
 232395216,
 100873,
 -61987,
 232460453,
 100872,
 -1,
 232525720,
 100871,
 232721897,
 231936165,
 -1,
 -61984,
 232659005,
 100870,
 -61983,
 232724364,
 100869,
 -61982,
 232789676,
 100868,
 -61981,
 232855004,
 100867,
 -61980,
 232920295,
 100866,
 -61979,
 232985619,
 100865,
 -61978,
 233050869,
 100864,
 -61977,
 233116112,
 100863,
 -61976,
 233181349,
 100862,
 -1,
 233246616,
 100861,
 233504767,
 232656792,
 -1,
 -61973,
 233379901,
 100860,
 -61972,
 233445260,
 100859,
 -61971,
 233510572,
 100858,
 -61970,
 233575900,
 100857,
 -61969,
 233641191,
 100856,
 -61968,
 233706515,
 100855,
 -61967,
 233771765,
 100854,
 -61966,
 233837008,
 100853,
 -61965,
 233902245,
 100852,
 -1,
 233967512,
 100851,
 234163811,
 226825235,
 -1,
 234229248,
 234100797,
 -1,
 -61961,
 234166333,
 100850,
 -61960,
 234231692,
 100849,
 -61959,
 234297004,
 100848,
 -61958,
 234362332,
 100847,
 -61957,
 234427623,
 100846,
 -61956,
 234492947,
 100845,
 -61955,
 234558197,
 100844,
 -61954,
 234623440,
 100843,
 -61953,
 234688677,
 100842,
 -1,
 234753944,
 100841,
 234950155,
 234166156,
 -1,
 -61950,
 234887229,
 100840,
 -61949,
 234952588,
 100839,
 -61948,
 235017900,
 100838,
 -61947,
 235083228,
 100837,
 -61946,
 235148519,
 100836,
 -61945,
 235213843,
 100835,
 -61944,
 235279093,
 100834,
 -61943,
 235344336,
 100833,
 -61942,
 235409573,
 100832,
 -1,
 235474840,
 100831,
 235671062,
 234886828,
 -1,
 -61939,
 235608125,
 100830,
 -61938,
 235673484,
 100829,
 -61937,
 235738796,
 100828,
 -61936,
 235804124,
 100827,
 -61935,
 235869415,
 100826,
 -61934,
 235934739,
 100825,
 -61933,
 235999989,
 100824,
 -61932,
 236065232,
 100823,
 -61931,
 236130469,
 100822,
 -1,
 236195736,
 100821,
 236391969,
 235607516,
 -1,
 -61928,
 236329021,
 100820,
 -61927,
 236394380,
 100819,
 -61926,
 236459692,
 100818,
 -61925,
 236525020,
 100817,
 -61924,
 236590311,
 100816,
 -61923,
 236655635,
 100815,
 -61922,
 236720885,
 100814,
 -61921,
 236786128,
 100813,
 -61920,
 236851365,
 100812,
 -1,
 236916632,
 100811,
 237112876,
 236328167,
 -1,
 -61917,
 237049917,
 100810,
 -61916,
 237115276,
 100809,
 -61915,
 237180588,
 100808,
 -61914,
 237245916,
 100807,
 -61913,
 237311207,
 100806,
 -61912,
 237376531,
 100805,
 -61911,
 237441781,
 100804,
 -61910,
 237507024,
 100803,
 -61909,
 237572261,
 100802,
 -1,
 237637528,
 100801,
 237833783,
 237048851,
 -1,
 -61906,
 237770813,
 100800,
 -61905,
 237836172,
 100799,
 -61904,
 237901484,
 100798,
 -61903,
 237966812,
 100797,
 -61902,
 238032103,
 100796,
 -61901,
 238097427,
 100795,
 -61900,
 238162677,
 100794,
 -61899,
 238227920,
 100793,
 -61898,
 238293157,
 100792,
 -1,
 238358424,
 100791,
 238554690,
 237769461,
 -1,
 -61895,
 238491709,
 100790,
 -61894,
 238557068,
 100789,
 -61893,
 238622380,
 100788,
 -61892,
 238687708,
 100787,
 -61891,
 238752999,
 100786,
 -61890,
 238818323,
 100785,
 -61889,
 238883573,
 100784,
 -61888,
 238948816,
 100783,
 -61887,
 239014053,
 100782,
 -1,
 239079320,
 100781,
 239275597,
 238490064,
 -1,
 -61884,
 239212605,
 100780,
 -61883,
 239277964,
 100779,
 -61882,
 239343276,
 100778,
 -61881,
 239408604,
 100777,
 -61880,
 239473895,
 100776,
 -61879,
 239539219,
 100775,
 -61878,
 239604469,
 100774,
 -61877,
 239669712,
 100773,
 -61876,
 239734949,
 100772,
 -1,
 239800216,
 100771,
 239996504,
 239210661,
 -1,
 -61873,
 239933501,
 100770,
 -61872,
 239998860,
 100769,
 -61871,
 240064172,
 100768,
 -61870,
 240129500,
 100767,
 -61869,
 240194791,
 100766,
 -61868,
 240260115,
 100765,
 -61867,
 240325365,
 100764,
 -61866,
 240390608,
 100763,
 -61865,
 240455845,
 100762,
 -1,
 240521112,
 100761,
 240779263,
 239931288,
 -1,
 -61862,
 240654397,
 100760,
 -61861,
 240719756,
 100759,
 -61860,
 240785068,
 100758,
 -61859,
 240850396,
 100757,
 -61858,
 240915687,
 100756,
 -61857,
 240981011,
 100755,
 -61856,
 241046261,
 100754,
 -61855,
 241111504,
 100753,
 -61854,
 241176741,
 100752,
 -1,
 241242008,
 100751,
 241438418,
 234099445,
 -1,
 241503855,
 241375293,
 -1,
 -61850,
 241440829,
 100750,
 -61849,
 241506188,
 100749,
 -61848,
 241571500,
 100748,
 -61847,
 241636828,
 100747,
 -61846,
 241702119,
 100746,
 -61845,
 241767443,
 100745,
 -61844,
 241832693,
 100744,
 -61843,
 241897936,
 100743,
 -61842,
 241963173,
 100742,
 -1,
 242028440,
 100741,
 242224762,
 241440652,
 -1,
 -61839,
 242161725,
 100740,
 -61838,
 242227084,
 100739,
 -61837,
 242292396,
 100738,
 -61836,
 242357724,
 100737,
 -61835,
 242423015,
 100736,
 -61834,
 242488339,
 100735,
 -61833,
 242553589,
 100734,
 -61832,
 242618832,
 100733,
 -61831,
 242684069,
 100732,
 -1,
 242749336,
 100731,
 242945669,
 242161324,
 -1,
 -61828,
 242882621,
 100730,
 -61827,
 242947980,
 100729,
 -61826,
 243013292,
 100728,
 -61825,
 243078620,
 100727,
 -61824,
 243143911,
 100726,
 -61823,
 243209235,
 100725,
 -61822,
 243274485,
 100724,
 -61821,
 243339728,
 100723,
 -61820,
 243404965,
 100722,
 -1,
 243470232,
 100721,
 243666576,
 242882012,
 -1,
 -61817,
 243603517,
 100720,
 -61816,
 243668876,
 100719,
 -61815,
 243734188,
 100718,
 -61814,
 243799516,
 100717,
 -61813,
 243864807,
 100716,
 -61812,
 243930131,
 100715,
 -61811,
 243995381,
 100714,
 -61810,
 244060624,
 100713,
 -61809,
 244125861,
 100712,
 -1,
 244191128,
 100711,
 244387483,
 243602663,
 -1,
 -61806,
 244324413,
 100710,
 -61805,
 244389772,
 100709,
 -61804,
 244455084,
 100708,
 -61803,
 244520412,
 100707,
 -61802,
 244585703,
 100706,
 -61801,
 244651027,
 100705,
 -61800,
 244716277,
 100704,
 -61799,
 244781520,
 100703,
 -61798,
 244846757,
 100702,
 -1,
 244912024,
 100701,
 245108390,
 244323347,
 -1,
 -61795,
 245045309,
 100700,
 -61794,
 245110668,
 100699,
 -61793,
 245175980,
 100698,
 -61792,
 245241308,
 100697,
 -61791,
 245306599,
 100696,
 -61790,
 245371923,
 100695,
 -61789,
 245437173,
 100694,
 -61788,
 245502416,
 100693,
 -61787,
 245567653,
 100692,
 -1,
 245632920,
 100691,
 245829297,
 245043957,
 -1,
 -61784,
 245766205,
 100690,
 -61783,
 245831564,
 100689,
 -61782,
 245896876,
 100688,
 -61781,
 245962204,
 100687,
 -61780,
 246027495,
 100686,
 -61779,
 246092819,
 100685,
 -61778,
 246158069,
 100684,
 -61777,
 246223312,
 100683,
 -61776,
 246288549,
 100682,
 -1,
 246353816,
 100681,
 246550204,
 245764560,
 -1,
 -61773,
 246487101,
 100680,
 -61772,
 246552460,
 100679,
 -61771,
 246617772,
 100678,
 -61770,
 246683100,
 100677,
 -61769,
 246748391,
 100676,
 -61768,
 246813715,
 100675,
 -61767,
 246878965,
 100674,
 -61766,
 246944208,
 100673,
 -61765,
 247009445,
 100672,
 -1,
 247074712,
 100671,
 247271111,
 246485157,
 -1,
 -61762,
 247207997,
 100670,
 -61761,
 247273356,
 100669,
 -61760,
 247338668,
 100668,
 -61759,
 247403996,
 100667,
 -61758,
 247469287,
 100666,
 -61757,
 247534611,
 100665,
 -61756,
 247599861,
 100664,
 -61755,
 247665104,
 100663,
 -61754,
 247730341,
 100662,
 -1,
 247795608,
 100661,
 248053759,
 247205784,
 -1,
 -61751,
 247928893,
 100660,
 -61750,
 247994252,
 100659,
 -61749,
 248059564,
 100658,
 -61748,
 248124892,
 100657,
 -61747,
 248190183,
 100656,
 -61746,
 248255507,
 100655,
 -61745,
 248320757,
 100654,
 -61744,
 248386000,
 100653,
 -61743,
 248451237,
 100652,
 -1,
 248516504,
 100651,
 248713025,
 241373648,
 -1,
 248778462,
 248649789,
 -1,
 -61739,
 248715325,
 100650,
 -61738,
 248780684,
 100649,
 -61737,
 248845996,
 100648,
 -61736,
 248911324,
 100647,
 -61735,
 248976615,
 100646,
 -61734,
 249041939,
 100645,
 -61733,
 249107189,
 100644,
 -61732,
 249172432,
 100643,
 -61731,
 249237669,
 100642,
 -1,
 249302936,
 100641,
 249499369,
 248715148,
 -1,
 -61728,
 249436221,
 100640,
 -61727,
 249501580,
 100639,
 -61726,
 249566892,
 100638,
 -61725,
 249632220,
 100637,
 -61724,
 249697511,
 100636,
 -61723,
 249762835,
 100635,
 -61722,
 249828085,
 100634,
 -61721,
 249893328,
 100633,
 -61720,
 249958565,
 100632,
 -1,
 250023832,
 100631,
 250220276,
 249435820,
 -1,
 -61717,
 250157117,
 100630,
 -61716,
 250222476,
 100629,
 -61715,
 250287788,
 100628,
 -61714,
 250353116,
 100627,
 -61713,
 250418407,
 100626,
 -61712,
 250483731,
 100625,
 -61711,
 250548981,
 100624,
 -61710,
 250614224,
 100623,
 -61709,
 250679461,
 100622,
 -1,
 250744728,
 100621,
 250941183,
 250156508,
 -1,
 -61706,
 250878013,
 100620,
 -61705,
 250943372,
 100619,
 -61704,
 251008684,
 100618,
 -61703,
 251074012,
 100617,
 -61702,
 251139303,
 100616,
 -61701,
 251204627,
 100615,
 -61700,
 251269877,
 100614,
 -61699,
 251335120,
 100613,
 -61698,
 251400357,
 100612,
 -1,
 251465624,
 100611,
 251662090,
 250877159,
 -1,
 -61695,
 251598909,
 100610,
 -61694,
 251664268,
 100609,
 -61693,
 251729580,
 100608,
 -61692,
 251794908,
 100607,
 -61691,
 251860199,
 100606,
 -61690,
 251925523,
 100605,
 -61689,
 251990773,
 100604,
 -61688,
 252056016,
 100603,
 -61687,
 252121253,
 100602,
 -1,
 252186520,
 100601,
 252382997,
 251597843,
 -1,
 -61684,
 252319805,
 100600,
 -61683,
 252385164,
 100599,
 -61682,
 252450476,
 100598,
 -61681,
 252515804,
 100597,
 -61680,
 252581095,
 100596,
 -61679,
 252646419,
 100595,
 -61678,
 252711669,
 100594,
 -61677,
 252776912,
 100593,
 -61676,
 252842149,
 100592,
 -1,
 252907416,
 100591,
 253103904,
 252318453,
 -1,
 -61673,
 253040701,
 100590,
 -61672,
 253106060,
 100589,
 -61671,
 253171372,
 100588,
 -61670,
 253236700,
 100587,
 -61669,
 253301991,
 100586,
 -61668,
 253367315,
 100585,
 -61667,
 253432565,
 100584,
 -61666,
 253497808,
 100583,
 -61665,
 253563045,
 100582,
 -1,
 253628312,
 100581,
 253824811,
 253039056,
 -1,
 -61662,
 253761597,
 100580,
 -61661,
 253826956,
 100579,
 -61660,
 253892268,
 100578,
 -61659,
 253957596,
 100577,
 -61658,
 254022887,
 100576,
 -61657,
 254088211,
 100575,
 -61656,
 254153461,
 100574,
 -61655,
 254218704,
 100573,
 -61654,
 254283941,
 100572,
 -1,
 254349208,
 100571,
 254545718,
 253759653,
 -1,
 -61651,
 254482493,
 100570,
 -61650,
 254547852,
 100569,
 -61649,
 254613164,
 100568,
 -61648,
 254678492,
 100567,
 -61647,
 254743783,
 100566,
 -61646,
 254809107,
 100565,
 -61645,
 254874357,
 100564,
 -61644,
 254939600,
 100563,
 -61643,
 255004837,
 100562,
 -1,
 255070104,
 100561,
 255328255,
 254480280,
 -1,
 -61640,
 255203389,
 100560,
 -61639,
 255268748,
 100559,
 -61638,
 255334060,
 100558,
 -61637,
 255399388,
 100557,
 -61636,
 255464679,
 100556,
 -61635,
 255530003,
 100555,
 -61634,
 255595253,
 100554,
 -61633,
 255660496,
 100553,
 -61632,
 255725733,
 100552,
 -1,
 255791000,
 100551,
 255987632,
 248647845,
 -1,
 256053069,
 255924285,
 -1,
 -61628,
 255989821,
 100550,
 -61627,
 256055180,
 100549,
 -61626,
 256120492,
 100548,
 -61625,
 256185820,
 100547,
 -61624,
 256251111,
 100546,
 -61623,
 256316435,
 100545,
 -61622,
 256381685,
 100544,
 -61621,
 256446928,
 100543,
 -61620,
 256512165,
 100542,
 -1,
 256577432,
 100541,
 256773976,
 255989644,
 -1,
 -61617,
 256710717,
 100540,
 -61616,
 256776076,
 100539,
 -61615,
 256841388,
 100538,
 -61614,
 256906716,
 100537,
 -61613,
 256972007,
 100536,
 -61612,
 257037331,
 100535,
 -61611,
 257102581,
 100534,
 -61610,
 257167824,
 100533,
 -61609,
 257233061,
 100532,
 -1,
 257298328,
 100531,
 257494883,
 256710316,
 -1,
 -61606,
 257431613,
 100530,
 -61605,
 257496972,
 100529,
 -61604,
 257562284,
 100528,
 -61603,
 257627612,
 100527,
 -61602,
 257692903,
 100526,
 -61601,
 257758227,
 100525,
 -61600,
 257823477,
 100524,
 -61599,
 257888720,
 100523,
 -61598,
 257953957,
 100522,
 -1,
 258019224,
 100521,
 258215790,
 257431004,
 -1,
 -61595,
 258152509,
 100520,
 -61594,
 258217868,
 100519,
 -61593,
 258283180,
 100518,
 -61592,
 258348508,
 100517,
 -61591,
 258413799,
 100516,
 -61590,
 258479123,
 100515,
 -61589,
 258544373,
 100514,
 -61588,
 258609616,
 100513,
 -61587,
 258674853,
 100512,
 -1,
 258740120,
 100511,
 258936697,
 258151655,
 -1,
 -61584,
 258873405,
 100510,
 -61583,
 258938764,
 100509,
 -61582,
 259004076,
 100508,
 -61581,
 259069404,
 100507,
 -61580,
 259134695,
 100506,
 -61579,
 259200019,
 100505,
 -61578,
 259265269,
 100504,
 -61577,
 259330512,
 100503,
 -61576,
 259395749,
 100502,
 -1,
 259461016,
 100501,
 259657604,
 258872339,
 -1,
 -61573,
 259594301,
 100500,
 -61572,
 259659660,
 100499,
 -61571,
 259724972,
 100498,
 -61570,
 259790300,
 100497,
 -61569,
 259855591,
 100496,
 -61568,
 259920915,
 100495,
 -61567,
 259986165,
 100494,
 -61566,
 260051408,
 100493,
 -61565,
 260116645,
 100492,
 -1,
 260181912,
 100491,
 260378511,
 259592949,
 -1,
 -61562,
 260315197,
 100490,
 -61561,
 260380556,
 100489,
 -61560,
 260445868,
 100488,
 -61559,
 260511196,
 100487,
 -61558,
 260576487,
 100486,
 -61557,
 260641811,
 100485,
 -61556,
 260707061,
 100484,
 -61555,
 260772304,
 100483,
 -61554,
 260837541,
 100482,
 -1,
 260902808,
 100481,
 261099418,
 260313552,
 -1,
 -61551,
 261036093,
 100480,
 -61550,
 261101452,
 100479,
 -61549,
 261166764,
 100478,
 -61548,
 261232092,
 100477,
 -61547,
 261297383,
 100476,
 -61546,
 261362707,
 100475,
 -61545,
 261427957,
 100474,
 -61544,
 261493200,
 100473,
 -61543,
 261558437,
 100472,
 -1,
 261623704,
 100471,
 261820325,
 261034149,
 -1,
 -61540,
 261756989,
 100470,
 -61539,
 261822348,
 100469,
 -61538,
 261887660,
 100468,
 -61537,
 261952988,
 100467,
 -61536,
 262018279,
 100466,
 -61535,
 262083603,
 100465,
 -61534,
 262148853,
 100464,
 -61533,
 262214096,
 100463,
 -61532,
 262279333,
 100462,
 -1,
 262344600,
 100461,
 262602751,
 261754776,
 -1,
 -61529,
 262477885,
 100460,
 -61528,
 262543244,
 100459,
 -61527,
 262608556,
 100458,
 -61526,
 262673884,
 100457,
 -61525,
 262739175,
 100456,
 -61524,
 262804499,
 100455,
 -61523,
 262869749,
 100454,
 -61522,
 262934992,
 100453,
 -61521,
 263000229,
 100452,
 -1,
 263065496,
 100451,
 263262238,
 255922072,
 -1,
 263327676,
 263198781,
 -1,
 -61517,
 263264317,
 100450,
 -61516,
 263329676,
 100449,
 -61515,
 263394988,
 100448,
 -61514,
 263460316,
 100447,
 -61513,
 263525607,
 100446,
 -61512,
 263590931,
 100445,
 -61511,
 263656181,
 100444,
 -61510,
 263721424,
 100443,
 -61509,
 263786661,
 100442,
 -1,
 263851928,
 100441,
 264048583,
 263264140,
 -1,
 -61506,
 263985213,
 100440,
 -61505,
 264050572,
 100439,
 -61504,
 264115884,
 100438,
 -61503,
 264181212,
 100437,
 -61502,
 264246503,
 100436,
 -61501,
 264311827,
 100435,
 -61500,
 264377077,
 100434,
 -61499,
 264442320,
 100433,
 -61498,
 264507557,
 100432,
 -1,
 264572824,
 100431,
 264769490,
 263984812,
 -1,
 -61495,
 264706109,
 100430,
 -61494,
 264771468,
 100429,
 -61493,
 264836780,
 100428,
 -61492,
 264902108,
 100427,
 -61491,
 264967399,
 100426,
 -61490,
 265032723,
 100425,
 -61489,
 265097973,
 100424,
 -61488,
 265163216,
 100423,
 -61487,
 265228453,
 100422,
 -1,
 265293720,
 100421,
 265490397,
 264705500,
 -1,
 -61484,
 265427005,
 100420,
 -61483,
 265492364,
 100419,
 -61482,
 265557676,
 100418,
 -61481,
 265623004,
 100417,
 -61480,
 265688295,
 100416,
 -61479,
 265753619,
 100415,
 -61478,
 265818869,
 100414,
 -61477,
 265884112,
 100413,
 -61476,
 265949349,
 100412,
 -1,
 266014616,
 100411,
 266211304,
 265426151,
 -1,
 -61473,
 266147901,
 100410,
 -61472,
 266213260,
 100409,
 -61471,
 266278572,
 100408,
 -61470,
 266343900,
 100407,
 -61469,
 266409191,
 100406,
 -61468,
 266474515,
 100405,
 -61467,
 266539765,
 100404,
 -61466,
 266605008,
 100403,
 -61465,
 266670245,
 100402,
 -1,
 266735512,
 100401,
 266932211,
 266146835,
 -1,
 -61462,
 266868797,
 100400,
 -61461,
 266934156,
 100399,
 -61460,
 266999468,
 100398,
 -61459,
 267064796,
 100397,
 -61458,
 267130087,
 100396,
 -61457,
 267195411,
 100395,
 -61456,
 267260661,
 100394,
 -61455,
 267325904,
 100393,
 -61454,
 267391141,
 100392,
 -1,
 267456408,
 100391,
 267653118,
 266867445,
 -1,
 -61451,
 267589693,
 100390,
 -61450,
 267655052,
 100389,
 -61449,
 267720364,
 100388,
 -61448,
 267785692,
 100387,
 -61447,
 267850983,
 100386,
 -61446,
 267916307,
 100385,
 -61445,
 267981557,
 100384,
 -61444,
 268046800,
 100383,
 -61443,
 268112037,
 100382,
 -1,
 268177304,
 100381,
 268374025,
 267588048,
 -1,
 -61440,
 268310589,
 100380,
 -61439,
 268375948,
 100379,
 -61438,
 268441260,
 100378,
 -61437,
 268506588,
 100377,
 -61436,
 268571879,
 100376,
 -61435,
 268637203,
 100375,
 -61434,
 268702453,
 100374,
 -61433,
 268767696,
 100373,
 -61432,
 268832933,
 100372,
 -1,
 268898200,
 100371,
 269094932,
 268308645,
 -1,
 -61429,
 269031485,
 100370,
 -61428,
 269096844,
 100369,
 -61427,
 269162156,
 100368,
 -61426,
 269227484,
 100367,
 -61425,
 269292775,
 100366,
 -61424,
 269358099,
 100365,
 -61423,
 269423349,
 100364,
 -61422,
 269488592,
 100363,
 -61421,
 269553829,
 100362,
 -1,
 269619096,
 100361,
 269877247,
 269029272,
 -1,
 -61418,
 269752381,
 100360,
 -61417,
 269817740,
 100359,
 -61416,
 269883052,
 100358,
 -61415,
 269948380,
 100357,
 -61414,
 270013671,
 100356,
 -61413,
 270078995,
 100355,
 -61412,
 270144245,
 100354,
 -61411,
 270209488,
 100353,
 -1,
 270274725,
 100352,
 270532607,
 263198380,
 -1,
 270536746,
 270406675,
 -1,
 -61407,
 270473277,
 101100,
 -61406,
 270538636,
 101099,
 -61405,
 270603948,
 101098,
 -61404,
 270669276,
 101097,
 -61403,
 270734567,
 101096,
 -61402,
 270799891,
 101095,
 -61401,
 270865141,
 101094,
 -61400,
 270930384,
 101093,
 -61399,
 270995621,
 101092,
 -1,
 271060888,
 101091,
 271257653,
 270471925,
 -1,
 -61396,
 271194173,
 101090,
 -61395,
 271259532,
 101089,
 -61394,
 271324844,
 101088,
 -61393,
 271390172,
 101087,
 -61392,
 271455463,
 101086,
 -61391,
 271520787,
 101085,
 -61390,
 271586037,
 101084,
 -61389,
 271651280,
 101083,
 -61388,
 271716517,
 101082,
 -1,
 271781784,
 101081,
 271978560,
 271192528,
 -1,
 -61385,
 271915069,
 101080,
 -61384,
 271980428,
 101079,
 -61383,
 272045740,
 101078,
 -61382,
 272111068,
 101077,
 -61381,
 272176359,
 101076,
 -61380,
 272241683,
 101075,
 -61379,
 272306933,
 101074,
 -61378,
 272372176,
 101073,
 -61377,
 272437413,
 101072,
 -1,
 272502680,
 101071,
 272699467,
 271913125,
 -1,
 -61374,
 272635965,
 101070,
 -61373,
 272701324,
 101069,
 -61372,
 272766636,
 101068,
 -61371,
 272831964,
 101067,
 -61370,
 272897255,
 101066,
 -61369,
 272962579,
 101065,
 -61368,
 273027829,
 101064,
 -61367,
 273093072,
 101063,
 -61366,
 273158309,
 101062,
 -1,
 273223576,
 101061,
 273420374,
 272633752,
 -1,
 -61363,
 273356861,
 101060,
 -61362,
 273422220,
 101059,
 -61361,
 273487532,
 101058,
 -61360,
 273552860,
 101057,
 -61359,
 273618151,
 101056,
 -61358,
 273683475,
 101055,
 -61357,
 273748725,
 101054,
 -61356,
 273813968,
 101053,
 -61355,
 273879205,
 101052,
 -1,
 273944472,
 101051,
 274202623,
 273356007,
 -1,
 -61352,
 274076903,
 101106,
 -61351,
 274142227,
 101105,
 -61350,
 274207477,
 101104,
 -61349,
 274272720,
 101103,
 -61348,
 274337957,
 101102,
 -1,
 274403224,
 101101,
 -1,
 219506818,
 94176,
 -1,
 219432483,
 127818,
 -1,
 219355610,
 127883,
 274796993,
 219316237,
 -1,
 274862491,
 274774442,
 -1,
 274927779,
 274825972,
 -1,
 274993277,
 274891508,
 -1,
 275058801,
 274957044,
 -1,
 275124329,
 274995439,
 -1,
 -61337,
 275104970,
 983852,
 -61336,
 275143889,
 983849,
 -1,
 275192047,
 983842,
 275386475,
 275104970,
 983845,
 -1,
 275367114,
 983846,
 275517549,
 275351978,
 983850,
 -1,
 275483050,
 983851,
 275648623,
 275471569,
 983843,
 -1,
 275602641,
 983844,
 275841023,
 275594812,
 983847,
 -1,
 275725884,
 983848,
 275910773,
 274995439,
 -1,
 -61325,
 275891402,
 983720,
 -61324,
 275930321,
 983717,
 -1,
 275978479,
 983710,
 276172919,
 275891402,
 983713,
 -1,
 276153546,
 983714,
 276303993,
 276138410,
 983718,
 -1,
 276269482,
 983719,
 276435067,
 276258001,
 983711,
 -1,
 276389073,
 983712,
 276627455,
 276381244,
 983715,
 -1,
 276512316,
 983716,
 276697226,
 274979027,
 -1,
 276762754,
 276633839,
 -1,
 -61312,
 276743370,
 983698,
 -61311,
 276782289,
 983695,
 -1,
 276830447,
 983688,
 277024900,
 276743370,
 983691,
 -1,
 277005514,
 983692,
 277155974,
 276990378,
 983696,
 -1,
 277121450,
 983697,
 277287048,
 277109969,
 983689,
 -1,
 277241041,
 983690,
 277479423,
 277233212,
 983693,
 -1,
 277364284,
 983694,
 277549207,
 276647736,
 -1,
 277614735,
 277485807,
 -1,
 -61299,
 277595338,
 983676,
 -61298,
 277634257,
 983673,
 -1,
 277682415,
 983666,
 277876881,
 277595338,
 983669,
 -1,
 277857482,
 983670,
 278007955,
 277842346,
 983674,
 -1,
 277973418,
 983675,
 278139029,
 277961937,
 983667,
 -1,
 278093009,
 983668,
 278331391,
 278085180,
 983671,
 -1,
 278216252,
 983672,
 278401179,
 277485807,
 -1,
 -61287,
 278381770,
 983742,
 -61286,
 278420689,
 983739,
 -1,
 278468847,
 983732,
 278663325,
 278381770,
 983735,
 -1,
 278643914,
 983736,
 278794399,
 278628778,
 983740,
 -1,
 278759850,
 983741,
 278925473,
 278748369,
 983733,
 -1,
 278879441,
 983734,
 279117823,
 278871612,
 983737,
 -1,
 279002684,
 983738,
 279187659,
 274902412,
 -1,
 279253170,
 279139362,
 -1,
 279318697,
 279189743,
 -1,
 -61273,
 279299274,
 983874,
 -61272,
 279338193,
 983871,
 -1,
 279386351,
 983864,
 279580843,
 279299274,
 983867,
 -1,
 279561418,
 983868,
 279711917,
 279546282,
 983872,
 -1,
 279677354,
 983873,
 279842991,
 279665873,
 983865,
 -1,
 279796945,
 983866,
 279974065,
 279789116,
 983869,
 -1,
 279920188,
 983870,
 -1,
 279947568,
 983920,
 280170687,
 279227788,
 -1,
 280236215,
 280107247,
 -1,
 -61259,
 280216778,
 983885,
 -61258,
 280255697,
 983882,
 -1,
 280303855,
 983875,
 280498361,
 280216778,
 983878,
 -1,
 280478922,
 983879,
 280629435,
 280463786,
 983883,
 -1,
 280594858,
 983884,
 280760509,
 280583377,
 983876,
 -1,
 280714449,
 983877,
 280952831,
 280706620,
 983880,
 -1,
 280837692,
 983881,
 281022659,
 280107247,
 -1,
 -61247,
 281003210,
 983896,
 -61246,
 281042129,
 983893,
 -1,
 281090287,
 983886,
 281284805,
 281003210,
 983889,
 -1,
 281265354,
 983890,
 281415879,
 281250218,
 983894,
 -1,
 281381290,
 983895,
 281546953,
 281369809,
 983887,
 -1,
 281500881,
 983888,
 281739263,
 281493052,
 983891,
 -1,
 281624124,
 983892,
 281809138,
 279146183,
 -1,
 281874662,
 281767623,
 -1,
 281940186,
 281833159,
 -1,
 282005714,
 281876719,
 -1,
 -61232,
 281986250,
 983819,
 -61231,
 282025169,
 983816,
 -1,
 282073327,
 983809,
 282267860,
 281986250,
 983812,
 -1,
 282248394,
 983813,
 282398934,
 282233258,
 983817,
 -1,
 282364330,
 983818,
 282530008,
 282352849,
 983810,
 -1,
 282483921,
 983811,
 282722303,
 282476092,
 983814,
 -1,
 282607164,
 983815,
 282792158,
 281876719,
 -1,
 -61220,
 282772682,
 983830,
 -61219,
 282811601,
 983827,
 -1,
 282859759,
 983820,
 283054304,
 282772682,
 983823,
 -1,
 283034826,
 983824,
 283185378,
 283019690,
 983828,
 -1,
 283150762,
 983829,
 283316452,
 283139281,
 983821,
 -1,
 283270353,
 983822,
 283508735,
 283262524,
 983825,
 -1,
 283393596,
 983826,
 283578602,
 281811183,
 -1,
 -61208,
 283559114,
 983797,
 -61207,
 283598033,
 983794,
 -1,
 283646191,
 983787,
 283840748,
 283559114,
 983790,
 -1,
 283821258,
 983791,
 283971822,
 283806122,
 983795,
 -1,
 283937194,
 983796,
 284102896,
 283925713,
 983788,
 -1,
 284056785,
 983789,
 284295167,
 284048956,
 983792,
 -1,
 284180028,
 983793,
 284365068,
 281766709,
 -1,
 284430592,
 284341875,
 -1,
 284496120,
 284367087,
 983908,
 -61194,
 284476618,
 983919,
 -61193,
 284515537,
 983916,
 -1,
 284563695,
 983909,
 284758266,
 284476618,
 983912,
 -1,
 284738762,
 983913,
 284889340,
 284723626,
 983917,
 -1,
 284854698,
 983918,
 285020414,
 284843217,
 983910,
 -1,
 284974289,
 983911,
 285212671,
 284966460,
 983914,
 -1,
 285097532,
 983915,
 285282564,
 284367087,
 -1,
 -61182,
 285263050,
 983665,
 -61181,
 285301969,
 983662,
 -1,
 285350127,
 983655,
 285544710,
 285263050,
 983658,
 -1,
 285525194,
 983659,
 285675784,
 285510058,
 983663,
 -1,
 285641130,
 983664,
 285806858,
 285629649,
 983656,
 -1,
 285760721,
 983657,
 285999103,
 285752892,
 983660,
 -1,
 285883964,
 983661,
 286069030,
 284342811,
 -1,
 286134554,
 286046747,
 -1,
 286200082,
 286071023,
 -1,
 -61168,
 286180554,
 983709,
 -61167,
 286219473,
 983706,
 -1,
 286267631,
 983699,
 286462228,
 286180554,
 983702,
 -1,
 286442698,
 983703,
 286593302,
 286427562,
 983707,
 -1,
 286558634,
 983708,
 286724376,
 286547153,
 983700,
 -1,
 286678225,
 983701,
 286916607,
 286670396,
 983704,
 -1,
 286801468,
 983705,
 286986526,
 286071023,
 -1,
 -61156,
 286966986,
 983731,
 -61155,
 287005905,
 983728,
 -1,
 287054063,
 983721,
 287248672,
 286966986,
 983724,
 -1,
 287229130,
 983725,
 287379746,
 287213994,
 983729,
 -1,
 287345066,
 983730,
 287510820,
 287333585,
 983722,
 -1,
 287464657,
 983723,
 287703039,
 287456828,
 983726,
 -1,
 287587900,
 983727,
 287772992,
 286040321,
 -1,
 287838516,
 287744257,
 -1,
 287904044,
 287774959,
 -1,
 -61142,
 287884490,
 983841,
 -61141,
 287923409,
 983838,
 -1,
 287971567,
 983831,
 288166190,
 287884490,
 983834,
 -1,
 288146634,
 983835,
 288297264,
 288131498,
 983839,
 -1,
 288262570,
 983840,
 288428338,
 288251089,
 983832,
 -1,
 288382161,
 983833,
 288620543,
 288374332,
 983836,
 -1,
 288505404,
 983837,
 288690488,
 287774959,
 -1,
 -61130,
 288670922,
 983786,
 -61129,
 288709841,
 983783,
 -1,
 288757999,
 983776,
 288952634,
 288670922,
 983779,
 -1,
 288933066,
 983780,
 289083708,
 288917930,
 983784,
 -1,
 289049002,
 983785,
 289214782,
 289037521,
 983777,
 -1,
 289168593,
 983778,
 289406975,
 289160764,
 983781,
 -1,
 289291836,
 983782,
 289476941,
 287758547,
 -1,
 289542469,
 289413359,
 -1,
 -61117,
 289522890,
 983775,
 -61116,
 289561809,
 983772,
 -1,
 289609967,
 983765,
 289804615,
 289522890,
 983768,
 -1,
 289785034,
 983769,
 289935689,
 289769898,
 983773,
 -1,
 289900970,
 983774,
 290066763,
 289889489,
 983766,
 -1,
 290020561,
 983767,
 290258943,
 290012732,
 983770,
 -1,
 290143804,
 983771,
 290328922,
 289459322,
 -1,
 290394450,
 290265327,
 -1,
 -61104,
 290374858,
 983808,
 -61103,
 290413777,
 983805,
 -1,
 290461935,
 983798,
 290656596,
 290374858,
 983801,
 -1,
 290637002,
 983802,
 290787670,
 290621866,
 983806,
 -1,
 290752938,
 983807,
 290918744,
 290741457,
 983799,
 -1,
 290872529,
 983800,
 291110911,
 290864700,
 983803,
 -1,
 290995772,
 983804,
 291180903,
 290297710,
 -1,
 291246431,
 291117295,
 -1,
 -61091,
 291226826,
 983753,
 -61090,
 291265745,
 983750,
 -1,
 291313903,
 983743,
 291508577,
 291226826,
 983746,
 -1,
 291488970,
 983747,
 291639651,
 291473834,
 983751,
 -1,
 291604906,
 983752,
 291770725,
 291593425,
 983744,
 -1,
 291724497,
 983745,
 291962879,
 291716668,
 983748,
 -1,
 291847740,
 983749,
 292032884,
 291142335,
 -1,
 292098412,
 291969263,
 -1,
 -61078,
 292078794,
 983764,
 -61077,
 292117713,
 983761,
 -1,
 292165871,
 983754,
 292360558,
 292078794,
 983757,
 -1,
 292340938,
 983758,
 292491632,
 292325802,
 983762,
 -1,
 292456874,
 983763,
 292622706,
 292445393,
 983755,
 -1,
 292576465,
 983756,
 292814847,
 292568636,
 983759,
 -1,
 292699708,
 983760,
 292884865,
 291990025,
 -1,
 292950393,
 292821231,
 -1,
 -61065,
 292930762,
 983863,
 -61064,
 292969681,
 983860,
 -1,
 293017839,
 983853,
 293212539,
 292930762,
 983856,
 -1,
 293192906,
 983857,
 293343613,
 293177770,
 983861,
 -1,
 293308842,
 983862,
 293474687,
 293297361,
 983854,
 -1,
 293428433,
 983855,
 293666815,
 293420604,
 983858,
 -1,
 293551676,
 983859,
 293736846,
 292836386,
 -1,
 293802374,
 293673199,
 -1,
 -61052,
 293782730,
 983907,
 -61051,
 293821649,
 983904,
 -1,
 293869807,
 983897,
 294064520,
 293782730,
 983900,
 -1,
 294044874,
 983901,
 294195594,
 294029738,
 983905,
 -1,
 294160810,
 983906,
 294326668,
 294149329,
 983898,
 -1,
 294280401,
 983899,
 294518783,
 294272572,
 983902,
 -1,
 294403644,
 983903,
 294649855,
 293677954,
 -1,
 294654355,
 294525167,
 -1,
 -61039,
 294634698,
 983687,
 -61038,
 294673617,
 983684,
 -1,
 294721775,
 983677,
 294916501,
 294634698,
 983680,
 -1,
 294896842,
 983681,
 295047575,
 294881706,
 983685,
 -1,
 295012778,
 983686,
 295178649,
 295001297,
 983678,
 -1,
 295132369,
 983679,
 295370751,
 295124540,
 983682,
 -1,
 295255612,
 983683,
 295440822,
 274803586,
 -1,
 295506357,
 295407365,
 -1,
 295571874,
 295469812,
 983638,
 295637408,
 295535348,
 983636,
 -1,
 295600884,
 983648,
 -61023,
 295622867,
 983634,
 -1,
 295718712,
 983632,
 295899557,
 295546252,
 983652,
 -61020,
 295873932,
 983651,
 -1,
 295916578,
 983650,
 296096168,
 295857863,
 983643,
 296222719,
 296054471,
 983646,
 -1,
 296120007,
 983645,
 296292778,
 296073755,
 983637,
 -1,
 296270363,
 983635,
 296423852,
 296263937,
 983642,
 -1,
 296395009,
 983647,
 296554926,
 296381237,
 983631,
 -1,
 296531571,
 983654,
 -61009,
 296540371,
 983641,
 -61008,
 296668282,
 983644,
 -61007,
 296720238,
 983639,
 -61006,
 296778431,
 983640,
 -61005,
 296839689,
 983649,
 -61004,
 296899618,
 983653,
 -1,
 296954754,
 983633,
 -1,
 295478501,
 3063,
 297210298,
 295384541,
 -1,
 -61000,
 297164899,
 3046,
 -60999,
 297222211,
 3062,
 -1,
 297280886,
 3059,
 -60997,
 297195940,
 3061,
 -60996,
 297446744,
 3065,
 -60995,
 297503932,
 3024,
 -60994,
 297568488,
 3066,
 -60993,
 297632135,
 3060,
 -60992,
 297694510,
 2998,
 -1,
 297739019,
 3064,
 297931506,
 274750675,
 -1,
 297996906,
 297909496,
 -1,
 298062343,
 297956572,
 -1,
 298127836,
 298020551,
 -1,
 298193368,
 298096281,
 -1,
 298258890,
 298150709,
 -1,
 -60984,
 298244096,
 6692,
 -60983,
 298275896,
 6693,
 -1,
 298326255,
 6691,
 298521037,
 298236443,
 -1,
 -60980,
 298472504,
 6709,
 -1,
 298522863,
 6708,
 298717648,
 298489710,
 -1,
 -60977,
 298669112,
 6717,
 -1,
 298719471,
 6715,
 298914259,
 298658690,
 -1,
 -60974,
 298865720,
 6699,
 -1,
 298916079,
 6697,
 -60972,
 298899756,
 6719,
 -60971,
 299085343,
 6698,
 -60970,
 299148049,
 6704,
 -60969,
 299193400,
 6732,
 -1,
 299256333,
 6716,
 299438554,
 298129647,
 6723,
 -1,
 299384380,
 6739,
 -60965,
 299419381,
 6724,
 -1,
 299527941,
 6730,
 299700722,
 298080325,
 -1,
 299766241,
 299675020,
 -1,
 -60961,
 299740703,
 6727,
 -60960,
 299783224,
 6726,
 -1,
 299833583,
 6728,
 300028389,
 299723573,
 -1,
 -60957,
 300013568,
 6690,
 -60956,
 300045368,
 6689,
 -1,
 300095727,
 6688,
 300290536,
 300005915,
 -1,
 -60953,
 300241976,
 6707,
 -1,
 300292335,
 6706,
 300487147,
 300259182,
 -1,
 -60950,
 300438584,
 6713,
 -1,
 300488943,
 6712,
 300683758,
 300428162,
 -1,
 -60947,
 300635192,
 6696,
 -1,
 300685551,
 6695,
 -60945,
 300669228,
 6720,
 -60944,
 300851985,
 6702,
 -60943,
 300897336,
 6729,
 -1,
 300960269,
 6714,
 301142519,
 299671809,
 -1,
 301208054,
 301078767,
 6721,
 -60939,
 301185693,
 6701,
 -1,
 301237073,
 6705,
 -1,
 301188853,
 6722,
 301470203,
 301105908,
 -1,
 -60935,
 301455660,
 6700,
 -60934,
 301485959,
 6694,
 -1,
 301537519,
 6710,
 301732349,
 301450442,
 6735,
 -1,
 301712586,
 6736,
 301863423,
 301685969,
 6733,
 -1,
 301817041,
 6734,
 -60928,
 301846860,
 6725,
 -60927,
 301961017,
 6738,
 -60926,
 302021397,
 6718,
 -60925,
 302076764,
 6740,
 -60924,
 302137581,
 6737,
 -60923,
 302200427,
 6703,
 -60922,
 302261735,
 6711,
 -1,
 302323951,
 6731,
 302518825,
 298037903,
 -1,
 302584338,
 302476085,
 -1,
 302649871,
 302537790,
 -1,
 302715406,
 302582465,
 -1,
 -60916,
 302650599,
 6777,
 -60915,
 302715923,
 6776,
 -1,
 302781173,
 6775,
 -1,
 302649012,
 6780,
 303043089,
 302586291,
 6824,
 -1,
 303001242,
 6825,
 -1,
 302990608,
 6819,
 303239703,
 302558751,
 -1,
 303305237,
 303218667,
 6826,
 -1,
 303263386,
 6827,
 -60906,
 303288733,
 6818,
 -1,
 303394360,
 6752,
 303567388,
 303201148,
 -1,
 303632922,
 303524848,
 6772,
 -1,
 303563785,
 6744,
 -60901,
 303618417,
 6823,
 -1,
 303738512,
 6779,
 303895070,
 303551501,
 6816,
 -1,
 303878483,
 6817,
 304026145,
 303874153,
 -1,
 -60896,
 303960528,
 6774,
 -1,
 304025765,
 6773,
 304222756,
 303997185,
 -1,
 -60893,
 304171115,
 6822,
 -1,
 304224520,
 6778,
 304419367,
 304174114,
 -1,
 -60890,
 304387890,
 6820,
 -1,
 304422881,
 6828,
 -60888,
 304363985,
 6821,
 -1,
 304556983,
 6829,
 304747071,
 302502040,
 -1,
 304812592,
 304712106,
 6763,
 304878126,
 304748785,
 -1,
 -60883,
 304818060,
 6764,
 -1,
 304880161,
 6771,
 -60881,
 304863443,
 6765,
 -1,
 305039786,
 6768,
 305205812,
 304792778,
 6761,
 305271347,
 305185994,
 6762,
 -1,
 305217084,
 6760,
 -1,
 305217084,
 6759,
 305467960,
 305141999,
 6753,
 -60874,
 305421521,
 6769,
 -60873,
 305479228,
 6767,
 -1,
 305535215,
 6755,
 305730107,
 305445403,
 -1,
 -60870,
 305681691,
 6770,
 -1,
 305733226,
 6756,
 305926717,
 305683665,
 6757,
 -1,
 305880273,
 6758,
 -60866,
 305888135,
 6754,
 -1,
 306003516,
 6766,
 306188877,
 304725246,
 -1,
 306254403,
 306166299,
 -1,
 -60862,
 306238986,
 6802,
 -1,
 306273088,
 6803,
 306451014,
 306228620,
 -1,
 -60859,
 306407811,
 6806,
 -1,
 306464735,
 6807,
 306647625,
 306399672,
 -1,
 -60856,
 306615236,
 6804,
 -1,
 306669777,
 6805,
 -60854,
 306633713,
 6800,
 -60853,
 306810292,
 6801,
 -60852,
 306873904,
 6809,
 -1,
 306922037,
 6808,
 307106395,
 306141745,
 -1,
 307171921,
 307083803,
 -1,
 -60848,
 307156490,
 6786,
 -1,
 307190592,
 6787,
 307368532,
 307146124,
 -1,
 -60845,
 307325315,
 6790,
 -1,
 307382239,
 6791,
 307565143,
 307317176,
 -1,
 -60842,
 307532740,
 6788,
 -1,
 307587281,
 6789,
 -60840,
 307551217,
 6784,
 -60839,
 307727796,
 6785,
 -60838,
 307791408,
 6793,
 -1,
 307839541,
 6792,
 308084735,
 307048762,
 -1,
 308089449,
 307988500,
 -1,
 308154978,
 308050623,
 -1,
 308220513,
 308101331,
 -1,
 -60832,
 308191611,
 6741,
 -1,
 308244229,
 6742,
 -1,
 308156655,
 6748,
 308482661,
 308113095,
 -1,
 -60828,
 308450981,
 6746,
 -1,
 308484442,
 6743,
 -60826,
 308456991,
 6750,
 -60825,
 308631627,
 6747,
 -60824,
 308693853,
 6745,
 -1,
 308749799,
 6749,
 -1,
 308051278,
 6783,
 309007048,
 297979742,
 -1,
 309072554,
 308966620,
 -1,
 309138059,
 309033215,
 -1,
 309203569,
 309101300,
 -1,
 -60817,
 309189287,
 43664,
 -60816,
 309234090,
 43672,
 -1,
 309285564,
 43656,
 309465718,
 309160757,
 -1,
 309531253,
 309416994,
 -1,
 -60812,
 309496234,
 43650,
 -1,
 309549459,
 43652,
 -1,
 309496234,
 43648,
 309793401,
 309443099,
 -1,
 -60808,
 309758378,
 43668,
 -1,
 309811603,
 43670,
 309990012,
 309761902,
 -1,
 -60805,
 309954986,
 43676,
 -1,
 310008211,
 43678,
 310186623,
 309930882,
 -1,
 -60802,
 310151594,
 43658,
 -1,
 310204819,
 43660,
 -60800,
 310172327,
 43684,
 -60799,
 310366113,
 43690,
 -60798,
 310424869,
 43662,
 -60797,
 310487832,
 43686,
 -60796,
 310544810,
 43694,
 -60795,
 310608130,
 43682,
 -60794,
 310671399,
 43688,
 -60793,
 310729107,
 43692,
 -60792,
 310792892,
 43654,
 -60791,
 310856929,
 43680,
 -60790,
 310917549,
 43666,
 -1,
 310978957,
 43674,
 311230463,
 309090373,
 -1,
 311235216,
 311132916,
 -1,
 -60786,
 311220903,
 43665,
 -60785,
 311265706,
 43673,
 -1,
 311317180,
 43657,
 311497365,
 311192373,
 -1,
 311562900,
 311448610,
 -1,
 -60781,
 311527850,
 43651,
 -1,
 311581075,
 43653,
 -1,
 311527850,
 43649,
 311825048,
 311474715,
 -1,
 -60777,
 311789994,
 43669,
 -1,
 311843219,
 43671,
 312021659,
 311793518,
 -1,
 -60774,
 311986602,
 43677,
 -1,
 312039827,
 43679,
 312218270,
 311962498,
 -1,
 -60771,
 312183210,
 43659,
 -1,
 312236435,
 43661,
 -60769,
 312203943,
 43685,
 -60768,
 312397729,
 43691,
 -60767,
 312456485,
 43663,
 -60766,
 312519448,
 43687,
 -60765,
 312576426,
 43695,
 -60764,
 312639746,
 43683,
 -60763,
 312703015,
 43689,
 -60762,
 312760723,
 43693,
 -60761,
 312824508,
 43655,
 -60760,
 312888545,
 43681,
 -60759,
 312949165,
 43667,
 -1,
 313010573,
 43675,
 313201337,
 309055574,
 -1,
 313266865,
 313137391,
 -1,
 -60755,
 313252051,
 43708,
 -60754,
 313313013,
 43707,
 -60753,
 313361140,
 43709,
 -60752,
 313424575,
 43710,
 -1,
 313465071,
 43697,
 313660085,
 313246922,
 43700,
 313725620,
 313605692,
 43699,
 -1,
 313661679,
 43705,
 -1,
 313661679,
 43706,
 313922231,
 313613521,
 43698,
 -1,
 313858287,
 43704,
 -60744,
 313887146,
 43702,
 -1,
 313998908,
 43701,
 314184384,
 313178591,
 -1,
 314249917,
 314142189,
 -1,
 -60740,
 314213108,
 43739,
 -1,
 314268900,
 43743,
 -60738,
 314224272,
 43741,
 -60737,
 314411216,
 43740,
 -1,
 314464662,
 43742,
 314643141,
 314163295,
 -1,
 -60734,
 314621329,
 43713,
 -60733,
 314684775,
 43714,
 -60732,
 314738896,
 43712,
 -1,
 314786474,
 43711,
 315031551,
 314604417,
 -1,
 -60729,
 314923317,
 43703,
 -1,
 314974177,
 43696,
 315228159,
 308965822,
 -1,
 315232981,
 315144731,
 -1,
 315298512,
 315199052,
 -1,
 -60724,
 315233756,
 6516,
 -60723,
 315299047,
 6515,
 -60722,
 315364371,
 6514,
 -60721,
 315429621,
 6513,
 -1,
 315494864,
 6512,
 315691731,
 315272588,
 -1,
 -60718,
 315642936,
 6497,
 -1,
 315693295,
 6483,
 -60716,
 315642936,
 6487,
 -1,
 315824367,
 6486,
 316019416,
 315178556,
 6507,
 -60713,
 315970594,
 6502,
 -1,
 316030524,
 6501,
 316216027,
 315955439,
 6499,
 -60710,
 316196597,
 6508,
 -1,
 316234961,
 6509,
 316412637,
 316196042,
 6503,
 -1,
 316358204,
 6506,
 316543712,
 316381038,
 -1,
 -60705,
 316494904,
 6490,
 -1,
 316545263,
 6489,
 316740322,
 316508586,
 6505,
 -1,
 316705194,
 6504,
 316871397,
 316703476,
 -1,
 -60700,
 316821383,
 6482,
 -1,
 316872943,
 6498,
 317068008,
 316828469,
 -1,
 -60697,
 317019192,
 6496,
 -1,
 317069551,
 6480,
 -60695,
 317053228,
 6485,
 -60694,
 317249536,
 6481,
 -60693,
 317312144,
 6493,
 -60692,
 317369887,
 6484,
 -60691,
 317431658,
 6495,
 -60690,
 317487893,
 6491,
 -60689,
 317550341,
 6488,
 -60688,
 317611217,
 6500,
 -60687,
 317674552,
 6494,
 -1,
 317737485,
 6492,
 317920075,
 297889365,
 -1,
 317985580,
 317879516,
 -1,
 318051066,
 317962779,
 -1,
 318116600,
 318028315,
 -1,
 -60681,
 318067768,
 71317,
 -1,
 318118127,
 71316,
 -60679,
 318067768,
 71322,
 -1,
 318249199,
 71321,
 318444287,
 318014196,
 -1,
 -60676,
 318429484,
 71315,
 -60675,
 318473041,
 71320,
 -60674,
 318525319,
 71310,
 -1,
 318576879,
 71325,
 318771973,
 318387677,
 -1,
 318837507,
 318715357,
 -1,
 -60670,
 318788664,
 71319,
 -1,
 318839023,
 71318,
 -60668,
 318788664,
 71324,
 -1,
 318970095,
 71323,
 319165193,
 318707951,
 71296,
 -60665,
 319145162,
 71305,
 -60664,
 319184081,
 71303,
 -1,
 319232239,
 71297,
 319427339,
 319145162,
 71300,
 -1,
 319407306,
 71301,
 319558414,
 319401356,
 -1,
 -60659,
 319509560,
 71335,
 -1,
 319559919,
 71336,
 319755025,
 319529217,
 -1,
 -60656,
 319725947,
 71338,
 -1,
 319756527,
 71332,
 319951636,
 319723374,
 -1,
 -60653,
 319902776,
 71327,
 -1,
 319953135,
 71326,
 320148247,
 319908661,
 -1,
 -60650,
 320099384,
 71307,
 -1,
 320149743,
 71306,
 320344858,
 320104969,
 -1,
 -60647,
 320295992,
 71314,
 -1,
 320346351,
 71313,
 320541468,
 320298193,
 71298,
 -1,
 320494801,
 71299,
 320672543,
 320491320,
 -1,
 -60642,
 320623672,
 71309,
 -1,
 320674031,
 71308,
 320869154,
 320613250,
 -1,
 -60639,
 320820280,
 71312,
 -1,
 320870639,
 71311,
 321065765,
 320808370,
 -1,
 -60636,
 321016888,
 71329,
 -1,
 321067247,
 71328,
 -60634,
 321050924,
 71331,
 -60633,
 321244304,
 71334,
 -60632,
 321292714,
 71304,
 -60631,
 321354517,
 71330,
 -60630,
 321416965,
 71333,
 -60629,
 321475640,
 71337,
 -1,
 321535548,
 71302,
 321721146,
 317929692,
 -1,
 321786672,
 321698331,
 -1,
 -60625,
 321771018,
 71362,
 -1,
 321805120,
 71363,
 321983283,
 321760652,
 -1,
 -60622,
 321939843,
 71366,
 -1,
 321996767,
 71367,
 322179894,
 321931704,
 -1,
 -60619,
 322147268,
 71364,
 -1,
 322201809,
 71365,
 -60617,
 322165745,
 71360,
 -60616,
 322342324,
 71361,
 -60615,
 322405936,
 71369,
 -1,
 322454069,
 71368,
 322638661,
 321704088,
 -1,
 322704191,
 322574575,
 -1,
 -60611,
 322684106,
 71349,
 -60610,
 322723025,
 71347,
 -1,
 322771183,
 71341,
 322966337,
 322684106,
 71344,
 -1,
 322946250,
 71345,
 323097411,
 322919633,
 71342,
 -1,
 323050705,
 71343,
 -60604,
 323062186,
 71348,
 -1,
 323173948,
 71346,
 323420159,
 322613903,
 -1,
 323425097,
 323342142,
 -1,
 -60600,
 323399382,
 71340,
 -1,
 323461799,
 71350,
 -60598,
 323389654,
 71351,
 -1,
 323559590,
 71339,
 323752781,
 317859250,
 983061,
 -1,
 323711433,
 127955,
 -60594,
 323737717,
 128661,
 -60593,
 323852656,
 128429,
 -1,
 323891514,
 127790,
 324080678,
 219241681,
 -1,
 324146113,
 324051201,
 -1,
 324211648,
 324099223,
 -1,
 324277137,
 324170972,
 -1,
 324342619,
 324258938,
 -1,
 324408154,
 324307508,
 -1,
 324473688,
 324378881,
 70791,
 -1,
 324444417,
 70792,
 324665343,
 324431559,
 70793,
 -1,
 324562631,
 70794,
 -1,
 324344047,
 70827,
 324801377,
 324319771,
 -1,
 324866911,
 324778523,
 -1,
 -60578,
 324817976,
 70810,
 -1,
 324868335,
 70809,
 -60576,
 324817976,
 70815,
 -1,
 324999407,
 70814,
 325194598,
 324764404,
 -1,
 -60573,
 325179692,
 70808,
 -60572,
 325223249,
 70813,
 -60571,
 325275527,
 70803,
 -1,
 325327087,
 70818,
 325522284,
 325137885,
 -1,
 325587818,
 325465565,
 -1,
 -60567,
 325538872,
 70812,
 -1,
 325589231,
 70811,
 -60565,
 325538872,
 70817,
 -1,
 325720303,
 70816,
 325915504,
 325458159,
 70785,
 -60562,
 325895370,
 70798,
 -60561,
 325934289,
 70796,
 -1,
 325982447,
 70786,
 326177652,
 325889420,
 -1,
 -60558,
 326151711,
 70829,
 -60557,
 326194232,
 70828,
 -1,
 326244591,
 70830,
 326439798,
 326157514,
 70789,
 -1,
 326419658,
 70790,
 326570873,
 326408046,
 -1,
 -60552,
 326521912,
 70820,
 -1,
 326572271,
 70819,
 326767484,
 326527797,
 -1,
 -60549,
 326718520,
 70800,
 -1,
 326768879,
 70799,
 326964095,
 326724105,
 -1,
 -60546,
 326915128,
 70807,
 -1,
 326965487,
 70806,
 327160705,
 326917329,
 70787,
 -1,
 327113937,
 70788,
 327291780,
 327110456,
 -1,
 -60541,
 327242808,
 70802,
 -1,
 327293167,
 70801,
 327488391,
 327232386,
 -1,
 -60538,
 327439416,
 70805,
 -1,
 327489775,
 70804,
 327685002,
 327427506,
 -1,
 -60535,
 327636024,
 70822,
 -1,
 327686383,
 70821,
 -60533,
 327670060,
 70824,
 -60532,
 327852411,
 70825,
 -60531,
 327911850,
 70797,
 -60530,
 327973653,
 70823,
 -60529,
 328036101,
 70826,
 -60528,
 328094776,
 70831,
 -1,
 328154684,
 70795,
 328340388,
 324259992,
 -1,
 328405911,
 328323003,
 -1,
 328471445,
 328376577,
 70837,
 -1,
 328442113,
 70838,
 328663039,
 328429255,
 70839,
 -1,
 328560327,
 70840,
 328733595,
 328341743,
 -1,
 -60519,
 328713418,
 70846,
 -60518,
 328752337,
 70843,
 -1,
 328800495,
 70832,
 328995741,
 328713418,
 70835,
 -1,
 328975562,
 70836,
 329126816,
 328970670,
 -1,
 -60513,
 329091498,
 70845,
 -1,
 329137724,
 70842,
 329323426,
 329080017,
 70833,
 -1,
 329276625,
 70834,
 -60509,
 329288106,
 70844,
 -1,
 329399868,
 70841,
 329585586,
 328284380,
 -1,
 329651112,
 329562651,
 -1,
 -60505,
 329635338,
 70866,
 -1,
 329669440,
 70867,
 329847723,
 329624972,
 -1,
 -60502,
 329804163,
 70870,
 -1,
 329861087,
 70871,
 330044334,
 329796024,
 -1,
 -60499,
 330011588,
 70868,
 -1,
 330066129,
 70869,
 -60497,
 330030065,
 70864,
 -60496,
 330206644,
 70865,
 -60495,
 330270256,
 70873,
 -1,
 330318389,
 70872,
 330503099,
 329560719,
 -1,
 330568630,
 330485566,
 -1,
 -60491,
 330542806,
 70849,
 -1,
 330605223,
 70850,
 330765241,
 330504431,
 -1,
 -60488,
 330747027,
 70852,
 -1,
 330795301,
 70848,
 -60486,
 330729686,
 70851,
 -1,
 330902601,
 70847,
 331092926,
 330438895,
 -1,
 -60483,
 331056826,
 70784,
 -1,
 331097906,
 70854,
 -60481,
 331058364,
 70855,
 -1,
 331240419,
 70853,
 -1,
 324157567,
 128555,
 331486212,
 324094777,
 -1,
 331551745,
 331445468,
 -1,
 331617263,
 331536595,
 -1,
 331682794,
 331553007,
 11568,
 331748297,
 331625949,
 11575,
 331813832,
 331691485,
 11577,
 -1,
 331764770,
 11578,
 -1,
 331764770,
 11576,
 332010444,
 331733807,
 11619,
 -60469,
 331995951,
 11621,
 -1,
 332026914,
 11594,
 332207055,
 331987483,
 11612,
 -60466,
 332184091,
 11615,
 -1,
 332223522,
 11613,
 332403666,
 332180876,
 11609,
 -60463,
 332377484,
 11610,
 -1,
 332420130,
 11611,
 332600277,
 332360501,
 11581,
 332726271,
 332551202,
 11589,
 -1,
 332616738,
 11583,
 332796888,
 332549944,
 11571,
 332922879,
 332747810,
 11606,
 -1,
 332813346,
 11572,
 332993498,
 332767489,
 11604,
 -1,
 332964097,
 11605,
 333124572,
 332944418,
 11584,
 -1,
 333075490,
 11587,
 333255646,
 333063602,
 11569,
 -1,
 333206562,
 11570,
 -60449,
 333240531,
 11618,
 -60448,
 333369612,
 11617,
 -60447,
 333433978,
 11616,
 -60446,
 333487947,
 11591,
 -60445,
 333551470,
 11602,
 -60444,
 333611764,
 11599,
 -60443,
 333675199,
 11598,
 -60442,
 333737671,
 11597,
 -60441,
 333801993,
 11574,
 -60440,
 333859256,
 11580,
 -60439,
 333917680,
 11614,
 -1,
 333977839,
 11588,
 334173164,
 331628092,
 11622,
 -1,
 334158035,
 11579,
 -60435,
 334152906,
 11603,
 -60434,
 334268842,
 11623,
 -1,
 334322897,
 11593,
 334500859,
 331594267,
 -1,
 334566394,
 334480799,
 -1,
 334631923,
 334523189,
 11582,
 -1,
 334582818,
 11590,
 334762998,
 334581560,
 -1,
 -60427,
 334725876,
 11600,
 -1,
 334779426,
 11607,
 -60425,
 334748718,
 11596,
 -60424,
 334929739,
 11592,
 -60423,
 334988648,
 11601,
 -1,
 335041570,
 11586,
 -1,
 334505317,
 11620,
 335287294,
 334440379,
 -1,
 -60419,
 335243785,
 11573,
 -1,
 335303714,
 11585,
 335544319,
 335223023,
 -1,
 -60416,
 335469060,
 11608,
 -1,
 335500387,
 11595,
 -60414,
 331526102,
 11632,
 -60413,
 335642916,
 11631,
 -1,
 335688259,
 11647,
 335877146,
 331425758,
 -1,
 335942671,
 335838357,
 -1,
 336008201,
 335881650,
 -1,
 -60408,
 335983502,
 4048,
 -1,
 336030613,
 983208,
 -60406,
 335986989,
 4058,
 -60405,
 336169365,
 4050,
 -60404,
 336232683,
 4049,
 -60403,
 336294416,
 4057,
 -60402,
 336356443,
 4051,
 -1,
 336408840,
 4052,
 336598039,
 335916428,
 -1,
 336663572,
 336578012,
 -1,
 -60398,
 336625055,
 3982,
 -60397,
 336687421,
 3981,
 -1,
 336750044,
 3983,
 336986111,
 336617581,
 -1,
 -60394,
 336896963,
 4046,
 -1,
 336946652,
 3980,
 337182719,
 336557276,
 -1,
 -60391,
 337095765,
 3948,
 -1,
 337145304,
 3947,
 337318945,
 335835542,
 -1,
 337384480,
 337302660,
 -1,
 337450015,
 337328626,
 -1,
 -60386,
 337389452,
 11807,
 -1,
 337451553,
 11806,
 -1,
 337422694,
 11803,
 -1,
 337350762,
 11081,
 337777699,
 337269045,
 128005,
 -1,
 337707740,
 128047,
 -60380,
 337742165,
 68410,
 -60379,
 337870554,
 9202,
 -1,
 337916024,
 127915,
 338105540,
 324025916,
 -1,
 338171037,
 338084116,
 -1,
 338236474,
 338111362,
 -1,
 338302003,
 338201002,
 -1,
 338367536,
 338264820,
 -1,
 338433071,
 338344475,
 -1,
 -60371,
 338404089,
 119563,
 -60370,
 338445505,
 119582,
 -1,
 338500316,
 119573,
 -1,
 338409236,
 119608,
 338821119,
 338330105,
 -1,
 -60366,
 338714066,
 119634,
 -1,
 338773764,
 119630,
 338957368,
 338262200,
 -1,
 339022903,
 338902588,
 -1,
 -60362,
 338986260,
 119590,
 -1,
 339031585,
 119613,
 -1,
 339004176,
 119631,
 -60359,
 338908645,
 119585,
 -1,
 339231944,
 119558,
 339416136,
 338179549,
 -1,
 339481665,
 339369169,
 -1,
 339547199,
 339442367,
 -1,
 -60354,
 339509343,
 119625,
 -1,
 339567688,
 119612,
 -60352,
 339529216,
 119568,
 -1,
 339692256,
 119636,
 339874885,
 339426876,
 -1,
 -60349,
 339843408,
 119623,
 -60348,
 339888758,
 119567,
 -1,
 339947537,
 119586,
 -60346,
 339856457,
 119584,
 -60345,
 340104053,
 119619,
 -1,
 340140494,
 119624,
 340333649,
 339361340,
 -1,
 340399181,
 340296436,
 -1,
 -60341,
 340357261,
 119603,
 -60340,
 340408160,
 119583,
 -1,
 340472667,
 119600,
 -60338,
 340383840,
 119626,
 -60337,
 340638899,
 119610,
 -60336,
 340688188,
 119618,
 -1,
 340730692,
 119580,
 340923483,
 340304129,
 -1,
 340989018,
 340868668,
 -1,
 341054552,
 340962700,
 -1,
 341120087,
 341007569,
 -1,
 -60330,
 341096205,
 119579,
 -1,
 341129106,
 119596,
 -1,
 341089583,
 119598,
 -60327,
 341013045,
 119578,
 -1,
 341318284,
 119572,
 -1,
 340945096,
 119605,
 341578852,
 340871608,
 -1,
 341644383,
 341559209,
 -1,
 -60322,
 341607700,
 119595,
 -1,
 341639685,
 119559,
 341840994,
 341608874,
 -1,
 -60319,
 341817169,
 119638,
 -1,
 341866506,
 119576,
 -60317,
 341800477,
 119606,
 -1,
 341974252,
 119632,
 342168684,
 341552524,
 -1,
 342234218,
 342145563,
 -1,
 342299753,
 342198698,
 -1,
 -60312,
 342281573,
 119601,
 -1,
 342334858,
 119628,
 -1,
 342271363,
 119593,
 -60309,
 342189183,
 119621,
 -1,
 342509630,
 119627,
 342692978,
 342118200,
 -1,
 342758511,
 342631482,
 119592,
 -1,
 342688624,
 119615,
 -60304,
 342738324,
 119614,
 -60303,
 342860891,
 119602,
 -1,
 342920069,
 119599,
 343086200,
 342660974,
 -1,
 343151734,
 343021807,
 -1,
 -60299,
 343130874,
 119604,
 -1,
 343158925,
 119588,
 -60297,
 343132973,
 119594,
 -1,
 343295019,
 119571,
 343479421,
 343021807,
 -1,
 -60294,
 343453418,
 119564,
 -60293,
 343495026,
 119633,
 -60292,
 343555596,
 119577,
 -1,
 343616845,
 119617,
 343807105,
 343440063,
 -1,
 -60289,
 343762717,
 119560,
 -60288,
 343818241,
 119609,
 -1,
 343876486,
 119616,
 344069254,
 343764679,
 -1,
 344134789,
 344004847,
 -1,
 -60284,
 344117518,
 119597,
 -1,
 344140346,
 119637,
 -1,
 344080866,
 119589,
 344396938,
 344008114,
 -1,
 -60280,
 344367797,
 119566,
 -60279,
 344427597,
 119587,
 -1,
 344466027,
 119561,
 344659085,
 344379724,
 -1,
 -60276,
 344636322,
 119620,
 -1,
 344680599,
 119575,
 344855696,
 344623530,
 -1,
 -60273,
 344825278,
 119565,
 -1,
 344883972,
 119635,
 345052307,
 344812341,
 -1,
 -60270,
 345007301,
 119591,
 -1,
 345063757,
 119562,
 345248918,
 345006466,
 -1,
 -60267,
 345212153,
 119622,
 -1,
 345256851,
 119570,
 345445529,
 345199650,
 -1,
 -60264,
 345410675,
 119574,
 -1,
 345448872,
 119629,
 -60262,
 345430730,
 119569,
 -60261,
 345623882,
 119607,
 -60260,
 345688303,
 119611,
 -1,
 345729796,
 119581,
 345904317,
 338128583,
 -1,
 345969846,
 345884466,
 -1,
 346035371,
 345919063,
 -1,
 346100903,
 346012187,
 -1,
 346166436,
 346085014,
 -1,
 -60253,
 346131098,
 3194,
 -1,
 346179582,
 3197,
 346423295,
 346119105,
 -1,
 -60250,
 346327706,
 3195,
 -1,
 346376190,
 3198,
 346559658,
 346066384,
 -1,
 -60247,
 346524314,
 3193,
 -1,
 346572798,
 3196,
 -1,
 346545148,
 3192,
 346821808,
 345994460,
 -1,
 -60243,
 346800823,
 3160,
 -60242,
 346860679,
 3162,
 -60241,
 346912756,
 3124,
 -1,
 346963503,
 3161,
 347149492,
 346796687,
 -1,
 -60238,
 347128796,
 3199,
 -60237,
 347156866,
 3072,
 -1,
 347219230,
 3133,
 347471871,
 347132102,
 3170,
 -1,
 347369159,
 3171,
 347602943,
 345914940,
 -1,
 347608251,
 347511516,
 -1,
 347673786,
 347579492,
 128222,
 -1,
 347606327,
 128380,
 -1,
 347639136,
 128384,
 -60228,
 347590543,
 128250,
 -1,
 347844362,
 128301,
 348001473,
 345866996,
 -1,
 -60225,
 347978267,
 9978,
 -60224,
 348030604,
 127934,
 -1,
 348082384,
 8376,
 348323839,
 347937007,
 -1,
 -60221,
 348234058,
 128198,
 -1,
 348271940,
 127861,
 348460270,
 338056226,
 -1,
 348525792,
 348431600,
 -1,
 348591320,
 348454912,
 -1,
 348656844,
 348562270,
 -1,
 -60215,
 348628806,
 128487,
 -60214,
 348680829,
 128486,
 -60213,
 348727180,
 128485,
 -1,
 348789281,
 128484,
 348984529,
 348614343,
 -1,
 349050064,
 348938944,
 -1,
 -60209,
 349022022,
 9886,
 -1,
 349074045,
 9887,
 -1,
 348996050,
 11057,
 349312212,
 348927453,
 -1,
 -60205,
 349278838,
 8278,
 -1,
 349331767,
 10176,
 -60203,
 349287866,
 128491,
 -60202,
 349477999,
 128962,
 -60201,
 349537561,
 128423,
 -1,
 349580125,
 128433,
 349831167,
 348524066,
 -1,
 349836511,
 349713887,
 -1,
 349902045,
 349814946,
 -1,
 -60196,
 349874447,
 11162,
 -1,
 349926376,
 11160,
 -60194,
 349874256,
 11161,
 -1,
 350057287,
 11163,
 -1,
 349782818,
 11835,
 350295271,
 348478673,
 -1,
 350360806,
 350257908,
 -1,
 350426341,
 350289920,
 -1,
 -60188,
 350400136,
 128936,
 -1,
 350442364,
 128929,
 -1,
 350383492,
 129300,
 -1,
 350331820,
 129353,
 350754028,
 350274762,
 -1,
 350819563,
 350715290,
 -1,
 -60182,
 350800298,
 128077,
 -1,
 350829755,
 128078,
 -1,
 350782503,
 9928,
 -60179,
 350720922,
 128173,
 -1,
 351028777,
 127777,
 351212815,
 348424618,
 -1,
 351278335,
 351186130,
 -1,
 351343870,
 351219754,
 -1,
 351409397,
 351278556,
 -1,
 -60173,
 351344496,
 127552,
 -60172,
 351409608,
 127560,
 -1,
 351474399,
 127557,
 351671544,
 351344300,
 -1,
 -60169,
 351606440,
 127558,
 -1,
 351670433,
 127556,
 351868155,
 351605991,
 -1,
 -60166,
 351806947,
 127555,
 -1,
 351867633,
 127559,
 352124927,
 351802596,
 -1,
 -60163,
 352000054,
 127554,
 -1,
 352063646,
 127553,
 -1,
 351301864,
 127274,
 352326923,
 351246192,
 -1,
 352392453,
 352277560,
 -1,
 352457988,
 352351619,
 -1,
 -60157,
 352431978,
 11833,
 -1,
 352463095,
 11210,
 -1,
 352434715,
 127913,
 -60154,
 352376174,
 128285,
 -60153,
 352698572,
 9184,
 -60152,
 352757644,
 11811,
 -60151,
 352819472,
 9180,
 -60150,
 352875197,
 11810,
 -1,
 352925043,
 9182,
 -60148,
 352290276,
 128069,
 -60147,
 353074464,
 127813,
 -60146,
 353136317,
 128508,
 -1,
 353198337,
 128701,
 353375532,
 351192266,
 -1,
 353441066,
 353345793,
 -1,
 353506598,
 353404035,
 -1,
 353572120,
 353480076,
 -1,
 353637654,
 353539259,
 -1,
 -60139,
 353620697,
 128597,
 -1,
 353648570,
 128599,
 -60137,
 353598471,
 8526,
 -1,
 353780541,
 11829,
 353965341,
 353514973,
 -1,
 354030876,
 353919068,
 -1,
 -60133,
 354014730,
 8586,
 -1,
 354048832,
 8587,
 -1,
 353967170,
 11832,
 354293024,
 353929060,
 -1,
 -60129,
 354276057,
 128596,
 -1,
 354303930,
 128598,
 354489635,
 354232548,
 -1,
 -60126,
 354464150,
 9930,
 -1,
 354523672,
 11202,
 -60124,
 354472899,
 9929,
 -60123,
 354651072,
 128399,
 -1,
 354693560,
 11826,
 354882857,
 353463093,
 -1,
 -60120,
 354838379,
 8378,
 -1,
 354896305,
 129411,
 -1,
 354861041,
 128034,
 -60117,
 353402216,
 129347,
 -1,
 355104513,
 127799,
 355276100,
 353345793,
 -1,
 355341621,
 355228881,
 -1,
 355407155,
 355278817,
 -1,
 355472690,
 355387275,
 -1,
 -60111,
 355446038,
 128208,
 -1,
 355486765,
 128681,
 -1,
 355430904,
 128710,
 -60108,
 355350434,
 128305,
 -1,
 355676504,
 8285,
 355865916,
 355277039,
 -1,
 355931448,
 355826367,
 128650,
 -1,
 355860943,
 128651,
 356062523,
 355871618,
 -1,
 -60102,
 356040879,
 128668,
 -1,
 356084861,
 128434,
 -1,
 356016514,
 128646,
 356324675,
 355830186,
 -1,
 356390210,
 356292462,
 -1,
 356455745,
 356343327,
 -1,
 -60096,
 356404163,
 128032,
 -1,
 356466054,
 127865,
 -1,
 356408511,
 127942,
 -1,
 356349895,
 128654,
 -1,
 356304927,
 127930,
 356848977,
 355258636,
 -1,
 356914512,
 356813226,
 -1,
 356980047,
 356843520,
 -1,
 357045578,
 356923886,
 -1,
 -60087,
 357019076,
 11818,
 -1,
 357042236,
 8282,
 -60085,
 357029672,
 128109,
 -60084,
 357217722,
 128490,
 -60083,
 357269154,
 128108,
 -60082,
 357324505,
 128149,
 -1,
 357378909,
 128432,
 -1,
 356912747,
 11834,
 -1,
 356870105,
 128256,
 -1,
 356781916,
 128085,
 357768704,
 219196812,
 -1,
 357833208,
 357719249,
 983080,
 357898543,
 357782185,
 -1,
 357964078,
 357881766,
 -1,
 358029004,
 357913634,
 -1,
 358094527,
 357964015,
 -1,
 358160062,
 358056969,
 -1,
 358225447,
 358107576,
 -1,
 358290947,
 358180821,
 121091,
 358416383,
 358219776,
 -1,
 358421946,
 358310406,
 120832,
 358547455,
 358350848,
 -1,
 358552972,
 358448986,
 120846,
 358678527,
 358481920,
 -1,
 358684019,
 358558594,
 -1,
 358749551,
 358649563,
 120853,
 358875135,
 358678528,
 -1,
 358880617,
 358792778,
 -1,
 358946152,
 358855219,
 120877,
 359071743,
 358875136,
 -1,
 -60057,
 358953529,
 120878,
 -1,
 359016344,
 120879,
 -1,
 358894924,
 120884,
 359273835,
 358832364,
 120857,
 -1,
 359205330,
 120882,
 359404909,
 359216471,
 120856,
 -1,
 359336368,
 120885,
 -60050,
 359366505,
 120855,
 -1,
 359490067,
 120854,
 359727103,
 358722500,
 -1,
 359732594,
 359612527,
 120858,
 -1,
 359664082,
 120883,
 -1,
 359662637,
 121001,
 359929215,
 358661700,
 120862,
 360054783,
 359858176,
 -1,
 360060281,
 359934850,
 -1,
 -60041,
 360040961,
 120872,
 -60040,
 360091364,
 120893,
 -1,
 360146634,
 120873,
 360322428,
 360010786,
 -1,
 -60037,
 360288089,
 120874,
 -1,
 360342520,
 120875,
 360519038,
 360259619,
 120895,
 -1,
 360449357,
 120894,
 -1,
 360458136,
 120866,
 360715653,
 359899393,
 -1,
 360781188,
 360669912,
 120966,
 360906751,
 360710144,
 -1,
 -60029,
 360788537,
 120972,
 -1,
 360851352,
 120971,
 -1,
 360717597,
 120849,
 361108871,
 360667372,
 120850,
 -1,
 361040130,
 120867,
 361239945,
 361047960,
 120848,
 -1,
 361171422,
 120865,
 -60022,
 361220530,
 120871,
 -60021,
 361347082,
 120864,
 -1,
 361396024,
 120996,
 361567659,
 358530634,
 -1,
 361633175,
 361542195,
 121052,
 361758719,
 361562112,
 -1,
 361764243,
 361676362,
 -1,
 -60015,
 361707631,
 121054,
 -60014,
 361771577,
 121055,
 -1,
 361834392,
 121056,
 362026390,
 361718284,
 -1,
 -60011,
 361978079,
 121059,
 -1,
 362031000,
 121057,
 -1,
 361966081,
 121058,
 362288545,
 361573250,
 -1,
 362354079,
 362267850,
 -1,
 362419614,
 362324225,
 -1,
 362485149,
 362401172,
 -1,
 -60004,
 362465431,
 121066,
 -1,
 362505420,
 121064,
 -1,
 362444241,
 121063,
 -1,
 362388880,
 120887,
 362872831,
 362309299,
 121067,
 -1,
 362755605,
 120892,
 362943909,
 362240497,
 121062,
 363069439,
 362889358,
 -1,
 -59996,
 362989849,
 120881,
 -1,
 363026668,
 120899,
 363206056,
 362892628,
 -1,
 -59993,
 363182036,
 121060,
 -1,
 363210648,
 121061,
 363462655,
 363143210,
 -1,
 -59990,
 363369635,
 120890,
 -1,
 363422089,
 120891,
 363599280,
 361519340,
 120843,
 363724799,
 363528192,
 -1,
 363730351,
 363626464,
 120852,
 -1,
 363661778,
 120870,
 -1,
 363690235,
 120844,
 363926964,
 363579721,
 120851,
 364052479,
 363858344,
 -1,
 -59981,
 363967027,
 120868,
 -1,
 363999801,
 120869,
 364189111,
 363897089,
 -1,
 -59978,
 364143479,
 121018,
 -1,
 364190991,
 120841,
 364385721,
 364128152,
 120838,
 -1,
 364316178,
 120861,
 -1,
 364328279,
 120842,
 364582353,
 358399556,
 121077,
 364707839,
 364511232,
 -1,
 364713411,
 364628125,
 -1,
 364778944,
 364689947,
 -1,
 -59969,
 364762763,
 121086,
 -1,
 364796852,
 121088,
 -59967,
 364738375,
 120979,
 -59966,
 364929555,
 120840,
 -1,
 364989932,
 121089,
 365172168,
 364652530,
 -1,
 365237702,
 365126174,
 121083,
 -1,
 365168941,
 120876,
 -59961,
 365209980,
 121085,
 -1,
 365330305,
 121084,
 365499852,
 365146680,
 -1,
 -59958,
 365443183,
 121079,
 -59957,
 365507129,
 121080,
 -1,
 365569944,
 121081,
 365761999,
 365466865,
 -1,
 -59954,
 365741201,
 121087,
 -1,
 365776428,
 121090,
 -59952,
 365713188,
 121078,
 -1,
 365907276,
 121082,
 366089703,
 364543841,
 -1,
 366155231,
 366067274,
 -1,
 366220760,
 366095234,
 -1,
 366286295,
 366175953,
 -1,
 -59946,
 366266649,
 120888,
 -1,
 366303468,
 120889,
 -1,
 366266887,
 120886,
 366548445,
 366157866,
 -1,
 366613980,
 366515352,
 -1,
 -59941,
 366594329,
 120896,
 -1,
 366621701,
 120897,
 -1,
 366568067,
 120898,
 -59938,
 366507832,
 121035,
 -1,
 366828046,
 120880,
 367007201,
 366135577,
 121030,
 -1,
 366938578,
 121033,
 367138276,
 366977281,
 -1,
 -59933,
 367092599,
 121037,
 -1,
 367140111,
 121032,
 -59931,
 367097656,
 121036,
 -59930,
 367279169,
 121028,
 -1,
 367339421,
 120860,
 367531510,
 366049087,
 -1,
 367597038,
 367475777,
 120974,
 367722495,
 367525888,
 -1,
 367728109,
 367635021,
 -1,
 -59924,
 367704020,
 120975,
 -1,
 367736226,
 120976,
 -1,
 367694514,
 120977,
 367990257,
 367573531,
 -1,
 -59920,
 367956858,
 120985,
 -1,
 368008268,
 120986,
 368186867,
 367944198,
 120992,
 -1,
 368118177,
 120988,
 -59916,
 368167193,
 120978,
 -59915,
 368288302,
 120983,
 -1,
 368322456,
 120984,
 368514561,
 367503712,
 -1,
 368580091,
 368475994,
 121012,
 368705535,
 368508928,
 -1,
 -59910,
 368615997,
 121014,
 -1,
 368652857,
 121013,
 -59908,
 368560409,
 121006,
 -59907,
 368819780,
 121016,
 -59906,
 368878126,
 121007,
 -59905,
 368932664,
 121008,
 -59904,
 368992774,
 121015,
 -1,
 369048641,
 121003,
 -59902,
 368465700,
 121092,
 -1,
 369184272,
 120906,
 369426431,
 358248632,
 120922,
 369491967,
 369295360,
 -1,
 369497621,
 369379768,
 -1,
 369563151,
 369453284,
 120908,
 369688575,
 369491968,
 -1,
 369694220,
 369580268,
 120919,
 369819647,
 369623040,
 -1,
 -59893,
 369737311,
 120920,
 -1,
 369788672,
 120921,
 -59891,
 369671761,
 120914,
 -59890,
 369905040,
 120910,
 -1,
 369960856,
 120912,
 370212863,
 369529815,
 120900,
 370278399,
 370081792,
 -1,
 370284051,
 370160185,
 120903,
 -1,
 370215163,
 120904,
 -59884,
 370235628,
 120902,
 -1,
 370354072,
 120901,
 370546203,
 369473032,
 -1,
 370611737,
 370486683,
 120930,
 370737151,
 370543058,
 120931,
 -1,
 370606454,
 120932,
 -59878,
 370571064,
 120933,
 -1,
 370762354,
 120929,
 370939426,
 370497316,
 120924,
 371064831,
 370868224,
 -1,
 371070497,
 370953207,
 120909,
 371195903,
 370999296,
 -1,
 -59872,
 371084688,
 120911,
 -1,
 371140504,
 120913,
 -1,
 371048031,
 120926,
 371398182,
 370916938,
 -1,
 -59868,
 371372595,
 120925,
 -59867,
 371412300,
 120928,
 -1,
 371468184,
 120927,
 -1,
 371337244,
 120923,
 371725923,
 358165378,
 -1,
 371791426,
 371705034,
 -1,
 371856957,
 371758958,
 120941,
 371982335,
 371785728,
 -1,
 371988017,
 371888109,
 120940,
 372113407,
 371916800,
 -1,
 372119088,
 372031050,
 -1,
 -59857,
 372093491,
 120942,
 -1,
 372133196,
 120946,
 -1,
 372082432,
 120944,
 372381238,
 371941894,
 120834,
 372506623,
 372310016,
 -1,
 372512309,
 372424260,
 121068,
 -1,
 372442412,
 121069,
 -1,
 372484476,
 121024,
 372708921,
 372358730,
 -1,
 -59848,
 372683315,
 120943,
 -1,
 372723020,
 120947,
 372905531,
 372657143,
 120915,
 -1,
 372835628,
 120916,
 -59844,
 372868864,
 120945,
 -1,
 372998029,
 121040,
 373227519,
 371829498,
 120949,
 373293055,
 373096448,
 -1,
 -59840,
 373198829,
 120948,
 -59839,
 373260221,
 121039,
 -1,
 373318206,
 121020,
 373495385,
 371746483,
 120950,
 373620735,
 373424128,
 -1,
 373626449,
 373514758,
 120833,
 373751807,
 373555200,
 -1,
 373757518,
 373653338,
 120847,
 373882879,
 373686272,
 -1,
 373888587,
 373765108,
 -1,
 -59830,
 373833839,
 120859,
 -1,
 373883949,
 121002,
 -59828,
 373866052,
 120863,
 -59827,
 374057307,
 120967,
 -1,
 374110008,
 120997,
 -59825,
 373729660,
 121019,
 -59824,
 374233311,
 120845,
 -1,
 374286232,
 120839,
 374478421,
 373587809,
 -1,
 374543956,
 374450556,
 121038,
 -1,
 374473078,
 121045,
 -1,
 374524185,
 121031,
 374740568,
 374437695,
 -1,
 -59817,
 374720793,
 120980,
 -1,
 374759942,
 120993,
 -1,
 374712700,
 121009,
 375062527,
 373453090,
 120934,
 375128063,
 374931456,
 -1,
 375133790,
 375045706,
 -1,
 -59811,
 375108147,
 120935,
 -1,
 375147852,
 120937,
 375330400,
 375095200,
 121046,
 -1,
 375261380,
 121047,
 -59807,
 375293696,
 120936,
 -59806,
 375415379,
 121065,
 -1,
 375475705,
 120905,
 375658139,
 371676194,
 -1,
 375723661,
 375612403,
 120957,
 375848959,
 375652352,
 -1,
 375854709,
 375742982,
 120836,
 375980031,
 375783424,
 -1,
 375985775,
 375897668,
 121072,
 376111103,
 375914496,
 -1,
 376116845,
 376024460,
 -1,
 -59796,
 376077278,
 121073,
 -1,
 376135339,
 121053,
 -59794,
 376082413,
 121070,
 -1,
 376270897,
 121071,
 376444531,
 375947105,
 -1,
 376510066,
 376416603,
 120968,
 -1,
 376439309,
 120973,
 -1,
 376469304,
 120998,
 -59788,
 376416636,
 121025,
 -1,
 376658156,
 121051,
 376837755,
 375820269,
 120955,
 376963071,
 376766464,
 -1,
 376968826,
 376880714,
 -1,
 -59783,
 376943155,
 120959,
 -1,
 376982860,
 120956,
 -1,
 376932096,
 120961,
 377230976,
 376796984,
 120970,
 377356287,
 377159680,
 -1,
 377362047,
 377250310,
 120994,
 -1,
 377293217,
 120989,
 -1,
 377339460,
 120987,
 377558660,
 377208394,
 -1,
 377624195,
 377532979,
 120960,
 -1,
 377555656,
 120963,
 -1,
 377563144,
 120964,
 377820806,
 377530715,
 120999,
 -1,
 377750174,
 121004,
 377951880,
 377782106,
 121029,
 -1,
 377882738,
 121041,
 378082955,
 377899448,
 -1,
 -59766,
 378049507,
 120907,
 -1,
 378104055,
 120917,
 -59764,
 378057674,
 120958,
 -1,
 378242816,
 120962,
 378470399,
 375689045,
 120939,
 378535935,
 378339328,
 -1,
 378541717,
 378437473,
 -1,
 378607252,
 378513800,
 121050,
 378732543,
 378535936,
 -1,
 -59757,
 378639489,
 121048,
 -1,
 378691970,
 121049,
 -1,
 378584644,
 121034,
 378934937,
 378495531,
 -1,
 -59753,
 378914967,
 121023,
 -59752,
 378967169,
 121021,
 -1,
 379019650,
 121022,
 -59750,
 378907085,
 121017,
 -1,
 379139427,
 120938,
 379328180,
 375595037,
 120965,
 379453439,
 379256832,
 -1,
 379459240,
 379347462,
 120837,
 379584511,
 379387904,
 -1,
 379590307,
 379502148,
 121076,
 379715583,
 379518976,
 -1,
 -59742,
 379622529,
 121074,
 -1,
 379675010,
 121075,
 379852453,
 379562364,
 121027,
 -1,
 379782477,
 121026,
 380043263,
 379813729,
 -1,
 -59737,
 379955547,
 120969,
 -1,
 380008248,
 121000,
 380180141,
 379418431,
 -1,
 380245676,
 380133894,
 120995,
 380370943,
 380176831,
 120991,
 -1,
 380241229,
 120990,
 -1,
 380225817,
 120982,
 380507825,
 380141453,
 121044,
 380633087,
 380436480,
 -1,
 -59728,
 380540033,
 121042,
 -1,
 380592514,
 121043,
 380829695,
 380479840,
 -1,
 -59725,
 380729144,
 121011,
 -1,
 380779628,
 121005,
 381026303,
 379294934,
 120951,
 381091839,
 380895232,
 -1,
 381097657,
 381009482,
 -1,
 -59720,
 381071923,
 120952,
 -1,
 381111628,
 120954,
 -59718,
 381069692,
 121010,
 -59717,
 381257472,
 120953,
 -59716,
 381318983,
 120981,
 -59715,
 381379078,
 120835,
 -1,
 381438967,
 120918,
 -1,
 358114967,
 121451,
 381747199,
 358039392,
 121343,
 381812735,
 381616128,
 -1,
 381818571,
 381714873,
 -1,
 381884106,
 381750818,
 -1,
 381949639,
 381866342,
 -1,
 -59707,
 381927201,
 121346,
 -59706,
 381990868,
 121345,
 -1,
 382023061,
 121348,
 382271487,
 381897863,
 -1,
 -59703,
 382187476,
 121347,
 -1,
 382219669,
 121349,
 -1,
 381813253,
 121350,
 -1,
 381790546,
 121344,
 382539782,
 357990658,
 -1,
 382605280,
 382520781,
 -1,
 382670663,
 382587238,
 -1,
 382736114,
 382610306,
 -1,
 382801640,
 382716819,
 -1,
 382867173,
 382730240,
 -1,
 382932699,
 382817314,
 -1,
 382998232,
 382869044,
 -1,
 383063766,
 382955569,
 121230,
 -1,
 383039196,
 121231,
 -59689,
 383038410,
 121228,
 -1,
 383155687,
 121229,
 383385599,
 382953664,
 -1,
 -59686,
 383274667,
 121254,
 -1,
 383331993,
 121261,
 383522528,
 382902330,
 -1,
 383588062,
 383479857,
 121226,
 -1,
 383563484,
 121227,
 -59681,
 383562698,
 121224,
 -1,
 383679975,
 121225,
 383909887,
 383499473,
 -1,
 383915748,
 383821079,
 -1,
 -59677,
 383890378,
 121232,
 -1,
 383942119,
 121233,
 -1,
 383861671,
 121247,
 384237567,
 382809607,
 -1,
 -59673,
 384152522,
 121248,
 -1,
 384204263,
 121249,
 384374509,
 382767573,
 -1,
 -59670,
 384349130,
 121147,
 -59669,
 384412690,
 121150,
 -59668,
 384466407,
 121148,
 -1,
 384528433,
 121149,
 384702193,
 384325394,
 -1,
 -59665,
 384676810,
 121151,
 -59664,
 384728551,
 121152,
 -1,
 384790577,
 121153,
 -1,
 384674756,
 121139,
 385029895,
 382718220,
 -1,
 385095428,
 384967975,
 -1,
 385160957,
 385037723,
 -1,
 385226489,
 385139273,
 -1,
 -59657,
 385201098,
 121244,
 -59656,
 385252839,
 121245,
 -1,
 385314865,
 121246,
 385548287,
 385170191,
 -1,
 -59653,
 385463242,
 121241,
 -59652,
 385514983,
 121242,
 -1,
 385577009,
 121243,
 385750785,
 385104002,
 -1,
 -59649,
 385725386,
 121268,
 -59648,
 385777127,
 121269,
 -1,
 385839153,
 121270,
 386072575,
 385702213,
 -1,
 -59645,
 385961643,
 121257,
 -1,
 386018969,
 121264,
 386269183,
 385067647,
 -1,
 -59642,
 386183919,
 121325,
 -1,
 386218760,
 121326,
 386406160,
 385002892,
 -1,
 386471695,
 386360335,
 -1,
 386537230,
 386447325,
 -1,
 386602764,
 386494513,
 121132,
 -1,
 386578140,
 121133,
 -59635,
 386577354,
 121130,
 -1,
 386694631,
 121131,
 -1,
 386520987,
 121134,
 -1,
 386421926,
 121253,
 386995992,
 386365618,
 -1,
 387061523,
 386970570,
 121237,
 -1,
 386990742,
 121240,
 387192598,
 387012933,
 -1,
 -59627,
 387141291,
 121256,
 -1,
 387198617,
 121263,
 -59625,
 387153383,
 121238,
 -1,
 387346481,
 121239,
 387520289,
 386934194,
 -1,
 387585821,
 387487526,
 -1,
 -59621,
 387560394,
 121154,
 -59620,
 387612135,
 121155,
 -1,
 387674161,
 121156,
 387907583,
 387531764,
 -1,
 -59617,
 387822538,
 121144,
 -59616,
 387874279,
 121145,
 -1,
 387936305,
 121146,
 388110120,
 387472465,
 -1,
 388175653,
 388061509,
 -1,
 -59612,
 388124331,
 121255,
 -1,
 388181657,
 121262,
 -59610,
 388150218,
 121234,
 -59609,
 388333031,
 121235,
 -1,
 388395057,
 121236,
 388568877,
 388088393,
 -1,
 388634411,
 388505260,
 121142,
 -1,
 388566538,
 121143,
 -59604,
 388618139,
 121141,
 -1,
 388741095,
 121140,
 388896562,
 388512527,
 -1,
 388962096,
 388832940,
 121137,
 -1,
 388894218,
 121138,
 -59599,
 388945819,
 121136,
 -1,
 389068756,
 121135,
 389224249,
 388833777,
 -1,
 389289782,
 389198800,
 -1,
 -59595,
 389264111,
 121315,
 -1,
 389298952,
 121317,
 389545983,
 389250542,
 -1,
 -59592,
 389460719,
 121316,
 -1,
 389495560,
 121318,
 389683005,
 389209187,
 -1,
 -59589,
 389657546,
 121157,
 -59588,
 389709287,
 121158,
 -1,
 389771313,
 121159,
 389945153,
 389650831,
 -1,
 -59585,
 389919690,
 121160,
 -59584,
 389971431,
 121161,
 -1,
 390033457,
 121162,
 390207302,
 389892994,
 -1,
 390272837,
 390162162,
 -1,
 -59580,
 390247151,
 121329,
 -1,
 390281992,
 121330,
 -1,
 390237985,
 121128,
 -1,
 390163025,
 121448,
 390600639,
 382618759,
 -1,
 390666076,
 390540162,
 -1,
 390731606,
 390646680,
 -1,
 390797137,
 390682949,
 -1,
 390862670,
 390745216,
 -1,
 -59571,
 390837194,
 121286,
 -1,
 390885425,
 121287,
 391118847,
 390802830,
 -1,
 -59568,
 391033802,
 121271,
 -1,
 391082033,
 121272,
 391255891,
 390754353,
 121303,
 -1,
 391231196,
 121304,
 -59564,
 391230410,
 121301,
 -59563,
 391347687,
 121302,
 -1,
 391393646,
 121305,
 391583578,
 390697429,
 -1,
 -59560,
 391558090,
 121204,
 -59559,
 391609831,
 121205,
 -1,
 391671857,
 121206,
 -59557,
 391556036,
 121198,
 -1,
 391796493,
 121207,
 391976812,
 390648076,
 -1,
 392042345,
 391914791,
 -1,
 392107877,
 391993669,
 -1,
 392173410,
 392055936,
 -1,
 -59551,
 392147914,
 121296,
 -1,
 392196145,
 121297,
 392429567,
 392113550,
 -1,
 -59548,
 392344522,
 121281,
 -1,
 392392753,
 121282,
 392566632,
 392080780,
 -1,
 -59545,
 392528759,
 121308,
 -1,
 392592350,
 121309,
 -1,
 392523825,
 121310,
 392888319,
 392014482,
 -1,
 -59541,
 392803055,
 121327,
 -1,
 392837896,
 121328,
 393025405,
 391936178,
 -1,
 393090940,
 392976709,
 -1,
 393156469,
 393038976,
 -1,
 393222002,
 393130960,
 -1,
 -59535,
 393196271,
 121292,
 -1,
 393231112,
 121294,
 393478143,
 393179191,
 -1,
 -59532,
 393392879,
 121293,
 -1,
 393427720,
 121295,
 393674751,
 393096590,
 -1,
 393680761,
 393589712,
 -1,
 -59528,
 393655023,
 121277,
 -1,
 393689864,
 121279,
 393936895,
 393637943,
 -1,
 -59525,
 393851631,
 121278,
 -1,
 393886472,
 121280,
 -1,
 393065418,
 121307,
 394139533,
 392977489,
 -1,
 394205068,
 394090821,
 -1,
 394270597,
 394153088,
 -1,
 394336131,
 394248777,
 -1,
 -59518,
 394310835,
 121290,
 -1,
 394358912,
 121291,
 -59516,
 394310721,
 121288,
 -1,
 394489918,
 121289,
 394723327,
 394210702,
 -1,
 394729353,
 394638288,
 -1,
 -59512,
 394707522,
 121275,
 -1,
 394738440,
 121273,
 394985471,
 394686519,
 -1,
 -59509,
 394904130,
 121276,
 -1,
 394935048,
 121274,
 -1,
 394179530,
 121306,
 395188118,
 394112396,
 -1,
 395253653,
 395142159,
 -1,
 395319188,
 395229149,
 -1,
 395384722,
 395276337,
 121191,
 -1,
 395359964,
 121192,
 -59501,
 395359178,
 121189,
 -1,
 395476455,
 121190,
 -1,
 395302811,
 121193,
 -1,
 395203757,
 121314,
 395777952,
 395125245,
 -1,
 395843482,
 395752400,
 -1,
 -59495,
 395817711,
 121319,
 -1,
 395852552,
 121322,
 396040093,
 395804142,
 -1,
 -59492,
 396014319,
 121320,
 -1,
 396049160,
 121323,
 396296191,
 395997239,
 -1,
 -59489,
 396210927,
 121321,
 -1,
 396245768,
 121324,
 396433318,
 395756105,
 -1,
 396498852,
 396369592,
 -1,
 -59485,
 396482459,
 121202,
 -1,
 396526009,
 121201,
 -59483,
 396482459,
 121200,
 -1,
 396670951,
 121199,
 396826539,
 396376847,
 -1,
 396892073,
 396762796,
 121196,
 -1,
 396824074,
 121197,
 -59478,
 396875675,
 121195,
 -1,
 396998612,
 121194,
 397154225,
 396764594,
 -1,
 397219760,
 397121318,
 -1,
 -59474,
 397194186,
 121208,
 -59473,
 397245927,
 121209,
 -1,
 397307953,
 121210,
 -1,
 397165552,
 121203,
 397547445,
 397139043,
 -1,
 -59469,
 397521866,
 121211,
 -59468,
 397573607,
 121212,
 -1,
 397635633,
 121213,
 397809593,
 397515151,
 -1,
 -59465,
 397784010,
 121214,
 -59464,
 397835751,
 121215,
 -1,
 397897777,
 121216,
 398071742,
 397757314,
 -1,
 398137277,
 398026490,
 -1,
 -59460,
 398111471,
 121331,
 -1,
 398146312,
 121332,
 -1,
 398102305,
 121129,
 -1,
 398027345,
 121449,
 398464981,
 390543480,
 -1,
 398530507,
 398403570,
 -1,
 398596038,
 398508290,
 -1,
 398661572,
 398553137,
 121187,
 -1,
 398636764,
 121188,
 -59451,
 398635978,
 121185,
 -1,
 398753255,
 121186,
 398983167,
 398533983,
 -1,
 398989257,
 398880817,
 121183,
 -1,
 398964444,
 121184,
 -59446,
 398963658,
 121181,
 -1,
 399080935,
 121182,
 399251408,
 398508290,
 -1,
 399316942,
 399208497,
 121179,
 -1,
 399292124,
 121180,
 -59441,
 399291338,
 121177,
 -1,
 399408615,
 121178,
 399638527,
 399189343,
 -1,
 399644627,
 399536177,
 121175,
 -1,
 399619804,
 121176,
 -59436,
 399619018,
 121173,
 -1,
 399736295,
 121174,
 399966207,
 398416101,
 -1,
 399972318,
 399886620,
 -1,
 400037853,
 399916102,
 -1,
 400103387,
 399974072,
 -1,
 -59430,
 400077770,
 121126,
 -1,
 400126001,
 121125,
 -59428,
 400077770,
 121122,
 -1,
 400257073,
 121121,
 -1,
 400011276,
 121123,
 -59425,
 399946302,
 121127,
 -1,
 400440491,
 121124,
 400687103,
 382585901,
 -1,
 400693229,
 400592882,
 -1,
 400758758,
 400663713,
 121418,
 400883711,
 400687104,
 -1,
 -59419,
 400808344,
 121420,
 -1,
 400873352,
 121419,
 401020906,
 400725206,
 121415,
 401145855,
 400949248,
 -1,
 -59415,
 401070488,
 121417,
 -1,
 401135496,
 121416,
 -59413,
 401004424,
 121414,
 -59412,
 401231180,
 121413,
 -1,
 401289039,
 121412,
 401479667,
 400632706,
 -1,
 401545202,
 401438908,
 -1,
 -59408,
 401507629,
 121403,
 -59407,
 401558860,
 121404,
 -1,
 401617592,
 121405,
 -1,
 401510876,
 121430,
 401872887,
 401456222,
 121424,
 401997823,
 401801216,
 -1,
 -59402,
 401914146,
 121426,
 -1,
 401952076,
 121425,
 402135035,
 401847526,
 121406,
 402259967,
 402063360,
 -1,
 -59398,
 402184072,
 121407,
 -1,
 402231277,
 121408,
 402397183,
 402091441,
 121421,
 402522111,
 402325504,
 -1,
 -59394,
 402446216,
 121423,
 -1,
 402476364,
 121422,
 402659331,
 402345654,
 121409,
 402784255,
 402587648,
 -1,
 -59390,
 402708360,
 121410,
 -1,
 402755565,
 121411,
 402980863,
 402642833,
 -1,
 -59387,
 402895599,
 121431,
 -1,
 402930440,
 121432,
 403118149,
 382515739,
 -1,
 403183650,
 403088206,
 -1,
 403249175,
 403165542,
 -1,
 403314706,
 403221531,
 -1,
 403380238,
 403296614,
 -1,
 -59380,
 403354351,
 121163,
 -59379,
 403389192,
 121164,
 -1,
 403447468,
 121165,
 403701759,
 403328135,
 -1,
 -59376,
 403616495,
 121166,
 -59375,
 403651336,
 121167,
 -1,
 403709612,
 121168,
 403904534,
 403251744,
 -1,
 -59372,
 403882562,
 121172,
 -59371,
 403944175,
 121170,
 -1,
 403979016,
 121171,
 -1,
 403878042,
 121169,
 404291583,
 403197063,
 -1,
 404297761,
 404204571,
 -1,
 404363293,
 404279654,
 -1,
 -59365,
 404337391,
 121220,
 -59364,
 404372232,
 121221,
 -1,
 404430508,
 121222,
 404684799,
 404311175,
 -1,
 -59361,
 404599535,
 121217,
 -59360,
 404634376,
 121218,
 -1,
 404692652,
 121219,
 -1,
 404271258,
 121223,
 404953143,
 403147178,
 -1,
 405018670,
 404915689,
 -1,
 405084199,
 404996024,
 -1,
 -59354,
 405061864,
 121436,
 -1,
 405088251,
 121435,
 405280810,
 405024162,
 -1,
 -59351,
 405256048,
 121439,
 -1,
 405300435,
 121440,
 -59349,
 405256061,
 121433,
 -59348,
 405438914,
 121438,
 -59347,
 405501380,
 121434,
 -1,
 405562592,
 121437,
 405739570,
 404997814,
 -1,
 -59344,
 405713647,
 121093,
 -59343,
 405766737,
 121094,
 -1,
 405809130,
 121095,
 406061055,
 405712035,
 -1,
 406067254,
 405983590,
 -1,
 -59339,
 406042617,
 121458,
 -1,
 406074793,
 121459,
 -1,
 406015140,
 121460,
 406388735,
 404897340,
 -1,
 406394945,
 406275840,
 121441,
 406519807,
 406323200,
 -1,
 406526015,
 406424885,
 -1,
 406591549,
 406503535,
 121443,
 -1,
 406520999,
 121444,
 406781951,
 406550277,
 121445,
 -1,
 406652071,
 121446,
 -59328,
 406487481,
 121442,
 -1,
 406792394,
 121447,
 407044095,
 406358013,
 -1,
 -59325,
 406945626,
 121390,
 -59324,
 407009531,
 121391,
 -1,
 407066688,
 121389,
 407246968,
 403087617,
 -1,
 407312500,
 407212709,
 -1,
 407378019,
 407244322,
 -1,
 407443542,
 407359846,
 -1,
 407509069,
 407417583,
 121250,
 407633919,
 407438151,
 -1,
 -59316,
 407522987,
 121258,
 -1,
 407580313,
 121265,
 407771217,
 407452424,
 121251,
 407896063,
 407700295,
 -1,
 -59312,
 407785131,
 121259,
 -1,
 407842457,
 121266,
 408092671,
 407707299,
 -1,
 408098901,
 407987033,
 -1,
 -59308,
 408047275,
 121260,
 -1,
 408104601,
 121267,
 -1,
 408043068,
 121252,
 408420351,
 407391367,
 -1,
 408426587,
 408335087,
 121311,
 408551423,
 408355655,
 -1,
 -59302,
 408439930,
 121298,
 -1,
 408497542,
 121283,
 408688735,
 408369928,
 121312,
 408813567,
 408617799,
 -1,
 -59298,
 408702074,
 121299,
 -1,
 408759686,
 121284,
 409010175,
 408624812,
 121313,
 409075711,
 408879943,
 -1,
 -59294,
 408964218,
 121300,
 -1,
 409021830,
 121285,
 409272319,
 407307420,
 -1,
 409278572,
 409145509,
 -1,
 -59290,
 409212380,
 121519,
 -59289,
 409277671,
 121518,
 -59288,
 409342995,
 121517,
 -59287,
 409408245,
 121516,
 -59286,
 409473488,
 121515,
 -59285,
 409538725,
 121514,
 -1,
 409603992,
 121513,
 -59283,
 409212989,
 121512,
 -59282,
 409737100,
 121511,
 -59281,
 409802412,
 121510,
 -59280,
 409867740,
 121509,
 -59279,
 409933031,
 121508,
 -59278,
 409998355,
 121507,
 -59277,
 410063605,
 121506,
 -1,
 410128848,
 121505,
 410386431,
 407291316,
 -1,
 -59274,
 410301167,
 121105,
 -59273,
 410354257,
 121106,
 -1,
 410396650,
 121107,
 410589346,
 407191100,
 -1,
 410654880,
 410573217,
 -1,
 410720393,
 410603641,
 -1,
 410785923,
 410702182,
 -1,
 410851456,
 410761172,
 121377,
 410976255,
 410779648,
 -1,
 -59265,
 410860296,
 121378,
 -1,
 410918572,
 121379,
 411172863,
 410790786,
 -1,
 -59262,
 411093918,
 121383,
 -1,
 411133711,
 121385,
 411369471,
 410733703,
 -1,
 411375752,
 411285460,
 121380,
 411500543,
 411303936,
 -1,
 -59257,
 411384584,
 121381,
 -1,
 411442860,
 121382,
 -1,
 411317666,
 121384,
 411703443,
 410693006,
 -1,
 411768973,
 411685907,
 -1,
 -59252,
 411731566,
 121372,
 -1,
 411764012,
 121370,
 411965584,
 411718860,
 -1,
 -59249,
 411930605,
 121369,
 -1,
 411971772,
 121371,
 -59247,
 411940445,
 121365,
 -59246,
 412127213,
 121364,
 -1,
 412168380,
 121366,
 412358807,
 411660443,
 -1,
 -59243,
 412338457,
 121374,
 -59242,
 412372182,
 121376,
 -1,
 412433473,
 121375,
 412620955,
 412297926,
 -1,
 -59239,
 412600601,
 121354,
 -59238,
 412648749,
 121355,
 -1,
 412695617,
 121356,
 412942335,
 412549120,
 -1,
 412948639,
 412821857,
 -1,
 -59234,
 412922607,
 121367,
 -1,
 412975697,
 121368,
 -1,
 412931170,
 121373,
 -59231,
 410638365,
 121452,
 -1,
 413147851,
 121392,
 413341887,
 410545863,
 -1,
 413407411,
 413293777,
 -1,
 413472942,
 413367600,
 -1,
 413538477,
 413430943,
 -1,
 -59225,
 413472428,
 121469,
 -59224,
 413537756,
 121468,
 -59223,
 413603047,
 121467,
 -59222,
 413668371,
 121466,
 -59221,
 413733621,
 121465,
 -59220,
 413798864,
 121464,
 -1,
 413864101,
 121463,
 -1,
 413479266,
 121462,
 414187519,
 413439854,
 -1,
 414193842,
 414056448,
 -1,
 -59215,
 414173753,
 121429,
 -1,
 414218680,
 121428,
 -1,
 414166495,
 121427,
 414515199,
 413370949,
 -1,
 414521532,
 414384128,
 -1,
 414587064,
 414471809,
 -1,
 -59209,
 414539732,
 121473,
 -1,
 414587667,
 121476,
 -59207,
 414569496,
 121474,
 -59206,
 414761153,
 121477,
 -59205,
 414807706,
 121478,
 -1,
 414857158,
 121475,
 415105023,
 414453282,
 -1,
 -59202,
 415027597,
 121471,
 -1,
 415059091,
 121472,
 415242460,
 413288888,
 -1,
 415307979,
 415198919,
 -1,
 415373514,
 415260229,
 -1,
 415439047,
 415346060,
 -1,
 415504582,
 415398883,
 -1,
 -59195,
 415478511,
 121116,
 -1,
 415531601,
 121118,
 -1,
 415450466,
 121119,
 415825919,
 415395895,
 -1,
 -59191,
 415740655,
 121115,
 -1,
 415793745,
 121117,
 -1,
 415338379,
 121456,
 416028883,
 415259857,
 -1,
 416094418,
 415987574,
 -1,
 -59186,
 416028124,
 121503,
 -59185,
 416093415,
 121502,
 -59184,
 416158739,
 121501,
 -59183,
 416223989,
 121500,
 -1,
 416289232,
 121499,
 -1,
 416056773,
 121470,
 416553175,
 415994214,
 -1,
 -59179,
 416536456,
 121363,
 -59178,
 416580909,
 121361,
 -1,
 416625336,
 121362,
 416815323,
 416488039,
 -1,
 416880858,
 416794981,
 121352,
 -1,
 416811502,
 121353,
 -1,
 416828771,
 121351,
 -1,
 416794541,
 121480,
 417143028,
 415214988,
 -1,
 417208551,
 417112210,
 -1,
 417274083,
 417181068,
 -1,
 417339618,
 417233891,
 -1,
 -59167,
 417313519,
 121111,
 -1,
 417366609,
 121113,
 -1,
 417285474,
 121114,
 417601766,
 417230903,
 -1,
 -59163,
 417575663,
 121110,
 -1,
 417628753,
 121112,
 -1,
 417549410,
 121120,
 417863915,
 417186351,
 -1,
 -59159,
 417837807,
 121099,
 -59158,
 417890897,
 121100,
 -1,
 417933290,
 121101,
 418126064,
 417815292,
 -1,
 418191599,
 418076933,
 -1,
 -59154,
 418166238,
 121453,
 -1,
 418225497,
 121454,
 -1,
 418168614,
 121457,
 418453747,
 418106132,
 -1,
 -59150,
 418429447,
 121108,
 -1,
 418457578,
 121109,
 -1,
 418399037,
 121481,
 418715912,
 417084893,
 -1,
 418781442,
 418699935,
 -1,
 418846970,
 418753932,
 -1,
 418912505,
 418799990,
 121339,
 -1,
 418840630,
 121340,
 -1,
 418871547,
 121336,
 419109117,
 418783907,
 -1,
 -59140,
 419083210,
 121333,
 -1,
 419131441,
 121334,
 -59138,
 419085406,
 121337,
 -59137,
 419276122,
 121338,
 -59136,
 419320562,
 121342,
 -59135,
 419383895,
 121335,
 -1,
 419448977,
 121341,
 419692543,
 418751502,
 -1,
 419698950,
 419595573,
 -1,
 -59131,
 419678489,
 121360,
 -1,
 419707969,
 121357,
 -59129,
 419678554,
 121359,
 -1,
 419839114,
 121358,
 420026640,
 418677492,
 -1,
 420092175,
 419992114,
 -1,
 420157709,
 420073740,
 -1,
 -59124,
 420129272,
 121395,
 -1,
 420175817,
 121396,
 -59122,
 420119853,
 121393,
 -1,
 420295352,
 121394,
 -1,
 420036696,
 121450,
 420550936,
 419965826,
 -1,
 420616469,
 420501277,
 -1,
 -59117,
 420591906,
 121388,
 -59116,
 420650659,
 121386,
 -1,
 420709677,
 121387,
 420937727,
 420579754,
 -1,
 -59113,
 420839632,
 121479,
 -1,
 420902994,
 121482,
 421075232,
 420489830,
 -1,
 421140765,
 421055441,
 -1,
 -59109,
 421114607,
 121102,
 -59108,
 421167697,
 121103,
 -1,
 421210090,
 121104,
 421462015,
 421085197,
 -1,
 -59105,
 421356588,
 121401,
 -1,
 421415142,
 121402,
 421599527,
 421010689,
 -1,
 421665060,
 421574941,
 -1,
 -59101,
 421618534,
 121398,
 -1,
 421660896,
 121400,
 421920767,
 421603688,
 -1,
 -59098,
 421815204,
 121397,
 -1,
 421857504,
 121399,
 422058283,
 421548854,
 -1,
 -59095,
 422032111,
 121096,
 -59094,
 422085201,
 121097,
 -1,
 422127594,
 121098,
 -59092,
 422039921,
 121455,
 -59091,
 422300182,
 121461,
 -1,
 422353168,
 121483,
 -1,
 357893406,
 129304,
 422582711,
 357840349,
 -1,
 422648236,
 422524978,
 -1,
 422713716,
 422606044,
 -1,
 422779196,
 422689307,
 -1,
 422844725,
 422762172,
 71129,
 -1,
 422796497,
 71130,
 422975800,
 422820379,
 -1,
 -59081,
 422925368,
 71065,
 -1,
 422975727,
 71064,
 423172411,
 422925346,
 -1,
 -59078,
 423142656,
 71128,
 -1,
 423172335,
 71070,
 -1,
 423106799,
 71069,
 423434563,
 422759546,
 -1,
 423500098,
 423397940,
 -1,
 423565632,
 423469313,
 71046,
 -1,
 423534849,
 71047,
 423755775,
 423521991,
 71048,
 -1,
 423653063,
 71049,
 -1,
 423434479,
 71082,
 423893320,
 423368943,
 71040,
 -59067,
 423871690,
 71053,
 -59066,
 423918111,
 71131,
 -59065,
 423976145,
 71051,
 -1,
 424024303,
 71041,
 424221005,
 423854836,
 -1,
 -59062,
 424204588,
 71063,
 -59061,
 424248145,
 71068,
 -59060,
 424300423,
 71058,
 -1,
 424351983,
 71073,
 424548691,
 424162781,
 -1,
 424614225,
 424490461,
 -1,
 -59056,
 424563768,
 71067,
 -1,
 424614127,
 71066,
 -59054,
 424563768,
 71072,
 -1,
 424745199,
 71071,
 424941911,
 424521100,
 -1,
 -59051,
 424914463,
 71084,
 -59050,
 424956984,
 71083,
 -1,
 425007343,
 71085,
 425204057,
 424920266,
 71044,
 -1,
 425182410,
 71045,
 425335132,
 425170798,
 -1,
 -59045,
 425284664,
 71075,
 -1,
 425335023,
 71074,
 425531743,
 425290549,
 -1,
 -59042,
 425481272,
 71055,
 -1,
 425531631,
 71054,
 425728354,
 425486857,
 -1,
 -59039,
 425677880,
 71062,
 -1,
 425728239,
 71061,
 425924964,
 425680081,
 71042,
 -1,
 425876689,
 71043,
 426056039,
 425873208,
 -1,
 -59034,
 426005560,
 71057,
 -1,
 426055919,
 71056,
 426252650,
 425995138,
 -1,
 -59031,
 426202168,
 71060,
 -1,
 426252527,
 71059,
 426449261,
 426190258,
 -1,
 -59028,
 426398776,
 71077,
 -1,
 426449135,
 71076,
 -59026,
 426432812,
 71079,
 -59025,
 426615163,
 71080,
 -59024,
 426674602,
 71052,
 -59023,
 426736405,
 71078,
 -59022,
 426798853,
 71081,
 -59021,
 426857528,
 71086,
 -1,
 426917436,
 71050,
 427104661,
 422686092,
 -1,
 427170189,
 427048508,
 -1,
 427235722,
 427111655,
 -1,
 427301256,
 427218052,
 -1,
 427366781,
 427278728,
 -1,
 427432316,
 427308952,
 -1,
 -59013,
 427410748,
 71114,
 -1,
 427440821,
 71115,
 -1,
 427400055,
 71122,
 427694465,
 427336548,
 -1,
 -59009,
 427672145,
 71118,
 -59008,
 427703180,
 71117,
 -1,
 427766716,
 71116,
 427956613,
 427634641,
 -1,
 -59005,
 427934850,
 71126,
 -59004,
 427991897,
 71125,
 -1,
 428035548,
 71127,
 -59002,
 427929573,
 71124,
 -59001,
 428187618,
 71123,
 -1,
 428227468,
 71121,
 428474367,
 427244546,
 71119,
 -1,
 428346732,
 71120,
 428605439,
 427202792,
 -1,
 -58996,
 428489198,
 71108,
 -1,
 428549746,
 71109,
 428802047,
 427122797,
 -1,
 428808593,
 428724030,
 -1,
 -58992,
 428781270,
 71102,
 -1,
 428843687,
 71103,
 -58990,
 428782123,
 71105,
 -58989,
 428968150,
 71104,
 -58988,
 429009993,
 71100,
 -1,
 429072550,
 71101,
 429267364,
 427085976,
 -1,
 429332892,
 429201647,
 -1,
 429398425,
 429292063,
 71132,
 -1,
 429376714,
 71133,
 -58982,
 429376714,
 71099,
 -58981,
 429481169,
 71097,
 -1,
 429529327,
 71087,
 429726110,
 429313998,
 71092,
 -1,
 429695233,
 71093,
 429857184,
 429704394,
 71090,
 -1,
 429835466,
 71091,
 429988258,
 429808849,
 71088,
 -1,
 429939921,
 71089,
 -58973,
 429951402,
 71098,
 -1,
 430063164,
 71096,
 430250408,
 429237647,
 -1,
 -58970,
 430183157,
 71112,
 -58969,
 430248400,
 71111,
 -1,
 430313637,
 71110,
 430512555,
 430192093,
 -1,
 -58966,
 430478157,
 71107,
 -1,
 430514093,
 71106,
 -1,
 430457864,
 71113,
 430833663,
 422594725,
 -1,
 430840242,
 430756640,
 -1,
 -58961,
 430819723,
 128414,
 -58960,
 430876610,
 128409,
 -58959,
 430928617,
 128408,
 -1,
 430980247,
 128415,
 431226879,
 430778596,
 -1,
 -58956,
 431147403,
 128416,
 -58955,
 431204290,
 128411,
 -58954,
 431256297,
 128410,
 -1,
 431307927,
 128417,
 431495668,
 422544116,
 -1,
 431561194,
 431445185,
 -1,
 431626711,
 431497559,
 -1,
 431692234,
 431589600,
 -1,
 431757759,
 431667739,
 -1,
 -58947,
 431739551,
 70123,
 -58946,
 431773977,
 70124,
 -1,
 431833956,
 70122,
 432019906,
 431730060,
 -1,
 -58943,
 431974852,
 70127,
 -1,
 432031776,
 70128,
 432216517,
 431984056,
 -1,
 -58940,
 432192917,
 70132,
 -1,
 432233559,
 70131,
 432413128,
 432163256,
 -1,
 -58937,
 432378389,
 70125,
 -1,
 432430911,
 70126,
 -58935,
 432375383,
 70130,
 -1,
 432554632,
 70129,
 432799743,
 431634652,
 -1,
 432806350,
 432716315,
 -1,
 -58931,
 432789002,
 70114,
 -1,
 432823104,
 70115,
 433002961,
 432778636,
 -1,
 -58928,
 432957827,
 70118,
 -1,
 433014751,
 70119,
 433199572,
 432949688,
 -1,
 -58925,
 433165252,
 70116,
 -1,
 433219793,
 70117,
 -58923,
 433163700,
 70113,
 -58922,
 433358384,
 70121,
 -1,
 433406517,
 70120,
 433592805,
 431585068,
 -1,
 433658331,
 433568283,
 -1,
 -58918,
 433640970,
 3560,
 -1,
 433675072,
 3561,
 433854942,
 433630604,
 -1,
 -58915,
 433809795,
 3564,
 -1,
 433866719,
 3565,
 434051553,
 433801656,
 -1,
 -58912,
 434017220,
 3562,
 -1,
 434071761,
 3563,
 -58910,
 434035697,
 3558,
 -58909,
 434212276,
 3559,
 -58908,
 434275888,
 3567,
 -1,
 434324021,
 3566,
 434569215,
 433533524,
 -1,
 434575849,
 434479361,
 -1,
 -58904,
 434521374,
 983923,
 -1,
 434576776,
 983922,
 -1,
 434559368,
 983921,
 434896895,
 431510168,
 -1,
 434903537,
 434765824,
 -1,
 434969071,
 434876776,
 -1,
 -58898,
 434951690,
 983154,
 -1,
 434985792,
 983157,
 -58896,
 434918169,
 983182,
 -1,
 435105318,
 983184,
 435355647,
 434835284,
 -1,
 -58893,
 435229429,
 983158,
 -1,
 435294672,
 983155,
 435493367,
 431478761,
 -1,
 -58890,
 435468064,
 128303,
 -1,
 435526462,
 128973,
 -1,
 435451305,
 128510,
 435755739,
 357782562,
 -1,
 435821245,
 435689711,
 -1,
 435886715,
 435790081,
 -1,
 435952250,
 435821372,
 -1,
 436017724,
 435909852,
 -1,
 436083204,
 435997818,
 -1,
 436148739,
 436046388,
 -1,
 436214273,
 436117761,
 70025,
 -1,
 436183297,
 70026,
 436404223,
 436170439,
 70027,
 -1,
 436301511,
 70028,
 -1,
 436082927,
 70062,
 436541962,
 436058651,
 -1,
 436607496,
 436517403,
 -1,
 -58873,
 436556856,
 70044,
 -1,
 436607215,
 70043,
 -58871,
 436556856,
 70049,
 -1,
 436738287,
 70048,
 436935183,
 436503284,
 -1,
 -58868,
 436918572,
 70042,
 -58867,
 436962129,
 70047,
 -58866,
 437014407,
 70037,
 -1,
 437065967,
 70052,
 437262869,
 436876765,
 -1,
 437328403,
 437204445,
 -1,
 -58862,
 437277752,
 70046,
 -1,
 437328111,
 70045,
 -58860,
 437277752,
 70051,
 -1,
 437459183,
 70050,
 437656089,
 437197039,
 70019,
 -58857,
 437634250,
 70032,
 -58856,
 437673169,
 70030,
 -1,
 437721327,
 70020,
 437918237,
 437628300,
 -1,
 -58853,
 437890591,
 70064,
 -58852,
 437933112,
 70063,
 -1,
 437983471,
 70065,
 438180383,
 437896394,
 70023,
 -1,
 438158538,
 70024,
 438311458,
 438146926,
 -1,
 -58847,
 438260792,
 70054,
 -1,
 438311151,
 70053,
 438508069,
 438267591,
 -1,
 -58844,
 438464261,
 70061,
 -1,
 438507759,
 70060,
 438704680,
 438463285,
 -1,
 -58841,
 438654008,
 70034,
 -1,
 438704367,
 70033,
 438901291,
 438659593,
 -1,
 -58838,
 438850616,
 70041,
 -1,
 438900975,
 70040,
 439097901,
 438852817,
 70021,
 -1,
 439049425,
 70022,
 439228976,
 439045944,
 -1,
 -58833,
 439178296,
 70036,
 -1,
 439228655,
 70035,
 439425587,
 439167874,
 -1,
 -58830,
 439374904,
 70039,
 -1,
 439425263,
 70038,
 439622198,
 439362994,
 -1,
 -58827,
 439571512,
 70056,
 -1,
 439621871,
 70055,
 -58825,
 439605548,
 70058,
 -58824,
 439787899,
 70059,
 -58823,
 439847338,
 70031,
 -58822,
 439909141,
 70057,
 -58821,
 439964728,
 70066,
 -1,
 440024636,
 70029,
 440212046,
 435998806,
 -1,
 440277581,
 440185487,
 -1,
 440343107,
 440258491,
 -1,
 440408641,
 440312065,
 70072,
 -1,
 440377601,
 70073,
 440598527,
 440364743,
 70074,
 -1,
 440495815,
 70075,
 440670791,
 440277231,
 -1,
 -58811,
 440648906,
 70079,
 -58810,
 440687825,
 70077,
 -1,
 440735983,
 70067,
 440932937,
 440648906,
 70070,
 -1,
 440911050,
 70071,
 441064011,
 440884433,
 70068,
 -1,
 441015505,
 70069,
 -58804,
 441026986,
 70078,
 -1,
 441138748,
 70076,
 -1,
 440238407,
 70091,
 441391714,
 440184204,
 -1,
 441457243,
 441344109,
 -1,
 441522771,
 441438014,
 -1,
 -58798,
 441495254,
 70018,
 -1,
 441557671,
 70080,
 441719382,
 441456879,
 -1,
 -58795,
 441699475,
 70081,
 -1,
 441747749,
 70017,
 -58793,
 441698791,
 70083,
 -58792,
 441889323,
 70107,
 -58791,
 441944278,
 70090,
 -58790,
 442002090,
 70082,
 -1,
 442051657,
 70016,
 442243680,
 441400892,
 -1,
 442309215,
 442184947,
 -1,
 -58786,
 442241488,
 70111,
 -1,
 442306725,
 70110,
 -1,
 442276064,
 70088,
 -58783,
 442223707,
 70093,
 -1,
 442507202,
 70089,
 442702451,
 441333213,
 -1,
 442767985,
 442654806,
 -1,
 442833511,
 442743323,
 -1,
 -58778,
 442816010,
 70098,
 -1,
 442850112,
 70099,
 443030122,
 442805644,
 -1,
 -58775,
 442984835,
 70102,
 -1,
 443041759,
 70103,
 443226733,
 442976696,
 -1,
 -58772,
 443192260,
 70100,
 -1,
 443246801,
 70101,
 -58770,
 443210737,
 70096,
 -58769,
 443387316,
 70097,
 -58768,
 443450928,
 70105,
 -1,
 443499061,
 70104,
 -58766,
 442733389,
 70086,
 -1,
 443621293,
 70085,
 443816566,
 442646076,
 -1,
 -58763,
 443799721,
 70092,
 -1,
 443837420,
 70106,
 -58761,
 443780284,
 70084,
 -58760,
 443963062,
 70108,
 -58759,
 444019410,
 70109,
 -1,
 444078602,
 70087,
 -1,
 435907381,
 129416,
 444340923,
 435866746,
 -1,
 444406458,
 444292535,
 -1,
 444471943,
 444340463,
 -1,
 444537473,
 444440833,
 -1,
 -58752,
 444506965,
 66684,
 -1,
 444546620,
 66680,
 -58750,
 444519022,
 66679,
 -58749,
 444706870,
 66664,
 -58748,
 444753559,
 66682,
 -58747,
 444814370,
 66669,
 -58746,
 444879037,
 66673,
 -1,
 444938669,
 66665,
 445127310,
 444434858,
 -1,
 -58743,
 445107227,
 66668,
 -58742,
 445161729,
 66681,
 -58741,
 445224765,
 66677,
 -58740,
 445285108,
 66666,
 -58739,
 445341877,
 66678,
 -1,
 445390198,
 66676,
 445586068,
 445070908,
 -1,
 445651602,
 445520111,
 -1,
 -58735,
 445626907,
 66672,
 -1,
 445686017,
 66685,
 -58733,
 445623378,
 66683,
 -1,
 445796676,
 66663,
 445979289,
 445561371,
 -1,
 446044824,
 445928482,
 -1,
 -58729,
 445997008,
 66644,
 -1,
 446056881,
 66654,
 -1,
 446009943,
 66641,
 446306973,
 445930705,
 -1,
 -58725,
 446253496,
 66662,
 -58724,
 446311769,
 66674,
 -1,
 446373661,
 66686,
 446569120,
 446290337,
 -1,
 -58721,
 446550284,
 66687,
 -1,
 446568687,
 66648,
 446765731,
 446551562,
 -1,
 -58718,
 446729235,
 66667,
 -1,
 446774844,
 66658,
 446962342,
 446737804,
 -1,
 -58715,
 446941968,
 66646,
 -1,
 446990762,
 66645,
 447158953,
 446921407,
 -1,
 -58712,
 447111470,
 66661,
 -1,
 447168513,
 66656,
 447355564,
 447108130,
 -1,
 -58709,
 447334581,
 66649,
 -1,
 447355265,
 66659,
 -58707,
 447339662,
 66655,
 -58706,
 447533132,
 66653,
 -58705,
 447596825,
 66675,
 -58704,
 447654702,
 66670,
 -58703,
 447715752,
 66640,
 -58702,
 447777052,
 66671,
 -58701,
 447838285,
 66660,
 -58700,
 447901020,
 66642,
 -58699,
 447965972,
 66657,
 -58698,
 448024538,
 66652,
 -58697,
 448088720,
 66643,
 -58696,
 448149339,
 66651,
 -58695,
 448212754,
 66647,
 -1,
 448276569,
 66650,
 -1,
 444350599,
 127847,
 -58692,
 444301821,
 9752,
 -1,
 448493561,
 129368,
 448666319,
 435784106,
 -1,
 448731850,
 448638120,
 -1,
 448797380,
 448681314,
 -1,
 -58687,
 448776650,
 113827,
 -58686,
 448820511,
 113824,
 -58685,
 448871621,
 113826,
 -1,
 448934628,
 113825,
 449125065,
 448724992,
 -1,
 449190600,
 449062322,
 -1,
 -58681,
 449135736,
 11103,
 -1,
 449190597,
 11087,
 -1,
 449164208,
 11086,
 -1,
 449063903,
 127856,
 449518285,
 448699807,
 -1,
 -58676,
 449495693,
 128722,
 -1,
 449521186,
 128717,
 -58674,
 449499835,
 128703,
 -1,
 449680074,
 127776,
 449845974,
 448617681,
 -1,
 449911507,
 449793756,
 -1,
 -58670,
 449877121,
 983075,
 -1,
 449929602,
 983078,
 -58668,
 449877870,
 128674,
 -58667,
 450070704,
 9961,
 -1,
 450118334,
 128737,
 450304729,
 449814785,
 -1,
 -58664,
 450283300,
 129335,
 -1,
 450322802,
 129424,
 -58662,
 450287827,
 983197,
 -1,
 450445641,
 128017,
 450632611,
 435689711,
 -1,
 450698057,
 450611950,
 -1,
 450763551,
 450655452,
 -1,
 450829029,
 450743418,
 -1,
 450894564,
 450791988,
 -1,
 450960098,
 450863361,
 43144,
 -1,
 450928897,
 43145,
 451149823,
 450916039,
 43146,
 -1,
 451047111,
 43147,
 -1,
 450828527,
 43182,
 451287787,
 450804251,
 -1,
 451353321,
 451263003,
 -1,
 -58648,
 451302456,
 43165,
 -1,
 451352815,
 43164,
 -58646,
 451302456,
 43170,
 -1,
 451483887,
 43169,
 451681008,
 451248884,
 -1,
 -58643,
 451664172,
 43163,
 -58642,
 451707729,
 43168,
 -58641,
 451760007,
 43158,
 -1,
 451811567,
 43173,
 452008694,
 451622365,
 -1,
 452074228,
 451950045,
 -1,
 -58637,
 452023352,
 43167,
 -1,
 452073711,
 43166,
 -58635,
 452023352,
 43172,
 -1,
 452204783,
 43171,
 452401914,
 451942639,
 43138,
 -58632,
 452379850,
 43153,
 -58631,
 452418769,
 43150,
 -1,
 452466927,
 43139,
 452664062,
 452373900,
 -1,
 -58628,
 452636191,
 43184,
 -58627,
 452678712,
 43183,
 -1,
 452729071,
 43185,
 452926208,
 452641994,
 43142,
 -1,
 452904138,
 43143,
 453057283,
 452892526,
 -1,
 -58622,
 453006392,
 43175,
 -1,
 453056751,
 43174,
 453253893,
 453020074,
 43151,
 -1,
 453216682,
 43152,
 453384968,
 453209799,
 -1,
 -58617,
 453340933,
 43187,
 -1,
 453384431,
 43181,
 453581579,
 453339957,
 -1,
 -58614,
 453530680,
 43155,
 -1,
 453581039,
 43154,
 453778190,
 453536265,
 -1,
 -58611,
 453727288,
 43162,
 -1,
 453777647,
 43161,
 453974800,
 453729489,
 43140,
 -1,
 453926097,
 43141,
 454105875,
 453922616,
 -1,
 -58606,
 454054968,
 43157,
 -1,
 454105327,
 43156,
 454302485,
 454049340,
 43148,
 -1,
 454245948,
 43149,
 454433560,
 454241154,
 -1,
 -58601,
 454382648,
 43160,
 -1,
 454433007,
 43159,
 454630171,
 454370738,
 -1,
 -58598,
 454579256,
 43177,
 -1,
 454629615,
 43176,
 -58596,
 454613292,
 43179,
 -58595,
 454795643,
 43180,
 -58594,
 454851349,
 43178,
 -1,
 454906936,
 43186,
 455088945,
 450744472,
 -1,
 455154469,
 455069627,
 -1,
 455220003,
 455123201,
 43194,
 -1,
 455188737,
 43195,
 455409663,
 455175879,
 43196,
 -1,
 455306951,
 43197,
 455482153,
 455088367,
 -1,
 -58585,
 455460042,
 43203,
 -58584,
 455498961,
 43200,
 -1,
 455547119,
 43189,
 455744299,
 455460042,
 43192,
 -1,
 455722186,
 43193,
 455875373,
 455707050,
 43201,
 -1,
 455838122,
 43202,
 456006447,
 455826641,
 43190,
 -1,
 455957713,
 43191,
 456196095,
 455949884,
 43198,
 -1,
 456080956,
 43199,
 456268610,
 455030237,
 -1,
 456334144,
 456220758,
 -1,
 456399670,
 456309275,
 -1,
 -58571,
 456381962,
 43218,
 -1,
 456416064,
 43219,
 456596281,
 456371596,
 -1,
 -58568,
 456550787,
 43222,
 -1,
 456607711,
 43223,
 456792892,
 456542648,
 -1,
 -58565,
 456758212,
 43220,
 -1,
 456812753,
 43221,
 -58563,
 456776689,
 43216,
 -58562,
 456953268,
 43217,
 -58561,
 457016880,
 43225,
 -1,
 457065013,
 43224,
 -58559,
 456299341,
 43215,
 -1,
 457187245,
 43214,
 457382728,
 456241807,
 -1,
 457448262,
 457363262,
 -1,
 -58555,
 457420502,
 43137,
 -1,
 457482919,
 43204,
 -58553,
 457387081,
 43205,
 -1,
 457580710,
 43136,
 -1,
 457323130,
 43188,
 457841559,
 450657415,
 -1,
 457907045,
 457798876,
 -1,
 457972559,
 457882139,
 -1,
 -58547,
 457944627,
 2065,
 -58546,
 457992194,
 2056,
 -1,
 458037664,
 2069,
 458234707,
 457923793,
 -1,
 -58543,
 458217683,
 2052,
 -58542,
 458275355,
 2055,
 -1,
 458326772,
 2063,
 458496854,
 458206604,
 -1,
 -58539,
 458449900,
 2062,
 -1,
 458511689,
 2068,
 458693465,
 458433970,
 -1,
 -58536,
 458647554,
 2049,
 -1,
 458693021,
 2053,
 -58534,
 458677207,
 2054,
 -58533,
 458873639,
 2057,
 -58532,
 458926702,
 2067,
 -58531,
 458989780,
 2066,
 -58530,
 459049244,
 2061,
 -58529,
 459112521,
 2060,
 -58528,
 459173667,
 2059,
 -58527,
 459238315,
 2058,
 -58526,
 459296763,
 2050,
 -58525,
 459361050,
 2064,
 -58524,
 459421367,
 2051,
 -1,
 459480529,
 2048,
 459676535,
 457887896,
 -1,
 459742060,
 459634789,
 -1,
 459807593,
 459675887,
 2082,
 -1,
 459741423,
 2079,
 -58518,
 459785418,
 2086,
 -58517,
 459889873,
 2089,
 -1,
 459947580,
 2076,
 460135279,
 459704746,
 2091,
 460259327,
 460115486,
 2081,
 -1,
 460134639,
 2078,
 460331890,
 460107148,
 -1,
 -58511,
 460310390,
 2092,
 -1,
 460348088,
 2085,
 460528500,
 460265711,
 2083,
 -1,
 460462319,
 2080,
 -58507,
 460506314,
 2087,
 -58506,
 460610769,
 2090,
 -1,
 460668476,
 2077,
 460856202,
 459644607,
 -1,
 460921727,
 460789999,
 -1,
 460987260,
 460882676,
 -1,
 -58501,
 460948327,
 2110,
 -1,
 461000939,
 2098,
 -58499,
 460963844,
 2100,
 -58498,
 461155044,
 2108,
 -1,
 461197011,
 2097,
 461380482,
 460905263,
 -1,
 -58495,
 461334162,
 2104,
 -1,
 461380466,
 2106,
 461577093,
 461352332,
 -1,
 -58492,
 461540082,
 2109,
 -1,
 461592930,
 2101,
 -58490,
 461554637,
 2107,
 -58489,
 461741994,
 2105,
 -58488,
 461800689,
 2096,
 -58487,
 461864577,
 2103,
 -1,
 461907736,
 2099,
 462101398,
 460815039,
 -1,
 462166930,
 462037449,
 -1,
 462232462,
 462119298,
 2070,
 -1,
 462163501,
 2071,
 -58481,
 462195277,
 2072,
 -58480,
 462324977,
 2093,
 -58479,
 462374180,
 2075,
 -1,
 462435996,
 2073,
 462684159,
 462129856,
 -1,
 -58476,
 462598581,
 2084,
 -58475,
 462642385,
 2088,
 -1,
 462701860,
 2074,
 -1,
 462035429,
 2102,
 462953374,
 457803726,
 -1,
 463018909,
 462903008,
 -1,
 463084444,
 462961423,
 -1,
 -58469,
 463061868,
 128630,
 -1,
 463090110,
 128631,
 -1,
 463042820,
 128632,
 -1,
 462972208,
 128634,
 463412128,
 462928917,
 128752,
 -1,
 463339755,
 128225,
 -58463,
 463394960,
 127927,
 -58462,
 463498379,
 127862,
 -1,
 463560906,
 9973,
 463739987,
 450600897,
 -1,
 463805522,
 463675824,
 -1,
 463871033,
 463746527,
 -1,
 463936485,
 463809410,
 -1,
 464002019,
 463891139,
 -1,
 464067516,
 463934695,
 -1,
 464133037,
 463999440,
 -1,
 -58453,
 464066413,
 127545,
 -58452,
 464131297,
 127516,
 -1,
 464196042,
 127520,
 464395184,
 464066621,
 -1,
 -58449,
 464327403,
 127511,
 -1,
 464392647,
 127509,
 464591795,
 464327699,
 -1,
 -58446,
 464524304,
 127525,
 -1,
 464588955,
 127540,
 464788406,
 464524021,
 -1,
 -58443,
 464734726,
 127534,
 -1,
 464792890,
 127506,
 -58441,
 464734729,
 127517,
 -58440,
 464926551,
 127532,
 -58439,
 464987612,
 127505,
 -58438,
 465049657,
 127524,
 -58437,
 465114584,
 127546,
 -1,
 465179075,
 127518,
 465378253,
 464000476,
 -1,
 465443777,
 465310160,
 -1,
 -58433,
 465377505,
 127527,
 -58432,
 465442238,
 127537,
 -1,
 465507550,
 127504,
 465705924,
 465377127,
 -1,
 -58429,
 465639485,
 127542,
 -1,
 465704844,
 127543,
 465902535,
 465638631,
 -1,
 -58426,
 465839553,
 127519,
 -1,
 465901800,
 127515,
 466099146,
 465834741,
 -1,
 -58423,
 466032065,
 127528,
 -1,
 466096280,
 127535,
 -58421,
 466045442,
 127526,
 -58420,
 466239311,
 127541,
 -1,
 466294433,
 127513,
 466492373,
 465311404,
 -1,
 466557905,
 466425063,
 -1,
 -58416,
 466490372,
 127544,
 -1,
 466555341,
 127522,
 -58414,
 466499171,
 127521,
 -58413,
 466688409,
 127539,
 -58412,
 466753764,
 127538,
 -1,
 466817454,
 127514,
 467016668,
 466425060,
 -1,
 467082201,
 466947992,
 -1,
 -58408,
 467015741,
 127530,
 -1,
 467079064,
 127529,
 -58406,
 467016086,
 127512,
 -58405,
 467212342,
 127508,
 -1,
 467276526,
 127533,
 467475424,
 466950028,
 -1,
 -58402,
 467416679,
 127536,
 -58401,
 467479475,
 127523,
 -1,
 467540203,
 127510,
 467795967,
 467408957,
 -1,
 -58398,
 467669426,
 127547,
 -1,
 467734676,
 127531,
 -58396,
 463966065,
 127378,
 -1,
 467889863,
 127377,
 468065288,
 463892167,
 -1,
 468130819,
 468001881,
 -1,
 468196354,
 468069522,
 -1,
 -58391,
 468179759,
 127305,
 -58390,
 468244691,
 127304,
 -58389,
 468309981,
 127303,
 -58388,
 468373772,
 127302,
 -58387,
 468438138,
 127301,
 -58386,
 468501706,
 127300,
 -58385,
 468564507,
 127299,
 -58384,
 468626828,
 127298,
 -58383,
 468689153,
 127297,
 -58382,
 468754251,
 127296,
 -58381,
 468817774,
 127295,
 -58380,
 468879786,
 127294,
 -58379,
 468943604,
 127293,
 -58378,
 469007039,
 127292,
 -58377,
 469069511,
 127291,
 -58376,
 469134133,
 127290,
 -58375,
 469199369,
 127289,
 -58374,
 469261521,
 127288,
 -58373,
 469324834,
 127287,
 -58372,
 469389112,
 127286,
 -58371,
 469453240,
 127285,
 -58370,
 469515836,
 127284,
 -58369,
 469579229,
 127283,
 -58368,
 469642114,
 127282,
 -58367,
 469706162,
 127281,
 -1,
 469768431,
 127280,
 -1,
 468169820,
 127397,
 470089727,
 468093354,
 -1,
 470096903,
 469979698,
 -1,
 -58362,
 470061329,
 10191,
 -1,
 470097727,
 10190,
 -1,
 470070992,
 127401,
 470359058,
 468037004,
 -1,
 470424588,
 470302268,
 -1,
 -58357,
 470404565,
 127393,
 -1,
 470430253,
 127388,
 -58355,
 470396300,
 127309,
 -58354,
 470585903,
 127384,
 -58353,
 470641118,
 127395,
 -58352,
 470703266,
 127402,
 -58351,
 470758877,
 127308,
 -1,
 470818509,
 9949,
 471014424,
 470313781,
 -1,
 471079959,
 470950860,
 -1,
 -58347,
 471051807,
 127490,
 -58346,
 471100926,
 127489,
 -1,
 471152445,
 127507,
 -1,
 471026097,
 9919,
 471407645,
 470963234,
 -1,
 -58342,
 471387258,
 127306,
 -58341,
 471424330,
 127400,
 -58340,
 471481705,
 127399,
 -1,
 471542658,
 127398,
 471735331,
 471353784,
 -1,
 471800865,
 471700424,
 -1,
 -58336,
 471755573,
 127390,
 -1,
 471808619,
 11820,
 -58334,
 471770352,
 127379,
 -1,
 471951654,
 127392,
 472128552,
 471710235,
 -1,
 472194087,
 472109324,
 -1,
 -58330,
 472156604,
 127389,
 -1,
 472204505,
 127394,
 -1,
 472144737,
 127387,
 472456235,
 472108154,
 -1,
 -58326,
 472427916,
 127386,
 -1,
 472484503,
 127404,
 472652846,
 472433866,
 -1,
 -58323,
 472618945,
 127385,
 -1,
 472667774,
 127403,
 472849457,
 472615338,
 -1,
 -58320,
 472810600,
 127396,
 -1,
 472869685,
 127383,
 473046068,
 472810228,
 -1,
 -58317,
 472993592,
 127382,
 -1,
 473057442,
 127381,
 -58315,
 473027174,
 127311,
 -58314,
 473210320,
 127310,
 -58313,
 473268940,
 127307,
 -58312,
 473325200,
 127380,
 -1,
 473383502,
 127391,
 473628671,
 463798272,
 -1,
 473635903,
 473552004,
 -1,
 -58308,
 473614922,
 11028,
 -58307,
 473677942,
 11026,
 -58306,
 473725337,
 11029,
 -1,
 473770514,
 11027,
 473963589,
 473576925,
 -1,
 474029124,
 473922239,
 13175,
 474152959,
 473956352,
 -1,
 -58301,
 474068533,
 13176,
 -1,
 474101018,
 13177,
 -1,
 473983497,
 127376,
 474356808,
 473912354,
 -1,
 -58297,
 474310304,
 127488,
 -1,
 474369848,
 13004,
 474553419,
 474299964,
 -1,
 -58294,
 474532986,
 13006,
 -1,
 474588750,
 13005,
 -58292,
 474532988,
 13278,
 -58291,
 474725240,
 128918,
 -58290,
 474783046,
 11216,
 -58289,
 474835150,
 13178,
 -58288,
 474894321,
 13311,
 -58287,
 474959258,
 9974,
 -1,
 475011350,
 13279,
 -1,
 463756944,
 129425,
 475274436,
 463717578,
 -1,
 475339965,
 475235060,
 -1,
 475405494,
 475281133,
 -1,
 475470980,
 475362524,
 -1,
 475536475,
 475431668,
 -1,
 -58279,
 475519276,
 7057,
 -58278,
 475549575,
 7053,
 -1,
 475601135,
 7060,
 475798624,
 475482552,
 -1,
 475864159,
 475750830,
 -1,
 -58274,
 475822783,
 7103,
 -1,
 475884341,
 7102,
 -1,
 475797743,
 7062,
 476126307,
 475770252,
 -1,
 -58270,
 476109100,
 7087,
 -1,
 476125423,
 7070,
 476322918,
 476094721,
 -1,
 -58267,
 476268358,
 7099,
 -1,
 476322031,
 7067,
 476519529,
 476278471,
 -1,
 -58264,
 476464966,
 7100,
 -1,
 476518639,
 7068,
 476716140,
 476474165,
 -1,
 -58261,
 476664888,
 7086,
 -1,
 476715247,
 7050,
 476912750,
 476659260,
 7048,
 -1,
 476890314,
 7049,
 477043825,
 476849586,
 -1,
 -58256,
 476992568,
 7101,
 -1,
 477042927,
 7064,
 477240435,
 476977391,
 7043,
 -1,
 477183548,
 7046,
 -58252,
 477223743,
 7056,
 -58251,
 477354284,
 7066,
 -58250,
 477419520,
 7071,
 -58249,
 477483340,
 7069,
 -58248,
 477547664,
 7063,
 -58247,
 477611210,
 7045,
 -58246,
 477674141,
 7058,
 -58245,
 477732714,
 7051,
 -58244,
 477796316,
 7061,
 -58243,
 477858218,
 7047,
 -58242,
 477920021,
 7065,
 -58241,
 477981223,
 7055,
 -58240,
 478043345,
 7044,
 -58239,
 478106680,
 7072,
 -58238,
 478171015,
 7052,
 -58237,
 478230123,
 7059,
 -1,
 478292912,
 7054,
 478485650,
 475412700,
 -1,
 478551176,
 478460443,
 -1,
 -58233,
 478533130,
 7090,
 -1,
 478567232,
 7091,
 478747787,
 478522764,
 -1,
 -58230,
 478701955,
 7094,
 -1,
 478758879,
 7095,
 478944398,
 478693816,
 -1,
 -58227,
 478909380,
 7092,
 -1,
 478963921,
 7093,
 -58225,
 478927857,
 7088,
 -58224,
 479104436,
 7089,
 -58223,
 479168048,
 7097,
 -1,
 479216181,
 7096,
 479403164,
 478453452,
 -1,
 479468694,
 479369070,
 -1,
 -58219,
 479447867,
 7362,
 -1,
 479469618,
 7361,
 -58217,
 479443282,
 7360,
 -58216,
 479622487,
 7364,
 -58215,
 479685514,
 7365,
 -58214,
 479737477,
 7366,
 -58213,
 479800298,
 7363,
 -1,
 479864298,
 7367,
 480058532,
 479383716,
 -1,
 480124067,
 480019188,
 -1,
 -58209,
 480107298,
 7077,
 -58208,
 480152744,
 7079,
 -58207,
 480203272,
 7076,
 -58206,
 480266107,
 7081,
 -1,
 480320374,
 7078,
 -1,
 480083659,
 7080,
 480582829,
 480031375,
 -1,
 480648364,
 480548828,
 -1,
 480713899,
 480609012,
 -1,
 480779434,
 480661304,
 -1,
 -58199,
 480760947,
 7042,
 -1,
 480801066,
 7041,
 -1,
 480762286,
 7040,
 -1,
 480672540,
 7082,
 -1,
 480628599,
 7083,
 481172661,
 480522918,
 -1,
 481238193,
 481144505,
 -1,
 -58192,
 481218892,
 7085,
 -1,
 481262357,
 7084,
 481434804,
 481200466,
 -1,
 -58189,
 481386673,
 7075,
 -1,
 481435041,
 7074,
 -1,
 481394801,
 7073,
 -1,
 481109278,
 7098,
 481762488,
 475376226,
 127749,
 -1,
 481691167,
 127748,
 481893563,
 481689600,
 -1,
 -58182,
 481875098,
 127774,
 -1,
 481896315,
 9925,
 -58180,
 481865755,
 127751,
 -1,
 482036929,
 127803,
 482221248,
 475311500,
 -1,
 -58177,
 482187784,
 128671,
 -1,
 482236385,
 127843,
 482417858,
 482158002,
 983102,
 -1,
 482391950,
 983101,
 -58173,
 482387529,
 127940,
 -1,
 482515597,
 10185,
 482680079,
 475236778,
 983077,
 482745585,
 482648454,
 -1,
 482811107,
 482702556,
 -1,
 482876619,
 482771700,
 -1,
 -58167,
 482859315,
 69857,
 -58166,
 482889705,
 69847,
 -1,
 482942088,
 69849,
 483138766,
 482835221,
 -1,
 -58163,
 483087394,
 69846,
 -1,
 483147324,
 69864,
 483335377,
 483081788,
 -1,
 -58160,
 483284002,
 69863,
 -1,
 483344872,
 69859,
 -58158,
 483318067,
 69852,
 -58157,
 483511451,
 69850,
 -58156,
 483575607,
 69861,
 -58155,
 483637995,
 69841,
 -58154,
 483700290,
 69840,
 -58153,
 483762644,
 69853,
 -58152,
 483825698,
 69851,
 -58151,
 483887969,
 69862,
 -58150,
 483946442,
 69848,
 -58149,
 484010955,
 69855,
 -58148,
 484076083,
 69856,
 -58147,
 484139165,
 69860,
 -58146,
 484201583,
 69854,
 -58145,
 484265961,
 69845,
 -58144,
 484325027,
 69844,
 -58143,
 484387803,
 69843,
 -58142,
 484451879,
 69842,
 -1,
 484514952,
 69858,
 484769791,
 482752732,
 -1,
 484777191,
 484686363,
 -1,
 -58138,
 484759050,
 69874,
 -1,
 484793152,
 69875,
 484973802,
 484748684,
 -1,
 -58135,
 484927875,
 69878,
 -1,
 484984799,
 69879,
 485170413,
 484919736,
 -1,
 -58132,
 485135300,
 69876,
 -1,
 485189841,
 69877,
 -58130,
 485153777,
 69872,
 -58129,
 485330356,
 69873,
 -58128,
 485393968,
 69881,
 -1,
 485442101,
 69880,
 485629190,
 482724909,
 -1,
 485694716,
 485610180,
 -1,
 485760247,
 485661826,
 -1,
 -58123,
 485740397,
 128601,
 -58122,
 485782052,
 128593,
 -1,
 485829361,
 128609,
 486022393,
 485736926,
 11113,
 -1,
 485952179,
 11129,
 -58118,
 486003495,
 11011,
 -58117,
 486125249,
 129111,
 -1,
 486156523,
 11019,
 486408191,
 485638053,
 -1,
 486415617,
 486317186,
 -1,
 -58113,
 486395757,
 128603,
 -58112,
 486437412,
 128595,
 -1,
 486484721,
 128611,
 486677763,
 486392286,
 11112,
 -1,
 486607539,
 11128,
 -58108,
 486658855,
 11010,
 -58107,
 486780609,
 129110,
 -1,
 486811883,
 11018,
 487005448,
 485586391,
 128618,
 -1,
 486933364,
 128619,
 487136523,
 486952668,
 -1,
 -58102,
 487108898,
 128428,
 -1,
 487153202,
 127846,
 -58100,
 487107980,
 983181,
 -58099,
 487296381,
 128284,
 -58098,
 487347234,
 983043,
 -1,
 487402819,
 9917,
 487595359,
 482662611,
 -1,
 487660876,
 487553236,
 -1,
 487726397,
 487617756,
 -1,
 487791896,
 487701019,
 -1,
 487857430,
 487766555,
 -1,
 -58091,
 487819690,
 43024,
 -1,
 487872915,
 43025,
 -58089,
 487819690,
 43028,
 -1,
 488003987,
 43029,
 488185118,
 487732701,
 -1,
 488250652,
 488125917,
 -1,
 -58085,
 488212906,
 43026,
 -1,
 488266131,
 43027,
 -58083,
 488212906,
 43030,
 -1,
 488397203,
 43031,
 488578337,
 488153345,
 -1,
 -58080,
 488549144,
 43040,
 -1,
 488606122,
 43038,
 488774948,
 488544110,
 -1,
 -58077,
 488737194,
 43033,
 -1,
 488790419,
 43034,
 488971559,
 488729397,
 -1,
 -58074,
 488933802,
 43015,
 -1,
 488987027,
 43016,
 489168170,
 488925705,
 -1,
 -58071,
 489130410,
 43022,
 -1,
 489183635,
 43023,
 489364781,
 489115448,
 -1,
 -58068,
 489327018,
 43017,
 -1,
 489380243,
 43018,
 489561392,
 489302914,
 -1,
 -58065,
 489523626,
 43020,
 -1,
 489576851,
 43021,
 489758003,
 489498034,
 -1,
 -58062,
 489720234,
 43035,
 -1,
 489773459,
 43036,
 -58060,
 489735370,
 43011,
 -58059,
 489927973,
 43041,
 -58058,
 489982378,
 43013,
 -58057,
 490047213,
 43032,
 -58056,
 490111234,
 43037,
 -58055,
 490174503,
 43039,
 -58054,
 490233041,
 43009,
 -58053,
 490297747,
 43042,
 -58052,
 490356284,
 43012,
 -1,
 490412271,
 43008,
 490609987,
 487706776,
 -1,
 -58049,
 490587338,
 43045,
 -58048,
 490639161,
 43047,
 -58047,
 490691793,
 43044,
 -58046,
 490749500,
 43046,
 -1,
 490805487,
 43043,
 491003208,
 490576985,
 -1,
 -58043,
 490935315,
 43051,
 -58042,
 491000565,
 43050,
 -58041,
 491065808,
 43049,
 -1,
 491131045,
 43048,
 491388927,
 490975887,
 -1,
 -58038,
 491279938,
 43014,
 -58037,
 491339292,
 43010,
 -1,
 491397286,
 43019,
 491593049,
 487630496,
 -1,
 491658584,
 491526717,
 -1,
 491724119,
 491615452,
 -1,
 491789651,
 491697467,
 -1,
 -58031,
 491773004,
 1869,
 -58030,
 491810104,
 1870,
 -1,
 491866739,
 1871,
 492109823,
 491756198,
 -1,
 -58027,
 491999626,
 1838,
 -58026,
 492058666,
 1839,
 -1,
 492120144,
 1837,
 -1,
 491698413,
 983202,
 -1,
 491619771,
 128137,
 492445020,
 491553524,
 983094,
 -58021,
 492383986,
 983093,
 -1,
 492444775,
 128333,
 492699647,
 492404098,
 -1,
 -58018,
 492613268,
 8527,
 -1,
 492666057,
 128325,
 492838277,
 487569947,
 983189,
 492903793,
 492771567,
 -1,
 492969321,
 492874923,
 -1,
 493034853,
 492940684,
 -1,
 -58012,
 493011510,
 983180,
 -1,
 493044444,
 983132,
 -58010,
 493010119,
 983044,
 -58009,
 493198938,
 983175,
 -58008,
 493246126,
 983042,
 -1,
 493310890,
 983174,
 493493612,
 492943899,
 -1,
 -58005,
 493471494,
 128509,
 -1,
 493512241,
 128649,
 493690223,
 493439675,
 -1,
 -58002,
 493639533,
 9882,
 -1,
 493689782,
 9877,
 -58000,
 493650393,
 128387,
 -1,
 493828458,
 127967,
 494017912,
 492871937,
 -1,
 494083447,
 493951215,
 -1,
 494148982,
 494034900,
 -1,
 -57995,
 494109972,
 9188,
 -1,
 494143624,
 128207,
 -1,
 494129744,
 127827,
 -1,
 494035922,
 983188,
 494476669,
 493960764,
 -1,
 494542204,
 494411476,
 -1,
 -57989,
 494494442,
 127836,
 -1,
 494535733,
 128642,
 -1,
 494503689,
 11836,
 494804352,
 494453962,
 -1,
 -57985,
 494750402,
 129369,
 -1,
 494811415,
 127897,
 495000963,
 494766506,
 -1,
 -57982,
 494968644,
 9201,
 -1,
 495005764,
 128480,
 -57980,
 494983133,
 983045,
 -1,
 495168908,
 983169,
 495328676,
 492803950,
 983117,
 495394195,
 495271484,
 -1,
 495459727,
 495328630,
 -1,
 495525261,
 495404418,
 128264,
 495648767,
 495454978,
 -1,
 -57973,
 495566339,
 128266,
 -57972,
 495619609,
 128265,
 -1,
 495660047,
 128263,
 -57970,
 495477560,
 128483,
 -1,
 495783650,
 128586,
 495984018,
 495402556,
 -1,
 -57967,
 495925024,
 128676,
 -1,
 495988223,
 128172,
 -1,
 495957254,
 8375,
 496246170,
 495344849,
 -1,
 496311704,
 496214663,
 -1,
 -57962,
 496283932,
 128026,
 -57961,
 496338839,
 128466,
 -1,
 496380912,
 128467,
 496631807,
 496252876,
 128375,
 -1,
 496503543,
 128376,
 496704927,
 496179439,
 983176,
 496770462,
 496675574,
 -1,
 -57955,
 496722767,
 128150,
 -1,
 496780941,
 10024,
 -1,
 496718239,
 127837,
 497032611,
 496667050,
 -1,
 -57951,
 497011791,
 128051,
 -57950,
 497069290,
 127941,
 -1,
 497126706,
 129348,
 -1,
 496988323,
 128166,
 497360318,
 495286975,
 -1,
 497425848,
 497310929,
 -1,
 497491383,
 497383150,
 -1,
 497556916,
 497437205,
 -1,
 497622445,
 497520707,
 128515,
 497745919,
 497549383,
 -1,
 -57941,
 497663688,
 128518,
 -57940,
 497726700,
 128516,
 -1,
 497758541,
 128517,
 497950129,
 497570850,
 -1,
 -57937,
 497914339,
 128520,
 -57936,
 497958798,
 128525,
 -1,
 498015879,
 128519,
 498270207,
 497921420,
 -1,
 -57933,
 498190543,
 128526,
 -1,
 498237458,
 128522,
 498466815,
 497495275,
 -1,
 -57930,
 498372675,
 128570,
 -1,
 498423495,
 128571,
 -1,
 497461995,
 128527,
 498671037,
 497360485,
 -1,
 -57926,
 498648134,
 68411,
 -57925,
 498700588,
 128312,
 -57924,
 498739584,
 128313,
 -1,
 498801926,
 128745,
 -1,
 498633720,
 128684,
 499064274,
 497315527,
 -1,
 499129799,
 499007036,
 -1,
 499195334,
 499074324,
 -1,
 499260869,
 499147484,
 -1,
 -57917,
 499235288,
 128164,
 -57916,
 499272208,
 128564,
 -1,
 499325525,
 128716,
 -1,
 499243245,
 128554,
 -1,
 499174462,
 128373,
 499654092,
 499080401,
 -1,
 499719627,
 499601921,
 -1,
 -57910,
 499692793,
 128578,
 -1,
 499732165,
 128577,
 -1,
 499658080,
 127829,
 499981777,
 499587311,
 -1,
 500047312,
 499943521,
 -1,
 -57905,
 500017860,
 11100,
 -1,
 500075475,
 11098,
 -1,
 500027431,
 42611,
 -1,
 499946074,
 127920,
 500375005,
 499007036,
 -1,
 500440534,
 500317756,
 -1,
 -57899,
 500382087,
 127793,
 -1,
 500436706,
 128584,
 -57897,
 500422819,
 9913,
 -57896,
 500611713,
 983168,
 -57895,
 500676198,
 9916,
 -57894,
 500727960,
 9914,
 -57893,
 500790680,
 129331,
 -57892,
 500838940,
 129352,
 -1,
 500900786,
 128186,
 501095913,
 500312962,
 -1,
 501161442,
 501063937,
 -1,
 -57888,
 501124246,
 128220,
 -57887,
 501180022,
 128624,
 -1,
 501236022,
 128437,
 501423589,
 501123498,
 -1,
 -57884,
 501394508,
 129410,
 -1,
 501453485,
 128756,
 501620199,
 501373470,
 127979,
 -1,
 501549212,
 127890,
 -57880,
 501570769,
 983185,
 -1,
 501685777,
 9878,
 501882354,
 501056244,
 -1,
 501947886,
 501847702,
 -1,
 -57876,
 501906508,
 9924,
 -57875,
 501950880,
 127938,
 -1,
 502006206,
 127956,
 502210033,
 501881071,
 -1,
 -57872,
 502164616,
 128013,
 -1,
 502227125,
 128012,
 -1,
 502153572,
 129319,
 502472182,
 501862668,
 -1,
 -57868,
 502450361,
 8275,
 -57867,
 502489448,
 127946,
 -1,
 502539084,
 128629,
 502734330,
 502443404,
 -1,
 -57864,
 502667503,
 983133,
 -57863,
 502731509,
 983159,
 -1,
 502796752,
 983156,
 502996479,
 502688565,
 -1,
 503062014,
 502947025,
 -1,
 -57859,
 503006594,
 9975,
 -1,
 503054513,
 127935,
 -1,
 503039913,
 128128,
 -1,
 502943930,
 983183,
 503391590,
 357726911,
 -1,
 503455793,
 503332412,
 -1,
 503521019,
 503415540,
 -1,
 503586553,
 503461696,
 -1,
 503652064,
 503560628,
 -1,
 503717491,
 503582616,
 -1,
 503782929,
 503650365,
 -1,
 -57848,
 503715986,
 125069,
 -57847,
 503781385,
 125123,
 -57846,
 503846574,
 124959,
 -57845,
 503911929,
 125036,
 -57844,
 503977267,
 124932,
 -57843,
 504042602,
 124952,
 -57842,
 504107818,
 125097,
 -57841,
 504173062,
 125088,
 -57840,
 504238443,
 124999,
 -1,
 504303628,
 125047,
 504503836,
 503715724,
 -1,
 -57837,
 504436807,
 124993,
 -57836,
 504502187,
 125024,
 -57835,
 504567514,
 125043,
 -57834,
 504632873,
 125056,
 -57833,
 504698262,
 125117,
 -57832,
 504763480,
 124985,
 -57831,
 504828721,
 125039,
 -57830,
 504894018,
 125049,
 -57829,
 504959303,
 125071,
 -1,
 505024625,
 125015,
 505224743,
 504436396,
 -1,
 -57826,
 505157804,
 124980,
 -57825,
 505223077,
 125021,
 -57824,
 505288535,
 125119,
 -57823,
 505353753,
 124933,
 -57822,
 505419039,
 125022,
 -57821,
 505484365,
 125089,
 -57820,
 505549660,
 124986,
 -57819,
 505614895,
 125080,
 -57818,
 505680107,
 125099,
 -1,
 505745354,
 125100,
 505945650,
 505157084,
 -1,
 -57815,
 505878710,
 125002,
 -57814,
 505944080,
 125068,
 -57813,
 506009369,
 125107,
 -57812,
 506074710,
 125074,
 -57811,
 506139960,
 124931,
 -57810,
 506205303,
 125108,
 -57809,
 506270541,
 125009,
 -57808,
 506335785,
 125076,
 -57807,
 506401155,
 124945,
 -1,
 506466335,
 125124,
 506666557,
 505877735,
 -1,
 -57804,
 506599512,
 124951,
 -57803,
 506664962,
 125121,
 -57802,
 506730286,
 125066,
 -57801,
 506795496,
 125095,
 -57800,
 506860931,
 125000,
 -57799,
 506926174,
 124987,
 -57798,
 506991416,
 125041,
 -57797,
 507056629,
 125044,
 -57796,
 507121986,
 125072,
 -1,
 507187251,
 125070,
 507387464,
 506598419,
 -1,
 -57793,
 507320512,
 124946,
 -57792,
 507385816,
 124934,
 -57791,
 507451141,
 125078,
 -57790,
 507516424,
 125046,
 -57789,
 507581861,
 124942,
 -57788,
 507647046,
 125090,
 -57787,
 507712399,
 125048,
 -57786,
 507777531,
 125037,
 -57785,
 507842809,
 125033,
 -1,
 507908060,
 125035,
 508108371,
 507319029,
 -1,
 -57782,
 508041356,
 125029,
 -57781,
 508106742,
 125028,
 -57780,
 508172093,
 125027,
 -57779,
 508237283,
 125020,
 -57778,
 508302618,
 125019,
 -57777,
 508367926,
 125018,
 -57776,
 508433377,
 125013,
 -57775,
 508498614,
 125012,
 -57774,
 508563853,
 125011,
 -1,
 508628973,
 125005,
 508829278,
 508039632,
 -1,
 -57771,
 508762189,
 125004,
 -57770,
 508827590,
 125003,
 -57769,
 508892928,
 124984,
 -57768,
 508958244,
 124983,
 -57767,
 509023550,
 124982,
 -57766,
 509088930,
 124998,
 -57765,
 509154248,
 124997,
 -57764,
 509219483,
 124996,
 -57763,
 509284710,
 124976,
 -1,
 509349949,
 124975,
 509550185,
 508760229,
 -1,
 -57760,
 509483175,
 124974,
 -57759,
 509548439,
 124992,
 -57758,
 509613747,
 124991,
 -57757,
 509679070,
 124990,
 -57756,
 509744525,
 124964,
 -57755,
 509809685,
 124963,
 -57754,
 509875012,
 124962,
 -57753,
 509940182,
 124957,
 -57752,
 510005427,
 124956,
 -1,
 510070688,
 124955,
 510328831,
 509480856,
 -1,
 -57749,
 510204005,
 124950,
 -57748,
 510269417,
 124949,
 -57747,
 510334739,
 124948,
 -57746,
 510400143,
 124938,
 -57745,
 510465435,
 124937,
 -57744,
 510530738,
 124936,
 -57743,
 510595922,
 124930,
 -57742,
 510661121,
 124929,
 -1,
 510726419,
 124928,
 510984191,
 503648421,
 -1,
 510991999,
 510859148,
 -1,
 -57738,
 510924894,
 124954,
 -57737,
 510990319,
 125079,
 -57736,
 511055628,
 125083,
 -57735,
 511120899,
 125034,
 -57734,
 511186321,
 125114,
 -57733,
 511251586,
 125065,
 -57732,
 511316838,
 125058,
 -57731,
 511382176,
 125113,
 -57730,
 511447248,
 124995,
 -1,
 511512494,
 124994,
 511712906,
 510924460,
 -1,
 -57727,
 511645778,
 124935,
 -57726,
 511711136,
 124973,
 -57725,
 511776565,
 125067,
 -57724,
 511841790,
 125032,
 -57723,
 511907139,
 125010,
 -57722,
 511972452,
 125082,
 -57721,
 512037837,
 125116,
 -57720,
 512102965,
 125081,
 -57719,
 512168279,
 125101,
 -1,
 512233510,
 125122,
 512433813,
 511645148,
 -1,
 -57716,
 512366726,
 125031,
 -57715,
 512432054,
 125061,
 -57714,
 512497363,
 125064,
 -57713,
 512562670,
 125063,
 -57712,
 512628094,
 124967,
 -57711,
 512693392,
 125120,
 -57710,
 512758551,
 124965,
 -57709,
 512823952,
 124977,
 -57708,
 512889117,
 125084,
 -1,
 512954343,
 125008,
 513154720,
 512365799,
 -1,
 -57705,
 513087607,
 125054,
 -57704,
 513152995,
 125093,
 -57703,
 513218281,
 125006,
 -57702,
 513283662,
 125052,
 -57701,
 513348900,
 125059,
 -57700,
 513414256,
 124953,
 -57699,
 513479521,
 124988,
 -57698,
 513544777,
 125109,
 -57697,
 513610103,
 125115,
 -1,
 513675162,
 124958,
 513875627,
 513086483,
 -1,
 -57694,
 513808511,
 125111,
 -57693,
 513873840,
 125096,
 -57692,
 513939267,
 124968,
 -57691,
 514004551,
 125051,
 -57690,
 514069849,
 125075,
 -57689,
 514135207,
 125118,
 -57688,
 514200531,
 124944,
 -57687,
 514265630,
 125086,
 -57686,
 514331031,
 125016,
 -1,
 514396130,
 125038,
 514596534,
 513807093,
 -1,
 -57683,
 514529478,
 124947,
 -57682,
 514594706,
 124961,
 -57681,
 514660034,
 124969,
 -57680,
 514725494,
 124979,
 -57679,
 514790697,
 124971,
 -57678,
 514856073,
 125112,
 -57677,
 514921252,
 125023,
 -57676,
 514986508,
 125087,
 -57675,
 515051790,
 124970,
 -1,
 515117014,
 125042,
 515317441,
 514527696,
 -1,
 -57672,
 515250283,
 125103,
 -57671,
 515315643,
 125040,
 -57670,
 515381030,
 125055,
 -57669,
 515446409,
 124939,
 -57668,
 515511659,
 125104,
 -57667,
 515576891,
 125094,
 -57666,
 515642249,
 125102,
 -57665,
 515707452,
 125077,
 -57664,
 515772818,
 125017,
 -1,
 515837971,
 125053,
 516038348,
 515248293,
 -1,
 -57661,
 515971185,
 125106,
 -57660,
 516036645,
 124940,
 -57659,
 516101920,
 125030,
 -57658,
 516167275,
 124978,
 -57657,
 516232561,
 125050,
 -57656,
 516297911,
 124941,
 -57655,
 516363080,
 125007,
 -57654,
 516428306,
 125092,
 -57653,
 516493542,
 125060,
 -1,
 516558839,
 124989,
 516759255,
 515968920,
 -1,
 -57650,
 516692172,
 125014,
 -57649,
 516757469,
 125091,
 -57648,
 516822733,
 125098,
 -57647,
 516888117,
 125057,
 -57646,
 516953421,
 125085,
 -57645,
 517018780,
 125001,
 -57644,
 517083917,
 124960,
 -57643,
 517149306,
 125073,
 -57642,
 517214432,
 125026,
 -1,
 517279674,
 124966,
 517537791,
 516692029,
 -1,
 -57639,
 517412551,
 125025,
 -57638,
 517478000,
 124981,
 -57637,
 517543150,
 124972,
 -57636,
 517608637,
 124943,
 -57635,
 517673790,
 125045,
 -57634,
 517739087,
 125110,
 -57633,
 517804328,
 125105,
 -1,
 517869520,
 125062,
 518069997,
 503593180,
 -1,
 518135524,
 518044187,
 -1,
 -57629,
 518116874,
 125128,
 -1,
 518150976,
 125129,
 518332135,
 518106508,
 -1,
 -57626,
 518285699,
 125132,
 -1,
 518342623,
 125133,
 518528746,
 518277560,
 -1,
 -57623,
 518493124,
 125130,
 -1,
 518547665,
 125131,
 -57621,
 518491572,
 125127,
 -57620,
 518686256,
 125135,
 -1,
 518734389,
 125134,
 518979583,
 518009246,
 -1,
 518987509,
 518896155,
 -1,
 519053044,
 518929980,
 -1,
 519118579,
 519013108,
 -1,
 -57614,
 519089548,
 125137,
 -1,
 519113091,
 125140,
 -1,
 519062625,
 125136,
 -1,
 519002931,
 125139,
 519446264,
 518937687,
 -1,
 -57609,
 519417228,
 125138,
 -1,
 519440771,
 125141,
 -1,
 519405627,
 125142,
 -57606,
 503557643,
 128697,
 -1,
 519672084,
 128334,
 519839643,
 503491409,
 -1,
 519905141,
 519779724,
 -1,
 519970626,
 519866592,
 -1,
 520036113,
 519944731,
 -1,
 520101639,
 520016140,
 -1,
 520167173,
 520063402,
 68033,
 520290303,
 520093696,
 -1,
 520298244,
 520182871,
 68051,
 -1,
 520227193,
 68078,
 -1,
 520273301,
 68060,
 520552447,
 520111316,
 68042,
 -1,
 520423801,
 68069,
 520625935,
 520049698,
 -1,
 520691469,
 520594672,
 68034,
 520814591,
 520617984,
 -1,
 520822540,
 520707159,
 68052,
 -1,
 520751481,
 68079,
 -1,
 520797589,
 68061,
 521076735,
 520644417,
 68043,
 -1,
 520948089,
 68070,
 521207807,
 520569700,
 68041,
 -1,
 521079161,
 68068,
 521281312,
 520007052,
 -1,
 521346841,
 521234819,
 68037,
 521412375,
 521273344,
 -1,
 521477910,
 521362519,
 68055,
 -1,
 521406841,
 68082,
 -1,
 521452949,
 68064,
 521732095,
 521389235,
 68046,
 -1,
 521603449,
 68073,
 521863167,
 521291743,
 68038,
 521871134,
 521732096,
 -1,
 521936669,
 521821271,
 68056,
 -1,
 521865593,
 68083,
 -1,
 521911701,
 68065,
 522190847,
 521847987,
 68047,
 -1,
 522062201,
 68074,
 522264369,
 521226680,
 -1,
 522329897,
 522226090,
 -1,
 522395431,
 522308293,
 68035,
 522518527,
 522321920,
 -1,
 522526502,
 522411095,
 68053,
 -1,
 522455417,
 68080,
 -1,
 522501525,
 68062,
 522780671,
 522366196,
 68044,
 -1,
 522652025,
 68071,
 522911743,
 522280145,
 -1,
 522919727,
 522833253,
 68036,
 523042815,
 522846208,
 -1,
 523050798,
 522935383,
 68054,
 -1,
 522979705,
 68081,
 -1,
 523025813,
 68063,
 523304959,
 522866463,
 68045,
 -1,
 523176313,
 68072,
 523378487,
 522225200,
 68040,
 523444022,
 523304960,
 -1,
 523509557,
 523394135,
 68058,
 -1,
 523438457,
 68085,
 -1,
 523484565,
 68067,
 -1,
 523420854,
 68076,
 523771709,
 523321909,
 68039,
 523837244,
 523698176,
 -1,
 523902779,
 523787351,
 68057,
 -1,
 523831673,
 68084,
 -1,
 523877781,
 68066,
 -1,
 523819285,
 68075,
 524222463,
 523734452,
 68032,
 524287999,
 524091392,
 -1,
 524296001,
 524180567,
 68050,
 -1,
 524224889,
 68077,
 -1,
 524270997,
 68059,
 524492643,
 519925447,
 -1,
 524558176,
 524437280,
 -1,
 524623688,
 524532251,
 -1,
 -57530,
 524585386,
 68022,
 -57529,
 524631612,
 68021,
 -1,
 524687599,
 68020,
 524885835,
 524594572,
 -1,
 -57526,
 524828220,
 68017,
 -1,
 524884207,
 68015,
 525082446,
 524845812,
 -1,
 -57523,
 525024828,
 68010,
 -1,
 525080815,
 68009,
 525279057,
 525036341,
 -1,
 -57520,
 525227064,
 68013,
 -1,
 525277423,
 68018,
 525475667,
 525211887,
 68000,
 -1,
 525443980,
 68016,
 -57516,
 525457708,
 68004,
 -57515,
 525586764,
 68005,
 -57514,
 525640059,
 68011,
 -57513,
 525705066,
 68019,
 -57512,
 525768668,
 68007,
 -57511,
 525830570,
 68003,
 -57510,
 525892373,
 68008,
 -57509,
 525954821,
 68012,
 -57508,
 526015697,
 68002,
 -57507,
 526079965,
 68014,
 -57506,
 526138940,
 68001,
 -57505,
 526202475,
 68023,
 -1,
 526263783,
 68006,
 526516223,
 524520221,
 -1,
 -57502,
 526428929,
 68030,
 -1,
 526475630,
 68031,
 526712831,
 524439117,
 -1,
 526720872,
 526629403,
 -1,
 -57498,
 526702256,
 68087,
 -57497,
 526736364,
 68088,
 -1,
 526795699,
 68095,
 526983019,
 526691724,
 -1,
 -57494,
 526936493,
 68091,
 -1,
 526993426,
 68092,
 527179630,
 526945720,
 -1,
 -57491,
 527156201,
 68086,
 -1,
 527193287,
 68029,
 527376241,
 527124920,
 -1,
 -57488,
 527340609,
 68089,
 -1,
 527395158,
 68090,
 527572852,
 527318588,
 -1,
 -57485,
 527529321,
 68028,
 -1,
 527589368,
 68093,
 -1,
 527533641,
 68094,
 527892479,
 519854078,
 -1,
 527900569,
 527791324,
 -1,
 527966077,
 527874587,
 -1,
 528031610,
 527908412,
 67994,
 -1,
 527961639,
 67995,
 528162684,
 527964399,
 67992,
 -1,
 528092711,
 67993,
 -1,
 528124330,
 67996,
 528359298,
 527926004,
 -1,
 528424832,
 528301628,
 67980,
 -1,
 528354855,
 67981,
 528613375,
 528357615,
 67978,
 -1,
 528485927,
 67979,
 528686982,
 528330124,
 -1,
 528752517,
 528619759,
 67987,
 -1,
 528682535,
 67988,
 -1,
 528694844,
 67989,
 528949128,
 528654715,
 67982,
 -1,
 528879143,
 67983,
 529080203,
 528902965,
 -1,
 -57462,
 529028152,
 67985,
 -1,
 529078511,
 67990,
 529276813,
 529016295,
 67974,
 -1,
 529206823,
 67975,
 -57458,
 529258796,
 67972,
 -57457,
 529387852,
 67973,
 -57456,
 529440618,
 67991,
 -57455,
 529504220,
 67976,
 -57454,
 529566122,
 67971,
 -57453,
 529627925,
 67977,
 -57452,
 529690373,
 67984,
 -57451,
 529751249,
 67970,
 -57450,
 529815517,
 67986,
 -57449,
 529874492,
 67969,
 -57448,
 529938027,
 67997,
 -1,
 529996015,
 67968,
 530251775,
 527874555,
 67998,
 -1,
 530124327,
 67999,
 530325509,
 519784180,
 -1,
 530391001,
 530280135,
 -1,
 530456536,
 530335520,
 -1,
 530522021,
 530416372,
 -1,
 530587553,
 530469614,
 43977,
 -1,
 530515016,
 44001,
 530718627,
 530520303,
 43973,
 -1,
 530646088,
 43999,
 -57436,
 530700588,
 43747,
 -1,
 530809681,
 43752,
 530980780,
 530496027,
 -1,
 531046313,
 530954779,
 -1,
 -57432,
 530994232,
 43749,
 -1,
 531044591,
 43748,
 531242923,
 530997429,
 43975,
 -1,
 531170376,
 44000,
 -1,
 531192554,
 43978,
 531439538,
 530920925,
 -1,
 531505072,
 531379677,
 -1,
 -57425,
 531452984,
 43751,
 -1,
 531503343,
 43750,
 -57423,
 531456181,
 43991,
 -1,
 531651306,
 43993,
 531832758,
 531410316,
 -1,
 -57420,
 531803679,
 43754,
 -57419,
 531846200,
 43753,
 -1,
 531898068,
 43969,
 532094906,
 531797870,
 -1,
 532160441,
 532027631,
 43972,
 -1,
 532087880,
 43998,
 -1,
 532108567,
 43984,
 532357054,
 532048693,
 -1,
 532422589,
 532319165,
 43968,
 -1,
 532350024,
 43995,
 -1,
 532372202,
 43976,
 532619200,
 532316355,
 43971,
 -1,
 532546632,
 43997,
 532750274,
 532574158,
 43970,
 -1,
 532677704,
 43996,
 532881349,
 532703753,
 -1,
 -57404,
 532832437,
 43990,
 -1,
 532894999,
 43987,
 533077959,
 532831441,
 43983,
 -1,
 533005384,
 44002,
 533209034,
 533024568,
 -1,
 -57399,
 533171133,
 43986,
 -1,
 533224170,
 43992,
 533405645,
 533147120,
 -1,
 -57396,
 533356725,
 43974,
 -1,
 533403887,
 43746,
 533602256,
 533341618,
 -1,
 -57393,
 533550359,
 43994,
 -1,
 533600495,
 43989,
 -57391,
 533584251,
 43980,
 -57390,
 533778786,
 43979,
 -57389,
 533841961,
 43982,
 -57388,
 533897688,
 43988,
 -57387,
 533957034,
 43745,
 -57386,
 534010952,
 43981,
 -57385,
 534068796,
 43744,
 -1,
 534127727,
 43985,
 -1,
 530434000,
 44012,
 534388718,
 530369658,
 -1,
 534454253,
 534353646,
 -1,
 534519777,
 534386927,
 -1,
 534585311,
 534452463,
 -1,
 -57378,
 534561994,
 43759,
 -1,
 534600913,
 43757,
 -57376,
 534561994,
 43758,
 -1,
 534741905,
 44005,
 534912996,
 534496458,
 -1,
 -57373,
 534889674,
 43756,
 -1,
 534938513,
 44008,
 535109607,
 534863057,
 -1,
 -57370,
 535069585,
 44004,
 -1,
 535125201,
 43755,
 -57368,
 535091685,
 44006,
 -57367,
 535285630,
 43765,
 -57366,
 535344496,
 44007,
 -57365,
 535399855,
 44003,
 -57364,
 535464224,
 44010,
 -1,
 535506544,
 44009,
 -1,
 534406829,
 43766,
 535764988,
 534329564,
 -1,
 535830514,
 535738907,
 -1,
 -57359,
 535811594,
 44018,
 -1,
 535845696,
 44019,
 536027125,
 535801228,
 -1,
 -57356,
 535980419,
 44022,
 -1,
 536037343,
 44023,
 536223736,
 535972280,
 -1,
 -57353,
 536187844,
 44020,
 -1,
 536242385,
 44021,
 -57351,
 536206321,
 44016,
 -57350,
 536382900,
 44017,
 -57349,
 536446512,
 44025,
 -1,
 536494645,
 44024,
 536682496,
 535697647,
 -1,
 -57346,
 536649386,
 44013,
 -57345,
 536708794,
 43762,
 -1,
 536761817,
 43761,
 536944643,
 536620649,
 -1,
 -57342,
 536887850,
 44011,
 -1,
 536944413,
 43760,
 -57340,
 536926029,
 43764,
 -1,
 537115071,
 43763,
 537272350,
 530266479,
 -1,
 537337868,
 537243020,
 -1,
 537403402,
 537291142,
 -1,
 -57335,
 537376271,
 128950,
 -1,
 537435247,
 128971,
 -57333,
 537361448,
 9900,
 -1,
 537534157,
 128938,
 537731089,
 537283000,
 -1,
 537796624,
 537695248,
 -1,
 -57329,
 537762622,
 128967,
 -1,
 537798927,
 128965,
 -1,
 537749826,
 128944,
 538058772,
 537711392,
 -1,
 -57325,
 538031647,
 128911,
 -1,
 538062671,
 9898,
 538255383,
 538033652,
 -1,
 -57322,
 538221374,
 128963,
 -1,
 538257679,
 128961,
 538451994,
 538198587,
 -1,
 -57319,
 538424847,
 128956,
 -1,
 538483823,
 128974,
 538648605,
 538387890,
 -1,
 -57316,
 538610780,
 128901,
 -1,
 538668859,
 9899,
 -1,
 538596220,
 128931,
 538910765,
 537248011,
 -1,
 538976300,
 538861087,
 -1,
 539041830,
 538950171,
 -1,
 539107364,
 539023013,
 -1,
 -57309,
 539071959,
 9173,
 -1,
 539126496,
 9174,
 -57307,
 539077223,
 9175,
 -1,
 539248394,
 9176,
 539435049,
 538998916,
 -1,
 -57304,
 539411613,
 9172,
 -1,
 539472296,
 9170,
 -57302,
 539406790,
 9171,
 -57301,
 539597355,
 9177,
 -1,
 539634305,
 9169,
 -1,
 538937770,
 128647,
 -57298,
 538883713,
 983172,
 -57297,
 539853058,
 128221,
 -57296,
 539916370,
 127816,
 -1,
 539960245,
 127830,
 540156367,
 503388399,
 -1,
 540221606,
 540115700,
 128104,
 540287097,
 540171836,
 -1,
 540352613,
 540243164,
 -1,
 540418107,
 540323212,
 -1,
 540483641,
 540350703,
 -1,
 -57288,
 540442236,
 68312,
 -1,
 540489784,
 68317,
 -57286,
 540455286,
 68323,
 -1,
 540629197,
 68322,
 540811327,
 540391963,
 -1,
 -57283,
 540759344,
 68309,
 -57282,
 540821248,
 68302,
 -1,
 540878172,
 68324,
 541073475,
 540743919,
 -1,
 -57279,
 541055523,
 68313,
 -57278,
 541095085,
 68288,
 -1,
 541140389,
 68314,
 541335622,
 541055791,
 -1,
 -57275,
 541283955,
 68298,
 -1,
 541336997,
 68297,
 541532233,
 541317085,
 -1,
 -57272,
 541495433,
 68319,
 -1,
 541532363,
 68305,
 541728844,
 541499211,
 -1,
 -57269,
 541692041,
 68318,
 -1,
 541743660,
 68320,
 541925455,
 541682485,
 -1,
 -57266,
 541873664,
 68306,
 -1,
 541925579,
 68304,
 542122066,
 541878793,
 -1,
 -57263,
 542070387,
 68300,
 -1,
 542123429,
 68299,
 542318676,
 542070401,
 68294,
 -1,
 542293201,
 68301,
 542449751,
 542265144,
 -1,
 -57258,
 542400818,
 68291,
 -1,
 542464199,
 68292,
 542646362,
 542389725,
 -1,
 -57255,
 542594352,
 68308,
 -1,
 542645782,
 68293,
 542842973,
 542582194,
 -1,
 -57252,
 542791577,
 68290,
 -1,
 542852864,
 68289,
 -57250,
 542825138,
 68303,
 -57249,
 543019565,
 68295,
 -57248,
 543073739,
 68321,
 -57247,
 543136109,
 68315,
 -57246,
 543197468,
 68311,
 -57245,
 543260309,
 68310,
 -57244,
 543322098,
 68307,
 -1,
 543378035,
 68316,
 543563886,
 540319423,
 -1,
 543629418,
 543504813,
 -1,
 543694953,
 543603227,
 68340,
 -1,
 543624694,
 68339,
 -1,
 543671818,
 68338,
 -57237,
 543605781,
 68341,
 -57236,
 543864603,
 68336,
 -57235,
 543913676,
 68342,
 -1,
 543968346,
 68337,
 544153717,
 543525088,
 -1,
 544219250,
 544127515,
 -1,
 -57231,
 544199327,
 68334,
 -1,
 544228196,
 68333,
 544415860,
 544181684,
 68331,
 -1,
 544342875,
 68335,
 -1,
 544361452,
 68332,
 544612472,
 544086519,
 -1,
 -57225,
 544548748,
 68326,
 -1,
 544610849,
 68325,
 -1,
 544584382,
 68296,
 544874650,
 540227239,
 -1,
 544940182,
 544830684,
 -1,
 545005711,
 544872687,
 -1,
 545071231,
 544976268,
 2126,
 -57218,
 545053487,
 2129,
 -1,
 545084450,
 2132,
 545267841,
 545045019,
 2133,
 -1,
 545241627,
 2120,
 545398915,
 545221429,
 2122,
 -1,
 545369631,
 2121,
 -57212,
 545381167,
 2118,
 -57211,
 545497345,
 2131,
 -57210,
 545562443,
 2130,
 -57209,
 545625966,
 2128,
 -57208,
 545686260,
 2125,
 -57207,
 545749695,
 2124,
 -57206,
 545812167,
 2123,
 -57205,
 545874306,
 2136,
 -57204,
 545936418,
 2116,
 -57203,
 546000696,
 2114,
 -57202,
 546059741,
 2115,
 -1,
 546121138,
 2113,
 546316434,
 544955601,
 -1,
 -57199,
 546290203,
 2119,
 -1,
 546341620,
 2127,
 -57197,
 546294753,
 2117,
 -57196,
 546466750,
 2135,
 -57195,
 546526481,
 2112,
 -1,
 546586115,
 2134,
 -57193,
 544919512,
 2138,
 -57192,
 546741939,
 2142,
 -57191,
 546787592,
 2139,
 -1,
 546839575,
 2137,
 547037347,
 544800768,
 -1,
 547102878,
 547017860,
 -1,
 -57187,
 547078992,
 128115,
 -1,
 547115935,
 128114,
 547299489,
 547053957,
 -1,
 -57184,
 547275746,
 129333,
 -1,
 547302187,
 128372,
 -57182,
 547239647,
 128378,
 -1,
 547430293,
 128107,
 -57180,
 547011613,
 128368,
 -57179,
 547597828,
 128094,
 -1,
 547627968,
 8380,
 547823909,
 540169250,
 -1,
 547889390,
 547777273,
 -1,
 547954870,
 547859852,
 -1,
 548020398,
 547907987,
 -1,
 548085933,
 547957634,
 -1,
 -57172,
 548038379,
 127006,
 -1,
 548099623,
 126988,
 -1,
 548021845,
 126997,
 548348083,
 547964917,
 -1,
 548413618,
 548285314,
 -1,
 -57167,
 548366059,
 127007,
 -1,
 548427303,
 126989,
 -1,
 548349525,
 126998,
 -57164,
 548325401,
 127015,
 -57163,
 548642346,
 127014,
 -1,
 548705473,
 126977,
 548872385,
 547928603,
 -1,
 548937916,
 548853406,
 -1,
 549003451,
 548875138,
 -1,
 -57158,
 548955883,
 127002,
 -1,
 549017127,
 126984,
 -1,
 548939349,
 126993,
 549322751,
 548887499,
 -1,
 549331136,
 549202818,
 -1,
 -57153,
 549283563,
 127003,
 -1,
 549344807,
 126985,
 -1,
 549267029,
 126994,
 549593292,
 548817336,
 -1,
 549658823,
 549557256,
 -1,
 549724358,
 549596034,
 -1,
 -57147,
 549676779,
 127004,
 -1,
 549738023,
 126986,
 -1,
 549660245,
 126995,
 550043647,
 549611806,
 -1,
 550052043,
 549923714,
 -1,
 -57142,
 550004459,
 127005,
 -1,
 550065703,
 126987,
 -1,
 549987925,
 126996,
 550314195,
 549554602,
 -1,
 550379730,
 550274172,
 -1,
 550445265,
 550316930,
 -1,
 -57136,
 550397675,
 127001,
 -1,
 550458919,
 126983,
 -1,
 550381141,
 126992,
 -1,
 550347670,
 127011,
 550772954,
 550273780,
 -1,
 550838489,
 550724275,
 -1,
 550904024,
 550775682,
 -1,
 -57129,
 550856427,
 127009,
 -1,
 550917671,
 126991,
 -1,
 550839893,
 127000,
 -1,
 550801912,
 126979,
 551231713,
 550714940,
 -1,
 551297248,
 551182319,
 -1,
 551362783,
 551234434,
 -1,
 -57122,
 551315179,
 127008,
 -1,
 551376423,
 126990,
 -1,
 551298645,
 126999,
 -1,
 551232397,
 126976,
 551690469,
 551211276,
 -1,
 -57117,
 551642377,
 127017,
 -57116,
 551704889,
 126982,
 -1,
 551765704,
 126978,
 551952616,
 551626215,
 -1,
 -57113,
 551910796,
 127012,
 -1,
 551956545,
 127019,
 -57111,
 551920822,
 126980,
 -57110,
 552115174,
 127010,
 -57109,
 552168174,
 127018,
 -57108,
 552227720,
 126981,
 -57107,
 552283904,
 127013,
 -1,
 552346900,
 127016,
 552599551,
 547822949,
 -1,
 552608033,
 552496839,
 -1,
 552673568,
 552552224,
 -1,
 552739063,
 552647195,
 -1,
 552804597,
 552712731,
 -1,
 -57100,
 552752184,
 69983,
 -1,
 552802543,
 69982,
 -57098,
 552752184,
 69988,
 -1,
 552933615,
 69987,
 553132285,
 552678877,
 -1,
 553197819,
 553072093,
 -1,
 -57094,
 553145400,
 69985,
 -1,
 553195759,
 69984,
 -57092,
 553145400,
 69990,
 -1,
 553326831,
 69989,
 553525505,
 553091828,
 -1,
 -57089,
 553507116,
 69981,
 -57088,
 553550673,
 69986,
 -1,
 553588975,
 69991,
 553787652,
 553492737,
 -1,
 -57085,
 553755003,
 70002,
 -1,
 553785583,
 69997,
 553984263,
 553752430,
 -1,
 -57082,
 553931832,
 69993,
 -1,
 553982191,
 69992,
 554180874,
 553937717,
 -1,
 -57079,
 554128440,
 69974,
 -1,
 554178799,
 69973,
 554377485,
 554134025,
 -1,
 -57076,
 554325048,
 69980,
 -1,
 554375407,
 69979,
 554574096,
 554323768,
 -1,
 -57073,
 554521656,
 69976,
 -1,
 554572015,
 69975,
 554770707,
 554511234,
 -1,
 -57070,
 554718264,
 69978,
 -1,
 554768623,
 69977,
 554967318,
 554706354,
 -1,
 -57067,
 554914872,
 69995,
 -1,
 554965231,
 69994,
 -57065,
 554945680,
 69999,
 -57064,
 555140298,
 69970,
 -57063,
 555200031,
 70000,
 -57062,
 555256234,
 69972,
 -57061,
 555318037,
 69996,
 -57060,
 555380485,
 69998,
 -57059,
 555441361,
 69969,
 -57058,
 555504696,
 70001,
 -57057,
 555564604,
 69971,
 -1,
 555620591,
 69968,
 -1,
 552624060,
 70006,
 555884836,
 552578444,
 -1,
 -57053,
 555835519,
 70003,
 -1,
 555892835,
 70005,
 -1,
 555817482,
 70004,
 556147076,
 547791105,
 -1,
 556212610,
 556084877,
 -1,
 556278098,
 556182924,
 -1,
 556343631,
 556254667,
 -1,
 556409135,
 556317211,
 -1,
 556474669,
 556379532,
 -1,
 -57044,
 556422200,
 72867,
 -1,
 556472559,
 72866,
 -57042,
 556422200,
 72859,
 -1,
 556603631,
 72858,
 556802355,
 556368628,
 -1,
 -57039,
 556783916,
 72857,
 -57038,
 556814215,
 72853,
 -1,
 556865775,
 72861,
 557064502,
 556784431,
 -1,
 -57035,
 557012024,
 72870,
 -1,
 557062383,
 72871,
 557261113,
 557034892,
 -1,
 -57032,
 557208632,
 72876,
 -1,
 557258991,
 72877,
 557457724,
 557225838,
 -1,
 -57029,
 557405240,
 72863,
 -1,
 557455599,
 72862,
 557654335,
 557411125,
 -1,
 -57026,
 557601848,
 72851,
 -1,
 557652207,
 72850,
 557850946,
 557594077,
 -1,
 -57023,
 557833023,
 72868,
 -1,
 557848815,
 72860,
 558047557,
 557788034,
 -1,
 -57020,
 557995064,
 72855,
 -1,
 558045423,
 72854,
 -57018,
 558029100,
 72873,
 -57017,
 558223692,
 72869,
 -57016,
 558276987,
 72874,
 -57015,
 558332693,
 72865,
 -57014,
 558395141,
 72875,
 -57013,
 558459431,
 72856,
 -57012,
 558519352,
 72878,
 -57011,
 558583687,
 72852,
 -57010,
 558638567,
 72864,
 -1,
 558700783,
 72879,
 558956543,
 556294253,
 -1,
 -57007,
 558836809,
 72886,
 -1,
 558899366,
 72885,
 559096186,
 556233948,
 -1,
 559161689,
 559069723,
 -1,
 559227223,
 559132044,
 -1,
 -57002,
 559174712,
 72835,
 -1,
 559225071,
 72834,
 -57000,
 559174712,
 72827,
 -1,
 559356143,
 72826,
 559554909,
 559121140,
 -1,
 -56997,
 559536428,
 72825,
 -56996,
 559566727,
 72821,
 -1,
 559618287,
 72829,
 559817056,
 559536943,
 -1,
 -56993,
 559764536,
 72838,
 -1,
 559814895,
 72839,
 560013667,
 559787404,
 -1,
 -56990,
 559961144,
 72844,
 -1,
 560011503,
 72845,
 560210278,
 559978350,
 -1,
 -56987,
 560157752,
 72831,
 -1,
 560208111,
 72830,
 560406889,
 560163637,
 -1,
 -56984,
 560354360,
 72819,
 -1,
 560404719,
 72818,
 560603500,
 560346589,
 -1,
 -56981,
 560585535,
 72836,
 -1,
 560601327,
 72828,
 560800111,
 560540546,
 -1,
 -56978,
 560747576,
 72823,
 -1,
 560797935,
 72822,
 -56976,
 560781612,
 72841,
 -56975,
 560976204,
 72837,
 -56974,
 561029499,
 72842,
 -56973,
 561085205,
 72833,
 -56972,
 561147653,
 72843,
 -56971,
 561211943,
 72824,
 -56970,
 561271864,
 72846,
 -56969,
 561336199,
 72820,
 -56968,
 561391079,
 72832,
 -56967,
 561453295,
 72847,
 -1,
 561516074,
 72840,
 561717632,
 559075480,
 -1,
 -56964,
 561693898,
 72882,
 -56963,
 561744298,
 72884,
 -56962,
 561798353,
 72881,
 -56961,
 561856060,
 72883,
 -1,
 561912221,
 72880,
 -56959,
 561675455,
 72817,
 -1,
 562058903,
 72816,
 -56957,
 556187257,
 129355,
 -1,
 562210467,
 9901,
 562373050,
 556101319,
 -1,
 562438581,
 562308487,
 -1,
 562504085,
 562394332,
 -1,
 562569617,
 562441905,
 -1,
 562635147,
 562523847,
 3453,
 562757631,
 562589383,
 3454,
 -1,
 562654919,
 3414,
 562831757,
 562594548,
 3451,
 -1,
 562791156,
 3450,
 -56946,
 562813139,
 3413,
 -56945,
 562932818,
 3452,
 -56944,
 562985663,
 3412,
 -1,
 563047221,
 3455,
 -56942,
 562545414,
 3386,
 -56941,
 563185384,
 3369,
 -56940,
 563231355,
 3406,
 -1,
 563290464,
 3423,
 563487143,
 562449997,
 -1,
 563552674,
 563449272,
 -1,
 563618202,
 563526171,
 -1,
 -56935,
 563597974,
 3419,
 -1,
 563627173,
 3420,
 563814813,
 563562936,
 -1,
 -56932,
 563778061,
 3417,
 -1,
 563830586,
 3422,
 -56930,
 563786611,
 3446,
 -56929,
 563978290,
 3443,
 -56928,
 564039249,
 3416,
 -56927,
 564090055,
 3444,
 -1,
 564150902,
 3447,
 564396031,
 563527105,
 -1,
 -56924,
 564315137,
 3421,
 -56923,
 564376445,
 3448,
 -56922,
 564437105,
 3445,
 -1,
 564478589,
 3418,
 564666795,
 563466418,
 -1,
 564732330,
 564620999,
 3426,
 -1,
 564686535,
 3427,
 -1,
 564702290,
 3396,
 564928943,
 564638351,
 -1,
 -56915,
 564893909,
 3407,
 -56914,
 564931657,
 3329,
 -1,
 564995358,
 3389,
 565191092,
 564889824,
 -1,
 565256627,
 565153208,
 -1,
 -56910,
 565230997,
 3442,
 -1,
 565271639,
 3441,
 -1,
 565230647,
 3440,
 -1,
 565131030,
 3449,
 565641215,
 562380350,
 -1,
 565649849,
 565564744,
 -1,
 -56904,
 565621386,
 9894,
 -1,
 565649254,
 9895,
 -1,
 565583683,
 9893,
 565912011,
 562347305,
 -1,
 565977536,
 565880480,
 -1,
 566043071,
 565924292,
 -1,
 -56898,
 566023138,
 10221,
 -1,
 566053952,
 10223,
 -1,
 566014689,
 10187,
 566305219,
 565932674,
 -1,
 -56894,
 566285282,
 10220,
 -1,
 566316096,
 10222,
 566501830,
 566257730,
 -1,
 -56891,
 566454793,
 120485,
 -1,
 566516945,
 120484,
 566698441,
 566438340,
 -1,
 -56888,
 566670387,
 120779,
 -1,
 566701176,
 120778,
 -56886,
 566669072,
 120001,
 -1,
 566839867,
 10189,
 567026126,
 565876590,
 -1,
 -56883,
 566981046,
 127809,
 -1,
 567019839,
 9967,
 -1,
 567007352,
 128470,
 567288652,
 540117418,
 -1,
 567354126,
 567227869,
 -1,
 567419661,
 567303377,
 -1,
 567485090,
 567364381,
 -1,
 567550625,
 567440604,
 -1,
 567616049,
 567520652,
 -1,
 567681579,
 567573475,
 -1,
 567747044,
 567654939,
 7511,
 567812577,
 567724866,
 -1,
 567878107,
 567744751,
 7492,
 -56870,
 567835106,
 7579,
 -1,
 567885372,
 7494,
 568074717,
 567835327,
 7514,
 -1,
 568003848,
 7597,
 -56866,
 568052858,
 7610,
 -56865,
 568168465,
 7500,
 -56864,
 568220881,
 7502,
 -1,
 568284194,
 7587,
 -56862,
 567775164,
 7508,
 -56861,
 568416148,
 7615,
 -1,
 568462658,
 7605,
 568664557,
 567683970,
 7580,
 568730091,
 568598735,
 -1,
 568795624,
 568679633,
 7590,
 -1,
 568724939,
 7591,
 -56855,
 568771786,
 7608,
 -56854,
 568886004,
 7600,
 -1,
 568946375,
 7595,
 -56852,
 568678369,
 7521,
 -1,
 569052031,
 7581,
 569254388,
 568618695,
 -1,
 569319923,
 569182978,
 -1,
 -56848,
 569288160,
 7593,
 -56847,
 569350205,
 7594,
 -56846,
 569409491,
 43870,
 -1,
 569468364,
 43869,
 -1,
 569270168,
 43001,
 569713145,
 569196092,
 7497,
 -56842,
 569695278,
 7614,
 -56841,
 569752785,
 7582,
 -56840,
 569815094,
 7604,
 -1,
 569869672,
 7505,
 570040830,
 569689290,
 7512,
 570106365,
 569966592,
 -1,
 -56836,
 570086595,
 43871,
 -1,
 570107506,
 7606,
 -1,
 570072684,
 7607,
 570368516,
 570011020,
 -1,
 570434050,
 570305410,
 -1,
 -56831,
 570403419,
 7586,
 -1,
 570449064,
 7498,
 -56829,
 570384086,
 7513,
 -1,
 570559604,
 7603,
 570761736,
 570303922,
 7495,
 -56826,
 570725119,
 7509,
 -56825,
 570771180,
 7517,
 -1,
 570827349,
 7601,
 571023884,
 570743599,
 7611,
 571146239,
 570952450,
 -1,
 -56821,
 571057632,
 7612,
 -1,
 571094366,
 7613,
 571286032,
 570984874,
 7506,
 571408383,
 571251147,
 -1,
 -56817,
 571312554,
 7507,
 -1,
 571358780,
 7499,
 571548180,
 571232056,
 7501,
 571670527,
 571516203,
 -1,
 -56813,
 571579082,
 7520,
 -1,
 571625483,
 7518,
 571810327,
 571487709,
 7496,
 -56810,
 571773661,
 7585,
 -1,
 571818773,
 7519,
 572006938,
 571742447,
 7491,
 -56807,
 571963874,
 7493,
 -1,
 572023170,
 7516,
 572203548,
 571985018,
 7515,
 -1,
 572132468,
 7609,
 572334622,
 572168046,
 7510,
 -1,
 572282849,
 7602,
 572465697,
 572293923,
 -1,
 -56800,
 572433888,
 7599,
 -1,
 572486367,
 7598,
 572662307,
 572422847,
 7504,
 -1,
 572591220,
 7596,
 572793382,
 572611793,
 -1,
 -56795,
 572756613,
 7589,
 -1,
 572788171,
 7588,
 -56793,
 572761642,
 7583,
 -56792,
 572943157,
 7503,
 -56791,
 573008403,
 7592,
 -56790,
 573069142,
 43868,
 -1,
 573131192,
 7584,
 573317678,
 567656819,
 -1,
 -56787,
 573274482,
 42785,
 -1,
 573331581,
 42784,
 573571071,
 573264930,
 -1,
 -56784,
 573477352,
 42890,
 -1,
 573522665,
 765,
 573710941,
 567552898,
 -1,
 573776461,
 573645007,
 -1,
 573841975,
 573743361,
 7487,
 573964287,
 573786196,
 -1,
 -56778,
 573866740,
 7483,
 -1,
 573914684,
 7474,
 574104121,
 573802922,
 7484,
 -1,
 574080202,
 7485,
 574235195,
 574051362,
 7476,
 -1,
 574164427,
 43000,
 574366269,
 574170546,
 7470,
 -1,
 574300749,
 7471,
 574497343,
 574298351,
 7468,
 -1,
 574438972,
 7469,
 -56768,
 574476556,
 7490,
 -56767,
 574606458,
 11389,
 -56766,
 574670026,
 7489,
 -56765,
 574732827,
 7488,
 -56764,
 574789486,
 7486,
 -56763,
 574849780,
 7482,
 -56762,
 574913215,
 7481,
 -56761,
 574975687,
 7480,
 -56760,
 575040309,
 7479,
 -56759,
 575105545,
 7478,
 -56758,
 575167697,
 7477,
 -56757,
 575229752,
 7475,
 -56756,
 575290940,
 7473,
 -1,
 575354333,
 7472,
 575545944,
 573724881,
 -1,
 575611475,
 575496581,
 -1,
 -56752,
 575582415,
 42754,
 -56751,
 575646968,
 42758,
 -56750,
 575709121,
 42756,
 -1,
 575773497,
 42752,
 575995903,
 575545317,
 -1,
 -56747,
 575910095,
 42755,
 -56746,
 575974648,
 42759,
 -56745,
 576036801,
 42757,
 -1,
 576101177,
 42753,
 576266844,
 575527702,
 -1,
 -56742,
 576238888,
 42653,
 -56741,
 576280113,
 42652,
 -1,
 576340836,
 7544,
 -1,
 576228515,
 42889,
 576594544,
 573667579,
 -1,
 576660079,
 576520192,
 -1,
 576725603,
 576615037,
 -1,
 576791138,
 576651508,
 767,
 -1,
 576738956,
 753,
 -1,
 576720739,
 42773,
 576987752,
 576666029,
 -1,
 577053287,
 576963276,
 -1,
 -56730,
 577028182,
 42763,
 -1,
 577074060,
 42768,
 -1,
 577033656,
 751,
 577315435,
 576956064,
 -1,
 -56726,
 577275240,
 755,
 -1,
 577327561,
 754,
 -56724,
 577292585,
 752,
 -56723,
 577486571,
 759,
 -56722,
 577529266,
 42783,
 -1,
 577581039,
 42888,
 -1,
 576603555,
 42778,
 577839745,
 576536124,
 -1,
 577905278,
 577820863,
 -1,
 577970808,
 577861887,
 -1,
 578036342,
 577911469,
 -1,
 -56715,
 578011222,
 42764,
 -1,
 578057100,
 42769,
 -56713,
 577991564,
 42774,
 -1,
 578177402,
 983981,
 578420735,
 577919045,
 -1,
 578429564,
 578304685,
 -1,
 -56709,
 578404438,
 42760,
 -1,
 578450316,
 42765,
 -56707,
 578384780,
 42770,
 -1,
 578570646,
 983980,
 578813951,
 577864685,
 -1,
 -56704,
 578713970,
 764,
 -1,
 578771069,
 762,
 578953868,
 577797945,
 -1,
 579019399,
 578894210,
 -1,
 579084934,
 578960143,
 -1,
 -56699,
 579031875,
 757,
 -1,
 579082999,
 758,
 -1,
 579031875,
 756,
 579403775,
 578945024,
 -1,
 579412619,
 579287725,
 -1,
 -56694,
 579387478,
 42762,
 -1,
 579433356,
 42767,
 -1,
 579367820,
 42772,
 579674770,
 578920942,
 -1,
 -56690,
 579651872,
 42779,
 -56689,
 579691954,
 42782,
 -56688,
 579750075,
 42781,
 -56687,
 579812428,
 42780,
 -1,
 579875160,
 760,
 580067991,
 579622981,
 -1,
 580133526,
 580008621,
 -1,
 -56683,
 580108374,
 42761,
 -1,
 580154252,
 42766,
 -1,
 580088716,
 42771,
 580395675,
 580008434,
 -1,
 -56679,
 580374087,
 42775,
 -56678,
 580432836,
 42776,
 -1,
 580475469,
 42777,
 580657822,
 580331366,
 -1,
 -56675,
 580614514,
 763,
 -1,
 580671613,
 761,
 -56673,
 580635563,
 42864,
 -56672,
 580816981,
 766,
 -1,
 580866344,
 4348,
 -1,
 567487111,
 43867,
 581173247,
 567410688,
 -1,
 581182179,
 581072092,
 -1,
 581247659,
 581160058,
 -1,
 581313194,
 581208628,
 -1,
 581378728,
 581280001,
 71174,
 -1,
 581345537,
 71175,
 581566463,
 581332679,
 71176,
 -1,
 581463751,
 71177,
 -1,
 581245167,
 71210,
 581706417,
 581220891,
 -1,
 581771951,
 581679643,
 -1,
 -56658,
 581719096,
 71193,
 -1,
 581769455,
 71192,
 -56656,
 581719096,
 71198,
 -1,
 581900527,
 71197,
 582099638,
 581665524,
 -1,
 -56653,
 582080812,
 71191,
 -56652,
 582124369,
 71196,
 -56651,
 582176647,
 71186,
 -1,
 582228207,
 71201,
 582427324,
 582039005,
 -1,
 582492858,
 582366685,
 -1,
 -56647,
 582439992,
 71195,
 -1,
 582490351,
 71194,
 -56645,
 582439992,
 71200,
 -1,
 582621423,
 71199,
 582820544,
 582359279,
 71168,
 -56642,
 582796490,
 71181,
 -56641,
 582835409,
 71179,
 -1,
 582883567,
 71169,
 583082692,
 582790540,
 -1,
 -56638,
 583052831,
 71212,
 -56637,
 583095352,
 71211,
 -1,
 583145711,
 71213,
 583344838,
 583058634,
 71172,
 -1,
 583320778,
 71173,
 583475913,
 583309166,
 -1,
 -56632,
 583423032,
 71203,
 -1,
 583473391,
 71202,
 583672524,
 583429831,
 -1,
 -56629,
 583626501,
 71215,
 -1,
 583669999,
 71209,
 583869135,
 583625525,
 -1,
 -56626,
 583816248,
 71183,
 -1,
 583866607,
 71182,
 584065746,
 583821833,
 -1,
 -56623,
 584012856,
 71190,
 -1,
 584063215,
 71189,
 584262356,
 584015057,
 71170,
 -1,
 584211665,
 71171,
 584393431,
 584208184,
 -1,
 -56618,
 584340536,
 71185,
 -1,
 584390895,
 71184,
 584590042,
 584330114,
 -1,
 -56615,
 584537144,
 71188,
 -1,
 584587503,
 71187,
 584786653,
 584525234,
 -1,
 -56612,
 584733752,
 71205,
 -1,
 584784111,
 71204,
 -56610,
 584767788,
 71207,
 -56609,
 584950139,
 71208,
 -56608,
 585009578,
 71180,
 -56607,
 585071381,
 71206,
 -56606,
 585126968,
 71214,
 -1,
 585186876,
 71178,
 585376499,
 581161112,
 -1,
 585442025,
 585355195,
 -1,
 585507559,
 585408769,
 71221,
 -1,
 585474305,
 71222,
 585695231,
 585461447,
 71223,
 -1,
 585592519,
 71224,
 585769709,
 585373935,
 -1,
 -56597,
 585745610,
 71228,
 -56596,
 585784529,
 71226,
 -1,
 585832687,
 71216,
 586031855,
 585745610,
 71219,
 -1,
 586007754,
 71220,
 586162929,
 585981137,
 71217,
 -1,
 586112209,
 71218,
 -56590,
 586123690,
 71227,
 -1,
 586235452,
 71225,
 586425092,
 585315805,
 -1,
 586490626,
 586375254,
 -1,
 586556152,
 586463771,
 -1,
 -56585,
 586536458,
 71250,
 -1,
 586570560,
 71251,
 586752763,
 586526092,
 -1,
 -56582,
 586705283,
 71254,
 -1,
 586762207,
 71255,
 586949374,
 586697144,
 -1,
 -56579,
 586912708,
 71252,
 -1,
 586967249,
 71253,
 -56577,
 586931185,
 71248,
 -56576,
 587107764,
 71249,
 -56575,
 587171376,
 71257,
 -1,
 587219509,
 71256,
 -56573,
 586453837,
 71234,
 -1,
 587341741,
 71233,
 587539212,
 586396303,
 -1,
 587604744,
 587517758,
 -1,
 -56569,
 587574998,
 71230,
 -1,
 587637415,
 71231,
 587801355,
 587536623,
 -1,
 -56566,
 587768790,
 71232,
 -1,
 587827493,
 71229,
 -1,
 587750557,
 71236,
 -1,
 587471370,
 71235,
 -1,
 567363123,
 129339,
 588194608,
 567313140,
 -1,
 588260130,
 588141260,
 -1,
 588325652,
 588233108,
 71273,
 588447743,
 588253954,
 -1,
 -56557,
 588353996,
 71274,
 -1,
 588397554,
 71275,
 588587800,
 588295149,
 71265,
 588709887,
 588516098,
 -1,
 -56553,
 588616140,
 71269,
 -1,
 588659698,
 71270,
 588849947,
 588560923,
 -1,
 -56550,
 588827483,
 71276,
 -1,
 588884480,
 71267,
 589046557,
 588801386,
 71271,
 -1,
 588975111,
 71272,
 589177632,
 588982449,
 -1,
 -56545,
 589140428,
 71264,
 -1,
 589183986,
 71268,
 -56543,
 589133050,
 6314,
 -1,
 589314866,
 71266,
 589505321,
 588220842,
 -1,
 589570856,
 589452026,
 -1,
 589636391,
 589551827,
 -1,
 -56538,
 589586818,
 9867,
 -1,
 589635553,
 9866,
 -1,
 589578143,
 119552,
 -1,
 589537756,
 128669,
 589964078,
 589449649,
 -1,
 590029613,
 589889536,
 -1,
 -56532,
 590009735,
 128184,
 -1,
 590030366,
 128176,
 -1,
 589958870,
 129297,
 590348287,
 589917428,
 128018,
 -1,
 590217948,
 128053,
 590422843,
 588170442,
 -1,
 590488376,
 590383166,
 -1,
 590553911,
 590421235,
 9968,
 590675967,
 590479360,
 -1,
 -56523,
 590586337,
 128670,
 -56522,
 590621650,
 128672,
 -1,
 590686301,
 128693,
 -1,
 590480131,
 128507,
 590947130,
 590458679,
 128001,
 -1,
 590873308,
 128045,
 -1,
 590920913,
 128068,
 591143746,
 590395931,
 -1,
 591209281,
 591106321,
 -1,
 591274816,
 591134720,
 -1,
 -56513,
 591245058,
 128757,
 -1,
 591276456,
 128741,
 -1,
 591254089,
 128739,
 -1,
 591157087,
 129334,
 591602502,
 591079556,
 128241,
 591724543,
 591527936,
 -1,
 -56507,
 591648014,
 128242,
 -1,
 591694590,
 128244,
 591864649,
 591563178,
 -1,
 -56504,
 591823632,
 127889,
 -1,
 591869418,
 128496,
 -56502,
 591845695,
 128511,
 -56501,
 592039763,
 127909,
 -1,
 592098904,
 128332,
 592258078,
 567269760,
 -1,
 592323507,
 592211655,
 -1,
 592389039,
 592267040,
 -1,
 592454510,
 592358796,
 -1,
 592520045,
 592401442,
 -1,
 592585578,
 592453408,
 -1,
 592651094,
 592544500,
 -1,
 -56492,
 592632108,
 4218,
 -56491,
 592675665,
 43491,
 -1,
 592713967,
 4220,
 592913241,
 592603957,
 -1,
 -56488,
 592860216,
 4214,
 -1,
 592910575,
 4213,
 593109852,
 592858936,
 -1,
 -56485,
 593056824,
 43488,
 -1,
 593107183,
 4215,
 593306463,
 593046402,
 -1,
 -56482,
 593253432,
 43489,
 -1,
 593303791,
 4216,
 593503074,
 593241522,
 -1,
 -56479,
 593450040,
 43492,
 -1,
 593500399,
 4223,
 -56477,
 593484607,
 4217,
 -56476,
 593673445,
 4224,
 -56475,
 593730235,
 4221,
 -56474,
 593783454,
 43490,
 -56473,
 593843256,
 4225,
 -56472,
 593906189,
 4222,
 -56471,
 593966699,
 4219,
 -1,
 594024687,
 4130,
 594280447,
 592564849,
 -1,
 -56468,
 594194539,
 43647,
 -1,
 594226715,
 43646,
 -1,
 592466027,
 4193,
 594486153,
 592407822,
 -1,
 594551668,
 594425309,
 -1,
 594617203,
 594490845,
 -1,
 -56462,
 594564152,
 43625,
 -1,
 594614511,
 43624,
 -1,
 594564152,
 43626,
 594879351,
 594526917,
 -1,
 -56458,
 594826296,
 43623,
 -1,
 594876655,
 43622,
 595075962,
 594838260,
 -1,
 -56455,
 595056940,
 43621,
 -1,
 595073263,
 43627,
 595272573,
 595028489,
 -1,
 -56452,
 595219512,
 43620,
 -1,
 595269871,
 43619,
 595469184,
 595219490,
 -1,
 -56449,
 595416120,
 43630,
 -1,
 595466479,
 43629,
 595665795,
 595405698,
 -1,
 -56446,
 595612728,
 43618,
 -1,
 595663087,
 43617,
 -56444,
 595647295,
 43634,
 -56443,
 595843072,
 43633,
 -56442,
 595897887,
 43628,
 -56441,
 595960187,
 43635,
 -56440,
 596004743,
 43616,
 -1,
 596068877,
 43631,
 596255646,
 594459375,
 -1,
 596321168,
 596194781,
 -1,
 596386702,
 596260317,
 -1,
 -56435,
 596333624,
 43502,
 -1,
 596383983,
 43501,
 -56433,
 596333624,
 43516,
 -1,
 596515055,
 43515,
 596714387,
 596280052,
 -1,
 -56430,
 596695340,
 43495,
 -1,
 596738897,
 43503,
 596910998,
 596666889,
 -1,
 -56427,
 596857912,
 43500,
 -1,
 596908271,
 43499,
 597107609,
 596856632,
 -1,
 -56424,
 597054520,
 43498,
 -1,
 597104879,
 43497,
 597304220,
 597042610,
 -1,
 -56421,
 597251128,
 43518,
 -1,
 597301487,
 43517,
 -56419,
 597260172,
 43514,
 -1,
 597445133,
 43496,
 597631909,
 596214105,
 -1,
 597697442,
 597567265,
 -1,
 -56415,
 597638716,
 4189,
 -1,
 597694703,
 4188,
 -56413,
 597657003,
 4186,
 -56412,
 597846686,
 4187,
 -1,
 597900860,
 4136,
 598090665,
 597573604,
 -1,
 -56409,
 598072107,
 4207,
 -56408,
 598116050,
 4206,
 -1,
 598168078,
 4208,
 598352812,
 598069996,
 -1,
 -56405,
 598326501,
 4197,
 -1,
 598384448,
 4198,
 -56403,
 598322460,
 4238,
 -56402,
 598496092,
 4159,
 -1,
 598547801,
 43642,
 598802431,
 592349990,
 -1,
 -56399,
 598712240,
 43637,
 -56398,
 598772207,
 43636,
 -1,
 598825343,
 43638,
 599008230,
 592293260,
 -1,
 599073744,
 598958189,
 -1,
 599139265,
 599044263,
 -1,
 599204795,
 599113833,
 -1,
 -56392,
 599135708,
 4234,
 -56391,
 599200999,
 4233,
 -56390,
 599266037,
 4232,
 -1,
 599331280,
 4231,
 599532480,
 599143250,
 -1,
 599598015,
 599507049,
 -1,
 -56386,
 599528181,
 4236,
 -1,
 599593424,
 4235,
 -1,
 599540566,
 4237,
 -1,
 599502566,
 43493,
 599925703,
 599118591,
 -1,
 -56381,
 599856359,
 4205,
 -56380,
 599921683,
 4204,
 -56379,
 599986933,
 4203,
 -56378,
 600052176,
 4202,
 -1,
 600117413,
 4201,
 600318922,
 599898874,
 -1,
 -56375,
 600249575,
 43645,
 -1,
 600314320,
 43644,
 600515533,
 600272171,
 -1,
 -56372,
 600445685,
 4251,
 -1,
 600510629,
 4250,
 -56370,
 600485165,
 4239,
 -56369,
 600676488,
 43643,
 -1,
 600711975,
 4154,
 600908766,
 599020882,
 -1,
 600974292,
 600881691,
 -1,
 -56365,
 600954378,
 4242,
 -1,
 600988480,
 4243,
 601170903,
 600944012,
 -1,
 -56362,
 601123203,
 4246,
 -1,
 601180127,
 4247,
 601367514,
 601115064,
 -1,
 -56359,
 601330628,
 4244,
 -1,
 601385169,
 4245,
 -56357,
 601349105,
 4240,
 -56356,
 601525684,
 4241,
 -56355,
 601589296,
 4249,
 -1,
 601637429,
 4248,
 601882623,
 600889969,
 -1,
 601891811,
 601759050,
 -1,
 -56351,
 601867276,
 43641,
 -56350,
 601918900,
 43640,
 -1,
 601966767,
 43639,
 602210303,
 601862311,
 -1,
 -56347,
 602115508,
 4254,
 -1,
 602163375,
 4255,
 602350589,
 598986904,
 -1,
 602416110,
 602320268,
 -1,
 602481645,
 602363213,
 -1,
 602547179,
 602422844,
 4228,
 -1,
 602472453,
 4229,
 -56340,
 602491770,
 4230,
 -1,
 602610077,
 4227,
 -1,
 602427486,
 4194,
 602874866,
 602369142,
 -1,
 -56336,
 602850506,
 4211,
 -56335,
 602901205,
 4210,
 -1,
 602947821,
 4212,
 603137013,
 602854124,
 -1,
 -56332,
 603113205,
 4200,
 -1,
 603146054,
 4199,
 603333624,
 603095385,
 -1,
 -56329,
 603294122,
 4148,
 -1,
 603349152,
 4147,
 603530234,
 603266385,
 4252,
 -1,
 603479249,
 4253,
 -56325,
 603503451,
 4139,
 -56324,
 603607262,
 4209,
 -1,
 603668033,
 4149,
 603857935,
 602323483,
 -1,
 603923468,
 603790530,
 -1,
 603988994,
 603896347,
 -1,
 -56319,
 603969034,
 43506,
 -1,
 604003136,
 43507,
 604185605,
 603958668,
 -1,
 -56316,
 604137859,
 43510,
 -1,
 604194783,
 43511,
 604382216,
 604129720,
 -1,
 -56313,
 604345284,
 43508,
 -1,
 604399825,
 43509,
 -56311,
 604363761,
 43504,
 -56310,
 604540340,
 43505,
 -56309,
 604603952,
 43513,
 -1,
 604652085,
 43512,
 604897279,
 603885050,
 -1,
 -56306,
 604794013,
 4196,
 -1,
 604853849,
 4195,
 605037595,
 603796052,
 -1,
 605103130,
 604994239,
 -1,
 605168662,
 605044947,
 -1,
 -56301,
 605149484,
 4155,
 -56300,
 605213004,
 4157,
 -56299,
 605266299,
 4156,
 -1,
 605312056,
 4158,
 605552639,
 605130059,
 -1,
 -56296,
 605455185,
 4190,
 -56295,
 605518613,
 4191,
 -1,
 605581061,
 4192,
 -1,
 605073581,
 4226,
 605880319,
 604995859,
 -1,
 -56291,
 605794492,
 43494,
 -1,
 605842710,
 43632,
 606020825,
 592207057,
 -1,
 606086347,
 605954223,
 -1,
 606151829,
 606041308,
 -1,
 606217267,
 606124571,
 -1,
 606282794,
 606178892,
 -1,
 -56284,
 606214028,
 94105,
 -56283,
 606279340,
 94104,
 -56282,
 606344668,
 94103,
 -56281,
 606409959,
 94102,
 -56280,
 606475283,
 94101,
 -56279,
 606540533,
 94100,
 -1,
 606605776,
 94099,
 606807086,
 606252428,
 -1,
 -56276,
 606776863,
 93994,
 -56275,
 606819384,
 93998,
 -1,
 606869743,
 94007,
 607069233,
 606762402,
 -1,
 -56272,
 607050028,
 93980,
 -1,
 607066351,
 93978,
 -56270,
 607042205,
 93966,
 -1,
 607197423,
 93962,
 607396928,
 606175988,
 -1,
 607462455,
 607377619,
 -1,
 -56266,
 607409208,
 93997,
 -1,
 607459567,
 93996,
 607659066,
 607421172,
 -1,
 -56263,
 607605816,
 93973,
 -1,
 607656175,
 93972,
 607855677,
 607604536,
 -1,
 -56260,
 607802424,
 93988,
 -1,
 607852783,
 93987,
 608052287,
 607787247,
 93968,
 -1,
 608022116,
 94032,
 -1,
 607999032,
 93969,
 608248908,
 607378223,
 -1,
 608314439,
 608230191,
 -1,
 608379973,
 608284044,
 -1,
 -56252,
 608360748,
 94017,
 -1,
 608377071,
 94014,
 -56250,
 608360748,
 94016,
 -1,
 608508143,
 94013,
 608707658,
 608284044,
 -1,
 -56247,
 608654392,
 94006,
 -1,
 608704751,
 94012,
 -56245,
 608654392,
 94005,
 -1,
 608835823,
 94011,
 609035351,
 608229919,
 -1,
 609100883,
 609008155,
 -1,
 609166417,
 609070476,
 -1,
 -56240,
 609113144,
 94000,
 -1,
 609163503,
 94009,
 -56238,
 609139357,
 93964,
 -1,
 609294575,
 93965,
 -56236,
 609064924,
 93954,
 -56235,
 609453778,
 93970,
 -56234,
 609512327,
 93984,
 -1,
 609566263,
 94001,
 609756256,
 609002811,
 -1,
 609821791,
 609717836,
 -1,
 -56230,
 609752972,
 94111,
 -56229,
 609818076,
 94110,
 -56228,
 609883367,
 94109,
 -56227,
 609948691,
 94108,
 -56226,
 610013648,
 94107,
 -1,
 610078885,
 94106,
 -1,
 609792107,
 94002,
 610346090,
 609695197,
 -1,
 610411621,
 610327343,
 -1,
 -56221,
 610392895,
 93995,
 -56220,
 610423864,
 93999,
 -1,
 610474223,
 94008,
 610673768,
 610366882,
 -1,
 -56217,
 610654508,
 93981,
 -1,
 610670831,
 93979,
 -56215,
 610612843,
 93967,
 -1,
 610801903,
 93963,
 611001458,
 610277615,
 -1,
 611066993,
 610968443,
 -1,
 611132527,
 611025652,
 -1,
 -56210,
 611078023,
 93989,
 -1,
 611129583,
 93971,
 -56208,
 611114162,
 94015,
 -1,
 611285781,
 93958,
 -1,
 611013666,
 94019,
 611525752,
 610954951,
 -1,
 611591286,
 611472418,
 -1,
 -56203,
 611572012,
 93977,
 -1,
 611588335,
 93976,
 -56201,
 611572012,
 93975,
 -1,
 611719407,
 93974,
 611918972,
 611495308,
 -1,
 -56198,
 611888671,
 94004,
 -56197,
 611931192,
 94003,
 -1,
 611981551,
 94010,
 612181121,
 611864376,
 -1,
 612246656,
 612127778,
 -1,
 -56193,
 612193336,
 93993,
 -1,
 612243695,
 93992,
 -1,
 612178159,
 93983,
 612508804,
 612158586,
 -1,
 -56189,
 612452877,
 93961,
 -1,
 612505839,
 93960,
 612705415,
 612474699,
 -1,
 -56186,
 612650887,
 93986,
 -1,
 612702447,
 93985,
 612902026,
 612669294,
 -1,
 -56183,
 612855557,
 93955,
 -1,
 612899055,
 93952,
 613098637,
 612858559,
 -1,
 -56180,
 613045304,
 93957,
 -1,
 613095663,
 93956,
 613295248,
 613045282,
 -1,
 -56177,
 613241912,
 94020,
 -1,
 613292271,
 93990,
 -56175,
 613275648,
 93991,
 -56174,
 613470540,
 94018,
 -56173,
 613510023,
 93982,
 -56172,
 613566989,
 93959,
 -1,
 613623271,
 93953,
 613819585,
 606130328,
 -1,
 613885087,
 613768401,
 94049,
 613950618,
 613816559,
 94050,
 614072319,
 613909236,
 94051,
 -1,
 613961528,
 94052,
 -56165,
 613926090,
 94056,
 -56164,
 614107562,
 94053,
 -56163,
 614172008,
 94057,
 -56162,
 614227153,
 94055,
 -1,
 614284860,
 94054,
 614474920,
 613816559,
 94036,
 614540450,
 614433524,
 94039,
 -1,
 614485816,
 94040,
 614671524,
 614481468,
 94067,
 -1,
 614612540,
 94068,
 -56155,
 614646986,
 94075,
 -56154,
 614751441,
 94073,
 -56153,
 614815706,
 94038,
 -1,
 614865135,
 94037,
 615064751,
 614450378,
 94058,
 615130284,
 614996207,
 94059,
 615251967,
 615088884,
 94060,
 -1,
 615141176,
 94061,
 -56147,
 615105738,
 94062,
 -56146,
 615286120,
 94064,
 -1,
 615334442,
 94063,
 615523509,
 615005756,
 94045,
 615589042,
 615489793,
 94071,
 -1,
 615555329,
 94069,
 615720116,
 615547636,
 94046,
 -1,
 615665464,
 94047,
 -1,
 615668945,
 94074,
 615916729,
 615483818,
 94041,
 -56137,
 615892170,
 94076,
 -56136,
 615942570,
 94042,
 -1,
 615991729,
 94048,
 616178875,
 615897299,
 94065,
 -1,
 616127697,
 94066,
 616309949,
 616157452,
 94044,
 -1,
 616270250,
 94043,
 616441023,
 616279091,
 94072,
 -1,
 616407297,
 94070,
 616628223,
 616399604,
 94077,
 -1,
 616517432,
 94078,
 616703174,
 613793872,
 -1,
 -56125,
 616677509,
 94096,
 -56124,
 616736582,
 94095,
 -56123,
 616769420,
 94098,
 -1,
 616831521,
 94097,
 617086975,
 616673935,
 -1,
 617096394,
 616998193,
 -1,
 -56119,
 617074697,
 94034,
 -1,
 617096059,
 94035,
 -1,
 617030523,
 94033,
 617358546,
 606024554,
 -1,
 617424079,
 617318826,
 -1,
 -56114,
 617393930,
 128300,
 -1,
 617454294,
 127908,
 617676799,
 617349120,
 -1,
 -56111,
 617581936,
 983231,
 -1,
 617625341,
 983232,
 617817302,
 617317871,
 -1,
 -56108,
 617775303,
 128469,
 -56107,
 617822534,
 128189,
 -1,
 617884455,
 128656,
 618135551,
 617770695,
 -1,
 -56104,
 618032804,
 127756,
 -1,
 618096733,
 127894,
 618276138,
 605996234,
 -1,
 618341648,
 618232326,
 -1,
 618407183,
 618274887,
 -1,
 618472718,
 618362076,
 -1,
 618538212,
 618411485,
 -1,
 618603746,
 618477021,
 -1,
 -56096,
 618550328,
 70292,
 -56095,
 618608235,
 70291,
 -1,
 618666223,
 70290,
 -56093,
 618550328,
 70297,
 -1,
 618797295,
 70296,
 618996970,
 618510875,
 -1,
 619062504,
 618969627,
 -1,
 -56089,
 619009080,
 70289,
 -1,
 619059439,
 70288,
 -56087,
 619009080,
 70295,
 -1,
 619190511,
 70294,
 619390190,
 618963201,
 -1,
 -56084,
 619356539,
 70311,
 -56083,
 619402296,
 70312,
 -1,
 619452655,
 70306,
 619652338,
 619348724,
 -1,
 -56080,
 619632940,
 70287,
 -56079,
 619676497,
 70293,
 -1,
 619714799,
 70298,
 619914485,
 619616110,
 -1,
 -56076,
 619861048,
 70300,
 -1,
 619911407,
 70299,
 620111096,
 619866933,
 -1,
 -56073,
 620057656,
 70277,
 -1,
 620108015,
 70276,
 620307707,
 620063241,
 -1,
 -56070,
 620259879,
 70285,
 -1,
 620304623,
 70284,
 620504318,
 620252984,
 -1,
 -56067,
 620450872,
 70280,
 -1,
 620501231,
 70278,
 620700929,
 620440450,
 -1,
 -56064,
 620647480,
 70283,
 -1,
 620697839,
 70282,
 620897540,
 620635570,
 -1,
 -56061,
 620844088,
 70303,
 -1,
 620894447,
 70301,
 -56059,
 620878124,
 70305,
 -56058,
 621071504,
 70308,
 -56057,
 621135050,
 70274,
 -56056,
 621194783,
 70309,
 -56055,
 621247253,
 70304,
 -56054,
 621309701,
 70307,
 -56053,
 621370577,
 70273,
 -56052,
 621433912,
 70310,
 -56051,
 621493820,
 70275,
 -1,
 621549807,
 70272,
 -1,
 618442589,
 70313,
 -1,
 618358354,
 127926,
 621936639,
 618311052,
 -1,
 621946153,
 621829663,
 -1,
 622011686,
 621915532,
 -1,
 622077221,
 621992561,
 -1,
 622142756,
 622030177,
 -1,
 622208282,
 622083644,
 -1,
 622273817,
 622157880,
 -1,
 -56040,
 622250265,
 119271,
 -1,
 622279745,
 119270,
 -1,
 622232561,
 119263,
 622535965,
 622174289,
 -1,
 -56036,
 622512409,
 119269,
 -1,
 622541889,
 119268,
 622732576,
 622479800,
 -1,
 -56033,
 622686396,
 119272,
 -1,
 622748084,
 119264,
 -56031,
 622711807,
 119266,
 -56030,
 622896264,
 119265,
 -56029,
 622941421,
 119267,
 -1,
 622996369,
 119262,
 -1,
 622101082,
 119081,
 -1,
 622015257,
 127932,
 623322408,
 621964536,
 127929,
 -1,
 623250670,
 127896,
 -1,
 623282066,
 127925,
 -1,
 621894665,
 127812,
 623584611,
 618244891,
 -1,
 623650130,
 623539420,
 -1,
 623715632,
 623622683,
 -1,
 -56018,
 623662728,
 92757,
 -56017,
 623723178,
 92766,
 -1,
 623778031,
 92736,
 623977779,
 623675818,
 92754,
 -56014,
 623937962,
 92753,
 -1,
 623996615,
 92749,
 624174391,
 623930165,
 -1,
 -56011,
 624134570,
 92761,
 -56010,
 624186496,
 92744,
 -1,
 624246614,
 92748,
 624436538,
 624140545,
 -1,
 -56007,
 624396714,
 92755,
 -1,
 624450769,
 92765,
 624633149,
 624400238,
 -1,
 -56004,
 624580577,
 92743,
 -1,
 624629999,
 92752,
 624829760,
 624591604,
 -1,
 -56001,
 624779650,
 92751,
 -1,
 624841235,
 92737,
 625026371,
 624786111,
 -1,
 -55998,
 624976152,
 92739,
 -1,
 625023870,
 92750,
 625222981,
 624979717,
 92763,
 -1,
 625181428,
 92762,
 625354056,
 625169464,
 -1,
 -55993,
 625314218,
 92745,
 -1,
 625368273,
 92764,
 625550666,
 625294908,
 92760,
 -1,
 625481967,
 92758,
 625681740,
 625489515,
 92741,
 -1,
 625630417,
 92746,
 -55987,
 625662631,
 92738,
 -55986,
 625791308,
 92759,
 -55985,
 625848676,
 92756,
 -55984,
 625880846,
 92747,
 -55983,
 625944039,
 92740,
 -1,
 626006255,
 92742,
 626262015,
 623588829,
 -1,
 626271585,
 626155606,
 -1,
 626337111,
 626244123,
 -1,
 -55978,
 626316810,
 92770,
 -1,
 626350912,
 92771,
 626533722,
 626306444,
 -1,
 -55975,
 626485635,
 92774,
 -1,
 626542559,
 92775,
 626730333,
 626477496,
 -1,
 -55972,
 626693060,
 92772,
 -1,
 626747601,
 92773,
 -55970,
 626711537,
 92768,
 -55969,
 626888116,
 92769,
 -55968,
 626951728,
 92777,
 -1,
 626999861,
 92776,
 -55966,
 626234189,
 92783,
 -1,
 627122093,
 92782,
 -55964,
 623563020,
 983173,
 -55963,
 627298547,
 983212,
 -1,
 627343901,
 983224,
 627518593,
 503344839,
 -1,
 627583165,
 627465425,
 -1,
 627648515,
 627540724,
 -1,
 627714048,
 627588668,
 -1,
 627779580,
 627646753,
 -1,
 627844856,
 627710289,
 -1,
 627910092,
 627778994,
 -1,
 627975613,
 627838872,
 -1,
 628041085,
 627904976,
 -1,
 628106610,
 627970512,
 67090,
 -55951,
 628062911,
 67092,
 -1,
 628115896,
 67091,
 628303221,
 628035749,
 67087,
 -55948,
 628259519,
 67089,
 -1,
 628312504,
 67088,
 628499831,
 628232949,
 67093,
 -1,
 628456127,
 67094,
 -55944,
 628430909,
 67100,
 -55943,
 628561804,
 67098,
 -55942,
 628627116,
 67097,
 -55941,
 628692444,
 67096,
 -55940,
 628757523,
 67095,
 -1,
 628821912,
 67086,
 629024135,
 627971303,
 -1,
 -55937,
 628955197,
 67123,
 -55936,
 629020556,
 67122,
 -55935,
 629085868,
 67121,
 -55934,
 629151196,
 67120,
 -55933,
 629216487,
 67119,
 -55932,
 629281811,
 67118,
 -55931,
 629347061,
 67117,
 -55930,
 629412005,
 67116,
 -1,
 629477272,
 67115,
 629679505,
 628952984,
 -1,
 -55927,
 629610557,
 67080,
 -55926,
 629675916,
 67079,
 -55925,
 629741228,
 67078,
 -55924,
 629806556,
 67077,
 -55923,
 629871847,
 67076,
 -55922,
 629937171,
 67075,
 -55921,
 630002421,
 67074,
 -55920,
 630067664,
 67073,
 -1,
 630132901,
 67072,
 630334874,
 629609491,
 -1,
 -55917,
 630265917,
 67114,
 -55916,
 630331276,
 67113,
 -55915,
 630396588,
 67112,
 -55914,
 630461916,
 67111,
 -55913,
 630527207,
 67110,
 -55912,
 630592531,
 67109,
 -55911,
 630657189,
 67108,
 -1,
 630722456,
 67107,
 630924706,
 630265516,
 -1,
 -55908,
 630855741,
 67136,
 -55907,
 630921100,
 67135,
 -55906,
 630986412,
 67134,
 -55905,
 631051740,
 67133,
 -55904,
 631116819,
 67132,
 -55903,
 631182069,
 67131,
 -1,
 631246744,
 67130,
 631449001,
 630855564,
 -1,
 -55900,
 631379628,
 67142,
 -55899,
 631444956,
 67141,
 -55898,
 631510247,
 67140,
 -55897,
 631574992,
 67139,
 -55896,
 631640229,
 67138,
 -1,
 631705496,
 67137,
 631907760,
 631379420,
 -1,
 -55893,
 631838781,
 67129,
 -55892,
 631903916,
 67128,
 -55891,
 631969244,
 67127,
 -55890,
 632034535,
 67126,
 -55889,
 632098981,
 67125,
 -1,
 632164248,
 67124,
 632366519,
 631837429,
 -1,
 -55886,
 632297533,
 67106,
 -55885,
 632362892,
 67105,
 -55884,
 632428204,
 67104,
 -55883,
 632493075,
 67103,
 -55882,
 632557733,
 67102,
 -1,
 632623000,
 67101,
 632881151,
 632295589,
 -1,
 -55879,
 632755884,
 67085,
 -55878,
 632821212,
 67084,
 -55877,
 632886005,
 67083,
 -55876,
 632950949,
 67082,
 -1,
 633016216,
 67081,
 633274367,
 627904677,
 -1,
 633284034,
 633147856,
 -1,
 -55872,
 633213685,
 67148,
 -55871,
 633278928,
 67147,
 -1,
 633343896,
 67145,
 633546181,
 633214860,
 -1,
 -55868,
 633477004,
 67155,
 -1,
 633540504,
 67154,
 633742792,
 633476087,
 -1,
 -55865,
 633677234,
 67150,
 -1,
 633739503,
 67149,
 -55863,
 633673947,
 67156,
 -55862,
 633870186,
 67153,
 -55861,
 633935525,
 67152,
 -1,
 633999808,
 67144,
 634201639,
 627840231,
 -1,
 634267096,
 634132364,
 -1,
 -55857,
 634198077,
 67324,
 -55856,
 634263436,
 67323,
 -55855,
 634328748,
 67322,
 -55854,
 634394076,
 67321,
 -55853,
 634459367,
 67320,
 -55852,
 634524691,
 67319,
 -55851,
 634589941,
 67318,
 -55850,
 634655184,
 67317,
 -55849,
 634720421,
 67316,
 -1,
 634785688,
 67315,
 634988003,
 634197676,
 -1,
 -55846,
 634918973,
 67314,
 -55845,
 634984332,
 67313,
 -55844,
 635049644,
 67312,
 -55843,
 635114972,
 67311,
 -55842,
 635180263,
 67310,
 -55841,
 635245587,
 67309,
 -55840,
 635310837,
 67308,
 -55839,
 635376080,
 67307,
 -55838,
 635441317,
 67306,
 -1,
 635506584,
 67305,
 635708909,
 634918119,
 -1,
 -55835,
 635639869,
 67298,
 -55834,
 635705004,
 67297,
 -55833,
 635770332,
 67296,
 -55832,
 635835623,
 67295,
 -55831,
 635900947,
 67294,
 -55830,
 635966197,
 67293,
 -55829,
 636031440,
 67292,
 -55828,
 636096677,
 67291,
 -1,
 636161944,
 67290,
 636364279,
 635638517,
 -1,
 -55825,
 636295229,
 67282,
 -55824,
 636360588,
 67281,
 -55823,
 636425900,
 67280,
 -55822,
 636491228,
 67279,
 -55821,
 636556519,
 67278,
 -55820,
 636621843,
 67277,
 -55819,
 636686800,
 67276,
 -55818,
 636752037,
 67275,
 -1,
 636817304,
 67274,
 637019649,
 636293584,
 -1,
 -55815,
 636950589,
 67273,
 -55814,
 637015948,
 67272,
 -55813,
 637081260,
 67271,
 -55812,
 637146588,
 67270,
 -55811,
 637211879,
 67269,
 -55810,
 637277203,
 67268,
 -55809,
 637342453,
 67267,
 -55808,
 637407397,
 67266,
 -1,
 637472664,
 67265,
 637675018,
 636948376,
 -1,
 -55805,
 637605949,
 67258,
 -55804,
 637671308,
 67257,
 -55803,
 637736412,
 67256,
 -55802,
 637801703,
 67255,
 -55801,
 637867027,
 67254,
 -55800,
 637932277,
 67253,
 -55799,
 637997520,
 67252,
 -1,
 638062757,
 67251,
 638264850,
 637604883,
 -1,
 -55796,
 638195773,
 67289,
 -55795,
 638261132,
 67288,
 -55794,
 638326444,
 67287,
 -55793,
 638391527,
 67286,
 -55792,
 638456272,
 67285,
 -55791,
 638521509,
 67284,
 -1,
 638586776,
 67283,
 638789145,
 638195773,
 -1,
 -55788,
 638719884,
 67330,
 -55787,
 638784988,
 67329,
 -55786,
 638850279,
 67328,
 -55785,
 638915603,
 67327,
 -55784,
 638980560,
 67326,
 -1,
 639045797,
 67325,
 639247904,
 638719452,
 -1,
 -55781,
 639178813,
 67304,
 -55780,
 639244172,
 67303,
 -55779,
 639309276,
 67302,
 -55778,
 639374567,
 67301,
 -55777,
 639439891,
 67300,
 -1,
 639505141,
 67299,
 639762431,
 639176869,
 -1,
 -55774,
 639636956,
 67264,
 -55773,
 639702247,
 67263,
 -55772,
 639767285,
 67262,
 -55771,
 639832528,
 67261,
 -55770,
 639897765,
 67260,
 -1,
 639963032,
 67259,
 640165501,
 634131189,
 -1,
 640230966,
 640094373,
 -1,
 640296493,
 640160501,
 -1,
 -55765,
 640232322,
 67173,
 -55764,
 640296370,
 67172,
 -1,
 640358639,
 67171,
 -55762,
 640227389,
 67179,
 -55761,
 640489356,
 67178,
 -55760,
 640554668,
 67177,
 -55759,
 640619996,
 67176,
 -55758,
 640685287,
 67175,
 -55757,
 640750611,
 67174,
 -55756,
 640815568,
 67170,
 -55755,
 640880805,
 67169,
 -1,
 640946072,
 67168,
 641148483,
 640159640,
 -1,
 641214011,
 641079357,
 -1,
 -55751,
 641149826,
 67167,
 -55750,
 641213874,
 67166,
 -1,
 641276143,
 67165,
 -55748,
 641144716,
 67164,
 -55747,
 641406636,
 67163,
 -55746,
 641471964,
 67162,
 -55745,
 641537255,
 67161,
 -55744,
 641602579,
 67160,
 -55743,
 641667829,
 67159,
 -55742,
 641733072,
 67158,
 -1,
 641798309,
 67157,
 642000462,
 641078748,
 -1,
 -55739,
 641931325,
 67229,
 -55738,
 641996684,
 67228,
 -55737,
 642061996,
 67227,
 -55736,
 642127324,
 67226,
 -55735,
 642192615,
 67225,
 -55734,
 642257939,
 67224,
 -55733,
 642323189,
 67223,
 -55732,
 642388432,
 67222,
 -55731,
 642453669,
 67221,
 -1,
 642518936,
 67220,
 642721369,
 641930471,
 -1,
 -55728,
 642652221,
 67219,
 -55727,
 642717580,
 67218,
 -55726,
 642782892,
 67217,
 -55725,
 642848220,
 67216,
 -55724,
 642913511,
 67215,
 -55723,
 642978835,
 67214,
 -55722,
 643044085,
 67213,
 -55721,
 643109328,
 67212,
 -55720,
 643174565,
 67211,
 -1,
 643239832,
 67210,
 643442276,
 642651155,
 -1,
 -55717,
 643373117,
 67209,
 -55716,
 643438476,
 67208,
 -55715,
 643503788,
 67207,
 -55714,
 643569116,
 67206,
 -55713,
 643634407,
 67205,
 -55712,
 643699731,
 67204,
 -55711,
 643764981,
 67203,
 -55710,
 643830224,
 67202,
 -55709,
 643895461,
 67201,
 -1,
 643960728,
 67200,
 644163183,
 643371765,
 -1,
 -55706,
 644094013,
 67199,
 -55705,
 644159372,
 67198,
 -55704,
 644224684,
 67197,
 -55703,
 644290012,
 67196,
 -55702,
 644355303,
 67195,
 -55701,
 644420627,
 67194,
 -55700,
 644485877,
 67193,
 -55699,
 644551120,
 67192,
 -55698,
 644616357,
 67191,
 -1,
 644681624,
 67190,
 644884090,
 644092368,
 -1,
 -55695,
 644814909,
 67189,
 -55694,
 644880268,
 67188,
 -55693,
 644945580,
 67187,
 -55692,
 645010908,
 67186,
 -55691,
 645076199,
 67185,
 -55690,
 645141523,
 67184,
 -55689,
 645206773,
 67183,
 -55688,
 645272016,
 67182,
 -55687,
 645337253,
 67181,
 -1,
 645402520,
 67180,
 645660671,
 644814508,
 -1,
 -55684,
 645533861,
 67231,
 -1,
 645599128,
 67230,
 645801657,
 640095708,
 -1,
 645867145,
 645730469,
 -1,
 -55680,
 645797949,
 67348,
 -55679,
 645863308,
 67347,
 -55678,
 645928620,
 67346,
 -55677,
 645993948,
 67345,
 -55676,
 646059239,
 67344,
 -55675,
 646124563,
 67343,
 -55674,
 646189813,
 67342,
 -55673,
 646255056,
 67341,
 -55672,
 646320293,
 67340,
 -1,
 646385560,
 67339,
 646588051,
 645797095,
 -1,
 -55669,
 646518845,
 67377,
 -55668,
 646584204,
 67376,
 -55667,
 646649516,
 67375,
 -55666,
 646714844,
 67374,
 -55665,
 646780135,
 67373,
 -55664,
 646845459,
 67372,
 -55663,
 646910709,
 67371,
 -55662,
 646975952,
 67370,
 -1,
 647041189,
 67369,
 647243421,
 646517200,
 -1,
 -55659,
 647174205,
 67357,
 -55658,
 647239564,
 67356,
 -55657,
 647304876,
 67355,
 -55656,
 647370204,
 67354,
 -55655,
 647435283,
 67353,
 -55654,
 647500533,
 67352,
 -55653,
 647565776,
 67351,
 -55652,
 647631013,
 67350,
 -1,
 647696280,
 67349,
 647898790,
 647173139,
 -1,
 -55649,
 647829565,
 67368,
 -55648,
 647894924,
 67367,
 -55647,
 647960028,
 67366,
 -55646,
 648025319,
 67365,
 -55645,
 648090643,
 67364,
 -55644,
 648155893,
 67363,
 -55643,
 648221136,
 67362,
 -1,
 648286104,
 67361,
 648488623,
 647827352,
 -1,
 -55640,
 648419389,
 67338,
 -55639,
 648484748,
 67337,
 -55638,
 648549852,
 67336,
 -55637,
 648614931,
 67335,
 -55636,
 648680181,
 67334,
 -55635,
 648745424,
 67333,
 -55634,
 648810661,
 67332,
 -1,
 648875928,
 67331,
 649078453,
 648418780,
 -1,
 -55631,
 649008147,
 67382,
 -55630,
 649073397,
 67381,
 -55629,
 649138640,
 67380,
 -55628,
 649203877,
 67379,
 -1,
 649269144,
 67378,
 649527295,
 649007861,
 -1,
 -55625,
 649402252,
 67360,
 -55624,
 649467564,
 67359,
 -1,
 649532435,
 67358,
 649733844,
 645732012,
 -1,
 649799370,
 649662360,
 -1,
 649864898,
 649730109,
 -1,
 649930433,
 649793058,
 -1,
 -55618,
 649860639,
 67404,
 -55617,
 649925715,
 67403,
 -55616,
 649990999,
 67402,
 -1,
 650056217,
 67401,
 -1,
 649855964,
 67400,
 -55613,
 649795531,
 67399,
 -55612,
 650254048,
 67398,
 -55611,
 650319349,
 67397,
 -55610,
 650384662,
 67396,
 -55609,
 650449970,
 67395,
 -55608,
 650515219,
 67394,
 -55607,
 650580434,
 67393,
 -1,
 650645671,
 67392,
 650847954,
 649728165,
 -1,
 -55604,
 650778296,
 67411,
 -55603,
 650843394,
 67410,
 -55602,
 650908697,
 67409,
 -55601,
 650974102,
 67408,
 -55600,
 651039410,
 67407,
 -55599,
 651104649,
 67406,
 -1,
 651169870,
 67405,
 -55597,
 650777598,
 67413,
 -1,
 651301603,
 67412,
 651503338,
 649663507,
 -1,
 651568864,
 651431832,
 -1,
 -55593,
 651499730,
 67241,
 -55592,
 651565098,
 67240,
 -55591,
 651630433,
 67239,
 -55590,
 651695768,
 67238,
 -55589,
 651761077,
 67237,
 -55588,
 651826380,
 67236,
 -55587,
 651891690,
 67235,
 -55586,
 651956927,
 67234,
 -55585,
 652022181,
 67233,
 -1,
 652087423,
 67232,
 652345343,
 651497637,
 -1,
 -55582,
 652220458,
 67250,
 -55581,
 652285793,
 67249,
 -55580,
 652351128,
 67248,
 -55579,
 652416437,
 67247,
 -55578,
 652481740,
 67246,
 -55577,
 652547050,
 67245,
 -55576,
 652612287,
 67244,
 -55575,
 652677541,
 67243,
 -1,
 652742783,
 67242,
 652945139,
 651434032,
 -1,
 -55572,
 652875436,
 67431,
 -55571,
 652940764,
 67430,
 -55570,
 653006055,
 67429,
 -55569,
 653071379,
 67428,
 -55568,
 653136629,
 67427,
 -55567,
 653201872,
 67426,
 -55566,
 653267109,
 67425,
 -1,
 653332376,
 67424,
 653534967,
 652873893,
 -1,
 -55563,
 653464570,
 67151,
 -55562,
 653529800,
 67146,
 -1,
 653594757,
 67143,
 -1,
 653463692,
 67099,
 653918207,
 627778996,
 -1,
 653928329,
 653811382,
 -1,
 653993831,
 653862322,
 -1,
 654059337,
 653922469,
 -1,
 654124816,
 653987736,
 -1,
 654190337,
 654054631,
 -1,
 -55553,
 654146294,
 65669,
 -55552,
 654199241,
 65668,
 -1,
 654246613,
 65667,
 654452484,
 654121021,
 -1,
 -55549,
 654408395,
 65677,
 -1,
 654461373,
 65676,
 654649095,
 654382988,
 -1,
 -55546,
 654604996,
 65675,
 -1,
 654658019,
 65674,
 654845706,
 654579372,
 -1,
 -55543,
 654801625,
 65673,
 -1,
 654854616,
 65672,
 655042317,
 654775772,
 -1,
 -55540,
 654998256,
 65671,
 -1,
 655051203,
 65670,
 -55538,
 654971942,
 65666,
 -55537,
 655168170,
 65665,
 -1,
 655233030,
 65664,
 655435547,
 654054876,
 -1,
 -55534,
 655366205,
 65713,
 -55533,
 655431564,
 65712,
 -55532,
 655496876,
 65711,
 -55531,
 655562204,
 65710,
 -55530,
 655627495,
 65709,
 -55529,
 655692819,
 65708,
 -55528,
 655758084,
 65707,
 -55527,
 655823339,
 65706,
 -55526,
 655888549,
 65705,
 -1,
 655953816,
 65704,
 656156453,
 655365804,
 -1,
 -55523,
 656087101,
 65722,
 -55522,
 656152460,
 65721,
 -55521,
 656217772,
 65720,
 -55520,
 656283266,
 65719,
 -55519,
 656348179,
 65718,
 -55518,
 656413564,
 65717,
 -55517,
 656478672,
 65716,
 -55516,
 656543909,
 65715,
 -1,
 656609176,
 65714,
 656811822,
 656086247,
 -1,
 -55513,
 656742463,
 65703,
 -55512,
 656807820,
 65702,
 -55511,
 656873132,
 65701,
 -55510,
 656938003,
 65699,
 -55509,
 657003253,
 65698,
 -55508,
 657068496,
 65697,
 -55507,
 657133831,
 65696,
 -1,
 657199000,
 65695,
 657401654,
 656742284,
 -1,
 -55504,
 657332285,
 65729,
 -55503,
 657396967,
 65728,
 -55502,
 657462291,
 65727,
 -55501,
 657527541,
 65726,
 -55500,
 657592784,
 65725,
 -55499,
 657658021,
 65724,
 -1,
 657723288,
 65723,
 657925948,
 657331219,
 -1,
 -55496,
 657855964,
 65694,
 -55495,
 657921450,
 65693,
 -55494,
 657986000,
 65692,
 -55493,
 658051314,
 65691,
 -1,
 658116517,
 65690,
 658319170,
 657854928,
 -1,
 -55490,
 658248967,
 65682,
 -55489,
 658314168,
 65681,
 -55488,
 658379354,
 65680,
 -55487,
 658444472,
 65679,
 -1,
 658509906,
 65678,
 658712390,
 658248437,
 -1,
 -55484,
 658641360,
 65687,
 -55483,
 658706812,
 65686,
 -1,
 658772013,
 65685,
 659030015,
 658643005,
 -1,
 -55480,
 658903294,
 65731,
 -1,
 658968472,
 65730,
 659226623,
 653988304,
 -1,
 659236692,
 659100903,
 -1,
 -55476,
 659167293,
 65757,
 -55475,
 659232652,
 65756,
 -55474,
 659297964,
 65755,
 -55473,
 659363292,
 65754,
 -55472,
 659428583,
 65753,
 -55471,
 659493919,
 65752,
 -55470,
 659559157,
 65751,
 -55469,
 659624400,
 65750,
 -1,
 659689637,
 65749,
 659892061,
 659166227,
 -1,
 -55466,
 659822653,
 65748,
 -55465,
 659888012,
 65747,
 -55464,
 659953116,
 65745,
 -55463,
 660018407,
 65744,
 -55462,
 660083673,
 65743,
 -55461,
 660148699,
 65742,
 -55460,
 660213953,
 65741,
 -1,
 660279386,
 65740,
 660481892,
 659821301,
 -1,
 -55457,
 660411868,
 65739,
 -55456,
 660476947,
 65738,
 -55455,
 660542400,
 65737,
 -55454,
 660607440,
 65736,
 -55453,
 660672683,
 65735,
 -1,
 660738114,
 65734,
 660996095,
 660410832,
 -1,
 -55450,
 660870392,
 65733,
 -1,
 660934590,
 65732,
 661192703,
 653971224,
 -1,
 661202823,
 661066192,
 -1,
 661268340,
 661131429,
 -1,
 -55445,
 661198909,
 65778,
 -55444,
 661264268,
 65777,
 -55443,
 661329580,
 65776,
 -55442,
 661394908,
 65775,
 -55441,
 661460199,
 65774,
 -55440,
 661525523,
 65773,
 -55439,
 661590773,
 65772,
 -55438,
 661656016,
 65771,
 -55437,
 661721253,
 65770,
 -1,
 661786520,
 65769,
 661989247,
 661196696,
 -1,
 -55434,
 661919805,
 65768,
 -55433,
 661985164,
 65767,
 -55432,
 662050476,
 65766,
 -55431,
 662115804,
 65765,
 -55430,
 662181095,
 65764,
 -55429,
 662246419,
 65763,
 -55428,
 662311669,
 65762,
 -55427,
 662376912,
 65761,
 -55426,
 662442149,
 65760,
 -1,
 662507416,
 65759,
 662710150,
 661918160,
 -1,
 -55423,
 662640701,
 65784,
 -55422,
 662706060,
 65783,
 -55421,
 662771372,
 65782,
 -55420,
 662836700,
 65781,
 -55419,
 662901200,
 65780,
 -1,
 662966437,
 65779,
 -1,
 662640059,
 65785,
 -55416,
 661132275,
 65786,
 -1,
 663163318,
 65758,
 663365618,
 653900199,
 -1,
 663431135,
 663320472,
 -1,
 663496597,
 663361196,
 -1,
 -55411,
 663427093,
 65572,
 -55410,
 663492335,
 65551,
 -55409,
 663557728,
 65608,
 -55408,
 663623072,
 65592,
 -55407,
 663688387,
 65597,
 -55406,
 663753591,
 65558,
 -55405,
 663818850,
 65567,
 -55404,
 663883994,
 65603,
 -1,
 663949298,
 65554,
 664151967,
 663426279,
 -1,
 -55401,
 664082609,
 65586,
 -55400,
 664148000,
 65585,
 -55399,
 664213220,
 65546,
 -55398,
 664278393,
 65565,
 -55397,
 664343725,
 65591,
 -55396,
 664409011,
 65578,
 -55395,
 664474197,
 65564,
 -55394,
 664539349,
 65545,
 -1,
 664604723,
 65570,
 664807337,
 664080848,
 -1,
 -55391,
 664737948,
 65606,
 -55390,
 664803266,
 65538,
 -55389,
 664868679,
 65577,
 -55388,
 664933990,
 65580,
 -55387,
 664999145,
 65600,
 -55386,
 665064573,
 65562,
 -55385,
 665129860,
 65560,
 -55384,
 665194834,
 65573,
 -1,
 665260150,
 65599,
 665462707,
 664735640,
 -1,
 -55381,
 665393314,
 65582,
 -55380,
 665458574,
 65536,
 -55379,
 665523901,
 65543,
 -55378,
 665589314,
 65561,
 -55377,
 665654664,
 65589,
 -55376,
 665719959,
 65587,
 -55375,
 665785246,
 65566,
 -55374,
 665850507,
 65579,
 -1,
 665915595,
 65541,
 666118076,
 665392604,
 -1,
 -55371,
 666048699,
 65590,
 -55370,
 666114074,
 65610,
 -55369,
 666179323,
 65553,
 -55368,
 666244732,
 65611,
 -55367,
 666309934,
 65550,
 -55366,
 666374784,
 65607,
 -55365,
 666439983,
 65539,
 -1,
 666505272,
 65576,
 666707909,
 666047507,
 -1,
 -55362,
 666638332,
 65605,
 -55361,
 666703375,
 65547,
 -55360,
 666768657,
 65542,
 -55359,
 666833985,
 65552,
 -55358,
 666899191,
 65601,
 -55357,
 666964645,
 65594,
 -55356,
 667029857,
 65583,
 -1,
 667095148,
 65593,
 667297742,
 666637045,
 -1,
 -55353,
 667228311,
 65568,
 -55352,
 667293596,
 65537,
 -55351,
 667359052,
 65588,
 -55350,
 667424276,
 65549,
 -55349,
 667489197,
 65609,
 -55348,
 667554438,
 65574,
 -55347,
 667619676,
 65581,
 -1,
 667684890,
 65563,
 667887575,
 667226277,
 -1,
 -55344,
 667817820,
 65596,
 -55343,
 667883099,
 65571,
 -55342,
 667948390,
 65559,
 -55341,
 668013613,
 65544,
 -55340,
 668078962,
 65557,
 -55339,
 668144278,
 65584,
 -55338,
 668209485,
 65569,
 -1,
 668274762,
 65540,
 668477404,
 667817868,
 -1,
 -55335,
 668407633,
 65612,
 -55334,
 668472563,
 65602,
 -55333,
 668537112,
 65555,
 -1,
 668602369,
 65556,
 668860415,
 668407869,
 -1,
 -55330,
 668733809,
 65613,
 -1,
 668798900,
 65604,
 669057023,
 663387514,
 -1,
 669067237,
 668931980,
 -1,
 -55326,
 668997693,
 65629,
 -55325,
 669062620,
 65628,
 -55324,
 669127413,
 65627,
 -1,
 669192656,
 65626,
 669394920,
 668997084,
 -1,
 -55321,
 669324307,
 65624,
 -1,
 669389557,
 65623,
 669591531,
 669324307,
 -1,
 -55318,
 669521981,
 65621,
 -1,
 669587116,
 65620,
 669788142,
 669520037,
 -1,
 -55315,
 669718589,
 65617,
 -1,
 669783948,
 65616,
 -55313,
 669718388,
 65625,
 -55312,
 669914572,
 65622,
 -55311,
 669979655,
 65619,
 -1,
 670044879,
 65618,
 670302207,
 663322991,
 -1,
 670312443,
 670175397,
 -1,
 670377975,
 670241525,
 -1,
 -55306,
 670307679,
 65689,
 -1,
 670372604,
 65688,
 670574586,
 670306768,
 -1,
 -55303,
 670504911,
 65684,
 -1,
 670570228,
 65683,
 -1,
 670504399,
 65700,
 -1,
 670241493,
 65746,
 670957567,
 627703808,
 -1,
 670967807,
 670874323,
 983068,
 -1,
 670894264,
 983142,
 -1,
 670911124,
 983062,
 671219711,
 627665717,
 -1,
 -55294,
 671105177,
 128391,
 -1,
 671156535,
 128279,
 671361120,
 627604159,
 -1,
 671426655,
 671296237,
 -1,
 671492142,
 671380700,
 -1,
 671557642,
 671463963,
 -1,
 -55288,
 671523195,
 6430,
 -55287,
 671568952,
 6412,
 -1,
 671619311,
 6411,
 671819790,
 671526284,
 -1,
 -55284,
 671788575,
 6426,
 -55283,
 671831096,
 6425,
 -1,
 671881455,
 6427,
 672081938,
 671764280,
 -1,
 -55280,
 672061815,
 6429,
 -55279,
 672093240,
 6404,
 -1,
 672143599,
 6403,
 672344084,
 672061740,
 6421,
 -1,
 672301812,
 6410,
 672475159,
 672307054,
 -1,
 -55274,
 672420920,
 6417,
 -1,
 672471279,
 6416,
 672671770,
 672432884,
 -1,
 -55271,
 672616327,
 6405,
 -1,
 672667887,
 6415,
 672868381,
 672623413,
 -1,
 -55268,
 672814136,
 6402,
 -1,
 672864495,
 6401,
 673064992,
 672819721,
 -1,
 -55265,
 673010744,
 6409,
 -1,
 673061103,
 6408,
 673261603,
 673002973,
 -1,
 -55262,
 673207352,
 6414,
 -1,
 673257711,
 6413,
 673458214,
 673196930,
 -1,
 -55259,
 673403960,
 6407,
 -1,
 673454319,
 6406,
 673654825,
 673392050,
 -1,
 -55256,
 673600568,
 6419,
 -1,
 673650927,
 6418,
 -55254,
 673632588,
 6424,
 -55253,
 673816955,
 6422,
 -55252,
 673872661,
 6420,
 -55251,
 673935109,
 6423,
 -1,
 673993784,
 6428,
 674179139,
 671460748,
 -1,
 674244666,
 674135054,
 -1,
 674310195,
 674202356,
 -1,
 -55246,
 674254727,
 6449,
 -1,
 674306287,
 6452,
 -55244,
 674282141,
 6451,
 -55243,
 674472315,
 6455,
 -55242,
 674535388,
 6453,
 -55241,
 674593557,
 6454,
 -55240,
 674656005,
 6456,
 -55239,
 674720647,
 6448,
 -1,
 674767014,
 6450,
 674965567,
 674193517,
 -1,
 -55236,
 674934314,
 6459,
 -55235,
 674988601,
 6457,
 -55234,
 675051673,
 6464,
 -1,
 675114176,
 6458,
 675348479,
 674940363,
 -1,
 -55231,
 675273004,
 6441,
 -55230,
 675336524,
 6443,
 -1,
 675389819,
 6442,
 675555407,
 674156624,
 -1,
 675620942,
 675481808,
 -1,
 675686472,
 675551471,
 6432,
 -55225,
 675661002,
 6438,
 -1,
 675699921,
 6436,
 675883082,
 675645866,
 6440,
 -1,
 675842474,
 6437,
 676014156,
 675823164,
 6439,
 -1,
 675954236,
 6435,
 -55219,
 675988682,
 6434,
 -1,
 676093137,
 6433,
 -1,
 675548733,
 6400,
 676341853,
 675494108,
 -1,
 676407379,
 676313627,
 -1,
 -55214,
 676386314,
 6472,
 -1,
 676420416,
 6473,
 676603990,
 676375948,
 -1,
 -55211,
 676555139,
 6476,
 -1,
 676612063,
 6477,
 676800601,
 676547000,
 -1,
 -55208,
 676762564,
 6474,
 -1,
 676817105,
 6475,
 -55206,
 676781041,
 6470,
 -55205,
 676957620,
 6471,
 -55204,
 677021232,
 6479,
 -1,
 677069365,
 6478,
 -55202,
 676307119,
 6469,
 -1,
 677202107,
 6468,
 -1,
 671377518,
 13007,
 677456032,
 671332580,
 -1,
 677521565,
 677410012,
 -1,
 677587056,
 677493275,
 -1,
 677652587,
 677547448,
 -1,
 677718122,
 677610215,
 -1,
 -55194,
 677690998,
 42232,
 -55193,
 677741393,
 42236,
 -55192,
 677800602,
 42237,
 -55191,
 677852628,
 42234,
 -1,
 677915021,
 42235,
 -1,
 677675869,
 42233,
 678176878,
 677621132,
 -1,
 -55187,
 678122552,
 42206,
 -1,
 678172911,
 42205,
 -55185,
 678122552,
 42197,
 -1,
 678303983,
 42196,
 678504563,
 677561546,
 42228,
 -55182,
 678450210,
 42230,
 -1,
 678510140,
 42229,
 678701174,
 678484783,
 -1,
 -55179,
 678646840,
 42211,
 -1,
 678697199,
 42212,
 678897785,
 678669708,
 -1,
 -55176,
 678843448,
 42219,
 -1,
 678893807,
 42210,
 679094396,
 678860654,
 -1,
 -55173,
 679040056,
 42194,
 -1,
 679090415,
 42193,
 679291006,
 679053738,
 42227,
 -1,
 679231036,
 42231,
 679422081,
 679248628,
 -1,
 -55168,
 679366535,
 42213,
 -1,
 679418095,
 42208,
 679618692,
 679373621,
 -1,
 -55165,
 679564344,
 42200,
 -1,
 679614703,
 42199,
 679815303,
 679564322,
 -1,
 -55162,
 679760952,
 42216,
 -1,
 679811311,
 42214,
 680011914,
 679759672,
 -1,
 -55159,
 679957560,
 42221,
 -1,
 680007919,
 42198,
 680208524,
 679951932,
 42224,
 -1,
 680182986,
 42225,
 680339599,
 680146397,
 -1,
 -55154,
 680319807,
 42204,
 -1,
 680335599,
 42195,
 680536210,
 680274818,
 -1,
 -55151,
 680481848,
 42203,
 -1,
 680532207,
 42202,
 680732820,
 680466671,
 42222,
 -1,
 680672828,
 42223,
 -55147,
 680712492,
 42220,
 -55146,
 680843264,
 42215,
 -55145,
 680907084,
 42218,
 -55144,
 680950549,
 42207,
 -55143,
 681012997,
 42209,
 -55142,
 681077287,
 42201,
 -55141,
 681139409,
 42226,
 -55140,
 681200141,
 42217,
 -1,
 681256423,
 42192,
 681508863,
 677486271,
 -1,
 -55137,
 681398055,
 42239,
 -1,
 681456056,
 42238,
 681650360,
 677400376,
 -1,
 681715895,
 681597972,
 -1,
 681781429,
 681639936,
 -1,
 681846954,
 681724344,
 -1,
 681912487,
 681808925,
 -1,
 -55130,
 681883419,
 128964,
 -1,
 681915829,
 11212,
 682164223,
 681863381,
 -1,
 -55127,
 682079759,
 128943,
 -1,
 682138735,
 128969,
 682305709,
 681818651,
 -1,
 -55124,
 682283645,
 128978,
 -1,
 682318804,
 128960,
 682502320,
 682274188,
 -1,
 -55121,
 682453402,
 128949,
 -1,
 682499789,
 128937,
 -55119,
 682480597,
 128910,
 -55118,
 682664412,
 128648,
 -55117,
 682709884,
 128930,
 -55116,
 682771040,
 128955,
 -1,
 682831434,
 128504,
 683081727,
 681739876,
 128498,
 -1,
 682951062,
 128497,
 -1,
 681649327,
 128626,
 683223226,
 681614953,
 128482,
 -1,
 683196075,
 128132,
 -55109,
 683203514,
 129422,
 -55108,
 683331803,
 8374,
 -1,
 683380025,
 129409,
 683551551,
 627513583,
 -1,
 683617058,
 683523980,
 -1,
 683682358,
 683584908,
 -1,
 683747875,
 683637731,
 -1,
 683813408,
 683701468,
 -1,
 683878630,
 683784731,
 -1,
 683944154,
 683853002,
 -1,
 684009689,
 683911954,
 -1,
 684075213,
 683968938,
 -1,
 684140746,
 684015164,
 7444,
 684261375,
 684067586,
 -1,
 -55095,
 684177476,
 43841,
 -1,
 684219010,
 43842,
 684402892,
 684066098,
 43843,
 -1,
 684330443,
 43844,
 -1,
 684366288,
 7432,
 684599504,
 684051589,
 -1,
 -55089,
 684544829,
 983615,
 -1,
 684595953,
 983616,
 684796114,
 684547281,
 7433,
 -1,
 684754997,
 42879,
 684927188,
 684741668,
 686,
 -1,
 684851391,
 687,
 -55083,
 684902220,
 43857,
 -55082,
 685023550,
 11385,
 -55081,
 685076167,
 42881,
 -55080,
 685133624,
 7543,
 -1,
 685185903,
 7426,
 -1,
 683965119,
 42871,
 685451486,
 683889698,
 -1,
 685517021,
 685412796,
 42853,
 -1,
 685443470,
 42855,
 -1,
 685444535,
 7546,
 685713634,
 685378306,
 -1,
 -55072,
 685670355,
 7541,
 -55071,
 685717649,
 11366,
 -1,
 685782366,
 566,
 -55069,
 685693743,
 42793,
 -55068,
 685942224,
 42795,
 -55067,
 686002108,
 7446,
 -1,
 686038240,
 11383,
 686237953,
 683847052,
 -1,
 686303470,
 686186189,
 -1,
 686369003,
 686262698,
 7441,
 -55062,
 686332399,
 7442,
 -1,
 686362059,
 7443,
 -55060,
 686343370,
 7453,
 -55059,
 686539676,
 7455,
 -1,
 686569569,
 7454,
 686762231,
 686238594,
 -1,
 686827763,
 686729813,
 -1,
 686893298,
 686792961,
 43851,
 -1,
 686820743,
 43852,
 -1,
 686837588,
 43830,
 687144959,
 686775468,
 -1,
 -55051,
 687056352,
 7573,
 -55050,
 687100733,
 983617,
 -1,
 687151857,
 983618,
 687352061,
 686689026,
 -1,
 -55047,
 687328891,
 983575,
 -55046,
 687389056,
 575,
 -55045,
 687446077,
 7562,
 -55044,
 687507983,
 42921,
 -1,
 687570899,
 7540,
 687745280,
 687282415,
 -1,
 -55041,
 687700545,
 42892,
 -1,
 687762689,
 43872,
 -1,
 687718349,
 43845,
 688007453,
 686177852,
 -1,
 688072980,
 687934210,
 -1,
 688138503,
 688049787,
 983555,
 688259071,
 688062535,
 -1,
 -55034,
 688149309,
 983557,
 -1,
 688200433,
 983559,
 688400650,
 688098102,
 -1,
 -55031,
 688373483,
 983585,
 -1,
 688397041,
 983583,
 688597261,
 688339457,
 -1,
 -55028,
 688570091,
 983589,
 -1,
 688593649,
 983587,
 688793872,
 688533505,
 -1,
 -55025,
 688749374,
 983561,
 -1,
 688794819,
 983563,
 -55023,
 688764996,
 583,
 -55022,
 688956896,
 7570,
 -55021,
 689014655,
 11384,
 -1,
 689065144,
 43828,
 689252631,
 688042065,
 -1,
 -55018,
 689219040,
 7576,
 -1,
 689281085,
 7563,
 689449242,
 689198099,
 -1,
 -55015,
 689402450,
 42787,
 -1,
 689463682,
 42789,
 -55013,
 689429553,
 7578,
 -55012,
 689617435,
 42859,
 -1,
 689669526,
 43836,
 689842487,
 687955153,
 -1,
 689908009,
 689799924,
 -1,
 689973542,
 689879342,
 -1,
 -55007,
 689945115,
 42887,
 -55006,
 690007436,
 42885,
 -55005,
 690069761,
 42883,
 -55004,
 690114360,
 7545,
 -55003,
 690178488,
 42876,
 -1,
 690238941,
 42874,
 690487295,
 689950262,
 -1,
 -55000,
 690391765,
 43840,
 -1,
 690429597,
 43876,
 690628915,
 689834754,
 -1,
 690694446,
 690567681,
 -1,
 -54996,
 690667243,
 983591,
 -54995,
 690705213,
 983590,
 -1,
 690756337,
 983566,
 690956593,
 690654018,
 -1,
 -54992,
 690929387,
 983595,
 -1,
 690952945,
 983593,
 -54990,
 690922976,
 7574,
 -1,
 691108689,
 983565,
 691284278,
 690590295,
 -1,
 -54987,
 691232562,
 43873,
 -1,
 691280237,
 7548,
 -1,
 691252620,
 42861,
 691546442,
 689816778,
 -1,
 691611973,
 691470336,
 -1,
 691677508,
 691590276,
 -1,
 691743038,
 691632965,
 -1,
 -54980,
 691715819,
 983611,
 -54979,
 691753789,
 983577,
 -1,
 691804913,
 983609,
 692005185,
 691702582,
 -1,
 -54976,
 691977963,
 983607,
 -1,
 692001521,
 983605,
 -54974,
 691974614,
 43854,
 -54973,
 692168160,
 7577,
 -1,
 692220639,
 43858,
 -1,
 691611291,
 43855,
 -54970,
 691576435,
 7551,
 -54969,
 692423082,
 43875,
 -54968,
 692484799,
 42872,
 -54967,
 692542673,
 43856,
 -1,
 692600380,
 7531,
 692791645,
 691511553,
 -1,
 692857175,
 692715520,
 -1,
 692922710,
 692835455,
 -1,
 692988245,
 692846592,
 -1,
 -54961,
 692961003,
 983603,
 -54960,
 693024836,
 589,
 -54959,
 693082173,
 7561,
 -54958,
 693144079,
 42919,
 -54957,
 693206995,
 7538,
 -54956,
 693259208,
 7539,
 -1,
 693318669,
 43849,
 -1,
 692950149,
 43847,
 -1,
 692890661,
 42843,
 693643611,
 692799572,
 -1,
 693709146,
 693578626,
 8580,
 -1,
 693636039,
 42815,
 -1,
 693669912,
 7572,
 693960703,
 693618637,
 42869,
 -1,
 693831807,
 42845,
 694036850,
 692750762,
 -1,
 694102375,
 694000075,
 -1,
 694167910,
 694061482,
 -1,
 694233445,
 694094594,
 -1,
 -54942,
 694204484,
 43839,
 -54941,
 694265312,
 7575,
 -54940,
 694309693,
 983613,
 -1,
 694360817,
 983614,
 -1,
 694173244,
 43874,
 -1,
 694107931,
 7571,
 694692208,
 694029058,
 -1,
 694757740,
 694668923,
 983569,
 694878207,
 694681671,
 -1,
 -54933,
 694768445,
 983571,
 -1,
 694819569,
 983573,
 695074815,
 694712359,
 -1,
 -54930,
 694997295,
 11386,
 -54929,
 695046073,
 42829,
 -1,
 695108996,
 42827,
 -54927,
 694651306,
 42831,
 -1,
 695238263,
 42935,
 695413124,
 693967087,
 -1,
 695478652,
 695336960,
 -1,
 695544187,
 695456900,
 -1,
 695609720,
 695503670,
 -1,
 -54921,
 695582443,
 983581,
 -1,
 695606001,
 983579,
 -54919,
 695580740,
 11365,
 -54918,
 695772640,
 7567,
 -1,
 695827281,
 983553,
 -1,
 695510586,
 43825,
 696068478,
 695454842,
 42809,
 -1,
 695995519,
 42811,
 -54913,
 696047827,
 42813,
 -54912,
 696173770,
 42807,
 -54911,
 696224170,
 42805,
 -54910,
 696285671,
 7568,
 -54909,
 696336123,
 983612,
 -1,
 696391919,
 42803,
 696592789,
 695365319,
 -1,
 696658320,
 696519426,
 -1,
 696723849,
 696597263,
 -1,
 -54904,
 696680403,
 43832,
 -1,
 696723058,
 11361,
 -54902,
 696696555,
 983599,
 -54901,
 696886767,
 42894,
 -54900,
 696948797,
 7557,
 -54899,
 697008001,
 43833,
 -54898,
 697066956,
 43831,
 -54897,
 697129073,
 42825,
 -1,
 697185630,
 564,
 697379219,
 696618654,
 -1,
 -54894,
 697325681,
 7837,
 -1,
 697383057,
 7836,
 -54892,
 697354189,
 42866,
 -1,
 697517125,
 43829,
 697706918,
 696526258,
 -1,
 697772442,
 697659241,
 -1,
 697837977,
 697731498,
 43837,
 -1,
 697765323,
 43838,
 -1,
 697777724,
 43826,
 698034591,
 697702639,
 -1,
 698100126,
 698002521,
 -1,
 -54883,
 698039868,
 43827,
 -1,
 698097309,
 43824,
 -1,
 698068879,
 43853,
 698362275,
 697961218,
 -1,
 -54879,
 698325053,
 7552,
 -54878,
 698384339,
 7532,
 -1,
 698436792,
 42903,
 -54876,
 698329945,
 42823,
 -54875,
 698585855,
 7447,
 -1,
 698631916,
 42933,
 698821043,
 697683066,
 -1,
 698886572,
 698747650,
 -1,
 -54871,
 698853279,
 11377,
 -54870,
 698914877,
 7564,
 -54869,
 698955921,
 42847,
 -1,
 699020638,
 11380,
 699214256,
 698846230,
 -1,
 -54866,
 699188981,
 42911,
 -54865,
 699239125,
 42909,
 -1,
 699276143,
 42907,
 -54863,
 699193555,
 42849,
 -54862,
 699426698,
 42851,
 -1,
 699483120,
 42857,
 699673024,
 698758621,
 -1,
 699738553,
 699599618,
 -1,
 -54858,
 699701309,
 7553,
 -54857,
 699760595,
 7533,
 -54856,
 699816438,
 7569,
 -1,
 699872606,
 545,
 700066237,
 699697578,
 -1,
 700131772,
 700040751,
 43848,
 -1,
 700058476,
 43850,
 -1,
 700104700,
 567,
 -54850,
 700041165,
 42865,
 -54849,
 700269333,
 7839,
 -1,
 700327351,
 568,
 700525004,
 699607938,
 -1,
 700590533,
 700471265,
 43859,
 700710911,
 700517655,
 -1,
 -54844,
 700622823,
 43860,
 -1,
 700674845,
 43861,
 700852681,
 700517122,
 -1,
 -54841,
 700823620,
 572,
 -54840,
 700880957,
 42900,
 -1,
 700917362,
 42899,
 701114827,
 700827048,
 42797,
 -1,
 701041504,
 42799,
 -1,
 701074738,
 42863,
 701311447,
 700482292,
 -1,
 701376981,
 701238018,
 -1,
 701442513,
 701311874,
 -1,
 -54832,
 701418291,
 565,
 -1,
 701475809,
 43835,
 -54830,
 701405245,
 7559,
 -54829,
 701598223,
 42917,
 -54828,
 701661139,
 7536,
 -1,
 701708240,
 42897,
 -54826,
 701351885,
 42868,
 -1,
 701845352,
 983567,
 702032353,
 701266623,
 -1,
 702097885,
 701958914,
 -1,
 -54822,
 702070507,
 983601,
 -54821,
 702126141,
 7558,
 -54820,
 702185427,
 7535,
 -1,
 702231565,
 43834,
 702425568,
 702045854,
 -1,
 -54817,
 702401658,
 7933,
 -1,
 702445427,
 7931,
 -1,
 702400461,
 42867,
 702687721,
 701994937,
 -1,
 702753254,
 702655884,
 -1,
 702818789,
 702726785,
 7549,
 -1,
 702744974,
 42833,
 -1,
 702783732,
 42837,
 -54809,
 702715965,
 7560,
 -54808,
 702971859,
 7537,
 -1,
 703024312,
 42835,
 703212017,
 702638945,
 -1,
 703277548,
 703182916,
 42817,
 -1,
 703201384,
 42821,
 703408623,
 703215069,
 -1,
 -54802,
 703356273,
 42819,
 -1,
 703415960,
 11370,
 -54800,
 703371325,
 7556,
 -1,
 703564303,
 42915,
 703736314,
 703157282,
 -1,
 703801845,
 703696735,
 -1,
 -54796,
 703746877,
 983619,
 -1,
 703798001,
 983620,
 703998456,
 703728386,
 -1,
 -54793,
 703961149,
 42901,
 -1,
 704002000,
 11368,
 -54791,
 703939638,
 42791,
 -1,
 704126510,
 11382,
 704326146,
 703715316,
 -1,
 704391681,
 704280615,
 -1,
 704457216,
 704349560,
 43863,
 704577535,
 704380928,
 -1,
 -54785,
 704501036,
 43865,
 -1,
 704520019,
 43864,
 -1,
 704434466,
 43862,
 -1,
 704354365,
 7565,
 704850439,
 704305969,
 -1,
 -54780,
 704821632,
 576,
 -54779,
 704878653,
 7566,
 -54778,
 704937939,
 7542,
 -1,
 704985040,
 11372,
 705178125,
 704814923,
 -1,
 705243660,
 705104642,
 -1,
 -54774,
 705214589,
 42839,
 -54773,
 705255940,
 587,
 -1,
 705312913,
 42841,
 -1,
 705206131,
 569,
 705571347,
 705122104,
 -1,
 705636881,
 705497858,
 -1,
 -54768,
 705599549,
 7555,
 -1,
 705661455,
 42913,
 -54766,
 705591530,
 578,
 -1,
 705778744,
 983199,
 705964568,
 705550624,
 -1,
 706030103,
 705932684,
 -1,
 -54762,
 706003585,
 591,
 -1,
 706042566,
 43866,
 -1,
 705984685,
 7935,
 706292252,
 705907177,
 -1,
 -54758,
 706263108,
 42905,
 -54757,
 706320445,
 7554,
 -1,
 706379731,
 7534,
 706554399,
 706243083,
 -1,
 -54754,
 706525252,
 585,
 -1,
 706558480,
 983597,
 -1,
 706531645,
 11379,
 706871295,
 683748498,
 -1,
 -54750,
 706790691,
 7550,
 -1,
 706829621,
 7547,
 707067903,
 683722361,
 -1,
 707078694,
 706981260,
 8347,
 -1,
 707014425,
 8340,
 -54745,
 707057629,
 8339,
 -54744,
 707185786,
 7525,
 -54743,
 707249354,
 7524,
 -54742,
 707312155,
 8348,
 -54741,
 707371265,
 7523,
 -54740,
 707434350,
 8346,
 -54739,
 707496362,
 8338,
 -54738,
 707560180,
 8345,
 -54737,
 707623615,
 8344,
 -54736,
 707686087,
 8343,
 -54735,
 707750709,
 8342,
 -54734,
 707815945,
 11388,
 -54733,
 707878097,
 7522,
 -54732,
 707941410,
 8341,
 -54731,
 708001340,
 8337,
 -1,
 708057327,
 8336,
 708258546,
 683617426,
 -1,
 708323910,
 708229659,
 -1,
 708389441,
 708299586,
 -1,
 708454971,
 708319471,
 11375,
 -1,
 708409826,
 11376,
 -54724,
 708430970,
 581,
 -54723,
 708557339,
 42929,
 -54722,
 708603591,
 42880,
 -54721,
 708668213,
 42928,
 -54720,
 708732159,
 42878,
 -1,
 708793378,
 42893,
 708979267,
 708336295,
 42852,
 -1,
 708905358,
 42854,
 -54716,
 708959023,
 42792,
 -54715,
 709076432,
 42794,
 -1,
 709102513,
 574,
 709306970,
 708263484,
 -1,
 709372502,
 709233410,
 -1,
 709438028,
 709348987,
 983554,
 709558271,
 709361735,
 -1,
 -54709,
 709448509,
 983556,
 -1,
 709499633,
 983558,
 709700175,
 709397302,
 -1,
 -54706,
 709672683,
 983584,
 -1,
 709696241,
 983582,
 709896786,
 709638657,
 -1,
 -54703,
 709869291,
 983588,
 -1,
 709892849,
 983586,
 710093397,
 709832705,
 -1,
 -54700,
 710048574,
 983560,
 -1,
 710094019,
 983562,
 -1,
 710064196,
 582,
 710355545,
 709317651,
 -1,
 -54696,
 710308434,
 42786,
 -1,
 710369666,
 42788,
 -1,
 710326811,
 42858,
 710617704,
 709236975,
 -1,
 710683233,
 710544130,
 -1,
 710748767,
 710642486,
 -1,
 -54690,
 710721259,
 983580,
 -1,
 710744817,
 983578,
 -54688,
 710719556,
 570,
 -1,
 710900561,
 983552,
 711076451,
 710659194,
 42808,
 -1,
 711003263,
 42810,
 -54684,
 711055571,
 42812,
 -54683,
 711181514,
 42806,
 -54682,
 711231914,
 42804,
 -54681,
 711293410,
 11373,
 -1,
 711334127,
 42802,
 711535222,
 710565073,
 -1,
 711600752,
 711493677,
 -1,
 -54677,
 711571995,
 42886,
 -54676,
 711634316,
 42884,
 -54675,
 711696641,
 42882,
 -54674,
 711741240,
 42877,
 -54673,
 711805368,
 42875,
 -1,
 711865821,
 42873,
 712059509,
 711527170,
 -1,
 712125044,
 712018742,
 -1,
 -54669,
 712097515,
 983594,
 -1,
 712121073,
 983592,
 -1,
 712080209,
 983564,
 -1,
 712027532,
 42860,
 712452737,
 711503244,
 -1,
 712518267,
 712379138,
 -1,
 -54663,
 712494715,
 983574,
 -54662,
 712554880,
 11390,
 -1,
 712608271,
 42920,
 712780414,
 712473571,
 -1,
 -54659,
 712744789,
 586,
 -1,
 712780936,
 42926,
 -54657,
 712726075,
 7838,
 -54656,
 712913862,
 42924,
 -1,
 712974021,
 42891,
 713173646,
 712417537,
 -1,
 713239178,
 713097216,
 -1,
 713304713,
 713217156,
 -1,
 713370247,
 713275931,
 -1,
 -54650,
 713318609,
 983602,
 -1,
 713366738,
 11364,
 -54648,
 713340996,
 588,
 -1,
 713525775,
 42918,
 -1,
 713272357,
 42842,
 713763469,
 713181268,
 -1,
 -54644,
 713723921,
 42923,
 -1,
 713763743,
 42814,
 -1,
 713738200,
 42844,
 714025623,
 713149562,
 -1,
 714091155,
 713985046,
 -1,
 -54639,
 714065653,
 42910,
 -54638,
 714115797,
 42908,
 -1,
 714152815,
 42906,
 -54636,
 714070227,
 42848,
 -54635,
 714303370,
 42850,
 -54634,
 714359792,
 42856,
 -1,
 714410929,
 42846,
 714615458,
 713984426,
 -1,
 714680992,
 714541826,
 -1,
 714746525,
 714657403,
 983568,
 714866687,
 714670151,
 -1,
 -54628,
 714756925,
 983570,
 -1,
 714808049,
 983572,
 715063295,
 714700839,
 -1,
 -54625,
 714969017,
 42828,
 -1,
 715031940,
 42826,
 -54623,
 714639786,
 42830,
 -1,
 715161207,
 42934,
 715336364,
 714589388,
 -1,
 715401899,
 715314308,
 -1,
 715467432,
 715356997,
 -1,
 -54618,
 715439851,
 983610,
 -54617,
 715477821,
 983576,
 -1,
 715528945,
 983608,
 715784191,
 715426614,
 -1,
 -54614,
 715701995,
 983606,
 -1,
 715725553,
 983604,
 -1,
 715335282,
 580,
 715991732,
 715288293,
 -1,
 716057264,
 715924914,
 -1,
 -54609,
 715997969,
 42925,
 -1,
 716054814,
 573,
 -54607,
 716029675,
 983598,
 -54606,
 716210131,
 11362,
 -54605,
 716265585,
 42824,
 -1,
 716323623,
 11360,
 716516028,
 715926402,
 -1,
 716581559,
 716490152,
 42796,
 -1,
 716508000,
 42798,
 716712634,
 716507906,
 -1,
 -54599,
 716683332,
 571,
 -1,
 716711538,
 42898,
 -54597,
 716672306,
 42862,
 -1,
 716855265,
 42931,
 717040323,
 716467041,
 -1,
 717105855,
 717011012,
 42816,
 -1,
 717029480,
 42820,
 717236930,
 717043165,
 -1,
 -54591,
 717184369,
 42818,
 -1,
 717244056,
 11369,
 -1,
 717195791,
 42914,
 717499081,
 717002681,
 -1,
 717564616,
 717467020,
 -1,
 717630151,
 717537921,
 11363,
 -1,
 717556110,
 42832,
 -1,
 717594868,
 42836,
 -1,
 717507768,
 42834,
 717892304,
 717454015,
 -1,
 717957837,
 717840030,
 -1,
 -54580,
 717933690,
 7932,
 -1,
 717977459,
 7930,
 718209023,
 717884162,
 -1,
 -54577,
 718126827,
 983600,
 -1,
 718166513,
 11374,
 718351062,
 717837346,
 -1,
 718416596,
 718277378,
 -1,
 -54573,
 718363121,
 42922,
 -1,
 718419920,
 11367,
 -54571,
 718357558,
 42790,
 -1,
 718544430,
 11381,
 718744284,
 718284210,
 -1,
 718809818,
 718670594,
 -1,
 -54567,
 718780484,
 579,
 -1,
 718818488,
 42902,
 -54565,
 718777177,
 42822,
 -1,
 718948076,
 42932,
 719137504,
 718694923,
 -1,
 -54562,
 719109867,
 983596,
 -54561,
 719173700,
 584,
 -1,
 719205389,
 42930,
 719399652,
 719081272,
 -1,
 -54558,
 719354090,
 577,
 -54557,
 719410232,
 983198,
 -1,
 719457570,
 42912,
 719661799,
 719379249,
 -1,
 -54554,
 719632768,
 11391,
 -1,
 719665104,
 11371,
 719858410,
 719640864,
 -1,
 -54551,
 719829060,
 590,
 -1,
 719878317,
 7934,
 720055021,
 719822669,
 -1,
 -54548,
 720025725,
 42838,
 -1,
 720058513,
 42840,
 720251632,
 720012067,
 -1,
 -54545,
 720210447,
 42916,
 -1,
 720254928,
 42896,
 -54543,
 720228669,
 11378,
 -1,
 720390641,
 42904,
 720579353,
 708211932,
 -1,
 720644887,
 720547212,
 -1,
 720710422,
 720600057,
 -1,
 720775930,
 720681499,
 7451,
 720895999,
 720751426,
 -1,
 -54536,
 720806145,
 7450,
 -54535,
 720861887,
 43002,
 -1,
 720911932,
 11387,
 721103616,
 720740609,
 -1,
 721169150,
 721045588,
 -1,
 -54531,
 721133825,
 7449,
 -1,
 721191668,
 7438,
 -54529,
 721143757,
 42870,
 -1,
 721292663,
 43846,
 721496835,
 721062314,
 7439,
 -54526,
 721470666,
 7445,
 -1,
 721525231,
 7440,
 721693446,
 721436220,
 7431,
 -54523,
 721673262,
 7459,
 -1,
 721730769,
 7430,
 721890056,
 721623279,
 7424,
 -1,
 721829436,
 7425,
 -54519,
 721869615,
 7458,
 -54518,
 721998092,
 7457,
 -54517,
 722062458,
 7456,
 -54516,
 722126026,
 7452,
 -54515,
 722185612,
 42801,
 -54514,
 722245486,
 7448,
 -54513,
 722303679,
 7437,
 -54512,
 722366189,
 7436,
 -54511,
 722430773,
 7435,
 -54510,
 722496009,
 7434,
 -54509,
 722553272,
 42800,
 -54508,
 722613725,
 7429,
 -54507,
 722676610,
 7428,
 -1,
 722740927,
 7427,
 -1,
 720659619,
 42895,
 -54504,
 720621552,
 7460,
 -1,
 722935027,
 7461,
 723189759,
 720520515,
 -1,
 723200797,
 723101216,
 -1,
 -54500,
 723162990,
 43004,
 -1,
 723208632,
 43003,
 723397408,
 723147985,
 -1,
 -54497,
 723355976,
 43005,
 -1,
 723387457,
 43006,
 -54495,
 723366499,
 42999,
 -1,
 723525995,
 43007,
 723725105,
 683581697,
 -1,
 723790640,
 723669184,
 -1,
 723856169,
 723749290,
 -1,
 723921704,
 723813468,
 -1,
 -54489,
 723888557,
 68415,
 -1,
 723925581,
 68413,
 -1,
 723886786,
 128310,
 724183852,
 723829776,
 -1,
 -54485,
 724150744,
 68414,
 -1,
 724187791,
 68412,
 724380463,
 724117882,
 -1,
 -54482,
 724318369,
 128311,
 -1,
 724381519,
 128309,
 -1,
 724346027,
 128308,
 -1,
 723737852,
 8382,
 724708154,
 723683776,
 -1,
 724773685,
 724659539,
 -1,
 -54476,
 724732320,
 3807,
 -1,
 724783804,
 3806,
 724970296,
 724716772,
 -1,
 -54473,
 724929842,
 983204,
 -1,
 724968819,
 983205,
 -54471,
 724937496,
 983206,
 -1,
 725121063,
 983207,
 725297981,
 724678382,
 -1,
 -54468,
 725275802,
 127772,
 -1,
 725334488,
 127767,
 -54466,
 725237285,
 128030,
 -1,
 725428104,
 127991,
 725625893,
 683490876,
 -1,
 725691323,
 725569241,
 -1,
 725756819,
 725668263,
 -1,
 725822310,
 725727771,
 -1,
 725887832,
 725788349,
 -1,
 725953367,
 725814922,
 -1,
 726018901,
 725885563,
 11104,
 726138879,
 725942272,
 -1,
 726149971,
 726062212,
 -1,
 726215499,
 726104207,
 -1,
 -54454,
 726190698,
 11172,
 -1,
 726220006,
 11174,
 726412110,
 726153999,
 -1,
 -54451,
 726388383,
 983233,
 -1,
 726424194,
 11130,
 -54449,
 726388450,
 129072,
 -54448,
 726565785,
 129056,
 -54447,
 726629911,
 129060,
 -54446,
 726685432,
 129068,
 -1,
 726739419,
 129064,
 -54444,
 726122515,
 11120,
 -1,
 726898187,
 11136,
 -54442,
 725981222,
 11140,
 -1,
 727004937,
 11114,
 -1,
 725877037,
 129168,
 727264101,
 725866194,
 -1,
 727329636,
 727196289,
 -1,
 727395171,
 727307396,
 -1,
 727460705,
 727366171,
 -1,
 727526240,
 727391442,
 11067,
 727646207,
 727452418,
 -1,
 -54433,
 727568031,
 11068,
 -1,
 727596074,
 11069,
 -1,
 727492293,
 11244,
 -54430,
 727436959,
 11060,
 -1,
 727792682,
 11061,
 -1,
 727338629,
 11062,
 -1,
 727302767,
 11063,
 -1,
 727224273,
 129186,
 728181629,
 725754497,
 -1,
 728247159,
 728159364,
 -1,
 728312687,
 728218139,
 -1,
 728378220,
 728262222,
 -1,
 -54421,
 728353386,
 11025,
 -1,
 728382694,
 11024,
 728629247,
 728308950,
 -1,
 -54418,
 728551071,
 11065,
 -1,
 728579114,
 11066,
 728771442,
 728282064,
 -1,
 -54415,
 728744344,
 129024,
 -1,
 728778092,
 129040,
 -54413,
 728729477,
 129176,
 -54412,
 728923698,
 129028,
 -54411,
 728985703,
 129032,
 -54410,
 729040236,
 129044,
 -1,
 729103073,
 11064,
 729295740,
 728177191,
 -1,
 729361275,
 729261575,
 -1,
 -54406,
 729333489,
 11083,
 -1,
 729357943,
 11074,
 -1,
 729292407,
 11082,
 -1,
 729267754,
 11070,
 729688963,
 728114610,
 -1,
 729754497,
 729640757,
 -1,
 -54400,
 729690045,
 11144,
 -1,
 729752187,
 11013,
 -54398,
 729715493,
 129184,
 -1,
 729881241,
 129192,
 730082182,
 729656716,
 -1,
 -54395,
 730046501,
 129080,
 -1,
 730079331,
 129104,
 730278793,
 730046721,
 -1,
 -54392,
 730237543,
 128620,
 -1,
 730292246,
 129190,
 730475404,
 730224352,
 -1,
 -54389,
 730411522,
 129088,
 -1,
 730473083,
 129092,
 730672015,
 730417592,
 -1,
 -54386,
 730639262,
 129194,
 -1,
 730686462,
 129076,
 -54384,
 730649408,
 129172,
 -54383,
 730832850,
 11077,
 -54382,
 730887028,
 129188,
 -1,
 730935810,
 129084,
 731130802,
 725680128,
 -1,
 731196315,
 731095297,
 -1,
 731261850,
 731144153,
 -1,
 -54377,
 731239207,
 11012,
 -54376,
 731300318,
 11108,
 -54375,
 731360961,
 129112,
 -1,
 731392235,
 11020,
 -1,
 731192620,
 11788,
 731655072,
 731164044,
 -1,
 -54371,
 731629200,
 11778,
 -54370,
 731683222,
 128488,
 -54369,
 731733728,
 11814,
 -1,
 731778854,
 10181,
 731982757,
 731584751,
 -1,
 732048292,
 731950204,
 -1,
 -54365,
 732017702,
 11056,
 -1,
 732049298,
 11058,
 -1,
 732005834,
 128494,
 732310440,
 731953691,
 -1,
 -54361,
 732275428,
 11785,
 -1,
 732322542,
 128492,
 732507051,
 732262087,
 -1,
 -54358,
 732481323,
 128709,
 -1,
 732534443,
 11804,
 732703662,
 732445101,
 -1,
 -54355,
 732677662,
 11816,
 -1,
 732742354,
 11780,
 -54353,
 732682159,
 128398,
 -54352,
 732876372,
 11808,
 -54351,
 732910969,
 128379,
 -1,
 732967107,
 9948,
 733216767,
 731057698,
 -1,
 733227960,
 733104672,
 -1,
 733293494,
 733198708,
 4054,
 -1,
 733219810,
 4056,
 -54345,
 733236194,
 129307,
 -1,
 733356588,
 1422,
 -54343,
 733200426,
 8294,
 -54342,
 733519057,
 128269,
 -1,
 733566386,
 9958,
 733752352,
 725653863,
 -1,
 733817842,
 733705436,
 -1,
 733883334,
 733788699,
 -1,
 733948865,
 733854235,
 -1,
 -54336,
 733893688,
 7246,
 -1,
 733944047,
 7245,
 734145476,
 733916556,
 -1,
 -54333,
 734090296,
 7192,
 -1,
 734140655,
 7191,
 -54331,
 734090296,
 7179,
 -1,
 734271727,
 7178,
 734473162,
 733845358,
 -1,
 -54328,
 734424837,
 7183,
 -54327,
 734483512,
 7184,
 -1,
 734533871,
 7182,
 734735310,
 734429940,
 -1,
 -54324,
 734714156,
 7177,
 -54323,
 734744455,
 7173,
 -1,
 734796015,
 7181,
 734997458,
 734686005,
 -1,
 -54320,
 734949125,
 7169,
 -54319,
 735007800,
 7170,
 -1,
 735058159,
 7168,
 735259606,
 734934493,
 -1,
 -54316,
 735238975,
 7193,
 -54315,
 735262315,
 7247,
 -1,
 735320303,
 7180,
 735521753,
 735227276,
 -1,
 -54312,
 735466552,
 7201,
 -1,
 735516911,
 7200,
 735718364,
 735476415,
 -1,
 -54309,
 735670021,
 7190,
 -1,
 735713519,
 7189,
 735914975,
 735663138,
 -1,
 -54306,
 735866629,
 7198,
 -1,
 735910127,
 7197,
 736111586,
 735858488,
 -1,
 -54303,
 736063237,
 7172,
 -1,
 736106735,
 7171,
 736308197,
 736053688,
 -1,
 -54300,
 736259845,
 7186,
 -1,
 736303343,
 7185,
 736504808,
 736242562,
 -1,
 -54297,
 736449592,
 7175,
 -1,
 736499951,
 7174,
 736701419,
 736437682,
 -1,
 -54294,
 736653061,
 7188,
 -1,
 736696559,
 7187,
 -54292,
 736680236,
 7194,
 -54291,
 736874828,
 7202,
 -54290,
 736939152,
 7199,
 -54289,
 736993659,
 7195,
 -54288,
 737046277,
 7196,
 -54287,
 737110567,
 7176,
 -1,
 737155311,
 7203,
 737356800,
 733755612,
 -1,
 737422326,
 737327643,
 -1,
 -54283,
 737400330,
 7234,
 -1,
 737434432,
 7235,
 737618937,
 737389964,
 -1,
 -54280,
 737569155,
 7238,
 -1,
 737626079,
 7239,
 737815548,
 737561016,
 -1,
 -54277,
 737776580,
 7236,
 -1,
 737831121,
 7237,
 -54275,
 737795057,
 7232,
 -54274,
 737971636,
 7233,
 -54273,
 738035248,
 7241,
 -1,
 738083381,
 7240,
 738274314,
 737292884,
 -1,
 738339843,
 738231028,
 7216,
 -1,
 738318887,
 7220,
 738470917,
 738290485,
 7213,
 -1,
 738402273,
 7221,
 -54266,
 738441755,
 7219,
 -54265,
 738566401,
 7218,
 -54264,
 738629486,
 7217,
 -54263,
 738687679,
 7214,
 -1,
 738750151,
 7215,
 738929682,
 738250904,
 -1,
 738995213,
 738903242,
 7210,
 -1,
 738968778,
 7211,
 739126287,
 738953642,
 7208,
 -1,
 739084714,
 7209,
 -54256,
 739073233,
 7207,
 -54255,
 739196476,
 7212,
 -1,
 739252637,
 7206,
 739453977,
 738893503,
 -1,
 739519511,
 739424795,
 -1,
 739585046,
 739488162,
 7231,
 -1,
 739508701,
 7230,
 -1,
 739514758,
 7227,
 -54248,
 739477886,
 7228,
 -1,
 739716564,
 7229,
 739966975,
 739421580,
 -1,
 739978269,
 739886539,
 -1,
 -54244,
 739957036,
 7204,
 -1,
 740008315,
 7205,
 740229119,
 739926125,
 -1,
 -54241,
 740139692,
 7222,
 -1,
 740198614,
 7223,
 -54239,
 733728171,
 127898,
 -54238,
 740331495,
 128006,
 -54237,
 740393301,
 127819,
 -54236,
 740440094,
 128210,
 -1,
 740498411,
 127811,
 740699234,
 725604563,
 -1,
 740764740,
 740634398,
 -1,
 740830250,
 740735515,
 66199,
 -54231,
 740801051,
 66200,
 -1,
 740840482,
 66185,
 741026860,
 740786932,
 66191,
 -1,
 740983540,
 66193,
 741157934,
 740981439,
 66190,
 -1,
 741112511,
 66192,
 741289008,
 741108533,
 66187,
 -1,
 741239605,
 66196,
 741420082,
 741228092,
 66177,
 -1,
 741376756,
 66202,
 741551156,
 741352882,
 66178,
 -1,
 741495842,
 66179,
 741682230,
 741480687,
 66176,
 -1,
 741638900,
 66201,
 -54217,
 741661487,
 66184,
 -54216,
 741791709,
 66204,
 -54215,
 741855500,
 66183,
 -54214,
 741917898,
 66194,
 -54213,
 741977484,
 66198,
 -54212,
 742039809,
 66197,
 -54211,
 742104907,
 66188,
 -54210,
 742168430,
 66195,
 -54209,
 742223559,
 66189,
 -54208,
 742287881,
 66186,
 -54207,
 742350033,
 66182,
 -54206,
 742413346,
 66203,
 -54205,
 742477624,
 66180,
 -1,
 742536669,
 66181,
 742730849,
 740702386,
 -1,
 742796384,
 742683868,
 -1,
 742861896,
 742767131,
 67887,
 -1,
 742832667,
 67892,
 742992970,
 742829452,
 67891,
 -1,
 742960524,
 67886,
 743124044,
 742949620,
 67883,
 -1,
 743080692,
 67896,
 743255118,
 743075527,
 67881,
 -1,
 743233747,
 67895,
 743386192,
 743194172,
 67876,
 -1,
 743342836,
 67894,
 743517266,
 743315695,
 67872,
 -1,
 743473908,
 67893,
 -54189,
 743495891,
 67879,
 -54188,
 743623802,
 67877,
 -54187,
 743687370,
 67888,
 -54186,
 743743745,
 67885,
 -54185,
 743808843,
 67890,
 -54184,
 743868842,
 67884,
 -54183,
 743930559,
 67882,
 -54182,
 743992117,
 67880,
 -54181,
 744053969,
 67878,
 -54180,
 744116024,
 67874,
 -54179,
 744180152,
 67889,
 -54178,
 744240605,
 67875,
 -54177,
 744303490,
 67897,
 -1,
 744367538,
 67873,
 -1,
 742769174,
 67903,
 -1,
 742679328,
 129317,
 744696955,
 740657578,
 -1,
 744762478,
 744673548,
 -1,
 744828013,
 744703365,
 -1,
 744893548,
 744780418,
 -1,
 744959081,
 744855406,
 -1,
 -54168,
 744899548,
 128393,
 -1,
 744955127,
 128396,
 -54166,
 744902003,
 128395,
 -54165,
 745091957,
 128397,
 -1,
 745154119,
 128394,
 -1,
 744859667,
 128318,
 -1,
 744751491,
 128261,
 745483379,
 744697921,
 128274,
 745548914,
 745432033,
 -1,
 -54159,
 745528305,
 983079,
 -1,
 745573812,
 983076,
 -1,
 745475296,
 128271,
 745811062,
 745459048,
 -1,
 -54155,
 745764053,
 128140,
 -1,
 745822948,
 127977,
 746007673,
 745768299,
 -1,
 -54152,
 745960544,
 11059,
 -1,
 746010997,
 10188,
 -54150,
 745981668,
 128557,
 -1,
 746158046,
 127853,
 746335360,
 744661249,
 -1,
 -54147,
 746293674,
 983221,
 -54146,
 746355391,
 983216,
 -54145,
 746413265,
 983226,
 -1,
 746470972,
 983218,
 -1,
 746277304,
 983065,
 746730267,
 627448047,
 -1,
 746794776,
 746685172,
 -1,
 746860297,
 746726517,
 -1,
 746925315,
 746786981,
 -1,
 746990747,
 746852248,
 -1,
 747056266,
 746919596,
 83070,
 -54136,
 746990466,
 83073,
 -54135,
 747054514,
 83072,
 -1,
 747116783,
 83071,
 747318414,
 746984467,
 83062,
 -54132,
 747252610,
 83065,
 -54131,
 747316658,
 83064,
 -1,
 747378927,
 83063,
 747580561,
 747246823,
 83066,
 -54128,
 747513266,
 83068,
 -1,
 747575535,
 83067,
 747777171,
 747508176,
 83059,
 -1,
 747706607,
 83060,
 747908245,
 747704485,
 83057,
 -1,
 747837679,
 83058,
 748039319,
 747835288,
 83055,
 -1,
 747968751,
 83056,
 -54120,
 747968573,
 83075,
 -54119,
 748099468,
 83074,
 -54118,
 748164572,
 83069,
 -1,
 748229365,
 83061,
 748432553,
 746918053,
 -1,
 748498079,
 748359576,
 83076,
 -54114,
 748430770,
 83078,
 -1,
 748493039,
 83077,
 748694689,
 748426471,
 83083,
 -1,
 748624111,
 83084,
 -54110,
 748623933,
 83088,
 -54109,
 748754828,
 83087,
 -54108,
 748820140,
 83086,
 -54107,
 748885468,
 83085,
 -54106,
 748950547,
 83082,
 -54105,
 749015797,
 83081,
 -54104,
 749081040,
 83080,
 -1,
 749146277,
 83079,
 749350069,
 748360437,
 -1,
 749415596,
 749278439,
 83105,
 -1,
 749345007,
 83106,
 -54099,
 749344829,
 83110,
 -54098,
 749475724,
 83109,
 -54097,
 749541036,
 83108,
 -54096,
 749606364,
 83107,
 -54095,
 749671443,
 83104,
 -54094,
 749736693,
 83103,
 -54093,
 749801936,
 83102,
 -54092,
 749867173,
 83101,
 -1,
 749932440,
 83100,
 750136513,
 749277648,
 -1,
 750202040,
 750064871,
 83094,
 -1,
 750131439,
 83095,
 -54087,
 750131261,
 83099,
 -54086,
 750262156,
 83098,
 -54085,
 750327468,
 83097,
 -54084,
 750392796,
 83096,
 -54083,
 750457875,
 83093,
 -54082,
 750523125,
 83092,
 -54081,
 750588368,
 83091,
 -54080,
 750653605,
 83090,
 -1,
 750718872,
 83089,
 750922956,
 750065725,
 -1,
 -54077,
 750852157,
 83170,
 -54076,
 750917516,
 83169,
 -54075,
 750982828,
 83168,
 -54074,
 751048156,
 83167,
 -54073,
 751113447,
 83166,
 -54072,
 751178771,
 83165,
 -54071,
 751244021,
 83164,
 -54070,
 751309264,
 83163,
 -54069,
 751374501,
 83162,
 -1,
 751439768,
 83161,
 751643863,
 750851980,
 -1,
 -54066,
 751573053,
 83160,
 -54065,
 751638412,
 83159,
 -54064,
 751703724,
 83158,
 -54063,
 751769052,
 83157,
 -54062,
 751834343,
 83156,
 -54061,
 751899667,
 83155,
 -54060,
 751964917,
 83154,
 -54059,
 752030160,
 83153,
 -54058,
 752095397,
 83152,
 -1,
 752160664,
 83151,
 752364770,
 751572652,
 -1,
 -54055,
 752293949,
 83150,
 -54054,
 752359308,
 83149,
 -54053,
 752424620,
 83148,
 -54052,
 752489948,
 83147,
 -54051,
 752555239,
 83146,
 -54050,
 752620563,
 83145,
 -54049,
 752685813,
 83144,
 -54048,
 752751056,
 83143,
 -54047,
 752816293,
 83142,
 -1,
 752881560,
 83141,
 753085677,
 752293340,
 -1,
 -54044,
 753014845,
 83140,
 -54043,
 753080204,
 83139,
 -54042,
 753145516,
 83138,
 -54041,
 753210844,
 83137,
 -54040,
 753276135,
 83136,
 -54039,
 753341459,
 83135,
 -54038,
 753406709,
 83134,
 -54037,
 753471952,
 83133,
 -54036,
 753537189,
 83132,
 -1,
 753602456,
 83131,
 753806584,
 753013991,
 -1,
 -54033,
 753735741,
 83130,
 -54032,
 753801100,
 83129,
 -54031,
 753866412,
 83128,
 -54030,
 753931740,
 83127,
 -54029,
 753997031,
 83126,
 -54028,
 754062355,
 83125,
 -54027,
 754127605,
 83124,
 -54026,
 754192848,
 83123,
 -54025,
 754258085,
 83122,
 -1,
 754323352,
 83121,
 754581503,
 753734675,
 -1,
 -54022,
 754456637,
 83120,
 -54021,
 754521996,
 83119,
 -54020,
 754587308,
 83118,
 -54019,
 754652636,
 83117,
 -54018,
 754717927,
 83116,
 -54017,
 754783251,
 83115,
 -54016,
 754848501,
 83114,
 -54015,
 754913744,
 83113,
 -54014,
 754978981,
 83112,
 -1,
 755044248,
 83111,
 755248514,
 746853109,
 -1,
 755313941,
 755176181,
 -1,
 755379465,
 755242460,
 83322,
 -54009,
 755313538,
 83325,
 -54008,
 755377586,
 83324,
 -1,
 755439855,
 83323,
 755641613,
 755306960,
 -1,
 -54005,
 755575682,
 83318,
 -54004,
 755639730,
 83317,
 -1,
 755701999,
 83316,
 -54002,
 755570749,
 83328,
 -54001,
 755832716,
 83327,
 -54000,
 755898028,
 83326,
 -53999,
 755963111,
 83321,
 -53998,
 756028435,
 83320,
 -53997,
 756093685,
 83319,
 -53996,
 756158629,
 83315,
 -1,
 756223896,
 83314,
 756428068,
 755242892,
 -1,
 756493592,
 756356572,
 83381,
 -1,
 756422895,
 83382,
 756624667,
 756421365,
 -1,
 -53990,
 756553967,
 83378,
 -1,
 756615249,
 83377,
 756821277,
 756551845,
 83374,
 -1,
 756750575,
 83375,
 -53986,
 756750397,
 83385,
 -53985,
 756881292,
 83384,
 -53984,
 756946604,
 83383,
 -53983,
 757011687,
 83380,
 -53982,
 757077011,
 83379,
 -53981,
 757141968,
 83376,
 -1,
 757206936,
 83373,
 757411121,
 756356572,
 -1,
 757476647,
 757340044,
 83359,
 -1,
 757405935,
 83360,
 757607721,
 757404691,
 83354,
 -1,
 757537007,
 83355,
 -53974,
 757536829,
 83361,
 -53973,
 757667500,
 83358,
 -53972,
 757732828,
 83357,
 -53971,
 757798119,
 83356,
 -53970,
 757863157,
 83353,
 -53969,
 757928400,
 83352,
 -53968,
 757993637,
 83351,
 -1,
 758058904,
 83350,
 758263101,
 757339820,
 -1,
 758328628,
 758190245,
 83363,
 -1,
 758257903,
 83364,
 -53963,
 758257725,
 83372,
 -53962,
 758388620,
 83371,
 -53961,
 758453932,
 83370,
 -53960,
 758519260,
 83369,
 -53959,
 758584551,
 83368,
 -53958,
 758649875,
 83367,
 -53957,
 758715125,
 83366,
 -53956,
 758780368,
 83365,
 -1,
 758845336,
 83362,
 759049545,
 758191335,
 -1,
 759115072,
 758978621,
 83348,
 -1,
 759044335,
 83349,
 -53951,
 759043980,
 83347,
 -53950,
 759174828,
 83346,
 -53949,
 759240156,
 83345,
 -53948,
 759305447,
 83344,
 -53947,
 759370771,
 83343,
 -53946,
 759436021,
 83342,
 -53945,
 759501264,
 83341,
 -53944,
 759566501,
 83340,
 -1,
 759631768,
 83339,
 759835989,
 758976976,
 -1,
 759901516,
 759765053,
 83312,
 -1,
 759830767,
 83313,
 -53939,
 759830412,
 83311,
 -53938,
 759961260,
 83310,
 -53937,
 760026588,
 83309,
 -53936,
 760091879,
 83308,
 -53935,
 760157203,
 83307,
 -53934,
 760222453,
 83306,
 -53933,
 760287696,
 83305,
 -53932,
 760352933,
 83304,
 -1,
 760418200,
 83303,
 760622433,
 759762840,
 -1,
 760687960,
 760551485,
 83291,
 -1,
 760617199,
 83292,
 -53927,
 760616844,
 83290,
 -53926,
 760747692,
 83289,
 -53925,
 760813020,
 83288,
 -53924,
 760878311,
 83287,
 -53923,
 760943635,
 83286,
 -53922,
 761008885,
 83285,
 -53921,
 761074128,
 83284,
 -53920,
 761139365,
 83283,
 -1,
 761204632,
 83282,
 761408876,
 760551485,
 -1,
 -53917,
 761337917,
 83395,
 -53916,
 761403276,
 83394,
 -53915,
 761468588,
 83393,
 -53914,
 761533916,
 83392,
 -53913,
 761599207,
 83391,
 -53912,
 761664531,
 83390,
 -53911,
 761729820,
 83389,
 -53910,
 761795024,
 83388,
 -53909,
 761860261,
 83387,
 -1,
 761925528,
 83386,
 762129783,
 761336851,
 -1,
 -53906,
 762058813,
 83338,
 -53905,
 762124172,
 83337,
 -53904,
 762189484,
 83336,
 -53903,
 762254812,
 83335,
 -53902,
 762320103,
 83334,
 -53901,
 762385427,
 83333,
 -53900,
 762450677,
 83332,
 -53899,
 762515920,
 83331,
 -53898,
 762581157,
 83330,
 -1,
 762646424,
 83329,
 762904575,
 762056869,
 -1,
 -53895,
 762779709,
 83302,
 -53894,
 762845068,
 83301,
 -53893,
 762910380,
 83300,
 -53892,
 762975708,
 83299,
 -53891,
 763040999,
 83298,
 -53890,
 763106323,
 83297,
 -53889,
 763171573,
 83296,
 -53888,
 763236816,
 83295,
 -53887,
 763302053,
 83294,
 -1,
 763367320,
 83293,
 763571708,
 755175888,
 -1,
 763637138,
 763498392,
 -1,
 763702663,
 763564496,
 83173,
 -53882,
 763635122,
 83175,
 -1,
 763697391,
 83174,
 763899273,
 763631677,
 83183,
 -1,
 763828463,
 83184,
 764030347,
 763827884,
 83180,
 -1,
 763959535,
 83181,
 -53876,
 763959180,
 83182,
 -53875,
 764089820,
 83179,
 -53874,
 764155111,
 83178,
 -53873,
 764220435,
 83177,
 -53872,
 764285685,
 83176,
 -53871,
 764350629,
 83172,
 -1,
 764415896,
 83171,
 764620191,
 763566141,
 -1,
 764685717,
 764549181,
 83280,
 -1,
 764614895,
 83281,
 764816791,
 764613651,
 83274,
 -1,
 764745967,
 83275,
 -53864,
 764745612,
 83279,
 -53863,
 764876460,
 83278,
 -53862,
 764941788,
 83277,
 -53861,
 765007079,
 83276,
 -53860,
 765072117,
 83273,
 -53859,
 765137360,
 83272,
 -53858,
 765202597,
 83271,
 -1,
 765267864,
 83270,
 765472172,
 764547237,
 -1,
 765537698,
 765400540,
 83192,
 -1,
 765466863,
 83193,
 765668772,
 765465831,
 83190,
 -1,
 765597935,
 83191,
 -53851,
 765597757,
 83196,
 -53850,
 765728652,
 83195,
 -53849,
 765793964,
 83194,
 -53848,
 765858835,
 83189,
 -53847,
 765924085,
 83188,
 -53846,
 765989328,
 83187,
 -53845,
 766054565,
 83186,
 -1,
 766119832,
 83185,
 766324152,
 765400972,
 -1,
 766389679,
 766253117,
 83268,
 -1,
 766318831,
 83269,
 -53840,
 766318476,
 83267,
 -53839,
 766449324,
 83266,
 -53838,
 766514652,
 83265,
 -53837,
 766579943,
 83264,
 -53836,
 766645267,
 83263,
 -53835,
 766710517,
 83262,
 -53834,
 766775760,
 83261,
 -53833,
 766840997,
 83260,
 -1,
 766906264,
 83259,
 767110596,
 766252508,
 -1,
 767176123,
 767039148,
 83245,
 -1,
 767105263,
 83246,
 -53828,
 767105085,
 83248,
 -53827,
 767235980,
 83247,
 -53826,
 767301084,
 83244,
 -53825,
 767366375,
 83243,
 -53824,
 767431699,
 83242,
 -53823,
 767496949,
 83241,
 -53822,
 767562192,
 83240,
 -53821,
 767627429,
 83239,
 -1,
 767692696,
 83238,
 767897040,
 767037904,
 -1,
 767962567,
 767825580,
 83204,
 -1,
 767891695,
 83205,
 -53816,
 767891517,
 83207,
 -53815,
 768022412,
 83206,
 -53814,
 768087516,
 83203,
 -53813,
 768152807,
 83202,
 -53812,
 768218131,
 83201,
 -53811,
 768283381,
 83200,
 -53810,
 768348624,
 83199,
 -53809,
 768413861,
 83198,
 -1,
 768479128,
 83197,
 768683483,
 767825580,
 -1,
 -53806,
 768612413,
 83258,
 -53805,
 768677772,
 83257,
 -53804,
 768743084,
 83256,
 -53803,
 768808412,
 83255,
 -53802,
 768873703,
 83254,
 -53801,
 768939027,
 83253,
 -53800,
 769004277,
 83252,
 -53799,
 769069520,
 83251,
 -53798,
 769134757,
 83250,
 -1,
 769200024,
 83249,
 769404390,
 768611559,
 -1,
 -53795,
 769333309,
 83237,
 -53794,
 769398668,
 83236,
 -53793,
 769463980,
 83235,
 -53792,
 769529308,
 83234,
 -53791,
 769594599,
 83233,
 -53790,
 769659923,
 83232,
 -53789,
 769725173,
 83231,
 -53788,
 769790416,
 83230,
 -53787,
 769855653,
 83229,
 -1,
 769920920,
 83228,
 770125297,
 769332243,
 -1,
 -53784,
 770054205,
 83227,
 -53783,
 770119564,
 83226,
 -53782,
 770184876,
 83225,
 -53781,
 770250204,
 83224,
 -53780,
 770315495,
 83223,
 -53779,
 770380819,
 83222,
 -53778,
 770446069,
 83221,
 -53777,
 770511312,
 83220,
 -53776,
 770576549,
 83219,
 -1,
 770641816,
 83218,
 770899967,
 770052853,
 -1,
 -53773,
 770775101,
 83217,
 -53772,
 770840460,
 83216,
 -53771,
 770905772,
 83215,
 -53770,
 770971100,
 83214,
 -53769,
 771036391,
 83213,
 -53768,
 771101715,
 83212,
 -53767,
 771166965,
 83211,
 -53766,
 771232208,
 83210,
 -53765,
 771297445,
 83209,
 -1,
 771362712,
 83208,
 771567222,
 763498392,
 -1,
 771632652,
 771494931,
 -1,
 771698177,
 771560924,
 82994,
 -53760,
 771630514,
 82996,
 -1,
 771692783,
 82995,
 771894787,
 771626215,
 82992,
 -1,
 771823855,
 82993,
 772025861,
 771821733,
 82987,
 -1,
 771954927,
 82988,
 -53754,
 771954749,
 82999,
 -53753,
 772085644,
 82998,
 -53752,
 772150956,
 82997,
 -53751,
 772215827,
 82991,
 -53750,
 772281077,
 82990,
 -53749,
 772346320,
 82989,
 -1,
 772411288,
 82986,
 772615706,
 771560924,
 -1,
 772681233,
 772543964,
 83016,
 -53745,
 772615042,
 83019,
 -53744,
 772679090,
 83018,
 -1,
 772741359,
 83017,
 -53742,
 772610109,
 83022,
 -53741,
 772872076,
 83021,
 -53740,
 772937388,
 83020,
 -53739,
 773002471,
 83015,
 -53738,
 773067795,
 83014,
 -53737,
 773133045,
 83013,
 -53736,
 773198288,
 83012,
 -53735,
 773263525,
 83011,
 -1,
 773328792,
 83010,
 773533223,
 772544573,
 -1,
 773598749,
 773461900,
 83052,
 -1,
 773527791,
 83053,
 773729823,
 773527212,
 83050,
 -1,
 773658863,
 83051,
 -53728,
 773658685,
 83054,
 -53727,
 773789148,
 83049,
 -53726,
 773854439,
 83048,
 -53725,
 773919763,
 83047,
 -53724,
 773985013,
 83046,
 -53723,
 774050256,
 83045,
 -53722,
 774115493,
 83044,
 -1,
 774180760,
 83043,
 774385203,
 773460725,
 -1,
 774450730,
 774314045,
 82984,
 -1,
 774379759,
 82985,
 -53717,
 774379404,
 82983,
 -53716,
 774510252,
 82982,
 -53715,
 774575580,
 82981,
 -53714,
 774640871,
 82980,
 -53713,
 774706195,
 82979,
 -53712,
 774771445,
 82978,
 -53711,
 774836688,
 82977,
 -53710,
 774901925,
 82976,
 -1,
 774967192,
 82975,
 775171647,
 774312400,
 -1,
 775237174,
 775099868,
 82970,
 -1,
 775166191,
 82971,
 -53705,
 775166013,
 82974,
 -53704,
 775296908,
 82973,
 -53703,
 775362220,
 82972,
 -53702,
 775427303,
 82969,
 -53701,
 775492627,
 82968,
 -53700,
 775557877,
 82967,
 -53699,
 775623120,
 82966,
 -53698,
 775688357,
 82965,
 -1,
 775753624,
 82964,
 775958091,
 775098533,
 -1,
 776023618,
 775884696,
 82953,
 -1,
 775952623,
 82954,
 -53693,
 775952445,
 82963,
 -53692,
 776083340,
 82962,
 -53691,
 776148652,
 82961,
 -53690,
 776213980,
 82960,
 -53689,
 776279271,
 82959,
 -53688,
 776344595,
 82958,
 -53687,
 776409845,
 82957,
 -53686,
 776475088,
 82956,
 -1,
 776540325,
 82955,
 776744534,
 775886732,
 -1,
 -53683,
 776673341,
 83042,
 -53682,
 776738700,
 83041,
 -53681,
 776804012,
 83040,
 -53680,
 776869340,
 83039,
 -53679,
 776934631,
 83038,
 -53678,
 776999955,
 83037,
 -53677,
 777065205,
 83036,
 -53676,
 777130448,
 83035,
 -53675,
 777195685,
 83034,
 -1,
 777260952,
 83033,
 777465441,
 776672940,
 -1,
 -53672,
 777394237,
 83032,
 -53671,
 777459596,
 83031,
 -53670,
 777524908,
 83030,
 -53669,
 777590236,
 83029,
 -53668,
 777655527,
 83028,
 -53667,
 777720851,
 83027,
 -53666,
 777786101,
 83026,
 -53665,
 777851344,
 83025,
 -53664,
 777916581,
 83024,
 -1,
 777981848,
 83023,
 778186348,
 777393383,
 -1,
 -53661,
 778115133,
 83009,
 -53660,
 778180492,
 83008,
 -53659,
 778245804,
 83007,
 -53658,
 778311132,
 83006,
 -53657,
 778376423,
 83005,
 -53656,
 778441747,
 83004,
 -53655,
 778506997,
 83003,
 -53654,
 778572240,
 83002,
 -53653,
 778637477,
 83001,
 -1,
 778702744,
 83000,
 778960895,
 778112920,
 -1,
 -53650,
 778836029,
 82952,
 -53649,
 778901388,
 82951,
 -53648,
 778966700,
 82950,
 -53647,
 779032028,
 82949,
 -53646,
 779097319,
 82948,
 -53645,
 779162643,
 82947,
 -53644,
 779227893,
 82946,
 -53643,
 779293136,
 82945,
 -1,
 779358373,
 82944,
 779562727,
 771494931,
 -1,
 779628164,
 779490535,
 -1,
 779693690,
 779556524,
 83455,
 -1,
 779622639,
 83456,
 779824764,
 779620248,
 83447,
 -1,
 779753711,
 83448,
 -53635,
 779753533,
 83458,
 -53634,
 779884428,
 83457,
 -53633,
 779949532,
 83454,
 -53632,
 780014823,
 83453,
 -53631,
 780080147,
 83452,
 -53630,
 780145397,
 83451,
 -53629,
 780210640,
 83450,
 -1,
 780275877,
 83449,
 780480145,
 779554981,
 -1,
 780545672,
 780406680,
 -1,
 -53625,
 780474612,
 83407,
 -1,
 780534106,
 83406,
 -53623,
 780474429,
 83416,
 -53622,
 780670860,
 83415,
 -53621,
 780736172,
 83414,
 -53620,
 780801500,
 83413,
 -53619,
 780866791,
 83412,
 -53618,
 780932115,
 83411,
 -53617,
 780997365,
 83410,
 -53616,
 781062608,
 83409,
 -1,
 781127845,
 83408,
 781332124,
 780408716,
 -1,
 -53613,
 781260861,
 83488,
 -53612,
 781326220,
 83487,
 -53611,
 781391532,
 83486,
 -53610,
 781456860,
 83485,
 -53609,
 781522151,
 83484,
 -53608,
 781587475,
 83483,
 -53607,
 781652725,
 83482,
 -53606,
 781717968,
 83481,
 -53605,
 781783205,
 83480,
 -1,
 781848472,
 83479,
 782053031,
 781260460,
 -1,
 -53602,
 781981757,
 83478,
 -53601,
 782047116,
 83477,
 -53600,
 782112428,
 83476,
 -53599,
 782177756,
 83475,
 -53598,
 782243047,
 83474,
 -53597,
 782308371,
 83473,
 -53596,
 782373621,
 83472,
 -53595,
 782438864,
 83471,
 -53594,
 782504101,
 83470,
 -1,
 782569368,
 83469,
 782773938,
 781981148,
 -1,
 -53591,
 782702653,
 83468,
 -53590,
 782768012,
 83467,
 -53589,
 782833324,
 83466,
 -53588,
 782898652,
 83465,
 -53587,
 782963943,
 83464,
 -53586,
 783029267,
 83463,
 -53585,
 783094517,
 83462,
 -53584,
 783159760,
 83461,
 -53583,
 783224997,
 83460,
 -1,
 783290264,
 83459,
 783494845,
 782701587,
 -1,
 -53580,
 783423549,
 83446,
 -53579,
 783488908,
 83445,
 -53578,
 783554220,
 83444,
 -53577,
 783619548,
 83443,
 -53576,
 783684839,
 83442,
 -53575,
 783750163,
 83441,
 -53574,
 783815413,
 83440,
 -53573,
 783880656,
 83439,
 -53572,
 783945893,
 83438,
 -1,
 784011160,
 83437,
 784215752,
 783422197,
 -1,
 -53569,
 784144445,
 83436,
 -53568,
 784209804,
 83435,
 -53567,
 784275116,
 83434,
 -53566,
 784340444,
 83433,
 -53565,
 784405735,
 83432,
 -53564,
 784471059,
 83431,
 -53563,
 784536309,
 83430,
 -53562,
 784601552,
 83429,
 -53561,
 784666789,
 83428,
 -1,
 784732056,
 83427,
 784936659,
 784142800,
 -1,
 -53558,
 784865341,
 83426,
 -53557,
 784930700,
 83425,
 -53556,
 784996012,
 83424,
 -53555,
 785061340,
 83423,
 -53554,
 785126631,
 83422,
 -53553,
 785191955,
 83421,
 -53552,
 785257205,
 83420,
 -53551,
 785322448,
 83419,
 -53550,
 785387685,
 83418,
 -1,
 785452952,
 83417,
 785657566,
 784863128,
 -1,
 -53547,
 785586237,
 83405,
 -53546,
 785651596,
 83404,
 -53545,
 785716908,
 83403,
 -53544,
 785782236,
 83402,
 -53543,
 785847527,
 83401,
 -53542,
 785912851,
 83400,
 -53541,
 785978101,
 83399,
 -53540,
 786043344,
 83398,
 -53539,
 786108581,
 83397,
 -1,
 786173848,
 83396,
 786431999,
 785586237,
 -1,
 -53536,
 786306732,
 83496,
 -53535,
 786372060,
 83495,
 -53534,
 786437351,
 83494,
 -53533,
 786502675,
 83493,
 -53532,
 786567925,
 83492,
 -53531,
 786633168,
 83491,
 -53530,
 786698405,
 83490,
 -1,
 786763672,
 83489,
 787021823,
 779490535,
 -1,
 787033843,
 786895312,
 -1,
 -53526,
 786962493,
 83525,
 -53525,
 787027852,
 83524,
 -53524,
 787093164,
 83523,
 -53523,
 787158492,
 83522,
 -53522,
 787223783,
 83521,
 -53521,
 787289107,
 83520,
 -53520,
 787354357,
 83519,
 -53519,
 787419600,
 83518,
 -53518,
 787484837,
 83517,
 -1,
 787550104,
 83516,
 787754750,
 786960549,
 -1,
 -53515,
 787683389,
 83515,
 -53514,
 787748748,
 83514,
 -53513,
 787814060,
 83513,
 -53512,
 787879388,
 83512,
 -53511,
 787944679,
 83511,
 -53510,
 788010003,
 83510,
 -53509,
 788075253,
 83509,
 -53508,
 788140496,
 83508,
 -53507,
 788205733,
 83507,
 -1,
 788271000,
 83506,
 788475656,
 787681176,
 -1,
 -53504,
 788404285,
 83505,
 -53503,
 788469644,
 83504,
 -53502,
 788534956,
 83503,
 -53501,
 788600284,
 83502,
 -53500,
 788665575,
 83501,
 -53499,
 788730899,
 83500,
 -53498,
 788796149,
 83499,
 -53497,
 788861392,
 83498,
 -1,
 788926629,
 83497,
 -1,
 788403184,
 83526,
 789196563,
 746830363,
 128028,
 789262098,
 789143133,
 -1,
 789327633,
 789234125,
 -1,
 -53491,
 789299343,
 11151,
 -53490,
 789358639,
 11148,
 -53489,
 789417976,
 11119,
 -53488,
 789476136,
 11150,
 -1,
 789522980,
 11149,
 -1,
 789265674,
 128260,
 -1,
 789202002,
 128246,
 789851927,
 789139256,
 -1,
 -53483,
 789825364,
 128551,
 -53482,
 789884262,
 128544,
 -1,
 789923257,
 128162,
 -1,
 789786332,
 9875,
 790180091,
 746758401,
 -1,
 790245623,
 790108700,
 -1,
 790311153,
 790167552,
 -1,
 790376410,
 790264597,
 -1,
 790441943,
 790347049,
 -1,
 790507334,
 790377949,
 -1,
 790572867,
 790464938,
 -1,
 790638398,
 790546014,
 -1,
 790703910,
 790608411,
 -1,
 790769444,
 790647842,
 -1,
 -53469,
 790708712,
 126646,
 -1,
 790764966,
 126648,
 -53467,
 790708712,
 126645,
 -1,
 790895752,
 126632,
 791097130,
 790670732,
 -1,
 -53464,
 791041850,
 126644,
 -53463,
 791101750,
 126638,
 -1,
 791157520,
 126641,
 791359277,
 791075647,
 -1,
 -53460,
 791306626,
 126630,
 -1,
 791368738,
 126650,
 791555888,
 791295595,
 -1,
 -53457,
 791506631,
 126627,
 -1,
 791557597,
 126649,
 -53455,
 791534008,
 126633,
 -53454,
 791728685,
 126629,
 -53453,
 791782732,
 126643,
 -53452,
 791846770,
 126642,
 -53451,
 791906077,
 126637,
 -53450,
 791969356,
 126636,
 -53449,
 792031198,
 126635,
 -53448,
 792096009,
 126647,
 -53447,
 792160868,
 126626,
 -53446,
 792220783,
 126631,
 -53445,
 792285572,
 126651,
 -53444,
 792349342,
 126640,
 -53443,
 792405869,
 126625,
 -1,
 792468723,
 126639,
 792723455,
 790609909,
 -1,
 -53440,
 792633202,
 126495,
 -53439,
 792692509,
 126493,
 -53438,
 792742558,
 126494,
 -1,
 792799085,
 126492,
 793051135,
 790501615,
 -1,
 -53435,
 792948423,
 126467,
 -1,
 792999389,
 126489,
 793194347,
 790458055,
 -1,
 793259882,
 793153412,
 -1,
 793325390,
 793229851,
 -1,
 793390924,
 793269282,
 -1,
 -53429,
 793330152,
 126614,
 -1,
 793386406,
 126616,
 -53427,
 793330152,
 126613,
 -1,
 793517192,
 126600,
 793718610,
 793292172,
 -1,
 -53424,
 793663290,
 126612,
 -53423,
 793723190,
 126606,
 -1,
 793778960,
 126609,
 793980757,
 793697087,
 -1,
 -53420,
 793928066,
 126598,
 -1,
 793990178,
 126618,
 794177368,
 793924642,
 -1,
 -53417,
 794116584,
 126596,
 -1,
 794172552,
 126599,
 794373979,
 794113643,
 -1,
 -53414,
 794324679,
 126595,
 -1,
 794375645,
 126617,
 794570590,
 794302703,
 -1,
 -53411,
 794522194,
 126592,
 -1,
 794583426,
 126607,
 -53409,
 794548664,
 126601,
 -53408,
 794743341,
 126597,
 -53407,
 794797388,
 126611,
 -53406,
 794861426,
 126610,
 -53405,
 794920733,
 126605,
 -53404,
 794984012,
 126604,
 -53403,
 795045854,
 126603,
 -53402,
 795110665,
 126615,
 -53401,
 795175524,
 126594,
 -53400,
 795234692,
 126619,
 -53399,
 795298462,
 126608,
 -1,
 795354989,
 126593,
 -1,
 793190100,
 126475,
 795619213,
 793161100,
 -1,
 795684746,
 795591038,
 -1,
 795750257,
 795654683,
 -1,
 -53393,
 795694911,
 126582,
 -53392,
 795754984,
 126581,
 -1,
 795810952,
 126568,
 796012405,
 795717004,
 -1,
 -53389,
 795957050,
 126580,
 -53388,
 796016950,
 126574,
 -1,
 796072720,
 126577,
 796274554,
 795948509,
 -1,
 796340089,
 796234453,
 -1,
 -53384,
 796281502,
 126590,
 -1,
 796338029,
 126588,
 -1,
 796269328,
 126585,
 796602237,
 796224309,
 -1,
 -53380,
 796546159,
 126583,
 -1,
 796597224,
 126570,
 796798848,
 796546082,
 -1,
 -53377,
 796738024,
 126564,
 -1,
 796793992,
 126567,
 -53375,
 796777282,
 126586,
 -53374,
 796973496,
 126569,
 -53373,
 797024114,
 126578,
 -53372,
 797083421,
 126573,
 -53371,
 797146700,
 126572,
 -53370,
 797207140,
 126562,
 -53369,
 797266308,
 126587,
 -53368,
 797330078,
 126576,
 -53367,
 797386605,
 126561,
 -1,
 797449459,
 126575,
 -53365,
 795629370,
 126484,
 -53364,
 797589814,
 126478,
 -1,
 797645584,
 126481,
 797847462,
 795567186,
 -1,
 797912978,
 797814156,
 -1,
 -53360,
 797857594,
 126516,
 -53359,
 797917494,
 126510,
 -1,
 797973264,
 126513,
 798175125,
 797882907,
 -1,
 -53356,
 798119743,
 126518,
 -1,
 798179816,
 126517,
 798371736,
 798124853,
 -1,
 -53353,
 798315631,
 126519,
 -1,
 798366696,
 126506,
 798568347,
 798315554,
 -1,
 -53350,
 798507496,
 126500,
 -1,
 798563464,
 126503,
 -53348,
 798546360,
 126505,
 -53347,
 798728050,
 126514,
 -53346,
 798787357,
 126509,
 -53345,
 798850636,
 126508,
 -53344,
 798912478,
 126507,
 -53343,
 798976612,
 126498,
 -53342,
 799035780,
 126523,
 -53341,
 799099550,
 126512,
 -53340,
 799159960,
 126521,
 -53339,
 799221613,
 126497,
 -1,
 799284467,
 126511,
 799485888,
 797817371,
 -1,
 799551420,
 799414511,
 -1,
 799616955,
 799498491,
 -1,
 799682477,
 799583628,
 -1,
 -53333,
 799627066,
 126548,
 -53332,
 799686966,
 126542,
 -1,
 799742736,
 126545,
 799944626,
 799618525,
 -1,
 800010161,
 799904469,
 -1,
 -53328,
 799973234,
 126559,
 -1,
 800032541,
 126557,
 -1,
 799939344,
 126553,
 -53325,
 799922616,
 126537,
 -53324,
 800235378,
 126546,
 -53323,
 800294685,
 126541,
 -53322,
 800354270,
 126539,
 -53321,
 800419081,
 126551,
 -53320,
 800483940,
 126530,
 -53319,
 800543855,
 126535,
 -53318,
 800608644,
 126555,
 -1,
 800660723,
 126543,
 -1,
 799560738,
 126472,
 800927679,
 799495202,
 -1,
 -53314,
 800866792,
 126486,
 -1,
 800923046,
 126488,
 -1,
 800866792,
 126485,
 801189827,
 799464255,
 -1,
 -53310,
 801137026,
 126470,
 -1,
 801199138,
 126490,
 801386438,
 801149024,
 -1,
 -53307,
 801341020,
 126704,
 -1,
 801395827,
 126705,
 801583049,
 801336117,
 -1,
 -53304,
 801526895,
 126487,
 -1,
 801577960,
 126474,
 801779660,
 801511663,
 -1,
 -53301,
 801731154,
 126464,
 -1,
 801792386,
 126479,
 -53299,
 801757624,
 126473,
 -53298,
 801952301,
 126469,
 -53297,
 802006348,
 126483,
 -53296,
 802070386,
 126482,
 -53295,
 802129693,
 126477,
 -53294,
 802192972,
 126476,
 -53293,
 802253412,
 126466,
 -53292,
 802313327,
 126471,
 -53291,
 802378116,
 126491,
 -53290,
 802441886,
 126480,
 -1,
 802498413,
 126465,
 802750463,
 790407890,
 -1,
 -53287,
 802665070,
 2303,
 -1,
 802719533,
 1624,
 802893930,
 790326983,
 -1,
 802959465,
 802831932,
 -1,
 803024998,
 802931436,
 -1,
 803090411,
 802957169,
 -1,
 803155940,
 803060251,
 -1,
 803221475,
 803101544,
 -1,
 803287010,
 803183851,
 1874,
 -1,
 803209417,
 1875,
 -1,
 803232404,
 1872,
 -1,
 803198536,
 1876,
 803549160,
 803124176,
 -1,
 803614695,
 803523706,
 1878,
 -1,
 803537263,
 2208,
 -1,
 803569233,
 2230,
 -53271,
 803497477,
 1877,
 -53270,
 803755325,
 2209,
 -1,
 803813934,
 1873,
 804007931,
 803031480,
 -1,
 804073462,
 803939023,
 -1,
 804138994,
 804014321,
 -1,
 804204529,
 804108827,
 -1,
 -53264,
 804181521,
 1909,
 -1,
 804215627,
 1910,
 -1,
 804146565,
 1911,
 804466677,
 804108827,
 -1,
 -53260,
 804443692,
 1598,
 -1,
 804477811,
 1599,
 -1,
 804415004,
 1597,
 804782079,
 804012523,
 -1,
 804794362,
 804698651,
 -1,
 -53255,
 804771386,
 1888,
 -1,
 804805523,
 1889,
 -1,
 804731438,
 2212,
 805056522,
 803936495,
 -1,
 805122051,
 805003680,
 -1,
 805187584,
 805099043,
 -1,
 -53249,
 805162683,
 1887,
 -1,
 805181985,
 1885,
 805437439,
 805133160,
 -1,
 -53246,
 805346488,
 1886,
 -1,
 805382028,
 2227,
 805580807,
 805064317,
 -1,
 -53243,
 805543794,
 2236,
 -53242,
 805603101,
 2237,
 -1,
 805653150,
 2235,
 805896191,
 805532246,
 -1,
 -53239,
 805819921,
 1907,
 -1,
 805854027,
 1908,
 806039574,
 805019905,
 -1,
 806105109,
 805978603,
 -1,
 806170641,
 806071692,
 -1,
 806236176,
 806124515,
 -1,
 -53233,
 806192930,
 2233,
 -1,
 806232362,
 1905,
 -1,
 806208129,
 1883,
 -53230,
 806143080,
 1899,
 -53229,
 806451373,
 2218,
 -53228,
 806512156,
 1775,
 -1,
 806573373,
 1900,
 -1,
 806062962,
 2220,
 806826020,
 805989173,
 -1,
 806891551,
 806765087,
 -1,
 806957086,
 806861339,
 -1,
 807022621,
 806902632,
 -1,
 -53221,
 806984939,
 1892,
 -53220,
 807020428,
 1596,
 -1,
 807082529,
 1891,
 -1,
 806999596,
 1595,
 -1,
 806894071,
 1890,
 807469055,
 806820079,
 -1,
 807481379,
 807356905,
 -1,
 -53214,
 807453736,
 1919,
 -1,
 807483940,
 2228,
 -1,
 807448971,
 1568,
 807743533,
 806792588,
 -1,
 807809067,
 807682362,
 -1,
 -53209,
 807781480,
 1901,
 -53208,
 807842800,
 1904,
 -53207,
 807888412,
 1918,
 -53206,
 807947708,
 1884,
 -1,
 808012046,
 1917,
 -53204,
 807780641,
 2225,
 -1,
 808131355,
 2223,
 808333369,
 807687202,
 -1,
 808398904,
 808262795,
 -1,
 808464436,
 808367063,
 -1,
 808529971,
 808392943,
 -1,
 -53198,
 808485885,
 1903,
 -1,
 808528450,
 1906,
 -1,
 808462220,
 1902,
 808792119,
 808434203,
 -1,
 -53194,
 808769068,
 1879,
 -1,
 808803219,
 1880,
 -1,
 808732981,
 1916,
 -1,
 808337908,
 1791,
 809119809,
 808311228,
 -1,
 809185342,
 809096533,
 -1,
 -53188,
 809153657,
 2234,
 -53187,
 809194813,
 2216,
 -1,
 809253367,
 2217,
 809500671,
 809117384,
 -1,
 -53184,
 809424401,
 1914,
 -1,
 809458507,
 1915,
 809644104,
 809073343,
 -1,
 809709639,
 809582892,
 -1,
 809775174,
 809646578,
 -1,
 -53179,
 809707404,
 1894,
 -1,
 809769505,
 1893,
 -1,
 809745891,
 2215,
 -1,
 809640389,
 1564,
 810102863,
 809580205,
 -1,
 810168396,
 810072603,
 -1,
 -53173,
 810145380,
 1881,
 -1,
 810179459,
 2222,
 810418175,
 810116448,
 -1,
 -53170,
 810339450,
 1774,
 -1,
 810398926,
 1882,
 810561620,
 810078769,
 -1,
 810627155,
 810502492,
 -1,
 -53166,
 810604049,
 1912,
 -1,
 810638155,
 1913,
 -1,
 810564228,
 2219,
 810889305,
 810518329,
 -1,
 810954840,
 810857424,
 -1,
 -53161,
 810929274,
 1897,
 -1,
 810990315,
 1896,
 -1,
 810927159,
 1895,
 811216990,
 810839751,
 -1,
 811282525,
 811146967,
 -1,
 -53156,
 811219751,
 2214,
 -1,
 811279986,
 1898,
 -1,
 811243165,
 2221,
 811544673,
 811186715,
 -1,
 -53152,
 811483655,
 2232,
 -1,
 811539604,
 2211,
 -53150,
 811522895,
 2226,
 -53149,
 811704182,
 2213,
 -53148,
 811768237,
 2231,
 -53147,
 811821673,
 2210,
 -1,
 811880385,
 2224,
 812122111,
 802967264,
 -1,
 -53144,
 812001164,
 2297,
 -1,
 812063265,
 2295,
 -1,
 802905970,
 65021,
 812331193,
 802860428,
 -1,
 812396678,
 812284899,
 -1,
 812462210,
 812341317,
 -1,
 812527736,
 812437772,
 -1,
 812593271,
 812486976,
 -1,
 812658804,
 812521711,
 -1,
 -53135,
 812629209,
 2266,
 -53134,
 812690964,
 2267,
 -53133,
 812753241,
 2260,
 -1,
 812811051,
 2268,
 -53131,
 812634529,
 2271,
 -53130,
 812953158,
 2269,
 -1,
 813014946,
 2270,
 -1,
 812524892,
 2291,
 813248635,
 812494220,
 -1,
 -53126,
 813195401,
 2273,
 -1,
 813243152,
 2261,
 -53124,
 813226826,
 1559,
 -53123,
 813415147,
 1557,
 -53122,
 813473650,
 2263,
 -53121,
 813532996,
 2264,
 -53120,
 813594109,
 1558,
 -53119,
 813649153,
 2272,
 -1,
 813702387,
 2262,
 -53117,
 812415277,
 2265,
 -53116,
 813853739,
 1562,
 -53115,
 813910620,
 1560,
 -1,
 813971152,
 1561,
 814166176,
 812374641,
 -1,
 814231700,
 814135835,
 -1,
 814297230,
 814208547,
 -1,
 814362764,
 814272175,
 -1,
 -53109,
 814294924,
 64446,
 -1,
 814357025,
 64445,
 -53107,
 814294924,
 64437,
 -1,
 814488097,
 64436,
 814743551,
 814242664,
 -1,
 814755986,
 814652580,
 -1,
 -53103,
 814688140,
 64441,
 -1,
 814750241,
 64440,
 -53101,
 814688140,
 64439,
 -1,
 814881313,
 64438,
 815083673,
 814168493,
 -1,
 815149208,
 815053341,
 -1,
 -53097,
 815081356,
 64435,
 -1,
 815143457,
 64434,
 -1,
 815121990,
 64444,
 815411356,
 815051944,
 -1,
 -53093,
 815343500,
 64449,
 -1,
 815405601,
 64448,
 815607967,
 815353265,
 -1,
 -53090,
 815540108,
 64443,
 -1,
 815602209,
 64442,
 -1,
 815573339,
 64447,
 815870124,
 814112877,
 -1,
 815935654,
 815836703,
 -1,
 -53085,
 815891315,
 1537,
 -53084,
 815956687,
 1540,
 -53083,
 816019362,
 1552,
 -1,
 816073494,
 1539,
 816263337,
 815899003,
 -1,
 -53080,
 816208258,
 1554,
 -1,
 816265279,
 1555,
 -53078,
 816233255,
 1556,
 -53077,
 816414893,
 1551,
 -1,
 816455131,
 1553,
 816656568,
 815809881,
 -1,
 816722103,
 816634305,
 -1,
 816787634,
 816650479,
 -1,
 816853169,
 816738898,
 983621,
 -1,
 816776302,
 983623,
 -1,
 816791100,
 983628,
 -53069,
 816765727,
 983626,
 -53068,
 817025581,
 983622,
 -53067,
 817087690,
 983625,
 -53066,
 817138389,
 983624,
 -1,
 817184316,
 983627,
 -1,
 816678740,
 983629,
 -1,
 816629355,
 1622,
 817508550,
 812300827,
 -1,
 817574084,
 817466808,
 -1,
 817639614,
 817546270,
 -1,
 -53059,
 817571724,
 2286,
 -1,
 817633825,
 2283,
 817836225,
 817597895,
 -1,
 -53056,
 817768332,
 2285,
 -1,
 817830433,
 2282,
 818085887,
 817789106,
 -1,
 -53053,
 817964940,
 2287,
 -1,
 818027041,
 2284,
 -53051,
 817548105,
 2275,
 -1,
 818194980,
 1566,
 818360525,
 817444204,
 -1,
 818426057,
 818310187,
 2278,
 -1,
 818396010,
 2281,
 818557131,
 818367068,
 2276,
 -1,
 818527082,
 2279,
 818741247,
 818493136,
 2277,
 -1,
 818658154,
 2280,
 818819284,
 818323713,
 -1,
 818884818,
 818765791,
 -1,
 818950353,
 818813473,
 2296,
 -1,
 818875335,
 2301,
 -1,
 818882444,
 2298,
 -53037,
 818825309,
 1629,
 -1,
 819078515,
 1544,
 819278043,
 818755037,
 -1,
 819343575,
 819237721,
 2299,
 -1,
 819268551,
 2300,
 819474650,
 819271919,
 -1,
 -53031,
 819444663,
 1549,
 -1,
 819495124,
 2302,
 -1,
 819423162,
 2274,
 819736801,
 819218872,
 -1,
 819802336,
 819667972,
 -1,
 -53026,
 819774485,
 1630,
 -53025,
 819833179,
 2292,
 -1,
 819870199,
 2293,
 -1,
 819761062,
 1538,
 820130021,
 819712152,
 -1,
 -53021,
 820098240,
 1626,
 -53020,
 820143598,
 1627,
 -1,
 820197924,
 1628,
 820392169,
 820088818,
 -1,
 -53017,
 820341830,
 2290,
 -53016,
 820398690,
 2288,
 -1,
 820459222,
 2289,
 820654316,
 820349152,
 -1,
 -53013,
 820621962,
 1536,
 -1,
 820673691,
 1541,
 -53011,
 820632733,
 1625,
 -53010,
 820826652,
 1631,
 -53009,
 820878407,
 1550,
 -53008,
 820931633,
 2294,
 -1,
 820995491,
 1623,
 821231615,
 790236826,
 -1,
 821244149,
 821140038,
 -1,
 -53004,
 821214272,
 1546,
 -1,
 821264432,
 1545,
 -53002,
 821186113,
 1543,
 -1,
 821376272,
 1542,
 821571834,
 790216310,
 -1,
 -52999,
 821540579,
 127912,
 -1,
 821572904,
 128667,
 -1,
 821526196,
 1423,
 821834150,
 790130375,
 -1,
 821899679,
 821767800,
 -1,
 821965078,
 821865868,
 -1,
 822030600,
 821937354,
 -1,
 822096135,
 821963098,
 -1,
 822161670,
 822034076,
 -1,
 822227204,
 822128239,
 -1,
 -52989,
 822162167,
 128807,
 -1,
 822222996,
 128814,
 -52987,
 822162167,
 128802,
 -1,
 822354068,
 128812,
 -1,
 822109745,
 128862,
 -1,
 822048157,
 128781,
 822685966,
 821960102,
 -1,
 822751501,
 822655515,
 128788,
 822870015,
 822674667,
 -1,
 -52980,
 822751998,
 128806,
 -1,
 822812820,
 128813,
 -1,
 822677043,
 128825,
 823079186,
 822655515,
 -1,
 823144721,
 823042861,
 128860,
 -1,
 823070247,
 128861,
 -1,
 823075421,
 128850,
 -52973,
 823040844,
 128839,
 -52972,
 823298539,
 128852,
 -52971,
 823353618,
 128795,
 -1,
 823406017,
 128847,
 823603497,
 821893359,
 -1,
 823669022,
 823566276,
 -1,
 823734557,
 823590912,
 -1,
 823800091,
 823709590,
 128776,
 -1,
 823725607,
 128777,
 823984127,
 823764294,
 128774,
 -1,
 823856679,
 128775,
 -1,
 823676229,
 128773,
 824127779,
 823619271,
 -1,
 824193313,
 824077287,
 128822,
 -1,
 824118823,
 128823,
 -52958,
 824166349,
 128837,
 -1,
 824263466,
 128874,
 -52956,
 824101666,
 128829,
 -52955,
 824422708,
 128855,
 -52954,
 824487061,
 128826,
 -52953,
 824543374,
 128811,
 -52952,
 824605655,
 128859,
 -1,
 824665751,
 128769,
 824848701,
 823536514,
 -1,
 824914229,
 824811777,
 -1,
 824979761,
 824886971,
 128869,
 825098239,
 824905250,
 -1,
 -52946,
 824972519,
 128873,
 -52945,
 825037843,
 128872,
 -52944,
 825103093,
 128871,
 -1,
 825168336,
 128870,
 825425919,
 824937102,
 -1,
 825438516,
 825307895,
 128803,
 -1,
 825364007,
 128804,
 -1,
 825386790,
 128798,
 825635129,
 824842479,
 -1,
 -52937,
 825597732,
 128846,
 -52936,
 825653932,
 128844,
 -1,
 825703879,
 128848,
 825897276,
 825594003,
 -1,
 -52933,
 825856354,
 128800,
 -1,
 825893000,
 128805,
 -1,
 825844870,
 128787,
 826159437,
 824811777,
 -1,
 826224971,
 826097212,
 -1,
 826290504,
 826168261,
 128818,
 826356036,
 826215970,
 -1,
 -52926,
 826283027,
 128821,
 -52925,
 826348277,
 128820,
 -1,
 826413520,
 128819,
 826671103,
 826279147,
 -1,
 826683719,
 826548372,
 128816,
 -1,
 826609191,
 128817,
 -1,
 826631974,
 128799,
 826880330,
 826220096,
 128827,
 -1,
 826805799,
 128828,
 -1,
 826851527,
 128877,
 827129855,
 826182238,
 128792,
 -1,
 827002407,
 128793,
 827208024,
 826090930,
 -1,
 827273554,
 827167035,
 128834,
 827391999,
 827199010,
 -1,
 -52911,
 827265781,
 128836,
 -1,
 827331024,
 128835,
 827535701,
 827204604,
 -1,
 -52908,
 827509949,
 128876,
 -1,
 827555086,
 128875,
 -52906,
 827500284,
 128857,
 -52905,
 827682642,
 128783,
 -1,
 827746198,
 128830,
 827928930,
 827182202,
 -1,
 827994465,
 827874513,
 -1,
 828059999,
 827950216,
 128778,
 828125534,
 827985442,
 -1,
 -52899,
 828052213,
 128780,
 -1,
 828117456,
 128779,
 -1,
 828048624,
 128815,
 828440575,
 828031548,
 128790,
 -1,
 828313127,
 128791,
 -1,
 827934177,
 128808,
 828584300,
 827889518,
 -1,
 828649831,
 828541354,
 -1,
 828715366,
 828625513,
 128843,
 -1,
 828653686,
 128858,
 -1,
 828684843,
 128856,
 828911978,
 828622026,
 -1,
 -52887,
 828883304,
 128868,
 -1,
 828942145,
 128867,
 -52885,
 828875901,
 128863,
 -1,
 829053098,
 128782,
 829239668,
 828553755,
 -1,
 829305200,
 829186434,
 -1,
 -52881,
 829240581,
 128840,
 -1,
 829293896,
 128809,
 829501810,
 829235938,
 128831,
 -1,
 829427239,
 128832,
 -52877,
 829475941,
 128845,
 -1,
 829597441,
 128849,
 829763963,
 829192895,
 -1,
 829829497,
 829703632,
 128784,
 829947903,
 829754914,
 -1,
 -52872,
 829821685,
 128786,
 -1,
 829886928,
 128785,
 -52870,
 829787944,
 128881,
 -1,
 830021966,
 128824,
 830222722,
 829707298,
 -1,
 830288255,
 830179754,
 -1,
 -52866,
 830261957,
 128878,
 -1,
 830319756,
 128854,
 830537727,
 830217769,
 -1,
 -52863,
 830444456,
 128883,
 -1,
 830487937,
 128882,
 830681480,
 830158301,
 -1,
 830747015,
 830629702,
 -1,
 830812550,
 830715229,
 128865,
 -1,
 830737959,
 128866,
 -1,
 830783260,
 128864,
 -1,
 830678398,
 128880,
 831074700,
 830629670,
 -1,
 831140235,
 830997832,
 128796,
 -1,
 831065639,
 128797,
 -1,
 831065677,
 128801,
 831336847,
 831050060,
 -1,
 -52850,
 831313885,
 128842,
 -1,
 831372399,
 128772,
 831533458,
 831299800,
 -1,
 -52847,
 831490170,
 128768,
 -1,
 831533133,
 128833,
 831730069,
 831489519,
 -1,
 -52844,
 831701343,
 128789,
 -1,
 831738304,
 128879,
 831926680,
 831680199,
 -1,
 -52841,
 831883949,
 128851,
 -1,
 831930212,
 128810,
 832123291,
 831868728,
 -1,
 -52838,
 832096205,
 128841,
 -1,
 832146462,
 128794,
 -52836,
 832097052,
 128853,
 -52835,
 832277377,
 128838,
 -52834,
 832326573,
 128770,
 -1,
 832389023,
 128771,
 832582050,
 821837372,
 -1,
 -52831,
 832548008,
 983054,
 -1,
 832601417,
 9879,
 -52829,
 832552082,
 9941,
 -52828,
 832731839,
 983201,
 -52827,
 832790276,
 128126,
 -1,
 832840214,
 9200,
 833040919,
 821769693,
 -1,
 833106454,
 832991202,
 -1,
 833171924,
 833039234,
 -1,
 833237459,
 833102039,
 -1,
 833302958,
 833192692,
 -1,
 -52820,
 833280300,
 125209,
 -52819,
 833341481,
 125200,
 -1,
 833377336,
 125211,
 833565106,
 833252149,
 -1,
 -52816,
 833526852,
 125216,
 -52815,
 833573944,
 125213,
 -1,
 833625064,
 125201,
 833827253,
 833542355,
 -1,
 -52812,
 833771137,
 125198,
 -1,
 833820911,
 125202,
 834023864,
 833793420,
 -1,
 -52809,
 833971342,
 125189,
 -1,
 834032696,
 125217,
 834220475,
 833965880,
 -1,
 -52806,
 834152259,
 125214,
 -1,
 834214127,
 125208,
 834417086,
 834155997,
 -1,
 -52803,
 834360376,
 125197,
 -1,
 834410916,
 125185,
 834613697,
 834348466,
 -1,
 -52800,
 834557569,
 125191,
 -1,
 834607343,
 125188,
 -52798,
 834591609,
 125215,
 -52797,
 834785837,
 125199,
 -52796,
 834849936,
 125212,
 -52795,
 834913482,
 125203,
 -52794,
 834978571,
 125210,
 -52793,
 835035515,
 125192,
 -52792,
 835100525,
 125207,
 -52791,
 835164525,
 125190,
 -52790,
 835226026,
 125196,
 -52789,
 835289091,
 125187,
 -52788,
 835350297,
 125186,
 -52787,
 835414710,
 125204,
 -52786,
 835476689,
 125195,
 -52785,
 835540024,
 125206,
 -52784,
 835602957,
 125194,
 -52783,
 835665468,
 125193,
 -52782,
 835727007,
 125205,
 -1,
 835788358,
 125184,
 -1,
 833195791,
 125256,
 836055550,
 833139790,
 -1,
 836121049,
 836010740,
 -1,
 -52777,
 836098348,
 125243,
 -52776,
 836159529,
 125234,
 -1,
 836195384,
 125245,
 836383197,
 836070197,
 -1,
 -52773,
 836344900,
 125250,
 -52772,
 836391992,
 125247,
 -1,
 836443112,
 125235,
 836645344,
 836360403,
 -1,
 -52769,
 836589185,
 125232,
 -1,
 836638959,
 125236,
 836841955,
 836611468,
 -1,
 -52766,
 836789390,
 125223,
 -1,
 836850744,
 125251,
 837038566,
 836783928,
 -1,
 -52763,
 836970307,
 125248,
 -1,
 837032175,
 125242,
 837235177,
 836974045,
 -1,
 -52760,
 837178424,
 125231,
 -1,
 837228964,
 125219,
 837431788,
 837166514,
 -1,
 -52757,
 837375617,
 125225,
 -1,
 837425391,
 125222,
 -52755,
 837409657,
 125249,
 -52754,
 837603885,
 125233,
 -52753,
 837667984,
 125246,
 -52752,
 837731530,
 125237,
 -52751,
 837796619,
 125244,
 -52750,
 837853563,
 125226,
 -52749,
 837918573,
 125241,
 -52748,
 837982573,
 125224,
 -52747,
 838044074,
 125230,
 -52746,
 838107139,
 125221,
 -52745,
 838168345,
 125220,
 -52744,
 838232758,
 125238,
 -52743,
 838294737,
 125229,
 -52742,
 838358072,
 125240,
 -52741,
 838421005,
 125228,
 -52740,
 838483516,
 125227,
 -52739,
 838545055,
 125239,
 -1,
 838606406,
 125218,
 838808076,
 835991772,
 -1,
 838873602,
 838777371,
 -1,
 -52735,
 838850058,
 125266,
 -1,
 838884160,
 125267,
 839070213,
 838839692,
 -1,
 -52732,
 839018883,
 125270,
 -1,
 839075807,
 125271,
 839266824,
 839010744,
 -1,
 -52729,
 839226308,
 125268,
 -1,
 839280849,
 125269,
 -52727,
 839244785,
 125264,
 -52726,
 839421364,
 125265,
 -52725,
 839484976,
 125273,
 -1,
 839533109,
 125272,
 839725583,
 838755410,
 -1,
 -52722,
 839688367,
 125279,
 -1,
 839731387,
 125278,
 839922194,
 839667956,
 -1,
 -52719,
 839870005,
 125254,
 -1,
 839925362,
 125257,
 -52717,
 839897207,
 125253,
 -52716,
 840075478,
 125258,
 -52715,
 840127799,
 125255,
 -1,
 840179275,
 125252,
 -1,
 833061043,
 127903,
 840446569,
 832978492,
 -1,
 840512104,
 840388824,
 -1,
 840577623,
 840468704,
 -1,
 840643115,
 840546843,
 -1,
 840708642,
 840618252,
 -1,
 840774176,
 840665514,
 65800,
 840892415,
 840695808,
 -1,
 -52705,
 840809877,
 65827,
 -1,
 840850519,
 65818,
 841089023,
 840713428,
 65809,
 -1,
 840960377,
 65836,
 841167401,
 840651810,
 -1,
 841232935,
 841131248,
 65801,
 841351167,
 841154560,
 -1,
 -52698,
 841268629,
 65828,
 -1,
 841309271,
 65819,
 841547775,
 841180993,
 65810,
 -1,
 841419129,
 65837,
 841678847,
 841106276,
 65808,
 -1,
 841550201,
 65835,
 841757240,
 840609164,
 -1,
 841822770,
 841705859,
 65804,
 841888303,
 841794739,
 65813,
 -1,
 841812345,
 65840,
 842072063,
 841809920,
 -1,
 -52687,
 841989525,
 65831,
 -1,
 842030167,
 65822,
 842268671,
 841762783,
 65805,
 842281525,
 842187955,
 65814,
 -1,
 842205561,
 65841,
 842465279,
 842203136,
 -1,
 -52681,
 842382741,
 65832,
 -1,
 842423383,
 65823,
 842609223,
 841697720,
 -1,
 842674752,
 842566058,
 -1,
 842740286,
 842648261,
 65802,
 842858495,
 842661888,
 -1,
 -52675,
 842775957,
 65829,
 -1,
 842816599,
 65820,
 843055103,
 842706164,
 65811,
 -1,
 842926457,
 65838,
 843186175,
 842620113,
 -1,
 843199045,
 843107685,
 65803,
 843317247,
 843120640,
 -1,
 -52668,
 843234709,
 65830,
 -1,
 843275351,
 65821,
 843513855,
 843140895,
 65812,
 -1,
 843385209,
 65839,
 843592269,
 842565168,
 65807,
 843657802,
 843564211,
 65816,
 -1,
 843581817,
 65843,
 843841535,
 843579392,
 -1,
 -52660,
 843758997,
 65834,
 -1,
 843799639,
 65825,
 843985491,
 843530805,
 65806,
 844051024,
 843962579,
 65815,
 -1,
 843975033,
 65842,
 844234751,
 843972608,
 -1,
 -52654,
 844152213,
 65833,
 -1,
 844192855,
 65824,
 844431359,
 843943348,
 65799,
 844496895,
 844300288,
 -1,
 -52650,
 844414357,
 65826,
 -1,
 844454999,
 65817,
 844640866,
 840552716,
 -1,
 844706399,
 844579387,
 -1,
 844771932,
 844646840,
 -1,
 -52645,
 844731480,
 65851,
 -1,
 844785460,
 65848,
 -52643,
 844741999,
 65850,
 -52642,
 844934990,
 65849,
 -1,
 844965632,
 65847,
 845217791,
 844665171,
 -1,
 -52639,
 845117106,
 65792,
 -1,
 845167086,
 65793,
 845361765,
 844594623,
 -1,
 -52636,
 845331823,
 65855,
 -1,
 845393742,
 65854,
 -52634,
 845313802,
 65853,
 -52633,
 845495692,
 65852,
 -1,
 845557322,
 65794,
 -1,
 840476336,
 128673,
 845820600,
 840391144,
 -1,
 845886094,
 845771996,
 -1,
 845951599,
 845841140,
 -1,
 -52627,
 845928748,
 71440,
 -52626,
 845959047,
 71426,
 -1,
 846010607,
 71427,
 846213747,
 845879535,
 71442,
 846331903,
 846166549,
 -1,
 -52622,
 846248605,
 71429,
 -1,
 846286727,
 71446,
 846475894,
 846182939,
 -1,
 -52619,
 846419000,
 71436,
 -1,
 846469359,
 71428,
 846672505,
 846436206,
 -1,
 -52616,
 846615608,
 71431,
 -1,
 846665967,
 71430,
 846869116,
 846621493,
 -1,
 -52613,
 846812216,
 71425,
 -1,
 846862575,
 71424,
 847065727,
 846817801,
 -1,
 -52610,
 847008824,
 71449,
 -1,
 847059183,
 71434,
 847262338,
 847007544,
 -1,
 -52607,
 847205432,
 71447,
 -1,
 847255791,
 71445,
 847458949,
 847197661,
 -1,
 -52604,
 847402040,
 71444,
 -1,
 847452399,
 71443,
 847655560,
 847390130,
 -1,
 -52601,
 847598648,
 71448,
 -1,
 847649007,
 71432,
 -52599,
 847621663,
 71439,
 -52598,
 847815035,
 71437,
 -52597,
 847870741,
 71433,
 -52596,
 847933189,
 71438,
 -52595,
 847991864,
 71441,
 -1,
 848047643,
 71435,
 848245402,
 845861016,
 -1,
 848310932,
 848173295,
 71456,
 -52591,
 848285964,
 71463,
 -52590,
 848329407,
 71466,
 -52589,
 848387281,
 71465,
 -1,
 848435439,
 71457,
 848638614,
 848282826,
 71460,
 -1,
 848610506,
 71461,
 848769688,
 848583889,
 71458,
 -1,
 848714961,
 71459,
 -52583,
 848726442,
 71464,
 -1,
 848838204,
 71462,
 849031848,
 848181468,
 -1,
 849097374,
 849000987,
 -1,
 -52579,
 849073674,
 71474,
 -1,
 849107776,
 71475,
 849293985,
 849063308,
 -1,
 -52576,
 849242499,
 71478,
 -1,
 849299423,
 71479,
 849490596,
 849234360,
 -1,
 -52573,
 849449924,
 71476,
 -1,
 849504465,
 71477,
 -52571,
 849468401,
 71472,
 -52570,
 849644980,
 71473,
 -52569,
 849708592,
 71481,
 -1,
 849756725,
 71480,
 849949360,
 848997772,
 -1,
 850014895,
 849895533,
 -1,
 850080429,
 849980812,
 -1,
 -52564,
 850033691,
 71484,
 -1,
 850083932,
 71485,
 -52562,
 850046224,
 71486,
 -1,
 850226537,
 71467,
 -1,
 849992339,
 71487,
 850473653,
 849883791,
 -1,
 850539188,
 850423495,
 -1,
 -52557,
 850485095,
 71455,
 -1,
 850532591,
 71453,
 -1,
 850502011,
 71454,
 850853887,
 850430196,
 -1,
 -52553,
 850776735,
 71483,
 -1,
 850805604,
 71482,
 850998015,
 845794426,
 -1,
 851063550,
 850937553,
 -1,
 851129085,
 851014876,
 -1,
 851194563,
 851056879,
 68352,
 851260095,
 851122415,
 68353,
 -52546,
 851216810,
 68355,
 -1,
 851280628,
 68357,
 851456705,
 851197500,
 68358,
 -1,
 851394108,
 68359,
 -52542,
 851413418,
 68354,
 -1,
 851542772,
 68356,
 851718859,
 851149556,
 -1,
 851784392,
 851660600,
 -1,
 -52538,
 851761569,
 68387,
 -52537,
 851823973,
 68388,
 -1,
 851852860,
 68386,
 -52535,
 851761569,
 68390,
 -52534,
 852001881,
 68391,
 -1,
 852049468,
 68389,
 852243153,
 851684748,
 -1,
 852308687,
 852186146,
 -1,
 -52530,
 852285857,
 68403,
 -1,
 852311612,
 68401,
 -52528,
 852275460,
 68404,
 -1,
 852442684,
 68399,
 852636373,
 852219869,
 -1,
 -52525,
 852613537,
 68370,
 -52524,
 852675941,
 68371,
 -1,
 852704828,
 68369,
 852898521,
 852605467,
 -1,
 -52521,
 852868006,
 68381,
 -52520,
 852907649,
 68378,
 -1,
 852966972,
 68377,
 853160669,
 852840248,
 -1,
 -52517,
 853104257,
 68374,
 -52516,
 853168317,
 68373,
 -1,
 853229116,
 68372,
 853422816,
 853138223,
 -1,
 -52513,
 853366401,
 68402,
 -1,
 853425724,
 68400,
 853619427,
 853399763,
 -1,
 -52510,
 853596577,
 68394,
 -1,
 853622332,
 68395,
 853816037,
 853591242,
 68366,
 -1,
 853787850,
 68367,
 853947111,
 853772714,
 68362,
 -1,
 853903786,
 68363,
 854078185,
 853892305,
 68364,
 -1,
 854023377,
 68365,
 854209260,
 854021154,
 -1,
 -52501,
 854162856,
 68393,
 -1,
 854212156,
 68405,
 854405870,
 854146620,
 68360,
 -1,
 854343228,
 68361,
 854536945,
 854341085,
 -1,
 -52496,
 854480513,
 68380,
 -1,
 854539836,
 68379,
 854733556,
 854468018,
 -1,
 -52493,
 854677121,
 68385,
 -1,
 854736444,
 68384,
 -52491,
 854707557,
 68396,
 -52490,
 854893549,
 68397,
 -52489,
 854956397,
 68382,
 -52488,
 855014824,
 68392,
 -52487,
 855077295,
 68398,
 -52486,
 855141512,
 68368,
 -52485,
 855206485,
 68376,
 -52484,
 855263859,
 68383,
 -1,
 855321945,
 68375,
 -1,
 851057125,
 68409,
 -1,
 851020334,
 129361,
 855651077,
 850969802,
 -1,
 855716611,
 855621691,
 -1,
 -52478,
 855673338,
 128663,
 -1,
 855712725,
 127975,
 -52476,
 855685150,
 8371,
 -1,
 855844813,
 127814,
 856044297,
 855603903,
 -1,
 -52473,
 856005347,
 127994,
 -52472,
 856049165,
 127944,
 -1,
 856107782,
 128657,
 856306445,
 855976834,
 -1,
 856371980,
 856255285,
 983053,
 -1,
 856328112,
 983052,
 -1,
 856293986,
 9190,
 856568592,
 856275483,
 -1,
 -52465,
 856526028,
 9883,
 -1,
 856578419,
 128095,
 856765203,
 856536796,
 -1,
 -52462,
 856730498,
 9954,
 -1,
 856788686,
 128562,
 856961814,
 856725358,
 -1,
 -52459,
 856923049,
 983194,
 -1,
 856959874,
 983195,
 857158425,
 856909611,
 -1,
 -52456,
 857094076,
 128747,
 -1,
 857154162,
 128748,
 -52454,
 857108058,
 8525,
 -1,
 857295626,
 1547,
 857487634,
 746667580,
 -1,
 857552836,
 857427768,
 -1,
 857618371,
 857529050,
 -1,
 857682846,
 857544943,
 -1,
 857748343,
 857608088,
 -1,
 857813807,
 857674771,
 -1,
 857879331,
 857740519,
 77877,
 -1,
 857807087,
 77878,
 858010405,
 857805557,
 77874,
 -1,
 857938159,
 77875,
 858141479,
 857936336,
 77872,
 -1,
 858069231,
 77873,
 858272553,
 858066840,
 77869,
 -1,
 858200303,
 77870,
 -52438,
 858200125,
 77882,
 -52437,
 858331020,
 77881,
 -52436,
 858396332,
 77880,
 -52435,
 858461660,
 77879,
 -52434,
 858526739,
 77876,
 -1,
 858591397,
 77871,
 858796860,
 857739429,
 -1,
 858862386,
 858724012,
 77844,
 -1,
 858790127,
 77845,
 858993460,
 858788883,
 77840,
 -1,
 858921199,
 77841,
 -52427,
 858921021,
 77847,
 -52426,
 859051916,
 77846,
 -52425,
 859117020,
 77843,
 -52424,
 859182311,
 77842,
 -52423,
 859247349,
 77839,
 -52422,
 859312592,
 77838,
 -52421,
 859377829,
 77837,
 -1,
 859443096,
 77836,
 859648841,
 858722200,
 -1,
 859714368,
 859575772,
 77830,
 -52417,
 859645362,
 77832,
 -1,
 859707631,
 77831,
 859910978,
 859641063,
 77828,
 -1,
 859838703,
 77829,
 -52413,
 859838525,
 77835,
 -52412,
 859969420,
 77834,
 -52411,
 860034732,
 77833,
 -52410,
 860099603,
 77827,
 -52409,
 860164853,
 77826,
 -52408,
 860230096,
 77825,
 -1,
 860295333,
 77824,
 860500821,
 859575029,
 -1,
 860566348,
 860426704,
 77860,
 -1,
 860494063,
 77861,
 -52403,
 860493885,
 77868,
 -52402,
 860624780,
 77867,
 -52401,
 860690092,
 77866,
 -52400,
 860755420,
 77865,
 -52399,
 860820711,
 77864,
 -52398,
 860886035,
 77863,
 -52397,
 860951285,
 77862,
 -52396,
 861016229,
 77859,
 -1,
 861081496,
 77858,
 861287264,
 860427740,
 -1,
 -52393,
 861214781,
 77902,
 -52392,
 861280140,
 77901,
 -52391,
 861345452,
 77900,
 -52390,
 861410780,
 77899,
 -52389,
 861476071,
 77898,
 -52388,
 861541395,
 77897,
 -52387,
 861606645,
 77896,
 -52386,
 861671888,
 77895,
 -52385,
 861737125,
 77894,
 -1,
 861802392,
 77893,
 862008171,
 861213927,
 -1,
 -52382,
 861935677,
 77892,
 -52381,
 862001036,
 77891,
 -52380,
 862066348,
 77890,
 -52379,
 862131676,
 77889,
 -52378,
 862196967,
 77888,
 -52377,
 862262291,
 77887,
 -52376,
 862327541,
 77886,
 -52375,
 862392784,
 77885,
 -52374,
 862458021,
 77884,
 -1,
 862523288,
 77883,
 862729078,
 861934032,
 -1,
 -52371,
 862656573,
 77857,
 -52370,
 862721932,
 77856,
 -52369,
 862787244,
 77855,
 -52368,
 862852572,
 77854,
 -52367,
 862917863,
 77853,
 -52366,
 862983187,
 77852,
 -52365,
 863048437,
 77851,
 -52364,
 863113680,
 77850,
 -52363,
 863178917,
 77849,
 -1,
 863244184,
 77848,
 -1,
 862656359,
 77903,
 863567871,
 857676176,
 -1,
 863581060,
 863440792,
 -1,
 863646588,
 863508140,
 78867,
 -52357,
 863577522,
 78869,
 -1,
 863639791,
 78868,
 -52355,
 863574077,
 78871,
 -52354,
 863770508,
 78870,
 -52353,
 863835612,
 78866,
 -52352,
 863900903,
 78865,
 -52351,
 863966227,
 78864,
 -52350,
 864031477,
 78863,
 -52349,
 864096720,
 78862,
 -1,
 864161957,
 78861,
 864367503,
 863506896,
 -1,
 -52346,
 864294973,
 78891,
 -52345,
 864360332,
 78890,
 -52344,
 864425644,
 78889,
 -52343,
 864490972,
 78888,
 -52342,
 864556263,
 78887,
 -52341,
 864621587,
 78886,
 -52340,
 864686837,
 78885,
 -52339,
 864752080,
 78884,
 -52338,
 864817317,
 78883,
 -1,
 864882584,
 78882,
 865088410,
 864293029,
 -1,
 -52335,
 865015869,
 78881,
 -52334,
 865081228,
 78880,
 -52333,
 865146540,
 78879,
 -52332,
 865211868,
 78878,
 -52331,
 865277159,
 78877,
 -52330,
 865342483,
 78876,
 -52329,
 865407733,
 78875,
 -52328,
 865472976,
 78874,
 -52327,
 865538213,
 78873,
 -1,
 865603480,
 78872,
 865861631,
 865014517,
 -1,
 -52324,
 865735120,
 78894,
 -52323,
 865800357,
 78893,
 -1,
 865865624,
 78892,
 866071565,
 857637620,
 -1,
 866137046,
 865996696,
 -1,
 866202543,
 866063093,
 -1,
 866268067,
 866129580,
 78361,
 -1,
 866195695,
 78362,
 866399141,
 866194663,
 78358,
 -1,
 866326767,
 78359,
 866530215,
 866325523,
 78356,
 -1,
 866457839,
 78357,
 866661289,
 866456309,
 78354,
 -1,
 866588911,
 78355,
 -52310,
 866588733,
 78364,
 -52309,
 866719628,
 78363,
 -52308,
 866784732,
 78360,
 -52307,
 866849232,
 78353,
 -52306,
 866914469,
 78352,
 -1,
 866979736,
 78351,
 867185596,
 866128037,
 -1,
 867251123,
 867112844,
 78336,
 -52302,
 867182002,
 78338,
 -1,
 867244271,
 78337,
 -52300,
 867178557,
 78339,
 -52299,
 867374764,
 78335,
 -52298,
 867440092,
 78334,
 -52297,
 867505383,
 78333,
 -52296,
 867570707,
 78332,
 -52295,
 867635957,
 78331,
 -52294,
 867701200,
 78330,
 -52293,
 867766437,
 78329,
 -1,
 867831704,
 78328,
 868037576,
 867111376,
 -1,
 868103103,
 867964135,
 78345,
 -1,
 868030703,
 78346,
 -52288,
 868030525,
 78350,
 -52287,
 868161420,
 78349,
 -52286,
 868226732,
 78348,
 -52285,
 868292060,
 78347,
 -52284,
 868357139,
 78344,
 -52283,
 868422389,
 78343,
 -52282,
 868487632,
 78342,
 -52281,
 868552869,
 78341,
 -1,
 868618136,
 78340,
 868824018,
 867962776,
 -1,
 -52278,
 868751421,
 78327,
 -52277,
 868816780,
 78326,
 -52276,
 868882092,
 78325,
 -52275,
 868947420,
 78324,
 -52274,
 869012711,
 78323,
 -52273,
 869078035,
 78322,
 -52272,
 869143285,
 78321,
 -52271,
 869208528,
 78320,
 -1,
 869273765,
 78319,
 869531647,
 868750355,
 -1,
 -52268,
 869405136,
 78367,
 -52267,
 869470373,
 78366,
 -1,
 869535640,
 78365,
 869741556,
 866108751,
 -1,
 869807077,
 869666981,
 -1,
 869872602,
 869734284,
 78409,
 -1,
 869800175,
 78410,
 870003676,
 869798053,
 78401,
 -1,
 869931247,
 78402,
 870134750,
 869928856,
 78399,
 -1,
 870062319,
 78400,
 -52257,
 870062141,
 78411,
 -52256,
 870192812,
 78408,
 -52255,
 870258140,
 78407,
 -52254,
 870323431,
 78406,
 -52253,
 870388755,
 78405,
 -52252,
 870454005,
 78404,
 -1,
 870519248,
 78403,
 870724591,
 869732248,
 -1,
 -52249,
 870651965,
 78398,
 -52248,
 870717324,
 78397,
 -52247,
 870782636,
 78396,
 -52246,
 870847964,
 78395,
 -52245,
 870913255,
 78394,
 -52244,
 870978579,
 78393,
 -52243,
 871043829,
 78392,
 -52242,
 871109072,
 78391,
 -1,
 871174309,
 78390,
 871432191,
 870650320,
 -1,
 871445490,
 871305680,
 78414,
 -1,
 871373039,
 78415,
 -52237,
 871370917,
 78413,
 -1,
 871501720,
 78412,
 871759871,
 869691131,
 -1,
 871773185,
 871633061,
 -1,
 871838712,
 871700140,
 78385,
 -1,
 871766255,
 78386,
 -52231,
 871766077,
 78388,
 -52230,
 871896972,
 78387,
 -52229,
 871962076,
 78384,
 -52228,
 872027367,
 78383,
 -52227,
 872092691,
 78382,
 -52226,
 872157941,
 78381,
 -52225,
 872223184,
 78380,
 -52224,
 872288421,
 78379,
 -1,
 872353688,
 78378,
 872559628,
 871698328,
 -1,
 872625156,
 872486119,
 78372,
 -1,
 872552687,
 78373,
 -52219,
 872552509,
 78377,
 -52218,
 872683404,
 78376,
 -52217,
 872748716,
 78375,
 -52216,
 872814044,
 78374,
 -52215,
 872879123,
 78371,
 -52214,
 872944373,
 78370,
 -52213,
 873009616,
 78369,
 -1,
 873074853,
 78368,
 -1,
 872485573,
 78389,
 873346161,
 866006624,
 -1,
 873411620,
 873272551,
 -1,
 873477145,
 873336728,
 77997,
 -52207,
 873422033,
 78006,
 -52206,
 873485346,
 78005,
 -52205,
 873549624,
 78004,
 -52204,
 873613752,
 78003,
 -52203,
 873676348,
 78002,
 -52202,
 873739741,
 78001,
 -52201,
 873802626,
 78000,
 -52200,
 873866674,
 77999,
 -1,
 873928943,
 77998,
 874132507,
 873403411,
 78011,
 -1,
 874060015,
 78012,
 874263581,
 874058192,
 78008,
 -1,
 874191087,
 78009,
 -52194,
 874190909,
 78017,
 -52193,
 874321804,
 78016,
 -52192,
 874387116,
 78015,
 -52191,
 874452444,
 78014,
 -52190,
 874517735,
 78013,
 -52189,
 874582773,
 78010,
 -1,
 874647717,
 78007,
 874853429,
 873338332,
 -1,
 874918958,
 874780332,
 78025,
 -52185,
 874861602,
 78033,
 -52184,
 874925880,
 78032,
 -52183,
 874990008,
 78031,
 -52182,
 875052604,
 78030,
 -52181,
 875115997,
 78029,
 -52180,
 875178882,
 78028,
 -52179,
 875242930,
 78027,
 -1,
 875305199,
 78026,
 -52177,
 874845660,
 78024,
 -52176,
 875435239,
 78023,
 -52175,
 875500563,
 78022,
 -52174,
 875565813,
 78021,
 -52173,
 875631056,
 78020,
 -52172,
 875696293,
 78019,
 -1,
 875761560,
 78018,
 875967554,
 874779667,
 -1,
 876033080,
 875894668,
 77994,
 -1,
 875960559,
 77995,
 876164154,
 875959772,
 77991,
 -1,
 876091631,
 77992,
 -52165,
 876091453,
 77996,
 -52164,
 876222124,
 77993,
 -52163,
 876287207,
 77990,
 -52162,
 876352531,
 77989,
 -52161,
 876417781,
 77988,
 -52160,
 876483024,
 77987,
 -52159,
 876548261,
 77986,
 -1,
 876613528,
 77985,
 876819535,
 875893493,
 -1,
 876885061,
 876745747,
 77978,
 -1,
 876812527,
 77979,
 877016135,
 876810405,
 77974,
 -1,
 876943599,
 77975,
 -52152,
 876943421,
 77984,
 -52151,
 877074316,
 77983,
 -52150,
 877139628,
 77982,
 -52149,
 877204956,
 77981,
 -52148,
 877270247,
 77980,
 -52147,
 877335285,
 77977,
 -52146,
 877400528,
 77976,
 -1,
 877465496,
 77973,
 877671515,
 876745168,
 -1,
 877737042,
 877598380,
 77969,
 -1,
 877664495,
 77970,
 -52141,
 877664317,
 77972,
 -52140,
 877795212,
 77971,
 -52139,
 877860316,
 77968,
 -52138,
 877925607,
 77967,
 -52137,
 877990931,
 77966,
 -52136,
 878056181,
 77965,
 -52135,
 878121424,
 77964,
 -52134,
 878186661,
 77963,
 -1,
 878251928,
 77962,
 878457958,
 877596837,
 -1,
 -52131,
 878385213,
 77961,
 -52130,
 878450572,
 77960,
 -52129,
 878515884,
 77959,
 -52128,
 878581212,
 77958,
 -52127,
 878646503,
 77957,
 -52126,
 878711827,
 77956,
 -52125,
 878777077,
 77955,
 -52124,
 878842320,
 77954,
 -52123,
 878907557,
 77953,
 -1,
 878972824,
 77952,
 879230975,
 878383000,
 -1,
 879244393,
 879105932,
 77949,
 -1,
 879171823,
 77950,
 -52118,
 879171645,
 77951,
 -52117,
 879302316,
 77948,
 -52116,
 879367644,
 77947,
 -52115,
 879432935,
 77946,
 -52114,
 879498259,
 77945,
 -52113,
 879563509,
 77944,
 -52112,
 879628752,
 77943,
 -1,
 879693989,
 77942,
 879899843,
 873319565,
 -1,
 879965324,
 879825360,
 -1,
 880030848,
 879890328,
 78726,
 -52107,
 879980231,
 78738,
 -52106,
 880044853,
 78737,
 -52105,
 880110089,
 78736,
 -52104,
 880172241,
 78735,
 -52103,
 880235554,
 78734,
 -52102,
 880299832,
 78733,
 -52101,
 880363960,
 78732,
 -52100,
 880426556,
 78731,
 -52099,
 880489949,
 78730,
 -52098,
 880552834,
 78729,
 -52097,
 880616882,
 78728,
 -1,
 880679151,
 78727,
 880882818,
 879958077,
 78749,
 -1,
 880810223,
 78750,
 881013892,
 880809868,
 78747,
 -1,
 880941295,
 78748,
 881144966,
 880939765,
 78741,
 -1,
 881072367,
 78742,
 -52089,
 881071788,
 78746,
 -52088,
 881202652,
 78745,
 -52087,
 881267943,
 78744,
 -52086,
 881333267,
 78743,
 -52085,
 881398224,
 78740,
 -1,
 881463461,
 78739,
 881669282,
 879890328,
 -1,
 881734807,
 881594533,
 78690,
 -52081,
 881679569,
 78699,
 -52080,
 881742882,
 78698,
 -52079,
 881807160,
 78697,
 -52078,
 881871288,
 78696,
 -52077,
 881933884,
 78695,
 -52076,
 881997277,
 78694,
 -52075,
 882060162,
 78693,
 -52074,
 882124210,
 78692,
 -1,
 882186479,
 78691,
 882390170,
 881661612,
 78706,
 -52071,
 882320818,
 78708,
 -1,
 882383087,
 78707,
 882586780,
 882315728,
 78700,
 -1,
 882514159,
 78701,
 -52067,
 882513981,
 78710,
 -52066,
 882644876,
 78709,
 -52065,
 882709980,
 78705,
 -52064,
 882775271,
 78704,
 -52063,
 882840595,
 78703,
 -1,
 882905845,
 78702,
 883111090,
 881594533,
 -1,
 883176615,
 883036325,
 78712,
 -52059,
 883108738,
 78715,
 -52058,
 883172786,
 78714,
 -1,
 883235055,
 78713,
 883438762,
 883102160,
 78716,
 -52055,
 883369394,
 78718,
 -1,
 883431663,
 78717,
 -52053,
 883365949,
 78725,
 -52052,
 883562380,
 78724,
 -52051,
 883627692,
 78723,
 -52050,
 883693020,
 78722,
 -52049,
 883758311,
 78721,
 -52048,
 883823635,
 78720,
 -52047,
 883888885,
 78719,
 -1,
 883953560,
 78711,
 884159681,
 883036917,
 -1,
 884225205,
 884086444,
 78761,
 -1,
 884152559,
 78762,
 884356279,
 884151029,
 78756,
 -1,
 884283631,
 78757,
 884487353,
 884281509,
 78753,
 -1,
 884414703,
 78754,
 884618427,
 884412312,
 78751,
 -1,
 884545775,
 78752,
 -52036,
 884545597,
 78764,
 -52035,
 884676492,
 78763,
 -52034,
 884741596,
 78760,
 -52033,
 884806887,
 78759,
 -52032,
 884872211,
 78758,
 -1,
 884937168,
 78755,
 885194751,
 884085970,
 78765,
 -1,
 885070063,
 78766,
 885273877,
 879856096,
 -1,
 885339350,
 885198744,
 -1,
 885404876,
 885265884,
 78423,
 -52025,
 885344696,
 78429,
 -52024,
 885407292,
 78428,
 -52023,
 885470685,
 78427,
 -52022,
 885533570,
 78426,
 -52021,
 885597618,
 78425,
 -1,
 885659887,
 78424,
 885863630,
 885331175,
 78421,
 -1,
 885790959,
 78422,
 885994704,
 885788837,
 78416,
 -1,
 885922031,
 78417,
 -52015,
 885921853,
 78432,
 -52014,
 886052748,
 78431,
 -52013,
 886118060,
 78430,
 -52012,
 886182931,
 78420,
 -52011,
 886248181,
 78419,
 -1,
 886313424,
 78418,
 886519015,
 885265141,
 -1,
 886584540,
 886445532,
 78469,
 -52007,
 886519261,
 78473,
 -52006,
 886582146,
 78472,
 -52005,
 886646194,
 78471,
 -1,
 886708463,
 78470,
 886912222,
 886510325,
 78465,
 -1,
 886839535,
 78466,
 887043296,
 886837144,
 78461,
 -1,
 886970607,
 78462,
 -51999,
 886970429,
 78476,
 -51998,
 887101324,
 78475,
 -51997,
 887166636,
 78474,
 -51996,
 887231719,
 78468,
 -51995,
 887297043,
 78467,
 -51994,
 887362000,
 78464,
 -1,
 887427237,
 78463,
 887633142,
 886444496,
 -1,
 887698666,
 887560253,
 78459,
 -1,
 887625967,
 78460,
 887829740,
 887624935,
 78454,
 -1,
 887757039,
 78455,
 887960814,
 887755795,
 78452,
 -1,
 887888111,
 78453,
 888091888,
 887885720,
 78447,
 -1,
 888019183,
 78448,
 -51983,
 888018828,
 78458,
 -51982,
 888149676,
 78457,
 -51981,
 888215004,
 78456,
 -51980,
 888279797,
 78451,
 -51979,
 888345040,
 78450,
 -1,
 888410277,
 78449,
 888616197,
 887558309,
 -1,
 888681723,
 888541080,
 78433,
 -51975,
 888613762,
 78436,
 -51974,
 888677810,
 78435,
 -1,
 888740079,
 78434,
 888943869,
 888608829,
 78445,
 -1,
 888871151,
 78446,
 -51970,
 888870796,
 78444,
 -51969,
 889001644,
 78443,
 -51968,
 889066972,
 78442,
 -51967,
 889132263,
 78441,
 -51966,
 889197587,
 78440,
 -51965,
 889262837,
 78439,
 -51964,
 889328080,
 78438,
 -1,
 889393317,
 78437,
 889599248,
 888542227,
 -1,
 -51961,
 889526333,
 78486,
 -51960,
 889591692,
 78485,
 -51959,
 889657004,
 78484,
 -51958,
 889722332,
 78483,
 -51957,
 889787623,
 78482,
 -51956,
 889852947,
 78481,
 -51955,
 889918197,
 78480,
 -51954,
 889983440,
 78479,
 -51953,
 890048677,
 78478,
 -1,
 890113944,
 78477,
 890372095,
 889525479,
 -1,
 890385684,
 890245016,
 78487,
 -51949,
 890316210,
 78489,
 -1,
 890378479,
 78488,
 -1,
 890310821,
 78490,
 890647901,
 885226258,
 -1,
 890713389,
 890572965,
 -1,
 890778912,
 890638800,
 78268,
 -51943,
 890721314,
 78276,
 -51942,
 890785592,
 78275,
 -51941,
 890849720,
 78274,
 -51940,
 890912316,
 78273,
 -51939,
 890975709,
 78272,
 -51938,
 891038594,
 78271,
 -51937,
 891102642,
 78270,
 -1,
 891164911,
 78269,
 891368738,
 890705580,
 78283,
 -1,
 891295983,
 78284,
 891499812,
 891295196,
 78281,
 -1,
 891427055,
 78282,
 891630886,
 891426023,
 78279,
 -1,
 891558127,
 78280,
 891761960,
 891555736,
 78265,
 -1,
 891689199,
 78266,
 -51927,
 891689021,
 78286,
 -51926,
 891819916,
 78285,
 -51925,
 891884563,
 78278,
 -51924,
 891949813,
 78277,
 -1,
 892014757,
 78267,
 892220731,
 890639093,
 -1,
 892286257,
 892146421,
 78304,
 -51920,
 892216754,
 78306,
 -1,
 892279023,
 78305,
 892482867,
 892211365,
 78301,
 -1,
 892410095,
 78302,
 -51916,
 892409917,
 78312,
 -51915,
 892540812,
 78311,
 -51914,
 892606124,
 78310,
 -51913,
 892671452,
 78309,
 -51912,
 892736743,
 78308,
 -51911,
 892802067,
 78307,
 -51910,
 892867024,
 78303,
 -1,
 892931992,
 78300,
 893138249,
 892146128,
 -1,
 893203774,
 893065100,
 78297,
 -1,
 893130991,
 78298,
 893334848,
 893129747,
 78292,
 -1,
 893262063,
 78293,
 893465922,
 893260240,
 78289,
 -1,
 893393135,
 78290,
 -51901,
 893392957,
 78299,
 -51900,
 893523628,
 78296,
 -51899,
 893588956,
 78295,
 -51898,
 893654247,
 78294,
 -51897,
 893719285,
 78291,
 -51896,
 893784229,
 78288,
 -1,
 893849496,
 78287,
 894055766,
 893063064,
 -1,
 894121293,
 893980837,
 78253,
 -51892,
 894051762,
 78255,
 -1,
 894114031,
 78254,
 894317903,
 894046965,
 78257,
 -1,
 894245103,
 78258,
 -51888,
 894244925,
 78264,
 -51887,
 894375820,
 78263,
 -51886,
 894441132,
 78262,
 -51885,
 894506460,
 78261,
 -51884,
 894571751,
 78260,
 -51883,
 894637075,
 78259,
 -1,
 894702032,
 78256,
 894959615,
 893981715,
 -1,
 894973273,
 894832536,
 78313,
 -1,
 894900463,
 78314,
 -51878,
 894899219,
 78318,
 -51877,
 895030005,
 78317,
 -51876,
 895095248,
 78316,
 -1,
 895160485,
 78315,
 895366565,
 890587647,
 -1,
 895432044,
 895292435,
 -1,
 895497569,
 895358636,
 78132,
 -1,
 895424751,
 78133,
 895628643,
 895423964,
 78130,
 -1,
 895555823,
 78131,
 895759717,
 895554791,
 78128,
 -1,
 895686895,
 78129,
 -51866,
 895686717,
 78135,
 -51865,
 895817612,
 78134,
 -51864,
 895882259,
 78127,
 -51863,
 895947509,
 78126,
 -51862,
 896012752,
 78125,
 -51861,
 896077989,
 78124,
 -1,
 896143256,
 78123,
 896349562,
 895357685,
 -1,
 896415087,
 896276364,
 78120,
 -1,
 896342255,
 78121,
 896546161,
 896341676,
 78118,
 -1,
 896473327,
 78119,
 896677235,
 896471205,
 78111,
 -1,
 896604399,
 78112,
 -51852,
 896604221,
 78122,
 -51851,
 896734684,
 78117,
 -51850,
 896799975,
 78116,
 -51849,
 896865299,
 78115,
 -51848,
 896930549,
 78114,
 -51847,
 896995792,
 78113,
 -1,
 897060760,
 78110,
 897267078,
 896274896,
 -1,
 897332605,
 897192101,
 78100,
 -1,
 897259759,
 78101,
 -51842,
 897259581,
 78109,
 -51841,
 897390476,
 78108,
 -51840,
 897455788,
 78107,
 -51839,
 897521116,
 78106,
 -51838,
 897586407,
 78105,
 -51837,
 897651731,
 78104,
 -51836,
 897716981,
 78103,
 -51835,
 897782224,
 78102,
 -1,
 897847192,
 78099,
 898053522,
 897192101,
 -1,
 898119049,
 897979125,
 78091,
 -1,
 898046191,
 78092,
 -51830,
 898046013,
 78098,
 -51829,
 898176908,
 78097,
 -51828,
 898242220,
 78096,
 -51827,
 898307548,
 78095,
 -51826,
 898372839,
 78094,
 -51825,
 898438163,
 78093,
 -51824,
 898503120,
 78090,
 -51823,
 898568357,
 78089,
 -1,
 898633624,
 78088,
 898839965,
 897978264,
 -1,
 898905493,
 898764965,
 78078,
 -1,
 898832623,
 78079,
 -51818,
 898832445,
 78087,
 -51817,
 898963340,
 78086,
 -51816,
 899028652,
 78085,
 -51815,
 899093980,
 78084,
 -51814,
 899159271,
 78083,
 -51813,
 899224595,
 78082,
 -51812,
 899289845,
 78081,
 -1,
 899355088,
 78080,
 899612671,
 898766055,
 -1,
 899626402,
 899485861,
 78137,
 -51808,
 899558274,
 78140,
 -51807,
 899622322,
 78139,
 -1,
 899684591,
 78138,
 -51805,
 899551989,
 78142,
 -51804,
 899813840,
 78141,
 -1,
 899878808,
 78136,
 900085228,
 895307643,
 -1,
 900150707,
 900011027,
 -1,
 900216233,
 900076775,
 78196,
 -1,
 900143343,
 78197,
 900347307,
 900141813,
 78193,
 -1,
 900274415,
 78194,
 -51796,
 900274237,
 78201,
 -51795,
 900405132,
 78200,
 -51794,
 900470444,
 78199,
 -51793,
 900535772,
 78198,
 -51792,
 900600851,
 78195,
 -51791,
 900665808,
 78192,
 -51790,
 900731045,
 78191,
 -1,
 900796312,
 78190,
 901002688,
 900076277,
 -1,
 901068214,
 900929196,
 78186,
 -1,
 900995311,
 78187,
 901199288,
 900994524,
 78184,
 -1,
 901126383,
 78185,
 -51783,
 901126205,
 78189,
 -51782,
 901257100,
 78188,
 -51781,
 901321959,
 78183,
 -51780,
 901387283,
 78182,
 -51779,
 901452533,
 78181,
 -51778,
 901517776,
 78180,
 -51777,
 901583013,
 78179,
 -1,
 901648280,
 78178,
 901854669,
 900927952,
 -1,
 901920195,
 901780956,
 78173,
 -1,
 901847279,
 78174,
 902051269,
 901844888,
 78166,
 -1,
 901978351,
 78167,
 -51770,
 901978173,
 78177,
 -51769,
 902109068,
 78176,
 -51768,
 902174380,
 78175,
 -51767,
 902239463,
 78172,
 -51766,
 902304787,
 78171,
 -51765,
 902370037,
 78170,
 -51764,
 902435280,
 78169,
 -1,
 902500517,
 78168,
 902706650,
 901779352,
 -1,
 902772177,
 902633132,
 78150,
 -51760,
 902702514,
 78152,
 -1,
 902764783,
 78151,
 902968787,
 902698460,
 78148,
 -1,
 902895855,
 78149,
 -51756,
 902895677,
 78154,
 -51755,
 903026572,
 78153,
 -51754,
 903091431,
 78147,
 -51753,
 903156755,
 78146,
 -51752,
 903222005,
 78145,
 -51751,
 903287248,
 78144,
 -1,
 903352485,
 78143,
 903558630,
 902631589,
 -1,
 903624157,
 903483557,
 78156,
 -1,
 903551215,
 78157,
 -51746,
 903551037,
 78165,
 -51745,
 903681932,
 78164,
 -51744,
 903747244,
 78163,
 -51743,
 903812572,
 78162,
 -51742,
 903877863,
 78161,
 -51741,
 903943187,
 78160,
 -51740,
 904008437,
 78159,
 -51739,
 904073680,
 78158,
 -1,
 904138648,
 78155,
 904396799,
 903484647,
 -1,
 -51736,
 904270867,
 78206,
 -51735,
 904336117,
 78205,
 -51734,
 904401360,
 78204,
 -51733,
 904466597,
 78203,
 -1,
 904531864,
 78202,
 904738344,
 900050460,
 -1,
 904803835,
 904663205,
 -1,
 904869361,
 904729619,
 78560,
 -51728,
 904799666,
 78562,
 -1,
 904861935,
 78561,
 905065971,
 904795820,
 78565,
 -1,
 904993007,
 78566,
 -51724,
 904992829,
 78568,
 -51723,
 905123724,
 78567,
 -51722,
 905188828,
 78564,
 -51721,
 905254119,
 78563,
 -51720,
 905319157,
 78559,
 -51719,
 905384400,
 78558,
 -51718,
 905449637,
 78557,
 -1,
 905514904,
 78556,
 905721352,
 904729040,
 -1,
 905786879,
 905647580,
 78575,
 -51714,
 905717170,
 78577,
 -1,
 905779439,
 78576,
 -51712,
 905713725,
 78580,
 -51711,
 905910156,
 78579,
 -51710,
 905975468,
 78578,
 -51709,
 906040551,
 78574,
 -51708,
 906105875,
 78573,
 -51707,
 906171125,
 78572,
 -51706,
 906236368,
 78571,
 -51705,
 906301605,
 78570,
 -1,
 906366872,
 78569,
 906573332,
 905646837,
 -1,
 906638859,
 906499303,
 78586,
 -1,
 906565871,
 78587,
 -51700,
 906565693,
 78591,
 -51699,
 906696588,
 78590,
 -51698,
 906761900,
 78589,
 -51697,
 906827228,
 78588,
 -51696,
 906892307,
 78585,
 -51695,
 906957557,
 78584,
 -51694,
 907022800,
 78583,
 -51693,
 907088037,
 78582,
 -1,
 907153304,
 78581,
 907359776,
 906497944,
 -1,
 907425303,
 907285980,
 78551,
 -1,
 907352303,
 78552,
 907556377,
 907350480,
 78546,
 -1,
 907483375,
 78547,
 -51686,
 907483197,
 78555,
 -51685,
 907614092,
 78554,
 -51684,
 907679404,
 78553,
 -51683,
 907744487,
 78550,
 -51682,
 907809811,
 78549,
 -51681,
 907875061,
 78548,
 -1,
 907940005,
 78545,
 908197887,
 907285523,
 -1,
 -51678,
 908072412,
 78598,
 -51677,
 908137703,
 78597,
 -51676,
 908203027,
 78596,
 -51675,
 908268277,
 78595,
 -51674,
 908333520,
 78594,
 -51673,
 908398757,
 78593,
 -1,
 908464024,
 78592,
 908670557,
 904709455,
 -1,
 908736054,
 908595664,
 -1,
 908801580,
 908662845,
 78674,
 -1,
 908728559,
 78675,
 908932654,
 908727029,
 78667,
 -1,
 908859631,
 78668,
 -51665,
 908859276,
 78673,
 -51664,
 908990124,
 78672,
 -51663,
 909055452,
 78671,
 -51662,
 909120743,
 78670,
 -51661,
 909186067,
 78669,
 -51660,
 909251024,
 78666,
 -51659,
 909316261,
 78665,
 -1,
 909381528,
 78664,
 909588034,
 908661493,
 -1,
 909653561,
 909513168,
 78678,
 -1,
 909580527,
 78679,
 -51654,
 909580349,
 78686,
 -51653,
 909711244,
 78685,
 -51652,
 909776556,
 78684,
 -51651,
 909841884,
 78683,
 -51650,
 909907175,
 78682,
 -51649,
 909972499,
 78681,
 -51648,
 910037749,
 78680,
 -51647,
 910102693,
 78677,
 -1,
 910167960,
 78676,
 910374478,
 909512600,
 -1,
 910440006,
 910300636,
 78648,
 -51643,
 910370226,
 78650,
 -1,
 910432495,
 78649,
 -51641,
 910366781,
 78653,
 -51640,
 910563212,
 78652,
 -51639,
 910628524,
 78651,
 -51638,
 910693607,
 78647,
 -51637,
 910758931,
 78646,
 -51636,
 910824181,
 78645,
 -51635,
 910889424,
 78644,
 -1,
 910954661,
 78643,
 911160921,
 910299301,
 -1,
 -51632,
 911087677,
 78663,
 -51631,
 911153036,
 78662,
 -51630,
 911218348,
 78661,
 -51629,
 911283676,
 78660,
 -51628,
 911348967,
 78659,
 -51627,
 911414291,
 78658,
 -51626,
 911479541,
 78657,
 -51625,
 911544784,
 78656,
 -51624,
 911610021,
 78655,
 -1,
 911675288,
 78654,
 911933439,
 911086611,
 -1,
 -51621,
 911806928,
 78689,
 -51620,
 911872165,
 78688,
 -1,
 911937432,
 78687,
 912144014,
 908638874,
 -1,
 912209516,
 912068504,
 -1,
 912275041,
 912136253,
 78610,
 -1,
 912201967,
 78611,
 912406115,
 912201612,
 78608,
 -1,
 912333039,
 78609,
 912537189,
 912332460,
 78606,
 -1,
 912464111,
 78607,
 912668263,
 912462581,
 78601,
 -1,
 912595183,
 78602,
 -51608,
 912594396,
 78605,
 -51607,
 912725223,
 78604,
 -51606,
 912790547,
 78603,
 -51605,
 912855504,
 78600,
 -1,
 912920741,
 78599,
 913127033,
 912134309,
 -1,
 913192559,
 913053148,
 78619,
 -1,
 913119471,
 78620,
 913323633,
 913117349,
 78613,
 -1,
 913250543,
 78614,
 -51598,
 913250365,
 78623,
 -51597,
 913381260,
 78622,
 -51596,
 913446572,
 78621,
 -51595,
 913511655,
 78618,
 -51594,
 913576979,
 78617,
 -51593,
 913642229,
 78616,
 -51592,
 913707472,
 78615,
 -1,
 913772440,
 78612,
 913979012,
 913052112,
 -1,
 -51589,
 913905725,
 78633,
 -51588,
 913971084,
 78632,
 -51587,
 914036396,
 78631,
 -51586,
 914101724,
 78630,
 -51585,
 914167015,
 78629,
 -51584,
 914232339,
 78628,
 -51583,
 914297589,
 78627,
 -51582,
 914362832,
 78626,
 -51581,
 914428069,
 78625,
 -1,
 914493336,
 78624,
 914751487,
 913904373,
 -1,
 914765447,
 914625269,
 78638,
 -1,
 914692335,
 78639,
 914896521,
 914690512,
 78636,
 -1,
 914823407,
 78637,
 -51574,
 914822620,
 78642,
 -51573,
 914953447,
 78641,
 -51572,
 915018771,
 78640,
 -51571,
 915083429,
 78635,
 -1,
 915148696,
 78634,
 915355327,
 912080701,
 -1,
 915420828,
 915280336,
 -1,
 915486354,
 915347340,
 78066,
 -1,
 915413231,
 78067,
 915617428,
 915410840,
 78057,
 -1,
 915544303,
 78058,
 -51563,
 915544125,
 78068,
 -51562,
 915674796,
 78065,
 -51561,
 915740124,
 78064,
 -51560,
 915805415,
 78063,
 -51559,
 915870739,
 78062,
 -51558,
 915935989,
 78061,
 -51557,
 916001232,
 78060,
 -1,
 916066469,
 78059,
 916272809,
 915345573,
 -1,
 916338335,
 916199084,
 78053,
 -1,
 916265199,
 78054,
 916469409,
 916264412,
 78051,
 -1,
 916396271,
 78052,
 -51550,
 916396093,
 78056,
 -51549,
 916526988,
 78055,
 -51548,
 916591847,
 78050,
 -51547,
 916657171,
 78049,
 -51546,
 916722421,
 78048,
 -51545,
 916787664,
 78047,
 -51544,
 916852901,
 78046,
 -1,
 916918168,
 78045,
 917124789,
 916197272,
 -1,
 917190316,
 917051453,
 78043,
 -1,
 917117167,
 78044,
 917321390,
 917116812,
 78041,
 -1,
 917248239,
 78042,
 -51537,
 917247660,
 78040,
 -51536,
 917378524,
 78039,
 -51535,
 917443815,
 78038,
 -51534,
 917509139,
 78037,
 -51533,
 917574389,
 78036,
 -51532,
 917639632,
 78035,
 -1,
 917704869,
 78034,
 917962751,
 917050101,
 -1,
 917976760,
 917836819,
 78073,
 -1,
 917903599,
 78074,
 -51527,
 917903244,
 78077,
 -51526,
 918034092,
 78076,
 -51525,
 918099420,
 78075,
 -51524,
 918164213,
 78072,
 -51523,
 918229456,
 78071,
 -51522,
 918294693,
 78070,
 -1,
 918359960,
 78069,
 918566635,
 915331897,
 -1,
 918632153,
 918491301,
 -1,
 918697675,
 918557927,
 78842,
 -51517,
 918641873,
 78851,
 -51516,
 918705186,
 78850,
 -51515,
 918769464,
 78849,
 -51514,
 918833592,
 78848,
 -51513,
 918896188,
 78847,
 -51512,
 918959581,
 78846,
 -51511,
 919022466,
 78845,
 -51510,
 919086514,
 78844,
 -1,
 919148783,
 78843,
 919353044,
 918623708,
 78852,
 -51507,
 919295010,
 78860,
 -51506,
 919359288,
 78859,
 -51505,
 919423416,
 78858,
 -51504,
 919486012,
 78857,
 -51503,
 919549405,
 78856,
 -51502,
 919612290,
 78855,
 -51501,
 919676338,
 78854,
 -1,
 919738607,
 78853,
 -51499,
 919278611,
 78841,
 -51498,
 919868149,
 78840,
 -51497,
 919933392,
 78839,
 -51496,
 919998629,
 78838,
 -1,
 920063896,
 78837,
 920322047,
 918556568,
 -1,
 920336095,
 920195536,
 78821,
 -51492,
 920270301,
 78825,
 -51491,
 920333186,
 78824,
 -51490,
 920397234,
 78823,
 -1,
 920459503,
 78822,
 920663778,
 920261365,
 78826,
 -51487,
 920593842,
 78828,
 -1,
 920656111,
 78827,
 920860388,
 920589543,
 78831,
 -1,
 920787183,
 78832,
 920991462,
 920785939,
 78829,
 -1,
 920918255,
 78830,
 -51481,
 920918077,
 78836,
 -51480,
 921048972,
 78835,
 -51479,
 921114284,
 78834,
 -51478,
 921179612,
 78833,
 -1,
 921243813,
 78820,
 921450257,
 918528351,
 -1,
 921515769,
 921374885,
 -1,
 921581295,
 921441756,
 78530,
 -1,
 921508079,
 78531,
 921712369,
 921505688,
 78523,
 -1,
 921639151,
 78524,
 -51470,
 921638973,
 78534,
 -51469,
 921769868,
 78533,
 -51468,
 921835180,
 78532,
 -51467,
 921900263,
 78529,
 -51466,
 921965587,
 78528,
 -51465,
 922030837,
 78527,
 -51464,
 922096080,
 78526,
 -1,
 922161317,
 78525,
 922367750,
 921440152,
 -1,
 922433277,
 922292981,
 78514,
 -51460,
 922363314,
 78516,
 -1,
 922425583,
 78515,
 922629887,
 922358224,
 78512,
 -1,
 922556655,
 78513,
 -51456,
 922556477,
 78522,
 -51455,
 922687372,
 78521,
 -51454,
 922752684,
 78520,
 -51453,
 922818012,
 78519,
 -51452,
 922883303,
 78518,
 -51451,
 922948627,
 78517,
 -1,
 923013285,
 78511,
 923271167,
 922292688,
 -1,
 -51448,
 923146301,
 78544,
 -51447,
 923211660,
 78543,
 -51446,
 923276972,
 78542,
 -51445,
 923342300,
 78541,
 -51444,
 923407591,
 78540,
 -51443,
 923472915,
 78539,
 -51442,
 923538165,
 78538,
 -51441,
 923603408,
 78537,
 -51440,
 923668645,
 78536,
 -1,
 923733912,
 78535,
 923940661,
 921424201,
 -1,
 924006177,
 923865253,
 -1,
 924071701,
 923932556,
 78789,
 -1,
 923998447,
 78790,
 924202775,
 923997868,
 78787,
 -1,
 924129519,
 78788,
 924333849,
 924128275,
 78783,
 -1,
 924260591,
 78784,
 924464923,
 924258200,
 78778,
 -1,
 924391663,
 78779,
 -51428,
 924391485,
 78791,
 -51427,
 924521948,
 78786,
 -51426,
 924587239,
 78785,
 -51425,
 924652277,
 78782,
 -51424,
 924717520,
 78781,
 -1,
 924782757,
 78780,
 924989229,
 923930520,
 -1,
 925054756,
 924915773,
 78776,
 -1,
 924981487,
 78777,
 925185830,
 924979957,
 78769,
 -1,
 925112559,
 78770,
 -51417,
 925112204,
 78775,
 -51416,
 925243052,
 78774,
 -51415,
 925308380,
 78773,
 -51414,
 925373671,
 78772,
 -51413,
 925438995,
 78771,
 -51412,
 925503952,
 78768,
 -1,
 925569189,
 78767,
 925827071,
 924914128,
 -1,
 925841200,
 925701139,
 78796,
 -1,
 925767919,
 78797,
 -51407,
 925766887,
 78798,
 -51406,
 925897461,
 78795,
 -51405,
 925962704,
 78794,
 -51404,
 926027941,
 78793,
 -1,
 926093208,
 78792,
 926299989,
 923872173,
 -1,
 926365507,
 926224280,
 -1,
 926431035,
 926290384,
 77915,
 -51399,
 926362498,
 77918,
 -51398,
 926426546,
 77917,
 -1,
 926488815,
 77916,
 -51396,
 926357565,
 77925,
 -51395,
 926619532,
 77924,
 -51394,
 926684844,
 77923,
 -51393,
 926750172,
 77922,
 -51392,
 926815463,
 77921,
 -51391,
 926880787,
 77920,
 -51390,
 926946037,
 77919,
 -1,
 927010981,
 77914,
 927217487,
 926290085,
 -1,
 927283014,
 927141784,
 77926,
 -1,
 927209711,
 77927,
 -51385,
 927209533,
 77936,
 -51384,
 927340428,
 77935,
 -51383,
 927405740,
 77934,
 -51382,
 927471068,
 77933,
 -51381,
 927536359,
 77932,
 -51380,
 927601683,
 77931,
 -51379,
 927666933,
 77930,
 -51378,
 927732176,
 77929,
 -1,
 927797413,
 77928,
 928055295,
 927142352,
 -1,
 -51375,
 927929363,
 77941,
 -51374,
 927994613,
 77940,
 -51373,
 928059856,
 77939,
 -51372,
 928125093,
 77938,
 -1,
 928190360,
 77937,
 928397163,
 926244176,
 -1,
 928462690,
 928321432,
 -1,
 928528217,
 928389181,
 78225,
 -1,
 928454895,
 78226,
 928659291,
 928453863,
 78220,
 -1,
 928585967,
 78221,
 -51364,
 928585612,
 78224,
 -51363,
 928716460,
 78223,
 -51362,
 928781788,
 78222,
 -51361,
 928846867,
 78219,
 -51360,
 928912117,
 78218,
 -51359,
 928977360,
 78217,
 -1,
 929042597,
 78216,
 929300479,
 928387237,
 -1,
 929314661,
 929173669,
 78229,
 -1,
 929241327,
 78230,
 929445735,
 929238936,
 78227,
 -1,
 929372399,
 78228,
 -51352,
 929371367,
 78234,
 -51351,
 929502227,
 78233,
 -51350,
 929567477,
 78232,
 -1,
 929632720,
 78231,
 929838971,
 928356313,
 -1,
 929904504,
 929763224,
 -1,
 929970031,
 929829621,
 78494,
 -1,
 929896687,
 78495,
 930101105,
 929894565,
 78491,
 -1,
 930027759,
 78492,
 -51342,
 930027581,
 78501,
 -51341,
 930158476,
 78500,
 -51340,
 930223788,
 78499,
 -51339,
 930289116,
 78498,
 -51338,
 930354407,
 78497,
 -51337,
 930419731,
 78496,
 -1,
 930484688,
 78493,
 930742271,
 929829029,
 -1,
 -51334,
 930615461,
 78503,
 -1,
 930680728,
 78502,
 930887560,
 929814524,
 -1,
 930953087,
 930812947,
 78802,
 -51330,
 930882994,
 78804,
 -1,
 930945263,
 78803,
 931149697,
 930879372,
 78809,
 -1,
 931076335,
 78810,
 931280771,
 931075548,
 78806,
 -1,
 931207407,
 78807,
 -51324,
 931206828,
 78808,
 -51323,
 931337447,
 78805,
 -51322,
 931402485,
 78801,
 -51321,
 931467728,
 78800,
 -1,
 931532965,
 78799,
 931739539,
 930836222,
 -1,
 931805067,
 931665372,
 78249,
 -1,
 931731695,
 78250,
 931936141,
 931729872,
 78244,
 -1,
 931862767,
 78245,
 -51314,
 931862412,
 78252,
 -51313,
 931993260,
 78251,
 -51312,
 932058343,
 78248,
 -51311,
 932123667,
 78247,
 -51310,
 932188917,
 78246,
 -1,
 932253861,
 78243,
 932460446,
 931669444,
 -1,
 932525974,
 932386023,
 77908,
 -1,
 932452591,
 77909,
 -51305,
 932452413,
 77913,
 -51304,
 932583308,
 77912,
 -51303,
 932648620,
 77911,
 -51302,
 932713948,
 77910,
 -51301,
 932779027,
 77907,
 -51300,
 932844277,
 77906,
 -51299,
 932909520,
 77905,
 -1,
 932974757,
 77904,
 933181352,
 932436264,
 -1,
 933246881,
 933105829,
 78811,
 -1,
 933173487,
 78812,
 -51294,
 933173132,
 78819,
 -51293,
 933303980,
 78818,
 -51292,
 933369308,
 78817,
 -51291,
 933434599,
 78816,
 -51290,
 933499923,
 78815,
 -51289,
 933565173,
 78814,
 -1,
 933630416,
 78813,
 933836722,
 933123124,
 -1,
 933902251,
 933762524,
 78212,
 -1,
 933828847,
 78213,
 -51284,
 933828492,
 78215,
 -51283,
 933959340,
 78214,
 -51282,
 934024423,
 78211,
 -51281,
 934089747,
 78210,
 -51280,
 934154997,
 78209,
 -51279,
 934220240,
 78208,
 -1,
 934285477,
 78207,
 934492091,
 933784434,
 -1,
 -51276,
 934418316,
 78242,
 -51275,
 934483628,
 78241,
 -51274,
 934548956,
 78240,
 -51273,
 934614247,
 78239,
 -51272,
 934679571,
 78238,
 -51271,
 934744821,
 78237,
 -51270,
 934810064,
 78236,
 -1,
 934875301,
 78235,
 935133183,
 934453094,
 -1,
 -51267,
 935007916,
 78510,
 -51266,
 935073244,
 78509,
 -51265,
 935138535,
 78508,
 -51264,
 935203859,
 78507,
 -51263,
 935269109,
 78506,
 -51262,
 935334352,
 78505,
 -1,
 935399589,
 78504,
 -1,
 857558840,
 129370,
 935671942,
 857520667,
 -1,
 935737476,
 935614717,
 -1,
 935802994,
 935701900,
 -1,
 935868529,
 935778914,
 -1,
 935933923,
 935799682,
 -1,
 935999457,
 935865218,
 -1,
 936064986,
 935941154,
 -1,
 936130515,
 936006690,
 -1,
 936196046,
 936066620,
 43813,
 -1,
 936132156,
 43812,
 936327120,
 936122607,
 43808,
 -1,
 936253679,
 43811,
 -51247,
 936297674,
 43809,
 -51246,
 936413610,
 43814,
 -1,
 936467665,
 43810,
 936654805,
 936066620,
 11709,
 -1,
 936590908,
 11708,
 936785879,
 936581359,
 11704,
 -1,
 936712431,
 11707,
 -51240,
 936756426,
 11705,
 -51239,
 936872362,
 11710,
 -1,
 936926417,
 11706,
 937113564,
 936001084,
 11693,
 -1,
 937049660,
 11692,
 937244638,
 937040111,
 11688,
 -1,
 937171183,
 11691,
 -51233,
 937215178,
 11689,
 -51232,
 937331114,
 11694,
 -1,
 937385169,
 11690,
 -51230,
 935954915,
 11655,
 -1,
 937515421,
 11664,
 937703412,
 935874360,
 -1,
 937768940,
 937679059,
 -1,
 937834471,
 937705020,
 11741,
 -1,
 937770556,
 11740,
 937965545,
 937761007,
 11736,
 -1,
 937892079,
 11739,
 -51222,
 937936074,
 11737,
 -51221,
 938052010,
 11742,
 -1,
 938106065,
 11738,
 938293234,
 937710605,
 -1,
 938358767,
 938229308,
 11670,
 -1,
 938294844,
 11669,
 938489841,
 938285295,
 11667,
 -1,
 938416367,
 4895,
 -1,
 938433745,
 11668,
 -51213,
 938248675,
 4879,
 -1,
 938637536,
 11658,
 938817542,
 937637341,
 -1,
 938883070,
 938751453,
 -1,
 938948605,
 938824738,
 -1,
 939014137,
 938884668,
 43789,
 -1,
 938950204,
 43788,
 -51206,
 938984650,
 43785,
 -51205,
 939100586,
 43790,
 -51204,
 939154641,
 43786,
 -1,
 939202973,
 43787,
 -1,
 938904035,
 11661,
 939472901,
 938859311,
 -1,
 939538433,
 939408956,
 43797,
 -1,
 939474492,
 43796,
 -51198,
 939508938,
 43793,
 -51197,
 939624874,
 43798,
 -51196,
 939678929,
 43794,
 -1,
 939727261,
 43795,
 -1,
 939428323,
 11660,
 939997206,
 938782092,
 -1,
 940062735,
 939961740,
 -1,
 940128266,
 939998780,
 11685,
 -1,
 940064316,
 11684,
 940259340,
 940054767,
 11680,
 -1,
 940185839,
 11683,
 -51187,
 940229834,
 11681,
 -51186,
 940345770,
 11686,
 -1,
 940399825,
 11682,
 940587028,
 939999289,
 -1,
 -51183,
 940547904,
 5004,
 -51182,
 940606164,
 4992,
 -51181,
 940658484,
 5000,
 -1,
 940714858,
 4996,
 -51179,
 940542435,
 11651,
 -1,
 940857757,
 11652,
 941045796,
 939926962,
 -1,
 941111327,
 940975538,
 -1,
 941176858,
 941047356,
 43821,
 -1,
 941112892,
 43820,
 941307932,
 941103343,
 43816,
 -1,
 941234415,
 43819,
 -51171,
 941278410,
 43817,
 -51170,
 941394346,
 43822,
 -1,
 941448401,
 43818,
 941635619,
 941084940,
 -1,
 941701154,
 941571644,
 4999,
 -1,
 941637180,
 4998,
 -1,
 941645009,
 4997,
 -1,
 941591011,
 11653,
 941963311,
 941013531,
 -1,
 942028844,
 941931729,
 -1,
 942094376,
 941964860,
 43781,
 -1,
 942030396,
 43780,
 -51159,
 942064842,
 43777,
 -51158,
 942180778,
 43782,
 -51157,
 942234833,
 43778,
 -1,
 942283165,
 43779,
 -51155,
 942005386,
 4935,
 -51154,
 942442979,
 11654,
 -1,
 942496157,
 11663,
 942684217,
 941939503,
 -1,
 942749752,
 942660399,
 -1,
 942815283,
 942685756,
 11701,
 -1,
 942751292,
 11700,
 942946357,
 942741743,
 11696,
 -1,
 942872815,
 11699,
 -51146,
 942916810,
 11697,
 -51145,
 943032746,
 11702,
 -1,
 943086801,
 11698,
 -1,
 942705123,
 11659,
 943339587,
 942659549,
 -1,
 943405122,
 943315155,
 -1,
 943470653,
 943341116,
 11733,
 -1,
 943406652,
 11732,
 943601727,
 943397103,
 11728,
 -1,
 943528175,
 11731,
 -51136,
 943572170,
 11729,
 -51135,
 943688106,
 11734,
 -1,
 943742161,
 11730,
 -1,
 943360483,
 4743,
 943994957,
 943300427,
 -1,
 944060492,
 943970515,
 -1,
 944126023,
 943996476,
 11717,
 -1,
 944062012,
 11716,
 944257097,
 944052463,
 11712,
 -1,
 944183535,
 11715,
 -51126,
 944227530,
 11713,
 -51125,
 944343466,
 11718,
 -1,
 944397521,
 11714,
 -1,
 944015843,
 4679,
 944650327,
 943942453,
 -1,
 944715862,
 944625875,
 -1,
 944781393,
 944651836,
 11725,
 -1,
 944717372,
 11724,
 944912467,
 944707823,
 11720,
 -1,
 944838895,
 11723,
 -51116,
 944882890,
 11721,
 -51115,
 944998826,
 11726,
 -1,
 945052881,
 11722,
 -1,
 944671203,
 4783,
 945305694,
 944609134,
 -1,
 945371228,
 945279244,
 -1,
 945436763,
 945307196,
 5007,
 -1,
 945372732,
 5006,
 -1,
 945380561,
 5005,
 -51107,
 945326563,
 11666,
 -1,
 945576349,
 11665,
 945764452,
 945257151,
 -1,
 945829987,
 945737996,
 -1,
 945895522,
 945765948,
 4995,
 -1,
 945831484,
 4994,
 -1,
 945839313,
 4993,
 -1,
 945785315,
 11649,
 946157672,
 945704753,
 -1,
 946223207,
 946093628,
 5003,
 -1,
 946159164,
 5002,
 -1,
 946166993,
 5001,
 946419819,
 946111220,
 -1,
 -51094,
 946395818,
 11657,
 -1,
 946440675,
 11656,
 -51092,
 946395818,
 4847,
 -51091,
 946591518,
 4815,
 -51090,
 946645791,
 11650,
 -51089,
 946698282,
 11648,
 -51088,
 946760412,
 11662,
 -1,
 946821533,
 4615,
 -1,
 935805027,
 4960,
 947075199,
 935772223,
 -1,
 947140727,
 947008989,
 -1,
 947206262,
 947078634,
 5009,
 -1,
 947130003,
 5016,
 -1,
 947150630,
 5012,
 947402874,
 947088181,
 -1,
 -51079,
 947374987,
 5017,
 -1,
 947405772,
 5013,
 -51077,
 947378780,
 5008,
 -51076,
 947565030,
 5011,
 -51075,
 947628340,
 5010,
 -51074,
 947673080,
 5015,
 -1,
 947728075,
 5014,
 947978239,
 947007863,
 -1,
 947992707,
 947867900,
 -1,
 -51070,
 947944592,
 4959,
 -1,
 947986303,
 4957,
 -1,
 947966053,
 4958,
 -51067,
 935712733,
 983047,
 -1,
 948184498,
 983096,
 948385987,
 935620295,
 -1,
 948451515,
 948315890,
 -1,
 948517005,
 948404980,
 -1,
 -51062,
 948464213,
 66837,
 -51061,
 948518460,
 66835,
 -51060,
 948582205,
 66821,
 -1,
 948639983,
 66836,
 948844691,
 948457272,
 -1,
 948910225,
 948786210,
 -1,
 -51056,
 948846140,
 66853,
 -1,
 948903680,
 66854,
 -51054,
 948857429,
 66827,
 -1,
 949042748,
 66826,
 949237910,
 948820783,
 -1,
 -51051,
 949180033,
 66852,
 -1,
 949239356,
 66851,
 949434521,
 949205531,
 -1,
 -51048,
 949376641,
 66846,
 -1,
 949435964,
 66845,
 949631132,
 949398924,
 -1,
 -51045,
 949573249,
 66844,
 -1,
 949632572,
 66843,
 949827743,
 949592321,
 -1,
 -51042,
 949789677,
 66842,
 -1,
 949829180,
 66841,
 950024354,
 949776071,
 -1,
 -51039,
 949973423,
 66833,
 -1,
 950025788,
 66832,
 950220965,
 949971765,
 -1,
 -51036,
 950163073,
 66855,
 -1,
 950222396,
 66831,
 950417575,
 950156860,
 66824,
 -1,
 950361297,
 66823,
 950548650,
 950351325,
 -1,
 -51031,
 950490753,
 66822,
 -1,
 950550076,
 66820,
 950745261,
 950479746,
 -1,
 -51028,
 950687361,
 66819,
 -1,
 950746684,
 66818,
 -51026,
 950720723,
 66850,
 -51025,
 950917182,
 66849,
 -51024,
 950979941,
 66848,
 -51023,
 951043274,
 66847,
 -51022,
 951099290,
 66840,
 -51021,
 951163245,
 66839,
 -51020,
 951224746,
 66838,
 -51019,
 951287208,
 66834,
 -51018,
 951347797,
 66830,
 -51017,
 951409873,
 66829,
 -51016,
 951473793,
 66828,
 -51015,
 951536243,
 66825,
 -51014,
 951592771,
 66817,
 -1,
 951654639,
 66816,
 951910399,
 948387388,
 -1,
 951924930,
 951792895,
 -1,
 951990465,
 951844864,
 -1,
 -51009,
 951959731,
 128294,
 -51008,
 952015841,
 128268,
 -1,
 952071732,
 128161,
 -1,
 951918013,
 9191,
 -1,
 951884484,
 128024,
 952383701,
 948339444,
 -1,
 952449232,
 952317407,
 -1,
 952514767,
 952404706,
 -1,
 952580298,
 952482331,
 -1,
 952645833,
 952541912,
 983048,
 -1,
 952566140,
 983095,
 -1,
 952584429,
 983046,
 -50997,
 952545153,
 983134,
 -50996,
 952802906,
 983178,
 -50995,
 952860135,
 983099,
 -50994,
 952923826,
 983064,
 -1,
 952980394,
 983177,
 -1,
 952489187,
 128282,
 953235667,
 952421814,
 -1,
 -50990,
 953185936,
 128388,
 -1,
 953236803,
 128233,
 953483263,
 953196363,
 983051,
 -1,
 953403215,
 983050,
 953563364,
 952335039,
 -1,
 953628894,
 953523858,
 -1,
 953694427,
 953583506,
 128453,
 953810943,
 953616063,
 -1,
 -50982,
 953700541,
 128454,
 -1,
 953759197,
 128455,
 953956573,
 953653277,
 128460,
 -1,
 953920908,
 128461,
 -1,
 953891248,
 128459,
 954204159,
 953584536,
 -1,
 -50976,
 954078684,
 127999,
 -50975,
 954143975,
 127998,
 -50974,
 954209299,
 127997,
 -50973,
 954274549,
 127996,
 -1,
 954339745,
 127995,
 954546417,
 953538525,
 -1,
 954611952,
 954515723,
 -1,
 954677487,
 954549040,
 -1,
 954743018,
 954651424,
 -1,
 -50967,
 954709535,
 128915,
 -1,
 954740559,
 128905,
 954939629,
 954707340,
 -1,
 -50964,
 954886554,
 128954,
 -1,
 954932941,
 128942,
 -50962,
 954880892,
 128935,
 -1,
 955075608,
 128948,
 -1,
 954606569,
 128125,
 -1,
 954572312,
 128529,
 955398398,
 954472687,
 -1,
 955463933,
 955359489,
 128066,
 955529466,
 955432148,
 -1,
 955595001,
 955480116,
 -1,
 955660536,
 955521263,
 -1,
 -50953,
 955626013,
 127759,
 -1,
 955678436,
 127758,
 -1,
 955598782,
 127757,
 -1,
 955558957,
 9178,
 956039167,
 955450603,
 -1,
 -50948,
 955950833,
 127806,
 -1,
 956005277,
 127805,
 -1,
 955404952,
 129413,
 956250369,
 955373985,
 128065,
 -50944,
 956214668,
 128064,
 -1,
 956256912,
 128083,
 956446981,
 956214668,
 -1,
 956512516,
 956377986,
 983104,
 -1,
 956440767,
 983103,
 -1,
 956438767,
 983135,
 956709129,
 956402090,
 -1,
 -50937,
 956676635,
 983049,
 -50936,
 956725951,
 983100,
 -1,
 956788423,
 983067,
 956971276,
 956681090,
 -1,
 -50933,
 956931427,
 127972,
 -1,
 956968155,
 127984,
 -50931,
 956943881,
 127794,
 -50930,
 957128694,
 11072,
 -50929,
 957192156,
 983179,
 -50928,
 957246040,
 9167,
 -50927,
 957299033,
 11790,
 -1,
 957353663,
 128231,
 957562923,
 857417138,
 -1,
 957627906,
 957487343,
 -1,
 957693114,
 957579888,
 -1,
 957758639,
 957641948,
 -1,
 957824081,
 957716334,
 -1,
 957889609,
 957765194,
 -1,
 957954551,
 957824574,
 -1,
 958019925,
 957907700,
 -1,
 958085428,
 957959992,
 -1,
 958150948,
 958032693,
 -1,
 958216479,
 958121162,
 -1,
 -50914,
 958175086,
 92598,
 -1,
 958233279,
 92619,
 958413090,
 958154566,
 -1,
 -50911,
 958388189,
 92543,
 -1,
 958405502,
 92553,
 958660607,
 958339311,
 92531,
 -1,
 958537463,
 92601,
 958740781,
 958091064,
 -1,
 958806313,
 958710986,
 -1,
 -50905,
 958767534,
 92550,
 -50904,
 958830446,
 92624,
 -1,
 958864322,
 92563,
 959119359,
 958742076,
 -1,
 959133996,
 959038822,
 92607,
 -1,
 959101467,
 92535,
 -1,
 959070448,
 92557,
 959330607,
 958711142,
 92640,
 -1,
 959298075,
 92657,
 959461682,
 959285674,
 -1,
 -50895,
 959422283,
 92544,
 -1,
 959485806,
 92541,
 -50893,
 959399848,
 92579,
 -1,
 959584495,
 92658,
 959789374,
 958019037,
 -1,
 959854906,
 959715567,
 -1,
 959920441,
 959781105,
 -1,
 -50888,
 959886642,
 92562,
 -1,
 959939294,
 92637,
 -1,
 959879022,
 92518,
 960182589,
 959798481,
 -1,
 -50884,
 960143179,
 92558,
 -1,
 960176411,
 92592,
 -1,
 960153641,
 92528,
 960444740,
 959736329,
 -1,
 960510275,
 960380476,
 -1,
 960575810,
 960446012,
 92628,
 -1,
 960496334,
 92648,
 -1,
 960547956,
 92547,
 -1,
 960437128,
 92554,
 960837961,
 960409654,
 -1,
 960903496,
 960808138,
 -1,
 -50873,
 960860089,
 92527,
 -1,
 960904764,
 92545,
 -1,
 960847616,
 92540,
 961165644,
 960813871,
 -1,
 -50869,
 961137336,
 92609,
 -1,
 961159451,
 92583,
 961362255,
 961141279,
 -1,
 -50866,
 961294502,
 92589,
 -1,
 961357802,
 92608,
 961558866,
 961329691,
 -1,
 -50863,
 961529805,
 92604,
 -1,
 961552563,
 92622,
 961755476,
 961485039,
 92662,
 -1,
 961691196,
 92613,
 -1,
 961703427,
 92584,
 961952109,
 957978478,
 -1,
 962017628,
 961922250,
 92576,
 962083162,
 961943791,
 -1,
 -50855,
 962043723,
 92618,
 -1,
 962084412,
 92529,
 -50853,
 962034367,
 92561,
 -1,
 962215484,
 92649,
 962410850,
 961943791,
 -1,
 962476383,
 962337007,
 92524,
 -1,
 962427583,
 92536,
 962658303,
 962397884,
 -1,
 -50847,
 962558624,
 92634,
 -1,
 962610442,
 92625,
 962804070,
 962354385,
 92663,
 962920447,
 962739772,
 -1,
 -50843,
 962837019,
 92621,
 -1,
 962872662,
 92593,
 963066219,
 962739772,
 -1,
 963131754,
 963036362,
 -1,
 -50839,
 963106781,
 92647,
 -1,
 963164699,
 92605,
 -1,
 963068703,
 92548,
 963444735,
 963021226,
 92568,
 -1,
 963349810,
 92610,
 963524992,
 961903295,
 -1,
 963590515,
 963451119,
 92667,
 963656049,
 963526204,
 92600,
 -1,
 963607231,
 92542,
 -50830,
 963616587,
 92668,
 -1,
 963745646,
 92555,
 963918197,
 963534033,
 92654,
 -1,
 963854573,
 92611,
 964049272,
 963858559,
 -1,
 -50825,
 963986276,
 92581,
 -1,
 964040943,
 92551,
 964245883,
 963979075,
 -1,
 -50822,
 964216781,
 92520,
 -1,
 964247100,
 92582,
 -50820,
 964218686,
 92617,
 -50819,
 964412774,
 92614,
 -50818,
 964463922,
 92671,
 -50817,
 964512438,
 92591,
 -1,
 964576100,
 92666,
 964770195,
 963492379,
 -1,
 964835719,
 964696303,
 -1,
 964901252,
 964761839,
 92635,
 -1,
 964861771,
 92577,
 -50811,
 964861771,
 92636,
 -50810,
 964983487,
 92530,
 -1,
 965034884,
 92559,
 965228939,
 964805834,
 -1,
 965294474,
 965180095,
 92586,
 -1,
 965221231,
 92569,
 -1,
 965221231,
 92566,
 965491087,
 965183914,
 -1,
 965556622,
 965446058,
 92537,
 -1,
 965509876,
 92519,
 -1,
 965517131,
 92630,
 965804031,
 965426748,
 -1,
 965818770,
 965723338,
 92669,
 -1,
 965745580,
 92572,
 -1,
 965772020,
 92672,
 966015397,
 964745427,
 -1,
 966080921,
 965985482,
 -1,
 -50794,
 966041419,
 92644,
 -50793,
 966099700,
 92645,
 -50792,
 966149462,
 92594,
 -1,
 966204309,
 92641,
 966408606,
 966018886,
 -1,
 966474140,
 966335343,
 92567,
 -1,
 966441499,
 92623,
 -50787,
 966449117,
 92639,
 -1,
 966556351,
 92606,
 966736289,
 966365434,
 -1,
 -50784,
 966703499,
 92642,
 -1,
 966734692,
 92643,
 966932900,
 966679761,
 -1,
 -50781,
 966900251,
 92590,
 -1,
 966934765,
 92564,
 -1,
 966860979,
 92588,
 967195057,
 965979532,
 -1,
 967260587,
 967136290,
 -1,
 967326121,
 967215530,
 92659,
 -1,
 967286603,
 92660,
 -50774,
 967272079,
 92638,
 -1,
 967395180,
 92580,
 967588270,
 967196220,
 -1,
 -50771,
 967555611,
 92560,
 -1,
 967589436,
 92534,
 -50769,
 967558511,
 92571,
 -50768,
 967740604,
 92525,
 -1,
 967776669,
 92549,
 967981502,
 967143111,
 -1,
 968047032,
 967936426,
 -1,
 968112566,
 968001962,
 -1,
 -50763,
 968079899,
 92556,
 -1,
 968131316,
 92523,
 -50761,
 968073035,
 92664,
 -1,
 968260287,
 92539,
 968440252,
 967973103,
 -1,
 -50758,
 968400715,
 92633,
 -50757,
 968464238,
 92521,
 -1,
 968498900,
 92575,
 -50755,
 968410314,
 92653,
 -1,
 968640345,
 92595,
 968833483,
 967928629,
 -1,
 968899011,
 968803530,
 -1,
 -50751,
 968866331,
 92620,
 -50750,
 968921017,
 92538,
 -1,
 968967896,
 92587,
 969161160,
 968834620,
 -1,
 969226695,
 969131210,
 -1,
 -50746,
 969201629,
 92646,
 -1,
 969218927,
 92570,
 -1,
 969194011,
 92599,
 -50743,
 969120435,
 92532,
 -50742,
 969443754,
 92665,
 -1,
 969497809,
 92670,
 969685463,
 968772024,
 -1,
 969750995,
 969655498,
 -1,
 969816529,
 969670656,
 -1,
 -50737,
 969778552,
 92661,
 -50736,
 969825489,
 92616,
 -1,
 969878525,
 92626,
 970129407,
 969752124,
 92596,
 -1,
 970045979,
 92612,
 970209749,
 969677039,
 92603,
 -1,
 970170187,
 92673,
 -50730,
 970165436,
 92627,
 -1,
 970277101,
 92651,
 970471908,
 969625400,
 -1,
 970537441,
 970413090,
 -1,
 970602975,
 970473020,
 -1,
 970668510,
 970573002,
 -1,
 -50724,
 970643421,
 92552,
 -50723,
 970687220,
 92565,
 -1,
 970726255,
 92615,
 -1,
 970635803,
 92602,
 -50720,
 970558652,
 92674,
 -1,
 970922413,
 92578,
 971177983,
 970467139,
 -1,
 -50717,
 971099252,
 92597,
 -1,
 971160091,
 92585,
 971323882,
 970432769,
 -1,
 971389416,
 971249903,
 -1,
 -50713,
 971349835,
 92526,
 -1,
 971390524,
 92656,
 -50711,
 971333966,
 92546,
 -1,
 971524059,
 92655,
 971717103,
 971297036,
 -1,
 971782638,
 971687114,
 -1,
 -50707,
 971737514,
 92533,
 -1,
 971783740,
 92650,
 -1,
 971720667,
 92574,
 972044788,
 971689082,
 -1,
 972110323,
 971980348,
 -1,
 -50702,
 972080486,
 92573,
 -1,
 972111420,
 92652,
 -1,
 972065980,
 92522,
 -50699,
 971999658,
 92631,
 -50698,
 972315857,
 92632,
 -1,
 972364015,
 92629,
 972569246,
 957887967,
 -1,
 972634668,
 972522228,
 -1,
 972700170,
 972574520,
 -1,
 972765698,
 972647221,
 -1,
 972831230,
 972703558,
 -1,
 -50691,
 972793504,
 92432,
 -1,
 972823468,
 92457,
 -50689,
 972806580,
 92435,
 -50688,
 972998697,
 92412,
 -50687,
 973037312,
 92476,
 -1,
 973086899,
 92414,
 973340671,
 972705592,
 -1,
 973355527,
 973215983,
 -1,
 973421062,
 973283028,
 92465,
 -1,
 973347695,
 92409,
 -1,
 973379438,
 92483,
 -50680,
 973328728,
 92467,
 -50679,
 973588744,
 92485,
 -1,
 973621211,
 92475,
 973814290,
 972646921,
 -1,
 973879821,
 973757649,
 92403,
 -1,
 973816045,
 92405,
 974010896,
 973817670,
 -1,
 -50673,
 973978139,
 92407,
 -1,
 974003070,
 92430,
 -50671,
 973981460,
 92487,
 -1,
 974135475,
 92418,
 974338586,
 973778316,
 -1,
 974404118,
 974282496,
 -1,
 -50667,
 974371355,
 92459,
 -1,
 974428014,
 92447,
 974600729,
 974345250,
 -1,
 -50664,
 974572571,
 92486,
 -1,
 974602477,
 92408,
 -1,
 974571469,
 92480,
 974862879,
 974313683,
 -1,
 -50660,
 974833397,
 92463,
 -50659,
 974871761,
 92493,
 -50658,
 974931672,
 92450,
 -1,
 974986964,
 92410,
 975190565,
 974796253,
 -1,
 975256099,
 975126076,
 -1,
 -50654,
 975228020,
 92425,
 -1,
 975257148,
 92437,
 -50652,
 975211826,
 92440,
 -1,
 975380180,
 92471,
 975583786,
 975157787,
 -1,
 975649321,
 975519292,
 -1,
 -50648,
 975620045,
 92472,
 -1,
 975650364,
 92505,
 -1,
 975621226,
 92514,
 -50645,
 975553738,
 92503,
 -1,
 975854801,
 92507,
 976042567,
 972585663,
 92497,
 976108084,
 975980984,
 -1,
 976173616,
 976062890,
 92445,
 -1,
 976126708,
 92404,
 976304691,
 976111430,
 -1,
 -50638,
 976271899,
 92424,
 -1,
 976296815,
 92458,
 -1,
 976248576,
 92466,
 976566840,
 976048255,
 -1,
 -50634,
 976522008,
 92438,
 -50633,
 976576256,
 92444,
 -1,
 976635783,
 92442,
 976828989,
 976502332,
 -1,
 976894524,
 976798922,
 -1,
 -50629,
 976861723,
 92427,
 -1,
 976913140,
 92478,
 -1,
 976830704,
 92496,
 977156673,
 976758194,
 -1,
 977222208,
 977082781,
 92448,
 -1,
 977143997,
 92515,
 -1,
 977193221,
 92401,
 977418820,
 977082607,
 -1,
 -50621,
 977367628,
 92426,
 -1,
 977421388,
 92482,
 -50619,
 977391670,
 92510,
 -50618,
 977585354,
 92499,
 -1,
 977637066,
 92441,
 977812058,
 976006540,
 -1,
 977877585,
 977753122,
 -1,
 977943118,
 977813052,
 -1,
 978008653,
 977913034,
 -1,
 -50612,
 977983453,
 92501,
 -1,
 978000751,
 92417,
 -1,
 977944124,
 92413,
 -50609,
 977913034,
 92504,
 -50608,
 978227447,
 92508,
 -1,
 978280608,
 92500,
 978467413,
 977847498,
 -1,
 -50605,
 978437322,
 92498,
 -50604,
 978468412,
 92419,
 -1,
 978525039,
 92473,
 978729560,
 978393327,
 -1,
 -50601,
 978689867,
 92516,
 -1,
 978753390,
 92423,
 -50599,
 978686551,
 92452,
 -1,
 978863980,
 92428,
 979057256,
 977759029,
 -1,
 979122786,
 978992700,
 -1,
 979188321,
 979092682,
 -1,
 -50594,
 979146606,
 92460,
 -50593,
 979210853,
 92431,
 -50592,
 979270335,
 92454,
 -1,
 979311566,
 92415,
 -1,
 979155483,
 92420,
 979581542,
 979092682,
 92489,
 -50588,
 979541835,
 92479,
 -50587,
 979602620,
 92422,
 -1,
 979665652,
 92474,
 -50585,
 979556788,
 92502,
 -1,
 979816797,
 92449,
 979974772,
 979024411,
 -1,
 980040303,
 979910204,
 -1,
 980105838,
 980010186,
 -1,
 -50580,
 980072987,
 92416,
 -50579,
 980124404,
 92481,
 -1,
 980163477,
 92451,
 -1,
 980041968,
 92456,
 980433521,
 980010186,
 92433,
 -1,
 980390487,
 92477,
 -50574,
 980390135,
 92492,
 -50573,
 980507857,
 92513,
 -1,
 980556655,
 92491,
 980761214,
 979922631,
 -1,
 980826747,
 980696636,
 -1,
 980892281,
 980796618,
 -1,
 -50568,
 980843199,
 92484,
 -1,
 980884386,
 92439,
 -50566,
 980859419,
 92464,
 -1,
 981025008,
 92495,
 -50564,
 980797389,
 92446,
 -50563,
 981176567,
 92511,
 -1,
 981229312,
 92406,
 981416583,
 980719470,
 -1,
 981482114,
 981386442,
 -1,
 -50559,
 981453851,
 92443,
 -1,
 981507915,
 92509,
 981678725,
 981417532,
 -1,
 -50556,
 981650466,
 92462,
 -1,
 981679676,
 92506,
 -50554,
 981624395,
 92461,
 -1,
 981803187,
 92469,
 982006415,
 981391571,
 -1,
 982071949,
 981976266,
 -1,
 982137484,
 982026666,
 -1,
 -50549,
 982095726,
 92470,
 -1,
 982153919,
 92468,
 -1,
 982112060,
 92453,
 -50546,
 982008676,
 92429,
 -1,
 982326158,
 92421,
 982530709,
 981967105,
 -1,
 982596243,
 982467431,
 -1,
 -50542,
 982551582,
 92490,
 -1,
 982614576,
 92512,
 -50540,
 982540448,
 92494,
 -1,
 982719358,
 92455,
 982923928,
 982503692,
 -1,
 -50537,
 982893935,
 92411,
 -1,
 982917299,
 92402,
 983120539,
 982864253,
 -1,
 -50534,
 983058260,
 92488,
 -1,
 983112093,
 92434,
 983367679,
 983058872,
 -1,
 -50531,
 983254898,
 92436,
 -1,
 983308701,
 92517,
 983513905,
 972499844,
 -1,
 983579347,
 983466740,
 -1,
 983644845,
 983519032,
 -1,
 983710376,
 983584568,
 -1,
 983775911,
 983680202,
 92362,
 -50524,
 983731506,
 92341,
 -50523,
 983792319,
 92347,
 -50522,
 983843168,
 92370,
 -1,
 983899033,
 92336,
 -1,
 983712612,
 92307,
 984169131,
 983657269,
 -1,
 -50518,
 984139516,
 92303,
 -1,
 984162587,
 92309,
 -50516,
 984124604,
 92368,
 -1,
 984293659,
 92395,
 984496821,
 983608716,
 -1,
 984562353,
 984466634,
 -1,
 -50512,
 984519278,
 92359,
 -1,
 984580852,
 92374,
 -50510,
 984517820,
 92371,
 -50509,
 984700421,
 92351,
 -50508,
 984762207,
 92325,
 -1,
 984815855,
 92350,
 985021118,
 984430045,
 -1,
 985086649,
 984958790,
 -1,
 -50504,
 985053723,
 92349,
 -1,
 985078704,
 92308,
 985283260,
 985012463,
 -1,
 -50501,
 985241454,
 92378,
 -1,
 985299647,
 92375,
 -50499,
 985238790,
 92317,
 -1,
 985423507,
 92331,
 985610950,
 984967689,
 -1,
 985676482,
 985546300,
 -1,
 -50495,
 985648244,
 92389,
 -1,
 985678064,
 92360,
 985873093,
 985602287,
 -1,
 -50492,
 985823935,
 92367,
 -1,
 985875231,
 92356,
 -1,
 985843476,
 92333,
 986135244,
 985578011,
 -1,
 986200778,
 986070588,
 -1,
 -50487,
 986171593,
 92345,
 -1,
 986219252,
 92372,
 -50485,
 986170586,
 92314,
 -1,
 986323357,
 92340,
 986528463,
 986110767,
 -1,
 -50482,
 986466179,
 92323,
 -1,
 986519791,
 92304,
 986725074,
 986454255,
 -1,
 -50479,
 986685259,
 92396,
 -1,
 986744822,
 92338,
 -1,
 986700359,
 92313,
 986987248,
 983530175,
 -1,
 987052774,
 986916274,
 -1,
 987118299,
 986988092,
 -1,
 987183833,
 987088074,
 -1,
 -50472,
 987158493,
 92385,
 -1,
 987200191,
 92315,
 -50470,
 987144622,
 92354,
 -1,
 987316909,
 92311,
 987511518,
 987061457,
 92381,
 -50467,
 987478555,
 92326,
 -1,
 987539218,
 92343,
 987708131,
 987437295,
 -1,
 987773666,
 987633905,
 -1,
 -50463,
 987732731,
 92387,
 -1,
 987769789,
 92318,
 -1,
 987728273,
 92383,
 988086271,
 987677898,
 -1,
 -50459,
 987971132,
 92324,
 -1,
 988027774,
 92364,
 988232429,
 986978543,
 -1,
 988297962,
 988167740,
 -1,
 -50455,
 988262938,
 92363,
 -1,
 988314932,
 92382,
 988545023,
 988217344,
 -1,
 -50452,
 988448782,
 92376,
 -1,
 988507367,
 92339,
 -50450,
 988202342,
 92391,
 -50449,
 988634880,
 92390,
 -1,
 988696727,
 92344,
 988887809,
 986934069,
 -1,
 988953340,
 988823100,
 -1,
 989018872,
 988923082,
 -1,
 989084406,
 988982668,
 -1,
 -50443,
 989026218,
 92319,
 -1,
 989087707,
 92384,
 -50441,
 989035199,
 92386,
 -1,
 989228045,
 92321,
 989412091,
 988971766,
 -1,
 -50438,
 989360418,
 92393,
 -1,
 989416043,
 92394,
 -1,
 989379099,
 92361,
 989674239,
 988923082,
 -1,
 -50434,
 989641243,
 92366,
 -1,
 989695942,
 92373,
 -50432,
 989632730,
 92328,
 -1,
 989796765,
 92329,
 990001928,
 988862675,
 -1,
 990067462,
 989971658,
 -1,
 -50428,
 990041916,
 92388,
 -50427,
 990083775,
 92305,
 -1,
 990119089,
 92322,
 -50425,
 990005150,
 92327,
 -1,
 990255517,
 92377,
 990460688,
 989968923,
 -1,
 990526220,
 990406658,
 -1,
 -50421,
 990496116,
 92358,
 -1,
 990517627,
 92334,
 990722831,
 990461500,
 -1,
 -50418,
 990694439,
 92346,
 -1,
 990755355,
 92400,
 -1,
 990648765,
 92332,
 990984984,
 990424460,
 -1,
 991050516,
 990925858,
 -1,
 -50413,
 991020820,
 92379,
 -1,
 991061647,
 92392,
 991247127,
 990985788,
 -1,
 -50410,
 991218804,
 92330,
 -1,
 991280332,
 92380,
 -1,
 991217024,
 92335,
 991509278,
 990932679,
 -1,
 991574812,
 991434991,
 -1,
 -50405,
 991532910,
 92342,
 -1,
 991591103,
 92357,
 -50403,
 991544522,
 92365,
 -1,
 991717007,
 92397,
 991902499,
 991467374,
 -1,
 991968034,
 991845585,
 -1,
 -50399,
 991930130,
 92316,
 -1,
 991986420,
 92398,
 -1,
 991904612,
 92399,
 992230184,
 991842104,
 -1,
 992295719,
 992171064,
 -1,
 -50394,
 992256430,
 92310,
 -1,
 992319342,
 92320,
 -1,
 992225052,
 92312,
 992557867,
 992203020,
 -1,
 -50390,
 992528665,
 92369,
 -1,
 992550933,
 92306,
 992754478,
 992530209,
 -1,
 -50387,
 992729053,
 92337,
 -1,
 992746406,
 92353,
 -50385,
 992718072,
 92355,
 -50384,
 992890659,
 92348,
 -1,
 992946967,
 92352,
 993147823,
 983439601,
 -1,
 993213269,
 993100532,
 -1,
 993278777,
 993180187,
 -1,
 993344312,
 993206451,
 92223,
 993460223,
 993263616,
 -1,
 -50377,
 993364054,
 92194,
 -1,
 993427215,
 92185,
 -1,
 993300747,
 92178,
 993671999,
 993218360,
 -1,
 993737533,
 993619571,
 -1,
 -50372,
 993692068,
 92182,
 -1,
 993723532,
 92160,
 -50370,
 993677592,
 92229,
 -1,
 993861698,
 92173,
 994065219,
 993646803,
 -1,
 994130754,
 994008273,
 92239,
 -1,
 994097752,
 92225,
 -1,
 994068184,
 92233,
 994327366,
 994040623,
 -1,
 -50363,
 994297900,
 92191,
 -1,
 994318607,
 92167,
 994523977,
 994291766,
 -1,
 -50360,
 994467584,
 92237,
 -1,
 994515183,
 92241,
 994720588,
 994470709,
 -1,
 -50357,
 994665100,
 92180,
 -1,
 994711991,
 92227,
 994917199,
 994653803,
 -1,
 -50354,
 994844676,
 92212,
 -1,
 994903061,
 92201,
 995113810,
 994842863,
 -1,
 -50351,
 995073867,
 92245,
 -1,
 995105039,
 92164,
 -50349,
 995060287,
 92231,
 -50348,
 995254439,
 92204,
 -1,
 995312484,
 92244,
 995507052,
 993163967,
 -1,
 995572577,
 995432687,
 -1,
 995638111,
 995507772,
 -1,
 995703644,
 995588799,
 92238,
 -50342,
 995675956,
 92174,
 -50341,
 995716676,
 92203,
 -1,
 995764282,
 92171,
 -50339,
 995668506,
 92230,
 -50338,
 995920273,
 92210,
 -1,
 995978479,
 92186,
 -50336,
 995596185,
 92221,
 -1,
 996116514,
 92175,
 996293478,
 995527082,
 -1,
 996359013,
 996248764,
 -1,
 -50332,
 996318991,
 92198,
 -1,
 996362188,
 92214,
 -1,
 996311801,
 92190,
 996621161,
 996222439,
 -1,
 -50328,
 996581195,
 92246,
 -1,
 996641169,
 92232,
 -50326,
 996593445,
 92176,
 -50325,
 996757649,
 92196,
 -1,
 996820875,
 92197,
 997014396,
 995470732,
 -1,
 997079925,
 996955170,
 -1,
 997145457,
 997049546,
 -1,
 -50320,
 997096127,
 92215,
 -1,
 997147760,
 92165,
 997342068,
 997088465,
 -1,
 -50317,
 997302702,
 92222,
 -1,
 997360653,
 92168,
 -1,
 997298430,
 92224,
 997604217,
 997034410,
 -1,
 -50313,
 997571099,
 92235,
 -50312,
 997629771,
 92220,
 -1,
 997689013,
 92208,
 -50310,
 997575786,
 92181,
 -50309,
 997812050,
 92195,
 -1,
 997869463,
 92177,
 998062989,
 996972398,
 -1,
 998128516,
 997988591,
 -1,
 998194049,
 998054127,
 -1,
 -50304,
 998154670,
 92226,
 -1,
 998210239,
 92236,
 -50302,
 998158479,
 92187,
 -50301,
 998343171,
 92189,
 -1,
 998376469,
 92200,
 998587275,
 998083893,
 -1,
 998652808,
 998545375,
 -1,
 -50297,
 998592679,
 92169,
 -1,
 998647271,
 92170,
 998899711,
 998604564,
 -1,
 -50294,
 998789287,
 92162,
 -1,
 998843879,
 92163,
 -50292,
 998557977,
 92205,
 -1,
 998983384,
 92202,
 999177110,
 998009653,
 -1,
 999242641,
 999112252,
 -1,
 -50288,
 999212905,
 92179,
 -1,
 999275035,
 92211,
 999439252,
 999168239,
 -1,
 -50285,
 999399243,
 92240,
 -1,
 999442957,
 92199,
 -50283,
 999409941,
 92213,
 -1,
 999595317,
 92219,
 999766942,
 999143963,
 -1,
 999832474,
 999736522,
 -1,
 -50279,
 999758754,
 92206,
 -1,
 999818331,
 92172,
 1000029085,
 999769926,
 -1,
 -50276,
 999996608,
 92209,
 -1,
 1000020885,
 92234,
 -1,
 999974936,
 92166,
 1000291236,
 999714503,
 -1,
 1000356769,
 1000260810,
 92243,
 -1,
 1000283042,
 92207,
 -50270,
 1000312104,
 92216,
 -50269,
 1000425183,
 92184,
 -1,
 1000480954,
 92183,
 1000684457,
 1000230712,
 -1,
 1000749992,
 1000626084,
 -1,
 -50265,
 1000710574,
 92188,
 -1,
 1000755622,
 92193,
 -1,
 1000679539,
 92161,
 1001012140,
 1000654026,
 -1,
 -50261,
 1000965832,
 92228,
 -1,
 1001000473,
 92192,
 -50259,
 1000983975,
 92242,
 -50258,
 1001171834,
 92218,
 -1,
 1001212862,
 92217,
 1001405440,
 993076660,
 -1,
 1001470915,
 1001355967,
 -1,
 1001536440,
 1001399730,
 -1,
 1001601973,
 1001461999,
 -1,
 -50252,
 1001529673,
 92255,
 -1,
 1001587795,
 92252,
 -50250,
 1001572629,
 92292,
 -50249,
 1001744393,
 92268,
 -1,
 1001801647,
 92286,
 1001995196,
 1001461999,
 92300,
 1002110975,
 1001915587,
 -1,
 -50245,
 1002031803,
 92296,
 -1,
 1002063717,
 92295,
 1002257343,
 1001933240,
 -1,
 -50242,
 1002212694,
 92267,
 -1,
 1002269162,
 92284,
 1002453954,
 1002194758,
 -1,
 -50239,
 1002420837,
 92290,
 -1,
 1002479435,
 92281,
 -1,
 1002409773,
 92287,
 1002716116,
 1001423604,
 -1,
 1002781644,
 1002655544,
 -1,
 1002847178,
 1002721080,
 -1,
 1002912712,
 1002817813,
 92282,
 -1,
 1002832910,
 92283,
 -50231,
 1002850121,
 92277,
 -1,
 1002969513,
 92298,
 -50229,
 1002802364,
 92302,
 -1,
 1003122036,
 92276,
 1003305935,
 1002756307,
 -1,
 -50226,
 1003248874,
 92269,
 -1,
 1003297666,
 92288,
 1003502546,
 1003269516,
 -1,
 -50223,
 1003445315,
 92247,
 -1,
 1003504484,
 92299,
 -50221,
 1003470512,
 92260,
 -1,
 1003634095,
 92261,
 1003830236,
 1002679692,
 -1,
 1003895768,
 1003771521,
 -1,
 -50217,
 1003865465,
 92266,
 -1,
 1003928174,
 92265,
 -50215,
 1003865845,
 92285,
 -50214,
 1004035840,
 92249,
 -50213,
 1004095206,
 92250,
 -1,
 1004150170,
 92279,
 1004354533,
 1003776821,
 -1,
 1004420065,
 1004291910,
 -1,
 -50209,
 1004395031,
 92272,
 -50208,
 1004445455,
 92270,
 -1,
 1004477310,
 92294,
 1004682212,
 1004362961,
 -1,
 -50205,
 1004642123,
 92301,
 -1,
 1004683555,
 92253,
 -1,
 1004609236,
 92256,
 1004944362,
 1004312430,
 -1,
 -50201,
 1004914882,
 92289,
 -50200,
 1004955650,
 92263,
 -50199,
 1005011290,
 92257,
 -1,
 1005069032,
 92274,
 1005272048,
 1004891847,
 -1,
 1005337582,
 1005197551,
 -1,
 -50195,
 1005288163,
 92259,
 -1,
 1005330225,
 92273,
 -50193,
 1005292739,
 92251,
 -1,
 1005471448,
 92297,
 1005665269,
 1005238811,
 -1,
 1005730804,
 1005634764,
 -1,
 -50189,
 1005684750,
 92264,
 -1,
 1005747048,
 92248,
 -1,
 1005656489,
 92280,
 1005992952,
 1005639891,
 -1,
 -50185,
 1005930402,
 92254,
 -1,
 1005984808,
 92258,
 1006189563,
 1005932973,
 -1,
 -50182,
 1006159210,
 92262,
 -1,
 1006207732,
 92271,
 1006386174,
 1006127731,
 -1,
 -50179,
 1006357620,
 92291,
 -1,
 1006386748,
 92293,
 -50177,
 1006360527,
 92278,
 -1,
 1006554927,
 92275,
 1006764031,
 1001343418,
 -1,
 1006779407,
 1006666484,
 -1,
 1006844932,
 1006748874,
 92697,
 -1,
 1006771055,
 92696,
 1006976007,
 1006791177,
 -1,
 -50170,
 1006945638,
 92698,
 -1,
 1006967678,
 92688,
 1007172618,
 1006915384,
 -1,
 -50167,
 1007120030,
 92711,
 -1,
 1007177607,
 92712,
 -50165,
 1007147548,
 92681,
 -50164,
 1007336459,
 92704,
 -50163,
 1007399019,
 92702,
 -50162,
 1007443153,
 92708,
 -1,
 1007498900,
 92687,
 1007696920,
 1006742924,
 -1,
 1007762452,
 1007637538,
 -1,
 -50158,
 1007731914,
 92700,
 -50157,
 1007782314,
 92713,
 -1,
 1007837344,
 92691,
 -50155,
 1007733866,
 92690,
 -50154,
 1007967441,
 92692,
 -50153,
 1008027611,
 92693,
 -1,
 1008082656,
 92727,
 1008286753,
 1007643445,
 -1,
 1008352284,
 1008221756,
 -1,
 -50149,
 1008319003,
 92695,
 -1,
 1008370420,
 92710,
 -50147,
 1008327092,
 92694,
 -50146,
 1008518346,
 92677,
 -50145,
 1008572380,
 92726,
 -50144,
 1008634282,
 92719,
 -1,
 1008670959,
 92675,
 1008876586,
 1008247041,
 -1,
 1008942118,
 1008811580,
 -1,
 -50140,
 1008913524,
 92709,
 -50139,
 1008960244,
 92721,
 -1,
 1009008188,
 92679,
 1009204265,
 1008884945,
 -1,
 -50136,
 1009147089,
 92683,
 -1,
 1009205485,
 92684,
 -1,
 1009173706,
 92707,
 1009466417,
 1008827071,
 92689,
 1009531950,
 1009395122,
 -1,
 -50131,
 1009468260,
 92720,
 -1,
 1009523101,
 92724,
 -50129,
 1009486250,
 92723,
 -50128,
 1009664244,
 92685,
 -1,
 1009719535,
 92722,
 1009925174,
 1009433115,
 -1,
 1009990709,
 1009850607,
 -1,
 -50124,
 1009925692,
 92680,
 -1,
 1009981679,
 92686,
 -1,
 1009927896,
 92725,
 1010252859,
 1009882990,
 -1,
 1010318394,
 1010187836,
 -1,
 -50119,
 1010289780,
 92703,
 -1,
 1010318908,
 92706,
 -1,
 1010287974,
 92714,
 1010580543,
 1010200263,
 -1,
 -50115,
 1010536695,
 92718,
 -50114,
 1010588881,
 92717,
 -1,
 1010637039,
 92682,
 1010842690,
 1010555091,
 -1,
 -50111,
 1010798839,
 92699,
 -1,
 1010833647,
 92701,
 1011039301,
 1010815244,
 -1,
 -50108,
 1011009269,
 92705,
 -1,
 1011030255,
 92716,
 -50106,
 1011011833,
 92728,
 -50105,
 1011205322,
 92676,
 -50104,
 1011240189,
 92715,
 -1,
 1011302637,
 92678,
 1011498060,
 957859018,
 -1,
 -50101,
 1011433020,
 42696,
 -1,
 1011489647,
 42711,
 1011694671,
 1011433020,
 -1,
 -50098,
 1011666036,
 42693,
 -1,
 1011695164,
 42698,
 -50096,
 1011637457,
 42717,
 -1,
 1011816687,
 42667,
 1012022372,
 957776628,
 -1,
 1012087894,
 1011968521,
 -1,
 -50092,
 1012057446,
 42686,
 -50091,
 1012089069,
 42694,
 -1,
 1012145022,
 42674,
 1012350042,
 1012027192,
 -1,
 -50088,
 1012297374,
 42707,
 -50087,
 1012354951,
 42708,
 -1,
 1012406511,
 42709,
 1012612188,
 1012319434,
 42685,
 -1,
 1012538223,
 42684,
 1012743263,
 1012578843,
 -1,
 -50082,
 1012714602,
 42731,
 -1,
 1012744429,
 42695,
 -50080,
 1012718108,
 42664,
 -50079,
 1012904043,
 42691,
 -50078,
 1012948177,
 42703,
 -50077,
 1013003924,
 42673,
 -1,
 1013061871,
 42715,
 1013267569,
 1011968821,
 -1,
 1013333096,
 1013221802,
 42719,
 -50073,
 1013305598,
 42734,
 -1,
 1013338555,
 42735,
 1013529708,
 1013268028,
 -1,
 -50070,
 1013501044,
 42692,
 -50069,
 1013561883,
 42683,
 -1,
 1013613300,
 42706,
 -50067,
 1013504436,
 42682,
 -50066,
 1013761226,
 42659,
 -50065,
 1013815260,
 42729,
 -50064,
 1013865681,
 42725,
 -1,
 1013913839,
 42657,
 1014119548,
 1013217983,
 42675,
 1014185077,
 1014054460,
 -1,
 -50060,
 1014137588,
 42722,
 -1,
 1014186224,
 42671,
 1014381688,
 1014113714,
 -1,
 -50057,
 1014317924,
 42720,
 -1,
 1014372765,
 42727,
 -50055,
 1014351050,
 42677,
 -50054,
 1014532522,
 42726,
 -50053,
 1014586577,
 42702,
 -1,
 1014634735,
 42723,
 1014840454,
 1014082956,
 -1,
 1014905986,
 1014780962,
 -1,
 -50049,
 1014875338,
 42688,
 -50048,
 1014925738,
 42710,
 -50047,
 1014980768,
 42678,
 -1,
 1015039963,
 42680,
 -50045,
 1014877290,
 42676,
 -50044,
 1015176401,
 42679,
 -50043,
 1015236571,
 42681,
 -1,
 1015291616,
 42732,
 1015495824,
 1014800641,
 -1,
 1015561355,
 1015430716,
 -1,
 -50039,
 1015532660,
 42704,
 -50038,
 1015579380,
 42721,
 -1,
 1015627324,
 42661,
 1015823502,
 1015504081,
 -1,
 -50035,
 1015766225,
 42668,
 -1,
 1015824621,
 42669,
 -50033,
 1015792842,
 42700,
 -1,
 1015946095,
 42705,
 1016151192,
 1015462427,
 -1,
 1016216724,
 1016086076,
 -1,
 -50029,
 1016183323,
 42728,
 -1,
 1016234740,
 42730,
 1016413335,
 1016142063,
 -1,
 -50026,
 1016348220,
 42662,
 -1,
 1016404207,
 42672,
 -1,
 1016356049,
 42724,
 1016675486,
 1016098503,
 -1,
 -50022,
 1016644810,
 42701,
 -50021,
 1016697079,
 42718,
 -50020,
 1016749265,
 42716,
 -50019,
 1016807668,
 42670,
 -1,
 1016862959,
 42666,
 1017068707,
 1016613304,
 -1,
 -50016,
 1017038026,
 42712,
 -50015,
 1017089212,
 42713,
 -50014,
 1017135341,
 42699,
 -1,
 1017190829,
 42733,
 1017396391,
 1017043155,
 -1,
 -50011,
 1017367224,
 42689,
 -50010,
 1017417975,
 42687,
 -1,
 1017452783,
 42690,
 1017658538,
 1017368844,
 -1,
 -50007,
 1017628405,
 42697,
 -1,
 1017649391,
 42714,
 -50005,
 1017627850,
 42658,
 -50004,
 1017809322,
 42663,
 -50003,
 1017863377,
 42665,
 -50002,
 1017921773,
 42660,
 -1,
 1017977071,
 42656,
 1018182838,
 957690170,
 -1,
 1018248373,
 1018133183,
 -1,
 1018313908,
 1018177700,
 -1,
 -49997,
 1018282818,
 42737,
 -1,
 1018326539,
 42736,
 -1,
 1018264341,
 42741,
 -1,
 1018198098,
 42740,
 -49993,
 1018146714,
 42742,
 -49992,
 1018601647,
 42743,
 -49991,
 1018660525,
 42738,
 -1,
 1018711847,
 42739,
 1018903911,
 957640391,
 -1,
 1018969433,
 1018847953,
 -1,
 1019034876,
 1018918108,
 -1,
 1019100356,
 1019001371,
 -1,
 1019165891,
 1019025647,
 6946,
 1019281407,
 1019084800,
 -1,
 -49983,
 1019198360,
 6947,
 -49982,
 1019249319,
 6942,
 -1,
 1019310277,
 6941,
 -1,
 1019141240,
 6983,
 1019559113,
 1019052788,
 -1,
 1019624647,
 1019484399,
 6950,
 -1,
 1019545691,
 6945,
 -49976,
 1019599148,
 6940,
 -1,
 1019694983,
 6935,
 1019886798,
 1019505461,
 -1,
 1019952333,
 1019812079,
 6931,
 -49972,
 1019890128,
 6981,
 -1,
 1019937891,
 6932,
 -1,
 1019894490,
 6982,
 1020214484,
 1019819627,
 6948,
 1020329983,
 1020134480,
 -1,
 1020345555,
 1020250890,
 -1,
 -49966,
 1020296050,
 6944,
 -1,
 1020337811,
 6943,
 -1,
 1020271467,
 6949,
 1020607705,
 1020139759,
 -1,
 1020673239,
 1020554257,
 6917,
 -1,
 1020594533,
 6918,
 -49960,
 1020639759,
 6987,
 -1,
 1020747947,
 6928,
 1020935389,
 1020571167,
 6962,
 1021050879,
 1020856466,
 -1,
 -49956,
 1020958684,
 6961,
 -1,
 1021005703,
 6960,
 1021197536,
 1020895611,
 6957,
 1021313023,
 1021118572,
 6923,
 -1,
 1021184357,
 6924,
 1021394147,
 1021144837,
 6958,
 1021509631,
 1021314086,
 6925,
 -1,
 1021380965,
 6926,
 1021590757,
 1021364067,
 6921,
 -1,
 1021512037,
 6922,
 1021721831,
 1021548508,
 6951,
 -1,
 1021641645,
 6952,
 1021852905,
 1021676493,
 6929,
 -1,
 1021774181,
 6930,
 1021983979,
 1021798951,
 6938,
 -1,
 1021903772,
 6939,
 1022115053,
 1021927595,
 6919,
 -1,
 1022036325,
 6920,
 1022246127,
 1022054279,
 6933,
 -1,
 1022165810,
 6934,
 1022377202,
 1022180924,
 -1,
 -49935,
 1022323729,
 6927,
 -1,
 1022380496,
 6984,
 1022573812,
 1022307248,
 6936,
 -1,
 1022493663,
 6937,
 1022704886,
 1022502375,
 6953,
 -1,
 1022624718,
 6954,
 -49929,
 1022679933,
 6986,
 -49928,
 1022810412,
 6956,
 -49927,
 1022873932,
 6959,
 -49926,
 1022938507,
 6985,
 -49925,
 1022982933,
 6955,
 -1,
 1023038520,
 6963,
 1023229221,
 1018987196,
 -1,
 1023294731,
 1023161821,
 -1,
 1023360261,
 1023219951,
 -1,
 1023425795,
 1023313256,
 7012,
 1023541247,
 1023344640,
 -1,
 -49918,
 1023457611,
 7013,
 -1,
 1023496431,
 7018,
 -49916,
 1023369944,
 7017,
 -1,
 1023624246,
 7015,
 1023819016,
 1023295036,
 -1,
 -49913,
 1023789237,
 7016,
 -1,
 1023837544,
 7010,
 -49911,
 1023789237,
 7011,
 -49910,
 1023970922,
 7009,
 -1,
 1024025304,
 7014,
 1024212246,
 1023226231,
 -1,
 1024277777,
 1024158907,
 -1,
 1024343311,
 1024247679,
 7021,
 -1,
 1024265466,
 7024,
 1024524287,
 1024292283,
 7022,
 -1,
 1024396538,
 7025,
 -49902,
 1024244751,
 7019,
 -49901,
 1024551554,
 7023,
 -49900,
 1024611049,
 7027,
 -49899,
 1024672799,
 7020,
 -1,
 1024731026,
 7026,
 1024933150,
 1024160572,
 -1,
 1024998683,
 1024888910,
 -1,
 -49895,
 1024968885,
 7033,
 -49894,
 1025008344,
 7036,
 -1,
 1025056737,
 7032,
 1025310719,
 1024930030,
 -1,
 -49891,
 1025230688,
 7035,
 -1,
 1025252726,
 7034,
 1025507327,
 1024895044,
 -1,
 1025522978,
 1025413130,
 -1,
 -49887,
 1025492772,
 7028,
 -1,
 1025514549,
 7029,
 1025769471,
 1025454328,
 -1,
 -49884,
 1025689440,
 7030,
 -1,
 1025711478,
 7031,
 1025916215,
 1023201432,
 -1,
 1025981741,
 1025882651,
 -1,
 1026047276,
 1025908315,
 6974,
 1026162687,
 1025966080,
 -1,
 1026178347,
 1026073994,
 6975,
 -1,
 1026099557,
 6977,
 -1,
 1026145284,
 6976,
 -1,
 1025982695,
 6965,
 1026440495,
 1025951679,
 6966,
 -1,
 1026361494,
 6967,
 1026571569,
 1026406697,
 6968,
 -1,
 1026491242,
 6969,
 1026702643,
 1026531710,
 6970,
 -1,
 1026623845,
 6971,
 1026833717,
 1026660917,
 6978,
 -1,
 1026754917,
 6979,
 1027014655,
 1026780936,
 6972,
 -1,
 1026885989,
 6973,
 1027095877,
 1025849564,
 -1,
 1027161403,
 1027062299,
 -1,
 -49862,
 1027134986,
 6994,
 -1,
 1027169088,
 6995,
 1027358014,
 1027124620,
 -1,
 -49859,
 1027303811,
 6998,
 -1,
 1027360735,
 6999,
 1027554625,
 1027295672,
 -1,
 -49856,
 1027511236,
 6996,
 -1,
 1027565777,
 6997,
 -49854,
 1027529713,
 6992,
 -49853,
 1027706292,
 6993,
 -49852,
 1027769904,
 7001,
 -1,
 1027818037,
 7000,
 1028013389,
 1027060367,
 -1,
 1028078921,
 1027983299,
 -1,
 -49848,
 1028040438,
 6912,
 -1,
 1028074531,
 6913,
 -49846,
 1028045131,
 6915,
 -49845,
 1028236717,
 6964,
 -49844,
 1028271488,
 6914,
 -1,
 1028335805,
 6916,
 1028537682,
 1027971036,
 -1,
 1028603217,
 1028487871,
 -1,
 -49840,
 1028539429,
 7008,
 -1,
 1028594488,
 7003,
 -1,
 1028556938,
 7002,
 1028865367,
 1028467900,
 -1,
 1028930902,
 1028823004,
 -1,
 -49835,
 1028892085,
 7007,
 -1,
 1028948622,
 7005,
 -1,
 1028895434,
 7006,
 -49832,
 1028838471,
 7004,
 -1,
 1029118800,
 6980,
 1029373951,
 1018918951,
 -1,
 1029389670,
 1029290525,
 -1,
 1029455205,
 1029319053,
 -1,
 1029520740,
 1029429236,
 -1,
 1029586274,
 1029449138,
 -1,
 1029651809,
 1029540898,
 -1,
 -49824,
 1029615391,
 128503,
 -1,
 1029647940,
 128505,
 -1,
 1029578353,
 128499,
 -49821,
 1029549855,
 128501,
 -1,
 1029863033,
 11197,
 -1,
 1029468535,
 128502,
 -1,
 1029418783,
 128500,
 -1,
 1029344562,
 127880,
 1030241713,
 1018870299,
 129415,
 1030307246,
 1030167929,
 -1,
 1030372757,
 1030255836,
 -1,
 1030438264,
 1030335884,
 -1,
 1030503798,
 1030381859,
 -1,
 -49811,
 1030478124,
 7132,
 -49810,
 1030541644,
 7116,
 -49809,
 1030598175,
 7129,
 -49808,
 1030660475,
 7123,
 -49807,
 1030723548,
 7112,
 -49806,
 1030781717,
 7125,
 -49805,
 1030844165,
 7135,
 -49804,
 1030902840,
 7107,
 -49803,
 1030967175,
 7119,
 -1,
 1031018735,
 7105,
 -49801,
 1030460619,
 7126,
 -1,
 1031149807,
 7128,
 1031355774,
 1030390516,
 -1,
 -49798,
 1031330092,
 7136,
 -49797,
 1031377410,
 7127,
 -49796,
 1031425927,
 7133,
 -49795,
 1031485035,
 7138,
 -1,
 1031543023,
 7113,
 1031748997,
 1031305919,
 -1,
 1031814532,
 1031674095,
 7124,
 1031929855,
 1031767064,
 -1,
 -49790,
 1031843359,
 7130,
 -49789,
 1031897937,
 7114,
 -1,
 1031951416,
 7108,
 -1,
 1031742951,
 7139,
 1032207751,
 1031706588,
 7111,
 -1,
 1032154684,
 7117,
 -49784,
 1032182060,
 7131,
 -49783,
 1032311116,
 7115,
 -49782,
 1032373450,
 7141,
 -49781,
 1032429947,
 7122,
 -49780,
 1032482565,
 7134,
 -49779,
 1032547356,
 7110,
 -49778,
 1032612391,
 7120,
 -49777,
 1032674513,
 7140,
 -49776,
 1032737848,
 7106,
 -49775,
 1032802183,
 7118,
 -49774,
 1032861291,
 7121,
 -49773,
 1032924080,
 7137,
 -49772,
 1032988135,
 7109,
 -1,
 1033050351,
 7104,
 1033256352,
 1030344856,
 -1,
 1033321880,
 1033225418,
 7150,
 -1,
 1033241328,
 7151,
 1033452955,
 1033268246,
 -1,
 -49766,
 1033406890,
 7149,
 -1,
 1033460945,
 7147,
 1033649565,
 1033387580,
 7143,
 -1,
 1033584188,
 7145,
 -49762,
 1033607220,
 7144,
 -49761,
 1033734570,
 7148,
 -1,
 1033788625,
 7146,
 1033977256,
 1033219468,
 -1,
 1034042791,
 1033951864,
 -1,
 1034108325,
 1034000238,
 -1,
 -49756,
 1034052030,
 7165,
 -1,
 1034100794,
 7167,
 -49754,
 1034060628,
 7164,
 -1,
 1034251041,
 7166,
 -1,
 1033986195,
 7142,
 1034501547,
 1033934954,
 -1,
 -49750,
 1034456760,
 7155,
 -1,
 1034506950,
 7154,
 1034747903,
 1034433108,
 -1,
 -49747,
 1034650984,
 7152,
 -1,
 1034703906,
 7153,
 1034894768,
 1030247458,
 128704,
 -1,
 1034863374,
 128705,
 -1,
 1034861755,
 128267,
 1035091425,
 1030204812,
 -1,
 1035156959,
 1035054626,
 -1,
 1035222486,
 1035105500,
 -1,
 1035287991,
 1035157052,
 92908,
 -49738,
 1035241181,
 92880,
 -1,
 1035288124,
 92907,
 1035484602,
 1035262163,
 -1,
 -49735,
 1035427570,
 92885,
 -1,
 1035485862,
 92900,
 1035681212,
 1035456844,
 92891,
 -1,
 1035613993,
 92902,
 1035812286,
 1035650250,
 92906,
 -1,
 1035786182,
 92896,
 1035943360,
 1035766186,
 92904,
 -1,
 1035897258,
 92905,
 1036074435,
 1035889461,
 -1,
 -49726,
 1036032034,
 92888,
 -1,
 1036065007,
 92881,
 1036271046,
 1036013368,
 -1,
 -49723,
 1036200682,
 92893,
 -1,
 1036262536,
 92886,
 1036467657,
 1036203485,
 -1,
 -49720,
 1036421546,
 92894,
 -1,
 1036474524,
 92887,
 -49718,
 1036442759,
 92892,
 -49717,
 1036636406,
 92899,
 -49716,
 1036697616,
 92897,
 -49715,
 1036758839,
 92882,
 -49714,
 1036818396,
 92901,
 -49713,
 1036877112,
 92884,
 -49712,
 1036937945,
 92889,
 -49711,
 1036999889,
 92909,
 -49710,
 1037065398,
 92890,
 -49709,
 1037126157,
 92883,
 -49708,
 1037184345,
 92895,
 -49707,
 1037247975,
 92898,
 -1,
 1037310191,
 92903,
 1037516254,
 1035153783,
 -1,
 1037581786,
 1037465851,
 -1,
 -49703,
 1037504204,
 92915,
 -1,
 1037568699,
 92913,
 1037778397,
 1037523008,
 -1,
 -49700,
 1037700778,
 92916,
 -1,
 1037765307,
 92912,
 -1,
 1037729602,
 92914,
 -1,
 1037455143,
 92917,
 -49696,
 1035103446,
 127936,
 -1,
 1038041139,
 9918,
 1038237165,
 1035021186,
 -1,
 1038302699,
 1038183221,
 -1,
 1038368232,
 1038265740,
 -1,
 1038433767,
 1038315542,
 -1,
 -49690,
 1038396100,
 11101,
 -1,
 1038453725,
 11099,
 -1,
 1038391301,
 983056,
 1038745599,
 1038286848,
 -1,
 -49686,
 1038669027,
 128281,
 -1,
 1038715622,
 128386,
 -49684,
 1038270860,
 128043,
 -1,
 1038847282,
 129363,
 1039023605,
 1038189300,
 -1,
 1039089140,
 1038969653,
 127974,
 1039204351,
 1039042464,
 -1,
 -49679,
 1039129052,
 128180,
 -49678,
 1039179119,
 128183,
 -49677,
 1039222708,
 128182,
 -1,
 1039284696,
 128181,
 -1,
 1039015725,
 127820,
 1039547899,
 1038953330,
 128118,
 1039663103,
 1039466496,
 -1,
 -49672,
 1039579608,
 128700,
 -49671,
 1039609507,
 128036,
 -49670,
 1039673867,
 127868,
 -1,
 1039736830,
 128124,
 1039941118,
 1039507713,
 -1,
 -49667,
 1039869874,
 128136,
 -1,
 1039925744,
 128202,
 1040137729,
 1039879992,
 -1,
 -49664,
 1040107288,
 129366,
 -1,
 1040142302,
 128708,
 -1,
 1040071053,
 127992,
 1040400033,
 957587713,
 -1,
 1040465560,
 1040325817,
 -1,
 1040531016,
 1040413916,
 -1,
 1040596492,
 1040501882,
 -1,
 1040662027,
 1040550452,
 -1,
 1040727561,
 1040621825,
 69643,
 -1,
 1040687361,
 69644,
 1040908287,
 1040674503,
 69645,
 -1,
 1040805575,
 69646,
 -1,
 1040586991,
 69679,
 1041055250,
 1040562715,
 -1,
 1041120784,
 1041021467,
 -1,
 -49649,
 1041060920,
 69662,
 -1,
 1041111279,
 69661,
 -49647,
 1041060920,
 69667,
 -1,
 1041242351,
 69666,
 1041448471,
 1041009066,
 69649,
 1041563647,
 1041396108,
 -1,
 -49643,
 1041476693,
 69686,
 -49642,
 1041532648,
 69687,
 -1,
 1041594356,
 69685,
 1041776156,
 1041400564,
 -1,
 -49639,
 1041750316,
 69660,
 -49638,
 1041793873,
 69665,
 -49637,
 1041846151,
 69655,
 -1,
 1041897711,
 69670,
 1042103842,
 1041708509,
 -1,
 1042169376,
 1042036189,
 -1,
 -49633,
 1042109496,
 69664,
 -1,
 1042159855,
 69663,
 -49631,
 1042109496,
 69669,
 -1,
 1042290927,
 69668,
 1042497062,
 1042028783,
 69637,
 -49628,
 1042465994,
 69650,
 -49627,
 1042504913,
 69648,
 -1,
 1042553071,
 69638,
 1042759210,
 1042460044,
 -1,
 -49624,
 1042722335,
 69681,
 -49623,
 1042764856,
 69680,
 -1,
 1042815215,
 69682,
 1043021356,
 1042728138,
 69641,
 -1,
 1042990282,
 69642,
 1043152431,
 1042978670,
 -1,
 -49618,
 1043092536,
 69672,
 -1,
 1043142895,
 69671,
 1043349042,
 1043099335,
 -1,
 -49615,
 1043296005,
 69684,
 -1,
 1043339503,
 69678,
 1043545653,
 1043295029,
 -1,
 -49612,
 1043485752,
 69652,
 -1,
 1043536111,
 69651,
 1043742264,
 1043491337,
 -1,
 -49609,
 1043682360,
 69659,
 -1,
 1043732719,
 69658,
 1043938874,
 1043684561,
 69639,
 -1,
 1043881169,
 69640,
 1044069949,
 1043877688,
 -1,
 -49604,
 1044010040,
 69654,
 -1,
 1044060399,
 69653,
 1044266560,
 1043999618,
 -1,
 -49601,
 1044206648,
 69657,
 -1,
 1044257007,
 69656,
 1044463171,
 1044194738,
 -1,
 -49598,
 1044403256,
 69674,
 -1,
 1044453615,
 69673,
 -49596,
 1044437292,
 69676,
 -49595,
 1044619643,
 69677,
 -49594,
 1044675349,
 69675,
 -49593,
 1044730936,
 69683,
 -1,
 1044790844,
 69647,
 1044987494,
 1040484576,
 -1,
 1045053009,
 1044953627,
 -1,
 1045118541,
 1045025036,
 -1,
 -49588,
 1045072298,
 69715,
 -1,
 1045120212,
 69724,
 1045315152,
 1045058594,
 -1,
 -49585,
 1045275888,
 69716,
 -1,
 1045325633,
 69725,
 -1,
 1045250916,
 69723,
 1045577302,
 1045015948,
 -1,
 1045642836,
 1045522819,
 69719,
 -1,
 1045611699,
 69728,
 1045823487,
 1045579743,
 69720,
 -1,
 1045742771,
 69729,
 1045904989,
 1045514680,
 -1,
 1045970522,
 1045858730,
 -1,
 -49575,
 1045940933,
 69717,
 -1,
 1045998836,
 69726,
 1046216703,
 1045912785,
 -1,
 -49572,
 1046138213,
 69718,
 -1,
 1046171423,
 69727,
 1046363745,
 1045859764,
 69714,
 1046478847,
 1046282240,
 -1,
 -49568,
 1046396309,
 69733,
 -1,
 1046436951,
 69732,
 1046625891,
 1046316592,
 69722,
 -1,
 1046594739,
 69731,
 1046756965,
 1046561333,
 69721,
 -1,
 1046730963,
 69730,
 -1,
 1046702823,
 69759,
 1046953593,
 1044958330,
 -1,
 1047019128,
 1046910702,
 -1,
 1047084653,
 1046990779,
 -1,
 1047150187,
 1047044353,
 69694,
 -1,
 1047109889,
 69695,
 1047330815,
 1047097031,
 69696,
 -1,
 1047228103,
 69697,
 1047412337,
 1047009519,
 -1,
 -49553,
 1047381194,
 69701,
 -49552,
 1047420113,
 69699,
 -1,
 1047468271,
 69688,
 1047674483,
 1047381194,
 69692,
 -1,
 1047643338,
 69693,
 1047805557,
 1047616721,
 69690,
 -1,
 1047747793,
 69691,
 -49546,
 1047759274,
 69700,
 -49545,
 1047871036,
 69698,
 -1,
 1047930945,
 69689,
 -1,
 1046963885,
 69702,
 1048198794,
 1046885853,
 -1,
 1048264328,
 1048141910,
 -1,
 1048329854,
 1048230427,
 -1,
 -49539,
 1048303114,
 69736,
 -1,
 1048337216,
 69737,
 1048526465,
 1048292748,
 -1,
 -49536,
 1048471939,
 69740,
 -1,
 1048528863,
 69741,
 1048723076,
 1048463800,
 -1,
 -49533,
 1048679364,
 69738,
 -1,
 1048733905,
 69739,
 -49531,
 1048697841,
 69734,
 -49530,
 1048874420,
 69735,
 -49529,
 1048938032,
 69743,
 -1,
 1048986165,
 69742,
 -49527,
 1048220493,
 69704,
 -1,
 1049108397,
 69703,
 1049312912,
 1048162959,
 -1,
 -49524,
 1049284478,
 69634,
 -49523,
 1049348583,
 69636,
 -49522,
 1049389738,
 69635,
 -49521,
 1049439305,
 69632,
 -1,
 1049501862,
 69633,
 1049755647,
 1049271999,
 -1,
 1049771668,
 1049652935,
 -1,
 -49517,
 1049727806,
 69709,
 -1,
 1049780911,
 69707,
 1049968279,
 1049704877,
 -1,
 -49514,
 1049937409,
 69706,
 -1,
 1049999899,
 69705,
 -1,
 1049899930,
 69708,
 1050230429,
 1040407761,
 -1,
 1050295964,
 1050162653,
 -1,
 -49509,
 1050235076,
 127753,
 -1,
 1050296113,
 128112,
 -1,
 1050231152,
 128188,
 1050558112,
 1050165075,
 -1,
 -49505,
 1050504016,
 983124,
 -1,
 1050555869,
 127838,
 -1,
 1050512365,
 128148,
 1050820390,
 1040340100,
 -1,
 1050885855,
 1050768604,
 -1,
 1050951337,
 1050856570,
 -1,
 1051016872,
 1050905140,
 -1,
 1051082407,
 1050976513,
 72710,
 -1,
 1051042049,
 72711,
 -1,
 1051029191,
 72712,
 -1,
 1050941679,
 72746,
 1051344559,
 1050917403,
 -1,
 1051410093,
 1051310619,
 -1,
 -49492,
 1051350072,
 72729,
 -1,
 1051400431,
 72728,
 -49490,
 1051350072,
 72734,
 -1,
 1051531503,
 72733,
 1051737780,
 1051296500,
 -1,
 -49487,
 1051711788,
 72727,
 -49486,
 1051755345,
 72732,
 -49485,
 1051807623,
 72722,
 -1,
 1051859183,
 72737,
 1052065466,
 1051669981,
 -1,
 1052131000,
 1051997661,
 -1,
 -49481,
 1052070968,
 72731,
 -1,
 1052121327,
 72730,
 -49479,
 1052070968,
 72736,
 -1,
 1052252399,
 72735,
 1052458686,
 1051990255,
 72704,
 -49476,
 1052427466,
 72717,
 -49475,
 1052466385,
 72715,
 -1,
 1052514543,
 72705,
 1052720834,
 1052421516,
 -1,
 -49472,
 1052683807,
 72748,
 -49471,
 1052726328,
 72747,
 -1,
 1052776687,
 72749,
 1052982980,
 1052689610,
 72708,
 -1,
 1052951754,
 72709,
 1053114055,
 1052940142,
 -1,
 -49466,
 1053054008,
 72739,
 -1,
 1053104367,
 72738,
 1053310666,
 1053059893,
 -1,
 -49463,
 1053250616,
 72719,
 -1,
 1053300975,
 72718,
 1053507277,
 1053256201,
 -1,
 -49460,
 1053447224,
 72726,
 -1,
 1053497583,
 72725,
 1053703887,
 1053449425,
 72706,
 -1,
 1053646033,
 72707,
 1053834962,
 1053642552,
 -1,
 -49455,
 1053774904,
 72721,
 -1,
 1053825263,
 72720,
 1054031573,
 1053764482,
 -1,
 -49452,
 1053971512,
 72724,
 -1,
 1054021871,
 72723,
 1054228184,
 1053959602,
 -1,
 -49449,
 1054168120,
 72741,
 -1,
 1054218479,
 72740,
 -49447,
 1054202156,
 72743,
 -49446,
 1054384507,
 72744,
 -49445,
 1054443946,
 72716,
 -49444,
 1054505749,
 72742,
 -49443,
 1054568197,
 72745,
 -49442,
 1054626872,
 72750,
 -1,
 1054686780,
 72714,
 1054883577,
 1050839264,
 -1,
 1054949096,
 1054849563,
 -1,
 1055014628,
 1054920972,
 -1,
 -49437,
 1054968234,
 72795,
 -1,
 1055016148,
 72804,
 1055211239,
 1054954530,
 -1,
 -49434,
 1055171824,
 72796,
 -1,
 1055221569,
 72805,
 -1,
 1055146852,
 72803,
 1055473389,
 1054911884,
 -1,
 1055538923,
 1055418755,
 72799,
 -1,
 1055507635,
 72808,
 1055719423,
 1055475679,
 72800,
 -1,
 1055638707,
 72809,
 1055801076,
 1055410616,
 -1,
 1055866609,
 1055754666,
 -1,
 -49424,
 1055836869,
 72797,
 -1,
 1055894772,
 72806,
 1056112639,
 1055808721,
 -1,
 -49421,
 1056034149,
 72798,
 -1,
 1056067359,
 72807,
 1056259830,
 1055753776,
 72802,
 -1,
 1056228531,
 72811,
 1056390904,
 1056195125,
 72801,
 -1,
 1056364755,
 72810,
 -1,
 1056345524,
 72794,
 1056587528,
 1054855320,
 -1,
 1056653054,
 1056559035,
 -1,
 1056718589,
 1056612609,
 72756,
 -1,
 1056678145,
 72757,
 -1,
 1056665287,
 72758,
 1056915202,
 1056577775,
 -1,
 -49408,
 1056883914,
 72763,
 -49407,
 1056922833,
 72761,
 -1,
 1056970991,
 72751,
 1057177348,
 1056883914,
 72754,
 -1,
 1057146058,
 72755,
 1057308422,
 1057119441,
 72752,
 -1,
 1057250513,
 72753,
 -49401,
 1057261994,
 72762,
 -1,
 1057373756,
 72760,
 1057570585,
 1056519645,
 -1,
 1057636119,
 1057513558,
 -1,
 1057701645,
 1057602075,
 -1,
 -49396,
 1057674762,
 72786,
 -1,
 1057708864,
 72787,
 1057898256,
 1057664396,
 -1,
 -49393,
 1057843587,
 72790,
 -1,
 1057900511,
 72791,
 1058094867,
 1057835448,
 -1,
 -49390,
 1058051012,
 72788,
 -1,
 1058105553,
 72789,
 -49388,
 1058069489,
 72784,
 -49387,
 1058246068,
 72785,
 -49386,
 1058309680,
 72793,
 -1,
 1058357813,
 72792,
 -49384,
 1057592141,
 72770,
 -1,
 1058480045,
 72769,
 1058684705,
 1057534607,
 -1,
 1058750237,
 1058656062,
 -1,
 -49380,
 1058713302,
 72766,
 -1,
 1058775719,
 72767,
 1058946848,
 1058674927,
 -1,
 -49377,
 1058917523,
 72768,
 -1,
 1058965797,
 72765,
 -1,
 1058876489,
 72764,
 1059208996,
 1058623549,
 -1,
 -49373,
 1059131856,
 72773,
 -1,
 1059197093,
 72772,
 -49371,
 1059182434,
 72771,
 -1,
 1059347573,
 72812,
 1059536808,
 1050767047,
 -1,
 1059602338,
 1059461780,
 -1,
 1059667770,
 1059551935,
 -1,
 1059733305,
 1059602656,
 -1,
 1059798830,
 1059679943,
 -1,
 1059864365,
 1059733927,
 9204,
 -1,
 1059783124,
 11207,
 -1,
 1059821377,
 11047,
 1060060978,
 1059730909,
 -1,
 1060126513,
 1060017936,
 9207,
 -1,
 1060045268,
 11206,
 -1,
 1060068756,
 11045,
 1060323124,
 1060030930,
 9206,
 -1,
 1060241876,
 11205,
 1060454199,
 1060287440,
 -1,
 -49354,
 1060403670,
 128927,
 -1,
 1060452513,
 128921,
 1060700159,
 1060415656,
 9205,
 -1,
 1060569556,
 11208,
 -1,
 1059688313,
 9912,
 1060847433,
 1059630476,
 -1,
 1060912959,
 1060806679,
 -1,
 -49347,
 1060850961,
 9209,
 -49346,
 1060908458,
 11200,
 -1,
 1060973398,
 128306,
 1061175107,
 1060862947,
 -1,
 -49343,
 1061140251,
 11089,
 -49342,
 1061190102,
 11050,
 -1,
 1061238945,
 11049,
 1061437254,
 1061123713,
 -1,
 -49339,
 1061402143,
 128909,
 -1,
 1061433167,
 128900,
 -49337,
 1061390265,
 9927,
 -49336,
 1061580411,
 128369,
 -1,
 1061624833,
 9984,
 1061830489,
 1060776834,
 -1,
 1061896023,
 1061800868,
 -1,
 1061961550,
 1061866107,
 -1,
 -49331,
 1061923047,
 11179,
 -1,
 1061975000,
 11178,
 1062158161,
 1061923031,
 -1,
 -49328,
 1062128264,
 11181,
 -1,
 1062157619,
 11183,
 1062354772,
 1062106057,
 -1,
 -49325,
 1062324872,
 11180,
 -1,
 1062354227,
 11182,
 1062600703,
 1062288635,
 -1,
 -49322,
 1062512871,
 11177,
 -1,
 1062564824,
 11176,
 -49320,
 1061858249,
 9960,
 -1,
 1062692537,
 9210,
 1062879076,
 1061789953,
 -1,
 1062944611,
 1062821844,
 -1,
 1063010145,
 1062866696,
 -1,
 1063075678,
 1062943770,
 9193,
 -1,
 1062997475,
 9197,
 -49313,
 1063043499,
 9199,
 -49312,
 1063164440,
 11091,
 -1,
 1063217057,
 128898,
 -49310,
 1062982101,
 11166,
 -1,
 1063323670,
 128413,
 -1,
 1062900279,
 127990,
 1063599985,
 1062825671,
 -1,
 1063665518,
 1063534984,
 -1,
 1063731050,
 1063587592,
 -1,
 1063796585,
 1063664666,
 9194,
 -1,
 1063718371,
 9198,
 -1,
 1063741345,
 128896,
 1063993197,
 1063649280,
 -1,
 -49300,
 1063951500,
 128412,
 -1,
 1064005643,
 9944,
 -1,
 1063965141,
 11164,
 1064304639,
 1063592383,
 -1,
 -49296,
 1064220191,
 11035,
 -1,
 1064251215,
 11044,
 1064451966,
 1063531997,
 -1,
 1064517496,
 1064408830,
 -1,
 1064583030,
 1064439560,
 -1,
 -49291,
 1064527777,
 128899,
 -1,
 1064582170,
 9196,
 -49289,
 1064554965,
 11167,
 -1,
 1064699926,
 128419,
 1064910717,
 1064476929,
 -1,
 1064976252,
 1064838368,
 -1,
 -49285,
 1064926275,
 9922,
 -1,
 1064988031,
 9923,
 -1,
 1064931469,
 127778,
 -1,
 1064852899,
 11201,
 1065303942,
 1064417819,
 -1,
 1065369475,
 1065248295,
 -1,
 -49279,
 1065334303,
 128908,
 -49278,
 1065384406,
 128925,
 -1,
 1065433249,
 128919,
 -49276,
 1065342726,
 9942,
 -49275,
 1065594107,
 9951,
 -1,
 1065653127,
 128383,
 1065828236,
 1065274866,
 -1,
 1065893771,
 1065801981,
 -1,
 -49271,
 1065858591,
 11037,
 -49270,
 1065908694,
 128926,
 -1,
 1065957537,
 128920,
 -1,
 1065860765,
 11054,
 1066221458,
 1065797913,
 -1,
 1066286992,
 1066143496,
 -1,
 -49265,
 1066231713,
 128897,
 -1,
 1066286106,
 9195,
 -49263,
 1066258901,
 11165,
 -1,
 1066403862,
 128418,
 1066614680,
 1066161186,
 -1,
 1066680214,
 1066548796,
 -1,
 -49259,
 1066653699,
 11042,
 -1,
 1066672862,
 128420,
 -49257,
 1066635659,
 11052,
 -1,
 1066803602,
 128426,
 1067007901,
 1066571630,
 -1,
 1067073436,
 1066943332,
 -1,
 -49253,
 1067039454,
 11039,
 -1,
 1067090828,
 127986,
 -1,
 1067043831,
 128392,
 1067335584,
 1066944952,
 -1,
 -49249,
 1067289709,
 128447,
 -1,
 1067347829,
 9873,
 -49247,
 1067294909,
 10067,
 -1,
 1067485817,
 11204,
 1067663269,
 1059571448,
 -1,
 -49244,
 1067603649,
 128153,
 -1,
 1067657709,
 128216,
 1067909119,
 1067616682,
 -1,
 -49241,
 1067832087,
 128033,
 -1,
 1067890391,
 127804,
 1068056537,
 1059505354,
 -1,
 1068122063,
 1067994936,
 128027,
 1068236799,
 1068065489,
 -1,
 1068253127,
 1068135644,
 -1,
 1068318645,
 1068204788,
 -1,
 1068384176,
 1068292307,
 -1,
 -49233,
 1068313520,
 6671,
 -1,
 1068374255,
 6670,
 1068580787,
 1068322616,
 -1,
 -49230,
 1068526471,
 6659,
 -1,
 1068570863,
 6658,
 -49228,
 1068540283,
 6667,
 -1,
 1068701935,
 6666,
 1068908472,
 1068268223,
 -1,
 -49225,
 1068865500,
 6663,
 -1,
 1068898543,
 6662,
 -49223,
 1068882220,
 6672,
 -49222,
 1069075600,
 6675,
 -49221,
 1069136541,
 6664,
 -49220,
 1069198879,
 6676,
 -49219,
 1069261179,
 6673,
 -49218,
 1069324252,
 6660,
 -49217,
 1069379333,
 6674,
 -49216,
 1069443975,
 6656,
 -49215,
 1069509159,
 6669,
 -49214,
 1069569080,
 6678,
 -49213,
 1069633415,
 6657,
 -49212,
 1069692523,
 6665,
 -49211,
 1069755312,
 6668,
 -49210,
 1069819367,
 6661,
 -1,
 1069881583,
 6677,
 1070088141,
 1068224664,
 -1,
 -49207,
 1070056650,
 6680,
 -49206,
 1070107050,
 6682,
 -49205,
 1070161105,
 6679,
 -49204,
 1070218812,
 6681,
 -1,
 1070275439,
 6683,
 -49202,
 1070045258,
 6686,
 -1,
 1070416889,
 6687,
 1070612436,
 1068084620,
 128652,
 1070677971,
 1070578203,
 -1,
 -49198,
 1070640545,
 128101,
 -1,
 1070662533,
 128100,
 -1,
 1070598439,
 128655,
 1070940118,
 1070561231,
 128363,
 -1,
 1070861733,
 128364,
 -49193,
 1070908146,
 129419,
 -49192,
 1071033439,
 127791,
 -1,
 1071079644,
 127959,
 1071267843,
 1068009898,
 -1,
 1071333347,
 1071235781,
 -1,
 1071398882,
 1071287487,
 -1,
 -49187,
 1071366348,
 9185,
 -49186,
 1071425420,
 11813,
 -49185,
 1071487248,
 9181,
 -49184,
 1071542973,
 11812,
 -49183,
 1071600850,
 11211,
 -1,
 1071658355,
 9183,
 -1,
 1071346147,
 127870,
 1071923181,
 1071280457,
 -1,
 1071988711,
 1071895328,
 -1,
 -49178,
 1071953439,
 128912,
 -1,
 1071984463,
 128902,
 1072185322,
 1071951244,
 -1,
 -49175,
 1072130458,
 128951,
 -1,
 1072176845,
 128939,
 -49173,
 1072124796,
 128932,
 -49172,
 1072319512,
 128945,
 -1,
 1072382560,
 128957,
 1072578546,
 1071881504,
 -1,
 -49169,
 1072553135,
 12730,
 -49168,
 1072592290,
 12729,
 -49167,
 1072652445,
 12589,
 -1,
 1072714109,
 12728,
 1072906230,
 1072532413,
 128366,
 1072971765,
 1072856208,
 128278,
 -1,
 1072892246,
 128209,
 -1,
 1072934284,
 128218,
 1073168379,
 1072877836,
 -1,
 1073233914,
 1073114823,
 -1,
 -49159,
 1073177304,
 127923,
 -1,
 1073218834,
 128335,
 -1,
 1073152077,
 127993,
 1073496061,
 1073141971,
 128102,
 -1,
 1073458699,
 128713,
 1073627135,
 1073466047,
 128144,
 -1,
 1073546493,
 127893,
 1073758209,
 1073576639,
 983254,
 -1,
 1073685938,
 128163,
 -49150,
 1073731717,
 129354,
 -1,
 1073815838,
 128023,
 1074020381,
 1071201852,
 -1,
 1074085904,
 1073971956,
 -1,
 1074151436,
 1074024437,
 -1,
 1074216969,
 1074099428,
 -1,
 -49144,
 1074161196,
 983630,
 -1,
 1074208690,
 2510,
 -49142,
 1074180757,
 2493,
 -49141,
 1074352160,
 2555,
 -1,
 1074405461,
 2432,
 1074610191,
 1074117147,
 -1,
 -49138,
 1074563500,
 127857,
 -1,
 1074594051,
 11102,
 -1,
 1074584539,
 9187,
 1074872343,
 1074010351,
 -1,
 1074937876,
 1074822600,
 -1,
 -49133,
 1074870234,
 127901,
 -1,
 1074930476,
 127900,
 -49131,
 1074904993,
 128147,
 -49130,
 1075093784,
 128059,
 -1,
 1075129866,
 127958,
 1075331099,
 1074818759,
 983055,
 1075445759,
 1075277511,
 128276,
 -49126,
 1075337763,
 128718,
 -1,
 1075383084,
 128277,
 -49124,
 1075266972,
 127866,
 -1,
 1075525085,
 128719,
 1075724326,
 1073962193,
 -1,
 1075789857,
 1075683585,
 -1,
 -49120,
 1075756318,
 127874,
 -1,
 1075787229,
 128038,
 1075986468,
 1075721688,
 -1,
 -49117,
 1075931093,
 128692,
 -1,
 1075985980,
 128690,
 -49115,
 1075935190,
 127921,
 -1,
 1076129166,
 128089,
 1076314153,
 1075697875,
 -1,
 -49112,
 1076288391,
 983258,
 -1,
 1076345769,
 983253,
 -49110,
 1076276620,
 983057,
 -1,
 1076468408,
 983125,
 1076642805,
 957533306,
 -1,
 1076707977,
 1076566255,
 -1,
 1076773256,
 1076649171,
 -1,
 1076838775,
 1076738471,
 -1,
 1076904292,
 1076787088,
 -1,
 1076969571,
 1076855540,
 -1,
 1077035070,
 1076907832,
 42507,
 1077100603,
 1076973368,
 -1,
 1077166134,
 1077034556,
 42500,
 -49099,
 1077117684,
 42501,
 -1,
 1077165628,
 42271,
 1077362744,
 1077119402,
 42460,
 -1,
 1077316010,
 42384,
 -49095,
 1077331146,
 42421,
 -49094,
 1077435601,
 42308,
 -1,
 1077483759,
 42348,
 -49092,
 1077054770,
 42428,
 -49091,
 1077625700,
 42467,
 -1,
 1077681949,
 42315,
 1077887052,
 1076966877,
 -1,
 1077952583,
 1077840298,
 42450,
 1078018118,
 1077899698,
 -1,
 -49086,
 1077982572,
 42514,
 -49085,
 1078033173,
 42538,
 -49084,
 1078094727,
 42513,
 -49083,
 1078151693,
 42512,
 -1,
 1078213037,
 42539,
 -1,
 1077971370,
 42374,
 1078476873,
 1077886524,
 42490,
 -1,
 1078410812,
 42261,
 -49078,
 1078445258,
 42411,
 -49077,
 1078549713,
 42298,
 -1,
 1078597871,
 42337,
 1078804564,
 1077860563,
 -1,
 1078870095,
 1078757802,
 42464,
 -1,
 1078823338,
 42388,
 1079001169,
 1078804028,
 42506,
 -1,
 1078935100,
 42275,
 -49070,
 1078969546,
 42425,
 -49069,
 1079074001,
 42312,
 -1,
 1079122159,
 42352,
 1079328860,
 1078749705,
 -1,
 1079394391,
 1079282090,
 42457,
 -1,
 1079347626,
 42381,
 1079525465,
 1079328316,
 42497,
 -1,
 1079459388,
 42268,
 -49062,
 1079493834,
 42418,
 -49061,
 1079598289,
 42305,
 -1,
 1079646447,
 42344,
 1079853150,
 1079282090,
 42463,
 -1,
 1079806378,
 42387,
 1079984224,
 1079787068,
 42505,
 -1,
 1079918140,
 42274,
 -49055,
 1079952586,
 42424,
 -49054,
 1080057041,
 42311,
 -1,
 1080105199,
 42351,
 1080311931,
 1076918975,
 -1,
 1080377452,
 1080250495,
 -1,
 1080442983,
 1080330666,
 42438,
 -1,
 1080396202,
 42363,
 1080574057,
 1080376892,
 42478,
 -1,
 1080507964,
 42250,
 -49046,
 1080542410,
 42400,
 -49045,
 1080646865,
 42287,
 -1,
 1080695023,
 42326,
 1080901748,
 1080305074,
 -1,
 1080967279,
 1080854954,
 42436,
 -1,
 1080920490,
 42361,
 1081098353,
 1080901180,
 42475,
 -1,
 1081032252,
 42248,
 -49038,
 1081066698,
 42398,
 -49037,
 1081171153,
 42285,
 -1,
 1081219311,
 42323,
 1081426038,
 1080854954,
 42462,
 -1,
 1081379242,
 42386,
 1081557112,
 1081359932,
 42504,
 -1,
 1081491004,
 42273,
 -49031,
 1081525450,
 42423,
 -49030,
 1081629905,
 42310,
 -1,
 1081678063,
 42350,
 1081884819,
 1080243677,
 -1,
 1081950348,
 1081824290,
 -1,
 1082015877,
 1081889826,
 -1,
 1082081408,
 1081969066,
 42446,
 -1,
 1082034602,
 42370,
 1082212482,
 1082015292,
 42486,
 -1,
 1082146364,
 42257,
 -49021,
 1082180810,
 42407,
 -49020,
 1082285265,
 42294,
 -1,
 1082333423,
 42333,
 1082540167,
 1081969066,
 42445,
 -1,
 1082493354,
 42369,
 1082671241,
 1082474044,
 42485,
 -1,
 1082605116,
 42256,
 -49014,
 1082639562,
 42406,
 -49013,
 1082744017,
 42293,
 -1,
 1082792175,
 42332,
 1082998926,
 1081903530,
 42449,
 -1,
 1082952106,
 42373,
 1083130000,
 1082932796,
 42489,
 -1,
 1083063868,
 42260,
 -49007,
 1083098314,
 42410,
 -49006,
 1083202769,
 42297,
 -1,
 1083250927,
 42336,
 1083457702,
 1081830197,
 -1,
 1083523230,
 1083414382,
 -1,
 1083588760,
 1083457084,
 42476,
 -49001,
 1083540212,
 42477,
 -1,
 1083588156,
 42249,
 1083785370,
 1083541930,
 42437,
 -1,
 1083738538,
 42362,
 1083916444,
 1083709679,
 42324,
 -1,
 1083867892,
 42325,
 -48995,
 1083884746,
 42399,
 -1,
 1083989201,
 42286,
 1084178592,
 1083476394,
 42459,
 -1,
 1084131754,
 42383,
 1084309666,
 1084112444,
 42499,
 -1,
 1084243516,
 42270,
 1084440740,
 1084233967,
 42346,
 -1,
 1084392180,
 42347,
 -48987,
 1084409034,
 42420,
 -1,
 1084513489,
 42307,
 1084702905,
 1083395896,
 -1,
 1084768433,
 1084630450,
 -1,
 1084833963,
 1084721578,
 42439,
 -48982,
 1084787114,
 42364,
 -1,
 1084850932,
 42440,
 1085030574,
 1084767804,
 42479,
 -48979,
 1084982004,
 42480,
 -1,
 1085029948,
 42251,
 -48977,
 1084998858,
 42401,
 -48976,
 1085168849,
 42288,
 -1,
 1085217007,
 42327,
 1085423796,
 1084702268,
 42502,
 -48973,
 1085375220,
 42503,
 -1,
 1085423164,
 42272,
 1085620406,
 1085376938,
 42461,
 -1,
 1085573546,
 42385,
 -48969,
 1085588682,
 42422,
 -48968,
 1085693137,
 42309,
 -1,
 1085741295,
 42349,
 1085948105,
 1084676911,
 -1,
 1086013634,
 1085887522,
 -1,
 1086079165,
 1085966762,
 42454,
 -1,
 1086032298,
 42378,
 1086210239,
 1086012988,
 42494,
 -1,
 1086144060,
 42265,
 -48960,
 1086178506,
 42415,
 -48959,
 1086282961,
 42302,
 -1,
 1086331119,
 42341,
 1086537924,
 1085966762,
 42453,
 -1,
 1086491050,
 42377,
 1086668998,
 1086471740,
 42493,
 -1,
 1086602812,
 42264,
 -48953,
 1086637258,
 42414,
 -48952,
 1086741713,
 42301,
 -1,
 1086789871,
 42340,
 1086996696,
 1085919500,
 -1,
 1087062222,
 1086949802,
 42431,
 1087127757,
 1087015338,
 42356,
 -1,
 1087079156,
 42357,
 -1,
 1087079156,
 42432,
 1087324370,
 1086996028,
 42470,
 1087389905,
 1087258172,
 42243,
 -1,
 1087341300,
 42244,
 -1,
 1087341300,
 42471,
 1087586516,
 1087292618,
 42393,
 -1,
 1087537908,
 42394,
 1087717590,
 1087528145,
 42280,
 -1,
 1087668980,
 42281,
 1087897599,
 1087641839,
 42318,
 -1,
 1087800052,
 42319,
 1087979752,
 1086962203,
 -1,
 1088045281,
 1087919138,
 -1,
 1088110812,
 1087998378,
 42444,
 -1,
 1088063914,
 42368,
 1088241886,
 1088044604,
 42484,
 -1,
 1088175676,
 42255,
 -48929,
 1088210122,
 42405,
 -48928,
 1088314577,
 42292,
 -1,
 1088362735,
 42331,
 1088569571,
 1087998378,
 42443,
 -1,
 1088522666,
 42367,
 1088700645,
 1088503356,
 42483,
 -1,
 1088634428,
 42254,
 -48922,
 1088668874,
 42404,
 -48921,
 1088773329,
 42291,
 -1,
 1088821487,
 42330,
 1089028344,
 1087942028,
 -1,
 1089093873,
 1088967714,
 -1,
 1089159404,
 1089046954,
 42452,
 -1,
 1089112490,
 42376,
 1089290478,
 1089093180,
 42492,
 -1,
 1089224252,
 42263,
 -48913,
 1089258698,
 42413,
 -48912,
 1089363153,
 42300,
 -1,
 1089411311,
 42339,
 1089618163,
 1089046954,
 42451,
 -1,
 1089571242,
 42375,
 1089749237,
 1089551932,
 42491,
 -1,
 1089683004,
 42262,
 -48906,
 1089717450,
 42412,
 -48905,
 1089821905,
 42299,
 -1,
 1089870063,
 42338,
 1090076936,
 1088955826,
 -1,
 1090142465,
 1090016290,
 -1,
 1090207996,
 1090095530,
 42434,
 -1,
 1090161066,
 42359,
 1090339070,
 1090141756,
 42473,
 -1,
 1090272828,
 42246,
 -48897,
 1090307274,
 42396,
 -48896,
 1090411729,
 42283,
 -1,
 1090459887,
 42321,
 1090666755,
 1090095530,
 42435,
 -1,
 1090619818,
 42360,
 1090797829,
 1090600508,
 42474,
 -1,
 1090731580,
 42247,
 -48890,
 1090766026,
 42397,
 -48889,
 1090870481,
 42284,
 -1,
 1090918639,
 42322,
 1091125525,
 1090016290,
 -1,
 1091191052,
 1091078570,
 42429,
 -48885,
 1091144106,
 42355,
 -1,
 1091207924,
 42430,
 1091387663,
 1091124796,
 42468,
 -48882,
 1091338996,
 42469,
 -1,
 1091386940,
 42242,
 1091584273,
 1091355850,
 42391,
 -1,
 1091535604,
 42392,
 1091715347,
 1091525841,
 42278,
 -1,
 1091666676,
 42279,
 1091895295,
 1091639535,
 42316,
 -1,
 1091797748,
 42317,
 1091977502,
 1091071687,
 -1,
 1092043033,
 1091911228,
 42487,
 -48872,
 1091995099,
 42508,
 -1,
 1092042300,
 42258,
 1092239643,
 1091996074,
 42447,
 -1,
 1092192682,
 42371,
 -48868,
 1092207818,
 42408,
 -48867,
 1092312273,
 42295,
 -1,
 1092360431,
 42334,
 1092567334,
 1091950803,
 -1,
 1092632865,
 1092520362,
 42458,
 -1,
 1092585898,
 42382,
 1092763939,
 1092566588,
 42498,
 -1,
 1092697660,
 42269,
 -48860,
 1092732106,
 42419,
 -48859,
 1092836561,
 42306,
 -1,
 1092884719,
 42345,
 1093091630,
 1092537466,
 -1,
 1093157161,
 1093044650,
 42442,
 -1,
 1093110186,
 42366,
 1093288235,
 1093090876,
 42482,
 -1,
 1093221948,
 42253,
 -48852,
 1093256394,
 42403,
 -48851,
 1093360849,
 42290,
 -1,
 1093409007,
 42329,
 1093615926,
 1093050625,
 -1,
 1093681457,
 1093568938,
 42448,
 -1,
 1093634474,
 42372,
 1093812531,
 1093615164,
 42488,
 -1,
 1093746236,
 42259,
 -48844,
 1093780682,
 42409,
 -48843,
 1093885137,
 42296,
 -1,
 1093933295,
 42335,
 1094140222,
 1093572462,
 -1,
 1094205753,
 1094093226,
 42433,
 -1,
 1094158762,
 42358,
 1094336827,
 1094139452,
 42472,
 -1,
 1094270524,
 42245,
 -48836,
 1094304970,
 42395,
 -48835,
 1094409425,
 42282,
 -1,
 1094457583,
 42320,
 1094664518,
 1094085129,
 -1,
 1094730049,
 1094617514,
 42456,
 -1,
 1094683050,
 42380,
 1094861123,
 1094663740,
 42496,
 -1,
 1094794812,
 42267,
 -48828,
 1094829258,
 42417,
 -48827,
 1094933713,
 42304,
 -1,
 1094981871,
 42343,
 1095188814,
 1094601144,
 -1,
 1095254345,
 1095141802,
 42441,
 -1,
 1095207338,
 42365,
 1095385419,
 1095188028,
 42481,
 -1,
 1095319100,
 42252,
 -48820,
 1095353546,
 42402,
 -48819,
 1095458001,
 42289,
 -1,
 1095506159,
 42328,
 1095713110,
 1095117698,
 -1,
 1095778641,
 1095666090,
 42455,
 -1,
 1095731626,
 42379,
 1095909715,
 1095712316,
 42495,
 -1,
 1095843388,
 42266,
 -48812,
 1095877834,
 42416,
 -48811,
 1095982289,
 42303,
 -1,
 1096030447,
 42342,
 1096237402,
 1095666090,
 42426,
 1096302937,
 1096190378,
 42353,
 -1,
 1096254196,
 42354,
 -1,
 1096254196,
 42427,
 1096499550,
 1096171068,
 42465,
 1096565085,
 1096433212,
 42240,
 -1,
 1096516340,
 42241,
 -1,
 1096516340,
 42466,
 1096761696,
 1096467658,
 42389,
 -1,
 1096712948,
 42390,
 1096892770,
 1096703185,
 42276,
 -1,
 1096844020,
 42277,
 1097072639,
 1096816879,
 42313,
 -1,
 1096975092,
 42314,
 1097203711,
 1076854132,
 -1,
 1097220457,
 1097120283,
 -1,
 -48793,
 1097174634,
 42525,
 -48792,
 1097229016,
 42517,
 -1,
 1097275805,
 42521,
 1097482606,
 1097151965,
 -1,
 1097548141,
 1097435562,
 -1,
 -48788,
 1097502314,
 42523,
 -1,
 1097535218,
 42526,
 -1,
 1097474017,
 42522,
 1097810289,
 1097427765,
 -1,
 -48784,
 1097779381,
 42524,
 -1,
 1097810244,
 42516,
 1098006900,
 1097746872,
 -1,
 -48781,
 1097941316,
 42515,
 -1,
 1097996701,
 42520,
 -48779,
 1097958944,
 42518,
 -48778,
 1098148596,
 42527,
 -1,
 1098196577,
 42519,
 1098400133,
 1076771036,
 -1,
 1098465659,
 1098365467,
 -1,
 -48774,
 1098438154,
 42530,
 -1,
 1098472256,
 42531,
 1098662270,
 1098427788,
 -1,
 -48771,
 1098606979,
 42534,
 -1,
 1098663903,
 42535,
 1098858881,
 1098598840,
 -1,
 -48768,
 1098814404,
 42532,
 -1,
 1098868945,
 42533,
 -48766,
 1098832881,
 42528,
 -48765,
 1099009460,
 42529,
 -48764,
 1099073072,
 42537,
 -1,
 1099121205,
 42536,
 -48762,
 1098358959,
 42511,
 -48761,
 1099255591,
 42510,
 -1,
 1099313592,
 42509,
 1099563007,
 1076733656,
 -1,
 1099579896,
 1099436197,
 -1,
 1099645333,
 1099503677,
 917762,
 -48756,
 1099569213,
 917942,
 -48755,
 1099634572,
 917941,
 -48754,
 1099699884,
 917940,
 -48753,
 1099765212,
 917939,
 -48752,
 1099830503,
 917938,
 -48751,
 1099895827,
 917937,
 -48750,
 1099961077,
 917936,
 -48749,
 1100026320,
 917935,
 -48748,
 1100091557,
 917934,
 -1,
 1100156824,
 917933,
 1100366240,
 1099569036,
 917761,
 -48745,
 1100290109,
 917932,
 -48744,
 1100355468,
 917931,
 -48743,
 1100420780,
 917930,
 -48742,
 1100486108,
 917929,
 -48741,
 1100551399,
 917928,
 -48740,
 1100616723,
 917927,
 -48739,
 1100681973,
 917926,
 -48738,
 1100747216,
 917925,
 -48737,
 1100812453,
 917924,
 -1,
 1100877720,
 917923,
 1101087147,
 1100289708,
 917760,
 -48734,
 1101011005,
 917922,
 -48733,
 1101076364,
 917921,
 -48732,
 1101141676,
 917920,
 -48731,
 1101207004,
 917919,
 -48730,
 1101272295,
 917918,
 -48729,
 1101337619,
 917917,
 -48728,
 1101402869,
 917916,
 -48727,
 1101468112,
 917915,
 -48726,
 1101533349,
 917914,
 -1,
 1101598616,
 917913,
 1101808054,
 1101010396,
 -1,
 -48723,
 1101731901,
 917912,
 -48722,
 1101797260,
 917911,
 -48721,
 1101862572,
 917910,
 -48720,
 1101927900,
 917909,
 -48719,
 1101993191,
 917908,
 -48718,
 1102058515,
 917907,
 -48717,
 1102123765,
 917906,
 -48716,
 1102189008,
 917905,
 -48715,
 1102254245,
 917904,
 -1,
 1102319512,
 917903,
 1102528961,
 1101731047,
 -1,
 -48712,
 1102452797,
 917902,
 -48711,
 1102518156,
 917901,
 -48710,
 1102583468,
 917900,
 -48709,
 1102648796,
 917899,
 -48708,
 1102714087,
 917898,
 -48707,
 1102779411,
 917897,
 -48706,
 1102844661,
 917896,
 -48705,
 1102909904,
 917895,
 -48704,
 1102975141,
 917894,
 -1,
 1103040408,
 917893,
 1103249868,
 1102451731,
 -1,
 -48701,
 1103173693,
 917892,
 -48700,
 1103239052,
 917891,
 -48699,
 1103304364,
 917890,
 -48698,
 1103369692,
 917889,
 -48697,
 1103434983,
 917888,
 -48696,
 1103500307,
 917887,
 -48695,
 1103565557,
 917886,
 -48694,
 1103630800,
 917885,
 -48693,
 1103696037,
 917884,
 -1,
 1103761304,
 917883,
 1103970775,
 1103172341,
 -1,
 -48690,
 1103894589,
 917882,
 -48689,
 1103959948,
 917881,
 -48688,
 1104025260,
 917880,
 -48687,
 1104090588,
 917879,
 -48686,
 1104155879,
 917878,
 -48685,
 1104221203,
 917877,
 -48684,
 1104286453,
 917876,
 -48683,
 1104351696,
 917875,
 -48682,
 1104416933,
 917874,
 -1,
 1104482200,
 917873,
 1104691682,
 1103892944,
 -1,
 -48679,
 1104615485,
 917872,
 -48678,
 1104680844,
 917871,
 -48677,
 1104746156,
 917870,
 -48676,
 1104811484,
 917869,
 -48675,
 1104876775,
 917868,
 -48674,
 1104942099,
 917867,
 -48673,
 1105007349,
 917866,
 -48672,
 1105072592,
 917865,
 -48671,
 1105137829,
 917864,
 -1,
 1105203096,
 917863,
 1105412589,
 1104613541,
 -1,
 -48668,
 1105336381,
 917862,
 -48667,
 1105401740,
 917861,
 -48666,
 1105467052,
 917860,
 -48665,
 1105532380,
 917859,
 -48664,
 1105597671,
 917858,
 -48663,
 1105662995,
 917857,
 -48662,
 1105728245,
 917856,
 -48661,
 1105793488,
 917855,
 -48660,
 1105858725,
 917854,
 -1,
 1105923992,
 917853,
 1106182143,
 1105334168,
 -1,
 -48657,
 1106057277,
 917852,
 -48656,
 1106122636,
 917851,
 -48655,
 1106187948,
 917850,
 -48654,
 1106253276,
 917849,
 -48653,
 1106318567,
 917848,
 -48652,
 1106383891,
 917847,
 -48651,
 1106449141,
 917846,
 -48650,
 1106514384,
 917845,
 -48649,
 1106579621,
 917844,
 -1,
 1106644888,
 917843,
 1106854460,
 1099502032,
 -1,
 1106919940,
 1106777107,
 917767,
 -48645,
 1106843709,
 917992,
 -48644,
 1106909068,
 917991,
 -48643,
 1106974380,
 917990,
 -48642,
 1107039708,
 917989,
 -48641,
 1107104999,
 917988,
 -48640,
 1107170323,
 917987,
 -48639,
 1107235573,
 917986,
 -48638,
 1107300816,
 917985,
 -48637,
 1107366053,
 917984,
 -1,
 1107431320,
 917983,
 1107640847,
 1106842357,
 917766,
 -48634,
 1107564605,
 917982,
 -48633,
 1107629964,
 917981,
 -48632,
 1107695276,
 917980,
 -48631,
 1107760604,
 917979,
 -48630,
 1107825895,
 917978,
 -48629,
 1107891219,
 917977,
 -48628,
 1107956469,
 917976,
 -48627,
 1108021712,
 917975,
 -48626,
 1108086949,
 917974,
 -1,
 1108152216,
 917973,
 1108361754,
 1107562960,
 917765,
 -48623,
 1108285501,
 917972,
 -48622,
 1108350860,
 917971,
 -48621,
 1108416172,
 917970,
 -48620,
 1108481500,
 917969,
 -48619,
 1108546791,
 917968,
 -48618,
 1108612115,
 917967,
 -48617,
 1108677365,
 917966,
 -48616,
 1108742608,
 917965,
 -48615,
 1108807845,
 917964,
 -1,
 1108873112,
 917963,
 1109082661,
 1108283557,
 917764,
 -48612,
 1109006397,
 917962,
 -48611,
 1109071756,
 917961,
 -48610,
 1109137068,
 917960,
 -48609,
 1109202396,
 917959,
 -48608,
 1109267687,
 917958,
 -48607,
 1109333011,
 917957,
 -48606,
 1109398261,
 917956,
 -48605,
 1109463504,
 917955,
 -48604,
 1109528741,
 917954,
 -1,
 1109594008,
 917953,
 1109803568,
 1109004184,
 917763,
 -48601,
 1109727293,
 917952,
 -48600,
 1109792652,
 917951,
 -48599,
 1109857964,
 917950,
 -48598,
 1109923292,
 917949,
 -48597,
 1109988583,
 917948,
 -48596,
 1110053907,
 917947,
 -48595,
 1110119157,
 917946,
 -48594,
 1110184400,
 917945,
 -48593,
 1110249637,
 917944,
 -1,
 1110314904,
 917943,
 1110524472,
 1109726439,
 917768,
 -48590,
 1110447580,
 917999,
 -48589,
 1110512871,
 917998,
 -48588,
 1110578195,
 917997,
 -48587,
 1110643445,
 917996,
 -48586,
 1110708688,
 917995,
 -48585,
 1110773925,
 917994,
 -1,
 1110839192,
 917993,
 -48583,
 1110448189,
 917772,
 -48582,
 1110972300,
 917771,
 -48581,
 1111037612,
 917770,
 -1,
 1111102940,
 917769,
 1111310919,
 1106778173,
 -1,
 -48578,
 1111234621,
 917842,
 -48577,
 1111299980,
 917841,
 -48576,
 1111365292,
 917840,
 -48575,
 1111430620,
 917839,
 -48574,
 1111495911,
 917838,
 -48573,
 1111561235,
 917837,
 -48572,
 1111626485,
 917836,
 -48571,
 1111691728,
 917835,
 -48570,
 1111756965,
 917834,
 -1,
 1111822232,
 917833,
 1112031826,
 1111234444,
 -1,
 -48567,
 1111955517,
 917832,
 -48566,
 1112020876,
 917831,
 -48565,
 1112086188,
 917830,
 -48564,
 1112151516,
 917829,
 -48563,
 1112216807,
 917828,
 -48562,
 1112282131,
 917827,
 -48561,
 1112347381,
 917826,
 -48560,
 1112412624,
 917825,
 -48559,
 1112477861,
 917824,
 -1,
 1112543128,
 917823,
 1112752733,
 1111955116,
 -1,
 -48556,
 1112676413,
 917822,
 -48555,
 1112741772,
 917821,
 -48554,
 1112807084,
 917820,
 -48553,
 1112872412,
 917819,
 -48552,
 1112937703,
 917818,
 -48551,
 1113003027,
 917817,
 -48550,
 1113068277,
 917816,
 -48549,
 1113133520,
 917815,
 -48548,
 1113198757,
 917814,
 -1,
 1113264024,
 917813,
 1113473640,
 1112675804,
 -1,
 -48545,
 1113397309,
 917812,
 -48544,
 1113462668,
 917811,
 -48543,
 1113527980,
 917810,
 -48542,
 1113593308,
 917809,
 -48541,
 1113658599,
 917808,
 -48540,
 1113723923,
 917807,
 -48539,
 1113789173,
 917806,
 -48538,
 1113854416,
 917805,
 -48537,
 1113919653,
 917804,
 -1,
 1113984920,
 917803,
 1114194547,
 1113396455,
 -1,
 -48534,
 1114118205,
 917802,
 -48533,
 1114183564,
 917801,
 -48532,
 1114248876,
 917800,
 -48531,
 1114314204,
 917799,
 -48530,
 1114379495,
 917798,
 -48529,
 1114444819,
 917797,
 -48528,
 1114510069,
 917796,
 -48527,
 1114575312,
 917795,
 -48526,
 1114640549,
 917794,
 -1,
 1114705816,
 917793,
 1114915454,
 1114117139,
 -1,
 -48523,
 1114839101,
 917792,
 -48522,
 1114904460,
 917791,
 -48521,
 1114969772,
 917790,
 -48520,
 1115035100,
 917789,
 -48519,
 1115100391,
 917788,
 -48518,
 1115165715,
 917787,
 -48517,
 1115230965,
 917786,
 -48516,
 1115296208,
 917785,
 -48515,
 1115361445,
 917784,
 -1,
 1115426712,
 917783,
 1115684863,
 1114837749,
 -1,
 -48512,
 1115559997,
 917782,
 -48511,
 1115625356,
 917781,
 -48510,
 1115690668,
 917780,
 -48509,
 1115755996,
 917779,
 -48508,
 1115821287,
 917778,
 -48507,
 1115886611,
 917777,
 -48506,
 1115951861,
 917776,
 -48505,
 1116017104,
 917775,
 -48504,
 1116082341,
 917774,
 -1,
 1116147608,
 917773,
 1116357514,
 1076669836,
 -1,
 1116422905,
 1116278949,
 983237,
 1116488342,
 1116346429,
 983261,
 -48499,
 1116411965,
 983441,
 -48498,
 1116477324,
 983440,
 -48497,
 1116542636,
 983439,
 -48496,
 1116607964,
 983438,
 -48495,
 1116673255,
 983437,
 -48494,
 1116738579,
 983436,
 -48493,
 1116803829,
 983435,
 -48492,
 1116869072,
 983434,
 -48491,
 1116934309,
 983433,
 -1,
 1116999576,
 983432,
 1117209249,
 1116411788,
 983260,
 -48488,
 1117132861,
 983431,
 -48487,
 1117198220,
 983430,
 -48486,
 1117263532,
 983429,
 -48485,
 1117328860,
 983428,
 -48484,
 1117394151,
 983427,
 -48483,
 1117459475,
 983426,
 -48482,
 1117524725,
 983425,
 -48481,
 1117589968,
 983424,
 -48480,
 1117655205,
 983423,
 -1,
 1117720472,
 983422,
 1117930156,
 1117132460,
 983259,
 -48477,
 1117853757,
 983421,
 -48476,
 1117919116,
 983420,
 -48475,
 1117984428,
 983419,
 -48474,
 1118049756,
 983418,
 -48473,
 1118115047,
 983417,
 -48472,
 1118180371,
 983416,
 -48471,
 1118245621,
 983415,
 -48470,
 1118310864,
 983414,
 -48469,
 1118376101,
 983413,
 -1,
 1118441368,
 983412,
 1118651063,
 1117853148,
 983252,
 -48466,
 1118574653,
 983411,
 -48465,
 1118640012,
 983410,
 -48464,
 1118705324,
 983409,
 -48463,
 1118770652,
 983408,
 -48462,
 1118835943,
 983407,
 -48461,
 1118901267,
 983406,
 -48460,
 1118966517,
 983405,
 -48459,
 1119031760,
 983404,
 -48458,
 1119096997,
 983403,
 -1,
 1119162264,
 983402,
 1119371970,
 1118573799,
 983251,
 -48455,
 1119295549,
 983401,
 -48454,
 1119360908,
 983400,
 -48453,
 1119426220,
 983399,
 -48452,
 1119491548,
 983398,
 -48451,
 1119556839,
 983397,
 -48450,
 1119622163,
 983396,
 -48449,
 1119687413,
 983395,
 -48448,
 1119752656,
 983394,
 -48447,
 1119817893,
 983393,
 -1,
 1119883160,
 983392,
 1120092877,
 1119294483,
 983250,
 -48444,
 1120016445,
 983391,
 -48443,
 1120081804,
 983390,
 -48442,
 1120147116,
 983389,
 -48441,
 1120212444,
 983388,
 -48440,
 1120277735,
 983387,
 -48439,
 1120343059,
 983386,
 -48438,
 1120408309,
 983385,
 -48437,
 1120473552,
 983384,
 -48436,
 1120538789,
 983383,
 -1,
 1120604056,
 983382,
 1120813784,
 1120015093,
 983249,
 -48433,
 1120737341,
 983381,
 -48432,
 1120802700,
 983380,
 -48431,
 1120868012,
 983379,
 -48430,
 1120933340,
 983378,
 -48429,
 1120998631,
 983377,
 -48428,
 1121063955,
 983376,
 -48427,
 1121129205,
 983375,
 -48426,
 1121194448,
 983374,
 -48425,
 1121259685,
 983373,
 -1,
 1121324952,
 983372,
 1121534691,
 1120735696,
 983248,
 -48422,
 1121458237,
 983371,
 -48421,
 1121523596,
 983370,
 -48420,
 1121588908,
 983369,
 -48419,
 1121654236,
 983368,
 -48418,
 1121719527,
 983367,
 -48417,
 1121784851,
 983366,
 -48416,
 1121850101,
 983365,
 -48415,
 1121915344,
 983364,
 -48414,
 1121980581,
 983363,
 -1,
 1122045848,
 983362,
 1122255598,
 1121456293,
 983247,
 -48411,
 1122179133,
 983361,
 -48410,
 1122244492,
 983360,
 -48409,
 1122309804,
 983359,
 -48408,
 1122375132,
 983358,
 -48407,
 1122440423,
 983357,
 -48406,
 1122505747,
 983356,
 -48405,
 1122570997,
 983355,
 -48404,
 1122636240,
 983354,
 -48403,
 1122701477,
 983353,
 -1,
 1122766744,
 983352,
 1123024895,
 1122176920,
 983246,
 -48400,
 1122900029,
 983351,
 -48399,
 1122965388,
 983350,
 -48398,
 1123030700,
 983349,
 -48397,
 1123096028,
 983348,
 -48396,
 1123161319,
 983347,
 -48395,
 1123226643,
 983346,
 -48394,
 1123291893,
 983345,
 -48393,
 1123357136,
 983344,
 -48392,
 1123422373,
 983343,
 -1,
 1123487640,
 983342,
 1123697469,
 1116344784,
 983238,
 1123762949,
 1123619859,
 983266,
 -48388,
 1123686461,
 983491,
 -48387,
 1123751820,
 983490,
 -48386,
 1123817132,
 983489,
 -48385,
 1123882460,
 983488,
 -48384,
 1123947751,
 983487,
 -48383,
 1124013075,
 983486,
 -48382,
 1124078325,
 983485,
 -48381,
 1124143568,
 983484,
 -48380,
 1124208805,
 983483,
 -1,
 1124274072,
 983482,
 1124483856,
 1123685109,
 983265,
 -48377,
 1124407357,
 983481,
 -48376,
 1124472716,
 983480,
 -48375,
 1124538028,
 983479,
 -48374,
 1124603356,
 983478,
 -48373,
 1124668647,
 983477,
 -48372,
 1124733971,
 983476,
 -48371,
 1124799221,
 983475,
 -48370,
 1124864464,
 983474,
 -48369,
 1124929701,
 983473,
 -1,
 1124994968,
 983472,
 1125204763,
 1124405712,
 983264,
 -48366,
 1125128253,
 983471,
 -48365,
 1125193612,
 983470,
 -48364,
 1125258924,
 983469,
 -48363,
 1125324252,
 983468,
 -48362,
 1125389543,
 983467,
 -48361,
 1125454867,
 983466,
 -48360,
 1125520117,
 983465,
 -48359,
 1125585360,
 983464,
 -48358,
 1125650597,
 983463,
 -1,
 1125715864,
 983462,
 1125925670,
 1125126309,
 983263,
 -48355,
 1125849149,
 983461,
 -48354,
 1125914508,
 983460,
 -48353,
 1125979820,
 983459,
 -48352,
 1126045148,
 983458,
 -48351,
 1126110439,
 983457,
 -48350,
 1126175763,
 983456,
 -48349,
 1126241013,
 983455,
 -48348,
 1126306256,
 983454,
 -48347,
 1126371493,
 983453,
 -1,
 1126436760,
 983452,
 1126646577,
 1125846936,
 983262,
 -48344,
 1126570045,
 983451,
 -48343,
 1126635404,
 983450,
 -48342,
 1126700716,
 983449,
 -48341,
 1126766044,
 983448,
 -48340,
 1126831335,
 983447,
 -48339,
 1126896659,
 983446,
 -48338,
 1126961909,
 983445,
 -48337,
 1127027152,
 983444,
 -48336,
 1127092389,
 983443,
 -1,
 1127157656,
 983442,
 1127367481,
 1126569191,
 983267,
 -48333,
 1127290332,
 983498,
 -48332,
 1127355623,
 983497,
 -48331,
 1127420947,
 983496,
 -48330,
 1127486197,
 983495,
 -48329,
 1127551440,
 983494,
 -48328,
 1127616677,
 983493,
 -1,
 1127681944,
 983492,
 -48326,
 1127290941,
 983271,
 -48325,
 1127815052,
 983270,
 -48324,
 1127880364,
 983269,
 -1,
 1127945692,
 983268,
 1128153928,
 1123620925,
 983245,
 -48321,
 1128077373,
 983341,
 -48320,
 1128142732,
 983340,
 -48319,
 1128208044,
 983339,
 -48318,
 1128273372,
 983338,
 -48317,
 1128338663,
 983337,
 -48316,
 1128403987,
 983336,
 -48315,
 1128469237,
 983335,
 -48314,
 1128534480,
 983334,
 -48313,
 1128599717,
 983333,
 -1,
 1128664984,
 983332,
 1128874835,
 1128077196,
 983244,
 -48310,
 1128798269,
 983331,
 -48309,
 1128863628,
 983330,
 -48308,
 1128928940,
 983329,
 -48307,
 1128994268,
 983328,
 -48306,
 1129059559,
 983327,
 -48305,
 1129124883,
 983326,
 -48304,
 1129190133,
 983325,
 -48303,
 1129255376,
 983324,
 -48302,
 1129320613,
 983323,
 -1,
 1129385880,
 983322,
 1129595742,
 1128797868,
 983243,
 -48299,
 1129519165,
 983321,
 -48298,
 1129584524,
 983320,
 -48297,
 1129649836,
 983319,
 -48296,
 1129715164,
 983318,
 -48295,
 1129780455,
 983317,
 -48294,
 1129845779,
 983316,
 -48293,
 1129911029,
 983315,
 -48292,
 1129976272,
 983314,
 -48291,
 1130041509,
 983313,
 -1,
 1130106776,
 983312,
 1130316649,
 1129518556,
 983242,
 -48288,
 1130240061,
 983311,
 -48287,
 1130305420,
 983310,
 -48286,
 1130370732,
 983309,
 -48285,
 1130436060,
 983308,
 -48284,
 1130501351,
 983307,
 -48283,
 1130566675,
 983306,
 -48282,
 1130631925,
 983305,
 -48281,
 1130697168,
 983304,
 -48280,
 1130762405,
 983303,
 -1,
 1130827672,
 983302,
 1131037556,
 1130239207,
 983241,
 -48277,
 1130960957,
 983301,
 -48276,
 1131026316,
 983300,
 -48275,
 1131091628,
 983299,
 -48274,
 1131156956,
 983298,
 -48273,
 1131222247,
 983297,
 -48272,
 1131287571,
 983296,
 -48271,
 1131352821,
 983295,
 -48270,
 1131418064,
 983294,
 -48269,
 1131483301,
 983293,
 -1,
 1131548568,
 983292,
 1131758463,
 1130959891,
 983240,
 -48266,
 1131681853,
 983291,
 -48265,
 1131747212,
 983290,
 -48264,
 1131812524,
 983289,
 -48263,
 1131877852,
 983288,
 -48262,
 1131943143,
 983287,
 -48261,
 1132008467,
 983286,
 -48260,
 1132073717,
 983285,
 -48259,
 1132138960,
 983284,
 -48258,
 1132204197,
 983283,
 -1,
 1132269464,
 983282,
 1132527615,
 1131680501,
 983239,
 -48255,
 1132402749,
 983281,
 -48254,
 1132468108,
 983280,
 -48253,
 1132533420,
 983279,
 -48252,
 1132598748,
 983278,
 -48251,
 1132664039,
 983277,
 -48250,
 1132729363,
 983276,
 -48249,
 1132794613,
 983275,
 -48248,
 1132859856,
 983274,
 -48247,
 1132925093,
 983273,
 -1,
 1132990360,
 983272,
 1133200354,
 1116290620,
 -1,
 1133265859,
 1133131964,
 -1,
 1133331368,
 1133228687,
 -1,
 1133396885,
 1133254895,
 -1,
 1133462420,
 1133349165,
 -1,
 1133527953,
 1133431967,
 7403,
 -1,
 1133448664,
 7404,
 -48238,
 1133495740,
 7409,
 -48237,
 1133585963,
 7402,
 -1,
 1133650043,
 7401,
 -1,
 1133421537,
 7410,
 1133921179,
 1133367174,
 -1,
 1133986712,
 1133889236,
 7395,
 -1,
 1133907416,
 7399,
 1134117786,
 1133912221,
 7397,
 -1,
 1134038488,
 7400,
 -1,
 1134082412,
 7394,
 1134314401,
 1133879553,
 -1,
 1134379935,
 1134250112,
 -1,
 -48226,
 1134347988,
 7396,
 -1,
 1134370973,
 7398,
 -48224,
 1134345482,
 7408,
 -1,
 1134531217,
 7411,
 -48222,
 1134287183,
 7380,
 -48221,
 1134676455,
 7414,
 -48220,
 1134739428,
 7405,
 -48219,
 1134790166,
 7379,
 -48218,
 1134852203,
 7407,
 -48217,
 1134914218,
 7413,
 -1,
 1134974905,
 7406,
 1135214591,
 1133297744,
 -1,
 1135231918,
 1135139139,
 -1,
 1135297452,
 1135176783,
 7383,
 -1,
 1135216805,
 7385,
 -48211,
 1135239624,
 7382,
 -1,
 1135352904,
 7381,
 1135559602,
 1135196699,
 -1,
 -48208,
 1135531578,
 7390,
 -48207,
 1135585855,
 7387,
 -1,
 1135631235,
 7391,
 1135821751,
 1135491501,
 -1,
 1135887286,
 1135789552,
 -1,
 -48203,
 1135851884,
 7386,
 -1,
 1135913318,
 7417,
 -1,
 1135852083,
 7389,
 1136149434,
 1135781536,
 -1,
 -48199,
 1136100719,
 7416,
 -1,
 1136153577,
 7392,
 1136346045,
 1136094087,
 -1,
 -48196,
 1136311529,
 7388,
 -1,
 1136372892,
 7376,
 1136542656,
 1136274474,
 -1,
 -48193,
 1136469900,
 7384,
 -1,
 1136532001,
 7412,
 -48191,
 1136505080,
 7377,
 -48190,
 1136696825,
 7378,
 -1,
 1136731161,
 7393,
 1136935905,
 1133224193,
 -1,
 1137001428,
 1136908501,
 -1,
 1137066963,
 1136940768,
 -1,
 1137132490,
 1137028492,
 -1,
 -48184,
 1137085567,
 128636,
 -48183,
 1137142170,
 128953,
 -1,
 1137188557,
 128941,
 1137394637,
 1137103648,
 -1,
 -48180,
 1137358367,
 128914,
 -1,
 1137389391,
 128904,
 1137591248,
 1137328699,
 -1,
 -48177,
 1137554959,
 128959,
 -1,
 1137613935,
 128976,
 -48175,
 1137550864,
 128637,
 -48174,
 1137726332,
 128934,
 -1,
 1137789976,
 128947,
 -1,
 1136994762,
 128933,
 1138098175,
 1136967307,
 -1,
 1138115548,
 1138014747,
 -1,
 1138181082,
 1138039236,
 -1,
 1138246617,
 1138149265,
 983069,
 -1,
 1138165944,
 983143,
 -1,
 1138164695,
 11135,
 -48165,
 1138139576,
 128678,
 -1,
 1138385105,
 11823,
 -48163,
 1138078556,
 11837,
 -48162,
 1138523073,
 9896,
 -48161,
 1138587325,
 9168,
 -48160,
 1138642343,
 8286,
 -1,
 1138697856,
 10186,
 -1,
 1136899839,
 9910,
 1138967530,
 1133141201,
 -1,
 1139033064,
 1138898862,
 -1,
 1139098599,
 1138950144,
 -1,
 -48154,
 1139036161,
 127918,
 -1,
 1139092488,
 128249,
 -1,
 1139027154,
 128252,
 -48151,
 1138986118,
 127931,
 -1,
 1139288692,
 128243,
 1139491824,
 1138935705,
 -1,
 1139557359,
 1139445176,
 -1,
 -48147,
 1139522660,
 8530,
 -48146,
 1139585070,
 8528,
 -1,
 1139639942,
 8529,
 -1,
 1139530786,
 8585,
 1139885042,
 1139456539,
 983070,
 -1,
 1139846540,
 983144,
 1140064255,
 1139837971,
 -1,
 -48140,
 1139963256,
 127952,
 -1,
 1140010082,
 127755,
 1140213545,
 1076598638,
 -1,
 1140278630,
 1140136175,
 -1,
 1140343984,
 1140217447,
 -1,
 1140409389,
 1140272002,
 -1,
 1140474898,
 1140363013,
 -1,
 1140540418,
 1140425460,
 -1,
 1140605950,
 1140505115,
 -1,
 -48131,
 1140567778,
 92957,
 -1,
 1140610655,
 92971,
 -48129,
 1140551966,
 92960,
 -48128,
 1140747371,
 92962,
 -48127,
 1140796987,
 92968,
 -1,
 1140860102,
 92972,
 1141064710,
 1140479010,
 -1,
 -48124,
 1141015486,
 92969,
 -48123,
 1141076254,
 92965,
 -1,
 1141122246,
 92959,
 1141326857,
 1140992898,
 -1,
 -48120,
 1141266015,
 92967,
 -1,
 1141318854,
 92975,
 -48118,
 1141299604,
 92964,
 -48117,
 1141495833,
 92974,
 -48116,
 1141558622,
 92956,
 -48115,
 1141613377,
 92961,
 -48114,
 1141677981,
 92963,
 -48113,
 1141742499,
 92970,
 -48112,
 1141800229,
 92966,
 -48111,
 1141862686,
 92958,
 -1,
 1141908678,
 92973,
 1142161407,
 1140420609,
 -1,
 1142178841,
 1142077979,
 -1,
 1142244376,
 1142140300,
 -1,
 -48106,
 1142215245,
 93069,
 -48105,
 1142249240,
 93053,
 -1,
 1142299076,
 93062,
 -1,
 1142184379,
 93061,
 1142572061,
 1142123317,
 -1,
 -48101,
 1142543794,
 93070,
 -48100,
 1142591289,
 93058,
 -1,
 1142641753,
 93064,
 1142834208,
 1142544595,
 -1,
 -48097,
 1142767865,
 93054,
 -1,
 1142824290,
 93068,
 1143030819,
 1142803578,
 -1,
 -48094,
 1143002540,
 93071,
 -1,
 1143020898,
 93066,
 1143227430,
 1142976199,
 -1,
 -48091,
 1143170886,
 93055,
 -1,
 1143219432,
 93056,
 1143424041,
 1143166008,
 -1,
 -48088,
 1143395756,
 93059,
 -1,
 1143438015,
 93065,
 -48086,
 1143396557,
 93057,
 -48085,
 1143577279,
 93063,
 -48084,
 1143636516,
 93060,
 -1,
 1143687735,
 93067,
 1143882848,
 1140372111,
 -1,
 1143948345,
 1143811908,
 -1,
 1144013875,
 1143912987,
 -1,
 1144079410,
 1143986377,
 93044,
 -1,
 1143996927,
 93045,
 -1,
 1144042893,
 92997,
 1144276022,
 1143942018,
 -1,
 -48075,
 1144243593,
 93043,
 -1,
 1144280885,
 92985,
 -48073,
 1144233626,
 93046,
 -48072,
 1144424384,
 93047,
 -1,
 1144476819,
 93042,
 1144669251,
 1143920605,
 -1,
 1144734785,
 1144641747,
 -1,
 1144800320,
 1144668455,
 -1,
 -48067,
 1144766718,
 92990,
 -48066,
 1144825477,
 92989,
 -48065,
 1144883387,
 92988,
 -1,
 1144932914,
 92991,
 -1,
 1144753977,
 93028,
 -48062,
 1144675667,
 93034,
 -1,
 1145120005,
 92996,
 1145324621,
 1144639559,
 -1,
 1145390153,
 1145289243,
 -1,
 1145455688,
 1145328674,
 -1,
 -48057,
 1145408700,
 92983,
 -1,
 1145462099,
 92986,
 -1,
 1145417856,
 92984,
 -48054,
 1145352060,
 92992,
 -48053,
 1145669577,
 92994,
 -48052,
 1145731703,
 93027,
 -1,
 1145784985,
 92987,
 1145979985,
 1145289243,
 -1,
 -48049,
 1145952362,
 93037,
 -48048,
 1145985290,
 93030,
 -1,
 1146037446,
 93039,
 1146242134,
 1145928383,
 -1,
 1146307669,
 1146175741,
 -1,
 -48044,
 1146274495,
 93038,
 -1,
 1146337512,
 92993,
 -1,
 1146276779,
 93041,
 1146569817,
 1146192628,
 -1,
 -48040,
 1146536761,
 93035,
 -1,
 1146593190,
 93033,
 1146766428,
 1146508322,
 -1,
 -48037,
 1146718404,
 93032,
 -1,
 1146779067,
 93029,
 -48035,
 1146739878,
 93031,
 -48034,
 1146910904,
 93040,
 -48033,
 1146969610,
 92995,
 -1,
 1147020571,
 93036,
 1147225227,
 1143853149,
 -1,
 1147290736,
 1147148527,
 -1,
 1147356261,
 1147261196,
 -1,
 -48028,
 1147325562,
 92943,
 -1,
 1147348402,
 92942,
 1147552872,
 1147323594,
 -1,
 -48025,
 1147522170,
 92933,
 -1,
 1147545010,
 92932,
 1147749483,
 1147493585,
 -1,
 -48022,
 1147718778,
 92939,
 -1,
 1147741618,
 92938,
 1147946094,
 1147672815,
 -1,
 -48019,
 1147915386,
 92955,
 -1,
 1147938226,
 92954,
 -48017,
 1147915386,
 92951,
 -1,
 1148069298,
 92950,
 1148273782,
 1147258058,
 -1,
 1148339316,
 1148197103,
 -1,
 -48013,
 1148308602,
 92945,
 -1,
 1148331442,
 92944,
 -48011,
 1148308602,
 92935,
 -1,
 1148462514,
 92934,
 1148667004,
 1148225962,
 -1,
 1148732538,
 1148619178,
 -1,
 -48007,
 1148701818,
 92941,
 -1,
 1148724658,
 92940,
 -48005,
 1148701818,
 92947,
 -1,
 1148855730,
 92946,
 1149060226,
 1148607697,
 -1,
 1149125760,
 1148983535,
 -1,
 -48001,
 1149095034,
 92949,
 -1,
 1149117874,
 92948,
 -47999,
 1149095034,
 92931,
 -1,
 1149248946,
 92930,
 1149453448,
 1148993084,
 -1,
 1149518982,
 1149386300,
 -1,
 -47995,
 1149488250,
 92929,
 -1,
 1149511090,
 92928,
 -47993,
 1149488250,
 92937,
 -1,
 1149642162,
 92936,
 1149894655,
 1149423884,
 -1,
 -47990,
 1149815930,
 92953,
 -1,
 1149838770,
 92952,
 1150043289,
 1147156700,
 -1,
 1150108815,
 1150007835,
 -1,
 -47986,
 1150080522,
 93010,
 -1,
 1150114624,
 93011,
 1150305426,
 1150070156,
 -1,
 -47983,
 1150249347,
 93014,
 -1,
 1150306271,
 93015,
 1150502037,
 1150241208,
 -1,
 -47980,
 1150456772,
 93012,
 -1,
 1150511313,
 93013,
 -47978,
 1150475249,
 93008,
 -47977,
 1150651828,
 93009,
 -47976,
 1150715440,
 93017,
 -1,
 1150763573,
 93016,
 1150960805,
 1149995232,
 -1,
 1151026337,
 1150925339,
 -1,
 1151091872,
 1150960484,
 -1,
 1151157407,
 1151008768,
 -1,
 -47970,
 1151122856,
 93021,
 -1,
 1151150223,
 93024,
 -1,
 1151118732,
 93019,
 -1,
 1151052105,
 93025,
 1151485092,
 1150966871,
 -1,
 -47965,
 1151446412,
 93020,
 -1,
 1151468690,
 93023,
 -1,
 1151434811,
 93022,
 1151795199,
 1150909606,
 -1,
 1151812777,
 1151711771,
 -1,
 -47960,
 1151780273,
 92976,
 -1,
 1151804665,
 92982,
 1152009388,
 1151774092,
 -1,
 -47957,
 1151976837,
 92980,
 -1,
 1152027050,
 92977,
 1152205999,
 1151953717,
 -1,
 -47954,
 1152144995,
 92979,
 -1,
 1152206477,
 92978,
 -1,
 1152145892,
 92981,
 1152468217,
 1140311247,
 -1,
 1152533732,
 1152413383,
 -1,
 1152599263,
 1152468768,
 -1,
 1152664767,
 1152534968,
 -1,
 1152730302,
 1152606638,
 -1,
 1152795831,
 1152680692,
 72416,
 -1,
 1152732984,
 72419,
 -47944,
 1152768211,
 72420,
 -47943,
 1152897292,
 72418,
 -47942,
 1152956955,
 72414,
 -47941,
 1153013614,
 72412,
 -47940,
 1153071807,
 72415,
 -47939,
 1153134279,
 72417,
 -1,
 1153198901,
 72413,
 -1,
 1152653551,
 72403,
 1153451201,
 1152632010,
 72409,
 -1,
 1153374447,
 72410,
 1153582276,
 1153415707,
 -1,
 -47933,
 1153520696,
 72399,
 -1,
 1153571055,
 72398,
 1153778887,
 1153537902,
 -1,
 -47930,
 1153717304,
 72401,
 -1,
 1153767663,
 72384,
 1153975498,
 1153729268,
 -1,
 -47927,
 1153912711,
 72391,
 -1,
 1153964271,
 72400,
 1154172109,
 1153919797,
 -1,
 -47924,
 1154110520,
 72394,
 -1,
 1154160879,
 72385,
 1154368719,
 1154112721,
 72407,
 -1,
 1154291951,
 72411,
 1154499794,
 1154296706,
 -1,
 -47919,
 1154438200,
 72404,
 -1,
 1154488559,
 72397,
 -47917,
 1154472767,
 72389,
 -47916,
 1154665616,
 72390,
 -47915,
 1154723359,
 72395,
 -47914,
 1154785659,
 72402,
 -47913,
 1154845098,
 72408,
 -47912,
 1154906901,
 72387,
 -47911,
 1154969349,
 72386,
 -47910,
 1155028024,
 72392,
 -47909,
 1155092359,
 72393,
 -47908,
 1155153468,
 72406,
 -47907,
 1155217003,
 72388,
 -47906,
 1155278311,
 72396,
 -1,
 1155340527,
 72405,
 1155596287,
 1152554708,
 72436,
 1155661823,
 1155465216,
 -1,
 1155679459,
 1155561568,
 72435,
 -1,
 1155597033,
 72438,
 -1,
 1155615553,
 72439,
 1155876076,
 1152495276,
 -1,
 1155941610,
 1155842123,
 72428,
 1156055039,
 1155858432,
 -1,
 1156072681,
 1155954784,
 72427,
 -1,
 1155990249,
 72429,
 -1,
 1156008769,
 72430,
 1156317183,
 1155879580,
 72423,
 -1,
 1156186857,
 72426,
 1156400369,
 1155836531,
 72422,
 1156513791,
 1156317184,
 -1,
 1156531440,
 1156413536,
 72421,
 -1,
 1156449001,
 72424,
 -1,
 1156467521,
 72425,
 1156728053,
 1156349771,
 72431,
 1156841471,
 1156644864,
 -1,
 -47884,
 1156741241,
 72433,
 -1,
 1156795201,
 72434,
 1157038079,
 1156666012,
 72437,
 1157103615,
 1156907008,
 -1,
 -47880,
 1157024965,
 72432,
 -1,
 1157057345,
 72440,
 1157252386,
 1152426241,
 -1,
 1157317913,
 1157186730,
 -1,
 1157383446,
 1157263570,
 -1,
 -47875,
 1157356335,
 127273,
 -47874,
 1157421267,
 127272,
 -47873,
 1157486557,
 127271,
 -47872,
 1157550348,
 127270,
 -47871,
 1157614714,
 127269,
 -47870,
 1157678282,
 127268,
 -47869,
 1157741083,
 127267,
 -47868,
 1157803404,
 127266,
 -47867,
 1157865729,
 127265,
 -47866,
 1157930827,
 127264,
 -47865,
 1157994350,
 127263,
 -47864,
 1158056362,
 127262,
 -47863,
 1158120180,
 127261,
 -47862,
 1158183615,
 127260,
 -47861,
 1158246087,
 127259,
 -47860,
 1158310709,
 127258,
 -47859,
 1158375945,
 127257,
 -47858,
 1158438097,
 127256,
 -47857,
 1158501410,
 127255,
 -47856,
 1158565688,
 127254,
 -47855,
 1158629816,
 127253,
 -47854,
 1158692412,
 127252,
 -47853,
 1158755805,
 127251,
 -47852,
 1158818690,
 127250,
 -47851,
 1158882738,
 127249,
 -1,
 1158945007,
 127248,
 1159200767,
 1157328421,
 -1,
 -47848,
 1159096970,
 12829,
 -1,
 1159136087,
 12830,
 1159349537,
 1157282331,
 -1,
 1159415071,
 1159290240,
 -1,
 -47844,
 1159383321,
 983149,
 -47843,
 1159417164,
 983145,
 -47842,
 1159478337,
 983146,
 -1,
 1159538193,
 983148,
 -47840,
 1159387380,
 127881,
 -1,
 1159693575,
 12880,
 -1,
 1159273599,
 11791,
 1159939411,
 1157197511,
 -1,
 1160004946,
 1159887551,
 -1,
 1160070479,
 1159977743,
 -1,
 1160136003,
 1160016303,
 -1,
 1160201538,
 1160102636,
 -1,
 1160267052,
 1160162700,
 -1,
 1160332587,
 1160190191,
 -1,
 -47830,
 1160281724,
 67695,
 -1,
 1160329272,
 67698,
 -1,
 1160272077,
 67701,
 1160594735,
 1160231451,
 -1,
 -47826,
 1160529664,
 67688,
 -1,
 1160586588,
 67702,
 1160791345,
 1160533633,
 67684,
 -1,
 1160756433,
 67687,
 1160922420,
 1160714479,
 -1,
 -47821,
 1160895011,
 67696,
 -1,
 1160934573,
 67680,
 -47819,
 1160895428,
 67686,
 -47818,
 1161091762,
 67689,
 -47817,
 1161155117,
 67685,
 -47816,
 1161209291,
 67700,
 -47815,
 1161273276,
 67699,
 -47814,
 1161337197,
 67697,
 -47813,
 1161398556,
 67694,
 -47812,
 1161461397,
 67692,
 -47811,
 1161523186,
 67691,
 -47810,
 1161587706,
 67690,
 -47809,
 1161646654,
 67682,
 -47808,
 1161710439,
 67693,
 -47807,
 1161770685,
 67683,
 -1,
 1161832421,
 67681,
 -1,
 1160138491,
 67703,
 1162102094,
 1160087776,
 -1,
 1162167626,
 1162066459,
 -1,
 1162233160,
 1162137868,
 -1,
 -47801,
 1162185130,
 67706,
 -1,
 1162233044,
 67711,
 -47799,
 1162173248,
 67707,
 -1,
 1162363748,
 67710,
 1162560845,
 1162103224,
 -1,
 -47796,
 1162515396,
 67708,
 -1,
 1162569937,
 67709,
 -1,
 1162513844,
 67705,
 -1,
 1162061969,
 67704,
 1162936319,
 1159987200,
 -1,
 -47791,
 1162854755,
 127796,
 -1,
 1162881645,
 11801,
 -1,
 1159950487,
 9908,
 1163150683,
 1159876797,
 128463,
 1163216217,
 1163067392,
 -1,
 1163281752,
 1163187338,
 -1,
 -47785,
 1163250483,
 128195,
 -1,
 1163290335,
 128479,
 -1,
 1163217448,
 128196,
 -47782,
 1163177356,
 128464,
 -1,
 1163501825,
 128223,
 1163674974,
 1163114099,
 -1,
 -47779,
 1163631929,
 128706,
 -1,
 1163674682,
 128755,
 1163871585,
 1163625204,
 -1,
 -47776,
 1163802226,
 128060,
 -1,
 1163865060,
 129374,
 1164068195,
 1163802077,
 983121,
 -1,
 1163999492,
 983120,
 -47772,
 1164038425,
 128062,
 -47771,
 1164155499,
 128206,
 -1,
 1164193890,
 128230,
 1164396055,
 1140216866,
 -1,
 1164461554,
 1164318959,
 -1,
 1164527026,
 1164399509,
 -1,
 1164592550,
 1164473564,
 -1,
 1164658035,
 1164556827,
 -1,
 1164723566,
 1164622363,
 -1,
 -47763,
 1164661816,
 43114,
 -1,
 1164712175,
 43113,
 1164920177,
 1164684684,
 -1,
 -47760,
 1164858424,
 43089,
 -1,
 1164908783,
 43088,
 -47758,
 1164858424,
 43081,
 -1,
 1165039855,
 43080,
 1165247864,
 1164608244,
 -1,
 -47755,
 1165220140,
 43079,
 -47754,
 1165263697,
 43116,
 -47753,
 1165315975,
 43075,
 -1,
 1165367535,
 43083,
 1165575548,
 1165208972,
 -1,
 -47750,
 1165523945,
 43094,
 -47749,
 1165579320,
 43098,
 -1,
 1165629679,
 43099,
 1165837696,
 1165506013,
 -1,
 -47746,
 1165810495,
 43090,
 -47745,
 1165833835,
 43115,
 -1,
 1165891823,
 43082,
 1166099844,
 1165765506,
 -1,
 1166165379,
 1166022895,
 43076,
 -1,
 1166115899,
 43123,
 -1,
 1166103608,
 43077,
 1166361991,
 1166022895,
 43101,
 -47738,
 1166325227,
 43120,
 -1,
 1166375466,
 43117,
 1166558602,
 1166334767,
 -1,
 -47735,
 1166496824,
 43092,
 -1,
 1166547183,
 43093,
 1166755213,
 1166528490,
 -1,
 -47732,
 1166701746,
 43118,
 -1,
 1166751248,
 43119,
 1166951824,
 1166710638,
 -1,
 -47729,
 1166890040,
 43085,
 -1,
 1166940399,
 43084,
 1167148435,
 1166895925,
 -1,
 -47726,
 1167086648,
 43073,
 -1,
 1167137007,
 43072,
 1167345046,
 1167085368,
 -1,
 -47723,
 1167282055,
 43109,
 -1,
 1167333615,
 43074,
 1167541656,
 1167277628,
 43104,
 -1,
 1167474236,
 43110,
 -47719,
 1167513900,
 43095,
 -47718,
 1167644672,
 43107,
 -47717,
 1167708492,
 43091,
 -47716,
 1167770826,
 43103,
 -47715,
 1167827323,
 43096,
 -47714,
 1167892330,
 43106,
 -47713,
 1167952298,
 43105,
 -47712,
 1168014101,
 43087,
 -47711,
 1168076549,
 43097,
 -47710,
 1168140839,
 43078,
 -47709,
 1168202961,
 43102,
 -47708,
 1168266296,
 43100,
 -47707,
 1168329229,
 43108,
 -1,
 1168385511,
 43086,
 1168590254,
 1164553612,
 -1,
 1168655789,
 1168557258,
 -1,
 1168721324,
 1168582868,
 -1,
 -47702,
 1168693548,
 43112,
 -47701,
 1168757068,
 43111,
 -1,
 1168810363,
 43121,
 -1,
 1168677491,
 43122,
 -1,
 1168598038,
 43124,
 1169114545,
 1168538773,
 -1,
 -47696,
 1169076362,
 43126,
 -1,
 1169112078,
 43127,
 -1,
 1169046446,
 43125,
 1169424383,
 1164470257,
 -1,
 1169442238,
 1169304450,
 -1,
 1169507768,
 1169394090,
 -1,
 1169573303,
 1169456429,
 66020,
 -1,
 1169515571,
 66045,
 -1,
 1169521287,
 66022,
 1169769916,
 1169430767,
 -1,
 -47686,
 1169734171,
 66028,
 -47685,
 1169796158,
 66018,
 -1,
 1169858188,
 66003,
 -47683,
 1169717879,
 66012,
 -1,
 1169971365,
 66004,
 1170163142,
 1169403276,
 -1,
 1170228674,
 1170102241,
 -1,
 -47679,
 1170184046,
 66024,
 -1,
 1170227902,
 66011,
 -47677,
 1170194754,
 66042,
 -47676,
 1170373616,
 66043,
 -47675,
 1170437865,
 66021,
 -1,
 1170482524,
 66015,
 1170687437,
 1170089394,
 -1,
 1170752970,
 1170639274,
 -1,
 -47671,
 1170723084,
 66010,
 -1,
 1170771217,
 66017,
 1170949580,
 1170686189,
 66033,
 -1,
 1170889046,
 66023,
 -1,
 1170917302,
 66027,
 1171146195,
 1170642798,
 -1,
 1171211729,
 1171091143,
 -1,
 -47664,
 1171179535,
 66001,
 -1,
 1171202008,
 66034,
 -47662,
 1171144894,
 66000,
 -1,
 1171333396,
 66036,
 1171539415,
 1171110427,
 -1,
 -47659,
 1171507456,
 66032,
 -47658,
 1171545599,
 66008,
 -1,
 1171596443,
 66002,
 1171801563,
 1171477538,
 -1,
 -47655,
 1171755448,
 66025,
 -47654,
 1171807915,
 66026,
 -1,
 1171866375,
 66006,
 1172063710,
 1171771660,
 -1,
 -47651,
 1172016342,
 66005,
 -1,
 1172055364,
 66044,
 1172260321,
 1172021505,
 -1,
 -47648,
 1172214327,
 66037,
 -1,
 1172250324,
 66029,
 1172456932,
 1172208405,
 -1,
 -47645,
 1172423424,
 66014,
 -1,
 1172472684,
 66013,
 1172653543,
 1172403643,
 -1,
 -47642,
 1172601519,
 66038,
 -1,
 1172649437,
 66016,
 1172850154,
 1172590392,
 -1,
 -47639,
 1172808459,
 66041,
 -1,
 1172841725,
 66007,
 1173046765,
 1172781485,
 -1,
 -47636,
 1173015909,
 66031,
 -1,
 1173059420,
 66019,
 -47634,
 1173016424,
 66035,
 -47633,
 1173198634,
 66039,
 -47632,
 1173245136,
 66040,
 -47631,
 1173307244,
 66030,
 -1,
 1173365371,
 66009,
 1173618687,
 1164413656,
 -1,
 1173636621,
 1173517532,
 -1,
 1173702136,
 1173597580,
 -1,
 -47626,
 1173641421,
 67860,
 -47625,
 1173701446,
 67854,
 -1,
 1173756748,
 67857,
 1173964283,
 1173666331,
 -1,
 -47622,
 1173898968,
 67848,
 -1,
 1173955782,
 67861,
 1174160893,
 1173902977,
 67844,
 -1,
 1174125083,
 67847,
 1174291968,
 1174083823,
 -1,
 -47617,
 1174238592,
 67840,
 -1,
 1174299010,
 67855,
 -47615,
 1174264646,
 67846,
 -47614,
 1174461102,
 67849,
 -47613,
 1174524435,
 67845,
 -47612,
 1174580159,
 67859,
 -47611,
 1174642611,
 67858,
 -47610,
 1174706541,
 67856,
 -47609,
 1174767900,
 67853,
 -47608,
 1174830741,
 67852,
 -47607,
 1174892519,
 67851,
 -47606,
 1174956999,
 67850,
 -47605,
 1175015430,
 67842,
 -47604,
 1175074697,
 67843,
 -1,
 1175136213,
 67841,
 1175340566,
 1173588192,
 -1,
 1175406100,
 1175304731,
 -1,
 1175471634,
 1175376140,
 -1,
 -47599,
 1175423402,
 67866,
 -1,
 1175471316,
 67864,
 -47597,
 1175411520,
 67867,
 -1,
 1175602020,
 67863,
 1175846911,
 1175358900,
 67862,
 -1,
 1175716699,
 67865,
 -1,
 1175312226,
 67871,
 1175996036,
 1164340935,
 -1,
 1176061570,
 1175918831,
 -1,
 1176127105,
 1176033838,
 -1,
 1176192576,
 1176091163,
 -1,
 1176258097,
 1176153410,
 -1,
 1176323623,
 1176178853,
 127201,
 -47586,
 1176246333,
 127219,
 -47585,
 1176311692,
 127218,
 -47584,
 1176377004,
 127217,
 -47583,
 1176442332,
 127216,
 -47582,
 1176507623,
 127215,
 -47581,
 1176572947,
 127214,
 -47580,
 1176638197,
 127213,
 -47579,
 1176703440,
 127212,
 -47578,
 1176768677,
 127211,
 -1,
 1176833944,
 127210,
 1177044522,
 1176244688,
 127202,
 -47575,
 1176965285,
 127221,
 -1,
 1177030552,
 127220,
 -47573,
 1176967229,
 127209,
 -47572,
 1177163660,
 127208,
 -47571,
 1177228972,
 127207,
 -47570,
 1177294300,
 127206,
 -47569,
 1177359591,
 127205,
 -47568,
 1177424915,
 127204,
 -1,
 1177490165,
 127203,
 1177699894,
 1176229534,
 -1,
 -47565,
 1177662892,
 127138,
 -47564,
 1177704153,
 127154,
 -47563,
 1177761961,
 127170,
 -1,
 1177825588,
 127186,
 1178027579,
 1177639883,
 -1,
 -47560,
 1177990572,
 127139,
 -47559,
 1178031833,
 127155,
 -47558,
 1178089641,
 127171,
 -1,
 1178153268,
 127187,
 1178402815,
 1177961357,
 -1,
 -47555,
 1178318252,
 127146,
 -47554,
 1178359513,
 127162,
 -47553,
 1178417321,
 127178,
 -1,
 1178480948,
 127194,
 1178682957,
 1176127928,
 -1,
 1178748488,
 1178634666,
 -1,
 1178814023,
 1178716883,
 -1,
 -47548,
 1178777004,
 127140,
 -47547,
 1178818265,
 127156,
 -47546,
 1178876073,
 127172,
 -1,
 1178939700,
 127188,
 -1,
 1178766355,
 127200,
 1179254783,
 1178691870,
 -1,
 -47542,
 1179170220,
 127141,
 -47541,
 1179211481,
 127157,
 -47540,
 1179269289,
 127173,
 -1,
 1179332916,
 127189,
 1179534936,
 1178643852,
 -1,
 1179600467,
 1179478419,
 -1,
 -47536,
 1179563436,
 127142,
 -47535,
 1179604697,
 127158,
 -47534,
 1179662505,
 127174,
 -1,
 1179726132,
 127190,
 1179975679,
 1179535349,
 -1,
 -47531,
 1179891116,
 127143,
 -47530,
 1179932377,
 127159,
 -47529,
 1179990185,
 127175,
 -1,
 1180053812,
 127191,
 1180255843,
 1179478837,
 -1,
 1180321374,
 1180206604,
 -1,
 -47525,
 1180284332,
 127148,
 -47524,
 1180325593,
 127164,
 -47523,
 1180383401,
 127180,
 -1,
 1180447028,
 127196,
 1180696575,
 1180263298,
 -1,
 -47520,
 1180612012,
 127150,
 -47519,
 1180653273,
 127166,
 -47518,
 1180711081,
 127182,
 -1,
 1180774708,
 127198,
 1180976744,
 1180213384,
 -1,
 -47515,
 1180939692,
 127149,
 -47514,
 1180980953,
 127165,
 -47513,
 1181038761,
 127181,
 -1,
 1181102388,
 127197,
 1181304429,
 1180927552,
 -1,
 -47510,
 1181267372,
 127145,
 -47509,
 1181308633,
 127161,
 -47508,
 1181366441,
 127177,
 -1,
 1181430068,
 127193,
 1181632114,
 1181248042,
 -1,
 -47505,
 1181595052,
 127147,
 -47504,
 1181636313,
 127163,
 -47503,
 1181694121,
 127179,
 -1,
 1181757748,
 127195,
 1181959799,
 1181565526,
 -1,
 -47500,
 1181922732,
 127144,
 -47499,
 1181963993,
 127160,
 -47498,
 1182021801,
 127176,
 -1,
 1182085428,
 127192,
 1182287484,
 1181883012,
 -1,
 -47495,
 1182250412,
 127137,
 -47494,
 1182291673,
 127153,
 -47493,
 1182349481,
 127169,
 -1,
 1182413108,
 127185,
 1182615167,
 1182213554,
 -1,
 -47490,
 1182560071,
 127183,
 -1,
 1182603920,
 127136,
 -47488,
 1182585737,
 127199,
 -1,
 1182770369,
 127167,
 -1,
 1176055148,
 128720,
 -47485,
 1176028362,
 983150,
 -1,
 1182938589,
 983147,
 1183139497,
 1175957112,
 -1,
 1183205018,
 1183085788,
 -1,
 1183270539,
 1183165836,
 -1,
 1183336074,
 1183193327,
 -1,
 -47479,
 1183284860,
 68493,
 -1,
 1183332408,
 68495,
 -1,
 1183275213,
 68496,
 1183598221,
 1183209089,
 68484,
 -1,
 1183562961,
 68487,
 -47474,
 1183570884,
 68486,
 -47473,
 1183701682,
 68488,
 -47472,
 1183765051,
 68485,
 -47471,
 1183824788,
 68497,
 -47470,
 1183881581,
 68494,
 -47469,
 1183942940,
 68492,
 -47468,
 1184005785,
 68491,
 -47467,
 1184067570,
 68490,
 -47466,
 1184132090,
 68489,
 -47465,
 1184191038,
 68482,
 -47464,
 1184249533,
 68483,
 -47463,
 1184311269,
 68481,
 -1,
 1184374283,
 68480,
 1184581284,
 1183156448,
 -1,
 1184646817,
 1184545307,
 -1,
 1184712351,
 1184616716,
 -1,
 -47458,
 1184663978,
 68522,
 -1,
 1184711892,
 68526,
 -47456,
 1184652096,
 68523,
 -1,
 1184842596,
 68525,
 1185040035,
 1184599476,
 68521,
 -1,
 1184957275,
 68527,
 -1,
 1184976256,
 68524,
 1185236647,
 1184517580,
 -1,
 -47450,
 1185167854,
 68508,
 -1,
 1185231860,
 68507,
 -47448,
 1185203129,
 68506,
 -1,
 1185394525,
 68505,
 1185564368,
 1183097089,
 -1,
 1185629887,
 1185496636,
 -1,
 1185695422,
 1185591204,
 -1,
 1185760945,
 1185654604,
 -1,
 1185826480,
 1185731477,
 -1,
 -47441,
 1185770627,
 65048,
 -1,
 1185820792,
 983236,
 -1,
 1185789478,
 65096,
 1186088628,
 1185706626,
 -1,
 -47437,
 1186059178,
 65047,
 -1,
 1186117158,
 65095,
 1186285239,
 1186029248,
 -1,
 -47434,
 1186221863,
 65042,
 -1,
 1186279864,
 65041,
 1186481850,
 1186214202,
 -1,
 -47431,
 1186431184,
 65040,
 -1,
 1186494546,
 65043,
 -47429,
 1186443162,
 65044,
 -47428,
 1186635951,
 65046,
 -47427,
 1186683484,
 65049,
 -1,
 1186744507,
 65045,
 -1,
 1185632944,
 129328,
 1187006158,
 1185570001,
 -1,
 1187071689,
 1186974864,
 -1,
 1187137224,
 1187036100,
 -1,
 1187202757,
 1187057186,
 -1,
 -47420,
 1187123664,
 983166,
 -1,
 1187188901,
 983163,
 1187446783,
 1187119104,
 -1,
 -47417,
 1187365900,
 983165,
 -1,
 1187417524,
 983162,
 -1,
 1187067337,
 983192,
 1187708927,
 1187021556,
 -1,
 1187727052,
 1187626095,
 128424,
 -1,
 1187644260,
 128438,
 1187905535,
 1187655001,
 129332,
 -1,
 1187821171,
 128120,
 -47409,
 1186958180,
 128711,
 -1,
 1187915155,
 128255,
 1188120303,
 1185496636,
 -1,
 1188185829,
 1188077825,
 -1,
 1188251361,
 1188146572,
 -1,
 1188316896,
 1188203826,
 -1,
 1188382431,
 1188233216,
 -1,
 1188447963,
 1188353156,
 -1,
 1188513497,
 1188373938,
 -1,
 -47400,
 1188460630,
 128113,
 -1,
 1188503137,
 9977,
 -47398,
 1188470138,
 128590,
 -1,
 1188646121,
 128591,
 -47396,
 1188405861,
 128588,
 -47395,
 1188777660,
 128589,
 -47394,
 1188837825,
 129336,
 -1,
 1188899403,
 128583,
 -1,
 1188306345,
 128187,
 -1,
 1188251719,
 128547,
 -47390,
 1188207093,
 10178,
 -47389,
 1189182557,
 9854,
 -47388,
 1189236024,
 127917,
 -1,
 1189284042,
 8524,
 1189496554,
 1188135668,
 -1,
 -47385,
 1189460708,
 9956,
 -47384,
 1189524302,
 128532,
 -47383,
 1189565371,
 128039,
 -1,
 1189611116,
 128390,
 1189824238,
 1189419247,
 -1,
 -47380,
 1189781761,
 127824,
 -47379,
 1189841214,
 129372,
 -1,
 1189883376,
 127825,
 -1,
 1189754895,
 128694,
 1190151951,
 1188071850,
 -1,
 1190217463,
 1190122175,
 -1,
 1190282996,
 1190178188,
 -1,
 -47373,
 1190255211,
 9211,
 -1,
 1190294080,
 9214,
 1190526975,
 1190235442,
 -1,
 -47370,
 1190399733,
 9212,
 -1,
 1190463799,
 9213,
 1190676221,
 1190184138,
 -1,
 1190741755,
 1190641563,
 -1,
 -47366,
 1190677008,
 128545,
 -1,
 1190735074,
 128574,
 -47364,
 1190689358,
 127831,
 -1,
 1190866416,
 128093,
 1191069442,
 1190640155,
 -1,
 1191134977,
 1190992111,
 -1,
 -47360,
 1191100432,
 129364,
 -1,
 1191127335,
 128688,
 -1,
 1191052553,
 127858,
 1191397126,
 1191015870,
 -1,
 1191462661,
 1191324850,
 128659,
 -1,
 1191423474,
 128680,
 -1,
 1191414530,
 128110,
 1191659273,
 1191360220,
 -1,
 -47352,
 1191586393,
 128238,
 -1,
 1191648693,
 128239,
 1191855884,
 1191614318,
 -1,
 -47349,
 1191785246,
 127871,
 -1,
 1191838327,
 8297,
 -47347,
 1191816370,
 128254,
 -47346,
 1192004304,
 128041,
 -1,
 1192046717,
 128425,
 1192249116,
 1190091985,
 -1,
 1192314644,
 1192185656,
 128022,
 1192427519,
 1192230912,
 -1,
 -47341,
 1192331130,
 128061,
 -1,
 1192380944,
 128055,
 1192576791,
 1192264793,
 -1,
 -47338,
 1192501492,
 127821,
 -1,
 1192559211,
 127885,
 1192773402,
 1192521415,
 -1,
 -47335,
 1192718023,
 128138,
 -1,
 1192771234,
 128169,
 -47333,
 1192736680,
 128299,
 -1,
 1192898625,
 9935,
 1193101093,
 1192215754,
 -1,
 1193166624,
 1193058561,
 -1,
 -47329,
 1193127735,
 128091,
 -1,
 1193188229,
 128156,
 -47327,
 1193130555,
 128686,
 -47326,
 1193325043,
 128204,
 -47325,
 1193355585,
 128226,
 -47324,
 1193415120,
 983167,
 -1,
 1193480357,
 983164,
 1193690920,
 1193031133,
 -1,
 -47321,
 1193630929,
 983229,
 -1,
 1193691576,
 983220,
 -1,
 1193638591,
 983193,
 1193953750,
 1140165034,
 -1,
 1194019080,
 1193897671,
 -1,
 1194084552,
 1193948637,
 -1,
 1194150085,
 1194000384,
 -1,
 1194215331,
 1194089608,
 -1,
 1194280804,
 1194177614,
 -1,
 1194346318,
 1194212924,
 68809,
 1194411829,
 1194296052,
 68825,
 1194477363,
 1194375707,
 68839,
 -1,
 1194397511,
 68849,
 -47308,
 1194449107,
 68826,
 -1,
 1194535810,
 68805,
 1194739512,
 1194339202,
 68804,
 -47305,
 1194700172,
 68806,
 -1,
 1194742818,
 68841,
 1194936122,
 1194711855,
 68847,
 -1,
 1194896780,
 68848,
 1195067196,
 1194899995,
 68838,
 -1,
 1195038931,
 68840,
 1195198270,
 1195027852,
 68836,
 -1,
 1195170607,
 68837,
 1195329344,
 1195145919,
 68824,
 -1,
 1195284334,
 68833,
 1195460418,
 1195273927,
 68822,
 -1,
 1195432147,
 68823,
 1195591492,
 1195396920,
 68813,
 -1,
 1195563219,
 68814,
 -47291,
 1195560058,
 68846,
 -47290,
 1195680001,
 68834,
 -47289,
 1195743086,
 68832,
 -47288,
 1195797301,
 68819,
 -47287,
 1195862537,
 68818,
 -47286,
 1195922466,
 68815,
 -47285,
 1195985336,
 68812,
 -47284,
 1196047932,
 68811,
 -47283,
 1196111325,
 68807,
 -1,
 1196172722,
 68802,
 1196377939,
 1194268911,
 68800,
 -47280,
 1196327914,
 68808,
 -47279,
 1196391725,
 68803,
 -47278,
 1196452661,
 68820,
 -1,
 1196497135,
 68801,
 1196705623,
 1196344522,
 68842,
 -47275,
 1196672202,
 68843,
 -47274,
 1196731788,
 68850,
 -1,
 1196787390,
 68821,
 1196967770,
 1196657066,
 68827,
 -47271,
 1196919210,
 68828,
 -1,
 1196966125,
 68831,
 1197164381,
 1196928261,
 -1,
 -47268,
 1197131509,
 68845,
 -1,
 1197181653,
 68830,
 1197360992,
 1197114916,
 -1,
 -47265,
 1197328117,
 68844,
 -1,
 1197378261,
 68829,
 1197557602,
 1197300945,
 68816,
 -1,
 1197497553,
 68817,
 -47261,
 1197519293,
 68835,
 -1,
 1197617332,
 68810,
 1197819802,
 1194208402,
 -1,
 1197885316,
 1197751868,
 68745,
 1197950827,
 1197834996,
 68761,
 1198016361,
 1197914651,
 68775,
 -1,
 1197936455,
 68785,
 -47254,
 1197988051,
 68762,
 -1,
 1198074754,
 68741,
 1198278510,
 1197878146,
 68740,
 -47251,
 1198239116,
 68742,
 -1,
 1198281762,
 68777,
 1198475120,
 1198250799,
 68783,
 -1,
 1198435724,
 68784,
 1198606194,
 1198438939,
 68774,
 -1,
 1198577875,
 68776,
 1198737268,
 1198566796,
 68772,
 -1,
 1198709551,
 68773,
 1198868342,
 1198684863,
 68760,
 -1,
 1198823278,
 68769,
 1198999416,
 1198812871,
 68758,
 -1,
 1198971091,
 68759,
 1199130490,
 1198935864,
 68749,
 -1,
 1199102163,
 68750,
 -47237,
 1199099002,
 68782,
 -47236,
 1199218945,
 68770,
 -47235,
 1199282030,
 68768,
 -47234,
 1199336245,
 68755,
 -47233,
 1199401481,
 68754,
 -47232,
 1199461410,
 68751,
 -47231,
 1199524280,
 68748,
 -47230,
 1199586876,
 68747,
 -47229,
 1199650269,
 68743,
 -1,
 1199711666,
 68738,
 1199916937,
 1197807855,
 68736,
 -47226,
 1199866858,
 68744,
 -47225,
 1199930669,
 68739,
 -47224,
 1199991605,
 68756,
 -1,
 1200036079,
 68737,
 1200244621,
 1199883466,
 68778,
 -47221,
 1200211146,
 68779,
 -47220,
 1200270732,
 68786,
 -1,
 1200326334,
 68757,
 1200506768,
 1200196010,
 68763,
 -47217,
 1200458154,
 68764,
 -1,
 1200505069,
 68767,
 1200703379,
 1200467205,
 -1,
 -47214,
 1200670453,
 68781,
 -1,
 1200720597,
 68766,
 1200899990,
 1200653860,
 -1,
 -47211,
 1200867061,
 68780,
 -1,
 1200917205,
 68765,
 1201096600,
 1200839889,
 68752,
 -1,
 1201036497,
 68753,
 -47207,
 1201058237,
 68771,
 -1,
 1201156276,
 68746,
 1201405951,
 1197770976,
 -1,
 1201424287,
 1201311156,
 68858,
 1201537023,
 1201340416,
 -1,
 -47202,
 1201454485,
 68863,
 -1,
 1201495127,
 68862,
 1201686434,
 1201359642,
 -1,
 -47199,
 1201655141,
 68859,
 -1,
 1201688351,
 68861,
 -1,
 1201650743,
 68860,
 1201948696,
 1194170946,
 -1,
 1202014185,
 1201909132,
 -1,
 1202079720,
 1201954226,
 -1,
 1202145247,
 1202041487,
 -1,
 1202210733,
 1202075101,
 -1,
 1202276267,
 1202133231,
 66477,
 1202388991,
 1202216130,
 66508,
 -1,
 1202261543,
 66509,
 -47188,
 1202242762,
 66479,
 -1,
 1202412753,
 66478,
 1202603953,
 1202133231,
 66464,
 1202716671,
 1202572004,
 66504,
 -47184,
 1202607160,
 66506,
 -1,
 1202654759,
 66505,
 1202866101,
 1202567707,
 -1,
 -47181,
 1202832586,
 66476,
 -47180,
 1202869304,
 66480,
 -1,
 1202919663,
 66475,
 1203128249,
 1202826636,
 -1,
 -47177,
 1203088927,
 66498,
 -47176,
 1203131448,
 66497,
 -1,
 1203181807,
 66495,
 1203390397,
 1203075775,
 -1,
 -47173,
 1203356874,
 66488,
 -47172,
 1203395793,
 66487,
 -1,
 1203443951,
 66486,
 1203652545,
 1203316146,
 -1,
 1203718080,
 1203575023,
 66482,
 -1,
 1203654535,
 66510,
 -1,
 1203686509,
 66511,
 1203914692,
 1203623901,
 -1,
 -47165,
 1203875956,
 66507,
 -1,
 1203902703,
 66471,
 1204111303,
 1203883130,
 -1,
 -47162,
 1204051153,
 66491,
 -1,
 1204099311,
 66490,
 1204307914,
 1204068609,
 -1,
 -47159,
 1204274378,
 66493,
 -1,
 1204295919,
 66492,
 1204504525,
 1204257524,
 -1,
 -47156,
 1204470986,
 66485,
 -1,
 1204492527,
 66484,
 1204701136,
 1204448053,
 -1,
 -47153,
 1204667594,
 66468,
 -1,
 1204689135,
 66467,
 1204897747,
 1204644361,
 -1,
 -47150,
 1204837585,
 66474,
 -1,
 1204885743,
 66473,
 1205094358,
 1204834104,
 -1,
 -47147,
 1205060810,
 66470,
 -1,
 1205082351,
 66469,
 -47145,
 1205066559,
 66496,
 -47144,
 1205262636,
 66489,
 -47143,
 1205322954,
 66466,
 -47142,
 1205376988,
 66481,
 -47141,
 1205432069,
 66494,
 -47140,
 1205492945,
 66465,
 -47139,
 1205556280,
 66499,
 -47138,
 1205619213,
 66483,
 -1,
 1205676976,
 66472,
 1205880807,
 1202096352,
 -1,
 1205946341,
 1205844507,
 -1,
 1206011876,
 1205915916,
 -1,
 -47133,
 1205963178,
 66514,
 -1,
 1206011092,
 66516,
 -1,
 1205945188,
 66515,
 -47130,
 1205898676,
 66513,
 -1,
 1206213719,
 66517,
 -1,
 1205851968,
 66512,
 -1,
 1202032033,
 128435,
 1206583295,
 1201962797,
 -1,
 1206601714,
 1206507731,
 -1,
 1206667246,
 1206535554,
 66415,
 -47123,
 1206633674,
 66408,
 -1,
 1206672593,
 66416,
 1206863856,
 1206589679,
 66420,
 -1,
 1206827547,
 66417,
 -47119,
 1206830282,
 66419,
 -1,
 1206955363,
 66407,
 1207126007,
 1206562188,
 -1,
 1207191542,
 1207063586,
 -1,
 -47115,
 1207144273,
 66405,
 -1,
 1207185110,
 66406,
 -1,
 1207132320,
 66401,
 1207453690,
 1207065809,
 66393,
 -47111,
 1207385660,
 66418,
 -1,
 1207441647,
 66421,
 1207650303,
 1207383517,
 -1,
 1207715838,
 1207622447,
 -1,
 -47107,
 1207658516,
 66392,
 -1,
 1207720375,
 66390,
 -1,
 1207667582,
 66387,
 1207977986,
 1207622447,
 -1,
 -47103,
 1207916983,
 66389,
 -1,
 1207968712,
 66391,
 1208174597,
 1207946362,
 -1,
 -47100,
 1208127313,
 66398,
 -1,
 1208173954,
 66414,
 1208371208,
 1208138267,
 -1,
 -47097,
 1208333130,
 66413,
 -1,
 1208360127,
 66402,
 1208567818,
 1208322474,
 66409,
 -1,
 1208519082,
 66410,
 1208698892,
 1208499772,
 66388,
 -1,
 1208633784,
 66411,
 -47091,
 1208665290,
 66403,
 -47090,
 1208788304,
 66400,
 -47089,
 1208850851,
 66399,
 -47088,
 1208911083,
 66397,
 -47087,
 1208975045,
 66396,
 -47086,
 1209037945,
 66395,
 -47085,
 1209101817,
 66394,
 -47084,
 1209160760,
 66412,
 -47083,
 1209225197,
 66386,
 -47082,
 1209282195,
 66404,
 -47081,
 1209346844,
 66385,
 -1,
 1209409309,
 66384,
 1209616489,
 1201914711,
 -1,
 1209681991,
 1209569712,
 -1,
 1209747505,
 1209604335,
 68608,
 1209813030,
 1209679420,
 -1,
 -47075,
 1209784531,
 68632,
 -47074,
 1209842203,
 68677,
 -47073,
 1209904524,
 68670,
 -47072,
 1209966849,
 68668,
 -47071,
 1210024692,
 68644,
 -47070,
 1210085063,
 68640,
 -47069,
 1210149685,
 68634,
 -47068,
 1210208056,
 68623,
 -47067,
 1210267101,
 68627,
 -1,
 1210328498,
 68619,
 1210533928,
 1209773452,
 68669,
 -1,
 1210471458,
 68671,
 -47063,
 1210505427,
 68630,
 -47062,
 1210628635,
 68675,
 -47061,
 1210687745,
 68666,
 -47060,
 1210752843,
 68660,
 -47059,
 1210811124,
 68643,
 -47058,
 1210871495,
 68638,
 -47057,
 1210928952,
 68621,
 -47056,
 1210987997,
 68625,
 -1,
 1211049394,
 68617,
 1211254845,
 1209679420,
 -1,
 1211320375,
 1211204340,
 -1,
 -47052,
 1211291859,
 68650,
 -47051,
 1211349531,
 68646,
 -47050,
 1211387704,
 68653,
 -1,
 1211444098,
 68648,
 -47048,
 1211292463,
 68628,
 -47047,
 1211609142,
 68673,
 -47046,
 1211668334,
 68655,
 -47045,
 1211726527,
 68642,
 -47044,
 1211791878,
 68641,
 -1,
 1211837314,
 68658,
 1212041283,
 1211206058,
 68614,
 1212106816,
 1211973180,
 68615,
 -1,
 1212050229,
 68636,
 -47039,
 1212070427,
 68679,
 -47038,
 1212194635,
 68664,
 -1,
 1212258158,
 68656,
 1212434502,
 1211981009,
 68611,
 -47035,
 1212391243,
 68662,
 -1,
 1212427138,
 68657,
 -1,
 1212360458,
 68680,
 1212743679,
 1209653739,
 -1,
 1212762203,
 1212618991,
 68609,
 1212827729,
 1212694076,
 68610,
 1212893260,
 1212777204,
 68645,
 -1,
 1212829496,
 68654,
 -47027,
 1212864723,
 68633,
 -47026,
 1212987931,
 68678,
 -47025,
 1213033269,
 68635,
 -47024,
 1213091640,
 68624,
 -1,
 1213146546,
 68620,
 -47022,
 1212799187,
 68631,
 -47021,
 1213315611,
 68676,
 -47020,
 1213378614,
 68672,
 -47019,
 1213440257,
 68667,
 -47018,
 1213505355,
 68661,
 -47017,
 1213564264,
 68652,
 -47016,
 1213624007,
 68639,
 -47015,
 1213681464,
 68622,
 -47014,
 1213740509,
 68626,
 -1,
 1213801906,
 68618,
 1214007395,
 1212694076,
 68613,
 1214072928,
 1213956852,
 -1,
 -47010,
 1214044371,
 68651,
 -47009,
 1214102043,
 68647,
 -1,
 1214131074,
 68649,
 -47007,
 1214044975,
 68629,
 -47006,
 1214296118,
 68674,
 -1,
 1214327682,
 68659,
 1214531687,
 1213958570,
 -1,
 1214597222,
 1214463548,
 68616,
 -1,
 1214540597,
 68637,
 -1,
 1214553931,
 68665,
 1214840831,
 1214471377,
 68612,
 -1,
 1214750539,
 68663,
 1214924950,
 1209578878,
 -1,
 1214990481,
 1214870748,
 -1,
 1215055985,
 1214954011,
 -1,
 1215121519,
 1214993442,
 -1,
 -46994,
 1215055616,
 68220,
 -1,
 1215112540,
 68219,
 -46992,
 1215055616,
 68215,
 -1,
 1215243612,
 68201,
 1215449207,
 1215016332,
 -1,
 1215514742,
 1215371503,
 -1,
 -46988,
 1215478299,
 68202,
 -46987,
 1215528572,
 68207,
 -1,
 1215576120,
 68206,
 -1,
 1215453389,
 68198,
 1215842428,
 1215378909,
 -1,
 1215907963,
 1215779896,
 -1,
 -46982,
 1215853764,
 68217,
 -1,
 1215903800,
 68211,
 -1,
 1215831574,
 68213,
 1216170111,
 1215785781,
 -1,
 -46978,
 1216108441,
 68205,
 -1,
 1216159947,
 68203,
 1216366721,
 1216108161,
 68192,
 -1,
 1216330961,
 68194,
 1216497796,
 1216302904,
 -1,
 -46973,
 1216438578,
 68212,
 -1,
 1216501369,
 68214,
 1216694407,
 1216420079,
 -1,
 -46970,
 1216666268,
 68210,
 -1,
 1216705106,
 68209,
 -46968,
 1216666570,
 68216,
 -46967,
 1216862898,
 68218,
 -46966,
 1216926253,
 68197,
 -46965,
 1216980427,
 68199,
 -46964,
 1217044412,
 68196,
 -46963,
 1217104156,
 68204,
 -46962,
 1217166997,
 68195,
 -46961,
 1217228786,
 68193,
 -46960,
 1217284723,
 68208,
 -1,
 1217341413,
 68200,
 1217593343,
 1214941404,
 -1,
 1217611925,
 1217472429,
 -1,
 -46956,
 1217564084,
 68221,
 -1,
 1217612579,
 68222,
 -1,
 1217545726,
 68223,
 1217874115,
 1214875499,
 -1,
 1217939646,
 1217819868,
 -1,
 1218005150,
 1217903131,
 -1,
 1218070684,
 1217942562,
 -1,
 -46949,
 1218003432,
 68251,
 -1,
 1218059686,
 68249,
 -46947,
 1218003432,
 68233,
 -1,
 1218190472,
 68247,
 1218398370,
 1217939088,
 -1,
 -46944,
 1218319093,
 68239,
 -46943,
 1218384336,
 68230,
 -1,
 1218449573,
 68234,
 1218660517,
 1218370367,
 -1,
 -46940,
 1218601346,
 68248,
 -1,
 1218663458,
 68252,
 1218857128,
 1218603829,
 -1,
 -46937,
 1218794607,
 68237,
 -1,
 1218845672,
 68235,
 1219053739,
 1218794530,
 -1,
 -46934,
 1218986472,
 68224,
 -1,
 1219042440,
 68226,
 1219250350,
 1218989880,
 -1,
 -46931,
 1219187854,
 68246,
 -1,
 1219248419,
 68244,
 1219446961,
 1219180139,
 -1,
 -46928,
 1219391175,
 68245,
 -1,
 1219442141,
 68243,
 1219643572,
 1219369199,
 -1,
 -46925,
 1219588690,
 68241,
 -1,
 1219649922,
 68242,
 -46923,
 1219615160,
 68250,
 -46922,
 1219809837,
 68229,
 -46921,
 1219866170,
 68238,
 -46920,
 1219929420,
 68231,
 -46919,
 1219993458,
 68228,
 -46918,
 1220052765,
 68236,
 -46917,
 1220116044,
 68227,
 -46916,
 1220177886,
 68225,
 -46915,
 1220233886,
 68240,
 -1,
 1220290413,
 68232,
 1220542463,
 1217890528,
 -1,
 1220561090,
 1220459035,
 -1,
 -46911,
 1220530847,
 68255,
 -1,
 1220559716,
 68254,
 -1,
 1220513204,
 68253,
 -46908,
 1217817844,
 128477,
 -1,
 1220765744,
 66335,
 1221001215,
 1194083717,
 -1,
 -46905,
 1220925218,
 128117,
 -1,
 1220967491,
 128116,
 1221197823,
 1194000887,
 -1,
 1221216495,
 1221096668,
 -1,
 1221282004,
 1221138671,
 -1,
 1221347536,
 1221204207,
 -1,
 -46899,
 1221316876,
 7267,
 -46898,
 1221360319,
 7266,
 -46897,
 1221421877,
 7264,
 -1,
 1221487113,
 7265,
 -46895,
 1221311003,
 7259,
 -46894,
 1221625192,
 7261,
 -46893,
 1221684935,
 7262,
 -1,
 1221742392,
 7260,
 1221937371,
 1221226183,
 -1,
 1222002903,
 1221859567,
 7258,
 -1,
 1221925103,
 7263,
 -46888,
 1221969098,
 7273,
 -46887,
 1222085034,
 7283,
 -46886,
 1222139089,
 7268,
 -1,
 1222196796,
 7278,
 1222396128,
 1221903562,
 -1,
 -46883,
 1222367443,
 7277,
 -46882,
 1222411983,
 7276,
 -46881,
 1222456797,
 7275,
 -1,
 1222519682,
 7274,
 1222723813,
 1222347178,
 -1,
 -46878,
 1222691962,
 7286,
 -46877,
 1222755013,
 7284,
 -46876,
 1222792226,
 7287,
 -1,
 1222845874,
 7285,
 1223051498,
 1222663377,
 -1,
 -46873,
 1223011724,
 7269,
 -46872,
 1223074049,
 7272,
 -46871,
 1223133522,
 7271,
 -1,
 1223185442,
 7270,
 1223426047,
 1222983228,
 -1,
 -46868,
 1223339090,
 7282,
 -46867,
 1223399278,
 7279,
 -46866,
 1223459572,
 7281,
 -1,
 1223505702,
 7280,
 1223706877,
 1221146844,
 -1,
 1223772403,
 1223670299,
 -1,
 -46862,
 1223742986,
 7250,
 -1,
 1223777088,
 7251,
 1223969014,
 1223732620,
 -1,
 -46859,
 1223911811,
 7254,
 -1,
 1223968735,
 7255,
 1224165625,
 1223903672,
 -1,
 -46856,
 1224119236,
 7252,
 -1,
 1224173777,
 7253,
 -46854,
 1224137713,
 7248,
 -46853,
 1224314292,
 7249,
 -46852,
 1224377904,
 7257,
 -1,
 1224426037,
 7256,
 1224624386,
 1223661422,
 -1,
 1224689921,
 1224591455,
 -1,
 -46848,
 1224639017,
 7294,
 -1,
 1224686564,
 7295,
 -1,
 1224627281,
 7292,
 1224952069,
 1224573473,
 -1,
 -46844,
 1224871544,
 7290,
 -1,
 1224936152,
 7288,
 -46842,
 1224910164,
 7291,
 -46841,
 1225084814,
 7289,
 -1,
 1225137323,
 7293,
 1225345430,
 1193979276,
 -1,
 1225410916,
 1225268285,
 -1,
 1225476407,
 1225372750,
 -1,
 1225541908,
 1225408060,
 66783,
 1225607443,
 1225479202,
 -1,
 1225672976,
 1225570843,
 -1,
 -46833,
 1225633311,
 66803,
 -1,
 1225660655,
 66801,
 -46831,
 1225627612,
 66797,
 -46830,
 1225812871,
 66789,
 -1,
 1225862683,
 66782,
 -1,
 1225548162,
 66784,
 1226131736,
 1225464047,
 66776,
 1226197271,
 1226071249,
 66777,
 -1,
 1226146548,
 66778,
 -1,
 1226134562,
 66779,
 1226393885,
 1226095131,
 -1,
 1226459420,
 1226354060,
 -1,
 -46821,
 1226396728,
 66804,
 -1,
 1226447087,
 66802,
 -1,
 1226381551,
 66800,
 1226721569,
 1226337077,
 -1,
 -46817,
 1226692908,
 66790,
 -46816,
 1226724408,
 66808,
 -1,
 1226774767,
 66788,
 1226983716,
 1226693423,
 -1,
 -46813,
 1226921016,
 66811,
 -1,
 1226971375,
 66810,
 1227180327,
 1226943884,
 -1,
 -46810,
 1227117624,
 66799,
 -1,
 1227167983,
 66798,
 1227376937,
 1227131306,
 66794,
 -1,
 1227317634,
 66795,
 1227508012,
 1227314210,
 -1,
 -46805,
 1227479340,
 66786,
 -1,
 1227495663,
 66785,
 -46803,
 1227477324,
 66807,
 -46802,
 1227670730,
 66806,
 -46801,
 1227724764,
 66796,
 -46800,
 1227785041,
 66793,
 -46799,
 1227848469,
 66792,
 -46798,
 1227910917,
 66791,
 -46797,
 1227971793,
 66787,
 -46796,
 1228034432,
 66809,
 -46795,
 1228093478,
 66805,
 -46794,
 1228156443,
 66781,
 -1,
 1228221033,
 66780,
 1228472319,
 1225403538,
 -1,
 1228491073,
 1228357180,
 66743,
 1228556608,
 1228428322,
 -1,
 1228622141,
 1228519963,
 -1,
 -46788,
 1228582431,
 66763,
 -1,
 1228609775,
 66761,
 -46786,
 1228576732,
 66757,
 -46785,
 1228761991,
 66749,
 -1,
 1228811803,
 66742,
 -1,
 1228497282,
 66744,
 1229080901,
 1228413167,
 66736,
 1229146436,
 1229020369,
 66737,
 -1,
 1229095668,
 66738,
 -1,
 1229083682,
 66739,
 1229343050,
 1229044251,
 -1,
 1229408585,
 1229303180,
 -1,
 -46776,
 1229345848,
 66764,
 -1,
 1229396207,
 66762,
 -1,
 1229330671,
 66760,
 1229670734,
 1229286197,
 -1,
 -46772,
 1229642028,
 66750,
 -46771,
 1229673528,
 66768,
 -1,
 1229723887,
 66748,
 1229932881,
 1229642543,
 -1,
 -46768,
 1229870136,
 66771,
 -1,
 1229920495,
 66770,
 1230129492,
 1229893004,
 -1,
 -46765,
 1230066744,
 66759,
 -1,
 1230117103,
 66758,
 1230326102,
 1230080426,
 66754,
 -1,
 1230266754,
 66755,
 1230457177,
 1230263330,
 -1,
 -46760,
 1230428460,
 66746,
 -1,
 1230444783,
 66745,
 -46758,
 1230426444,
 66767,
 -46757,
 1230619850,
 66766,
 -46756,
 1230673884,
 66756,
 -46755,
 1230734161,
 66753,
 -46754,
 1230797589,
 66752,
 -46753,
 1230860037,
 66751,
 -46752,
 1230920913,
 66747,
 -46751,
 1230983552,
 66769,
 -46750,
 1231042598,
 66765,
 -46749,
 1231105563,
 66741,
 -1,
 1231170153,
 66740,
 1231374741,
 1225358456,
 -1,
 1231440263,
 1231320284,
 -1,
 1231505769,
 1231362287,
 66710,
 -46744,
 1231450706,
 66688,
 -1,
 1231493359,
 66715,
 1231702380,
 1231465868,
 -1,
 -46741,
 1231640736,
 66697,
 -1,
 1231689967,
 66696,
 1231898990,
 1231653290,
 66713,
 -1,
 1231849898,
 66717,
 1232030065,
 1231842101,
 -1,
 -46736,
 1231967288,
 66693,
 -1,
 1232017824,
 66703,
 1232226675,
 1231961660,
 66711,
 -1,
 1232158268,
 66716,
 1232357750,
 1232156125,
 -1,
 -46731,
 1232294968,
 66698,
 -1,
 1232355599,
 66694,
 -46729,
 1232329004,
 66709,
 -46728,
 1232525312,
 66692,
 -46727,
 1232589357,
 66707,
 -46726,
 1232651466,
 66714,
 -46725,
 1232714397,
 66690,
 -46724,
 1232773499,
 66695,
 -46723,
 1232838509,
 66702,
 -46722,
 1232898371,
 66706,
 -46721,
 1232961544,
 66705,
 -46720,
 1233022750,
 66704,
 -46719,
 1233087015,
 66691,
 -46718,
 1233149137,
 66712,
 -46717,
 1233212472,
 66708,
 -46716,
 1233276807,
 66700,
 -46715,
 1233340941,
 66701,
 -46714,
 1233399093,
 66699,
 -1,
 1233462759,
 66689,
 1233715199,
 1231370460,
 -1,
 1233734027,
 1233631771,
 -1,
 -46710,
 1233704458,
 66722,
 -1,
 1233738560,
 66723,
 1233930638,
 1233694092,
 -1,
 -46707,
 1233873283,
 66726,
 -1,
 1233930207,
 66727,
 1234127249,
 1233865144,
 -1,
 -46704,
 1234080708,
 66724,
 -1,
 1234135249,
 66725,
 -46702,
 1234099185,
 66720,
 -46701,
 1234275764,
 66721,
 -46700,
 1234339376,
 66729,
 -1,
 1234387509,
 66728,
 -1,
 1231301506,
 983191,
 1234651562,
 1225302273,
 -1,
 1234717096,
 1234594277,
 -1,
 1234782625,
 1234652749,
 -1,
 1234848158,
 1234734520,
 -1,
 -46693,
 1234809715,
 2933,
 -46692,
 1234870322,
 2930,
 -46691,
 1234916551,
 2931,
 -1,
 1234977398,
 2934,
 1235222527,
 1234812353,
 -1,
 -46688,
 1235137405,
 2935,
 -1,
 1235198065,
 2932,
 1235372453,
 1234751666,
 -1,
 1235437988,
 1235316423,
 2914,
 -1,
 1235381959,
 2915,
 -1,
 1235397714,
 2884,
 1235681279,
 1235317980,
 -1,
 -46681,
 1235603788,
 2929,
 -1,
 1235668112,
 2869,
 -46679,
 1234640884,
 128217,
 -1,
 1235749841,
 10183,
 1235962301,
 1234605934,
 -1,
 1236027834,
 1235893820,
 -1,
 1236093369,
 1235976950,
 -1,
 1236158896,
 1236056289,
 -1,
 -46673,
 1236114054,
 10180,
 -1,
 1236150998,
 10179,
 1236355507,
 1236106127,
 -1,
 -46670,
 1236312577,
 128236,
 -1,
 1236367817,
 128237,
 1236552118,
 1236289976,
 -1,
 -46667,
 1236503661,
 128449,
 -1,
 1236558064,
 128194,
 -46665,
 1236498490,
 128275,
 -46664,
 1236686286,
 128080,
 -1,
 1236740589,
 128214,
 -1,
 1236050711,
 983190,
 1237010876,
 1235992210,
 128191,
 -1,
 1236927332,
 128440,
 -1,
 1236949326,
 9934,
 1237207496,
 1235911412,
 -1,
 1237273028,
 1237135792,
 -1,
 -46656,
 1237236637,
 128662,
 -46655,
 1237294345,
 128660,
 -46654,
 1237339058,
 128753,
 -46653,
 1237396263,
 128653,
 -1,
 1237460233,
 128664,
 1237666247,
 1237204542,
 -1,
 -46650,
 1237596749,
 11819,
 -1,
 1237658461,
 128431,
 -1,
 1237584925,
 128283,
 1237928395,
 1237175323,
 -1,
 -46646,
 1237874392,
 9885,
 -1,
 1237920349,
 128228,
 1238125006,
 1237857508,
 -1,
 -46643,
 1238077682,
 128025,
 -1,
 1238113395,
 128721,
 -46641,
 1238095837,
 128002,
 -46640,
 1238291887,
 129417,
 -46639,
 1238355479,
 128471,
 -46638,
 1238399753,
 128329,
 -46637,
 1238461252,
 128076,
 -46636,
 1238524088,
 128738,
 -46635,
 1238584017,
 127970,
 -1,
 1238644622,
 127842,
 1238846494,
 1193889592,
 -1,
 1238911796,
 1238802689,
 -1,
 1238977222,
 1238843629,
 -1,
 1239042753,
 1238919991,
 -1,
 1239108142,
 1238964463,
 -1,
 1239173675,
 1239036905,
 -1,
 1239239169,
 1239098516,
 -1,
 1239304688,
 1239173914,
 -1,
 1239370217,
 1239272805,
 65859,
 1239482367,
 1239285760,
 -1,
 1239501284,
 1239398939,
 -1,
 1239566819,
 1239440133,
 65862,
 -1,
 1239484764,
 65870,
 -1,
 1239490052,
 65864,
 1239763432,
 1239440471,
 65861,
 1239875583,
 1239678976,
 -1,
 -46617,
 1239792439,
 65868,
 -1,
 1239856949,
 65875,
 -1,
 1239725877,
 65871,
 1240137727,
 1239306015,
 65860,
 1240203263,
 1240006656,
 -1,
 1240222191,
 1240119835,
 -1,
 1240287726,
 1240161029,
 65863,
 -1,
 1240205598,
 65878,
 -1,
 1240210948,
 65866,
 -1,
 1240184629,
 65873,
 1240549883,
 1239256504,
 -1,
 1240615414,
 1240486946,
 -1,
 1240680949,
 1240582317,
 -1,
 -46604,
 1240644407,
 65867,
 -1,
 1240708917,
 65874,
 -1,
 1240604197,
 65857,
 1240943097,
 1240579486,
 -1,
 -46600,
 1240906551,
 65869,
 -1,
 1240971061,
 65876,
 -46598,
 1240899634,
 65856,
 -1,
 1241070956,
 65858,
 1241317375,
 1240513595,
 -1,
 1241336319,
 1241233947,
 -1,
 -46594,
 1241275171,
 65877,
 -1,
 1241325060,
 65865,
 -46592,
 1241298741,
 65872,
 -1,
 1241481446,
 65879,
 1241664026,
 1239202331,
 -1,
 1241729554,
 1241601931,
 -1,
 1241795081,
 1241692699,
 -1,
 1241860615,
 1241732130,
 -1,
 -46586,
 1241818356,
 65899,
 -1,
 1241868097,
 65893,
 -46584,
 1241830922,
 65884,
 -1,
 1241989988,
 65892,
 1242188301,
 1241746868,
 65881,
 1242300415,
 1242103808,
 -1,
 -46580,
 1242217877,
 65905,
 -1,
 1242258519,
 65898,
 1242497023,
 1242123034,
 -1,
 1242515985,
 1242418536,
 -1,
 -46576,
 1242480021,
 65906,
 -1,
 1242520663,
 65902,
 -1,
 1242451743,
 65897,
 1242824703,
 1241688894,
 -1,
 1242843672,
 1242712858,
 -1,
 1242909206,
 1242811749,
 65887,
 -1,
 1242825563,
 65901,
 1243086847,
 1242844959,
 65894,
 -1,
 1242955814,
 65895,
 1243217919,
 1242807351,
 65888,
 -1,
 1243086886,
 65889,
 1243302432,
 1241601883,
 -1,
 1243367967,
 1243250831,
 -1,
 -46563,
 1243331639,
 65890,
 -46562,
 1243385268,
 65882,
 -1,
 1243433763,
 65896,
 -1,
 1243290582,
 65880,
 1243695652,
 1243235639,
 -1,
 1243761187,
 1243661324,
 65883,
 -1,
 1243677372,
 65886,
 -1,
 1243696139,
 65900,
 1243957799,
 1243622274,
 -1,
 -46554,
 1243929338,
 65885,
 -1,
 1243947762,
 65903,
 -46552,
 1243920425,
 65908,
 -46551,
 1244103618,
 65904,
 -46550,
 1244167916,
 65891,
 -1,
 1244215159,
 65907,
 1244463103,
 1239130369,
 -1,
 -46547,
 1244379849,
 65926,
 -1,
 1244435534,
 65927,
 1244613207,
 1239048578,
 -1,
 1244678742,
 1244575920,
 -1,
 1244744248,
 1244599315,
 119327,
 -46542,
 1244665917,
 119356,
 -46541,
 1244731276,
 119355,
 -46540,
 1244796588,
 119354,
 -46539,
 1244861671,
 119353,
 -46538,
 1244926709,
 119352,
 -46537,
 1244991952,
 119351,
 -1,
 1245056920,
 119350,
 1245268544,
 1244663973,
 119325,
 -46534,
 1245190205,
 119337,
 -46533,
 1245255564,
 119336,
 -46532,
 1245320876,
 119335,
 -46531,
 1245385747,
 119334,
 -46530,
 1245450997,
 119333,
 -46529,
 1245516240,
 119332,
 -1,
 1245581477,
 119331,
 1245792839,
 1245188560,
 119326,
 -46526,
 1245714493,
 119343,
 -46525,
 1245779628,
 119342,
 -46524,
 1245844956,
 119341,
 -46523,
 1245910247,
 119340,
 -46522,
 1245975571,
 119339,
 -1,
 1246040821,
 119338,
 1246251597,
 1245713639,
 119328,
 -46519,
 1246172179,
 119361,
 -46518,
 1246237429,
 119360,
 -46517,
 1246302672,
 119359,
 -46516,
 1246367909,
 119358,
 -1,
 1246433176,
 119357,
 1246644820,
 1246171893,
 -1,
 -46513,
 1246566461,
 119349,
 -46512,
 1246631820,
 119348,
 -46511,
 1246697132,
 119347,
 -46510,
 1246762460,
 119346,
 -46509,
 1246826960,
 119345,
 -1,
 1246891928,
 119344,
 -46507,
 1246566284,
 119330,
 -1,
 1247024812,
 119329,
 -1,
 1244608719,
 65933,
 1247300213,
 1244581796,
 -1,
 1247365731,
 1247219877,
 119296,
 -46502,
 1247287357,
 119314,
 -46501,
 1247352716,
 119313,
 -46500,
 1247418028,
 119312,
 -46499,
 1247483356,
 119311,
 -46498,
 1247548647,
 119310,
 -46497,
 1247613971,
 119309,
 -46496,
 1247679221,
 119308,
 -46495,
 1247744464,
 119307,
 -46494,
 1247809701,
 119306,
 -1,
 1247874968,
 119305,
 1248086633,
 1247286503,
 119300,
 -46491,
 1248007187,
 119324,
 -46490,
 1248072437,
 119323,
 -46489,
 1248137680,
 119322,
 -46488,
 1248202917,
 119321,
 -1,
 1248268184,
 119320,
 1248479855,
 1248006608,
 119297,
 -46485,
 1248400403,
 119319,
 -46484,
 1248465653,
 119318,
 -46483,
 1248530896,
 119317,
 -46482,
 1248596133,
 119316,
 -1,
 1248661400,
 119315,
 -46480,
 1248401469,
 119304,
 -46479,
 1248794508,
 119303,
 -46478,
 1248859820,
 119302,
 -46477,
 1248925148,
 119301,
 -46476,
 1248990227,
 119299,
 -1,
 1249055477,
 119298,
 1249266314,
 1247260044,
 -1,
 1249331842,
 1249213411,
 -1,
 1249397374,
 1249277148,
 -1,
 1249462907,
 1249357196,
 -1,
 -46470,
 1249401235,
 1016,
 -1,
 1249451805,
 1019,
 -46468,
 1249417303,
 887,
 -46467,
 1249597332,
 881,
 -1,
 1249649013,
 883,
 1249856129,
 1249355296,
 -1,
 -46464,
 1249802892,
 891,
 -1,
 1249852102,
 893,
 -1,
 1249786566,
 892,
 1250118280,
 1249298041,
 -1,
 -46460,
 1250076293,
 7528,
 -46459,
 1250138826,
 7529,
 -46458,
 1250185227,
 7527,
 -46457,
 1250242207,
 7530,
 -1,
 1250306009,
 7526,
 -46455,
 1250089605,
 65952,
 -1,
 1250452810,
 65932,
 1250642586,
 1249193071,
 -1,
 1250708117,
 1250586311,
 -1,
 1250773652,
 1250641696,
 -1,
 1250839184,
 1250733452,
 -1,
 -46449,
 1250777491,
 1015,
 -1,
 1250828061,
 1018,
 -46447,
 1250810551,
 895,
 -46446,
 1250990167,
 886,
 -46445,
 1251039124,
 880,
 -1,
 1251090805,
 882,
 -1,
 1250740276,
 1017,
 1251363480,
 1250666016,
 -1,
 -46441,
 1251310220,
 1021,
 -1,
 1251359430,
 1023,
 -46439,
 1251306447,
 975,
 -1,
 1251490502,
 1022,
 1251691172,
 1250586311,
 -1,
 1251756707,
 1251624743,
 -1,
 1251822239,
 1251710830,
 -1,
 -46434,
 1251783194,
 7466,
 -1,
 1251826897,
 7464,
 -46432,
 1251780229,
 7465,
 -46431,
 1251970315,
 43877,
 -46430,
 1252028396,
 7463,
 -1,
 1252085771,
 7462,
 -1,
 1251698865,
 65923,
 1252346541,
 1251654171,
 -1,
 1252412072,
 1252316685,
 -1,
 -46425,
 1252375941,
 65911,
 -1,
 1252428318,
 65917,
 1252608683,
 1252350789,
 -1,
 -46422,
 1252565114,
 65912,
 -1,
 1252624926,
 65918,
 -46420,
 1252568430,
 65929,
 -1,
 1252728313,
 65914,
 1252936372,
 1252297130,
 -1,
 1253001906,
 1252885596,
 -1,
 1253067441,
 1252939015,
 65909,
 -1,
 1252982822,
 65910,
 -1,
 1253023844,
 65931,
 -46413,
 1252968693,
 65924,
 -1,
 1253190075,
 65916,
 1253395127,
 1252883135,
 -1,
 -46410,
 1253362686,
 119365,
 -1,
 1253394195,
 65921,
 1253591738,
 1253329336,
 -1,
 -46407,
 1253544953,
 65919,
 -1,
 1253599503,
 65920,
 -46405,
 1253563416,
 65930,
 -46404,
 1253759396,
 65913,
 -46403,
 1253824588,
 65925,
 -46402,
 1253877385,
 1020,
 -46401,
 1253928619,
 65922,
 -46400,
 1253987076,
 65928,
 -1,
 1254047092,
 65915,
 1254293503,
 1238991606,
 -1,
 -46397,
 1254207070,
 129367,
 -46396,
 1254250177,
 128154,
 -46395,
 1254304237,
 128215,
 -1,
 1254367476,
 127823,
 1254574891,
 1238898927,
 -1,
 1254640425,
 1254525060,
 -1,
 1254705931,
 1254585564,
 -1,
 1254771411,
 1254673530,
 -1,
 1254836943,
 1254722100,
 -1,
 1254902477,
 1254793473,
 70411,
 -1,
 1254859009,
 70496,
 1255079935,
 1254846151,
 70412,
 -1,
 1254977223,
 70497,
 1255164626,
 1254768858,
 -1,
 -46383,
 1255095063,
 70495,
 -1,
 1255153830,
 70494,
 -1,
 1255086319,
 70453,
 1255426777,
 1254734363,
 -1,
 1255492311,
 1255389723,
 -1,
 -46378,
 1255429176,
 70432,
 -1,
 1255479535,
 70431,
 -46376,
 1255429176,
 70437,
 -1,
 1255610607,
 70436,
 1255819998,
 1255375604,
 -1,
 -46373,
 1255790892,
 70430,
 -46372,
 1255834449,
 70435,
 -46371,
 1255886727,
 70425,
 -1,
 1255938287,
 70440,
 1256147684,
 1255749085,
 -1,
 1256213218,
 1256076765,
 -1,
 -46367,
 1256150072,
 70434,
 -1,
 1256200431,
 70433,
 -46365,
 1256150072,
 70439,
 -1,
 1256331503,
 70438,
 1256540904,
 1256069359,
 70405,
 -46362,
 1256506570,
 70420,
 -46361,
 1256545489,
 70416,
 -1,
 1256593647,
 70406,
 1256803052,
 1256500620,
 -1,
 -46358,
 1256762911,
 70455,
 -46357,
 1256805432,
 70454,
 -1,
 1256855791,
 70456,
 1257065198,
 1256768714,
 70409,
 -1,
 1257030858,
 70410,
 1257196273,
 1257019246,
 -1,
 -46352,
 1257133112,
 70443,
 -1,
 1257183471,
 70442,
 1257392884,
 1257139911,
 -1,
 -46349,
 1257336581,
 70451,
 -1,
 1257380079,
 70450,
 1257589495,
 1257335605,
 -1,
 -46346,
 1257526328,
 70422,
 -1,
 1257576687,
 70421,
 1257786106,
 1257531913,
 -1,
 -46343,
 1257722936,
 70429,
 -1,
 1257773295,
 70428,
 1257982716,
 1257725137,
 70407,
 -1,
 1257921745,
 70408,
 1258113791,
 1257918264,
 -1,
 -46338,
 1258050616,
 70424,
 -1,
 1258100975,
 70423,
 1258310402,
 1258040194,
 -1,
 -46335,
 1258247224,
 70427,
 -1,
 1258297583,
 70426,
 1258507013,
 1258235314,
 -1,
 -46332,
 1258443832,
 70445,
 -1,
 1258494191,
 70444,
 -46330,
 1258477868,
 70447,
 -46329,
 1258660219,
 70448,
 -46328,
 1258721081,
 70419,
 -46327,
 1258781461,
 70446,
 -46326,
 1258837048,
 70457,
 -1,
 1258897645,
 70415,
 1259096859,
 1254674584,
 -1,
 1259162385,
 1259065275,
 -1,
 1259227919,
 1259118849,
 70467,
 -1,
 1259184385,
 70468,
 1259405311,
 1259171527,
 70498,
 -1,
 1259302599,
 70499,
 1259490069,
 1259084015,
 -1,
 -46317,
 1259455690,
 70476,
 -46316,
 1259494609,
 70472,
 -1,
 1259542767,
 70462,
 1259752215,
 1259455690,
 70465,
 -1,
 1259717834,
 70466,
 1259883289,
 1259691217,
 70463,
 -1,
 1259822289,
 70464,
 -46310,
 1259835193,
 70475,
 -1,
 1259946221,
 70471,
 1260145447,
 1259057807,
 -1,
 1260210975,
 1260113726,
 -1,
 -46306,
 1260170966,
 70403,
 -1,
 1260233383,
 70477,
 1260407586,
 1260137346,
 -1,
 -46303,
 1260358894,
 70400,
 -1,
 1260396493,
 70401,
 1260604197,
 1260329199,
 -1,
 -46300,
 1260571795,
 70461,
 -1,
 1260620069,
 70402,
 -46298,
 1260559416,
 70493,
 -1,
 1260751062,
 70460,
 -46296,
 1260096700,
 70480,
 -1,
 1260856521,
 70487,
 -46294,
 1254595247,
 127815,
 -1,
 1260993975,
 127891,
 1261194033,
 1254513873,
 -1,
 1261259568,
 1261143777,
 -1,
 1261325103,
 1261193744,
 128512,
 -1,
 1261243794,
 128513,
 -1,
 1261251860,
 128568,
 -1,
 1261206322,
 128556,
 1261633535,
 1261144490,
 -1,
 -46285,
 1261556813,
 128151,
 -1,
 1261619613,
 983109,
 1261783993,
 1238855367,
 -1,
 1261849526,
 1261705455,
 -1,
 1261915061,
 1261785812,
 -1,
 1261980534,
 1261876302,
 -1,
 1262046017,
 1261940108,
 -1,
 1262111549,
 1261982754,
 -1,
 1262177084,
 1262074525,
 11339,
 -1,
 1262131954,
 11356,
 -1,
 1262098671,
 11342,
 1262373695,
 1262058554,
 11348,
 -1,
 1262292440,
 11349,
 -46272,
 1262328586,
 11346,
 -1,
 1262450934,
 11332,
 1262635850,
 1262016723,
 -1,
 1262701383,
 1262566972,
 -1,
 1262766918,
 1262657793,
 -1,
 -46267,
 1262732490,
 11343,
 -1,
 1262771409,
 11344,
 -1,
 1262729420,
 11317,
 -46264,
 1262666954,
 11347,
 -46263,
 1262979498,
 11350,
 -1,
 1263019093,
 11345,
 1263225682,
 1262574801,
 11323,
 1263291214,
 1263197230,
 -1,
 -46259,
 1263233211,
 11355,
 -1,
 1263287868,
 11321,
 1263487825,
 1263243913,
 -1,
 -46256,
 1263449308,
 11351,
 -1,
 1263478908,
 11353,
 -1,
 1263437473,
 11322,
 1263749974,
 1263188507,
 -1,
 -46252,
 1263718637,
 11333,
 -46251,
 1263776282,
 11340,
 -1,
 1263840097,
 11357,
 1264012122,
 1263678941,
 -1,
 -46248,
 1263983570,
 11319,
 -46247,
 1264028201,
 11316,
 -1,
 1264085652,
 11324,
 1264274269,
 1263983407,
 -1,
 -46244,
 1264212315,
 11318,
 -1,
 1264272202,
 11320,
 1264470880,
 1264228206,
 -1,
 -46241,
 1264421893,
 11330,
 -1,
 1264467516,
 11338,
 1264667491,
 1264421290,
 -1,
 -46238,
 1264632587,
 11337,
 -1,
 1264683201,
 11329,
 1264864102,
 1264611015,
 -1,
 -46235,
 1264806682,
 11326,
 -1,
 1264854111,
 11358,
 1265060713,
 1264798136,
 -1,
 -46232,
 1265019583,
 11335,
 -1,
 1265068052,
 11354,
 1265257324,
 1264985522,
 -1,
 -46229,
 1265223547,
 11313,
 -1,
 1265262428,
 11352,
 -46227,
 1265225122,
 11314,
 -46226,
 1265420146,
 11334,
 -46225,
 1265478329,
 11331,
 -46224,
 1265533880,
 11328,
 -46223,
 1265599212,
 11327,
 -46222,
 1265658846,
 11325,
 -46221,
 1265719167,
 11336,
 -46220,
 1265783432,
 11315,
 -46219,
 1265839851,
 11341,
 -1,
 1265903022,
 11312,
 1266155519,
 1261907090,
 -1,
 1266174848,
 1266068876,
 -1,
 1266240380,
 1266111522,
 -1,
 1266305915,
 1266203293,
 11291,
 -1,
 1266260722,
 11308,
 -1,
 1266227439,
 11294,
 1266502526,
 1266187322,
 11300,
 -1,
 1266421208,
 11301,
 -46209,
 1266457354,
 11298,
 -1,
 1266579702,
 11284,
 1266764681,
 1266145491,
 -1,
 1266830214,
 1266695740,
 -1,
 1266895749,
 1266786561,
 -1,
 -46204,
 1266861258,
 11295,
 -1,
 1266900177,
 11296,
 -1,
 1266858188,
 11269,
 -46201,
 1266795722,
 11299,
 -46200,
 1267108266,
 11302,
 -1,
 1267147861,
 11297,
 1267354513,
 1266703569,
 11275,
 1267420045,
 1267325998,
 -1,
 -46196,
 1267361979,
 11307,
 -1,
 1267416636,
 11273,
 1267616656,
 1267372681,
 -1,
 -46193,
 1267578076,
 11303,
 -1,
 1267607676,
 11305,
 -1,
 1267566241,
 11274,
 1267878805,
 1267317275,
 -1,
 -46189,
 1267847405,
 11285,
 -46188,
 1267905050,
 11292,
 -1,
 1267968865,
 11309,
 1268140953,
 1267807709,
 -1,
 -46185,
 1268112338,
 11271,
 -46184,
 1268156969,
 11268,
 -1,
 1268214420,
 11276,
 1268403100,
 1268112175,
 -1,
 -46181,
 1268341083,
 11270,
 -1,
 1268400970,
 11272,
 1268599711,
 1268356974,
 -1,
 -46178,
 1268550661,
 11282,
 -1,
 1268596284,
 11290,
 1268796322,
 1268550058,
 -1,
 -46175,
 1268761355,
 11289,
 -1,
 1268811969,
 11281,
 1268992933,
 1268739783,
 -1,
 -46172,
 1268935450,
 11278,
 -1,
 1268982879,
 11310,
 1269189544,
 1268926904,
 -1,
 -46169,
 1269148351,
 11287,
 -1,
 1269196820,
 11306,
 1269386155,
 1269114290,
 -1,
 -46166,
 1269352315,
 11265,
 -1,
 1269391196,
 11304,
 -46164,
 1269353890,
 11266,
 -46163,
 1269548914,
 11286,
 -46162,
 1269607097,
 11283,
 -46161,
 1269662648,
 11280,
 -46160,
 1269727980,
 11279,
 -46159,
 1269787614,
 11277,
 -46158,
 1269847935,
 11288,
 -46157,
 1269912200,
 11267,
 -46156,
 1269968619,
 11293,
 -1,
 1270031790,
 11264,
 -1,
 1261876854,
 129371,
 1270349823,
 1261799850,
 -1,
 -46152,
 1270273112,
 127775,
 -1,
 1270294342,
 127760,
 1270500352,
 1261715004,
 -1,
 1270565883,
 1270452591,
 -1,
 1270631408,
 1270527054,
 -1,
 1270696899,
 1270567970,
 -1,
 1270762432,
 1270618351,
 -1,
 -46145,
 1270718721,
 11556,
 -1,
 1270758972,
 11552,
 -46143,
 1270713045,
 11557,
 -46142,
 1270898418,
 11554,
 -1,
 1270955580,
 11553,
 1271155657,
 1270623106,
 -1,
 1271221191,
 1271092258,
 -1,
 -46138,
 1271161218,
 11545,
 -1,
 1271210270,
 11549,
 -46136,
 1271161013,
 11548,
 -1,
 1271340829,
 11546,
 1271548876,
 1271126831,
 -1,
 -46133,
 1271485961,
 11535,
 -1,
 1271546724,
 11526,
 1271745487,
 1271511709,
 -1,
 -46130,
 1271701761,
 11538,
 -1,
 1271759604,
 11527,
 1271942098,
 1271704972,
 -1,
 -46127,
 1271879885,
 11544,
 -1,
 1271930653,
 11537,
 1272138709,
 1271895918,
 -1,
 -46124,
 1272075785,
 11540,
 -1,
 1272127774,
 11534,
 1272335320,
 1272081205,
 -1,
 -46121,
 1272272393,
 11541,
 -1,
 1272323869,
 11529,
 1272531931,
 1272277513,
 -1,
 -46118,
 1272471733,
 11547,
 -1,
 1272534345,
 11551,
 1272728542,
 1272467256,
 -1,
 -46115,
 1272665417,
 11542,
 -1,
 1272717085,
 11522,
 1272925153,
 1272649967,
 -1,
 -46112,
 1272873716,
 11520,
 -1,
 1272922980,
 11565,
 -46110,
 1272896156,
 11559,
 -46109,
 1273092117,
 11550,
 -46108,
 1273156206,
 11555,
 -46107,
 1273220964,
 11525,
 -46106,
 1273284649,
 11539,
 -46105,
 1273340334,
 11536,
 -46104,
 1273405334,
 11543,
 -46103,
 1273466162,
 11533,
 -46102,
 1273529237,
 11532,
 -46101,
 1273592899,
 11531,
 -46100,
 1273655447,
 11530,
 -46099,
 1273717122,
 11528,
 -46098,
 1273774948,
 11524,
 -46097,
 1273838058,
 11523,
 -1,
 1273898589,
 11521,
 1274104824,
 1270576348,
 -1,
 1274170356,
 1274026223,
 -1,
 -46093,
 1274110338,
 4346,
 -1,
 1274168164,
 4349,
 -46091,
 1274135860,
 983924,
 -46090,
 1274332049,
 4345,
 -46089,
 1274375977,
 4351,
 -1,
 1274435121,
 4350,
 1274675199,
 1274031250,
 -1,
 -46086,
 1274600092,
 4295,
 -1,
 1274616725,
 4301,
 1274825727,
 1270489374,
 9881,
 1274937343,
 1274743548,
 -1,
 -46082,
 1274844304,
 9965,
 -1,
 1274872638,
 9966,
 -1,
 1274772225,
 128142,
 1275153427,
 1270465738,
 -1,
 1275218954,
 1275095625,
 -1,
 1275284486,
 1275163868,
 -1,
 1275350021,
 1275252676,
 2700,
 -1,
 1275293383,
 2785,
 -1,
 1275321416,
 2809,
 1275546632,
 1275252934,
 2786,
 -1,
 1275489991,
 2787,
 -46071,
 1275506008,
 2801,
 -1,
 1275599370,
 2800,
 1275808783,
 1275177733,
 -1,
 -46068,
 1275779434,
 2677,
 -46067,
 1275842430,
 2563,
 -46066,
 1275905742,
 2641,
 -1,
 1275927361,
 2561,
 1276136466,
 1275732254,
 -1,
 -46063,
 1276067238,
 128130,
 -1,
 1276125260,
 8370,
 -1,
 1276078168,
 127928,
 1276398617,
 1275103658,
 -1,
 1276464151,
 1276319983,
 -1,
 -46058,
 1276426779,
 128016,
 -1,
 1276473043,
 129349,
 -46056,
 1276422459,
 129421,
 -1,
 1276605843,
 127948,
 1276791835,
 1276340002,
 128103,
 -1,
 1276751371,
 128714,
 -46052,
 1276751244,
 983110,
 -46051,
 1276861141,
 128123,
 -1,
 1276911333,
 127922,
 1277120115,
 1238788917,
 -1,
 1277185456,
 1277056034,
 -1,
 1277250725,
 1277132501,
 -1,
 1277316203,
 1277209996,
 -1,
 1277381738,
 1277287025,
 -1,
 1277447226,
 1277335406,
 -1,
 1277512758,
 1277403797,
 -1,
 1277578291,
 1277431330,
 -1,
 1277643821,
 1277502898,
 -1,
 1277709354,
 1277610256,
 -1,
 -46039,
 1277668147,
 6649,
 -1,
 1277718004,
 6633,
 1277951999,
 1277641261,
 -1,
 -46036,
 1277864755,
 6648,
 -1,
 1277914612,
 6632,
 1278102576,
 1277598512,
 -1,
 -46033,
 1278061363,
 6647,
 -1,
 1278111220,
 6631,
 1278345215,
 1278050971,
 -1,
 -46030,
 1278257971,
 6646,
 -1,
 1278307828,
 6630,
 1278541823,
 1277493248,
 -1,
 -46027,
 1278454579,
 6645,
 -1,
 1278504436,
 6629,
 1278692409,
 1277452451,
 -1,
 -46024,
 1278651187,
 6642,
 -1,
 1278701044,
 6626,
 -1,
 1278616591,
 6624,
 1278954576,
 1277376245,
 -1,
 1279020109,
 1278873122,
 -1,
 1279085635,
 1278973806,
 -1,
 1279151168,
 1279042201,
 -1,
 -46017,
 1279109939,
 6655,
 -1,
 1279159796,
 6639,
 1279393791,
 1279090851,
 -1,
 -46014,
 1279306547,
 6652,
 -1,
 1279356404,
 6636,
 1279544394,
 1279010226,
 -1,
 1279609927,
 1279510800,
 -1,
 -46010,
 1279568691,
 6654,
 -1,
 1279618548,
 6638,
 1279852543,
 1279541805,
 -1,
 -46007,
 1279765299,
 6653,
 -1,
 1279815156,
 6637,
 1280049151,
 1279492763,
 -1,
 -46004,
 1279961907,
 6651,
 -1,
 1280011764,
 6635,
 1280245759,
 1278935040,
 -1,
 -46001,
 1280158515,
 6650,
 -1,
 1280208372,
 6634,
 1280396383,
 1278899325,
 -1,
 1280461914,
 1280350062,
 -1,
 1280527449,
 1280418453,
 6133,
 1280638975,
 1280445986,
 -1,
 1280658519,
 1280517554,
 -1,
 -45994,
 1280624908,
 6137,
 -1,
 1280655914,
 6136,
 -45992,
 1280613164,
 6135,
 -1,
 1280803478,
 6134,
 -1,
 1280467104,
 6130,
 1281051741,
 1280386482,
 -1,
 -45988,
 1281018124,
 6132,
 -1,
 1281049130,
 6131,
 -45986,
 1281013091,
 6128,
 -1,
 1281196694,
 6129,
 1281379430,
 1280320946,
 -1,
 1281444963,
 1281345808,
 -1,
 -45982,
 1281403699,
 6644,
 -1,
 1281453556,
 6628,
 1281687551,
 1281376813,
 -1,
 -45979,
 1281600307,
 6643,
 -1,
 1281650164,
 6627,
 1281838185,
 1281327771,
 -1,
 -45976,
 1281796915,
 6641,
 -1,
 1281846772,
 6625,
 -1,
 1281803218,
 6640,
 -1,
 1277321330,
 6109,
 1282165915,
 1277244004,
 -1,
 1282231413,
 1282128411,
 -1,
 1282296944,
 1282194641,
 -1,
 -45969,
 1282247082,
 983938,
 -1,
 1282283759,
 983936,
 1282493555,
 1282233378,
 -1,
 -45966,
 1282443690,
 983943,
 -1,
 1282480367,
 983941,
 -45964,
 1282443690,
 983942,
 -1,
 1282611439,
 983940,
 1282821242,
 1282179828,
 -1,
 -45961,
 1282792103,
 983934,
 -45960,
 1282836906,
 983944,
 -45959,
 1282888380,
 983929,
 -1,
 1282939119,
 983939,
 1283148928,
 1282763573,
 -1,
 1283214462,
 1283085346,
 -1,
 -45955,
 1283164586,
 983928,
 -1,
 1283201263,
 983926,
 -45953,
 1283164586,
 983927,
 -1,
 1283332335,
 983925,
 1283542150,
 1283074946,
 -1,
 1283607684,
 1283478562,
 -1,
 -45949,
 1283557802,
 983933,
 -1,
 1283594479,
 983931,
 -45947,
 1283557802,
 983932,
 -1,
 1283725551,
 983930,
 1283935370,
 1283501452,
 -1,
 -45944,
 1283894815,
 983955,
 -45943,
 1283937336,
 983954,
 -1,
 1283987695,
 983956,
 1284197519,
 1283889006,
 -1,
 1284263054,
 1284133922,
 -1,
 -45939,
 1284213162,
 983948,
 -1,
 1284249839,
 983946,
 -1,
 1284213162,
 983947,
 1284525202,
 1284140743,
 -1,
 -45935,
 1284475306,
 983952,
 -1,
 1284511983,
 983958,
 1284721813,
 1284453853,
 -1,
 -45932,
 1284671914,
 983937,
 -1,
 1284708591,
 983935,
 -45930,
 1284692647,
 983950,
 -45929,
 1284886433,
 983953,
 -45928,
 1284942616,
 983951,
 -45927,
 1284997378,
 983949,
 -45926,
 1285051448,
 983957,
 -1,
 1285105127,
 983945,
 1285311649,
 1282105820,
 -1,
 1285377182,
 1285270883,
 983961,
 -1,
 1285347539,
 983962,
 1285554175,
 1285332811,
 -1,
 -45920,
 1285473482,
 983960,
 -1,
 1285504572,
 983963,
 1285750783,
 1285279896,
 -1,
 -45917,
 1285655740,
 983964,
 -45916,
 1285697860,
 983959,
 -1,
 1285757353,
 983965,
 1285967104,
 1277216475,
 -1,
 1286032611,
 1285911772,
 -1,
 1286098094,
 1285961181,
 -1,
 1286163628,
 1286026717,
 -1,
 -45910,
 1286100024,
 70347,
 -45909,
 1286157931,
 70345,
 -1,
 1286215919,
 70344,
 -45907,
 1286100024,
 70352,
 -1,
 1286346991,
 70351,
 1286556852,
 1286060571,
 -1,
 1286622386,
 1286519323,
 -1,
 -45903,
 1286558776,
 70343,
 -1,
 1286609135,
 70342,
 -45901,
 1286558776,
 70350,
 -1,
 1286740207,
 70349,
 1286950073,
 1286505204,
 -1,
 -45898,
 1286920492,
 70341,
 -45897,
 1286964049,
 70348,
 -45896,
 1287016327,
 70335,
 -1,
 1287067887,
 70353,
 1287277757,
 1286871279,
 70320,
 -45893,
 1287242954,
 70329,
 -45892,
 1287281873,
 70327,
 -1,
 1287330031,
 70321,
 1287539905,
 1287219721,
 -1,
 -45889,
 1287481895,
 70339,
 -45888,
 1287541816,
 70340,
 -1,
 1287592175,
 70338,
 1287802053,
 1287475000,
 -1,
 -45885,
 1287738424,
 70334,
 -45884,
 1287802759,
 70333,
 -1,
 1287854319,
 70332,
 1288064201,
 1287726514,
 -1,
 -45881,
 1288000568,
 70358,
 -45880,
 1288054247,
 70357,
 -1,
 1288116463,
 70356,
 1288326347,
 1288029386,
 70324,
 -1,
 1288291530,
 70325,
 1288457422,
 1288285580,
 -1,
 -45875,
 1288393784,
 70364,
 -1,
 1288444143,
 70365,
 1288654033,
 1288413441,
 -1,
 -45872,
 1288610171,
 70346,
 -1,
 1288640751,
 70361,
 1288850644,
 1288607598,
 -1,
 -45869,
 1288787000,
 70355,
 -1,
 1288837359,
 70354,
 1289047255,
 1288792885,
 -1,
 -45866,
 1288983608,
 70331,
 -1,
 1289033967,
 70330,
 1289243865,
 1288985809,
 70322,
 -1,
 1289182417,
 70323,
 1289374940,
 1289169794,
 -1,
 -45861,
 1289311288,
 70337,
 -1,
 1289361647,
 70336,
 -45859,
 1289345324,
 70360,
 -45858,
 1289538704,
 70363,
 -45857,
 1289587114,
 70328,
 -45856,
 1289648917,
 70359,
 -45855,
 1289711365,
 70362,
 -45854,
 1289770040,
 70366,
 -1,
 1289829948,
 70326,
 1290030321,
 1285961948,
 -1,
 1290095847,
 1289992731,
 -1,
 -45850,
 1290065418,
 70386,
 -1,
 1290099520,
 70387,
 1290292458,
 1290055052,
 -1,
 -45847,
 1290234243,
 70390,
 -1,
 1290291167,
 70391,
 1290489069,
 1290226104,
 -1,
 -45844,
 1290441668,
 70388,
 -1,
 1290496209,
 70389,
 -45842,
 1290460145,
 70384,
 -45841,
 1290636724,
 70385,
 -45840,
 1290700336,
 70393,
 -1,
 1290748469,
 70392,
 1290947836,
 1289998488,
 -1,
 1291013366,
 1290868975,
 -1,
 -45836,
 1290978506,
 70376,
 -45835,
 1291017425,
 70374,
 -1,
 1291065583,
 70368,
 1291275512,
 1290978506,
 70371,
 -1,
 1291240650,
 70372,
 1291406586,
 1291214033,
 70369,
 -1,
 1291345105,
 70370,
 -45829,
 1291356586,
 70375,
 -1,
 1291468348,
 70373,
 1291714559,
 1290908303,
 -1,
 -45826,
 1291636599,
 70378,
 -45825,
 1291684054,
 70377,
 -1,
 1291722918,
 70367,
 1291930973,
 1285890627,
 -1,
 1291996464,
 1291875548,
 -1,
 1292061961,
 1291958811,
 -1,
 1292127495,
 1292024347,
 -1,
 -45819,
 1292090597,
 68147,
 -45818,
 1292129336,
 68123,
 -1,
 1292179695,
 68122,
 -45816,
 1292063800,
 68128,
 -1,
 1292310767,
 68127,
 1292520719,
 1291990493,
 -1,
 1292586253,
 1292449245,
 -1,
 -45812,
 1292522552,
 68125,
 -1,
 1292572911,
 68124,
 -45810,
 1292522552,
 68130,
 -1,
 1292703983,
 68129,
 1292913939,
 1292479884,
 -1,
 -45807,
 1292873247,
 68142,
 -45806,
 1292915768,
 68141,
 -1,
 1292966127,
 68143,
 1293176087,
 1292862196,
 -1,
 -45803,
 1293146412,
 68121,
 -45802,
 1293189969,
 68126,
 -1,
 1293228271,
 68131,
 1293438235,
 1293118261,
 -1,
 -45799,
 1293380487,
 68146,
 -45798,
 1293440056,
 68113,
 -1,
 1293490415,
 68112,
 1293700382,
 1293391726,
 -1,
 -45795,
 1293636664,
 68133,
 -1,
 1293687023,
 68132,
 1293896993,
 1293635384,
 -1,
 -45792,
 1293833272,
 68115,
 -1,
 1293883631,
 68114,
 1294093604,
 1293822850,
 -1,
 -45789,
 1294029880,
 68118,
 -1,
 1294080239,
 68117,
 1294290215,
 1294017970,
 -1,
 -45786,
 1294226488,
 68135,
 -1,
 1294276847,
 68134,
 -45784,
 1294261055,
 68144,
 -45783,
 1294457132,
 68137,
 -45782,
 1294519440,
 68140,
 -45781,
 1294573947,
 68138,
 -45780,
 1294629653,
 68136,
 -45779,
 1294692101,
 68139,
 -45778,
 1294756391,
 68119,
 -45777,
 1294816312,
 68145,
 -1,
 1294866671,
 68096,
 1295076670,
 1291951807,
 -1,
 1295142198,
 1295005149,
 -1,
 1295207733,
 1295092138,
 -1,
 -45772,
 1295173110,
 68183,
 -1,
 1295235611,
 68176,
 -1,
 1295130541,
 68182,
 1295469881,
 1295085255,
 -1,
 -45768,
 1295422270,
 68181,
 -1,
 1295475387,
 68184,
 1295666492,
 1295395714,
 -1,
 -45765,
 1295623615,
 68179,
 -1,
 1295673011,
 68178,
 -45763,
 1295627302,
 68177,
 -1,
 1295809647,
 68180,
 1295994184,
 1295043706,
 -1,
 1296059719,
 1295947496,
 -1,
 1296125254,
 1296020111,
 -1,
 -45758,
 1296093134,
 68099,
 -45757,
 1296155850,
 68098,
 -45756,
 1296206250,
 68102,
 -45755,
 1296260305,
 68097,
 -1,
 1296318012,
 68101,
 -1,
 1296069779,
 68108,
 -1,
 1296000685,
 68159,
 1296649552,
 1295954575,
 -1,
 1296715084,
 1296578989,
 -1,
 -45749,
 1296680502,
 68109,
 -1,
 1296742963,
 68154,
 -45747,
 1296682878,
 68111,
 -45746,
 1296837935,
 68153,
 -45745,
 1296901750,
 68152,
 -1,
 1296965798,
 68110,
 1297173847,
 1296599264,
 -1,
 1297239380,
 1297136155,
 -1,
 -45741,
 1297207967,
 68165,
 -1,
 1297236836,
 68164,
 1297481727,
 1297190328,
 -1,
 -45738,
 1297399189,
 68167,
 -1,
 1297439831,
 68166,
 1297678335,
 1297103068,
 -1,
 1297698139,
 1297594907,
 -1,
 -45734,
 1297667594,
 68161,
 -1,
 1297701696,
 68162,
 -45732,
 1297649076,
 68160,
 -1,
 1297829248,
 68163,
 1298071551,
 1291881399,
 -1,
 1298091414,
 1297970396,
 -1,
 1298156902,
 1298019805,
 -1,
 1298222436,
 1298085341,
 -1,
 -45726,
 1298158648,
 70167,
 -45725,
 1298216555,
 70172,
 -1,
 1298274543,
 70166,
 -45723,
 1298158648,
 70173,
 -1,
 1298405615,
 70171,
 1298615660,
 1298119195,
 -1,
 1298681194,
 1298577947,
 -1,
 -45719,
 1298617400,
 70165,
 -1,
 1298667759,
 70164,
 -45717,
 1298617400,
 70170,
 -1,
 1298798831,
 70169,
 1299008881,
 1298563828,
 -1,
 -45714,
 1298979116,
 70163,
 -45713,
 1299022673,
 70168,
 -45712,
 1299074951,
 70157,
 -1,
 1299126511,
 70174,
 1299336565,
 1298929903,
 70144,
 -45709,
 1299301578,
 70151,
 -45708,
 1299340497,
 70149,
 -1,
 1299388655,
 70145,
 1299598713,
 1299271480,
 -1,
 -45705,
 1299534904,
 70156,
 -45704,
 1299599239,
 70155,
 -1,
 1299650799,
 70154,
 1299860861,
 1299522994,
 -1,
 -45701,
 1299797048,
 70179,
 -45700,
 1299850727,
 70178,
 -1,
 1299912943,
 70177,
 1300123008,
 1299814254,
 -1,
 -45697,
 1300059192,
 70176,
 -1,
 1300109551,
 70175,
 1300319619,
 1300065991,
 -1,
 -45694,
 1300262661,
 70187,
 -1,
 1300306159,
 70183,
 1300516230,
 1300261685,
 -1,
 -45691,
 1300452408,
 70153,
 -1,
 1300502767,
 70152,
 1300712841,
 1300457993,
 -1,
 -45688,
 1300654631,
 70161,
 -1,
 1300699375,
 70160,
 1300909452,
 1300638594,
 -1,
 -45685,
 1300845624,
 70159,
 -1,
 1300895983,
 70158,
 -45683,
 1300879660,
 70181,
 -45682,
 1301073040,
 70184,
 -45681,
 1301136586,
 70147,
 -45680,
 1301196319,
 70185,
 -45679,
 1301258619,
 70182,
 -45678,
 1301318058,
 70150,
 -45677,
 1301379861,
 70180,
 -45676,
 1301437649,
 70146,
 -45675,
 1301500984,
 70186,
 -1,
 1301560892,
 70148,
 1301761440,
 1298059416,
 -1,
 1301826971,
 1301682415,
 -1,
 -45671,
 1301791946,
 70195,
 -45670,
 1301830865,
 70193,
 -1,
 1301879023,
 70188,
 1302089117,
 1301765329,
 70189,
 -1,
 1302027473,
 70190,
 -45666,
 1302054090,
 70191,
 -45665,
 1302170026,
 70194,
 -1,
 1302216252,
 70192,
 1302416809,
 1301720460,
 -1,
 1302482344,
 1302356077,
 -1,
 1302547877,
 1302441356,
 -1,
 -45660,
 1302513526,
 70206,
 -1,
 1302549597,
 70199,
 -45658,
 1302515575,
 70197,
 -45657,
 1302694102,
 70198,
 -1,
 1302732966,
 70196,
 -1,
 1302413411,
 70203,
 1303006638,
 1302345181,
 -1,
 1303072173,
 1302958918,
 -1,
 -45652,
 1303031645,
 70204,
 -1,
 1303066343,
 70201,
 -1,
 1302994861,
 70200,
 -45649,
 1302976354,
 70202,
 -1,
 1303255562,
 70205,
 1303465572,
 1277106415,
 -1,
 1303531017,
 1303406737,
 -1,
 1303596525,
 1303475420,
 -1,
 1303662010,
 1303524829,
 -1,
 1303727544,
 1303590365,
 -1,
 -45642,
 1303663672,
 69787,
 -45641,
 1303722022,
 69786,
 -1,
 1303779567,
 69785,
 -45639,
 1303663672,
 69793,
 -1,
 1303910639,
 69792,
 1304120768,
 1303624219,
 -1,
 1304186302,
 1304082971,
 -1,
 -45635,
 1304122424,
 69784,
 -1,
 1304172783,
 69783,
 -45633,
 1304122424,
 69791,
 -1,
 1304303855,
 69790,
 1304513989,
 1304068852,
 -1,
 -45630,
 1304484140,
 69782,
 -45629,
 1304527697,
 69789,
 -45628,
 1304579975,
 69777,
 -1,
 1304631535,
 69794,
 1304841673,
 1304434927,
 69763,
 -45625,
 1304806602,
 69772,
 -45624,
 1304845521,
 69770,
 -1,
 1304893679,
 69764,
 1305103821,
 1304800652,
 -1,
 -45621,
 1305062943,
 69805,
 -45620,
 1305105464,
 69804,
 -1,
 1305155823,
 69806,
 1305365967,
 1305068746,
 69767,
 -1,
 1305330890,
 69768,
 1305497042,
 1305321729,
 -1,
 -45615,
 1305433144,
 69788,
 -1,
 1305483503,
 69801,
 1305693653,
 1305450350,
 -1,
 -45612,
 1305629752,
 69796,
 -1,
 1305680111,
 69795,
 1305890264,
 1305635637,
 -1,
 -45609,
 1305826360,
 69774,
 -1,
 1305876719,
 69773,
 1306086875,
 1305831945,
 -1,
 -45606,
 1306022968,
 69781,
 -1,
 1306073327,
 69780,
 1306283485,
 1306025169,
 69765,
 -1,
 1306221777,
 69766,
 1306414560,
 1306218296,
 -1,
 -45601,
 1306350648,
 69776,
 -1,
 1306401007,
 69775,
 1306611171,
 1306340226,
 -1,
 -45598,
 1306547256,
 69779,
 -1,
 1306597615,
 69778,
 1306807782,
 1306535346,
 -1,
 -45595,
 1306743864,
 69798,
 -1,
 1306794223,
 69797,
 -45593,
 1306777900,
 69800,
 -45592,
 1306971280,
 69803,
 -45591,
 1307019690,
 69771,
 -45590,
 1307081493,
 69799,
 -45589,
 1307143941,
 69802,
 -45588,
 1307202616,
 69807,
 -1,
 1307262524,
 69769,
 1307463160,
 1303564440,
 -1,
 1307528690,
 1307384047,
 -1,
 -45584,
 1307493578,
 69816,
 -45583,
 1307532497,
 69814,
 -1,
 1307580655,
 69808,
 1307790836,
 1307493578,
 69811,
 -1,
 1307755722,
 69812,
 1307921910,
 1307729105,
 69809,
 -1,
 1307860177,
 69810,
 -45577,
 1307871658,
 69815,
 -1,
 1307983420,
 69813,
 1308184065,
 1307422092,
 -1,
 1308249600,
 1308123245,
 -1,
 1308315133,
 1308217150,
 -1,
 -45572,
 1308274390,
 69762,
 -1,
 1308336807,
 69817,
 -45570,
 1308264662,
 69818,
 -45569,
 1308437577,
 69760,
 -1,
 1308500134,
 69761,
 -1,
 1308180579,
 69822,
 1308773894,
 1308112349,
 -1,
 1308839429,
 1308726086,
 -1,
 -45564,
 1308798813,
 69823,
 -1,
 1308833511,
 69825,
 -1,
 1308762029,
 69824,
 -45561,
 1308723432,
 69821,
 -45560,
 1309033712,
 69820,
 -1,
 1309088266,
 69819,
 1309298249,
 1303501111,
 -1,
 1309363758,
 1309242588,
 -1,
 1309429263,
 1309311732,
 -1,
 -45555,
 1309399340,
 43281,
 -45554,
 1309429639,
 43277,
 -1,
 1309481199,
 43284,
 1309691410,
 1309391387,
 -1,
 -45551,
 1309627448,
 43294,
 -1,
 1309677807,
 43282,
 1309888021,
 1309650316,
 -1,
 -45548,
 1309824056,
 43279,
 -1,
 1309874415,
 43278,
 1310084632,
 1309841262,
 -1,
 -45545,
 1310020664,
 43286,
 -1,
 1310071023,
 43285,
 1310281243,
 1310034346,
 -1,
 -45542,
 1310230954,
 43301,
 -1,
 1310277180,
 43299,
 1310477854,
 1310223157,
 -1,
 -45539,
 1310413880,
 43275,
 -1,
 1310464239,
 43274,
 1310674465,
 1310413858,
 -1,
 -45536,
 1310636701,
 43283,
 -1,
 1310660847,
 43295,
 -45534,
 1310645055,
 43280,
 -45533,
 1310841132,
 43291,
 -45532,
 1310904652,
 43293,
 -45531,
 1310968976,
 43296,
 -45530,
 1311023483,
 43290,
 -45529,
 1311079189,
 43287,
 -45528,
 1311141637,
 43292,
 -45527,
 1311202513,
 43300,
 -45526,
 1311264647,
 43276,
 -45525,
 1311323755,
 43288,
 -45524,
 1311386544,
 43297,
 -45523,
 1311450599,
 43289,
 -1,
 1311512815,
 43298,
 1311723068,
 1309292764,
 -1,
 1311788594,
 1311685147,
 -1,
 -45519,
 1311757834,
 43266,
 -1,
 1311791936,
 43267,
 1311985205,
 1311747468,
 -1,
 -45516,
 1311926659,
 43270,
 -1,
 1311983583,
 43271,
 1312181816,
 1311918520,
 -1,
 -45513,
 1312134084,
 43268,
 -1,
 1312188625,
 43269,
 -45511,
 1312152561,
 43264,
 -45510,
 1312329140,
 43265,
 -45509,
 1312392752,
 43273,
 -1,
 1312440885,
 43272,
 1312640578,
 1311690838,
 -1,
 1312706111,
 1312605386,
 43304,
 -1,
 1312636476,
 43302,
 1312837185,
 1312636476,
 43303,
 -1,
 1312767548,
 43305,
 -1,
 1312786858,
 43306,
 1313033798,
 1312604240,
 -1,
 1313099333,
 1312959490,
 43308,
 -1,
 1313015491,
 43309,
 -1,
 1313053650,
 43307,
 1313341439,
 1312993935,
 -1,
 -45496,
 1313255957,
 43311,
 -1,
 1313289669,
 43310,
 1313492568,
 1309260568,
 -1,
 1313558096,
 1313417319,
 -1,
 -45492,
 1313522890,
 983973,
 -45491,
 1313573290,
 983975,
 -45490,
 1313627345,
 983972,
 -45489,
 1313685052,
 983974,
 -1,
 1313741039,
 983971,
 1313996799,
 1313478895,
 -1,
 1314016855,
 1313891653,
 -1,
 1314082389,
 1313978907,
 -1,
 -45484,
 1314047178,
 983977,
 -1,
 1314097578,
 983978,
 -45482,
 1314035566,
 983979,
 -1,
 1314205017,
 983976,
 -1,
 1313973123,
 110592,
 1314475619,
 1313441494,
 -1,
 1314541152,
 1314435727,
 -1,
 -45477,
 1314507239,
 3314,
 -45476,
 1314567576,
 3200,
 -45475,
 1314621654,
 3260,
 -45474,
 1314679466,
 3313,
 -45473,
 1314729033,
 3201,
 -1,
 1314792734,
 3261,
 1314999906,
 1314508998,
 3298,
 -1,
 1314942663,
 3299,
 -1,
 1314944238,
 983203,
 -1,
 1314396630,
 128331,
 1315262063,
 1303403729,
 -1,
 1315327597,
 1315223155,
 128143,
 1315393132,
 1315267292,
 -1,
 1315458667,
 1315326480,
 128535,
 1315569663,
 1315375874,
 -1,
 -45462,
 1315484908,
 128537,
 -1,
 1315516624,
 128538,
 -1,
 1315384570,
 128573,
 -1,
 1315308663,
 128139,
 -45458,
 1315296286,
 129373,
 -1,
 1315799390,
 128088,
 1315982962,
 1315195313,
 128273,
 -45455,
 1315908711,
 128287,
 -1,
 1315973520,
 128422,
 -1,
 1315932646,
 128040,
 1316245647,
 1277048285,
 -1,
 1316310845,
 1316194730,
 -1,
 1316376300,
 1316257913,
 -1,
 1316441777,
 1316343358,
 -1,
 1316507312,
 1316359716,
 -1,
 1316572800,
 1316427412,
 -1,
 -45446,
 1316492764,
 127123,
 -45445,
 1316558055,
 127122,
 -45444,
 1316623379,
 127121,
 -45443,
 1316688629,
 127120,
 -45442,
 1316753872,
 127119,
 -45441,
 1316819109,
 127118,
 -1,
 1316884376,
 127117,
 1317097096,
 1316492721,
 -1,
 -45438,
 1317017052,
 127116,
 -45437,
 1317082343,
 127115,
 -45436,
 1317147667,
 127114,
 -45435,
 1317212917,
 127113,
 -45434,
 1317278160,
 127112,
 -45433,
 1317343397,
 127111,
 -1,
 1317408664,
 127110,
 1317621392,
 1317016776,
 -1,
 -45430,
 1317541340,
 127109,
 -45429,
 1317606631,
 127108,
 -45428,
 1317671955,
 127107,
 -45427,
 1317737205,
 127106,
 -45426,
 1317802448,
 127105,
 -45425,
 1317867685,
 127104,
 -1,
 1317932952,
 127103,
 1318145688,
 1317540838,
 -1,
 -45422,
 1318065628,
 127102,
 -45421,
 1318130919,
 127101,
 -45420,
 1318196243,
 127100,
 -45419,
 1318261493,
 127099,
 -45418,
 1318326736,
 127098,
 -45417,
 1318391973,
 127097,
 -1,
 1318457240,
 127096,
 1318669984,
 1318064827,
 -1,
 -45414,
 1318589916,
 127095,
 -45413,
 1318655207,
 127094,
 -45412,
 1318720531,
 127093,
 -45411,
 1318785781,
 127092,
 -45410,
 1318851024,
 127091,
 -45409,
 1318916261,
 127090,
 -1,
 1318981528,
 127089,
 1319194280,
 1318588829,
 -1,
 -45406,
 1319114204,
 127088,
 -45405,
 1319179495,
 127087,
 -45404,
 1319244819,
 127086,
 -45403,
 1319310069,
 127085,
 -45402,
 1319375312,
 127084,
 -45401,
 1319440549,
 127083,
 -1,
 1319505816,
 127082,
 1319763967,
 1319112827,
 -1,
 -45398,
 1319638492,
 127081,
 -45397,
 1319703783,
 127080,
 -45396,
 1319769107,
 127079,
 -45395,
 1319834357,
 127078,
 -45394,
 1319899600,
 127077,
 -45393,
 1319964837,
 127076,
 -1,
 1320030104,
 127075,
 -1,
 1316421972,
 127074,
 1320353791,
 1316379202,
 -1,
 1320373995,
 1320226340,
 -1,
 1320439483,
 1320294036,
 -1,
 -45387,
 1320359388,
 127073,
 -45386,
 1320424679,
 127072,
 -45385,
 1320490003,
 127071,
 -45384,
 1320555253,
 127070,
 -45383,
 1320620496,
 127069,
 -45382,
 1320685733,
 127068,
 -1,
 1320751000,
 127067,
 1320963779,
 1320359345,
 -1,
 -45379,
 1320883676,
 127066,
 -45378,
 1320948967,
 127065,
 -45377,
 1321014291,
 127064,
 -45376,
 1321079541,
 127063,
 -45375,
 1321144784,
 127062,
 -45374,
 1321210021,
 127061,
 -1,
 1321275288,
 127060,
 1321488075,
 1320883400,
 -1,
 -45371,
 1321407964,
 127059,
 -45370,
 1321473255,
 127058,
 -45369,
 1321538579,
 127057,
 -45368,
 1321603829,
 127056,
 -45367,
 1321669072,
 127055,
 -45366,
 1321734309,
 127054,
 -1,
 1321799576,
 127053,
 1322012371,
 1321407462,
 -1,
 -45363,
 1321932252,
 127052,
 -45362,
 1321997543,
 127051,
 -45361,
 1322062867,
 127050,
 -45360,
 1322128117,
 127049,
 -45359,
 1322193360,
 127048,
 -45358,
 1322258597,
 127047,
 -1,
 1322323864,
 127046,
 1322536667,
 1321931451,
 -1,
 -45355,
 1322456540,
 127045,
 -45354,
 1322521831,
 127044,
 -45353,
 1322587155,
 127043,
 -45352,
 1322652405,
 127042,
 -45351,
 1322717648,
 127041,
 -45350,
 1322782885,
 127040,
 -1,
 1322848152,
 127039,
 1323060963,
 1322455453,
 -1,
 -45347,
 1322980828,
 127038,
 -45346,
 1323046119,
 127037,
 -45345,
 1323111443,
 127036,
 -45344,
 1323176693,
 127035,
 -45343,
 1323241936,
 127034,
 -45342,
 1323307173,
 127033,
 -1,
 1323372440,
 127032,
 1323630591,
 1322979451,
 -1,
 -45339,
 1323505116,
 127031,
 -45338,
 1323570407,
 127030,
 -45337,
 1323635731,
 127029,
 -45336,
 1323700981,
 127028,
 -45335,
 1323766224,
 127027,
 -45334,
 1323831461,
 127026,
 -1,
 1323896728,
 127025,
 -1,
 1320288596,
 127024,
 1324175134,
 1316345269,
 -1,
 1324240667,
 1324143015,
 -1,
 1324306180,
 1324202523,
 -1,
 1324371715,
 1324263101,
 -1,
 1324437250,
 1324289674,
 -1,
 1324502783,
 1324360315,
 11107,
 1324613631,
 1324417024,
 -1,
 1324633853,
 1324536964,
 -1,
 1324699383,
 1324578959,
 -1,
 -45322,
 1324656832,
 11169,
 -1,
 1324708788,
 11168,
 -45320,
 1324666594,
 129075,
 -45319,
 1324843929,
 129059,
 -45318,
 1324908055,
 129063,
 -45317,
 1324963576,
 129071,
 -45316,
 1325022143,
 11133,
 -1,
 1325083099,
 129067,
 -45314,
 1324597267,
 11123,
 -1,
 1325233205,
 11139,
 -45312,
 1324473451,
 11085,
 -45311,
 1325373478,
 11143,
 -1,
 1325414153,
 11117,
 -1,
 1324351789,
 129171,
 -1,
 1324340957,
 11247,
 1325747982,
 1324226799,
 -1,
 1325813517,
 1325706364,
 -1,
 1325879049,
 1325773776,
 -1,
 -45304,
 1325842840,
 129027,
 -1,
 1325876588,
 129043,
 -45302,
 1325827973,
 129179,
 -45301,
 1326022194,
 129031,
 -45300,
 1326084199,
 129035,
 -1,
 1326138732,
 129047,
 -1,
 1325761508,
 11796,
 1326403345,
 1325706636,
 -1,
 -45296,
 1326358565,
 129083,
 -1,
 1326391395,
 129107,
 1326599956,
 1326339808,
 -1,
 -45293,
 1326526978,
 129091,
 -1,
 1326588539,
 129095,
 1326796567,
 1326524644,
 -1,
 -45290,
 1326723005,
 11147,
 -1,
 1326785147,
 11015,
 -45288,
 1326764864,
 129175,
 -45287,
 1326951223,
 128623,
 -45286,
 1326992267,
 129079,
 -1,
 1327051266,
 129087,
 1327300607,
 1324158728,
 -1,
 -45283,
 1327215754,
 128317,
 -1,
 1327277272,
 128315,
 1327451948,
 1324139722,
 -1,
 1327517483,
 1327376666,
 -1,
 1327583015,
 1327431680,
 -1,
 -45278,
 1327550023,
 9208,
 -45277,
 1327610200,
 11844,
 -45276,
 1327663616,
 11799,
 -45275,
 1327724923,
 11842,
 -45274,
 1327783114,
 11840,
 -1,
 1327838593,
 10175,
 1328041770,
 1327511007,
 -1,
 -45271,
 1327987639,
 9891,
 -1,
 1328040610,
 9890,
 -1,
 1327959922,
 8508,
 -1,
 1327452597,
 127849,
 1328369458,
 1327416012,
 -1,
 -45266,
 1328333130,
 11784,
 -45265,
 1328395807,
 11034,
 -45264,
 1328457852,
 11798,
 -45263,
 1328515571,
 11795,
 -1,
 1328559092,
 8284,
 1328762679,
 1328297277,
 128462,
 1328873471,
 1328679682,
 -1,
 1328893750,
 1328790727,
 128441,
 -1,
 1328808100,
 128442,
 -1,
 1328847618,
 128443,
 1329090361,
 1328697144,
 128021,
 -1,
 1329005276,
 128054,
 -45254,
 1329057151,
 128330,
 -45253,
 1329172753,
 128682,
 -45252,
 1329232384,
 128044,
 -1,
 1329267911,
 128687,
 1329483751,
 1316275402,
 -1,
 1329549286,
 1329437657,
 -1,
 1329614776,
 1329493212,
 -1,
 1329680220,
 1329573260,
 113692,
 1329745743,
 1329594368,
 -1,
 1329811268,
 1329714321,
 113701,
 -1,
 1329725807,
 113702,
 1329942342,
 1329773083,
 113714,
 -1,
 1329858633,
 113715,
 1330073416,
 1329895278,
 113716,
 -1,
 1329989705,
 113717,
 1330204490,
 1330015029,
 113727,
 -1,
 1330120777,
 113728,
 1330335564,
 1330145801,
 113696,
 -1,
 1330251919,
 113710,
 -45235,
 1330294156,
 113706,
 -45234,
 1330414324,
 113723,
 -1,
 1330477759,
 113724,
 1330663259,
 1329690670,
 -1,
 1330728788,
 1330593340,
 -1,
 -45230,
 1330676468,
 113767,
 -45229,
 1330730018,
 113740,
 -1,
 1330789948,
 113742,
 1330990935,
 1330678186,
 -1,
 -45226,
 1330958604,
 113730,
 -1,
 1331004148,
 113769,
 -45224,
 1330955466,
 113752,
 -45223,
 1331128841,
 113685,
 -45222,
 1331181603,
 113682,
 -1,
 1331240733,
 113768,
 -1,
 1330600639,
 113737,
 1331515239,
 1329627892,
 113690,
 1331580770,
 1331438369,
 -1,
 -45217,
 1331545290,
 113761,
 -45216,
 1331595690,
 113762,
 -45215,
 1331649745,
 113763,
 -1,
 1331697903,
 113764,
 1331953663,
 1331494912,
 -1,
 1331973989,
 1331854015,
 113694,
 -1,
 1331890319,
 113708,
 -45210,
 1331942545,
 113698,
 -1,
 1332063628,
 113704,
 1332236145,
 1331456521,
 113691,
 1332346879,
 1332150272,
 -1,
 1332367211,
 1332270225,
 113699,
 -1,
 1332325809,
 113700,
 1332498285,
 1332325772,
 113705,
 -1,
 1332415431,
 113711,
 1332629359,
 1332445940,
 113712,
 -1,
 1332545679,
 113713,
 1332805631,
 1332574911,
 113695,
 -1,
 1332676751,
 113709,
 1332891513,
 1332203788,
 113720,
 1332957044,
 1332840874,
 113757,
 -1,
 1332924684,
 113760,
 -45195,
 1332894929,
 113758,
 -45194,
 1333023778,
 113721,
 -45193,
 1333084714,
 113759,
 -45192,
 1333139695,
 113756,
 -1,
 1333200969,
 113722,
 1333415807,
 1332846849,
 113675,
 1333481341,
 1333365979,
 -1,
 -45188,
 1333445834,
 113750,
 -1,
 1333484753,
 113741,
 -45186,
 1333416994,
 113688,
 -1,
 1333594255,
 113680,
 1333809028,
 1333365162,
 113732,
 -45183,
 1333776652,
 113754,
 -45182,
 1333839050,
 113755,
 -45181,
 1333889889,
 113753,
 -1,
 1333926127,
 113731,
 1334136714,
 1333754559,
 113689,
 1334247423,
 1334050816,
 -1,
 1334267784,
 1334149876,
 113693,
 -1,
 1334184079,
 113707,
 -45175,
 1334236305,
 113697,
 -1,
 1334357388,
 113703,
 1334529934,
 1334101194,
 113745,
 -45172,
 1334467793,
 113738,
 -45171,
 1334531106,
 113751,
 -1,
 1334576320,
 113748,
 1334792083,
 1334491675,
 113667,
 1334857618,
 1334706176,
 -1,
 -45167,
 1334816140,
 113718,
 -1,
 1334878522,
 113719,
 -1,
 1334793250,
 113681,
 1335119768,
 1334744942,
 113666,
 1335185303,
 1335051848,
 -1,
 -45162,
 1335132916,
 113765,
 -1,
 1335196351,
 113766,
 -1,
 1335100608,
 113676,
 1335447453,
 1335062215,
 113670,
 1335512988,
 1335397998,
 -1,
 -45157,
 1335477450,
 113749,
 -1,
 1335516369,
 113743,
 -1,
 1335448610,
 113687,
 1335775138,
 1335388981,
 113669,
 1335840673,
 1335689216,
 -1,
 -45152,
 1335796026,
 113725,
 -1,
 1335851711,
 113679,
 -1,
 1335782197,
 113684,
 1336102821,
 1335705148,
 113735,
 -45148,
 1336067274,
 113746,
 -1,
 1336098364,
 113739,
 1336299432,
 1336030685,
 113672,
 -45145,
 1336235042,
 113683,
 -1,
 1336281231,
 113677,
 1336496042,
 1336268765,
 113665,
 -1,
 1336463628,
 113747,
 1336627116,
 1336462458,
 113673,
 -1,
 1336576572,
 113770,
 1336758190,
 1336564945,
 113734,
 -1,
 1336688188,
 113736,
 1336889264,
 1336693794,
 113664,
 -1,
 1336831687,
 113686,
 1337020338,
 1336823608,
 113674,
 -1,
 1336936524,
 113726,
 1337151412,
 1336953272,
 113668,
 -1,
 1337066688,
 113678,
 1337282486,
 1337071855,
 113729,
 -1,
 1337234243,
 113733,
 -45129,
 1337252257,
 113744,
 -1,
 1337337266,
 113671,
 1337544674,
 1329536016,
 -1,
 1337610185,
 1337487047,
 -1,
 1337675720,
 1337562777,
 -1,
 1337741245,
 1337642558,
 113816,
 -1,
 1337657520,
 113779,
 1337872320,
 1337683655,
 -1,
 -45121,
 1337822862,
 113811,
 -1,
 1337877167,
 113814,
 1338068931,
 1337792751,
 -1,
 -45118,
 1338027109,
 113817,
 -1,
 1338062266,
 113808,
 -45116,
 1338036759,
 113815,
 -45115,
 1338228412,
 113809,
 -45114,
 1338266429,
 113810,
 -45113,
 1338325486,
 113812,
 -1,
 1338388303,
 113813,
 -1,
 1337606545,
 113776,
 1338658773,
 1337546821,
 -1,
 1338724300,
 1338625598,
 113800,
 -1,
 1338640560,
 113781,
 1338855375,
 1338666695,
 -1,
 -45106,
 1338805902,
 113795,
 -1,
 1338860207,
 113798,
 -45104,
 1338823191,
 113799,
 -45103,
 1339014844,
 113793,
 -45102,
 1339052861,
 113794,
 -45101,
 1339111918,
 113796,
 -45100,
 1339174735,
 113797,
 -1,
 1339235057,
 113792,
 1339445214,
 1338582154,
 -1,
 1339510746,
 1339407005,
 -1,
 1339576281,
 1339459007,
 113784,
 -1,
 1339491153,
 113788,
 -1,
 1339515061,
 113785,
 -45093,
 1339469639,
 113782,
 -45092,
 1339716511,
 113783,
 -45091,
 1339776221,
 113787,
 -1,
 1339834005,
 113786,
 1340035041,
 1339391805,
 -1,
 -45088,
 1340001935,
 113780,
 -1,
 1340037744,
 113777,
 -1,
 1339991978,
 113778,
 -45085,
 1337507140,
 113821,
 -45084,
 1340256940,
 113820,
 -45083,
 1340317407,
 113823,
 -1,
 1340357592,
 113822,
 -1,
 1329475649,
 129414,
 1340624953,
 1329413692,
 -1,
 1340690464,
 1340591226,
 -1,
 1340755993,
 1340612406,
 -1,
 1340821501,
 1340699868,
 -1,
 1340887022,
 1340785866,
 -1,
 -45075,
 1340851957,
 2423,
 -1,
 1340882492,
 2422,
 1341083633,
 1340836266,
 -1,
 -45072,
 1341033173,
 2420,
 -1,
 1341079100,
 2419,
 1341280244,
 1341017912,
 -1,
 -45069,
 1341225194,
 2429,
 -1,
 1341280135,
 2427,
 -45067,
 1341250632,
 2425,
 -45066,
 1341436341,
 2308,
 -45065,
 1341488386,
 2424,
 -45064,
 1341549243,
 2428,
 -45063,
 1341609732,
 2426,
 -45062,
 1341667117,
 2430,
 -45061,
 1341729842,
 2418,
 -45060,
 1341794084,
 2431,
 -1,
 1341859164,
 2421,
 1342066699,
 1340781199,
 -1,
 1342132228,
 1341992021,
 -1,
 1342197762,
 1342093851,
 -1,
 -45055,
 1342166538,
 43253,
 -1,
 1342200640,
 43254,
 -45053,
 1342164855,
 43251,
 -1,
 1342317854,
 43255,
 1342525447,
 1342090636,
 -1,
 -45050,
 1342478346,
 43250,
 -1,
 1342529175,
 43260,
 -45048,
 1342480147,
 43256,
 -45047,
 1342662030,
 2304,
 -45046,
 1342724192,
 2417,
 -1,
 1342782285,
 43252,
 1342984213,
 1342034072,
 -1,
 1343049743,
 1342948554,
 -1,
 -45042,
 1343014645,
 2391,
 -1,
 1343045180,
 2390,
 1343246354,
 1342998954,
 -1,
 -45039,
 1343195861,
 2363,
 -1,
 1343241788,
 2362,
 -45037,
 1343200832,
 2382,
 -45036,
 1343368251,
 2389,
 -1,
 1343432028,
 2383,
 -45034,
 1342925367,
 43261,
 -45033,
 1343575734,
 43259,
 -45032,
 1343639602,
 43257,
 -1,
 1343696054,
 43258,
 1343946751,
 1340694053,
 -1,
 1343967261,
 1343863323,
 -1,
 -45028,
 1343936010,
 983085,
 -1,
 1343970112,
 983087,
 -45026,
 1343928381,
 983160,
 -45025,
 1344114100,
 983083,
 -1,
 1344163200,
 983089,
 1344360494,
 1340648844,
 -1,
 1344426027,
 1344292226,
 -1,
 1344491561,
 1344358107,
 -1,
 1344557094,
 1344451662,
 -1,
 -45019,
 1344506750,
 66638,
 -1,
 1344555170,
 66639,
 1344798719,
 1344482450,
 -1,
 -45016,
 1344703358,
 66598,
 -1,
 1344751778,
 66599,
 1344995327,
 1344453147,
 127964,
 -1,
 1344865172,
 127965,
 1345126399,
 1344368230,
 -1,
 -45011,
 1345049664,
 128468,
 -1,
 1345073683,
 128421,
 1345278001,
 1344302791,
 983119,
 -45008,
 1345218915,
 128666,
 -1,
 1345275632,
 983118,
 1345474614,
 1345203074,
 -1,
 1345540149,
 1345412305,
 -1,
 -45004,
 1345485731,
 9192,
 -1,
 1345535480,
 127795,
 -1,
 1345496094,
 128475,
 -45001,
 1345430882,
 127962,
 -45000,
 1345755457,
 127980,
 -1,
 1345799554,
 129420,
 1345998959,
 1340562641,
 -1,
 1346064473,
 1345933112,
 -1,
 1346129995,
 1346004997,
 -1,
 1346195519,
 1346100214,
 -1,
 -44994,
 1346129703,
 127232,
 -1,
 1346187704,
 127233,
 1346392130,
 1346157083,
 -1,
 -44991,
 1346360858,
 127235,
 -1,
 1346394966,
 127236,
 1346588741,
 1346350476,
 -1,
 -44988,
 1346529674,
 127239,
 -1,
 1346586602,
 127240,
 1346785352,
 1346521528,
 -1,
 -44985,
 1346737101,
 127237,
 -1,
 1346791642,
 127238,
 -44983,
 1346735549,
 127234,
 -44982,
 1346930229,
 127242,
 -1,
 1346978370,
 127241,
 1347223551,
 1346085534,
 -1,
 1347244112,
 1347108767,
 119557,
 1347354623,
 1347189426,
 -1,
 -44977,
 1347274742,
 119556,
 -1,
 1347305491,
 119555,
 1347506259,
 1347187899,
 -1,
 -44974,
 1347445122,
 9869,
 -1,
 1347493857,
 9870,
 1347702870,
 1347441698,
 -1,
 -44971,
 1347667963,
 119554,
 -1,
 1347698713,
 119553,
 1347944447,
 1347638117,
 -1,
 -44968,
 1347838338,
 9871,
 -1,
 1347887073,
 9868,
 1348096097,
 1345986309,
 -1,
 1348161631,
 1348064388,
 -1,
 -44964,
 1348124790,
 11032,
 -44963,
 1348183931,
 11031,
 -44962,
 1348235949,
 11030,
 -1,
 1348282898,
 11033,
 -44960,
 1348123512,
 128924,
 -1,
 1348448469,
 128160,
 1348620390,
 1348054559,
 -1,
 1348685925,
 1348574630,
 -1,
 -44956,
 1348618768,
 128542,
 -1,
 1348676420,
 128549,
 -1,
 1348610360,
 9933,
 1348948073,
 1348590774,
 -1,
 -44952,
 1348909528,
 128171,
 -1,
 1348946448,
 128565,
 1349144684,
 1348896180,
 -1,
 -44949,
 1349092494,
 127244,
 -1,
 1349136287,
 127243,
 -44947,
 1349111866,
 9902,
 -44946,
 1349297304,
 127919,
 -1,
 1349338785,
 128754,
 1349537917,
 1345919215,
 -1,
 1349603445,
 1349472583,
 -1,
 1349668980,
 1349571716,
 -1,
 -44941,
 1349625683,
 11831,
 -1,
 1349677704,
 11830,
 -1,
 1349610977,
 128481,
 1349931128,
 1349562425,
 -1,
 -44937,
 1349899474,
 11843,
 -1,
 1349958104,
 128168,
 1350127739,
 1349878516,
 -1,
 -44934,
 1350062780,
 127841,
 -1,
 1350118864,
 128131,
 -44932,
 1350089376,
 983081,
 -1,
 1350281942,
 128374,
 1350455431,
 1349492993,
 -1,
 1350520962,
 1350404522,
 -1,
 -44928,
 1350474654,
 128167,
 -44927,
 1350536331,
 129316,
 -1,
 1350598093,
 128042,
 1350783108,
 1350442094,
 128009,
 -1,
 1350697692,
 128050,
 -44923,
 1350748131,
 129345,
 -44922,
 1350854964,
 9946,
 -1,
 1350911680,
 128087,
 1351110797,
 1350380418,
 -1,
 -44919,
 1351069068,
 983161,
 -44918,
 1351095315,
 983090,
 -44917,
 1351160565,
 983088,
 -44916,
 1351225808,
 983086,
 -1,
 1351291045,
 983084,
 -44914,
 1351077218,
 128192,
 -1,
 1351446959,
 983082,
 1351635611,
 1316193012,
 -1,
 1351700940,
 1351564860,
 -1,
 1351766404,
 1351667980,
 -1,
 1351831822,
 1351686385,
 -1,
 1351897307,
 1351775452,
 -1,
 1351962782,
 1351844596,
 -1,
 1352028312,
 1351932115,
 -1,
 -44905,
 1351963704,
 70681,
 -1,
 1352014063,
 70680,
 1352224923,
 1351962424,
 -1,
 -44902,
 1352160312,
 70675,
 -1,
 1352210671,
 70674,
 -44900,
 1352172369,
 70686,
 -44899,
 1352356920,
 70692,
 -1,
 1352407279,
 70691,
 1352618147,
 1351929787,
 -1,
 1352683681,
 1352573185,
 70662,
 -1,
 1352638721,
 70663,
 1352859647,
 1352625863,
 70664,
 -1,
 1352756935,
 70665,
 1352945833,
 1352579611,
 -1,
 1353011367,
 1352907291,
 -1,
 -44890,
 1352946744,
 70683,
 -1,
 1352997103,
 70682,
 -44888,
 1352946744,
 70688,
 -1,
 1353128175,
 70687,
 1353339055,
 1352873437,
 -1,
 1353404589,
 1353266653,
 -1,
 -44884,
 1353339960,
 70685,
 -1,
 1353390319,
 70684,
 -44882,
 1353339960,
 70690,
 -1,
 1353521391,
 70689,
 1353732275,
 1353259247,
 70656,
 -44879,
 1353696458,
 70669,
 -44878,
 1353735377,
 70667,
 -1,
 1353783535,
 70657,
 1353994423,
 1353690508,
 -1,
 -44875,
 1353952799,
 70706,
 -44874,
 1353995320,
 70705,
 -1,
 1354045679,
 70707,
 1354256569,
 1353958602,
 70660,
 -1,
 1354220746,
 70661,
 1354387644,
 1354211585,
 -1,
 -44869,
 1354323000,
 70701,
 -1,
 1354373359,
 70700,
 1354584255,
 1354340206,
 -1,
 -44866,
 1354519608,
 70694,
 -1,
 1354569967,
 70693,
 1354780866,
 1354529471,
 -1,
 -44863,
 1354716216,
 70698,
 -1,
 1354766575,
 70697,
 1354977477,
 1354723015,
 -1,
 -44860,
 1354912824,
 70703,
 -1,
 1354963183,
 70702,
 1355174088,
 1354918709,
 -1,
 -44857,
 1355109432,
 70671,
 -1,
 1355159791,
 70670,
 1355370699,
 1355115017,
 -1,
 -44854,
 1355306040,
 70679,
 -1,
 1355356399,
 70678,
 1355567309,
 1355308241,
 70658,
 -1,
 1355504849,
 70659,
 1355698384,
 1355501368,
 -1,
 -44849,
 1355633720,
 70673,
 -1,
 1355684079,
 70672,
 1355894995,
 1355623298,
 -1,
 -44846,
 1355830328,
 70677,
 -1,
 1355880687,
 70676,
 1356091606,
 1355818418,
 -1,
 -44843,
 1356026936,
 70696,
 -1,
 1356077295,
 70695,
 -44841,
 1356060972,
 70699,
 -44840,
 1356255564,
 70704,
 -44839,
 1356302762,
 70668,
 -44838,
 1356354616,
 70708,
 -1,
 1356414524,
 70666,
 1356615915,
 1351864472,
 -1,
 1356681441,
 1356582843,
 -1,
 1356746975,
 1356636417,
 70714,
 -1,
 1356701953,
 70715,
 1356922879,
 1356689095,
 70716,
 -1,
 1356820167,
 70717,
 1357009125,
 1356601583,
 -1,
 -44829,
 1356973258,
 70721,
 -44828,
 1357012177,
 70719,
 -1,
 1357060335,
 70709,
 1357271271,
 1356973258,
 70712,
 -1,
 1357235402,
 70713,
 1357402345,
 1357208785,
 70710,
 -1,
 1357339857,
 70711,
 -44822,
 1357351338,
 70720,
 -1,
 1357463100,
 70718,
 1357664508,
 1356543453,
 -1,
 1357730042,
 1357602902,
 -1,
 1357795568,
 1357691419,
 -1,
 -44817,
 1357764106,
 70738,
 -1,
 1357798208,
 70739,
 1357992179,
 1357753740,
 -1,
 -44814,
 1357932931,
 70742,
 -1,
 1357989855,
 70743,
 1358188790,
 1357924792,
 -1,
 -44811,
 1358140356,
 70740,
 -1,
 1358194897,
 70741,
 -44809,
 1358158833,
 70736,
 -44808,
 1358335412,
 70737,
 -44807,
 1358399024,
 70745,
 -1,
 1358447157,
 70744,
 -44805,
 1357681485,
 70732,
 -1,
 1358569389,
 70731,
 1358778632,
 1357623834,
 -1,
 1358844167,
 1358713516,
 -1,
 1358909697,
 1358810942,
 -1,
 -44800,
 1358868182,
 70725,
 -1,
 1358930599,
 70722,
 1359106308,
 1358829807,
 -1,
 -44797,
 1359072403,
 70727,
 -1,
 1359120677,
 70724,
 -44795,
 1359055062,
 70726,
 -44794,
 1359235918,
 70728,
 -1,
 1359293513,
 70723,
 -1,
 1358772018,
 70730,
 -44791,
 1358732134,
 70747,
 -44790,
 1359514812,
 70729,
 -44789,
 1359570102,
 70749,
 -44788,
 1359630386,
 70734,
 -44787,
 1359688120,
 70733,
 -1,
 1359747594,
 70735,
 1359958400,
 1351745536,
 -1,
 1360023932,
 1359919882,
 -1,
 1360089427,
 1359967452,
 -1,
 1360154926,
 1360034047,
 -1,
 1360220438,
 1360116251,
 -1,
 -44780,
 1360178719,
 6539,
 -44779,
 1360221240,
 6546,
 -1,
 1360271599,
 6545,
 1360482585,
 1360189405,
 -1,
 -44776,
 1360448656,
 6569,
 -1,
 1360468207,
 6534,
 1360679196,
 1360440716,
 -1,
 -44773,
 1360643427,
 6571,
 -1,
 1360664815,
 6540,
 1360875807,
 1360631662,
 -1,
 -44770,
 1360811064,
 6552,
 -1,
 1360861423,
 6551,
 1361072418,
 1360823028,
 -1,
 -44767,
 1361006471,
 6535,
 -1,
 1361058031,
 6547,
 1361269029,
 1361013557,
 -1,
 -44764,
 1361235088,
 6568,
 -1,
 1361254639,
 6533,
 -44762,
 1361238316,
 6541,
 -44761,
 1361431696,
 6558,
 -44760,
 1361485674,
 6529,
 -44759,
 1361541909,
 6553,
 -44758,
 1361604357,
 6559,
 -44757,
 1361663032,
 6563,
 -44756,
 1361725965,
 6557,
 -44755,
 1361786475,
 6564,
 -1,
 1361847783,
 6565,
 1362055499,
 1360091205,
 -1,
 1362121011,
 1362016795,
 -1,
 -44751,
 1362079263,
 6536,
 -44750,
 1362121784,
 6543,
 -1,
 1362172143,
 6542,
 1362383158,
 1362089949,
 -1,
 -44747,
 1362349200,
 6567,
 -1,
 1362368751,
 6531,
 1362579769,
 1362341260,
 -1,
 -44744,
 1362543971,
 6570,
 -1,
 1362565359,
 6537,
 1362776380,
 1362532206,
 -1,
 -44741,
 1362711608,
 6549,
 -1,
 1362761967,
 6548,
 1362972991,
 1362723572,
 -1,
 -44738,
 1362907015,
 6532,
 -1,
 1362958575,
 6544,
 1363169602,
 1362914101,
 -1,
 -44735,
 1363135632,
 6566,
 -1,
 1363155183,
 6530,
 -44733,
 1363138860,
 6538,
 -44732,
 1363332240,
 6555,
 -44731,
 1363386218,
 6528,
 -44730,
 1363442453,
 6550,
 -44729,
 1363504901,
 6556,
 -44728,
 1363563576,
 6560,
 -44727,
 1363626509,
 6554,
 -44726,
 1363687019,
 6561,
 -1,
 1363748327,
 6562,
 1364000767,
 1361988423,
 -1,
 1364021582,
 1363903220,
 6595,
 -1,
 1363955512,
 6594,
 -44721,
 1363987578,
 6593,
 -44720,
 1364097727,
 6596,
 -44719,
 1364159285,
 6597,
 -44718,
 1364211165,
 6598,
 -1,
 1364272562,
 6599,
 1364480359,
 1360056472,
 -1,
 1364545881,
 1364444362,
 6579,
 1364611415,
 1364475452,
 6585,
 -1,
 1364580563,
 6591,
 -44712,
 1364580563,
 6588,
 -1,
 1364706506,
 6580,
 1364873565,
 1364494762,
 6583,
 1364939100,
 1364793583,
 6584,
 -1,
 1364908243,
 6590,
 -1,
 1364908243,
 6589,
 1365135714,
 1364793583,
 -1,
 1365201248,
 1365055727,
 6577,
 -1,
 1365170387,
 6587,
 -44703,
 1365170387,
 6586,
 -1,
 1365261884,
 6582,
 1365463397,
 1365073105,
 -1,
 -44700,
 1365432531,
 6592,
 -1,
 1365466321,
 6578,
 -44698,
 1365430408,
 6576,
 -1,
 1365589564,
 6581,
 1365791093,
 1364408540,
 -1,
 1365856619,
 1365752347,
 -1,
 -44694,
 1365825034,
 6610,
 -1,
 1365859136,
 6611,
 1366053230,
 1365814668,
 -1,
 -44691,
 1365993859,
 6614,
 -1,
 1366050783,
 6615,
 1366249841,
 1365985720,
 -1,
 -44688,
 1366201284,
 6612,
 -1,
 1366255825,
 6613,
 -44686,
 1366219761,
 6608,
 -44685,
 1366396340,
 6609,
 -44684,
 1366459952,
 6617,
 -1,
 1366508085,
 6616,
 1366708602,
 1365752347,
 -1,
 1366774137,
 1366658575,
 -1,
 -44680,
 1366692304,
 6601,
 -1,
 1366757541,
 6600,
 -1,
 1366709538,
 6618,
 1367080959,
 1366667939,
 6622,
 -1,
 1367002234,
 6623,
 1367167359,
 1359970706,
 -1,
 -44674,
 1367135386,
 127770,
 -1,
 1367194072,
 127761,
 -1,
 1367111346,
 983063,
 1367429507,
 1359902391,
 -1,
 -44670,
 1367385926,
 11155,
 -1,
 1367437949,
 11154,
 -1,
 1367389619,
 128240,
 1367691717,
 1351700566,
 -1,
 1367757223,
 1367651901,
 -1,
 1367822753,
 1367699666,
 -1,
 -44664,
 1367792431,
 127369,
 -44663,
 1367857363,
 127368,
 -44662,
 1367922653,
 127367,
 -44661,
 1367986444,
 127366,
 -44660,
 1368050810,
 127365,
 -44659,
 1368114378,
 127364,
 -44658,
 1368177179,
 127363,
 -44657,
 1368239500,
 127362,
 -44656,
 1368301825,
 127361,
 -44655,
 1368366923,
 127360,
 -44654,
 1368430446,
 127359,
 -44653,
 1368492458,
 127358,
 -44652,
 1368556276,
 127357,
 -44651,
 1368619711,
 127356,
 -44650,
 1368682183,
 127355,
 -44649,
 1368746805,
 127354,
 -44648,
 1368812041,
 127353,
 -44647,
 1368874193,
 127352,
 -44646,
 1368937506,
 127351,
 -44645,
 1369001784,
 127350,
 -44644,
 1369065912,
 127349,
 -44643,
 1369128508,
 127348,
 -44642,
 1369191901,
 127347,
 -44641,
 1369254786,
 127346,
 -44640,
 1369318834,
 127345,
 -1,
 1369381103,
 127344,
 -44638,
 1367790182,
 127375,
 -44637,
 1369550367,
 127373,
 -44636,
 1369610204,
 127372,
 -44635,
 1369660945,
 127371,
 -44634,
 1369715706,
 10062,
 -1,
 1369774532,
 127374,
 1369985476,
 1367682953,
 -1,
 1370051011,
 1369927890,
 -1,
 -44630,
 1370020655,
 127337,
 -44629,
 1370085587,
 127336,
 -44628,
 1370150877,
 127335,
 -44627,
 1370214668,
 127334,
 -44626,
 1370279034,
 127333,
 -44625,
 1370342602,
 127332,
 -44624,
 1370405403,
 127331,
 -44623,
 1370467724,
 127330,
 -44622,
 1370530049,
 127329,
 -44621,
 1370595147,
 127328,
 -44620,
 1370658670,
 127327,
 -44619,
 1370720682,
 127326,
 -44618,
 1370784500,
 127325,
 -44617,
 1370847935,
 127324,
 -44616,
 1370910407,
 127323,
 -44615,
 1370975029,
 127322,
 -44614,
 1371040265,
 127321,
 -44613,
 1371102417,
 127320,
 -44612,
 1371165730,
 127319,
 -44611,
 1371230008,
 127318,
 -44610,
 1371294136,
 127317,
 -44609,
 1371356732,
 127316,
 -44608,
 1371420125,
 127315,
 -44607,
 1371483010,
 127314,
 -44606,
 1371547058,
 127313,
 -1,
 1371609327,
 127312,
 -1,
 1369979107,
 9471,
 -1,
 1369905849,
 983091,
 1371951560,
 1367657499,
 -1,
 -44601,
 1371906700,
 128528,
 -1,
 1371948418,
 9906,
 -44599,
 1371920539,
 983130,
 -44598,
 1372103588,
 129299,
 -44597,
 1372155591,
 983131,
 -1,
 1372205216,
 128084,
 1372410390,
 1351642608,
 -1,
 1372475893,
 1372352199,
 -1,
 1372541427,
 1372407584,
 -1,
 1372606932,
 1372488436,
 2002,
 1372672466,
 1372576044,
 2018,
 -1,
 1372589570,
 2023,
 1372848127,
 1372592367,
 2019,
 -1,
 1372720642,
 2016,
 1372934618,
 1372547593,
 -1,
 1373000153,
 1372884380,
 -1,
 -44585,
 1372955003,
 2026,
 -44584,
 1373006375,
 2024,
 -1,
 1373056539,
 2025,
 -1,
 1372920047,
 2006,
 1373327837,
 1372889345,
 -1,
 -44580,
 1373282683,
 2010,
 -1,
 1373313263,
 2009,
 1373524447,
 1373276586,
 2000,
 -1,
 1373473194,
 1999,
 1373655521,
 1373453884,
 1997,
 -1,
 1373584956,
 1995,
 1373786595,
 1373582955,
 2008,
 -1,
 1373720734,
 2001,
 -44572,
 1373755692,
 2022,
 -44571,
 1373884748,
 2021,
 -44570,
 1373947082,
 1998,
 -44569,
 1374010013,
 2005,
 -44568,
 1374072351,
 2011,
 -44567,
 1374132188,
 2004,
 -44566,
 1374190357,
 2017,
 -44565,
 1374252805,
 2015,
 -44564,
 1374317447,
 2014,
 -44563,
 1374379217,
 1996,
 -44562,
 1374442552,
 2020,
 -44561,
 1374507138,
 2012,
 -44560,
 1374571021,
 2013,
 -44559,
 1374629403,
 2007,
 -44558,
 1374692839,
 2003,
 -1,
 1374755055,
 1994,
 -44556,
 1372493505,
 2037,
 -1,
 1374887276,
 2042,
 1375097347,
 1372403932,
 -1,
 1375162873,
 1375058459,
 -1,
 -44552,
 1375131146,
 1986,
 -1,
 1375165248,
 1987,
 1375359484,
 1375120780,
 -1,
 -44549,
 1375299971,
 1990,
 -1,
 1375356895,
 1991,
 1375556095,
 1375291832,
 -1,
 -44546,
 1375507396,
 1988,
 -1,
 1375561937,
 1989,
 -44544,
 1375525873,
 1984,
 -44543,
 1375702452,
 1985,
 -44542,
 1375766064,
 1993,
 -1,
 1375814197,
 1992,
 1376014865,
 1375023454,
 -1,
 1376080400,
 1375938716,
 -1,
 1376145930,
 1376024677,
 -1,
 -44537,
 1376103027,
 2033,
 -44536,
 1376156018,
 2032,
 -44535,
 1376213117,
 2031,
 -1,
 1376270323,
 2030,
 1376473614,
 1376104878,
 -1,
 -44532,
 1376430707,
 2029,
 -44531,
 1376483698,
 2028,
 -1,
 1376540797,
 2027,
 -44529,
 1376420774,
 2034,
 -1,
 1376664477,
 2035,
 -1,
 1376025365,
 2040,
 1376932372,
 1375975903,
 -1,
 -44525,
 1376882492,
 2038,
 -1,
 1376931974,
 2039,
 -44523,
 1376868487,
 2036,
 -1,
 1377061051,
 2041,
 1377260120,
 1372359082,
 -1,
 1377325631,
 1377214721,
 -1,
 1377391166,
 1377287377,
 -1,
 1377456701,
 1377304576,
 -1,
 1377522217,
 1377395345,
 -1,
 1377587748,
 1377455693,
 -1,
 1377653281,
 1377537464,
 -1,
 -44514,
 1377612659,
 43059,
 -44513,
 1377673266,
 43056,
 -44512,
 1377719495,
 43057,
 -1,
 1377780342,
 43060,
 1378025471,
 1377615297,
 -1,
 -44509,
 1377940349,
 43061,
 -1,
 1378001009,
 43058,
 1378177575,
 1377542084,
 -1,
 -44506,
 1378135232,
 43062,
 -1,
 1378191525,
 43065,
 -44504,
 1378135373,
 43064,
 -1,
 1378327398,
 43063,
 1378505267,
 1377489604,
 -1,
 1378570798,
 1378458754,
 -1,
 -44500,
 1378537325,
 128600,
 -44499,
 1378578980,
 128592,
 -1,
 1378626289,
 128608,
 1378832944,
 1378533854,
 11110,
 -1,
 1378749107,
 11126,
 -44495,
 1378800423,
 11009,
 -44494,
 1378922177,
 129108,
 -1,
 1378953451,
 11017,
 1379205119,
 1378434981,
 -1,
 1379226168,
 1379114114,
 -1,
 -44490,
 1379192685,
 128602,
 -44489,
 1379234340,
 128594,
 -1,
 1379281649,
 128610,
 1379488314,
 1379189214,
 11111,
 -1,
 1379404467,
 11127,
 -44485,
 1379455783,
 11008,
 -44484,
 1379577537,
 129109,
 -1,
 1379608811,
 11016,
 -1,
 1377386445,
 128746,
 -1,
 1377319105,
 8379,
 1379947083,
 1377239040,
 -1,
 1380012611,
 1379899246,
 -1,
 -44478,
 1379952282,
 128370,
 -1,
 1380008136,
 128695,
 1380209221,
 1379943630,
 9940,
 -1,
 1380124874,
 128683,
 1380340296,
 1380132274,
 -1,
 -44473,
 1380295672,
 983126,
 -1,
 1380343432,
 128691,
 -44471,
 1380300049,
 128685,
 -44470,
 1380486706,
 128286,
 -1,
 1380548869,
 128245,
 1380733525,
 1379908123,
 -1,
 1380799058,
 1380662844,
 128456,
 1380864591,
 1380723181,
 128211,
 -1,
 1380780938,
 128212,
 1381040127,
 1380779711,
 -1,
 -44463,
 1380929725,
 128457,
 -1,
 1380988381,
 128458,
 1381236735,
 1380724323,
 -1,
 -44460,
 1381148658,
 128324,
 -1,
 1381200637,
 128323,
 -44458,
 1380691767,
 128067,
 -44457,
 1381335858,
 128689,
 -1,
 1381400738,
 65934,
 1381585553,
 1377179887,
 -1,
 1381651084,
 1381508879,
 -1,
 1381716607,
 1381594332,
 -1,
 1381782117,
 1381649223,
 -1,
 -44451,
 1381751474,
 67724,
 -44450,
 1381806454,
 67740,
 -44449,
 1381861660,
 67732,
 -44448,
 1381924501,
 67730,
 -44447,
 1381986290,
 67728,
 -44446,
 1382050810,
 67726,
 -44445,
 1382110849,
 67718,
 -44444,
 1382164453,
 67714,
 -1,
 1382227467,
 67712,
 1382437482,
 1381739916,
 -1,
 1382503017,
 1382357231,
 -1,
 -44440,
 1382448764,
 67734,
 -1,
 1382496312,
 67737,
 -1,
 1382439117,
 67741,
 1382765165,
 1382398491,
 -1,
 -44436,
 1382696704,
 67723,
 -1,
 1382753628,
 67742,
 1382961775,
 1382700673,
 67719,
 -1,
 1382923473,
 67722,
 1383092850,
 1382881519,
 -1,
 -44431,
 1383062051,
 67735,
 -1,
 1383101613,
 67713,
 -44429,
 1383062468,
 67721,
 -44428,
 1383258802,
 67725,
 -44427,
 1383322157,
 67720,
 -44426,
 1383376331,
 67739,
 -44425,
 1383440316,
 67738,
 -44424,
 1383504237,
 67736,
 -44423,
 1383565596,
 67733,
 -44422,
 1383628437,
 67731,
 -44421,
 1383690226,
 67729,
 -44420,
 1383754746,
 67727,
 -44419,
 1383813694,
 67716,
 -44418,
 1383872189,
 67717,
 -1,
 1383933925,
 67715,
 1384141451,
 1381664992,
 -1,
 1384206982,
 1384102427,
 -1,
 1384272516,
 1384173836,
 -1,
 -44413,
 1384221098,
 67752,
 -1,
 1384269012,
 67758,
 -44411,
 1384209216,
 67753,
 -1,
 1384399716,
 67757,
 1384600200,
 1384156596,
 67751,
 -1,
 1384514395,
 67759,
 1384775679,
 1384532408,
 -1,
 -44406,
 1384682436,
 67754,
 -1,
 1384736977,
 67756,
 -1,
 1384068302,
 67755,
 -44403,
 1381616566,
 129314,
 -44402,
 1384955820,
 127966,
 -44401,
 1385004459,
 128219,
 -44400,
 1385065269,
 983092,
 -1,
 1385128128,
 128133,
 1385321109,
 1381549258,
 -1,
 1385386644,
 1385262791,
 983041,
 -1,
 1385328327,
 983040,
 -1,
 1385347616,
 128297,
 1385583256,
 1385244082,
 -1,
 -44393,
 1385543061,
 983196,
 -1,
 1385583650,
 983127,
 -44391,
 1385530326,
 983223,
 -44390,
 1385721543,
 983066,
 -1,
 1385783302,
 127747,
 1385976969,
 1351570466,
 -1,
 1386042232,
 1385896175,
 -1,
 1386107722,
 1385988852,
 -1,
 1386173252,
 1386042304,
 -1,
 1386238742,
 1386113545,
 -1,
 1386304237,
 1386188480,
 -1,
 1386369718,
 1386261900,
 -1,
 1386435245,
 1386327732,
 -1,
 1386500773,
 1386397404,
 55245,
 -1,
 1386417921,
 55246,
 1386631848,
 1386459936,
 -1,
 -44377,
 1386594012,
 55277,
 -1,
 1386638774,
 55276,
 -44375,
 1386587941,
 55255,
 -44374,
 1386781460,
 55270,
 -44373,
 1386841595,
 4607,
 -44372,
 1386905578,
 55264,
 -1,
 1386950443,
 55289,
 1387200511,
 1386374722,
 -1,
 1387221681,
 1387080578,
 -1,
 -44368,
 1387159316,
 55279,
 -1,
 1387223052,
 55280,
 -44366,
 1387183450,
 55281,
 -44365,
 1387370614,
 55278,
 -44364,
 1387429866,
 55274,
 -44363,
 1387490303,
 55275,
 -1,
 1387550739,
 55282,
 1387745989,
 1386321774,
 -1,
 1387811519,
 1387683616,
 -1,
 1387877051,
 1387735938,
 -1,
 -44358,
 1387814676,
 55272,
 -1,
 1387878412,
 55273,
 -44356,
 1387839196,
 55267,
 -44355,
 1388032830,
 55271,
 -44354,
 1388095283,
 55268,
 -1,
 1388150762,
 55269,
 1388335810,
 1387747371,
 -1,
 -44351,
 1388297562,
 55291,
 -1,
 1388360475,
 55290,
 1388576767,
 1388257395,
 -1,
 -44348,
 1388485396,
 55283,
 -1,
 1388538879,
 55284,
 1388729039,
 1387702046,
 -1,
 1388794569,
 1388698017,
 -1,
 -44344,
 1388753539,
 55259,
 -1,
 1388810619,
 55260,
 1388991180,
 1388747546,
 -1,
 -44341,
 1388953308,
 55257,
 -1,
 1389009614,
 55258,
 -44339,
 1388951189,
 55253,
 -44338,
 1389133815,
 55256,
 -1,
 1389194685,
 55254,
 1389384407,
 1388691171,
 -1,
 1389449938,
 1389343515,
 55248,
 -1,
 1389366946,
 55249,
 1389581013,
 1389374338,
 -1,
 -44332,
 1389518612,
 55250,
 -1,
 1389582348,
 55251,
 -44330,
 1389542746,
 55252,
 -1,
 1389730580,
 55247,
 1389908703,
 1389325109,
 -1,
 1389974238,
 1389849077,
 -1,
 -44326,
 1389927188,
 4603,
 -44325,
 1389987323,
 4602,
 -44324,
 1390046526,
 4605,
 -44323,
 1390106643,
 4606,
 -1,
 1390161577,
 4604,
 -1,
 1389895943,
 55261,
 1390432996,
 1389854704,
 -1,
 -44319,
 1390392993,
 55263,
 -44318,
 1390451489,
 55265,
 -44317,
 1390511611,
 55262,
 -1,
 1390554923,
 55266,
 1390760679,
 1390402061,
 -1,
 -44314,
 1390706666,
 55285,
 -1,
 1390762003,
 55286,
 1390957290,
 1390708225,
 -1,
 -44311,
 1390913304,
 55243,
 -1,
 1390948009,
 55244,
 1391198207,
 1390882609,
 -1,
 -44308,
 1391113900,
 55288,
 -1,
 1391172372,
 55287,
 1391394815,
 1386268889,
 -1,
 1391416057,
 1391287619,
 -1,
 1391481591,
 1391384787,
 -1,
 1391547122,
 1391410748,
 55232,
 -1,
 1391495594,
 55231,
 1391678197,
 1391466735,
 -1,
 -44300,
 1391607356,
 55230,
 -1,
 1391660786,
 55229,
 -44298,
 1391641802,
 55235,
 -1,
 1391823274,
 55234,
 -44296,
 1391430108,
 55233,
 -1,
 1391942865,
 55236,
 1392136963,
 1391384787,
 -1,
 1392202494,
 1392085465,
 -1,
 1392268029,
 1392122095,
 55218,
 -1,
 1392197180,
 55219,
 -1,
 1392198913,
 55220,
 1392464641,
 1392166193,
 -1,
 -44288,
 1392413098,
 55224,
 -1,
 1392450415,
 55223,
 -44286,
 1392395524,
 4517,
 -1,
 1392581004,
 4516,
 1392792329,
 1392085465,
 -1,
 1392857864,
 1392761043,
 -1,
 1392923399,
 1392777455,
 4518,
 -1,
 1392852540,
 4519,
 -1,
 1392854273,
 55216,
 -1,
 1392806364,
 55217,
 1393185550,
 1392723792,
 -1,
 1393251084,
 1393114684,
 55227,
 -1,
 1393199530,
 55226,
 -44275,
 1393199530,
 55228,
 -1,
 1393301743,
 55225,
 1393513235,
 1393105135,
 -1,
 1393578770,
 1393467826,
 -1,
 -44271,
 1393507900,
 55238,
 -1,
 1393563887,
 55237,
 -1,
 1393495668,
 4515,
 1393885183,
 1393476913,
 -1,
 -44267,
 1393809908,
 55221,
 -1,
 1393843526,
 55222,
 1394081791,
 1386163937,
 -1,
 1394103078,
 1393993502,
 -1,
 1394168606,
 1394060684,
 -1,
 1394234141,
 1394126516,
 -1,
 -44261,
 1394196188,
 43367,
 -44260,
 1394252564,
 43370,
 -1,
 1394306486,
 43365,
 -1,
 1394173502,
 43372,
 1394561826,
 1394109237,
 -1,
 -44256,
 1394502127,
 43364,
 -44255,
 1394563108,
 43374,
 -1,
 1394614522,
 43371,
 -44253,
 1394523868,
 43366,
 -44252,
 1394776852,
 43369,
 -44251,
 1394835434,
 43368,
 -1,
 1394880299,
 43373,
 1395086124,
 1394065123,
 -1,
 -44248,
 1395045147,
 43362,
 -44247,
 1395107608,
 4446,
 -44246,
 1395170068,
 43361,
 -44245,
 1395228650,
 43360,
 -1,
 1395273515,
 43363,
 1395479345,
 1395046031,
 -1,
 -44242,
 1395448312,
 43388,
 -44241,
 1395506522,
 43385,
 -44240,
 1395569446,
 43381,
 -1,
 1395601208,
 43384,
 1395807031,
 1395431278,
 -1,
 1395872566,
 1395744544,
 -1,
 -44236,
 1395831601,
 43378,
 -44235,
 1395879230,
 43379,
 -1,
 1395939347,
 43380,
 -1,
 1395808307,
 43386,
 1396200251,
 1395754497,
 -1,
 -44231,
 1396159259,
 4443,
 -44230,
 1396201491,
 4445,
 -1,
 1396256555,
 4444,
 1396462399,
 1396146160,
 -1,
 -44227,
 1396424412,
 43376,
 -44226,
 1396486939,
 43377,
 -1,
 1396534710,
 43375,
 1396724546,
 1396399897,
 -1,
 -44223,
 1396680472,
 43382,
 -1,
 1396725779,
 43383,
 -44221,
 1396665802,
 4442,
 -1,
 1396856857,
 43387,
 1397096447,
 1386100189,
 -1,
 1397117768,
 1396975079,
 -1,
 -44217,
 1397061491,
 129342,
 -1,
 1397116728,
 128092,
 -44215,
 1397076116,
 129309,
 -1,
 1397230777,
 129310,
 1397445486,
 1386068507,
 -1,
 1397511021,
 1397400240,
 -1,
 1397576550,
 1397454044,
 -1,
 1397642066,
 1397534092,
 -1,
 1397707601,
 1397561583,
 -1,
 -44208,
 1397653116,
 67822,
 -1,
 1397700664,
 67825,
 -1,
 1397643469,
 67828,
 1397969749,
 1397602843,
 -1,
 -44204,
 1397901056,
 67816,
 -1,
 1397957980,
 67829,
 1398166359,
 1397905025,
 67812,
 -1,
 1398127825,
 67815,
 1398297434,
 1398085871,
 -1,
 -44199,
 1398266524,
 67823,
 -1,
 1398305965,
 67808,
 -44197,
 1398266826,
 67814,
 -44196,
 1398463154,
 67817,
 -44195,
 1398526509,
 67813,
 -44194,
 1398579132,
 67826,
 -44193,
 1398643053,
 67824,
 -44192,
 1398704412,
 67821,
 -44191,
 1398767253,
 67820,
 -44190,
 1398829042,
 67819,
 -44189,
 1398893562,
 67818,
 -44188,
 1398952510,
 67810,
 -44187,
 1399011012,
 67811,
 -1,
 1399072741,
 67809,
 1399324671,
 1397524704,
 -1,
 1399346026,
 1399241243,
 -1,
 -44183,
 1399313055,
 67838,
 -1,
 1399341924,
 67837,
 1399542636,
 1399295412,
 67835,
 -1,
 1399456603,
 67839,
 -1,
 1399475180,
 67836,
 -1,
 1397436095,
 128035,
 1399804789,
 1397390015,
 -1,
 1399870323,
 1399750353,
 128296,
 1399980031,
 1399783495,
 -1,
 -44174,
 1399904129,
 128736,
 -1,
 1399954166,
 9874,
 -44172,
 1399830343,
 128057,
 -1,
 1400056608,
 127828,
 -44170,
 1399759772,
 128436,
 -44169,
 1400217053,
 128587,
 -1,
 1400268567,
 128135,
 1400460353,
 1385971260,
 -1,
 1400525784,
 1400428553,
 -1,
 1400591247,
 1400486427,
 -1,
 1400656782,
 1400526468,
 -1,
 1400722304,
 1400580994,
 -1,
 -44162,
 1400677452,
 19904,
 -44161,
 1400731380,
 19933,
 -1,
 1400775921,
 19953,
 1400984453,
 1400641775,
 -1,
 1401049988,
 1400938753,
 -1,
 -44157,
 1401001074,
 19954,
 -1,
 1401062107,
 19910,
 -1,
 1400974197,
 19932,
 1401312136,
 1400951052,
 -1,
 -44153,
 1401242349,
 19951,
 -1,
 1401298874,
 19959,
 -44151,
 1401267309,
 19905,
 -44150,
 1401453810,
 19957,
 -44149,
 1401515172,
 19955,
 -44148,
 1401580296,
 19961,
 -44147,
 1401639196,
 19960,
 -1,
 1401702992,
 19940,
 -1,
 1400611824,
 19913,
 1401967513,
 1400518109,
 -1,
 1402033044,
 1401896508,
 -1,
 -44142,
 1401998787,
 19956,
 -44141,
 1402042209,
 19943,
 -1,
 1402090387,
 19944,
 1402295191,
 1401969873,
 -1,
 -44138,
 1402254805,
 19962,
 -1,
 1402292971,
 19906,
 -44136,
 1402260216,
 19935,
 -1,
 1402413527,
 19939,
 1402622884,
 1401900856,
 -1,
 1402688419,
 1402577153,
 -1,
 1402753954,
 1402617864,
 -1,
 1402819489,
 1402705774,
 -1,
 1402885024,
 1402767786,
 -1,
 -44129,
 1402852027,
 19937,
 -1,
 1402910391,
 19917,
 -1,
 1402840480,
 19931,
 -1,
 1402780515,
 19929,
 -1,
 1402673763,
 19925,
 -1,
 1402610755,
 19948,
 1403343786,
 1402580364,
 -1,
 1403409320,
 1403288547,
 -1,
 -44121,
 1403370339,
 19912,
 -1,
 1403428353,
 19965,
 -44119,
 1403370350,
 19915,
 -1,
 1403558851,
 19926,
 1403737008,
 1403281794,
 -1,
 1403802542,
 1403683572,
 -1,
 -44115,
 1403750999,
 19928,
 -1,
 1403798979,
 19964,
 -44113,
 1403735240,
 19934,
 -1,
 1403925395,
 19945,
 1404130229,
 1403692013,
 -1,
 1404195764,
 1404090907,
 -1,
 -44109,
 1404160823,
 19927,
 -1,
 1404216373,
 19936,
 -1,
 1404162078,
 19952,
 1404457913,
 1404082030,
 -1,
 -44105,
 1404423145,
 19949,
 -44104,
 1404480329,
 19938,
 -1,
 1404518235,
 19914,
 1404720062,
 1404406186,
 -1,
 1404785597,
 1404673415,
 -1,
 -44100,
 1404741080,
 19950,
 -1,
 1404801598,
 19941,
 -1,
 1404709599,
 19942,
 1405047747,
 1404645690,
 -1,
 1405113282,
 1404994292,
 -1,
 -44095,
 1405074476,
 19923,
 -1,
 1405111412,
 19909,
 -1,
 1405059172,
 19947,
 1405375431,
 1404970418,
 -1,
 -44091,
 1405330434,
 19946,
 -44090,
 1405380765,
 19924,
 -1,
 1405436279,
 19967,
 1405637579,
 1405294831,
 -1,
 -44087,
 1405590984,
 19922,
 -44086,
 1405636367,
 19966,
 -1,
 1405692686,
 19958,
 1405899726,
 1405604108,
 -1,
 -44083,
 1405850013,
 19921,
 -1,
 1405885763,
 19908,
 1406096337,
 1405845762,
 -1,
 -44080,
 1406061618,
 19930,
 -1,
 1406089240,
 19918,
 1406292948,
 1406028216,
 -1,
 -44077,
 1406241946,
 19920,
 -1,
 1406288637,
 19916,
 -44075,
 1406261947,
 19907,
 -44074,
 1406432935,
 19963,
 -44073,
 1406491091,
 19911,
 -1,
 1406551222,
 19919,
 1406751797,
 1400445167,
 -1,
 1406817322,
 1406718210,
 -1,
 1406882793,
 1406774668,
 -1,
 1406948322,
 1406833851,
 -1,
 1407013855,
 1406915274,
 -1,
 -44066,
 1406979949,
 128605,
 -1,
 1407003377,
 128613,
 1407254527,
 1406943147,
 -1,
 -44063,
 1407176557,
 128607,
 -1,
 1407199985,
 128615,
 1407407077,
 1406888326,
 -1,
 -44060,
 1407366671,
 128952,
 -1,
 1407425647,
 128972,
 1407603688,
 1407326447,
 -1,
 -44057,
 1407551448,
 128635,
 -1,
 1407613512,
 128940,
 -1,
 1407529934,
 128625,
 1407865844,
 1406824135,
 -1,
 1407931373,
 1407817369,
 -1,
 -44052,
 1407890166,
 10079,
 -1,
 1407925095,
 10080,
 1408127984,
 1407861181,
 -1,
 -44049,
 1408069707,
 129052,
 -1,
 1408124268,
 129048,
 1408324595,
 1408047343,
 -1,
 -44046,
 1408286609,
 128327,
 -1,
 1408345681,
 11093,
 -1,
 1408262051,
 128627,
 1408586748,
 1407785199,
 -1,
 1408652283,
 1408543850,
 -1,
 1408717818,
 1408601524,
 129180,
 1408827391,
 1408630784,
 -1,
 -44039,
 1408744802,
 129183,
 -1,
 1408783559,
 129182,
 -1,
 1408681128,
 129181,
 -1,
 1408598503,
 128628,
 1409111043,
 1408534372,
 -1,
 1409176576,
 1409077962,
 -1,
 -44033,
 1409142637,
 128604,
 -1,
 1409166065,
 128612,
 1409417215,
 1409105835,
 -1,
 -44030,
 1409339245,
 128606,
 -1,
 1409362673,
 128614,
 1409569802,
 1409039932,
 -1,
 1409635337,
 1409507289,
 -1,
 1409700872,
 1409588326,
 -1,
 -44025,
 1409653566,
 128977,
 -1,
 1409689871,
 128975,
 -1,
 1409660431,
 128958,
 -1,
 1409603623,
 10071,
 1410028561,
 1409496541,
 -1,
 1410094096,
 1409976746,
 -1,
 1410159631,
 1410061814,
 -1,
 -44018,
 1410101323,
 129055,
 -1,
 1410155884,
 129051,
 -1,
 1410103229,
 128178,
 -1,
 1410034031,
 10135,
 1410487318,
 1409953615,
 11096,
 1410552853,
 1410403074,
 -1,
 -44012,
 1410512995,
 9955,
 -1,
 1410543483,
 11095,
 -1,
 1410479657,
 11097,
 1410815002,
 1410454304,
 -1,
 -44008,
 1410774559,
 128913,
 -44007,
 1410809039,
 9947,
 -1,
 1410871119,
 128903,
 1411077149,
 1410779798,
 -1,
 -44004,
 1411018827,
 129053,
 -1,
 1411073388,
 129049,
 1411273760,
 1411040241,
 -1,
 -44001,
 1411226430,
 128980,
 -1,
 1411262735,
 128979,
 1411470371,
 1411229944,
 -1,
 -43998,
 1411412043,
 129054,
 -1,
 1411466604,
 129050,
 1411666982,
 1411402737,
 -1,
 -43995,
 1411626511,
 128946,
 -1,
 1411685487,
 128970,
 -43993,
 1411619886,
 10133,
 -43992,
 1411814619,
 11094,
 -43991,
 1411874948,
 10134,
 -1,
 1411933488,
 128633,
 1412125746,
 1406771457,
 -1,
 1412191281,
 1412086301,
 -1,
 1412256816,
 1412158596,
 -1,
 -43986,
 1412218813,
 127892,
 -43985,
 1412277994,
 128157,
 -1,
 1412309627,
 128152,
 -1,
 1412183912,
 128159,
 -1,
 1412108002,
 128585,
 1412694015,
 1412052445,
 -1,
 -43980,
 1412609965,
 9980,
 -1,
 1412668118,
 127911,
 1412846653,
 1406675630,
 -1,
 1412912187,
 1412798318,
 -1,
 1412977722,
 1412860818,
 -1,
 -43975,
 1412931465,
 1479,
 -1,
 1412979135,
 1466,
 -1,
 1412941947,
 1478,
 -43972,
 1412857008,
 1477,
 -1,
 1413159489,
 1442,
 1413370944,
 1412787911,
 -1,
 -43969,
 1413316346,
 9937,
 -1,
 1413373550,
 128641,
 -1,
 1413325685,
 127807,
 1413633130,
 1400408490,
 -1,
 1413698644,
 1413587201,
 -1,
 1413764176,
 1413638656,
 -1,
 1413829708,
 1413724699,
 -1,
 1413895243,
 1413749188,
 -1,
 1413960778,
 1413859217,
 983059,
 1414070271,
 1413873664,
 -1,
 -43959,
 1413993648,
 983140,
 -1,
 1414049815,
 983137,
 -1,
 1413874647,
 11134,
 -1,
 1413849528,
 128677,
 1414353999,
 1413753060,
 -1,
 -43954,
 1414302329,
 11203,
 -1,
 1414354865,
 11043,
 -1,
 1414298561,
 9897,
 1414660095,
 1413721911,
 128014,
 1414725631,
 1414529024,
 -1,
 -43949,
 1414635926,
 127943,
 -1,
 1414679056,
 128052,
 1414878298,
 1413661898,
 -1,
 1414943833,
 1414836026,
 -1,
 1415009368,
 1414867709,
 127968,
 -1,
 1414966668,
 127960,
 -1,
 1414976676,
 127969,
 -1,
 1414899303,
 9203,
 1415271520,
 1414838811,
 -1,
 1415337055,
 1415184384,
 -1,
 -43939,
 1415289403,
 127798,
 -43938,
 1415330233,
 127789,
 -1,
 1415391281,
 9749,
 -1,
 1415266995,
 127976,
 1415664740,
 1415212743,
 -1,
 1415730275,
 1415608664,
 128616,
 -1,
 1415644020,
 128617,
 -1,
 1415659068,
 128371,
 1415926887,
 1415611722,
 -1,
 -43930,
 1415849816,
 128029,
 -1,
 1415907383,
 127855,
 -43928,
 1415886337,
 127973,
 -43927,
 1416075118,
 983123,
 -1,
 1416113874,
 128298,
 1416320126,
 1413569745,
 -1,
 1416385651,
 1416274373,
 -1,
 1416451186,
 1416308839,
 -1,
 -43922,
 1416414410,
 983968,
 -43921,
 1416464810,
 983970,
 -43920,
 1416518865,
 983967,
 -43919,
 1416576572,
 983969,
 -1,
 1416632559,
 983966,
 -1,
 1416372611,
 110593,
 1416909948,
 1416319357,
 -1,
 1416975480,
 1416826402,
 -1,
 1417041015,
 1416934857,
 128644,
 -1,
 1416956681,
 128645,
 -1,
 1416976169,
 128096,
 1417281535,
 1416888320,
 -1,
 -43910,
 1417203729,
 9889,
 -43909,
 1417251457,
 983122,
 -1,
 1417292468,
 128262,
 -43907,
 1416869828,
 9964,
 -1,
 1417423043,
 127802,
 1417630850,
 1416283338,
 -1,
 -43904,
 1417589005,
 128559,
 -43903,
 1417643077,
 128175,
 -1,
 1417695565,
 129303,
 1417892997,
 1417591323,
 983060,
 -43900,
 1417850252,
 983138,
 -1,
 1417898505,
 983141,
 1418089608,
 1417861847,
 -1,
 -43897,
 1418037942,
 11794,
 -1,
 1418090307,
 11802,
 -1,
 1418046848,
 8372,
 1418352137,
 1385931009,
 -1,
 1418417402,
 1418280508,
 -1,
 1418482874,
 1418357315,
 -1,
 1418548392,
 1418425564,
 -1,
 1418613910,
 1418494708,
 -1,
 1418679441,
 1418582227,
 -1,
 -43888,
 1418619431,
 43333,
 -1,
 1418664175,
 43323,
 1418876052,
 1418612536,
 -1,
 -43885,
 1418809223,
 43331,
 -1,
 1418860783,
 43314,
 -43883,
 1418802795,
 43332,
 -1,
 1418991855,
 43317,
 1419203737,
 1418558143,
 -1,
 -43880,
 1419126247,
 43330,
 -1,
 1419188463,
 43320,
 -43878,
 1419172140,
 43327,
 -43877,
 1419366732,
 43328,
 -43876,
 1419426461,
 43315,
 -43875,
 1419488799,
 43324,
 -43874,
 1419551099,
 43325,
 -43873,
 1419614172,
 43318,
 -43872,
 1419669253,
 43326,
 -43871,
 1419733895,
 43312,
 -43870,
 1419799079,
 43322,
 -43869,
 1419859000,
 43329,
 -43868,
 1419923335,
 43313,
 -43867,
 1419982443,
 43316,
 -43866,
 1420045232,
 43321,
 -43865,
 1420109287,
 43319,
 -1,
 1420171503,
 43334,
 1420383412,
 1418513530,
 -1,
 1420448947,
 1420334830,
 -1,
 1420514477,
 1420377660,
 43337,
 -43860,
 1420477642,
 43341,
 -1,
 1420499183,
 43342,
 1420711088,
 1420433647,
 -1,
 -43857,
 1420674250,
 43340,
 -1,
 1420713169,
 43338,
 -43855,
 1420674250,
 43336,
 -43854,
 1420855722,
 43339,
 -1,
 1420909777,
 43335,
 -1,
 1420388013,
 43347,
 1421169849,
 1420309076,
 -1,
 1421235383,
 1421116148,
 43344,
 -1,
 1421168440,
 43343,
 -43848,
 1421189377,
 43345,
 -1,
 1421300770,
 43346,
 -1,
 1421127517,
 43359,
 1421563093,
 1418416708,
 -1,
 -43844,
 1421531951,
 127487,
 -43843,
 1421596883,
 127486,
 -43842,
 1421662173,
 127485,
 -43841,
 1421725964,
 127484,
 -43840,
 1421790330,
 127483,
 -43839,
 1421853898,
 127482,
 -43838,
 1421916699,
 127481,
 -43837,
 1421979020,
 127480,
 -43836,
 1422041345,
 127479,
 -43835,
 1422106443,
 127478,
 -43834,
 1422169966,
 127477,
 -43833,
 1422231978,
 127476,
 -43832,
 1422295796,
 127475,
 -43831,
 1422359231,
 127474,
 -43830,
 1422421703,
 127473,
 -43829,
 1422486325,
 127472,
 -43828,
 1422551561,
 127471,
 -43827,
 1422613713,
 127470,
 -43826,
 1422677026,
 127469,
 -43825,
 1422741304,
 127468,
 -43824,
 1422805432,
 127467,
 -43823,
 1422868028,
 127466,
 -43822,
 1422931421,
 127465,
 -43821,
 1422994306,
 127464,
 -43820,
 1423058354,
 127463,
 -1,
 1423120623,
 127462,
 1423332588,
 1421528186,
 -1,
 1423398123,
 1423263312,
 -1,
 1423463649,
 1423324639,
 -1,
 1423529179,
 1423425130,
 -1,
 -43814,
 1423493546,
 128402,
 -1,
 1423523003,
 128403,
 -43812,
 1423494977,
 128404,
 -43811,
 1423680013,
 128401,
 -43810,
 1423745199,
 11822,
 -43809,
 1423791505,
 128405,
 -43808,
 1423854874,
 11793,
 -1,
 1423913400,
 11841,
 1424162815,
 1423376384,
 -1,
 1424184549,
 1424080640,
 -1,
 -43804,
 1424140519,
 11079,
 -1,
 1424192472,
 11073,
 1424381160,
 1424127419,
 -1,
 -43801,
 1424327776,
 983151,
 -1,
 1424380375,
 128968,
 -43799,
 1424340292,
 10184,
 -43798,
 1424515590,
 983152,
 -1,
 1424567893,
 128639,
 -1,
 1423346862,
 128158,
 1424839921,
 1423292368,
 -1,
 1424905456,
 1424776822,
 -1,
 -43793,
 1424822736,
 9953,
 -1,
 1424887973,
 9952,
 -1,
 1424854901,
 128699,
 1425167604,
 1424802662,
 -1,
 -43789,
 1425123142,
 11153,
 -1,
 1425175165,
 11152,
 1425364215,
 1425091458,
 -1,
 -43786,
 1425318970,
 128665,
 -1,
 1425379653,
 983112,
 -43784,
 1425309777,
 127895,
 -43783,
 1425503729,
 128524,
 -1,
 1425552866,
 127822,
 1425757557,
 1418353873,
 983153,
 1425823072,
 1425691072,
 -1,
 1425888573,
 1425789351,
 -1,
 1425954069,
 1425848859,
 -1,
 1426019603,
 1425909437,
 -1,
 1426085138,
 1425936010,
 -1,
 1426150672,
 1426006651,
 11106,
 1426259967,
 1426063360,
 -1,
 1426281742,
 1426183300,
 -1,
 1426347270,
 1426225295,
 -1,
 -43771,
 1426311786,
 11173,
 -1,
 1426341094,
 11175,
 1426543881,
 1426275087,
 -1,
 -43768,
 1426509471,
 983234,
 -1,
 1426545282,
 11132,
 -43766,
 1426509538,
 129074,
 -43765,
 1426686873,
 129058,
 -43764,
 1426750999,
 129062,
 -43763,
 1426806520,
 129070,
 -1,
 1426860507,
 129066,
 -43761,
 1426243603,
 11122,
 -1,
 1427019186,
 11138,
 -43759,
 1426102310,
 11142,
 -1,
 1427126025,
 11116,
 -1,
 1425998125,
 129170,
 -43756,
 1425987293,
 11246,
 -1,
 1427345361,
 129187,
 1427526951,
 1425875585,
 -1,
 1427592481,
 1427494020,
 -1,
 1427658010,
 1427554232,
 -1,
 -43751,
 1427622506,
 11023,
 -1,
 1427651814,
 11022,
 1427854621,
 1427616720,
 -1,
 -43748,
 1427816856,
 129026,
 -1,
 1427850604,
 129042,
 -43746,
 1427801989,
 129178,
 -43745,
 1427996210,
 129030,
 -43744,
 1428058215,
 129034,
 -1,
 1428112748,
 129046,
 1428313380,
 1427553825,
 -1,
 -43741,
 1428273461,
 11076,
 -1,
 1428312943,
 11075,
 1428553727,
 1428232750,
 -1,
 -43738,
 1428471537,
 11084,
 -1,
 1428495991,
 11080,
 1428706605,
 1427449266,
 -1,
 1428772139,
 1428647733,
 -1,
 -43734,
 1428697021,
 11146,
 -1,
 1428759163,
 11157,
 -43732,
 1428722444,
 129185,
 -1,
 1428888217,
 129193,
 1429099824,
 1428663692,
 -1,
 -43729,
 1429053477,
 129082,
 -1,
 1429086307,
 129106,
 1429296435,
 1429053697,
 -1,
 -43726,
 1429244519,
 128622,
 -1,
 1429299222,
 129189,
 1429493046,
 1429231328,
 -1,
 -43723,
 1429418498,
 129090,
 -1,
 1429480059,
 129094,
 1429689657,
 1429424568,
 -1,
 -43720,
 1429646238,
 129195,
 -1,
 1429693438,
 129078,
 -43718,
 1429656384,
 129174,
 -43717,
 1429839826,
 11078,
 -43716,
 1429894004,
 129191,
 -1,
 1429942786,
 129086,
 1430148439,
 1425801216,
 -1,
 1430213960,
 1430105484,
 -1,
 1430279493,
 1430165869,
 -1,
 1430345028,
 1430199701,
 128360,
 1430454271,
 1430260482,
 -1,
 -43709,
 1430371843,
 128362,
 -1,
 1430425113,
 128361,
 -1,
 1430274125,
 128489,
 -43706,
 1430242960,
 11779,
 -43705,
 1430609632,
 11815,
 -1,
 1430654758,
 10182,
 1430869325,
 1430134753,
 -1,
 1430934860,
 1430811058,
 -1,
 -43701,
 1430894857,
 11776,
 -1,
 1430928109,
 11777,
 -1,
 1430865298,
 128495,
 1431197008,
 1430829595,
 -1,
 -43697,
 1431151332,
 11786,
 -1,
 1431198446,
 128493,
 1431393619,
 1431124397,
 -1,
 -43694,
 1431356958,
 11817,
 -1,
 1431421650,
 11781,
 -43692,
 1431359060,
 11809,
 -43691,
 1431544397,
 11789,
 -43690,
 1431599425,
 11805,
 -1,
 1431655801,
 128381,
 1431896063,
 1430064674,
 -1,
 1431917917,
 1431783968,
 -1,
 1431983451,
 1431878004,
 4053,
 -1,
 1431899106,
 4055,
 -43684,
 1431915490,
 129308,
 -1,
 1432035884,
 1421,
 -43682,
 1431879706,
 8295,
 -43681,
 1432198353,
 128270,
 -1,
 1432245682,
 9957,
 1432442222,
 1425745709,
 127872,
 1432551423,
 1432355067,
 -1,
 1432573285,
 1432471836,
 -1,
 -43676,
 1432528710,
 11187,
 -1,
 1432580733,
 11186,
 1432769896,
 1432528716,
 -1,
 -43673,
 1432733977,
 11189,
 -1,
 1432763457,
 11191,
 1432966507,
 1432711810,
 -1,
 -43670,
 1432930585,
 11188,
 -1,
 1432960065,
 11190,
 1433206783,
 1432894534,
 -1,
 -43667,
 1433118534,
 11185,
 -1,
 1433170557,
 11184,
 1433359729,
 1432388968,
 128141,
 -43664,
 1433297633,
 128365,
 -1,
 1433339919,
 11824,
 1433556340,
 1433283932,
 -1,
 -43661,
 1433482093,
 127832,
 -1,
 1433544258,
 127833,
 -1,
 1433488470,
 129350,
 1433818553,
 1425720522,
 -1,
 1433884072,
 1433763619,
 -1,
 1433949589,
 1433831648,
 -1,
 1434015104,
 1433909787,
 -1,
 1434080636,
 1433981196,
 -1,
 -43653,
 1434028466,
 69235,
 -1,
 1434076372,
 69226,
 1434277247,
 1434014754,
 -1,
 -43650,
 1434232052,
 69236,
 -1,
 1434281793,
 69227,
 -1,
 1434207076,
 69225,
 1434539399,
 1433972108,
 -1,
 1434604932,
 1434478979,
 -1,
 -43645,
 1434567859,
 69230,
 -1,
 1434583899,
 69239,
 1434845183,
 1434535903,
 -1,
 -43642,
 1434764467,
 69231,
 -1,
 1434780507,
 69240,
 1434998158,
 1434470840,
 -1,
 1435063691,
 1434945962,
 -1,
 -43638,
 1435028168,
 69237,
 -1,
 1435086068,
 69228,
 1435303935,
 1435000017,
 -1,
 -43635,
 1435225460,
 69238,
 -1,
 1435258655,
 69229,
 1435456913,
 1434945072,
 -1,
 -43632,
 1435419827,
 69233,
 -1,
 1435435867,
 69242,
 1435653524,
 1435386421,
 -1,
 -43629,
 1435621587,
 69232,
 -1,
 1435632475,
 69241,
 -1,
 1435602393,
 69234,
 1435915682,
 1433876700,
 -1,
 1435981209,
 1435875867,
 -1,
 -43624,
 1435948554,
 69217,
 -1,
 1435982656,
 69218,
 1436177820,
 1435938188,
 -1,
 -43621,
 1436117379,
 69221,
 -1,
 1436174303,
 69222,
 1436374431,
 1436109240,
 -1,
 -43618,
 1436324804,
 69219,
 -1,
 1436379345,
 69220,
 -43616,
 1436323252,
 69216,
 -43615,
 1436517936,
 69224,
 -1,
 1436566069,
 69223,
 1436811263,
 1435848269,
 -1,
 1436833191,
 1436716472,
 -1,
 -43611,
 1436794210,
 69245,
 -43610,
 1436852274,
 69244,
 -1,
 1436898503,
 69243,
 -1,
 1436796072,
 69246,
 1437160887,
 1433830132,
 -1,
 1437226420,
 1437097492,
 -1,
 1437291953,
 1437159022,
 -1,
 1437357486,
 1437210863,
 -1,
 -43603,
 1437288084,
 5880,
 -1,
 1437346690,
 5879,
 -43601,
 1437307439,
 5876,
 -43600,
 1437493062,
 5877,
 -1,
 1437549032,
 5878,
 -43598,
 1437249590,
 5874,
 -43597,
 1437699897,
 5875,
 -1,
 1437756213,
 5873,
 1437990911,
 1437172468,
 -1,
 -43594,
 1437885374,
 127933,
 -1,
 1437943170,
 127939,
 -43592,
 1437094061,
 127945,
 -1,
 1438066974,
 8381,
 1438275043,
 1433766314,
 -1,
 1438340561,
 1438219335,
 -1,
 1438406083,
 1438297484,
 -1,
 1438471618,
 1438334524,
 -1,
 1438537152,
 1438439576,
 -1,
 -43585,
 1438500738,
 65939,
 -1,
 1438523482,
 65936,
 -43583,
 1438496610,
 65944,
 -1,
 1438679682,
 65938,
 -1,
 1438408966,
 65941,
 1438930377,
 1438353669,
 -1,
 1438995911,
 1438862121,
 -1,
 -43578,
 1438956949,
 8583,
 -1,
 1438990199,
 8582,
 -43576,
 1438954341,
 8581,
 -1,
 1439141349,
 8584,
 1439323597,
 1438856669,
 -1,
 -43573,
 1439287795,
 65945,
 -43572,
 1439326548,
 65940,
 -1,
 1439384511,
 65942,
 -43570,
 1439287380,
 65937,
 -43569,
 1439539420,
 65943,
 -43568,
 1439575474,
 65947,
 -1,
 1439638297,
 65946,
 1439847894,
 1438283635,
 -1,
 1439913429,
 1439776316,
 -1,
 -43564,
 1439867150,
 127906,
 -1,
 1439905361,
 128478,
 -1,
 1439851402,
 129315,
 1440175577,
 1439811730,
 -1,
 -43560,
 1440136056,
 128907,
 -1,
 1440194332,
 128205,
 1440372188,
 1440136063,
 -1,
 -43557,
 1440338801,
 11215,
 -1,
 1440380507,
 11213,
 1440568798,
 1440329527,
 127801,
 -1,
 1440531144,
 127989,
 -43553,
 1440535127,
 128675,
 -43552,
 1440649809,
 128019,
 -43551,
 1440690296,
 128640,
 -43550,
 1440754168,
 129302,
 -1,
 1440818070,
 127840,
 1441027586,
 1438193903,
 -1,
 1441093113,
 1440963793,
 -1,
 1441158644,
 1441050487,
 -1,
 1441224170,
 1441092957,
 9995,
 1441333247,
 1441139458,
 -1,
 -43543,
 1441241372,
 128406,
 -1,
 1441287069,
 128400,
 1441486317,
 1441168063,
 -1,
 -43540,
 1441412682,
 127339,
 -1,
 1441475480,
 127338,
 1441682927,
 1441413614,
 11827,
 -1,
 1441643499,
 11783,
 -43536,
 1441642015,
 11787,
 -43535,
 1441752335,
 11782,
 -43534,
 1441811426,
 9994,
 -43533,
 1441870264,
 11828,
 -1,
 1441932789,
 129306,
 1442141686,
 1441104628,
 9926,
 -1,
 1442064967,
 127752,
 1442316287,
 1442085542,
 -1,
 -43528,
 1442234638,
 128740,
 -1,
 1442262194,
 128643,
 1442469371,
 1441020179,
 128251,
 -1,
 1442382238,
 128280,
 1442600446,
 1442393929,
 -1,
 -43523,
 1442546094,
 127949,
 -1,
 1442589874,
 127950,
 1442797056,
 1442522920,
 128007,
 -1,
 1442710236,
 128048,
 -43519,
 1442757147,
 128000,
 -1,
 1442871999,
 128015,
 1443059207,
 1440968391,
 -1,
 -43516,
 1443006890,
 983222,
 -43515,
 1443068607,
 983217,
 -43514,
 1443126481,
 983227,
 -1,
 1443184188,
 983219,
 -43512,
 1443016076,
 983113,
 -1,
 1443322099,
 129423,
 1443518260,
 1418318092,
 -1,
 1443583630,
 1443436783,
 -1,
 1443649146,
 1443537153,
 -1,
 1443714681,
 1443569642,
 -1,
 1443780149,
 1443673166,
 -1,
 1443845651,
 1443748051,
 -1,
 1443911185,
 1443808458,
 71875,
 -1,
 1443850761,
 71886,
 -43502,
 1443858858,
 71877,
 -1,
 1443961071,
 71876,
 1444173337,
 1443779618,
 -1,
 1444238871,
 1444121002,
 -1,
 -43498,
 1444195410,
 71899,
 -1,
 1444247591,
 71898,
 -43496,
 1444178428,
 71897,
 -1,
 1444356382,
 71900,
 1444566557,
 1444092143,
 71873,
 -43493,
 1444526619,
 71893,
 -43492,
 1444578664,
 71882,
 -1,
 1444641471,
 71894,
 1444828705,
 1444494908,
 71880,
 1444937727,
 1444774644,
 -1,
 -43488,
 1444862163,
 71885,
 -1,
 1444905716,
 71888,
 1445090852,
 1444791498,
 -1,
 -43485,
 1445053642,
 71879,
 -1,
 1445079938,
 71887,
 1445287463,
 1445047692,
 -1,
 -43482,
 1445247336,
 71901,
 -1,
 1445290144,
 71902,
 1445484073,
 1445235114,
 71881,
 -1,
 1445410598,
 71889,
 1445615148,
 1445430004,
 -1,
 -43477,
 1445578933,
 71891,
 -1,
 1445613450,
 71872,
 -43475,
 1445581834,
 71874,
 -43474,
 1445777308,
 71903,
 -43473,
 1445839560,
 71890,
 -43472,
 1445895831,
 71896,
 -43471,
 1445948909,
 71884,
 -43470,
 1446011040,
 71878,
 -43469,
 1446072199,
 71883,
 -43468,
 1446131307,
 71892,
 -1,
 1446193898,
 71895,
 1446401629,
 1443703954,
 -1,
 1446467131,
 1446369491,
 -1,
 1446532665,
 1446429898,
 71843,
 -1,
 1446472201,
 71854,
 -43462,
 1446480298,
 71845,
 -1,
 1446582511,
 71844,
 1446794817,
 1446401058,
 -1,
 1446860351,
 1446742442,
 -1,
 -43458,
 1446816850,
 71867,
 -1,
 1446869031,
 71866,
 -43456,
 1446799868,
 71865,
 -1,
 1446977822,
 71868,
 1447188037,
 1446713583,
 71841,
 -43453,
 1447148059,
 71861,
 -43452,
 1447200104,
 71850,
 -1,
 1447262911,
 71862,
 1447450185,
 1447116348,
 71848,
 1447559167,
 1447396084,
 -1,
 -43448,
 1447483603,
 71853,
 -1,
 1447527156,
 71856,
 1447712332,
 1447412938,
 -1,
 -43445,
 1447675082,
 71847,
 -1,
 1447701378,
 71855,
 1447908943,
 1447669132,
 -1,
 -43442,
 1447868776,
 71869,
 -1,
 1447911584,
 71870,
 1448105553,
 1447856554,
 71849,
 -1,
 1448032038,
 71857,
 1448236628,
 1448051444,
 -1,
 -43437,
 1448200373,
 71859,
 -1,
 1448234890,
 71840,
 -43435,
 1448203274,
 71842,
 -43434,
 1448398748,
 71871,
 -43433,
 1448461000,
 71858,
 -43432,
 1448517271,
 71864,
 -43431,
 1448570349,
 71852,
 -43430,
 1448632480,
 71846,
 -43429,
 1448693639,
 71851,
 -43428,
 1448752747,
 71860,
 -1,
 1448815338,
 71863,
 1449023083,
 1446328540,
 -1,
 1449088609,
 1448983067,
 -1,
 -43424,
 1449055754,
 71906,
 -1,
 1449089856,
 71907,
 1449285220,
 1449045388,
 -1,
 -43421,
 1449224579,
 71910,
 -1,
 1449281503,
 71911,
 1449481831,
 1449216440,
 -1,
 -43418,
 1449432004,
 71908,
 -1,
 1449486545,
 71909,
 -43416,
 1449450481,
 71904,
 -43415,
 1449627060,
 71905,
 -43414,
 1449690672,
 71913,
 -1,
 1449738805,
 71912,
 1449940600,
 1448970464,
 -1,
 1450006128,
 1449900571,
 -1,
 -43410,
 1449972383,
 71915,
 -43409,
 1450006809,
 71916,
 -1,
 1450066788,
 71914,
 1450268275,
 1449962892,
 -1,
 -43406,
 1450207684,
 71919,
 -1,
 1450264608,
 71920,
 1450464886,
 1450199480,
 -1,
 -43403,
 1450414613,
 71917,
 -1,
 1450467135,
 71918,
 -43401,
 1450411607,
 71922,
 -1,
 1450590856,
 71921,
 -1,
 1449888956,
 71935,
 -1,
 1443661436,
 9888,
 1450923649,
 1443609711,
 -1,
 1450989184,
 1450835968,
 -1,
 -43395,
 1450955287,
 127754,
 -43394,
 1451007252,
 129341,
 -43393,
 1451045121,
 128702,
 -1,
 1451109109,
 128003,
 -1,
 1450933903,
 127817,
 1451382407,
 1450888314,
 -1,
 1451447942,
 1451320028,
 -1,
 -43388,
 1451414374,
 127987,
 -43387,
 1451447663,
 128075,
 -1,
 1451501828,
 127988,
 -1,
 1451376201,
 11071,
 1451775626,
 1451350143,
 -1,
 -43383,
 1451708958,
 127764,
 -1,
 1451766695,
 127762,
 1451972237,
 1451722334,
 -1,
 -43380,
 1451905566,
 127766,
 -1,
 1451963303,
 127768,
 -1,
 1451931453,
 128465,
 1452234458,
 1443517474,
 -1,
 1452299992,
 1452173417,
 -1,
 1452365470,
 1452256652,
 -1,
 1452430998,
 1452329001,
 127779,
 1452539903,
 1452343296,
 -1,
 1452562069,
 1452418939,
 127781,
 -1,
 1452477793,
 127782,
 -1,
 1452528951,
 127780,
 1452758683,
 1452384279,
 -1,
 1452824218,
 1452683968,
 -1,
 -43367,
 1452789510,
 128916,
 -1,
 1452834340,
 128917,
 -1,
 1452747606,
 128307,
 1453129727,
 1452702691,
 -1,
 -43363,
 1453045531,
 11090,
 -1,
 1453095382,
 11051,
 1453282986,
 1452291549,
 -1,
 1453348516,
 1453219227,
 -1,
 1453414051,
 1453273792,
 -1,
 -43358,
 1453379315,
 128922,
 -1,
 1453424136,
 128923,
 -1,
 1453351318,
 9931,
 1453676199,
 1453302597,
 -1,
 -43354,
 1453620291,
 9920,
 -1,
 1453682047,
 9921,
 1453916159,
 1453627138,
 -1,
 -43351,
 1453814479,
 128407,
 -1,
 1453860354,
 128071,
 1454069426,
 1453223623,
 -1,
 1454134958,
 1453998476,
 -1,
 -43347,
 1454087308,
 128072,
 -1,
 1454141451,
 9945,
 1454331569,
 1454053615,
 -1,
 -43344,
 1454292881,
 128326,
 -1,
 1454351964,
 11036,
 -1,
 1454282568,
 128928,
 1454593720,
 1454029339,
 -1,
 1454659254,
 1454547201,
 -1,
 -43339,
 1454595544,
 10177,
 -1,
 1454645443,
 9186,
 -43337,
 1454626566,
 9943,
 -1,
 1454805895,
 128382,
 1454986942,
 1454527522,
 -1,
 1455052476,
 1454915132,
 -1,
 -43333,
 1455020035,
 11041,
 -1,
 1455039821,
 9989,
 -43331,
 1455001995,
 11053,
 -1,
 1455169938,
 128427,
 1455380164,
 1454918072,
 -1,
 1455445699,
 1455320775,
 -1,
 1455511234,
 1455365173,
 9872,
 -1,
 1455426708,
 9983,
 -1,
 1455462137,
 128174,
 -1,
 1455395888,
 11214,
 1455773384,
 1455324654,
 -1,
 -43322,
 1455732507,
 11088,
 -43321,
 1455782358,
 11048,
 -1,
 1455831201,
 11046,
 1456035531,
 1455738354,
 -1,
 -43318,
 1456003334,
 11038,
 -1,
 1456062109,
 11055,
 1456232142,
 1455990598,
 -1,
 -43315,
 1456148243,
 11092,
 -1,
 1456211990,
 128073,
 1456428753,
 1456183751,
 -1,
 -43312,
 1456388830,
 11040,
 -1,
 1456440204,
 127985,
 1456625364,
 1456349840,
 -1,
 -43309,
 1456587944,
 129197,
 -1,
 1456639412,
 129196,
 -43307,
 1456589168,
 128070,
 -43306,
 1456775357,
 10068,
 -43305,
 1456818380,
 10069,
 -1,
 1456877398,
 128906,
 -43303,
 1452228883,
 9855,
 -1,
 1457004016,
 128011,
 1457215255,
 1452170449,
 -1,
 1457280782,
 1457141580,
 -1,
 1457346281,
 1457239415,
 -1,
 1457411811,
 1457312452,
 -1,
 -43297,
 1457376972,
 129159,
 -43296,
 1457421814,
 129143,
 -43295,
 1457485347,
 129127,
 -43294,
 1457542887,
 129151,
 -1,
 1457596084,
 129135,
 1457848319,
 1457340325,
 -1,
 -43291,
 1457770188,
 129158,
 -43290,
 1457815030,
 129142,
 -43289,
 1457878563,
 129126,
 -43288,
 1457936103,
 129150,
 -1,
 1457989300,
 129134,
 1458198262,
 1457293156,
 -1,
 1458263792,
 1458164420,
 -1,
 -43284,
 1458228940,
 129156,
 -43283,
 1458273782,
 129140,
 -43282,
 1458337315,
 129124,
 -43281,
 1458394855,
 129148,
 -1,
 1458448052,
 129132,
 1458700287,
 1458192293,
 -1,
 -43278,
 1458622156,
 129157,
 -43277,
 1458666998,
 129141,
 -43276,
 1458730531,
 129125,
 -43275,
 1458788071,
 129149,
 -1,
 1458841268,
 129133,
 1459050236,
 1458162290,
 -1,
 -43272,
 1459015372,
 129153,
 -43271,
 1459060214,
 129137,
 -43270,
 1459123747,
 129121,
 -43269,
 1459181287,
 129145,
 -1,
 1459234484,
 129129,
 1459443458,
 1459005643,
 -1,
 -43266,
 1459408588,
 129154,
 -43265,
 1459453430,
 129138,
 -43264,
 1459516963,
 129122,
 -43263,
 1459574503,
 129146,
 -1,
 1459627700,
 129130,
 1459836680,
 1459385278,
 -1,
 -43260,
 1459801804,
 129152,
 -43259,
 1459846646,
 129136,
 -43258,
 1459910179,
 129120,
 -43257,
 1459967719,
 129144,
 -1,
 1460020916,
 129128,
 1460273151,
 1459764464,
 -1,
 -43254,
 1460195020,
 129155,
 -43253,
 1460239862,
 129139,
 -43252,
 1460303395,
 129123,
 -43251,
 1460360935,
 129147,
 -1,
 1460414132,
 129131,
 1460623124,
 1457226484,
 -1,
 1460688658,
 1460549087,
 -1,
 -43247,
 1460612793,
 127888,
 -1,
 1460676973,
 127788,
 -43245,
 1460628868,
 128521,
 -1,
 1460813453,
 127863,
 -43243,
 1460577483,
 128430,
 -43242,
 1460959753,
 129344,
 -1,
 1461014879,
 11838,
 1461212966,
 1457162666,
 -1,
 1461278497,
 1461156543,
 -1,
 1461344032,
 1461198621,
 128105,
 1461409567,
 1461300622,
 -1,
 -43236,
 1461366437,
 128097,
 -43235,
 1461409360,
 128082,
 -43234,
 1461465388,
 128090,
 -1,
 1461529074,
 128098,
 -1,
 1461324571,
 128111,
 -1,
 1461273701,
 128698,
 1461868325,
 1461231873,
 -1,
 -43229,
 1461823240,
 128543,
 -43228,
 1461875038,
 128506,
 -1,
 1461925427,
 11825,
 -1,
 1461810567,
 128058,
 1462196014,
 1461141052,
 -1,
 1462261546,
 1462131921,
 -1,
 -43223,
 1462194678,
 127947,
 -1,
 1462257237,
 983230,
 1462458157,
 1462182637,
 -1,
 -43220,
 1462389264,
 128553,
 -1,
 1462447330,
 128576,
 -1,
 1462384439,
 128146,
 1462720307,
 1462149377,
 -1,
 1462785842,
 1462648380,
 -1,
 -43215,
 1462744987,
 129340,
 -1,
 1462797280,
 128295,
 -1,
 1462706406,
 127873,
 -1,
 1462659593,
 983225,
 1463113679,
 1443454161,
 -1,
 1463179168,
 1463059188,
 -1,
 1463244675,
 1463136040,
 -1,
 1463310175,
 1463200970,
 -1,
 1463375699,
 1463252188,
 -1,
 1463441214,
 1463332236,
 -1,
 1463506749,
 1463359727,
 -1,
 -43204,
 1463451260,
 68430,
 -1,
 1463498808,
 68433,
 -1,
 1463441613,
 68436,
 1463768897,
 1463400987,
 -1,
 -43200,
 1463699200,
 68424,
 -1,
 1463756124,
 68437,
 1463965507,
 1463703169,
 68420,
 -1,
 1463925969,
 68423,
 1464096582,
 1463884015,
 -1,
 -43195,
 1464064547,
 68431,
 -1,
 1464104109,
 68416,
 -43193,
 1464064964,
 68422,
 -43192,
 1464261298,
 68425,
 -43191,
 1464324653,
 68421,
 -43190,
 1464378827,
 68435,
 -43189,
 1464442812,
 68434,
 -43188,
 1464506733,
 68432,
 -43187,
 1464568092,
 68429,
 -43186,
 1464630933,
 68428,
 -43185,
 1464692722,
 68427,
 -43184,
 1464757242,
 68426,
 -43183,
 1464816190,
 68418,
 -43182,
 1464874685,
 68419,
 -1,
 1464936421,
 68417,
 1465188351,
 1463322848,
 -1,
 1465210714,
 1465104923,
 -1,
 1465276248,
 1465176332,
 -1,
 -43177,
 1465223594,
 68441,
 -1,
 1465271508,
 68445,
 -43175,
 1465211712,
 68442,
 -1,
 1465402212,
 68444,
 1465603934,
 1465159092,
 68440,
 1465712639,
 1465516032,
 -1,
 -43171,
 1465630101,
 68447,
 -1,
 1465670743,
 68446,
 -1,
 1465535872,
 68443,
 1465974783,
 1463245164,
 -1,
 1465997175,
 1465873628,
 -1,
 1466062694,
 1465953676,
 -1,
 1466128229,
 1465981167,
 -1,
 -43164,
 1466072700,
 68462,
 -1,
 1466120248,
 68464,
 -1,
 1466063053,
 68465,
 1466390377,
 1466022427,
 -1,
 -43160,
 1466320640,
 68456,
 -1,
 1466377564,
 68466,
 1466586987,
 1466324609,
 68452,
 -1,
 1466547409,
 68455,
 -43156,
 1466555332,
 68454,
 -43155,
 1466686130,
 68457,
 -43154,
 1466749499,
 68453,
 -43153,
 1466800493,
 68463,
 -43152,
 1466861852,
 68461,
 -43151,
 1466924697,
 68460,
 -43150,
 1466986482,
 68459,
 -43149,
 1467051002,
 68458,
 -43148,
 1467109950,
 68450,
 -43147,
 1467168445,
 68451,
 -43146,
 1467230181,
 68449,
 -1,
 1467293195,
 68448,
 1467547647,
 1465944288,
 -1,
 1467570046,
 1467464219,
 -1,
 1467635580,
 1467535628,
 -1,
 -43141,
 1467582890,
 68473,
 -1,
 1467630804,
 68477,
 -43139,
 1467571008,
 68474,
 -1,
 1467761508,
 68476,
 1467963266,
 1467518388,
 68472,
 1468071935,
 1467875328,
 -1,
 -43135,
 1467989397,
 68479,
 -1,
 1468030039,
 68478,
 -1,
 1467895168,
 68475,
 1468290954,
 1463197488,
 -1,
 1468356488,
 1468231883,
 -1,
 -43130,
 1468314731,
 128289,
 -43129,
 1468364111,
 128292,
 -1,
 1468411042,
 128288,
 -43127,
 1468316167,
 128291,
 -1,
 1468565757,
 128290,
 1468749714,
 1468222765,
 -1,
 1468815249,
 1468706763,
 -1,
 1468880783,
 1468774939,
 -1,
 -43122,
 1468847626,
 983111,
 -1,
 1468881728,
 983108,
 -43120,
 1468829108,
 983114,
 -1,
 1469009280,
 983105,
 -1,
 1468741635,
 128129,
 1469274008,
 1468714106,
 -1,
 1469339543,
 1469204080,
 -1,
 -43115,
 1469302948,
 8276,
 -43114,
 1469356577,
 9959,
 -1,
 1469408548,
 11800,
 -1,
 1469278078,
 8292,
 1469667227,
 1469199837,
 983129,
 -43110,
 1469603267,
 8377,
 -1,
 1469663404,
 983128,
 1469863838,
 1469590402,
 -1,
 -43107,
 1469817886,
 128474,
 -1,
 1469877529,
 128232,
 -43105,
 1469824115,
 9892,
 -1,
 1469983325,
 128229,
 1470191562,
 1463124438,
 128127,
 1470300159,
 1470121455,
 -1,
 1470322621,
 1470199004,
 -1,
 1470388136,
 1470279052,
 -1,
 1470453671,
 1470306543,
 -1,
 -43098,
 1470398076,
 67662,
 -1,
 1470445624,
 67665,
 -1,
 1470388429,
 67668,
 1470715819,
 1470347803,
 -1,
 -43094,
 1470646016,
 67656,
 -1,
 1470702940,
 67669,
 1470912429,
 1470649985,
 67652,
 -1,
 1470872785,
 67655,
 1471043504,
 1470830831,
 -1,
 -43089,
 1471011363,
 67663,
 -1,
 1471050925,
 67648,
 -43087,
 1471011780,
 67654,
 -43086,
 1471208114,
 67657,
 -43085,
 1471271469,
 67653,
 -43084,
 1471325643,
 67667,
 -43083,
 1471389628,
 67666,
 -43082,
 1471453549,
 67664,
 -43081,
 1471514908,
 67661,
 -43080,
 1471577749,
 67660,
 -43079,
 1471639538,
 67659,
 -43078,
 1471704058,
 67658,
 -43077,
 1471763006,
 67650,
 -43076,
 1471821501,
 67651,
 -1,
 1471883237,
 67649,
 1472092105,
 1470269664,
 -1,
 1472157637,
 1472051739,
 -1,
 1472223170,
 1472123148,
 -1,
 -43071,
 1472170410,
 67673,
 -1,
 1472218324,
 67676,
 1472419780,
 1472152420,
 67675,
 -1,
 1472334201,
 67679,
 -1,
 1472355136,
 67674,
 1472659455,
 1472105908,
 67672,
 1472724991,
 1472528384,
 -1,
 -43064,
 1472642453,
 67678,
 -1,
 1472683095,
 67677,
 -1,
 1472049002,
 67671,
 1472944078,
 1470115164,
 -1,
 -43060,
 1472902058,
 9976,
 -43059,
 1472944545,
 127954,
 -1,
 1473000316,
 127848,
 -1,
 1472912234,
 127982,
 1473271891,
 1463052809,
 -1,
 1473337422,
 1473190127,
 -1,
 1473402949,
 1473301685,
 -1,
 1473468426,
 1473343919,
 -1,
 1473533961,
 1473430252,
 -1,
 1473599452,
 1473479412,
 -1,
 1473664984,
 1473531783,
 43412,
 1473773567,
 1473578015,
 43402,
 -1,
 1473644643,
 43403,
 1473861594,
 1473632556,
 43418,
 -1,
 1473774777,
 43416,
 1474035711,
 1473779951,
 43428,
 -1,
 1473905849,
 43423,
 1474123745,
 1473559067,
 -1,
 1474189279,
 1474083485,
 43419,
 -1,
 1474102371,
 43420,
 1474363391,
 1474107631,
 43424,
 -1,
 1474233529,
 43425,
 1474451430,
 1474049501,
 -1,
 1474516964,
 1474377323,
 43421,
 -1,
 1474430051,
 43422,
 1474691071,
 1474435311,
 43426,
 -1,
 1474561123,
 43427,
 1474779114,
 1474407967,
 43441,
 1474887679,
 1474692176,
 -1,
 -43031,
 1474808581,
 43439,
 -1,
 1474829488,
 43440,
 1475041262,
 1474729948,
 43429,
 1475149823,
 1474953216,
 -1,
 -43027,
 1475052193,
 43430,
 -1,
 1475096027,
 43401,
 1475303410,
 1474980743,
 43407,
 1475411967,
 1475215360,
 -1,
 -43023,
 1475325660,
 43408,
 -1,
 1475379873,
 43409,
 1475565557,
 1475239121,
 43398,
 -43020,
 1475501265,
 43399,
 -1,
 1475544008,
 43397,
 1475762167,
 1475518843,
 43435,
 -1,
 1475674143,
 43436,
 1475893241,
 1475701287,
 43415,
 -1,
 1475806307,
 43417,
 1476024315,
 1475825543,
 43410,
 -1,
 1475937465,
 43411,
 1476155389,
 1475947440,
 43413,
 -1,
 1476068537,
 43414,
 1476286463,
 1476077031,
 43431,
 -1,
 1476199609,
 43432,
 1476417537,
 1476204783,
 43396,
 -1,
 1476353233,
 43405,
 -43006,
 1476385068,
 43434,
 -43005,
 1476514124,
 43438,
 -43004,
 1476576458,
 43400,
 -43003,
 1476626858,
 43406,
 -43002,
 1476688661,
 43433,
 -43001,
 1476751109,
 43437,
 -43000,
 1476809784,
 43442,
 -1,
 1476869692,
 43404,
 -1,
 1473466094,
 43457,
 1477138463,
 1473419228,
 -1,
 1477203996,
 1477064302,
 -1,
 1477269521,
 1477144263,
 -1,
 1477335056,
 1477231818,
 -1,
 -42993,
 1477281238,
 43465,
 -1,
 1477336211,
 43461,
 -1,
 1477272614,
 43464,
 1477597205,
 1477187823,
 -1,
 1477662740,
 1477523315,
 43466,
 -1,
 1477574681,
 43467,
 -1,
 1477608482,
 43459,
 1477859352,
 1477547886,
 -1,
 -42985,
 1477797718,
 43468,
 -1,
 1477845006,
 43463,
 -42983,
 1477825607,
 43462,
 -42982,
 1478016982,
 43486,
 -42981,
 1478064994,
 43460,
 -1,
 1478125405,
 43487,
 1478361087,
 1477150056,
 -1,
 -42978,
 1478271696,
 43471,
 -1,
 1478323719,
 43456,
 1478514733,
 1477064924,
 -1,
 1478580259,
 1478474267,
 -1,
 -42974,
 1478546954,
 43474,
 -1,
 1478581056,
 43475,
 1478776870,
 1478536588,
 -1,
 -42971,
 1478715779,
 43478,
 -1,
 1478772703,
 43479,
 1478973481,
 1478707640,
 -1,
 -42968,
 1478923204,
 43476,
 -1,
 1478977745,
 43477,
 -42966,
 1478941681,
 43472,
 -42965,
 1479118260,
 43473,
 -42964,
 1479181872,
 43481,
 -1,
 1479230005,
 43480,
 1479432249,
 1478480024,
 -1,
 1479497779,
 1479391771,
 -1,
 1479563314,
 1479416047,
 -1,
 -42959,
 1479519560,
 43444,
 -1,
 1479571177,
 43450,
 -1,
 1479511208,
 43445,
 1479825461,
 1479464917,
 43446,
 -1,
 1479738493,
 43447,
 1479956535,
 1479784745,
 43448,
 -1,
 1479869572,
 43449,
 -42952,
 1479907893,
 43452,
 -1,
 1480014139,
 43451,
 1480218687,
 1479389839,
 -1,
 1480284220,
 1480142202,
 43393,
 -1,
 1480198509,
 43443,
 -42947,
 1480250424,
 43395,
 -42946,
 1480366206,
 43392,
 -1,
 1480421674,
 43394,
 1480611907,
 1480143444,
 -1,
 -42943,
 1480563200,
 43454,
 -42942,
 1480617162,
 43453,
 -1,
 1480666090,
 43455,
 -42940,
 1480573861,
 43469,
 -1,
 1480828887,
 43458,
 1481005133,
 1473353838,
 -1,
 -42937,
 1480964583,
 128304,
 -42936,
 1481022819,
 127971,
 -42935,
 1481083740,
 128121,
 -42934,
 1481134783,
 128122,
 -42933,
 1481193956,
 127886,
 -42932,
 1481256155,
 127983,
 -1,
 1481320038,
 9979,
 -1,
 1480929365,
 127875,
 1481594961,
 1473299658,
 -1,
 -42928,
 1481541357,
 9909,
 -1,
 1481593176,
 129337,
 -42926,
 1481545525,
 128377,
 -1,
 1481719666,
 128086,
 1481922782,
 1473202616,
 -1,
 1481988221,
 1481840879,
 -1,
 1482053749,
 1481911170,
 -1,
 1482119283,
 1481981502,
 -1,
 1482184813,
 1482085503,
 -1,
 1482250348,
 1482096640,
 -1,
 1482315869,
 1482209488,
 128539,
 1482424319,
 1482227783,
 -1,
 -42916,
 1482347623,
 128540,
 -1,
 1482407624,
 128541,
 1482578017,
 1482262954,
 -1,
 1482643552,
 1482529253,
 128558,
 -1,
 1482555480,
 128560,
 -1,
 1482582842,
 128582,
 1482840164,
 1482537499,
 -1,
 -42909,
 1482774388,
 129298,
 -1,
 1482833794,
 128514,
 1483036775,
 1482764602,
 -1,
 -42906,
 1483002461,
 129312,
 -1,
 1483043203,
 128531,
 -42904,
 1482992493,
 128580,
 -42903,
 1483179760,
 128581,
 -42902,
 1483242970,
 128567,
 -42901,
 1483307165,
 128548,
 -1,
 1483364001,
 129301,
 -1,
 1482200241,
 128566,
 1483626608,
 1482141068,
 -1,
 -42897,
 1483551618,
 128561,
 -1,
 1483613484,
 128523,
 -42895,
 1483587124,
 128536,
 -42894,
 1483774034,
 129318,
 -1,
 1483832600,
 128134,
 -42892,
 1482080483,
 127981,
 -1,
 1483977429,
 8507,
 1484150904,
 1482020831,
 -1,
 -42889,
 1484094250,
 128224,
 -1,
 1484152425,
 128439,
 1484347515,
 1484093299,
 -1,
 -42886,
 1484284659,
 9950,
 -1,
 1484342123,
 127810,
 -42884,
 1484307765,
 127877,
 -1,
 1484488772,
 128106,
 1484675227,
 1481923793,
 -1,
 1484740746,
 1484628225,
 -1,
 1484806277,
 1484699359,
 -1,
 1484871811,
 1484759107,
 -1,
 -42878,
 1484838042,
 127771,
 -1,
 1484896728,
 127763,
 -42876,
 1484830870,
 8296,
 -1,
 1485019994,
 129351,
 1485242367,
 1484734012,
 128293,
 1485265033,
 1485166449,
 -1,
 -42872,
 1485221260,
 127878,
 -1,
 1485244657,
 127879,
 -1,
 1485177542,
 128658,
 1485527186,
 1484680903,
 -1,
 1485592719,
 1485454910,
 -1,
 -42867,
 1485549505,
 983106,
 -42866,
 1485589750,
 128193,
 -1,
 1485646794,
 128452,
 1485897727,
 1485535937,
 -1,
 -42863,
 1485807184,
 128253,
 -1,
 1485852263,
 127902,
 1486051479,
 1485483404,
 -1,
 1486117014,
 1485984802,
 128031,
 -42859,
 1486054316,
 127907,
 -1,
 1486094758,
 127845,
 -1,
 1486076893,
 128074,
 1486379162,
 1486015852,
 -1,
 -42855,
 1486331571,
 8281,
 -1,
 1486388368,
 11821,
 -1,
 1486308034,
 127953,
 1486641328,
 1484622250,
 -1,
 1486706853,
 1486603466,
 -1,
 1486772388,
 1486659843,
 -1,
 1486837921,
 1486698994,
 -1,
 -42848,
 1486790323,
 8280,
 -1,
 1486847120,
 8283,
 -42846,
 1486789743,
 128966,
 -42845,
 1486975529,
 127808,
 -1,
 1487024941,
 11156,
 -1,
 1486719067,
 9970,
 1487296683,
 1486659841,
 -1,
 1487362218,
 1487235893,
 -1,
 1487427753,
 1487274109,
 127860,
 -1,
 1487342933,
 127869,
 -1,
 1487356071,
 11792,
 -1,
 1487305426,
 983071,
 1487689901,
 1487228728,
 127787,
 -1,
 1487623184,
 127745,
 -42834,
 1487656930,
 129418,
 -42833,
 1487770358,
 128099,
 -1,
 1487827355,
 128448,
 1488017599,
 1486581447,
 -1,
 1488083127,
 1487964586,
 -1,
 1488148662,
 1488048827,
 9880,
 1488257023,
 1488062140,
 -1,
 -42827,
 1488177259,
 8277,
 -1,
 1488220464,
 127924,
 -1,
 1488100820,
 128190,
 1488476346,
 1488010812,
 -1,
 -42823,
 1488443457,
 128170,
 -1,
 1488505562,
 9884,
 1488672957,
 1488394479,
 -1,
 -42820,
 1488633866,
 9189,
 -1,
 1488670529,
 9971,
 -42818,
 1488640569,
 128389,
 -1,
 1488833494,
 128563,
 1489000650,
 1487970561,
 -1,
 1489066180,
 1488947626,
 -1,
 -42814,
 1489032653,
 128550,
 -42813,
 1489078337,
 128037,
 -1,
 1489129274,
 128056,
 1489328328,
 1488985837,
 -1,
 -42810,
 1489288982,
 128445,
 -42809,
 1489345282,
 128444,
 -1,
 1489379108,
 128446,
 -42807,
 1489264373,
 127844,
 -1,
 1489519569,
 127839,
 1489721553,
 1488962762,
 -1,
 1489787086,
 1489663875,
 -1,
 -42803,
 1489753242,
 127773,
 -1,
 1489811928,
 127765,
 -42801,
 1489743671,
 9179,
 -42800,
 1489929469,
 9905,
 -1,
 1489978038,
 9981,
 1490180311,
 1489649212,
 -1,
 1490245845,
 1490136146,
 -1,
 -42796,
 1490213075,
 9972,
 -1,
 1490249545,
 127905,
 -42794,
 1490191323,
 129338,
 -1,
 1490362804,
 128552,
 1490573531,
 1490145523,
 -1,
 -42791,
 1490490101,
 983211,
 -42790,
 1490555344,
 983210,
 -1,
 1490620581,
 983209,
 1490835677,
 1490529676,
 983107,
 -1,
 1490771153,
 983228,
 -1,
 1490766264,
 983072,
 1491032402,
 1481884874,
 -1,
 1491097886,
 1490982766,
 -1,
 1491163407,
 1491063207,
 -1,
 1491228918,
 1491122715,
 -1,
 1491294453,
 1491183293,
 -1,
 1491359988,
 1491209866,
 -1,
 1491425522,
 1491280507,
 11105,
 1491533823,
 1491337216,
 -1,
 1491556592,
 1491457156,
 -1,
 1491622122,
 1491499151,
 -1,
 -42775,
 1491577024,
 11171,
 -1,
 1491628980,
 11170,
 -42773,
 1491586786,
 129073,
 -42772,
 1491764121,
 129057,
 -42771,
 1491828247,
 129061,
 -42770,
 1491883768,
 129069,
 -42769,
 1491942335,
 11131,
 -1,
 1492003291,
 129065,
 -42767,
 1491517459,
 11121,
 -1,
 1492153352,
 11137,
 -42765,
 1491376166,
 11141,
 -1,
 1492268809,
 11115,
 -1,
 1491271981,
 129169,
 -1,
 1491261149,
 11245,
 1492605184,
 1491146991,
 -1,
 1492670719,
 1492561020,
 -1,
 1492736251,
 1492628432,
 -1,
 -42758,
 1492697496,
 129025,
 -1,
 1492731244,
 129041,
 -42756,
 1492682629,
 129177,
 -42755,
 1492876850,
 129029,
 -42754,
 1492938855,
 129033,
 -1,
 1492993388,
 129045,
 -1,
 1492616164,
 11797,
 1493260547,
 1492570931,
 -1,
 -42750,
 1493226898,
 129173,
 -1,
 1493257870,
 11192,
 1493457158,
 1493216652,
 -1,
 -42747,
 1493409829,
 129081,
 -1,
 1493442659,
 129105,
 1493653769,
 1493391072,
 -1,
 -42744,
 1493578242,
 129089,
 -1,
 1493639803,
 129093,
 1493850380,
 1493575908,
 -1,
 -42741,
 1493774269,
 11145,
 -1,
 1493836411,
 11014,
 -42739,
 1493805879,
 128621,
 -42738,
 1493977995,
 129077,
 -1,
 1494036994,
 129085,
 1494243606,
 1491078920,
 -1,
 1494309139,
 1494201296,
 -1,
 -42734,
 1494263000,
 128316,
 -1,
 1494293766,
 128744,
 -42732,
 1494263000,
 128314,
 -42731,
 1494450206,
 128742,
 -1,
 1494490374,
 128743,
 1494702364,
 1494155264,
 -1,
 1494767899,
 1494629446,
 -1,
 -42727,
 1494729182,
 11109,
 -42726,
 1494789825,
 129113,
 -1,
 1494821099,
 11021,
 -1,
 1494688430,
 11193,
 -42723,
 1494659668,
 128579,
 -1,
 1495046731,
 128319,
 1495226695,
 1491030093,
 -1,
 1495292230,
 1495168220,
 -1,
 1495357734,
 1495248268,
 -1,
 1495423268,
 1495275759,
 -1,
 -42717,
 1495367884,
 66450,
 -1,
 1495414589,
 66453,
 -42715,
 1495382241,
 66461,
 -1,
 1495554253,
 66444,
 1495750954,
 1495317019,
 -1,
 -42712,
 1495697834,
 66458,
 -42711,
 1495750138,
 66456,
 -1,
 1495811800,
 66441,
 1496013101,
 1495718703,
 -1,
 -42708,
 1495975114,
 66449,
 -1,
 1496008428,
 66439,
 1496209712,
 1495952181,
 -1,
 -42705,
 1496142904,
 66435,
 -1,
 1496194024,
 66443,
 1496406322,
 1496144275,
 66437,
 -1,
 1496365725,
 66440,
 1496537397,
 1496338232,
 -1,
 -42700,
 1496470670,
 66457,
 -1,
 1496522491,
 66434,
 1496734008,
 1496462813,
 -1,
 -42697,
 1496667325,
 66447,
 -1,
 1496728341,
 66436,
 1496930619,
 1496652015,
 -1,
 -42694,
 1496873438,
 66432,
 -1,
 1496932738,
 66451,
 -42692,
 1496898222,
 66442,
 -42691,
 1497093642,
 66438,
 -42690,
 1497154762,
 66460,
 -42689,
 1497211649,
 66455,
 -42688,
 1497276343,
 66454,
 -42687,
 1497341591,
 66452,
 -42686,
 1497401628,
 66448,
 -42685,
 1497464469,
 66446,
 -42684,
 1497526252,
 66445,
 -42683,
 1497586897,
 66459,
 -1,
 1497638873,
 66433,
 -1,
 1495258944,
 66463,
 1497913678,
 1495171828,
 -1,
 1497979211,
 1497849041,
 -1,
 -42678,
 1497938549,
 983115,
 -1,
 1497969443,
 129412,
 -42676,
 1497922775,
 9903,
 -42675,
 1498099169,
 11217,
 -1,
 1498160913,
 128530,
 1498372433,
 1497857425,
 -1,
 -42672,
 1498338558,
 9748,
 -1,
 1498385729,
 9969,
 -1,
 1498328460,
 983116,
 1498634586,
 1491000111,
 -1,
 1498700121,
 1498599692,
 -1,
 1498765655,
 1498645236,
 -1,
 -42666,
 1498704393,
 983214,
 -1,
 1498753755,
 983255,
 -42664,
 1498723733,
 983213,
 -1,
 1498901001,
 983215,
 -1,
 1498637925,
 129296,
 1499158877,
 1498601683,
 -1,
 -42660,
 1499094275,
 983235,
 -1,
 1499153137,
 128155,
 -1,
 1499111659,
 9915]
_charnames_564 = [
10639,
10703,
10465,
10684,
10687,
10764,
10847,
10936,
10694,
10927,
10821,
10489,
10755,
10977,
10769,
10968,
10923,
10811,
10837,
10512,
10974,
10781,
10876,
10762,
10887,
10575,
10984,
10773,
]

_charnames_751 = [
8807,
8811,
8801,
8810,
8809,
8838,
8836,
8837,
8812,
8849,
8861,
8832,
8860,
8831,
8752,
8863,
8800,
]

_charnames_848 = [
1844,
1781,
1903,
1898,
1778,
1845,
1842,
1847,
1833,
1870,
1823,
1895,
1822,
1821,
1819,
1820,
]

_charnames_880 = [
19090,
19068,
19091,
19069,
-1,
-1,
19089,
19067,
-1,
-1,
-1,
19071,
19073,
19072,
-1,
19088,
]

_charnames_1015 = [
19086,
19065,
19092,
19087,
19066,
19133,
19094,
19097,
19095,
]

_charnames_1270 = [
2951,
2871,
-1,
-1,
2950,
2870,
2933,
2841,
2932,
2840,
]

_charnames_1296 = [
2907,
2805,
2915,
2823,
2956,
2868,
2911,
2810,
2929,
2837,
2953,
2873,
2952,
2856,
2957,
2874,
2914,
2822,
2918,
2826,
2954,
2858,
2904,
2819,
2919,
2827,
2879,
2793,
2888,
2802,
2916,
2824,
]

_charnames_1536 = [
12522,
12450,
12512,
12453,
12451,
12523,
12534,
12533,
12499,
12532,
12531,
13082,
-1,
12504,
12526,
12458,
12452,
12459,
12455,
12456,
12457,
12412,
12415,
12411,
12420,
12421,
12419,
-1,
12359,
-1,
12485,
-1,
12323,
]

_charnames_1622 = [
12472,
12528,
12249,
12524,
12514,
12515,
12516,
12498,
12509,
12525,
]

_charnames_1869 = [
7504,
7505,
7506,
12258,
12266,
12256,
12257,
12259,
12264,
12261,
12341,
12342,
12362,
12366,
12304,
12329,
12287,
12289,
12286,
12280,
12281,
12318,
12316,
12314,
12357,
12356,
12376,
12375,
12374,
12380,
12305,
12308,
12326,
12339,
12337,
12327,
12303,
12338,
12296,
12297,
12271,
12272,
12273,
12369,
12370,
12351,
12352,
12343,
12330,
12328,
12321,
]

_charnames_1984 = [
20991,
20992,
20983,
20984,
20989,
20990,
20986,
20987,
20994,
20993,
20978,
20960,
20972,
20959,
20965,
20958,
20957,
20962,
20943,
20977,
20968,
20966,
20953,
20976,
20961,
20956,
20955,
20967,
20974,
20975,
20971,
20970,
20947,
20969,
20944,
20946,
20973,
20964,
20963,
20945,
20951,
20952,
20950,
21005,
21004,
21003,
21001,
21000,
20999,
20998,
21006,
21007,
21012,
20979,
21010,
21011,
21008,
21013,
20980,
-1,
-1,
-1,
-1,
-1,
7012,
6999,
7009,
7011,
6992,
7000,
7001,
6993,
6989,
7002,
7008,
7007,
7006,
7005,
6996,
6994,
7010,
6988,
7004,
7003,
6997,
6990,
7052,
7053,
7054,
7057,
7061,
7056,
7019,
7030,
7022,
7016,
7027,
7021,
7015,
7026,
7059,
7025,
7017,
7028,
7060,
7018,
7029,
7020,
7024,
7055,
-1,
-1,
7047,
7038,
7035,
7049,
7036,
7044,
7062,
7048,
7040,
7046,
7041,
7045,
7037,
7043,
7034,
-1,
8340,
8334,
8332,
8333,
8331,
8338,
8323,
8336,
8320,
8322,
8321,
8329,
8328,
8327,
8316,
8337,
8326,
8317,
8325,
8324,
8318,
8319,
8341,
8339,
8330,
8345,
8342,
8344,
-1,
-1,
8343,
]

_charnames_2208 = [
12262,
12265,
12388,
12384,
12282,
12386,
12379,
12358,
12348,
12349,
12306,
12371,
12309,
12381,
12363,
12332,
12389,
12331,
12385,
12290,
12322,
-1,
12263,
12387,
12383,
12302,
12347,
12294,
12292,
12293,
]

_charnames_2260 = [
12402,
12410,
12417,
12413,
12414,
12418,
12400,
12401,
12403,
12405,
12406,
12404,
12416,
12409,
12506,
12484,
12489,
12491,
12487,
12490,
12492,
12488,
12480,
12477,
12483,
12479,
12476,
12482,
12519,
12520,
12518,
12407,
12510,
12511,
12527,
12392,
12495,
12391,
12497,
12501,
12502,
12496,
12505,
12248,
20488,
-1,
-1,
-1,
20469,
]

_charnames_2382 = [
20498,
20500,
-1,
-1,
-1,
-1,
-1,
20499,
20494,
20493,
]

_charnames_2417 = [
20489,
20474,
20464,
20463,
20476,
20461,
20460,
20470,
20468,
20472,
20467,
20471,
20466,
20473,
20475,
16395,
]

_charnames_2555 = [
16394,
-1,
-1,
-1,
-1,
-1,
19470,
-1,
19468,
]

_charnames_2929 = [
18854,
18843,
18844,
18848,
18842,
18845,
18847,
]

_charnames_3059 = [
4537,
4542,
4538,
4536,
4533,
4544,
4539,
4541,
-1,
-1,
-1,
-1,
-1,
5298,
]

_charnames_3192 = [
5290,
5288,
5282,
5285,
5289,
5283,
5286,
5297,
20059,
20062,
]

_charnames_3386 = [
8593,
-1,
-1,
8622,
-1,
-1,
-1,
-1,
-1,
-1,
8618,
]

_charnames_3406 = [
8595,
8620,
-1,
-1,
-1,
-1,
8591,
8589,
8586,
-1,
8607,
8603,
8614,
8600,
8601,
8611,
8604,
8596,
-1,
-1,
8616,
8617,
]

_charnames_3440 = [
8627,
8626,
8625,
8606,
8608,
8613,
8605,
8609,
8612,
8628,
8588,
8587,
8590,
8584,
8585,
8592,
]

_charnames_3558 = [
6625,
6626,
6617,
6618,
6623,
6624,
6620,
6621,
6628,
6627,
]

_charnames_4046 = [
5141,
-1,
5127,
5131,
5130,
5133,
5134,
21849,
11188,
21850,
11189,
5132,
5129,
]

_charnames_4130 = [
9065,
-1,
-1,
-1,
-1,
-1,
9124,
-1,
-1,
9210,
]

_charnames_4147 = [
9207,
9206,
9212,
-1,
-1,
-1,
-1,
9167,
9234,
9236,
9235,
9237,
9133,
]

_charnames_4186 = [
9122,
9123,
9121,
9120,
9239,
9240,
9241,
9069,
9197,
9230,
9229,
9130,
9131,
9204,
9203,
9158,
9157,
9156,
9155,
9154,
9127,
9126,
9128,
9211,
9200,
9199,
9201,
9048,
9047,
9051,
9054,
9058,
9043,
9064,
9045,
9060,
9063,
9057,
9059,
9062,
9242,
9196,
9193,
9194,
9195,
9146,
9145,
9144,
9143,
9150,
9149,
9151,
9132,
9165,
9178,
9179,
9170,
9171,
9176,
9177,
9173,
9174,
9181,
9180,
9164,
9163,
9208,
9209,
9188,
9189,
]

_charnames_4295 = [
19449,
-1,
-1,
-1,
-1,
-1,
19450,
]

_charnames_4345 = [
19445,
19442,
-1,
8864,
19443,
19447,
19446,
]

_charnames_4992 = [
14353,
14434,
14433,
14432,
14355,
14370,
14369,
14368,
14354,
14439,
14438,
14437,
14352,
14427,
14426,
14425,
14458,
14452,
14460,
14459,
14454,
14457,
14462,
14461,
14453,
14456,
]

_charnames_5109 = [
2483,
-1,
-1,
2439,
2438,
2437,
2436,
2435,
2456,
-1,
-1,
2613,
]

_charnames_5751 = [
2529,
2525,
2526,
2523,
2524,
2527,
2528,
2530,
2598,
]

_charnames_5873 = [
21939,
21937,
21938,
21934,
21935,
21936,
21933,
21932,
]

_charnames_6128 = [
19549,
19550,
19545,
19548,
19547,
19538,
19544,
19543,
19542,
19541,
]

_charnames_6314 = [
8992,
-1,
-1,
-1,
-1,
-1,
2519,
2609,
2610,
2536,
2592,
2593,
2591,
2561,
2604,
2603,
2611,
2578,
2579,
2612,
2549,
2538,
2547,
2548,
2546,
2600,
2601,
2570,
2576,
2510,
2577,
2511,
2574,
2508,
2575,
2509,
2568,
2566,
2567,
2564,
2565,
2569,
2515,
2514,
2517,
2518,
2516,
2506,
2512,
2513,
2614,
2535,
2606,
2607,
2571,
2533,
2534,
2559,
2560,
2552,
2553,
2554,
2556,
2557,
2541,
2542,
2544,
2583,
2588,
2585,
2584,
2543,
2589,
2597,
2596,
2587,
]

_charnames_6400 = [
10318,
10268,
10267,
10257,
10256,
10264,
10277,
10276,
10271,
10270,
10259,
10249,
10248,
10274,
10273,
10265,
10262,
10261,
10280,
10279,
10283,
10258,
10282,
10284,
10281,
10252,
10251,
10253,
10285,
10255,
10247,
-1,
10309,
10317,
10316,
10315,
10311,
10313,
10310,
10314,
10312,
10304,
10306,
10305,
-1,
-1,
-1,
-1,
10296,
10289,
10297,
10291,
10290,
10293,
10294,
10292,
10295,
10300,
10302,
10299,
-1,
-1,
-1,
-1,
10301,
-1,
-1,
-1,
10334,
10333,
10329,
10330,
10321,
10322,
10327,
10328,
10324,
10325,
10332,
10331,
4839,
4841,
4835,
4818,
4843,
4840,
4820,
4819,
4846,
4831,
4830,
4845,
4849,
4842,
4848,
4844,
4838,
4817,
4836,
4824,
4847,
4823,
4822,
4827,
4833,
4832,
4828,
4821,
4825,
4826,
-1,
-1,
4815,
4814,
4813,
4812,
4811,
]

_charnames_6528 = [
20804,
20775,
20801,
20789,
20797,
20772,
20760,
20768,
20784,
20792,
20802,
20755,
20763,
20773,
20786,
20785,
20798,
20757,
20756,
20769,
20795,
20794,
20805,
20766,
20765,
20776,
20808,
20803,
20806,
20779,
20774,
20777,
20807,
20809,
20810,
20778,
20780,
20781,
20800,
20788,
20771,
20759,
20791,
20762,
-1,
-1,
-1,
-1,
20837,
20830,
20836,
20820,
20824,
20838,
20833,
20825,
20826,
20821,
20832,
20831,
20823,
20828,
20827,
20822,
20835,
20814,
20813,
20812,
20815,
20816,
20817,
20818,
20856,
20855,
-1,
-1,
-1,
-1,
-1,
-1,
20849,
20850,
20841,
20842,
20847,
20848,
20844,
20845,
20852,
20851,
20857,
-1,
-1,
-1,
20858,
20859,
19513,
19560,
19512,
19557,
19554,
19509,
19506,
19503,
19500,
19497,
19535,
19532,
19522,
19529,
19526,
19519,
19561,
19559,
19511,
19556,
19553,
19508,
19505,
19502,
19499,
19496,
19534,
19531,
19521,
19528,
19525,
19518,
16319,
16322,
16306,
16305,
16317,
16325,
16311,
16310,
16314,
16323,
16308,
16307,
16324,
16320,
16303,
16302,
16312,
16316,
16318,
16313,
16315,
16326,
16321,
16330,
16328,
16331,
16329,
16332,
-1,
-1,
16333,
16334,
4580,
4579,
4578,
4553,
4551,
4552,
4601,
4589,
4588,
4562,
4564,
4561,
4600,
4596,
4591,
4612,
4565,
4597,
4583,
4582,
4556,
4555,
4602,
4613,
4586,
4585,
4593,
4559,
4567,
4558,
4609,
4563,
4590,
4595,
4598,
4568,
4570,
4607,
4575,
4574,
4576,
4592,
4571,
4614,
4566,
4605,
4606,
4603,
4604,
4611,
4608,
4569,
4610,
4703,
4704,
4708,
4633,
4711,
4707,
4710,
4705,
4712,
4709,
-1,
4630,
4660,
4669,
4663,
4666,
4667,
4668,
4659,
4658,
4656,
4657,
4650,
4652,
4654,
4670,
4662,
4655,
4661,
4665,
4653,
4632,
4640,
4639,
4621,
4620,
4619,
4643,
4635,
4622,
-1,
-1,
4713,
4695,
4696,
4687,
4688,
4693,
4694,
4690,
4691,
4698,
4697,
-1,
-1,
-1,
-1,
-1,
-1,
4681,
4682,
4673,
4674,
4679,
4680,
4676,
4677,
4684,
4683,
-1,
-1,
-1,
-1,
-1,
-1,
4636,
4637,
4629,
4625,
4645,
4647,
4642,
4634,
4623,
4624,
4627,
4628,
4646,
4648,
-1,
-1,
1828,
1835,
1901,
1834,
1884,
1897,
1902,
1856,
1825,
1787,
1887,
1892,
1824,
1891,
1890,
]

_charnames_6912 = [
15687,
15688,
15691,
15689,
15692,
15573,
15574,
15595,
15596,
15587,
15588,
15582,
15583,
15585,
15586,
15600,
15576,
15591,
15592,
15562,
15564,
15597,
15598,
15560,
15602,
15603,
15593,
15594,
15559,
15554,
15553,
15570,
15569,
15558,
15550,
15552,
15566,
15571,
15557,
15589,
15590,
15604,
15605,
15610,
15607,
15581,
15584,
15608,
15580,
15579,
15577,
15611,
15690,
15660,
15661,
15662,
15663,
15664,
15665,
15666,
15669,
15670,
15655,
15657,
15659,
15658,
15667,
15668,
15704,
15563,
15565,
15555,
15601,
15609,
15606,
15575,
-1,
-1,
-1,
-1,
15681,
15682,
15673,
15674,
15679,
15680,
15676,
15677,
15684,
15683,
15697,
15696,
15703,
15701,
15702,
15700,
15695,
15625,
15623,
15624,
15615,
15617,
15626,
15620,
15622,
15619,
15618,
15633,
15636,
15629,
15631,
15634,
15630,
15632,
15637,
15635,
15648,
15649,
15651,
15652,
15642,
15640,
15645,
15644,
15641,
-1,
-1,
-1,
7338,
7337,
7336,
7281,
7295,
7288,
7282,
7292,
7276,
7277,
7275,
7290,
7297,
7257,
7299,
7294,
7283,
7256,
7289,
7298,
7258,
7291,
7263,
7287,
7280,
7293,
7284,
7269,
7272,
7286,
7266,
7285,
7296,
7348,
7347,
7346,
7328,
7326,
7330,
7327,
7331,
7329,
7339,
7340,
7344,
7343,
7274,
7265,
7310,
7311,
7302,
7303,
7308,
7309,
7305,
7306,
7313,
7312,
7349,
7268,
7271,
7279,
7262,
7261,
15764,
15733,
15759,
15731,
15747,
15763,
15756,
15749,
15728,
15741,
15746,
15752,
15725,
15750,
15760,
15732,
15757,
15761,
15754,
15727,
15743,
15729,
15734,
15738,
15735,
15726,
15745,
15751,
15724,
15739,
15755,
15730,
15737,
15762,
15740,
15748,
15758,
15753,
15783,
15771,
15773,
15772,
15775,
15770,
15774,
15769,
15766,
15767,
15788,
15789,
15786,
15785,
]

_charnames_7164 = [
15781,
15779,
15782,
15780,
11217,
11215,
11216,
11233,
11232,
11212,
11239,
11238,
11248,
11211,
11205,
11204,
11221,
11213,
11209,
11207,
11208,
11236,
11235,
11242,
11241,
11227,
11226,
11203,
11202,
11219,
11243,
11246,
11247,
11230,
11229,
11245,
11224,
11223,
11244,
11249,
11291,
11292,
11281,
11279,
11277,
11278,
11275,
11276,
11280,
11267,
11272,
11273,
11265,
11271,
11270,
11269,
11266,
11268,
11294,
11295,
-1,
-1,
-1,
11286,
11287,
11288,
11285,
11284,
11260,
11261,
11252,
11253,
11258,
11259,
11255,
11256,
11263,
11262,
-1,
-1,
-1,
11200,
11199,
11220,
18681,
18682,
18673,
18674,
18679,
18680,
18676,
18677,
18684,
18683,
18645,
18640,
18643,
18641,
18642,
18646,
18638,
18639,
18637,
18636,
18649,
18662,
18665,
18664,
18663,
18647,
18655,
18654,
18653,
18652,
18650,
18668,
18670,
18669,
18667,
18648,
18658,
18660,
18657,
18659,
18692,
18694,
18691,
18693,
18689,
18695,
18687,
18688,
2809,
2867,
2862,
2855,
2781,
2787,
2782,
2780,
2872,
]

_charnames_7360 = [
7318,
7317,
7316,
7322,
7319,
7320,
7321,
7323,
]

_charnames_7376 = [
17340,
17344,
17345,
17316,
17313,
17325,
17324,
17322,
17342,
17323,
17332,
17328,
17339,
17334,
17327,
17329,
17337,
17346,
17306,
17302,
17309,
17304,
17310,
17303,
17305,
17299,
17298,
17295,
17296,
17315,
17319,
17317,
17311,
17297,
17300,
17312,
17343,
17318,
17314,
-1,
17336,
17333,
-1,
-1,
-1,
-1,
-1,
-1,
11014,
11015,
10456,
11029,
11028,
11027,
11013,
11011,
10444,
10448,
11025,
11024,
11023,
11022,
11005,
11008,
11010,
10472,
10473,
10474,
10438,
11009,
10468,
10660,
11021,
11004,
10999,
10997,
11019,
10475,
10477,
10476,
11018,
11017,
11016,
11012,
11031,
11032,
19106,
19105,
19102,
19103,
19101,
2959,
8765,
8766,
8763,
8764,
8780,
8779,
8758,
8778,
8761,
8777,
8776,
8775,
8774,
8773,
8772,
8757,
8759,
8760,
8771,
8755,
8770,
8769,
8767,
8727,
8664,
8728,
8666,
8708,
8724,
8692,
8705,
8719,
8670,
8720,
8671,
8743,
8737,
8696,
8716,
8718,
8673,
8709,
8732,
8662,
8697,
8706,
8667,
8730,
8729,
8710,
8723,
8726,
8722,
8683,
10802,
10794,
10792,
10791,
19079,
19077,
19075,
19076,
19078,
10569,
10657,
10678,
10779,
10715,
10707,
10727,
10578,
10579,
10492,
10463,
10757,
10455,
8795,
10531,
10461,
10786,
10549,
10723,
10785,
10565,
10656,
10677,
10778,
10767,
10735,
10635,
10714,
10705,
10726,
10576,
10490,
10518,
10665,
10753,
10756,
10617,
10625,
10679,
10513,
10598,
10586,
10484,
10545,
10594,
10517,
10562,
10522,
8665,
8676,
8684,
8694,
8742,
8746,
8725,
8704,
8672,
8741,
8740,
8678,
8679,
8744,
8687,
8688,
8682,
8738,
8668,
8736,
8735,
8681,
8711,
8733,
8707,
8695,
8675,
8700,
8701,
8680,
8731,
8669,
8712,
8714,
8715,
8693,
8674,
1831,
1832,
1888,
1886,
1867,
1655,
1865,
1873,
1656,
1874,
1749,
1904,
1866,
1827,
1857,
1894,
1900,
1878,
1877,
1754,
1737,
1735,
1734,
1767,
1765,
1756,
1766,
1773,
1764,
1739,
1772,
1771,
1763,
1770,
1769,
1748,
1745,
1740,
1760,
1736,
1758,
1759,
1746,
1753,
1741,
1751,
1762,
1757,
1743,
1761,
1738,
1752,
1744,
1879,
-1,
-1,
-1,
-1,
-1,
1815,
1826,
1875,
1779,
1843,
]

_charnames_8275 = [
7667,
22420,
22708,
5330,
-1,
22687,
22680,
5449,
22688,
20273,
5428,
17375,
-1,
-1,
-1,
-1,
-1,
22423,
-1,
11192,
21853,
22659,
18187,
]

_charnames_8336 = [
10805,
10804,
10796,
10790,
10789,
10803,
10800,
10799,
10798,
10797,
10795,
10788,
10793,
]

_charnames_8370 = [
19473,
13059,
21640,
3340,
10427,
7570,
5312,
22425,
5415,
21054,
8357,
21944,
11056,
]

_charnames_8524 = [
18148,
13081,
5398,
7517,
17389,
17390,
17388,
]

_charnames_8580 = [
10584,
21959,
21958,
21957,
21960,
17391,
5402,
5403,
]

_charnames_9167 = [
14607,
17374,
8235,
8232,
8233,
8231,
8226,
8227,
8228,
8229,
8234,
14585,
22734,
5384,
16350,
5386,
16353,
5382,
16348,
22197,
16399,
7540,
22715,
13068,
14529,
20531,
16220,
16231,
16271,
16245,
16221,
16232,
16222,
12709,
7553,
5156,
21593,
16171,
16183,
16178,
16175,
20257,
16188,
16216,
18162,
18165,
18166,
18163,
]

_charnames_9866 = [
8998,
8997,
20568,
20561,
20562,
20567,
22208,
16287,
21362,
12055,
3316,
7534,
7656,
12705,
22706,
19451,
7533,
13070,
22713,
18889,
5326,
5327,
22137,
21625,
20265,
20264,
22430,
8633,
8631,
8632,
17373,
21583,
8211,
8220,
8202,
8579,
20588,
22859,
2168,
22735,
20935,
3338,
17746,
22607,
17377,
2494,
16185,
7638,
7641,
22877,
7640,
7438,
15840,
7191,
22181,
22182,
16250,
16251,
7659,
7354,
22004,
16198,
5355,
5411,
5409,
22179,
3323,
20581,
18876,
18203,
2683,
21566,
3298,
2380,
21059,
12706,
16259,
22198,
16236,
22189,
20613,
21528,
11185,
7185,
22649,
16260,
21743,
21742,
13073,
21523,
18150,
21855,
11194,
22421,
16215,
6868,
2498,
2772,
21628,
19453,
19454,
8653,
9010,
22864,
22692,
22716,
22739,
7074,
7248,
7676,
22475,
18136,
5310,
22604,
21555,
22736,
1579,
22209,
16200,
-1,
-1,
-1,
-1,
22203,
-1,
-1,
-1,
-1,
22001,
21990,
]

_charnames_10060 = [
3322,
-1,
20901,
-1,
-1,
-1,
-1,
16288,
22229,
22230,
-1,
21513,
]

_charnames_10175 = [
20262,
5331,
22196,
18145,
18863,
18862,
11167,
21831,
18857,
21736,
7363,
17376,
8639,
11384,
8650,
7174,
7173,
]

_charnames_11008 = [
21050,
21040,
7427,
7417,
11158,
11136,
22795,
20246,
21052,
21042,
7429,
7419,
11161,
22810,
21785,
21784,
11115,
11114,
7228,
7230,
7227,
7229,
20573,
20572,
20571,
20574,
20270,
16239,
22192,
16264,
22217,
16282,
22223,
22202,
16276,
21582,
16240,
16177,
22215,
16173,
22214,
16194,
16193,
22173,
16278,
22204,
16267,
22218,
11170,
5328,
11171,
11383,
11105,
11106,
11107,
11108,
11126,
11117,
11118,
11100,
11102,
11103,
11132,
22150,
14605,
21732,
11130,
21795,
21794,
11152,
21818,
21731,
21798,
5152,
11131,
11129,
21797,
20223,
6856,
6855,
22213,
16192,
22172,
16223,
22220,
21490,
21543,
21524,
21521,
21525,
7631,
15846,
7630,
15845,
16398,
6854,
11077,
22756,
21760,
20209,
11159,
22808,
21038,
21048,
7425,
7415,
11094,
22771,
21777,
20225,
3241,
12046,
11091,
22768,
21774,
20221,
-1,
-1,
21039,
21049,
7426,
7416,
11085,
22766,
21768,
20219,
21578,
17369,
11092,
22769,
21775,
20222,
11093,
22770,
21776,
20224,
11135,
22794,
21801,
20245,
12045,
12048,
12047,
12044,
21747,
21746,
20866,
20865,
22691,
21802,
-1,
-1,
5340,
5341,
5339,
5342,
16237,
16272,
16225,
16246,
20214,
20213,
22761,
22760,
11081,
21764,
11082,
21765,
16214,
16213,
16205,
16204,
16210,
16207,
16211,
16208,
21869,
21868,
21860,
21859,
21865,
21862,
21866,
21863,
22786,
22811,
-1,
-1,
-1,
15715,
3304,
3307,
16189,
16253,
5410,
21581,
16289,
16179,
16176,
16172,
16184,
-1,
5379,
16352,
10406,
21979,
22211,
21978,
7245,
22860,
]

_charnames_11264 = [
19380,
19369,
19371,
19378,
19351,
19333,
19354,
19350,
19355,
19340,
19344,
19337,
19352,
19376,
19363,
19375,
19374,
19361,
19357,
19373,
19327,
19346,
19372,
19366,
19377,
19360,
19358,
19321,
19347,
19379,
19323,
19331,
19332,
19336,
19326,
19334,
19324,
19325,
19335,
19342,
19370,
19343,
19367,
19339,
19322,
19348,
19364,
-1,
19317,
19306,
19308,
19315,
19288,
19270,
19291,
19287,
19292,
19277,
19281,
19274,
19289,
19313,
19300,
19312,
19311,
19298,
19294,
19310,
19264,
19283,
19309,
19303,
19314,
19297,
19295,
19258,
19284,
19316,
19260,
19268,
19269,
19273,
19263,
19271,
19261,
19262,
19272,
19279,
19307,
19280,
19304,
19276,
19259,
19285,
19301,
-1,
10931,
10632,
10929,
10949,
10886,
10616,
10464,
10963,
10743,
10945,
10734,
10982,
10758,
10854,
10959,
10809,
10810,
10664,
10992,
10783,
10667,
10965,
10745,
10469,
10514,
10453,
10605,
11001,
10801,
8768,
10873,
10981,
2045,
1964,
2048,
1967,
2055,
1974,
2019,
1938,
2057,
1976,
2028,
1947,
2047,
1966,
2054,
1973,
2036,
1955,
2053,
1972,
2034,
1953,
2042,
1961,
2052,
1971,
2051,
1970,
2032,
1951,
1990,
1909,
2040,
1959,
2050,
1969,
2029,
1948,
2037,
1956,
2049,
1968,
2056,
1975,
2033,
1952,
2039,
1958,
2012,
1931,
2018,
1937,
2005,
1924,
2025,
1944,
2016,
1935,
2015,
1934,
2023,
1942,
2001,
1920,
2030,
1949,
2026,
1945,
2000,
1919,
2003,
1922,
2046,
1965,
2017,
1936,
1996,
1915,
1994,
1913,
2043,
1962,
1997,
1916,
1995,
1914,
2002,
1921,
2004,
1923,
1999,
1918,
2011,
1930,
2009,
1928,
2008,
1927,
2010,
1929,
1984,
1987,
1986,
1980,
1985,
1983,
1981,
2022,
1941,
2024,
1943,
2063,
2062,
2061,
2058,
1977,
-1,
-1,
-1,
-1,
-1,
2112,
2113,
2111,
2110,
2116,
2115,
2117,
19423,
19439,
19421,
19438,
19437,
19428,
19403,
19406,
19436,
19415,
19435,
19434,
19433,
19432,
19412,
19402,
19430,
19409,
19405,
19429,
19411,
19414,
19420,
19431,
19408,
19397,
19400,
19417,
19399,
19398,
19426,
19418,
19391,
19394,
19393,
19427,
19390,
19392,
-1,
19425,
-1,
-1,
-1,
-1,
-1,
19424,
-1,
-1,
5060,
5084,
5085,
5077,
5079,
5116,
5094,
5061,
5064,
5062,
5063,
5099,
5095,
5074,
5105,
5076,
5082,
5117,
5113,
5083,
5097,
5075,
5106,
5089,
5111,
5102,
5067,
5120,
5110,
5093,
5092,
5091,
5108,
5112,
5090,
5100,
5080,
5081,
5078,
5109,
5119,
5071,
5072,
5073,
5068,
5070,
5096,
5069,
5088,
5087,
5086,
5065,
5114,
5066,
5098,
5101,
]

_charnames_11647 = [
5123,
14446,
14435,
14445,
14356,
14357,
14371,
14381,
14305,
14442,
14441,
14323,
14392,
14341,
14333,
14447,
14382,
14306,
14429,
14428,
14319,
14321,
14318,
14317,
]

_charnames_11680 = [
14346,
14348,
14350,
14347,
14345,
14344,
14349,
-1,
14300,
14302,
14304,
14301,
14299,
14298,
14303,
-1,
14387,
14389,
14391,
14388,
14386,
14385,
14390,
-1,
14293,
14295,
14297,
14294,
14292,
14291,
14296,
-1,
14407,
14409,
14411,
14408,
14406,
14405,
14410,
-1,
14417,
14419,
14421,
14418,
14416,
14415,
14420,
-1,
14397,
14399,
14401,
14398,
14396,
14395,
14400,
-1,
14311,
14313,
14315,
14312,
14310,
14309,
14314,
-1,
1706,
1707,
1712,
1703,
1690,
1691,
1711,
1671,
1670,
1669,
1697,
1708,
1668,
1666,
1696,
1699,
1695,
1714,
1687,
1686,
1713,
1667,
1715,
1678,
1702,
1709,
1683,
1680,
1677,
1710,
1705,
1676,
21834,
21835,
11164,
21829,
11181,
21842,
22000,
21998,
20269,
11174,
21838,
21999,
11162,
21844,
14608,
17697,
22697,
21727,
21638,
20272,
20237,
22783,
20271,
20259,
22422,
17745,
21639,
5151,
11178,
21845,
5150,
5149,
11183,
21843,
5385,
5383,
16351,
16349,
11166,
21830,
11180,
21841,
5448,
18885,
7200,
22681,
21725,
17371,
21872,
22308,
5413,
21997,
22002,
5399,
20595,
20594,
5404,
5378,
5455,
5343,
7548,
17372,
22294,
2773,
20261,
21728,
20260,
20598,
20258,
]

_charnames_12728 = [
16369,
16367,
16366,
-1,
-1,
-1,
-1,
-1,
3183,
3186,
3185,
3190,
3173,
3157,
3164,
3165,
3162,
3172,
3163,
3160,
3166,
3161,
3158,
3188,
3155,
3169,
3179,
3177,
3189,
3156,
3168,
3170,
3174,
3176,
3178,
3182,
3180,
3184,
3171,
3175,
3167,
3159,
3181,
3187,
]

_charnames_12868 = [
3279,
3274,
3278,
3273,
3288,
3286,
3287,
3293,
3294,
3290,
3291,
3295,
17696,
]

_charnames_19904 = [
21373,
21384,
21398,
21460,
21453,
21441,
21379,
21462,
21414,
21390,
21432,
21416,
21459,
21407,
21456,
21463,
21458,
21452,
21448,
21440,
21445,
21410,
21417,
21426,
21420,
21409,
21455,
21408,
21380,
21374,
21422,
21399,
21427,
21406,
21431,
21400,
21389,
21436,
21437,
21394,
21395,
21423,
21444,
21442,
21411,
21430,
21435,
21382,
21428,
21375,
21378,
21386,
21393,
21385,
21450,
21383,
21388,
21387,
21397,
21461,
21421,
21415,
21449,
21446,
]

_charnames_42192 = [
10396,
10363,
10362,
10382,
10351,
10350,
10377,
10371,
10370,
10393,
10385,
10384,
10381,
10349,
10348,
10391,
10368,
10392,
10360,
10356,
10357,
10367,
10374,
10389,
10373,
10395,
10390,
10359,
10388,
10376,
10386,
10387,
10378,
10379,
10394,
10364,
10352,
10354,
10353,
10365,
10341,
10346,
10344,
10345,
10342,
10343,
10399,
10398,
16731,
16732,
16654,
16591,
16592,
16698,
16637,
16644,
16496,
16535,
16488,
16557,
16714,
16682,
16612,
16605,
16520,
16513,
16664,
16690,
16527,
16456,
16628,
16621,
16581,
16574,
16722,
16706,
16472,
16674,
16545,
16437,
16563,
16503,
16479,
16464,
16736,
16737,
16657,
16658,
16596,
16597,
16700,
16639,
16646,
16498,
16541,
16490,
16559,
16716,
16684,
16614,
16607,
16522,
16515,
16668,
16692,
16529,
16458,
16630,
16623,
16583,
16576,
16724,
16708,
16474,
16676,
16549,
16441,
16567,
16505,
16481,
16466,
16738,
16739,
16445,
16659,
16660,
16598,
16599,
16701,
16640,
16647,
16499,
16538,
16539,
16491,
16560,
16717,
16685,
16615,
16608,
16523,
16516,
16669,
16693,
16530,
16459,
16631,
16624,
16584,
16577,
16725,
16709,
16475,
16677,
16546,
16547,
16442,
16568,
16506,
16482,
16467,
16727,
16728,
16650,
16587,
16588,
16696,
16635,
16642,
16494,
16537,
16486,
16553,
16712,
16680,
16610,
16603,
16518,
16511,
16666,
16688,
16525,
16454,
16626,
16619,
16579,
16572,
16720,
16704,
16470,
16672,
16543,
16439,
16565,
16501,
16477,
16462,
16734,
16735,
16655,
16656,
16594,
16595,
16699,
16638,
16645,
16497,
16540,
16489,
16558,
16715,
16683,
16613,
16606,
16521,
16514,
16667,
16691,
16528,
16457,
16629,
16622,
16582,
16575,
16723,
16707,
16473,
16675,
16548,
16440,
16566,
16504,
16480,
16465,
16726,
16729,
16443,
16649,
16651,
16586,
16589,
16695,
16634,
16641,
16493,
16536,
16485,
16552,
16554,
16711,
16679,
16609,
16602,
16517,
16510,
16665,
16687,
16524,
16447,
16625,
16618,
16578,
16571,
16719,
16703,
16469,
16671,
16542,
16438,
16564,
16500,
16476,
16461,
16730,
16733,
16444,
16652,
16653,
16590,
16593,
16697,
16636,
16643,
16495,
16533,
16534,
16487,
16555,
16556,
16713,
16681,
16611,
16604,
16519,
16512,
16662,
16689,
16526,
16455,
16627,
16620,
16580,
16573,
16721,
16705,
16471,
16673,
16544,
16435,
16436,
16561,
16562,
16502,
16478,
16463,
16433,
16663,
16775,
16774,
16773,
16452,
16451,
16449,
16754,
16752,
16743,
16756,
16758,
16755,
16744,
16749,
16747,
16751,
16742,
16748,
16757,
16769,
16770,
16761,
16762,
16767,
16768,
16764,
16765,
16772,
16771,
16450,
16453,
]

_charnames_42560 = [
2945,
2853,
2882,
2796,
2910,
2808,
2925,
2833,
2887,
2801,
2947,
2864,
2940,
2848,
2955,
2861,
2928,
2836,
2922,
2830,
2908,
2806,
2924,
2832,
2937,
2845,
2941,
2849,
2923,
2831,
2927,
2835,
2909,
2807,
2901,
2816,
2900,
2815,
2899,
2814,
2948,
2865,
2942,
2850,
2885,
2799,
2960,
1725,
1721,
1727,
1720,
7632,
1693,
1673,
1681,
1692,
1700,
1682,
1688,
1698,
1726,
1724,
2962,
2961,
2886,
2800,
2881,
2795,
2944,
2852,
2938,
2846,
2880,
2794,
2894,
2788,
2893,
2786,
2891,
2784,
2892,
2785,
2895,
2789,
2934,
2842,
2903,
2818,
2884,
2798,
2936,
2844,
8794,
8793,
1672,
1675,
15534,
15472,
15530,
15469,
15533,
15498,
15509,
15531,
15455,
15532,
15517,
15440,
15500,
15501,
15516,
15476,
15510,
15458,
15445,
15473,
15490,
15480,
15488,
15491,
15489,
15492,
15468,
15466,
15451,
15450,
15443,
15525,
15486,
15524,
15526,
15456,
15465,
15437,
15444,
15454,
15434,
15528,
15438,
15521,
15502,
15513,
15482,
15457,
15496,
15503,
15467,
15447,
15448,
15449,
15487,
15435,
15519,
15520,
15529,
15459,
15515,
15439,
15514,
15461,
15478,
15497,
15475,
15483,
15511,
15471,
15481,
15479,
15506,
15470,
15507,
15453,
15493,
15522,
15462,
15463,
15539,
15538,
15544,
15545,
15541,
15540,
15542,
15543,
]

_charnames_42752 = [
8786,
8791,
8783,
8788,
8785,
8790,
8784,
8789,
8826,
8852,
8841,
8805,
8820,
8827,
8853,
8842,
8806,
8821,
8828,
8854,
8843,
8802,
8822,
8856,
8857,
8858,
8815,
8845,
8848,
8847,
8846,
8813,
8749,
8748,
10839,
10520,
10840,
10521,
10964,
10744,
10819,
10466,
10820,
10467,
10933,
10697,
10934,
10698,
11026,
11020,
10855,
10627,
10853,
10624,
10852,
10623,
10849,
10620,
10850,
10621,
10851,
10622,
10892,
10585,
10941,
10730,
10944,
10733,
10942,
10731,
10970,
10659,
10930,
10638,
10911,
10607,
10910,
10606,
10912,
10608,
10950,
10724,
10952,
10728,
10951,
10725,
10987,
10761,
10988,
10763,
10889,
10582,
10893,
10588,
10902,
10666,
10899,
10672,
10900,
10673,
10817,
10459,
10818,
10460,
10901,
10674,
10841,
10523,
10869,
10550,
10938,
10699,
8862,
10685,
10643,
10720,
10709,
10587,
11006,
10457,
10567,
10863,
10533,
10862,
10532,
10861,
10815,
10449,
10813,
10454,
10860,
10530,
10859,
10529,
10858,
10528,
8814,
8796,
8751,
10880,
10494,
10816,
10634,
11030,
10991,
10708,
10937,
10696,
10695,
10742,
10969,
10658,
10993,
10777,
10898,
10671,
10897,
10670,
10896,
10669,
10979,
10768,
10946,
10736,
10990,
10706,
10888,
10577,
10874,
10491,
10962,
10891,
10879,
10926,
10877,
-1,
10814,
10812,
10975,
10939,
10971,
10661,
10913,
10609,
]

_charnames_42999 = [
11040,
8762,
8691,
11000,
11036,
11035,
11038,
11039,
11041,
7484,
7481,
7498,
7475,
7483,
7477,
7497,
7461,
7462,
7467,
7468,
7499,
7470,
7471,
7464,
7465,
7444,
7445,
7450,
7451,
7446,
7447,
7452,
7453,
7478,
7458,
7459,
7473,
7474,
7479,
7456,
7480,
7455,
7476,
7482,
7490,
7488,
7486,
7489,
7487,
7495,
7494,
7493,
7492,
-1,
-1,
-1,
-1,
21022,
21023,
21027,
21021,
21024,
21026,
21029,
21032,
21031,
21030,
-1,
-1,
-1,
-1,
-1,
-1,
17810,
17809,
17813,
17782,
17793,
17795,
17825,
17780,
17778,
17777,
17791,
17783,
17807,
17806,
17829,
17823,
17776,
17775,
17789,
17818,
17800,
17801,
17785,
17816,
17820,
17824,
17786,
17787,
17827,
17796,
17826,
17819,
17814,
17822,
17821,
17817,
17828,
17812,
17815,
17834,
17833,
17773,
17772,
17790,
17781,
17798,
17803,
17804,
17797,
17835,
17836,
17794,
17837,
17841,
17839,
17840,
]

_charnames_43136 = [
6983,
6980,
6902,
6905,
6926,
6927,
6910,
6911,
6880,
6881,
6882,
6883,
6931,
6932,
6904,
6915,
6916,
6903,
6922,
6921,
6930,
6929,
6894,
6935,
6934,
6925,
6924,
6892,
6888,
6887,
6899,
6898,
6893,
6890,
6889,
6901,
6900,
6895,
6914,
6913,
6938,
6937,
6941,
6939,
6940,
6919,
6884,
6908,
6907,
6909,
6942,
6918,
6984,
6952,
6957,
6958,
6953,
6954,
6945,
6946,
6947,
6948,
6959,
6960,
6951,
6955,
6956,
6950,
6981,
6982,
]

_charnames_43214 = [
6977,
6976,
6972,
6973,
6964,
6965,
6970,
6971,
6967,
6968,
6975,
6974,
-1,
-1,
-1,
-1,
-1,
-1,
1802,
1803,
1794,
1795,
1800,
1801,
1797,
1798,
1805,
1804,
1813,
1808,
1812,
1811,
1810,
1809,
1807,
1814,
20485,
20482,
20490,
20480,
20481,
20483,
20487,
20503,
20504,
20502,
20486,
20501,
-1,
-1,
20024,
20025,
20016,
20017,
20022,
20023,
20019,
20020,
20027,
20026,
19997,
19996,
20009,
19981,
19988,
19987,
20001,
19980,
19985,
19999,
19982,
19991,
19990,
20006,
20010,
20012,
20005,
20002,
20007,
20003,
19984,
20000,
20004,
20011,
20013,
19994,
20008,
19993,
20030,
20031,
20029,
20032,
20033,
20037,
20035,
20036,
20040,
20039,
21664,
21667,
21651,
21659,
21668,
21653,
21662,
21670,
21656,
21669,
21665,
21648,
21660,
21661,
21663,
21657,
21658,
21666,
21655,
21650,
21652,
21647,
21671,
21682,
21680,
21674,
21679,
21681,
21678,
21675,
21676,
21686,
21685,
21687,
21688,
21683,
]

_charnames_43359 = [
21689,
21290,
21289,
21287,
21291,
21279,
21276,
21282,
21274,
21284,
21283,
21275,
21281,
21277,
21285,
21280,
21310,
21308,
21309,
21299,
21300,
21301,
21295,
21312,
21313,
21296,
21294,
21302,
21315,
21293,
-1,
-1,
-1,
22589,
22586,
22590,
22588,
22527,
22516,
22514,
22515,
22531,
22509,
22486,
22487,
22536,
22528,
22532,
22510,
22512,
22513,
22521,
22522,
22485,
22523,
22524,
22519,
22489,
22520,
22488,
22493,
22494,
22498,
22499,
22491,
22495,
22496,
22500,
22501,
22490,
22506,
22508,
22525,
22526,
22533,
22529,
22517,
22518,
22534,
22530,
22504,
22505,
22502,
22535,
22587,
22576,
22578,
22579,
22580,
22581,
22582,
22577,
22584,
22583,
22593,
22592,
22594,
22558,
22537,
22596,
22548,
22554,
22543,
22552,
22551,
22544,
22542,
22546,
22547,
22550,
22595,
-1,
22557,
22569,
22570,
22561,
22562,
22567,
22568,
22564,
22565,
22572,
22571,
-1,
-1,
-1,
-1,
22553,
22555,
9050,
9053,
9061,
9044,
9056,
9152,
9244,
9105,
9117,
9112,
9111,
9109,
9108,
9101,
9100,
9106,
9224,
9225,
9216,
9217,
9222,
9223,
9219,
9220,
9227,
9226,
9116,
9103,
9102,
9115,
9114,
-1,
2229,
2237,
2233,
2239,
2230,
2235,
2219,
2218,
2225,
2224,
2192,
2193,
2228,
2227,
2222,
2221,
2188,
2190,
2189,
2210,
2209,
2203,
2201,
2194,
2195,
2202,
2199,
2197,
2198,
2207,
2205,
2215,
2216,
2206,
2231,
2234,
2236,
2232,
2212,
2213,
2238,
2244,
2249,
2250,
2251,
2245,
2248,
2247,
2243,
2242,
2246,
2271,
2273,
2274,
2272,
]

_charnames_43584 = [
2183,
2184,
2176,
2268,
2185,
2178,
2175,
2181,
2177,
2180,
2182,
2179,
2269,
2270,
-1,
-1,
2262,
2263,
2254,
2255,
2260,
2261,
2257,
2258,
2265,
2264,
-1,
-1,
2280,
2278,
2277,
2279,
9095,
9090,
9089,
9084,
9083,
9080,
9078,
9077,
9074,
9073,
9075,
9081,
9093,
9087,
9086,
9096,
9245,
9092,
9091,
9094,
9137,
9136,
9138,
9186,
9185,
9184,
9134,
9166,
9161,
9160,
9068,
9067,
4725,
4756,
4723,
4754,
4724,
4755,
4743,
4774,
4720,
4751,
4733,
4764,
4734,
4765,
4737,
4768,
4718,
4749,
4745,
4776,
4727,
4758,
4728,
4759,
4719,
4750,
4746,
4777,
4730,
4761,
4731,
4762,
4744,
4775,
4740,
4771,
4735,
4766,
4738,
4769,
4741,
4772,
4736,
4767,
4742,
4773,
4739,
4770,
4807,
4784,
4789,
4786,
4785,
4792,
4791,
4806,
4790,
4787,
4788,
4781,
4780,
4782,
4783,
4804,
4803,
4801,
4802,
]

_charnames_43739 = [
4795,
4798,
4797,
4799,
4796,
8150,
8148,
8140,
8099,
8104,
8103,
8111,
8110,
8100,
8116,
8115,
8166,
8162,
8158,
8159,
8157,
8194,
8191,
8190,
8196,
8195,
8168,
8173,
]

_charnames_43777 = [
14376,
14378,
14379,
14375,
14374,
14377,
-1,
-1,
14329,
14331,
14332,
14328,
14327,
14330,
-1,
-1,
14337,
14339,
14340,
14336,
14335,
14338,
]

_charnames_43808 = [
14286,
14288,
14290,
14287,
14285,
14284,
14289,
-1,
14362,
14364,
14366,
14363,
14361,
14360,
14365,
-1,
10653,
10619,
10649,
10652,
10515,
10644,
10482,
10637,
10631,
10636,
10716,
10704,
10524,
10647,
10648,
10593,
10535,
10440,
10441,
10442,
10443,
10496,
11007,
10581,
10682,
10580,
10683,
10480,
10481,
10654,
10561,
10564,
10568,
10452,
10563,
10689,
10691,
10692,
10752,
10748,
10751,
10750,
10774,
8865,
8745,
8690,
8689,
8699,
10495,
10548,
10597,
10566,
10536,
19104,
]

_charnames_43888 = [
2482,
2481,
2480,
2478,
2477,
2476,
2475,
2479,
2474,
2473,
2472,
2471,
2470,
2425,
2424,
2423,
2421,
2420,
2419,
2468,
2467,
2466,
2465,
2464,
2463,
2461,
2460,
2459,
2458,
2457,
2411,
2422,
2412,
2417,
2416,
2415,
2414,
2413,
2454,
2453,
2452,
2451,
2450,
2449,
2409,
2403,
2408,
2407,
2406,
2405,
2404,
2433,
2402,
2432,
2401,
2431,
2400,
2429,
2428,
2427,
2430,
2399,
2398,
2397,
2396,
2395,
2394,
2392,
2391,
2390,
2389,
2388,
2387,
2447,
2446,
2445,
2444,
2443,
2442,
2440,
8123,
8117,
8128,
8126,
8119,
8097,
8139,
8105,
8125,
8095,
8107,
8145,
8144,
8149,
8146,
8133,
8121,
8151,
8136,
8132,
8147,
8143,
8131,
8112,
8137,
8113,
8142,
8124,
8129,
8127,
8120,
8098,
8106,
8096,
8134,
8170,
8165,
8160,
8167,
8169,
8163,
8172,
8171,
8193,
8152,
8189,
-1,
-1,
8184,
8185,
8176,
8177,
8182,
8183,
8179,
8180,
8187,
8186,
]

_charnames_55216 = [
21255,
21256,
21243,
21244,
21245,
21268,
21269,
21248,
21247,
21261,
21259,
21258,
21260,
21236,
21235,
21233,
21232,
21239,
21238,
21237,
21240,
21265,
21264,
-1,
-1,
-1,
-1,
21224,
21225,
21155,
21156,
21206,
21200,
21201,
21203,
21204,
21205,
21196,
21198,
21160,
21197,
21194,
21195,
21191,
21192,
21214,
21218,
21216,
21163,
21217,
21219,
21179,
21181,
21182,
21161,
21180,
21177,
21178,
21171,
21172,
21159,
21158,
21170,
21167,
21168,
21169,
21173,
21187,
21188,
21221,
21222,
21228,
21227,
21164,
21185,
21184,
]

_charnames_64107 = [
3150,
3149,
3148,
-1,
-1,
3135,
3134,
3133,
3132,
3131,
3130,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3121,
3120,
3118,
3117,
3116,
3115,
3114,
3113,
3112,
3111,
3110,
3109,
3108,
3107,
3106,
3105,
3104,
3103,
3101,
3100,
3099,
3098,
3097,
3096,
3095,
3094,
3093,
3092,
3091,
3090,
3089,
3088,
3087,
3086,
3084,
3083,
3082,
3081,
3080,
3079,
3078,
3077,
3076,
3075,
3074,
3073,
3072,
3071,
3070,
3069,
3067,
3066,
3065,
3064,
3063,
3062,
3061,
3060,
3059,
3058,
3057,
3056,
3055,
3054,
3053,
3052,
3050,
3049,
3048,
3047,
3046,
3045,
3044,
3043,
3042,
3041,
3040,
3039,
3038,
3037,
3036,
3035,
3146,
3145,
3144,
3143,
3142,
3141,
3140,
3139,
3138,
3137,
]

_charnames_64434 = [
12439,
12438,
12429,
12428,
12435,
12434,
12433,
12432,
12446,
12445,
12440,
12427,
12426,
12447,
12443,
12442,
]

_charnames_65040 = [
18104,
18102,
18101,
18105,
18106,
18109,
18107,
18098,
18094,
18108,
]

_charnames_65060 = [
1862,
1860,
1728,
1786,
1785,
1883,
1882,
1863,
1861,
1729,
1719,
1718,
]

_charnames_65536 = [
10155,
10183,
10145,
10170,
10198,
10162,
10175,
10156,
10194,
10141,
10136,
10174,
-1,
10185,
10168,
10125,
10176,
10166,
10132,
10202,
10203,
10195,
10129,
10193,
10150,
10157,
10149,
10189,
10140,
10137,
10160,
10130,
10182,
10197,
10142,
10192,
10124,
10151,
10187,
-1,
10171,
10146,
10139,
10161,
10147,
10188,
10154,
10179,
10196,
10135,
10134,
10159,
10184,
10158,
10164,
10138,
10127,
10180,
10178,
-1,
10191,
10128,
-1,
10152,
10148,
10177,
10201,
10131,
10206,
10173,
10144,
10169,
10126,
10186,
10165,
10167,
10200,
10205,
-1,
-1,
10221,
10220,
10225,
10224,
10218,
10217,
10223,
10215,
10214,
10222,
10212,
10211,
10210,
10209,
]

_charnames_65664 = [
9999,
9998,
9997,
9984,
9983,
9982,
9996,
9995,
9993,
9992,
9990,
9989,
9987,
9986,
10049,
10048,
10047,
10046,
10045,
10233,
10232,
10053,
10052,
10051,
10230,
10229,
10043,
10042,
10041,
10040,
10039,
10029,
10028,
10027,
10026,
10025,
10234,
10024,
10023,
10022,
10010,
10009,
10008,
10007,
10006,
10005,
10004,
10003,
10002,
10001,
10020,
10019,
10018,
10017,
10016,
10015,
10014,
10013,
10012,
10037,
10036,
10035,
10034,
10033,
10032,
10031,
10056,
10055,
10086,
10085,
10083,
10082,
10081,
10080,
10079,
10078,
10076,
10075,
10074,
10073,
10072,
10071,
10235,
10070,
10069,
10067,
10066,
10065,
10064,
10063,
10062,
10061,
10060,
10059,
10120,
10110,
10109,
10108,
10107,
10106,
10105,
10104,
10103,
10102,
10101,
10099,
10098,
10097,
10096,
10095,
10094,
10093,
10092,
10091,
10090,
10117,
10116,
10115,
10114,
10113,
10112,
10118,
10119,
-1,
-1,
-1,
-1,
-1,
12896,
12897,
12903,
-1,
-1,
-1,
-1,
12883,
12828,
12835,
12858,
12865,
12844,
12850,
12877,
12871,
12841,
12832,
12839,
12862,
12869,
12845,
12851,
12878,
12872,
12886,
12831,
12838,
12861,
12868,
12849,
12855,
12882,
12876,
12885,
12830,
12837,
12860,
12867,
12848,
12854,
12881,
12875,
12842,
12833,
12840,
12863,
12870,
12846,
12852,
12879,
12873,
-1,
-1,
-1,
12894,
12891,
12893,
12892,
12890,
12902,
12901,
12900,
12899,
18937,
18933,
18938,
18910,
18921,
18916,
18913,
18924,
18915,
18942,
18926,
18931,
18918,
18935,
18914,
18920,
18943,
18927,
18932,
18919,
18936,
18941,
18925,
18944,
18975,
18953,
18973,
18977,
18951,
18981,
18978,
18964,
18968,
18969,
18972,
18985,
18952,
18950,
18966,
18967,
18974,
18961,
18956,
18949,
18979,
18965,
18960,
18982,
18984,
18955,
18959,
18986,
18983,
19119,
19120,
19110,
19113,
19131,
19116,
19136,
19123,
19111,
19114,
19128,
19129,
19126,
19134,
19107,
19122,
19132,
18988,
18989,
19135,
19115,
19130,
19121,
19081,
19030,
21079,
-1,
21951,
21965,
21953,
21950,
21963,
21954,
21964,
21966,
21952,
21962,
21968,
21967,
-1,
-1,
-1,
-1,
19080,
]

_charnames_66000 = [
17873,
17871,
17878,
17851,
17853,
17884,
17882,
17897,
17877,
17905,
17864,
17857,
17852,
17891,
17890,
17861,
17894,
17865,
17850,
17900,
17845,
17860,
17847,
17867,
17856,
17880,
17881,
17868,
17849,
17888,
17904,
17899,
17876,
17866,
17872,
17901,
17874,
17887,
17893,
17902,
17903,
17896,
17858,
17859,
17885,
17846,
]

_charnames_66176 = [
11316,
11312,
11314,
11315,
11330,
11331,
11328,
11320,
11318,
11305,
11327,
11310,
11324,
11326,
11308,
11306,
11309,
11307,
11321,
11325,
11311,
11323,
11322,
11303,
11304,
11317,
11313,
11329,
11319,
-1,
-1,
-1,
2668,
2654,
2663,
2648,
2626,
2651,
2649,
2669,
2671,
2673,
2636,
2672,
2664,
2645,
2633,
2634,
2630,
2667,
2624,
2642,
2670,
2641,
2647,
2653,
2635,
2657,
2661,
2627,
2655,
2656,
2644,
2625,
2659,
2660,
2631,
2632,
2643,
2658,
2666,
2646,
2629,
2652,
2637,
2640,
2639,
2638,
2650,
2662,
2628,
]

_charnames_66272 = [
2108,
2105,
2097,
2098,
2103,
2104,
2100,
2101,
2107,
2106,
2073,
2069,
2072,
2084,
2087,
2076,
2079,
2092,
2089,
2094,
2068,
2071,
2083,
2086,
2077,
2080,
2093,
2090,
]

_charnames_66384 = [
18455,
18454,
18452,
18430,
18442,
18432,
18429,
18433,
18428,
18423,
18450,
18449,
18448,
18447,
18435,
18446,
18445,
18422,
18439,
18444,
18453,
18420,
18421,
18417,
18412,
18440,
18441,
18443,
18451,
18438,
18436,
18411,
18413,
18415,
18424,
18416,
18414,
18425,
1855,
1854,
1851,
1853,
1852,
-1,
-1,
-1,
-1,
-1,
22841,
22853,
22836,
22830,
22839,
22832,
22844,
22828,
22833,
22825,
22843,
22831,
22821,
22851,
22850,
22838,
22849,
22827,
22818,
22842,
22848,
22819,
22847,
22846,
22824,
22835,
22823,
22852,
22845,
22820,
-1,
22854,
18349,
18395,
18392,
18383,
18382,
18389,
18388,
18371,
18398,
18386,
18385,
18356,
18354,
18344,
18348,
18347,
18355,
18393,
18366,
18397,
18380,
18379,
18364,
18363,
18362,
18391,
18374,
18373,
18377,
18376,
18394,
18360,
18390,
18359,
18358,
18396,
-1,
-1,
-1,
-1,
18350,
18352,
18351,
18370,
18345,
18346,
18367,
18368,
18407,
18405,
18402,
18404,
18403,
18406,
]

_charnames_66638 = [
20516,
20517,
6832,
6808,
6835,
6838,
6806,
6821,
6820,
6840,
6815,
6826,
6841,
6839,
6837,
6829,
6807,
6828,
6824,
6836,
6818,
6827,
6834,
6823,
6810,
6803,
6786,
6790,
6795,
6817,
6792,
6788,
6831,
6833,
6800,
6789,
6811,
6830,
6797,
6794,
6796,
6785,
6784,
6793,
6787,
6802,
6783,
6801,
6812,
6814,
18791,
18822,
18810,
18816,
18807,
18799,
18805,
18811,
18795,
18794,
18804,
18821,
18819,
18820,
18812,
18800,
18815,
18814,
18813,
18808,
18818,
18806,
18790,
18801,
18817,
18796,
18809,
18792,
18802,
18797,
-1,
-1,
18833,
18834,
18825,
18826,
18831,
18832,
18828,
18829,
18836,
18835,
-1,
-1,
-1,
-1,
-1,
-1,
18753,
18754,
18755,
18756,
18787,
18786,
18751,
18744,
18752,
18776,
18775,
18783,
18765,
18750,
18763,
18782,
18781,
18780,
18772,
18773,
18779,
18749,
18771,
18770,
18761,
18748,
18760,
18747,
18759,
18785,
18778,
18777,
18764,
18784,
18768,
18767,
-1,
-1,
-1,
-1,
18708,
18709,
18710,
18711,
18742,
18741,
18706,
18699,
18707,
18731,
18730,
18738,
18720,
18705,
18718,
18737,
18736,
18735,
18727,
18728,
18734,
18704,
18726,
18725,
18716,
18703,
18715,
18702,
18714,
18740,
18733,
18732,
18719,
18739,
18723,
18722,
-1,
-1,
-1,
-1,
14522,
14521,
14508,
14507,
14505,
14475,
14504,
14502,
14501,
14520,
14482,
14481,
14519,
14518,
14517,
14500,
14497,
14496,
14516,
14474,
14476,
14473,
14515,
14514,
14513,
14494,
14493,
14491,
14490,
14488,
14487,
14512,
14511,
14510,
14509,
14485,
14484,
14479,
14480,
14499,
]

_charnames_66864 = [
2749,
2758,
2742,
2709,
2746,
2714,
2745,
2712,
2718,
2688,
2724,
2713,
2721,
2700,
2734,
2722,
2750,
2708,
2697,
2739,
2737,
2733,
2756,
2727,
2748,
2690,
2691,
2693,
2755,
2728,
2754,
2706,
2701,
2740,
2753,
2716,
2757,
2707,
2689,
2731,
2743,
2752,
2703,
2751,
2717,
2702,
2720,
2694,
2696,
2725,
2730,
2736,
]

_charnames_67072 = [
9616,
9615,
9614,
9613,
9612,
9611,
9610,
9609,
9608,
9660,
9659,
9658,
9657,
9656,
9596,
9586,
9588,
9587,
9583,
9585,
9584,
9589,
9590,
9595,
9594,
9593,
9592,
9975,
9591,
9654,
9653,
9652,
9651,
9650,
9649,
9625,
9624,
9623,
9622,
9621,
9620,
9619,
9618,
9606,
9605,
9604,
9603,
9602,
9601,
9600,
9599,
9598,
9647,
9646,
9645,
9644,
9643,
9642,
9633,
9632,
9631,
9630,
9629,
9628,
9627,
9640,
9639,
9638,
9637,
9636,
9635,
9974,
9675,
9665,
9973,
9664,
9663,
9671,
9670,
9972,
9674,
9673,
9668,
9667,
9672,
9794,
9793,
9792,
9791,
9790,
9789,
9788,
9787,
9786,
9785,
9784,
9781,
9780,
9779,
9772,
9771,
9770,
9778,
9777,
9776,
9775,
9774,
9773,
9849,
9848,
9847,
9846,
9845,
9844,
9843,
9842,
9841,
9840,
9838,
9837,
9836,
9835,
9834,
9833,
9832,
9831,
9830,
9829,
9827,
9826,
9825,
9824,
9823,
9822,
9821,
9820,
9819,
9818,
9816,
9815,
9814,
9813,
9812,
9811,
9810,
9809,
9808,
9807,
9805,
9804,
9803,
9802,
9801,
9800,
9799,
9798,
9797,
9796,
9852,
9851,
9951,
9950,
9949,
9948,
9947,
9946,
9945,
9944,
9943,
9942,
9961,
9960,
9959,
9958,
9957,
9956,
9955,
9954,
9953,
9737,
9736,
9735,
9734,
9733,
9732,
9731,
9730,
9766,
9765,
9764,
9763,
9762,
9761,
9728,
9727,
9726,
9725,
9724,
9723,
9722,
9721,
9720,
9718,
9717,
9716,
9715,
9714,
9713,
9712,
9711,
9710,
9745,
9744,
9743,
9742,
9741,
9740,
9739,
9708,
9707,
9706,
9705,
9704,
9703,
9702,
9701,
9700,
9759,
9758,
9757,
9756,
9755,
9754,
9698,
9697,
9696,
9695,
9694,
9693,
9692,
9691,
9690,
9689,
9687,
9686,
9685,
9684,
9683,
9682,
9681,
9680,
9679,
9678,
9752,
9751,
9750,
9749,
9748,
9747,
9902,
9901,
9900,
9899,
9898,
9897,
9896,
9895,
9864,
9863,
9862,
9861,
9860,
9859,
9858,
9857,
9856,
9855,
9884,
9883,
9882,
9881,
9880,
9879,
9878,
9877,
9876,
9912,
9911,
9910,
9893,
9892,
9891,
9890,
9889,
9888,
9887,
9886,
9874,
9873,
9872,
9871,
9870,
9869,
9868,
9867,
9866,
9908,
9907,
9906,
9905,
9904,
]

_charnames_67392 = [
9929,
9928,
9927,
9926,
9925,
9924,
9923,
9922,
9921,
9920,
9919,
9918,
9917,
9937,
9936,
9935,
9934,
9933,
9932,
9931,
9939,
9938,
]

_charnames_67424 = [
9970,
9969,
9968,
9967,
9966,
9965,
9964,
9963,
]

_charnames_67584 = [
3030,
3029,
3028,
3027,
3026,
3025,
-1,
-1,
3024,
-1,
3011,
3010,
3009,
3008,
3007,
3005,
3004,
3003,
3002,
3001,
2999,
2998,
2997,
2996,
2995,
2993,
2992,
2991,
2990,
2989,
2987,
2986,
2985,
2984,
2983,
2981,
2980,
2979,
2978,
2977,
2975,
2974,
2973,
2972,
2971,
2969,
2968,
2967,
2966,
2965,
3016,
3015,
3014,
3013,
-1,
3022,
3021,
-1,
-1,
-1,
3019,
-1,
-1,
3018,
22447,
22460,
22458,
22459,
22443,
22450,
22448,
22444,
22441,
22449,
22457,
22456,
22455,
22454,
22437,
22446,
22453,
22438,
22452,
22451,
22439,
22442,
-1,
22473,
22469,
22464,
22468,
22466,
22465,
22472,
22471,
22467,
17715,
17729,
17726,
17728,
17711,
17718,
17716,
17712,
17709,
17717,
17725,
17724,
17723,
17727,
17722,
17705,
17714,
17721,
17706,
17720,
17719,
17707,
17710,
17730,
17742,
17741,
17734,
17736,
17739,
17740,
17737,
17735,
21092,
21105,
21091,
21118,
21116,
21117,
21090,
21101,
21108,
21106,
21102,
21099,
21084,
21107,
21089,
21115,
21088,
21114,
21087,
21113,
21086,
21112,
21095,
21104,
21111,
21096,
21110,
21109,
21085,
21097,
21100,
]

_charnames_67751 = [
21126,
21122,
21124,
21129,
21131,
21130,
21125,
21123,
21127,
]

_charnames_67808 = [
21337,
21349,
21347,
21348,
21333,
21340,
21338,
21334,
21331,
21339,
21346,
21345,
21344,
21343,
21327,
21336,
21342,
21328,
21341,
-1,
21329,
21332,
-1,
-1,
-1,
-1,
-1,
21354,
21356,
21353,
21352,
21355,
17918,
17932,
17930,
17931,
17915,
17922,
17920,
17916,
17913,
17921,
17929,
17928,
17927,
17926,
17910,
17919,
17925,
17911,
17924,
17923,
17909,
17914,
17940,
17939,
17937,
17941,
17936,
17938,
-1,
-1,
-1,
17942,
11344,
11359,
11355,
11357,
11342,
11347,
11354,
11346,
11353,
11340,
11352,
11338,
11351,
11349,
11337,
11334,
11348,
11356,
11350,
11336,
11335,
11345,
11343,
11341,
11339,
11358,
-1,
-1,
-1,
-1,
-1,
11360,
]

_charnames_67968 = [
8088,
8086,
8084,
8081,
8077,
8078,
8075,
8076,
8080,
8082,
8064,
8065,
8062,
8063,
8070,
8071,
8083,
8073,
8085,
8067,
8068,
8069,
8074,
8079,
8058,
8059,
8056,
8057,
8060,
8087,
8089,
8090,
8017,
8029,
8027,
8024,
8019,
8020,
8031,
8023,
8025,
8013,
8012,
8021,
8026,
8015,
8028,
8010,
8018,
8009,
8016,
8022,
8007,
8006,
8005,
8030,
-1,
-1,
-1,
-1,
8050,
8045,
8033,
8034,
7997,
7936,
7944,
7970,
7978,
7954,
7961,
7991,
7985,
7951,
7941,
7949,
7975,
7983,
7959,
7966,
-1,
-1,
7999,
7938,
7946,
7972,
7980,
7956,
7963,
7993,
7987,
8001,
7940,
7948,
7974,
7982,
7958,
7965,
7995,
7989,
7952,
7942,
7950,
7976,
7984,
7960,
7967,
7996,
7990,
8000,
7939,
7947,
7973,
7981,
7957,
7964,
7994,
7988,
8044,
8037,
8038,
8047,
8048,
8041,
8042,
8051,
8052,
8039,
19759,
19780,
19778,
19777,
-1,
19781,
19779,
-1,
-1,
-1,
-1,
-1,
19782,
19786,
19791,
19788,
19738,
19737,
19744,
19743,
-1,
19747,
19746,
19757,
-1,
19732,
19718,
19717,
19724,
19723,
19733,
19720,
19719,
19726,
19725,
19734,
19741,
19740,
19750,
19749,
19755,
19752,
19754,
19756,
19753,
19729,
19728,
19730,
19751,
19758,
19736,
19716,
-1,
-1,
-1,
-1,
19790,
19789,
19787,
-1,
-1,
-1,
-1,
19783,
19803,
19801,
19802,
19804,
19795,
19794,
19798,
19797,
]

_charnames_68176 = [
19764,
19772,
19771,
19770,
19773,
19767,
19765,
19763,
19768,
]

_charnames_68192 = [
18559,
18574,
18560,
18573,
18571,
18569,
18550,
18570,
18576,
18544,
18547,
18558,
18572,
18557,
18549,
18548,
18575,
18566,
18565,
18554,
18562,
18555,
18563,
18543,
18567,
18553,
18568,
18542,
18541,
18579,
18580,
18581,
18601,
18619,
18602,
18618,
18616,
18613,
18592,
18615,
18621,
18588,
18593,
18599,
18617,
18598,
18614,
18591,
18620,
18610,
18611,
18608,
18605,
18607,
18604,
18589,
18595,
18587,
18612,
18586,
18596,
18626,
18625,
18624,
]

_charnames_68288 = [
8257,
8284,
8283,
8277,
8278,
8281,
8274,
8286,
8312,
8261,
8260,
8273,
8272,
8275,
8253,
8285,
8270,
8264,
8269,
8291,
8280,
8252,
8290,
8289,
8247,
8256,
8258,
8288,
8292,
8248,
8266,
8263,
8267,
8287,
8250,
8249,
8254,
8311,
8310,
-1,
-1,
-1,
-1,
8306,
8308,
8305,
8304,
8307,
8299,
8301,
8297,
8296,
8295,
8298,
8300,
]

_charnames_68352 = [
12987,
12988,
12993,
12989,
12994,
12990,
12991,
12992,
13036,
13037,
13029,
13030,
13031,
13032,
13027,
13028,
13049,
13012,
13010,
13011,
13020,
13019,
13018,
13052,
13050,
13016,
13015,
13040,
13039,
13014,
13046,
13051,
13043,
13042,
12999,
12997,
12998,
13002,
13000,
13001,
13047,
13034,
13025,
13026,
13044,
13045,
13048,
13008,
13023,
13006,
13022,
13005,
13007,
13035,
-1,
-1,
-1,
13053,
5155,
7609,
11051,
11047,
11050,
11046,
22341,
22354,
22352,
22353,
22337,
22344,
22342,
22338,
22335,
22343,
22351,
22350,
22349,
22348,
22331,
22340,
22347,
22332,
22346,
22345,
22333,
22336,
-1,
-1,
22362,
22358,
22360,
22366,
22361,
22359,
22365,
22364,
22390,
22389,
22387,
22388,
22377,
22381,
22379,
22378,
22375,
22380,
22386,
22385,
22384,
22383,
22371,
22382,
22372,
22373,
22376,
-1,
-1,
-1,
-1,
-1,
22398,
22394,
22396,
22402,
22397,
22395,
22401,
22400,
18073,
18072,
18070,
18071,
18059,
18063,
18061,
18060,
18062,
18069,
18068,
18067,
18066,
18056,
18065,
18057,
18058,
18064,
]

_charnames_68521 = [
18081,
18077,
18079,
18083,
18080,
18078,
18082,
]

_charnames_68608 = [
18458,
18504,
18505,
18499,
18535,
18523,
18493,
18494,
18532,
18480,
18522,
18469,
18512,
18478,
18520,
18467,
18511,
18479,
18521,
18468,
18487,
18528,
18472,
18513,
18460,
18508,
18466,
18510,
18495,
18533,
18477,
18519,
18465,
18491,
18490,
18476,
18464,
18506,
18484,
18526,
18486,
18527,
18483,
18525,
18518,
18485,
18507,
18489,
18498,
18501,
18492,
18530,
18475,
18517,
18500,
18536,
18497,
18534,
18474,
18516,
18463,
18470,
18462,
18471,
18515,
18488,
18529,
18473,
18514,
18461,
18509,
18496,
18502,
]

_charnames_68736 = [
18308,
18312,
18307,
18310,
18283,
18282,
18284,
18306,
18309,
18277,
18329,
18305,
18304,
18296,
18297,
18303,
18326,
18327,
18302,
18301,
18311,
18316,
18294,
18295,
18292,
18278,
18281,
18317,
18318,
18325,
18322,
18319,
18300,
18293,
18299,
18328,
18290,
18291,
18288,
18279,
18289,
18285,
18313,
18314,
18324,
18321,
18298,
18286,
18287,
18280,
18315,
]

_charnames_68800 = [
18254,
18258,
18253,
18256,
18229,
18228,
18230,
18252,
18255,
18223,
18275,
18251,
18250,
18242,
18243,
18249,
18272,
18273,
18248,
18247,
18257,
18262,
18240,
18241,
18238,
18224,
18227,
18263,
18264,
18271,
18268,
18265,
18246,
18239,
18245,
18274,
18236,
18237,
18234,
18225,
18235,
18231,
18259,
18260,
18270,
18267,
18244,
18232,
18233,
18226,
18261,
]

_charnames_69216 = [
21919,
21911,
21912,
21917,
21918,
21914,
21915,
21921,
21920,
21887,
21883,
21886,
21898,
21901,
21890,
21893,
21906,
21903,
21908,
21882,
21885,
21897,
21900,
21891,
21894,
21907,
21904,
21926,
21925,
21924,
21927,
]

_charnames_69632 = [
16014,
16015,
16011,
16013,
16012,
15906,
15909,
15928,
15929,
15914,
15915,
15879,
15880,
15881,
15882,
15943,
15908,
15890,
15907,
15924,
15923,
15932,
15931,
15898,
15935,
15934,
15927,
15926,
15896,
15887,
15886,
15903,
15902,
15897,
15889,
15888,
15905,
15904,
15899,
15918,
15917,
15938,
15937,
15941,
15939,
15940,
15921,
15883,
15912,
15911,
15913,
15942,
15920,
15894,
15892,
15893,
15984,
15991,
15987,
15988,
15985,
15986,
15977,
15978,
15979,
15980,
15990,
15983,
15989,
15982,
15992,
16009,
16008,
16022,
16021,
16019,
16023,
16018,
-1,
-1,
-1,
-1,
15965,
15947,
15950,
15960,
15963,
15954,
15956,
15971,
15969,
15952,
15948,
15951,
15961,
15964,
15955,
15957,
15972,
15970,
15968,
15967,
16004,
16005,
15996,
15997,
16002,
16003,
15999,
16000,
16007,
16006,
]

_charnames_69759 = [
15973,
19966,
19967,
19963,
19909,
19912,
19931,
19932,
19917,
19918,
19948,
19911,
19944,
19910,
19927,
19926,
19935,
19934,
19907,
19938,
19937,
19930,
19929,
19905,
19901,
19900,
19895,
19894,
19893,
19920,
19906,
19903,
19902,
19897,
19896,
19908,
19924,
19923,
19941,
19940,
19945,
19942,
19921,
19946,
19943,
19915,
19914,
19916,
19947,
19953,
19956,
19957,
19954,
19955,
19959,
19952,
19958,
19951,
19964,
19965,
19976,
19975,
19974,
19968,
19971,
19973,
19972,
]

_charnames_69840 = [
7381,
7380,
7393,
7392,
7391,
7390,
7372,
7369,
7385,
7370,
7378,
7383,
7377,
7382,
7389,
7386,
7387,
7368,
7394,
7376,
7388,
7379,
7384,
7375,
7373,
]

_charnames_69872 = [
7405,
7406,
7397,
7398,
7403,
7404,
7400,
7401,
7408,
7407,
-1,
-1,
-1,
-1,
-1,
-1,
2364,
2365,
2363,
2330,
2327,
2322,
2329,
2308,
2307,
2314,
2313,
2292,
2317,
2316,
2311,
2310,
2290,
2286,
2285,
2297,
2296,
2291,
2288,
2287,
2299,
2298,
2293,
2305,
2304,
2320,
2319,
2325,
2301,
2302,
2324,
2326,
2321,
2323,
2328,
2350,
2357,
2358,
2353,
2354,
2359,
2352,
2355,
2351,
2356,
2368,
2370,
2360,
2369,
-1,
2342,
2343,
2334,
2335,
2340,
2341,
2337,
2338,
2345,
2344,
2366,
2347,
2346,
2367,
]

_charnames_69968 = [
8479,
8476,
8471,
8478,
8473,
8457,
8456,
8463,
8462,
8466,
8465,
8460,
8459,
8446,
8436,
8435,
8442,
8441,
8447,
8438,
8437,
8444,
8443,
8448,
8454,
8453,
8469,
8468,
8474,
8451,
8475,
8470,
8472,
8477,
8450,
8482,
8484,
8483,
8480,
]

_charnames_70016 = [
6746,
6741,
6737,
6677,
6680,
6699,
6700,
6685,
6686,
6655,
6656,
6657,
6658,
6715,
6679,
6712,
6678,
6695,
6694,
6703,
6702,
6669,
6706,
6705,
6698,
6697,
6667,
6663,
6662,
6674,
6673,
6668,
6665,
6664,
6676,
6675,
6670,
6689,
6688,
6709,
6708,
6713,
6710,
6711,
6692,
6691,
6659,
6683,
6682,
6684,
6714,
6726,
6729,
6730,
6727,
6728,
6719,
6720,
6721,
6722,
6732,
6725,
6731,
6724,
6738,
6740,
6745,
6742,
6774,
6770,
6769,
6777,
6751,
6753,
6744,
6733,
6772,
6752,
-1,
-1,
6765,
6766,
6757,
6758,
6763,
6764,
6760,
6761,
6768,
6767,
6773,
6743,
6775,
6776,
6750,
6749,
-1,
6612,
6604,
6605,
6610,
6611,
6607,
6608,
6614,
6613,
6590,
6588,
6589,
6598,
6599,
6592,
6593,
6601,
6600,
6596,
6595,
]

_charnames_70144 = [
19825,
19828,
19859,
19854,
19861,
19827,
19857,
19826,
19845,
19844,
19832,
19831,
19830,
19823,
19851,
19850,
19848,
19847,
-1,
19821,
19817,
19816,
19811,
19809,
19822,
19819,
19818,
19813,
19810,
19812,
19824,
19839,
19838,
19836,
19835,
19834,
19858,
19852,
19856,
19842,
19853,
19855,
19860,
19841,
19866,
19867,
19868,
19869,
19871,
19865,
19870,
19864,
19879,
19877,
19878,
19876,
19885,
19884,
19886,
19880,
19883,
19887,
19875,
]

_charnames_70272 = [
9485,
9482,
9478,
9484,
9463,
9462,
9469,
-1,
9468,
-1,
9472,
9471,
9466,
9465,
-1,
9455,
9447,
9446,
9441,
9440,
9439,
9456,
9449,
9448,
9443,
9442,
9457,
9460,
9459,
9475,
-1,
9474,
9480,
9476,
9453,
9481,
9477,
9479,
9483,
9451,
9452,
9486,
-1,
-1,
-1,
-1,
-1,
-1,
19641,
19644,
19671,
19672,
19657,
19658,
19682,
19643,
19678,
19642,
19670,
19669,
19652,
19651,
19650,
19639,
19675,
19674,
19648,
19646,
19647,
19637,
19633,
19632,
19627,
19626,
19663,
19625,
19638,
19635,
19634,
19629,
19628,
19640,
19667,
19666,
19656,
19655,
19654,
19679,
19676,
19664,
19680,
19677,
19660,
19661,
19681,
19711,
19701,
19704,
19705,
19702,
19703,
19707,
19700,
19706,
19699,
19710,
19709,
-1,
-1,
-1,
-1,
-1,
19693,
19694,
19685,
19686,
19691,
19692,
19688,
19689,
19696,
19695,
-1,
-1,
-1,
-1,
-1,
-1,
19232,
19233,
19236,
19229,
-1,
19172,
19175,
19194,
19195,
19180,
19181,
19147,
19149,
-1,
-1,
19210,
19174,
-1,
-1,
19207,
19173,
19190,
19189,
19198,
19197,
19164,
19201,
19200,
19193,
19192,
19162,
19158,
19157,
19169,
19168,
19163,
19160,
19159,
19171,
19170,
19165,
-1,
19184,
19183,
19204,
19203,
19208,
19205,
19206,
-1,
19187,
19186,
-1,
19154,
19178,
19177,
19179,
19209,
-1,
-1,
19238,
19235,
19220,
19223,
19224,
19221,
19222,
19213,
19214,
-1,
-1,
19226,
19219,
-1,
-1,
19225,
19218,
19230,
-1,
-1,
19239,
-1,
-1,
-1,
-1,
-1,
-1,
19240,
-1,
-1,
-1,
-1,
-1,
19237,
19153,
19152,
19148,
19150,
19215,
19216,
-1,
-1,
1645,
1647,
1640,
1641,
1643,
1644,
1646,
-1,
-1,
-1,
1653,
1652,
1651,
1649,
1650,
]

_charnames_70656 = [
20655,
20658,
20683,
20684,
20663,
20664,
20639,
20640,
20641,
20642,
20698,
20657,
20696,
20656,
20679,
20678,
20687,
20686,
20634,
20633,
20690,
20689,
20682,
20681,
20631,
20630,
20646,
20645,
20652,
20651,
20635,
20648,
20647,
20654,
20653,
20637,
20636,
20670,
20669,
20693,
20692,
20673,
20672,
20694,
20667,
20666,
20676,
20675,
20695,
20661,
20660,
20662,
20697,
20708,
20711,
20712,
20709,
20710,
20701,
20702,
20703,
20704,
20714,
20707,
20713,
20706,
20736,
20742,
20739,
20735,
20740,
20738,
20741,
20745,
20743,
20731,
20730,
20748,
20747,
20749,
20726,
20727,
20718,
20719,
20724,
20725,
20721,
20722,
20729,
20728,
-1,
20744,
-1,
20746,
]

_charnames_70784 = [
5052,
4972,
4975,
4991,
4992,
4980,
4981,
4950,
4951,
4952,
4953,
5008,
4974,
5004,
4973,
4987,
4986,
4995,
4994,
4964,
4998,
4997,
4990,
4989,
4962,
4958,
4957,
4969,
4968,
4963,
4960,
4959,
4971,
4970,
4965,
4984,
4983,
5001,
5000,
5005,
5002,
5003,
5006,
4954,
4978,
4977,
4979,
5007,
5018,
5024,
5025,
5019,
5020,
5011,
5012,
5013,
5014,
5027,
5023,
5017,
5026,
5022,
5016,
5050,
5048,
5044,
5045,
5049,
5047,
5055,
5053,
5054,
]

_charnames_70864 = [
5038,
5039,
5030,
5031,
5036,
5037,
5033,
5034,
5041,
5040,
]

_charnames_71040 = [
6467,
6471,
6498,
6499,
6487,
6488,
6462,
6463,
6464,
6465,
6515,
6470,
6511,
6468,
6494,
6493,
6502,
6501,
6475,
6505,
6504,
6497,
6496,
6473,
6455,
6454,
6480,
6479,
6474,
6459,
6458,
6482,
6481,
6476,
6491,
6490,
6508,
6507,
6512,
6509,
6510,
6513,
6466,
6485,
6484,
6486,
6514,
6555,
6560,
6561,
6558,
6559,
6556,
6557,
-1,
-1,
6563,
6554,
6562,
6553,
6547,
6548,
6543,
6544,
6546,
6545,
6570,
6569,
6539,
6540,
6567,
6566,
6565,
6571,
6522,
6523,
6528,
6527,
6526,
6536,
6537,
6535,
6524,
6534,
6533,
6531,
6530,
6532,
6457,
6451,
6452,
6469,
6551,
6552,
]

_charnames_71168 = [
8892,
8895,
8914,
8915,
8900,
8901,
8870,
8871,
8872,
8873,
8930,
8894,
8927,
8893,
8910,
8909,
8918,
8917,
8884,
8921,
8920,
8913,
8912,
8882,
8878,
8877,
8889,
8888,
8883,
8880,
8879,
8891,
8890,
8885,
8904,
8903,
8924,
8923,
8928,
8925,
8926,
8907,
8874,
8898,
8897,
8899,
8929,
8906,
8940,
8943,
8944,
8941,
8942,
8933,
8934,
8935,
8936,
8946,
8939,
8945,
8938,
8970,
8966,
8967,
8969,
8963,
8962,
8972,
8971,
]

_charnames_71248 = [
8958,
8959,
8950,
8951,
8956,
8957,
8953,
8954,
8961,
8960,
-1,
-1,
-1,
-1,
-1,
-1,
8990,
8980,
8993,
8986,
8991,
8982,
8983,
8987,
8988,
8976,
8978,
8979,
8985,
]

_charnames_71296 = [
4869,
4872,
4890,
4891,
4873,
4874,
4907,
4871,
4903,
4870,
4886,
4885,
4894,
4893,
4861,
4897,
4896,
4889,
4888,
4859,
4855,
4854,
4866,
4865,
4860,
4857,
4856,
4868,
4867,
4862,
4883,
4882,
4900,
4899,
4904,
4901,
4880,
4905,
4902,
4876,
4877,
4906,
4879,
4938,
4935,
4926,
4929,
4930,
4927,
4928,
4932,
4925,
4931,
4924,
4936,
4937,
]

_charnames_71360 = [
4918,
4919,
4910,
4911,
4916,
4917,
4913,
4914,
4921,
4920,
]

_charnames_71424 = [
12923,
12922,
12909,
12910,
12917,
12913,
12920,
12919,
12935,
12938,
12926,
12941,
12916,
12937,
12939,
12936,
12908,
12940,
12911,
12932,
12931,
12929,
12914,
12928,
12934,
12925,
-1,
-1,
-1,
12979,
12980,
12978,
12943,
12947,
12950,
12951,
12948,
12949,
12953,
12944,
12952,
12946,
12945,
12974,
-1,
-1,
-1,
-1,
12964,
12965,
12956,
12957,
12962,
12963,
12959,
12960,
12967,
12966,
12983,
12982,
12971,
12972,
12973,
12975,
]

_charnames_71840 = [
22099,
22081,
22100,
22071,
22074,
22073,
22105,
22090,
22085,
22095,
22083,
22106,
22104,
22087,
22072,
22091,
22088,
22096,
22102,
22098,
22107,
22082,
22084,
22108,
22103,
22079,
22078,
22077,
22080,
22093,
22094,
22101,
22059,
22041,
22060,
22031,
22034,
22033,
22065,
22050,
22045,
22055,
22043,
22066,
22064,
22047,
22032,
22051,
22048,
22056,
22062,
22058,
22067,
22042,
22044,
22068,
22063,
22039,
22038,
22037,
22040,
22053,
22054,
22061,
22119,
22120,
22111,
22112,
22117,
22118,
22114,
22115,
22122,
22121,
22127,
22125,
22126,
22132,
22133,
22129,
22130,
22135,
22134,
]

_charnames_72384 = [
17606,
17612,
17624,
17623,
17628,
17618,
17619,
17608,
17625,
17626,
17611,
17620,
17629,
17617,
17603,
17602,
17609,
17605,
17621,
17598,
17616,
17630,
17627,
17613,
17622,
17599,
17600,
17614,
17594,
17597,
17593,
17595,
17589,
17596,
17592,
17590,
17591,
17646,
17644,
17642,
17647,
17648,
17643,
17639,
17637,
17640,
17641,
17649,
17655,
17651,
17652,
17633,
17631,
17653,
17634,
17635,
17656,
]

_charnames_72704 = [
16058,
16061,
16077,
16078,
16066,
16067,
16037,
16038,
16039,
-1,
16094,
16060,
16090,
16059,
16073,
16072,
16081,
16080,
16050,
16084,
16083,
16076,
16075,
16048,
16044,
16043,
16055,
16054,
16049,
16046,
16045,
16057,
16056,
16051,
16070,
16069,
16087,
16086,
16091,
16088,
16089,
16092,
16040,
16064,
16063,
16065,
16093,
16129,
16132,
16133,
16130,
16131,
16123,
16124,
16125,
-1,
16135,
16128,
16134,
16127,
16160,
16159,
16155,
16156,
16158,
16152,
16151,
16164,
16163,
16162,
]

_charnames_72784 = [
16147,
16148,
16139,
16140,
16145,
16146,
16142,
16143,
16150,
16149,
16120,
16098,
16101,
16111,
16114,
16105,
16107,
16118,
16116,
16103,
16099,
16102,
16112,
16115,
16106,
16108,
16119,
16117,
16165,
-1,
-1,
-1,
8577,
8576,
8552,
8551,
8566,
8539,
8558,
8557,
8564,
8538,
8536,
8535,
8555,
8540,
8549,
8548,
8567,
8562,
8534,
8533,
8554,
8560,
8542,
8543,
8569,
8559,
8561,
8563,
8545,
8546,
8565,
8568,
-1,
-1,
8510,
8509,
8524,
8497,
8516,
8515,
8522,
8496,
8494,
8493,
8513,
8498,
8507,
8506,
8525,
8520,
8492,
8491,
8512,
8518,
8500,
8501,
-1,
8517,
8519,
8521,
8503,
8504,
8523,
8526,
8575,
8573,
8571,
8574,
8572,
8529,
8528,
]

_charnames_73728 = [
1019,
1081,
1080,
1079,
1078,
1077,
1076,
1075,
1074,
1105,
1020,
1038,
1037,
1033,
1032,
1036,
1030,
1029,
1035,
1025,
1034,
1039,
1040,
1046,
1045,
1044,
1043,
1042,
1102,
1098,
1101,
1100,
1048,
1058,
1057,
1056,
1055,
1052,
1051,
1054,
1053,
1060,
1059,
1094,
1096,
1082,
1088,
1087,
1086,
1085,
1089,
1104,
1091,
1092,
1093,
1072,
1062,
1068,
1069,
1067,
1065,
1066,
1071,
1070,
1264,
1275,
1277,
1265,
1270,
1272,
1271,
1273,
1274,
1289,
1293,
1292,
1291,
1278,
1283,
1281,
1284,
1287,
1288,
1285,
1286,
756,
757,
783,
782,
780,
779,
763,
764,
761,
762,
765,
789,
776,
777,
788,
770,
767,
769,
768,
787,
786,
785,
784,
774,
775,
796,
792,
795,
794,
798,
810,
799,
802,
804,
808,
809,
806,
698,
752,
753,
751,
745,
748,
749,
699,
739,
755,
740,
741,
742,
743,
744,
754,
1106,
1172,
1173,
1145,
1155,
1154,
1152,
1149,
1148,
1150,
1176,
1175,
1174,
1156,
1159,
1160,
1161,
1164,
1163,
1162,
1168,
1166,
1169,
1107,
1115,
1116,
1117,
1118,
1135,
1131,
1132,
1129,
1130,
1133,
1120,
1121,
1122,
1111,
1112,
1114,
1113,
1125,
1124,
251,
375,
252,
273,
272,
271,
276,
274,
267,
269,
334,
332,
335,
336,
298,
294,
296,
293,
327,
328,
325,
326,
261,
257,
262,
263,
264,
265,
313,
310,
311,
316,
315,
351,
350,
307,
306,
303,
304,
302,
338,
348,
347,
322,
323,
354,
286,
285,
282,
283,
281,
287,
353,
342,
343,
344,
355,
365,
368,
371,
372,
362,
364,
363,
374,
356,
357,
359,
360,
361,
369,
370,
373,
436,
439,
376,
405,
404,
406,
398,
400,
401,
408,
385,
386,
378,
384,
383,
382,
381,
380,
397,
388,
396,
394,
392,
395,
409,
434,
410,
413,
414,
416,
415,
418,
419,
423,
422,
425,
433,
431,
432,
426,
430,
429,
428,
1317,
1319,
1321,
1322,
1295,
1297,
1298,
1306,
1305,
1304,
1303,
1302,
1301,
1300,
1307,
1308,
1314,
1313,
1312,
1311,
1310,
1316,
1323,
1349,
1348,
1341,
1344,
1343,
1331,
1332,
1337,
1334,
1335,
1336,
1338,
1340,
1339,
1324,
1326,
1329,
1328,
1327,
1330,
1347,
1346,
1345,
442,
486,
490,
491,
489,
497,
496,
495,
499,
523,
522,
451,
455,
454,
452,
453,
445,
450,
448,
449,
456,
457,
520,
519,
504,
501,
502,
508,
506,
479,
483,
482,
481,
484,
485,
517,
516,
513,
525,
466,
467,
465,
464,
463,
461,
469,
468,
511,
470,
476,
475,
474,
473,
524,
546,
547,
549,
532,
531,
530,
528,
529,
544,
545,
537,
539,
540,
543,
542,
533,
536,
535,
575,
562,
571,
569,
570,
573,
572,
567,
566,
564,
565,
550,
561,
560,
555,
556,
559,
553,
554,
558,
551,
552,
557,
574,
5,
101,
104,
108,
107,
106,
111,
110,
109,
167,
166,
171,
170,
138,
139,
136,
137,
162,
163,
164,
151,
147,
150,
149,
133,
134,
132,
130,
131,
145,
144,
142,
143,
158,
159,
160,
169,
126,
125,
124,
121,
122,
127,
155,
154,
156,
112,
115,
114,
118,
117,
116,
172,
173,
175,
176,
177,
178,
184,
182,
183,
179,
180,
181,
246,
249,
248,
247,
185,
245,
186,
224,
223,
201,
203,
221,
217,
220,
194,
192,
193,
195,
215,
214,
219,
212,
211,
199,
198,
206,
225,
232,
230,
229,
227,
244,
233,
236,
237,
238,
243,
242,
239,
240,
241,
1248,
1252,
1253,
1256,
1255,
1254,
1249,
1250,
1260,
1261,
1257,
1258,
1222,
1247,
1243,
1244,
1246,
1245,
1223,
1233,
1232,
1231,
1225,
1229,
1234,
1235,
1238,
1239,
1241,
1242,
1001,
1012,
1002,
1006,
1004,
1005,
1007,
1010,
1008,
1009,
1013,
1017,
1016,
1018,
924,
967,
966,
961,
964,
963,
926,
947,
945,
946,
941,
952,
950,
949,
933,
937,
935,
936,
931,
929,
965,
968,
996,
969,
991,
990,
987,
988,
989,
994,
995,
992,
993,
970,
982,
981,
980,
979,
978,
977,
976,
975,
974,
973,
983,
984,
1374,
1377,
1376,
1375,
1378,
1351,
1361,
1362,
1360,
1359,
1363,
1356,
1357,
1354,
1355,
1364,
1366,
1371,
1370,
1369,
1372,
1405,
1406,
1408,
1407,
641,
674,
642,
670,
662,
663,
668,
661,
660,
666,
665,
664,
655,
653,
658,
650,
649,
648,
647,
646,
673,
671,
675,
676,
678,
677,
603,
604,
613,
612,
611,
610,
609,
608,
606,
607,
614,
617,
616,
618,
628,
627,
626,
633,
632,
629,
631,
630,
597,
600,
599,
579,
592,
585,
584,
591,
590,
581,
582,
589,
588,
587,
586,
602,
593,
595,
596,
601,
634,
640,
635,
639,
688,
694,
689,
690,
691,
696,
695,
679,
687,
684,
685,
686,
682,
683,
680,
681,
1178,
1193,
1191,
1190,
1192,
1194,
1197,
1196,
1179,
1187,
1186,
1183,
1182,
1185,
1184,
1198,
1200,
1219,
1220,
1210,
1218,
1216,
1211,
1215,
1213,
1214,
1201,
1209,
1208,
1202,
1206,
1207,
811,
913,
912,
910,
909,
908,
922,
921,
885,
894,
891,
890,
888,
889,
895,
892,
893,
896,
873,
879,
876,
878,
877,
884,
880,
883,
882,
918,
919,
812,
871,
870,
850,
862,
861,
863,
865,
864,
854,
857,
856,
872,
867,
868,
813,
840,
841,
847,
838,
816,
819,
818,
817,
820,
846,
833,
832,
831,
845,
827,
844,
843,
836,
835,
842,
824,
823,
822,
848,
849,
897,
902,
899,
900,
901,
903,
905,
904,
920,
915,
916,
917,
1396,
1398,
1399,
1401,
1400,
1403,
1389,
1395,
1394,
1390,
1391,
1393,
1392,
1381,
1382,
1385,
1387,
1386,
548,
1026,
1047,
1097,
773,
791,
807,
747,
1134,
1128,
275,
268,
440,
407,
1315,
492,
488,
446,
458,
526,
507,
514,
462,
510,
472,
140,
228,
204,
200,
1262,
1240,
1011,
925,
960,
959,
942,
999,
1379,
1373,
667,
1217,
875,
911,
]

_charnames_74752 = [
1483,
1467,
1429,
1447,
1502,
1498,
1557,
1544,
1469,
1431,
1449,
1507,
1497,
1556,
1543,
1421,
1442,
1500,
1493,
1552,
1539,
1521,
1479,
1466,
1428,
1446,
1506,
1496,
1555,
1542,
1520,
1478,
1465,
1427,
1445,
1476,
1455,
1456,
1425,
1436,
1505,
1495,
1554,
1541,
1528,
1475,
1453,
1454,
1424,
1435,
1510,
1509,
1526,
1481,
1458,
1459,
1420,
1441,
1463,
1462,
1412,
1416,
1415,
1414,
1504,
1492,
1491,
1490,
1550,
1551,
1535,
1537,
1536,
1538,
1484,
1468,
1430,
1448,
1503,
1527,
1482,
1460,
1418,
1419,
1439,
1440,
1546,
1547,
1523,
1485,
1515,
1473,
1437,
1514,
1472,
1524,
1518,
1531,
1532,
1517,
1529,
1563,
1562,
1560,
1561,
1422,
1443,
1501,
1494,
1553,
1540,
-1,
1570,
1569,
1568,
1566,
1567,
]

_charnames_74880 = [
1027,
1024,
1103,
1276,
1269,
1268,
1267,
1282,
797,
790,
803,
801,
805,
725,
723,
724,
734,
733,
738,
717,
714,
716,
715,
731,
730,
737,
712,
711,
709,
710,
705,
703,
704,
706,
721,
720,
719,
736,
735,
728,
727,
1153,
1151,
1167,
1170,
1144,
1143,
1142,
1139,
1140,
1137,
1138,
1141,
1127,
333,
297,
292,
291,
329,
256,
260,
259,
314,
301,
339,
340,
341,
346,
318,
321,
320,
280,
352,
367,
438,
393,
417,
424,
1320,
1299,
498,
503,
477,
471,
168,
71,
66,
65,
70,
63,
62,
69,
68,
60,
59,
67,
98,
97,
82,
81,
76,
75,
74,
83,
79,
78,
88,
87,
86,
91,
90,
92,
46,
38,
45,
44,
42,
41,
43,
54,
53,
56,
55,
51,
50,
49,
48,
99,
35,
8,
21,
20,
19,
18,
17,
16,
15,
13,
12,
11,
34,
22,
33,
32,
27,
28,
31,
30,
29,
26,
25,
95,
94,
231,
222,
218,
208,
209,
207,
1259,
1228,
1227,
958,
943,
940,
957,
956,
955,
953,
954,
928,
932,
930,
672,
669,
654,
657,
615,
624,
623,
622,
621,
638,
637,
693,
1199,
1205,
1204,
866,
858,
839,
829,
828,
1402,
1388,
1384,
]

_charnames_77824 = [
13128,
13127,
13126,
13125,
13120,
13121,
13117,
13119,
13118,
13124,
13123,
13122,
13115,
13114,
13113,
13112,
13106,
13107,
13111,
13110,
13104,
13105,
13109,
13108,
13173,
13172,
13171,
13170,
13169,
13168,
13167,
13166,
13165,
13164,
13140,
13139,
13130,
13131,
13138,
13137,
13136,
13135,
13134,
13133,
13132,
13095,
13096,
13102,
13093,
13094,
13091,
13092,
13101,
13089,
13090,
13100,
13099,
13098,
13097,
13162,
13161,
13160,
13159,
13158,
13157,
13156,
13155,
13154,
13153,
13151,
13150,
13149,
13148,
13147,
13146,
13145,
13144,
13143,
13142,
13174,
14237,
14236,
14235,
14234,
14228,
14229,
14233,
14232,
14231,
14230,
14146,
14135,
14138,
14137,
14136,
14145,
14144,
14143,
14142,
14141,
14140,
14139,
14148,
14149,
14158,
14157,
14156,
14155,
14154,
14153,
14152,
14151,
14150,
14164,
14163,
14162,
14161,
14160,
13424,
13423,
13422,
13421,
13420,
13419,
13418,
13415,
13416,
13417,
13413,
13412,
13411,
13410,
13409,
13408,
13407,
13406,
13405,
13404,
13402,
13401,
13400,
13399,
13398,
13397,
13396,
13392,
13393,
13395,
13394,
13390,
13381,
13382,
13389,
13388,
13379,
13380,
13387,
13386,
13385,
13384,
13383,
13377,
13376,
13375,
13374,
13373,
13372,
13368,
13369,
13371,
13366,
13367,
13370,
13327,
13336,
13335,
13334,
13333,
13332,
13331,
13330,
13329,
13328,
13347,
13339,
13340,
13346,
13337,
13338,
13345,
13344,
13343,
13342,
13341,
13364,
13363,
13362,
13361,
13360,
13359,
13358,
13349,
13357,
13356,
13355,
13354,
13353,
13352,
13351,
13350,
14004,
14003,
14002,
14001,
14000,
13999,
13998,
13996,
13997,
13994,
13995,
13992,
13991,
13990,
13989,
13988,
13987,
13983,
13984,
13981,
13982,
13986,
13985,
13970,
13971,
13979,
13978,
13977,
13976,
13975,
13974,
13973,
13968,
13969,
13972,
14014,
14013,
14012,
14011,
14006,
14007,
14010,
14009,
14008,
13715,
13716,
13724,
13723,
13722,
13721,
13720,
13719,
13718,
13717,
13713,
13712,
13711,
13703,
13704,
13710,
13709,
13708,
13707,
13706,
13705,
13701,
13691,
13692,
13700,
13699,
13698,
13697,
13696,
13695,
13694,
13693,
13689,
13681,
13682,
13688,
13687,
13686,
13685,
13684,
13679,
13680,
13677,
13678,
13683,
13675,
13674,
13673,
13672,
13671,
13667,
13668,
13665,
13666,
13663,
13664,
13670,
13669,
13732,
13726,
13729,
13728,
13727,
13731,
13730,
13785,
13784,
13783,
13782,
13781,
13777,
13778,
13774,
13776,
13775,
13780,
13779,
13797,
13787,
13788,
13796,
13795,
13794,
13793,
13792,
13791,
13790,
13789,
13763,
13764,
13772,
13771,
13770,
13769,
13768,
13761,
13762,
13767,
13766,
13765,
13759,
13758,
13757,
13756,
13755,
13754,
13750,
13751,
13748,
13749,
13753,
13752,
13746,
13745,
13744,
13737,
13738,
13743,
13735,
13736,
13742,
13741,
13740,
13739,
13803,
13802,
13801,
13800,
13799,
14257,
14256,
14255,
14254,
14253,
14249,
14250,
14252,
14251,
14177,
14176,
14175,
14174,
14169,
14170,
14173,
14172,
14171,
14167,
14168,
14181,
14182,
14179,
14180,
14186,
14185,
14184,
14183,
14266,
14265,
14264,
14263,
14262,
14261,
14260,
14259,
14226,
14219,
14220,
14225,
14224,
14223,
14217,
14218,
14222,
14221,
13642,
13644,
13643,
13653,
13645,
13646,
13652,
13651,
13650,
13649,
13648,
13647,
13606,
13607,
13612,
13591,
13599,
13598,
13597,
13596,
13595,
13594,
13593,
13592,
13611,
13610,
13604,
13605,
13602,
13603,
13600,
13601,
13609,
13608,
13640,
13639,
13632,
13633,
13638,
13630,
13631,
13637,
13636,
13635,
13628,
13629,
13634,
13626,
13617,
13618,
13625,
13614,
13616,
13615,
13624,
13623,
13622,
13621,
13620,
13619,
13655,
13656,
13660,
13659,
13658,
13657,
13265,
13264,
13263,
13262,
13261,
13260,
13259,
13258,
13257,
13243,
13242,
13241,
13240,
13239,
13238,
13237,
13236,
13232,
13234,
13233,
13235,
13255,
13254,
13253,
13252,
13251,
13245,
13246,
13250,
13249,
13248,
13247,
13230,
13229,
13228,
13223,
13224,
13221,
13222,
13219,
13220,
13227,
13217,
13218,
13226,
13225,
13269,
13268,
13267,
13323,
13322,
13321,
13320,
13314,
13315,
13319,
13318,
13317,
13316,
13312,
13311,
13310,
13309,
13308,
13307,
13306,
13302,
13303,
13305,
13304,
13324,
13294,
13293,
13292,
13291,
13290,
13289,
13288,
13287,
13286,
13276,
13277,
13274,
13275,
13284,
13283,
13282,
13281,
13280,
13279,
13272,
13273,
13278,
13299,
13298,
13296,
13297,
13518,
13519,
13525,
13524,
13523,
13516,
13517,
13509,
13515,
13514,
13513,
13512,
13511,
13510,
13522,
13521,
13520,
13559,
13562,
13561,
13560,
13572,
13571,
13570,
13569,
13568,
13567,
13566,
13565,
13563,
13564,
13550,
13551,
13557,
13556,
13555,
13548,
13549,
13546,
13547,
13554,
13553,
13552,
13544,
13545,
13534,
13535,
13542,
13541,
13532,
13533,
13540,
13539,
13527,
13531,
13530,
13529,
13528,
13538,
13537,
13536,
13583,
13582,
13581,
13580,
13579,
13578,
13577,
13576,
13575,
13574,
13585,
13587,
13586,
13588,
14191,
14192,
14199,
14189,
14190,
14198,
14197,
14196,
14195,
14194,
14193,
14202,
14201,
14274,
14273,
14272,
14271,
14270,
14269,
14268,
14085,
14077,
14078,
14074,
14076,
14075,
14084,
14083,
14082,
14081,
14080,
14079,
14063,
14064,
14072,
14071,
14070,
14069,
14068,
14061,
14062,
14067,
14066,
14065,
14096,
14095,
14094,
14093,
14092,
14091,
14090,
14089,
14088,
14087,
13855,
13847,
13848,
13854,
13853,
13852,
13845,
13846,
13851,
13850,
13849,
13818,
13817,
13816,
13815,
13806,
13808,
13807,
13814,
13813,
13809,
13810,
13812,
13811,
13831,
13830,
13829,
13828,
13827,
13826,
13820,
13822,
13821,
13825,
13824,
13823,
13843,
13842,
13841,
13840,
13839,
13833,
13834,
13838,
13837,
13836,
13835,
13863,
13862,
13861,
13860,
13859,
13858,
13857,
13931,
13930,
13925,
13926,
13929,
13928,
13927,
13923,
13924,
13921,
13922,
13919,
13920,
13944,
13935,
13936,
13943,
13942,
13941,
13940,
13933,
13934,
13939,
13938,
13937,
13955,
13954,
13953,
13952,
13951,
13950,
13949,
13948,
13947,
13946,
13965,
13964,
13959,
13960,
13957,
13958,
13963,
13962,
13961,
13901,
13900,
13899,
13898,
13897,
13891,
13893,
13892,
13896,
13895,
13894,
13912,
13911,
13910,
13909,
13908,
13907,
13906,
13905,
13904,
13903,
13877,
13876,
13875,
13868,
13869,
13874,
13873,
13872,
13871,
13870,
13866,
13867,
13889,
13888,
13879,
13880,
13887,
13886,
13885,
13884,
13883,
13882,
13881,
13916,
13915,
13914,
13453,
13462,
13461,
13460,
13459,
13458,
13457,
13456,
13455,
13454,
13466,
13467,
13473,
13472,
13471,
13470,
13463,
13465,
13464,
13469,
13468,
13489,
13475,
13478,
13477,
13476,
13479,
13481,
13480,
13488,
13487,
13486,
13485,
13484,
13483,
13482,
13427,
13439,
13438,
13437,
13436,
13435,
13434,
13433,
13432,
13431,
13430,
13429,
13428,
13451,
13450,
13444,
13445,
13449,
13448,
13447,
13446,
13442,
13443,
13440,
13441,
13497,
13498,
13495,
13496,
13504,
13493,
13494,
13503,
13502,
13501,
13491,
13492,
13500,
13499,
13505,
13506,
14124,
14123,
14116,
14117,
14122,
14121,
14120,
14119,
14118,
14114,
14115,
14105,
14106,
14112,
14111,
14110,
14103,
14104,
14109,
14108,
14101,
14102,
14099,
14100,
14107,
14132,
14131,
14130,
14129,
14126,
14127,
14128,
14215,
14214,
14213,
14204,
14206,
14205,
14212,
14209,
14210,
14211,
14207,
14208,
14239,
14240,
14247,
14246,
14245,
14244,
14243,
14242,
14241,
14058,
14042,
14046,
14045,
14044,
14043,
14047,
14049,
14048,
14052,
14053,
14050,
14051,
14057,
14056,
14055,
14054,
14040,
14039,
14038,
14037,
14036,
14017,
14026,
14025,
14024,
14023,
14022,
14021,
14020,
14019,
14018,
14027,
14035,
14034,
14033,
14032,
14031,
14030,
14029,
14028,
13187,
13186,
13185,
13184,
13183,
13182,
13177,
13179,
13178,
13181,
13180,
13209,
13208,
13207,
13206,
13205,
13204,
13203,
13202,
13201,
13200,
13198,
13197,
13196,
13195,
13194,
13193,
13192,
13191,
13190,
13189,
13213,
13212,
13211,
]

_charnames_82944 = [
11893,
11892,
11891,
11890,
11889,
11888,
11887,
11886,
11885,
11840,
11841,
11850,
11849,
11848,
11847,
11846,
11845,
11844,
11843,
11842,
11838,
11837,
11836,
11835,
11834,
11833,
11828,
11829,
11832,
11831,
11830,
11826,
11825,
11824,
11823,
11822,
11821,
11820,
11819,
11818,
11816,
11817,
11787,
11779,
11780,
11786,
11785,
11784,
11777,
11778,
11774,
11776,
11775,
11783,
11782,
11781,
11883,
11882,
11881,
11880,
11879,
11878,
11877,
11876,
11875,
11874,
11801,
11800,
11799,
11798,
11797,
11796,
11789,
11792,
11791,
11790,
11795,
11794,
11793,
11872,
11871,
11870,
11869,
11868,
11867,
11866,
11865,
11864,
11863,
11861,
11860,
11859,
11858,
11857,
11856,
11855,
11854,
11853,
11852,
11814,
11813,
11812,
11811,
11810,
11809,
11808,
11805,
11806,
11803,
11804,
11807,
11413,
11414,
11411,
11412,
11409,
11410,
11418,
11402,
11405,
11404,
11403,
11406,
11408,
11407,
11417,
11398,
11401,
11400,
11399,
11416,
11415,
11420,
11422,
11421,
11432,
11431,
11430,
11429,
11423,
11424,
11428,
11427,
11426,
11425,
11456,
11455,
11454,
11453,
11452,
11446,
11447,
11451,
11450,
11449,
11448,
11444,
11443,
11442,
11441,
11440,
11434,
11435,
11439,
11438,
11437,
11436,
11522,
11521,
11520,
11519,
11518,
11517,
11516,
11515,
11514,
11513,
11511,
11510,
11509,
11508,
11507,
11506,
11505,
11504,
11503,
11502,
11500,
11499,
11498,
11497,
11496,
11495,
11494,
11493,
11492,
11491,
11489,
11488,
11487,
11486,
11485,
11484,
11483,
11482,
11481,
11480,
11478,
11477,
11476,
11475,
11474,
11473,
11472,
11471,
11470,
11469,
11467,
11466,
11465,
11464,
11463,
11462,
11461,
11460,
11459,
11458,
11665,
11664,
11652,
11654,
11653,
11663,
11662,
11661,
11660,
11657,
11658,
11659,
11655,
11656,
11691,
11690,
11689,
11688,
11687,
11682,
11683,
11680,
11681,
11686,
11685,
11684,
11727,
11726,
11725,
11724,
11723,
11722,
11721,
11717,
11718,
11720,
11719,
11771,
11770,
11769,
11768,
11767,
11766,
11765,
11764,
11763,
11762,
11760,
11759,
11758,
11757,
11756,
11755,
11754,
11753,
11752,
11751,
11749,
11748,
11747,
11746,
11745,
11744,
11743,
11742,
11741,
11740,
11715,
11714,
11713,
11712,
11711,
11710,
11709,
11705,
11706,
11708,
11707,
11738,
11737,
11736,
11735,
11734,
11733,
11732,
11731,
11730,
11729,
11703,
11702,
11701,
11700,
11699,
11698,
11697,
11696,
11695,
11693,
11694,
11678,
11677,
11676,
11675,
11669,
11670,
11674,
11673,
11672,
11671,
11667,
11668,
11616,
11615,
11614,
11613,
11612,
11611,
11610,
11609,
11608,
11606,
11607,
11649,
11648,
11647,
11646,
11645,
11644,
11643,
11642,
11641,
11640,
11604,
11603,
11602,
11601,
11600,
11599,
11598,
11597,
11596,
11594,
11595,
11540,
11539,
11532,
11531,
11530,
11538,
11537,
11536,
11525,
11528,
11527,
11526,
11535,
11534,
11533,
11638,
11637,
11636,
11635,
11634,
11633,
11632,
11631,
11630,
11629,
11592,
11591,
11590,
11589,
11588,
11587,
11586,
11585,
11584,
11582,
11583,
11568,
11567,
11566,
11565,
11559,
11560,
11564,
11563,
11562,
11557,
11558,
11561,
11580,
11570,
11571,
11579,
11578,
11577,
11576,
11575,
11574,
11573,
11572,
11555,
11547,
11548,
11554,
11546,
11545,
11553,
11552,
11542,
11543,
11551,
11550,
11549,
11627,
11626,
11625,
11624,
11623,
11622,
11621,
11620,
11619,
11618,
11997,
11996,
11995,
11994,
11993,
11992,
11991,
11990,
11989,
11988,
11911,
11910,
11920,
11919,
11918,
11917,
11916,
11915,
11914,
11913,
11912,
11986,
11985,
11984,
11983,
11982,
11981,
11980,
11979,
11978,
11977,
11975,
11974,
11973,
11972,
11971,
11970,
11969,
11968,
11967,
11966,
11964,
11963,
11962,
11961,
11960,
11959,
11958,
11957,
11956,
11955,
11898,
11899,
11907,
11906,
11905,
11904,
11903,
11902,
11896,
11897,
11901,
11900,
11953,
11952,
11951,
11950,
11949,
11948,
11947,
11946,
11945,
11944,
11942,
11941,
11940,
11939,
11938,
11937,
11936,
11935,
11934,
11933,
11931,
11930,
11929,
11928,
11927,
11926,
11925,
11924,
11923,
11922,
12006,
12005,
12004,
12003,
12002,
12001,
12000,
11999,
12039,
12038,
12037,
12036,
12035,
12034,
12033,
12032,
12031,
12029,
12028,
12027,
12026,
12025,
12024,
12023,
12022,
12021,
12020,
12018,
12017,
12016,
12015,
12014,
12013,
12012,
12011,
12010,
12009,
12040,
]

_charnames_92160 = [
15164,
15272,
15241,
15242,
15185,
15216,
15261,
15173,
15219,
15238,
15239,
15195,
15257,
15166,
15193,
15200,
15209,
15227,
15160,
15247,
15178,
15225,
15163,
15267,
15266,
15159,
15198,
15233,
15270,
15234,
15205,
15172,
15275,
15271,
15158,
15226,
15210,
15211,
15203,
15251,
15235,
15182,
15244,
15194,
15187,
15243,
15256,
15264,
15224,
15259,
15197,
15248,
15181,
15252,
15204,
15215,
15265,
15278,
15277,
15253,
15223,
15199,
15218,
15156,
15220,
15169,
15231,
15179,
15274,
15165,
15196,
15186,
15208,
15170,
15260,
15222,
15232,
15175,
15192,
15168,
15250,
15176,
15276,
15263,
15188,
15184,
15207,
15312,
15347,
15321,
15322,
15342,
15284,
15331,
15350,
15283,
15332,
15336,
15351,
15340,
15314,
15315,
15353,
15335,
15346,
15319,
15318,
15293,
15286,
15309,
15327,
15354,
15326,
15341,
15337,
15359,
15307,
15304,
15358,
15323,
15348,
15297,
15302,
15303,
15294,
15320,
15287,
15298,
15310,
15334,
15296,
15356,
15285,
15357,
15328,
15291,
15290,
15343,
15305,
15313,
15288,
15330,
15306,
15017,
15054,
15108,
15146,
15015,
15032,
15018,
15141,
15066,
15143,
15058,
15050,
15064,
15136,
15036,
15073,
15092,
15142,
15095,
15109,
15053,
15076,
15027,
15068,
15110,
15103,
15104,
15125,
15037,
15119,
15045,
15115,
15127,
15014,
15148,
15057,
15084,
15051,
15011,
15130,
15069,
15087,
15048,
15117,
15012,
15151,
15031,
15028,
15026,
15152,
15149,
15065,
15150,
15044,
15131,
15114,
15023,
15041,
15099,
15010,
15080,
15077,
15132,
15101,
15043,
15019,
15145,
15013,
15025,
15049,
15102,
15024,
15035,
15083,
15111,
15034,
15122,
15126,
15067,
15081,
15074,
15093,
15063,
15094,
15072,
15107,
15040,
15086,
15085,
15123,
15097,
15098,
15020,
15056,
15133,
15137,
15138,
15118,
14912,
14999,
14859,
14895,
14860,
14973,
14862,
14872,
14853,
14878,
14998,
14847,
14925,
14849,
14944,
14955,
14924,
14865,
14931,
14945,
14990,
14948,
14935,
14897,
14881,
14914,
14906,
14937,
14989,
14863,
14942,
14844,
14959,
15002,
14846,
15004,
14882,
14901,
14968,
14883,
14918,
14903,
14976,
14902,
14894,
14971,
14869,
14910,
14951,
14877,
14957,
14936,
14988,
14943,
14996,
14958,
14845,
14898,
14868,
14941,
14981,
14979,
14875,
14969,
14852,
14899,
14855,
14987,
14982,
14986,
14884,
14887,
14932,
14949,
14857,
14848,
14960,
14907,
14947,
14873,
14956,
14915,
14854,
14967,
14856,
14871,
14864,
15001,
14946,
14993,
14963,
14961,
14876,
14995,
14970,
14908,
14892,
14930,
14917,
14928,
14923,
14950,
14890,
14926,
14888,
14980,
14891,
14927,
14977,
14916,
14972,
14994,
14962,
14889,
14911,
14934,
15005,
14649,
14733,
14713,
14778,
14835,
14773,
14685,
14767,
14822,
14662,
14653,
14681,
14725,
14626,
14792,
14828,
14765,
14635,
14686,
14732,
14785,
14775,
14664,
14641,
14704,
14624,
14640,
14663,
14824,
14658,
14698,
14768,
14630,
14711,
14811,
14625,
14659,
14706,
14772,
14636,
14651,
14726,
14764,
14682,
14647,
14632,
14755,
14812,
14730,
14746,
14699,
14729,
14790,
14766,
14737,
14833,
14830,
14779,
14678,
14723,
14816,
14642,
14762,
14710,
14714,
14667,
14676,
14819,
14728,
14786,
14756,
14669,
14754,
14718,
14652,
14693,
14743,
14781,
14801,
14818,
14621,
14791,
14703,
14627,
14814,
14803,
14672,
14697,
14749,
14634,
14670,
14666,
14700,
14708,
14802,
14675,
14716,
14813,
14799,
14715,
14680,
14622,
14784,
14692,
14673,
14747,
14631,
14689,
14800,
14805,
14656,
14838,
14734,
14836,
14837,
14777,
14688,
14722,
14724,
14648,
14761,
14748,
14637,
14744,
14751,
14752,
14741,
14742,
14789,
14696,
14657,
14683,
14829,
14806,
14834,
14780,
14707,
14825,
14823,
14638,
14643,
14759,
14760,
14798,
14674,
14690,
14774,
14793,
14719,
14702,
14705,
14736,
14794,
14717,
14738,
14804,
14815,
15392,
15430,
15389,
15432,
15397,
15411,
15370,
15422,
15399,
15400,
15407,
15412,
15374,
15366,
15402,
15380,
15379,
15381,
15382,
15388,
15386,
15363,
15362,
15365,
15424,
15377,
15425,
15372,
15416,
15371,
15427,
15417,
15401,
15373,
15395,
15387,
15368,
15369,
15378,
15418,
15431,
15428,
15421,
15420,
15391,
15404,
15396,
15408,
15406,
15405,
15413,
15390,
15383,
15429,
]

_charnames_92736 = [
9519,
9535,
9548,
9537,
9552,
9546,
9553,
9531,
9525,
9542,
9547,
9551,
9526,
9522,
9538,
9534,
9532,
9521,
9520,
9528,
9550,
9517,
9545,
9549,
9544,
9524,
9540,
9539,
9543,
9529,
9518,
-1,
9565,
9566,
9557,
9558,
9563,
9564,
9560,
9561,
9568,
9567,
-1,
-1,
-1,
-1,
9570,
9569,
]

_charnames_92880 = [
15797,
15810,
15820,
15826,
15822,
15800,
15813,
15816,
15809,
15823,
15825,
15802,
15817,
15812,
15815,
15827,
15805,
15819,
15828,
15818,
15801,
15821,
15803,
15829,
15806,
15807,
15804,
15798,
15796,
15824,
-1,
-1,
15836,
15833,
15837,
15832,
15835,
15838,
]

_charnames_92928 = [
17541,
17540,
17537,
17536,
17511,
17510,
17525,
17524,
17543,
17542,
17514,
17513,
17529,
17528,
17508,
17507,
17523,
17522,
17531,
17530,
17535,
17534,
17519,
17518,
17546,
17545,
17517,
17516,
17419,
17404,
17424,
17413,
17406,
17420,
17407,
17421,
17417,
17412,
17423,
17415,
17408,
17411,
17422,
17405,
17409,
17425,
17418,
17416,
17575,
17579,
17582,
17581,
17578,
17583,
17576,
17478,
17480,
17461,
17479,
17484,
17470,
17469,
17468,
17471,
17481,
17492,
17482,
17502,
17474,
17458,
]

_charnames_93008 = [
17557,
17558,
17549,
17550,
17555,
17556,
17552,
17553,
17560,
17559,
-1,
17567,
17570,
17565,
17572,
17571,
17566,
17568,
-1,
17483,
17472,
17499,
17487,
17500,
17498,
17496,
17473,
17495,
17503,
17486,
17491,
17488,
17501,
17493,
17464,
17460,
17456,
17457,
17462,
17463,
-1,
-1,
-1,
-1,
-1,
17430,
17438,
17444,
17445,
17449,
17435,
17447,
17451,
17432,
17431,
17450,
17436,
17448,
17442,
17452,
17439,
17429,
17434,
17441,
]

_charnames_93952 = [
9353,
9364,
9299,
9352,
9356,
9355,
9328,
9363,
9347,
9346,
9266,
9321,
9297,
9298,
9265,
9320,
9277,
9279,
9300,
9326,
9273,
9272,
9335,
9334,
9333,
9332,
9264,
9319,
9263,
9318,
9362,
9344,
9301,
9350,
9349,
9276,
9275,
9325,
9359,
9360,
9343,
9342,
9259,
9314,
9270,
9269,
9260,
9315,
9295,
9302,
9311,
9338,
9337,
9290,
9288,
9261,
9316,
9296,
9339,
9291,
9289,
9286,
9284,
9327,
9285,
9283,
9361,
9329,
9358,
]

_charnames_94032 = [
9278,
9418,
9416,
9417,
9375,
9383,
9382,
9376,
9377,
9397,
9399,
9404,
9403,
9391,
9394,
9395,
9400,
9366,
9367,
9368,
9369,
9371,
9374,
9373,
9370,
9372,
9384,
9385,
9386,
9387,
9388,
9390,
9389,
9401,
9402,
9378,
9379,
9393,
9406,
9392,
9405,
9381,
9396,
9380,
9398,
9407,
9408,
]

_charnames_94095 = [
9411,
9410,
9413,
9412,
9257,
9256,
9255,
9254,
9253,
9252,
9251,
9310,
9309,
9308,
9307,
9306,
9305,
]

_charnames_100352 = [
4125,
4124,
4123,
4122,
4121,
4120,
4119,
4118,
4117,
4115,
4114,
4113,
4112,
4111,
4110,
4109,
4108,
4107,
4106,
4104,
4103,
4102,
4101,
4100,
4099,
4098,
4097,
4096,
4095,
4093,
4092,
4091,
4090,
4089,
4088,
4087,
4086,
4085,
4084,
4082,
4081,
4080,
4079,
4078,
4077,
4076,
4075,
4074,
4073,
4071,
4070,
4069,
4068,
4067,
4066,
4065,
4064,
4063,
4062,
4060,
4059,
4058,
4057,
4056,
4055,
4054,
4053,
4052,
4051,
4049,
4048,
4047,
4046,
4045,
4044,
4043,
4042,
4041,
4040,
4038,
4037,
4036,
4035,
4034,
4033,
4032,
4031,
4030,
4029,
4027,
4026,
4025,
4024,
4023,
4022,
4021,
4020,
4019,
4018,
4015,
4014,
4013,
4012,
4011,
4010,
4009,
4008,
4007,
4006,
4004,
4003,
4002,
4001,
4000,
3999,
3998,
3997,
3996,
3995,
3993,
3992,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3982,
3981,
3980,
3979,
3978,
3977,
3976,
3975,
3974,
3973,
3971,
3970,
3969,
3968,
3967,
3966,
3965,
3964,
3963,
3962,
3960,
3959,
3958,
3957,
3956,
3955,
3954,
3953,
3952,
3951,
3949,
3948,
3947,
3946,
3945,
3944,
3943,
3942,
3941,
3940,
3938,
3937,
3936,
3935,
3934,
3933,
3932,
3931,
3930,
3929,
3927,
3926,
3925,
3924,
3923,
3922,
3921,
3920,
3919,
3918,
3916,
3915,
3914,
3913,
3912,
3911,
3910,
3909,
3908,
3907,
3904,
3903,
3902,
3901,
3900,
3899,
3898,
3897,
3896,
3895,
3893,
3892,
3891,
3890,
3889,
3888,
3887,
3886,
3885,
3884,
3882,
3881,
3880,
3879,
3878,
3877,
3876,
3875,
3874,
3873,
3871,
3870,
3869,
3868,
3867,
3866,
3865,
3864,
3863,
3862,
3860,
3859,
3858,
3857,
3856,
3855,
3854,
3853,
3852,
3851,
3849,
3848,
3847,
3846,
3845,
3844,
3843,
3842,
3841,
3840,
3838,
3837,
3836,
3835,
3834,
3833,
3832,
3831,
3830,
3829,
3827,
3826,
3825,
3824,
3823,
3822,
3821,
3820,
3819,
3818,
3816,
3815,
3814,
3813,
3812,
3811,
3810,
3809,
3808,
3807,
3805,
3804,
3803,
3802,
3801,
3800,
3799,
3798,
3797,
3796,
3793,
3792,
3791,
3790,
3789,
3788,
3787,
3786,
3785,
3784,
3782,
3781,
3780,
3779,
3778,
3777,
3776,
3775,
3774,
3773,
3771,
3770,
3769,
3768,
3767,
3766,
3765,
3764,
3763,
3762,
3760,
3759,
3758,
3757,
3756,
3755,
3754,
3753,
3752,
3751,
3749,
3748,
3747,
3746,
3745,
3744,
3743,
3742,
3741,
3740,
3738,
3737,
3736,
3735,
3734,
3733,
3732,
3731,
3730,
3729,
3727,
3726,
3725,
3724,
3723,
3722,
3721,
3720,
3719,
3718,
3716,
3715,
3714,
3713,
3712,
3711,
3710,
3709,
3708,
3707,
3705,
3704,
3703,
3702,
3701,
3700,
3699,
3698,
3697,
3696,
3694,
3693,
3692,
3691,
3690,
3689,
3688,
3687,
3686,
3685,
3682,
3681,
3680,
3679,
3678,
3677,
3676,
3675,
3674,
3673,
3671,
3670,
3669,
3668,
3667,
3666,
3665,
3664,
3663,
3662,
3660,
3659,
3658,
3657,
3656,
3655,
3654,
3653,
3652,
3651,
3649,
3648,
3647,
3646,
3645,
3644,
3643,
3642,
3641,
3640,
3638,
3637,
3636,
3635,
3634,
3633,
3632,
3631,
3630,
3629,
3627,
3626,
3625,
3624,
3623,
3622,
3621,
3620,
3619,
3618,
3616,
3615,
3614,
3613,
3612,
3611,
3610,
3609,
3608,
3607,
3605,
3604,
3603,
3602,
3601,
3600,
3599,
3598,
3597,
3596,
3594,
3593,
3592,
3591,
3590,
3589,
3588,
3587,
3586,
3585,
3583,
3582,
3581,
3580,
3579,
3578,
3577,
3576,
3575,
3574,
3571,
3570,
3569,
3568,
3567,
3566,
3565,
3564,
3563,
3562,
3560,
3559,
3558,
3557,
3556,
3555,
3554,
3553,
3552,
3551,
3549,
3548,
3547,
3546,
3545,
3544,
3543,
3542,
3541,
3540,
3538,
3537,
3536,
3535,
3534,
3533,
3532,
3531,
3530,
3529,
3527,
3526,
3525,
3524,
3523,
3522,
3521,
3520,
3519,
3518,
3516,
3515,
3514,
3513,
3512,
3511,
3510,
3509,
3508,
3507,
3505,
3504,
3503,
3502,
3501,
3500,
3499,
3498,
3497,
3496,
3494,
3493,
3492,
3491,
3490,
3489,
3488,
3487,
3486,
3485,
3483,
3482,
3481,
3480,
3479,
3478,
3477,
3476,
3475,
3474,
3472,
3471,
3470,
3469,
3468,
3467,
3466,
3465,
3464,
3463,
3460,
3459,
3458,
3457,
3456,
3455,
3454,
3453,
3452,
3451,
3449,
3448,
3447,
3446,
3445,
3444,
3443,
3442,
3441,
3440,
3438,
3437,
3436,
3435,
3434,
3433,
3432,
3431,
3430,
3429,
3427,
3426,
3425,
3424,
3423,
3422,
3421,
3420,
3419,
3418,
3416,
3415,
3414,
3413,
3412,
3411,
3410,
3409,
3408,
3407,
3405,
3404,
3403,
3402,
3401,
3400,
3399,
3398,
3397,
3396,
3394,
3393,
3392,
3391,
3390,
3389,
3388,
3387,
3386,
3385,
3383,
3382,
3381,
3380,
3379,
3378,
3377,
3376,
3375,
3374,
3372,
3371,
3370,
3369,
3368,
3367,
3366,
3365,
3364,
3363,
3361,
3360,
3359,
3358,
3357,
3356,
3355,
3354,
3353,
3352,
4181,
4180,
4179,
4178,
4177,
4176,
4175,
4174,
4173,
4172,
4170,
4169,
4168,
4167,
4166,
4165,
4164,
4163,
4162,
4161,
4159,
4158,
4157,
4156,
4155,
4154,
4153,
4152,
4151,
4150,
4148,
4147,
4146,
4145,
4144,
4143,
4142,
4141,
4140,
4139,
4137,
4136,
4135,
4134,
4133,
4132,
4131,
4130,
4129,
4128,
4188,
4187,
4186,
4185,
4184,
4183,
]

_charnames_113664 = [
20398,
20392,
20371,
20366,
20402,
20381,
20376,
20407,
20389,
20394,
20400,
20345,
20375,
20391,
20403,
20384,
20350,
20370,
20313,
20390,
20385,
20312,
20399,
20380,
20349,
20356,
20316,
20327,
20288,
20358,
20323,
20335,
20298,
20360,
20325,
20329,
20330,
20290,
20291,
20361,
20326,
20331,
20300,
20359,
20324,
20336,
20299,
20332,
20333,
20334,
20292,
20293,
20294,
20295,
20368,
20369,
20337,
20341,
20344,
20301,
20302,
20383,
20401,
20296,
20297,
20404,
20309,
20355,
20351,
20405,
20396,
20386,
20397,
20315,
20363,
20388,
20306,
20348,
20307,
20379,
20406,
20362,
20387,
20393,
20365,
20378,
20347,
20364,
20311,
20354,
20352,
20353,
20343,
20338,
20340,
20342,
20339,
20318,
20319,
20320,
20321,
20373,
20374,
20305,
20314,
20310,
20395,
-1,
-1,
-1,
-1,
-1,
20424,
20448,
20449,
20412,
20447,
20427,
20442,
20443,
20439,
20441,
20445,
20444,
20440,
-1,
-1,
-1,
20436,
20432,
20433,
20429,
20434,
20435,
20430,
20431,
20426,
]

_charnames_113808 = [
20418,
20420,
20421,
20414,
20422,
20423,
20415,
20419,
20411,
20417,
-1,
-1,
20451,
20450,
20453,
20452,
6849,
6851,
6850,
6848,
]

_charnames_119262 = [
9507,
9497,
9503,
9505,
9504,
9506,
9500,
9499,
9496,
9495,
9502,
]

_charnames_119296 = [
19032,
19049,
19060,
19059,
19043,
19058,
19057,
19056,
19055,
19042,
19041,
19040,
19039,
19038,
19037,
19036,
19035,
19034,
19033,
19054,
19053,
19052,
19051,
19050,
19048,
19047,
19046,
19045,
19044,
19000,
19008,
18992,
19015,
19029,
19028,
19007,
19006,
19005,
19004,
19003,
19002,
19001,
19014,
19013,
19012,
19011,
19010,
19009,
19027,
19026,
19025,
19024,
19023,
19022,
18999,
18998,
18997,
18996,
18995,
18994,
18993,
19020,
19019,
19018,
19017,
19016,
1659,
1660,
1661,
19125,
]

_charnames_119552 = [
8999,
20565,
20564,
20559,
20558,
20556,
5177,
5214,
5246,
5257,
5266,
5164,
5241,
5262,
5255,
5187,
5183,
5273,
5269,
5239,
5209,
5166,
5271,
5260,
5217,
5243,
5208,
5205,
5200,
5276,
5165,
5195,
5189,
5176,
5188,
5256,
5237,
5253,
5173,
5265,
5229,
5225,
5238,
5213,
5206,
5251,
5207,
5233,
5196,
5223,
5232,
5194,
5236,
5210,
5218,
5274,
5167,
5247,
5198,
5275,
5182,
5174,
5231,
5230,
5248,
5244,
5199,
5190,
5259,
5226,
5268,
5186,
5191,
5181,
5197,
5227,
5224,
5272,
5170,
5175,
5219,
5242,
5169,
5263,
5184,
5252,
5216,
]

_charnames_119648 = [
2130,
2122,
2123,
2128,
2129,
2125,
2126,
2132,
2131,
2143,
2135,
2136,
2141,
2142,
2138,
2139,
2145,
2144,
]

_charnames_120832 = [
5468,
5700,
5681,
5820,
5734,
5789,
5559,
5712,
5569,
5558,
5561,
5547,
5551,
5711,
5470,
5702,
5511,
5508,
5509,
5552,
5549,
5473,
5486,
5485,
5483,
5481,
5488,
5705,
5606,
5560,
5491,
5707,
5514,
5512,
5502,
5510,
5554,
5555,
5550,
5513,
5494,
5496,
5498,
5499,
5573,
5476,
5478,
5479,
5598,
5539,
5482,
5489,
5480,
5484,
5591,
5534,
5589,
5590,
5545,
5546,
5536,
5495,
5501,
5500,
5594,
5595,
5596,
5540,
5647,
5652,
5651,
5649,
5650,
5730,
5634,
5769,
5638,
5661,
5645,
5663,
5646,
5664,
5644,
5689,
5690,
5770,
5821,
5640,
5642,
5643,
5635,
5670,
5659,
5667,
5665,
5669,
5668,
5658,
5654,
5655,
5656,
5657,
5721,
5724,
5728,
5725,
5786,
5773,
5675,
5673,
5678,
5687,
5680,
5691,
5679,
5688,
5695,
5693,
5698,
5812,
5815,
5818,
5816,
5749,
5753,
5732,
5771,
5752,
5761,
5754,
5772,
5762,
5763,
5787,
5504,
5708,
5744,
5798,
5755,
5507,
5506,
5745,
5608,
5611,
5612,
5613,
5619,
5568,
5718,
5819,
5804,
5620,
5621,
5615,
5616,
5759,
5618,
5758,
5803,
5802,
5617,
5719,
5757,
5801,
5515,
5709,
5746,
5764,
5799,
5490,
5706,
5632,
5765,
5811,
5627,
5629,
5630,
5720,
5817,
5810,
5623,
5626,
5625,
5631,
5628,
5785,
5557,
5710,
5697,
5783,
5784,
5782,
5685,
5747,
5796,
5795,
5605,
5766,
5599,
5716,
5603,
5600,
5780,
5597,
5604,
5602,
5714,
5696,
5692,
5767,
5807,
5808,
5805,
5715,
5726,
5727,
5778,
5779,
5776,
5748,
5517,
5740,
5520,
5521,
5522,
5525,
5526,
5524,
5542,
5543,
5537,
5533,
5532,
5729,
5531,
5535,
5683,
5684,
5741,
5742,
5736,
5739,
5793,
5794,
5791,
5562,
5583,
5577,
5578,
5579,
5584,
5572,
5575,
5574,
5566,
5581,
5567,
5570,
5582,
5466,
5633,
6191,
6192,
6193,
6440,
6441,
6442,
6376,
6377,
6378,
6426,
6427,
6428,
6261,
6262,
6263,
6385,
6386,
6372,
6368,
6373,
6369,
6370,
6344,
6340,
6345,
6341,
6342,
6374,
6108,
6107,
6109,
6111,
6106,
6105,
6110,
5957,
6077,
5900,
5901,
5898,
5899,
5902,
5937,
5936,
5934,
5935,
5873,
5932,
5931,
5929,
5930,
5918,
5919,
5920,
5865,
5867,
5868,
5866,
5870,
5871,
5872,
5914,
5915,
5916,
5946,
5947,
5948,
5950,
5951,
5952,
6155,
6156,
6157,
6159,
6160,
6161,
6166,
6164,
6165,
6163,
6099,
6100,
6097,
6098,
6094,
6095,
6092,
6093,
6089,
6090,
6087,
6088,
6084,
6085,
6082,
6083,
6034,
6035,
6032,
6033,
6036,
6058,
6057,
6055,
6056,
5978,
6053,
6052,
6051,
6050,
6064,
5975,
5976,
5977,
5979,
6061,
6062,
6063,
6066,
6067,
6068,
6070,
6071,
6072,
6174,
6175,
6176,
6170,
6171,
6172,
6177,
5854,
5855,
5852,
5853,
5846,
5847,
5844,
5845,
5858,
5859,
5925,
5926,
5927,
5905,
5910,
5911,
5906,
5882,
5883,
5884,
5878,
5879,
5880,
5860,
5862,
5863,
6217,
6221,
6229,
5903,
5849,
5923,
5908,
5890,
6219,
6223,
6227,
5850,
5924,
5909,
5891,
6220,
6224,
6228,
5886,
5887,
5888,
5967,
5968,
6024,
6027,
6023,
6026,
6007,
6010,
6008,
6011,
5987,
5988,
6234,
6238,
6242,
5964,
5965,
6019,
6020,
6017,
6018,
6000,
6003,
6001,
6004,
5984,
5985,
6233,
6237,
6241,
5971,
5972,
5969,
5970,
5973,
6028,
6012,
5990,
5991,
5992,
6231,
6235,
6239,
6037,
5940,
5943,
5941,
5944,
6040,
6043,
6046,
6041,
6044,
6047,
5893,
5894,
5994,
5995,
5955,
5956,
6075,
6076,
6395,
6396,
6400,
6393,
6397,
6398,
6391,
6392,
6401,
6399,
5823,
5835,
5829,
5828,
5832,
5830,
5833,
5834,
6362,
6360,
6361,
6296,
6297,
6298,
6405,
6407,
6406,
6404,
6357,
6358,
6356,
6289,
6288,
6290,
6301,
6302,
6286,
6284,
6287,
6283,
6303,
6292,
6294,
6293,
6268,
6270,
6271,
6276,
6278,
6279,
6273,
6280,
6274,
6419,
6420,
6418,
6212,
6210,
6211,
6305,
6413,
6414,
6411,
6412,
6437,
6434,
6438,
6435,
6430,
6431,
6127,
6128,
6129,
6135,
6137,
6138,
6143,
6145,
6146,
6124,
6123,
6122,
6118,
6121,
6120,
6114,
6117,
6116,
6139,
6142,
6141,
6131,
6134,
6133,
6322,
6321,
6320,
6130,
6148,
6149,
6186,
6188,
6182,
6181,
6189,
6187,
6184,
6185,
6200,
6207,
6203,
6204,
6205,
6206,
6208,
5958,
6078,
6415,
5822,
6304,
6381,
6382,
6443,
6346,
6383,
6196,
6197,
6198,
6444,
6317,
6316,
6315,
6314,
6313,
6312,
6311,
6310,
6354,
6333,
6334,
6326,
6328,
6331,
6327,
6329,
6330,
6422,
6363,
6387,
6423,
6445,
]

_charnames_121499 = [
6353,
6352,
6351,
6350,
6349,
-1,
6259,
6258,
6257,
6256,
6255,
6254,
6253,
6252,
6251,
6250,
6249,
6248,
6247,
6246,
6245,
]

_charnames_122880 = [
1634,
1620,
1622,
1632,
1617,
1591,
1608,
-1,
1609,
1599,
1600,
1595,
1618,
1630,
1629,
1628,
1627,
1626,
1625,
1624,
1606,
1611,
1623,
1614,
1631,
-1,
-1,
1603,
1612,
1633,
1604,
1589,
1590,
1594,
-1,
1592,
1605,
-1,
1593,
1597,
1621,
1598,
1615,
]

_charnames_124928 = [
7794,
7793,
7792,
7724,
7691,
7712,
7743,
7808,
7791,
7790,
7789,
7866,
7875,
7879,
7746,
7899,
7847,
7728,
7742,
7852,
7788,
7787,
7786,
7731,
7692,
7835,
7797,
7784,
7783,
7782,
7839,
7689,
7891,
7853,
7781,
7780,
7779,
7825,
7894,
7823,
7843,
7854,
7860,
7856,
7898,
7809,
7775,
7773,
7772,
7826,
7877,
7855,
7709,
7897,
7768,
7767,
7766,
7703,
7715,
7736,
7836,
7883,
7778,
7777,
7776,
7698,
7806,
7805,
7771,
7770,
7769,
7695,
7735,
7890,
7720,
7765,
7764,
7762,
7832,
7880,
7828,
7726,
7812,
7761,
7760,
7759,
7885,
7707,
7849,
7871,
7758,
7757,
7756,
7710,
7713,
7858,
7699,
7896,
7893,
7755,
7754,
7753,
7876,
7819,
7811,
7750,
7800,
7751,
7690,
7749,
7850,
7704,
7864,
7737,
7861,
7700,
7738,
7900,
7745,
7696,
7748,
7705,
7878,
7844,
7833,
7872,
7830,
7865,
7701,
7888,
7803,
7834,
7882,
7820,
7903,
7822,
7821,
7802,
7733,
7810,
7721,
7687,
7740,
7706,
7739,
7892,
7723,
7845,
7727,
7870,
7744,
7798,
7716,
7815,
7813,
7799,
7827,
7889,
7848,
7859,
7694,
7714,
7747,
7886,
7881,
7831,
7868,
7734,
7842,
7693,
7887,
7717,
7718,
7816,
7869,
7863,
7867,
7902,
7874,
7722,
7725,
7837,
7901,
7841,
7857,
7804,
7801,
7838,
7814,
7702,
7846,
7711,
7824,
7732,
7817,
7688,
7729,
-1,
-1,
7914,
7906,
7907,
7912,
7913,
7909,
7910,
7916,
7915,
7923,
7921,
7926,
7924,
7922,
7927,
7928,
]

_charnames_125184 = [
12754,
12733,
12747,
12746,
12736,
12726,
12744,
12735,
12742,
12752,
12751,
12749,
12745,
12732,
12723,
12738,
12716,
12721,
12724,
12740,
12748,
12753,
12750,
12743,
12730,
12715,
12741,
12717,
12739,
12720,
12729,
12737,
12719,
12727,
12797,
12776,
12790,
12789,
12779,
12769,
12787,
12778,
12785,
12795,
12794,
12792,
12788,
12775,
12766,
12781,
12759,
12764,
12767,
12783,
12791,
12796,
12793,
12786,
12773,
12758,
12784,
12760,
12782,
12763,
12772,
12780,
12762,
12770,
12821,
12818,
12816,
12820,
12755,
12817,
12819,
-1,
-1,
-1,
-1,
-1,
12808,
12809,
12800,
12801,
12806,
12807,
12803,
12804,
12811,
12810,
-1,
-1,
-1,
-1,
12814,
12813,
]

_charnames_126464 = [
12234,
12246,
12242,
12100,
-1,
12237,
12225,
12243,
12219,
12236,
12232,
12138,
12241,
12240,
12171,
12235,
12245,
12172,
12239,
12238,
12170,
12223,
12221,
12231,
12222,
12101,
12226,
12244,
12098,
12096,
12097,
12095,
-1,
12196,
12192,
-1,
12185,
-1,
-1,
12186,
-1,
12187,
12183,
12191,
12190,
12189,
12176,
12197,
12194,
12177,
12188,
-1,
12175,
12180,
12179,
12182,
-1,
12195,
-1,
12193,
-1,
-1,
-1,
-1,
-1,
-1,
12215,
-1,
-1,
-1,
-1,
12216,
-1,
12210,
-1,
12213,
-1,
12212,
12203,
12218,
-1,
12204,
12211,
-1,
12202,
-1,
-1,
12214,
-1,
12209,
-1,
12217,
-1,
12208,
-1,
12207,
-1,
12168,
12165,
-1,
12158,
-1,
-1,
12159,
12144,
12161,
12156,
-1,
12164,
12163,
12147,
12169,
12167,
12148,
12162,
-1,
12146,
12143,
12142,
12155,
-1,
12153,
12160,
12166,
12152,
-1,
12151,
-1,
12124,
12137,
12134,
12121,
12118,
12127,
12115,
12119,
12109,
12126,
-1,
12132,
12131,
12130,
12112,
12125,
12136,
12113,
12129,
12128,
12111,
12108,
12106,
12133,
12107,
12122,
12116,
12135,
-1,
-1,
-1,
-1,
-1,
12092,
12088,
12078,
-1,
12081,
12075,
12089,
12069,
12080,
-1,
12086,
12085,
12084,
12072,
12093,
12091,
12073,
12083,
12082,
12071,
12068,
12066,
12087,
12067,
12079,
12076,
12090,
]

_charnames_126976 = [
8416,
8373,
8420,
8409,
8424,
8427,
8419,
8400,
8378,
8383,
8389,
8394,
8364,
8369,
8414,
8407,
8401,
8379,
8384,
8390,
8395,
8365,
8370,
8415,
8408,
8399,
8377,
8382,
8388,
8393,
8363,
8368,
8413,
8406,
8425,
8402,
8422,
8428,
8372,
8371,
8429,
8418,
8426,
8423,
-1,
-1,
-1,
-1,
20203,
20202,
20201,
20200,
20199,
20198,
20197,
20196,
20194,
20193,
20192,
20191,
20190,
20189,
20188,
20186,
20185,
20184,
20183,
20182,
20181,
20180,
20178,
20177,
20176,
20175,
20174,
20173,
20172,
20170,
20169,
20168,
20167,
20166,
20165,
20164,
20162,
20161,
20160,
20159,
20158,
20157,
20156,
20154,
20153,
20152,
20151,
20150,
20149,
20148,
20144,
20143,
20142,
20141,
20140,
20139,
20138,
20137,
20135,
20134,
20133,
20132,
20131,
20130,
20129,
20127,
20126,
20125,
20124,
20123,
20122,
20121,
20119,
20118,
20117,
20116,
20115,
20114,
20113,
20111,
20110,
20109,
20108,
20107,
20106,
20105,
20103,
20102,
20101,
20100,
20099,
20098,
20097,
20095,
20094,
20093,
20092,
20091,
20090,
20089,
]

_charnames_127136 = [
18046,
18040,
17970,
17975,
17987,
17993,
17999,
18004,
18035,
18025,
17980,
18030,
18010,
18020,
18015,
-1,
-1,
18041,
17971,
17976,
17988,
17994,
18000,
18005,
18036,
18026,
17981,
18031,
18011,
18021,
18016,
18048,
-1,
18042,
17972,
17977,
17989,
17995,
18001,
18006,
18037,
18027,
17982,
18032,
18012,
18022,
18017,
18045,
-1,
18043,
17973,
17978,
17990,
17996,
18002,
18007,
18038,
18028,
17983,
18033,
18013,
18023,
18018,
18047,
17991,
17948,
17959,
17968,
17967,
17966,
17965,
17964,
17963,
17962,
17958,
17957,
17956,
17955,
17954,
17953,
17952,
17951,
17950,
17949,
17961,
17960,
]

_charnames_127232 = [
20541,
20542,
20552,
20544,
20545,
20550,
20551,
20547,
20548,
20554,
20553,
20587,
20586,
-1,
-1,
-1,
17685,
17684,
17683,
17682,
17681,
17680,
17679,
17678,
17677,
17676,
17675,
17674,
17673,
17672,
17671,
17670,
17669,
17668,
17667,
17666,
17665,
17664,
17663,
17662,
17661,
17660,
5374,
3282,
3281,
3300,
3305,
-1,
7169,
7168,
7167,
7166,
7165,
7164,
7163,
7162,
7161,
7160,
7159,
7158,
7157,
7156,
7155,
7154,
7153,
7152,
7151,
7150,
7149,
7148,
7147,
7146,
7145,
7144,
7193,
7222,
7184,
7180,
7221,
7220,
20930,
20929,
20928,
20927,
20926,
20925,
20924,
20923,
20922,
20921,
20920,
20919,
20918,
20917,
20916,
20915,
20914,
20913,
20912,
20911,
20910,
20909,
20908,
20907,
20906,
20905,
21996,
21995,
-1,
-1,
-1,
-1,
20896,
20895,
20894,
20893,
20892,
20891,
20890,
20889,
20888,
20887,
20886,
20885,
20884,
20883,
20882,
20881,
20880,
20879,
20878,
20877,
20876,
20875,
20874,
20873,
20872,
20871,
3317,
20900,
20899,
20898,
20902,
20897,
7236,
7140,
7139,
7201,
7223,
7219,
7218,
7216,
7181,
7212,
7209,
7207,
7179,
7205,
7199,
7224,
7202,
7178,
7206,
7182,
7215,
7170,
7196,
7195,
7194,
7175,
7183,
7213,
7210,
]

_charnames_127462 = [
21716,
21715,
21714,
21713,
21712,
21711,
21710,
21709,
21708,
21707,
21706,
21705,
21704,
21703,
21702,
21701,
21700,
21699,
21698,
21697,
21696,
21695,
21694,
21693,
21692,
21691,
7238,
7189,
7188,
]

_charnames_127504 = [
7104,
7096,
7093,
7190,
7130,
7087,
7135,
7086,
7129,
7116,
7124,
7110,
7083,
7094,
7099,
7109,
7084,
7121,
7120,
7134,
7097,
7089,
7114,
7102,
7112,
7128,
7127,
7138,
7095,
7131,
7092,
7113,
7133,
7103,
7123,
7122,
7090,
7115,
7106,
7107,
7119,
7082,
7098,
7137,
-1,
-1,
-1,
-1,
5362,
5373,
5372,
5369,
5367,
5364,
5366,
5370,
5363,
]

_charnames_127744 = [
3031,
22700,
3247,
21146,
7351,
7350,
3310,
7355,
22005,
16026,
22140,
17396,
9431,
14584,
14583,
14582,
19384,
20862,
22153,
22658,
22152,
22733,
22155,
11068,
22156,
3333,
20861,
22657,
11067,
22732,
7353,
19383,
6862,
5357,
16252,
22161,
22165,
22163,
22164,
3253,
3252,
3254,
3251,
22699,
22289,
21597,
4943,
16343,
2490,
7636,
14604,
20532,
17744,
2774,
21596,
5419,
2485,
21980,
21629,
7356,
16295,
14588,
14587,
21568,
22690,
8652,
22650,
11300,
9513,
5388,
13060,
19241,
8239,
22144,
4190,
11298,
15860,
18197,
21753,
19141,
18155,
18157,
2486,
7542,
21364,
7627,
8240,
18171,
21874,
21875,
2164,
1573,
7546,
7582,
16031,
22729,
21986,
20601,
18901,
7359,
22728,
22677,
7434,
6842,
22477,
20267,
2163,
2500,
2619,
11386,
1578,
21606,
6857,
16397,
18177,
2162,
22695,
5315,
7073,
22291,
2169,
5440,
16411,
3265,
15865,
22696,
16354,
18186,
21856,
22322,
16415,
22605,
2499,
22651,
22663,
22664,
15718,
17695,
2152,
4191,
3318,
18198,
22602,
2681,
22288,
9031,
7654,
19242,
21549,
16382,
9432,
21751,
9511,
7551,
11296,
2155,
16403,
16402,
22673,
12822,
2682,
22740,
21971,
22676,
9422,
9034,
3311,
21556,
12536,
5380,
3308,
5157,
3259,
18147,
17381,
20589,
7633,
16420,
19485,
16376,
22709,
9512,
9487,
7072,
19474,
9510,
5443,
17384,
9509,
21941,
5311,
7677,
15839,
2491,
7660,
21942,
7362,
7585,
5441,
21586,
13063,
21943,
7668,
22312,
19480,
22012,
22013,
3335,
17395,
22682,
22476,
4940,
7661,
2768,
16406,
16344,
21591,
3309,
20534,
3260,
20521,
20522,
21133,
7536,
21590,
21592,
18900,
22599,
14602,
21607,
15854,
13058,
21599,
11381,
2159,
7653,
20535,
22643,
22478,
22603,
14603,
22224,
16283,
22147,
22149,
21981,
16227,
11070,
15873,
16378,
13062,
14563,
14562,
14561,
14560,
14559,
22016,
9016,
18894,
22143,
2165,
5153,
11297,
22014,
2760,
20610,
3326,
22233,
7664,
7663,
21584,
22017,
19477,
6874,
9006,
21983,
2497,
20279,
18192,
16386,
14530,
18892,
7573,
16297,
12041,
21605,
11069,
22675,
5439,
16294,
5417,
21357,
15864,
22722,
16416,
18152,
20082,
18189,
20609,
15851,
20283,
9017,
2166,
5154,
22015,
2761,
20611,
7584,
21587,
9007,
20280,
18195,
22723,
21363,
22309,
16405,
17759,
18194,
17763,
2495,
14591,
14590,
14578,
21077,
9018,
5387,
22228,
22185,
22188,
22221,
22678,
22148,
18898,
5353,
5354,
3258,
18871,
3324,
22300,
14592,
20939,
5457,
22610,
20614,
20078,
16421,
22301,
18206,
21319,
18172,
8356,
13071,
21623,
22299,
22302,
22702,
16338,
16337,
16379,
19481,
8242,
22297,
22652,
8354,
5452,
5450,
18181,
22303,
16027,
18135,
8349,
8348,
18631,
18630,
15861,
2157,
18125,
22600,
22601,
19484,
15866,
14575,
12708,
22432,
7678,
22417,
19472,
20602,
10425,
21136,
22642,
21367,
15868,
7512,
18200,
20076,
11380,
21870,
19455,
20069,
16381,
2146,
22317,
16404,
16032,
5453,
7580,
19250,
21551,
16291,
19139,
22876,
18207,
21550,
21739,
21552,
20576,
14528,
12054,
16384,
7618,
2167,
7587,
20607,
20599,
18201,
22712,
20583,
7569,
5356,
22210,
21632,
9004,
1574,
21519,
3334,
15856,
15859,
15858,
15857,
9003,
2374,
7644,
18143,
16028,
9428,
22710,
18874,
20621,
22669,
18869,
17750,
17752,
2771,
5314,
2675,
2373,
2375,
15869,
3266,
18209,
21976,
17764,
7541,
5424,
16372,
11299,
21069,
21070,
3249,
18872,
19140,
16292,
18856,
16373,
21134,
7647,
8238,
5304,
17754,
22646,
7071,
18210,
2489,
18890,
22431,
17765,
14609,
22429,
14546,
3246,
3245,
18865,
18866,
18183,
18184,
20867,
9026,
9028,
17385,
9029,
21066,
12050,
2766,
2767,
17382,
5307,
22009,
17383,
22672,
18188,
18127,
5456,
3238,
3239,
3242,
12049,
11373,
21627,
7564,
7560,
7563,
7562,
15792,
14527,
11193,
21854,
11378,
3248,
20079,
11374,
18870,
16408,
16410,
16371,
10242,
22010,
15849,
14543,
18887,
7436,
5381,
21065,
20080,
22407,
22405,
22409,
22408,
22406,
22661,
14526,
22321,
21359,
21140,
21609,
18202,
9421,
5308,
3331,
6645,
22598,
5427,
16190,
22170,
11055,
11054,
11048,
11053,
7610,
7611,
22803,
20253,
22801,
20252,
11372,
22813,
3299,
3321,
3320,
21076,
21075,
7518,
22191,
21489,
3339,
18897,
20281,
20067,
9035,
7515,
7930,
16377,
3232,
3199,
3205,
3219,
3222,
3212,
3215,
3229,
3235,
3208,
3226,
3202,
3231,
3198,
3204,
3218,
3221,
3211,
3214,
3228,
3234,
3207,
3225,
3201,
21824,
21827,
21826,
16340,
16341,
21871,
16370,
2620,
8355,
16199,
21057,
21603,
8352,
7622,
20604,
7576,
7577,
22609,
8353,
11184,
5305,
21846,
22199,
16261,
5306,
3261,
15850,
7535,
14545,
22717,
18153,
10241,
16284,
11367,
11371,
11369,
11368,
11370,
11182,
5412,
21993,
21724,
21721,
21722,
21723,
21726,
21992,
22184,
6576,
6575,
6581,
6580,
16235,
16226,
6574,
6577,
6579,
6582,
16273,
16247,
16277,
20525,
20081,
5334,
18122,
18190,
16279,
22205,
7433,
4942,
22292,
18886,
5454,
5335,
5434,
18408,
21365,
7649,
18123,
22647,
18875,
20276,
20277,
20278,
22726,
22725,
22727,
16286,
22703,
18868,
2676,
2677,
22670,
14551,
14553,
14554,
21068,
21072,
21073,
14557,
14555,
14556,
20274,
17747,
17753,
22157,
7574,
7575,
20524,
9427,
8654,
18896,
3240,
2616,
22428,
20533,
1905,
18627,
21972,
17751,
7554,
20596,
10424,
7565,
5323,
5322,
5321,
5320,
11165,
21828,
5451,
5332,
11175,
21839,
11172,
21836,
9032,
10422,
10421,
15713,
15717,
15714,
15716,
15711,
10420,
15712,
22307,
9015,
5389,
7530,
6647,
9033,
19245,
19246,
22627,
7592,
7595,
7596,
7594,
7600,
7598,
22290,
7603,
22639,
21752,
7599,
7602,
7607,
20934,
14576,
22861,
22630,
18151,
2150,
2151,
20071,
22640,
20073,
20074,
22617,
22619,
22620,
20579,
22306,
12053,
18169,
3329,
18144,
22634,
20580,
22721,
12052,
22742,
22315,
7621,
5056,
19248,
11385,
22622,
21631,
22623,
22638,
13074,
22718,
7619,
20584,
22636,
22633,
19247,
2764,
7605,
7606,
2763,
20075,
18170,
3330,
22316,
7626,
7625,
22812,
22631,
22632,
22624,
18142,
7637,
21553,
7566,
21366,
18139,
18140,
18137,
18138,
21036,
7413,
21046,
7423,
5406,
5396,
5407,
5397,
21035,
7412,
21045,
7422,
21502,
21469,
21505,
21472,
21037,
7414,
21047,
7424,
21503,
21470,
21506,
21473,
21601,
21602,
7430,
7431,
11143,
22796,
21809,
20248,
7648,
21480,
10423,
21491,
21499,
7669,
7066,
7067,
7068,
21545,
7069,
21478,
17351,
17360,
2492,
21738,
21984,
21567,
7547,
22008,
21621,
21622,
5435,
8236,
10417,
7531,
5430,
5431,
16335,
18882,
5442,
16339,
9429,
13064,
22665,
18179,
18880,
4941,
18879,
13057,
18883,
21749,
20527,
12537,
5433,
9000,
9012,
7358,
9013,
12904,
6867,
21982,
7568,
21579,
17370,
2158,
18180,
5425,
20282,
21060,
7613,
21064,
18208,
20284,
18176,
21078,
16419,
21063,
16418,
9014,
18158,
21058,
2496,
7929,
22304,
21744,
15863,
5390,
22142,
6861,
15790,
15791,
17756,
1577,
15872,
11177,
5426,
18126,
3283,
16380,
19482,
2147,
7620,
6860,
16409,
16412,
18049,
18893,
6859,
]

_charnames_128736 = [
21361,
6869,
18899,
9024,
22007,
9023,
22804,
22805,
22802,
7612,
21053,
13079,
13080,
-1,
-1,
-1,
7070,
18881,
20590,
17757,
7652,
9022,
2621,
]

_charnames_128768 = [
12688,
12584,
12701,
12702,
12686,
12573,
12571,
12572,
12569,
12570,
12634,
12637,
12636,
12551,
12651,
12630,
12661,
12664,
12663,
12604,
12553,
12691,
12639,
12640,
12619,
12620,
12698,
12564,
12681,
12682,
12596,
12615,
12602,
12683,
12548,
12594,
12595,
12603,
12555,
12546,
12641,
12655,
12695,
12582,
12549,
12556,
12547,
12638,
12613,
12614,
12607,
12611,
12610,
12609,
12575,
12576,
12666,
12557,
12581,
12616,
12617,
12579,
12631,
12656,
12657,
12689,
12622,
12625,
12624,
12577,
12700,
12562,
12654,
12697,
12685,
12644,
12599,
12658,
12598,
12565,
12600,
12659,
12561,
12694,
12563,
12699,
12670,
12580,
12646,
12629,
12645,
12583,
12559,
12560,
12550,
12650,
12678,
12676,
12677,
12649,
12648,
12587,
12592,
12591,
12590,
12589,
12578,
12628,
12627,
12618,
12669,
12692,
12679,
12665,
12673,
12672,
]

_charnames_128896 = [
16233,
16270,
16224,
16244,
16197,
8219,
16358,
21529,
17356,
14569,
22231,
21975,
16256,
16196,
10416,
8210,
16357,
21527,
17355,
14568,
22168,
22169,
7244,
16258,
16266,
16182,
22177,
22178,
20575,
16257,
16265,
16181,
22193,
5348,
10418,
8221,
16362,
17363,
17361,
14573,
5347,
10415,
8203,
16361,
21479,
17353,
14572,
10408,
8208,
16363,
21540,
17362,
14574,
10414,
8200,
16360,
21475,
17352,
14571,
10419,
8216,
16364,
21512,
17358,
10412,
8214,
5333,
8213,
10405,
8207,
22689,
8206,
21735,
10409,
21541,
8201,
21476,
6646,
8217,
21511,
17359,
21510,
10411,
21535,
21534,
]

_charnames_129024 = [
11120,
22777,
21787,
20231,
11123,
22780,
21790,
20234,
11124,
22781,
21791,
20235,
-1,
-1,
-1,
-1,
11121,
22778,
21788,
20232,
11125,
22782,
21792,
20236,
21487,
21532,
21538,
21518,
21486,
21531,
21537,
21517,
11087,
22763,
21770,
20216,
11088,
22764,
21771,
20217,
11090,
22767,
21773,
20220,
11089,
22765,
21772,
20218,
11086,
22762,
21769,
20215,
11150,
22797,
21816,
20249,
11140,
22788,
21806,
20239,
11154,
22798,
21820,
20250,
11146,
22791,
21812,
20242,
11147,
22792,
21813,
20243,
]

_charnames_129104 = [
11141,
22789,
21807,
20240,
21041,
21051,
7428,
7418,
11160,
22809,
-1,
-1,
-1,
-1,
-1,
-1,
22277,
22265,
22271,
22283,
22253,
22259,
22246,
22240,
22279,
22267,
22273,
22285,
22255,
22261,
22248,
22242,
22276,
22264,
22270,
22282,
22252,
22258,
22245,
22239,
22278,
22266,
22272,
22284,
22254,
22260,
22247,
22241,
22275,
22263,
22269,
22281,
22251,
22257,
22244,
22238,
]

_charnames_129168 = [
11095,
22772,
21778,
20226,
11151,
22785,
21817,
20247,
11122,
22779,
21789,
20233,
21494,
21498,
21497,
21496,
11137,
21803,
11109,
21780,
11153,
21810,
11144,
21819,
11138,
21804,
11149,
21815,
22227,
22226,
]

_charnames_129296 = [
22873,
9005,
22626,
20937,
5349,
22635,
21985,
21633,
6446,
2770,
22003,
11190,
21851,
21320,
21321,
-1,
22629,
3255,
21132,
21973,
20608,
11361,
22641,
7665,
]

_charnames_129328 = [
18110,
-1,
-1,
7642,
18124,
8351,
9025,
6871,
18141,
22608,
22741,
8973,
22320,
22141,
21318,
-1,
22293,
20612,
3264,
5418,
7586,
19478,
21876,
22660,
7643,
5350,
16385,
8578,
-1,
-1,
-1,
-1,
3325,
13054,
1580,
15852,
18175,
2679,
15871,
19138,
6844,
7550,
14275,
19381,
18156,
20077,
17760,
]

_charnames_129408 = [
3336,
10428,
7651,
5416,
22858,
14589,
20454,
15719,
6778,
18895,
22701,
16342,
20536,
19479,
10426,
22024,
6872,
7250,
]

_charnames_917760 = [
16800,
16789,
16778,
16933,
16922,
16911,
16900,
16889,
16944,
16955,
16954,
16953,
16952,
17032,
17031,
17030,
17029,
17028,
17027,
17026,
17025,
17024,
17023,
17021,
17020,
17019,
17018,
17017,
17016,
17015,
17014,
17013,
17012,
17010,
17009,
17008,
17007,
17006,
17005,
17004,
17003,
17002,
17001,
16999,
16998,
16997,
16996,
16995,
16994,
16993,
16992,
16991,
16990,
16988,
16987,
16986,
16985,
16984,
16983,
16982,
16981,
16980,
16979,
16977,
16976,
16975,
16974,
16973,
16972,
16971,
16970,
16969,
16968,
16966,
16965,
16964,
16963,
16962,
16961,
16960,
16959,
16958,
16957,
16887,
16886,
16885,
16884,
16883,
16882,
16881,
16880,
16879,
16878,
16876,
16875,
16874,
16873,
16872,
16871,
16870,
16869,
16868,
16867,
16865,
16864,
16863,
16862,
16861,
16860,
16859,
16858,
16857,
16856,
16854,
16853,
16852,
16851,
16850,
16849,
16848,
16847,
16846,
16845,
16843,
16842,
16841,
16840,
16839,
16838,
16837,
16836,
16835,
16834,
16832,
16831,
16830,
16829,
16828,
16827,
16826,
16825,
16824,
16823,
16821,
16820,
16819,
16818,
16817,
16816,
16815,
16814,
16813,
16812,
16810,
16809,
16808,
16807,
16806,
16805,
16804,
16803,
16802,
16801,
16799,
16798,
16797,
16796,
16795,
16794,
16793,
16792,
16791,
16790,
16788,
16787,
16786,
16785,
16784,
16783,
16782,
16781,
16780,
16779,
16943,
16942,
16941,
16940,
16939,
16938,
16937,
16936,
16935,
16934,
16932,
16931,
16930,
16929,
16928,
16927,
16926,
16925,
16924,
16923,
16921,
16920,
16919,
16918,
16917,
16916,
16915,
16914,
16913,
16912,
16910,
16909,
16908,
16907,
16906,
16905,
16904,
16903,
16902,
16901,
16899,
16898,
16897,
16896,
16895,
16894,
16893,
16892,
16891,
16890,
16951,
16950,
16949,
16948,
16947,
16946,
16945,
]

_charnames_983040 = [
21139,
21138,
7527,
7437,
7525,
7555,
14537,
14468,
14535,
14598,
14548,
14547,
13067,
13066,
12704,
16407,
15847,
16425,
2376,
21574,
21634,
4939,
10239,
20863,
14541,
11392,
21145,
14600,
10237,
17367,
17392,
22698,
22749,
2680,
3312,
6865,
11377,
7364,
6866,
11376,
5459,
20603,
20622,
20510,
20620,
20507,
20619,
20508,
20618,
20511,
20617,
20932,
21135,
7514,
7513,
14536,
14469,
2615,
2502,
14540,
14599,
7361,
7360,
14595,
14594,
22416,
22668,
22747,
22414,
19251,
19483,
22413,
21750,
22023,
22415,
22857,
22865,
7557,
20528,
20526,
17762,
17761,
21626,
21608,
16030,
16426,
21062,
21143,
22426,
22424,
20936,
20938,
7524,
7671,
14538,
14596,
2379,
21577,
21635,
2378,
21576,
21636,
10238,
17368,
17393,
17692,
17693,
18051,
17694,
17691,
18050,
21734,
21737,
21754,
6637,
6643,
7673,
6638,
6642,
7672,
20509,
20616,
18119,
18116,
18212,
18118,
18115,
18211,
7639,
7556,
2617,
3343,
8237,
9571,
7528,
7526,
7578,
14542,
14539,
14606,
7523,
7435,
6639,
7679,
6640,
7655,
2154,
3341,
7543,
7519,
18873,
18837,
18120,
18216,
13076,
13077,
21142,
6873,
10978,
10770,
3342,
12707,
7511,
20066,
11062,
11063,
11064,
11065,
5128,
22746,
22745,
22744,
9572,
22871,
22869,
22872,
11389,
22020,
11391,
22022,
18215,
11388,
22019,
21144,
9573,
22323,
11390,
22021,
22748,
18214,
22313,
9424,
9425,
11084,
21767,
22875,
18095,
17034,
17145,
17279,
17268,
17257,
17246,
17235,
17224,
17213,
17134,
17123,
17112,
17101,
17090,
17079,
17068,
16424,
16383,
22870,
998,
1000,
16423,
17057,
17046,
17035,
17190,
17179,
17168,
17157,
17146,
17201,
17212,
17211,
17210,
17209,
17289,
17288,
17287,
17286,
17285,
17284,
17283,
17282,
17281,
17280,
17278,
17277,
17276,
17275,
17274,
17273,
17272,
17271,
17270,
17269,
17267,
17266,
17265,
17264,
17263,
17262,
17261,
17260,
17259,
17258,
17256,
17255,
17254,
17253,
17252,
17251,
17250,
17249,
17248,
17247,
17245,
17244,
17243,
17242,
17241,
17240,
17239,
17238,
17237,
17236,
17234,
17233,
17232,
17231,
17230,
17229,
17228,
17227,
17226,
17225,
17223,
17222,
17221,
17220,
17219,
17218,
17217,
17216,
17215,
17214,
17144,
17143,
17142,
17141,
17140,
17139,
17138,
17137,
17136,
17135,
17133,
17132,
17131,
17130,
17129,
17128,
17127,
17126,
17125,
17124,
17122,
17121,
17120,
17119,
17118,
17117,
17116,
17115,
17114,
17113,
17111,
17110,
17109,
17108,
17107,
17106,
17105,
17104,
17103,
17102,
17100,
17099,
17098,
17097,
17096,
17095,
17094,
17093,
17092,
17091,
17089,
17088,
17087,
17086,
17085,
17084,
17083,
17082,
17081,
17080,
17078,
17077,
17076,
17075,
17074,
17073,
17072,
17071,
17070,
17069,
17067,
17066,
17065,
17064,
17063,
17062,
17061,
17060,
17059,
17058,
17056,
17055,
17054,
17053,
17052,
17051,
17050,
17049,
17048,
17047,
17045,
17044,
17043,
17042,
17041,
17040,
17039,
17038,
17037,
17036,
17200,
17199,
17198,
17197,
17196,
17195,
17194,
17193,
17192,
17191,
17189,
17188,
17187,
17186,
17185,
17184,
17183,
17182,
17181,
17180,
17178,
17177,
17176,
17175,
17174,
17173,
17172,
17171,
17170,
17169,
17167,
17166,
17165,
17164,
17163,
17162,
17161,
17160,
17159,
17158,
17156,
17155,
17154,
17153,
17152,
17151,
17150,
17149,
17148,
17147,
17208,
17207,
17206,
17205,
17204,
17203,
17202,
]

_charnames_983552 = [
10848,
10618,
10824,
10499,
10826,
10501,
10827,
10502,
10835,
10510,
10836,
10511,
10868,
10546,
10541,
10710,
10905,
10600,
10907,
10602,
10908,
10603,
10872,
10488,
10918,
10556,
10846,
10615,
10845,
10614,
10830,
10505,
10829,
10504,
10833,
10508,
10832,
10507,
10540,
10539,
10867,
10544,
10866,
10543,
10973,
10782,
10928,
10633,
10958,
10713,
10885,
10574,
10922,
10560,
10921,
10559,
10919,
10557,
10917,
10555,
10626,
10595,
10596,
10446,
10447,
10485,
10486,
10739,
10740,
12463,
12467,
12464,
12469,
12468,
12466,
12470,
12465,
12471,
16391,
4524,
4513,
4532,
4512,
4521,
4510,
4520,
4509,
4528,
4529,
4526,
4522,
4517,
4527,
4519,
4518,
4523,
4511,
4530,
4516,
4515,
4514,
4531,
4525,
4355,
4360,
4361,
4356,
4357,
4362,
4363,
4354,
4358,
4359,
4353,
4238,
4243,
4244,
4239,
4240,
4245,
4246,
4237,
4241,
4242,
4236,
4498,
4503,
4504,
4499,
4500,
4505,
4506,
4497,
4501,
4502,
4496,
4225,
4230,
4231,
4226,
4227,
4232,
4233,
4224,
4228,
4229,
4223,
4369,
4374,
4375,
4370,
4371,
4376,
4377,
4368,
4372,
4373,
4367,
4212,
4217,
4218,
4213,
4214,
4219,
4220,
4211,
4215,
4216,
4210,
4381,
4386,
4387,
4382,
4383,
4388,
4389,
4380,
4384,
4385,
4379,
4250,
4255,
4256,
4251,
4252,
4257,
4258,
4249,
4253,
4254,
4248,
4446,
4451,
4452,
4447,
4448,
4453,
4454,
4445,
4449,
4450,
4444,
4459,
4464,
4465,
4460,
4461,
4466,
4467,
4458,
4462,
4463,
4457,
4420,
4425,
4426,
4421,
4422,
4427,
4428,
4419,
4423,
4424,
4418,
4407,
4412,
4413,
4408,
4409,
4414,
4415,
4406,
4410,
4411,
4405,
4329,
4334,
4335,
4330,
4331,
4336,
4337,
4328,
4332,
4333,
4327,
4433,
4438,
4439,
4434,
4435,
4440,
4441,
4432,
4436,
4437,
4431,
4305,
4310,
4311,
4306,
4307,
4312,
4313,
4304,
4308,
4309,
4303,
4317,
4322,
4323,
4318,
4319,
4324,
4325,
4316,
4320,
4321,
4315,
4395,
4400,
4401,
4396,
4397,
4402,
4403,
4394,
4398,
4399,
4393,
4200,
4205,
4206,
4201,
4202,
4207,
4208,
4199,
4203,
4204,
4198,
4472,
4477,
4478,
4473,
4474,
4479,
4480,
4471,
4475,
4476,
4470,
4264,
4269,
4270,
4265,
4266,
4271,
4272,
4263,
4267,
4268,
4262,
4278,
4283,
4284,
4279,
4280,
4285,
4286,
4277,
4281,
4282,
4276,
4290,
4295,
4296,
4291,
4292,
4297,
4298,
4289,
4293,
4294,
4288,
4485,
4490,
4491,
4486,
4487,
4492,
4493,
4484,
4488,
4489,
4483,
4340,
4343,
4348,
4349,
4344,
4345,
4350,
4351,
4342,
4346,
4347,
4341,
4273,
6633,
6632,
6631,
19444,
19583,
19581,
19582,
19580,
19576,
19589,
19587,
19588,
19586,
19574,
19604,
19567,
19603,
19566,
19577,
19572,
19570,
19571,
19569,
19575,
19610,
19597,
19598,
19596,
19608,
19605,
19607,
19600,
19606,
19592,
19591,
19593,
19609,
19601,
19619,
19615,
19612,
19613,
19616,
19618,
19620,
21617,
21615,
21613,
21616,
21614,
20047,
20045,
20043,
20046,
20044,
20054,
20051,
20052,
20053,
8829,
8823,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 10680
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 10450
    elif code == 687: res = 10451
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 895: res = _charnames_880[code-880]
    elif code == 975: res = 19096
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1723
    elif code == 1231: res = 2859
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1327: res = _charnames_1296[code-1296]
    elif code == 1421: res = 21852
    elif code == 1422: res = 11191
    elif code == 1423: res = 12538
    elif code == 1442: res = 21564
    elif code == 1466: res = 21561
    elif code == 1477: res = 21563
    elif code == 1478: res = 21562
    elif code == 1479: res = 21560
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 12317
    elif code == 1596: res = 12315
    elif code == 1597: res = 12277
    elif code == 1598: res = 12275
    elif code == 1599: res = 12276
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 12365
    elif code == 1775: res = 12307
    elif code == 1791: res = 12344
    elif code == 1837: res = 7510
    elif code == 1838: res = 7508
    elif code == 1839: res = 7509
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2142: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2260 <= code <= 2308: res = _charnames_2260[code-2260]
    elif code == 2362: res = 20497
    elif code == 2363: res = 20496
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2432: res = _charnames_2417[code-2417]
    elif code == 2493: res = 16393
    elif code == 2510: res = 16392
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 19469
    elif code == 2677: res = 19467
    elif code == 2700: res = 19459
    elif code == 2785: res = 19460
    elif code == 2786: res = 19462
    elif code == 2787: res = 19463
    elif code == 2800: res = 19465
    elif code == 2801: res = 19464
    elif code == 2809: res = 19461
    elif code == 2869: res = 18855
    elif code == 2884: res = 18852
    elif code == 2914: res = 18850
    elif code == 2915: res = 18851
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 4543
    elif code == 3024: res = 4540
    elif code == 3046: res = 4535
    elif 3059 <= code <= 3072: res = _charnames_3059[code-3059]
    elif code == 3124: res = 5294
    elif code == 3133: res = 5299
    elif code == 3160: res = 5292
    elif code == 3161: res = 5295
    elif code == 3162: res = 5293
    elif code == 3170: res = 5300
    elif code == 3171: res = 5301
    elif 3192 <= code <= 3201: res = _charnames_3192[code-3192]
    elif code == 3260: res = 20060
    elif code == 3261: res = 20063
    elif code == 3298: res = 20064
    elif code == 3299: res = 20065
    elif code == 3313: res = 20061
    elif code == 3314: res = 20058
    elif code == 3329: res = 8621
    elif code == 3369: res = 8594
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif 3406 <= code <= 3427: res = _charnames_3406[code-3406]
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 11060
    elif code == 3807: res = 11059
    elif code == 3947: res = 5145
    elif code == 3948: res = 5144
    elif code == 3980: res = 5142
    elif code == 3981: res = 5138
    elif code == 3982: res = 5137
    elif code == 3983: res = 5139
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 21314
    elif code == 4443: res = 21304
    elif code == 4444: res = 21306
    elif code == 4445: res = 21305
    elif code == 4446: res = 21288
    elif code == 4515: res = 21266
    elif code == 4516: res = 21250
    elif code == 4517: res = 21249
    elif code == 4518: res = 21253
    elif code == 4519: res = 21254
    elif code == 4602: res = 21210
    elif code == 4603: res = 21209
    elif code == 4604: res = 21213
    elif code == 4605: res = 21211
    elif code == 4606: res = 21212
    elif code == 4607: res = 21162
    elif code == 4615: res = 14448
    elif code == 4679: res = 14412
    elif code == 4743: res = 14402
    elif code == 4783: res = 14422
    elif code == 4815: res = 14444
    elif code == 4847: res = 14443
    elif code == 4879: res = 14322
    elif code == 4895: res = 14320
    elif code == 4935: res = 14380
    elif code == 4957: res = 14466
    elif code == 4958: res = 14467
    elif code == 4959: res = 14465
    elif code == 4960: res = 14449
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif 5109 <= code <= 5120: res = _charnames_5109[code-5109]
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6109: res = 19562
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6846: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7304: res = _charnames_7164[code-7164]
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7376 <= code <= 7679: res = _charnames_7376[code-7376]
    elif code == 7836: res = 10642
    elif code == 7837: res = 10641
    elif code == 7838: res = 10878
    elif code == 7839: res = 10686
    elif code == 7930: res = 10956
    elif code == 7931: res = 10719
    elif code == 7932: res = 10955
    elif code == 7933: res = 10718
    elif code == 7934: res = 10985
    elif code == 7935: res = 10775
    elif 8275 <= code <= 8297: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8382: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1788
    elif code == 8428: res = 1848
    elif code == 8429: res = 1782
    elif code == 8430: res = 1780
    elif code == 8431: res = 1846
    elif code == 8432: res = 1871
    elif code == 8507: res = 22644
    elif code == 8508: res = 20266
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif 8580 <= code <= 8587: res = _charnames_8580[code-8580]
    elif 9167 <= code <= 9214: res = _charnames_9167[code-9167]
    elif code == 9471: res = 20931
    elif code == 9748: res = 22863
    elif code == 9749: res = 21598
    elif code == 9752: res = 6843
    elif code == 9854: res = 18146
    elif code == 9855: res = 22232
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 7581
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 21483
    elif code == 10080: res = 21484
    elif code == 10133: res = 21542
    elif code == 10134: res = 21544
    elif code == 10135: res = 21520
    elif code == 10160: res = 1575
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 8641
    elif code == 10221: res = 8637
    elif code == 10222: res = 8642
    elif code == 10223: res = 8638
    elif 11008 <= code <= 11217: res = _charnames_11008[code-11008]
    elif code == 11244: res = 11104
    elif code == 11245: res = 22773
    elif code == 11246: res = 21779
    elif code == 11247: res = 20227
    elif 11264 <= code <= 11623: res = _charnames_11264[code-11264]
    elif code == 11631: res = 5122
    elif code == 11632: res = 5121
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11844: res = _charnames_11680[code-11680]
    elif code == 12589: res = 16368
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 17687
    elif code == 12830: res = 17688
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 3303
    elif code == 12925: res = 3302
    elif code == 12926: res = 3306
    elif code == 13004: res = 7239
    elif code == 13005: res = 7242
    elif code == 13006: res = 7241
    elif code == 13007: res = 10335
    elif code == 13175: res = 7232
    elif code == 13176: res = 7234
    elif code == 13177: res = 7235
    elif code == 13178: res = 7246
    elif code == 13278: res = 7243
    elif code == 13279: res = 7249
    elif code == 13311: res = 7247
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42743: res = _charnames_42560[code-42560]
    elif 42752 <= code <= 42935: res = _charnames_42752[code-42752]
    elif 42999 <= code <= 43127: res = _charnames_42999[code-42999]
    elif 43136 <= code <= 43205: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43574: res = _charnames_43359[code-43359]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 44025: res = _charnames_43888[code-43888]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 3153
    elif code == 64047: res = 3152
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 12393
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif 65060 <= code <= 65071: res = _charnames_65060[code-65060]
    elif code == 65095: res = 18099
    elif code == 65096: res = 18096
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65952: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 18628
    elif 66384 <= code <= 66517: res = _charnames_66384[code-66384]
    elif code == 66598: res = 20519
    elif code == 66599: res = 20520
    elif 66638 <= code <= 66855: res = _charnames_66638[code-66638]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 2759
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67584 <= code <= 67742: res = _charnames_67584[code-67584]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67903: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68167: res = _charnames_67968[code-67968]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68255: res = _charnames_68192[code-68192]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68352 <= code <= 68497: res = _charnames_68352[code-68352]
    elif code == 68505: res = 18088
    elif code == 68506: res = 18087
    elif code == 68507: res = 18086
    elif code == 68508: res = 18085
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif code == 68858: res = 18331
    elif code == 68859: res = 18336
    elif code == 68860: res = 18338
    elif code == 68861: res = 18337
    elif code == 68862: res = 18334
    elif code == 68863: res = 18333
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69759 <= code <= 69825: res = _charnames_69759[code-69759]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70749: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 22136
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 73728 <= code <= 74649: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74868: res = _charnames_74752[code-74752]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 4189
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif code == 110592: res = 20055
    elif code == 110593: res = 21618
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif code == 119081: res = 9508
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119665: res = _charnames_119648[code-119648]
    elif code == 120001: res = 8649
    elif code == 120484: res = 8645
    elif code == 120485: res = 8644
    elif code == 120778: res = 8648
    elif code == 120779: res = 8647
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 12228
    elif code == 126705: res = 12229
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127404: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 3276
    elif code == 127569: res = 3277
    elif 127744 <= code <= 128722: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128758: res = _charnames_128736[code-128736]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 128896 <= code <= 128980: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129296 <= code <= 129319: res = _charnames_129296[code-129296]
    elif 129328 <= code <= 129374: res = _charnames_129328[code-129328]
    elif 129408 <= code <= 129425: res = _charnames_129408[code-129408]
    elif code == 129472: res = 2488
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983498: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983981: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'N', 15360),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklkmnopqrstukvkwkkk\x15\x15\x15xyzkkkkkkkkkk\x15\x15\x15\x15{kkkkkkkkkkk'
'kkkk\x15\x15|kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x15\x15}~kkk\x7f5555555555555555'
'5555555\x8055\x81kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x82kkkkkkkkkkk\x83kkk'
'kkkkkkkkkkkkkkkk\x84\x85\x86\x87\x88\x89\x8a\x8b((\x8ckkkkk\x8dkkkkkkk\x8e\x8fkkkk\x90k\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9akkkkkk'
'\x9b\x9c5555555\x9d\x9e\x9f55555555555555555555555\xa055555\xa155555555555555555\xa25555'
'5555555555555555555555555555555555\xa355555555555555555555555555555'
'55555555555555555555555555555555555555\xa45555555555555555\xa5\xa65555555'
'55555555555555\xa7\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa05\xa9\xa8\xa8\xa8\xa8\xaa'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xaa'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'\xab\xackkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xad'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xad'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd6\x91\x91\x86\xa3\x86\x91\x92\x9bp\x91\xb0\x7ff\x80\x7fFFFFFFFFFF\x80\x91\xbe\xbd\xbe\x91'
'\x9188888888888888888888888888\x9b\x91p\xaac\xaa\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9b\xbdp\xbd\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd3\x89\xa3\xa3\x9f\xa3\xce\x89\xa7\xcd-y\xbd\x07\xca\xaa\xc2\xb2SS\xa7\x1b\x89\x8b\xa7S-uZZZ\x89'
'77777757777777775777777\xb55777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb5\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xa9\xa9\xa7\xa9)')''')'))\x1f$\xa9\xa9\xa9\xa9\xa9\xa9\xa7\xa7\xa7\xa7\xa9\xa7\xa9\xa7%%%%%\xa9\xa9\xa9\xa9\xa9\xa9\xa9)\xa9$\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xa97\x1b\x15\x15#\x1b\x1b\x1b\x8f7'
'\x15\x15\x15\x15\xa9\xa97\x90777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xba7\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xc8@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x88\x88\x88\x88\x88\x88\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x88i\x15\x15\xcd\xcd\xa2\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@k@'
'\x95@@\x95@@\x95@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x15\x15333\x95\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xba\xba\xac\x85\x85\x9e~z\xcd\xcd@@@@@@@@@@@z\x05\x15zz,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@CCCCCCCCCC\x85{{z,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,z,@@@@@@@\x06\xcd@@@@@@\x1e\x1e@@\xcd@@@@,,EEEEEEEEEE,,,\xc1\xc1,'
'zzzzzzzzzzzzzz\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'HHHHHHHHHH333333333333333333333333333333333@@@@@@@@@**\xcd\x8f\x8f\x8f*\x15\x15\x15\x15\x15'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x15'
'3333333333333333333333333@@@\x15\x15\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15,,,,,,,,\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@\x06@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x88\x88GGGGGGGGGG\x88$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG00\xa2\xa2WWWWWW\xc8\xa2\x15\x15\x15\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG@@000@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x88\xa2\x15\x15\x15\x15\x15\x15\x150\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG\xc80WWWWWW\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGWWW\xcd\xcd\xcd\xcd\xcd\xcd\xa2\xcd\x15\x15\x15\x15\x15'
'@:::\x1500000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\xc8'
'0@::\x1500000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15GGGGGGGGGG\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15000\x1500000000000000000000000000000000000000000\x15\x150::'
':@@@@\x15:::\x15:::@0\xc8\x15\x15\x15\x15000:WWWWWWW000@@\x15\x15GGGGGGGGGGWWWWWWWWW\xc8000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15::\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa2'
'000000$@@@@@@@@\x88GGGGGGGGGG\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15GGGGGGGGGG\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xc8\xc8\xc8\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xc8\x88\xc8\xc8\xc8@@\xc8\xc8\xc8\xc8\xc8\xc8GGGGGGGGGGWWWWWWWWWW\xc8@\xc8@\xc8@\x9ao\x9ao::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x88@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8@\xc8\xc8\xc8\xc8\xc8\xc8\x15\xc8\xc8\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'GGGGGGGGGG\x88\x88\x88\x88\x88\x88000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:GGGGGGGGGG:::@\xc8\xc877777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x150000000000000000000000000000000000000000000\x88$000'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x88\x88\x88\x88\x88\x88\x88\x88\x88XXXXXXXXXWWWWWWWWWWW\x15\x15\x15'
'0000000000000000\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'i000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x88\x8800000000000000000'
'\xd500000000000000000000000000\x9ao\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x88\x88\x88KKK00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x88\x88\x88$\x88\x88\x88\xa20@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\\\\x15\x15\x15\x15\x15\x15'
'\x8f\x8f\x8f\x8f\x8f\x8fi\x8f\x8f\x8f\x8f@@@\x08\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$0000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15'
'00000AA0000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcd\x15\x15\x15\x8f\x8fGGGGGGGGGG000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15GGGGGGGGGGX\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'00000000000000000000000@@::@\x15\x15\x88\x8800000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x88\x88\x88\x88\x88\x88\x88$\x88\x88\x88\x88\x88\x88\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15GGGGGGGGGG\x88\x88\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@@@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00GGGGGGGGGG000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x88\x88\x88\x88'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x88\x88\x88\x88\x88'
'GGGGGGGGGG\x15\x15\x15000GGGGGGGGGG000000000000000000000000000000$$$$$$\x88\x88'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x88\x88\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15@@@\x88@@@@@@@@@@@@@:@@@@@@@0000@0000::@00\x15@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15@@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\x1b\xa9'
'\xa9\xa9\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\xa9\xa9\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xa9\xa9\xa9\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xa9\xa9\xa9\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\xa9\x15'
'\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x08\x08\x08\n\x11hiihhh\x89\x8fwt\x99xvs\x99x\x89\x89\x89\x8f\x8a\x89\x89\x8a\xd1\xd2\x0b\x12\x0f\r\x14\xd3\x83\x85\x83\x83\x85\x89\x8f\x8f\x8fyu\x89\x8f\x8f\x89b'
'b\x8f\x8f\x8f\xad\x9ao\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\xba\x8fb\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\xd5\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08U%\x15\x15SUUUUU\xaf\xaf\xba\x9ao '
'USSSSUUUUU\xaf\xaf\xba\x9ao\x15%%%%%%%%%%%%%\x15\x15\x15\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa1\xa2\xa2\x9f\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd7\xca\xcd\xca\xcd7\xcd\xca\x1b777\x1b\x1b777\x19\xcd7\xca\xcd\xbc77777\xcd\xcd\xcd\xca\xca\xcd7\xcd5\xcd7\xcd7577\xc4\x1b7777\x1b0000\x1b\xcd\xcd\x1b\x1b77'
'\xbb\xba\xba\xba\xba7\x1b\x1b\x1b\x1b\xcd\xba\xcd\xcd\x1b\xc8\\\\\\ZZ\\\\\\\\\\\\ZZZZ\\IIIIIIIIIIIILLLLJJJJJJJJJJMMMMMM'
'KKK7\x1bKKKKZ\xcd\xcd\x15\x15\x15\x15\xb5\xb5\xb5\xb5\xb5\xca\xca\xca\xca\xca\xba\xba\xcd\xcd\xcd\xcd\xba\xcd\xcd\xba\xcd\xcd\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xcd\xcd\xb5\xcd\xb5\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xb5\xbb\xb6\xb6\xbb\xba\xba\xb5\xb6\xbb\xbb\xb6\xbb\xbb\xba\xb5\xba\xb6\xaf\xb3\xba\xb6\xbb\xba\xba\xba\xb6\xbb\xbb\xb6\xb5\xb6\xb6\xbb\xbb\xb5\xbb\xb5\xbb\xb5\xb5\xb5\xb5\xb6\xb6\xbb\xb6\xbb\xbb\xbb\xbb\xbb\xb5\xb5\xb5\xb5\xba\xbb\xba\xbb\xb6\xb6\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xb6\xbb\xbb\xbb\xb6\xba\xba\xba\xba\xba\xb6\xbb\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xb6\xb5\xbb\xba\xb6\xb6\xb6\xb6\xbb\xbb\xb6\xb6\xba\xba\xb6\xb6\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xb6\xb6\xbb\xbb\xb6\xb6\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xba\xba\xb5\xba\xba\xbb\xb5\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xb5\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xb6'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9ao\x9ao\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xbb\xbb\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9dr\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xcd\xba\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xc8\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcf\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15[[[[[[[[[ZZZZZZZZZZZ[[[[[[[[[ZZZ'
'ZZZZZZZZSSSSSSSSSRRRRRRRRRRR\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7]ZZZZZZZZZZ[[[[[[[[[Z['
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xca\xb5\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd'
'\xca\xb5\xcd\xcd\xcd\xcd\xca\xca\xca\xcd\xcd\xca\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xbf\xbf\xba'
'\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xca\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xca\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xca\xca\xca\xcd\xca\xca\xca\xca\xcd\xca\xca\xcd\xb5\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xc8\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xca'
'\xcd\xcd\xcd\xcd\xcf\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xcf\xca\xca\xca\xca\xca\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xca\xcd\xcd\xcd\xcd\xca\xca\xcf\xca\xca\xca\xca\xca\xca\xca\xcf\xcf\xca\xcf\xca\xca\xca\xca\xcf\xca\xca\xcf\xca\xca'
'\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao[[[[[[[[[Z'
']]]]]]]]]\\]]]]]]]]]\\\xcd\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf'
'\xbb\xba\xba\xbb\xbb\x9ao\xba\xbb\xbb\xba\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\x9bp\x9bp\x9bp\x9bp\x9ao\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\x9ao\x9bp\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xba\xba\xba\xba\xba\xba\xba'
'\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xba\xba\x9ao\x9ao\xbb\xba\xba\xba\xba\xbb\xba\xbb\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\x9ao\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xbb\xbb\xba\xba\xbb\xba\xbb\xba\xba\xbb\xba\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xba\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xba\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba\xba\xba\xba\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xbb\xba\xba'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xcd\xcd\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcd\xcd\xcd\xcd\xcd\xcd7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x8f\x8f\x8f\x8f\\\x8f\x8f'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x8f\x8fyuyu\x8f\x8f\x8fyu\x8fyu\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8fi\x8f\x8fi\x8fyu\x8f\x8fyu\x9ao\x9ao\x9ao\x9ao\x8f\x8f\x8f\x8f\x8f(\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8fii\x8f\x8f\x8f\x8f'
'i\x8f\x99\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15'
'\xd4\x93\x93\x93\xcf&1N\x9dr\x9dr\x9dr\x9dr\x9dr\xcf\xcf\x9dr\x9dr\x9dr\x9drj\x9cqq\xcfNNNNNNNNNBBBB;;j&&&&&\xcf\xcfNNN&1\x93\xcf\xcd'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15BB\xab\xab&&1j1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x93&&&1'
'\x15\x15\x15\x15\x1511111111111111111111111111111111111111111\x15\x15\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xc9\xc9YYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9111111111111111111111111111\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\x15YYYYYYYYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9VVVVVVVV\xcf^^^^^^^^^^^^^^^\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xc9'
'YYYYYYYYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9^^^^^^^^^^^^^^^'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xcf\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xcf\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x88\x88'
'000000000000$\x8f\x8f\x8f0000000000000000GGGGGGGGGG00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x8f@@@@@@@@@@\x8f)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000KKKKKKKKKK@@\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9)))))))))\xa9\xa97\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa6\xa67\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77777\x1577777\x1b7\x1b\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcd\xcd\xcd\xcd\x15\x15\x15\x15WWWWWW\xc8\xc8\xa2\xc3\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x8f\x8f\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@@\x15\x15\x15\x15\x15\x15\x15\x15\x88\x88GGGGGGGGGG\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x88\x88\x880\x880\x15\x15'
'GGGGGGGGGG0000000000000000000000000000@@@@@@@@\x88\x880000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8811111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@:::'
':\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x15$GGGGGGGGGG\x15\x15\x15\x15\x88\x8800000@$000000000GGGGGGGGGG00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15GGGGGGGGGG\x15\x15\x88\x88\x88\x880000000000000000$000000\xc8\xc8\xc80:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x88\x8800000000000:@@::\x88\x880$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa6%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x88:@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xaf3333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5'
'\xa5\xa5\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,n\x99'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9e\xcd\x15\x15'
'>>>>>>>>>>>>>>>>\x93\x93\x93\x94\x93\x93\x93\x9cq\x93\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x93jjdd\x9cq\x9cq\x9cq\x9cq\x9cq\x9c'
'q\x9cq\x9cq\x93\x93\x9cq\x93\x93\x93\x93ddd\x81\x93\x82\x15\x93\x82\x93\x93j\x9dr\x9dr\x9dr\x87\x93\x93\xb1g\xc0\xc0\xbf\x15\x93\xa4\x87\x93\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8c\x8c\x84\xa0\x84\x8c\x8d\x97l\x8c\xae|e}|DDDDDDDDDD}\x8c\xb8\xb7\xb8\x8c\x8c66666666666666666666666666\x97\x8cl\xa8a'
'\xa8\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x97\xb7l\xb7\x97l\x8e\x98m\x8e\x8e.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\xa0\xa0\xb7\xa8\xcb\xa0\xa0\x15\xcc\xb9\xb9\xb9\xb9\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcd\xca\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x88\x8f\x88\x15\x15\x15\x15WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\\\\\\\\\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\\\\\xcd\xc8\xc8\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@TTTTTTTTTTTTTTTTTTTTTTTTTTT\x15\x15\x15\x15'
'00000000000000000000000000000000WWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0K00000000K\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8800000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x88KKKKK\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x157777777777777777'
'77777777777777777777\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x95________33333333333333333333333\xd0\xd0_______'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15_________\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15_____'
'3333333333333333333333______\x15\x15\x15\x8f33333333333333333333333333\x15\x15\x15\x15\x15\x95'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15__33'
'________________\x15\x15______________________________________________'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x15333333333333333333333333333\x15\x15\x15\x15@@@\x15\x15\x15\x15@'
'````____\x15\x15\x15\x15\x15\x15\x15\x15\x95\x95\x95\x95\x95\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333__\x95'
'33333333333333333333333333333___\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xd03333333333333333333333333333@@\x15\x15\x15\x15_____\x95\x95\x95\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x8f\x8f\x8f\x8f\x8f\x8f\x8f'
'3333333333333333333333\x15\x15________3333333333333333333\x15\x15\x15\x15\x15________'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15_______\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15______'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15QQQQQQQQQPPPPPPPPPPPPPPPPPPPPPP\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x88\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15]]]]]]]]]\\\\\\\\\\\\\\\\\\\\\\GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x88\x88\n\x88\x88'
'\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15GGGGGGGGGG'
'\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x88\x880\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x88\x88\x88\x88\x88@@@\x88\x15\x15GGGGGGGGGG0\x880\x88\x88\x88\x15WWWWWWWWWWWWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x88\x88\x88\x88\x88\x88@\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x88\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000000000:::@@@@@@@@'
'::@@@:@0000\x88\x88\x88\x88\x88GGGGGGGGGG\x15\x88\x15\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x880\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x880000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x88\x88\x880\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@\x15\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000\x15\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15GGGGGGGGGGWW\x88\x88\x88\xc8'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bGGGGGGGGGGWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'000000000\x150000000000000000000000000000000000000:@@@@@@@\x15@@@@@@:='
'0\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGWWWWWWWWWWWWWWWWWWW\x15\x15\x15\x88\x8800000000000000'
'0000000000000000\x15\x15@@@@@@@@@@@@@@@@@@@@@@\x15:@@@@@@@:@@:@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x15\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15GGGGGGGGGG\x15\x15\x15\x15\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8'
'$$$$\x88\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15WWWWWWW\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150::::::::::::::::::::::::::::::::::::::::::::::\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15&\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'11\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xc8@@\x88\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8::@@@\xc8\xc8\xc8::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xc8\xc8@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd@@@\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15WWWWWWWWWWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc8\xc8\xc8\xc8@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8@\xc8\xc8\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@@@@\x15@@@@@@@@@@@@@@@@@\x15\x15@@@@@@@\x15@@\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15_________@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'9999999999999999999999999999999999\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'\x1d\x1d\x1d\x1d@@@@@@@\x15\x15\x15\x15\x15HHHHHHHHHH\x15\x15\x15\x15\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xba\xba\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'SSSSSSSSSSS\\\\\x15\x15\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc8\x15\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xcd\xcd\x15\x15\x15\x15\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc5\xc5\xc5\xc5\xc9\xc5\xc5\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc9\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15\x15\x15\x15'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcf\xcf\xcf\xab\xab\xab\xab\xab'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd'
'\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\x15\x15\x15\xcd\xcd\xcd\xcd\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x