# smbclient.py
# Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import subprocess
import copy
import re
from pyneighborhood import config, db, dblock
from pyneighborhood.misc import print_debug

sharere = re.compile("^\t(.*)Disk *(.*)$", re.M)
anonsharelookupcommand = [ config.get("Main", "smbclient"), "-N", "-L" ]

def scan_shares(ip, manual=False):
    """
    Get a list of shares at ip
    """
    print_debug("Scanning for Shares: " + ip)
    manual = 1 if manual else 0
    command = copy.copy(anonsharelookupcommand)
    command.append(ip)
    process = subprocess.Popen(command,
                                executable = command[0],
                                stdout = subprocess.PIPE,
                                stderr = subprocess.STDOUT )
    process.wait()
    output = process.stdout.read()
    print_debug(command, output)
    match = sharere.search(output)
    cursor = db.cursor()
    host_id = cursor.execute("""SELECT id FROM hosts WHERE ip=?;""", (ip,)).fetchall()
    if host_id:    
        while match:
            sharename = match.group(1).rstrip()
            comment = match.group(2).rstrip()
            result = cursor.execute("""SELECT * FROM shares WHERE name = ? AND host = ?""", (sharename,host_id[0][0])).fetchall()
            if len(result) == 0:
                dblock.acquire()
                cursor.execute("""INSERT INTO shares (name,host,comment,manual) VALUES (?,?,?,?);""", (sharename,host_id[0][0],comment, manual))
                dblock.release()
            elif len(result) == 1:
                dblock.acquire()
                cursor.execute("""UPDATE shares SET validated = 1 WHERE id = ?""", (result[0][0],))
                dblock.release()
            match = sharere.search(output, match.end())
