
from grendel.chemistry.element import Element, Isotope
from grendel.util.units import AtomicMassUnit, ElectronVolt, Picometers, KilojoulesPerMole

MASS_UNIT = AtomicMassUnit


Elements = dict()

# Ghost atoms
Gh = X = Element(
    symbol="X",
    atomic_number=0,
    atomic_weight=0,
    isotopes=[
        Isotope(
            mass=0.0,
            mass_uncertainty=0,
            abundance=1.0,
            abundance_uncertainty=None,
            mass_number=0,
            special_symbol=None
        )
    ]
)
Elements['X'] = X
Elements['Gh'] = X


H = Element(
    symbol="H",
    atomic_number=1,
    atomic_weight=1.00794,
    atomic_weight_uncertainty=0.00007,
    vdw_radius=120. * Picometers,
    ionization_energies=[1312. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=1.00782503207,
            mass_uncertainty=0.00000000010,
            abundance=0.999885,
            abundance_uncertainty=0.000070,
            mass_number=1,
            special_symbol=None
        ),
        Isotope(
            mass=2.0141017778,
            mass_uncertainty=0.0000000004,
            abundance=0.000115,
            abundance_uncertainty=0.000070,
            mass_number=2,
            special_symbol="D"
        ),
        Isotope(
            mass=3.0160492777,
            mass_uncertainty=0.0000000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=3,
            special_symbol="T"
        ),
        Isotope(
            mass=4.02781,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=4,
            special_symbol=None
        ),
        Isotope(
            mass=5.03531,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=5,
            special_symbol=None
        ),
        Isotope(
            mass=6.04494,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=6,
            special_symbol=None
        ),
        Isotope(
            mass=7.05275,
            mass_uncertainty=0.00108,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=7,
            special_symbol=None
        )
    ]
)
Elements['H'] = H


He = Element(
    symbol="He",
    atomic_number=2,
    atomic_weight=4.002602,
    atomic_weight_uncertainty=0.000002,
    vdw_radius=140. * Picometers,
    ionization_energies=[2372.3 * KilojoulesPerMole, 5250.5 * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=3.0160293191,
            mass_uncertainty=0.0000000026,
            abundance=0.00000134,
            abundance_uncertainty=0.00000003,
            mass_number=3,
            special_symbol=None
        ),
        Isotope(
            mass=4.00260325415,
            mass_uncertainty=0.00000000006,
            abundance=0.99999866,
            abundance_uncertainty=0.00000003,
            mass_number=4,
            special_symbol=None
        ),
        Isotope(
            mass=5.012220,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=5,
            special_symbol=None
        ),
        Isotope(
            mass=6.0188891,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=6,
            special_symbol=None
        ),
        Isotope(
            mass=7.028021,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=7,
            special_symbol=None
        ),
        Isotope(
            mass=8.033922,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=8,
            special_symbol=None
        ),
        Isotope(
            mass=9.043950,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=9,
            special_symbol=None
        ),
        Isotope(
            mass=10.052400,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=10,
            special_symbol=None
        )
    ]
)
Elements['He'] = He


Li = Element(
    symbol="Li",
    atomic_number=3,
    atomic_weight=6.941,
    atomic_weight_uncertainty=0.002,
    vdw_radius=182. * Picometers,
    ionization_energies=[520.2 * KilojoulesPerMole, 7298.1 * KilojoulesPerMole, 11815. * KilojoulesPerMole],
    electronegativity=0.98,
    isotopes=[
        Isotope(
            mass=3.03078,
            mass_uncertainty=0.00215,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=3,
            special_symbol=None
        ),
        Isotope(
            mass=4.02719,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=4,
            special_symbol=None
        ),
        Isotope(
            mass=5.012540,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=5,
            special_symbol=None
        ),
        Isotope(
            mass=6.015122795,
            mass_uncertainty=0.000000016,
            abundance=0.0759,
            abundance_uncertainty=0.0004,
            mass_number=6,
            special_symbol=None
        ),
        Isotope(
            mass=7.01600455,
            mass_uncertainty=0.00000008,
            abundance=0.9241,
            abundance_uncertainty=0.0004,
            mass_number=7,
            special_symbol=None
        ),
        Isotope(
            mass=8.02248736,
            mass_uncertainty=0.00000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=8,
            special_symbol=None
        ),
        Isotope(
            mass=9.0267895,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=9,
            special_symbol=None
        ),
        Isotope(
            mass=10.035481,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=10,
            special_symbol=None
        ),
        Isotope(
            mass=11.043798,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=11,
            special_symbol=None
        ),
        Isotope(
            mass=12.05378,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=12,
            special_symbol=None
        )
    ]
)
Elements['Li'] = Li


Be = Element(
    symbol="Be",
    atomic_number=4,
    atomic_weight=9.012182,
    atomic_weight_uncertainty=0.000003,
    ionization_energies=[899.5 * KilojoulesPerMole, 1757.1 * KilojoulesPerMole, 14848.7 * KilojoulesPerMole, 21006.6 * KilojoulesPerMole],
    electronegativity=1.57,
    isotopes=[
        Isotope(
            mass=5.04079,
            mass_uncertainty=0.00429,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=5,
            special_symbol=None
        ),
        Isotope(
            mass=6.019726,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=6,
            special_symbol=None
        ),
        Isotope(
            mass=7.01692983,
            mass_uncertainty=0.00000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=7,
            special_symbol=None
        ),
        Isotope(
            mass=8.00530510,
            mass_uncertainty=0.00000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=8,
            special_symbol=None
        ),
        Isotope(
            mass=9.0121822,
            mass_uncertainty=0.0000004,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=9,
            special_symbol=None
        ),
        Isotope(
            mass=10.0135338,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=10,
            special_symbol=None
        ),
        Isotope(
            mass=11.021658,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=11,
            special_symbol=None
        ),
        Isotope(
            mass=12.026921,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=12,
            special_symbol=None
        ),
        Isotope(
            mass=13.035690,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=13,
            special_symbol=None
        ),
        Isotope(
            mass=14.04289,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.05346,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=16.06192,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        )
    ]
)
Elements['Be'] = Be


B = Element(
    symbol="B",
    atomic_number=5,
    atomic_weight=10.811,
    atomic_weight_uncertainty=0.007,
    ionization_energies=[800.6 * KilojoulesPerMole, 2427.1 * KilojoulesPerMole, 3659.7 * KilojoulesPerMole, 25025.8 * KilojoulesPerMole, 32826.7 * KilojoulesPerMole],
    electronegativity=2.04,
    isotopes=[
        Isotope(
            mass=6.04681,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=6,
            special_symbol=None
        ),
        Isotope(
            mass=7.029920,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=7,
            special_symbol=None
        ),
        Isotope(
            mass=8.0246072,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=8,
            special_symbol=None
        ),
        Isotope(
            mass=9.0133288,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=9,
            special_symbol=None
        ),
        Isotope(
            mass=10.0129370,
            mass_uncertainty=0.0000004,
            abundance=0.199,
            abundance_uncertainty=0.007,
            mass_number=10,
            special_symbol=None
        ),
        Isotope(
            mass=11.0093054,
            mass_uncertainty=0.0000004,
            abundance=0.801,
            abundance_uncertainty=0.007,
            mass_number=11,
            special_symbol=None
        ),
        Isotope(
            mass=12.0143521,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=12,
            special_symbol=None
        ),
        Isotope(
            mass=13.0177802,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=13,
            special_symbol=None
        ),
        Isotope(
            mass=14.025404,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.031103,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=16.039810,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=17.04699,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=18.05617,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.06373,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        )
    ]
)
Elements['B'] = B


C = Element(
    symbol="C",
    atomic_number=6,
    atomic_weight=12.0107,
    atomic_weight_uncertainty=0.0008,
    vdw_radius=170. * Picometers,
    ionization_energies=[1086.5 * KilojoulesPerMole, 2352.6 * KilojoulesPerMole, 4620.5 * KilojoulesPerMole, 6222.7 * KilojoulesPerMole, 37831. * KilojoulesPerMole, 47277. * KilojoulesPerMole],
    electronegativity=2.55,
    isotopes=[
        Isotope(
            mass=8.037675,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=8,
            special_symbol=None
        ),
        Isotope(
            mass=9.0310367,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=9,
            special_symbol=None
        ),
        Isotope(
            mass=10.0168532,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=10,
            special_symbol=None
        ),
        Isotope(
            mass=11.0114336,
            mass_uncertainty=0.0000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=11,
            special_symbol=None
        ),
        Isotope(
            mass=12.0000000,
            mass_uncertainty=0.0000000,
            abundance=0.9893,
            abundance_uncertainty=0.0008,
            mass_number=12,
            special_symbol=None
        ),
        Isotope(
            mass=13.0033548378,
            mass_uncertainty=0.0000000010,
            abundance=0.0107,
            abundance_uncertainty=0.0008,
            mass_number=13,
            special_symbol=None
        ),
        Isotope(
            mass=14.003241989,
            mass_uncertainty=0.000000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.0105993,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=16.014701,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=17.022586,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=18.026760,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.03481,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=20.04032,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=21.04934,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=22.05720,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        )
    ]
)
Elements['C'] = C


N = Element(
    symbol="N",
    atomic_number=7,
    atomic_weight=14.0067,
    atomic_weight_uncertainty=0.0002,
    vdw_radius=155. * Picometers,
    ionization_energies=[1402.3 * KilojoulesPerMole, 2856. * KilojoulesPerMole, 4578.1 * KilojoulesPerMole, 7475. * KilojoulesPerMole, 9444.9 * KilojoulesPerMole, 53266.6 * KilojoulesPerMole, 64360. * KilojoulesPerMole],
    electronegativity=3.04,
    isotopes=[
        Isotope(
            mass=10.04165,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=10,
            special_symbol=None
        ),
        Isotope(
            mass=11.026090,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=11,
            special_symbol=None
        ),
        Isotope(
            mass=12.0186132,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=12,
            special_symbol=None
        ),
        Isotope(
            mass=13.00573861,
            mass_uncertainty=0.00000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=13,
            special_symbol=None
        ),
        Isotope(
            mass=14.0030740048,
            mass_uncertainty=0.0000000006,
            abundance=0.99636,
            abundance_uncertainty=0.00020,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.0001088982,
            mass_uncertainty=0.0000000007,
            abundance=0.00364,
            abundance_uncertainty=0.00020,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=16.0061017,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=17.008450,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=18.014079,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.017029,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=20.023370,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=21.02711,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=22.03439,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=23.04122,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=24.05104,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=25.06066,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        )
    ]
)
Elements['N'] = N


O = Element(
    symbol="O",
    atomic_number=8,
    atomic_weight=15.9994,
    atomic_weight_uncertainty=0.0003,
    vdw_radius=152. * Picometers,
    ionization_energies=[1313.9 * KilojoulesPerMole, 3388.3 * KilojoulesPerMole, 5300.5 * KilojoulesPerMole, 7469.2 * KilojoulesPerMole, 10989.5 * KilojoulesPerMole, 13326.5 * KilojoulesPerMole, 71330. * KilojoulesPerMole, 84078. * KilojoulesPerMole],
    electronegativity=3.44,
    isotopes=[
        Isotope(
            mass=12.034405,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=12,
            special_symbol=None
        ),
        Isotope(
            mass=13.024812,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=13,
            special_symbol=None
        ),
        Isotope(
            mass=14.00859625,
            mass_uncertainty=0.00000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.0030656,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=15.99491461956,
            mass_uncertainty=0.00000000016,
            abundance=0.99757,
            abundance_uncertainty=0.00016,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=16.99913170,
            mass_uncertainty=0.00000012,
            abundance=0.00038,
            abundance_uncertainty=0.00001,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=17.9991610,
            mass_uncertainty=0.0000007,
            abundance=0.00205,
            abundance_uncertainty=0.00014,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.003580,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=20.0040767,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=21.008656,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=22.009970,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=23.01569,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=24.02047,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=25.02946,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=26.03834,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=27.04826,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=28.05781,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        )
    ]
)
Elements['O'] = O


F = Element(
    symbol="F",
    atomic_number=9,
    atomic_weight=18.9984032,
    atomic_weight_uncertainty=0.0000005,
    vdw_radius=147. * Picometers,
    ionization_energies=[1681. * KilojoulesPerMole, 3374.2 * KilojoulesPerMole, 6050.4 * KilojoulesPerMole, 8407.7 * KilojoulesPerMole, 11022.7 * KilojoulesPerMole, 15164.1 * KilojoulesPerMole, 17868. * KilojoulesPerMole, 92038.1 * KilojoulesPerMole, 106434.3 * KilojoulesPerMole],
    electronegativity=3.98,
    isotopes=[
        Isotope(
            mass=14.03506,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=14,
            special_symbol=None
        ),
        Isotope(
            mass=15.01801,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=15,
            special_symbol=None
        ),
        Isotope(
            mass=16.011466,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=17.00209524,
            mass_uncertainty=0.00000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=18.0009380,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=18.99840322,
            mass_uncertainty=0.00000007,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=19.99998132,
            mass_uncertainty=0.00000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=20.9999490,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=22.002999,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=23.003570,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=24.008120,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=25.01210,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=26.01962,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=27.02676,
            mass_uncertainty=0.00040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=28.03567,
            mass_uncertainty=0.00055,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=29.04326,
            mass_uncertainty=0.00062,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=30.05250,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=31.06043,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        )
    ]
)
Elements['F'] = F


Ne = Element(
    symbol="Ne",
    atomic_number=10,
    atomic_weight=20.1797,
    atomic_weight_uncertainty=0.0006,
    vdw_radius=154. * Picometers,
    ionization_energies=[2080.7 * KilojoulesPerMole, 3952.3 * KilojoulesPerMole, 6122. * KilojoulesPerMole, 9371. * KilojoulesPerMole, 12177. * KilojoulesPerMole, 15238. * KilojoulesPerMole, 19999. * KilojoulesPerMole, 23069.5 * KilojoulesPerMole, 115379.5 * KilojoulesPerMole, 131432. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=16.025761,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=16,
            special_symbol=None
        ),
        Isotope(
            mass=17.017672,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=17,
            special_symbol=None
        ),
        Isotope(
            mass=18.0057082,
            mass_uncertainty=0.0000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.0018802,
            mass_uncertainty=0.0000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=19.9924401754,
            mass_uncertainty=0.0000000019,
            abundance=0.9048,
            abundance_uncertainty=0.0003,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=20.99384668,
            mass_uncertainty=0.00000004,
            abundance=0.0027,
            abundance_uncertainty=0.0001,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=21.991385114,
            mass_uncertainty=0.000000019,
            abundance=0.0925,
            abundance_uncertainty=0.0003,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=22.99446690,
            mass_uncertainty=0.00000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=23.9936108,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=24.997737,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=26.000461,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=27.00759,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=28.01207,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=29.01939,
            mass_uncertainty=0.00029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=30.02480,
            mass_uncertainty=0.00061,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=31.03311,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=32.04002,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=33.04938,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=34.05703,
            mass_uncertainty=0.00087,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        )
    ]
)
Elements['Ne'] = Ne


Na = Element(
    symbol="Na",
    atomic_number=11,
    atomic_weight=22.98976928,
    atomic_weight_uncertainty=0.00000002,
    vdw_radius=227. * Picometers,
    ionization_energies=[495.8 * KilojoulesPerMole, 4562. * KilojoulesPerMole, 6910.3 * KilojoulesPerMole, 9543. * KilojoulesPerMole, 13354. * KilojoulesPerMole, 16613. * KilojoulesPerMole, 20117. * KilojoulesPerMole, 25496. * KilojoulesPerMole, 28932. * KilojoulesPerMole, 141362. * KilojoulesPerMole],
    electronegativity=0.93,
    isotopes=[
        Isotope(
            mass=18.025970,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=18,
            special_symbol=None
        ),
        Isotope(
            mass=19.013877,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=20.007351,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=20.9976552,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=21.9944364,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=22.9897692809,
            mass_uncertainty=0.0000000029,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=23.99096278,
            mass_uncertainty=0.00000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=24.9899540,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=25.992633,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=26.994077,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=27.998938,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=29.002861,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=30.008976,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=31.01359,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=32.02047,
            mass_uncertainty=0.00038,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=33.02672,
            mass_uncertainty=0.00094,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=34.03517,
            mass_uncertainty=0.00096,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=35.04249,
            mass_uncertainty=0.00102,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=36.05148,
            mass_uncertainty=0.00102,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=37.05934,
            mass_uncertainty=0.00103,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        )
    ]
)
Elements['Na'] = Na


Mg = Element(
    symbol="Mg",
    atomic_number=12,
    atomic_weight=24.3050,
    atomic_weight_uncertainty=0.0006,
    vdw_radius=173. * Picometers,
    ionization_energies=[737.7 * KilojoulesPerMole, 1450.7 * KilojoulesPerMole, 7732.7 * KilojoulesPerMole, 10542.5 * KilojoulesPerMole, 13630. * KilojoulesPerMole, 18020. * KilojoulesPerMole, 21711. * KilojoulesPerMole, 25661. * KilojoulesPerMole, 31653. * KilojoulesPerMole, 35458. * KilojoulesPerMole],
    electronegativity=1.31,
    isotopes=[
        Isotope(
            mass=19.03547,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=19,
            special_symbol=None
        ),
        Isotope(
            mass=20.018863,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=20,
            special_symbol=None
        ),
        Isotope(
            mass=21.011713,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=21.9995738,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=22.9941237,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=23.985041700,
            mass_uncertainty=0.000000014,
            abundance=0.7899,
            abundance_uncertainty=0.0004,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=24.98583692,
            mass_uncertainty=0.00000003,
            abundance=0.1000,
            abundance_uncertainty=0.0001,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=25.982592929,
            mass_uncertainty=0.000000030,
            abundance=0.1101,
            abundance_uncertainty=0.0003,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=26.98434059,
            mass_uncertainty=0.00000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=27.9838768,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=28.988600,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=29.990434,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.996546,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.998975,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=33.005254,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=34.00946,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=35.01734,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=36.02300,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=37.03140,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=38.03757,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=39.04677,
            mass_uncertainty=0.00055,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=40.05393,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        )
    ]
)
Elements['Mg'] = Mg


Al = Element(
    symbol="Al",
    atomic_number=13,
    atomic_weight=26.9815386,
    atomic_weight_uncertainty=0.0000008,
    ionization_energies=[577.5 * KilojoulesPerMole, 1816.7 * KilojoulesPerMole, 2744.8 * KilojoulesPerMole, 11577. * KilojoulesPerMole, 14842. * KilojoulesPerMole, 18379. * KilojoulesPerMole, 23326. * KilojoulesPerMole, 27465. * KilojoulesPerMole, 31853. * KilojoulesPerMole, 38473. * KilojoulesPerMole],
    electronegativity=1.61,
    isotopes=[
        Isotope(
            mass=21.02804,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=21,
            special_symbol=None
        ),
        Isotope(
            mass=22.01952,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=23.007267,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=23.9999389,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=24.9904281,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=25.98689169,
            mass_uncertainty=0.00000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=26.98153863,
            mass_uncertainty=0.00000012,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=27.98191031,
            mass_uncertainty=0.00000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=28.9804450,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=29.982960,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.983947,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.988120,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.990840,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.99685,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.99986,
            mass_uncertainty=0.00019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=36.00621,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=37.01068,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=38.01723,
            mass_uncertainty=0.00078,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=39.02297,
            mass_uncertainty=0.00158,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=40.03145,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=41.03833,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=42.04689,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        )
    ]
)
Elements['Al'] = Al


Si = Element(
    symbol="Si",
    atomic_number=14,
    atomic_weight=28.0855,
    atomic_weight_uncertainty=0.0003,
    vdw_radius=210. * Picometers,
    ionization_energies=[786.5 * KilojoulesPerMole, 1577.1 * KilojoulesPerMole, 3231.6 * KilojoulesPerMole, 4355.5 * KilojoulesPerMole, 16091. * KilojoulesPerMole, 19805. * KilojoulesPerMole, 23780. * KilojoulesPerMole, 29287. * KilojoulesPerMole, 33878. * KilojoulesPerMole, 38726. * KilojoulesPerMole],
    electronegativity=1.9,
    isotopes=[
        Isotope(
            mass=22.03453,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=22,
            special_symbol=None
        ),
        Isotope(
            mass=23.02552,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=23,
            special_symbol=None
        ),
        Isotope(
            mass=24.011546,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=25.004106,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=25.992330,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=26.98670491,
            mass_uncertainty=0.00000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=27.9769265325,
            mass_uncertainty=0.0000000019,
            abundance=0.92223,
            abundance_uncertainty=0.00019,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=28.976494700,
            mass_uncertainty=0.000000022,
            abundance=0.04685,
            abundance_uncertainty=0.00008,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=29.97377017,
            mass_uncertainty=0.00000003,
            abundance=0.03092,
            abundance_uncertainty=0.00011,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.97536323,
            mass_uncertainty=0.00000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.97414808,
            mass_uncertainty=0.00000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.978000,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.978576,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.984580,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.98660,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.99294,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.99563,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=39.00207,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=40.00587,
            mass_uncertainty=0.00060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=41.01456,
            mass_uncertainty=0.00198,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=42.01979,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=43.02866,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=44.03526,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        )
    ]
)
Elements['Si'] = Si


P = Element(
    symbol="P",
    atomic_number=15,
    atomic_weight=30.973762,
    atomic_weight_uncertainty=0.000002,
    vdw_radius=180. * Picometers,
    ionization_energies=[1011.8 * KilojoulesPerMole, 1907. * KilojoulesPerMole, 2914.1 * KilojoulesPerMole, 4963.6 * KilojoulesPerMole, 6273.9 * KilojoulesPerMole, 21267. * KilojoulesPerMole, 25431. * KilojoulesPerMole, 29872. * KilojoulesPerMole, 35905. * KilojoulesPerMole, 40950. * KilojoulesPerMole],
    electronegativity=2.19,
    isotopes=[
        Isotope(
            mass=24.03435,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=24,
            special_symbol=None
        ),
        Isotope(
            mass=25.02026,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=25,
            special_symbol=None
        ),
        Isotope(
            mass=26.01178,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=26.999230,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=27.992315,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=28.9818006,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=29.9783138,
            mass_uncertainty=0.0000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.97376163,
            mass_uncertainty=0.00000020,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.97390727,
            mass_uncertainty=0.00000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.9717255,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.973636,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.9733141,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.978260,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.979610,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.98416,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.98618,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.99130,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.99434,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=42.00101,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=43.00619,
            mass_uncertainty=0.00104,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=44.01299,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=45.01922,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=46.02738,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        )
    ]
)
Elements['P'] = P


S = Element(
    symbol="S",
    atomic_number=16,
    atomic_weight=32.065,
    atomic_weight_uncertainty=0.005,
    vdw_radius=180. * Picometers,
    ionization_energies=[999.6 * KilojoulesPerMole, 2252. * KilojoulesPerMole, 3357. * KilojoulesPerMole, 4556. * KilojoulesPerMole, 7004.3 * KilojoulesPerMole, 8495.8 * KilojoulesPerMole, 27107. * KilojoulesPerMole, 31719. * KilojoulesPerMole, 36621. * KilojoulesPerMole, 43177. * KilojoulesPerMole],
    electronegativity=2.58,
    isotopes=[
        Isotope(
            mass=26.02788,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=26,
            special_symbol=None
        ),
        Isotope(
            mass=27.01883,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=27,
            special_symbol=None
        ),
        Isotope(
            mass=28.00437,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=28.996610,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=29.984903,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.9795547,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.97207100,
            mass_uncertainty=0.00000015,
            abundance=0.9499,
            abundance_uncertainty=0.0026,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.97145876,
            mass_uncertainty=0.00000015,
            abundance=0.0075,
            abundance_uncertainty=0.0002,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.96786690,
            mass_uncertainty=0.00000012,
            abundance=0.0425,
            abundance_uncertainty=0.0024,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.96903216,
            mass_uncertainty=0.00000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.96708076,
            mass_uncertainty=0.00000020,
            abundance=0.0001,
            abundance_uncertainty=0.0001,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.97112557,
            mass_uncertainty=0.00000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.971163,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.975130,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.97545,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.97958,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.98102,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.98715,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.99021,
            mass_uncertainty=0.00042,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.99651,
            mass_uncertainty=0.00187,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=46.00075,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=47.00859,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=48.01417,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=49.02362,
            mass_uncertainty=0.00102,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        )
    ]
)
Elements['S'] = S


Cl = Element(
    symbol="Cl",
    atomic_number=17,
    atomic_weight=35.453,
    atomic_weight_uncertainty=0.002,
    vdw_radius=175. * Picometers,
    ionization_energies=[1251.2 * KilojoulesPerMole, 2298. * KilojoulesPerMole, 3822. * KilojoulesPerMole, 5158.6 * KilojoulesPerMole, 6542. * KilojoulesPerMole, 9362. * KilojoulesPerMole, 11018. * KilojoulesPerMole, 33604. * KilojoulesPerMole, 38600. * KilojoulesPerMole, 43961. * KilojoulesPerMole],
    electronegativity=3.16,
    isotopes=[
        Isotope(
            mass=28.02851,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=28,
            special_symbol=None
        ),
        Isotope(
            mass=29.01411,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=29,
            special_symbol=None
        ),
        Isotope(
            mass=30.00477,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=30.992410,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.985690,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.9774519,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.97376282,
            mass_uncertainty=0.00000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.96885268,
            mass_uncertainty=0.00000004,
            abundance=0.7576,
            abundance_uncertainty=0.0010,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.96830698,
            mass_uncertainty=0.00000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.96590259,
            mass_uncertainty=0.00000005,
            abundance=0.2424,
            abundance_uncertainty=0.0010,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.96801043,
            mass_uncertainty=0.00000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.9680082,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.970420,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.970680,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.97325,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.97405,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.97828,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.98029,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.98421,
            mass_uncertainty=0.00077,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.98871,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.99495,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=49.00032,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=50.00784,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=51.01449,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        )
    ]
)
Elements['Cl'] = Cl


Ar = Element(
    symbol="Ar",
    atomic_number=18,
    atomic_weight=39.948,
    atomic_weight_uncertainty=0.001,
    vdw_radius=188. * Picometers,
    ionization_energies=[1520.6 * KilojoulesPerMole, 2665.8 * KilojoulesPerMole, 3931. * KilojoulesPerMole, 5771. * KilojoulesPerMole, 7238. * KilojoulesPerMole, 8781. * KilojoulesPerMole, 11995. * KilojoulesPerMole, 13842. * KilojoulesPerMole, 40760. * KilojoulesPerMole, 46186. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=30.02156,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=30,
            special_symbol=None
        ),
        Isotope(
            mass=31.01212,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=31,
            special_symbol=None
        ),
        Isotope(
            mass=31.9976380,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=32.9899257,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.9802712,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.9752576,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.967545106,
            mass_uncertainty=0.000000029,
            abundance=0.003365,
            abundance_uncertainty=0.000030,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.96677632,
            mass_uncertainty=0.00000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.9627324,
            mass_uncertainty=0.0000004,
            abundance=0.000632,
            abundance_uncertainty=0.000005,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.964313,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.9623831225,
            mass_uncertainty=0.0000000029,
            abundance=0.996003,
            abundance_uncertainty=0.000030,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.9645006,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.963046,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.965636,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.9649240,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.9680400,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.968090,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.97219,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.97454,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.98052,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.98443,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.99163,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.99678,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=53.00494,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        )
    ]
)
Elements['Ar'] = Ar


K = Element(
    symbol="K",
    atomic_number=19,
    atomic_weight=39.0983,
    atomic_weight_uncertainty=0.0001,
    vdw_radius=275. * Picometers,
    ionization_energies=[418.8 * KilojoulesPerMole, 3052. * KilojoulesPerMole, 4420. * KilojoulesPerMole, 5877. * KilojoulesPerMole, 7975. * KilojoulesPerMole, 9590. * KilojoulesPerMole, 11343. * KilojoulesPerMole, 14944. * KilojoulesPerMole, 16963.7 * KilojoulesPerMole, 48610. * KilojoulesPerMole],
    electronegativity=0.82,
    isotopes=[
        Isotope(
            mass=32.02192,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=32,
            special_symbol=None
        ),
        Isotope(
            mass=33.00726,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=33,
            special_symbol=None
        ),
        Isotope(
            mass=33.99841,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=34.988010,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.981292,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.97337589,
            mass_uncertainty=0.00000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.9690812,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.96370668,
            mass_uncertainty=0.00000020,
            abundance=0.932581,
            abundance_uncertainty=0.000044,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.96399848,
            mass_uncertainty=0.00000021,
            abundance=0.000117,
            abundance_uncertainty=0.000001,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.96182576,
            mass_uncertainty=0.00000021,
            abundance=0.067302,
            abundance_uncertainty=0.000044,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.96240281,
            mass_uncertainty=0.00000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.960716,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.961560,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.960699,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.961977,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.961678,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.965514,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.967450,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.97278,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.97638,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.98261,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.98712,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.99420,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.99971,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        )
    ]
)
Elements['K'] = K


Ca = Element(
    symbol="Ca",
    atomic_number=20,
    atomic_weight=40.078,
    atomic_weight_uncertainty=0.004,
    ionization_energies=[589.8 * KilojoulesPerMole, 1145.4 * KilojoulesPerMole, 4912.4 * KilojoulesPerMole, 6491. * KilojoulesPerMole, 8153. * KilojoulesPerMole, 10496. * KilojoulesPerMole, 12270. * KilojoulesPerMole, 14206. * KilojoulesPerMole, 18191. * KilojoulesPerMole, 20385. * KilojoulesPerMole, 57110. * KilojoulesPerMole],
    electronegativity=1.,
    isotopes=[
        Isotope(
            mass=34.01412,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=34,
            special_symbol=None
        ),
        Isotope(
            mass=35.00494,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=35,
            special_symbol=None
        ),
        Isotope(
            mass=35.993090,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=36.985870,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.976318,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.9707197,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.96259098,
            mass_uncertainty=0.00000022,
            abundance=0.96941,
            abundance_uncertainty=0.00156,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.96227806,
            mass_uncertainty=0.00000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.95861801,
            mass_uncertainty=0.00000027,
            abundance=0.00647,
            abundance_uncertainty=0.00023,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.9587666,
            mass_uncertainty=0.0000003,
            abundance=0.00135,
            abundance_uncertainty=0.00010,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.9554818,
            mass_uncertainty=0.0000004,
            abundance=0.02086,
            abundance_uncertainty=0.00110,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.9561866,
            mass_uncertainty=0.0000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.9536926,
            mass_uncertainty=0.0000024,
            abundance=0.00004,
            abundance_uncertainty=0.00003,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.9545460,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.952534,
            mass_uncertainty=0.000004,
            abundance=0.00187,
            abundance_uncertainty=0.00021,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.955674,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.957519,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.96150,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.96510,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.97005,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.97435,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.98055,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.98557,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.99236,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        )
    ]
)
Elements['Ca'] = Ca


Sc = Element(
    symbol="Sc",
    atomic_number=21,
    atomic_weight=44.955912,
    atomic_weight_uncertainty=0.000006,
    ionization_energies=[633.1 * KilojoulesPerMole, 1235. * KilojoulesPerMole, 2388.6 * KilojoulesPerMole, 7090.6 * KilojoulesPerMole, 8843. * KilojoulesPerMole, 10679. * KilojoulesPerMole, 13310. * KilojoulesPerMole, 15250. * KilojoulesPerMole, 17370. * KilojoulesPerMole, 21726. * KilojoulesPerMole, 24102. * KilojoulesPerMole, 66320. * KilojoulesPerMole, 73010. * KilojoulesPerMole, 80160. * KilojoulesPerMole, 89490. * KilojoulesPerMole, 97400. * KilojoulesPerMole, 105600. * KilojoulesPerMole, 117000. * KilojoulesPerMole, 124270. * KilojoulesPerMole, 547530. * KilojoulesPerMole, 582163. * KilojoulesPerMole],
    electronegativity=1.36,
    isotopes=[
        Isotope(
            mass=36.01492,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=36,
            special_symbol=None
        ),
        Isotope(
            mass=37.00305,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=37,
            special_symbol=None
        ),
        Isotope(
            mass=37.99470,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=38.984790,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.977967,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.96925113,
            mass_uncertainty=0.00000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.96551643,
            mass_uncertainty=0.00000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.9611507,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.9594028,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.9559119,
            mass_uncertainty=0.0000009,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.9551719,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.9524075,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.952231,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.950024,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.952188,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.953603,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.95668,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.95961,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.96326,
            mass_uncertainty=0.00040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.96824,
            mass_uncertainty=0.00079,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.97287,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.97779,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.98371,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.98922,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.99571,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        )
    ]
)
Elements['Sc'] = Sc


Ti = Element(
    symbol="Ti",
    atomic_number=22,
    atomic_weight=47.867,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[658.8 * KilojoulesPerMole, 1309.8 * KilojoulesPerMole, 2652.5 * KilojoulesPerMole, 4174.6 * KilojoulesPerMole, 9581. * KilojoulesPerMole, 11533. * KilojoulesPerMole, 13590. * KilojoulesPerMole, 16440. * KilojoulesPerMole, 18530. * KilojoulesPerMole, 20833. * KilojoulesPerMole, 25575. * KilojoulesPerMole, 28125. * KilojoulesPerMole, 76015. * KilojoulesPerMole, 83280. * KilojoulesPerMole, 90880. * KilojoulesPerMole, 100700. * KilojoulesPerMole, 109100. * KilojoulesPerMole, 117800. * KilojoulesPerMole, 129900. * KilojoulesPerMole, 137530. * KilojoulesPerMole, 602930. * KilojoulesPerMole],
    electronegativity=1.54,
    isotopes=[
        Isotope(
            mass=38.00977,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=38,
            special_symbol=None
        ),
        Isotope(
            mass=39.00161,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=39,
            special_symbol=None
        ),
        Isotope(
            mass=39.99050,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.98315,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.973031,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.968522,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.9596901,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.9581256,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.9526316,
            mass_uncertainty=0.0000009,
            abundance=0.0825,
            abundance_uncertainty=0.0003,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.9517631,
            mass_uncertainty=0.0000009,
            abundance=0.0744,
            abundance_uncertainty=0.0002,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.9479463,
            mass_uncertainty=0.0000009,
            abundance=0.7372,
            abundance_uncertainty=0.0003,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.9478700,
            mass_uncertainty=0.0000009,
            abundance=0.0541,
            abundance_uncertainty=0.0002,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.9447912,
            mass_uncertainty=0.0000009,
            abundance=0.0518,
            abundance_uncertainty=0.0002,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.9466150,
            mass_uncertainty=0.0000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.946897,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.94973,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.95105,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.95527,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.95820,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.96399,
            mass_uncertainty=0.00049,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.96697,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.97293,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.97676,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.98320,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.98749,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.99442,
            mass_uncertainty=0.00107,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        )
    ]
)
Elements['Ti'] = Ti


V = Element(
    symbol="V",
    atomic_number=23,
    atomic_weight=50.9415,
    atomic_weight_uncertainty=0.0001,
    ionization_energies=[650.9 * KilojoulesPerMole, 1414. * KilojoulesPerMole, 2830. * KilojoulesPerMole, 4507. * KilojoulesPerMole, 6298.7 * KilojoulesPerMole, 12363. * KilojoulesPerMole, 14530. * KilojoulesPerMole, 16730. * KilojoulesPerMole, 19860. * KilojoulesPerMole, 22240. * KilojoulesPerMole, 24670. * KilojoulesPerMole, 29730. * KilojoulesPerMole, 32446. * KilojoulesPerMole, 86450. * KilojoulesPerMole, 94170. * KilojoulesPerMole, 102300. * KilojoulesPerMole, 112700. * KilojoulesPerMole, 121600. * KilojoulesPerMole, 130700. * KilojoulesPerMole, 143400. * KilojoulesPerMole, 151440. * KilojoulesPerMole],
    electronegativity=1.63,
    isotopes=[
        Isotope(
            mass=40.01109,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=40,
            special_symbol=None
        ),
        Isotope(
            mass=40.99978,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=41,
            special_symbol=None
        ),
        Isotope(
            mass=41.99123,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.98065,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.97411,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.965776,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.9602005,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.9549089,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.9522537,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.9485161,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.9471585,
            mass_uncertainty=0.0000011,
            abundance=0.00250,
            abundance_uncertainty=0.00004,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.9439595,
            mass_uncertainty=0.0000011,
            abundance=0.99750,
            abundance_uncertainty=0.00004,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.9447755,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.944338,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.946440,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.94723,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.95053,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.95256,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.95683,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.96021,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.96503,
            mass_uncertainty=0.00051,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.96848,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.97378,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.97755,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.98347,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.98792,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        )
    ]
)
Elements['V'] = V


Cr = Element(
    symbol="Cr",
    atomic_number=24,
    atomic_weight=51.9961,
    atomic_weight_uncertainty=0.0006,
    ionization_energies=[652.9 * KilojoulesPerMole, 1590.6 * KilojoulesPerMole, 2987. * KilojoulesPerMole, 4743. * KilojoulesPerMole, 6702. * KilojoulesPerMole, 8744.9 * KilojoulesPerMole, 15455. * KilojoulesPerMole, 17820. * KilojoulesPerMole, 20190. * KilojoulesPerMole, 23580. * KilojoulesPerMole, 26130. * KilojoulesPerMole, 28750. * KilojoulesPerMole, 34230. * KilojoulesPerMole, 37066. * KilojoulesPerMole, 97510. * KilojoulesPerMole, 105800. * KilojoulesPerMole, 114300. * KilojoulesPerMole, 125300. * KilojoulesPerMole, 134700. * KilojoulesPerMole, 144300. * KilojoulesPerMole, 157700. * KilojoulesPerMole],
    electronegativity=1.66,
    isotopes=[
        Isotope(
            mass=42.00643,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=42,
            special_symbol=None
        ),
        Isotope(
            mass=42.99771,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=43,
            special_symbol=None
        ),
        Isotope(
            mass=43.985550,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.97964,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.968359,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.962900,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.954032,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.9513357,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.9460442,
            mass_uncertainty=0.0000011,
            abundance=0.04345,
            abundance_uncertainty=0.00013,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.9447674,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.9405075,
            mass_uncertainty=0.0000008,
            abundance=0.83789,
            abundance_uncertainty=0.00018,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.9406494,
            mass_uncertainty=0.0000008,
            abundance=0.09501,
            abundance_uncertainty=0.00017,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.9388804,
            mass_uncertainty=0.0000008,
            abundance=0.02365,
            abundance_uncertainty=0.00007,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.9408397,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.9406531,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.9436130,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.94435,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.94859,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.95008,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.95472,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.95661,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.96186,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.96441,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.97016,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.97338,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.97955,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        )
    ]
)
Elements['Cr'] = Cr


Mn = Element(
    symbol="Mn",
    atomic_number=25,
    atomic_weight=54.938045,
    atomic_weight_uncertainty=0.000005,
    ionization_energies=[717.3 * KilojoulesPerMole, 1509. * KilojoulesPerMole, 3248. * KilojoulesPerMole, 4940. * KilojoulesPerMole, 6990. * KilojoulesPerMole, 9220. * KilojoulesPerMole, 11500. * KilojoulesPerMole, 18770. * KilojoulesPerMole, 21400. * KilojoulesPerMole, 23960. * KilojoulesPerMole, 27590. * KilojoulesPerMole, 30330. * KilojoulesPerMole, 33150. * KilojoulesPerMole, 38880. * KilojoulesPerMole, 41987. * KilojoulesPerMole, 109480. * KilojoulesPerMole, 118100. * KilojoulesPerMole, 127100. * KilojoulesPerMole, 138600. * KilojoulesPerMole, 148500. * KilojoulesPerMole, 158600. * KilojoulesPerMole],
    electronegativity=1.55,
    isotopes=[
        Isotope(
            mass=44.00687,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=44,
            special_symbol=None
        ),
        Isotope(
            mass=44.99451,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=45.98672,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.97610,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.96852,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.959618,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.9542382,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.9482108,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.9455655,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.9412901,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.9403589,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.9380451,
            mass_uncertainty=0.0000007,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.9389049,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.9382854,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.939980,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.940440,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.942910,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.94465,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.94843,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.95024,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.95425,
            mass_uncertainty=0.00029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.95634,
            mass_uncertainty=0.00058,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.96108,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.96414,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.96930,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.97284,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        )
    ]
)
Elements['Mn'] = Mn


Fe = Element(
    symbol="Fe",
    atomic_number=26,
    atomic_weight=55.845,
    atomic_weight_uncertainty=0.002,
    ionization_energies=[762.5 * KilojoulesPerMole, 1561.9 * KilojoulesPerMole, 2957. * KilojoulesPerMole, 5290. * KilojoulesPerMole, 7240. * KilojoulesPerMole, 9560. * KilojoulesPerMole, 12060. * KilojoulesPerMole, 14580. * KilojoulesPerMole, 22540. * KilojoulesPerMole, 25290. * KilojoulesPerMole, 28000. * KilojoulesPerMole, 31920. * KilojoulesPerMole, 34830. * KilojoulesPerMole, 37840. * KilojoulesPerMole, 44100. * KilojoulesPerMole, 47206. * KilojoulesPerMole, 122200. * KilojoulesPerMole, 131000. * KilojoulesPerMole, 140500. * KilojoulesPerMole, 152600. * KilojoulesPerMole, 163000. * KilojoulesPerMole],
    electronegativity=1.83,
    isotopes=[
        Isotope(
            mass=45.01458,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=45,
            special_symbol=None
        ),
        Isotope(
            mass=46.00081,
            mass_uncertainty=0.00038,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=46,
            special_symbol=None
        ),
        Isotope(
            mass=46.99289,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=47.980500,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.97361,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.962990,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.956820,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.948114,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.9453079,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.9396105,
            mass_uncertainty=0.0000007,
            abundance=0.05845,
            abundance_uncertainty=0.00035,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.9382934,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.9349375,
            mass_uncertainty=0.0000007,
            abundance=0.91754,
            abundance_uncertainty=0.00036,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.9353940,
            mass_uncertainty=0.0000007,
            abundance=0.02119,
            abundance_uncertainty=0.00010,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.9332756,
            mass_uncertainty=0.0000008,
            abundance=0.00282,
            abundance_uncertainty=0.00004,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.9348755,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.934072,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.936745,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.936767,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.94037,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.94120,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.94538,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.94678,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.95095,
            mass_uncertainty=0.00045,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.95370,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.95878,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.96146,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.96672,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.96962,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        )
    ]
)
Elements['Fe'] = Fe


Co = Element(
    symbol="Co",
    atomic_number=27,
    atomic_weight=58.933195,
    atomic_weight_uncertainty=0.000005,
    ionization_energies=[760.4 * KilojoulesPerMole, 1648. * KilojoulesPerMole, 3232. * KilojoulesPerMole, 4950. * KilojoulesPerMole, 7670. * KilojoulesPerMole, 9840. * KilojoulesPerMole, 12440. * KilojoulesPerMole, 15230. * KilojoulesPerMole, 17959. * KilojoulesPerMole, 26570. * KilojoulesPerMole, 29400. * KilojoulesPerMole, 32400. * KilojoulesPerMole, 36600. * KilojoulesPerMole, 39700. * KilojoulesPerMole, 42800. * KilojoulesPerMole, 49396. * KilojoulesPerMole, 52737. * KilojoulesPerMole, 134810. * KilojoulesPerMole, 145170. * KilojoulesPerMole, 154700. * KilojoulesPerMole, 167400. * KilojoulesPerMole],
    electronegativity=1.88,
    isotopes=[
        Isotope(
            mass=47.01149,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=47,
            special_symbol=None
        ),
        Isotope(
            mass=48.00176,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=48.98972,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.98154,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.97072,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.963590,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.954219,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.9484596,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.9419990,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.9398393,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.9362914,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.9357528,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.9331950,
            mass_uncertainty=0.0000007,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.9338171,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.9324758,
            mass_uncertainty=0.0000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.934051,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.933612,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.935810,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.936478,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.93976,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.94089,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.94487,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.94632,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.95100,
            mass_uncertainty=0.00090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.95290,
            mass_uncertainty=0.00090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.95781,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.96024,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.96538,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.96833,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        )
    ]
)
Elements['Co'] = Co


Ni = Element(
    symbol="Ni",
    atomic_number=28,
    atomic_weight=58.6934,
    atomic_weight_uncertainty=0.0004,
    vdw_radius=163. * Picometers,
    ionization_energies=[737.1 * KilojoulesPerMole, 1753. * KilojoulesPerMole, 3395. * KilojoulesPerMole, 5300. * KilojoulesPerMole, 7339. * KilojoulesPerMole, 10400. * KilojoulesPerMole, 12800. * KilojoulesPerMole, 15600. * KilojoulesPerMole, 18600. * KilojoulesPerMole, 21670. * KilojoulesPerMole, 30970. * KilojoulesPerMole, 34000. * KilojoulesPerMole, 37100. * KilojoulesPerMole, 41500. * KilojoulesPerMole, 44800. * KilojoulesPerMole, 48100. * KilojoulesPerMole, 55101. * KilojoulesPerMole, 58570. * KilojoulesPerMole, 148700. * KilojoulesPerMole, 159000. * KilojoulesPerMole, 169400. * KilojoulesPerMole],
    electronegativity=1.91,
    isotopes=[
        Isotope(
            mass=48.01975,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=48,
            special_symbol=None
        ),
        Isotope(
            mass=49.00966,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=49,
            special_symbol=None
        ),
        Isotope(
            mass=49.99593,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=50,
            special_symbol=None
        ),
        Isotope(
            mass=50.98772,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=51,
            special_symbol=None
        ),
        Isotope(
            mass=51.975680,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.96847,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.957910,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.951330,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.942132,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.9397935,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.9353429,
            mass_uncertainty=0.0000007,
            abundance=0.680769,
            abundance_uncertainty=0.000089,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.9343467,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.9307864,
            mass_uncertainty=0.0000007,
            abundance=0.262231,
            abundance_uncertainty=0.000077,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.9310560,
            mass_uncertainty=0.0000007,
            abundance=0.011399,
            abundance_uncertainty=0.000006,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.9283451,
            mass_uncertainty=0.0000006,
            abundance=0.036345,
            abundance_uncertainty=0.000017,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.9296694,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.9279660,
            mass_uncertainty=0.0000007,
            abundance=0.009256,
            abundance_uncertainty=0.000009,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.9300843,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.9291393,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.931569,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.931869,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.935610,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.93650,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.94074,
            mass_uncertainty=0.00040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.94209,
            mass_uncertainty=0.00047,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.94647,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.94807,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.95287,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.95533,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.96055,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.96318,
            mass_uncertainty=0.00118,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        )
    ]
)
Elements['Ni'] = Ni


Cu = Element(
    symbol="Cu",
    atomic_number=29,
    atomic_weight=63.546,
    atomic_weight_uncertainty=0.003,
    vdw_radius=140. * Picometers,
    ionization_energies=[745.5 * KilojoulesPerMole, 1957.9 * KilojoulesPerMole, 3555. * KilojoulesPerMole, 5536. * KilojoulesPerMole, 7700. * KilojoulesPerMole, 9900. * KilojoulesPerMole, 13400. * KilojoulesPerMole, 16000. * KilojoulesPerMole, 19200. * KilojoulesPerMole, 22400. * KilojoulesPerMole, 25600. * KilojoulesPerMole, 35600. * KilojoulesPerMole, 38700. * KilojoulesPerMole, 42000. * KilojoulesPerMole, 46700. * KilojoulesPerMole, 50200. * KilojoulesPerMole, 53700. * KilojoulesPerMole, 61100. * KilojoulesPerMole, 64702. * KilojoulesPerMole, 163700. * KilojoulesPerMole, 174100. * KilojoulesPerMole],
    electronegativity=1.9,
    isotopes=[
        Isotope(
            mass=51.99718,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=52,
            special_symbol=None
        ),
        Isotope(
            mass=52.98555,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=53,
            special_symbol=None
        ),
        Isotope(
            mass=53.97671,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.96605,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.95856,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.949211,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.9445385,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.9394980,
            mass_uncertainty=0.0000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.9373650,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.9334578,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.932584,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.9295975,
            mass_uncertainty=0.0000006,
            abundance=0.6915,
            abundance_uncertainty=0.0015,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.9297642,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.9277895,
            mass_uncertainty=0.0000007,
            abundance=0.3085,
            abundance_uncertainty=0.0015,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.9288688,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.9277303,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.9296109,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.9294293,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.9323923,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.9326768,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.9358203,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.936675,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.939875,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.94190,
            mass_uncertainty=0.00105,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.945275,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.94785,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.95196,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.95456,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.96087,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        )
    ]
)
Elements['Cu'] = Cu


Zn = Element(
    symbol="Zn",
    atomic_number=30,
    atomic_weight=65.38,
    atomic_weight_uncertainty=0.02,
    vdw_radius=139. * Picometers,
    ionization_energies=[906.4 * KilojoulesPerMole, 1733.3 * KilojoulesPerMole, 3833. * KilojoulesPerMole, 5731. * KilojoulesPerMole, 7970. * KilojoulesPerMole, 10400. * KilojoulesPerMole, 12900. * KilojoulesPerMole, 16800. * KilojoulesPerMole, 19600. * KilojoulesPerMole, 23000. * KilojoulesPerMole, 26400. * KilojoulesPerMole, 29990. * KilojoulesPerMole, 40490. * KilojoulesPerMole, 43800. * KilojoulesPerMole, 47300. * KilojoulesPerMole, 52300. * KilojoulesPerMole, 55900. * KilojoulesPerMole, 59700. * KilojoulesPerMole, 67300. * KilojoulesPerMole, 71200. * KilojoulesPerMole, 179100. * KilojoulesPerMole],
    electronegativity=1.65,
    isotopes=[
        Isotope(
            mass=53.99295,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=54,
            special_symbol=None
        ),
        Isotope(
            mass=54.98398,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=55,
            special_symbol=None
        ),
        Isotope(
            mass=55.97238,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.96479,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.954590,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.949260,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.941827,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.939511,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.934330,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.9332116,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.9291422,
            mass_uncertainty=0.0000007,
            abundance=0.48268,
            abundance_uncertainty=0.00321,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.9292410,
            mass_uncertainty=0.0000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.9260334,
            mass_uncertainty=0.0000010,
            abundance=0.27975,
            abundance_uncertainty=0.00077,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.9271273,
            mass_uncertainty=0.0000010,
            abundance=0.04102,
            abundance_uncertainty=0.00021,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.9248442,
            mass_uncertainty=0.0000010,
            abundance=0.19024,
            abundance_uncertainty=0.00123,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.9265503,
            mass_uncertainty=0.0000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.9253193,
            mass_uncertainty=0.0000021,
            abundance=0.00631,
            abundance_uncertainty=0.00009,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.927722,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.926858,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.929780,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.929460,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.932940,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.933290,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.93696,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.93844,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.94265,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.94434,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.95048,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.95442,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.96103,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        )
    ]
)
Elements['Zn'] = Zn


Ga = Element(
    symbol="Ga",
    atomic_number=31,
    atomic_weight=69.723,
    atomic_weight_uncertainty=0.001,
    vdw_radius=187. * Picometers,
    ionization_energies=[578.8 * KilojoulesPerMole, 1979.3 * KilojoulesPerMole, 2963. * KilojoulesPerMole, 6180. * KilojoulesPerMole],
    electronegativity=1.81,
    isotopes=[
        Isotope(
            mass=55.99491,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=56,
            special_symbol=None
        ),
        Isotope(
            mass=56.98293,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=57,
            special_symbol=None
        ),
        Isotope(
            mass=57.97425,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.96337,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.95706,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.949450,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.944175,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.9392942,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.9368387,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.9327348,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.931589,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.9282017,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.9279801,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.9255736,
            mass_uncertainty=0.0000013,
            abundance=0.60108,
            abundance_uncertainty=0.00009,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.9260220,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.9247013,
            mass_uncertainty=0.0000011,
            abundance=0.39892,
            abundance_uncertainty=0.00009,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.9263663,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.9251747,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.926946,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.9265002,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.9288276,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.9291543,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.9316082,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.93289,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.93652,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.93775,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.94299,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.94698,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.95265,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.95700,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.96312,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        )
    ]
)
Elements['Ga'] = Ga


Ge = Element(
    symbol="Ge",
    atomic_number=32,
    atomic_weight=72.64,
    atomic_weight_uncertainty=0.01,
    ionization_energies=[762. * KilojoulesPerMole, 1537.5 * KilojoulesPerMole, 3302.1 * KilojoulesPerMole, 4411. * KilojoulesPerMole, 9020. * KilojoulesPerMole],
    electronegativity=2.01,
    isotopes=[
        Isotope(
            mass=57.99101,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=58,
            special_symbol=None
        ),
        Isotope(
            mass=58.98175,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=59,
            special_symbol=None
        ),
        Isotope(
            mass=59.97019,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.96379,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.95465,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.94964,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.941650,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.93944,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.933840,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.932734,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.928094,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.9279645,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.9242474,
            mass_uncertainty=0.0000011,
            abundance=0.2038,
            abundance_uncertainty=0.0018,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.9249510,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.9220758,
            mass_uncertainty=0.0000018,
            abundance=0.2731,
            abundance_uncertainty=0.0026,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.9234589,
            mass_uncertainty=0.0000018,
            abundance=0.0776,
            abundance_uncertainty=0.0008,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.9211778,
            mass_uncertainty=0.0000018,
            abundance=0.3672,
            abundance_uncertainty=0.0015,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.9228589,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.9214026,
            mass_uncertainty=0.0000018,
            abundance=0.0783,
            abundance_uncertainty=0.0007,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.9235486,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.922853,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.92540,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.925370,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.92882,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.92955,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.93462,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.93747,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.94303,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.94649,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.95251,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.95691,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.96383,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        )
    ]
)
Elements['Ge'] = Ge


As = Element(
    symbol="As",
    atomic_number=33,
    atomic_weight=74.92160,
    atomic_weight_uncertainty=0.00002,
    vdw_radius=185. * Picometers,
    ionization_energies=[947. * KilojoulesPerMole, 1798. * KilojoulesPerMole, 2735. * KilojoulesPerMole, 4837. * KilojoulesPerMole, 6043. * KilojoulesPerMole, 12310. * KilojoulesPerMole],
    electronegativity=2.18,
    isotopes=[
        Isotope(
            mass=59.99313,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=60,
            special_symbol=None
        ),
        Isotope(
            mass=60.98062,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=61,
            special_symbol=None
        ),
        Isotope(
            mass=61.97320,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=62,
            special_symbol=None
        ),
        Isotope(
            mass=62.96369,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=63,
            special_symbol=None
        ),
        Isotope(
            mass=63.95757,
            mass_uncertainty=0.00038,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=64,
            special_symbol=None
        ),
        Isotope(
            mass=64.94956,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.94471,
            mass_uncertainty=0.00073,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.93919,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.936770,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.932270,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.930920,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.927112,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.926752,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.923825,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.9239287,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.9215965,
            mass_uncertainty=0.0000020,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.9223940,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.9206473,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.921827,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.920948,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.922534,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.922132,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.92450,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.92498,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.92906,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.93202,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.93650,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.93990,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.94494,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.94939,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.95550,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.96043,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.96680,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        )
    ]
)
Elements['As'] = As


Se = Element(
    symbol="Se",
    atomic_number=34,
    atomic_weight=78.96,
    atomic_weight_uncertainty=0.03,
    vdw_radius=190. * Picometers,
    ionization_energies=[941. * KilojoulesPerMole, 2045. * KilojoulesPerMole, 2973.7 * KilojoulesPerMole, 4144. * KilojoulesPerMole, 6590. * KilojoulesPerMole, 7880. * KilojoulesPerMole, 14990. * KilojoulesPerMole],
    electronegativity=2.55,
    isotopes=[
        Isotope(
            mass=64.96466,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=65,
            special_symbol=None
        ),
        Isotope(
            mass=65.95521,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=66,
            special_symbol=None
        ),
        Isotope(
            mass=66.95009,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.941800,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.939560,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.933390,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.932240,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.927112,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.926765,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.9224764,
            mass_uncertainty=0.0000018,
            abundance=0.0089,
            abundance_uncertainty=0.0004,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.9225234,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.9192136,
            mass_uncertainty=0.0000018,
            abundance=0.0937,
            abundance_uncertainty=0.0029,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.9199140,
            mass_uncertainty=0.0000018,
            abundance=0.0763,
            abundance_uncertainty=0.0016,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.9173091,
            mass_uncertainty=0.0000018,
            abundance=0.2377,
            abundance_uncertainty=0.0028,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.9184991,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.9165213,
            mass_uncertainty=0.0000021,
            abundance=0.4961,
            abundance_uncertainty=0.0041,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.9179925,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.9166994,
            mass_uncertainty=0.0000022,
            abundance=0.0873,
            abundance_uncertainty=0.0022,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.919118,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.918462,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.922250,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.924272,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.928520,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.931420,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.93645,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.93996,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.94596,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.94992,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.95629,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.96049,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        )
    ]
)
Elements['Se'] = Se


Br = Element(
    symbol="Br",
    atomic_number=35,
    atomic_weight=79.904,
    atomic_weight_uncertainty=0.001,
    vdw_radius=185. * Picometers,
    ionization_energies=[1139.9 * KilojoulesPerMole, 2103. * KilojoulesPerMole, 3470. * KilojoulesPerMole, 4560. * KilojoulesPerMole, 5760. * KilojoulesPerMole, 8550. * KilojoulesPerMole, 9940. * KilojoulesPerMole, 18600. * KilojoulesPerMole],
    electronegativity=2.96,
    isotopes=[
        Isotope(
            mass=66.96479,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=67,
            special_symbol=None
        ),
        Isotope(
            mass=67.95852,
            mass_uncertainty=0.00038,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=68,
            special_symbol=None
        ),
        Isotope(
            mass=68.95011,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.94479,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.93874,
            mass_uncertainty=0.00061,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.936640,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.931690,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.929891,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.925776,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.924541,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.921379,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.921146,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.9183371,
            mass_uncertainty=0.0000022,
            abundance=0.5069,
            abundance_uncertainty=0.0007,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.9185293,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.9162906,
            mass_uncertainty=0.0000021,
            abundance=0.4931,
            abundance_uncertainty=0.0007,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.9168041,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.915180,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.916479,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.915608,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.918798,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.920711,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.924070,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.926390,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.930630,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.933970,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.939260,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.94305,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.94868,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.95287,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.95853,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.96280,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        )
    ]
)
Elements['Br'] = Br


Kr = Element(
    symbol="Kr",
    atomic_number=36,
    atomic_weight=83.798,
    atomic_weight_uncertainty=0.002,
    vdw_radius=202. * Picometers,
    ionization_energies=[1350.8 * KilojoulesPerMole, 2350.4 * KilojoulesPerMole, 3565. * KilojoulesPerMole, 5070. * KilojoulesPerMole, 6240. * KilojoulesPerMole, 7570. * KilojoulesPerMole, 10710. * KilojoulesPerMole, 12138. * KilojoulesPerMole, 22274. * KilojoulesPerMole, 25880. * KilojoulesPerMole, 29700. * KilojoulesPerMole, 33800. * KilojoulesPerMole, 37700. * KilojoulesPerMole, 43100. * KilojoulesPerMole, 47500. * KilojoulesPerMole, 52200. * KilojoulesPerMole, 57100. * KilojoulesPerMole, 61800. * KilojoulesPerMole, 75800. * KilojoulesPerMole, 80400. * KilojoulesPerMole, 85300. * KilojoulesPerMole],
    electronegativity=3.,
    isotopes=[
        Isotope(
            mass=68.96518,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=69,
            special_symbol=None
        ),
        Isotope(
            mass=69.95526,
            mass_uncertainty=0.00041,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=70,
            special_symbol=None
        ),
        Isotope(
            mass=70.94963,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.942092,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.939289,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.9330844,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.930946,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.925910,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.9246700,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.9203648,
            mass_uncertainty=0.0000012,
            abundance=0.00355,
            abundance_uncertainty=0.00003,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.920082,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.9163790,
            mass_uncertainty=0.0000016,
            abundance=0.02286,
            abundance_uncertainty=0.00010,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.9165920,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.9134836,
            mass_uncertainty=0.0000019,
            abundance=0.11593,
            abundance_uncertainty=0.00031,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.914136,
            mass_uncertainty=0.000003,
            abundance=0.11500,
            abundance_uncertainty=0.00019,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.911507,
            mass_uncertainty=0.000003,
            abundance=0.56987,
            abundance_uncertainty=0.00015,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.9125273,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.91061073,
            mass_uncertainty=0.00000011,
            abundance=0.17279,
            abundance_uncertainty=0.00041,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.91335486,
            mass_uncertainty=0.00000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.914447,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.917630,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.919517,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.923450,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.926156,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.93127,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.93436,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.93984,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.94307,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.94856,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.95191,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.95760,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.96114,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        )
    ]
)
Elements['Kr'] = Kr


Rb = Element(
    symbol="Rb",
    atomic_number=37,
    atomic_weight=85.4678,
    atomic_weight_uncertainty=0.0003,
    ionization_energies=[403. * KilojoulesPerMole, 2633. * KilojoulesPerMole, 3860. * KilojoulesPerMole, 5080. * KilojoulesPerMole, 6850. * KilojoulesPerMole, 8140. * KilojoulesPerMole, 9570. * KilojoulesPerMole, 13120. * KilojoulesPerMole, 14500. * KilojoulesPerMole, 26740. * KilojoulesPerMole],
    electronegativity=0.82,
    isotopes=[
        Isotope(
            mass=70.96532,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=71,
            special_symbol=None
        ),
        Isotope(
            mass=71.95908,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=72,
            special_symbol=None
        ),
        Isotope(
            mass=72.95056,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.944265,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.938570,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.9350722,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.930408,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.928141,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.923989,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.922519,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.918996,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.9182086,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.915110,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.914385,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.911789738,
            mass_uncertainty=0.000000012,
            abundance=0.7217,
            abundance_uncertainty=0.0002,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.91116742,
            mass_uncertainty=0.00000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.909180527,
            mass_uncertainty=0.000000013,
            abundance=0.2783,
            abundance_uncertainty=0.0002,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.91131559,
            mass_uncertainty=0.00000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.912278,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.914802,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.916537,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.919729,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.922042,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.926405,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.929303,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.934270,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.937350,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.941790,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.94538,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.94987,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.95320,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.95887,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        )
    ]
)
Elements['Rb'] = Rb


Sr = Element(
    symbol="Sr",
    atomic_number=38,
    atomic_weight=87.62,
    atomic_weight_uncertainty=0.01,
    ionization_energies=[549.5 * KilojoulesPerMole, 1064.2 * KilojoulesPerMole, 4138. * KilojoulesPerMole, 5500. * KilojoulesPerMole, 6910. * KilojoulesPerMole, 8760. * KilojoulesPerMole, 10230. * KilojoulesPerMole, 11800. * KilojoulesPerMole, 15600. * KilojoulesPerMole, 17100. * KilojoulesPerMole],
    electronegativity=0.95,
    isotopes=[
        Isotope(
            mass=72.96597,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=73,
            special_symbol=None
        ),
        Isotope(
            mass=73.95631,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=74,
            special_symbol=None
        ),
        Isotope(
            mass=74.94995,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=75,
            special_symbol=None
        ),
        Isotope(
            mass=75.941770,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.937945,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.932180,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.929708,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.924521,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.923212,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.918402,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.917557,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.913425,
            mass_uncertainty=0.000003,
            abundance=0.0056,
            abundance_uncertainty=0.0001,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.912933,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.9092602,
            mass_uncertainty=0.0000012,
            abundance=0.0986,
            abundance_uncertainty=0.0001,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.9088771,
            mass_uncertainty=0.0000012,
            abundance=0.0700,
            abundance_uncertainty=0.0001,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.9056121,
            mass_uncertainty=0.0000012,
            abundance=0.8258,
            abundance_uncertainty=0.0001,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.9074507,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.907738,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.910203,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.911038,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.914026,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.915361,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.919359,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.921697,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.926153,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.928453,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.933240,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.93535,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.94052,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.94302,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.94895,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.95233,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.95858,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        )
    ]
)
Elements['Sr'] = Sr


Y = Element(
    symbol="Y",
    atomic_number=39,
    atomic_weight=88.90585,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[600. * KilojoulesPerMole, 1180. * KilojoulesPerMole, 1980. * KilojoulesPerMole, 5847. * KilojoulesPerMole, 7430. * KilojoulesPerMole, 8970. * KilojoulesPerMole, 11190. * KilojoulesPerMole, 12450. * KilojoulesPerMole, 14110. * KilojoulesPerMole, 18400. * KilojoulesPerMole],
    electronegativity=1.22,
    isotopes=[
        Isotope(
            mass=75.95845,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=76,
            special_symbol=None
        ),
        Isotope(
            mass=76.949650,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=77,
            special_symbol=None
        ),
        Isotope(
            mass=77.94361,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.93735,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.93428,
            mass_uncertainty=0.00019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.929130,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.92679,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.922350,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.92039,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.916433,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.914886,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.9108757,
            mass_uncertainty=0.0000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.9095011,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.9058483,
            mass_uncertainty=0.0000027,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.9071519,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.907305,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.908949,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.909583,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.911595,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.912821,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.915891,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.918134,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.922203,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.924636,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.927760,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.93031,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.933560,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.93673,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.94105,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.94487,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.94979,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.95414,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.95948,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        )
    ]
)
Elements['Y'] = Y


Zr = Element(
    symbol="Zr",
    atomic_number=40,
    atomic_weight=91.224,
    atomic_weight_uncertainty=0.002,
    ionization_energies=[640.1 * KilojoulesPerMole, 1270. * KilojoulesPerMole, 2218. * KilojoulesPerMole, 3313. * KilojoulesPerMole, 7752. * KilojoulesPerMole, 9500. * KilojoulesPerMole],
    electronegativity=1.33,
    isotopes=[
        Isotope(
            mass=77.95523,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=78,
            special_symbol=None
        ),
        Isotope(
            mass=78.94916,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=79,
            special_symbol=None
        ),
        Isotope(
            mass=79.94040,
            mass_uncertainty=0.00160,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=80,
            special_symbol=None
        ),
        Isotope(
            mass=80.93721,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.93109,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.92865,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.92325,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.92147,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.916470,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.914816,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.910227,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.908890,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.9047044,
            mass_uncertainty=0.0000025,
            abundance=0.5145,
            abundance_uncertainty=0.0040,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.9056458,
            mass_uncertainty=0.0000025,
            abundance=0.1122,
            abundance_uncertainty=0.0005,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.9050408,
            mass_uncertainty=0.0000025,
            abundance=0.1715,
            abundance_uncertainty=0.0008,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.9064760,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.9063152,
            mass_uncertainty=0.0000026,
            abundance=0.1738,
            abundance_uncertainty=0.0028,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.9080426,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.9082734,
            mass_uncertainty=0.0000030,
            abundance=0.0280,
            abundance_uncertainty=0.0009,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.9109531,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.912735,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.916512,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.917760,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.921140,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.922980,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.92660,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.92878,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.93305,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.93591,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.94075,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.94396,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.94924,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.95287,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        )
    ]
)
Elements['Zr'] = Zr


Nb = Element(
    symbol="Nb",
    atomic_number=41,
    atomic_weight=92.90638,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[652.1 * KilojoulesPerMole, 1380. * KilojoulesPerMole, 2416. * KilojoulesPerMole, 3700. * KilojoulesPerMole, 4877. * KilojoulesPerMole, 9847. * KilojoulesPerMole, 12100. * KilojoulesPerMole],
    electronegativity=1.6,
    isotopes=[
        Isotope(
            mass=80.94903,
            mass_uncertainty=0.00161,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=81,
            special_symbol=None
        ),
        Isotope(
            mass=81.94313,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=82,
            special_symbol=None
        ),
        Isotope(
            mass=82.93671,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.93357,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.92791,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.925040,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.920360,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.91833,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.913418,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.911265,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.906996,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.907194,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.9063781,
            mass_uncertainty=0.0000026,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.9072839,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.9068358,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.908101,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.9080986,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.910328,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.911618,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.914182,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.915252,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.918040,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.919140,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.92246,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.92394,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.92797,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.93031,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.93484,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.93763,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.94244,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.94565,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.95083,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.95470,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        )
    ]
)
Elements['Nb'] = Nb


Mo = Element(
    symbol="Mo",
    atomic_number=42,
    atomic_weight=95.96,
    atomic_weight_uncertainty=0.02,
    ionization_energies=[684.3 * KilojoulesPerMole, 1560. * KilojoulesPerMole, 2618. * KilojoulesPerMole, 4480. * KilojoulesPerMole, 5257. * KilojoulesPerMole, 6640.8 * KilojoulesPerMole, 12125. * KilojoulesPerMole, 13860. * KilojoulesPerMole, 15835. * KilojoulesPerMole, 17980. * KilojoulesPerMole, 20190. * KilojoulesPerMole, 22219. * KilojoulesPerMole, 26930. * KilojoulesPerMole, 29196. * KilojoulesPerMole, 52490. * KilojoulesPerMole, 55000. * KilojoulesPerMole, 61400. * KilojoulesPerMole, 67700. * KilojoulesPerMole, 74000. * KilojoulesPerMole, 80400. * KilojoulesPerMole, 87000. * KilojoulesPerMole],
    electronegativity=2.16,
    isotopes=[
        Isotope(
            mass=82.94874,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=83,
            special_symbol=None
        ),
        Isotope(
            mass=83.94009,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=84,
            special_symbol=None
        ),
        Isotope(
            mass=84.93655,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.93070,
            mass_uncertainty=0.00047,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.92733,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.921953,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.919480,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.913937,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.911750,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.906811,
            mass_uncertainty=0.000004,
            abundance=0.1477,
            abundance_uncertainty=0.0031,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.906813,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.9050883,
            mass_uncertainty=0.0000021,
            abundance=0.0923,
            abundance_uncertainty=0.0010,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.9058421,
            mass_uncertainty=0.0000021,
            abundance=0.1590,
            abundance_uncertainty=0.0009,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.9046795,
            mass_uncertainty=0.0000021,
            abundance=0.1668,
            abundance_uncertainty=0.0001,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.9060215,
            mass_uncertainty=0.0000021,
            abundance=0.0956,
            abundance_uncertainty=0.0005,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.9054082,
            mass_uncertainty=0.0000021,
            abundance=0.2419,
            abundance_uncertainty=0.0026,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.9077119,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.907477,
            mass_uncertainty=0.000006,
            abundance=0.0967,
            abundance_uncertainty=0.0020,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.910347,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.910297,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.913210,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.913760,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.916970,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.918137,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.92169,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.92345,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.92781,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.92973,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.93441,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.93684,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.94188,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.94492,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.95029,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        )
    ]
)
Elements['Mo'] = Mo


Tc = Element(
    symbol="Tc",
    atomic_number=43,
    atomic_weight=98,
    is_synthetic=True,
    ionization_energies=[702. * KilojoulesPerMole, 1470. * KilojoulesPerMole, 2850. * KilojoulesPerMole],
    electronegativity=1.9,
    isotopes=[
        Isotope(
            mass=84.94883,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=85,
            special_symbol=None
        ),
        Isotope(
            mass=85.94288,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=86,
            special_symbol=None
        ),
        Isotope(
            mass=86.93653,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.93268,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.92717,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.92356,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.91843,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.915260,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.910249,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.909657,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.907657,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.907871,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.906365,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.907216,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.9062547,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.9076578,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.907315,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.909215,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.909181,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.911450,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.911660,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.914358,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.91508,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.91846,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.91998,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.923820,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.92569,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.92915,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.93159,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.93588,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.93869,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.94337,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.94648,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.95148,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        )
    ]
)
Elements['Tc'] = Tc


Ru = Element(
    symbol="Ru",
    atomic_number=44,
    atomic_weight=101.07,
    atomic_weight_uncertainty=0.02,
    ionization_energies=[710.2 * KilojoulesPerMole, 1620. * KilojoulesPerMole, 2747. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=86.94918,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=87,
            special_symbol=None
        ),
        Isotope(
            mass=87.94026,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=88,
            special_symbol=None
        ),
        Isotope(
            mass=88.93611,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.92989,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.92629,
            mass_uncertainty=0.00063,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.92012,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.917050,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.911360,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.910413,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.907598,
            mass_uncertainty=0.000008,
            abundance=0.0554,
            abundance_uncertainty=0.0014,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.907555,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.905287,
            mass_uncertainty=0.000007,
            abundance=0.0187,
            abundance_uncertainty=0.0003,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.9059393,
            mass_uncertainty=0.0000022,
            abundance=0.1276,
            abundance_uncertainty=0.0014,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.9042195,
            mass_uncertainty=0.0000022,
            abundance=0.1260,
            abundance_uncertainty=0.0007,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.9055821,
            mass_uncertainty=0.0000022,
            abundance=0.1706,
            abundance_uncertainty=0.0002,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.9043493,
            mass_uncertainty=0.0000022,
            abundance=0.3155,
            abundance_uncertainty=0.0014,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.9063238,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.905433,
            mass_uncertainty=0.000003,
            abundance=0.1862,
            abundance_uncertainty=0.0027,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.907753,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.907329,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.90991,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.91017,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.913200,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.914140,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.917700,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.918970,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.922490,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.92428,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.92869,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.93081,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.93558,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.93782,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.94284,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.94531,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        )
    ]
)
Elements['Ru'] = Ru


Rh = Element(
    symbol="Rh",
    atomic_number=45,
    atomic_weight=102.90550,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[719.7 * KilojoulesPerMole, 1740. * KilojoulesPerMole, 2997. * KilojoulesPerMole],
    electronegativity=2.28,
    isotopes=[
        Isotope(
            mass=88.94884,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=89,
            special_symbol=None
        ),
        Isotope(
            mass=89.94287,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=90,
            special_symbol=None
        ),
        Isotope(
            mass=90.93655,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.93198,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.92574,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.92170,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.91590,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.914461,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.911340,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.910708,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.908132,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.908122,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.906164,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.906843,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.905504,
            mass_uncertainty=0.000003,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.906656,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.905694,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.907287,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.906748,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.90873,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.908737,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.911140,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.911590,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.914390,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.915530,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.91881,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.920330,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.92406,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.92598,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.93007,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.93211,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.93641,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.93872,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.94321,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        )
    ]
)
Elements['Rh'] = Rh


Pd = Element(
    symbol="Pd",
    atomic_number=46,
    atomic_weight=106.42,
    atomic_weight_uncertainty=0.01,
    vdw_radius=163. * Picometers,
    ionization_energies=[804.4 * KilojoulesPerMole, 1870. * KilojoulesPerMole, 3177. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=90.94911,
            mass_uncertainty=0.00061,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=91,
            special_symbol=None
        ),
        Isotope(
            mass=91.94042,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=92,
            special_symbol=None
        ),
        Isotope(
            mass=92.93591,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.92877,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.92469,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.91816,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.91648,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.912721,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.911768,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.908506,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.908289,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.905609,
            mass_uncertainty=0.000003,
            abundance=0.0102,
            abundance_uncertainty=0.0001,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.906087,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.904036,
            mass_uncertainty=0.000004,
            abundance=0.1114,
            abundance_uncertainty=0.0008,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.905085,
            mass_uncertainty=0.000004,
            abundance=0.2233,
            abundance_uncertainty=0.0008,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.903486,
            mass_uncertainty=0.000004,
            abundance=0.2733,
            abundance_uncertainty=0.0003,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.905133,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.903892,
            mass_uncertainty=0.000004,
            abundance=0.2646,
            abundance_uncertainty=0.0009,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.905950,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.905153,
            mass_uncertainty=0.000012,
            abundance=0.1172,
            abundance_uncertainty=0.0009,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.907671,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.907314,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.910150,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.910363,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.913680,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.914160,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.917840,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.91898,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.92311,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.92469,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.92887,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.93055,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.93493,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.93688,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        )
    ]
)
Elements['Pd'] = Pd


Ag = Element(
    symbol="Ag",
    atomic_number=47,
    atomic_weight=107.8682,
    atomic_weight_uncertainty=0.0002,
    vdw_radius=172. * Picometers,
    ionization_energies=[731. * KilojoulesPerMole, 2070. * KilojoulesPerMole, 3361. * KilojoulesPerMole],
    electronegativity=1.93,
    isotopes=[
        Isotope(
            mass=92.94978,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=93,
            special_symbol=None
        ),
        Isotope(
            mass=93.94278,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=94,
            special_symbol=None
        ),
        Isotope(
            mass=94.93548,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.93068,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.92397,
            mass_uncertainty=0.00035,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.921570,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.91760,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.916100,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.91280,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.911690,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.908973,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.908629,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.906529,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.906669,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.905097,
            mass_uncertainty=0.000005,
            abundance=0.51839,
            abundance_uncertainty=0.00008,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.905956,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.904752,
            mass_uncertainty=0.000003,
            abundance=0.48161,
            abundance_uncertainty=0.00008,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.906107,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.905291,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.907005,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.906567,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.908804,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.908760,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.911360,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.911680,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.914580,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.91567,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.918790,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.91985,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.92353,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.92490,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.92864,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.93043,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.93450,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.93677,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.94117,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.94369,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.95045,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        )
    ]
)
Elements['Ag'] = Ag


Cd = Element(
    symbol="Cd",
    atomic_number=48,
    atomic_weight=112.411,
    atomic_weight_uncertainty=0.008,
    vdw_radius=158. * Picometers,
    ionization_energies=[867.8 * KilojoulesPerMole, 1631.4 * KilojoulesPerMole, 3616. * KilojoulesPerMole],
    electronegativity=1.69,
    isotopes=[
        Isotope(
            mass=94.94987,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=95,
            special_symbol=None
        ),
        Isotope(
            mass=95.93977,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=96,
            special_symbol=None
        ),
        Isotope(
            mass=96.93494,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.927400,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.92501,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.92029,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.91868,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.914460,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.913419,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.909849,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.909468,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.906459,
            mass_uncertainty=0.000006,
            abundance=0.0125,
            abundance_uncertainty=0.0006,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.906618,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.904184,
            mass_uncertainty=0.000006,
            abundance=0.0089,
            abundance_uncertainty=0.0003,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.904982,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.9030021,
            mass_uncertainty=0.0000029,
            abundance=0.1249,
            abundance_uncertainty=0.0018,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.9041781,
            mass_uncertainty=0.0000029,
            abundance=0.1280,
            abundance_uncertainty=0.0012,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.9027578,
            mass_uncertainty=0.0000029,
            abundance=0.2413,
            abundance_uncertainty=0.0021,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.9044017,
            mass_uncertainty=0.0000029,
            abundance=0.1222,
            abundance_uncertainty=0.0012,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.9033585,
            mass_uncertainty=0.0000029,
            abundance=0.2873,
            abundance_uncertainty=0.0042,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.9054310,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.904756,
            mass_uncertainty=0.000003,
            abundance=0.0749,
            abundance_uncertainty=0.0018,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.907219,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.906915,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.909920,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.909850,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.912980,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.913330,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.917000,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.917650,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.921250,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.922350,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.926440,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.92776,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.93215,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.93390,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.94067,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.94555,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        )
    ]
)
Elements['Cd'] = Cd


In = Element(
    symbol="In",
    atomic_number=49,
    atomic_weight=114.818,
    atomic_weight_uncertainty=0.003,
    vdw_radius=193. * Picometers,
    ionization_energies=[558.3 * KilojoulesPerMole, 1820.7 * KilojoulesPerMole, 2704. * KilojoulesPerMole, 5210. * KilojoulesPerMole],
    electronegativity=1.78,
    isotopes=[
        Isotope(
            mass=96.94954,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=97,
            special_symbol=None
        ),
        Isotope(
            mass=97.94214,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=98,
            special_symbol=None
        ),
        Isotope(
            mass=98.93422,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.93111,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.92634,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.92409,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.919914,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.918300,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.914674,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.913465,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.910295,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.909698,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.907151,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.907165,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.905103,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.905532,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.904058,
            mass_uncertainty=0.000003,
            abundance=0.0429,
            abundance_uncertainty=0.0005,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.904914,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.903878,
            mass_uncertainty=0.000005,
            abundance=0.9571,
            abundance_uncertainty=0.0005,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.905260,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.904514,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.906354,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.905845,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.907960,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.907846,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.910280,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.910438,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.913180,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.913600,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.916460,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.917350,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.920170,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.921700,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.924970,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.926850,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.932990,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.93781,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.94415,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.94933,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        )
    ]
)
Elements['In'] = In


Sn = Element(
    symbol="Sn",
    atomic_number=50,
    atomic_weight=118.710,
    atomic_weight_uncertainty=0.007,
    vdw_radius=217. * Picometers,
    ionization_energies=[708.6 * KilojoulesPerMole, 1411.8 * KilojoulesPerMole, 2943. * KilojoulesPerMole, 3930.3 * KilojoulesPerMole, 7456. * KilojoulesPerMole],
    electronegativity=1.96,
    isotopes=[
        Isotope(
            mass=98.94933,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=99,
            special_symbol=None
        ),
        Isotope(
            mass=99.93904,
            mass_uncertainty=0.00076,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=100,
            special_symbol=None
        ),
        Isotope(
            mass=100.93606,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=101,
            special_symbol=None
        ),
        Isotope(
            mass=101.93030,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=102,
            special_symbol=None
        ),
        Isotope(
            mass=102.92810,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.92314,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.921350,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.916880,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.915640,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.911925,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.911283,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.907843,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.907734,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.904818,
            mass_uncertainty=0.000005,
            abundance=0.0097,
            abundance_uncertainty=0.0001,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.905171,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.902779,
            mass_uncertainty=0.000003,
            abundance=0.0066,
            abundance_uncertainty=0.0001,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.903342,
            mass_uncertainty=0.000003,
            abundance=0.0034,
            abundance_uncertainty=0.0001,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.901741,
            mass_uncertainty=0.000003,
            abundance=0.1454,
            abundance_uncertainty=0.0009,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.902952,
            mass_uncertainty=0.000003,
            abundance=0.0768,
            abundance_uncertainty=0.0007,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.901603,
            mass_uncertainty=0.000003,
            abundance=0.2422,
            abundance_uncertainty=0.0009,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.903308,
            mass_uncertainty=0.000003,
            abundance=0.0859,
            abundance_uncertainty=0.0004,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.9021947,
            mass_uncertainty=0.0000027,
            abundance=0.3258,
            abundance_uncertainty=0.0009,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.9042355,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.9034390,
            mass_uncertainty=0.0000029,
            abundance=0.0463,
            abundance_uncertainty=0.0003,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.9057208,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.9052739,
            mass_uncertainty=0.0000015,
            abundance=0.0579,
            abundance_uncertainty=0.0005,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.9077841,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.907653,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.910360,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.910537,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.913480,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.913967,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.917000,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.917816,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.923830,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.92829,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.93473,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.93934,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.94599,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        )
    ]
)
Elements['Sn'] = Sn


Sb = Element(
    symbol="Sb",
    atomic_number=51,
    atomic_weight=121.760,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[834. * KilojoulesPerMole, 1594.9 * KilojoulesPerMole, 2440. * KilojoulesPerMole, 4260. * KilojoulesPerMole, 5400. * KilojoulesPerMole, 10400. * KilojoulesPerMole],
    electronegativity=2.05,
    isotopes=[
        Isotope(
            mass=102.93969,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=103,
            special_symbol=None
        ),
        Isotope(
            mass=103.93647,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=104,
            special_symbol=None
        ),
        Isotope(
            mass=104.93149,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.92879,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.92415,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.92216,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.918132,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.91675,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.913160,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.912398,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.909372,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.909270,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.906598,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.906794,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.904836,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.905529,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.903942,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.905072,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.9038157,
            mass_uncertainty=0.0000024,
            abundance=0.5721,
            abundance_uncertainty=0.0005,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.9051737,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.9042140,
            mass_uncertainty=0.0000022,
            abundance=0.4279,
            abundance_uncertainty=0.0005,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.9059357,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.9052538,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.907250,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.906924,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.909169,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.909148,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.911656,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.911982,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.914467,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.915252,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.920380,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.92517,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.93035,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.93531,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.94079,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.94598,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        )
    ]
)
Elements['Sb'] = Sb


Te = Element(
    symbol="Te",
    atomic_number=52,
    atomic_weight=127.60,
    atomic_weight_uncertainty=0.03,
    vdw_radius=206. * Picometers,
    ionization_energies=[869.3 * KilojoulesPerMole, 1790. * KilojoulesPerMole, 2698. * KilojoulesPerMole, 3610. * KilojoulesPerMole, 5668. * KilojoulesPerMole, 6820. * KilojoulesPerMole, 13200. * KilojoulesPerMole],
    electronegativity=2.1,
    isotopes=[
        Isotope(
            mass=104.94364,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=105,
            special_symbol=None
        ),
        Isotope(
            mass=105.93750,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=106,
            special_symbol=None
        ),
        Isotope(
            mass=106.93501,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=107,
            special_symbol=None
        ),
        Isotope(
            mass=107.92944,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.927420,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.922410,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.921110,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.91701,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.915890,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.912090,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.911900,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.908460,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.908645,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.905828,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.906404,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.904020,
            mass_uncertainty=0.000010,
            abundance=0.0009,
            abundance_uncertainty=0.0001,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.904936,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.9030439,
            mass_uncertainty=0.0000016,
            abundance=0.0255,
            abundance_uncertainty=0.0012,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.9042700,
            mass_uncertainty=0.0000016,
            abundance=0.0089,
            abundance_uncertainty=0.0003,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.9028179,
            mass_uncertainty=0.0000016,
            abundance=0.0474,
            abundance_uncertainty=0.0014,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.9044307,
            mass_uncertainty=0.0000016,
            abundance=0.0707,
            abundance_uncertainty=0.0015,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.9033117,
            mass_uncertainty=0.0000016,
            abundance=0.1884,
            abundance_uncertainty=0.0025,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.9052263,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.9044631,
            mass_uncertainty=0.0000019,
            abundance=0.3174,
            abundance_uncertainty=0.0008,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.9065982,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.9062244,
            mass_uncertainty=0.0000021,
            abundance=0.3408,
            abundance_uncertainty=0.0062,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.9085239,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.908553,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.910955,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.911369,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.91645,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.920100,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.92532,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.92922,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.93473,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.93885,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.94465,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.94908,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        )
    ]
)
Elements['Te'] = Te


I = Element(
    symbol="I",
    atomic_number=53,
    atomic_weight=126.90447,
    atomic_weight_uncertainty=0.00003,
    vdw_radius=198. * Picometers,
    ionization_energies=[1008.4 * KilojoulesPerMole, 1845.9 * KilojoulesPerMole, 3180. * KilojoulesPerMole],
    electronegativity=2.66,
    isotopes=[
        Isotope(
            mass=107.94348,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=108,
            special_symbol=None
        ),
        Isotope(
            mass=108.93815,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=109,
            special_symbol=None
        ),
        Isotope(
            mass=109.93524,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.93028,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.92797,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.923640,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.92185,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.918050,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.91681,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.913650,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.913074,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.910070,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.910048,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.907367,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.907589,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.905589,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.9062099,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.9046302,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.905624,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.904473,
            mass_uncertainty=0.000004,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.905809,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.904988,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.906674,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.9061246,
            mass_uncertainty=0.0000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.907997,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.907797,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.909744,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.910048,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.914650,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.917871,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.922350,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.926100,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.93100,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.93503,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.94018,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.94456,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.94999,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        )
    ]
)
Elements['I'] = I


Xe = Element(
    symbol="Xe",
    atomic_number=54,
    atomic_weight=131.293,
    atomic_weight_uncertainty=0.006,
    vdw_radius=216. * Picometers,
    ionization_energies=[1170.4 * KilojoulesPerMole, 2046.4 * KilojoulesPerMole, 3099.4 * KilojoulesPerMole],
    electronegativity=2.6,
    isotopes=[
        Isotope(
            mass=109.94428,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=110,
            special_symbol=None
        ),
        Isotope(
            mass=110.94160,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=111,
            special_symbol=None
        ),
        Isotope(
            mass=111.93562,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.933340,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.927980,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.926294,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.921581,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.920359,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.916179,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.915411,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.911784,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.911462,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.908368,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.908482,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.9058930,
            mass_uncertainty=0.0000020,
            abundance=0.000952,
            abundance_uncertainty=0.000003,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.9063955,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.904274,
            mass_uncertainty=0.000007,
            abundance=0.000890,
            abundance_uncertainty=0.000002,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.905184,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.9035313,
            mass_uncertainty=0.0000015,
            abundance=0.019102,
            abundance_uncertainty=0.000008,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.9047794,
            mass_uncertainty=0.0000008,
            abundance=0.264006,
            abundance_uncertainty=0.000082,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.9035080,
            mass_uncertainty=0.0000008,
            abundance=0.040710,
            abundance_uncertainty=0.000013,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.9050824,
            mass_uncertainty=0.0000010,
            abundance=0.212324,
            abundance_uncertainty=0.000030,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.9041535,
            mass_uncertainty=0.0000010,
            abundance=0.269086,
            abundance_uncertainty=0.000033,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.9059107,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.9053945,
            mass_uncertainty=0.0000009,
            abundance=0.104357,
            abundance_uncertainty=0.000021,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.907227,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.907219,
            mass_uncertainty=0.000008,
            abundance=0.088573,
            abundance_uncertainty=0.000044,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.911562,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.913950,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.918793,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.921640,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.92665,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.92971,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.93511,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.93851,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.94407,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.94775,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.95356,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        )
    ]
)
Elements['Xe'] = Xe


Cs = Element(
    symbol="Cs",
    atomic_number=55,
    atomic_weight=132.9054519,
    atomic_weight_uncertainty=0.0000002,
    ionization_energies=[375.7 * KilojoulesPerMole, 2234.3 * KilojoulesPerMole, 3400. * KilojoulesPerMole],
    electronegativity=0.79,
    isotopes=[
        Isotope(
            mass=111.95030,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=112,
            special_symbol=None
        ),
        Isotope(
            mass=112.94449,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=113,
            special_symbol=None
        ),
        Isotope(
            mass=113.94145,
            mass_uncertainty=0.00033,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.93591,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.93337,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.928670,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.926559,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.922377,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.920677,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.917229,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.916110,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.912996,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.912258,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.909728,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.909452,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.907418,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.907749,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.906064,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.906709,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.905464,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.9064343,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.905451933,
            mass_uncertainty=0.000000024,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.906718475,
            mass_uncertainty=0.000000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.9059770,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.9073116,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.9070895,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.911017,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.913364,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.917282,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.920046,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.924299,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.927352,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.932077,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.935526,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.940290,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.944160,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.94922,
            mass_uncertainty=0.00062,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.95293,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.95817,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.96219,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        )
    ]
)
Elements['Cs'] = Cs


Ba = Element(
    symbol="Ba",
    atomic_number=56,
    atomic_weight=137.327,
    atomic_weight_uncertainty=0.007,
    ionization_energies=[502.9 * KilojoulesPerMole, 965.2 * KilojoulesPerMole, 3600. * KilojoulesPerMole],
    electronegativity=0.89,
    isotopes=[
        Isotope(
            mass=113.95068,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=114,
            special_symbol=None
        ),
        Isotope(
            mass=114.94737,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=115,
            special_symbol=None
        ),
        Isotope(
            mass=115.94138,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=116,
            special_symbol=None
        ),
        Isotope(
            mass=116.93850,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.93304,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.93066,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.92604,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.92405,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.919900,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.918781,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.915094,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.914473,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.911250,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.911094,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.908318,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.908679,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.9063208,
            mass_uncertainty=0.0000030,
            abundance=0.00106,
            abundance_uncertainty=0.00001,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.906941,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.9050613,
            mass_uncertainty=0.0000011,
            abundance=0.00101,
            abundance_uncertainty=0.00001,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.9060075,
            mass_uncertainty=0.0000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.9045084,
            mass_uncertainty=0.0000004,
            abundance=0.02417,
            abundance_uncertainty=0.00018,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.9056886,
            mass_uncertainty=0.0000004,
            abundance=0.06592,
            abundance_uncertainty=0.00012,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.9045759,
            mass_uncertainty=0.0000004,
            abundance=0.07854,
            abundance_uncertainty=0.00024,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.9058274,
            mass_uncertainty=0.0000005,
            abundance=0.11232,
            abundance_uncertainty=0.00024,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.9052472,
            mass_uncertainty=0.0000005,
            abundance=0.71698,
            abundance_uncertainty=0.00042,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.9088413,
            mass_uncertainty=0.0000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.910605,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.914411,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.916453,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.920627,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.922953,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.927630,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.930220,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.93495,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.937720,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.94258,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.94568,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.95081,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.95427,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.95961,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        )
    ]
)
Elements['Ba'] = Ba


La = Element(
    symbol="La",
    atomic_number=57,
    atomic_weight=138.90547,
    atomic_weight_uncertainty=0.00007,
    ionization_energies=[538.1 * KilojoulesPerMole, 1067. * KilojoulesPerMole, 1850.3 * KilojoulesPerMole, 4819. * KilojoulesPerMole, 5940. * KilojoulesPerMole],
    electronegativity=1.1,
    isotopes=[
        Isotope(
            mass=116.95007,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=117,
            special_symbol=None
        ),
        Isotope(
            mass=117.94673,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=118,
            special_symbol=None
        ),
        Isotope(
            mass=118.94099,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.93807,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.93301,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.93071,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.92624,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.924570,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.920816,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.91951,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.916375,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.915590,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.912693,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.912369,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.910070,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.910100,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.908220,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.908514,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.906977,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.907640,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.906494,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.907112,
            mass_uncertainty=0.000004,
            abundance=0.00090,
            abundance_uncertainty=0.00001,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.9063533,
            mass_uncertainty=0.0000026,
            abundance=0.99910,
            abundance_uncertainty=0.00001,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.9094776,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.910962,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.914079,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.916063,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.919600,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.92165,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.925790,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.928240,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.932230,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.93473,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.93877,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.94172,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.94625,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.94962,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.95450,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.95835,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        )
    ]
)
Elements['La'] = La


Ce = Element(
    symbol="Ce",
    atomic_number=58,
    atomic_weight=140.116,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[534.4 * KilojoulesPerMole, 1050. * KilojoulesPerMole, 1949. * KilojoulesPerMole, 3547. * KilojoulesPerMole, 6325. * KilojoulesPerMole, 7490. * KilojoulesPerMole],
    electronegativity=1.12,
    isotopes=[
        Isotope(
            mass=118.95276,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=119,
            special_symbol=None
        ),
        Isotope(
            mass=119.94664,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=120,
            special_symbol=None
        ),
        Isotope(
            mass=120.94342,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.93791,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.93540,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.93041,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.92844,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.923970,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.922730,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.918910,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.918100,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.914740,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.914420,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.911460,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.911515,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.908925,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.909151,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.907172,
            mass_uncertainty=0.000014,
            abundance=0.00185,
            abundance_uncertainty=0.00002,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.907806,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.905991,
            mass_uncertainty=0.000011,
            abundance=0.00251,
            abundance_uncertainty=0.00002,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.906653,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.9054387,
            mass_uncertainty=0.0000026,
            abundance=0.88450,
            abundance_uncertainty=0.00051,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.9082763,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.909244,
            mass_uncertainty=0.000003,
            abundance=0.11114,
            abundance_uncertainty=0.00051,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.912386,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.913647,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.917230,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.918760,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.922670,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.924430,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.92840,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.930410,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.93398,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.93654,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.94058,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.94342,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.94804,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.95126,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.95634,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        )
    ]
)
Elements['Ce'] = Ce


Pr = Element(
    symbol="Pr",
    atomic_number=59,
    atomic_weight=140.90765,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[527. * KilojoulesPerMole, 1020. * KilojoulesPerMole, 2086. * KilojoulesPerMole, 3761. * KilojoulesPerMole, 5551. * KilojoulesPerMole],
    electronegativity=1.13,
    isotopes=[
        Isotope(
            mass=120.95536,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=121,
            special_symbol=None
        ),
        Isotope(
            mass=121.95181,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=122,
            special_symbol=None
        ),
        Isotope(
            mass=122.94596,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=123,
            special_symbol=None
        ),
        Isotope(
            mass=123.94296,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.93783,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.93531,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.93083,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.928790,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.925100,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.923590,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.920260,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.919260,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.916331,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.915710,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.913112,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.912692,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.910705,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.910755,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.908938,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.909076,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.9076528,
            mass_uncertainty=0.0000026,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.9100448,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.9108169,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.913305,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.914512,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.917640,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.918996,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.922135,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.923720,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.926673,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.928319,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.93150,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.93384,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.93752,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.94012,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.94427,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.94743,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.95198,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.95550,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        )
    ]
)
Elements['Pr'] = Pr


Nd = Element(
    symbol="Nd",
    atomic_number=60,
    atomic_weight=144.242,
    atomic_weight_uncertainty=0.003,
    ionization_energies=[533.1 * KilojoulesPerMole, 1040. * KilojoulesPerMole, 2130. * KilojoulesPerMole, 3900. * KilojoulesPerMole],
    electronegativity=1.14,
    isotopes=[
        Isotope(
            mass=123.95223,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=124,
            special_symbol=None
        ),
        Isotope(
            mass=124.94888,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=125,
            special_symbol=None
        ),
        Isotope(
            mass=125.94322,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.94050,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.93539,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.93319,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.928510,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.927250,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.923321,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.922350,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.918790,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.918181,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.914976,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.914567,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.911950,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.911978,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.909550,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.909610,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.9077233,
            mass_uncertainty=0.0000025,
            abundance=0.272,
            abundance_uncertainty=0.005,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.9098143,
            mass_uncertainty=0.0000025,
            abundance=0.122,
            abundance_uncertainty=0.002,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.9100873,
            mass_uncertainty=0.0000025,
            abundance=0.238,
            abundance_uncertainty=0.003,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.9125736,
            mass_uncertainty=0.0000025,
            abundance=0.083,
            abundance_uncertainty=0.001,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.9131169,
            mass_uncertainty=0.0000025,
            abundance=0.172,
            abundance_uncertainty=0.003,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.9161004,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.916893,
            mass_uncertainty=0.000003,
            abundance=0.057,
            abundance_uncertainty=0.001,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.920149,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.920891,
            mass_uncertainty=0.000003,
            abundance=0.056,
            abundance_uncertainty=0.002,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.923829,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.924682,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.927698,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.92948,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.93293,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.93502,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.93903,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.94160,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.94609,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.94909,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.95388,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        )
    ]
)
Elements['Nd'] = Nd


Pm = Element(
    symbol="Pm",
    atomic_number=61,
    atomic_weight=145,
    is_synthetic=True,
    ionization_energies=[540. * KilojoulesPerMole, 1050. * KilojoulesPerMole, 2150. * KilojoulesPerMole, 3970. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=125.95752,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=126,
            special_symbol=None
        ),
        Isotope(
            mass=126.95163,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=127,
            special_symbol=None
        ),
        Isotope(
            mass=127.94842,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.94316,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.94045,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.93587,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.93375,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.929780,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.928350,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.924880,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.923570,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.920479,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.919548,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.916804,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.916040,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.913555,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.912874,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.910933,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.912591,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.912749,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.914696,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.9151385,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.917475,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.918334,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.920984,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.921207,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.923497,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.924117,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.926460,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.928100,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.931060,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.93304,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.93656,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.93897,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.94299,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.94586,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.95029,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.95368,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        )
    ]
)
Elements['Pm'] = Pm


Sm = Element(
    symbol="Sm",
    atomic_number=62,
    atomic_weight=150.36,
    atomic_weight_uncertainty=0.02,
    ionization_energies=[544.5 * KilojoulesPerMole, 1070. * KilojoulesPerMole, 2260. * KilojoulesPerMole, 3990. * KilojoulesPerMole],
    electronegativity=1.17,
    isotopes=[
        Isotope(
            mass=127.95808,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=128,
            special_symbol=None
        ),
        Isotope(
            mass=128.95464,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=129,
            special_symbol=None
        ),
        Isotope(
            mass=129.94892,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.94611,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.94069,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.93867,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.93397,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.93252,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.928276,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.926970,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.923244,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.922297,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.918995,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.918476,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.915198,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.914628,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.911999,
            mass_uncertainty=0.000003,
            abundance=0.0307,
            abundance_uncertainty=0.0007,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.913410,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.913041,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.9148979,
            mass_uncertainty=0.0000026,
            abundance=0.1499,
            abundance_uncertainty=0.0018,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.9148227,
            mass_uncertainty=0.0000026,
            abundance=0.1124,
            abundance_uncertainty=0.0010,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.9171847,
            mass_uncertainty=0.0000026,
            abundance=0.1382,
            abundance_uncertainty=0.0007,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.9172755,
            mass_uncertainty=0.0000026,
            abundance=0.0738,
            abundance_uncertainty=0.0001,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.9199324,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.9197324,
            mass_uncertainty=0.0000027,
            abundance=0.2675,
            abundance_uncertainty=0.0016,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.9220974,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.9222093,
            mass_uncertainty=0.0000027,
            abundance=0.2275,
            abundance_uncertainty=0.0029,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.9246402,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.925528,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.928360,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.929990,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.93321,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.93514,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.93883,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.94122,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.94536,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.94828,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.95298,
            mass_uncertainty=0.00097,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        )
    ]
)
Elements['Sm'] = Sm


Eu = Element(
    symbol="Eu",
    atomic_number=63,
    atomic_weight=151.964,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[547.1 * KilojoulesPerMole, 1085. * KilojoulesPerMole, 2404. * KilojoulesPerMole, 4120. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=129.96357,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=130,
            special_symbol=None
        ),
        Isotope(
            mass=130.95775,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=131,
            special_symbol=None
        ),
        Isotope(
            mass=131.95437,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=132,
            special_symbol=None
        ),
        Isotope(
            mass=132.94924,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=133,
            special_symbol=None
        ),
        Isotope(
            mass=133.94651,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.94182,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.93960,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.93557,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.933710,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.929792,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.928090,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.924931,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.923430,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.920298,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.918817,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.916265,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.917206,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.916746,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.918086,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.917931,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.919702,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.9198502,
            mass_uncertainty=0.0000026,
            abundance=0.4781,
            abundance_uncertainty=0.0006,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.9217445,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.9212303,
            mass_uncertainty=0.0000026,
            abundance=0.5219,
            abundance_uncertainty=0.0006,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.9229792,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.9228933,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.924752,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.925424,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.927850,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.929089,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.93197,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.93368,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.93704,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.93921,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.94299,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.94572,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.94997,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.95321,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        )
    ]
)
Elements['Eu'] = Eu


Gd = Element(
    symbol="Gd",
    atomic_number=64,
    atomic_weight=157.25,
    atomic_weight_uncertainty=0.03,
    ionization_energies=[593.4 * KilojoulesPerMole, 1170. * KilojoulesPerMole, 1990. * KilojoulesPerMole, 4250. * KilojoulesPerMole],
    electronegativity=1.2,
    isotopes=[
        Isotope(
            mass=133.95537,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=134,
            special_symbol=None
        ),
        Isotope(
            mass=134.95257,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=135,
            special_symbol=None
        ),
        Isotope(
            mass=135.94734,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.94502,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.94012,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.93824,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.933670,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.932126,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.928120,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.92675,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.922960,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.921709,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.918311,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.919094,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.918115,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.919341,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.918659,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.920348,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.9197910,
            mass_uncertainty=0.0000027,
            abundance=0.0020,
            abundance_uncertainty=0.0001,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.9217495,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.9208656,
            mass_uncertainty=0.0000027,
            abundance=0.0218,
            abundance_uncertainty=0.0003,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.9226220,
            mass_uncertainty=0.0000027,
            abundance=0.1480,
            abundance_uncertainty=0.0012,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.9221227,
            mass_uncertainty=0.0000027,
            abundance=0.2047,
            abundance_uncertainty=0.0009,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.9239601,
            mass_uncertainty=0.0000027,
            abundance=0.1565,
            abundance_uncertainty=0.0002,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.9241039,
            mass_uncertainty=0.0000027,
            abundance=0.2484,
            abundance_uncertainty=0.0007,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.9263887,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.9270541,
            mass_uncertainty=0.0000027,
            abundance=0.2186,
            abundance_uncertainty=0.0019,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.9296692,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.930985,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.93399,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.93586,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.93938,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.94160,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.94557,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.94836,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.95287,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        )
    ]
)
Elements['Gd'] = Gd


Tb = Element(
    symbol="Tb",
    atomic_number=65,
    atomic_weight=158.92535,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[565.8 * KilojoulesPerMole, 1110. * KilojoulesPerMole, 2114. * KilojoulesPerMole, 3839. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=135.96138,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=136,
            special_symbol=None
        ),
        Isotope(
            mass=136.95598,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=137,
            special_symbol=None
        ),
        Isotope(
            mass=137.95316,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.94829,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.94581,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.94145,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.93874,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.935120,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.933050,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.929270,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.927250,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.924045,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.924272,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.923246,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.923660,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.923103,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.924070,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.923435,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.924680,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.923505,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.924747,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.9240246,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.9254131,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.9253468,
            mass_uncertainty=0.0000027,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.9271676,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.9275699,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.929490,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.930648,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.93335,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.93488,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.93799,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.94005,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.94364,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.94622,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.95025,
            mass_uncertainty=0.00075,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.95330,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        )
    ]
)
Elements['Tb'] = Tb


Dy = Element(
    symbol="Dy",
    atomic_number=66,
    atomic_weight=162.500,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[573. * KilojoulesPerMole, 1130. * KilojoulesPerMole, 2200. * KilojoulesPerMole, 3990. * KilojoulesPerMole],
    electronegativity=1.22,
    isotopes=[
        Isotope(
            mass=137.96249,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=138,
            special_symbol=None
        ),
        Isotope(
            mass=138.95954,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=139,
            special_symbol=None
        ),
        Isotope(
            mass=139.95401,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.95135,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.94637,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.94383,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.939250,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.937430,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.932845,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.931092,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.927150,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.927305,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.925585,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.926185,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.924718,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.925765,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.924424,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.925754,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.924283,
            mass_uncertainty=0.000007,
            abundance=0.00056,
            abundance_uncertainty=0.00003,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.925466,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.924409,
            mass_uncertainty=0.000004,
            abundance=0.00095,
            abundance_uncertainty=0.00003,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.9257392,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.9251975,
            mass_uncertainty=0.0000027,
            abundance=0.02329,
            abundance_uncertainty=0.00018,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.9269334,
            mass_uncertainty=0.0000027,
            abundance=0.18889,
            abundance_uncertainty=0.00042,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.9267984,
            mass_uncertainty=0.0000027,
            abundance=0.25475,
            abundance_uncertainty=0.00036,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.9287312,
            mass_uncertainty=0.0000027,
            abundance=0.24896,
            abundance_uncertainty=0.00042,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.9291748,
            mass_uncertainty=0.0000027,
            abundance=0.28260,
            abundance_uncertainty=0.00054,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.9317033,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.9328067,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.935660,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.93713,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.94031,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.94239,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.94620,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.94876,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.95300,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        )
    ]
)
Elements['Dy'] = Dy


Ho = Element(
    symbol="Ho",
    atomic_number=67,
    atomic_weight=164.93032,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[581. * KilojoulesPerMole, 1140. * KilojoulesPerMole, 2204. * KilojoulesPerMole, 4100. * KilojoulesPerMole],
    electronegativity=1.23,
    isotopes=[
        Isotope(
            mass=139.96854,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=140,
            special_symbol=None
        ),
        Isotope(
            mass=140.96310,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=141,
            special_symbol=None
        ),
        Isotope(
            mass=141.95977,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=142,
            special_symbol=None
        ),
        Isotope(
            mass=142.95461,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.95148,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.94720,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.94464,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.940060,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.93772,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.933775,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.933496,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.931688,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.931714,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.930199,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.930602,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.929103,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.929840,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.928256,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.928941,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.927712,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.928729,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.927855,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.929096,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.9287339,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.9302335,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.9303221,
            mass_uncertainty=0.0000027,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.9322842,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.933133,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.935520,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.936872,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.939620,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.94147,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.94482,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.94729,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.95115,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.95405,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        )
    ]
)
Elements['Ho'] = Ho


Er = Element(
    symbol="Er",
    atomic_number=68,
    atomic_weight=167.259,
    atomic_weight_uncertainty=0.003,
    ionization_energies=[589.3 * KilojoulesPerMole, 1150. * KilojoulesPerMole, 2194. * KilojoulesPerMole, 4120. * KilojoulesPerMole],
    electronegativity=1.24,
    isotopes=[
        Isotope(
            mass=142.96634,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=143,
            special_symbol=None
        ),
        Isotope(
            mass=143.96038,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=144,
            special_symbol=None
        ),
        Isotope(
            mass=144.95739,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.95200,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.94949,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.94455,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.942310,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.937914,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.937449,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.935050,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.935063,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.932783,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.933209,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.931065,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.931920,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.929893,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.930684,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.929083,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.929995,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.928778,
            mass_uncertainty=0.000004,
            abundance=0.00139,
            abundance_uncertainty=0.00005,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.930033,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.929200,
            mass_uncertainty=0.000003,
            abundance=0.01601,
            abundance_uncertainty=0.00003,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.930726,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.9302931,
            mass_uncertainty=0.0000027,
            abundance=0.33503,
            abundance_uncertainty=0.00036,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.9320482,
            mass_uncertainty=0.0000027,
            abundance=0.22869,
            abundance_uncertainty=0.00009,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.9323702,
            mass_uncertainty=0.0000027,
            abundance=0.26978,
            abundance_uncertainty=0.00018,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.9345904,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.9354643,
            mass_uncertainty=0.0000030,
            abundance=0.14910,
            abundance_uncertainty=0.00036,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.9380298,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.939356,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.94240,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.94423,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.94777,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.95008,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.95405,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        )
    ]
)
Elements['Er'] = Er


Tm = Element(
    symbol="Tm",
    atomic_number=69,
    atomic_weight=168.93421,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[596.7 * KilojoulesPerMole, 1160. * KilojoulesPerMole, 2285. * KilojoulesPerMole, 4120. * KilojoulesPerMole],
    electronegativity=1.25,
    isotopes=[
        Isotope(
            mass=144.97007,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=145,
            special_symbol=None
        ),
        Isotope(
            mass=145.96643,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=146,
            special_symbol=None
        ),
        Isotope(
            mass=146.96096,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=147,
            special_symbol=None
        ),
        Isotope(
            mass=147.95784,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.95272,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.94996,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.945483,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.944420,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.942012,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.941568,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.939199,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.938980,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.936970,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.936980,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.934980,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.935260,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.933550,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.933995,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.932651,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.933560,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.932435,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.933554,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.9328516,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.934173,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.9342133,
            mass_uncertainty=0.0000027,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.9358014,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.9364294,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.938400,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.939604,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.942170,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.943840,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.94699,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.94904,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.95264,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.95534,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        )
    ]
)
Elements['Tm'] = Tm


Yb = Element(
    symbol="Yb",
    atomic_number=70,
    atomic_weight=173.054,
    atomic_weight_uncertainty=0.005,
    ionization_energies=[603.4 * KilojoulesPerMole, 1174.8 * KilojoulesPerMole, 2417. * KilojoulesPerMole, 4203. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=147.96742,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=148,
            special_symbol=None
        ),
        Isotope(
            mass=148.96404,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=149,
            special_symbol=None
        ),
        Isotope(
            mass=149.95842,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.95540,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.95029,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.94948,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.946394,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.945782,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.942818,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.942628,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.939866,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.940050,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.937552,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.937902,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.935768,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.936334,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.934489,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.935280,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.933882,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.934950,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.933897,
            mass_uncertainty=0.000005,
            abundance=0.0013,
            abundance_uncertainty=0.0001,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.935190,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.9347618,
            mass_uncertainty=0.0000026,
            abundance=0.0304,
            abundance_uncertainty=0.0015,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.9363258,
            mass_uncertainty=0.0000026,
            abundance=0.1428,
            abundance_uncertainty=0.0057,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.9363815,
            mass_uncertainty=0.0000026,
            abundance=0.2183,
            abundance_uncertainty=0.0067,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.9382108,
            mass_uncertainty=0.0000026,
            abundance=0.1613,
            abundance_uncertainty=0.0027,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.9388621,
            mass_uncertainty=0.0000026,
            abundance=0.3183,
            abundance_uncertainty=0.0092,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.9412765,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.9425717,
            mass_uncertainty=0.0000028,
            abundance=0.1276,
            abundance_uncertainty=0.0041,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.9452608,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.946647,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.95017,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.95233,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.95615,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        )
    ]
)
Elements['Yb'] = Yb


Lu = Element(
    symbol="Lu",
    atomic_number=71,
    atomic_weight=174.9668,
    atomic_weight_uncertainty=0.0001,
    ionization_energies=[523.5 * KilojoulesPerMole, 1340. * KilojoulesPerMole, 2022.3 * KilojoulesPerMole, 4370. * KilojoulesPerMole, 6445. * KilojoulesPerMole],
    electronegativity=1.27,
    isotopes=[
        Isotope(
            mass=149.97323,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=150,
            special_symbol=None
        ),
        Isotope(
            mass=150.96758,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=151,
            special_symbol=None
        ),
        Isotope(
            mass=151.96412,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=152,
            special_symbol=None
        ),
        Isotope(
            mass=152.95877,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.95752,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.954316,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.953030,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.950098,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.949313,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.946630,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.946030,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.943570,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.943280,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.941180,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.941340,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.939407,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.939860,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.938270,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.938740,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.937651,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.938475,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.9379131,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.939086,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.9389306,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.9403375,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.9407718,
            mass_uncertainty=0.0000023,
            abundance=0.9741,
            abundance_uncertainty=0.0002,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.9426863,
            mass_uncertainty=0.0000023,
            abundance=0.0259,
            abundance_uncertainty=0.0002,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.9437581,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.945955,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.947327,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.949880,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.95197,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.95504,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.95757,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.96091,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        )
    ]
)
Elements['Lu'] = Lu


Hf = Element(
    symbol="Hf",
    atomic_number=72,
    atomic_weight=178.49,
    atomic_weight_uncertainty=0.02,
    ionization_energies=[658.5 * KilojoulesPerMole, 1440. * KilojoulesPerMole, 2250. * KilojoulesPerMole, 3216. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=152.97069,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=153,
            special_symbol=None
        ),
        Isotope(
            mass=153.96486,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=154,
            special_symbol=None
        ),
        Isotope(
            mass=154.96339,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.95936,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.95840,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.954799,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.953995,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.950684,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.950275,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.947210,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.947090,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.944367,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.944570,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.942180,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.942600,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.940570,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.941260,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.939610,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.940490,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.939448,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.940510,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.940046,
            mass_uncertainty=0.000003,
            abundance=0.0016,
            abundance_uncertainty=0.0001,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.941509,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.9414086,
            mass_uncertainty=0.0000024,
            abundance=0.0526,
            abundance_uncertainty=0.0007,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.9432207,
            mass_uncertainty=0.0000023,
            abundance=0.1860,
            abundance_uncertainty=0.0009,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.9436988,
            mass_uncertainty=0.0000023,
            abundance=0.2728,
            abundance_uncertainty=0.0007,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.9458161,
            mass_uncertainty=0.0000023,
            abundance=0.1362,
            abundance_uncertainty=0.0002,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.9465500,
            mass_uncertainty=0.0000023,
            abundance=0.3508,
            abundance_uncertainty=0.0016,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.9491012,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.950554,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.953530,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.955450,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.95882,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.96089,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.96459,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.96685,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        )
    ]
)
Elements['Hf'] = Hf


Ta = Element(
    symbol="Ta",
    atomic_number=73,
    atomic_weight=180.94788,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[761. * KilojoulesPerMole, 1500. * KilojoulesPerMole],
    electronegativity=1.5,
    isotopes=[
        Isotope(
            mass=154.97459,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=155,
            special_symbol=None
        ),
        Isotope(
            mass=155.97230,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=156,
            special_symbol=None
        ),
        Isotope(
            mass=156.96819,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=157,
            special_symbol=None
        ),
        Isotope(
            mass=157.96670,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.963018,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.96149,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.958420,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.957290,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.954330,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.953530,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.950773,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.950510,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.948090,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.948050,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.946010,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.946180,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.944480,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.944900,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.943750,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.944450,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.943740,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.944860,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.944472,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.945778,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.9459295,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.9474648,
            mass_uncertainty=0.0000024,
            abundance=0.00012,
            abundance_uncertainty=0.00002,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.9479958,
            mass_uncertainty=0.0000019,
            abundance=0.99988,
            abundance_uncertainty=0.00002,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.9501518,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.9513726,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.954008,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.955559,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.958550,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.96053,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.96370,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.96583,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.96923,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        )
    ]
)
Elements['Ta'] = Ta


W = Element(
    symbol="W",
    atomic_number=74,
    atomic_weight=183.84,
    atomic_weight_uncertainty=0.01,
    ionization_energies=[770. * KilojoulesPerMole, 1700. * KilojoulesPerMole],
    electronegativity=2.36,
    isotopes=[
        Isotope(
            mass=157.97456,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=158,
            special_symbol=None
        ),
        Isotope(
            mass=158.97292,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=159,
            special_symbol=None
        ),
        Isotope(
            mass=159.96848,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.96736,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.963497,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.962520,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.958954,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.958280,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.955027,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.954816,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.951808,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.951779,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.949228,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.949450,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.947290,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.947690,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.946080,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.946720,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.945630,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.946640,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.945876,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.947070,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.946704,
            mass_uncertainty=0.000004,
            abundance=0.0012,
            abundance_uncertainty=0.0001,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.948197,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.9482042,
            mass_uncertainty=0.0000009,
            abundance=0.2650,
            abundance_uncertainty=0.0016,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.9502230,
            mass_uncertainty=0.0000009,
            abundance=0.1431,
            abundance_uncertainty=0.0004,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.9509312,
            mass_uncertainty=0.0000009,
            abundance=0.3064,
            abundance_uncertainty=0.0002,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.9534193,
            mass_uncertainty=0.0000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.9543641,
            mass_uncertainty=0.0000019,
            abundance=0.2843,
            abundance_uncertainty=0.0019,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.9571605,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.958489,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.96191,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.96318,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.96660,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.96817,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        )
    ]
)
Elements['W'] = W


Re = Element(
    symbol="Re",
    atomic_number=75,
    atomic_weight=186.207,
    atomic_weight_uncertainty=0.001,
    ionization_energies=[760. * KilojoulesPerMole, 1260. * KilojoulesPerMole, 2510. * KilojoulesPerMole, 3640. * KilojoulesPerMole],
    electronegativity=1.9,
    isotopes=[
        Isotope(
            mass=159.98212,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=160,
            special_symbol=None
        ),
        Isotope(
            mass=160.97759,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=161,
            special_symbol=None
        ),
        Isotope(
            mass=161.97600,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.972081,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.97032,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.967089,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.965810,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.962600,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.961570,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.958790,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.958220,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.955720,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.955420,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.953240,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.953120,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.951380,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.951620,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.950330,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.950990,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.949988,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.950789,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.950068,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.95121,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.950820,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.952521,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.9529550,
            mass_uncertainty=0.0000013,
            abundance=0.3740,
            abundance_uncertainty=0.0002,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.9549861,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.9557531,
            mass_uncertainty=0.0000015,
            abundance=0.6260,
            abundance_uncertainty=0.0002,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.9581144,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.959229,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.96182,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.963125,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.96596,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.96747,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.97042,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        )
    ]
)
Elements['Re'] = Re


Os = Element(
    symbol="Os",
    atomic_number=76,
    atomic_weight=190.23,
    atomic_weight_uncertainty=0.03,
    ionization_energies=[840. * KilojoulesPerMole, 1600. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=161.98443,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=162,
            special_symbol=None
        ),
        Isotope(
            mass=162.98269,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=163,
            special_symbol=None
        ),
        Isotope(
            mass=163.97804,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.97676,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.972691,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.971550,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.967804,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.967019,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.963577,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.963185,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.960023,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.959808,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.957062,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.956946,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.954810,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.954965,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.953251,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.953816,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.952379,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.953240,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.952110,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.953130,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.9524891,
            mass_uncertainty=0.0000014,
            abundance=0.0002,
            abundance_uncertainty=0.0001,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.9540423,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.9538382,
            mass_uncertainty=0.0000015,
            abundance=0.0159,
            abundance_uncertainty=0.0003,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.9557505,
            mass_uncertainty=0.0000015,
            abundance=0.0196,
            abundance_uncertainty=0.0002,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.9558382,
            mass_uncertainty=0.0000015,
            abundance=0.1324,
            abundance_uncertainty=0.0008,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.9581475,
            mass_uncertainty=0.0000016,
            abundance=0.1615,
            abundance_uncertainty=0.0005,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.9584470,
            mass_uncertainty=0.0000016,
            abundance=0.2626,
            abundance_uncertainty=0.0002,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.9609297,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.9614807,
            mass_uncertainty=0.0000027,
            abundance=0.4078,
            abundance_uncertainty=0.0019,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.9641516,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.9651821,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.96813,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.969640,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        )
    ]
)
Elements['Os'] = Os


Ir = Element(
    symbol="Ir",
    atomic_number=77,
    atomic_weight=192.217,
    atomic_weight_uncertainty=0.003,
    ionization_energies=[880. * KilojoulesPerMole, 1600. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=163.99220,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=164,
            special_symbol=None
        ),
        Isotope(
            mass=164.98752,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=165,
            special_symbol=None
        ),
        Isotope(
            mass=165.98582,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.981665,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.97988,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.976295,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.97497,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.971630,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.97046,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.967502,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.966861,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.964113,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.963649,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.961302,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.961082,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.959122,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.959229,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.957625,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.958076,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.956846,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.957480,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.956700,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.957946,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.957363,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.958853,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.958719,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.9605460,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.9605940,
            mass_uncertainty=0.0000018,
            abundance=0.373,
            abundance_uncertainty=0.002,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.9626050,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.9629264,
            mass_uncertainty=0.0000018,
            abundance=0.627,
            abundance_uncertainty=0.002,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.9650784,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.9659796,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.968400,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.969653,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.97228,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.973800,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        )
    ]
)
Elements['Ir'] = Ir


Pt = Element(
    symbol="Pt",
    atomic_number=78,
    atomic_weight=195.084,
    atomic_weight_uncertainty=0.009,
    vdw_radius=175. * Picometers,
    ionization_energies=[870. * KilojoulesPerMole, 1791. * KilojoulesPerMole],
    electronegativity=2.28,
    isotopes=[
        Isotope(
            mass=165.99486,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=166,
            special_symbol=None
        ),
        Isotope(
            mass=166.99298,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=167,
            special_symbol=None
        ),
        Isotope(
            mass=167.98815,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=168,
            special_symbol=None
        ),
        Isotope(
            mass=168.98672,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.982495,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.981240,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.977347,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.976440,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.972819,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.972421,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.968945,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.968469,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.965649,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.965363,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.963031,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.963097,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.961171,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.961597,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.959922,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.960620,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.959351,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.960590,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.959395,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.960834,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.959932,
            mass_uncertainty=0.000006,
            abundance=0.00014,
            abundance_uncertainty=0.00001,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.961677,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.9610380,
            mass_uncertainty=0.0000027,
            abundance=0.00782,
            abundance_uncertainty=0.00007,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.9629874,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.9626803,
            mass_uncertainty=0.0000009,
            abundance=0.32967,
            abundance_uncertainty=0.00099,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.9647911,
            mass_uncertainty=0.0000009,
            abundance=0.33832,
            abundance_uncertainty=0.00010,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.9649515,
            mass_uncertainty=0.0000009,
            abundance=0.25242,
            abundance_uncertainty=0.00041,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.9673402,
            mass_uncertainty=0.0000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.967893,
            mass_uncertainty=0.000003,
            abundance=0.07163,
            abundance_uncertainty=0.00055,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.970593,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.971441,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.974510,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.97574,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        )
    ]
)
Elements['Pt'] = Pt


Au = Element(
    symbol="Au",
    atomic_number=79,
    atomic_weight=196.966569,
    atomic_weight_uncertainty=0.000004,
    vdw_radius=166. * Picometers,
    ionization_energies=[890.1 * KilojoulesPerMole, 1980. * KilojoulesPerMole],
    electronegativity=2.54,
    isotopes=[
        Isotope(
            mass=168.99808,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=169,
            special_symbol=None
        ),
        Isotope(
            mass=169.99612,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=170,
            special_symbol=None
        ),
        Isotope(
            mass=170.991879,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.99004,
            mass_uncertainty=0.00017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.986237,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.98476,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.981270,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.98010,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.976865,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.976030,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.973213,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.972521,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.970079,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.969618,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.967593,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.967452,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.965789,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.965953,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.964568,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.965324,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.963948,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.964700,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.963700,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.964813,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.964150,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.965365,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.9650346,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.966570,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.9665687,
            mass_uncertainty=0.0000006,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.9682423,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.9687652,
            mass_uncertainty=0.0000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.970730,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.971657,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.97381,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.975155,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.97772,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.97987,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        )
    ]
)
Elements['Au'] = Au


Hg = Element(
    symbol="Hg",
    atomic_number=80,
    atomic_weight=200.59,
    atomic_weight_uncertainty=0.02,
    vdw_radius=155. * Picometers,
    ionization_energies=[1007.1 * KilojoulesPerMole, 1810. * KilojoulesPerMole, 3300. * KilojoulesPerMole],
    electronegativity=2.,
    isotopes=[
        Isotope(
            mass=171.00376,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=171,
            special_symbol=None
        ),
        Isotope(
            mass=171.99883,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=172,
            special_symbol=None
        ),
        Isotope(
            mass=172.99724,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=173,
            special_symbol=None
        ),
        Isotope(
            mass=173.992864,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=174,
            special_symbol=None
        ),
        Isotope(
            mass=174.99142,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=175,
            special_symbol=None
        ),
        Isotope(
            mass=175.987355,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.986280,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.982483,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.981834,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.978266,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.977819,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.974690,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.974450,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.971713,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.971899,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.969362,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.969814,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.967577,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.968190,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.966322,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.967157,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.965634,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.966665,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.965439,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.966720,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.965833,
            mass_uncertainty=0.000003,
            abundance=0.0015,
            abundance_uncertainty=0.0001,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.967213,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.9667690,
            mass_uncertainty=0.0000004,
            abundance=0.0997,
            abundance_uncertainty=0.0020,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.9682799,
            mass_uncertainty=0.0000004,
            abundance=0.1687,
            abundance_uncertainty=0.0022,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.9683260,
            mass_uncertainty=0.0000004,
            abundance=0.2310,
            abundance_uncertainty=0.0019,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.9703023,
            mass_uncertainty=0.0000006,
            abundance=0.1318,
            abundance_uncertainty=0.0009,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.9706430,
            mass_uncertainty=0.0000006,
            abundance=0.2986,
            abundance_uncertainty=0.0026,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.9728725,
            mass_uncertainty=0.0000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.9734939,
            mass_uncertainty=0.0000004,
            abundance=0.0687,
            abundance_uncertainty=0.0015,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.976073,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.977514,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.98259,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.98594,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.99104,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.99451,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        )
    ]
)
Elements['Hg'] = Hg


Tl = Element(
    symbol="Tl",
    atomic_number=81,
    atomic_weight=204.3833,
    atomic_weight_uncertainty=0.0002,
    vdw_radius=196. * Picometers,
    ionization_energies=[589.4 * KilojoulesPerMole, 1971. * KilojoulesPerMole, 2878. * KilojoulesPerMole],
    electronegativity=1.62,
    isotopes=[
        Isotope(
            mass=176.00059,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=176,
            special_symbol=None
        ),
        Isotope(
            mass=176.996427,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=177,
            special_symbol=None
        ),
        Isotope(
            mass=177.99490,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=178.991090,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.98991,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.986257,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.985670,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.982193,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.981870,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.978790,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.97833,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.975906,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.976010,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.973588,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.973880,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.971786,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.972230,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.97067,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.97120,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.969774,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.970481,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.969575,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.970480,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.969880,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.970963,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.970819,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.972106,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.9723442,
            mass_uncertainty=0.0000014,
            abundance=0.2952,
            abundance_uncertainty=0.0001,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.9738635,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.9744275,
            mass_uncertainty=0.0000014,
            abundance=0.7048,
            abundance_uncertainty=0.0001,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.9761103,
            mass_uncertainty=0.0000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.977419,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.9820187,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.985359,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.990074,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.99348,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.99823,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        )
    ]
)
Elements['Tl'] = Tl


Pb = Element(
    symbol="Pb",
    atomic_number=82,
    atomic_weight=207.2,
    atomic_weight_uncertainty=0.1,
    vdw_radius=202. * Picometers,
    ionization_energies=[715.6 * KilojoulesPerMole, 1450.5 * KilojoulesPerMole, 3081.5 * KilojoulesPerMole, 4083. * KilojoulesPerMole, 6640. * KilojoulesPerMole],
    electronegativity=2.33,
    isotopes=[
        Isotope(
            mass=178.003830,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=178,
            special_symbol=None
        ),
        Isotope(
            mass=179.00215,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=179,
            special_symbol=None
        ),
        Isotope(
            mass=179.997918,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=180,
            special_symbol=None
        ),
        Isotope(
            mass=180.99662,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=181,
            special_symbol=None
        ),
        Isotope(
            mass=181.992672,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=182,
            special_symbol=None
        ),
        Isotope(
            mass=182.991870,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=183,
            special_symbol=None
        ),
        Isotope(
            mass=183.988142,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.987610,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.984239,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.983918,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.980874,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.980810,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.978082,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.978270,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.975785,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.976170,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.974012,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.974542,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.972774,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.973431,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.972034,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.972917,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.971827,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.972885,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.972159,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.973391,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.9730436,
            mass_uncertainty=0.0000013,
            abundance=0.014,
            abundance_uncertainty=0.001,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.9744818,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.9744653,
            mass_uncertainty=0.0000013,
            abundance=0.241,
            abundance_uncertainty=0.001,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.9758969,
            mass_uncertainty=0.0000013,
            abundance=0.221,
            abundance_uncertainty=0.001,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.9766521,
            mass_uncertainty=0.0000013,
            abundance=0.524,
            abundance_uncertainty=0.001,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.9810901,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.9841885,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.9887370,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.9918975,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.996581,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.9998054,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.00481,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        )
    ]
)
Elements['Pb'] = Pb


Bi = Element(
    symbol="Bi",
    atomic_number=83,
    atomic_weight=208.98040,
    atomic_weight_uncertainty=0.00001,
    ionization_energies=[703. * KilojoulesPerMole, 1610. * KilojoulesPerMole, 2466. * KilojoulesPerMole, 4370. * KilojoulesPerMole, 5400. * KilojoulesPerMole, 8520. * KilojoulesPerMole],
    electronegativity=2.02,
    isotopes=[
        Isotope(
            mass=184.00112,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=184,
            special_symbol=None
        ),
        Isotope(
            mass=184.997630,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=185,
            special_symbol=None
        ),
        Isotope(
            mass=185.996600,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=186,
            special_symbol=None
        ),
        Isotope(
            mass=186.993158,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=187,
            special_symbol=None
        ),
        Isotope(
            mass=187.992270,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.989200,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.98830,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.985786,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.985460,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.982960,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.982830,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.980651,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.980667,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.978864,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.979210,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.977672,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.978132,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.977009,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.977742,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.976876,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.977813,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.977389,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.978499,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.9784707,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.9797422,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.9803987,
            mass_uncertainty=0.0000016,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.9841204,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.987269,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.9912857,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.994385,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.998712,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.001770,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.006306,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.00947,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.01432,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        )
    ]
)
Elements['Bi'] = Bi


Po = Element(
    symbol="Po",
    atomic_number=84,
    atomic_weight=209,
    is_synthetic=True,
    ionization_energies=[812.1 * KilojoulesPerMole],
    electronegativity=2.,
    isotopes=[
        Isotope(
            mass=187.999422,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=188,
            special_symbol=None
        ),
        Isotope(
            mass=188.998481,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=189,
            special_symbol=None
        ),
        Isotope(
            mass=189.995101,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=190,
            special_symbol=None
        ),
        Isotope(
            mass=190.994574,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=191,
            special_symbol=None
        ),
        Isotope(
            mass=191.991335,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=192,
            special_symbol=None
        ),
        Isotope(
            mass=192.991030,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.988186,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.988110,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.985535,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.985660,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.983389,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.983666,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.981799,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.982260,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.980758,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.981420,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.980318,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.981203,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.980481,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.981593,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.9812457,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.9824304,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.9828737,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.9866532,
            mass_uncertainty=0.0000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.9888680,
            mass_uncertainty=0.0000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.992857,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.9952014,
            mass_uncertainty=0.0000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=214.9994200,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.0019150,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.006335,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.0089730,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.01374,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.01660,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        )
    ]
)
Elements['Po'] = Po


At = Element(
    symbol="At",
    atomic_number=85,
    atomic_weight=210,
    is_synthetic=True,
    ionization_energies=[920. * KilojoulesPerMole],
    electronegativity=2.2,
    isotopes=[
        Isotope(
            mass=192.999840,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=193,
            special_symbol=None
        ),
        Isotope(
            mass=193.99873,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=194,
            special_symbol=None
        ),
        Isotope(
            mass=194.996268,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=195.995790,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=196.993190,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.992840,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.990530,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.990351,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.988417,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.988630,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.986942,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.987251,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.986074,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.986667,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.985784,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.986590,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.986173,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.987148,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.9874963,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.990745,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.992937,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.996372,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=214.998653,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.002423,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.004719,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.008694,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.011162,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.015410,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.01805,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.02233,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.02519,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        )
    ]
)
Elements['At'] = At


Rn = Element(
    symbol="Rn",
    atomic_number=86,
    atomic_weight=222,
    is_synthetic=True,
    ionization_energies=[1037. * KilojoulesPerMole],
    isotopes=[
        Isotope(
            mass=195.005440,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=195,
            special_symbol=None
        ),
        Isotope(
            mass=196.002115,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=196,
            special_symbol=None
        ),
        Isotope(
            mass=197.001580,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=197,
            special_symbol=None
        ),
        Isotope(
            mass=197.998679,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=198,
            special_symbol=None
        ),
        Isotope(
            mass=198.998370,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=199.995699,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=200.995630,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=201.993263,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=202.993387,
            mass_uncertainty=0.000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=203.991429,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.991720,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.990214,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.990734,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.989642,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.990415,
            mass_uncertainty=0.000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.989696,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.990601,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.990704,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.993883,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.995363,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=214.998745,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.000274,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.003928,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.0056013,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.0094802,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.0113940,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.015537,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.0175777,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.02179,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.02409,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.02844,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.03089,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.03541,
            mass_uncertainty=0.00045,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.03799,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        )
    ]
)
Elements['Rn'] = Rn


Fr = Element(
    symbol="Fr",
    atomic_number=87,
    atomic_weight=223,
    is_synthetic=True,
    ionization_energies=[380. * KilojoulesPerMole],
    electronegativity=0.7,
    isotopes=[
        Isotope(
            mass=199.007260,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=199,
            special_symbol=None
        ),
        Isotope(
            mass=200.006570,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=200,
            special_symbol=None
        ),
        Isotope(
            mass=201.003860,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=201,
            special_symbol=None
        ),
        Isotope(
            mass=202.003370,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=203.000925,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=204.000653,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=204.998594,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=205.998670,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=206.996950,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=207.997140,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=208.995954,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=209.996408,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=210.995537,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.996202,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=212.996189,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=213.998971,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.000341,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.003198,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.004632,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.007578,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.009252,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.012327,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.014255,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.017552,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.0197359,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.023250,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.025570,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.02939,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.03184,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.03573,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.038450,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.04251,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.04544,
            mass_uncertainty=0.00050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.04977,
            mass_uncertainty=0.00069,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        )
    ]
)
Elements['Fr'] = Fr


Ra = Element(
    symbol="Ra",
    atomic_number=88,
    atomic_weight=226,
    is_synthetic=True,
    ionization_energies=[509.3 * KilojoulesPerMole, 979. * KilojoulesPerMole],
    electronegativity=0.9,
    isotopes=[
        Isotope(
            mass=202.009890,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=202,
            special_symbol=None
        ),
        Isotope(
            mass=203.009270,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=203,
            special_symbol=None
        ),
        Isotope(
            mass=204.006500,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=204,
            special_symbol=None
        ),
        Isotope(
            mass=205.006270,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=205,
            special_symbol=None
        ),
        Isotope(
            mass=206.003827,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=207.003800,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=208.001840,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=209.001990,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=210.000495,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=211.000898,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=211.999794,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=213.000384,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=214.000108,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.002720,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.003533,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.006320,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.007140,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.010085,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.011028,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.013917,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.015375,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.0185022,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.0202118,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.023612,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.0254098,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.0291778,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.0310703,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.034958,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.037056,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.04122,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.04364,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.04806,
            mass_uncertainty=0.00050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.05070,
            mass_uncertainty=0.00053,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        )
    ]
)
Elements['Ra'] = Ra


Ac = Element(
    symbol="Ac",
    atomic_number=89,
    atomic_weight=227,
    is_synthetic=True,
    ionization_energies=[499. * KilojoulesPerMole, 1170. * KilojoulesPerMole],
    electronegativity=1.1,
    isotopes=[
        Isotope(
            mass=206.014500,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=206,
            special_symbol=None
        ),
        Isotope(
            mass=207.011950,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=207,
            special_symbol=None
        ),
        Isotope(
            mass=208.011550,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=208,
            special_symbol=None
        ),
        Isotope(
            mass=209.009490,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=210.009440,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=211.007730,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=212.007810,
            mass_uncertainty=0.000070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=213.006610,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=214.006902,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.006454,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.008720,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.009347,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.011640,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.012420,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.014763,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.015590,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.017844,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.019137,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.021723,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.023230,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.026098,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.0277521,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.0310211,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.033020,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.03629,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.03856,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.04203,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.04455,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.04842,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.05123,
            mass_uncertainty=0.00038,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.05530,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        )
    ]
)
Elements['Ac'] = Ac


Th = Element(
    symbol="Th",
    atomic_number=90,
    atomic_weight=232.03806,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[587. * KilojoulesPerMole, 1110. * KilojoulesPerMole, 1930. * KilojoulesPerMole, 2780. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=209.01772,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=209,
            special_symbol=None
        ),
        Isotope(
            mass=210.015075,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=210,
            special_symbol=None
        ),
        Isotope(
            mass=211.014930,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=211,
            special_symbol=None
        ),
        Isotope(
            mass=212.012980,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=213.013010,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=214.011500,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.011730,
            mass_uncertainty=0.000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.011062,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.013114,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.013284,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.015540,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.015748,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.018184,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.018468,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.020811,
            mass_uncertainty=0.000010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.021467,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.023951,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.024903,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.0277041,
            mass_uncertainty=0.0000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.0287411,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.031762,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.0331338,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.0363043,
            mass_uncertainty=0.0000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.0380553,
            mass_uncertainty=0.0000021,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.0415818,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.043601,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.047510,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.04987,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.05389,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.05650,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        )
    ]
)
Elements['Th'] = Th


Pa = Element(
    symbol="Pa",
    atomic_number=91,
    atomic_weight=231.03588,
    atomic_weight_uncertainty=0.00002,
    ionization_energies=[568. * KilojoulesPerMole],
    electronegativity=1.5,
    isotopes=[
        Isotope(
            mass=212.023200,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=212,
            special_symbol=None
        ),
        Isotope(
            mass=213.021110,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=213,
            special_symbol=None
        ),
        Isotope(
            mass=214.020920,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=214,
            special_symbol=None
        ),
        Isotope(
            mass=215.019190,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=215,
            special_symbol=None
        ),
        Isotope(
            mass=216.019110,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=216,
            special_symbol=None
        ),
        Isotope(
            mass=217.018320,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.020042,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.019880,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.021880,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.021880,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.023740,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.023960,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.025626,
            mass_uncertainty=0.000017,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.026130,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.027948,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.028805,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.031051,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.0320968,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.034541,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.0358840,
            mass_uncertainty=0.0000024,
            abundance=1.0000,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.038592,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.0402473,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.043308,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.045440,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.04868,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.05115,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.054500,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.05726,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.06098,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        )
    ]
)
Elements['Pa'] = Pa


U = Element(
    symbol="U",
    atomic_number=92,
    atomic_weight=238.02891,
    atomic_weight_uncertainty=0.00003,
    vdw_radius=186. * Picometers,
    ionization_energies=[597.6 * KilojoulesPerMole, 1420. * KilojoulesPerMole],
    electronegativity=1.38,
    isotopes=[
        Isotope(
            mass=217.024370,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=217,
            special_symbol=None
        ),
        Isotope(
            mass=218.023540,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=218,
            special_symbol=None
        ),
        Isotope(
            mass=219.024920,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=219,
            special_symbol=None
        ),
        Isotope(
            mass=220.02472,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=220,
            special_symbol=None
        ),
        Isotope(
            mass=221.02640,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=221,
            special_symbol=None
        ),
        Isotope(
            mass=222.02609,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=222,
            special_symbol=None
        ),
        Isotope(
            mass=223.027740,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=223,
            special_symbol=None
        ),
        Isotope(
            mass=224.027605,
            mass_uncertainty=0.000027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=224,
            special_symbol=None
        ),
        Isotope(
            mass=225.029391,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.029339,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.031156,
            mass_uncertainty=0.000018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.031374,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.033506,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.033940,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.036294,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.0371562,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.0396352,
            mass_uncertainty=0.0000029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.0409521,
            mass_uncertainty=0.0000020,
            abundance=0.000054,
            abundance_uncertainty=0.000005,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.0439299,
            mass_uncertainty=0.0000020,
            abundance=0.007204,
            abundance_uncertainty=0.000006,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.0455680,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.0487302,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.0507882,
            mass_uncertainty=0.0000020,
            abundance=0.992742,
            abundance_uncertainty=0.000010,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.0542933,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.056592,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.06033,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.06293,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        )
    ]
)
Elements['U'] = U


Np = Element(
    symbol="Np",
    atomic_number=93,
    atomic_weight=237,
    is_synthetic=True,
    ionization_energies=[604.5 * KilojoulesPerMole],
    electronegativity=1.36,
    isotopes=[
        Isotope(
            mass=225.033910,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=225,
            special_symbol=None
        ),
        Isotope(
            mass=226.03515,
            mass_uncertainty=0.00010,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=226,
            special_symbol=None
        ),
        Isotope(
            mass=227.034960,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=227,
            special_symbol=None
        ),
        Isotope(
            mass=228.03618,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.036260,
            mass_uncertainty=0.000090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.037830,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.038250,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.04011,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.040740,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.042895,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.0440633,
            mass_uncertainty=0.0000021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.046570,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.0481734,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.0509464,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.0529390,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.056162,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.058250,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.06164,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.064280,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.06785,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        )
    ]
)
Elements['Np'] = Np


Pu = Element(
    symbol="Pu",
    atomic_number=94,
    atomic_weight=244,
    is_synthetic=True,
    ionization_energies=[584.7 * KilojoulesPerMole],
    electronegativity=1.28,
    isotopes=[
        Isotope(
            mass=228.038740,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=228,
            special_symbol=None
        ),
        Isotope(
            mass=229.040150,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=229,
            special_symbol=None
        ),
        Isotope(
            mass=230.039650,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=230,
            special_symbol=None
        ),
        Isotope(
            mass=231.041101,
            mass_uncertainty=0.000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.041187,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.043000,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.043317,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.045286,
            mass_uncertainty=0.000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.0460580,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.0484097,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.0495599,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.0521634,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.0538135,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.0568515,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.0587426,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.062003,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.064204,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.067747,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.070205,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.07407,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        )
    ]
)
Elements['Pu'] = Pu


Am = Element(
    symbol="Am",
    atomic_number=95,
    atomic_weight=243,
    is_synthetic=True,
    ionization_energies=[578. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=231.04556,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=231,
            special_symbol=None
        ),
        Isotope(
            mass=232.04659,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=232,
            special_symbol=None
        ),
        Isotope(
            mass=233.04635,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.04781,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.04795,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.04958,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.050000,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.051980,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.0530245,
            mass_uncertainty=0.0000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.055300,
            mass_uncertainty=0.000015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.0568291,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.0595492,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.0613811,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.0642848,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.066452,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.069775,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.07209,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.07575,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.07848,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        )
    ]
)
Elements['Am'] = Am


Cm = Element(
    symbol="Cm",
    atomic_number=96,
    atomic_weight=247,
    is_synthetic=True,
    ionization_energies=[581. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=233.050770,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=233,
            special_symbol=None
        ),
        Isotope(
            mass=234.050160,
            mass_uncertainty=0.000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=234,
            special_symbol=None
        ),
        Isotope(
            mass=235.05143,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.05141,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.05290,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.053030,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.05496,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.0555295,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.0576530,
            mass_uncertainty=0.0000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.0588358,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.0613891,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.0627526,
            mass_uncertainty=0.0000020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.0654912,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.0672237,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.070354,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.072349,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.075953,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.078357,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.082285,
            mass_uncertainty=0.000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.08487,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        )
    ]
)
Elements['Cm'] = Cm


Bk = Element(
    symbol="Bk",
    atomic_number=97,
    atomic_weight=247,
    is_synthetic=True,
    ionization_energies=[601. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=235.05658,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=235,
            special_symbol=None
        ),
        Isotope(
            mass=236.05733,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=236,
            special_symbol=None
        ),
        Isotope(
            mass=237.05700,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.05828,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.05828,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.05976,
            mass_uncertainty=0.00016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.06023,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.06198,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.063008,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.065181,
            mass_uncertainty=0.000016,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.0663616,
            mass_uncertainty=0.0000025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.068670,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.070307,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.073090,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.0749867,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.078317,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.080760,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.08431,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.08688,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.09060,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        )
    ]
)
Elements['Bk'] = Bk


Cf = Element(
    symbol="Cf",
    atomic_number=98,
    atomic_weight=251,
    is_synthetic=True,
    ionization_energies=[608. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=237.06207,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=237,
            special_symbol=None
        ),
        Isotope(
            mass=238.06141,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=238,
            special_symbol=None
        ),
        Isotope(
            mass=239.06242,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=239,
            special_symbol=None
        ),
        Isotope(
            mass=240.06230,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.06373,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.063700,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.06543,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.066001,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.068049,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.0688053,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.071001,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.072185,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.0748535,
            mass_uncertainty=0.0000024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.0764061,
            mass_uncertainty=0.0000022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.079587,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.081626,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.085133,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.087323,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.09105,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.09344,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        )
    ]
)
Elements['Cf'] = Cf


Es = Element(
    symbol="Es",
    atomic_number=99,
    atomic_weight=252,
    is_synthetic=True,
    ionization_energies=[619. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=240.06892,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=240,
            special_symbol=None
        ),
        Isotope(
            mass=241.06854,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=241,
            special_symbol=None
        ),
        Isotope(
            mass=242.06975,
            mass_uncertainty=0.00035,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.06955,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.07088,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.07132,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.07290,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.073660,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.075470,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.076410,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.07861,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.079992,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.082980,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.0848247,
            mass_uncertainty=0.0000028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.088022,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.090273,
            mass_uncertainty=0.000012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.09360,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.09598,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.09952,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        )
    ]
)
Elements['Es'] = Es


Fm = Element(
    symbol="Fm",
    atomic_number=100,
    atomic_weight=257,
    is_synthetic=True,
    ionization_energies=[627. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=242.07343,
            mass_uncertainty=0.00043,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=242,
            special_symbol=None
        ),
        Isotope(
            mass=243.07435,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=243,
            special_symbol=None
        ),
        Isotope(
            mass=244.07408,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=244,
            special_symbol=None
        ),
        Isotope(
            mass=245.07539,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.075300,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.07685,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.077195,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.07903,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.079521,
            mass_uncertainty=0.000013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.081575,
            mass_uncertainty=0.000009,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.082467,
            mass_uncertainty=0.000006,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.085185,
            mass_uncertainty=0.000004,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.0868542,
            mass_uncertainty=0.0000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.089962,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.091773,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.095105,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.09708,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.10060,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.10268,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        )
    ]
)
Elements['Fm'] = Fm


Md = Element(
    symbol="Md",
    atomic_number=101,
    atomic_weight=258,
    is_synthetic=True,
    ionization_energies=[635. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=245.08083,
            mass_uncertainty=0.00035,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=245,
            special_symbol=None
        ),
        Isotope(
            mass=246.08189,
            mass_uncertainty=0.00035,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=246,
            special_symbol=None
        ),
        Isotope(
            mass=247.08164,
            mass_uncertainty=0.00035,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=247,
            special_symbol=None
        ),
        Isotope(
            mass=248.08282,
            mass_uncertainty=0.00026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.08301,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.08442,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.08484,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.08656,
            mass_uncertainty=0.00021,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.08728,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.08966,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.091083,
            mass_uncertainty=0.000007,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.094060,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.095541,
            mass_uncertainty=0.000003,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.098431,
            mass_uncertainty=0.000005,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.10051,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.10365,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.10572,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.10887,
            mass_uncertainty=0.00063,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        )
    ]
)
Elements['Md'] = Md


No = Element(
    symbol="No",
    atomic_number=102,
    atomic_weight=259,
    is_synthetic=True,
    ionization_energies=[642. * KilojoulesPerMole],
    electronegativity=1.3,
    isotopes=[
        Isotope(
            mass=248.08660,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=248,
            special_symbol=None
        ),
        Isotope(
            mass=249.08783,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=249,
            special_symbol=None
        ),
        Isotope(
            mass=250.08751,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=250,
            special_symbol=None
        ),
        Isotope(
            mass=251.08901,
            mass_uncertainty=0.00019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.088977,
            mass_uncertainty=0.000014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.09068,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.090955,
            mass_uncertainty=0.000019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.093241,
            mass_uncertainty=0.000011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.094283,
            mass_uncertainty=0.000008,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.096877,
            mass_uncertainty=0.000023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.09821,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.10103,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.10264,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.10575,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.10730,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.11055,
            mass_uncertainty=0.00053,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.11235,
            mass_uncertainty=0.00069,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        )
    ]
)
Elements['No'] = No


Lr = Element(
    symbol="Lr",
    atomic_number=103,
    atomic_weight=262,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=251.09436,
            mass_uncertainty=0.00032,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=251,
            special_symbol=None
        ),
        Isotope(
            mass=252.09537,
            mass_uncertainty=0.00027,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=252,
            special_symbol=None
        ),
        Isotope(
            mass=253.09521,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.09645,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.09668,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.09863,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.09956,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.10181,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.102900,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.10550,
            mass_uncertainty=0.00012,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.10688,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.10963,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.11129,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.11404,
            mass_uncertainty=0.00047,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.11584,
            mass_uncertainty=0.00077,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.11931,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        )
    ]
)
Elements['Lr'] = Lr


Rf = Element(
    symbol="Rf",
    atomic_number=104,
    atomic_weight=265,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=253.10069,
            mass_uncertainty=0.00049,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=253,
            special_symbol=None
        ),
        Isotope(
            mass=254.10018,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=254,
            special_symbol=None
        ),
        Isotope(
            mass=255.10134,
            mass_uncertainty=0.00019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.101166,
            mass_uncertainty=0.000026,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.10299,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.10349,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.105640,
            mass_uncertainty=0.000080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.10644,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.108770,
            mass_uncertainty=0.000030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.10993,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.11255,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.11399,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.11670,
            mass_uncertainty=0.00046,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.11796,
            mass_uncertainty=0.00058,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.12153,
            mass_uncertainty=0.00062,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.12364,
            mass_uncertainty=0.00076,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        )
    ]
)
Elements['Rf'] = Rf


Db = Element(
    symbol="Db",
    atomic_number=105,
    atomic_weight=268,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=255.10740,
            mass_uncertainty=0.00045,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=255,
            special_symbol=None
        ),
        Isotope(
            mass=256.10813,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=256,
            special_symbol=None
        ),
        Isotope(
            mass=257.10772,
            mass_uncertainty=0.00024,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=257,
            special_symbol=None
        ),
        Isotope(
            mass=258.10923,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.10961,
            mass_uncertainty=0.00023,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.11130,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.11206,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.11408,
            mass_uncertainty=0.00020,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.11499,
            mass_uncertainty=0.00018,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.11740,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.11860,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.12103,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.12238,
            mass_uncertainty=0.00050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.12545,
            mass_uncertainty=0.00057,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.12746,
            mass_uncertainty=0.00083,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.13071,
            mass_uncertainty=0.00077,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        )
    ]
)
Elements['Db'] = Db


Sg = Element(
    symbol="Sg",
    atomic_number=106,
    atomic_weight=271,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=258.11317,
            mass_uncertainty=0.00045,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=258,
            special_symbol=None
        ),
        Isotope(
            mass=259.11450,
            mass_uncertainty=0.00019,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=259,
            special_symbol=None
        ),
        Isotope(
            mass=260.114420,
            mass_uncertainty=0.000040,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.11612,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.11640,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.11832,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.11893,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.121110,
            mass_uncertainty=0.000060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.12207,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.12443,
            mass_uncertainty=0.00029,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.12561,
            mass_uncertainty=0.00058,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.12876,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.13033,
            mass_uncertainty=0.00066,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        ),
        Isotope(
            mass=271.13347,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=271,
            special_symbol=None
        ),
        Isotope(
            mass=272.13516,
            mass_uncertainty=0.00082,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.13822,
            mass_uncertainty=0.00071,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        )
    ]
)
Elements['Sg'] = Sg


Bh = Element(
    symbol="Bh",
    atomic_number=107,
    atomic_weight=272,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=260.12197,
            mass_uncertainty=0.00062,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=260,
            special_symbol=None
        ),
        Isotope(
            mass=261.12166,
            mass_uncertainty=0.00025,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=261,
            special_symbol=None
        ),
        Isotope(
            mass=262.12289,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=262,
            special_symbol=None
        ),
        Isotope(
            mass=263.12304,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.12460,
            mass_uncertainty=0.00030,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.12515,
            mass_uncertainty=0.00041,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.12694,
            mass_uncertainty=0.00022,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.12765,
            mass_uncertainty=0.00028,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.12976,
            mass_uncertainty=0.00041,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.13069,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.13362,
            mass_uncertainty=0.00050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        ),
        Isotope(
            mass=271.13518,
            mass_uncertainty=0.00060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=271,
            special_symbol=None
        ),
        Isotope(
            mass=272.13803,
            mass_uncertainty=0.00065,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.13962,
            mass_uncertainty=0.00089,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        ),
        Isotope(
            mass=274.14244,
            mass_uncertainty=0.00084,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=274,
            special_symbol=None
        ),
        Isotope(
            mass=275.14425,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=275,
            special_symbol=None
        )
    ]
)
Elements['Bh'] = Bh


Hs = Element(
    symbol="Hs",
    atomic_number=108,
    atomic_weight=270,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=263.12856,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=263,
            special_symbol=None
        ),
        Isotope(
            mass=264.128390,
            mass_uncertainty=0.000050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=264,
            special_symbol=None
        ),
        Isotope(
            mass=265.13009,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.13010,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.13179,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.13216,
            mass_uncertainty=0.00044,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.13406,
            mass_uncertainty=0.00013,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.13465,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        ),
        Isotope(
            mass=271.13766,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=271,
            special_symbol=None
        ),
        Isotope(
            mass=272.13905,
            mass_uncertainty=0.00062,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.14199,
            mass_uncertainty=0.00089,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        ),
        Isotope(
            mass=274.14313,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=274,
            special_symbol=None
        ),
        Isotope(
            mass=275.14595,
            mass_uncertainty=0.00077,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=275,
            special_symbol=None
        ),
        Isotope(
            mass=276.14721,
            mass_uncertainty=0.00089,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=276,
            special_symbol=None
        ),
        Isotope(
            mass=277.14984,
            mass_uncertainty=0.00078,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=277,
            special_symbol=None
        )
    ]
)
Elements['Hs'] = Hs


Mt = Element(
    symbol="Mt",
    atomic_number=109,
    atomic_weight=276,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=265.13615,
            mass_uncertainty=0.00050,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=265,
            special_symbol=None
        ),
        Isotope(
            mass=266.13730,
            mass_uncertainty=0.00037,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=266,
            special_symbol=None
        ),
        Isotope(
            mass=267.13731,
            mass_uncertainty=0.00058,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.13873,
            mass_uncertainty=0.00034,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.13906,
            mass_uncertainty=0.00059,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.14066,
            mass_uncertainty=0.00058,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        ),
        Isotope(
            mass=271.14114,
            mass_uncertainty=0.00061,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=271,
            special_symbol=None
        ),
        Isotope(
            mass=272.14374,
            mass_uncertainty=0.00052,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.14491,
            mass_uncertainty=0.00055,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        ),
        Isotope(
            mass=274.14749,
            mass_uncertainty=0.00060,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=274,
            special_symbol=None
        ),
        Isotope(
            mass=275.14865,
            mass_uncertainty=0.00064,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=275,
            special_symbol=None
        ),
        Isotope(
            mass=276.15116,
            mass_uncertainty=0.00073,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=276,
            special_symbol=None
        ),
        Isotope(
            mass=277.15242,
            mass_uncertainty=0.00095,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=277,
            special_symbol=None
        ),
        Isotope(
            mass=278.15481,
            mass_uncertainty=0.00090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=278,
            special_symbol=None
        ),
        Isotope(
            mass=279.15619,
            mass_uncertainty=0.00077,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=279,
            special_symbol=None
        )
    ]
)
Elements['Mt'] = Mt


Ds = Element(
    symbol="Ds",
    atomic_number=110,
    atomic_weight=281,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=267.14434,
            mass_uncertainty=0.00039,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=267,
            special_symbol=None
        ),
        Isotope(
            mass=268.14380,
            mass_uncertainty=0.00054,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=268,
            special_symbol=None
        ),
        Isotope(
            mass=269.14512,
            mass_uncertainty=0.00015,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=269,
            special_symbol=None
        ),
        Isotope(
            mass=270.14472,
            mass_uncertainty=0.00031,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=270,
            special_symbol=None
        ),
        Isotope(
            mass=271.14606,
            mass_uncertainty=0.00011,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=271,
            special_symbol=None
        ),
        Isotope(
            mass=272.14632,
            mass_uncertainty=0.00070,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.14886,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        ),
        Isotope(
            mass=274.14949,
            mass_uncertainty=0.00053,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=274,
            special_symbol=None
        ),
        Isotope(
            mass=275.15218,
            mass_uncertainty=0.00048,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=275,
            special_symbol=None
        ),
        Isotope(
            mass=276.15303,
            mass_uncertainty=0.00065,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=276,
            special_symbol=None
        ),
        Isotope(
            mass=277.15565,
            mass_uncertainty=0.00104,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=277,
            special_symbol=None
        ),
        Isotope(
            mass=278.15647,
            mass_uncertainty=0.00073,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=278,
            special_symbol=None
        ),
        Isotope(
            mass=279.15886,
            mass_uncertainty=0.00080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=279,
            special_symbol=None
        ),
        Isotope(
            mass=280.15980,
            mass_uncertainty=0.00091,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=280,
            special_symbol=None
        ),
        Isotope(
            mass=281.16206,
            mass_uncertainty=0.00078,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=281,
            special_symbol=None
        )
    ]
)
Elements['Ds'] = Ds


Rg = Element(
    symbol="Rg",
    atomic_number=111,
    atomic_weight=280,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=272.15362,
            mass_uncertainty=0.00036,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=272,
            special_symbol=None
        ),
        Isotope(
            mass=273.15368,
            mass_uncertainty=0.00065,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=273,
            special_symbol=None
        ),
        Isotope(
            mass=274.15571,
            mass_uncertainty=0.00066,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=274,
            special_symbol=None
        ),
        Isotope(
            mass=275.15614,
            mass_uncertainty=0.00074,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=275,
            special_symbol=None
        ),
        Isotope(
            mass=276.15849,
            mass_uncertainty=0.00067,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=276,
            special_symbol=None
        ),
        Isotope(
            mass=277.15952,
            mass_uncertainty=0.00066,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=277,
            special_symbol=None
        ),
        Isotope(
            mass=278.16160,
            mass_uncertainty=0.00068,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=278,
            special_symbol=None
        ),
        Isotope(
            mass=279.16247,
            mass_uncertainty=0.00071,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=279,
            special_symbol=None
        ),
        Isotope(
            mass=280.16447,
            mass_uncertainty=0.00080,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=280,
            special_symbol=None
        ),
        Isotope(
            mass=281.16537,
            mass_uncertainty=0.00100,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=281,
            special_symbol=None
        ),
        Isotope(
            mass=282.16749,
            mass_uncertainty=0.00095,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=282,
            special_symbol=None
        ),
        Isotope(
            mass=283.16842,
            mass_uncertainty=0.00084,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=283,
            special_symbol=None
        )
    ]
)
Elements['Rg'] = Rg


Cn = Element(
    symbol="Cn",
    atomic_number=112,
    atomic_weight=285,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=277.16394,
            mass_uncertainty=0.00014,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=277,
            special_symbol=None
        ),
        Isotope(
            mass=278.16431,
            mass_uncertainty=0.00057,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=278,
            special_symbol=None
        ),
        Isotope(
            mass=279.16655,
            mass_uncertainty=0.00053,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=279,
            special_symbol=None
        ),
        Isotope(
            mass=280.16704,
            mass_uncertainty=0.00069,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=280,
            special_symbol=None
        ),
        Isotope(
            mass=281.16929,
            mass_uncertainty=0.00106,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=281,
            special_symbol=None
        ),
        Isotope(
            mass=282.16977,
            mass_uncertainty=0.00076,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=282,
            special_symbol=None
        ),
        Isotope(
            mass=283.17179,
            mass_uncertainty=0.00083,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=283,
            special_symbol=None
        ),
        Isotope(
            mass=284.17238,
            mass_uncertainty=0.00091,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=284,
            special_symbol=None
        ),
        Isotope(
            mass=285.17411,
            mass_uncertainty=0.00078,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=285,
            special_symbol=None
        )
    ]
)
Elements['Cn'] = Cn


Uut = Element(
    symbol="Uut",
    atomic_number=113,
    atomic_weight=284,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=283.17645,
            mass_uncertainty=0.00078,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=283,
            special_symbol=None
        ),
        Isotope(
            mass=284.17808,
            mass_uncertainty=0.00086,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=284,
            special_symbol=None
        ),
        Isotope(
            mass=285.17873,
            mass_uncertainty=0.00105,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=285,
            special_symbol=None
        ),
        Isotope(
            mass=286.18048,
            mass_uncertainty=0.00101,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=286,
            special_symbol=None
        ),
        Isotope(
            mass=287.18105,
            mass_uncertainty=0.00090,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=287,
            special_symbol=None
        )
    ]
)
Elements['Uut'] = Uut


Uuq = Element(
    symbol="Uuq",
    atomic_number=114,
    atomic_weight=289,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=285.18370,
            mass_uncertainty=0.00111,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=285,
            special_symbol=None
        ),
        Isotope(
            mass=286.18386,
            mass_uncertainty=0.00083,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=286,
            special_symbol=None
        ),
        Isotope(
            mass=287.18560,
            mass_uncertainty=0.00083,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=287,
            special_symbol=None
        ),
        Isotope(
            mass=288.18569,
            mass_uncertainty=0.00091,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=288,
            special_symbol=None
        ),
        Isotope(
            mass=289.18728,
            mass_uncertainty=0.00079,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=289,
            special_symbol=None
        )
    ]
)
Elements['Uuq'] = Uuq


Uup = Element(
    symbol="Uup",
    atomic_number=115,
    atomic_weight=288,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=287.19119,
            mass_uncertainty=0.00085,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=287,
            special_symbol=None
        ),
        Isotope(
            mass=288.19249,
            mass_uncertainty=0.00092,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=288,
            special_symbol=None
        ),
        Isotope(
            mass=289.19272,
            mass_uncertainty=0.00110,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=289,
            special_symbol=None
        ),
        Isotope(
            mass=290.19414,
            mass_uncertainty=0.00106,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=290,
            special_symbol=None
        ),
        Isotope(
            mass=291.19438,
            mass_uncertainty=0.00095,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=291,
            special_symbol=None
        )
    ]
)
Elements['Uup'] = Uup


Uuh = Element(
    symbol="Uuh",
    atomic_number=116,
    atomic_weight=293,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=289.19886,
            mass_uncertainty=0.00117,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=289,
            special_symbol=None
        ),
        Isotope(
            mass=290.19859,
            mass_uncertainty=0.00091,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=290,
            special_symbol=None
        ),
        Isotope(
            mass=291.20001,
            mass_uncertainty=0.00091,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=291,
            special_symbol=None
        ),
        Isotope(
            mass=292.19979,
            mass_uncertainty=0.00092,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=292,
            special_symbol=None
        )
    ]
)
Elements['Uuh'] = Uuh


Uus = Element(
    symbol="Uus",
    atomic_number=117,
    atomic_weight=292,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=291.20656,
            mass_uncertainty=0.00095,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=291,
            special_symbol=None
        ),
        Isotope(
            mass=292.20755,
            mass_uncertainty=0.00101,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=292,
            special_symbol=None
        )
    ]
)
Elements['Uus'] = Uus


Uuo = Element(
    symbol="Uuo",
    atomic_number=118,
    atomic_weight=294,
    is_synthetic=True,
    ionization_energies=[],
    isotopes=[
        Isotope(
            mass=293.21467,
            mass_uncertainty=0.00129,
            abundance=None,
            abundance_uncertainty=None,
            mass_number=293,
            special_symbol=None
        )
    ]
)
Elements['Uuo'] = Uuo

