/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ComparableConstant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ConstantPoolSorter
extends SimplifiedVisitor
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private ComparableConstant[] comparableConstantPool = new ComparableConstant[256];
    private Constant[] newConstantPool = new Constant[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        int n;
        int n2 = programClass.u2constantPoolCount;
        if (this.constantIndexMap.length < n2) {
            this.constantIndexMap = new int[n2];
            this.comparableConstantPool = new ComparableConstant[n2];
            this.newConstantPool = new Constant[n2];
        }
        int n3 = 0;
        for (n = 1; n < n2; ++n) {
            Constant constant = programClass.constantPool[n];
            if (constant == null) continue;
            this.comparableConstantPool[n3++] = new ComparableConstant(programClass, n, constant);
        }
        Arrays.sort(this.comparableConstantPool, 0, n3);
        n = 1;
        int n4 = 1;
        ComparableConstant comparableConstant = null;
        for (int i = 0; i < n3; ++i) {
            ComparableConstant comparableConstant2 = this.comparableConstantPool[i];
            if (!comparableConstant2.equals(comparableConstant)) {
                n4 = n;
                Constant constant = comparableConstant2.getConstant();
                this.newConstantPool[n++] = constant;
                int n5 = constant.getTag();
                if (n5 == 5 || n5 == 6) {
                    this.newConstantPool[n++] = null;
                }
                comparableConstant = comparableConstant2;
            }
            this.constantIndexMap[comparableConstant2.getIndex()] = n4;
        }
        System.arraycopy(this.newConstantPool, 0, programClass.constantPool, 0, n);
        Arrays.fill(programClass.constantPool, n, n2, null);
        programClass.u2constantPoolCount = n;
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }
}

