/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _PLAYERSSETTINGS_H
#define _PLAYERSSETTINGS_H

#include <QWidget>
#include <QLabel>
#include <QLineEdit>
#include <QString>
#include <Plasma/Svg>
#include <QComboBox>
#include "theme.h"

class PlayersSettings : public QWidget {
	Q_OBJECT
	
	public:
		PlayersSettings( Plasma::Svg *, Theme, QWidget * = 0 );
		~PlayersSettings(){};
		
		void setName ( int, const QString & );
		QString name (int) const;
		
	private:
		QLabel *_lblTitle;
		QLabel *_icPlayer1;
		QLabel *_icPlayer2;
		QLabel *_lblPlayer1;
		QLabel *_lblPlayer2;
		QLineEdit *_lePlayer1;
		QLineEdit *_lePlayer2;
		Theme _currentTheme;
};

#endif
