/********************************************************************************
 *   Copyright (C) 2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#include "photosetdialog.h"

#include <QGroupBox>
#include <QLabel>
#include <QVBoxLayout>

#include <KListWidget>

using namespace Plasma;

PhotosetItem::PhotosetItem( const QString &p_text )
: QListWidgetItem( p_text )
{
}

PhotosetItem::~PhotosetItem()
{
}

QVariant PhotosetItem::data( int p_role ) const
{
  return p_role == s_photoset_id ? m_data : QListWidgetItem::data( p_role );
}

void PhotosetItem::setData( int p_role, const QVariant &p_data )
{
  if ( p_role == s_photoset_id)
  {
    m_data = p_data.toString();
  }
  else
  {
    QListWidgetItem::setData( p_role, p_data );
  }
}

PhotosetDialog::PhotosetDialog( QWidget *p_parent )
: KDialog( p_parent )
{
  QGroupBox *group = new QGroupBox( i18n( "Please select a photoset below:" ), this );
  QVBoxLayout *layout = new QVBoxLayout( group );

  m_list = new KListWidget( group );
  connect( m_list, SIGNAL( itemSelectionChanged() ), this, SLOT( photosetChosen() ) );
  m_list->setSelectionMode( QAbstractItemView::SingleSelection );
  m_list->setMinimumSize( 300, 500 );
  m_list->setSortingEnabled( true );
  layout->addWidget( m_list );

  setMainWidget( group );

  setButtons( KDialog::Ok | KDialog::Cancel );
  enableButtonOk( false );
}

PhotosetDialog::~PhotosetDialog()
{
}

void PhotosetDialog::addPhotosets( const DataEngine::Data &p_data )
{
  DataEngine::Data::const_iterator it = p_data.begin();
  for ( ; it != p_data.end(); ++it )
  {
    PhotosetItem *item = new PhotosetItem( it.value().toString() );
    item->setData( s_photoset_id, it.key() );
    m_list->addItem( item );
  }
}

void PhotosetDialog::reset()
{
  m_list->clear();
  enableButtonOk( false );
}

QString PhotosetDialog::photoset() const
{
  return m_list->currentItem()->data( s_photoset_id ).toString();
}

void PhotosetDialog::photosetChosen()
{
  enableButtonOk( true );
}
