/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_EGL_BACKEND_H__
#define __PGM_GLES_EGL_BACKEND_H__

#include <GLES/egl.h>
#include "pgmglesbackend.h"
#ifdef HAVE_TSLIB
#include <tslib.h>
#endif /* HAVE_TSLIB */

G_BEGIN_DECLS

#define PGM_TYPE_GLES_EGL_BACKEND (pgm_gles_egl_backend_get_type ())
#define PGM_GLES_EGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_EGL_BACKEND, PgmGlesEglBackend))
#define PGM_GLES_EGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_EGL_BACKEND, PgmGlesEglBackendClass))
#define PGM_IS_GLES_EGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_EGL_BACKEND))
#define PGM_IS_GLES_EGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_EGL_BACKEND))
#define PGM_GLES_EGL_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_EGL_BACKEND, PgmGlesEglBackendClass))

typedef struct _PgmGlesEglBackend       PgmGlesEglBackend;
typedef struct _PgmGlesEglBackendClass  PgmGlesEglBackendClass;

#ifdef HAVE_TSLIB
typedef struct _PgmGlesEglBackendSource PgmGlesEglBackendSource;
#endif /* HAVE_TSLIB */

struct _PgmGlesEglBackend {
  PgmGlesBackend parent;

  /* EGL structures */
  EGLDisplay display;
  EGLSurface surface;
  EGLContext context;

  /* EGL informations */
  const gchar *vendor;
  const gchar *extensions;
  const gchar *version;

  /* Display informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* Event source id */
  guint event_tag;

  /* States */
  gboolean created;
};

struct _PgmGlesEglBackendClass {
  PgmGlesBackendClass parent_class;
};

#ifdef HAVE_TSLIB
/* Touch screen event source */
struct _PgmGlesEglBackendSource {
  GSource source;
  GPollFD poll_fd;

  /* Touch screen device */
  struct tsdev *ts_device;

  /* Keep track of the backend */
  PgmGlesEglBackend *eglbackend;
};
#endif /* HAVE_TSLIB */

GType           pgm_gles_egl_backend_get_type (void) G_GNUC_CONST;

PgmGlesBackend *pgm_gles_egl_backend_new      (PgmGlesContext *glescontext);
void            pgm_gles_egl_backend_register (GTypeModule *module);

G_END_DECLS

#endif /* __PGM_GLES_EGL_BACKEND_H__ */
