/*
 * window_main_attachment.h
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PDFCHAIN_WINDOW_MAIN_ATTACHMENT_H__
#define __PDFCHAIN_WINDOW_MAIN_ATTACHMENT_H__

#include "pdfchain.h"
#include "store_attachment.h"
#include "dialog_filechooser.h"


/*** Tree View : Attachment ***************************************************/

class cTView_Attach : public Gtk::TreeView
{
	friend class cToolbar_Attach;
	friend class cSection_Attach;
	
	public:

		cTView_Attach( Gtk::Window& );
		virtual ~cTView_Attach();
		
		void clear();
		
	protected:

		Glib::RefPtr<cLStore_Attach>	rLStore_Attach;

		cTMCRecord_Attach* pTMCRecord_Attach;

		Gtk::TreeViewColumn     mTVColumn_AddPages,
		                        mTVColumn_AttachFile;			
		Gtk::CellRendererToggle mCRToggle_Add;
		Gtk::CellRendererText   mCRText_AttachFile;
#ifdef PDFCHAIN_TEMP
		Gtk::TreeViewColumn     mTVColumn_AttachPath,		//TEMP
		                        mTVColumn_AttachTooltip;	//TEMP
		Gtk::CellRendererText   mCRText_AttachPath,			//TEMP
		                        mCRText_AttachTooltip;		//TEMP
#endif
		
		void onCRToggle_Add_toggled( const Glib::ustring& str_path ) {
			rLStore_Attach->toggleAdd( Gtk::TreePath( str_path ) );
			return;
		}

		void onToolButton_Up_clicked() {		rLStore_Attach->moveRowsUp(		get_selection() );	return; }
		void onToolButton_Down_clicked() {		rLStore_Attach->moveRowsDown(	get_selection() );	return; }
		void onToolButton_Add_clicked() {		rLStore_Attach->addRows(		get_selection() );	return; }
		void onToolButton_Remove_clicked() {	rLStore_Attach->removeRows(		get_selection() );	return; }
};



/*** Toolbar : Attach **********************************************************/

class
cToolbar_Attach : public Gtk::Toolbar
{
	friend class cSection_Attach;
	
	public:

		cToolbar_Attach( cTView_Attach* );
		virtual ~cToolbar_Attach();
		
		void clear();

	protected:

		Glib::RefPtr<Gtk::Adjustment>	rAdjust_PageNumber;		// Declaration of Adjustment before SpinButton!
		Gtk::SpinButton					mSButton_PageNumber;
		Gtk::RadioToolButton::Group		mRTBGroup_AddTo;

		Gtk::ToolButton        mToolButton_Add,
		                       mToolButton_Remove,
		                       mToolButton_Up,
		                       mToolButton_Down;
		Gtk::RadioToolButton   mRTButton_AddToFile,
		                       mRTButton_AddToPage;
		Gtk::ToolItem          mToolItem_PageNumber;
		Gtk::SeparatorToolItem mSeparator_A,
		                       mSeparator_B,
		                       mSeparator_C;
		
		void onRTButton_AddToPage_toggled() {
			mSButton_PageNumber.set_sensitive( mRTButton_AddToPage.property_active() );
			return;
		}
};



/*** Section : Attach *********************************************************/

class
cSection_Attach : public Gtk::VBox
{
	public:

		cSection_Attach( Gtk::Window& );
		virtual ~cSection_Attach();

		void clear();
		std::string createCommand();

	protected:

		guint vPageNumbers;

		Gtk::HBox            mHBox_SourceFile;
		Gtk::Label           mLabel_SourceFile;
		cFCButton_Pdf        mFCButton_SourceFile;
		cTView_Attach        mTView_AttachFiles;
		cToolbar_Attach      mToolbar_AttachFiles;
		Gtk::ScrolledWindow  mSWindow_AttachFiles;
		cFCDialog_SaveAs_Pdf mFCDialog_SaveAs;

		void onFCButton_SourceFile_file_set() {
			vPageNumbers = Pdfchain::count_page_numbers( mFCButton_SourceFile.get_filename() );
			
			if ( 0 != vPageNumbers ) {
//				mToolbar_AttachFiles.mSButton_PageNumber.override_color( Pdfchain::Color::RGBA_VALID );
				mToolbar_AttachFiles.rAdjust_PageNumber->set_upper( static_cast<double>( vPageNumbers ) );

				if ( static_cast<guint>( mToolbar_AttachFiles.mSButton_PageNumber.get_value() ) > vPageNumbers ) {
					mToolbar_AttachFiles.mSButton_PageNumber.set_value( static_cast<double>( vPageNumbers ) );
				}
			}
			else {
//				mToolbar_AttachFiles.mSButton_PageNumber.override_color( Pdfchain::Color::RGBA_WARNING );
				mToolbar_AttachFiles.rAdjust_PageNumber->set_upper( Pdfchain::Attach::ADJUST_UPPER_PAGE_NUMBERS );
			}
			
			return;
		}
};

#endif
