/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkMarchingCubesPolygonCases.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkMarchingCubesPolygonCases.h"

//=============================================================================
// Edges to intersect hexes (i.e., structured grid) assuming a plane
// cut. Marching cubes case table modified to output general polygons (not
// just triangles). Basically because this is a plane cut situation,
// "connected" triangles are known to form (planar) polygons. Note the
// comments at end of line indicate marching cubes case number (0->255) and
// base case number (0->15).  The indices are like vtkCellArray.  That is
// the first number in the list is the number of points forming the
// polygon; followed by hexahedron edge ids. This repeats until a negative
// number appears.
//
static vtkMarchingCubesPolygonCases VTK_MARCHING_CUBES_POLYGONCASES[] = {
  { { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } }, // 0 0
  { { 3, 0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 1 1
  { { 3, 1, 0, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 2 1
  { { 4, 1, 3, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 3 2
  { { 3, 2, 1, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 4 1
  { { 3, 2, 1, 11, 3, 0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 5 3
  { { 4, 2, 0, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 6 2
  { { 5, 2, 3, 8, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 7 5
  { { 3, 3, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 8 1
  { { 4, 0, 2, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 9 2
  { { 3, 1, 0, 9, 3, 3, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 10 3
  { { 5, 1, 2, 10, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 11 5
  { { 4, 3, 1, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 12 2
  { { 5, 0, 1, 11, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 13 5
  { { 5, 3, 0, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 14 5
  { { 4, 8, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 15 8
  { { 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 16 1
  { { 4, 0, 3, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 17 2
  { { 3, 1, 0, 9, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 18 3
  { { 5, 1, 3, 7, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 19 5
  { { 3, 2, 1, 11, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 20 4
  { { 3, 2, 1, 11, 4, 0, 3, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 21 7
  { { 4, 2, 0, 9, 11, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 22 7
  { { 6, 2, 3, 7, 4, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 23 14
  { { 3, 3, 2, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 24 3
  { { 5, 0, 2, 10, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 25 5
  { { 3, 1, 0, 9, 3, 3, 2, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1 } },            // 26 6
  { { 6, 1, 2, 10, 7, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 27 9
  { { 4, 3, 1, 11, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 28 7
  { { 6, 0, 1, 11, 10, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 29 11
  { { 5, 3, 0, 9, 11, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1 } },         // 30 12
  { { 5, 7, 4, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 31 5
  { { 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 32 1
  { { 3, 0, 3, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 33 3
  { { 4, 1, 0, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 34 2
  { { 5, 1, 3, 8, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 35 5
  { { 3, 2, 1, 11, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 36 3
  { { 3, 2, 1, 11, 3, 0, 3, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1 } },            // 37 6
  { { 5, 2, 0, 4, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 38 5
  { { 6, 2, 3, 8, 4, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 39 9
  { { 3, 3, 2, 10, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 40 4
  { { 4, 0, 2, 10, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 41 7
  { { 4, 1, 0, 4, 5, 3, 3, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 42 7
  { { 6, 1, 2, 10, 8, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 43 11
  { { 4, 3, 1, 11, 10, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 44 7
  { { 5, 0, 1, 11, 10, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1 } },         // 45 12
  { { 6, 3, 0, 4, 5, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 46 14
  { { 5, 4, 5, 11, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 47 5
  { { 4, 7, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 48 2
  { { 5, 0, 3, 7, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 49 5
  { { 5, 1, 0, 8, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 50 5
  { { 4, 1, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 51 8
  { { 3, 2, 1, 11, 4, 7, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 52 7
  { { 3, 2, 1, 11, 5, 0, 3, 7, 5, 9, -1, -1, -1, -1, -1, -1, -1 } },          // 53 12
  { { 6, 2, 0, 8, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 54 11
  { { 5, 2, 3, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 55 5
  { { 3, 3, 2, 10, 4, 7, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 56 7
  { { 6, 0, 2, 10, 7, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 57 14
  { { 5, 1, 0, 8, 7, 5, 3, 3, 2, 10, -1, -1, -1, -1, -1, -1, -1 } },          // 58 12
  { { 5, 1, 2, 10, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 59 5
  { { 4, 3, 1, 11, 10, 4, 7, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1 } },         // 60 10
  { { 7, 0, 1, 11, 10, 7, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 61 7
  { { 7, 3, 0, 8, 7, 5, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 62 7
  { { 4, 7, 5, 11, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 63 2
  { { 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 64 1
  { { 3, 0, 3, 8, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 65 4
  { { 3, 1, 0, 9, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 66 3
  { { 4, 1, 3, 8, 9, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 67 7
  { { 4, 2, 1, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 68 2
  { { 4, 2, 1, 5, 6, 3, 0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },          // 69 7
  { { 5, 2, 0, 9, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 70 5
  { { 6, 2, 3, 8, 9, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 71 11
  { { 3, 3, 2, 10, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 72 3
  { { 4, 0, 2, 10, 8, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 73 7
  { { 3, 1, 0, 9, 3, 3, 2, 10, 3, 5, 6, 11, -1, -1, -1, -1, -1 } },           // 74 6
  { { 5, 1, 2, 10, 8, 9, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1 } },         // 75 12
  { { 5, 3, 1, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 76 5
  { { 6, 0, 1, 5, 6, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 77 14
  { { 6, 3, 0, 9, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 78 9
  { { 5, 5, 6, 10, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 79 5
  { { 3, 5, 6, 11, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 80 3
  { { 4, 0, 3, 7, 4, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 81 7
  { { 3, 1, 0, 9, 3, 5, 6, 11, 3, 7, 4, 8, -1, -1, -1, -1, -1 } },            // 82 6
  { { 5, 1, 3, 7, 4, 9, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1 } },          // 83 12
  { { 4, 2, 1, 5, 6, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1 } },          // 84 7
  { { 4, 2, 1, 5, 6, 4, 0, 3, 7, 4, -1, -1, -1, -1, -1, -1, -1 } },           // 85 10
  { { 5, 2, 0, 9, 5, 6, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1 } },           // 86 12
  { { 7, 2, 3, 7, 4, 9, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 87 7
  { { 3, 3, 2, 10, 3, 5, 6, 11, 3, 7, 4, 8, -1, -1, -1, -1, -1 } },           // 88 6
  { { 5, 0, 2, 10, 7, 4, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1, -1 } },         // 89 12
  { { 3, 1, 0, 9, 3, 3, 2, 10, 3, 5, 6, 11, 3, 7, 4, 8, -1 } },               // 90 13
  { { 6, 1, 2, 10, 7, 4, 9, 3, 5, 6, 11, -1, -1, -1, -1, -1, -1 } },          // 91 6
  { { 5, 3, 1, 5, 6, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1, -1 } },          // 92 12
  { { 7, 0, 1, 5, 6, 10, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 93 7
  { { 6, 3, 0, 9, 5, 6, 10, 3, 7, 4, 8, -1, -1, -1, -1, -1, -1 } },           // 94 6
  { { 6, 5, 6, 10, 7, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 95 3
  { { 4, 4, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 96 2
  { { 3, 0, 3, 8, 4, 4, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 97 7
  { { 5, 1, 0, 4, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 98 5
  { { 6, 1, 3, 8, 4, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 99 14
  { { 5, 2, 1, 9, 4, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 100 5
  { { 5, 2, 1, 9, 4, 6, 3, 0, 3, 8, -1, -1, -1, -1, -1, -1, -1 } },           // 101 12
  { { 4, 2, 0, 4, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 102 8
  { { 5, 2, 3, 8, 4, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 103 5
  { { 3, 3, 2, 10, 4, 4, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 104 7
  { { 4, 0, 2, 10, 8, 4, 4, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1 } },         // 105 10
  { { 5, 1, 0, 4, 6, 11, 3, 3, 2, 10, -1, -1, -1, -1, -1, -1, -1 } },         // 106 12
  { { 7, 1, 2, 10, 8, 4, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 107 7
  { { 6, 3, 1, 9, 4, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 108 11
  { { 7, 0, 1, 9, 4, 6, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 109 7
  { { 5, 3, 0, 4, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 110 5
  { { 4, 4, 6, 10, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 111 2
  { { 5, 7, 6, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 112 5
  { { 6, 0, 3, 7, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 113 11
  { { 6, 1, 0, 8, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 114 9
  { { 5, 1, 3, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 115 5
  { { 6, 2, 1, 9, 8, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 116 14
  { { 7, 2, 1, 9, 0, 3, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 117 7
  { { 5, 2, 0, 8, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 118 5
  { { 4, 2, 3, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 119 2
  { { 3, 3, 2, 10, 5, 7, 6, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1 } },         // 120 12
  { { 7, 0, 2, 10, 7, 6, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 121 7
  { { 6, 1, 0, 8, 7, 6, 11, 3, 3, 2, 10, -1, -1, -1, -1, -1, -1 } },          // 122 6
  { { 6, 1, 2, 10, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 123 3
  { { 7, 3, 1, 9, 8, 7, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 124 7
  { { 3, 0, 1, 9, 3, 7, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 125 4
  { { 6, 3, 0, 8, 7, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 126 3
  { { 3, 7, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 127 1
  { { 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 128 1
  { { 3, 0, 3, 8, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 129 3
  { { 3, 1, 0, 9, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 130 4
  { { 4, 1, 3, 8, 9, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 131 7
  { { 3, 2, 1, 11, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 132 3
  { { 3, 2, 1, 11, 3, 0, 3, 8, 3, 6, 7, 10, -1, -1, -1, -1, -1 } },           // 133 6
  { { 4, 2, 0, 9, 11, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 134 7
  { { 5, 2, 3, 8, 9, 11, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1 } },         // 135 12
  { { 4, 3, 2, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 136 2
  { { 5, 0, 2, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 137 5
  { { 3, 1, 0, 9, 4, 3, 2, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1 } },          // 138 7
  { { 6, 1, 2, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 139 14
  { { 5, 3, 1, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 140 5
  { { 6, 0, 1, 11, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 141 9
  { { 6, 3, 0, 9, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 142 11
  { { 5, 6, 7, 8, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 143 5
  { { 4, 6, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 144 2
  { { 5, 0, 3, 10, 6, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 145 5
  { { 3, 1, 0, 9, 4, 6, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 146 7
  { { 6, 1, 3, 10, 6, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 147 11
  { { 3, 2, 1, 11, 4, 6, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 148 7
  { { 3, 2, 1, 11, 5, 0, 3, 10, 6, 4, -1, -1, -1, -1, -1, -1, -1 } },         // 149 12
  { { 4, 2, 0, 9, 11, 4, 6, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1 } },         // 150 10
  { { 7, 2, 3, 10, 6, 4, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 151 7
  { { 5, 3, 2, 6, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 152 5
  { { 4, 0, 2, 6, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 153 8
  { { 3, 1, 0, 9, 5, 3, 2, 6, 4, 8, -1, -1, -1, -1, -1, -1, -1 } },           // 154 12
  { { 5, 1, 2, 6, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 155 5
  { { 6, 3, 1, 11, 6, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 156 14
  { { 5, 0, 1, 11, 6, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 157 5
  { { 7, 3, 0, 9, 11, 6, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 158 7
  { { 4, 6, 4, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 159 2
  { { 3, 4, 5, 9, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 160 3
  { { 3, 0, 3, 8, 3, 4, 5, 9, 3, 6, 7, 10, -1, -1, -1, -1, -1 } },            // 161 6
  { { 4, 1, 0, 4, 5, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 162 7
  { { 5, 1, 3, 8, 4, 5, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1 } },          // 163 12
  { { 3, 2, 1, 11, 3, 4, 5, 9, 3, 6, 7, 10, -1, -1, -1, -1, -1 } },           // 164 6
  { { 3, 2, 1, 11, 3, 0, 3, 8, 3, 4, 5, 9, 3, 6, 7, 10, -1 } },               // 165 13
  { { 5, 2, 0, 4, 5, 11, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1, -1 } },         // 166 12
  { { 6, 2, 3, 8, 4, 5, 11, 3, 6, 7, 10, -1, -1, -1, -1, -1, -1 } },          // 167 6
  { { 4, 3, 2, 6, 7, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1 } },          // 168 7
  { { 5, 0, 2, 6, 7, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1 } },           // 169 12
  { { 4, 1, 0, 4, 5, 4, 3, 2, 6, 7, -1, -1, -1, -1, -1, -1, -1 } },           // 170 10
  { { 7, 1, 2, 6, 7, 8, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 171 7
  { { 5, 3, 1, 11, 6, 7, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1, -1 } },          // 172 12
  { { 6, 0, 1, 11, 6, 7, 8, 3, 4, 5, 9, -1, -1, -1, -1, -1, -1 } },           // 173 6
  { { 7, 3, 0, 4, 5, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 174 7
  { { 6, 4, 5, 11, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 175 3
  { { 5, 6, 5, 9, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 176 5
  { { 6, 0, 3, 10, 6, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 177 9
  { { 6, 1, 0, 8, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 178 14
  { { 5, 1, 3, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 179 5
  { { 3, 2, 1, 11, 5, 6, 5, 9, 8, 10, -1, -1, -1, -1, -1, -1, -1 } },         // 180 12
  { { 3, 2, 1, 11, 6, 0, 3, 10, 6, 5, 9, -1, -1, -1, -1, -1, -1 } },          // 181 6
  { { 7, 2, 0, 8, 10, 6, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 182 7
  { { 6, 2, 3, 10, 6, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 183 3
  { { 6, 3, 2, 6, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 184 11
  { { 5, 0, 2, 6, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 185 5
  { { 7, 1, 0, 8, 3, 2, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },         // 186 7
  { { 4, 1, 2, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 187 2
  { { 7, 3, 1, 11, 6, 5, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 188 7
  { { 6, 0, 1, 11, 6, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 189 3
  { { 3, 3, 0, 8, 3, 6, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 190 4
  { { 3, 6, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 191 1
  { { 4, 5, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 192 2
  { { 3, 0, 3, 8, 4, 5, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 193 7
  { { 3, 1, 0, 9, 4, 5, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 194 7
  { { 4, 1, 3, 8, 9, 4, 5, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1 } },         // 195 10
  { { 5, 2, 1, 5, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 196 5
  { { 5, 2, 1, 5, 7, 10, 3, 0, 3, 8, -1, -1, -1, -1, -1, -1, -1 } },          // 197 12
  { { 6, 2, 0, 9, 5, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 198 14
  { { 7, 2, 3, 8, 9, 5, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 199 7
  { { 5, 3, 2, 11, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 200 5
  { { 6, 0, 2, 11, 5, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 201 11
  { { 3, 1, 0, 9, 5, 3, 2, 11, 5, 7, -1, -1, -1, -1, -1, -1, -1 } },          // 202 12
  { { 7, 1, 2, 11, 5, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 203 7
  { { 4, 3, 1, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 204 8
  { { 5, 0, 1, 5, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 205 5
  { { 5, 3, 0, 9, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 206 5
  { { 4, 5, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 207 2
  { { 5, 5, 4, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 208 5
  { { 6, 0, 3, 10, 11, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 209 14
  { { 3, 1, 0, 9, 5, 5, 4, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1 } },         // 210 12
  { { 7, 1, 3, 10, 11, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 211 7
  { { 6, 2, 1, 5, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 212 11
  { { 7, 2, 1, 5, 4, 0, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 213 7
  { { 7, 2, 0, 9, 5, 4, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 214 7
  { { 3, 2, 3, 10, 3, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 215 4
  { { 6, 3, 2, 11, 5, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 216 9
  { { 5, 0, 2, 11, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 217 5
  { { 3, 1, 0, 9, 6, 3, 2, 11, 5, 4, 8, -1, -1, -1, -1, -1, -1 } },           // 218 6
  { { 6, 1, 2, 11, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 219 3
  { { 5, 3, 1, 5, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 220 5
  { { 4, 0, 1, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 221 2
  { { 6, 3, 0, 9, 5, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 222 3
  { { 3, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 223 1
  { { 5, 4, 7, 10, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 224 5
  { { 3, 0, 3, 8, 5, 4, 7, 10, 11, 9, -1, -1, -1, -1, -1, -1, -1 } },         // 225 12
  { { 6, 1, 0, 4, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 226 11
  { { 7, 1, 3, 8, 4, 7, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 227 7
  { { 6, 2, 1, 9, 4, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 228 9
  { { 6, 2, 1, 9, 4, 7, 10, 3, 0, 3, 8, -1, -1, -1, -1, -1, -1 } },           // 229 6
  { { 5, 2, 0, 4, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 230 5
  { { 6, 2, 3, 8, 4, 7, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 231 3
  { { 6, 3, 2, 11, 9, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 232 14
  { { 7, 0, 2, 11, 9, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 233 7
  { { 7, 1, 0, 4, 7, 3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 234 7
  { { 3, 1, 2, 11, 3, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 235 4
  { { 5, 3, 1, 9, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 236 5
  { { 6, 0, 1, 9, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },        // 237 3
  { { 4, 3, 0, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 238 2
  { { 3, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 239 1
  { { 4, 9, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 240 8
  { { 5, 0, 3, 10, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 241 5
  { { 5, 1, 0, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 242 5
  { { 4, 1, 3, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 243 2
  { { 5, 2, 1, 9, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 244 5
  { { 6, 2, 1, 9, 0, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 245 3
  { { 4, 2, 0, 8, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 246 2
  { { 3, 2, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 247 1
  { { 5, 3, 2, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 248 5
  { { 4, 0, 2, 11, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 249 2
  { { 6, 1, 0, 8, 3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },       // 250 3
  { { 3, 1, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },    // 251 1
  { { 4, 3, 1, 9, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },      // 252 2
  { { 3, 0, 1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 253 1
  { { 3, 3, 0, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } },     // 254 1
  { { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 } }  // 255 0
};

vtkMarchingCubesPolygonCases* vtkMarchingCubesPolygonCases::GetCases()
{
  return VTK_MARCHING_CUBES_POLYGONCASES;
}
