/*
    This file is part of the KDE project.
    SPDX-FileCopyrightText: 2001 Martin R. Jones <mjones@kde.org>
    SPDX-FileCopyrightText: 2001 Carsten Pfeiffer <pfeiffer@kde.org>
    SPDX-FileCopyrightText: 2008 Rafael Fernández López <ereslibre@kde.org>

    SPDX-License-Identifier: LGPL-2.0-only
*/

#ifndef KIMAGEFILEPREVIEW_H
#define KIMAGEFILEPREVIEW_H

#include <QPixmap>
#include <QUrl>
#include <kpreviewwidgetbase.h>

#include <memory>

class KFileItem;
class KJob;
class KImageFilePreviewPrivate;

namespace KIO
{
class PreviewJob;
}

/*!
 * \class KImageFilePreview
 * \inmodule KIOFileWidgets
 *
 * \brief Image preview widget for the file dialog.
 */
class KIOFILEWIDGETS_EXPORT KImageFilePreview : public KPreviewWidgetBase
{
    Q_OBJECT

public:
    /*!
     * Creates a new image file preview.
     *
     * \a parent The parent widget.
     */
    explicit KImageFilePreview(QWidget *parent = nullptr);

    ~KImageFilePreview() override;

    QSize sizeHint() const override;

public Q_SLOTS:
    /*!
     * Shows a preview for the given \a url.
     */
    void showPreview(const QUrl &url) override;

    /*!
     * Clears the preview.
     */
    void clearPreview() override;

protected Q_SLOTS:
    /*!
     *
     */
    void showPreview();

    /*!
     *
     */
    void showPreview(const QUrl &url, bool force);

    /*!
     *
     */
    virtual void gotPreview(const KFileItem &, const QPixmap &);

protected:
    void resizeEvent(QResizeEvent *event) override;

    /*!
     *
     */
    virtual KIO::PreviewJob *createJob(const QUrl &url, int width, int height);

private:
    std::unique_ptr<KImageFilePreviewPrivate> const d;

    Q_DISABLE_COPY(KImageFilePreview)
};

#endif // KIMAGEFILEPREVIEW_H
