IAuthorizationPolicyProvider Sample
===================================

This small sample demonstrates how to use `IAuthorizationPolicyProvider` to 
dynamically produce authorization policies.

In the simple example, a `MinimumAgePolicyProvider` will produce minimum age 
policies for any integer age (based on the policy's 
name). This demonstrates a slightly round-about way to allow 'parameterized' 
authorization policies. Since authorization policies are identified by 
name strings, the custom `MinimumAgeAuthorizeAttribute` in the sample 
allows users to specify an age parameter and then embeds it into its 
underlying `AuthorizationAttribute`'s policy name string. The 
`MinimumAgePolicyProvider` dynamically generates the policies needed for use 
with these attributes by pulling the age from the policy name and creating 
necessary authorization requirements.

Other uses of `IAuthorizationPolicyProvider` might be loading policy 
information from some external data source (like a database, for example).

Notice that ASP.NET Core only uses one authorization policy provider, so 
if not all policies will be generated by the custom policy provider, it 
should fall back to other policy providers (like `DefaultAuthorizationPolicyProvider`).

To use the sample:

1. Run the app
2. Navigate to http://localhost:11606/
3. Attempt to follow one of the 'Minimum Age' links
4. Sign in by providing a user name and birth date
5. Notice that depending on the birth date entered, pages guarded by minimum age authorization policies will either be accessible or forbidden

The interesting classes for this sample are in the Authorization folder, 
particularly `MinimumAgePolicyProvider`.