/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.CompressedInputStream;
import com.amazon.redshift.core.Encoding;
import com.amazon.redshift.core.EncodingPredictor;
import com.amazon.redshift.core.FixedLengthOutputStream;
import com.amazon.redshift.core.RedshiftBindException;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.VisibleBufferedInputStream;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ByteStreamWriter;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftPropertyMaxResultBufferParser;
import com.amazon.redshift.util.RedshiftState;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public class RedshiftStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec hostSpec;
    private final byte[] int4Buf;
    private final byte[] int2Buf;
    private Socket connection;
    private VisibleBufferedInputStream pgInput;
    private CompressedInputStream pgCompressedInput;
    private OutputStream pgOutput;
    private byte[] streamBuffer;
    private long nextStreamAvailableCheckTime;
    private int minStreamAvailableCheckDelay = 1000;
    private Encoding encoding;
    private Writer encodingWriter;
    private long maxResultBuffer = -1L;
    private long resultBufferByteCount = 0L;
    private RedshiftLogger logger;

    public RedshiftStream(SocketFactory socketFactory, HostSpec hostSpec, int timeout, RedshiftLogger logger, boolean disableCompressionForSSL, Properties info) throws IOException {
        this.logger = logger;
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        Socket socket = socketFactory.createSocket();
        if (!socket.isConnected()) {
            if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.INFO, "hostspec host: " + hostSpec.getHost(), new Object[0]);
            }
            logger.log(LogLevel.INFO, "hostspec port: " + hostSpec.getPort(), new Object[0]);
            InetSocketAddress address = hostSpec.shouldResolve() != false ? new InetSocketAddress(hostSpec.getHost(), hostSpec.getPort()) : InetSocketAddress.createUnresolved(hostSpec.getHost(), hostSpec.getPort());
            socket.connect(address, timeout);
            if (RedshiftLogger.isEnable()) {
                logger.log(LogLevel.INFO, "address: " + address.getAddress(), new Object[0]);
            }
            logger.log(LogLevel.INFO, "port: " + address.getPort(), new Object[0]);
            logger.log(LogLevel.INFO, "hostname: " + address.getHostName(), new Object[0]);
            logger.log(LogLevel.INFO, "hoststring: " + address.getHostString(), new Object[0]);
        }
        this.changeSocket(socket, disableCompressionForSSL, info);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8", logger));
        this.int2Buf = new byte[2];
        this.int4Buf = new byte[4];
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.INFO, "Gets a new stream on a new socket", new Object[0]);
        }
    }

    @Deprecated
    public RedshiftStream(SocketFactory socketFactory, HostSpec hostSpec, RedshiftLogger logger, Properties info) throws IOException {
        this(socketFactory, hostSpec, 0, logger, true, info);
    }

    public RedshiftLogger getLogger() {
        return this.logger;
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() throws IOException {
        boolean available = false;
        if (this.pgInput.available() > 0) {
            return true;
        }
        long now = System.nanoTime() / 1000000L;
        if (now < this.nextStreamAvailableCheckTime && this.minStreamAvailableCheckDelay != 0) {
            return false;
        }
        int soTimeout = this.getNetworkTimeout();
        this.connection.setSoTimeout(1);
        try {
            if (!this.pgInput.ensureBytes(1, false)) {
                boolean bl = false;
                return bl;
            }
            available = this.pgInput.peek() != -1;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.connection.setSoTimeout(soTimeout);
        }
        if (!available) {
            this.nextStreamAvailableCheckTime = now + (long)this.minStreamAvailableCheckDelay;
        }
        return available;
    }

    public void setMinStreamAvailableCheckDelay(int delay) {
        this.minStreamAvailableCheckDelay = delay;
    }

    public void changeSocket(Socket socket, Boolean disableCompressionForSSL, Properties info) throws IOException {
        this.connection = socket;
        this.changeStream(disableCompressionForSSL, info);
    }

    public void changeStream(Boolean disableCompressionForSSL, Properties info) throws IOException {
        this.connection.setTcpNoDelay(true);
        InputStream connectionStream = this.connection.getInputStream();
        String compressionMode = RedshiftConnectionImpl.getOptionalSetting(RedshiftProperty.COMPRESSION.getName(), info);
        String string = compressionMode = null == compressionMode ? RedshiftProperty.COMPRESSION.getDefaultValue() : compressionMode;
        if (disableCompressionForSSL.booleanValue() || compressionMode.equalsIgnoreCase("off")) {
            if (RedshiftLogger.isEnable()) {
                this.logger.logInfo("Compression is disabled. Creating regular input stream.", new Object[0]);
            }
            this.pgInput = new VisibleBufferedInputStream(connectionStream, 8192);
        } else {
            if (RedshiftLogger.isEnable()) {
                this.logger.logInfo("Compression is enabled. Creating compressed input stream.", new Object[0]);
            }
            this.pgCompressedInput = new CompressedInputStream(connectionStream, this.logger);
            this.pgInput = new VisibleBufferedInputStream(this.pgCompressedInput, 8192);
        }
        this.pgOutput = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public long getBytesFromStream() {
        if (null != this.pgCompressedInput) {
            return this.pgCompressedInput.getBytesReadFromStream();
        }
        return this.pgInput.getBytesReadFromStream();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encoding != null && this.encoding.name().equals(encoding.name())) {
            return;
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.pgOutput){

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void sendChar(int val) throws IOException {
        this.pgOutput.write(val);
    }

    public void sendInteger4(int val) throws IOException {
        this.int4Buf[0] = (byte)(val >>> 24);
        this.int4Buf[1] = (byte)(val >>> 16);
        this.int4Buf[2] = (byte)(val >>> 8);
        this.int4Buf[3] = (byte)val;
        this.pgOutput.write(this.int4Buf);
    }

    public void sendInteger2(int val) throws IOException {
        if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + val);
        }
        this.int2Buf[0] = (byte)(val >>> 8);
        this.int2Buf[1] = (byte)val;
        this.pgOutput.write(this.int2Buf);
    }

    public void send(byte[] buf) throws IOException {
        this.pgOutput.write(buf);
    }

    public void send(byte[] buf, int siz) throws IOException {
        this.send(buf, 0, siz);
    }

    public void send(byte[] buf, int off, int siz) throws IOException {
        int bufamt = buf.length - off;
        this.pgOutput.write(buf, off, bufamt < siz ? bufamt : siz);
        for (int i = bufamt; i < siz; ++i) {
            this.pgOutput.write(0);
        }
    }

    public void send(ByteStreamWriter writer) throws IOException {
        final FixedLengthOutputStream fixedLengthStream = new FixedLengthOutputStream(writer.getLength(), this.pgOutput);
        try {
            writer.writeTo(new ByteStreamWriter.ByteStreamTarget(){

                @Override
                public OutputStream getOutputStream() {
                    return fixedLengthStream;
                }
            });
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception re) {
            throw new IOException("Error writing bytes to stream", re);
        }
        for (int i = fixedLengthStream.remaining(); i > 0; --i) {
            this.pgOutput.write(0);
        }
    }

    public int peekChar() throws IOException {
        int c = this.pgInput.peek();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int receiveChar() throws IOException {
        int c = this.pgInput.read();
        if (c < 0) {
            throw new EOFException("The server closed the connection.");
        }
        return c;
    }

    public int receiveInteger4() throws IOException {
        if (this.pgInput.read(this.int4Buf) != 4) {
            throw new EOFException();
        }
        return (this.int4Buf[0] & 0xFF) << 24 | (this.int4Buf[1] & 0xFF) << 16 | (this.int4Buf[2] & 0xFF) << 8 | this.int4Buf[3] & 0xFF;
    }

    public int receiveInteger2() throws IOException {
        if (this.pgInput.read(this.int2Buf) != 2) {
            throw new EOFException();
        }
        return (this.int2Buf[0] & 0xFF) << 8 | this.int2Buf[1] & 0xFF;
    }

    public String receiveString(int len) throws IOException {
        if (!this.pgInput.ensureBytes(len)) {
            throw new EOFException();
        }
        String res = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
        this.pgInput.skip(len);
        return res;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int len) throws IOException {
        EncodingPredictor.DecodeResult res;
        block3: {
            if (!this.pgInput.ensureBytes(len)) {
                throw new EOFException();
            }
            try {
                String value = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, null);
            }
            catch (IOException e) {
                res = EncodingPredictor.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len, this.logger);
                if (res != null) break block3;
                Encoding enc = Encoding.defaultEncoding();
                String value = enc.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, enc.name());
            }
        }
        this.pgInput.skip(len);
        return res;
    }

    public String receiveString() throws IOException {
        int len = this.pgInput.scanCStringLength();
        String res = this.encoding.decode(this.pgInput.getBuffer(), this.pgInput.getIndex(), len - 1);
        this.pgInput.skip(len);
        return res;
    }

    public Tuple receiveTupleV3() throws IOException, OutOfMemoryError, SQLException {
        int messageSize = this.receiveInteger4();
        int nf = this.receiveInteger2();
        int dataToReadSize = messageSize - 4 - 2 - 4 * nf;
        byte[][] answer = new byte[nf][];
        this.increaseByteCounter(dataToReadSize);
        OutOfMemoryError oom = null;
        for (int i = 0; i < nf; ++i) {
            int size = this.receiveInteger4();
            if (size == -1) continue;
            try {
                answer[i] = new byte[size];
                this.receive(answer[i], 0, size);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.skip(size);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return new Tuple((byte[][])answer, dataToReadSize);
    }

    public byte[] receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.receive(answer, 0, siz);
        return answer;
    }

    public void receive(byte[] buf, int off, int siz) throws IOException {
        int w;
        for (int s = 0; s < siz; s += w) {
            w = this.pgInput.read(buf, off + s, siz - s);
            if (w >= 0) continue;
            throw new EOFException();
        }
    }

    public void skip(int size) throws IOException {
        for (long s = 0L; s < (long)size; s += this.pgInput.skip((long)size - s)) {
        }
    }

    public void sendStream(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            int readCount;
            int count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
            try {
                readCount = inStream.read(this.streamBuffer, 0, count);
                if (readCount < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", expectedLength, expectedLength - remaining));
                }
            }
            catch (IOException ioe) {
                while (remaining > 0) {
                    this.send(this.streamBuffer, count);
                    count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                }
                throw new RedshiftBindException(ioe);
            }
            this.send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pgOutput.flush();
    }

    public void receiveEOF() throws SQLException, IOException {
        int c = this.pgInput.read();
        if (c < 0) {
            return;
        }
        throw new RedshiftException(GT.tr("Expected an EOF from server, got: {0}", c), RedshiftState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.INFO, "Stream on a connected socket closed", new Object[0]);
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pgOutput.close();
        this.pgInput.close();
        this.connection.close();
    }

    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.connection.setSoTimeout(milliseconds);
        this.pgInput.setTimeoutRequested(milliseconds != 0);
    }

    public int getNetworkTimeout() throws IOException {
        return this.connection.getSoTimeout();
    }

    public void setMaxResultBuffer(String value) throws RedshiftException {
        this.maxResultBuffer = RedshiftPropertyMaxResultBufferParser.parseProperty(value, RedshiftProperty.MAX_RESULT_BUFFER.getName());
    }

    public void clearResultBufferCount() {
        this.resultBufferByteCount = 0L;
    }

    private void increaseByteCounter(long value) throws SQLException {
        if (this.maxResultBuffer != -1L) {
            this.resultBufferByteCount += value;
            if (this.resultBufferByteCount > this.maxResultBuffer) {
                throw new RedshiftException(GT.tr("Result set exceeded maxResultBuffer limit. Received:  {0}; Current limit: {1}", String.valueOf(this.resultBufferByteCount), String.valueOf(this.maxResultBuffer)), RedshiftState.COMMUNICATION_ERROR);
            }
        }
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }
}

