/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;

@GenerateInline
@GenerateUncached
public abstract class LongToIntOrDoubleNode
extends JavaScriptBaseNode {
    public abstract Number execute(Node var1, long var2);

    public final Number fromIndex(Node node, long index) {
        assert (JSRuntime.isIntegerIndex(index)) : index;
        return this.execute(node, index);
    }

    @Specialization
    protected static Number toIntOrDouble(Node node, long value, @Cached InlinedBranchProfile toDoubleBranch) {
        if (CompilerDirectives.injectBranchProbability((double)0.75, (boolean)JSRuntime.longIsRepresentableAsInt(value))) {
            return (int)value;
        }
        toDoubleBranch.enter(node);
        return (double)value;
    }

    @NeverDefault
    public static LongToIntOrDoubleNode create() {
        return LongToIntOrDoubleNodeGen.create();
    }
}

