/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.tuple.InstantiableStructSequenceBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequenceBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Objects;

public class StructSequence {
    public static final TruffleString T_N_SEQUENCE_FIELDS = PythonUtils.tsLiteral("n_sequence_fields");
    public static final TruffleString T_N_FIELDS = PythonUtils.tsLiteral("n_fields");
    public static final TruffleString T_N_UNNAMED_FIELDS = PythonUtils.tsLiteral("n_unnamed_fields");

    @CompilerDirectives.TruffleBoundary
    public static void initType(Python3Core core, BuiltinTypeDescriptor desc) {
        StructSequence.initType(core.getContext(), core.lookupType(desc.type), desc);
    }

    @CompilerDirectives.TruffleBoundary
    public static void initType(PythonContext context, PythonAbstractClass klass, Descriptor desc) {
        assert (IsSubtypeNode.getUncached().execute(klass, (Object)PythonBuiltinClassType.PTuple));
        PythonLanguage language = context.getLanguage();
        long flags = TypeNodes.GetTypeFlagsNode.executeUncached(klass);
        if ((flags & 0x100L) != 0L) {
            TypeNodes.SetTypeFlagsNode.executeUncached(klass, flags & 0xFFFFFFFFFFFFFEFFL);
        }
        int unnamedFields = 0;
        ArrayList<TruffleString> namedFields = new ArrayList<TruffleString>(desc.fieldNames.length);
        for (int idx = 0; idx < desc.fieldNames.length; ++idx) {
            TruffleString fieldName = desc.fieldNames[idx];
            if (fieldName != null) {
                TruffleString doc = desc.fieldDocStrings == null ? null : desc.fieldDocStrings[idx];
                StructSequence.createMember(language, klass, fieldName, doc, idx);
                namedFields.add(fieldName);
                continue;
            }
            ++unnamedFields;
        }
        WriteAttributeToObjectNode writeAttrNode = WriteAttributeToObjectNode.getUncached(true);
        if (klass instanceof PythonManagedClass) {
            PythonManagedClass managedClass = (PythonManagedClass)klass;
            HiddenAttr.WriteNode.executeUncached(managedClass, HiddenAttr.STRUCTSEQ_FIELD_NAMES, namedFields.toArray(new TruffleString[0]));
        } else if (klass instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeClass = (PythonAbstractNativeObject)klass;
            TpSlot.TpSlotBuiltin newSlot = null;
            if ((flags & 0x80L) == 0L) {
                newSlot = (TpSlot.TpSlotBuiltin)InstantiableStructSequenceBuiltins.SLOTS.tp_new();
                writeAttrNode.execute(klass, SpecialMethodNames.T___NEW__, newSlot.createBuiltin(context, klass, SpecialMethodNames.T___NEW__, TpSlots.TpSlotMeta.TP_NEW.getNativeSignature()));
            }
            nativeClass.setTpSlots(nativeClass.getTpSlots().copy().set(TpSlots.TpSlotMeta.TP_NEW, newSlot).build());
            TpSlots.toNative(nativeClass.getPtr(), TpSlots.TpSlotMeta.TP_NEW, newSlot, (Object)context.getNativeNull());
            TpSlot.TpSlotBuiltin reprSlot = (TpSlot.TpSlotBuiltin)StructSequenceBuiltins.SLOTS.tp_repr();
            writeAttrNode.execute(klass, SpecialMethodNames.T___REPR__, reprSlot.createBuiltin(context, klass, SpecialMethodNames.T___REPR__, TpSlots.TpSlotMeta.TP_REPR.getNativeSignature()));
            PythonBuiltinClass template = context.lookupType(PythonBuiltinClassType.PFloatInfo);
            StructSequence.copyMethod(language, klass, SpecialMethodNames.T___REDUCE__, template);
        }
        writeAttrNode.execute(klass, T_N_SEQUENCE_FIELDS, desc.inSequence);
        writeAttrNode.execute(klass, T_N_FIELDS, desc.fieldNames.length);
        writeAttrNode.execute(klass, T_N_UNNAMED_FIELDS, unnamedFields);
        TypeNodes.SetTypeFlagsNode.executeUncached(klass, flags);
    }

    private static void copyMethod(PythonLanguage language, PythonAbstractClass klass, TruffleString name, PythonBuiltinClass template) {
        PBuiltinFunction templateMethod = (PBuiltinFunction)template.getAttribute(name);
        PBuiltinFunction method = PFactory.createBuiltinFunction(language, templateMethod, klass);
        WriteAttributeToObjectNode.getUncached(true).execute(klass, name, method);
    }

    private static void createMember(PythonLanguage language, Object klass, TruffleString name, TruffleString doc, int idx) {
        RootCallTarget callTarget = language.createStructSeqIndexedMemberAccessCachedCallTarget(l -> new GetStructMemberNode((PythonLanguage)((Object)l), idx), idx);
        PBuiltinFunction getter = PFactory.createBuiltinFunction(language, name, klass, 0, 0, callTarget);
        GetSetDescriptor callable = PFactory.createGetSetDescriptor(language, getter, null, name, klass, false);
        if (doc != null) {
            callable.setAttribute(SpecialAttributeNames.T___DOC__, doc);
        }
        WriteAttributeToObjectNode.getUncached(true).execute(klass, name, callable);
    }

    static TruffleString getTpName(Object cls) {
        if (cls instanceof PythonBuiltinClassType) {
            return ((PythonBuiltinClassType)((Object)cls)).getPrintName();
        }
        if (cls instanceof PythonBuiltinClass) {
            return ((PythonBuiltinClass)cls).getType().getPrintName();
        }
        return TypeNodes.GetNameNode.executeUncached(cls);
    }

    public static final class BuiltinTypeDescriptor
    extends Descriptor {
        public final PythonBuiltinClassType type;

        public BuiltinTypeDescriptor(PythonBuiltinClassType type, int inSequence, String[] fieldNames, String[] fieldDocStrings) {
            super(inSequence, PythonUtils.toTruffleStringArrayUncached(fieldNames), PythonUtils.toTruffleStringArrayUncached(fieldDocStrings));
            assert (type.getBase() == PythonBuiltinClassType.PTuple);
            assert (!type.isAcceptableBase());
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BuiltinTypeDescriptor)) {
                return false;
            }
            BuiltinTypeDescriptor that = (BuiltinTypeDescriptor)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.type});
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class Descriptor {
        public final int inSequence;
        public final TruffleString[] fieldNames;
        public final TruffleString[] fieldDocStrings;

        public Descriptor(int inSequence, TruffleString[] fieldNames, TruffleString[] fieldDocStrings) {
            assert (fieldDocStrings == null || fieldNames.length == fieldDocStrings.length);
            this.inSequence = inSequence;
            this.fieldNames = fieldNames;
            this.fieldDocStrings = fieldDocStrings;
        }
    }

    private static class GetStructMemberNode
    extends PRootNode {
        public static final Signature SIGNATURE = new Signature(-1, false, -1, PythonUtils.tsArray("$self"), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        private final int fieldIdx;

        GetStructMemberNode(PythonLanguage language, int fieldIdx) {
            super(language);
            this.fieldIdx = fieldIdx;
        }

        public Object execute(VirtualFrame frame) {
            PTuple self = (PTuple)PArguments.getArgument((Frame)frame, 0);
            if (self.getSequenceStorage() instanceof NativeSequenceStorage && this.fieldIdx >= self.getSequenceStorage().length()) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.NotImplementedError, ErrorMessages.UNSUPPORTED_ACCESS_OF_STRUCT_SEQUENCE_NATIVE_STORAGE);
            }
            return SequenceStorageNodes.GetItemScalarNode.executeUncached(self.getSequenceStorage(), this.fieldIdx);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }
    }
}

