/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.code;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.Instruction;
import com.oracle.truffle.api.bytecode.SourceInformationTree;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCode})
public final class CodeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CodeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodeBuiltinsFactory.getFactories();
    }

    private static boolean hasStrings(Object[] values) {
        for (Object o : values) {
            if (!(o instanceof TruffleString)) continue;
            return true;
        }
        return false;
    }

    private static PTuple internStrings(Node inliningTarget, Object[] values, StringNodes.InternStringNode internStringNode) {
        Object[] result;
        PythonLanguage language = PythonLanguage.get(inliningTarget);
        if (values == null) {
            return PFactory.createEmptyTuple(language);
        }
        if (!CodeBuiltins.hasStrings(values)) {
            result = values;
        } else {
            result = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i] instanceof TruffleString ? internStringNode.execute(inliningTarget, values[i]) : values[i];
            }
        }
        return PFactory.createTuple(language, result);
    }

    @Builtin(name="replace", minNumOfPositionalArgs=1, parameterNames={"$self", "co_argcount", "co_posonlyargcount", "co_kwonlyargcount", "co_nlocals", "co_stacksize", "co_flags", "co_firstlineno", "co_code", "co_consts", "co_names", "co_varnames", "co_freevars", "co_cellvars", "co_filename", "co_name", "co_qualname", "co_linetable", "co_exceptiontable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="co_argcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_posonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_kwonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_nlocals", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_stacksize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_firstlineno", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_code", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="co_consts", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_names", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_varnames", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_freevars", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_cellvars", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_filename", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="co_name", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="co_qualname", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="co_linetable", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class ReplaceNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodeBuiltinsClinicProviders.ReplaceNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PCode create(VirtualFrame frame, PCode self, int coArgcount, int coPosonlyargcount, int coKwonlyargcount, int coNlocals, int coStacksize, int coFlags, int coFirstlineno, Object coCode, Object[] coConsts, Object[] coNames, Object[] coVarnames, Object[] coFreevars, Object[] coCellvars, TruffleString coFilename, TruffleString coName, TruffleString coQualname, Object coLnotab, Object coExceptiontable, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached CodeNodes.CreateCodeNode createCodeNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            try {
                PCode pCode = createCodeNode.execute(frame, coArgcount == -1 ? self.co_argcount() : coArgcount, coPosonlyargcount == -1 ? self.co_posonlyargcount() : coPosonlyargcount, coKwonlyargcount == -1 ? self.co_kwonlyargcount() : coKwonlyargcount, coNlocals == -1 ? self.co_nlocals() : coNlocals, coStacksize == -1 ? self.co_stacksize() : coStacksize, coFlags == -1 ? self.co_flags() : coFlags, PGuards.isNone(coCode) ? self.getCodestring() : bufferLib.getInternalOrCopiedByteArray(coCode), coConsts.length == 0 ? null : coConsts, coNames.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coNames, castToTruffleStringNode), coVarnames.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coVarnames, castToTruffleStringNode), coFreevars.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coFreevars, castToTruffleStringNode), coCellvars.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coCellvars, castToTruffleStringNode), coFilename.isEmpty() ? self.co_filename() : coFilename, coName.isEmpty() ? self.co_name() : coName, coQualname.isEmpty() ? self.co_qualname() : coQualname, coFirstlineno == -1 ? self.co_firstlineno() : coFirstlineno, PGuards.isNone(coLnotab) ? self.getLinetable() : bufferLib.getInternalOrCopiedByteArray(coLnotab));
                return pCode;
            }
            finally {
                if (!PGuards.isNone(coCode)) {
                    bufferLib.release(coCode, frame, indirectCallData);
                }
                if (!PGuards.isNone(coLnotab)) {
                    bufferLib.release(coLnotab, frame, indirectCallData);
                }
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class CodeHashNode
    extends TpSlotHashFun.HashBuiltinNode {
        @Specialization
        static long hash(VirtualFrame frame, PCode self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyObjectHashNode hashNode) {
            long h6;
            long h5;
            long h4;
            long h3;
            long h2;
            long h1;
            long h0 = hashNode.execute((Frame)frame, inliningTarget, self.co_name());
            long h = h0 ^ (h1 = hashNode.execute((Frame)frame, inliningTarget, self.co_code(language))) ^ (h2 = hashNode.execute((Frame)frame, inliningTarget, self.co_consts(language))) ^ (h3 = hashNode.execute((Frame)frame, inliningTarget, self.co_names(language))) ^ (h4 = hashNode.execute((Frame)frame, inliningTarget, self.co_varnames(language))) ^ (h5 = hashNode.execute((Frame)frame, inliningTarget, self.co_freevars(language))) ^ (h6 = hashNode.execute((Frame)frame, inliningTarget, self.co_cellvars(language))) ^ (long)self.co_argcount() ^ (long)self.co_posonlyargcount() ^ (long)self.co_kwonlyargcount() ^ (long)self.co_nlocals() ^ (long)self.co_flags();
            if (h == -1L) {
                h = -2L;
            }
            return h;
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class CodeEqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization(guards={"op.isEqOrNe()"})
        @CompilerDirectives.TruffleBoundary
        boolean eq(PCode self, PCode other, RichCmpOp op) {
            if (self == other) {
                return op.isEq();
            }
            if (self.getRootNode() != null && other.getRootNode() != null) {
                if (!self.getName().equalsUncached((AbstractTruffleString)other.getName(), PythonUtils.TS_ENCODING)) {
                    return op.isNe();
                }
                if (self.co_argcount() != other.co_argcount() || self.co_posonlyargcount() != other.co_posonlyargcount() || self.co_kwonlyargcount() != other.co_kwonlyargcount() || self.co_nlocals() != other.co_nlocals() || self.co_flags() != other.co_flags() || self.co_firstlineno() != other.co_firstlineno()) {
                    return op.isNe();
                }
                if (!Arrays.equals(self.getCodestring(), other.getCodestring())) {
                    return op.isNe();
                }
                boolean eq = Arrays.equals(self.getNames(), other.getNames()) && Arrays.equals(self.getVarnames(), other.getVarnames()) && Arrays.equals(self.getFreeVars(), other.getFreeVars()) && Arrays.equals(self.getCellVars(), other.getCellVars());
                return eq == op.isEq();
            }
            return op.isNe();
        }

        @Fallback
        Object fail(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class CodeReprNode
    extends PythonUnaryBuiltinNode {
        CodeReprNode() {
        }

        @Specialization
        static TruffleString repr(PCode self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString codeName = self.getName() == null ? StringLiterals.T_NONE : self.getName();
            TruffleString codeFilename = self.getFilename() == null ? StringLiterals.T_NONE : self.getFilename();
            int codeFirstLineNo = self.getFirstLineNo() == 0 ? -1 : self.getFirstLineNo();
            return simpleTruffleStringFormatNode.format("<code object %s, file \"%s\", line %d>", codeName, codeFilename, codeFirstLineNo);
        }
    }

    @Builtin(name="co_positions", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CoPositionsNode
    extends PythonUnaryBuiltinNode {
        CoPositionsNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object positions(PCode self) {
            PTuple tuple;
            PythonLanguage language = PythonLanguage.get(null);
            CodeUnit co = self.getCodeUnit();
            if (co != null) {
                ArrayList<PTuple> lines = new ArrayList<PTuple>();
                if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                    PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)self.getRootNodeForExtraction();
                    for (Instruction instruction : rootNode.getBytecodeNode().getInstructions()) {
                        if (instruction.isInstrumentation()) continue;
                        SourceSection section = rootNode.getSourceSectionForLocation(instruction.getLocation());
                        lines.add(PFactory.createTuple(language, new int[]{section.getStartLine(), section.getEndLine(), section.getStartColumn() - 1, section.getEndColumn()}));
                    }
                } else {
                    BytecodeCodeUnit bytecodeCo = (BytecodeCodeUnit)co;
                    SourceMap map = bytecodeCo.getSourceMap();
                    if (map != null && map.startLineMap.length > 0) {
                        byte[] bytecode = bytecodeCo.code;
                        for (int i = 0; i < bytecode.length; i += OpCodes.fromOpCode(bytecode[i]).length()) {
                            lines.add(PFactory.createTuple(language, new int[]{map.startLineMap[i], map.endLineMap[i], map.startColumnMap[i], map.endColumnMap[i]}));
                        }
                    }
                }
                tuple = PFactory.createTuple(language, lines.toArray());
            } else {
                tuple = PFactory.createEmptyTuple(language);
            }
            return PyObjectGetIter.executeUncached(tuple);
        }
    }

    @Builtin(name="co_lines", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CoLinesNode
    extends PythonUnaryBuiltinNode {
        CoLinesNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object lines(PCode self) {
            PTuple tuple;
            PythonLanguage language = PythonLanguage.get(null);
            CodeUnit co = self.getCodeUnit();
            if (co != null) {
                if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                    PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)self.getRootNodeForExtraction();
                    List<PTuple> lines = CoLinesNode.computeLinesForBytecodeDSLInterpreter(rootNode);
                    tuple = PFactory.createTuple(language, lines.toArray());
                } else {
                    BytecodeCodeUnit bytecodeCo = (BytecodeCodeUnit)co;
                    SourceMap map = bytecodeCo.getSourceMap();
                    ArrayList lines = new ArrayList();
                    if (map != null && map.startLineMap.length > 0) {
                        IteratorData data = new IteratorData();
                        data.line = map.startLineMap[0];
                        bytecodeCo.iterateBytecode((bci, op, oparg, followingArgs) -> {
                            int nextStart = bci + op.length();
                            if (map.startLineMap[bci] != data.line || nextStart == bytecodeCo.code.length) {
                                lines.add(PFactory.createTuple(language, new int[]{data.start, nextStart, data.line}));
                                data.line = map.startLineMap[bci];
                                data.start = nextStart;
                            }
                        });
                    }
                    tuple = PFactory.createTuple(language, lines.toArray());
                }
            } else {
                tuple = PFactory.createEmptyTuple(language);
            }
            return PyObjectGetIter.executeUncached(tuple);
        }

        private static List<PTuple> computeLinesForBytecodeDSLInterpreter(PBytecodeDSLRootNode root) {
            BytecodeNode bytecodeNode = root.getBytecodeNode();
            ArrayList<int[]> triples = new ArrayList<int[]>();
            SourceInformationTree sourceInformationTree = bytecodeNode.getSourceInformationTree();
            assert (sourceInformationTree.getSourceSection() != null);
            CoLinesNode.traverseSourceInformationTree(sourceInformationTree, triples);
            return CoLinesNode.convertTripleBcisToInstructionIndices(bytecodeNode, root.getLanguage(), triples);
        }

        private static void traverseSourceInformationTree(SourceInformationTree tree, List<int[]> triples) {
            int startIndex = tree.getStartBytecodeIndex();
            int startLine = tree.getSourceSection().getStartLine();
            for (SourceInformationTree child : tree.getChildren()) {
                if (startIndex < child.getStartBytecodeIndex()) {
                    triples.add(new int[]{startIndex, child.getStartBytecodeIndex(), startLine});
                }
                CoLinesNode.traverseSourceInformationTree(child, triples);
                startIndex = child.getEndBytecodeIndex();
            }
            if (startIndex < tree.getEndBytecodeIndex()) {
                triples.add(new int[]{startIndex, tree.getEndBytecodeIndex(), startLine});
            }
        }

        private static List<PTuple> convertTripleBcisToInstructionIndices(BytecodeNode bytecodeNode, PythonLanguage language, List<int[]> triples) {
            ArrayList<PTuple> result = new ArrayList<PTuple>(triples.size());
            int tripleIndex = 0;
            int[] triple = triples.get(0);
            assert (triple[0] == 0) : "the first bytecode range should start from 0";
            int startInstructionIndex = 0;
            int instructionIndex = 0;
            for (Instruction instruction : bytecodeNode.getInstructions()) {
                if (instruction.getBytecodeIndex() == triple[1]) {
                    result.add(PFactory.createTuple(language, new int[]{startInstructionIndex, instructionIndex, triple[2]}));
                    startInstructionIndex = instructionIndex;
                    triple = triples.get(++tripleIndex);
                    assert (triple[0] == instruction.getBytecodeIndex()) : "bytecode ranges should be consecutive";
                }
                if (instruction.isInstrumentation()) continue;
                instructionIndex += 2;
            }
            result.add(PFactory.createTuple(language, new int[]{startInstructionIndex, instructionIndex, triple[2]}));
            assert (tripleIndex == triples.size()) : "every bytecode range should have been converted to an instruction range";
            return result;
        }

        private static final class IteratorData {
            int start = 0;
            int line = -1;

            private IteratorData() {
            }
        }
    }

    @Builtin(name="co_exceptiontable", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetExceptionTableNode
    extends PythonUnaryBuiltinNode {
        GetExceptionTableNode() {
        }

        @Specialization
        static Object get(PCode self, @Bind PythonLanguage language) {
            return PFactory.createEmptyBytes(language);
        }
    }

    @Builtins(value={@Builtin(name="co_lnotab", minNumOfPositionalArgs=1, isGetter=true), @Builtin(name="co_linetable", minNumOfPositionalArgs=1, isGetter=true)})
    @GenerateNodeFactory
    public static abstract class GetLineTableNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind PythonLanguage language) {
            byte[] linetable = self.getLinetable();
            if (linetable == null) {
                linetable = PythonUtils.EMPTY_BYTE_ARRAY;
            }
            return PFactory.createBytes(language, linetable);
        }
    }

    @Builtin(name="co_varnames", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetVarNamesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return CodeBuiltins.internStrings(inliningTarget, self.getVarnames(), internStringNode);
        }
    }

    @Builtin(name="co_names", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNamesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return CodeBuiltins.internStrings(inliningTarget, self.getNames(), internStringNode);
        }
    }

    @Builtin(name="co_consts", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetConstsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return CodeBuiltins.internStrings(inliningTarget, self.getConstants(), internStringNode);
        }
    }

    @Builtin(name="co_code", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCodeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind PythonLanguage language) {
            return self.co_code(language);
        }
    }

    @Builtin(name="co_flags", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFlagsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_flags();
        }
    }

    @Builtin(name="co_stacksize", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStackSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.getStacksize();
        }
    }

    @Builtin(name="co_nlocals", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNLocalsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_nlocals();
        }
    }

    @Builtin(name="co_kwonlyargcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetKnownlyArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_kwonlyargcount();
        }
    }

    @Builtin(name="co_posonlyargcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetPosOnlyArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_posonlyargcount();
        }
    }

    @Builtin(name="co_argcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_argcount();
        }
    }

    @Builtin(name="co_qualname", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetQualNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return internStringNode.execute(inliningTarget, self.co_qualname());
        }
    }

    @Builtin(name="co_name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return internStringNode.execute(inliningTarget, self.co_name());
        }
    }

    @Builtin(name="co_firstlineno", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetLinenoNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.getFirstLineNo();
        }
    }

    @Builtin(name="co_filename", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFilenameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            TruffleString filename = self.getFilename();
            if (filename != null) {
                return internStringNode.execute(inliningTarget, filename);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="co_cellvars", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCellVarsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return CodeBuiltins.internStrings(inliningTarget, self.getCellVars(), internStringNode);
        }
    }

    @Builtin(name="co_freevars", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFreeVarsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return CodeBuiltins.internStrings(inliningTarget, self.getFreeVars(), internStringNode);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="code", minNumOfPositionalArgs=16, numOfPositionalOnlyArgs=18, parameterNames={"$cls", "argcount", "posonlyargcount", "kwonlyargcount", "nlocals", "stacksize", "flags", "codestring", "constants", "names", "varnames", "filename", "name", "qualname", "firstlineno", "linetable", "exceptiontable", "freevars", "cellvars"})
    @ArgumentsClinic(value={@ArgumentClinic(name="argcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="posonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="kwonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="nlocals", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="stacksize", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="filename", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="qualname", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="firstlineno", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class CodeConstructorNode
    extends PythonClinicBuiltinNode {
        @Specialization
        static PCode call(VirtualFrame frame, Object cls, int argcount, int posonlyargcount, int kwonlyargcount, int nlocals, int stacksize, int flags, PBytes codestring, PTuple constants, PTuple names, PTuple varnames, TruffleString filename, TruffleString name, TruffleString qualname, int firstlineno, PBytes linetable, PBytes exceptiontable, PTuple freevars, PTuple cellvars, @Bind Node inliningTarget, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CodeNodes.CreateCodeNode createCodeNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached CastToTruffleStringNode castToTruffleStringNode) {
            byte[] codeBytes = bufferLib.getCopiedByteArray(codestring);
            byte[] linetableBytes = bufferLib.getCopiedByteArray(linetable);
            Object[] constantsArr = getObjectArrayNode.execute(inliningTarget, constants);
            TruffleString[] namesArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, names), castToTruffleStringNode);
            TruffleString[] varnamesArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, varnames), castToTruffleStringNode);
            TruffleString[] freevarsArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, freevars), castToTruffleStringNode);
            TruffleString[] cellcarsArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, cellvars), castToTruffleStringNode);
            return createCodeNode.execute(frame, argcount, posonlyargcount, kwonlyargcount, nlocals, stacksize, flags, codeBytes, constantsArr, namesArr, varnamesArr, freevarsArr, cellcarsArr, filename, name, qualname, firstlineno, linetableBytes);
        }

        @Fallback
        static PCode call(Object cls, Object argcount, Object kwonlyargcount, Object posonlyargcount, Object nlocals, Object stacksize, Object flags, Object codestring, Object constants, Object names, Object varnames, Object filename, Object name, Object qualname, Object firstlineno, Object linetable, Object exceptiontable, Object freevars, Object cellvars, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INVALID_ARGS, "code");
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodeBuiltinsClinicProviders.CodeConstructorNodeClinicProviderGen.INSTANCE;
        }
    }
}

