/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.compiler.Block;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import java.util.List;

final class Instruction {
    final OpCodes opcode;
    int arg;
    final byte[] followingArgs;
    final Block target;
    final SourceRange location;
    public int bci = -1;
    public byte quickenOutput;
    public List<Instruction> quickeningGeneralizeList;

    Instruction(OpCodes opcode, int arg, byte[] followingArgs, Block target, SourceRange location) {
        this.opcode = opcode;
        this.arg = arg;
        this.followingArgs = followingArgs;
        this.target = target;
        this.location = location;
        assert (opcode.argLength < 2 || followingArgs.length == opcode.argLength - 1);
    }

    public String toString() {
        if (this.target != null) {
            return String.format("%s %s", new Object[]{this.opcode, this.target});
        }
        if (this.opcode.hasArg()) {
            return String.format("%s %s", new Object[]{this.opcode, this.arg});
        }
        return this.opcode.toString();
    }

    public int bodyBci() {
        assert (this.bci != -1);
        return this.bci + 2 * this.extensions();
    }

    public int extensions() {
        if (this.arg <= 255) {
            return 0;
        }
        if (this.arg <= 65535) {
            return 1;
        }
        if (this.arg <= 0xFFFFFF) {
            return 2;
        }
        return 3;
    }

    public int extendedLength() {
        return this.opcode.length() + this.extensions() * 2;
    }
}

