/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.loader.weakassociations.ExtensionTableMatcher;
import schemacrawler.loader.weakassociations.IdMatcher;
import schemacrawler.loader.weakassociations.ProposedWeakAssociation;
import schemacrawler.loader.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationsCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationsCatalogLoader.class.getName());
    private static final String OPTION_WEAK_ASSOCIATIONS = "weak-associations";
    private static final String OPTION_INFER_EXTENSION_TABLES = "infer-extension-tables";

    public WeakAssociationsCatalogLoader() {
        super(new PropertyName("weakassociationsloader", "Loader for weak associations"), 3);
    }

    public PluginCommand getCommandLineCommand() {
        PropertyName catalogLoaderName = this.getCatalogLoaderName();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand((PropertyName)catalogLoaderName);
        pluginCommand.addOption(OPTION_WEAK_ASSOCIATIONS, Boolean.class, new String[]{"Analyzes the schema to find weak associations between tables, based on table and column naming patterns", "This can be a time consuming operation", "Optional, defaults to false"});
        pluginCommand.addOption(OPTION_INFER_EXTENSION_TABLES, Boolean.class, new String[]{"Infers extension tables that have similarly named primary keys, and reports them as weak associations", "Optional, defaults to false"});
        return pluginCommand;
    }

    public void loadCatalog() {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Finding weak associations");
        try (TaskRunner taskRunner = TaskRunners.getTaskRunner((String)"loadWeakAssociations", (int)1);){
            taskRunner.add(new TaskDefinition("retrieveWeakAssociations", () -> {
                Config config = this.getAdditionalConfiguration();
                boolean findWeakAssociations = config.getBooleanValue(OPTION_WEAK_ASSOCIATIONS, false);
                boolean inferExtensionTables = config.getBooleanValue(OPTION_INFER_EXTENSION_TABLES, false);
                if (findWeakAssociations) {
                    this.findWeakAssociations(inferExtensionTables);
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving weak associations, since this was not requested");
                }
            }));
            taskRunner.submit();
            LOGGER.log(Level.INFO, taskRunner.report());
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception retrieving weak association information", (Throwable)e);
        }
    }

    private void findWeakAssociations(boolean inferExtensionTables) {
        Predicate<ProposedWeakAssociation> weakAssociationRule = new IdMatcher().or(new ExtensionTableMatcher(inferExtensionTables));
        Catalog catalog = this.getCatalog();
        ArrayList<Table> allTables = new ArrayList<Table>(catalog.getTables());
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables, weakAssociationRule);
        Collection<ProposedWeakAssociation> proposedWeakAssociations = weakAssociationsAnalyzer.analyzeTables();
        for (ProposedWeakAssociation proposedWeakAssociation : proposedWeakAssociations) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Adding weak association <%s> ", new Object[]{proposedWeakAssociation}));
            Column fkColumn = proposedWeakAssociation.getForeignKeyColumn();
            Column pkColumn = proposedWeakAssociation.getPrimaryKeyColumn();
            WeakAssociationBuilder builder = WeakAssociationBuilder.builder((Catalog)catalog);
            builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
            builder.build();
        }
    }
}

