/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.operation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.BinaryData;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class DataJsonFormatter
implements DataTraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(DataJsonFormatter.class.getName());
    private final OperationOptions options;
    private final JsonGenerator generator;
    private final Operation operation;
    private int dataBlockCount;

    public DataJsonFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) {
        this.options = Objects.requireNonNull(options, "Operation options not provided");
        Objects.requireNonNull(outputOptions, "Output options not provided");
        this.operation = Objects.requireNonNull(operation, "No operation provided");
        try {
            PrintWriter out = outputOptions.openNewOutputWriter(false);
            JsonFactory factory = new JsonFactory();
            this.generator = factory.createGenerator((Writer)out);
            this.generator.useDefaultPrettyPrinter();
            LOGGER.log(Level.CONFIG, this.generator.version().toFullString());
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not create JSON formatter", e);
        }
    }

    public void begin() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not write JSON object", e);
        }
    }

    public void end() {
        try {
            this.generator.writeEndObject();
            this.generator.flush();
            this.generator.close();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not close JSON object", e);
        }
    }

    @Override
    public void handleData(Query query, ResultSet rows) {
        String title;
        this.writeStartDataBlock();
        if (query != null) {
            title = query.getName();
            if (!Utility.isBlank((CharSequence)title)) {
                try {
                    this.generator.writeStringField("query", title);
                }
                catch (IOException e) {
                    throw new IORuntimeException("Could not write query name <%s>".formatted(title), e);
                }
            }
        } else {
            title = "";
        }
        this.handleData(title, rows);
        this.writeEndDataBlock();
    }

    @Override
    public void handleData(Table table, ResultSet rows) {
        String tableName;
        this.writeStartDataBlock();
        if (table != null) {
            tableName = table.getName();
            try {
                String tableType = Utility.toSnakeCase((String)table.getTableType().toString());
                this.generator.writeStringField(tableType, tableName);
                this.generator.writeStringField("schema", table.getSchema().getFullName());
            }
            catch (IOException e) {
                throw new IORuntimeException("Could not write table name <%s>".formatted(tableName), e);
            }
        } else {
            tableName = "";
        }
        this.handleData(tableName, rows);
        this.writeEndDataBlock();
    }

    public void handleHeader(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        try {
            this.generator.writeStringField("db", crawlInfo.getDatabaseVersion().getProductName());
            this.generator.writeStringField("operation", this.operation.toString());
            this.generator.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not write database information", e);
        }
    }

    public void handleHeaderEnd() {
    }

    public void handleHeaderStart() {
    }

    private void handleData(String tableName, ResultSet rows) {
        if (rows == null) {
            return;
        }
        if (this.operation == OperationType.count) {
            this.handleTableAggregate(tableName, rows);
        } else {
            this.handleTableData(tableName, rows);
        }
    }

    private void handleTableAggregate(String title, ResultSet results) {
        long aggregate = 0L;
        try {
            aggregate = DatabaseUtility.readResultsForLong((String)title, (ResultSet)results);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not obtain aggregate data for <%s>", new Object[]{title}));
            aggregate = 0L;
        }
        try {
            this.generator.writeNumberField(this.operation.getName(), aggregate);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could notcount for table".formatted(title), e);
        }
    }

    private void handleTableData(String title, ResultSet rows) {
        try {
            String name = "Data for %s for <%s>".formatted(this.operation, title);
            RetrievalCounts retrievalCounts = new RetrievalCounts(name.toLowerCase());
            this.generator.writeFieldName("data");
            this.generator.writeStartArray();
            try (MetadataResultSet dataRows = new MetadataResultSet(rows, name);){
                dataRows.setShowLobs(this.options.isShowLobs());
                dataRows.setMaxRows(this.options.getMaxRows());
                while (dataRows.next()) {
                    retrievalCounts.count();
                    this.generator.writeStartObject();
                    String[] columnNames = dataRows.getColumnNames();
                    List currentRow = dataRows.row();
                    for (int i = 0; i < columnNames.length; ++i) {
                        Object element = currentRow.get(i);
                        String elementData = element == null ? null : (element instanceof BinaryData ? "<BINARY DATA>" : element.toString());
                        this.generator.writeStringField(columnNames[i], elementData);
                    }
                    this.generator.writeEndObject();
                    retrievalCounts.countIncluded();
                }
            }
            catch (SQLException e) {
                throw new DatabaseAccessException("Could not handle rows for <%s>".formatted(title), e);
            }
            this.generator.writeEndArray();
            retrievalCounts.log();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not write data in JSON format for <%s>".formatted(title), e);
        }
    }

    private void writeEndDataBlock() {
        try {
            this.generator.writeEndObject();
            this.generator.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not write end of data block", e);
        }
    }

    private void writeStartDataBlock() {
        try {
            this.generator.writeFieldId((long)this.dataBlockCount);
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not write start of data block", e);
        }
        ++this.dataBlockCount;
    }
}

