\name{TileImageFilter}
\alias{TileImageFilter}
\title{TileImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Tile multiple input images into a single output image.
TileImageFilter}
\details{
This filter will tile multiple images using a user-specified layout.
The tile sizes will be large enough to accommodate the largest image
for each tile. The layout is specified with the SetLayout method. The
layout has the same dimension as the output image. If all entries of
the layout are positive, the tiled output will contain the exact
number of tiles. If the layout contains a 0 in the last dimension, the
filter will compute a size that will accommodate all of the images.
Empty tiles are filled with the value specified with the SetDefault
value method. The input images must have a dimension less than or
equal to the output image. The output image have a larger dimension
than the input images. This filter can be used to create a volume from
a series of inputs by specifying a layout of 1,1,0.
See:
Tile for the procedural interface
TileImageFilter}
%C++ includes: sitkTileImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{double GetDefaultPixelValue() const:}{
Get the pixel value for locations that are not covered by an input
image.
}
\item{std::vector< uint32_t > GetLayout() const:}{
Set/Get the layout of the tiles. If the last Layout value is 0, the
filter will compute a value that will accommodate all of the images.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetDefaultPixelValue(double DefaultPixelValue):}{
Set the pixel value for locations that are not covered by an input
image. The default default pixel value is Zero.
}
\item{Self SetLayout(std::vector< uint32_t > Layout):}{
Set/Get the layout of the tiles. If the last Layout value is 0, the
filter will compute a value that will accommodate all of the images.
}
\item{ TileImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~TileImageFilter():}{
Destructor
}
}
}
