#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-BjpJDAEgMhvEcM9AC9fCwj
key:                  postgrest-10.0.0-BjpJDAEgMhvEcM9AC9fCwj
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  46c3764dac7749f1b154faa1204c5d92
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-BjpJDAEgMhvEcM9AC9fCwj
depends:
    HTTP-4000.4.1-GRo9vicF7H85D4W05vEDv7
    Ranged-sets-0.5.0-5n0OoXxRuViJsdwNVYREZF
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    auto-update-0.1.6-CjicGngnkTtEVu1imEZjmc base-4.17.2.1
    base64-bytestring-1.2.1.0-629Bo7Gc9ZF7jdkMFmzdCw
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-42k9iOSknrb4MqDPwxdyM4
    cassava-0.5.4.1-KKeL9yVfo9NHFOITYuc2Bq
    configurator-pg-0.2.10-2f1fbPtlCeOD6zRWv1FnGC containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-GbPNlhnvfo4KNBijysVCJo
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-Ip1G9zTwULvwstTwoycgj
    hasql-dynamic-statements-0.3.1.1-8oARYXaZjepJSBYstv7tx7
    hasql-notifications-0.2.0.5-Hu4VShjE8qO7KYZ702KOyg
    hasql-pool-0.5.2.2-3CrsnocMCttFTQMn2Yn08f
    hasql-transaction-1.0.1.1-5jQq4kD2AIWCVOPJpFZlEX
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-7VKWb71irDD4uKtGM0MrBb
    insert-ordered-containers-0.2.5.3-9twNBYDXNdVDv9P6OjMvW9
    interpolatedstring-perl6-1.0.2-FipvMnrzOZ9FdIIajvP1UP
    jose-0.10-GjfVXa7P4lk22jA7GnIDs3 lens-5.3.3-JbVUFNwOeNUGLciYleU4If
    lens-aeson-1.2.3-FpobKMxwnxeHGqlI7m94Fb mtl-2.2.2
    network-3.1.4.0-IC0hdE8eZqJ6PeeNglfLy3
    network-uri-2.6.4.2-KsTvmsDtlUpEkltGNZvqUJ
    optparse-applicative-0.18.1.0-I864cMO0U1ABRAZwcl7eB7
    parsec-3.1.16.1 protolude-0.3.5-Bfbedwg4Q9PJOpmlocLJ8e
    regex-tdfa-1.3.2.5-3jfIfS23fhoC4PyiafLhmq
    retry-0.9.3.1-JhLaoriJkSW2U2hh9fHqg5
    scientific-0.3.8.0-9gOL1qaAy2CzOZP0iULD0
    swagger2-2.8.10-EUUZUaxI07DLI8WIARrZLH text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    vault-0.3.1.5-FsLyr8iXdCq5LXKu2XbHsM
    vector-0.13.2.0-JUxTFkVHiOCDvdzFqkdqvm
    wai-3.2.4-9UOcSkHEAzRImuC2gWdKbJ
    wai-cors-0.2.7-CTrIkgypWRxCLdb2PwMaQW
    wai-extra-3.1.18-IyZc7VwwIQRd2Hz2VWBa4
    wai-logger-2.5.0-A8ZG2W7nNmS4hWPcuYBdAO
    warp-3.4.0-ElI89jnrDVYITHcf4bOOtL

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

